/**
  Copyright (c) 2010 - 2013 Freescale Semiconductor
  Freescale Confidential Proprietary
  \file      szk_ff_tpm.c
  \brief     Low power management entry routines.
  \author    Freescale Semiconductor
  \author    SASD Automotive     
  \author    R11515 
  \version    
  \date     	
  * History:
  
*/
#include <hidef.h>
#include "derivative.h"
#include "main.h"
#include "szk_ff_tpm.h"
/*
 ******************************************************************************
 * vfnConfigureTPMWait
 ******************************************************************************
 */
void vfnConfigureTPMWait(UINT8 u8Interval280usec)
{
  /* Divide counter by 4 to have an effective 62.5.kHz clock coming into TPM */
  /* Ensure there's no timer interrupts.                                     */
  TPM1SC = (UINT8)TPM1SC_PS1_MASK;
  
  /* Make the Modulo 250 so that it triggers every 0.5 Sec */
  /* The explicit cast to word is to make MISRA happy - TPM1MOD is declared  */
  /* as word in the header file                                              */
  TPM1MOD = (word)((UINT16)250u * (UINT16)u8Interval280usec);
  
  /* Clear the last count */
  (void)TPM1CNTL;

  
  return;
}
/*
 ******************************************************************************
 * vfnWaitMSec
 ******************************************************************************
 */
void vfnWaitMSec(UINT8 u8MSec)
{
  /* Divide counter by 16 to have an effective 250kHz clock coming into TPM */
  TPM1SC_PS = ((UINT8)TPM1SC_PS2_MASK);
  
  /* Make the Modulo 250 so that it triggers every MSec */
  /* The explicit cast to word is to make MISRA happy - TPM1MOD is declared */
  /* as word in the header file                                             */
  TPM1MOD = (word)((UINT16)250u * (UINT16)u8MSec);
  
  /* Clear the last count */
  (void)TPM1CNTL;

  /* Ensure no interrupts */
  TPM1SC_TOIE = CLEAR;

  /* Trigger by connecting the clock to the module */
  TPM1SC_CLKSA = SET;
  
  while((UINT8)CLEAR == TPM1SC_TOF)
  {
    /* Wait */
  }
  
  /* Remove the clock source */
  TPM1SC = CLEAR;
  
  return;
}
/*
 ******************************************************************************
 *
 *  End of file.
 *
 ******************************************************************************
 */