/*
  Copyright (c) 2006 - 2014 Freescale Semiconductor
  
  \file       "szk_firm_user_interrupt.c"
  \brief    	User interrupt routines.
  \author   	Freescale Semiconductor

  * History: \n  
  * 060312 - User version
  * 090501 - Commented for Suzuka 
*/
#include "derivative.h"
#include "main.h" /* Reference to FrameID */

/* SWI Interrupt */
void interrupt USER_1_INTERRUPT(void)
{
}

/* RESERVED - Don't use */
void interrupt USER_2_INTERRUPT(void)
{
}

/* LVD Interrupt */
void interrupt USER_3_INTERRUPT(void)
{
}

/* PWU Interrupt */
void interrupt USER_4_INTERRUPT(void)
{
  /* Clear all PWU Interrupt flags */
  PWUCS0_WUFACK = SET;
  PWUCS1_PRFACK = SET;
  FrameID ++;
  __asm PULH;
  __asm RTI;  
}

/* TPM1CH0 Interrupt */
void interrupt USER_5_INTERRUPT(void)
{
}

/* TPM1CH1 Interrupt */
void interrupt USER_6_INTERRUPT(void)
{
}

/* TPM1 Interrupt */
void interrupt USER_7_INTERRUPT(void)
{
}

/* SMI Interrupt - Don't use */
void interrupt USER_8_INTERRUPT(void)
{
}

/* RFM Interrupt */
void interrupt USER_9_INTERRUPT(void)
{
  RFCR7_RFIACK = SET;
  FrameID++;
  __asm PULH;
  __asm RTI;
}

/* ADC Interrupt - Don't use */
void interrupt USER_10_INTERRUPT(void)
{ 
}

/* LFR Interrupt */
void interrupt USER_11_INTERRUPT(void)
{
  LFS_LFIACK = SET;
  __asm PULH;
  __asm RTI;
}

/* RTI Interrupt */
void interrupt USER_12_INTERRUPT(void)
{   
}

/* RESERVED - Don't use */
void interrupt USER_13_INTERRUPT(void)
{
}

/* RESERVED - Don't use */
void interrupt USER_14_INTERRUPT(void)
{
}

/* KBI Interrupt */
void interrupt USER_15_INTERRUPT(void)
{
}

void(* const USER_INTERRUPT_TABLE[])() @ 0xDFE0 =
{
  USER_15_INTERRUPT,
  USER_14_INTERRUPT,
  USER_13_INTERRUPT,
  USER_12_INTERRUPT,
  USER_11_INTERRUPT,
  USER_10_INTERRUPT,
  USER_9_INTERRUPT,
  USER_8_INTERRUPT,
  USER_7_INTERRUPT,
  USER_6_INTERRUPT,
  USER_5_INTERRUPT,
  USER_4_INTERRUPT,
  USER_3_INTERRUPT,
  USER_2_INTERRUPT,
  USER_1_INTERRUPT,
  main
};
/*
******************************************************************************
*
* End of file.
*
******************************************************************************
*/
