/******************************************************************************
* 
* Copyright (c) 2012 Freescale Semiconductor;
* All Rights Reserved                       
*
******************************************************************************* 
*
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
* THE POSSIBILITY OF SUCH DAMAGE.
*
***************************************************************************//*!
*
* @file      pclib.h
*
* @author    B37570
* 
* @version   1.0.00.0
* 
* @date      September-2-2013
* 
* @brief     PCLIB include file
*
*******************************************************************************
*
* Functions that are included in PCLIB.
*
******************************************************************************/

#ifndef PCLIB_H_
#define PCLIB_H_

#include "56800E_types.h"

#include "PCLIB_Controller2P2ZAsm.h"
#include "PCLIB_Controller3P3ZAsm.h"
#include "PCLIB_ControllerPIandLPfilterAsm.h"
#include "PCLIB_ControllerPIAsm.h"
#include "PCLIB_ControllerPIDAsm.h"

/* Redeclaration of PClib functions */
#define PCLIB_Controller2P2Z(f16Error, pudtControlStruct) \
	PCLIB_Controller2P2ZAsm(f16Error, pudtControlStruct)
#define PCLIB_Controller3P3Z(f16Error, pudtControlStruct)		\
        PCLIB_Controller3P3ZAsm(f16Error, pudtControlStruct)
#define PCLIB_ControllerPIANDLPFILTER(f16Error, pudtControlStruct)		\
        PCLIB_ControllerPIANDLPFILTERAsm(f16Error, pudtControlStruct)
#define PCLIB_ControllerPI(f16Error, pudtControlSturct)		\
		PCLIB_ControllerPIAsm(f16Error, pudtControlSturct)
#define PCLIB_ControllerPID(f16Error, pudtControlStruct)	     \
    	PCLIB_ControllerPIDAsm(f16Error, pudtControlStruct)

#endif /* PCLIB_H_ */
