/** ###################################################################
**     THIS COMPONENT MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename    : PE_LDD.h
**     Project     : ramISR
**     Processor   : MC56F82748VLH
**     Version     : Component 01.055, Driver 01.00, CPU db: 3.50.001
**     Compiler    : CodeWarrior DSP C Compiler
**     Date/Time   : 2015-03-20, 21:55, # CodeGen: 115
**     Abstract    :
**
**     Settings    :
**
**
**     Copyright : 1997 - 2014 Freescale Semiconductor, Inc. 
**     All Rights Reserved.
**     
**     Redistribution and use in source and binary forms, with or without modification,
**     are permitted provided that the following conditions are met:
**     
**     o Redistributions of source code must retain the above copyright notice, this list
**       of conditions and the following disclaimer.
**     
**     o Redistributions in binary form must reproduce the above copyright notice, this
**       list of conditions and the following disclaimer in the documentation and/or
**       other materials provided with the distribution.
**     
**     o Neither the name of Freescale Semiconductor, Inc. nor the names of its
**       contributors may be used to endorse or promote products derived from this
**       software without specific prior written permission.
**     
**     THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
**     ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
**     WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
**     DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
**     ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
**     (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
**     LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
**     ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
**     (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
**     SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**     
**     http: www.freescale.com
**     mail: support@freescale.com
** ###################################################################*/
/*!
** @file PE_LDD.h                                                  
** @version 01.00
** @brief
**
*/         
/*!
**  @addtogroup PE_LDD_module PE_LDD module documentation
**  @{
*/         
#ifndef __PE_LDD_H
#define __PE_LDD_H

/* MODULE PE_LDD. */

#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"

/*! Logical Device Driver API version */
#define PE_LDD_VERSION                           0x0100U

/* LDD driver states */
#define PE_LDD_DRIVER_DISABLED_IN_CLOCK_CONFIGURATION 0x01U /*!< LDD driver is disabled in the selected clock configuration */
#define PE_LDD_DRIVER_DISABLED_BY_USER           0x02U /*!< LDD driver is disabled by the user */
#define PE_LDD_DRIVER_BUSY                       0x04U /*!< LDD driver is busy */

/*! Macro to register component device structure */
#define PE_LDD_RegisterDeviceStructure(ComponentIndex, DeviceStructure) (PE_LDD_DeviceDataList[ComponentIndex] = DeviceStructure)

/*! Macro to unregister component device structure */
#define PE_LDD_UnregisterDeviceStructure(ComponentIndex) (PE_LDD_DeviceDataList[ComponentIndex] = NULL)

/*! Macro to get the component device structure */
#define PE_LDD_GetDeviceStructure(ComponentIndex) (PE_LDD_DeviceDataList[ComponentIndex])

/*
** ===========================================================================
** LDD component ID specifying the component instance in the project. This ID
** is used internally as an index to the array of LDD device structures.
** ===========================================================================
*/
#define PE_LDD_COMPONENT_TU1_ID                  0x00U
#define PE_LDD_COMPONENT_BitIoLdd1_ID            0x01U

/*
** ===================================================================
** Global HAL types and constants
** ===================================================================
*/
typedef uint32_t LDD_TPinMask;         /*!< Pin mask type. */
typedef uint16_t LDD_TError;           /*!< Error type. */
typedef uint32_t LDD_TEventMask;       /*!< Event mask type. */
typedef uint8_t LDD_TClockConfiguration; /*!< CPU clock configuration type. */
typedef void LDD_TDeviceData;          /*!< Pointer to private device structure managed and used by HAL components. */
typedef void* LDD_TDeviceDataPtr;      /*!< Obsolete type for backward compatibility. */
typedef void LDD_TData;                /*!< General pointer to data. */
typedef void LDD_TUserData;            /*!< Pointer to this type specifies the user or RTOS specific data will be passed as an event or callback parameter. */

/*! Driver operation mode type. */
typedef enum {
  DOM_NONE,
  DOM_RUN,
  DOM_WAIT,
  DOM_SLEEP,
  DOM_STOP
} LDD_TDriverOperationMode;

typedef uint16_t LDD_TDriverState;     /*!< Driver state type. */
typedef void LDD_TCallbackParam;       /*!< Pointer to this type specifies the user data to be passed as a callback parameter. */
typedef void (* LDD_TCallback)(LDD_TCallbackParam *CallbackParam); /*!< Callback type used for definition of callback functions. */

/*! FlexRAM operation mode. */
typedef enum {
  LDD_FlexRAM_AS_RAM,                  /*!< FlexRAM area as traditional RAM operation. */ 
  LDD_FlexRAM_AS_EEPROM                /*!< FlexRAM area as EEPROM operations. */
} LDD_TFlexRAMFunction;

typedef uint8_t LDD_TBackDoorKey;      /*!< Backdoor key type. */

extern LDD_TDeviceData *PE_LDD_DeviceDataList[]; /*!< Array of LDD component device structures */


/*
** ===================================================================
** RTOS specific types and constants
** ===================================================================
*/
/* {Default RTOS Adapter} RTOS specific definition of type of Ioctl() command constants */


/*
** ===================================================================
** Published RTOS settings and constants
** ===================================================================
*/
/* {Default RTOS Adapter} No published RTOS settings */


/*
** ===================================================================
** TimerUnit device types and constants
** ===================================================================
*/
#define LDD_TIMERUNIT_ON_CHANNEL_0           0x01u /* OnChannel0 event mask value */
#define LDD_TIMERUNIT_ON_CHANNEL_1           0x02u /* OnChannel1 event mask value */
#define LDD_TIMERUNIT_ON_CHANNEL_2           0x04u /* OnChannel2 event mask value */
#define LDD_TIMERUNIT_ON_CHANNEL_3           0x08u /* OnChannel3 event mask value */
#define LDD_TIMERUNIT_ON_CHANNEL_4           0x10u /* OnChannel4 event mask value */
#define LDD_TIMERUNIT_ON_CHANNEL_5           0x20u /* OnChannel5 event mask value */
#define LDD_TIMERUNIT_ON_CHANNEL_6           0x40u /* OnChannel6 event mask value */
#define LDD_TIMERUNIT_ON_CHANNEL_7           0x80u /* OnChannel7 event mask value */
#define LDD_TIMERUNIT_ON_COUNTER_RESTART     0x0100u /* OnCounterRestart event mask value */

typedef enum {                         /* Direction of counting */
  DIR_UP,
  DIR_DOWN
} LDD_TimerUnit_TCounterDirection;

typedef enum                          { /* Output action type (flip-flop action on overrun or compare match) */
  OUTPUT_NONE,
  OUTPUT_TOGGLE,
  OUTPUT_CLEAR,
  OUTPUT_SET
} LDD_TimerUnit_TOutAction;

typedef enum  {                        /* Input edge type */
  EDGE_NONE,
  EDGE_RISING,
  EDGE_FALLING,
  EDGE_BOTH
} LDD_TimerUnit_TEdge;

typedef float LDD_TimerUnit_Tfloat;    /* Float type */

/*
** ===================================================================
** Capture types and constants
** ===================================================================
*/
#define LDD_CAPTURE_ON_CAPTURE         0x01u /* OnCapture event mask value */
#define LDD_CAPTURE_ON_OVERRUN         0x02u /* OnOverrun event mask value */

/*
** ===================================================================
** TimerInt types and constants
** ===================================================================
*/
#define LDD_TIMERINT_ON_INTERRUPT      0x01u /* OnInterrupt event mask value */

/*
** ===================================================================
** TimerOut types and constants
** ===================================================================
*/
#define LDD_TIMEROUT_ON_INTERRUPT      0x01u /* OnInterrupt event mask value */

/*
** ===================================================================
** EventCntr types and constants
** ===================================================================
*/
#define LDD_EVENTCNTR_ON_END           0x01u /* OnEnd event mask value */

/*
** ===================================================================
** FreeCntr types and constants
** ===================================================================
*/
#define LDD_FREECNTR_ON_INTERRUPT      0x01u /* OnInterrupt event mask value */

/*
** ===================================================================
** PPG device types and constants
** ===================================================================
*/
#define LDD_PPG_ON_END                 0x01u /* OnEnd event mask value */

typedef float LDD_PPG_Tfloat;          /* Float type */

/*
** ===================================================================
** PWM types and constants
** ===================================================================
*/
#define LDD_PWM_ON_END                 0x01u /* OnEnd event mask value */

/*
** ===================================================================
** PulseAccumulator types and constants
** ===================================================================
*/
#define LDD_PULSEACCUMULATOR_ON_OVERRUN     0x01u /* OnOverrun event mask value */
#define LDD_PULSEACCUMULATOR_ON_END         0x02u /* OnEnd event mask value */
#define LDD_PULSEACCUMULATOR_ON_COMPARE1    0x04u /* OnCompare1 event mask value */
#define LDD_PULSEACCUMULATOR_ON_COMPARE2    0x08u /* OnCompare2 event mask value */
#define LDD_PULSEACCUMULATOR_ON_EDGE        0x10u /* OnEdge event mask value */

/*
** ===================================================================
** PulseStream types and constants
** ===================================================================
*/
#define LDD_PULSESTREAM_ON_END         0x01u /* OnEnd event mask value */

typedef float LDD_PS_Tfloat;           /* Float type */

/*
** ===================================================================
** RealTime types and constants
** ===================================================================
*/

typedef float LDD_RealTime_Tfloat;     /* Float type */

/*
** ===================================================================
** TimeDate types and constants
** ===================================================================
*/
#define LDD_TIMEDATE_ON_ALARM         0x01u /* OnAlarm event mask value */
#define LDD_TIMEDATE_ON_SECOND        0x02u /* OnSecond event mask value */

typedef struct {                       /* Time struct */
  uint16_t Hour;                       /* Hours (0 - 23) */
  uint16_t Min;                        /* Minutes (0 - 59) */
  uint16_t Sec;                        /* Seconds (0 - 59) */
  uint16_t Sec100;                     /* Hundredths of seconds (0 - 99) */
} LDD_TimeDate_TTimeRec;

typedef struct {                       /* Date struct */
  uint16_t Year;                       /* Years (1998 - 2099) */
  uint16_t Month;                      /* Months (1 - 12) */
  uint16_t Day;                        /* Days (1 - 31) */
  uint16_t DayOfWeek;                  /* Day of week (0-Sunday, .. 6-Saturday)  */
} LDD_TimeDate_TDateRec;

/*
** ===================================================================
** CRC device types and constants
** ===================================================================
*/

#define LDD_CRC_16_SEED_LOW 0x00U      /* CRC 16bit seed low */
#define LDD_CRC_16_POLY_LOW 0x8005U    /* CRC 16bit poly low */
#define LDD_CRC_32_SEED_LOW 0xFFFFU    /* CRC 32bit seed low */
#define LDD_CRC_32_SEED_HIGH 0xFFFFU   /* CRC 32bit seed high */
#define LDD_CRC_32_POLY_LOW 0x1DB7U    /* CRC 32bit poly low */
#define LDD_CRC_32_POLY_HIGH 0x04C1U   /* CRC 32bit poly high */
#define LDD_CRC_CCITT_SEED_LOW 0xFFFFU /* CRC CCITT seed low */
#define LDD_CRC_CCITT_POLY_LOW 0x1021U /* CRC CCITT poly low */
#define LDD_CRC_MODBUS_16_SEED_LOW 0xFFFFU /* CRC MODBUS16 seed low */
#define LDD_CRC_MODBUS_16_POLY_LOW 0x8005U /* CRC MODBUS16 poly low */
#define LDD_CRC_KERMIT_SEED_LOW 0x00U  /* CRC KERMIT seed low */
#define LDD_CRC_KERMIT_POLY_LOW 0x1021U /* CRC KERMIT poly low */
#define LDD_CRC_DNP_SEED_LOW 0x00U     /* CRC DNP seed low */
#define LDD_CRC_DNP_POLY_LOW 0x3D65U   /* CRC DNP poly low */

typedef enum  {                        /* Transpose type */
  LDD_CRC_NO_TRANSPOSE = 0,
  LDD_CRC_BITS = 1,
  LDD_CRC_BITS_AND_BYTES = 2,
  LDD_CRC_BYTES = 3
} LDD_CRC_TTransposeType;

typedef enum  {                        /* CRC standard  */
  LDD_CRC_16,
  LDD_CRC_CCITT,
  LDD_CRC_MODBUS_16,
  LDD_CRC_KERMIT,
  LDD_CRC_DNP,
  LDD_CRC_32,
  LDD_CRC_USER
} LDD_CRC_TCRCStandard;

typedef struct  {                      /* User CRC standard  */
  bool Width32bit;                     /* 32bir CRC? */
  bool ResultXORed;                    /* Result XORed? */
  uint16_t SeedLow;                    /* Seed low value */
  uint16_t SeedHigh;                   /* Seed high value */
  uint16_t PolyLow;                    /* Poly low value */
  uint16_t PolyHigh;                   /* Poly high value */
  LDD_CRC_TTransposeType InputTransposeMode; /* Input transpose type */
  LDD_CRC_TTransposeType OutputTransposeMode; /* Output transpose type */
} LDD_CRC_TUserCRCStandard;

/*
** ===================================================================
** HSCMP device types and constants
** ===================================================================
*/

#define LDD_ANALOGCOMP_ON_COMPARE 0x01U /* OnCompare event mask */

/* Positive input pin masks */
#define LDD_ANALOGCOMP_POSITIVE_INPUT_0_MASK 0x01UL
#define LDD_ANALOGCOMP_POSITIVE_INPUT_1_MASK 0x02UL
#define LDD_ANALOGCOMP_POSITIVE_INPUT_2_MASK 0x04UL
#define LDD_ANALOGCOMP_POSITIVE_INPUT_3_MASK 0x08UL
#define LDD_ANALOGCOMP_POSITIVE_INPUT_4_MASK 0x10UL
#define LDD_ANALOGCOMP_POSITIVE_INPUT_5_MASK 0x20UL
#define LDD_ANALOGCOMP_POSITIVE_INPUT_6_MASK 0x40UL
#define LDD_ANALOGCOMP_POSITIVE_INPUT_7_MASK 0x80UL

/* Negative input pin masks */
#define LDD_ANALOGCOMP_NEGATIVE_INPUT_0_MASK 0x0100UL
#define LDD_ANALOGCOMP_NEGATIVE_INPUT_1_MASK 0x0200UL
#define LDD_ANALOGCOMP_NEGATIVE_INPUT_2_MASK 0x0400UL
#define LDD_ANALOGCOMP_NEGATIVE_INPUT_3_MASK 0x0800UL
#define LDD_ANALOGCOMP_NEGATIVE_INPUT_4_MASK 0x1000UL
#define LDD_ANALOGCOMP_NEGATIVE_INPUT_5_MASK 0x2000UL
#define LDD_ANALOGCOMP_NEGATIVE_INPUT_6_MASK 0x4000UL
#define LDD_ANALOGCOMP_NEGATIVE_INPUT_7_MASK 0x8000UL

/* Output pin masks */
#define LDD_ANALOGCOMP_OUTPUT_PIN_MASK 0x00010000UL

/* Window Sample pin masks */
#define LDD_ANALOGCOMP_WINDOWSAMPLE_PIN_MASK 0x00020000UL

typedef enum {
  LDD_ANALOGCOMP_INPUT_0 = 0x00U,
  LDD_ANALOGCOMP_INPUT_1 = 0x01U,
  LDD_ANALOGCOMP_INPUT_2 = 0x02U,
  LDD_ANALOGCOMP_INPUT_3 = 0x03U,
  LDD_ANALOGCOMP_INPUT_4 = 0x04U,
  LDD_ANALOGCOMP_INPUT_5 = 0x05U,
  LDD_ANALOGCOMP_INPUT_6 = 0x06U,
  LDD_ANALOGCOMP_INPUT_7 = 0x07U,
  LDD_ANALOGCOMP_INPUT_DISABLED = 0x08U
} LDD_AnalogComp_TComparatorInput;     /* Type specifying comparator input number */

typedef enum {
  LDD_ANALOGCOMP_NO_EDGE = 0x00U,
  LDD_ANALOGCOMP_FALLING_EDGE = 0x02U,
  LDD_ANALOGCOMP_RISING_EDGE = 0x04U,
  LDD_ANALOGCOMP_BOTH_EDGES = 0x06U
} LDD_AnalogComp_TCompareStatus;       /* Type specifying current comparator output status */

typedef enum {
  LDD_ANALOGCOMP_RISING_EDGE_MODE = 0x10U,
  LDD_ANALOGCOMP_FALLING_EDGE_MODE = 0x08U,
  LDD_ANALOGCOMP_BOTH_EDGES_MODE = 0x18U
} LDD_AnalogComp_TComparatorMode;      /* Type specifying requested comparator mode */

typedef uint8_t LDD_AnalogComp_TOutputValue; /* Type specifying comparator output value */

/*
** ===================================================================
** UART device types and constants
** ===================================================================
*/
#define LDD_SERIAL_RX_PIN                      0x01U /* Receiver pin mask */
#define LDD_SERIAL_TX_PIN                      0x02U /* Transmitter pin mask */
#define LDD_SERIAL_CTS_PIN                     0x04U /* CTS pin mask */
#define LDD_SERIAL_RTS_PIN                     0x08U /* RTS pin mask */

#define LDD_SERIAL_ON_BLOCK_RECEIVED           0x01U /* OnBlockReceived event mask */
#define LDD_SERIAL_ON_BLOCK_SENT               0x02U /* OnBlockSent event mask */
#define LDD_SERIAL_ON_BREAK                    0x04U /* OnBreak event mask */
#define LDD_SERIAL_ON_TXCOMPLETE               0x08U /* OnTxComplete event mask */
#define LDD_SERIAL_ON_ERROR                    0x10U /* OnError event mask */

#define LDD_SERIAL_RX_OVERRUN                  0x01U /* Receiver overrun */
#define LDD_SERIAL_PARITY_ERROR                0x02U /* Parity error */
#define LDD_SERIAL_FRAMING_ERROR               0x04U /* Framing error */
#define LDD_SERIAL_NOISE_ERROR                 0x08U /* Noise error */

typedef uint32_t LDD_SERIAL_TError;    /* Serial communication error type */

typedef uint8_t LDD_SERIAL_TDataWidth; /* Bit length type. The number of bits transmitted by one character. */

typedef uint16_t LDD_SERIAL_TSize;     /* Type specifying the length of the data or buffer. */

typedef uint8_t LDD_SERIAL_TBaudMode;  /* Type specifying the baud mode. */

typedef enum {                         /* Type specifying the parity. */
  LDD_SERIAL_PARITY_UNDEF,
  LDD_SERIAL_PARITY_NONE,
  LDD_SERIAL_PARITY_ODD,
  LDD_SERIAL_PARITY_EVEN,
  LDD_SERIAL_PARITY_MARK,
  LDD_SERIAL_PARITY_SPACE
} LDD_SERIAL_TParity;

typedef enum {                         /* Type specifying the stop bit length. */
  LDD_SERIAL_STOP_BIT_LEN_UNDEF,
  LDD_SERIAL_STOP_BIT_LEN_1,
  LDD_SERIAL_STOP_BIT_LEN_1_5,
  LDD_SERIAL_STOP_BIT_LEN_2
} LDD_SERIAL_TStopBitLen;

typedef struct {                       /* Communication statistics */
  uint32_t ReceivedChars;              /* Number of received characters */
  uint32_t SentChars;                  /* Number of transmitted characters */
  uint32_t ReceivedBreaks;             /* Number of received break characters */
  uint32_t ParityErrors;               /* Number of receiver parity errors */
  uint32_t FramingErrors;              /* Number of receiver framing errors */
  uint32_t OverrunErrors;              /* Number of receiver overrun errors */
  uint32_t NoiseErrors;                /* Number of receiver noise errors */
} LDD_SERIAL_TStats;

typedef enum {                         /* Type specifying the loop mode operation. */
  LOOPMODE_UNDEF,
  LOOPMODE_NORMAL,
  LOOPMODE_AUTO_ECHO,
  LOOPMODE_LOCAL_LOOPBACK,
  LOOPMODE_REMOTE_LOOPBACK
} LDD_SERIAL_TLoopMode;

/*
** ===================================================================
** I2C device types and constants
** ===================================================================
*/
#define LDD_I2C_SDA_PIN                        0x01U /* SDA pin mask */
#define LDD_I2C_SCL_PIN                        0x02U /* SCL pin  mask */

#define LDD_I2C_ON_MASTER_BLOCK_SENT           0x0001U /*  OnMasterBlockSent event mask */
#define LDD_I2C_ON_MASTER_BLOCK_RECEIVED       0x0002U /*  OnMasterBlockReceived event mask */
#define LDD_I2C_ON_SLAVE_BLOCK_SENT            0x0004U /*  OnSlaveBlockSent event mask */
#define LDD_I2C_ON_SLAVE_BLOCK_RECEIVED        0x0008U /*  OnSlaveBlockReceived event mask */
#define LDD_I2C_ON_SLAVE_TX_REQUEST            0x0010U /*  OnSlaveTxRequest event mask */
#define LDD_I2C_ON_SLAVE_RX_REQUEST            0x0020U /*  OnSlaveRxRequest event mask */
#define LDD_I2C_ON_ERROR                       0x0040U /*  OnError event mask */
#define LDD_I2C_ON_SLAVE_SM_BUS_CALL_ADDR      0x0080U /*  OnSlaveSMBusCallAddr event mask */
#define LDD_I2C_ON_SLAVE_SM_BUS_ALERT_RESPONSE 0x0100U /*  OnSlaveSMBusAlertResponse event mask */
#define LDD_I2C_ON_SLAVE_GENERAL_CALL_ADDR     0x0200U /*  OnSlaveGeneralCallAddr event mask */
#define LDD_I2C_ON_MASTER_BYTE_RECEIVED        0x0400U /*  OnMasterByteReceived event mask */
#define LDD_I2C_ON_SLAVE_BYTE_RECEIVED         0x0800U /*  OnMasterByteReceived event mask */
#define LDD_I2C_ON_BUS_START_DETECTED          0x1000U /*  OnBusStartDetected event mask */
#define LDD_I2C_ON_BUS_STOP_DETECTED           0x2000U /*  OnBusStopDetected event mask */

#define LDD_I2C_SLAVE_TX_UNDERRUN              0x0001U /*  SlaveTxUnderrun error mask */
#define LDD_I2C_SLAVE_RX_OVERRUN               0x0002U /*  SlaveRxOverrun error mask */
#define LDD_I2C_ARBIT_LOST                     0x0004U /*  ArbitLost error mask */
#define LDD_I2C_MASTER_NACK                    0x0008U /*  MasterNACK error mask */
#define LDD_I2C_SCL_LOW_TIMEOUT                0x0010U /*  SCLLowTimeout error mask */
#define LDD_I2C_SDA_LOW_TIMEOUT                0x0020U /*  SDALowTimeout error mask */
#define LDD_I2C_SLAVE_NACK                     0x0040U /*  SlaveNACK error mask */

typedef uint16_t LDD_I2C_TSize;        /* Type specifying the length of the data or buffer. */
typedef uint16_t LDD_I2C_TAddr;        /* Type specifying the address variable */
typedef uint16_t LDD_I2C_TErrorMask;   /* Type specifying the error mask type. */
typedef bool LDD_I2C_TMode;            /* Type specifynng the Actual operating mode */

typedef enum {                         /* Type specifying the address type  */
  LDD_I2C_ADDRTYPE_7BITS,
  LDD_I2C_ADDRTYPE_10BITS,
  LDD_I2C_ADDRTYPE_GENERAL_CALL
} LDD_I2C_TAddrType;

typedef enum {                         /* Type specifying generate the stop condition  */
  LDD_I2C_NO_SEND_STOP,
  LDD_I2C_SEND_STOP
} LDD_I2C_TSendStop;

typedef enum {                         /* Type specifying the I2C state of BUS. */
  LDD_I2C_BUSY,
  LDD_I2C_IDLE
} LDD_I2C_TBusState;

typedef enum {                         /* Type specifying the I2C byte acknowledge response. */
  LDD_I2C_ACK_BYTE,
  LDD_I2C_NACK_BYTE
} LDD_I2C_TAckType;

typedef struct {
  uint32_t MasterSentChars;            /* Number of master transmitted characters. */
  uint32_t MasterReceivedChars;        /* Number of master received characters. */
  uint32_t MasterNacks;                /* Number of no acknowledges. */
  uint32_t ArbitLost;                  /* Number of lost the bus arbitration. */
  uint32_t SlaveSentChars;             /* Number of slave transmitted characters. */
  uint32_t SlaveReceivedChars;         /* Number of slave received characters. */
  uint32_t SlaveTxUnderrun;            /* Number of slave underrun. */
  uint32_t SlaveRxOverrun;             /* Number of slave overrun. */
  uint32_t SlaveGeneralCallAddr;       /* Number of a general call address. */
  uint32_t SlaveSmBusCallAddr;         /* Number of a SMBus call address. */
  uint32_t SlaveSmBusAlertResponse;    /* Number of slave SMBus alert response received. */
  uint32_t SCLLowTimeout;              /* Number of SCL low timeout occur. */
  uint32_t SDALowTimeout;              /* Number of SCL low timeout occur. */
} LDD_I2C_TStats;


/*
** ===================================================================
** SPI device types and constants - SPIMaster_LDD
** ===================================================================
*/
#define LDD_SPIMASTER_INPUT_PIN                      0x01U /* Input pin mask */
#define LDD_SPIMASTER_OUTPUT_PIN                     0x02U /* Output pin mask */
#define LDD_SPIMASTER_CLK_PIN                        0x04U /* Clock pin mask */
#define LDD_SPIMASTER_CS_0_PIN                       0x08U /* Chip select 0 pin mask */
#define LDD_SPIMASTER_CS_1_PIN                       0x10U /* Chip select 1 pin mask */
#define LDD_SPIMASTER_CS_2_PIN                       0x20U /* Chip select 2 pin mask */
#define LDD_SPIMASTER_CS_3_PIN                       0x40U /* Chip select 3 pin mask */
#define LDD_SPIMASTER_CS_4_PIN                       0x80U /* Chip select 4 pin mask */
#define LDD_SPIMASTER_CS_5_PIN                       0x0100U /* Chip select 5 pin mask */
#define LDD_SPIMASTER_CS_6_PIN                       0x0200u /* Chip select 6 pin mask */
#define LDD_SPIMASTER_CS_7_PIN                       0x0400u /* Chip select 7 pin mask */
#define LDD_SPIMASTER_CSS_PIN                        0x0800u /* Chip select strobe pin mask */

#define LDD_SPIMASTER_ON_BLOCK_RECEIVED 0x01U /* OnBlockReceived event mask */
#define LDD_SPIMASTER_ON_BLOCK_SENT     0x02U /* OnBlockSent event mask */
#define LDD_SPIMASTER_ON_ERROR          0x04U /* OnError event mask */

#define LDD_SPIMASTER_RX_OVERFLOW       0x01U /* Receiver overflow */
#define LDD_SPIMASTER_PARITY_ERROR      0x02U /* Parity error */

typedef uint32_t LDD_SPIMASTER_TError; /* Communication error type */

/* Communication statistics */
typedef struct {                       /* Communication statistics */
  uint32_t RxChars;                    /* Number of received characters */
  uint32_t TxChars;                    /* Number of transmitted characters */
  uint32_t RxParityErrors;             /* Number of receiver parity errors, which have occured */  
  uint32_t RxOverruns;                 /* Number of receiver overruns, which have occured */ 
} LDD_SPIMASTER_TStats;

/*
** ===================================================================
** SPI device types and constants - SPISlave_LDD
** ===================================================================
*/
#define LDD_SPISLAVE_INPUT_PIN                      0x01U /* Input pin mask */
#define LDD_SPISLAVE_OUTPUT_PIN                     0x02U /* Output pin mask */
#define LDD_SPISLAVE_CLK_PIN                        0x04U /* Clock pin mask */
#define LDD_SPISLAVE_SS_PIN                         0x08U /* Slave select pin mask */

#define LDD_SPISLAVE_ON_BLOCK_RECEIVED 0x01U /* OnBlockReceived event mask */
#define LDD_SPISLAVE_ON_BLOCK_SENT     0x02U /* OnBlockSent event mask */
#define LDD_SPISLAVE_ON_ERROR          0x04U /* OnError event mask */

#define LDD_SPISLAVE_RX_OVERFLOW       0x01U /* Receiver overflow */
#define LDD_SPISLAVE_TX_UNDERFLOW      0x02U /* Transmitter underflow */
#define LDD_SPISLAVE_PARITY_ERROR      0x04U /* Parity error */

typedef uint32_t LDD_SPISLAVE_TError;  /* Communication error type */

/* Communication statistics */
typedef struct {                       /* Communication statistics */
  uint32_t RxChars;                    /* Number of received characters */
  uint32_t TxChars;                    /* Number of transmitted characters */
  uint32_t RxParityErrors;             /* Number of receiver parity errors, which have occured */
  uint32_t RxOverruns;                 /* Number of receiver overruns, which have occured */
  uint32_t TxUnderruns;                /* Number of transmitter underruns, which have occured */  
} LDD_SPISLAVE_TStats;

/*
** ===================================================================
** DAC device types and constants
** ===================================================================
*/
#define LDD_DAC_OUTPUT_PIN_0          0x01u /* DAC output pin 0 mask */
#define LDD_DAC_SYNC_PIN              0x01u /* DAC Sync input pin */

#define LDD_DAC_STATUS_FIFO_EMPTY     0x01U /* FIFO empty status mask */
#define LDD_DAC_STATUS_FIFO_FULL      0x02U /* FIFO full status mask */
#define LDD_DAC_ON_BUFFER_END         0x01U /* OnBufferEnd event mask */
#define LDD_DAC_ON_BUFFER_START       0x02U /* OnBufferStart event mask */
#define LDD_DAC_ON_BUFFER_WATERMARK   0x04U /* OnBufferWatermark event mask */
#define LDD_DAC_ON_COMPLETE           LDD_DMA_ON_COMPLETE /* OnComplete event mask */
#define LDD_DAC_ON_ERROR              LDD_DMA_ON_ERROR /* OnError event mask */

typedef enum {                         /* Type specifying the DAC buffer work mode */
  LDD_DAC_BUFFER_NORMAL_MODE          = 0x00U, /* Normal (cyclic) mode */
  LDD_DAC_BUFFER_SWING_MODE           = 0x01U, /* Swing mode  */
  LDD_DAC_BUFFER_SCAN_MODE            = 0x02U /* One-time scan mode */
} LDD_DAC_TBufferMode;

typedef enum {                         /* Type specifying the DAC buffer watermark levels */
  LDD_DAC_BUFFER_WATERMARK_L0         = 0x00U,
  LDD_DAC_BUFFER_WATERMARK_L2         = 0x01U,
  LDD_DAC_BUFFER_WATERMARK_L4         = 0x02U,
  LDD_DAC_BUFFER_WATERMARK_L6         = 0x03U
} LDD_DAC_TBufferWatermark;

typedef struct {                       /* Specifies waveform's parameters. */
  unsigned int: 3;
  unsigned int AutomaticWaveform : 1;  /* Enables automatic waveform generation */
  unsigned int DownCounting : 1;       /* Enables down counting */
  unsigned int UpConting : 1;          /* Enables up counting */
} LDD_DAC_TWaveformSettings;

typedef void* LDD_DAC_TDataPtr;        /* Type specifying the pointer to the DAC data variable */
typedef uint32_t LDD_DAC_TData;        /* The DAC data variable type */
typedef uint32_t LDD_DAC_TStatus;      /* The status of the DAC module variable type */

/*
** ===================================================================
** DMA device types and constants
** ===================================================================
*/

#define LDD_DMA_ON_COMPLETE                    0x01U /* OnTransferComplete event mask. */
#define LDD_DMA_ON_ERROR                       0x02U /* OnError event mask. */

#define LDD_DMA_CONFIGURATION_ERROR            0x40000000U /* Configuration error. */
#define LDD_DMA_SOURCE_BUS_ERROR               0x20000000U /* Bus error on a source read. */
#define LDD_DMA_DESTINATION_BUS_ERROR          0x10000000U /* Bus error on a destination write. */

/* eDMA device error compatibility constants */
#define LDD_DMA_CHANNEL_PRIORITY_ERROR         0x4000U /* Channel priority error. */
#define LDD_DMA_SOURCE_ADDRESS_ERROR           0x80U /* Address inconsistency with transfer size error. */
#define LDD_DMA_SOURCE_OFFSET_ERROR            0x40U /* Offset inconsistency with transfer size error. */
#define LDD_DMA_DESTINATION_ADDRESS_ERROR      0x20U /* Address inconsistency with transfer size error. */
#define LDD_DMA_DESTINATION_OFFSET_ERROR       0x10U /* Offset inconsistency with transfer size error. */
#define LDD_DMA_COUNT_ERROR                    0x08U /* Byte count inconsistency with transfer sizes or transfer count error. */
#define LDD_DMA_SCATTER_GATHER_ERROR           0x04U /* Scatter/gather configuration error. */

#define LDD_DMA_CHANNEL_0_MASK                 0x01U /* DMA channel 0 mask. */
#define LDD_DMA_CHANNEL_1_MASK                 0x02U /* DMA channel 1 mask. */
#define LDD_DMA_CHANNEL_2_MASK                 0x04U /* DMA channel 2 mask. */
#define LDD_DMA_CHANNEL_3_MASK                 0x08U /* DMA channel 3 mask. */
#define LDD_DMA_CHANNEL_4_MASK                 0x10U /* DMA channel 4 mask. */
#define LDD_DMA_CHANNEL_5_MASK                 0x20U /* DMA channel 5 mask. */
#define LDD_DMA_CHANNEL_6_MASK                 0x40U /* DMA channel 6 mask. */
#define LDD_DMA_CHANNEL_7_MASK                 0x80U /* DMA channel 7 mask. */
#define LDD_DMA_CHANNEL_8_MASK                 0x0100U /* DMA channel 8 mask. */
#define LDD_DMA_CHANNEL_9_MASK                 0x0200U /* DMA channel 9 mask. */
#define LDD_DMA_CHANNEL_10_MASK                0x0400U /* DMA channel 10 mask. */
#define LDD_DMA_CHANNEL_11_MASK                0x0800U /* DMA channel 11 mask. */
#define LDD_DMA_CHANNEL_12_MASK                0x1000U /* DMA channel 12 mask. */
#define LDD_DMA_CHANNEL_13_MASK                0x2000U /* DMA channel 13 mask. */
#define LDD_DMA_CHANNEL_14_MASK                0x4000U /* DMA channel 14 mask. */
#define LDD_DMA_CHANNEL_15_MASK                0x8000U /* DMA channel 15 mask. */

typedef void     LDD_DMA_TData;

typedef uint8_t  LDD_DMA_TTransactionSize; /* Type specifying the transfer size parameter used by the DMA component's methods. */
typedef uint32_t LDD_DMA_TErrorFlags;  /* DMA controller error flags. See the DMA_LDD component's header file for detail description of allowed values. */

typedef uint32_t LDD_DMA_TTransactionCount;
typedef uint32_t LDD_DMA_TRequestCount;
typedef uint32_t LDD_DMA_TTransferDataSize;

/* Type specifying a DMA transfer state. */
typedef enum {
  LDD_DMA_TRANSFER_IDLE,               /* Channel is idle, no request is serviced nor transfer completed. */
  LDD_DMA_TRANSFER_BUSY,               /* Channel is active, request is serviced. */
  LDD_DMA_TRANSFER_ERROR               /* Error detected. */
} LDD_DMA_TTransferState;

/*
** ===================================================================
** FLASH device types and constants
** ===================================================================
*/
#define LDD_FLASH_ON_OPERATION_COMPLETE 0x02u /* OnOperationComplete event mask */
#define LDD_FLASH_ON_ERROR              0x04u /* OnError event mask */

#define LDD_FLASH_READ_COLLISION_ERROR     0x40u /* Read collision error flag's mask */
#define LDD_FLASH_ACCESS_ERROR             0x20u /* Access error flag's mask */
#define LDD_FLASH_PROTECTION_VIOLATION     0x10u /* Protection violation error flag's mask */
#define LDD_FLASH_ERASE_VERIFICATION_ERROR 0x08u /* Erase verification error flag's mask */
#define LDD_FLASH_MULTIPLE_WRITE_ERROR     0x04u /* Multiple write to one flash memory location error flag's mask */

/* Type specifying HW commands for a flash device */
typedef enum {                                          
  LDD_FLASH_READ_1S_BLOCK             = 0x00u, /* Checks if an entire program flash or data flash logical block has been erased to the specified margin level */
  LDD_FLASH_READ_1S_SECTION           = 0x01u, /* Checks if a section of program flash or data flash memory is erased to the specified read margin level */
  LDD_FLASH_WRITE_BYTE                = 0x04u, /* Program byte */
  LDD_FLASH_WRITE_WORD                = 0x05u, /* Program word */
  LDD_FLASH_WRITE_LONG_WORD           = 0x06u, /* Program long word */
  LDD_FLASH_WRITE_PHRASE              = 0x07u, /* Program phrase */
  LDD_FLASH_ERASE_FLASH_BLOCK         = 0x08u, /* Erase flash memory block */
  LDD_FLASH_ERASE_SECTOR              = 0x09u, /* Erase sector */
  LDD_FLASH_ERASE_ALL_FLASH_BLOCKS    = 0x44u /* Erase all flash memory blocks */
} LDD_FLASH_TCommand;

/* Type specifying possible FLASH component operation types */
typedef enum {                                          
  LDD_FLASH_NO_OPERATION,              /* No operation - initial state */
  LDD_FLASH_READ,                      /* Read operation */
  LDD_FLASH_WRITE,                     /* Write operation */
  LDD_FLASH_ERASE,                     /* Erase operation */
  LDD_FLASH_ERASE_BLOCK,               /* Erase block operation */
  LDD_FLASH_VERIFY_ERASED_BLOCK        /* Verify erased block operation */
} LDD_FLASH_TOperationType;

/* Type specifying possible FLASH component operation states */
typedef enum {                                          
  LDD_FLASH_IDLE,                      /* No operation in progress */
  LDD_FLASH_STOP,                      /* The operation has been stopped */
  LDD_FLASH_STOP_REQ,                  /* The operation is in the STOP request mode */
  LDD_FLASH_START,                     /* Start of the operation, no operation steps have been done yet */
  LDD_FLASH_RUNNING,                   /* Operation is in progress */
  LDD_FLASH_FAILED                     /* Operation has failed */
} LDD_FLASH_TOperationStatus;

typedef uint8_t LDD_FLASH_TErrorFlags; /* Type specifying FLASH component's error flags bit field */

typedef uint32_t LDD_FLASH_TAddress;   /* Type specifying the Address parameter used by the FLASH component's methods */

typedef uint32_t LDD_FLASH_TDataSize;  /* Type specifying the Size parameter used by the FLASH component's methods */

typedef uint16_t LDD_FLASH_TErasableUnitSize; /* Type specifying the Size output parameter of the GetErasableUnitSize method (pointer to a variable of this type is passed to the method) */

/* Type specifying the FLASH component's rrror status information */
typedef struct {                                        
  LDD_FLASH_TOperationType CurrentOperation; /* Current operation */
  LDD_FLASH_TCommand       CurrentCommand; /* Last flash controller command */
  LDD_FLASH_TErrorFlags    CurrentErrorFlags; /* Bitfield with error flags. See FLASH2.h for details */
  LDD_FLASH_TAddress       CurrentAddress; /* Address of the flash memory location the error status is related to */
  LDD_TData               *CurrentDataPtr; /* Pointer to current input data the error status is related to */
  LDD_FLASH_TDataSize      CurrentDataSize; /* Size of the current input data to be programmed or erased in bytes */
} LDD_FLASH_TErrorStatus;

/*
** ===================================================================
** GPIO device types and constants
** ===================================================================
*/
#define LDD_GPIO_PIN_0                0x01U /*!< Pin 0 inside the port */
#define LDD_GPIO_PIN_1                0x02U /*!< Pin 1 inside the port */
#define LDD_GPIO_PIN_2                0x04U /*!< Pin 2 inside the port */
#define LDD_GPIO_PIN_3                0x08U /*!< Pin 3 inside the port */
#define LDD_GPIO_PIN_4                0x10U /*!< Pin 4 inside the port */
#define LDD_GPIO_PIN_5                0x20U /*!< Pin 5 inside the port */
#define LDD_GPIO_PIN_6                0x40U /*!< Pin 6 inside the port */
#define LDD_GPIO_PIN_7                0x80U /*!< Pin 7 inside the port */
#define LDD_GPIO_PIN_8                0x0100U /*!< Pin 8 inside the port */
#define LDD_GPIO_PIN_9                0x0200U /*!< Pin 9 inside the port */
#define LDD_GPIO_PIN_10                0x0400U /*!< Pin 10 inside the port */
#define LDD_GPIO_PIN_11                0x0800U /*!< Pin 11 inside the port */
#define LDD_GPIO_PIN_12                0x1000U /*!< Pin 12 inside the port */
#define LDD_GPIO_PIN_13                0x2000U /*!< Pin 13 inside the port */
#define LDD_GPIO_PIN_14                0x4000U /*!< Pin 14 inside the port */
#define LDD_GPIO_PIN_15                0x8000U /*!< Pin 15 inside the port */

#define LDD_GPIO_ON_PORT_EVENT 0x01U   /*!< OnPortEvent event mask */

typedef uint32_t LDD_GPIO_TBitField;   /*!< Abstract type specifying the bit field within the port. */

/*! Defines condition when event is invoked. */
typedef enum {
  LDD_GPIO_DISABLED = 0x00U,           /*!< Event doesn't invoke */
  LDD_GPIO_LOW      = 0x01U,           /*!< Event when logic zero */
  LDD_GPIO_HIGH     = 0x02U,           /*!< Event when logic one */
  LDD_GPIO_FALLING  = 0x03U,           /*!< Event on falling edge */
  LDD_GPIO_RISING   = 0x04U,           /*!< Event on rising edge */
  LDD_GPIO_BOTH     = 0x05U            /*!< Event on rising and falling edge */
} LDD_GPIO_TEventCondition;

/*
** ===================================================================
** BITSIO device types and constants
** ===================================================================
*/
#define LDD_BITSIO_PIN_0   0x01U       /*!< Pin 0 inside pin list of component */
#define LDD_BITSIO_PIN_1   0x02U       /*!< Pin 1 inside pin list of component */
#define LDD_BITSIO_PIN_2   0x04U       /*!< Pin 2 inside pin list of component */
#define LDD_BITSIO_PIN_3   0x08U       /*!< Pin 3 inside pin list of component */
#define LDD_BITSIO_PIN_4   0x10U       /*!< Pin 4 inside pin list of component */
#define LDD_BITSIO_PIN_5   0x20U       /*!< Pin 5 inside pin list of component */
#define LDD_BITSIO_PIN_6   0x40U       /*!< Pin 6 inside pin list of component */
#define LDD_BITSIO_PIN_7   0x80U       /*!< Pin 7 inside pin list of component */
#define LDD_BITSIO_PIN_8   0x0100U     /*!< Pin 8 inside pin list of component */
#define LDD_BITSIO_PIN_9   0x0200U     /*!< Pin 9 inside pin list of component */
#define LDD_BITSIO_PIN_10   0x0400U    /*!< Pin 10 inside pin list of component */
#define LDD_BITSIO_PIN_11   0x0800U    /*!< Pin 11 inside pin list of component */
#define LDD_BITSIO_PIN_12   0x1000U    /*!< Pin 12 inside pin list of component */
#define LDD_BITSIO_PIN_13   0x2000U    /*!< Pin 13 inside pin list of component */
#define LDD_BITSIO_PIN_14   0x4000U    /*!< Pin 14 inside pin list of component */
#define LDD_BITSIO_PIN_15   0x8000U    /*!< Pin 15 inside pin list of component */

/*
** ===================================================================
** MSCAN device types and constants
** ===================================================================
*/

#define LDD_CAN_RX_PIN            0x01U /* Rx pin mask */
#define LDD_CAN_TX_PIN            0x02U /* Tx pin mask */

#define LDD_CAN_ON_FULL_RXBUFFER  0x01U /* OnFullRxBuffer event mask */
#define LDD_CAN_ON_FREE_TXBUFFER  0x02U /* OnFreeTxBuffer event mask */
#define LDD_CAN_ON_BUSOFF         0x04U /* OnBusOff event mask */
#define LDD_CAN_ON_TXWARNING      0x08U /* OnTransmitterWarning event mask */
#define LDD_CAN_ON_RXWARNING      0x10U /* OnReceiverWarning event mask */
#define LDD_CAN_ON_ERROR          0x20U /* OnError event mask */
#define LDD_CAN_ON_WAKEUP         0x40U /* OnWakeUp event mask */

#define LDD_CAN_BIT0_ERROR        0x01UL /* Bit0 error detect error mask */
#define LDD_CAN_BIT1_ERROR        0x02UL /* Bit1 error detect error mask */
#define LDD_CAN_ACK_ERROR         0x04UL /* Acknowledge error detect error mask */
#define LDD_CAN_CRC_ERROR         0x08UL /* Cyclic redundancy check error detect error mask */
#define LDD_CAN_FORM_ERROR        0x10UL /* Message form error detect error mask */
#define LDD_CAN_STUFFING_ERROR    0x20UL /* Bit stuff error detect error mask */
#define LDD_CAN_RX_OVERRUN_ERROR  0x40UL /* Receiver overrun detect error mask */

#define LDD_CAN_MESSAGE_ID_EXT    0x80000000UL /* Value specifying extended Mask, ID */

#define LDD_CAN_RUN_MODE          0x00UL /* CAN device in run mode mask */
#define LDD_CAN_FREEZE_MODE       0x01UL /* CAN device in freeze (initialization) mode mask */
#define LDD_CAN_SLEEP_MODE        0x02UL /* CAN device in sleep mode mask */

typedef uint8_t LDD_CAN_TMBIndex;      /* CAN message buffer index */
typedef uint8_t LDD_CAN_TElementIndex; /* Type specifying the filter table mask element index */
typedef uint32_t LDD_CAN_TAccMask;     /* Type specifying the acceptance mask variable */
typedef uint32_t LDD_CAN_TAccCode;     /* Type specifying the acceptance code variable */
typedef uint32_t LDD_CAN_TMessageID;   /* Type specifying the ID mask variable */
typedef uint8_t LDD_CAN_TErrorCounter; /* Type specifying the error counter variable */
typedef uint32_t LDD_CAN_TErrorMask;   /* Type specifying the error mask variable */
typedef uint16_t LDD_CAN_TBufferMask;  /* Type specifying the message buffer mask variable */
typedef uint8_t LDD_CAN_TIDHitFilterIndex; /* Type specifying the Rx FIFO hit filter index variable */ 
typedef uint8_t LDD_CAN_TRunModeMask;  /* Type specifying the run mode variable */ 

typedef enum {                         /* Type specifying the Rx message buffer state */
  LDD_CAN_MB_RX_NOT_ACTIVE,            /* Receive buffer is not active */ 
  LDD_CAN_MB_RX_FULL,                  /* Receive buffer is full */
  LDD_CAN_MB_RX_EMPTY,                 /* Receive buffer is empty */
  LDD_CAN_MB_RX_OVERRUN,               /* Receive buffer is overrun */
  LDD_CAN_MB_RX_BUSY,                  /* Receive buffer is busy */
  LDD_CAN_MB_RX_RANSWER                /* Receive buffer is ranswer */
} LDD_CAN_TRxBufferState;

typedef enum {                         /* Type specifying the CAN frame type */
  LDD_CAN_ONE_32Bit_FILTER  = 0x00U,   /* One 32-bit - One full ID (standard and extended) per ID Filter Table element*/
  LDD_CAN_TWO_16Bit_FILTERS = 0x01U,   /* Two 16-bit - Two full standard IDs or two partial 14-bit (standard and extended) IDs per ID Filter Table element */
  LDD_CAN_FOUR_8Bit_FILTERS = 0x02U,   /* Four 8-bit - Four partial 8-bit Standard IDs per ID Filter Table element */
  LDD_CAN_FILTER_CLOSED     = 0x03U    /* Filter closed - all frames are rejected */
} LDD_CAN_IDAcceptanceFilterMode;

typedef enum {                         /* Type specifying the CAN frame type */
  LDD_CAN_DATA_FRAME,                  /* Data frame type received or transmitted */
  LDD_CAN_REMOTE_FRAME,                /* Remote frame type  */
  LDD_CAN_RESPONSE_FRAME               /* Response frame type - Tx buffer send data after receiving remote frame with the same ID */
} LDD_CAN_TFrameType;

typedef struct {
  uint32_t TxFrames;                   /* Transmitted frame counter */
  uint32_t TxWarnings;                 /* Transmission warning counter */
  uint32_t RxFrames;                   /* Received frame counter */
  uint32_t RxWarnings;                 /* Reception warning counter */
  uint32_t BusOffs;                    /* Bus off counter */
  uint32_t RxOverrun;                  /* Receiver FIFO overrun counter */
  uint32_t Wakeups;                    /* Wakeup counter */
  uint32_t Bit0Errors;                 /* Bit0 error counter */
  uint32_t Bit1Errors;                 /* Bit1 error counter */
  uint32_t AckErrors;                  /* ACK error counter */
  uint32_t CrcErrors;                  /* CRC error counter */
  uint32_t FormErrors;                 /* Message form error counter */
  uint32_t BitStuffErrors;             /* Bit stuff error counter */
  uint32_t Errors;                     /* Error counter */
} LDD_CAN_TStats;

typedef struct {
  LDD_CAN_TMessageID MessageID;        /* Message ID */
  LDD_CAN_TFrameType FrameType;        /* Type of the frame DATA/REMOTE */
  uint8_t *Data;                       /* Message data buffer */
  uint8_t  Length;                     /* Message length */
  uint16_t TimeStamp;                  /* Message time stamp */
  uint8_t  LocPriority;                /* Local Priority Tx Buffers */
} LDD_CAN_TFrame;


/*
** ===================================================================
** ADC device types and constants
** ===================================================================
*/

#define LDD_ADC_CHANNEL_0_PIN                0x01u /*!< Channel 0 pin mask */
#define LDD_ADC_CHANNEL_1_PIN                0x02u /*!< Channel 1 pin mask */
#define LDD_ADC_CHANNEL_2_PIN                0x04u /*!< Channel 2 pin mask */
#define LDD_ADC_CHANNEL_3_PIN                0x08u /*!< Channel 3 pin mask */
#define LDD_ADC_CHANNEL_4_PIN                0x10u /*!< Channel 4 pin mask */
#define LDD_ADC_CHANNEL_5_PIN                0x20u /*!< Channel 5 pin mask */
#define LDD_ADC_CHANNEL_6_PIN                0x40u /*!< Channel 6 pin mask */
#define LDD_ADC_CHANNEL_7_PIN                0x80u /*!< Channel 7 pin mask */
#define LDD_ADC_CHANNEL_8_PIN                0x0100u /*!< Channel 8 pin mask */
#define LDD_ADC_CHANNEL_9_PIN                0x0200u /*!< Channel 9 pin mask */
#define LDD_ADC_CHANNEL_10_PIN                0x0400u /*!< Channel 10 pin mask */
#define LDD_ADC_CHANNEL_11_PIN                0x0800u /*!< Channel 11 pin mask */
#define LDD_ADC_CHANNEL_12_PIN                0x1000u /*!< Channel 12 pin mask */
#define LDD_ADC_CHANNEL_13_PIN                0x2000u /*!< Channel 13 pin mask */
#define LDD_ADC_CHANNEL_14_PIN                0x4000u /*!< Channel 14 pin mask */
#define LDD_ADC_CHANNEL_15_PIN                0x8000u /*!< Channel 15 pin mask */
#define LDD_ADC_CHANNEL_16_PIN                0x00010000u /*!< Channel 16 pin mask */
#define LDD_ADC_CHANNEL_17_PIN                0x00020000u /*!< Channel 17 pin mask */
#define LDD_ADC_CHANNEL_18_PIN                0x00040000u /*!< Channel 18 pin mask */
#define LDD_ADC_CHANNEL_19_PIN                0x00080000u /*!< Channel 19 pin mask */
#define LDD_ADC_CHANNEL_20_PIN                0x00100000u /*!< Channel 20 pin mask */
#define LDD_ADC_CHANNEL_21_PIN                0x00200000u /*!< Channel 21 pin mask */
#define LDD_ADC_CHANNEL_22_PIN                0x00400000u /*!< Channel 22 pin mask */
#define LDD_ADC_CHANNEL_23_PIN                0x00800000u /*!< Channel 23 pin mask */
#define LDD_ADC_CHANNEL_24_PIN                0x01000000u /*!< Channel 24 pin mask */
#define LDD_ADC_CHANNEL_25_PIN                0x02000000u /*!< Channel 25 pin mask */
#define LDD_ADC_CHANNEL_26_PIN                0x04000000u /*!< Channel 26 pin mask */
#define LDD_ADC_CHANNEL_27_PIN                0x08000000u /*!< Channel 27 pin mask */
#define LDD_ADC_CHANNEL_28_PIN                0x10000000u /*!< Channel 28 pin mask */
#define LDD_ADC_CHANNEL_29_PIN                0x20000000u /*!< Channel 29 pin mask */
#define LDD_ADC_CHANNEL_30_PIN                0x40000000u /*!< Channel 30 pin mask */
#define LDD_ADC_CHANNEL_31_PIN                0x80000000u /*!< Channel 31 pin mask */

#define LDD_ADC_TRIGGER_PIN                  0x01U /*!< Trigger 0 pin mask */

#define LDD_ADC_LOW_VOLT_REF_PIN             0x01U /*!< Low voltage reference pin mask for converter A */
#define LDD_ADC_HIGH_VOLT_REF_PIN            0x02U /*!< High voltage reference pin mask for converter A */
#define LDD_ADC_LOW_VOLT_REF_1_PIN           0x03U /*!< Low voltage reference pin mask for converter B */
#define LDD_ADC_HIGH_VOLT_REF_1_PIN          0x04U /*!< High voltage reference pin mask for converter B */

#define LDD_ADC_ON_HIGH_LIMIT 0x0100U  /*!< OnHighLimit event mask */
#define LDD_ADC_ON_LOW_LIMIT 0x0200U   /*!< OnLowLimit event mask */
#define LDD_ADC_ON_ZERO_CROSSING 0x0400U /*!< OnZeroCrossing event mask */
#define LDD_ADC_ON_MEASUREMENT_COMPLETE 0x0800U /*!< OnMeasurementComplete event mask */

/*! Structure pins for pin connection method */
typedef struct {                                                 
  uint32_t Channel0_31PinMask;         /*!< Channel pin mask for channels 0 through 31 */
  uint16_t TriggerPinMask;             /*!< Trigger pin mask */
  uint8_t  VoltRefPinMask;             /*!< Voltage reference pin mask */
} LDD_ADC_TPinMask;

/*! Defines Zero crossing modes. */
typedef enum {
  LDD_ADC_ZERO_CROSSING_DISABLED             = 0x00U, /*!< Zero crossing disabled */
  LDD_ADC_ZERO_CROSSING_POSITIVE_TO_NEGATIVE = 0x01U, /*!< Zero crossing from positive to negative */
  LDD_ADC_ZERO_CROSSING_NEGATIVE_TO_POSITIVE = 0x02U, /*!< Zero crossing from negative to positive */
  LDD_ADC_ZERO_CROSSING_ANY_CHANGE           = 0x03U /*!< Zero crossing any change */
} LDD_ADC_TZeroCrossingMode;

/*! Structure used to describing one sample */
typedef struct {                                                 
  uint8_t ChannelIdx;                  /*!< Channel index */
  uint16_t HighLimitValue;             /*!< High limit value */
  uint16_t LowLimitValue;              /*!< Low limit value */
  uint16_t OffsetValue;                /*!< Offset value */
  LDD_ADC_TZeroCrossingMode ZeroCrossingMode; /*!< Zero crossing mode */
} LDD_ADC_TSample;


/*
** ===================================================================
** Interrupt vector constants
** ===================================================================
*/
#define LDD_ivIndex_INT_HW_RESET                0x00u
#define LDD_ivIndex_INT_COP_RESET               0x01u
#define LDD_ivIndex_INT_ILLEGAL_OP              0x02u
#define LDD_ivIndex_INT_SWI3                    0x03u
#define LDD_ivIndex_INT_OVERFLOW                0x04u
#define LDD_ivIndex_INT_MISALIGNED              0x05u
#define LDD_ivIndex_INT_STPCNT                  0x06u
#define LDD_ivIndex_INT_BKPT                    0x07u
#define LDD_ivIndex_INT_TRBUF                   0x08u
#define LDD_ivIndex_INT_TX_REG                  0x09u
#define LDD_ivIndex_INT_RX_REG                  0x0Au
#define LDD_ivIndex_INT_BUS_ERR                 0x0Bu
#define LDD_ivIndex_INT_reserved12              0x0Cu
#define LDD_ivIndex_INT_reserved13              0x0Du
#define LDD_ivIndex_INT_reserved14              0x0Eu
#define LDD_ivIndex_INT_SWI2                    0x0Fu
#define LDD_ivIndex_INT_SWI1                    0x10u
#define LDD_ivIndex_INT_SWI0                    0x11u
#define LDD_ivIndex_INT_XBARA                   0x12u
#define LDD_ivIndex_INT_LVI1                    0x13u
#define LDD_ivIndex_INT_OCCS                    0x14u
#define LDD_ivIndex_INT_reserved21              0x15u
#define LDD_ivIndex_INT_reserved22              0x16u
#define LDD_ivIndex_INT_reserved23              0x17u
#define LDD_ivIndex_INT_reserved24              0x18u
#define LDD_ivIndex_INT_TMRA_3                  0x19u
#define LDD_ivIndex_INT_TMRA_2                  0x1Au
#define LDD_ivIndex_INT_TMRA_1                  0x1Bu
#define LDD_ivIndex_INT_TMRA_0                  0x1Cu
#define LDD_ivIndex_INT_ADC_CC1                 0x1Du
#define LDD_ivIndex_INT_ADC_CC0                 0x1Eu
#define LDD_ivIndex_INT_ADC_ERR                 0x1Fu
#define LDD_ivIndex_INT_reserved32              0x20u
#define LDD_ivIndex_INT_DMA3                    0x21u
#define LDD_ivIndex_INT_DMA2                    0x22u
#define LDD_ivIndex_INT_DMA1                    0x23u
#define LDD_ivIndex_INT_DMA0                    0x24u
#define LDD_ivIndex_INT_reserved37              0x25u
#define LDD_ivIndex_INT_reserved38              0x26u
#define LDD_ivIndex_INT_ERROR                   0x27u
#define LDD_ivIndex_INT_TX_WARN                 0x28u
#define LDD_ivIndex_INT_RX_WARN                 0x29u
#define LDD_ivIndex_INT_WAKEUP                  0x2Au
#define LDD_ivIndex_INT_reserved43              0x2Bu
#define LDD_ivIndex_INT_reserved44              0x2Cu
#define LDD_ivIndex_INT_reserved45              0x2Du
#define LDD_ivIndex_INT_reserved46              0x2Eu
#define LDD_ivIndex_INT_QSCI1_RERR              0x2Fu
#define LDD_ivIndex_INT_QSCI1_RCV               0x30u
#define LDD_ivIndex_INT_QSCI1_TIDLE             0x31u
#define LDD_ivIndex_INT_QSCI1_TDRE              0x32u
#define LDD_ivIndex_INT_QSCI0_RERR              0x33u
#define LDD_ivIndex_INT_QSCI0_RCV               0x34u
#define LDD_ivIndex_INT_QSCI0_TIDLE             0x35u
#define LDD_ivIndex_INT_QSCI0_TDRE              0x36u
#define LDD_ivIndex_INT_reserved55              0x37u
#define LDD_ivIndex_INT_reserved56              0x38u
#define LDD_ivIndex_INT_QSPI1_XMIT              0x39u
#define LDD_ivIndex_INT_QSPI1_RCV               0x3Au
#define LDD_ivIndex_INT_QSPI0_XMIT              0x3Bu
#define LDD_ivIndex_INT_QSPI0_RCV               0x3Cu
#define LDD_ivIndex_INT_reserved61              0x3Du
#define LDD_ivIndex_INT_IIC0                    0x3Eu
#define LDD_ivIndex_INT_reserved63              0x3Fu
#define LDD_ivIndex_INT_reserved64              0x40u
#define LDD_ivIndex_INT_reserved65              0x41u
#define LDD_ivIndex_INT_reserved66              0x42u
#define LDD_ivIndex_INT_reserved67              0x43u
#define LDD_ivIndex_INT_reserved68              0x44u
#define LDD_ivIndex_INT_reserved69              0x45u
#define LDD_ivIndex_INT_reserved70              0x46u
#define LDD_ivIndex_INT_reserved71              0x47u
#define LDD_ivIndex_INT_reserved72              0x48u
#define LDD_ivIndex_INT_reserved73              0x49u
#define LDD_ivIndex_INT_reserved74              0x4Au
#define LDD_ivIndex_INT_reserved75              0x4Bu
#define LDD_ivIndex_INT_reserved76              0x4Cu
#define LDD_ivIndex_INT_eFlexPWMA_FAULT         0x4Du
#define LDD_ivIndex_INT_eFlexPWMA_RERR          0x4Eu
#define LDD_ivIndex_INT_eFlexPWMA_RELOAD3       0x4Fu
#define LDD_ivIndex_INT_eFlexPWMA_CAP           0x50u
#define LDD_ivIndex_INT_eFlexPWMA_CMP3          0x51u
#define LDD_ivIndex_INT_eFlexPWMA_RELOAD2       0x52u
#define LDD_ivIndex_INT_eFlexPWMA_CMP2          0x53u
#define LDD_ivIndex_INT_eFlexPWMA_RELOAD1       0x54u
#define LDD_ivIndex_INT_eFlexPWMA_CMP1          0x55u
#define LDD_ivIndex_INT_eFlexPWMA_RELOAD0       0x56u
#define LDD_ivIndex_INT_eFlexPWMA_CMP0          0x57u
#define LDD_ivIndex_INT_FTFA_RDCOL              0x58u
#define LDD_ivIndex_INT_FTFA_CC                 0x59u
#define LDD_ivIndex_INT_CMPD                    0x5Au
#define LDD_ivIndex_INT_CMPC                    0x5Bu
#define LDD_ivIndex_INT_CMPB                    0x5Cu
#define LDD_ivIndex_INT_CMPA                    0x5Du
#define LDD_ivIndex_INT_PIT1_ROLLOVR            0x5Eu
#define LDD_ivIndex_INT_PIT0_ROLLOVR            0x5Fu
#define LDD_ivIndex_INT_reserved96              0x60u
#define LDD_ivIndex_INT_reserved97              0x61u
#define LDD_ivIndex_INT_reserved98              0x62u
#define LDD_ivIndex_INT_reserved99              0x63u
#define LDD_ivIndex_INT_reserved100             0x64u
#define LDD_ivIndex_INT_reserved101             0x65u
#define LDD_ivIndex_INT_GPIOF                   0x66u
#define LDD_ivIndex_INT_GPIOE                   0x67u
#define LDD_ivIndex_INT_GPIOD                   0x68u
#define LDD_ivIndex_INT_GPIOC                   0x69u
#define LDD_ivIndex_INT_GPIOB                   0x6Au
#define LDD_ivIndex_INT_GPIOA                   0x6Bu
#define LDD_ivIndex_INT_COP_INT                 0x6Cu
#define LDD_ivIndex_INT_EWM_INT                 0x6Du
#define LDD_ivIndex_INT_SWILP                   0x6Eu
/*
** ===================================================================
** Function prototypes
** ===================================================================
*/

/*
** ===================================================================
**     Method      :  Cpu_PE_FillMemory (component MC56F82748VLH)
*/
/*!
**     @brief
**         Fills a memory area block by a specified value.
**     @param
**       SourceAddressPtr - Source address pointer.
**     @param
**       c - A value used to fill a memory block.
**     @param
**       len - Length of a memory block to fill.
*/
/* ===================================================================*/
void PE_FillMemory(register void* SourceAddressPtr, register uint8_t c, register uint32_t len);

/*
** ===================================================================
**     Method      :  Cpu_PE_PeripheralUsed (component MC56F82748VLH)
*/
/*!
**     @brief
**         Returns information whether a peripheral is allocated by PEx 
**         or not.
**     @param
**       PrphBaseAddress - Base address of a peripheral.
**     @return
**       TRUE if a peripheral is used by PEx or FALSE if it isn't used.
*/
/* ===================================================================*/
bool PE_PeripheralUsed(uint32_t PrphBaseAddress);

/*
** ===================================================================
**     Method      :  Cpu_LDD_SetClockConfiguration (component MC56F82748VLH)
*/
/*!
**     @brief
**         Changes the clock configuration of all LDD components in a 
**         project.
**     @param
**       ClockConfiguration - New CPU clock configuration changed by CPU SetClockConfiguration method.
*/
/* ===================================================================*/
void LDD_SetClockConfiguration(LDD_TClockConfiguration ClockConfiguration);

/* END PE_LDD. */

#include "Pins1.h"
#include "TU1.h"
#include "GPIOE0.h"
#include "BitIoLdd1.h"

#endif

/*!
** @}
*/
/*
** ###################################################################
**
**     This file was created by Processor Expert 10.3 [05.09]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
