/* ###################################################################
**     Filename    : Events.c
**     Project     : ramISR
**     Processor   : MC56F82748VLH
**     Component   : Events
**     Version     : Driver 01.03
**     Compiler    : CodeWarrior DSP C Compiler
**     Date/Time   : 2014-10-23, 18:00, # CodeGen: 0
**     Abstract    :
**         This is user's event module.
**         Put your event handler code here.
**     Settings    :
**     Contents    :
**         No public methods
**
** ###################################################################*/
/*!
** @file Events.c
** @version 01.03
** @brief
**         This is user's event module.
**         Put your event handler code here.
*/         
/*!
**  @addtogroup Events_module Events module documentation
**  @{
*/         
/* MODULE Events */

#include "Init_Config.h"
#include "Cpu.h"
#include "Events.h"
#include "intrinsics_56800E.h"

/* User includes (#include below this line is not maintained by Processor Expert) */

#pragma define_section ramFunc "ramFunc.text" RX

#pragma section ramFunc begin
#pragma interrupt alignsp 
void PIT_100k_OnInterrupt(void)
{

  PWMA_SM0STS |= PWM_STS_RF_MASK; // clear PWMA SM0 Reload Flag

  /*--------------------------------*/
  /* codes to be relocated into RAM */
  /*--------------------------------*/
  GPIOE_DR ^= 1;
}
#pragma section ramFunc end


/* END Events */

/*!
** @}
*/
/*
** ###################################################################
**
**     This file was created by Processor Expert 10.3 [05.09]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
