/* ###################################################################
**     Filename    : Events.h
**     Project     : ramISR
**     Processor   : MC56F82748VLH
**     Component   : Events
**     Version     : Driver 01.03
**     Compiler    : CodeWarrior DSP C Compiler
**     Date/Time   : 2014-10-23, 18:00, # CodeGen: 0
**     Abstract    :
**         This is user's event module.
**         Put your event handler code here.
**     Settings    :
**     Contents    :
**         No public methods
**
** ###################################################################*/
/*!
** @file Events.h
** @version 01.03
** @brief
**         This is user's event module.
**         Put your event handler code here.
*/         
/*!
**  @addtogroup Events_module Events module documentation
**  @{
*/         

#ifndef __Events_H
#define __Events_H
/* MODULE Events */

#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"
#include "Init_Config.h"
#include "PDD_Includes.h"
#include "Pins1.h"
#include "TU1.h"
#include "GPIOE0.h"
#include "BitIoLdd1.h"


/*
** ===================================================================
**     Event       :  PIT_100k_OnInterrupt (module Events)
**
**     Component   :  PIT_100k [TimerInt]
**     Description :
**         When a timer interrupt occurs this event is called (only
**         when the component is enabled - <Enable> and the events are
**         enabled - <EnableEvent>). This event is enabled only if a
**         <interrupt service/event> is enabled.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/

/* Convert int/float to Frac16; constant x generates compile time constant */
#define FRAC16(x) ((Frac16)((x) < 1 ? ((x) >= -1 ? ((Frac16)((x)*0x8000)) : ((Frac16)0x8000)) : ((Frac16)0x7FFF)))
/* Convert int/float to Frac32; constant x generates compile time constant */
#define FRAC32(x) ((Frac32)((x) < 1 ? ((x) >= -1 ? ((Frac32)((x)*0x80000000)) : ((Frac32)0x80000000)) : ((Frac32)0x7FFFFFFF)))

void PIT_100k_OnInterrupt(void);





/* END Events */
#endif /* __Events_H*/

/*!
** @}
*/
/*
** ###################################################################
**
**     This file was created by Processor Expert 10.3 [05.09]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
