/*******************************************************************************
 * Freescale Semiconductor Inc.
 * (c) Copyright 2013 Freescale Semiconductor, Inc.
 * ALL RIGHTS RESERVED.
 * 
 * This project performs the 
 * by enabling the LEDs on the board and the inputs from a 
 * Hall sensor interface.
*******************************************************************************/
#include <hidef.h> /* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */

#include "S12ZVMEVB.h"
#include "freemaster.h"	/*-> Added FreeMaster library placeholder*/
/*-> MCLib library placeholder */

unsigned short pot_value = 0;
unsigned short ADC0_temperature = 0;

/*Command list 0 with end of sequence after 2nd conversion and end of list after 4th. Reading potenciometer and internal temperature sensor*/
volatile char ADC0CommandList_0[4][4] @0x001000 = {
			{0x00,0xD4,0x00,0x00},
			{0x41,0xD4,0x00,0x00},
			{0x00,0xD4,0x00,0x00},
			{0xC2,0xD4,0x00,0x00}
};
/*Command list 1 with end of sequence after 2nd conversion and end of list after 4th. Reading potenciometer and internal temperature sensor*/
volatile char ADC0CommandList_1[4][4] @0x001010 = {
			{0x00,0xC8,0x00,0x00},
			{0x43,0xC8,0x00,0x00},
			{0x00,0xC8,0x00,0x00},
			{0xC4,0xC8,0x00,0x00}
};

volatile unsigned short ADC0ResultList_0[4] @ 0x001020 = {0, 0, 0, 0};
volatile unsigned short ADC0ResultList_1[4] @ 0x001028 = {0, 0, 0, 0};


/*****************************************************************************
* Function: main
*****************************************************************************/
void main(void) {
	
	initCPMU();
	initGPIO();
	initSCI();
	initADC();
	
	FMSTR_Init();
	EnableInterrupts;
	
	for(;;) {
		__RESET_WATCHDOG();	/* feeds the dog */

		FMSTR_Poll();
	
	} /* loop forever */
	/* please make sure that you never leave main */
	
}


/*****************************************************************************
*
* Function: void initCPMU(void)
*
* Description: Clock, Reset and Power Management Unit configuration
*              (External clock 4MHz, 25/12.5 MHz CPU/Bus clock)
*
*****************************************************************************/
void initCPMU(void)
{
	/* Wait for stable supply after power up */
	while (GDUF_GLVLSF)
		GDUF_GLVLSF = 1;

	CPMUREFDIV_REFDIV = CPMU_REFDIV;
	CPMUREFDIV_REFFRQ = CPMU_REFFRQ;
	CPMUSYNR_SYNDIV = CPMU_SYNDIV;
	CPMUSYNR_VCOFRQ = CPMU_VCOFRQ;
	CPMUPOSTDIV_POSTDIV = CPMU_POSTDIV;

	CPMUOSC_OSCE = 1;				/* Enable external oscillator */
	while (CPMUIFLG_UPOSC == 0) {}; /* Wait for oscillator to start up (UPOSC=1) and PLL to lock (LOCK=1) */
	while (CPMUIFLG_LOCK == 0) {};	/* Wait for PLL to lock */
	CPMURFLG  = 0x60; 				/* Clear PORF and LVRF */
	
}


/*****************************************************************************
*
* Function: void initGPIO(void)
*
* Description: I/O pins configuration
*
*****************************************************************************/
void initGPIO(void)
{
	MODRR0 = MODRR0_CONFIG;		/* Serial Port routing*/
	DDRS = DDRS_CONFIG;			/* User LEDs */
	LED1 = 0;					/* Turn off LEDs by default */
	LED2 = 0;					/* Turn off LEDs by default */
	
	MODRR2 = MODRR2_CONFIG;		/* Serial Port routing*/
}


/*****************************************************************************
*
* Function: void initSCI(void)
*
* Description: SCI module configuration
*
*****************************************************************************/
void initSCI(void)
{
	SCI1BD = SCI_BAUDRATE;		/* target baud rate = 9600, bus clock = 12.5MHz : [12.5MHz / 56000] = 223.2 */
	SCI1CR2_TE = 1;
	SCI1CR2_RE = 1;
}



/*****************************************************************************
*
* Function: void initADC(void)
*
* Description: ADC module configuration
*
*****************************************************************************/
void initADC(void){
	
	ADC0CTL_0_ACC_CFG = 3;	/* Dual access mode */
	ADC0CTL_0_MOD_CFG = 1;	/* Trigger mode */
	ADC0TIM = 3;			/* ADC clock = fbus / (2x(ADC0TIM + 1)) [0.25 - 8MHz] */
	
	ADC0FMT_DJM = 1;		/* Right justified result data */
	ADC0FMT_SRES = 4;		/* 12-bit resolution */
	
	/*Interrupt Enables */
	ADC0CONIE_1_EOL_IE = 1;	/* End of list interrupt enable */
	ADC0CONIE_CON_IE1 = 1;  /* Conversion 1 interrupt enable */
	ADC0CONIE_CON_IE2 = 1; /* Conversion 2 interrupt enable */
	ADC0CONIE_CON_IE3 = 1; /* Conversion 3 interrupt enable */
	ADC0CONIE_CON_IE4 = 1; /* Conversion 4 interrupt enable */
	
	/* Buffer Mode Select */
	ADC0CTL_1_CSL_BMOD = 1; /*Double CSL buffer */
	ADC0CTL_1_RVL_BMOD = 1; /*Double RVL buffer */
	
	
	/* ADC0 Command & Result Base Pointers */
	ADC0CBP = ADC0CommandList_0;
	ADC0RBP = ADC0ResultList_0;
	
	/* ADC0 Command/Result Offset registers */
	ADC0CROFF1 = 4; /* 4 is the size of RVL and CSL */
	
	ADC0CTL_0_ADC_EN = 1;	/* Enable ADC0 */
	ADC0EIE = 0xEE;			/* Enable all errors interrupts */
	ADC0FLWCTL_RSTA = 1;	/* Issue a restart event */
	
	while (1 == ADC0FLWCTL_RSTA) ;	/* Wait until restart flag is cleared */
}



/*****************************************************************************
* Function: ADC Conversion Complete Interrupt Service Request
*****************************************************************************/
interrupt VectorNumber_Vadc0conv_compl void ADC0done_ISR(void)
{
	if(ADC0CONIF_CON_IF1 == 1){ /*Interrupts at end of sequence in order to trigger next sequence */
		ADC0CONIF_CON_IF1 = 1;      /* Clears Conversion 1 interrupt flag */
		ADC0FLWCTL_TRIG = 1;		/* Trigger next conversion */
	}
	if(ADC0CONIF_EOL_IF == 1 && ADC0CONIF_CON_IF2 == 1){ /*Interrupts after EOL and Conversion ready */
		ADC0CONIF_CON_IF2 = 1; /*Clears conversion 2 interrupt flag */
		ADC0CONIF_EOL_IF = 1; /*Clears EOL interrupt flag */
		pot_value = ADC0ResultList_0[1]; /*Stores pot value */
		ADC0FLWCTL |= 0x30; /*set RSTA and LDOK */
	}
	if(ADC0CONIF_CON_IF3 == 1){ /*Interrupts at end of sequence in order to trigger next sequence */
		ADC0CONIF_CON_IF3 = 1;		/*Clears conversion 3 interrupt flag */
		ADC0FLWCTL_TRIG = 1;		/* Trigger next conversion */
	}
	if(ADC0CONIF_EOL_IF == 1 && ADC0CONIF_CON_IF4 == 1){ /*Interrupts after EOL and Conversion ready */
		ADC0CONIF_CON_IF4 = 1; /*Clears conversion 4 interrupt flag */
		ADC0CONIF_EOL_IF =1; /*Clears EOL interrupt flag */
		ADC0_temperature = ADC0ResultList_1[3]; /*stores temperature sensor value */
		ADC0FLWCTL = 0x30; /*Set RSTA and LDOK */
	}

}
