/*******************************************************************************
 * Freescale Semiconductor Inc.
 * (c) Copyright 2013 Freescale Semiconductor, Inc.
 * ALL RIGHTS RESERVED.
 * 
 * This project performs a configuration for the ADC as
 * dual CSL and single RVL 
*******************************************************************************/
#include <hidef.h> /* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */

#include "S12ZVMEVB.h"
#include "freemaster.h"	/*-> Added FreeMaster library placeholder*/
/*-> MCLib library placeholder */

unsigned short pot_value = 0;
unsigned short ADCtemp = 0;

/*Command List 0 reads the pot value */
volatile char ADC0CommandList_0[4][4] @0x001000 = {
			{0xC1,0xD4,0x00,0x00},
			{0x00,0x00,0x00,0x00},
			{0x00,0x00,0x00,0x00},
			{0x00,0x00,0x00,0x00}
};

/*Command List 2 reads the temperature sensor */
volatile char ADC0CommandList_1[4][4] @0x001010 = {
			{0xC2,0xC8,0x00,0x00},
			{0x00,0x00,0x00,0x00},
			{0x00,0x00,0x00,0x00},
			{0x00,0x00,0x00,0x00}
};

volatile unsigned short ADC0ResultList[4] @ 0x001020 = {0, 0, 0, 0};



/*****************************************************************************
* Function: main
*****************************************************************************/
void main(void) {
	
	initCPMU();
	initGPIO();
	initADC();
	
	FMSTR_Init();
	EnableInterrupts;
	
	for(;;) {
		__RESET_WATCHDOG();	/* feeds the dog */
		
		FMSTR_Poll();
	
	} /* loop forever */
	/* please make sure that you never leave main */
	
}


/*****************************************************************************
*
* Function: void initCPMU(void)
*
* Description: Clock, Reset and Power Management Unit configuration
*              (External clock 4MHz, 25/12.5 MHz CPU/Bus clock)
*
*****************************************************************************/
void initCPMU(void)
{
	/* Wait for stable supply after power up */
	while (GDUF_GLVLSF)
		GDUF_GLVLSF = 1;

	CPMUREFDIV_REFDIV = CPMU_REFDIV;
	CPMUREFDIV_REFFRQ = CPMU_REFFRQ;
	CPMUSYNR_SYNDIV = CPMU_SYNDIV;
	CPMUSYNR_VCOFRQ = CPMU_VCOFRQ;
	CPMUPOSTDIV_POSTDIV = CPMU_POSTDIV;

	CPMUOSC_OSCE = 1;				/* Enable external oscillator */
	while (CPMUIFLG_UPOSC == 0) {}; /* Wait for oscillator to start up (UPOSC=1) and PLL to lock (LOCK=1) */
	while (CPMUIFLG_LOCK == 0) {};	/* Wait for PLL to lock */
	CPMURFLG  = 0x60; 				/* Clear PORF and LVRF */
	
}


/*****************************************************************************
*
* Function: void initGPIO(void)
*
* Description: I/O pins configuration
*
*****************************************************************************/
void initGPIO(void)
{
	MODRR0 = MODRR0_CONFIG;		/* Serial Port routing*/
	DDRS = DDRS_CONFIG;			/* User LEDs */
	DDRP = DDRP_CONFIG;			/* EVDD output */
	
	HALL_SUPPLY = 1;			/* Turn on the hall sensor supply (EVDD) */
	LED1 = 0;					/* Turn off LEDs by default */
	LED2 = 0;					/* Turn off LEDs by default */
	
	MODRR2 = MODRR2_CONFIG;		/* Serial Port routing*/
}


/*****************************************************************************
*
* Function: void initSCI(void)
*
* Description: SCI module configuration
*

/*****************************************************************************
*
* Function: void initADC(void)
*
* Description: ADC module configuration
*
*****************************************************************************/
void initADC(void){
	
	ADC0CTL_0_ACC_CFG = 3;	/* Dual access mode */
	ADC0CTL_0_MOD_CFG = 1;	/* Trigger mode */
	ADC0TIM = 3;			/* ADC clock = fbus / (2x(ADC0TIM + 1)) [0.25 - 8MHz] */
	
	ADC0FMT_DJM = 1;		/* Right justified result data */
	ADC0FMT_SRES = 4;		/* 12-bit resolution */
	
	ADC0CTL_1_CSL_BMOD = 1; /*Double Buffer CSL */
	ADC0CTL_1_RVL_BMOD = 0; /*Single Buffer RVL */
	
	ADC0CONIE_1_EOL_IE = 1;	/* End of list interrupt enable */
	ADC0CONIE_CON_IE1 = 1; /* Enable Interruption related to conversion 1 */
	ADC0CONIE_CON_IE2 = 1; /* Enable Interruption related to conversion 2 */
	
	/* ADC0 Command & Result Base Pointers */
	ADC0CBP = ADC0CommandList_0;
	ADC0RBP = ADC0ResultList;
	
	/* ADC0 Command/Result Offset registers */
	ADC0CROFF1 = 4; /*Offset between CSL lists */
	
	ADC0CTL_0_ADC_EN = 1;	/* Enable ADC0 */
	ADC0EIE = 0xEE;			/* Enable all errors interrupts */
	ADC0FLWCTL_RSTA = 1;	/* Issue a restart event */
	
	while (1 == ADC0FLWCTL_RSTA) ;	/* Wait until restart flag is cleared */
}


/*****************************************************************************
* Function: ADC Conversion Complete Interrupt Service Request
*****************************************************************************/
interrupt VectorNumber_Vadc0conv_compl void ADC0done_ISR(void)
{
	if(ADC0CONIF_CON_IF1 == 1 || ADC0CONIF_CON_IF2 == 1){ /* Interrupted if any of the conversions is done */
		ADC0CONIF_EOL_IF = 1; /*Clears EOL flag */
		if(ADC0STS_CSL_SEL == 0){ /* Check if the selected command list is the CSL_0 */
			ADC0CONIF_CON_IF1 =1; /* Clears conversion 1 flag */
			pot_value = ADC0ResultList[0]; /*stores the pot value */
		}
		else{ /*if CSL_1 */
			ADC0CONIF_CON_IF2 =1; /* clears conversion 2 flag */ 
			ADCtemp = ADC0ResultList[0]; /* stores temperature value */
		}
		ADC0FLWCTL |= 0x30; /* Set RSTA and LDOK simultaneusly in order to change list */
	}

}
