#include <hidef.h> /* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */



#define CPMU_REFDIV		3			/* fref = fosc / (REFDIV + 1) = 4MHz / 2 = 2MHz */
#define CPMU_REFFRQ 	0			/* 0 for reference clock frequency in range 1 to 2 MHz */
#define CPMU_SYNDIV		24			/* 24 for 100 MHz VCO output [fvco = 2 * fref * (SYNDIV + 1)] */
#define	CPMU_VCOFRQ		1			/* 3 for VCO output frequency in range 80 to 100 MHz */
#define	CPMU_POSTDIV	1		/* 0 for 100MHz PLL frequency (fpll = fvco / (POSTDIV + 1) */
									/* bus clock frequency is 50MHz */
#define TIM_PRS			2			/* TIM clock = fbus / 4 = 12.5 MHz */
#define PWM_MODULO		10000		/* PWM modulo for 20KHz PWM (fcore = 100MHz) fPWM = 100MHz / 20KHz = 5000 */
#define	SCI_BAUDRATE	5208		/* fbus = 50MHz, baud_rate = 9600 : fbus/baud_rate = 50MHz / 9600 = 5208.33 */  

#define MIN_DUTY		500
#define MAX_DUTY		(PWM_MODULO - MIN_DUTY)

#define	LED1	PTS_PTS4
#define	LED2	PTS_PTS5
#define BUTTON1	PTIP_PTIP1
#define BUTTON2	PTIP_PTIP2
#define SWITCH1 PTIT_PTIT1

/*Global variables */
unsigned int timerLastValue, timerDelta, time_ON, time_OFF, inputPeriod, targetDuty;

/* CMU Initialization */
void CMU_init(){
	while (GDUF_GLVLSF){
		GDUF_GLVLSF = 1;
	}
	CPMUHTTR_HTOE = 1;
	CPMUREFDIV_REFDIV = CPMU_REFDIV;
	CPMUREFDIV_REFFRQ = CPMU_REFFRQ;
	CPMUSYNR_SYNDIV = CPMU_SYNDIV;
	CPMUSYNR_VCOFRQ = CPMU_VCOFRQ;
	CPMUPOSTDIV_POSTDIV = CPMU_POSTDIV;
}

/* Clock Initialization */
void PLL_init(){
	CPMUOSC_OSCE = 1;
	while (CPMUIFLG_UPOSC == 0) {};
	while (CPMUIFLG_LOCK == 0) {};
	CPMURFLG  = 0x60;
}

/* Initialize LEDs for debugging */
void GPIO_init(){
	DDRS = 0x30;
	DDRP = 0x00;
	LED1 = 0;
	LED2 = 0;
}

/* Initialize serial communication */
void SCI_init(){
	SCI1BD = SCI_BAUDRATE;
	SCI1CR2_TE = 1;
	SCI1CR2_RE = 1;
}

/* Route port to internal timer */
void HV_init(){
	MODRR0 = (0x08 | 0x01);		/* Route LIN LPRXD to RXD0, LPTXD to Data Register */
	MODRR2_T0IC3RR = 1;
	//MODRR0 = (0x08 | 0x00);		/* Route LIN LPRXD to SCI0-RXD, LPTXD to SCI0-TXD */
}

/* Initialize the physical layer */
void LIN_init(){
	LP0SLRM_LPDTDIS = 1;		/* Disable TxD dominant time out */
	LP0CR_LPPUE = 1;			/* Enable 34Kohm pull-up */
	LP0CR_LPE = 1;				/* Enable LIN */
}

/* Initialize Timer */
void TIM_init(){
	TIM0TIOS_IOS3 = 0;		/* Channel 3 configured as an input capture */
	TIM0TCTL4 = 0x40;		/* Channel 3 input capture on rising edge */
	TIM0TIE_C3I = 1;		/* Channel 3 interrupt enabled */

	TIM0TSCR2_PR = TIM_PRS;
	TIM0TSCR1_TEN = 1;		/* Enable Timer counter */
}

void main(void) {
	CMU_init();
	PLL_init();
	GPIO_init();
	SCI_init();
	HV_init();
	LIN_init();
	TIM_init();
	EnableInterrupts;
	/* include your code here */

	for(;;) {
		__RESET_WATCHDOG();	/* feeds the dog */
		if(BUTTON1 == 0){
			LED1 = 1;
		}
		if(BUTTON2 == 0){
			LED1 = 0;
		}
	}
		
}


/* TIM channel 3 Interrupt */
interrupt VectorNumber_Vtim0ch3 void TIM_CH3_ISR(void){
	
	LED1 = LP0DR_LPDR0;
	timerDelta = TIM0TC3 - timerLastValue;
	timerLastValue = TIM0TC3;
	
	if (0x40 == TIM0TCTL4){
		TIM0TCTL4 = 0x80;	/* Change active Input Capture Edge */
		time_ON = timerDelta;
	} else {
		TIM0TCTL4 = 0x40;	/* Change active Input Capture Edge */
		time_OFF = timerDelta;
	}
	
	inputPeriod = time_ON + time_OFF;
	targetDuty = 100 - time_ON/(inputPeriod/100); /*Calculate duty cicle of incoming signal */
	TIM0TFLG1 = TIM0TFLG1_C3F_MASK;			/* Clear the flag */	
}
