#**************************************************************************/
#* FILE NAME: GHS_MPC56xx_FLASH.ld         COPYRIGHT (c) Freescale 2015   */
#*                                                All Rights Reserved     */
#* DESCRIPTION:                                                           */
#* Generic single core FLASH linker file to be used for MPC5746C devices  */
#=========================================================================*/
#*                                                                        */
#*========================================================================*/
#* REV             DATE              DESCRIPTION OF CHANGE                */
#* ---          ----------           ---------------------                */
#* 0.1          27/7/2015             Initial Version                    */
#**************************************************************************/

DEFAULTS
{
    /* Define Flash Size */
     FLASH_SIZE = 256K
    
    /* Define Flash Boot Address */
     FLASH_BASE_ADDR =  0x00fc0000

    /* Define SRAM Size */
    SRAM_SIZE =  100K

    /* Define SRAM Base Address */
    CORE0_SRAM_ADDR = 0x40000000
    
    /* Define Stack Size */  
    STACK_SIZE = 4K     
      
    /* Stack located at end of SRAM       */
}

MEMORY
{
    flash_rcw : org = FLASH_BASE_ADDR,   len = 0x20
    int_flash : org = FLASH_BASE_ADDR + 0x20, len = FLASH_SIZE-0x20
    int_sram  : org = CORE0_SRAM_ADDR,    len = (SRAM_SIZE-STACK_SIZE)
    stack_ram : org = (CORE0_SRAM_ADDR+SRAM_SIZE-STACK_SIZE), len = STACK_SIZE
}

SECTIONS
{
    .rcw              : {*(.rcw)}> flash_rcw
    .init	        :{*(.init)}> int_flash

    .text             : {} > .                	  /* BookE Code   */
    .vletext          : {} > .                	  /* VLE Code */

    .fixaddr          : {} > .            	  /* Required for         */
    .fixtype          : {} > .            	  /* compatibility with   */
    .secinfo          : {} > .            	  /* GHS provided startup */
    .syscall          : {} > .            	  /* code                 */
    .flash_data 	: {}>. 		
    .rodata  : {*(.rdata) *(.rodata)} > .  	  /* Read Only Data */

    .xcptn    ALIGN(0x10000)            : {} > .
    
    
    .ROM.data   ROM(.data)       : {} > .  	  /* Store Initialised RAM Variables */
    .ROM.sdata  ROM(.sdata)      : {} > .  	  /* temporarily in Flash            */
    
     

    .isrvectbl    ALIGN(0x1000)            : {} > int_sram
    .data             : {} >.       /* Initialised Data                */
    
    .hsm5cmdparams	  ALIGN(0x20)            : {} > .
    .sdata            : {} > .             	 /* Small Initialised Data (Area1)  */
    .bd		        ALIGN(16): {*(.bd)} > .
    .buf	        ALIGN(16): {*(.buf)} > .
    .array		ALIGN(16): {*(.array)} > .
    .bss              : {} > .             	 /* Uninitialised Data              */
    .sbss             : {} > .             	 /* Small Uninitialised Data (Area1)*/
    .sdata2           : {} > .             	 /* Small Initialised Constant Data */
    .sbss2            : {} > .             	 /* Small Uninitialised Data (Area2)*/

    .stack  ALIGN(4)  PAD(STACK_SIZE) : {} > stack_ram  /* Stack Area */
   
/*-------- LABELS USED IN CODE -------------------------------*/

/* Stack Address Parameters */
__SP_INIT      = ADDR(stack_ram) + SIZEOF(stack_ram)-8;
__SP_END         = ADDR(stack_ram);
__STACK_SIZE     = SIZEOF(stack_ram); 
/* Interrupt Handler Parameters */
__IV_ADDR = ADDR(.xcptn);

/* Labels for Copying Initialised Data from Flash to RAM */
__DATA_SRAM_ADDR  = ADDR(.data);
__SDATA_SRAM_ADDR = ADDR(.sdata);
__ISRVECTTBL_SRAM_ADDR  = ADDR(.isrvectbl);

/*__DATA_SIZE   = ((SIZEOF(.data) + SIZEOF(.sdata)));*/
__DATA_SIZE   = SIZEOF(.data);
__SDATA_SIZE  = SIZEOF(.sdata);
__ISRVECTTBL_SIZE  = SIZEOF(.isrvectbl);

__DATA_ROM_ADDR  = ADDR(.ROM.data);
__SDATA_ROM_ADDR = ADDR(.ROM.sdata);

/* Labels Used for Initialising SRAM ECC */
_SRAM_SIZE=SRAM_SIZE;
_CORE0_SRAM_ADDR = CORE0_SRAM_ADDR;

}
