/*-----------------------------------------------------------------------------
  Copyright (c) 2015 by Freescale Semiconductor, All Rights reserved.

  This is unpublished proprietary source code of Freescale.
  The copyright notice above does not imply any actual or
  intended publication of such source code.

  FREESCALE CONFIDENTIAL PROPRIETARY

  ---------------------------------------------------------------------------*/
/*-----------------------------------------------------------------------------
  FILE NAME      : hsm.h
  DEPARTMENT     : AISG
  AUTHOR         : Pradip Singh
  AUTHOR'S EMAIL : pradip.singh@freescale.com
  -----------------------------------------------------------------------------
  REVISION HISTORY
  AUTHOR       			 Date D/M/Y                DESCRIPTION              
  ---------------------- 	----------              --------------------- 
  Pradip Singh (b09147) 	 27/7/2015               Initial Version
  --------------------- 	 ----------             ---------------------
  KEYWORDS :HSM, Security
  -----------------------------------------------------------------------------
  PURPOSE :  Implements HSM to HOST register interface structure. For more
             details please refer to HSM security block guide.
  ---------------------------------------------------------------------------*/

#ifndef _HSM_H_
#define _HSM_H_

#include "typedefs.h"

/* struct HSM_tag */
struct HSM_tag {
    /* HSM to Host Flags register */
    union {                            
	vuint32_t R;
	struct {
	    vuint32_t  :30;
	    vuint32_t CMD_COMPLETE:1;    
	    vuint32_t HSM_RDY:1; 
	} B;
    } HSM2HTF;      			

    /* HSM to Host interrupt enable register */
    union {                            
	vuint32_t R;
	struct {
	    vuint32_t  :30;
	    vuint32_t CIE:1;    
	    vuint32_t :1; 
	} B;
    } HSM2HTIE;     		

    /* Host to HSM Flags register */
    union {                         
	vuint32_t R;
	struct {
	    vuint32_t :28;  
	    vuint32_t RESUME:1;      
	    vuint32_t SUSPEND:1;      
	    vuint32_t CMD_INT:1;
	    vuint32_t :1;             
	} B;
    } HT2HSMF;      			

    uint32_t HSM_reserved;

    /* HSM to Host status register */
    union {                         
	vuint32_t R;
	struct {
	    vuint32_t :23;  
	    vuint32_t EXECUTE:1;      
	    vuint32_t INT_DEBUGGER:1;      
	    vuint32_t EXT_DEBUGGER:1;
	    vuint32_t RAND_INIT:1; 
	    vuint32_t BOOT_OK:1;      
	    vuint32_t BOOT_FINISHED:1;      
	    vuint32_t BOOT_INIT:1;
	    vuint32_t SECURE_BOOT:1; 
	    vuint32_t BUSY:1;              
	} B;
    } HSM2HTS;      			

    /* Host to HSM status register */
    union {                         
	vuint32_t R;
	struct {
	    vuint32_t CMD_ADDR:32;       
	} B;
    } HT2HSMS;      			
};  					

#define HSM (*(volatile struct HSM_tag *) 0xFFF30000UL)

struct HSM_CMD_struct 
{
    /* Command parameter */
    uint32_t CMD;
    /* Input/output parameter1 */
    uint32_t PARAM_1;
    /* Input/output parameter2 */
    uint32_t PARAM_2;
    /* Input/output parameter3 */
    uint32_t PARAM_3;
    /* Input/output parameter4 */
    uint32_t PARAM_4;
    /* Input/output parameter5 */
    uint32_t PARAM_5;     		
};

#endif 					/* _HSM_H_ */
