/**************************************************************************
 * FILE NAME: MPC5746C.h                     COPYRIGHT (c) Freescale 2014 *
 * REVISION:  1.0.1                                   All Rights Reserved *
 *                                                                        *
 * DESCRIPTION:                                                           *
 * This file contains all of the register and bit field definitions for   *
 * the MPC5746C.                                                          *
 *========================================================================*
 * UPDATE HISTORY                                                         *
 * REV      AUTHOR      DATE       DESCRIPTION OF CHANGE                  *
 * ---   -----------  ---------    ---------------------                  *
 * 1.0      M.D.      28-FEB-14     -First release.                       *
 *                                                                        *
 * 1.0.1    M.D.      06-JUN-14     -Generated from updated RDP           *
 *                                                                        *
 *========================================================================*
 * COPYRIGHT:                                                             *
 *  Freescale Semiconductor, INC. All Rights Reserved. You are hereby     *
 *  granted a copyright license to use, modify, and distribute the        *
 *  SOFTWARE so long as this entire notice is retained without alteration *
 *  in any modified and/or redistributed versions, and that such modified *
 *  versions are clearly identified as such. No licenses are granted by   *
 *  implication, estoppel or otherwise under any patentsor trademarks     *
 *  of Freescale Semiconductor, Inc. This software is provided on an      *
 *  "AS IS" basis and without warranty.                                   *
 *                                                                        *
 *  To the maximum extent permitted by applicable law, Freescale          *
 *  Semiconductor DISCLAIMS ALL WARRANTIES WHETHER EXPRESS OR IMPLIED,    *
 *  INCLUDING IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A      *
 *  PARTICULAR PURPOSE AND ANY WARRANTY AGAINST INFRINGEMENT WITH REGARD  *
 *  TO THE SOFTWARE (INCLUDING ANY MODIFIED VERSIONS THEREOF) AND ANY     *
 *  ACCOMPANYING WRITTEN MATERIALS.                                       *
 *                                                                        *
 *  To the maximum extent permitted by applicable law, IN NO EVENT        *
 *  SHALL Freescale Semiconductor BE LIABLE FOR ANY DAMAGES WHATSOEVER    *
 *  (INCLUDING WITHOUT LIMITATION, DAMAGES FOR LOSS OF BUSINESS PROFITS,  *
 *  BUSINESS INTERRUPTION, LOSS OF BUSINESS INFORMATION, OR OTHER         *
 *  PECUNIARY LOSS) ARISING OF THE USE OR INABILITY TO USE THE SOFTWARE.  *
 *                                                                        *
 *  Freescale Semiconductor assumes no responsibility for the             *
 *  maintenance and support of this software                              *
 *                                                                        *
 **************************************************************************/
/*>>>>>>> NOTE! this file is auto-generated please do not edit it! <<<<<<<*/

/**************************************************************************
 * Example register & bit field write:                                    *
 *                                                                        *
 *  <MODULE>.<REGISTER>.B.<BIT> = 1;                                      *
 *  <MODULE>.<REGISTER>.R       = 0x10000000;                             *
 *                                                                        *
 **************************************************************************/

#ifndef _MPC5746C_H_
#define _MPC5746C_H_
#include "typedefs.h"
#ifdef __cplusplus
extern "C" {
#endif
#ifdef __MWERKS__
#pragma push
#pragma ANSI_strict off
#endif
#ifdef __ghs__
#pragma ghs nowarning 618
#endif


/* ============================================================================
   =============================== Module: ADC ================================
   ============================================================================ */

struct ADC_tag {
  union {                              /* Main Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t OWREN:1;               /* Overwrite enable. */
      vuint32_t WLSIDE:1;              /* Write Left/Right aligned. */
      vuint32_t MODE:1;                /* One_Shot/Scan. */
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t NSTART:1;
      vuint32_t  :1;
      vuint32_t JTRGEN:1;              /* Injection external trigger enable. */
      vuint32_t JEDGE:1;               /* Injection trigger edge selection. */
      vuint32_t JSTART:1;              /* Injection start. */
      vuint32_t  :2;
      vuint32_t CTUEN:1;               /* Crosstrigger Unit Enable. */
      vuint32_t CTU_MODE:1;            /* Crosstrigger Unit MODE bit */
      vuint32_t STCL:1;                /* Self Testing Configuration Lock. */
      vuint32_t  :6;
      vuint32_t ADCLKSEL:1;            /* Analog Clock frequency Selector. */
      vuint32_t ABORT_CHAIN:1;         /* Abort Chain. */
      vuint32_t ABORT:1;               /* Abort Conversion. */
      vuint32_t ACKO:1;                /* Auto clock off enable. */
      vuint32_t  :2;
      vuint32_t REFSEL:2;              /* Reference voltage selection for ADC analog part. */
      vuint32_t PWDN:1;                /* Power-down enable. */
    } B;
  } MCR;

  union {                              /* Main Status register */
    vuint32_t R;
    struct {
      vuint32_t CALIBRTD:1;            /* This bit indicates the ADC calibration status. */
      vuint32_t  :6;
      vuint32_t NSTART:1;              /* This status bit is used to signal that a Normal conversion is ongoing. */
      vuint32_t JABORT:1;
      vuint32_t  :2;
      vuint32_t JSTART:1;              /* This status bit is used to signal that an Injected conversion is ongoing. */
      vuint32_t  :1;
      vuint32_t SELF_TEST_S:1;         /* This status bit signals that self test conversion is ongoing. */
      vuint32_t  :1;
      vuint32_t CTUSTART:1;            /* This status bit is used to signal that a CTU conversion is ongoing. */
      vuint32_t CHADDR:7;              /* Channel under measure address. */
      vuint32_t  :3;
      vuint32_t ACKO:1;                /* Auto clock off enable. */
      vuint32_t  :2;
      vuint32_t ADCSTATUS:3;           /* Status of the ADC. */
    } B;
  } MSR;

  uint8_t ADC_reserved0[8];
  union {                              /* Interrupt Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :27;
      vuint32_t EOCTU:1;
      vuint32_t JEOC:1;                /* End of injected channel conversion. */
      vuint32_t JECH:1;                /* End of injected chain conversion. */
      vuint32_t EOC:1;                 /* End of channel conversion. */
      vuint32_t ECH:1;                 /* End of chain conversion. */
    } B;
  } ISR;

  union {                              /* Channel Pending register 0 */
    vuint32_t R;
    struct {
      vuint32_t EOCCH31:1;             /* EOC Channel 31. */
      vuint32_t EOCCH30:1;             /* EOC Channel 30. */
      vuint32_t EOCCH29:1;             /* EOC Channel 29. */
      vuint32_t EOCCH28:1;             /* EOC Channel 28. */
      vuint32_t EOCCH27:1;             /* EOC Channel 27. */
      vuint32_t EOCCH26:1;             /* EOC Channel 26. */
      vuint32_t EOCCH25:1;             /* EOC Channel 25. */
      vuint32_t EOCCH24:1;             /* EOC Channel 24. */
      vuint32_t EOCCH23:1;             /* EOC Channel 23. */
      vuint32_t EOCCH22:1;             /* EOC Channel 22. */
      vuint32_t EOCCH21:1;             /* EOC Channel 21. */
      vuint32_t EOCCH20:1;             /* EOC Channel 20. */
      vuint32_t EOCCH19:1;             /* EOC Channel 19. */
      vuint32_t EOCCH18:1;             /* EOC Channel 18. */
      vuint32_t EOCCH17:1;             /* EOC Channel 17. */
      vuint32_t EOCCH16:1;             /* EOC Channel 16. */
      vuint32_t EOCCH15:1;             /* EOC Channel 15. */
      vuint32_t EOCCH14:1;             /* EOC Channel 14. */
      vuint32_t EOCCH13:1;             /* EOC Channel 13. */
      vuint32_t EOCCH12:1;             /* EOC Channel 12. */
      vuint32_t EOCCH11:1;             /* EOC Channel 11. */
      vuint32_t EOCCH10:1;             /* EOC Channel 10. */
      vuint32_t EOCCH9:1;              /* EOC Channel 9. */
      vuint32_t EOCCH8:1;              /* EOC Channel 8. */
      vuint32_t EOCCH7:1;              /* EOC Channel 7. */
      vuint32_t EOCCH6:1;              /* EOC Channel 6. */
      vuint32_t EOCCH5:1;              /* EOC Channel 5. */
      vuint32_t EOCCH4:1;              /* EOC Channel 4. */
      vuint32_t EOCCH3:1;              /* EOC Channel 3. */
      vuint32_t EOCCH2:1;              /* EOC Channel 2. */
      vuint32_t EOCCH1:1;              /* EOC Channel 1. */
      vuint32_t EOCCH0:1;              /* EOC Channel 0. */
    } B;
  } CEOCFR0;

  union {                              /* Channel Pending register 1 */
    vuint32_t R;
    struct {
      vuint32_t EOCCH63:1;             /* EOC Channel 63. */
      vuint32_t EOCCH62:1;             /* EOC Channel 62. */
      vuint32_t EOCCH61:1;             /* EOC Channel 61. */
      vuint32_t EOCCH60:1;             /* EOC Channel 60. */
      vuint32_t EOCCH59:1;             /* EOC Channel 59. */
      vuint32_t EOCCH58:1;             /* EOC Channel 58. */
      vuint32_t EOCCH57:1;             /* EOC Channel 57. */
      vuint32_t EOCCH56:1;             /* EOC Channel 56. */
      vuint32_t EOCCH55:1;             /* EOC Channel 55. */
      vuint32_t EOCCH54:1;             /* EOC Channel 54. */
      vuint32_t EOCCH53:1;             /* EOC Channel 53. */
      vuint32_t EOCCH52:1;             /* EOC Channel 52. */
      vuint32_t EOCCH51:1;             /* EOC Channel 51. */
      vuint32_t EOCCH50:1;             /* EOC Channel 50. */
      vuint32_t EOCCH49:1;             /* EOC Channel 49. */
      vuint32_t EOCCH48:1;             /* EOC Channel 48 */
      vuint32_t EOCCH47:1;             /* EOC Channel 47. */
      vuint32_t EOCCH46:1;             /* EOC Channel 46. */
      vuint32_t EOCCH45:1;             /* EOC Channel 45. */
      vuint32_t EOCCH44:1;             /* EOC Channel 44. */
      vuint32_t EOCCH43:1;             /* EOC Channel 43. */
      vuint32_t EOCCH42:1;             /* EOC Channel 42. */
      vuint32_t EOCCH41:1;             /* EOC Channel 41. */
      vuint32_t EOCCH40:1;             /* EOC Channel 40. */
      vuint32_t EOCCH39:1;             /* EOC Channel 39. */
      vuint32_t EOCCH38:1;             /* EOC Channel 38. */
      vuint32_t EOCCH37:1;             /* EOC Channel 37. */
      vuint32_t EOCCH36:1;             /* EOC Channel 36. */
      vuint32_t EOCCH35:1;             /* EOC Channel 35. */
      vuint32_t EOCCH34:1;             /* EOC Channel 34. */
      vuint32_t EOCCH33:1;             /* EOC Channel 33. */
      vuint32_t EOCCH32:1;             /* EOC Channel 32. */
    } B;
  } CEOCFR1;

  union {                              /* Channel Pending register 2 */
    vuint32_t R;
    struct {
      vuint32_t EOCCH95:1;             /* EOC Channel 95. */
      vuint32_t EOCCH94:1;             /* EOC Channel 94. */
      vuint32_t EOCCH93:1;             /* EOC Channel 93. */
      vuint32_t EOCCH92:1;             /* EOC Channel 92. */
      vuint32_t EOCCH91:1;             /* EOC Channel 91. */
      vuint32_t EOCCH90:1;             /* EOC Channel 90. */
      vuint32_t EOCCH89:1;             /* EOC Channel 89. */
      vuint32_t EOCCH88:1;             /* EOC Channel 88. */
      vuint32_t EOCCH87:1;             /* EOC Channel 87. */
      vuint32_t EOCCH86:1;             /* EOC Channel 86. */
      vuint32_t EOCCH85:1;             /* EOC Channel 85. */
      vuint32_t EOCCH84:1;             /* EOC Channel 84. */
      vuint32_t EOCCH83:1;             /* EOC Channel 83. */
      vuint32_t EOCCH82:1;             /* EOC Channel 82. */
      vuint32_t EOCCH81:1;             /* EOC Channel 81. */
      vuint32_t EOCCH80:1;             /* EOC Channel 80. */
      vuint32_t EOCCH79:1;             /* EOC Channel 79. */
      vuint32_t EOCCH78:1;             /* EOC Channel 78. */
      vuint32_t EOCCH77:1;             /* EOC Channel 77. */
      vuint32_t EOCCH76:1;             /* EOC Channel 76. */
      vuint32_t EOCCH75:1;             /* EOC Channel 75. */
      vuint32_t EOCCH74:1;             /* EOC Channel 74. */
      vuint32_t EOCCH73:1;             /* EOC Channel 73. */
      vuint32_t EOCCH72:1;             /* EOC Channel 72. */
      vuint32_t EOCCH71:1;             /* EOC Channel 71. */
      vuint32_t EOCCH70:1;             /* EOC Channel 70. */
      vuint32_t EOCCH69:1;             /* EOC Channel 69. */
      vuint32_t EOCCH68:1;             /* EOC Channel 68. */
      vuint32_t EOCCH67:1;             /* EOC Channel 67. */
      vuint32_t EOCCH66:1;             /* EOC Channel 66. */
      vuint32_t EOCCH65:1;             /* EOC Channel 65. */
      vuint32_t EOCCH64:1;             /* EOC Channel 64. */
    } B;
  } CEOCFR2;

  union {                              /* Interrupt Mask Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t  :1;
      vuint32_t  :10;
      vuint32_t MSKEOCTU:1;            /* Mask bit for EOCTU. */
      vuint32_t MSKJEOC:1;             /* Mask bit for JEOC. */
      vuint32_t MSKJECH:1;             /* Mask bit for JECH. */
      vuint32_t MSKEOC:1;              /* Mask bit for EOC. */
      vuint32_t MSKECH:1;              /* Mask bit for ECH. */
    } B;
  } IMR;

  union {                              /* Channel Interrupt Mask Register 0 */
    vuint32_t R;
    struct {
      vuint32_t CIM31:1;               /* Channel 31 interrupt enable. */
      vuint32_t CIM30:1;               /* Channel 30 interrupt enable. */
      vuint32_t CIM29:1;               /* Channel 29 interrupt enable. */
      vuint32_t CIM28:1;               /* Channel 28 interrupt enable. */
      vuint32_t CIM27:1;               /* Channel 27 interrupt enable. */
      vuint32_t CIM26:1;               /* Channel 26 interrupt enable. */
      vuint32_t CIM25:1;               /* Channel 25 interrupt enable. */
      vuint32_t CIM24:1;               /* Channel 24 interrupt enable. */
      vuint32_t CIM23:1;               /* Channel 23 interrupt enable. */
      vuint32_t CIM22:1;               /* Channel 22 interrupt enable. */
      vuint32_t CIM21:1;               /* Channel 21 interrupt enable. */
      vuint32_t CIM20:1;               /* Channel 20 interrupt enable. */
      vuint32_t CIM19:1;               /* Channel 19 interrupt enable. */
      vuint32_t CIM18:1;               /* Channel 18 interrupt enable. */
      vuint32_t CIM17:1;               /* Channel 17 interrupt enable. */
      vuint32_t CIM16:1;               /* Channel 16 interrupt enable. */
      vuint32_t CIM15:1;               /* Channel 15 interrupt enable. */
      vuint32_t CIM14:1;               /* Channel 14 interrupt enable. */
      vuint32_t CIM13:1;               /* Channel 13 interrupt enable. */
      vuint32_t CIM12:1;               /* Channel 12 interrupt enable. */
      vuint32_t CIM11:1;               /* Channel 11 interrupt enable. */
      vuint32_t CIM10:1;               /* Channel 10 interrupt enable. */
      vuint32_t CIM9:1;                /* Channel 9 interrupt enable. */
      vuint32_t CIM8:1;                /* Channel 8 interrupt enable. */
      vuint32_t CIM7:1;                /* Channel 7 interrupt enable. */
      vuint32_t CIM6:1;                /* Channel 6 interrupt enable. */
      vuint32_t CIM5:1;                /* Channel 5 interrupt enable. */
      vuint32_t CIM4:1;                /* Channel 4 interrupt enable. */
      vuint32_t CIM3:1;                /* Channel 3 interrupt enable. */
      vuint32_t CIM2:1;                /* Channel 2 interrupt enable. */
      vuint32_t CIM1:1;                /* Channel 1 interrupt enable. */
      vuint32_t CIM0:1;                /* Channel 0 interrupt enable. */
    } B;
  } CIMR0;

  union {                              /* Channel Interrupt Mask Register 1 */
    vuint32_t R;
    struct {
      vuint32_t CIM63:1;               /* Channel 63 interrupt enable. */
      vuint32_t CIM62:1;               /* Channel 62 interrupt enable. */
      vuint32_t CIM61:1;               /* Channel 61 interrupt enable. */
      vuint32_t CIM60:1;               /* Channel 60 interrupt enable. */
      vuint32_t CIM59:1;               /* Channel 59 interrupt enable. */
      vuint32_t CIM58:1;               /* Channel 58 interrupt enable. */
      vuint32_t CIM57:1;               /* Channel 57 interrupt enable. */
      vuint32_t CIM56:1;               /* Channel 56 interrupt enable. */
      vuint32_t CIM55:1;               /* Channel 55 interrupt enable. */
      vuint32_t CIM54:1;               /* Channel 54 interrupt enable. */
      vuint32_t CIM53:1;               /* Channel 53 interrupt enable. */
      vuint32_t CIM52:1;               /* Channel 52 interrupt enable. */
      vuint32_t CIM51:1;               /* Channel 51 interrupt enable. */
      vuint32_t CIM50:1;               /* Channel 50 interrupt enable. */
      vuint32_t CIM49:1;               /* Channel 49 interrupt enable. */
      vuint32_t CIM48:1;               /* Channel 48 interrupt enable. */
      vuint32_t CIM47:1;               /* Channel 47 interrupt enable. */
      vuint32_t CIM46:1;               /* Channel 46 interrupt enable. */
      vuint32_t CIM45:1;               /* Channel 45 interrupt enable. */
      vuint32_t CIM44:1;               /* Channel 44 interrupt enable. */
      vuint32_t CIM43:1;               /* Channel 43 interrupt enable. */
      vuint32_t CIM42:1;               /* Channel 42 interrupt enable. */
      vuint32_t CIM41:1;               /* Channel 41 interrupt enable. */
      vuint32_t CIM40:1;               /* Channel 40 interrupt enable. */
      vuint32_t CIM39:1;               /* Channel 39 interrupt enable. */
      vuint32_t CIM38:1;               /* Channel 38 interrupt enable. */
      vuint32_t CIM37:1;               /* Channel 37 interrupt enable. */
      vuint32_t CIM36:1;               /* Channel 36 interrupt enable. */
      vuint32_t CIM35:1;               /* Channel 35 interrupt enable. */
      vuint32_t CIM34:1;               /* Channel 34 interrupt enable. */
      vuint32_t CIM33:1;               /* Channel 33 interrupt enable. */
      vuint32_t CIM32:1;               /* Channel 32 interrupt enable. */
    } B;
  } CIMR1;

  union {                              /* Channel Interrupt Mask Register 2 */
    vuint32_t R;
    struct {
      vuint32_t CIM95:1;               /* Channel 95 interrupt enable. */
      vuint32_t CIM94:1;               /* Channel 94 interrupt enable. */
      vuint32_t CIM93:1;               /* Channel 93 interrupt enable. */
      vuint32_t CIM92:1;               /* Channel 92 interrupt enable. */
      vuint32_t CIM91:1;               /* Channel 91 interrupt enable. */
      vuint32_t CIM90:1;               /* Channel 90 interrupt enable. */
      vuint32_t CIM89:1;               /* Channel 89 interrupt enable. */
      vuint32_t CIM88:1;               /* Channel 88 interrupt enable. */
      vuint32_t CIM87:1;               /* Channel 87 interrupt enable. */
      vuint32_t CIM86:1;               /* Channel 86 interrupt enable. */
      vuint32_t CIM85:1;               /* Channel 85 interrupt enable. */
      vuint32_t CIM84:1;               /* Channel 84 interrupt enable. */
      vuint32_t CIM83:1;               /* Channel 83 interrupt enable. */
      vuint32_t CIM82:1;               /* Channel 82 interrupt enable. */
      vuint32_t CIM81:1;               /* Channel 81 interrupt enable. */
      vuint32_t CIM80:1;               /* Channel 80 interrupt enable. */
      vuint32_t CIM79:1;               /* Channel 79 interrupt enable. */
      vuint32_t CIM78:1;               /* Channel 78 interrupt enable. */
      vuint32_t CIM77:1;               /* Channel 77 interrupt enable. */
      vuint32_t CIM76:1;               /* Channel 76 interrupt enable. */
      vuint32_t CIM75:1;               /* Channel 75 interrupt enable. */
      vuint32_t CIM74:1;               /* Channel 74 interrupt enable. */
      vuint32_t CIM73:1;               /* Channel 73 interrupt enable. */
      vuint32_t CIM72:1;               /* Channel 72 interrupt enable. */
      vuint32_t CIM71:1;               /* Channel 71 interrupt enable. */
      vuint32_t CIM70:1;               /* Channel 70 interrupt enable. */
      vuint32_t CIM69:1;               /* Channel 69 interrupt enable. */
      vuint32_t CIM68:1;               /* Channel 68 interrupt enable. */
      vuint32_t CIM67:1;               /* Channel 67 interrupt enable. */
      vuint32_t CIM66:1;               /* Channel 66 interrupt enable. */
      vuint32_t CIM65:1;               /* Channel 65 interrupt enable. */
      vuint32_t CIM64:1;               /* Channel 64 interrupt enable. */
    } B;
  } CIMR2;

  union {                              /* Watchdog Threshold Interrupt Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :20;
      vuint32_t WDG5H:1;
      vuint32_t WDG5L:1;
      vuint32_t WDG4H:1;
      vuint32_t WDG4L:1;
      vuint32_t WDG3H:1;
      vuint32_t WDG3L:1;
      vuint32_t WDG2H:1;
      vuint32_t WDG2L:1;
      vuint32_t WDG1H:1;
      vuint32_t WDG1L:1;
      vuint32_t WDG0H:1;
      vuint32_t WDG0L:1;
    } B;
  } WTISR;

  union {                              /* Watchdog Threshold Interrupt Mask Register */
    vuint32_t R;
    struct {
      vuint32_t  :20;
      vuint32_t MSKWDG5H:1;
      vuint32_t MSKWDG5L:1;
      vuint32_t MSKWDG4H:1;
      vuint32_t MSKWDG4L:1;
      vuint32_t MSKWDG3H:1;
      vuint32_t MSKWDG3L:1;
      vuint32_t MSKWDG2H:1;
      vuint32_t MSKWDG2L:1;
      vuint32_t MSKWDG1H:1;
      vuint32_t MSKWDG1L:1;
      vuint32_t MSKWDG0H:1;
      vuint32_t MSKWDG0L:1;
    } B;
  } WTIMR;

  uint8_t ADC_reserved1[8];
  union {                              /* DMA Enable register */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t DCLR:1;                /* DMA Clear sequence enable. */
      vuint32_t DMAEN:1;               /* DMA global enable. */
    } B;
  } DMAE;

  union {                              /* DMA Channel Select Register 0 */
    vuint32_t R;
    struct {
      vuint32_t DMA31:1;               /* DMA enable for channel 31. */
      vuint32_t DMA30:1;               /* DMA enable for channel 30. */
      vuint32_t DMA29:1;               /* DMA enable for channel 29. */
      vuint32_t DMA28:1;               /* DMA enable for channel 28. */
      vuint32_t DMA27:1;               /* DMA enable for channel 27. */
      vuint32_t DMA26:1;               /* DMA enable for channel 26. */
      vuint32_t DMA25:1;               /* DMA enable for channel 25. */
      vuint32_t DMA24:1;               /* DMA enable for channel 24. */
      vuint32_t DMA23:1;               /* DMA enable for channel 23. */
      vuint32_t DMA22:1;               /* DMA enable for channel 22. */
      vuint32_t DMA21:1;               /* DMA enable for channel 21. */
      vuint32_t DMA20:1;               /* DMA enable for channel 20. */
      vuint32_t DMA19:1;               /* DMA enable for channel 19. */
      vuint32_t DMA18:1;               /* DMA enable for channel 18. */
      vuint32_t DMA17:1;               /* DMA enable for channel 17. */
      vuint32_t DMA16:1;               /* DMA enable for channel 16. */
      vuint32_t DMA15:1;               /* DMA enable for channel 15. */
      vuint32_t DMA14:1;               /* DMA enable for channel 14. */
      vuint32_t DMA13:1;               /* DMA enable for channel 13. */
      vuint32_t DMA12:1;               /* DMA enable for channel 12. */
      vuint32_t DMA11:1;               /* DMA enable for channel 11. */
      vuint32_t DMA10:1;               /* DMA enable for channel 10. */
      vuint32_t DMA9:1;                /* DMA enable for channel 9. */
      vuint32_t DMA8:1;                /* DMA enable for channel 8. */
      vuint32_t DMA7:1;                /* DMA enable for channel 7. */
      vuint32_t DMA6:1;                /* DMA enable for channel 6. */
      vuint32_t DMA5:1;                /* DMA enable for channel 5. */
      vuint32_t DMA4:1;                /* DMA enable for channel 4. */
      vuint32_t DMA3:1;                /* DMA enable for channel 3. */
      vuint32_t DMA2:1;                /* DMA enable for channel 2. */
      vuint32_t DMA1:1;                /* DMA enable for channel 1. */
      vuint32_t DMA0:1;                /* DMA enable for channel 0. */
    } B;
  } DMAR0;

  union {                              /* DMA Channel Select Register 1 */
    vuint32_t R;
    struct {
      vuint32_t DMA63:1;               /* DMA enable for channel 63. */
      vuint32_t DMA62:1;               /* DMA enable for channel 62. */
      vuint32_t DMA61:1;               /* DMA enable for channel 61. */
      vuint32_t DMA60:1;               /* DMA enable for channel 60. */
      vuint32_t DMA59:1;               /* DMA enable for channel 59. */
      vuint32_t DMA58:1;               /* DMA enable for channel 58. */
      vuint32_t DMA57:1;               /* DMA enable for channel 57. */
      vuint32_t DMA56:1;               /* DMA enable for channel 56. */
      vuint32_t DMA55:1;               /* DMA enable for channel 55. */
      vuint32_t DMA54:1;               /* DMA enable for channel 54. */
      vuint32_t DMA53:1;               /* DMA enable for channel 53. */
      vuint32_t DMA52:1;               /* DMA enable for channel 52. */
      vuint32_t DMA51:1;               /* DMA enable for channel 51. */
      vuint32_t DMA50:1;               /* DMA enable for channel 50. */
      vuint32_t DMA49:1;               /* DMA enable for channel 49. */
      vuint32_t DMA48:1;               /* DMA enable for channel 48. */
      vuint32_t DMA47:1;               /* DMA enable for channel 47. */
      vuint32_t DMA46:1;               /* DMA enable for channel 46. */
      vuint32_t DMA45:1;               /* DMA enable for channel 45. */
      vuint32_t DMA44:1;               /* DMA enable for channel 44. */
      vuint32_t DMA43:1;               /* DMA enable for channel 43. */
      vuint32_t DMA42:1;               /* DMA enable for channel 42. */
      vuint32_t DMA41:1;               /* DMA enable for channel 41. */
      vuint32_t DMA40:1;               /* DMA enable for channel 40. */
      vuint32_t DMA39:1;               /* DMA enable for channel 39. */
      vuint32_t DMA38:1;               /* DMA enable for channel 38. */
      vuint32_t DMA37:1;               /* DMA enable for channel 37. */
      vuint32_t DMA36:1;               /* DMA enable for channel 36. */
      vuint32_t DMA35:1;               /* DMA enable for channel 35. */
      vuint32_t DMA34:1;               /* DMA enable for channel 34. */
      vuint32_t DMA33:1;               /* DMA enable for channel 33. */
      vuint32_t DMA32:1;               /* DMA enable for channel 32. */
    } B;
  } DMAR1;

  union {                              /* DMA Channel Select Register 2 */
    vuint32_t R;
    struct {
      vuint32_t DMA95:1;               /* DMA enable for channel 95. */
      vuint32_t DMA94:1;               /* DMA enable for channel 94. */
      vuint32_t DMA93:1;               /* DMA enable for channel 93. */
      vuint32_t DMA92:1;               /* DMA enable for channel 92. */
      vuint32_t DMA91:1;               /* DMA enable for channel 91. */
      vuint32_t DMA90:1;               /* DMA enable for channel 90. */
      vuint32_t DMA89:1;               /* DMA enable for channel 89. */
      vuint32_t DMA88:1;               /* DMA enable for channel 88. */
      vuint32_t DMA87:1;               /* DMA enable for channel 87. */
      vuint32_t DMA86:1;               /* DMA enable for channel 86. */
      vuint32_t DMA85:1;               /* DMA enable for channel 85. */
      vuint32_t DMA84:1;               /* DMA enable for channel 84. */
      vuint32_t DMA83:1;               /* DMA enable for channel 83. */
      vuint32_t DMA82:1;               /* DMA enable for channel 82. */
      vuint32_t DMA81:1;               /* DMA enable for channel 81. */
      vuint32_t DMA80:1;               /* DMA enable for channel 80. */
      vuint32_t DMA79:1;               /* DMA enable for channel 79. */
      vuint32_t DMA78:1;               /* DMA enable for channel 78. */
      vuint32_t DMA77:1;               /* DMA enable for channel 77. */
      vuint32_t DMA76:1;               /* DMA enable for channel 76. */
      vuint32_t DMA75:1;               /* DMA enable for channel 75. */
      vuint32_t DMA74:1;               /* DMA enable for channel 74. */
      vuint32_t DMA73:1;               /* DMA enable for channel 73. */
      vuint32_t DMA72:1;               /* DMA enable for channel 72. */
      vuint32_t DMA71:1;               /* DMA enable for channel 71. */
      vuint32_t DMA70:1;               /* DMA enable for channel 70. */
      vuint32_t DMA69:1;               /* DMA enable for channel 69. */
      vuint32_t DMA68:1;               /* DMA enable for channel 68. */
      vuint32_t DMA67:1;               /* DMA enable for channel 67. */
      vuint32_t DMA66:1;               /* DMA enable for channel 66. */
      vuint32_t DMA65:1;               /* DMA enable for channel 65. */
      vuint32_t DMA64:1;               /* DMA enable for channel 64. */
    } B;
  } DMAR2;

  uint8_t ADC_reserved2[16];
  union {                              /* Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t THRH:12;               /* High threshold value for watchdog n. */
      vuint32_t  :4;
      vuint32_t THRL:12;               /* Low threshold value for watchdog n. */
    } B;
  } THRHLR0;

  union {                              /* Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t THRH:12;               /* High threshold value for watchdog n. */
      vuint32_t  :4;
      vuint32_t THRL:12;               /* Low threshold value for watchdog n. */
    } B;
  } THRHLR1;

  union {                              /* Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t THRH:12;               /* High threshold value for watchdog n. */
      vuint32_t  :4;
      vuint32_t THRL:12;               /* Low threshold value for watchdog n. */
    } B;
  } THRHLR2;

  union {                              /* Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t THRH:12;               /* High threshold value for watchdog n. */
      vuint32_t  :4;
      vuint32_t THRL:12;               /* Low threshold value for watchdog n. */
    } B;
  } THRHLR3;

  uint8_t ADC_reserved3[16];
  union {                              /* Presampling Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :25;
      vuint32_t PREVAL2:2;             /* Internal voltage selection for Presampling */
      vuint32_t PREVAL1:2;             /* Internal voltage selection for Presampling. */
      vuint32_t PREVAL0:2;             /* Internal voltage selection for Presampling. */
      vuint32_t PRECONV:1;             /* Convert Presampled value */
    } B;
  } PSCR;

  union {                              /* Presampling register 0 */
    vuint32_t R;
    struct {
      vuint32_t PRES31:1;              /* Presampling enable for channel 31. */
      vuint32_t PRES30:1;              /* Presampling enable for channel 30. */
      vuint32_t PRES29:1;              /* Presampling enable for channel 29. */
      vuint32_t PRES28:1;              /* Presampling enable for channel 28. */
      vuint32_t PRES27:1;              /* Presampling enable for channel 27. */
      vuint32_t PRES26:1;              /* Presampling enable for channel 26. */
      vuint32_t PRES25:1;              /* Presampling enable for channel 25. */
      vuint32_t PRES24:1;              /* Presampling enable for channel 24. */
      vuint32_t PRES23:1;              /* Presampling enable for channel 23. */
      vuint32_t PRES22:1;              /* Presampling enable for channel 22. */
      vuint32_t PRES21:1;              /* Presampling enable for channel 21. */
      vuint32_t PRES20:1;              /* Presampling enable for channel 20. */
      vuint32_t PRES19:1;              /* Presampling enable for channel 19. */
      vuint32_t PRES18:1;              /* Presampling enable for channel 18. */
      vuint32_t PRES17:1;              /* Presampling enable for channel 17. */
      vuint32_t PRES16:1;              /* Presampling enable for channel 16. */
      vuint32_t PRES15:1;              /* Presampling enable for channel 15. */
      vuint32_t PRES14:1;              /* Presampling enable for channel 14. */
      vuint32_t PRES13:1;              /* Presampling enable for channel 13. */
      vuint32_t PRES12:1;              /* Presampling enable for channel 12. */
      vuint32_t PRES11:1;              /* Presampling enable for channel 11. */
      vuint32_t PRES10:1;              /* Presampling enable for channel 10. */
      vuint32_t PRES9:1;               /* Presampling enable for channel 9. */
      vuint32_t PRES8:1;               /* Presampling enable for channel 8. */
      vuint32_t PRES7:1;               /* Presampling enable for channel 7. */
      vuint32_t PRES6:1;               /* Presampling enable for channel 6. */
      vuint32_t PRES5:1;               /* Presampling enable for channel 5. */
      vuint32_t PRES4:1;               /* Presampling enable for channel 4. */
      vuint32_t PRES3:1;               /* Presampling enable for channel 3. */
      vuint32_t PRES2:1;               /* Presampling enable for channel 2. */
      vuint32_t PRES1:1;               /* Presampling enable for channel 1. */
      vuint32_t PRES0:1;               /* Presampling enable for channel 0. */
    } B;
  } PSR0;

  union {                              /* Presampling register 1 */
    vuint32_t R;
    struct {
      vuint32_t PRES63:1;              /* Presampling enable for channel 63. */
      vuint32_t PRES62:1;              /* Presampling enable for channel 62. */
      vuint32_t PRES61:1;              /* Presampling enable for channel 61. */
      vuint32_t PRES60:1;              /* Presampling enable for channel 60. */
      vuint32_t PRES59:1;              /* Presampling enable for channel 59. */
      vuint32_t PRES58:1;              /* Presampling enable for channel 58. */
      vuint32_t PRES57:1;              /* Presampling enable for channel 57. */
      vuint32_t PRES56:1;              /* Presampling enable for channel 56. */
      vuint32_t PRES55:1;              /* Presampling enable for channel 55. */
      vuint32_t PRES54:1;              /* Presampling enable for channel 54. */
      vuint32_t PRES53:1;              /* Presampling enable for channel 53. */
      vuint32_t PRES52:1;              /* Presampling enable for channel 52. */
      vuint32_t PRES51:1;              /* Presampling enable for channel 51. */
      vuint32_t PRES50:1;              /* Presampling enable for channel 50. */
      vuint32_t PRES49:1;              /* Presampling enable for channel 49. */
      vuint32_t PRES48:1;              /* Presampling enable for channel 48. */
      vuint32_t PRES47:1;              /* Presampling enable for channel 47. */
      vuint32_t PRES46:1;              /* Presampling enable for channel 46. */
      vuint32_t PRES45:1;              /* Presampling enable for channel 45. */
      vuint32_t PRES44:1;              /* Presampling enable for channel 44. */
      vuint32_t PRES43:1;              /* Presampling enable for channel 43. */
      vuint32_t PRES42:1;              /* Presampling enable for channel 42. */
      vuint32_t PRES41:1;              /* Presampling enable for channel 41. */
      vuint32_t PRES40:1;              /* Presampling enable for channel 40. */
      vuint32_t PRES39:1;              /* Presampling enable for channel 39. */
      vuint32_t PRES38:1;              /* Presampling enable for channel 38. */
      vuint32_t PRES37:1;              /* Presampling enable for channel 37. */
      vuint32_t PRES36:1;              /* Presampling enable for channel 36. */
      vuint32_t PRES35:1;              /* Presampling enable for channel 35. */
      vuint32_t PRES34:1;              /* Presampling enable for channel 34. */
      vuint32_t PRES33:1;              /* Presampling enable for channel 33. */
      vuint32_t PRES32:1;              /* Presampling enable for channel 32. */
    } B;
  } PSR1;

  union {                              /* Presampling register 2 */
    vuint32_t R;
    struct {
      vuint32_t PRES95:1;              /* Presampling enable for channel 95. */
      vuint32_t PRES94:1;              /* Presampling enable for channel 94. */
      vuint32_t PRES93:1;              /* Presampling enable for channel 93. */
      vuint32_t PRES92:1;              /* Presampling enable for channel 92. */
      vuint32_t PRES91:1;              /* Presampling enable for channel 91. */
      vuint32_t PRES90:1;              /* Presampling enable for channel 90. */
      vuint32_t PRES89:1;              /* Presampling enable for channel 89. */
      vuint32_t PRES88:1;              /* Presampling enable for channel 88. */
      vuint32_t PRES87:1;              /* Presampling enable for channel 87. */
      vuint32_t PRES86:1;              /* Presampling enable for channel 86. */
      vuint32_t PRES85:1;              /* Presampling enable for channel 85. */
      vuint32_t PRES84:1;              /* Presampling enable for channel 84. */
      vuint32_t PRES83:1;              /* Presampling enable for channel 83. */
      vuint32_t PRES82:1;              /* Presampling enable for channel 82. */
      vuint32_t PRES81:1;              /* Presampling enable for channel 81. */
      vuint32_t PRES80:1;              /* Presampling enable for channel 80. */
      vuint32_t PRES79:1;              /* Presampling enable for channel 79. */
      vuint32_t PRES78:1;              /* Presampling enable for channel 78. */
      vuint32_t PRES77:1;              /* Presampling enable for channel 77. */
      vuint32_t PRES76:1;              /* Presampling enable for channel 76. */
      vuint32_t PRES75:1;              /* Presampling enable for channel 75. */
      vuint32_t PRES74:1;              /* Presampling enable for channel 74. */
      vuint32_t PRES73:1;              /* Presampling enable for channel 73. */
      vuint32_t PRES72:1;              /* Presampling enable for channel 72. */
      vuint32_t PRES71:1;              /* Presampling enable for channel 71. */
      vuint32_t PRES70:1;              /* Presampling enable for channel 70. */
      vuint32_t PRES69:1;              /* Presampling enable for channel 69. */
      vuint32_t PRES68:1;              /* Presampling enable for channel 68. */
      vuint32_t PRES67:1;              /* Presampling enable for channel 67. */
      vuint32_t PRES66:1;              /* Presampling enable for channel 66. */
      vuint32_t PRES65:1;              /* Presampling enable for channel 65. */
      vuint32_t PRES64:1;              /* Presampling enable for channel 64. */
    } B;
  } PSR2;

  uint8_t ADC_reserved4[4];
  union {                              /* Conversion Timing Register 0 */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t  :2;
      vuint32_t  :1;
      vuint32_t  :2;
      vuint32_t  :1;
      vuint32_t INPSAMP:8;             /* Configuration of sampling phase duration. */
    } B;
  } CTR0;

  union {                              /* Conversion Timing Register 1 */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t INPSAMP:8;             /* Configuration of sampling phase duration. */
    } B;
  } CTR1;

  union {                              /* Conversion Timing Register 2 */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t INPSAMP:8;             /* Configuration of sampling phase duration. */
    } B;
  } CTR2;

  uint8_t ADC_reserved5[4];
  union {                              /* Normal Conversion Mask Register 0 */
    vuint32_t R;
    struct {
      vuint32_t CH31:1;                /* Normal sampling enable for channel 31. */
      vuint32_t CH30:1;                /* Normal sampling enable for channel 30. */
      vuint32_t CH29:1;                /* Normal sampling enable for channel 29. */
      vuint32_t CH28:1;                /* Normal sampling enable for channel 28. */
      vuint32_t CH27:1;                /* Normal sampling enable for channel 27. */
      vuint32_t CH26:1;                /* Normal sampling enable for channel 26. */
      vuint32_t CH25:1;                /* Normal sampling enable for channel 25. */
      vuint32_t CH24:1;                /* Normal sampling enable for channel 24. */
      vuint32_t CH23:1;                /* Normal sampling enable for channel 23. */
      vuint32_t CH22:1;                /* Normal sampling enable for channel 22. */
      vuint32_t CH21:1;                /* Normal sampling enable for channel 21. */
      vuint32_t CH20:1;                /* Normal sampling enable for channel 20. */
      vuint32_t CH19:1;                /* Normal sampling enable for channel 19. */
      vuint32_t CH18:1;                /* Normal sampling enable for channel 18. */
      vuint32_t CH17:1;                /* Normal sampling enable for channel 17. */
      vuint32_t CH16:1;                /* Normal sampling enable for channel 16. */
      vuint32_t CH15:1;                /* Normal sampling enable for channel 15. */
      vuint32_t CH14:1;                /* Normal sampling enable for channel 14. */
      vuint32_t CH13:1;                /* Normal sampling enable for channel 13. */
      vuint32_t CH12:1;                /* Normal sampling enable for channel 12. */
      vuint32_t CH11:1;                /* Normal sampling enable for channel 11. */
      vuint32_t CH10:1;                /* Normal sampling enable for channel 10. */
      vuint32_t CH9:1;                 /* Normal sampling enable for channel 9. */
      vuint32_t CH8:1;                 /* Normal sampling enable for channel 8. */
      vuint32_t CH7:1;                 /* Normal sampling enable for channel 7. */
      vuint32_t CH6:1;                 /* Normal sampling enable for channel 6. */
      vuint32_t CH5:1;                 /* Normal sampling enable for channel 5. */
      vuint32_t CH4:1;                 /* Normal sampling enable for channel 4. */
      vuint32_t CH3:1;                 /* Normal sampling enable for channel 3. */
      vuint32_t CH2:1;                 /* Normal sampling enable for channel 2. */
      vuint32_t CH1:1;                 /* Normal sampling enable for channel 1. */
      vuint32_t CH0:1;                 /* Normal sampling enable for channel 0. */
    } B;
  } NCMR0;

  union {                              /* Normal Conversion Mask Register 1 */
    vuint32_t R;
    struct {
      vuint32_t CH63:1;                /* Normal sampling enable for channel 63. */
      vuint32_t CH62:1;                /* Normal sampling enable for channel 62. */
      vuint32_t CH61:1;                /* Normal sampling enable for channel 61. */
      vuint32_t CH60:1;                /* Normal sampling enable for channel 60. */
      vuint32_t CH59:1;                /* Normal sampling enable for channel 59. */
      vuint32_t CH58:1;                /* Normal sampling enable for channel 58. */
      vuint32_t CH57:1;                /* Normal sampling enable for channel 57. */
      vuint32_t CH56:1;                /* Normal sampling enable for channel 56. */
      vuint32_t CH55:1;                /* Normal sampling enable for channel 55. */
      vuint32_t CH54:1;                /* Normal sampling enable for channel 54. */
      vuint32_t CH53:1;                /* Normal sampling enable for channel 53. */
      vuint32_t CH52:1;                /* Normal sampling enable for channel 52. */
      vuint32_t CH51:1;                /* Normal sampling enable for channel 51. */
      vuint32_t CH50:1;                /* Normal sampling enable for channel 50. */
      vuint32_t CH49:1;                /* Normal sampling enable for channel 49. */
      vuint32_t CH48:1;                /* Normal sampling enable for channel 48. */
      vuint32_t CH47:1;                /* Normal sampling enable for channel 47. */
      vuint32_t CH46:1;                /* Normal sampling enable for channel 46. */
      vuint32_t CH45:1;                /* Normal sampling enable for channel 45. */
      vuint32_t CH44:1;                /* Normal sampling enable for channel 44. */
      vuint32_t CH43:1;                /* Normal sampling enable for channel 43. */
      vuint32_t CH42:1;                /* Normal sampling enable for channel 42. */
      vuint32_t CH41:1;                /* Normal sampling enable for channel 41. */
      vuint32_t CH40:1;                /* Normal sampling enable for channel 40. */
      vuint32_t CH39:1;                /* Normal sampling enable for channel 39. */
      vuint32_t CH38:1;                /* Normal sampling enable for channel 38. */
      vuint32_t CH37:1;                /* Normal sampling enable for channel 37. */
      vuint32_t CH36:1;                /* Normal sampling enable for channel 36. */
      vuint32_t CH35:1;                /* Normal sampling enable for channel 35. */
      vuint32_t CH34:1;                /* Normal sampling enable for channel 34. */
      vuint32_t CH33:1;                /* Normal sampling enable for channel 33. */
      vuint32_t CH32:1;                /* Normal sampling enable for channel 32. */
    } B;
  } NCMR1;

  union {                              /* Normal Conversion Mask Register 2 */
    vuint32_t R;
    struct {
      vuint32_t CH95:1;                /* Normal sampling enable for channel 95. */
      vuint32_t CH94:1;                /* Normal sampling enable for channel 94. */
      vuint32_t CH93:1;                /* Normal sampling enable for channel 93. */
      vuint32_t CH92:1;                /* Normal sampling enable for channel 92. */
      vuint32_t CH91:1;                /* Normal sampling enable for channel 91. */
      vuint32_t CH90:1;                /* Normal sampling enable for channel 90. */
      vuint32_t CH89:1;                /* Normal sampling enable for channel 89. */
      vuint32_t CH88:1;                /* Normal sampling enable for channel 88. */
      vuint32_t CH87:1;                /* Normal sampling enable for channel 87. */
      vuint32_t CH86:1;                /* Normal sampling enable for channel 86. */
      vuint32_t CH85:1;                /* Normal sampling enable for channel 85. */
      vuint32_t CH84:1;                /* Normal sampling enable for channel 84. */
      vuint32_t CH83:1;                /* Normal sampling enable for channel 83. */
      vuint32_t CH82:1;                /* Normal sampling enable for channel 82. */
      vuint32_t CH81:1;                /* Normal sampling enable for channel 81. */
      vuint32_t CH80:1;                /* Normal sampling enable for channel 80. */
      vuint32_t CH79:1;                /* Normal sampling enable for channel 79. */
      vuint32_t CH78:1;                /* Normal sampling enable for channel 78. */
      vuint32_t CH77:1;                /* Normal sampling enable for channel 77. */
      vuint32_t CH76:1;                /* Normal sampling enable for channel 76. */
      vuint32_t CH75:1;                /* Normal sampling enable for channel 75. */
      vuint32_t CH74:1;                /* Normal sampling enable for channel 74. */
      vuint32_t CH73:1;                /* Normal sampling enable for channel 73. */
      vuint32_t CH72:1;                /* Normal sampling enable for channel 72. */
      vuint32_t CH71:1;                /* Normal sampling enable for channel 71. */
      vuint32_t CH70:1;                /* Normal sampling enable for channel 70. */
      vuint32_t CH69:1;                /* Normal sampling enable for channel 69. */
      vuint32_t CH68:1;                /* Normal sampling enable for channel 68. */
      vuint32_t CH67:1;                /* Normal sampling enable for channel 67. */
      vuint32_t CH66:1;                /* Normal sampling enable for channel 66. */
      vuint32_t CH65:1;                /* Normal sampling enable for channel 65. */
      vuint32_t CH64:1;                /* Normal sampling enable for channel 64. */
    } B;
  } NCMR2;

  uint8_t ADC_reserved6[4];
  union {                              /* Injected Conversion Mask Register 0 */
    vuint32_t R;
    struct {
      vuint32_t CH31:1;                /* Injected sampling enable for channel 31. */
      vuint32_t CH30:1;                /* Injected sampling enable for channel 30. */
      vuint32_t CH29:1;                /* Injected sampling enable for channel 29. */
      vuint32_t CH28:1;                /* Injected sampling enable for channel 28. */
      vuint32_t CH27:1;                /* Injected sampling enable for channel 27. */
      vuint32_t CH26:1;                /* Injected sampling enable for channel 26. */
      vuint32_t CH25:1;                /* Injected sampling enable for channel 25. */
      vuint32_t CH24:1;                /* Injected sampling enable for channel 24. */
      vuint32_t CH23:1;                /* Injected sampling enable for channel 23. */
      vuint32_t CH22:1;                /* Injected sampling enable for channel 22. */
      vuint32_t CH21:1;                /* Injected sampling enable for channel 21. */
      vuint32_t CH20:1;                /* Injected sampling enable for channel 20. */
      vuint32_t CH19:1;                /* Injected sampling enable for channel 19. */
      vuint32_t CH18:1;                /* Injected sampling enable for channel 18. */
      vuint32_t CH17:1;                /* Injected sampling enable for channel 17. */
      vuint32_t CH16:1;                /* Injected sampling enable for channel 16. */
      vuint32_t CH15:1;                /* Injected sampling enable for channel 15. */
      vuint32_t CH14:1;                /* Injected sampling enable for channel 14. */
      vuint32_t CH13:1;                /* Injected sampling enable for channel 13. */
      vuint32_t CH12:1;                /* Injected sampling enable for channel 12. */
      vuint32_t CH11:1;                /* Injected sampling enable for channel 11. */
      vuint32_t CH10:1;                /* Injected sampling enable for channel 10. */
      vuint32_t CH9:1;                 /* Injected sampling enable for channel 9. */
      vuint32_t CH8:1;                 /* Injected sampling enable for channel 8. */
      vuint32_t CH7:1;                 /* Injected sampling enable for channel 7. */
      vuint32_t CH6:1;                 /* Injected sampling enable for channel 6. */
      vuint32_t CH5:1;                 /* Injected sampling enable for channel 5. */
      vuint32_t CH4:1;                 /* Injected sampling enable for channel 4. */
      vuint32_t CH3:1;                 /* Injected sampling enable for channel 3. */
      vuint32_t CH2:1;                 /* Injected sampling enable for channel 2. */
      vuint32_t CH1:1;                 /* Injected sampling enable for channel 1. */
      vuint32_t CH0:1;                 /* Injected sampling enable for channel 0. */
    } B;
  } JCMR0;

  union {                              /* Injected Conversion Mask Register 1 */
    vuint32_t R;
    struct {
      vuint32_t CH63:1;                /* Injected sampling enable for channel 63. */
      vuint32_t CH62:1;                /* Injected sampling enable for channel 62. */
      vuint32_t CH61:1;                /* Injected sampling enable for channel 61. */
      vuint32_t CH60:1;                /* Injected sampling enable for channel 60. */
      vuint32_t CH59:1;                /* Injected sampling enable for channel 59. */
      vuint32_t CH58:1;                /* Injected sampling enable for channel 58. */
      vuint32_t CH57:1;                /* Injected sampling enable for channel 57. */
      vuint32_t CH56:1;                /* Injected sampling enable for channel 56. */
      vuint32_t CH55:1;                /* Injected sampling enable for channel 55. */
      vuint32_t CH54:1;                /* Injected sampling enable for channel 54. */
      vuint32_t CH53:1;                /* Injected sampling enable for channel 53. */
      vuint32_t CH52:1;                /* Injected sampling enable for channel 52. */
      vuint32_t CH51:1;                /* Injected sampling enable for channel 51. */
      vuint32_t CH50:1;                /* Injected sampling enable for channel 50. */
      vuint32_t CH49:1;                /* Injected sampling enable for channel 49. */
      vuint32_t CH48:1;                /* Injected sampling enable for channel 48. */
      vuint32_t CH47:1;                /* Injected sampling enable for channel 47. */
      vuint32_t CH46:1;                /* Injected sampling enable for channel 46. */
      vuint32_t CH45:1;                /* Injected sampling enable for channel 45. */
      vuint32_t CH44:1;                /* Injected sampling enable for channel 44. */
      vuint32_t CH43:1;                /* Injected sampling enable for channel 43. */
      vuint32_t CH42:1;                /* Injected sampling enable for channel 42. */
      vuint32_t CH41:1;                /* Injected sampling enable for channel 41. */
      vuint32_t CH40:1;                /* Injected sampling enable for channel 40. */
      vuint32_t CH39:1;                /* Injected sampling enable for channel 39. */
      vuint32_t CH38:1;                /* Injected sampling enable for channel 38. */
      vuint32_t CH37:1;                /* Injected sampling enable for channel 37. */
      vuint32_t CH36:1;                /* Injected sampling enable for channel 36. */
      vuint32_t CH35:1;                /* Injected sampling enable for channel 35. */
      vuint32_t CH34:1;                /* Injected sampling enable for channel 34. */
      vuint32_t CH33:1;                /* Injected sampling enable for channel 33. */
      vuint32_t CH32:1;                /* Injected sampling enable for channel 32. */
    } B;
  } JCMR1;

  union {                              /* Injected Conversion Mask Register 2 */
    vuint32_t R;
    struct {
      vuint32_t CH95:1;                /* Injected sampling enable for channel 95. */
      vuint32_t CH94:1;                /* Injected sampling enable for channel 94. */
      vuint32_t CH93:1;                /* Injected sampling enable for channel 93. */
      vuint32_t CH92:1;                /* Injected sampling enable for channel 92. */
      vuint32_t CH91:1;                /* Injected sampling enable for channel 91. */
      vuint32_t CH90:1;                /* Injected sampling enable for channel 90. */
      vuint32_t CH89:1;                /* Injected sampling enable for channel 89. */
      vuint32_t CH88:1;                /* Injected sampling enable for channel 88. */
      vuint32_t CH87:1;                /* Injected sampling enable for channel 87. */
      vuint32_t CH86:1;                /* Injected sampling enable for channel 86. */
      vuint32_t CH85:1;                /* Injected sampling enable for channel 85. */
      vuint32_t CH84:1;                /* Injected sampling enable for channel 84. */
      vuint32_t CH83:1;                /* Injected sampling enable for channel 83. */
      vuint32_t CH82:1;                /* Injected sampling enable for channel 82. */
      vuint32_t CH81:1;                /* Injected sampling enable for channel 81. */
      vuint32_t CH80:1;                /* Injected sampling enable for channel 80. */
      vuint32_t CH79:1;                /* Injected sampling enable for channel 79. */
      vuint32_t CH78:1;                /* Injected sampling enable for channel 78. */
      vuint32_t CH77:1;                /* Injected sampling enable for channel 77. */
      vuint32_t CH76:1;                /* Injected sampling enable for channel 76. */
      vuint32_t CH75:1;                /* Injected sampling enable for channel 75. */
      vuint32_t CH74:1;                /* Injected sampling enable for channel 74. */
      vuint32_t CH73:1;                /* Injected sampling enable for channel 73. */
      vuint32_t CH72:1;                /* Injected sampling enable for channel 72. */
      vuint32_t CH71:1;                /* Injected sampling enable for channel 71. */
      vuint32_t CH70:1;                /* Injected sampling enable for channel 70. */
      vuint32_t CH69:1;                /* Injected sampling enable for channel 69. */
      vuint32_t CH68:1;                /* Injected sampling enable for channel 68. */
      vuint32_t CH67:1;                /* Injected sampling enable for channel 67. */
      vuint32_t CH66:1;                /* Injected sampling enable for channel 66. */
      vuint32_t CH65:1;                /* Injected sampling enable for channel 65. */
      vuint32_t CH64:1;                /* Injected sampling enable for channel 64. */
    } B;
  } JCMR2;

  uint8_t ADC_reserved7[4];
  union {                              /* Decode Signals Delay Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t DSD:16;
    } B;
  } DSDR;

  union {                              /* Power Down Exit Delay Register */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t PDED:8;
    } B;
  } PDEDR;

  uint8_t ADC_reserved8[52];
  union {                              /* Channel Data Register n (Precision Channels) */
    vuint32_t R;
    struct {
      vuint32_t  :12;
      vuint32_t VALID:1;               /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
      vuint32_t OVERW:1;               /* Overwrite data */
      vuint32_t RESULT:2;
      vuint32_t CDATA:16;              /* Converted Data 11:0. */
    } B;
  } CDR[96];

  union {                              /* Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t THRH:12;               /* High threshold value for channel x. */
      vuint32_t  :4;
      vuint32_t THRL:12;               /* Low threshold value for channel x. */
    } B;
  } THRHLR4;

  union {                              /* Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t THRH:12;               /* High threshold value for channel x. */
      vuint32_t  :4;
      vuint32_t THRL:12;               /* Low threshold value for channel x. */
    } B;
  } THRHLR5;

  uint8_t ADC_reserved9[40];
  union {                              /* Channel Watchdog Select Register 0 */
    vuint32_t R;
    struct {
      vuint32_t WSEL_CH7:4;            /* Channel Watchdog select for channel 7. */
      vuint32_t WSEL_CH6:4;            /* Channel Watchdog select for channel 6. */
      vuint32_t WSEL_CH5:4;            /* Channel Watchdog select for channel 5. */
      vuint32_t WSEL_CH4:4;            /* Channel Watchdog select for channel 4. */
      vuint32_t WSEL_CH3:4;            /* Channel Watchdog select for channel 3. */
      vuint32_t WSEL_CH2:4;            /* Channel Watchdog select for channel 2. */
      vuint32_t WSEL_CH1:4;            /* Channel Watchdog select for channel 1. */
      vuint32_t WSEL_CH0:4;            /* Channel Watchdog select for channel 0. */
    } B;
  } CWSELR0;

  union {                              /* Channel Watchdog Select Register 1 */
    vuint32_t R;
    struct {
      vuint32_t WSEL_CH15:4;           /* Channel Watchdog select for channel 15. */
      vuint32_t WSEL_CH14:4;           /* Channel Watchdog select for channel 14. */
      vuint32_t WSEL_CH13:4;           /* Channel Watchdog select for channel 13. */
      vuint32_t WSEL_CH12:4;           /* Channel Watchdog select for channel 12. */
      vuint32_t WSEL_CH11:4;           /* Channel Watchdog select for channel 11. */
      vuint32_t WSEL_CH10:4;           /* Channel Watchdog select for channel 10. */
      vuint32_t WSEL_CH9:4;            /* Channel Watchdog select for channel 9. */
      vuint32_t WSEL_CH8:4;            /* Channel Watchdog select for channel 8. */
    } B;
  } CWSELR1;

  union {                              /* Channel Watchdog Select Register 2 */
    vuint32_t R;
    struct {
      vuint32_t WSEL_CH23:4;           /* Channel Watchdog select for channel 23. */
      vuint32_t WSEL_CH22:4;           /* Channel Watchdog select for channel 22. */
      vuint32_t WSEL_CH21:4;           /* Channel Watchdog select for channel 21. */
      vuint32_t WSEL_CH20:4;           /* Channel Watchdog select for channel 20. */
      vuint32_t WSEL_CH19:4;           /* Channel Watchdog select for channel 19. */
      vuint32_t WSEL_CH18:4;           /* Channel Watchdog select for channel 18. */
      vuint32_t WSEL_CH17:4;           /* Channel Watchdog select for channel 17. */
      vuint32_t WSEL_CH16:4;           /* Channel Watchdog select for channel 16. */
    } B;
  } CWSELR2;

  uint8_t ADC_reserved10[4];
  union {                              /* Channel Watchdog Select Register 4 */
    vuint32_t R;
    struct {
      vuint32_t WSEL_CH39:4;           /* Channel Watchdog select for channel 39. */
      vuint32_t WSEL_CH38:4;           /* Channel Watchdog select for channel 38. */
      vuint32_t WSEL_CH37:4;           /* Channel Watchdog select for channel 37. */
      vuint32_t WSEL_CH36:4;           /* Channel Watchdog select for channel 36. */
      vuint32_t WSEL_CH35:4;           /* Channel Watchdog select for channel 35. */
      vuint32_t WSEL_CH34:4;           /* Channel Watchdog select for channel 34. */
      vuint32_t WSEL_CH33:4;           /* Channel Watchdog select for channel 33. */
      vuint32_t WSEL_CH32:4;           /* Channel Watchdog select for channel 32. */
    } B;
  } CWSELR4;

  union {                              /* Channel Watchdog Select Register 5 */
    vuint32_t R;
    struct {
      vuint32_t WSEL_CH47:4;           /* Channel Watchdog select for channel 47. */
      vuint32_t WSEL_CH46:4;           /* Channel Watchdog select for channel 46. */
      vuint32_t WSEL_CH45:4;           /* Channel Watchdog select for channel 45. */
      vuint32_t WSEL_CH44:4;           /* Channel Watchdog select for channel 44. */
      vuint32_t WSEL_CH43:4;           /* Channel Watchdog select for channel 43. */
      vuint32_t WSEL_CH42:4;           /* Channel Watchdog select for channel 42. */
      vuint32_t WSEL_CH41:4;           /* Channel Watchdog select for channel 41. */
      vuint32_t WSEL_CH40:4;           /* Channel Watchdog select for channel 40. */
    } B;
  } CWSELR5;

  union {                              /* Channel Watchdog Select Register 6 */
    vuint32_t R;
    struct {
      vuint32_t WSEL_CH55:4;           /* Channel Watchdog select for channel 55. */
      vuint32_t WSEL_CH54:4;           /* Channel Watchdog select for channel 54. */
      vuint32_t WSEL_CH53:4;           /* Channel Watchdog select for channel 53. */
      vuint32_t WSEL_CH52:4;           /* Channel Watchdog select for channel 52. */
      vuint32_t WSEL_CH51:4;           /* Channel Watchdog select for channel 51. */
      vuint32_t WSEL_CH50:4;           /* Channel Watchdog select for channel 50. */
      vuint32_t WSEL_CH49:4;           /* Channel Watchdog select for channel 49. */
      vuint32_t WSEL_CH48:4;           /* Channel Watchdog select for channel 48. */
    } B;
  } CWSELR6;

  union {                              /* Channel Watchdog Select Register 7 */
    vuint32_t R;
    struct {
      vuint32_t WSEL_CH63:4;           /* Channel Watchdog select for channel 63. */
      vuint32_t WSEL_CH62:4;           /* Channel Watchdog select for channel 62. */
      vuint32_t WSEL_CH61:4;           /* Channel Watchdog select for channel 61. */
      vuint32_t WSEL_CH60:4;           /* Channel Watchdog select for channel 60. */
      vuint32_t WSEL_CH59:4;           /* Channel Watchdog select for channel 59. */
      vuint32_t WSEL_CH58:4;           /* Channel Watchdog select for channel 58. */
      vuint32_t WSEL_CH57:4;           /* Channel Watchdog select for channel 57. */
      vuint32_t WSEL_CH56:4;           /* Channel Watchdog select for channel 56. */
    } B;
  } CWSELR7;

  union {                              /* Channel Watchdog Select Register 8 */
    vuint32_t R;
    struct {
      vuint32_t WSEL_CH71:4;           /* Channel Watchdog select for channel 71. */
      vuint32_t WSEL_CH70:4;           /* Channel Watchdog select for channel 70. */
      vuint32_t WSEL_CH69:4;           /* Channel Watchdog select for channel 69. */
      vuint32_t WSEL_CH68:4;           /* Channel Watchdog select for channel 68. */
      vuint32_t WSEL_CH67:4;           /* Channel Watchdog select for channel 67. */
      vuint32_t WSEL_CH66:4;           /* Channel Watchdog select for channel 66. */
      vuint32_t WSEL_CH65:4;           /* Channel Watchdog select for channel 65. */
      vuint32_t WSEL_CH64:4;           /* Channel Watchdog select for channel 64. */
    } B;
  } CWSELR8;

  union {                              /* Channel Watchdog Select Register 9 */
    vuint32_t R;
    struct {
      vuint32_t WSEL_CH79:4;           /* Channel Watchdog select for channel 79. */
      vuint32_t WSEL_CH78:4;           /* Channel Watchdog select for channel 78. */
      vuint32_t WSEL_CH77:4;           /* Channel Watchdog select for channel 77. */
      vuint32_t WSEL_CH76:4;           /* Channel Watchdog select for channel 76. */
      vuint32_t WSEL_CH75:4;           /* Channel Watchdog select for channel 75. */
      vuint32_t WSEL_CH74:4;           /* Channel Watchdog select for channel 74. */
      vuint32_t WSEL_CH73:4;           /* Channel Watchdog select for channel 73. */
      vuint32_t WSEL_CH72:4;           /* Channel Watchdog select for channel 72. */
    } B;
  } CWSELR9;

  union {                              /* Channel Watchdog Select Register 10 */
    vuint32_t R;
    struct {
      vuint32_t WSEL_CH87:4;           /* Channel Watchdog select for channel 87. */
      vuint32_t WSEL_CH86:4;           /* Channel Watchdog select for channel 86. */
      vuint32_t WSEL_CH85:4;           /* Channel Watchdog select for channel 85. */
      vuint32_t WSEL_CH84:4;           /* Channel Watchdog select for channel 84. */
      vuint32_t WSEL_CH83:4;           /* Channel Watchdog select for channel 83. */
      vuint32_t WSEL_CH82:4;           /* Channel Watchdog select for channel 82. */
      vuint32_t WSEL_CH81:4;           /* Channel Watchdog select for channel 81. */
      vuint32_t WSEL_CH80:4;           /* Channel Watchdog select for channel 80. */
    } B;
  } CWSELR10;

  union {                              /* Channel Watchdog Select Register 11 */
    vuint32_t R;
    struct {
      vuint32_t WSEL_CH95:4;           /* Channel Watchdog select for channel 95. */
      vuint32_t WSEL_CH94:4;           /* Channel Watchdog select for channel 94. */
      vuint32_t WSEL_CH93:4;           /* Channel Watchdog select for channel 93. */
      vuint32_t WSEL_CH92:4;           /* Channel Watchdog select for channel 92. */
      vuint32_t WSEL_CH91:4;           /* Channel Watchdog select for channel 91. */
      vuint32_t WSEL_CH90:4;           /* Channel Watchdog select for channel 90. */
      vuint32_t WSEL_CH89:4;           /* Channel Watchdog select for channel 89. */
      vuint32_t WSEL_CH88:4;           /* Channel Watchdog select for channel 88. */
    } B;
  } CWSELR11;

  union {                              /* Channel Watchdog Enable Register 0 */
    vuint32_t R;
    struct {
      vuint32_t CWEN31:1;              /* Watchdog enable for channel 31. */
      vuint32_t CWEN30:1;              /* Watchdog enable for channel 30. */
      vuint32_t CWEN29:1;              /* Watchdog enable for channel 29. */
      vuint32_t CWEN28:1;              /* Watchdog enable for channel 28. */
      vuint32_t CWEN27:1;              /* Watchdog enable for channel 27. */
      vuint32_t CWEN26:1;              /* Watchdog enable for channel 26. */
      vuint32_t CWEN25:1;              /* Watchdog enable for channel 25. */
      vuint32_t CWEN24:1;              /* Watchdog enable for channel 24. */
      vuint32_t CWEN23:1;              /* Watchdog enable for channel 23. */
      vuint32_t CWEN22:1;              /* Watchdog enable for channel 22. */
      vuint32_t CWEN21:1;              /* Watchdog enable for channel 21. */
      vuint32_t CWEN20:1;              /* Watchdog enable for channel 20. */
      vuint32_t CWEN19:1;              /* Watchdog enable for channel 19. */
      vuint32_t CWEN18:1;              /* Watchdog enable for channel 18. */
      vuint32_t CWEN17:1;              /* Watchdog enable for channel 17. */
      vuint32_t CWEN16:1;              /* Watchdog enable for channel 16. */
      vuint32_t CWEN15:1;              /* Watchdog enable for channel 15. */
      vuint32_t CWEN14:1;              /* Watchdog enable for channel 14. */
      vuint32_t CWEN13:1;              /* Watchdog enable for channel 13. */
      vuint32_t CWEN12:1;              /* Watchdog enable for channel 12. */
      vuint32_t CWEN11:1;              /* Watchdog enable for channel 11. */
      vuint32_t CWEN10:1;              /* Watchdog enable for channel 10. */
      vuint32_t CWEN9:1;               /* Watchdog enable for channel 9. */
      vuint32_t CWEN8:1;               /* Watchdog enable for channel 8. */
      vuint32_t CWEN7:1;               /* Watchdog enable for channel 7. */
      vuint32_t CWEN6:1;               /* Watchdog enable for channel 6. */
      vuint32_t CWEN5:1;               /* Watchdog enable for channel 5. */
      vuint32_t CWEN4:1;               /* Watchdog enable for channel 4. */
      vuint32_t CWEN3:1;               /* Watchdog enable for channel 3. */
      vuint32_t CWEN2:1;               /* Watchdog enable for channel 2. */
      vuint32_t CWEN1:1;               /* Watchdog enable for channel 1. */
      vuint32_t CWEN0:1;               /* Watchdog enable for channel 0. */
    } B;
  } CWENR0;

  union {                              /* Channel Watchdog Enable Register 1 */
    vuint32_t R;
    struct {
      vuint32_t CWEN63:1;              /* Watchdog enable for channel 63. */
      vuint32_t CWEN62:1;              /* Watchdog enable for channel 62. */
      vuint32_t CWEN61:1;              /* Watchdog enable for channel 61. */
      vuint32_t CWEN60:1;              /* Watchdog enable for channel 60. */
      vuint32_t CWEN59:1;              /* Watchdog enable for channel 59. */
      vuint32_t CWEN58:1;              /* Watchdog enable for channel 58. */
      vuint32_t CWEN57:1;              /* Watchdog enable for channel 57. */
      vuint32_t CWEN56:1;              /* Watchdog enable for channel 56. */
      vuint32_t CWEN55:1;              /* Watchdog enable for channel 55. */
      vuint32_t CWEN54:1;              /* Watchdog enable for channel 54. */
      vuint32_t CWEN53:1;              /* Watchdog enable for channel 53. */
      vuint32_t CWEN52:1;              /* Watchdog enable for channel 52. */
      vuint32_t CWEN51:1;              /* Watchdog enable for channel 51. */
      vuint32_t CWEN50:1;              /* Watchdog enable for channel 50. */
      vuint32_t CWEN49:1;              /* Watchdog enable for channel 49. */
      vuint32_t CWEN48:1;              /* Watchdog enable for channel 48. */
      vuint32_t CWEN47:1;              /* Watchdog enable for channel 47. */
      vuint32_t CWEN46:1;              /* Watchdog enable for channel 46. */
      vuint32_t CWEN45:1;              /* Watchdog enable for channel 45. */
      vuint32_t CWEN44:1;              /* Watchdog enable for channel 44. */
      vuint32_t CWEN43:1;              /* Watchdog enable for channel 43. */
      vuint32_t CWEN42:1;              /* Watchdog enable for channel 42. */
      vuint32_t CWEN41:1;              /* Watchdog enable for channel 41. */
      vuint32_t CWEN40:1;              /* Watchdog enable for channel 40. */
      vuint32_t CWEN39:1;              /* Watchdog enable for channel 39. */
      vuint32_t CWEN38:1;              /* Watchdog enable for channel 38. */
      vuint32_t CWEN37:1;              /* Watchdog enable for channel 37. */
      vuint32_t CWEN36:1;              /* Watchdog enable for channel 36. */
      vuint32_t CWEN35:1;              /* Watchdog enable for channel 35. */
      vuint32_t CWEN34:1;              /* Watchdog enable for channel 34. */
      vuint32_t CWEN33:1;              /* Watchdog enable for channel 33. */
      vuint32_t CWEN32:1;              /* Watchdog enable for channel 32. */
    } B;
  } CWENR1;

  union {                              /* Channel Watchdog Enable Register 2 */
    vuint32_t R;
    struct {
      vuint32_t CWEN95:1;              /* Watchdog enable for channel 95. */
      vuint32_t CWEN94:1;              /* Watchdog enable for channel 94. */
      vuint32_t CWEN93:1;              /* Watchdog enable for channel 93. */
      vuint32_t CWEN92:1;              /* Watchdog enable for channel 92. */
      vuint32_t CWEN91:1;              /* Watchdog enable for channel 91. */
      vuint32_t CWEN90:1;              /* Watchdog enable for channel 90. */
      vuint32_t CWEN89:1;              /* Watchdog enable for channel 89. */
      vuint32_t CWEN88:1;              /* Watchdog enable for channel 88. */
      vuint32_t CWEN87:1;              /* Watchdog enable for channel 87. */
      vuint32_t CWEN86:1;              /* Watchdog enable for channel 86. */
      vuint32_t CWEN85:1;              /* Watchdog enable for channel 85. */
      vuint32_t CWEN84:1;              /* Watchdog enable for channel 84. */
      vuint32_t CWEN83:1;              /* Watchdog enable for channel 83. */
      vuint32_t CWEN82:1;              /* Watchdog enable for channel 82. */
      vuint32_t CWEN81:1;              /* Watchdog enable for channel 81. */
      vuint32_t CWEN80:1;              /* Watchdog enable for channel 80. */
      vuint32_t CWEN79:1;              /* Watchdog enable for channel 79. */
      vuint32_t CWEN78:1;              /* Watchdog enable for channel 78. */
      vuint32_t CWEN77:1;              /* Watchdog enable for channel 77. */
      vuint32_t CWEN76:1;              /* Watchdog enable for channel 76. */
      vuint32_t CWEN75:1;              /* Watchdog enable for channel 75. */
      vuint32_t CWEN74:1;              /* Watchdog enable for channel 74. */
      vuint32_t CWEN73:1;              /* Watchdog enable for channel 73. */
      vuint32_t CWEN72:1;              /* Watchdog enable for channel 72. */
      vuint32_t CWEN71:1;              /* Watchdog enable for channel 71. */
      vuint32_t CWEN70:1;              /* Watchdog enable for channel 70. */
      vuint32_t CWEN69:1;              /* Watchdog enable for channel 69. */
      vuint32_t CWEN68:1;              /* Watchdog enable for channel 68. */
      vuint32_t CWEN67:1;              /* Watchdog enable for channel 67. */
      vuint32_t CWEN66:1;              /* Watchdog enable for channel 66. */
      vuint32_t CWEN65:1;              /* Watchdog enable for channel 65. */
      vuint32_t CWEN64:1;              /* Watchdog enable for channel 64. */
    } B;
  } CWENR2;

  uint8_t ADC_reserved11[4];
  union {                              /* Analog Watchdog Out of Range Register 0 */
    vuint32_t R;
    struct {
      vuint32_t AWOR_CH31:1;           /* Analog watchdog out of range for channel 31. */
      vuint32_t AWOR_CH30:1;           /* Analog watchdog out of range for channel 30. */
      vuint32_t AWOR_CH29:1;           /* Analog watchdog out of range for channel 29. */
      vuint32_t AWOR_CH28:1;           /* Analog watchdog out of range for channel 28. */
      vuint32_t AWOR_CH27:1;           /* Analog watchdog out of range for channel 27. */
      vuint32_t AWOR_CH26:1;           /* Analog watchdog out of range for channel 26. */
      vuint32_t AWOR_CH25:1;           /* Analog watchdog out of range for channel 25. */
      vuint32_t AWOR_CH24:1;           /* Analog watchdog out of range for channel 24. */
      vuint32_t AWOR_CH23:1;           /* Analog watchdog out of range for channel 23. */
      vuint32_t AWOR_CH22:1;           /* Analog watchdog out of range for channel 22. */
      vuint32_t AWOR_CH21:1;           /* Analog watchdog out of range for channel 21. */
      vuint32_t AWOR_CH20:1;           /* Analog watchdog out of range for channel 20. */
      vuint32_t AWOR_CH19:1;           /* Analog watchdog out of range for channel 19. */
      vuint32_t AWOR_CH18:1;           /* Analog watchdog out of range for channel 18. */
      vuint32_t AWOR_CH17:1;           /* Analog watchdog out of range for channel 17. */
      vuint32_t AWOR_CH16:1;           /* Analog watchdog out of range for channel 16. */
      vuint32_t AWOR_CH15:1;           /* Analog watchdog out of range for channel 15. */
      vuint32_t AWOR_CH14:1;           /* Analog watchdog out of range for channel 14. */
      vuint32_t AWOR_CH13:1;           /* Analog watchdog out of range for channel 13. */
      vuint32_t AWOR_CH12:1;           /* Analog watchdog out of range for channel 12. */
      vuint32_t AWOR_CH11:1;           /* Analog watchdog out of range for channel 11. */
      vuint32_t AWOR_CH10:1;           /* Analog watchdog out of range for channel 10. */
      vuint32_t AWOR_CH9:1;            /* Analog watchdog out of range for channel 9. */
      vuint32_t AWOR_CH8:1;            /* Analog watchdog out of range for channel 8. */
      vuint32_t AWOR_CH7:1;            /* Analog watchdog out of range for channel 7. */
      vuint32_t AWOR_CH6:1;            /* Analog watchdog out of range for channel 6. */
      vuint32_t AWOR_CH5:1;            /* Analog watchdog out of range for channel 5. */
      vuint32_t AWOR_CH4:1;            /* Analog watchdog out of range for channel 4. */
      vuint32_t AWOR_CH3:1;            /* Analog watchdog out of range for channel 3. */
      vuint32_t AWOR_CH2:1;            /* Analog watchdog out of range for channel 2. */
      vuint32_t AWOR_CH1:1;            /* Analog watchdog out of range for channel 1. */
      vuint32_t AWOR_CH0:1;            /* Analog watchdog out of range for channel 0. */
    } B;
  } AWORR0;

  union {                              /* Analog Watchdog Out of Range Register 1 */
    vuint32_t R;
    struct {
      vuint32_t AWOR_CH63:1;           /* Analog watchdog out of range for channel 63. */
      vuint32_t AWOR_CH62:1;           /* Analog watchdog out of range for channel 62. */
      vuint32_t AWOR_CH61:1;           /* Analog watchdog out of range for channel 61. */
      vuint32_t AWOR_CH60:1;           /* Analog watchdog out of range for channel 60. */
      vuint32_t AWOR_CH59:1;           /* Analog watchdog out of range for channel 59. */
      vuint32_t AWOR_CH58:1;           /* Analog watchdog out of range for channel 58. */
      vuint32_t AWOR_CH57:1;           /* Analog watchdog out of range for channel 57. */
      vuint32_t AWOR_CH56:1;           /* Analog watchdog out of range for channel 56. */
      vuint32_t AWOR_CH55:1;           /* Analog watchdog out of range for channel 55. */
      vuint32_t AWOR_CH54:1;           /* Analog watchdog out of range for channel 54. */
      vuint32_t AWOR_CH53:1;           /* Analog watchdog out of range for channel 53. */
      vuint32_t AWOR_CH52:1;           /* Analog watchdog out of range for channel 52. */
      vuint32_t AWOR_CH51:1;           /* Analog watchdog out of range for channel 51. */
      vuint32_t AWOR_CH50:1;           /* Analog watchdog out of range for channel 50. */
      vuint32_t AWOR_CH49:1;           /* Analog watchdog out of range for channel 49. */
      vuint32_t AWOR_CH48:1;           /* Analog watchdog out of range for channel 48. */
      vuint32_t AWOR_CH47:1;           /* Analog watchdog out of range for channel 47. */
      vuint32_t AWOR_CH46:1;           /* Analog watchdog out of range for channel 46. */
      vuint32_t AWOR_CH45:1;           /* Analog watchdog out of range for channel 45. */
      vuint32_t AWOR_CH44:1;           /* Analog watchdog out of range for channel 44. */
      vuint32_t AWOR_CH43:1;           /* Analog watchdog out of range for channel 43. */
      vuint32_t AWOR_CH42:1;           /* Analog watchdog out of range for channel 42. */
      vuint32_t AWOR_CH41:1;           /* Analog watchdog out of range for channel 41. */
      vuint32_t AWOR_CH40:1;           /* Analog watchdog out of range for channel 40. */
      vuint32_t AWOR_CH39:1;           /* Analog watchdog out of range for channel 39. */
      vuint32_t AWOR_CH38:1;           /* Analog watchdog out of range for channel 38. */
      vuint32_t AWOR_CH37:1;           /* Analog watchdog out of range for channel 37. */
      vuint32_t AWOR_CH36:1;           /* Analog watchdog out of range for channel 36. */
      vuint32_t AWOR_CH35:1;           /* Analog watchdog out of range for channel 35. */
      vuint32_t AWOR_CH34:1;           /* Analog watchdog out of range for channel 34. */
      vuint32_t AWOR_CH33:1;           /* Analog watchdog out of range for channel 33. */
      vuint32_t AWOR_CH32:1;           /* Analog watchdog out of range for channel 32. */
    } B;
  } AWORR1;

  union {                              /* Analog Watchdog Out of Range Register 2 */
    vuint32_t R;
    struct {
      vuint32_t AWOR_CH95:1;           /* Analog watchdog out of range for channel 95. */
      vuint32_t AWOR_CH94:1;           /* Analog watchdog out of range for channel 94. */
      vuint32_t AWOR_CH93:1;           /* Analog watchdog out of range for channel 93. */
      vuint32_t AWOR_CH92:1;           /* Analog watchdog out of range for channel 92. */
      vuint32_t AWOR_CH91:1;           /* Analog watchdog out of range for channel 91. */
      vuint32_t AWOR_CH90:1;           /* Analog watchdog out of range for channel 90. */
      vuint32_t AWOR_CH89:1;           /* Analog watchdog out of range for channel 89. */
      vuint32_t AWOR_CH88:1;           /* Analog watchdog out of range for channel 88. */
      vuint32_t AWOR_CH87:1;           /* Analog watchdog out of range for channel 87. */
      vuint32_t AWOR_CH86:1;           /* Analog watchdog out of range for channel 86. */
      vuint32_t AWOR_CH85:1;           /* Analog watchdog out of range for channel 85. */
      vuint32_t AWOR_CH84:1;           /* Analog watchdog out of range for channel 84. */
      vuint32_t AWOR_CH83:1;           /* Analog watchdog out of range for channel 83. */
      vuint32_t AWOR_CH82:1;           /* Analog watchdog out of range for channel 82. */
      vuint32_t AWOR_CH81:1;           /* Analog watchdog out of range for channel 81. */
      vuint32_t AWOR_CH80:1;           /* Analog watchdog out of range for channel 80. */
      vuint32_t AWOR_CH79:1;           /* Analog watchdog out of range for channel 79. */
      vuint32_t AWOR_CH78:1;           /* Analog watchdog out of range for channel 78. */
      vuint32_t AWOR_CH77:1;           /* Analog watchdog out of range for channel 77. */
      vuint32_t AWOR_CH76:1;           /* Analog watchdog out of range for channel 76. */
      vuint32_t AWOR_CH75:1;           /* Analog watchdog out of range for channel 75. */
      vuint32_t AWOR_CH74:1;           /* Analog watchdog out of range for channel 74. */
      vuint32_t AWOR_CH73:1;           /* Analog watchdog out of range for channel 73. */
      vuint32_t AWOR_CH72:1;           /* Analog watchdog out of range for channel 72. */
      vuint32_t AWOR_CH71:1;           /* Analog watchdog out of range for channel 71. */
      vuint32_t AWOR_CH70:1;           /* Analog watchdog out of range for channel 70. */
      vuint32_t AWOR_CH69:1;           /* Analog watchdog out of range for channel 69. */
      vuint32_t AWOR_CH68:1;           /* Analog watchdog out of range for channel 68. */
      vuint32_t AWOR_CH67:1;           /* Analog watchdog out of range for channel 67. */
      vuint32_t AWOR_CH66:1;           /* Analog watchdog out of range for channel 66. */
      vuint32_t AWOR_CH65:1;           /* Analog watchdog out of range for channel 65. */
      vuint32_t AWOR_CH64:1;           /* Analog watchdog out of range for channel 64. */
    } B;
  } AWORR2;

  uint8_t ADC_reserved12[68];
  union {                              /* Self Test Configuration Register 1 */
    vuint32_t R;
    struct {
      vuint32_t INPSAMP_C:8;
      vuint32_t  :8;
      vuint32_t INPSAMP_S:8;
      vuint32_t  :8;
    } B;
  } STCR1;

  union {                              /* Self Test Configuration Register 2 */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t MSKWDSERR:1;
      vuint32_t SERR:1;
      vuint32_t MSKWDTERR:1;           /* Interrupt enable (STSR[WDTERR] status bit) */
      vuint32_t  :1;
      vuint32_t MSKST_EOC:1;           /* Interrupt Enable bit for STSR2[ST_EOC] */
      vuint32_t  :4;
      vuint32_t MSKWDG_EOA_C:1;        /* Interrupt enable (WDG_EOA_C status bit) */
      vuint32_t  :1;
      vuint32_t MSKWDG_EOA_S:1;        /* Interrupt enable (WDG_EOA_S status bit) */
      vuint32_t MSKERR_C:1;            /* Interrupt enable (ERR_C status bit) */
      vuint32_t  :1;
      vuint32_t MSKERR_S2:1;           /* Interrupt enable (ERR_S2 status bit) */
      vuint32_t MSKERR_S1:1;           /* Interrupt enable (ERR_S1 status bit) */
      vuint32_t MSKERR_S0:1;           /* Interrupt enable (ERR_S0 status bit) */
      vuint32_t  :3;
      vuint32_t EN:1;                  /* Self testing channel enable. The TEST conversions are enabled. */
      vuint32_t  :2;
      vuint32_t FMA_WDSERR:1;          /* Fault mapping for the Watchdog Sequence error. */
      vuint32_t FMA_WDTERR:1;          /* Fault mapping for the Watchdog Timer error. */
      vuint32_t FMA_C:1;               /* Fault mapping for self test algorithm C. */
      vuint32_t  :1;
      vuint32_t FMA_S:1;               /* Fault mapping for the self test algorithm BGAP. */
    } B;
  } STCR2;

  union {                              /* Self Test Configuration Register 3 */
    vuint32_t R;
    struct {
      vuint32_t  :22;
      vuint32_t ALG:2;                 /* Algorithm scheduling. */
      vuint32_t  :3;
      vuint32_t MSTEP:5;
    } B;
  } STCR3;

  union {                              /* Self Test Baud Rate Register */
    vuint32_t R;
    struct {
      vuint32_t  :13;
      vuint32_t WDT:3;
      vuint32_t  :8;
      vuint32_t BR:8;                  /* Baud rate for the selected algorithm in SCAN mode (MCR[MODE] = 1). */
    } B;
  } STBRR;

  union {                              /* Self Test Status Register 1 */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t WDSERR:1;
      vuint32_t  :1;
      vuint32_t WDTERR:1;
      vuint32_t OVERWR:1;              /* Overwrite error. */
      vuint32_t ST_EOC:1;              /* Self Test EOC Bit. */
      vuint32_t  :4;
      vuint32_t WDG_EOA_C:1;
      vuint32_t  :1;
      vuint32_t WDG_EOA_S:1;
      vuint32_t ERR_C:1;
      vuint32_t  :1;
      vuint32_t ERR_S2:1;
      vuint32_t ERR_S1:1;
      vuint32_t ERR_S0:1;
      vuint32_t  :1;
      vuint32_t STEP_C:5;              /* Step of the algorithm C when an ERR_C has occurred. */
      vuint32_t  :5;
    } B;
  } STSR1;

  union {                              /* Self Test Status Register 2 */
    vuint32_t R;
    struct {
      vuint32_t OVFL:1;                /* Overflow Bit */
      vuint32_t  :3;
      vuint32_t DATA1:12;              /* Test channel converted data when the ERR_S1 has occurred. */
      vuint32_t  :4;
      vuint32_t DATA0:12;              /* Test channel converted data when the ERR_S1 has occurred. */
    } B;
  } STSR2;

  union {                              /* Self Test Status Register 3 */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t DATA1:12;              /* Test channel converted data when the ERR_S2 has occurred. */
      vuint32_t  :4;
      vuint32_t DATA0:12;              /* Test channel converted data when the ERR_S0 has occurred. */
    } B;
  } STSR3;

  union {                              /* Self Test Status Register 4 */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t DATA1:12;              /* Test channel converted data when the ERR_C has occurred. */
      vuint32_t  :4;
      vuint32_t  :12;
    } B;
  } STSR4;

  uint8_t ADC_reserved13[16];
  union {                              /* Self Test Data Register 1 */
    vuint32_t R;
    struct {
      vuint32_t  :12;
      vuint32_t VALID:1;               /* Valid data. */
      vuint32_t OWERWR:1;              /* Overwrite data. */
      vuint32_t  :6;
      vuint32_t TCDATA:12;             /* Test channel converted data. */
    } B;
  } STDR1;

  union {                              /* Self Test Data Register 2 */
    vuint32_t R;
    struct {
      vuint32_t FDATA:12;
      vuint32_t VALID:1;               /* Valid data. */
      vuint32_t OWERWR:1;              /* Overwrite data. */
      vuint32_t  :6;
      vuint32_t IDATA:12;
    } B;
  } STDR2;

  uint8_t ADC_reserved14[8];
  union {                              /* Self Test Analog Watchdog Register 0 */
    vuint32_t R;
    struct {
      vuint32_t AWDE:1;                /* Analog watchdog enable (related to the algorithm S (step 0)) */
      vuint32_t WDTE:1;                /* Watchdog timer enable (related to the algorithm S) */
      vuint32_t  :2;
      vuint32_t THRH:12;               /* High threshold value for Algorithm S step 0 */
      vuint32_t  :4;
      vuint32_t THRL:12;               /* Low threshold value for Algorithm S step 0 */
    } B;
  } STAW0R;

  union {                              /* Self Test Analog Watchdog Register 1A */
    vuint32_t R;
    struct {
      vuint32_t AWDE:1;                /* Analog watchdog enable related to the algorithm S (step1). */
      vuint32_t  :3;
      vuint32_t THRH:12;               /* High threshold value (integer part) for test channel for algorithm S (step 1) (unsigned coding). */
      vuint32_t  :4;
      vuint32_t THRL:12;               /* Low threshold value (integer part) for test channel for algorithm S (step 1) (unsigned coding). */
    } B;
  } STAW1AR;

  union {                              /* Self Test Analog Watchdog Register 1B */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t THRH:12;               /* High threshold value (fractional part) for test channel for algorithm S (step 1)(unsigned coding). */
      vuint32_t  :4;
      vuint32_t THRL:12;               /* Low threshold value (fractional part) for test channel for algorithm S (step 1) (unsigned coding). */
    } B;
  } STAW1BR;

  union {                              /* Self Test Analog Watchdog Register 2 */
    vuint32_t R;
    struct {
      vuint32_t AWDE:1;                /* Analog watchdog enable related to the algorithm S (step2). */
      vuint32_t  :19;
      vuint32_t THRL:12;               /* Low threshold value for channel x (unsigned coding). If the analog watchdog is enabled, the STSR1[ERR_S2] status bit is set if STDR1[TCDATA] < THRL. */
    } B;
  } STAW2R;

  uint8_t ADC_reserved15[4];
  union {                              /* Self Test Analog Watchdog Register 4 */
    vuint32_t R;
    struct {
      vuint32_t AWDE:1;                /* Analog watchdog enable (related to the algorithm C) */
      vuint32_t WDTE:1;                /* Watchdog timer enable (related to the algorithm C). */
      vuint32_t  :2;
      vuint32_t THRH:12;               /* High threshold value for channel sampled for C algorithm. */
      vuint32_t  :4;
      vuint32_t THRL:12;               /* Low threshold value for channel sampled for the C self test algorithm. */
    } B;
  } STAW4R;

  union {                              /* Self Test Analog Watchdog Register 5 */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t THRH:12;               /* High threshold value for the algorithm C (step1 to step CS-1). */
      vuint32_t  :4;
      vuint32_t THRL:12;               /* Low threshold value for the algorithm C (step1 to step CS-1). */
    } B;
  } STAW5R;

  uint8_t ADC_reserved16[4];
  union {                              /* Calibration, BIST Control and status Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t  :2;
      vuint32_t TSAMP:2;               /* Test Sample period in Calibration, BIST and Offset calculation process. */
      vuint32_t  :3;
      vuint32_t  :8;
      vuint32_t C_T_BUSY:1;
      vuint32_t  :1;
      vuint32_t  :6;
      vuint32_t  :1;
      vuint32_t NR_SMPL:2;             /* Number of Samples for averaging. */
      vuint32_t AVG_EN:1;              /* Average Enable (for Calibration only). */
      vuint32_t TEST_FAIL:1;           /* Test Fail. */
      vuint32_t  :2;
      vuint32_t TEST_EN:1;             /* Enable the test. */
    } B;
  } CALBISTREG;

  uint8_t ADC_reserved17[4];
  union {                              /* Offset and Gain User Register */
    vuint32_t R;
    struct {
      vuint32_t  :6;
      vuint32_t GAIN_USER:10;
      vuint32_t  :8;
      vuint32_t OFFSET_USER:8;
    } B;
  } OFSGNUSR;
};


/* ============================================================================
   =============================== Module: AIPS ===============================
   ============================================================================ */

struct AIPS_tag {
  union {                              /* Master Privilege Register A */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t MTR0:1;                /* Master 0 Trusted For Read */
      vuint32_t MTW0:1;                /* Master 0 Trusted For Writes */
      vuint32_t MPL0:1;                /* Master 0 Privilege Level */
      vuint32_t  :1;
      vuint32_t MTR1:1;                /* Master 1 trusted for read */
      vuint32_t MTW1:1;                /* Master 1 trusted for writes */
      vuint32_t MPL1:1;                /* Master 1 privilege level */
      vuint32_t  :1;
      vuint32_t MTR2:1;                /* Master 2 Trusted For Read */
      vuint32_t MTW2:1;                /* Master 2 Trusted For Writes */
      vuint32_t MPL2:1;                /* Master 2 Privilege Level */
      vuint32_t  :1;
      vuint32_t MTR3:1;                /* Master 3 Trusted For Read */
      vuint32_t MTW3:1;                /* Master 3 Trusted For Writes */
      vuint32_t MPL3:1;                /* Master 3 Privilege Level */
      vuint32_t  :1;
      vuint32_t MTR4:1;                /* Master 4 Trusted For Read */
      vuint32_t MTW4:1;                /* Master 4 Trusted For Writes */
      vuint32_t MPL4:1;                /* Master 4 Privilege Level */
      vuint32_t  :1;
      vuint32_t MTR5:1;                /* Master 5 Trusted For Read */
      vuint32_t MTW5:1;                /* Master 5 Trusted For Writes */
      vuint32_t MPL5:1;                /* Master 5 Privilege Level */
      vuint32_t  :1;
      vuint32_t MTR6:1;                /* Master 6 trusted for read */
      vuint32_t MTW6:1;                /* Master 6 trusted for writes */
      vuint32_t MPL6:1;                /* Master 6 privilege level */
      vuint32_t  :4;
    } B;
  } MPRA;

  union {                              /* Master Privilege Register B */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t  :1;
      vuint32_t MTR9:1;                /* Master 9 trusted for read */
      vuint32_t MTW9:1;                /* Master 9 trusted for writes */
      vuint32_t MPL9:1;                /* Master 9 privilege level */
      vuint32_t  :1;
      vuint32_t MTR10:1;               /* Master 10 trusted for read */
      vuint32_t MTW10:1;               /* Master 10 trusted for writes */
      vuint32_t MPL10:1;               /* Master 10 privilege level */
      vuint32_t  :1;
      vuint32_t MTR11:1;               /* Master 11 trusted for read */
      vuint32_t MTW11:1;               /* Master 11 trusted for writes */
      vuint32_t MPL11:1;               /* Master 11 privilege level */
      vuint32_t  :1;
      vuint32_t MTR12:1;               /* Master 12 trusted for read */
      vuint32_t MTW12:1;               /* Master 12 trusted for writes */
      vuint32_t MPL12:1;               /* Master 12 privilege level */
      vuint32_t  :1;
      vuint32_t MTR13:1;               /* Master 13 trusted for read */
      vuint32_t MTW13:1;               /* Master 13 trusted for writes */
      vuint32_t MPL13:1;               /* Master 13 Privilege Level */
      vuint32_t  :4;
      vuint32_t  :4;
    } B;
  } MPRB;

  uint8_t AIPS_reserved0[248];
  union {                              /* Peripheral Access Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t SP0:1;                 /* Supervisor Protect */
      vuint32_t WP0:1;                 /* Write Protect */
      vuint32_t TP0:1;                 /* Trusted Protect */
      vuint32_t  :1;
      vuint32_t SP1:1;                 /* Supervisor Protect */
      vuint32_t WP1:1;                 /* Write Protect */
      vuint32_t TP1:1;                 /* Trusted Protect */
      vuint32_t  :1;
      vuint32_t SP2:1;                 /* Supervisor Protect */
      vuint32_t WP2:1;                 /* Write Protect */
      vuint32_t TP2:1;                 /* Trusted Protect */
      vuint32_t  :1;
      vuint32_t SP3:1;                 /* Supervisor Protect */
      vuint32_t WP3:1;                 /* Write Protect */
      vuint32_t TP3:1;                 /* Trusted Protect */
      vuint32_t  :1;
      vuint32_t SP4:1;                 /* Supervisor Protect */
      vuint32_t WP4:1;                 /* Write Protect */
      vuint32_t TP4:1;                 /* Trusted Protect */
      vuint32_t  :1;
      vuint32_t SP5:1;                 /* Supervisor Protect */
      vuint32_t WP5:1;                 /* Write Protect */
      vuint32_t TP5:1;                 /* Trusted Protect */
      vuint32_t  :1;
      vuint32_t SP6:1;                 /* Supervisor Protect */
      vuint32_t WP6:1;                 /* Write Protect */
      vuint32_t TP6:1;                 /* Trusted Protect */
      vuint32_t  :1;
      vuint32_t SP7:1;                 /* Supervisor Protect */
      vuint32_t WP7:1;                 /* Write Protect */
      vuint32_t TP7:1;                 /* Trusted Protect */
    } B;
  } PACR[4];

  uint8_t AIPS_reserved1[48];
  union {                              /* Off-Platform Peripheral Access Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t SP0:1;                 /* Supervisor Protect */
      vuint32_t WP0:1;                 /* Write Protect */
      vuint32_t TP0:1;                 /* Trusted Protect */
      vuint32_t  :1;
      vuint32_t SP1:1;                 /* Supervisor Protect */
      vuint32_t WP1:1;                 /* Write Protect */
      vuint32_t TP1:1;                 /* Trusted Protect */
      vuint32_t  :1;
      vuint32_t SP2:1;                 /* Supervisor Protect */
      vuint32_t WP2:1;                 /* Write Protect */
      vuint32_t TP2:1;                 /* Trusted Protect */
      vuint32_t  :1;
      vuint32_t SP3:1;                 /* Supervisor Protect */
      vuint32_t WP3:1;                 /* Write Protect */
      vuint32_t TP3:1;                 /* Trusted Protect */
      vuint32_t  :1;
      vuint32_t SP4:1;                 /* Supervisor Protect */
      vuint32_t WP4:1;                 /* Write Protect */
      vuint32_t TP4:1;                 /* Trusted Protect */
      vuint32_t  :1;
      vuint32_t SP5:1;                 /* Supervisor Protect */
      vuint32_t WP5:1;                 /* Write Protect */
      vuint32_t TP5:1;                 /* Trusted Protect */
      vuint32_t  :1;
      vuint32_t SP6:1;                 /* Supervisor Protect */
      vuint32_t WP6:1;                 /* Write Protect */
      vuint32_t TP6:1;                 /* Trusted Protect */
      vuint32_t  :1;
      vuint32_t SP7:1;                 /* Supervisor Protect */
      vuint32_t WP7:1;                 /* Write Protect */
      vuint32_t TP7:1;                 /* Trusted Protect */
    } B;
  } OPACR[32];
};


/* ============================================================================
   =============================== Module: AXBS ===============================
   ============================================================================ */

struct AXBS_tag {
  struct {
    union {                            /* Priority Registers Slave */
      vuint32_t R;
      struct {
        vuint32_t  :1;
        vuint32_t M7:3;                /* Master 7 Priority. Sets the arbitration priority for this port on the associated slave port. */
        vuint32_t  :1;
        vuint32_t M6:3;                /* Master 6 Priority. Sets the arbitration priority for this port on the associated slave port. */
        vuint32_t  :1;
        vuint32_t M5:3;                /* Master 5 Priority. Sets the arbitration priority for this port on the associated slave port. */
        vuint32_t  :1;
        vuint32_t M4:3;                /* Master 4 Priority. Sets the arbitration priority for this port on the associated slave port. */
        vuint32_t  :1;
        vuint32_t M3:3;                /* Master 3 Priority. Sets the arbitration priority for this port on the associated slave port. */
        vuint32_t  :1;
        vuint32_t M2:3;                /* Master 2 Priority. Sets the arbitration priority for this port on the associated slave port. */
        vuint32_t  :1;
        vuint32_t M1:3;                /* Master 1 Priority. Sets the arbitration priority for this port on the associated slave port. */
        vuint32_t  :1;
        vuint32_t M0:3;                /* Master 0 Priority. Sets the arbitration priority for this port on the associated slave port. */
      } B;
    } PRS;
    uint8_t PORT_reserved0[12];
    union {                            /* Control Register */
      vuint32_t R;
      struct {
        vuint32_t RO:1;                /* Read Only */
        vuint32_t  :1;
        vuint32_t  :6;
        vuint32_t HPE7:1;
        vuint32_t HPE6:1;
        vuint32_t HPE5:1;
        vuint32_t HPE4:1;
        vuint32_t HPE3:1;
        vuint32_t HPE2:1;
        vuint32_t HPE1:1;
        vuint32_t HPE0:1;
        vuint32_t  :6;
        vuint32_t ARB:2;               /* Arbitration Mode */
        vuint32_t  :2;
        vuint32_t PCTL:2;              /* Parking Control */
        vuint32_t  :1;
        vuint32_t PARK:3;              /* Park */
      } B;
    } CRS;
    uint8_t PORT_reserved1[236];
  } PORT[8];

  struct {
    union {                            /* Master General Purpose Control Register */
      vuint32_t R;
      struct {
        vuint32_t  :29;
        vuint32_t AULB:3;              /* Arbitrates On Undefined Length Bursts */
      } B;
    } MGPCR;
    uint8_t MGPCR_reserved0[252];
  } MGPCR[8];
};


/* ============================================================================
   =============================== Module: BCTU ===============================
   ============================================================================ */

struct BCTU_tag {
  union {                              /* Module Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t MDIS:1;                /* Module Disable */
      vuint32_t FRZ:1;                 /* Freeze mode - for debug operation. */
      vuint32_t  :2;
      vuint32_t GTRGEN:1;              /* Global Trigger Enable. */
      vuint32_t  :6;
      vuint32_t  :1;                   /* Reserved. */
      vuint32_t  :1;
      vuint32_t DMA1:1;                /* ADC1DR data transferring by DMA. */
      vuint32_t DMA0:1;                /* ADC0DR data transferring by DMA. */
      vuint32_t  :8;
      vuint32_t TRGEN:1;               /* Trigger interrupt request enable. */
      vuint32_t  :1;
      vuint32_t LIST_IEN:1;            /* LIST interrupt enable. */
      vuint32_t  :1;
      vuint32_t  :1;                   /* Reserved. */
      vuint32_t  :1;                   /* Reserved. */
      vuint32_t IEN1:1;                /* Interrupt enable bit for ADC1DR new data. */
      vuint32_t IEN0:1;                /* Interrupt enable bit for ADC0DR new data. */
    } B;
  } MCR;

  uint8_t BCTU_reserved0[4];
  union {                              /* Module Status register */
    vuint32_t R;
    struct {
      vuint32_t TRGF_CLR:1;            /* TRGF clear */
      vuint32_t  :3;
      vuint32_t  :1;                   /* Reserved. */
      vuint32_t  :1;                   /* Reserved. */
      vuint32_t LIST1_Last_CLR:1;
      vuint32_t LIST0_Last_CLR:1;
      vuint32_t  :1;                   /* Reserved. */
      vuint32_t  :1;                   /* Reserved. */
      vuint32_t DATAOVR1_CLR:1;        /* Clears DATAOVR1 flag */
      vuint32_t DATAOVR0_CLR:1;        /* Clears DATAOVR0 flag */
      vuint32_t  :1;                   /* Reserved. */
      vuint32_t  :1;                   /* Reserved. */
      vuint32_t NDATA1_CLR:1;          /* Clears NDATA1 flag */
      vuint32_t NDATA0_CLR:1;          /* Clears NDATA0 flag */
      vuint32_t TRGF:1;                /* Trigger Flag */
      vuint32_t  :3;
      vuint32_t  :1;                   /* Reserved. */
      vuint32_t  :1;                   /* Reserved. */
      vuint32_t LIST1_Last:1;
      vuint32_t LIST0_Last:1;
      vuint32_t  :1;                   /* Reserved. */
      vuint32_t  :1;                   /* Reserved. */
      vuint32_t DATAOVR1:1;
      vuint32_t DATAOVR0:1;
      vuint32_t  :1;                   /* Reserved. */
      vuint32_t  :1;                   /* Reserved. */
      vuint32_t NDATA1:1;
      vuint32_t NDATA0:1;
    } B;
  } MSR;

  uint8_t BCTU_reserved1[12];
  union {                              /* Trigger Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t LOOP:1;                /* LOOP bit */
      vuint32_t  :7;
      vuint32_t  :8;                   /* Reserved. */
      vuint32_t TRIGEN:1;              /* Trigger enable */
      vuint32_t TRG_FLAG:1;
      vuint32_t TRS:1;                 /* Trigger resolution */
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t ADC_SEL1:1;
      vuint32_t ADC_SEL0:1;
      vuint32_t  :1;                   /* Reserved. */
      vuint32_t CHANNEL_VALUE_OR_LADDR:7; /* Channel Value or List Address Value. */
    } B;
  } TRGCFG[64];

  uint8_t BCTU_reserved2[272];
  union {                              /* Write Protection register */
    vuint32_t R;
    struct {
      vuint32_t  :28;
      vuint32_t PROTEC_CODE:4;         /* The Protection code sets protection for the write protected registers */
    } B;
  } WRPROT;

  union {                              /* Software Trigger register 1 */
    vuint32_t R;
    struct {
      vuint32_t SFTRG31:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG30:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG29:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG28:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG27:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG26:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG25:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG24:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG23:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG22:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG21:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG20:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG19:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG18:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG17:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG16:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG15:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG14:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG13:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG12:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG11:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG10:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG9:1;              /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG8:1;              /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG7:1;              /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG6:1;              /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG5:1;              /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG4:1;              /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG3:1;              /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG2:1;              /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG1:1;              /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG0:1;              /* Software trigger to start an ADC conversion. */
    } B;
  } SFTRGR1;

  union {                              /* Software Trigger register 1 */
    vuint32_t R;
    struct {
      vuint32_t SFTRG63:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG62:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG61:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG60:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG59:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG58:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG57:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG56:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG55:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG54:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG53:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG52:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG51:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG50:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG49:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG48:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG47:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG46:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG45:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG44:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG43:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG42:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG41:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG40:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG39:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG38:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG37:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG36:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG35:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG34:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG33:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG32:1;             /* Software trigger to start an ADC conversion. */
    } B;
  } SFTRGR2;

  union {                              /* Software Trigger register 1 */
    vuint32_t R;
    struct {
      vuint32_t SFTRG95:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG94:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG93:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG92:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG91:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG90:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG89:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG88:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG87:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG86:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG85:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG84:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG83:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG82:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG81:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG80:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG79:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG78:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG77:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG76:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG75:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG74:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG73:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG72:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG71:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG70:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG69:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG68:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG67:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG66:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG65:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG64:1;             /* Software trigger to start an ADC conversion. */
    } B;
  } SFTRGR3;

  uint8_t BCTU_reserved3[4];
  union {                              /* ADC0 Result Data register */
    vuint32_t R;
    struct {
      vuint32_t TRG_SRC:8;
      vuint32_t CH:8;
      vuint32_t LIST:1;
      vuint32_t LAST:1;
      vuint32_t  :2;
      vuint32_t ADC_DATA:12;
    } B;
  } ADC0DR;

  union {                              /* ADC1 result data register */
    vuint32_t R;
    struct {
      vuint32_t TRG_SRC:8;
      vuint32_t CH:8;
      vuint32_t LIST:1;
      vuint32_t LAST:1;
      vuint32_t  :2;
      vuint32_t ADC_DATA:12;
    } B;
  } ADC1DR;

  uint8_t BCTU_reserved4[8];
  union {                              /* LIST Size Status register */
    vuint32_t R;
    struct {
      vuint32_t  :24;                  /* Reserved. */
      vuint32_t LISTSZ:8;              /* Size of the LIST in number of elements. */
    } B;
  } LISTSTAR;

  union {                              /* LIST Channel Address Register */
    vuint32_t R;
    struct {
      vuint32_t LAST_y:1;              /* Last channel in the list of channels. */
      vuint32_t  :3;
      vuint32_t  :4;                   /* Reserved. */
      vuint32_t  :1;                   /* Reserved. */
      vuint32_t ADC_CH_y:7;            /* ADC channel selection. */
      vuint32_t LAST_y_plus_1:1;       /* Second to last channel in the list of channels. */
      vuint32_t  :3;
      vuint32_t  :4;                   /* Reserved. */
      vuint32_t  :1;                   /* Reserved. */
      vuint32_t ADC_CHL_y_plus_1:7;    /* ADC channel selection. */
    } B;
  } LISTCHR[16];
};


/* ============================================================================
   =============================== Module: C55FMC =============================
   ============================================================================ */

struct C55FMC_tag {
  union {                              /* Module Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t RVE:1;                 /* Read Voltage Error */
      vuint32_t RRE:1;                 /* Read Reference Error */
      vuint32_t AEE:1;                 /* Address Encode Error */
      vuint32_t EEE:1;                 /* ECC after ECC Error */
      vuint32_t  :12;
      vuint32_t EER:1;                 /* ECC Event Error */
      vuint32_t RWE:1;                 /* Read-While-Write Event Error */
      vuint32_t SBC:1;                 /* Single Bit Correction */
      vuint32_t  :1;
      vuint32_t PEAS:1;                /* Program Access Space */
      vuint32_t DONE:1;                /* State Machine Status */
      vuint32_t PEG:1;                 /* Program/Erase Good */
      vuint32_t PECIE:1;               /* Program/Erase Complete Interrupt Enable */
      vuint32_t  :3;
      vuint32_t PGM:1;                 /* Program */
      vuint32_t PSUS:1;                /* Program Suspend */
      vuint32_t ERS:1;                 /* Erase */
      vuint32_t ESUS:1;                /* Erase Suspend */
      vuint32_t EHV:1;                 /* Enable High Voltage */
    } B;
  } MCR;

//  uint8_t C55FMC_reserved0[4];

    union {                              /* Alternate Module Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :20;
      vuint32_t PEASa:1;               /* Program Access Space */
      vuint32_t DONEa:1;               /* State Machine Status */
      vuint32_t PEGa:1;                /* Program/Erase Good */
      vuint32_t  :4;
      vuint32_t PGMa:1;                /* Program */
      vuint32_t PSUSa:1;               /* Program Suspend */
      vuint32_t ERSa:1;                /* Erase Suspend */
      vuint32_t ESUSa:1;               /* Erase Suspend */
      vuint32_t EHVa:1;                /* Enable High Voltage */
    } B;
  } MCRA;
    
  union {                              /* Extended Module Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t HT:1;                  /* High Temperature Enabled. */
      vuint32_t  :2;
      vuint32_t n256K:5;
      vuint32_t n64Kh:3;
      vuint32_t n32Kh:2;
      vuint32_t n16Kh:3;
      vuint32_t n64Km:3;
      vuint32_t n32Km:2;
      vuint32_t n16Km:3;
      vuint32_t n64Kl:3;
      vuint32_t n32Kl:2;
      vuint32_t n16Kl:3;
    } B;
  } MCRE;

  uint8_t C55FMC_reserved1[4];
  union {                              /* Lock 0 register */
    vuint32_t R;
    struct {
      vuint32_t TSLOCK:1;              /* UTest NVM Lock. */
      vuint32_t  :1;
      vuint32_t LOWLOCK:14;            /* Low Block Lock */
      vuint32_t MIDLOCK:16;            /* Mid Block Lock */
    } B;
  } LOCK0;

  union {                              /* Lock 1 register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t HIGHLOCK:16;           /* High Block Lock */
    } B;
  } LOCK1;

  union {                              /* Lock 2 register */
    vuint32_t R;
    struct {
      vuint32_t A256KLOCK:32;          /* 256 KB Block Lock */
    } B;
  } LOCK2;

  union {                              /* Lock 3 register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t A256KLOCK:16;          /* 256 KB Block Lock */
    } B;
  } LOCK3;

//  uint8_t C55FMC_reserved2[24];

  uint8_t C55FMC_reserved2[8];

   union {                              /* Alternate Lock 0 register */
    vuint32_t R;
    struct {
      vuint32_t TSLOCKa:1;             /* Alternate UTest NVM Lock. */
      vuint32_t  :1;
      vuint32_t LOWLOCKa:14;           /* Alternate Low Block Lock */
      vuint32_t MIDLOCKa:16;           /* Alternate Mid Block Lock */
    } B;
  } LOCK0A;

  union {                              /* Alternate Lock 1 register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t HIGHLOCKa:16;          /* Alternate High Block Lock */
    } B;
  } LOCK1A;

  uint8_t C55FMC_reserved4[8];
  
  union {                              /* Select 0 register */
    vuint32_t R;
    struct {
      vuint32_t  :2;
      vuint32_t LOWSEL:14;             /* LOW Block Select. */
      vuint32_t MIDSEL:16;             /* Mid Block Select. */
    } B;
  } SEL0;

  union {                              /* Select 1 register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t HIGHSEL:16;            /* High Block Select. */
    } B;
  } SEL1;

  union {                              /* Select 2 register */
    vuint32_t R;
    struct {
      vuint32_t A256KSEL:32;           /* 256 KB Block Select. */
    } B;
  } SEL2;

  union {                              /* Select 3 register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t A256KSEL:16;           /* 256 KB Block Select. */
    } B;
  } SEL3;

  uint8_t C55FMC_reserved3[8];
  union {                              /* Address register */
    vuint32_t R;
    struct {
      vuint32_t SAD:1;
      vuint32_t aH:1;
      vuint32_t aM:1;
      vuint32_t aL:1;
      vuint32_t a256k:1;
      vuint32_t a64k:1;
      vuint32_t a32k:1;
      vuint32_t a16k:1;
      vuint32_t ADDR:21;
      vuint32_t  :3;
    } B;
  } ADR;

  union {                              /* UTest 0 register */
    vuint32_t R;
    struct {
      vuint32_t UTE:1;
      vuint32_t SBCE:1;
      vuint32_t  :11;
      vuint32_t CPR:1;
      vuint32_t CPA:1;
      vuint32_t CPE:1;
      vuint32_t  :6;
      vuint32_t NAIBP:1;
      vuint32_t AIBPE:1;
      vuint32_t  :1;
      vuint32_t AISUS:1;
      vuint32_t MRE:1;
      vuint32_t MRV:1;
      vuint32_t  :1;
      vuint32_t AIS:1;
      vuint32_t AIE:1;
      vuint32_t AID:1;
    } B;
  } UT0;

  union {                              /* UMISR register */
    vuint32_t R;
    struct {
      vuint32_t MISR:32;
    } B;
  } UM[9];

  union {                              /* UMISR register */
    vuint32_t R;
    struct {
      vuint32_t  :31;
      vuint32_t MISR:1;                /* MISR[288]. */
    } B;
  } UM9;

  union {                              /* Over-Program Protection 0 register */
    vuint32_t R;
    struct {
      vuint32_t  :2;
      vuint32_t LOWOPP:14;             /* Low Block Over-Program Protection[13:0]. */
      vuint32_t MIDOPP:16;             /* Mid Block Over-Program Protection[15:0]. */
    } B;
  } OPP0;

  union {                              /* Over-Program Protection 1 register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t HIGHOPP:16;            /* High Block Over-Program Protection[15:0]. */
    } B;
  } OPP1;

  union {                              /* Over-Program Protection 2 register */
    vuint32_t R;
    struct {
      vuint32_t A256KOPP:32;           /* 256K Block Over-Program Protection[31:0]. */
    } B;
  } OPP2;

  union {                              /* Over-Program Protection 3 register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t A256KOPP:16;           /* 256K Block Over-Program Protection[47:32]. */
    } B;
  } OPP3;

  union {                              /* Test Mode Disable Password Check register */
    vuint32_t R;
    struct {
      vuint32_t PWD:32;                /* Password challenge */
    } B;
  } TMD;
};


/* ============================================================================
   =============================== Module: CAN ================================
   ============================================================================ */

//struct CAN_tag {
//  union {                              /* Module Configuration Register */
//    vuint32_t R;
//    struct {
//      vuint32_t MDIS:1;                /* Module Disable */
//      vuint32_t FRZ:1;                 /* Freeze Enable */
//      vuint32_t RFEN:1;                /* Rx FIFO Enable */
//      vuint32_t HALT:1;                /* Halt FlexCAN */
//      vuint32_t NOTRDY:1;              /* FlexCAN Not Ready */
//      vuint32_t WAKMSK:1;              /* Wake Up Interrupt Mask */
//      vuint32_t SOFTRST:1;             /* Soft Reset */
//      vuint32_t FRZACK:1;              /* Freeze Mode Acknowledge */
//      vuint32_t SUPV:1;                /* Supervisor Mode */
//      vuint32_t SLFWAK:1;              /* Self Wake Up */
//      vuint32_t WRNEN:1;               /* Warning Interrupt Enable */
//      vuint32_t LPMACK:1;              /* Low-Power Mode Acknowledge */
//      vuint32_t WAKSRC:1;              /* Wake Up Source */
//      vuint32_t  :1;
//      vuint32_t SRXDIS:1;              /* Self Reception Disable */
//      vuint32_t IRMQ:1;                /* Individual Rx Masking And Queue Enable */
//      vuint32_t  :1;
//      vuint32_t PNET_EN:1;             /* Pretended Networking Enable */
//      vuint32_t LPRIOEN:1;             /* Local Priority Enable */
//      vuint32_t AEN:1;                 /* Abort Enable */
//      vuint32_t FDEN:1;                /* CAN FD operation enable */
//      vuint32_t  :1;
//      vuint32_t IDAM:2;                /* ID Acceptance Mode */
//      vuint32_t  :1;
//      vuint32_t MAXMB:7;               /* Number Of The Last Message Buffer */
//    } B;
//  } MCR;
//
//  union {                              /* Control 1 register */
//    vuint32_t R;
//    struct {
//      vuint32_t PRESDIV:8;             /* Prescaler Division Factor */
//      vuint32_t RJW:2;                 /* Resync Jump Width */
//      vuint32_t PSEG1:3;               /* Phase Segment 1 */
//      vuint32_t PSEG2:3;               /* Phase Segment 2 */
//      vuint32_t BOFFMSK:1;             /* Bus Off Interrupt Mask */
//      vuint32_t ERRMSK:1;              /* Error Interrupt Mask */
//      vuint32_t CLKSRC:1;              /* CAN Engine Clock Source */
//      vuint32_t LPB:1;                 /* Loop Back Mode */
//      vuint32_t TWRNMSK:1;             /* Tx Warning Interrupt Mask */
//      vuint32_t RWRNMSK:1;             /* Rx Warning Interrupt Mask */
//      vuint32_t  :1;
//      vuint32_t  :1;
//      vuint32_t SMP:1;                 /* CAN Bit Sampling */
//      vuint32_t BOFFREC:1;             /* Bus Off Recovery */
//      vuint32_t TSYN:1;                /* Timer Sync */
//      vuint32_t LBUF:1;                /* Lowest Buffer Transmitted First */
//      vuint32_t LOM:1;                 /* Listen-Only Mode */
//      vuint32_t PROPSEG:3;             /* Propagation Segment */
//    } B;
//  } CTRL1;
//
//  union {                              /* Free Running Timer */
//    vuint32_t R;
//    struct {
//      vuint32_t  :16;
//      vuint32_t TIMER:16;              /* Timer Value */
//    } B;
//  } TIMER;
//
//  uint8_t CAN_reserved0[4];
//  union {                              /* Rx Mailboxes Global Mask Register */
//    vuint32_t R;
//    struct {
//      vuint32_t MG:32;                 /* Rx Mailboxes Global Mask Bits */
//    } B;
//  } RXMGMASK;
//
//  union {                              /* Rx 14 Mask register */
//    vuint32_t R;
//    struct {
//      vuint32_t RX14M:32;              /* Rx Buffer 14 Mask Bits */
//    } B;
//  } RX14MASK;
//
//  union {                              /* Rx 15 Mask register */
//    vuint32_t R;
//    struct {
//      vuint32_t RX15M:32;              /* Rx Buffer 15 Mask Bits */
//    } B;
//  } RX15MASK;
//
//  union {                              /* Error Counter */
//    vuint32_t R;
//    struct {
//      vuint32_t RXERRCNT_FAST:8;       /* Receive Error Counter for fast bits */
//      vuint32_t TXERRCNT_FAST:8;       /* Transmit Error Counter for fast bits */
//      vuint32_t RXERRCNT:8;            /* Receive Error Counter */
//      vuint32_t TXERRCNT:8;            /* Transmit Error Counter */
//    } B;
//  } ECR;
//
//  union {                              /* Error and Status 1 register */
//    vuint32_t R;
//    struct {
//      vuint32_t BIT1ERR_FAST:1;        /* Bit1 Error in the Data Phase of CAN FD frames with the BRS bit set */
//      vuint32_t BIT0ERR_FAST:1;        /* Bit0 Error in the Data Phase of CAN FD frames with the BRS bit set */
//      vuint32_t  :1;
//      vuint32_t CRCERR_FAST:1;         /* Cyclic Redundancy Check Error in the CRC field of CAN FD frames with the BRS bit set */
//      vuint32_t FRMERR_FAST:1;         /* Form Error in the Data Phase of CAN FD frames with the BRS bit set */
//      vuint32_t STFERR_FAST:1;         /* Stuffing Error in the Data Phase of CAN FD frames with the BRS bit set */
//      vuint32_t  :4;
//      vuint32_t ERROVR:1;              /* Error Overrun bit */
//      vuint32_t ERRINT_FAST:1;         /* Error Interrupt for errors detected in the Data Phase of CAN FD frames with the BRS bit set */
//      vuint32_t BOFFDONEINT:1;         /* Bus Off Done Interrupt */
//      vuint32_t SYNCH:1;               /* CAN Synchronization Status */
//      vuint32_t TWRNINT:1;             /* Tx Warning Interrupt Flag */
//      vuint32_t RWRNINT:1;             /* Rx Warning Interrupt Flag */
//      vuint32_t BIT1ERR:1;             /* Bit1 Error */
//      vuint32_t BIT0ERR:1;             /* Bit0 Error */
//      vuint32_t ACKERR:1;              /* Acknowledge Error */
//      vuint32_t CRCERR:1;              /* Cyclic Redundancy Check Error */
//      vuint32_t FRMERR:1;              /* Form Error */
//      vuint32_t STFERR:1;              /* Stuffing Error */
//      vuint32_t TXWRN:1;               /* TX Error Warning */
//      vuint32_t RXWRN:1;               /* Rx Error Warning */
//      vuint32_t IDLE:1;
//      vuint32_t TX:1;                  /* FlexCAN In Transmission */
//      vuint32_t FLTCONF:2;             /* Fault Confinement State */
//      vuint32_t RX:1;                  /* FlexCAN In Reception */
//      vuint32_t BOFFINT:1;             /* Bus Off Interrupt */
//      vuint32_t ERRINT:1;              /* Error Interrupt */
//      vuint32_t WAKINT:1;              /* Wake-Up Interrupt */
//    } B;
//  } ESR1;
//
//  union {                              /* Interrupt Masks 2 register */
//    vuint32_t R;
//    struct {
//      vuint32_t BUF63TO32M:32;         /* Buffer MB i Mask */
//    } B;
//  } IMASK2;
//
//  union {                              /* Interrupt Masks 1 register */
//    vuint32_t R;
//    struct {
//      vuint32_t BUF31TO0M:32;          /* Buffer MB i Mask */
//    } B;
//  } IMASK1;
//
//  union {                              /* Interrupt Flags 2 register */
//    vuint32_t R;
//    struct {
//      vuint32_t BUF63TO32I:32;         /* Buffer MB i Interrupt */
//    } B;
//  } IFLAG2;
//
//  union {                              /* Interrupt Flags 1 register */
//    vuint32_t R;
//    struct {
//      vuint32_t BUF31TO8I:24;          /* Buffer MBi Interrupt */
//      vuint32_t BUF7I:1;               /* Buffer MB7 Interrupt Or "Rx FIFO Overflow" */
//      vuint32_t BUF6I:1;               /* Buffer MB6 Interrupt Or "Rx FIFO Warning" */
//      vuint32_t BUF5I:1;               /* Buffer MB5 Interrupt Or "Frames available in Rx FIFO" */
//      vuint32_t BUF4TO1I:4;            /* Buffer MB i Interrupt Or "reserved" */
//      vuint32_t BUF0I:1;               /* Buffer MB0 Interrupt Or "reserved" */
//    } B;
//  } IFLAG1;
//
//  union {                              /* Control 2 register */
//    vuint32_t R;
//    struct {
//      vuint32_t ERRMSK_FAST:1;         /* Error Interrupt Mask for errors detected in the Data Phase of fast CAN FD frames */
//      vuint32_t BOFFDONEMSK:1;         /* Bus Off Done Interrupt Mask */
//      vuint32_t  :1;
//      vuint32_t  :1;
//      vuint32_t RFFN:4;                /* Number Of Rx FIFO Filters */
//      vuint32_t TASD:5;                /* Tx Arbitration Start Delay */
//      vuint32_t MRP:1;                 /* Mailboxes Reception Priority */
//      vuint32_t RRS:1;                 /* Remote Request Storing */
//      vuint32_t EACEN:1;               /* Entire Frame Arbitration Field Comparison Enable For Rx Mailboxes */
//      vuint32_t TIMER_SRC:1;           /* Timer Source */
//      vuint32_t  :15;
//    } B;
//  } CTRL2;
//
//  union {                              /* Error and Status 2 register */
//    vuint32_t R;
//    struct {
//      vuint32_t  :9;
//      vuint32_t LPTM:7;                /* Lowest Priority Tx Mailbox */
//      vuint32_t  :1;
//      vuint32_t VPS:1;                 /* Valid Priority Status */
//      vuint32_t IMB:1;                 /* Inactive Mailbox */
//      vuint32_t  :13;
//    } B;
//  } ESR2;
//
//  uint8_t CAN_reserved1[8];
//  union {                              /* CRC Register */
//    vuint32_t R;
//    struct {
//      vuint32_t  :9;
//      vuint32_t MBCRC:7;               /* CRC Mailbox */
//      vuint32_t  :1;
//      vuint32_t TXCRC:15;              /* Transmitted CRC value */
//    } B;
//  } CRCR;
//
//  union {                              /* Rx FIFO Global Mask register */
//    vuint32_t R;
//    struct {
//      vuint32_t FGM:32;                /* Rx FIFO Global Mask Bits */
//    } B;
//  } RXFGMASK;
//
//  union {                              /* Rx FIFO Information Register */
//    vuint32_t R;
//    struct {
//      vuint32_t  :23;
//      vuint32_t IDHIT:9;               /* Identifier Acceptance Filter Hit Indicator */
//    } B;
//  } RXFIR;
//
//  union {                              /* CAN Bit Timing Register */
//    vuint32_t R;
//    struct {
//      vuint32_t BTF:1;                 /* Bit Timing Format Enable */
//      vuint32_t EPRESDIV:10;           /* Extended Prescaler Division Factor */
//      vuint32_t  :1;
//      vuint32_t ERJW:4;                /* Extended Resync Jump Width */
//      vuint32_t EPROPSEG:6;            /* Extended Propagation Segment */
//      vuint32_t EPSEG1:5;              /* Extended Phase Segment 1 */
//      vuint32_t EPSEG2:5;              /* Extended Phase Segment 2 */
//    } B;
//  } CBT;
//
//  uint8_t CAN_reserved2[24];
//  union {                              /* Interrupt Masks 3 Register */
//    vuint32_t R;
//    struct {
//      vuint32_t BUF95TO64M:32;         /* Buffer MB i Mask */
//    } B;
//  } IMASK3;
//
//  uint8_t CAN_reserved3[4];
//  union {                              /* Interrupt Flags 3 Register */
//    vuint32_t R;
//    struct {
//      vuint32_t BUF95TO64:32;          /* Buffer MB i Interrupt */
//    } B;
//  } IFLAG3;
//
//  uint8_t CAN_reserved4[8];
//  struct {
//    union {                            /* Message Buffer 0 CS Register */
//      vuint32_t R;
//      struct {
//        vuint32_t  :4;
//        vuint32_t CODE:4;              /* Message Buffer Code */
//        vuint32_t  :1;
//        vuint32_t SRR:1;               /* Substitute Remote Request. Contains a fixed recessive bit. */
//        vuint32_t IDE:1;               /* ID Extended. One/zero for extended/standard format frame. */
//        vuint32_t RTR:1;               /* Remote Transmission Request. One/zero for remote/data frame. */
//        vuint32_t DLC:4;               /* Length of the data to be stored/transmitted. */
//        vuint32_t TIMESTAMP:16;        /* Free-Running Counter Time stamp. This 16-bit field is a copy of the Free-Running Timer, captured for Tx and Rx frames at the time when the beginning of the Identifier field appears on the CAN bus. */
//      } B;
//    } CS;
//    union {                            /* Message Buffer 0 ID Register */
//      vuint32_t R;
//      struct {
//        vuint32_t PRIO:3;              /* Local Priority */
//        vuint32_t ID_STD:11;           /* Frame Identifier Standard */
//        vuint32_t ID_EXT:18;           /* Frame Identifier Extended */
//      } B;
//    } ID;
//    union {
//      vuint8_t B[8];
//      vuint16_t H[4];
//      vuint32_t W[2];
//    } DATA;
//  } MB[64];
//
//  uint8_t CAN_reserved5[1024];
//  union {                              /* Rx Individual Mask Registers */
//    vuint32_t R;
//    struct {
//      vuint32_t MI:32;                 /* Individual Mask Bits */
//    } B;
//  } RXIMR[64];
//
//  uint8_t CAN_reserved6[384];
//  union {                              /* Pretended Networking Control 1 Register */
//    vuint32_t R;
//    struct {
//      vuint32_t  :14;
//      vuint32_t WTOF_MSK:1;            /* Wake Up by Timeout Flag Mask Bit */
//      vuint32_t WUMF_MSK:1;            /* Wake Up by Match Flag Mask Bit */
//      vuint32_t NMATCH:8;              /* Number of Messages Matching the Same Filtering Criteria */
//      vuint32_t  :2;
//      vuint32_t PLFS:2;                /* Payload Filtering Selection */
//      vuint32_t IDFS:2;                /* ID Filtering Selection */
//      vuint32_t FCS:2;                 /* Filtering Combination Selection */
//    } B;
//  } CTRL1_PN;
//
//  union {                              /* Pretended Networking Control 2 Register */
//    vuint32_t R;
//    struct {
//      vuint32_t  :16;
//      vuint32_t MATCHTO:16;            /* Timeout for No Message Matching the Filtering Criteria */
//    } B;
//  } CTRL2_PN;
//
//  union {                              /* Pretended Networking Wake Up Match Register */
//    vuint32_t R;
//    struct {
//      vuint32_t  :14;
//      vuint32_t WTOF:1;                /* Wake Up by Timeout Flag Bit */
//      vuint32_t WUMF:1;                /* Wake Up by Match Flag Bit */
//      vuint32_t MCOUNTER:8;            /* Number of Matches while in Pretended Networking */
//      vuint32_t  :8;
//    } B;
//  } WU_MTC;
//
//  union {                              /* Pretended Networking ID Filter 1 Register */
//    vuint32_t R;
//    struct {
//      vuint32_t  :1;
//      vuint32_t FLT_IDE:1;             /* ID Extended Filter */
//      vuint32_t FLT_RTR:1;             /* Remote Transmission Request Filter */
//      vuint32_t FLT_ID1:29;            /* ID Filter 1 for Pretended Networking filtering */
//    } B;
//  } FLT_ID1;
//
//  union {                              /* Pretended Networking DLC Filter Register */
//    vuint32_t R;
//    struct {
//      vuint32_t  :12;
//      vuint32_t FLT_DLC_LO:4;          /* Lower Limit for Length of Data Bytes Filter */
//      vuint32_t  :12;
//      vuint32_t FLT_DLC_HI:4;          /* Upper Limit for Length of Data Bytes Filter */
//    } B;
//  } FLT_DLC;
//
//  union {                              /* Pretended Networking Payload Low Filter 1 Register */
//    vuint32_t R;
//    struct {
//      vuint32_t Data_byte_0:8;         /* Payload Filter 1 low order bits for Pretended Networking payload filtering corresponding to the data byte 0. */
//      vuint32_t Data_byte_1:8;         /* Payload Filter 1 low order bits for Pretended Networking payload filtering corresponding to the data byte 1. */
//      vuint32_t Data_byte_2:8;         /* Payload Filter 1 low order bits for Pretended Networking payload filtering corresponding to the data byte 2. */
//      vuint32_t Data_byte_3:8;         /* Payload Filter 1 low order bits for Pretended Networking payload filtering corresponding to the data byte 3. */
//    } B;
//  } PL1_LO;
//
//  union {                              /* Pretended Networking Payload High Filter 1 Register */
//    vuint32_t R;
//    struct {
//      vuint32_t Data_byte_4:8;         /* Payload Filter 1 high order bits for Pretended Networking payload filtering corresponding to the data byte 4. */
//      vuint32_t Data_byte_5:8;         /* Payload Filter 1 high order bits for Pretended Networking payload filtering corresponding to the data byte 5. */
//      vuint32_t Data_byte_6:8;         /* Payload Filter 1 high order bits for Pretended Networking payload filtering corresponding to the data byte 6. */
//      vuint32_t Data_byte_7:8;         /* Payload Filter 1 high order bits for Pretended Networking payload filtering corresponding to the data byte 7. */
//    } B;
//  } PL1_HI;
//
//  union {                              /* Pretended Networking ID Filter 2 Register / ID Mask Register */
//    vuint32_t R;
//    struct {
//      vuint32_t  :1;
//      vuint32_t IDE_MSK:1;             /* ID Extended Mask Bit */
//      vuint32_t RTR_MSK:1;             /* Remote Transmission Request Mask Bit */
//      vuint32_t FLT_ID2_IDMASK:29;     /* ID Filter 2 for Pretended Networking Filtering / ID Mask Bits for Pretended Networking ID Filtering */
//    } B;
//  } FLT_ID2_IDMASK;
//
//  union {                              /* Pretended Networking Payload Low Filter 2 Register / Payload Low Mask Register */
//    vuint32_t R;
//    struct {
//      vuint32_t Data_byte_0:8;         /* Payload Filter 2 low order bits / Payload Mask low order bits for Pretended Networking payload filtering corresponding to the data byte 0. */
//      vuint32_t Data_byte_1:8;         /* Payload Filter 2 low order bits / Payload Mask low order bits for Pretended Networking payload filtering corresponding to the data byte 1. */
//      vuint32_t Data_byte_2:8;         /* Payload Filter 2 low order bits / Payload Mask low order bits for Pretended Networking payload filtering corresponding to the data byte 2. */
//      vuint32_t Data_byte_3:8;         /* Payload Filter 2 low order bits / Payload Mask low order bits for Pretended Networking payload filtering corresponding to the data byte 3. */
//    } B;
//  } PL2_PLMASK_LO;
//
//  union {                              /* Pretended Networking Payload High Filter 2 low order bits / Payload High Mask Register */
//    vuint32_t R;
//    struct {
//      vuint32_t Data_byte_4:8;         /* Payload Filter 2 high order bits / Payload Mask high order bits for Pretended Networking payload filtering corresponding to the data byte 4. */
//      vuint32_t Data_byte_5:8;         /* Payload Filter 2 high order bits / Payload Mask high order bits for Pretended Networking payload filtering corresponding to the data byte 5. */
//      vuint32_t Data_byte_6:8;         /* Payload Filter 2 high order bits / Payload Mask high order bits for Pretended Networking payload filtering corresponding to the data byte 6. */
//      vuint32_t Data_byte_7:8;         /* Payload Filter 2 high order bits / Payload Mask high order bits for Pretended Networking payload filtering corresponding to the data byte 7. */
//    } B;
//  } PL2_PLMASK_HI;
//
//  uint8_t CAN_reserved7[24];
//  struct {
//    union {                            /* Wake Up Message Buffer Register for C/S */
//      vuint32_t R;
//      struct {
//        vuint32_t  :9;
//        vuint32_t SRR:1;               /* Substitute Remote Request */
//        vuint32_t IDE:1;               /* ID Extended Bit */
//        vuint32_t RTR:1;               /* Remote Transmission Request Bit */
//        vuint32_t DLC:4;               /* Length of Data in Bytes */
//        vuint32_t  :16;
//      } B;
//    } CS;
//    union {                            /* Wake Up Message Buffer Register for ID */
//      vuint32_t R;
//      struct {
//        vuint32_t  :3;
//        vuint32_t ID:29;               /* Received ID under Pretended Networking mode */
//      } B;
//    } ID;
//    union {                            /* Wake Up Message Buffer Register for Data 0-3 */
//      vuint32_t R;
//      struct {
//        vuint32_t Data_byte_0:8;       /* Received payload corresponding to the data byte 0 under Pretended Networking mode */
//        vuint32_t Data_byte_1:8;       /* Received payload corresponding to the data byte 1 under Pretended Networking mode */
//        vuint32_t Data_byte_2:8;       /* Received payload corresponding to the data byte 2 under Pretended Networking mode */
//        vuint32_t Data_byte_3:8;       /* Received payload corresponding to the data byte 3 under Pretended Networking mode */
//      } B;
//    } D03;
//    union {                            /* Wake Up Message Buffer Register Data 4-7 */
//      vuint32_t R;
//      struct {
//        vuint32_t Data_byte_4:8;       /* Received payload corresponding to the data byte 4 under Pretended Networking mode */
//        vuint32_t Data_byte_5:8;       /* Received payload corresponding to the data byte 5 under Pretended Networking mode */
//        vuint32_t Data_byte_6:8;       /* Received payload corresponding to the data byte 6 under Pretended Networking mode */
//        vuint32_t Data_byte_7:8;       /* Received payload corresponding to the data byte 7 under Pretended Networking mode */
//      } B;
//    } D47;
//  } WMB[4];
//
//  uint8_t CAN_reserved8[128];
//  union {                              /* CAN FD Control Register */
//    vuint32_t R;
//    struct {
//      vuint32_t FDRATE:1;              /* Bit Rate Switch Enable */
//      vuint32_t  :4;
//      vuint32_t  :2;
//      vuint32_t  :1;
//      vuint32_t MBDSR2:2;              /* Message Buffer Data Size for Region 2 */
//      vuint32_t  :1;
//      vuint32_t MBDSR1:2;              /* Message Buffer Data Size for Region 1 */
//      vuint32_t  :1;
//      vuint32_t MBDSR0:2;              /* Message Buffer Data Size for Region 0 */
//      vuint32_t TDCEN:1;               /* Transceiver Delay Compensation Enable */
//      vuint32_t TDCFAIL:1;             /* Transceiver Delay Compensation Fail */
//      vuint32_t  :1;
//      vuint32_t TDCOFF:5;              /* Transceiver Delay Compensation Offset */
//      vuint32_t  :2;
//      vuint32_t TDCVAL:6;              /* Transceiver Delay Compensation Value */
//    } B;
//  } FDCTRL;
//
//  union {                              /* CAN FD Bit Timing Register */
//    vuint32_t R;
//    struct {
//      vuint32_t  :2;
//      vuint32_t FPRESDIV:10;           /* Fast Prescaler Division Factor */
//      vuint32_t  :2;
//      vuint32_t FRJW:2;                /* Fast Resync Jump Width */
//      vuint32_t  :1;
//      vuint32_t FPROPSEG:5;            /* Fast Propagation Segment */
//      vuint32_t  :2;
//      vuint32_t FPSEG1:3;              /* Fast Phase Segment 1 */
//      vuint32_t  :2;
//      vuint32_t FPSEG2:3;              /* Fast Phase Segment 2 */
//    } B;
//  } FDCBT;
//
//  union {                              /* CAN FD CRC Register */
//    vuint32_t R;
//    struct {
//      vuint32_t  :1;
//      vuint32_t FD_MBCRC:7;            /* CRC Mailbox Number for FD_TXCRC */
//      vuint32_t  :3;
//      vuint32_t FD_TXCRC:21;           /* Extended Transmitted CRC value */
//    } B;
//  } FDCRC;
//};



struct CAN_1_7_tag {
  union {
    vuint32_t R;
      struct {
        vuint32_t MDIS:1;					 /* Module Disable */
        vuint32_t FRZ:1;					 /* Freeze Enable */
        vuint32_t RFEN:1;					 /* Rx FIFO Enable */
        vuint32_t HALT:1;					 /* Halt FlexCAN */
        vuint32_t NOTRDY:1;					 /* FlexCAN Not Ready */
        vuint32_t  :1;					 /*  */
        vuint32_t SOFTRST:1;					 /* Soft Reset */
        vuint32_t FRZACK:1;					 /* Freeze Mode Acknowledge */
        vuint32_t SUPV:1;					 /* Supervisor Mode */
        vuint32_t  :1;					 /*  */
        vuint32_t WRNEN:1;					 /* Warning Interrupt Enable */
        vuint32_t LPMACK:1;					 /* Low-Power Mode Acknowledge */
        vuint32_t  :1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t SRXDIS:1;					 /* Self Reception Disable */
        vuint32_t IRMQ:1;					 /* Individual Rx Masking And Queue Enable */
        vuint32_t DMA:1;					 /* DMA Enable */
        vuint32_t  :1;					 /*  */
        vuint32_t LPRIOEN:1;					 /* Local Priority Enable */
        vuint32_t AEN:1;					 /* Abort Enable */
        vuint32_t  :2;					 /*  */
        vuint32_t IDAM:2;					 /* ID Acceptance Mode */
        vuint32_t  :1;					 /*  */
        vuint32_t MAXMB:7;					 /* Number Of The Last Message Buffer */
    } B;
  } MCR;

  union {
    vuint32_t R;
      struct {
        vuint32_t PRESDIV:8;					 /* Prescaler Division Factor */
        vuint32_t RJW:2;					 /* Resync Jump Width */
        vuint32_t PSEG1:3;					 /* Phase Segment 1 */
        vuint32_t PSEG2:3;					 /* Phase Segment 2 */
        vuint32_t BOFFMSK:1;					 /* Bus Off Mask */
        vuint32_t ERRMSK:1;					 /* Error Mask */
        vuint32_t CLKSRC:1;					 /* CAN Engine Clock Source */
        vuint32_t LPB:1;					 /* Loop Back Mode */
        vuint32_t TWRNMSK:1;					 /* Tx Warning Interrupt Mask */
        vuint32_t RWRNMSK:1;					 /* Rx Warning Interrupt Mask */
        vuint32_t  :2;					 /*  */
        vuint32_t SMP:1;					 /* CAN Bit Sampling */
        vuint32_t BOFFREC:1;					 /* Bus Off Recovery */
        vuint32_t TSYN:1;					 /* Timer Sync */
        vuint32_t LBUF:1;					 /* Lowest Buffer Transmitted First */
        vuint32_t LOM:1;					 /* Listen-Only Mode */
        vuint32_t PROPSEG:3;					 /* Propagation Segment */
    } B;
  } CTRL1;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :16;					 /*  */
        vuint32_t TIMER:16;					 /* Timer Value */
    } B;
  } TIMER;

  uint8_t CAN_reserved0[4];
  union {
    vuint32_t R;
      struct {
        vuint32_t MG:32;					 /* Rx Mailboxes Global Mask Bits */
    } B;
  } RXMGMASK;

  union {
    vuint32_t R;
      struct {
        vuint32_t RX14M:32;					 /* Rx Buffer 14 Mask Bits */
    } B;
  } RX14MASK;

  union {
    vuint32_t R;
      struct {
        vuint32_t RX15M:32;					 /* Rx Buffer 15 Mask Bits */
    } B;
  } RX15MASK;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :16;					 /*  */
        vuint32_t RXERRCNT:8;					 /* Receive Error Counter */
        vuint32_t TXERRCNT:8;					 /* Transmit Error Counter */
    } B;
  } ECR;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :13;					 /*  */
        vuint32_t SYNCH:1;					 /* CAN Synchronization Status */
        vuint32_t TWRNINT:1;					 /* Tx Warning Interrupt Flag */
        vuint32_t RWRNINT:1;					 /* Rx Warning Interrupt Flag */
        vuint32_t BIT1ERR:1;					 /* Bit1 Error */
        vuint32_t BIT0ERR:1;					 /* Bit0 Error */
        vuint32_t ACKERR:1;					 /* Acknowledge Error */
        vuint32_t CRCERR:1;					 /* Cyclic Redundancy Check Error */
        vuint32_t FRMERR:1;					 /* Form Error */
        vuint32_t STFERR:1;					 /* Stuffing Error */
        vuint32_t TXWRN:1;					 /* TX Error Warning */
        vuint32_t RXWRN:1;					 /* Rx Error Warning */
        vuint32_t IDLE:1;					 /*  */
        vuint32_t TX:1;					 /* FlexCAN In Transmission */
        vuint32_t FLTCONF:2;					 /* Fault Confinement State */
        vuint32_t RX:1;					 /* FlexCAN In Reception */
        vuint32_t BOFFINT:1;					 /* Bus Off Interrupt */
        vuint32_t ERRINT:1;					 /* Error Interrupt */
        vuint32_t  :1;					 /*  */
    } B;
  } ESR1;

  union {
    vuint32_t R;
      struct {
        vuint32_t BUFHM:32;					 /* Buffer MB i Mask */
    } B;
  } IMASK2;

  union {
    vuint32_t R;
      struct {
        vuint32_t BUFLM:32;					 /* Buffer MB i Mask */
    } B;
  } IMASK1;

  union {
    vuint32_t R;
      struct {
        vuint32_t BUFHI:32;					 /* Buffer MB i Interrupt */
    } B;
  } IFLAG2;

  union {
    vuint32_t R;
      struct {
        vuint32_t BUF31TO8I:24;					 /* Buffer MBi Interrupt */
        vuint32_t BUF7I:1;					 /* Buffer MB7 Interrupt Or "Rx FIFO Overflow" */
        vuint32_t BUF6I:1;					 /* Buffer MB6 Interrupt Or "Rx FIFO Warning" */
        vuint32_t BUF5I:1;					 /* Buffer MB5 Interrupt Or "Frames available in Rx FIFO" */
        vuint32_t BUF4TO1I:4;					 /* Buffer MB i Interrupt Or "reserved" */
        vuint32_t BUF0I:1;					 /* Buffer MB0 Interrupt Or Clear FIFO bit */
    } B;
  } IFLAG1;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :2;					 /*  */
        vuint32_t ECRWRE:1;					 /* Error-correction Configuration Register Write Enable */
        vuint32_t WRMFRZ:1;					 /* Write-Access To Memory In Freeze Mode */
        vuint32_t RFFN:4;					 /* Number Of Rx FIFO Filters */
        vuint32_t TASD:5;					 /* Tx Arbitration Start Delay */
        vuint32_t MRP:1;					 /* Mailboxes Reception Priority */
        vuint32_t RRS:1;					 /* Remote Request Storing */
        vuint32_t EACEN:1;					 /* Entire Frame Arbitration Field Comparison Enable For Rx Mailboxes */
        vuint32_t  :16;					 /*  */
    } B;
  } CTRL2;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :9;					 /*  */
        vuint32_t LPTM:7;					 /* Lowest Priority Tx Mailbox */
        vuint32_t  :1;					 /*  */
        vuint32_t VPS:1;					 /* Valid Priority Status */
        vuint32_t IMB:1;					 /* Inactive Mailbox */
        vuint32_t  :13;					 /*  */
    } B;
  } ESR2;

  uint8_t CAN_reserved1[8];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :9;					 /*  */
        vuint32_t MBCRC:7;					 /* CRC Mailbox */
        vuint32_t  :1;					 /*  */
        vuint32_t TXCRC:15;					 /* CRC Transmitted */
    } B;
  } CRCR;

  union {
    vuint32_t R;
      struct {
        vuint32_t FGM:32;					 /* Rx FIFO Global Mask Bits */
    } B;
  } RXFGMASK;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :23;					 /*  */
        vuint32_t IDHIT:9;					 /* Identifier Acceptance Filter Hit Indicator */
    } B;
  } RXFIR;

  union {
      vuint32_t R;
      struct {
	  vuint32_t BTF: 1;				/* 1 */
	  vuint32_t EPRESDIV: 10;			/* 1 */
	  vuint32_t: 1;
	  vuint32_t ERJW: 4;				/* 1 */
	  vuint32_t EPROPSEG: 6;				/* 1 */
	  vuint32_t EPSEG1: 5;				/* 1 */
	  vuint32_t EPSEG2: 5;				/* 1 */
      } B;
  } CBT;	/* Register offset is 0x050 */

  uint8_t CAN_reserved2[24];

  union {
    vuint32_t R;
      struct {
        vuint32_t BUF95TO64M:32;					 /* Buffer MB i Mask */
    } B;
  } IMASK3;

  uint8_t CAN_reserved3[4];

  union {
    vuint32_t R;
      struct {
        vuint32_t BUF95TO64M:32;					 /* Buffer MB i Interrupt */
    } B;
  } IFLAG3;
  
  uint8_t CAN_reserved4[8];
    
  union {    
      struct MB_t {
	  union {                            /* Message Buffer 0 CS Register */
	      vuint32_t R;
	      struct {
		  vuint32_t EDL:1;
		  vuint32_t BRS:1;
		  vuint32_t ESI:1;
		  vuint32_t  :1;
		  vuint32_t CODE:4;              /* Message Buffer Code */
		  vuint32_t  :1;
		  vuint32_t SRR:1;               /* Substitute Remote Request. Contains a fixed recessive bit. */
		  vuint32_t IDE:1;               /* ID Extended. One/zero for extended/standard format frame. */
		  vuint32_t RTR:1;               /* Remote Transmission Request. One/zero for remote/data frame. */
		  vuint32_t DLC:4;               /* Length of the data to be stored/transmitted. */
		  vuint32_t TIMESTAMP:16;        /* Free-Running Counter Time stamp. This 16-bit field is a copy of the Free-Running Timer, captured for Tx and Rx frames at the time when the beginning of the Identifier field appears on the CAN bus. */
	      } B;
	  } CS;
	  union {                            /* Message Buffer 0 ID Register */
	      vuint32_t R;
	      struct {
		  vuint32_t PRIO:3;              /* Local Priority */
		  vuint32_t ID_STD:11;           /* Frame Identifier Standard */
		  vuint32_t ID_EXT:18;           /* Frame Identifier Extended */
	      } B;
	  } ID;
	  union {
	      vuint8_t B[8];
	      vuint16_t H[4];
	      vuint32_t W[2];
	  } DATA;
      } MB[96];

      struct MB_prt {
	  union {
	      struct MB_pld8 {
		  union {                            /* Message Buffer 0 CS Register */
		      vuint32_t R;
		      struct {
			  vuint32_t EDL:1;
			  vuint32_t BRS:1;
			  vuint32_t ESI:1;
			  vuint32_t  :1;
			  vuint32_t CODE:4;              /* Message Buffer Code */
			  vuint32_t  :1;
			  vuint32_t SRR:1;               /* Substitute Remote Request. Contains a fixed recessive bit. */
			  vuint32_t IDE:1;               /* ID Extended. One/zero for extended/standard format frame. */
			  vuint32_t RTR:1;               /* Remote Transmission Request. One/zero for remote/data frame. */
			  vuint32_t DLC:4;               /* Length of the data to be stored/transmitted. */
			  vuint32_t TIMESTAMP:16;        /* Free-Running Counter Time stamp. This 16-bit field is a copy of the Free-Running Timer, captured for Tx and Rx frames at the time when the beginning of the Identifier field appears on the CAN bus. */
		      } B;
		  } CS;
		  union {                            /* Message Buffer 0 ID Register */
		      vuint32_t R;
		      struct {
			  vuint32_t PRIO:3;              /* Local Priority */
			  vuint32_t ID_STD:11;           /* Frame Identifier Standard */
			  vuint32_t ID_EXT:18;           /* Frame Identifier Extended */
		      } B;
		  } ID;
		  union {
		      vuint8_t  B[8];
		      vuint16_t H[4];
		      vuint32_t W[2];
		  } DATA;
	      } MB1[32];

	      struct MB_pld16 {
		  union {                            /* Message Buffer 0 CS Register */
		      vuint32_t R;
		      struct {
			  vuint32_t EDL:1;
			  vuint32_t BRS:1;
			  vuint32_t ESI:1;
			  vuint32_t  :1;
			  vuint32_t CODE:4;              /* Message Buffer Code */
			  vuint32_t  :1;
			  vuint32_t SRR:1;               /* Substitute Remote Request. Contains a fixed recessive bit. */
			  vuint32_t IDE:1;               /* ID Extended. One/zero for extended/standard format frame. */
			  vuint32_t RTR:1;               /* Remote Transmission Request. One/zero for remote/data frame. */
			  vuint32_t DLC:4;               /* Length of the data to be stored/transmitted. */
			  vuint32_t TIMESTAMP:16;        /* Free-Running Counter Time stamp. This 16-bit field is a copy of the Free-Running Timer, captured for Tx and Rx frames at the time when the beginning of the Identifier field appears on the CAN bus. */
		      } B;
		  } CS;
		  union {                            /* Message Buffer 0 ID Register */
		      vuint32_t R;
		      struct {
			  vuint32_t PRIO:3;              /* Local Priority */
			  vuint32_t ID_STD:11;           /* Frame Identifier Standard */
			  vuint32_t ID_EXT:18;           /* Frame Identifier Extended */
		      } B;
		  } ID;
		  union {
		      vuint8_t  B[16];
		      vuint16_t H[8];
		      vuint32_t W[4];
		  } DATA;
	      } MB2[21];

	      struct MB_pld32 {
		  union {                            /* Message Buffer 0 CS Register */
		      vuint32_t R;
		      struct {
			  vuint32_t EDL:1;
			  vuint32_t BRS:1;
			  vuint32_t ESI:1;
			  vuint32_t  :1;
			  vuint32_t CODE:4;              /* Message Buffer Code */
			  vuint32_t  :1;
			  vuint32_t SRR:1;               /* Substitute Remote Request. Contains a fixed recessive bit. */
			  vuint32_t IDE:1;               /* ID Extended. One/zero for extended/standard format frame. */
			  vuint32_t RTR:1;               /* Remote Transmission Request. One/zero for remote/data frame. */
			  vuint32_t DLC:4;               /* Length of the data to be stored/transmitted. */
			  vuint32_t TIMESTAMP:16;        /* Free-Running Counter Time stamp. This 16-bit field is a copy of the Free-Running Timer, captured for Tx and Rx frames at the time when the beginning of the Identifier field appears on the CAN bus. */
		      } B;
		  } CS;
		  union {                            /* Message Buffer 0 ID Register */
		      vuint32_t R;
		      struct {
			  vuint32_t PRIO:3;              /* Local Priority */
			  vuint32_t ID_STD:11;           /* Frame Identifier Standard */
			  vuint32_t ID_EXT:18;           /* Frame Identifier Extended */
		      } B;
		  } ID;
		  union {
		      vuint8_t  B[32];
		      vuint16_t H[16];
		      vuint32_t W[8];
		  } DATA;
	      } MB3[12];

	      struct MB_pld64 {
		  union {                            /* Message Buffer 0 CS Register */
		      vuint32_t R;
		      struct {
			  vuint32_t EDL:1;
			  vuint32_t BRS:1;
			  vuint32_t ESI:1;
			  vuint32_t  :1;
			  vuint32_t CODE:4;              /* Message Buffer Code */
			  vuint32_t  :1;
			  vuint32_t SRR:1;               /* Substitute Remote Request. Contains a fixed recessive bit. */
			  vuint32_t IDE:1;               /* ID Extended. One/zero for extended/standard format frame. */
			  vuint32_t RTR:1;               /* Remote Transmission Request. One/zero for remote/data frame. */
			  vuint32_t DLC:4;               /* Length of the data to be stored/transmitted. */
			  vuint32_t TIMESTAMP:16;        /* Free-Running Counter Time stamp. This 16-bit field is a copy of the Free-Running Timer, captured for Tx and Rx frames at the time when the beginning of the Identifier field appears on the CAN bus. */
		      } B;
		  } CS;
		  union {                            /* Message Buffer 0 ID Register */
		      vuint32_t R;
		      struct {
			  vuint32_t PRIO:3;              /* Local Priority */
			  vuint32_t ID_STD:11;           /* Frame Identifier Standard */
			  vuint32_t ID_EXT:18;           /* Frame Identifier Extended */
		      } B;
		  } ID;
		  union {
		      vuint8_t  B[64];
		      vuint16_t H[32];
		      vuint32_t W[16];
		  } DATA;
	      } MB4[7];
	  } PAYLOAD;
      }PRT[3];
  }MODE;
    
  uint8_t CAN_reserved2a[512];

  union {
    vuint32_t R;
      struct {
        vuint32_t MI:32;					 /* Individual Mask Bits */
    } B;
  } RXIMR[64];

  uint8_t CAN_reserved5[352];
  union {
    vuint32_t R;
      struct {
        vuint32_t ECRWRDIS:1;					 /* Error Configuration Register Write Disable */
        vuint32_t  :11;					 /*  */
        vuint32_t HANCEI_MSK:1;					 /* Host Access With Non-Correctable Errors Interrupt Mask */            
        vuint32_t FANCEI_MSK:1;					 /* FlexCAN Access With Non-Correctable Errors Interrupt Mask */
        vuint32_t  :1;					 /*  */
        vuint32_t CEI_MSK:1;					 /* Correctable Errors Interrupt Mask */
        vuint32_t HAERRIE:1;					 /* Host Access Error Injection Enable */
        vuint32_t FAERRIE:1;					 /* FlexCAN Access Error Injection Enable */
        vuint32_t EXTERRIE:1;					 /* Extended Error Injection Enable */
        vuint32_t  :3;					 /*  */
        vuint32_t RERRDIS:1;					 /* Error Report Disable */
        vuint32_t ECCDIS:1;					 /* Error Correction Disable */
        vuint32_t NCEFAFRZ:1;					 /* Non-Correctable Errors In FlexCAN Access Put Device In Freeze Mode */
        vuint32_t  :7;					 /*  */
    } B;
  } MECR;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :18;					 /*  */
        vuint32_t INJADDR:14;					 /* Address Where Error Is To Be Injected */
    } B;
  } ERRIAR;

  union {
    vuint32_t R;
      struct {
        vuint32_t DFLIP:32;					 /* Data flip pattern */
    } B;
  } ERRIDPR;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :3;					 /*  */
        vuint32_t PFLIP3:5;					 /* Parity Flip Pattern For Byte 3 (most significant) */
        vuint32_t  :3;					 /*  */
        vuint32_t PFLIP2:5;					 /* Parity Flip Pattern For Byte 2 */
        vuint32_t  :3;					 /*  */
        vuint32_t PFLIP1:5;					 /* Parity Flip Pattern For Byte 1 */
        vuint32_t  :3;					 /*  */
        vuint32_t PFLIP0:5;					 /* Parity Flip Pattern For Byte 0 (Least Significant) */
    } B;
  } ERRIPPR;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :7;					 /*  */
        vuint32_t NCE:1;					 /* Non-Correctable Error */
        vuint32_t  :5;					 /*  */
        vuint32_t SAID:3;					 /*  */
        vuint32_t  :2;					 /*  */
        vuint32_t ERRADDR:14;					 /* Address Where The Error Was Detected */
    } B;
  } RERRAR;

  union {
    vuint32_t R;
      struct {
        vuint32_t RDATA:32;					 /* Raw data word read from memory with error */
    } B;
  } RERRDR;

  union {
    vuint32_t R;
      struct {
        vuint32_t BE3:1;					 /* Byte Enabled For Byte 3 (Most Significant) */
        vuint32_t  :2;					 /*  */
        vuint32_t SYND3:5;					 /* Error Syndrome For Byte 3 (Most Significant) */
        vuint32_t BE2:1;					 /* Byte Enabled For Byte 2 */
        vuint32_t  :2;					 /*  */
        vuint32_t SYND2:5;					 /* Error Syndrome For Byte 2 */
        vuint32_t BE1:1;					 /* Byte Enabled For Byte 1 */
        vuint32_t  :2;					 /*  */
        vuint32_t SYND1:5;					 /* Error Syndrome for Byte 1 */
        vuint32_t BE0:1;					 /* Byte Enabled For Byte 0 (least significant) */
        vuint32_t  :2;					 /*  */
        vuint32_t SYND0:5;					 /* Error Syndrome For Byte 0 (least significant) */
    } B;
  } RERRSYNR;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t HANCEIF:1;					 /* Host Access With Non-Correctable Error Interrupt Flag */
        vuint32_t FANCEIF:1;					 /* FlexCAN Access With Non-Correctable Error Interrupt Flag */
        vuint32_t  :1;					 /*  */
        vuint32_t CEIF:1;					 /* Correctable Error Interrupt Flag */
        vuint32_t  :12;					 /*  */
        vuint32_t HANCEIOF:1;					 /* Host Access With Non-Correctable Error Interrupt Overrun Flag */
        vuint32_t FANCEIOF:1;					 /* FlexCAN Access With Non-Correctable Error Interrupt Overrun Flag */
        vuint32_t  :1;					 /*  */
        vuint32_t CEIOF:1;					 /* Correctable Error Interrupt Overrun Flag */
    } B;
  } ERRSR;

  uint8_t CAN_reserved6[256];

  union {
      vuint32_t R;
      struct {
	  vuint32_t FDRATE: 1;				/* 1 */
	  vuint32_t: 7;
	  vuint32_t MBDSR2: 2;				/* 1 */
	  vuint32_t: 1;
	  vuint32_t MBDSR1: 2;				/* 1 */
	  vuint32_t: 1;
	  vuint32_t MBDSR0: 2;				/* 1 */
	  vuint32_t TDCEN: 1;				/* 1 */
	  vuint32_t TDCFAIL: 1;				/* 1 */
	  vuint32_t: 1;
	  vuint32_t TDCOFF: 5;				/* 1 */
	  vuint32_t: 2;
	  vuint32_t TDCVAL: 6;				/* 1 */
      } B;
  } FDCTRL;	/* Register offset is 0xC00 */

  union {
      vuint32_t R;
      struct {
	  vuint32_t: 2;
	  vuint32_t FPRESDIV: 10;				/* 1 */
	  vuint32_t: 2;
	  vuint32_t FRJW: 2;				/* 1 */
	  vuint32_t: 1;
	  vuint32_t FPROPSEG: 5;				/* 1 */
	  vuint32_t: 2;
	  vuint32_t FPSEG1: 3;				/* 1 */
	  vuint32_t: 2;
	  vuint32_t FPSEG2: 3;				/* 1 */
      } B;
  } FDCBT;	/* Register offset is 0xC04 */

  union {
      vuint32_t R;
      struct {
	  vuint32_t: 1;
	  vuint32_t FD_MBCRC: 7;				/* 1 */
	  vuint32_t: 3;
	  vuint32_t FD_TXCRC: 21;				/* 1 */
      } B;
  } FDCRC;	/* Register offset is 0xC08 */

};


/* ============================================================================
   =============================== Module: CMP ================================
   ============================================================================ */

struct CMP_tag {
  union {                              /* CMP Control Register 0 */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t DMAEN:1;               /* DMA Enable */
      vuint32_t  :1;
      vuint32_t IER:1;                 /* Comparator Interrupt Enable Rising */
      vuint32_t IEF:1;                 /* Comparator Interrupt Enable Falling */
      vuint32_t CFR:1;                 /* Analog Comparator Flag Rising */
      vuint32_t CFF:1;                 /* Analog Comparator Flag Falling */
      vuint32_t COUT:1;                /* Analog Comparator Output */
      vuint32_t FPR:8;                 /* Filter Sample Period */
      vuint32_t SE:1;                  /* Sample Enable */
      vuint32_t WE:1;                  /* Windowing Enable */
      vuint32_t  :1;
      vuint32_t PMODE:1;               /* Power Mode Select */
      vuint32_t INVT:1;                /* Comparator invert */
      vuint32_t COS:1;                 /* Comparator Output Select */
      vuint32_t OPE:1;                 /* Comparator Output Pin Enable */
      vuint32_t EN:1;                  /* Comparator Module Enable */
      vuint32_t  :1;
      vuint32_t FILTER_CNT:3;          /* Filter Sample Count */
      vuint32_t  :2;
      vuint32_t HYSTCTR:2;             /* Comparator hard block hysteresis control */
    } B;
  } C0;

  union {                              /* CMP Control Register 1 */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t  :7;
      vuint32_t CHN7:1;                /* Channel 7 input enable */
      vuint32_t CHN6:1;                /* Channel 6 input enable */
      vuint32_t CHN5:1;                /* Channel 5 input enable */
      vuint32_t CHN4:1;                /* Channel 4 input enable */
      vuint32_t CHN3:1;                /* Channel 3 input enable */
      vuint32_t CHN2:1;                /* Channel 2 input enable */
      vuint32_t CHN1:1;                /* Channel 1 input enable */
      vuint32_t CHN0:1;                /* Channel 0 input enable */
      vuint32_t DPSEL:1;               /* DAC output to Plus side ANMUX selection */
      vuint32_t DMSEL:1;               /* DAC output to Minus side ANMUX selection */
      vuint32_t PSEL:3;                /* Plus Input MUX Control */
      vuint32_t MSEL:3;                /* Minus Input MUX Control */
      vuint32_t DACEN:1;               /* DAC Enable */
      vuint32_t VRSEL:1;               /* Supply Voltage Reference Source Select */
      vuint32_t VOSEL:6;               /* DAC Output Voltage Select */
    } B;
  } C1;

  union {                              /* CMP Control Register 2 */
    vuint32_t R;
    struct {
      vuint32_t RRE:1;                 /* Round-Robin Enable */
      vuint32_t RRIE:1;                /* Round-Robin interrupt enable */
      vuint32_t FXMP:1;                /* Fixed MUX Port */
      vuint32_t FXDACI:1;              /* Fix DAC input to the fixed mux port side */
      vuint32_t FXMXCH:3;              /* Fixed channel selection */
      vuint32_t  :1;
      vuint32_t CH7F:1;
      vuint32_t CH6F:1;
      vuint32_t CH5F:1;
      vuint32_t CH4F:1;
      vuint32_t CH3F:1;
      vuint32_t CH2F:1;
      vuint32_t CH1F:1;
      vuint32_t CH0F:1;
      vuint32_t NSAM:2;                /* Number of sample clocks */
      vuint32_t  :6;
      vuint32_t ACOn:8;
    } B;
  } C2;
};


/* ============================================================================
   =============================== Module: CMU ================================
   ============================================================================ */

struct CMU_tag {
  union {                              /* CMU Control Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t SFM:1;                 /* Start frequency measure. */
      vuint32_t  :13;
      vuint32_t CKSEL1:2;              /* Frequency measure clock selection bit. */
      vuint32_t  :5;
      vuint32_t RCDIV:2;               /* CLKMT0_RMN division factor. */
      vuint32_t CME:1;                 /* CLKMN1 monitor enable. */
    } B;
  } CSR;

  union {                              /* CMU Frequency Display Register */
    vuint32_t R;
    struct {
      vuint32_t  :12;
      vuint32_t FD:20;                 /* Measured frequency bits. */
    } B;
  } FDR;

  union {                              /* CMU High Frequency Reference Register CLKMN1 */
    vuint32_t R;
    struct {
      vuint32_t  :20;
      vuint32_t HFREF:12;              /* High Frequency reference value. */
    } B;
  } HFREFR;

  union {                              /* CMU Low Frequency Reference Register CLKMN1 */
    vuint32_t R;
    struct {
      vuint32_t  :20;
      vuint32_t LFREF:12;              /* Low Frequency reference value. */
    } B;
  } LFREFR;

  union {                              /* CMU Interrupt Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :28;
      vuint32_t  :1;
      vuint32_t FHHI:1;                /* CLKMN1 frequency higher than high reference event status. */
      vuint32_t FLLI:1;                /* CLKMN1 frequency less than low reference event status. */
      vuint32_t OLRI:1;                /* Oscillator frequency less than f CLKMT0_RMN * 2RCDIVevent status. */
    } B;
  } ISR;

  uint8_t CMU_reserved0[4];
  union {                              /* CMU Measurement Duration Register */
    vuint32_t R;
    struct {
      vuint32_t  :12;
      vuint32_t MD:20;                 /* Measurement duration bits */
    } B;
  } MDR;
};


/* ============================================================================
   =============================== Module: CRC ================================
   ============================================================================ */

struct CRC_tag {
  struct {
      union {                              /* Configuration Register */
	  vuint32_t R;
	  struct {
	      vuint32_t  :8;
	      vuint32_t  :18;
	      vuint32_t SWAP_BYTEWISE:1;       /* Swap CRC_INP byte-wise */
	      vuint32_t SWAP_BITWISE:1;        /* Swap CRC_INP bit-wise */
	      vuint32_t POLYG:2;               /* Polynomial selection */
	      vuint32_t SWAP:1;                /* Swap selection */
	      vuint32_t INV:1;                 /* Inversion selection */
	  } B;
      } CFG;

      union {                              /* Input Register */
	  vuint32_t R;
	  struct {
	      vuint32_t INP:32;                /* Input data for the CRC computation */
	  } B;
      } INP;

      union {                              /* Current Status Register */
	  vuint32_t R;
	  struct {
	      vuint32_t CSTAT:32;              /* CRC signature status */
	  } B;
      } CSTAT;

      union {                              /* Output Register */
	  vuint32_t R;
	  struct {
	      vuint32_t OUTP:32;               /* Final CRC signature */
	  } B;
      } OUTP;
  } CNTX[1];
};



/* ============================================================================
   =============================== Module: DMA ================================
   ============================================================================ */

struct DMA_tag {
  union {                              /* Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :14;
      vuint32_t CX:1;                  /* Cancel Transfer */
      vuint32_t ECX:1;                 /* Error Cancel Transfer */
      vuint32_t  :4;
      vuint32_t  :1;
      vuint32_t GRP1PRI:1;             /* Channel Group 1 Priority */
      vuint32_t  :1;
      vuint32_t GRP0PRI:1;             /* Channel Group 0 Priority */
      vuint32_t EMLM:1;                /* Enable Minor Loop Mapping */
      vuint32_t CLM:1;                 /* Continuous Link Mode */
      vuint32_t HALT:1;                /* Halt DMA Operations */
      vuint32_t HOE:1;                 /* Halt On Error */
      vuint32_t ERGA:1;                /* Enable Round Robin Group Arbitration */
      vuint32_t ERCA:1;                /* Enable Round Robin Channel Arbitration */
      vuint32_t EDBG:1;                /* Enable Debug */
      vuint32_t  :1;                   /* Reserved. */
    } B;
  } CR;

  union {                              /* Error Status Register */
    vuint32_t R;
    struct {
      vuint32_t VLD:1;
      vuint32_t  :13;
      vuint32_t UCE:1;                 /* Uncorrectable ECC error during channel execution. */
      vuint32_t ECX:1;                 /* Transfer Canceled */
      vuint32_t GPE:1;                 /* Group Priority Error */
      vuint32_t CPE:1;                 /* Channel Priority Error */
      vuint32_t  :1;
      vuint32_t ERRCHN:5;              /* Error Channel Number or Canceled Channel Number */
      vuint32_t SAE:1;                 /* Source Address Error */
      vuint32_t SOE:1;                 /* Source Offset Error */
      vuint32_t DAE:1;                 /* Destination Address Error */
      vuint32_t DOE:1;                 /* Destination Offset Error */
      vuint32_t NCE:1;                 /* NBYTES/CITER Configuration Error */
      vuint32_t SGE:1;                 /* Scatter/Gather Configuration Error */
      vuint32_t SBE:1;                 /* Source Bus Error */
      vuint32_t DBE:1;                 /* Destination Bus Error */
    } B;
  } ES;

  uint8_t DMA_reserved0[4];
  union {                              /* Enable Request Register */
    vuint32_t R;
    struct {
      vuint32_t ERQ31:1;               /* Enable DMA Request 31 */
      vuint32_t ERQ30:1;               /* Enable DMA Request 30 */
      vuint32_t ERQ29:1;               /* Enable DMA Request 29 */
      vuint32_t ERQ28:1;               /* Enable DMA Request 28 */
      vuint32_t ERQ27:1;               /* Enable DMA Request 27 */
      vuint32_t ERQ26:1;               /* Enable DMA Request 26 */
      vuint32_t ERQ25:1;               /* Enable DMA Request 25 */
      vuint32_t ERQ24:1;               /* Enable DMA Request 24 */
      vuint32_t ERQ23:1;               /* Enable DMA Request 23 */
      vuint32_t ERQ22:1;               /* Enable DMA Request 22 */
      vuint32_t ERQ21:1;               /* Enable DMA Request 21 */
      vuint32_t ERQ20:1;               /* Enable DMA Request 20 */
      vuint32_t ERQ19:1;               /* Enable DMA Request 19 */
      vuint32_t ERQ18:1;               /* Enable DMA Request 18 */
      vuint32_t ERQ17:1;               /* Enable DMA Request 17 */
      vuint32_t ERQ16:1;               /* Enable DMA Request 16 */
      vuint32_t ERQ15:1;               /* Enable DMA Request 15 */
      vuint32_t ERQ14:1;               /* Enable DMA Request 14 */
      vuint32_t ERQ13:1;               /* Enable DMA Request 13 */
      vuint32_t ERQ12:1;               /* Enable DMA Request 12 */
      vuint32_t ERQ11:1;               /* Enable DMA Request 11 */
      vuint32_t ERQ10:1;               /* Enable DMA Request 10 */
      vuint32_t ERQ9:1;                /* Enable DMA Request 9 */
      vuint32_t ERQ8:1;                /* Enable DMA Request 8 */
      vuint32_t ERQ7:1;                /* Enable DMA Request 7 */
      vuint32_t ERQ6:1;                /* Enable DMA Request 6 */
      vuint32_t ERQ5:1;                /* Enable DMA Request 5 */
      vuint32_t ERQ4:1;                /* Enable DMA Request 4 */
      vuint32_t ERQ3:1;                /* Enable DMA Request 3 */
      vuint32_t ERQ2:1;                /* Enable DMA Request 2 */
      vuint32_t ERQ1:1;                /* Enable DMA Request 1 */
      vuint32_t ERQ0:1;                /* Enable DMA Request 0 */
    } B;
  } ERQ;

  uint8_t DMA_reserved1[4];
  union {                              /* Enable Error Interrupt Register */
    vuint32_t R;
    struct {
      vuint32_t EEI31:1;               /* Enable Error Interrupt 31 */
      vuint32_t EEI30:1;               /* Enable Error Interrupt 30 */
      vuint32_t EEI29:1;               /* Enable Error Interrupt 29 */
      vuint32_t EEI28:1;               /* Enable Error Interrupt 28 */
      vuint32_t EEI27:1;               /* Enable Error Interrupt 27 */
      vuint32_t EEI26:1;               /* Enable Error Interrupt 26 */
      vuint32_t EEI25:1;               /* Enable Error Interrupt 25 */
      vuint32_t EEI24:1;               /* Enable Error Interrupt 24 */
      vuint32_t EEI23:1;               /* Enable Error Interrupt 23 */
      vuint32_t EEI22:1;               /* Enable Error Interrupt 22 */
      vuint32_t EEI21:1;               /* Enable Error Interrupt 21 */
      vuint32_t EEI20:1;               /* Enable Error Interrupt 20 */
      vuint32_t EEI19:1;               /* Enable Error Interrupt 19 */
      vuint32_t EEI18:1;               /* Enable Error Interrupt 18 */
      vuint32_t EEI17:1;               /* Enable Error Interrupt 17 */
      vuint32_t EEI16:1;               /* Enable Error Interrupt 16 */
      vuint32_t EEI15:1;               /* Enable Error Interrupt 15 */
      vuint32_t EEI14:1;               /* Enable Error Interrupt 14 */
      vuint32_t EEI13:1;               /* Enable Error Interrupt 13 */
      vuint32_t EEI12:1;               /* Enable Error Interrupt 12 */
      vuint32_t EEI11:1;               /* Enable Error Interrupt 11 */
      vuint32_t EEI10:1;               /* Enable Error Interrupt 10 */
      vuint32_t EEI9:1;                /* Enable Error Interrupt 9 */
      vuint32_t EEI8:1;                /* Enable Error Interrupt 8 */
      vuint32_t EEI7:1;                /* Enable Error Interrupt 7 */
      vuint32_t EEI6:1;                /* Enable Error Interrupt 6 */
      vuint32_t EEI5:1;                /* Enable Error Interrupt 5 */
      vuint32_t EEI4:1;                /* Enable Error Interrupt 4 */
      vuint32_t EEI3:1;                /* Enable Error Interrupt 3 */
      vuint32_t EEI2:1;                /* Enable Error Interrupt 2 */
      vuint32_t EEI1:1;                /* Enable Error Interrupt 1 */
      vuint32_t EEI0:1;                /* Enable Error Interrupt 0 */
    } B;
  } EEI;

  union {                              /* Set Enable Request Register */
    vuint8_t R;
    struct {
      vuint8_t NOP:1;                  /* No Op enable */
      vuint8_t SAER:1;                 /* Set All Enable Requests */
      vuint8_t  :1;
      vuint8_t SERQ:5;                 /* Set Enable Request */
    } B;
  } SERQ;

  union {                              /* Clear Enable Request Register */
    vuint8_t R;
    struct {
      vuint8_t NOP:1;                  /* No Op enable */
      vuint8_t CAER:1;                 /* Clear All Enable Requests */
      vuint8_t  :1;
      vuint8_t CERQ:5;                 /* Clear Enable Request */
    } B;
  } CERQ;

  union {                              /* Set Enable Error Interrupt Register */
    vuint8_t R;
    struct {
      vuint8_t NOP:1;                  /* No Op enable */
      vuint8_t SAEE:1;                 /* Sets All Enable Error Interrupts */
      vuint8_t  :1;
      vuint8_t SEEI:5;                 /* Set Enable Error Interrupt */
    } B;
  } SEEI;

  union {                              /* Clear Enable Error Interrupt Register */
    vuint8_t R;
    struct {
      vuint8_t NOP:1;                  /* No Op enable */
      vuint8_t CAEE:1;                 /* Clear All Enable Error Interrupts */
      vuint8_t  :1;
      vuint8_t CEEI:5;                 /* Clear Enable Error Interrupt */
    } B;
  } CEEI;

  union {                              /* Clear Interrupt Request Register */
    vuint8_t R;
    struct {
      vuint8_t NOP:1;                  /* No Op enable */
      vuint8_t CAIR:1;                 /* Clear All Interrupt Requests */
      vuint8_t  :1;
      vuint8_t CINT:5;                 /* Clear interrupt request */
    } B;
  } CINT;

  union {                              /* Clear Error Register */
    vuint8_t R;
    struct {
      vuint8_t NOP:1;                  /* No Op enable */
      vuint8_t CAEI:1;                 /* Clear All Error Indicators */
      vuint8_t  :1;
      vuint8_t CERR:5;                 /* Clear Error Indicator */
    } B;
  } CERR;

  union {                              /* Set START Bit Register */
    vuint8_t R;
    struct {
      vuint8_t NOP:1;                  /* No Op enable */
      vuint8_t SAST:1;                 /* Set All START Bits (activates all channels) */
      vuint8_t  :1;
      vuint8_t SSRT:5;                 /* Set START Bit */
    } B;
  } SSRT;

  union {                              /* Clear DONE Status Bit Register */
    vuint8_t R;
    struct {
      vuint8_t NOP:1;                  /* No Op enable */
      vuint8_t CADN:1;                 /* Clears All DONE Bits */
      vuint8_t  :1;
      vuint8_t CDNE:5;                 /* Clear DONE Bit */
    } B;
  } CDNE;

  uint8_t DMA_reserved2[4];
  union {                              /* Interrupt Request Register */
    vuint32_t R;
    struct {
      vuint32_t INT31:1;               /* Interrupt Request 31 */
      vuint32_t INT30:1;               /* Interrupt Request 30 */
      vuint32_t INT29:1;               /* Interrupt Request 29 */
      vuint32_t INT28:1;               /* Interrupt Request 28 */
      vuint32_t INT27:1;               /* Interrupt Request 27 */
      vuint32_t INT26:1;               /* Interrupt Request 26 */
      vuint32_t INT25:1;               /* Interrupt Request 25 */
      vuint32_t INT24:1;               /* Interrupt Request 24 */
      vuint32_t INT23:1;               /* Interrupt Request 23 */
      vuint32_t INT22:1;               /* Interrupt Request 22 */
      vuint32_t INT21:1;               /* Interrupt Request 21 */
      vuint32_t INT20:1;               /* Interrupt Request 20 */
      vuint32_t INT19:1;               /* Interrupt Request 19 */
      vuint32_t INT18:1;               /* Interrupt Request 18 */
      vuint32_t INT17:1;               /* Interrupt Request 17 */
      vuint32_t INT16:1;               /* Interrupt Request 16 */
      vuint32_t INT15:1;               /* Interrupt Request 15 */
      vuint32_t INT14:1;               /* Interrupt Request 14 */
      vuint32_t INT13:1;               /* Interrupt Request 13 */
      vuint32_t INT12:1;               /* Interrupt Request 12 */
      vuint32_t INT11:1;               /* Interrupt Request 11 */
      vuint32_t INT10:1;               /* Interrupt Request 10 */
      vuint32_t INT9:1;                /* Interrupt Request 9 */
      vuint32_t INT8:1;                /* Interrupt Request 8 */
      vuint32_t INT7:1;                /* Interrupt Request 7 */
      vuint32_t INT6:1;                /* Interrupt Request 6 */
      vuint32_t INT5:1;                /* Interrupt Request 5 */
      vuint32_t INT4:1;                /* Interrupt Request 4 */
      vuint32_t INT3:1;                /* Interrupt Request 3 */
      vuint32_t INT2:1;                /* Interrupt Request 2 */
      vuint32_t INT1:1;                /* Interrupt Request 1 */
      vuint32_t INT0:1;                /* Interrupt Request 0 */
    } B;
  } INT;

  uint8_t DMA_reserved3[4];
  union {                              /* Error Register */
    vuint32_t R;
    struct {
      vuint32_t ERR31:1;               /* Error In Channel 31 */
      vuint32_t ERR30:1;               /* Error In Channel 30 */
      vuint32_t ERR29:1;               /* Error In Channel 29 */
      vuint32_t ERR28:1;               /* Error In Channel 28 */
      vuint32_t ERR27:1;               /* Error In Channel 27 */
      vuint32_t ERR26:1;               /* Error In Channel 26 */
      vuint32_t ERR25:1;               /* Error In Channel 25 */
      vuint32_t ERR24:1;               /* Error In Channel 24 */
      vuint32_t ERR23:1;               /* Error In Channel 23 */
      vuint32_t ERR22:1;               /* Error In Channel 22 */
      vuint32_t ERR21:1;               /* Error In Channel 21 */
      vuint32_t ERR20:1;               /* Error In Channel 20 */
      vuint32_t ERR19:1;               /* Error In Channel 19 */
      vuint32_t ERR18:1;               /* Error In Channel 18 */
      vuint32_t ERR17:1;               /* Error In Channel 17 */
      vuint32_t ERR16:1;               /* Error In Channel 16 */
      vuint32_t ERR15:1;               /* Error In Channel 15 */
      vuint32_t ERR14:1;               /* Error In Channel 14 */
      vuint32_t ERR13:1;               /* Error In Channel 13 */
      vuint32_t ERR12:1;               /* Error In Channel 12 */
      vuint32_t ERR11:1;               /* Error In Channel 11 */
      vuint32_t ERR10:1;               /* Error In Channel 10 */
      vuint32_t ERR9:1;                /* Error In Channel 9 */
      vuint32_t ERR8:1;                /* Error In Channel 8 */
      vuint32_t ERR7:1;                /* Error In Channel 7 */
      vuint32_t ERR6:1;                /* Error In Channel 6 */
      vuint32_t ERR5:1;                /* Error In Channel 5 */
      vuint32_t ERR4:1;                /* Error In Channel 4 */
      vuint32_t ERR3:1;                /* Error In Channel 3 */
      vuint32_t ERR2:1;                /* Error In Channel 2 */
      vuint32_t ERR1:1;                /* Error In Channel 1 */
      vuint32_t ERR0:1;                /* Error In Channel 0 */
    } B;
  } ERR;

  uint8_t DMA_reserved4[4];
  union {                              /* Hardware Request Status Register */
    vuint32_t R;
    struct {
      vuint32_t HRS31:1;               /* Hardware Request Status Channel 31 */
      vuint32_t HRS30:1;               /* Hardware Request Status Channel 30 */
      vuint32_t HRS29:1;               /* Hardware Request Status Channel 29 */
      vuint32_t HRS28:1;               /* Hardware Request Status Channel 28 */
      vuint32_t HRS27:1;               /* Hardware Request Status Channel 27 */
      vuint32_t HRS26:1;               /* Hardware Request Status Channel 26 */
      vuint32_t HRS25:1;               /* Hardware Request Status Channel 25 */
      vuint32_t HRS24:1;               /* Hardware Request Status Channel 24 */
      vuint32_t HRS23:1;               /* Hardware Request Status Channel 23 */
      vuint32_t HRS22:1;               /* Hardware Request Status Channel 22 */
      vuint32_t HRS21:1;               /* Hardware Request Status Channel 21 */
      vuint32_t HRS20:1;               /* Hardware Request Status Channel 20 */
      vuint32_t HRS19:1;               /* Hardware Request Status Channel 19 */
      vuint32_t HRS18:1;               /* Hardware Request Status Channel 18 */
      vuint32_t HRS17:1;               /* Hardware Request Status Channel 17 */
      vuint32_t HRS16:1;               /* Hardware Request Status Channel 16 */
      vuint32_t HRS15:1;               /* Hardware Request Status Channel 15 */
      vuint32_t HRS14:1;               /* Hardware Request Status Channel 14 */
      vuint32_t HRS13:1;               /* Hardware Request Status Channel 13 */
      vuint32_t HRS12:1;               /* Hardware Request Status Channel 12 */
      vuint32_t HRS11:1;               /* Hardware Request Status Channel 11 */
      vuint32_t HRS10:1;               /* Hardware Request Status Channel 10 */
      vuint32_t HRS9:1;                /* Hardware Request Status Channel 9 */
      vuint32_t HRS8:1;                /* Hardware Request Status Channel 8 */
      vuint32_t HRS7:1;                /* Hardware Request Status Channel 7 */
      vuint32_t HRS6:1;                /* Hardware Request Status Channel 6 */
      vuint32_t HRS5:1;                /* Hardware Request Status Channel 5 */
      vuint32_t HRS4:1;                /* Hardware Request Status Channel 4 */
      vuint32_t HRS3:1;                /* Hardware Request Status Channel 3 */
      vuint32_t HRS2:1;                /* Hardware Request Status Channel 2 */
      vuint32_t HRS1:1;                /* Hardware Request Status Channel 1 */
      vuint32_t HRS0:1;                /* Hardware Request Status Channel 0 */
    } B;
  } HRS;

  uint8_t DMA_reserved5[200];
  union {                              /* Channel n Priority Register */
    vuint8_t R;
    struct {
      vuint8_t ECP:1;                  /* Enable Channel Preemption. This bit resets to zero. */
      vuint8_t DPA:1;                  /* Disable preempt ability. This bit resets to zero. */
      vuint8_t GRPPRI:2;               /* Channel n Current Group Priority */
      vuint8_t CHPRI:4;                /* Channel n Arbitration Priority */
    } B;
  } DCHPRI[32];

  uint8_t DMA_reserved6[32];
  union {                              /* Channel n Master ID Register */
    vuint8_t R;
    struct {
      vuint8_t EMI:1;                  /* Enable Master ID replication */
      vuint8_t PAL:1;                  /* Privileged Access Level */
      vuint8_t  :2;
      vuint8_t MID:4;                  /* Master ID */
    } B;
  } DCHMID[32];

  uint8_t DMA_reserved7[3744];
  struct {
    union {                            /* TCD Source Address */
      vuint32_t R;
      struct {
        vuint32_t SADDR:32;            /* Source Address */
      } B;
    } SADDR;
    union {                            /* TCD Transfer Attributes */
      vuint16_t R;
      struct {
        vuint16_t SMOD:5;              /* Source Address Modulo */
        vuint16_t SSIZE:3;             /* Source data transfer size */
        vuint16_t DMOD:5;              /* Destination Address Modulo */
        vuint16_t DSIZE:3;             /* Destination Data Transfer Size */
      } B;
    } ATTR;
    union {                            /* TCD Signed Source Address Offset */
      vuint16_t R;
      struct {
        vuint16_t SOFF:16;             /* Source Address Signed Offset */
      } B;
    } SOFF;
    union {
      union {                          /* TCD Minor Byte Count (Minor Loop Disabled) */
        vuint32_t R;
        struct {
          vuint32_t NBYTES:32;         /* Minor Byte Transfer Count */
        } B;
      } MLNO;
      union {                          /* TCD Signed Minor Loop Offset (Minor Loop Enabled and Offset Disabled) */
        vuint32_t R;
        struct {
          vuint32_t SMLOE:1;           /* Source Minor Loop Offset Enable */
          vuint32_t DMLOE:1;           /* Destination Minor Loop Offset enable */
          vuint32_t NBYTES:30;         /* Minor Byte Transfer Count */
        } B;
      } MLOFFNO;
      union {                          /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
        vuint32_t R;
        struct {
          vuint32_t SMLOE:1;           /* Source Minor Loop Offset Enable */
          vuint32_t DMLOE:1;           /* Destination Minor Loop Offset Enable */
          vuint32_t MLOFF:20;          /* If SMLOE or DMLOE is set, this field represents a sign-extended offset applied to the source or destination address to form the next-state value after the minor loop completes. */
          vuint32_t NBYTES:10;         /* Minor Byte Transfer Count */
        } B;
      } MLOFFYES;
    } NBYTES;
    union {                            /* TCD Last Source Address Adjustment */
      vuint32_t R;
      struct {
        vuint32_t SLAST:32;            /* Last Source Address Adjustment */
      } B;
    } SLAST;
    union {                            /* TCD Destination Address */
      vuint32_t R;
      struct {
        vuint32_t DADDR:32;            /* Destination Address */
      } B;
    } DADDR;
    union {
      union {                          /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
        vuint16_t R;
        struct {
          vuint16_t ELINK:1;           /* Enable channel-to-channel linking on minor-loop complete */
          vuint16_t CITER:15;          /* Current Major Iteration Count */
        } B;
      } ELINKNO;
      union {                          /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
        vuint16_t R;
        struct {
          vuint16_t ELINK:1;           /* Enable channel-to-channel linking on minor-loop complete */
          vuint16_t  :1;
          vuint16_t LINKCH:5;          /* Link Channel Number */
          vuint16_t CITER:9;           /* Current Major Iteration Count */
        } B;
      } ELINKYES;
    } CITER;
    union {                            /* TCD Signed Destination Address Offset */
      vuint16_t R;
      struct {
        vuint16_t DOFF:16;             /* Destination Address Signed Offset */
      } B;
    } DOFF;
    union {                            /* TCD Last Destination Address Adjustment/Scatter Gather Address */
      vuint32_t R;
      struct {
        vuint32_t DLASTSGA:32;
      } B;
    } DLASTSGA;
    union {
      union {                          /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
        vuint16_t R;
        struct {
          vuint16_t ELINK:1;           /* Enables channel-to-channel linking on minor loop complete */
          vuint16_t BITER:15;          /* Starting Major Iteration Count */
        } B;
      } ELINKNO;
      union {                          /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
        vuint16_t R;
        struct {
          vuint16_t ELINK:1;           /* Enables channel-to-channel linking on minor loop complete */
          vuint16_t  :1;
          vuint16_t LINKCH:5;          /* Link Channel Number */
          vuint16_t BITER:9;           /* Starting Major Iteration Count */
        } B;
      } ELINKYES;
    } BITER;
    union {                            /* TCD Control and Status */
      vuint16_t R;
      struct {
        vuint16_t BWC:2;               /* Bandwidth Control */
        vuint16_t  :1;
        vuint16_t MAJORLINKCH:5;       /* Link Channel Number */
        vuint16_t DONE:1;              /* Channel Done */
        vuint16_t ACTIVE:1;            /* Channel Active */
        vuint16_t MAJORELINK:1;        /* Enable channel-to-channel linking on major loop complete */
        vuint16_t ESG:1;               /* Enable Scatter/Gather Processing */
        vuint16_t DREQ:1;              /* Disable Request */
        vuint16_t INTHALF:1;           /* Enable an interrupt when major counter is half complete. */
        vuint16_t INTMAJOR:1;          /* Enable an interrupt when major iteration count completes */
        vuint16_t START:1;             /* Channel Start */
      } B;
    } CSR;
  } TCD[32];
};


/* ============================================================================
   =============================== Module: DMAMUX =============================
   ============================================================================ */

struct DMAMUX_tag {
  union {                              /* Channel Configuration register */
    vuint8_t R;
    struct {
      vuint8_t ENBL:1;                 /* DMA Channel Enable */
      vuint8_t TRIG:1;                 /* DMA Channel Trigger Enable */
      vuint8_t SOURCE:6;               /* DMA Channel Source (Slot) */
    } B;
  } CHCFG[16];
};


/* ============================================================================
   =============================== Module: DSPI ===============================
   ============================================================================ */

struct DSPI_tag {
  union {                              /* Module Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t MSTR:1;                /* Master/Slave Mode Select */
      vuint32_t CONT_SCKE:1;           /* Continuous SCK Enable */
      vuint32_t DCONF:2;               /* Interface Configuration */
      vuint32_t FRZ:1;                 /* Freeze */
      vuint32_t MTFE:1;                /* Modified Timing Format Enable */
      vuint32_t PCSSE:1;               /* Peripheral Chip Select Strobe Enable */
      vuint32_t ROOE:1;                /* Receive FIFO Overflow Overwrite Enable */
      vuint32_t  :2;
      vuint32_t PCSIS:6;               /* Peripheral Chip Select x Inactive State */
      vuint32_t  :1;
      vuint32_t MDIS:1;                /* Module Disable */
      vuint32_t DIS_TXF:1;             /* Disable Transmit FIFO */
      vuint32_t DIS_RXF:1;             /* Disable Receive FIFO */
      vuint32_t CLR_TXF:1;             /* Clear TX FIFO */
      vuint32_t CLR_RXF:1;             /* CLR_RXF */
      vuint32_t SMPL_PT:2;             /* Sample Point */
      vuint32_t  :4;
      vuint32_t XSPI:1;                /* Extended SPI Mode */
      vuint32_t FCPCS:1;               /* Fast Continuous PCS Mode. */
      vuint32_t PES:1;                 /* Parity Error Stop */
      vuint32_t HALT:1;                /* Halt */
    } B;
  } MCR;

  uint8_t DSPI_reserved0[4];
  union {                              /* Transfer Count Register */
    vuint32_t R;
    struct {
      vuint32_t SPI_TCNT:16;           /* SPI Transfer Counter */
      vuint32_t  :16;
    } B;
  } TCR;

  union {
    union {                            /* Clock and Transfer Attributes Register (In Master Mode) */
      vuint32_t R;
      struct {
        vuint32_t DBR:1;               /* Double Baud Rate */
        vuint32_t FMSZ:4;              /* Frame Size */
        vuint32_t CPOL:1;              /* Clock Polarity */
        vuint32_t CPHA:1;              /* Clock Phase */
        vuint32_t LSBFE:1;             /* LSB First */
        vuint32_t PCSSCK:2;            /* PCS to SCK Delay Prescaler */
        vuint32_t PASC:2;              /* After SCK Delay Prescaler */
        vuint32_t PDT:2;               /* Delay after Transfer Prescaler */
        vuint32_t PBR:2;               /* Baud Rate Prescaler */
        vuint32_t CSSCK:4;             /* PCS to SCK Delay Scaler */
        vuint32_t ASC:4;               /* After SCK Delay Scaler */
        vuint32_t DT:4;                /* Delay After Transfer Scaler */
        vuint32_t BR:4;                /* Baud Rate Scaler */
      } B;
    } CTAR[2];
    union {                            /* Clock and Transfer Attributes Register (In Slave Mode) */
      vuint32_t R;
      struct {
        vuint32_t FMSZ:5;              /* Frame Size */
        vuint32_t CPOL:1;              /* Clock Polarity */
        vuint32_t CPHA:1;              /* Clock Phase */
        vuint32_t PE:1;                /* Parity Enable */
        vuint32_t PP:1;                /* Parity Polarity */
        vuint32_t FMSZ5:1;             /* MSB of Frame Size when DSI is used in 64-bit Mode */
        vuint32_t  :22;
      } B;
    } CTAR_SLAVE[2];
  } MODE;

  union {                              /* Clock and Transfer Attributes Register (In Master Mode) */
    vuint32_t R;
    struct {
      vuint32_t DBR:1;                 /* Double Baud Rate */
      vuint32_t FMSZ:4;                /* Frame Size */
      vuint32_t CPOL:1;                /* Clock Polarity */
      vuint32_t CPHA:1;                /* Clock Phase */
      vuint32_t LSBFE:1;               /* LSB First */
      vuint32_t PCSSCK:2;              /* PCS to SCK Delay Prescaler */
      vuint32_t PASC:2;                /* After SCK Delay Prescaler */
      vuint32_t PDT:2;                 /* Delay after Transfer Prescaler */
      vuint32_t PBR:2;                 /* Baud Rate Prescaler */
      vuint32_t CSSCK:4;               /* PCS to SCK Delay Scaler */
      vuint32_t ASC:4;                 /* After SCK Delay Scaler */
      vuint32_t DT:4;                  /* Delay After Transfer Scaler */
      vuint32_t BR:4;                  /* Baud Rate Scaler */
    } B;
  } CTAR[4];

  uint8_t DSPI_reserved1[8];
  union {                              /* Status Register */
    vuint32_t R;
    struct {
      vuint32_t TCF:1;                 /* Transfer Complete Flag */
      vuint32_t TXRXS:1;               /* TX and RX Status */
      vuint32_t SPITCF:1;              /* SPI Frame Transfer Complete Flag. */
      vuint32_t EOQF:1;                /* End of Queue Flag */
      vuint32_t TFUF:1;                /* Transmit FIFO Underflow Flag */
      vuint32_t DSITCF:1;              /* DSI Frame Transfer Complete Flag. */
      vuint32_t TFFF:1;                /* Transmit FIFO Fill Flag */
      vuint32_t BSYF:1;                /* Busy Flag. */
      vuint32_t CMDTCF:1;              /* Command Transfer Complete Flag. */
      vuint32_t DPEF:1;                /* DSI Parity Error Flag */
      vuint32_t SPEF:1;                /* SPI Parity Error Flag */
      vuint32_t DDIF:1;                /* DSI Data Received with Active Bits */
      vuint32_t RFOF:1;                /* Receive FIFO Overflow Flag */
      vuint32_t TFIWF:1;               /* Tranmit FIFO Invalid Write Flag */
      vuint32_t RFDF:1;                /* Receive FIFO Drain Flag */
      vuint32_t CMDFFF:1;              /* Command FIFO Fill Flag */
      vuint32_t TXCTR:4;               /* TX FIFO Counter */
      vuint32_t TXNXTPTR:4;            /* Transmit Next Pointer */
      vuint32_t RXCTR:4;               /* RX FIFO Counter */
      vuint32_t POPNXTPTR:4;           /* Pop Next Pointer */
    } B;
  } SR;

  union {                              /* DMA/Interrupt Request Select and Enable Register */
    vuint32_t R;
    struct {
      vuint32_t TCF_RE:1;              /* Transmission Complete Request Enable */
      vuint32_t CMDFFF_RE:1;           /* Command FIFO Fill Flag Request Enable. */
      vuint32_t SPITCF_RE:1;           /* SPI Frame Transmission Complete Request Enable. */
      vuint32_t EOQF_RE:1;             /* Finished Request Enable */
      vuint32_t TFUF_RE:1;             /* Transmit FIFO Underflow Request Enable */
      vuint32_t DSITCF_RE:1;           /* DSI Frame Transmission Complete Request Enable. */
      vuint32_t TFFF_RE:1;             /* Transmit FIFO Fill Request Enable */
      vuint32_t TFFF_DIRS:1;           /* Transmit FIFO Fill DMA or Interrupt Request Select */
      vuint32_t CMDTCF_RE:1;           /* Command Transmission Complete Request Enable. */
      vuint32_t DPEF_RE:1;             /* DSI Parity Error Request Enable */
      vuint32_t SPEF_RE:1;             /* SPI Parity Error Request Enable */
      vuint32_t DDIF_RE:1;             /* DSI data received with active bits Request Enable */
      vuint32_t RFOF_RE:1;             /* Receive FIFO Overflow Request Enable */
      vuint32_t TFIWF_RE:1;            /* Transmit FIFO Invalid Write Request Enable. */
      vuint32_t RFDF_RE:1;             /* Receive FIFO Drain Request Enable */
      vuint32_t RFDF_DIRS:1;           /* Receive FIFO Drain DMA or Interrupt Request Select */
      vuint32_t CMDFFF_DIRS:1;         /* Command FIFO Fill DMA or Interrupt Request Select */
      vuint32_t DDIF_DIRS:1;           /* DSI data received with active bits - DMA or Interrupt Request Select. */
      vuint32_t  :14;
    } B;
  } RSER;

  union {
    union {                            /* PUSH TX FIFO Register In Master Mode */
      vuint32_t R;
      struct {
        vuint32_t CONT:1;              /* Continuous Peripheral Chip Select Enable */
        vuint32_t CTAS:3;              /* Clock and Transfer Attributes Select */
        vuint32_t EOQ:1;               /* End Of Queue */
        vuint32_t CTCNT:1;             /* Clear Transfer Counter */
        vuint32_t PE_MASC:1;           /* Parity Enable or Mask T ASC delay in the current frame */
        vuint32_t PP_MCSC:1;           /* Parity Polarity or Mask T CSC delay in the next frame */
        vuint32_t  :2;
        vuint32_t PCS:6;
        vuint32_t TXDATA:16;           /* Transmit Data */
      } B;
    } PUSHR;
    union {                            /* PUSH TX FIFO Register In Slave Mode */
      vuint32_t R;
      struct {
        vuint32_t  :16;
        vuint32_t TXDATA:16;           /* Transmit Data */
      } B;
    } PUSHR_SLAVE;
  } PUSHR;

  union {                              /* POP RX FIFO Register */
    vuint32_t R;
    struct {
      vuint32_t RXDATA:32;             /* Received Data */
    } B;
  } POPR;

  union {                              /* Transmit FIFO Registers */
    vuint32_t R;
    struct {
      vuint32_t TXCMD_TXDATA:16;       /* Transmit Command or Transmit Data */
      vuint32_t TXDATA:16;             /* Transmit Data */
    } B;
  } TXFR[4];

  uint8_t DSPI_reserved2[48];
  union {                              /* Receive FIFO Registers */
    vuint32_t R;
    struct {
      vuint32_t RXDATA:32;             /* Receive Data */
    } B;
  } RXFR[4];

  uint8_t DSPI_reserved3[48];
  union {                              /* DSI Configuration Register 0 */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t FMSZ4:1;               /* MSB of the frame size in master mode. */
      vuint32_t  :6;
      vuint32_t FMSZ5:1;               /* MSB of the frame size in master mode when DSI is used in 64-bit mode. */
      vuint32_t  :2;
      vuint32_t  :1;
      vuint32_t TXSS:1;                /* Transmit Data Source Select. */
      vuint32_t TPOL:1;                /* Trigger Polarity */
      vuint32_t TRRE:1;                /* Trigger Reception Enable */
      vuint32_t CID:1;                 /* Change In Data Transfer Enable */
      vuint32_t DCONT:1;               /* DSI Continuous Peripheral Chip Select Enable */
      vuint32_t DSICTAS:3;             /* DSI Clock and Transfer Attributes Select */
      vuint32_t DMS:1;                 /* Data Match Stop */
      vuint32_t PES:1;                 /* Parity Error Stop */
      vuint32_t PE:1;                  /* Parity Enable */
      vuint32_t PP:1;                  /* Parity Polarity */
      vuint32_t DPCSx:8;               /* DSI Peripheral Chip Select 0-7 */
    } B;
  } DSICR0;

  union {                              /* DSI Serialization Data Register 0 */
    vuint32_t R;
    struct {
      vuint32_t SER_DATA:32;           /* Serialized Data */
    } B;
  } SDR0;

  union {                              /* DSI Alternate Serialization Data Register 0 */
    vuint32_t R;
    struct {
      vuint32_t ASER_DATA:32;          /* Alternate Serialized Data */
    } B;
  } ASDR0;

  union {                              /* DSI Transmit Comparison Register 0 */
    vuint32_t R;
    struct {
      vuint32_t COMP_DATA:32;          /* Compare Data */
    } B;
  } COMPR0;

  union {                              /* DSI Deserialization Data Register 0 */
    vuint32_t R;
    struct {
      vuint32_t DESER_DATA:32;         /* Deserialized Data */
    } B;
  } DDR0;

  union {                              /* DSI Configuration Register 1 */
    vuint32_t R;
    struct {
      vuint32_t  :2;
      vuint32_t  :6;
      vuint32_t  :3;
      vuint32_t CSI_PRTY:1;            /* CSI Priority */
      vuint32_t  :1;
      vuint32_t DSI64E:1;              /* DSI 64-bit Mode Enable */
      vuint32_t  :2;
      vuint32_t  :8;
      vuint32_t  :8;
    } B;
  } DSICR1;

  union {                              /* DSI Serialization Source Select Register 0 */
    vuint32_t R;
    struct {
      vuint32_t SS:32;                 /* Source Select */
    } B;
  } SSR0;

  union {                              /* DSI Parallel Input Select Register 0 */
    vuint32_t R;
    struct {
      vuint32_t IPS7:4;                /* Input Pin Select 7 */
      vuint32_t IPS6:4;                /* Input Pin Select 6 */
      vuint32_t IPS5:4;                /* Input Pin Select 5 */
      vuint32_t IPS4:4;                /* Input Pin Select 5 */
      vuint32_t IPS3:4;                /* Input Pin Select 3 */
      vuint32_t IPS2:4;                /* Input Pin Select 2 */
      vuint32_t IPS1:4;                /* Input Pin Select 1 */
      vuint32_t IPS0:4;                /* Input Pin Select 0 */
    } B;
  } PISR0;

  union {                              /* DSI Parallel Input Select Register 1 */
    vuint32_t R;
    struct {
      vuint32_t IPS15:4;               /* Input Pin Select 15 */
      vuint32_t IPS14:4;               /* Input Pin Select 14 */
      vuint32_t IPS13:4;               /* Input Pin Select 13 */
      vuint32_t IPS12:4;               /* Input Pin Select 12 */
      vuint32_t IPS11:4;               /* Input Pin Select 11 */
      vuint32_t IPS10:4;               /* Input Pin Select 10 */
      vuint32_t IPS9:4;                /* Input Pin Select 9 */
      vuint32_t IPS8:4;                /* Input Pin Select 8 */
    } B;
  } PISR1;

  union {                              /* DSI Parallel Input Select Register 2 */
    vuint32_t R;
    struct {
      vuint32_t IPS23:4;               /* Input Pin Select 23 */
      vuint32_t IPS22:4;               /* Input Pin Select 22 */
      vuint32_t IPS21:4;               /* Input Pin Select 21 */
      vuint32_t IPS20:4;               /* Input Pin Select 20 */
      vuint32_t IPS19:4;               /* Input Pin Select 19 */
      vuint32_t IPS18:4;               /* Input Pin Select 18 */
      vuint32_t IPS17:4;               /* Input Pin Select 17 */
      vuint32_t IPS16:4;               /* Input Pin Select 16 */
    } B;
  } PISR2;

  union {                              /* DSI Parallel Input Select Register 3 */
    vuint32_t R;
    struct {
      vuint32_t IPS31:4;               /* Input Pin Select 31 */
      vuint32_t IPS30:4;               /* Input Pin Select 30 */
      vuint32_t IPS29:4;               /* Input Pin Select 29 */
      vuint32_t IPS28:4;               /* Input Pin Select 28 */
      vuint32_t IPS27:4;               /* Input Pin Select 27 */
      vuint32_t IPS26:4;               /* Input Pin Select 26 */
      vuint32_t IPS25:4;               /* Input Pin Select 25 */
      vuint32_t IPS24:4;               /* Input Pin Select 24 */
    } B;
  } PISR3;

  union {                              /* DSI Deserialized Data Interrupt Mask Register 0 */
    vuint32_t R;
    struct {
      vuint32_t MASK:32;               /* Mask */
    } B;
  } DIMR0;

  union {                              /* DSI Deserialized Data Polarity Interrupt Register 0 */
    vuint32_t R;
    struct {
      vuint32_t DP:32;                 /* Data Polarity */
    } B;
  } DPIR0;

  union {                              /* DSI Serialization Data Register 1 */
    vuint32_t R;
    struct {
      vuint32_t SER_DATA:32;           /* Serialized Data */
    } B;
  } SDR1;

  union {                              /* DSI Alternate Serialization Data Register 1 */
    vuint32_t R;
    struct {
      vuint32_t ASER_DATA:32;          /* Alternate Serialized Data */
    } B;
  } ASDR1;

  union {                              /* DSI Transmit Comparison Register 1 */
    vuint32_t R;
    struct {
      vuint32_t COMP_DATA:32;          /* Compare Data */
    } B;
  } COMPR1;

  union {                              /* DSI Deserialization Data Register 1 */
    vuint32_t R;
    struct {
      vuint32_t DESER_DATA:32;         /* Deserialized Data */
    } B;
  } DDR1;

  union {                              /* DSI Serialization Source Select Register 1 */
    vuint32_t R;
    struct {
      vuint32_t SS:32;                 /* Source Select */
    } B;
  } SSR1;

  union {                              /* DSI Parallel Input Select Register 4 */
    vuint32_t R;
    struct {
      vuint32_t IPS39:4;               /* Input Pin Select 39 */
      vuint32_t IPS38:4;               /* Input Pin Select 38 */
      vuint32_t IPS37:4;               /* Input Pin Select 37 */
      vuint32_t IPS36:4;               /* Input Pin Select 36 */
      vuint32_t IPS35:4;               /* Input Pin Select 35 */
      vuint32_t IPS34:4;               /* Input Pin Select 34 */
      vuint32_t IPS33:4;               /* Input Pin Select 33 */
      vuint32_t IPS32:4;               /* Input Pin Select 32 */
    } B;
  } PISR4;

  union {                              /* DSI Parallel Input Select Register 5 */
    vuint32_t R;
    struct {
      vuint32_t IPS47:4;               /* Input Pin Select 47 */
      vuint32_t IPS46:4;               /* Input Pin Select 46 */
      vuint32_t IPS45:4;               /* Input Pin Select 45 */
      vuint32_t IPS44:4;               /* Input Pin Select 44 */
      vuint32_t IPS43:4;               /* Input Pin Select 43 */
      vuint32_t IPS42:4;               /* Input Pin Select 42 */
      vuint32_t IPS41:4;               /* Input Pin Select 41 */
      vuint32_t IPS40:4;               /* Input Pin Select 40 */
    } B;
  } PISR5;

  union {                              /* DSI Parallel Input Select Register 6 */
    vuint32_t R;
    struct {
      vuint32_t IPS55:4;               /* Input Pin Select 55 */
      vuint32_t IPS54:4;               /* Input Pin Select 54 */
      vuint32_t IPS53:4;               /* Input Pin Select 53 */
      vuint32_t IPS52:4;               /* Input Pin Select 52 */
      vuint32_t IPS51:4;               /* Input Pin Select 51 */
      vuint32_t IPS50:4;               /* Input Pin Select 50 */
      vuint32_t IPS49:4;               /* Input Pin Select 49 */
      vuint32_t IPS48:4;               /* Input Pin Select 48 */
    } B;
  } PISR6;

  union {                              /* DSI Parallel Input Select Register 7 */
    vuint32_t R;
    struct {
      vuint32_t IPS63:4;               /* Input Pin Select 63 */
      vuint32_t IPS62:4;               /* Input Pin Select 62 */
      vuint32_t IPS61:4;               /* Input Pin Select 61 */
      vuint32_t IPS60:4;               /* Input Pin Select 60 */
      vuint32_t IPS59:4;               /* Input Pin Select 59 */
      vuint32_t IPS58:4;               /* Input Pin Select 58 */
      vuint32_t IPS57:4;               /* Input Pin Select 57 */
      vuint32_t IPS56:4;               /* Input Pin Select 56 */
    } B;
  } PISR7;

  union {                              /* DSI Deserialized Data Interrupt Mask Register 1 */
    vuint32_t R;
    struct {
      vuint32_t MASK:32;               /* Mask */
    } B;
  } DIMR1;

  union {                              /* DSI Deserialized Data Polarity Interrupt Register 1 */
    vuint32_t R;
    struct {
      vuint32_t DP:32;                 /* Data Polarity */
    } B;
  } DPIR1;

  union {                              /* Clock and Transfer Attributes Register Extended */
    vuint32_t R;
    struct {
      vuint32_t  :15;
      vuint32_t FMSZE:1;               /* Frame Size Extended */
      vuint32_t  :5;
      vuint32_t DTCP:11;               /* Data Transfer Count Preload */
    } B;
  } CTARE[6];

  uint8_t DSPI_reserved4[8];
  union {                              /* Status Register Extended */
    vuint32_t R;
    struct {
      vuint32_t  :17;
      vuint32_t RXCTR4:1;              /* RX FIFO Counter[4] */
      vuint32_t  :2;
      vuint32_t TXCTR4:1;              /* TX FIFO Counter[4] */
      vuint32_t  :2;
      vuint32_t CMDCTR:5;              /* CMD FIFO Counter */
      vuint32_t CMDNXTPTR:4;           /* Command Next Pointer */
    } B;
  } SREX;

  union {                              /* Trigger Register */
    vuint32_t R;
    struct {
      vuint32_t ENABLE:1;              /* Trigger Register Enable */
      vuint32_t  :27;
      vuint32_t  :1;
      vuint32_t ASDR_WT:1;             /* ASDR Write Trigger Enable */
      vuint32_t CID:1;                 /* Change In Data Transfer Enable */
      vuint32_t TRRE:1;                /* Trigger Reception Enable */
    } B;
  } TRIG;
};


/* ============================================================================
   =============================== Module: ENET ===============================
   ============================================================================ */

struct ENET_tag {
  uint8_t ENET_reserved0[4];
  union {                              /* Interrupt Event Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t BABR:1;                /* Babbling Receive Error */
      vuint32_t BABT:1;                /* Babbling Transmit Error */
      vuint32_t GRA:1;                 /* Graceful Stop Complete */
      vuint32_t TXF:1;                 /* Transmit Frame Interrupt */
      vuint32_t TXB:1;                 /* Transmit Buffer Interrupt */
      vuint32_t RXF:1;                 /* Receive Frame Interrupt */
      vuint32_t RXB:1;                 /* Receive Buffer Interrupt */
      vuint32_t MII:1;                 /* MII Interrupt. */
      vuint32_t EBERR:1;               /* Ethernet Bus Error */
      vuint32_t LC:1;                  /* Late Collision */
      vuint32_t RL:1;                  /* Collision Retry Limit */
      vuint32_t UN:1;                  /* Transmit FIFO Underrun */
      vuint32_t PLR:1;                 /* Payload Receive Error */
      vuint32_t WAKEUP:1;              /* Node Wakeup Request Indication */
      vuint32_t TS_AVAIL:1;            /* Transmit Timestamp Available */
      vuint32_t TS_TIMER:1;            /* Timestamp Timer */
      vuint32_t RXFLUSH_2:1;
      vuint32_t RXFLUSH_1:1;
      vuint32_t RXFLUSH_0:1;
      vuint32_t  :1;
      vuint32_t PARSERR:1;
      vuint32_t PARSRF:1;
      vuint32_t  :1;
      vuint32_t TXF2:1;                /* Transmit frame interrupt, class 2 */
      vuint32_t TXB2:1;                /* Transmit buffer interrupt, class 2 */
      vuint32_t RXF2:1;                /* Receive frame interrupt, class 2 */
      vuint32_t RXB2:1;                /* Receive buffer interrupt, class 2 */
      vuint32_t TXF1:1;                /* Transmit frame interrupt, class 1 */
      vuint32_t TXB1:1;                /* Transmit buffer interrupt, class 1 */
      vuint32_t RXF1:1;                /* Receive frame interrupt, class 1 */
      vuint32_t RXB1:1;                /* Receive buffer interrupt, class 1 */
    } B;
  } EIR;

  union {                              /* Interrupt Mask Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t BABR:1;                /* BABR Interrupt Mask */
      vuint32_t BABT:1;                /* BABT Interrupt Mask */
      vuint32_t GRA:1;                 /* GRA Interrupt Mask */
      vuint32_t TXF:1;                 /* TXF Interrupt Mask */
      vuint32_t TXB:1;                 /* TXB Interrupt Mask */
      vuint32_t RXF:1;                 /* RXF Interrupt Mask */
      vuint32_t RXB:1;                 /* RXB Interrupt Mask */
      vuint32_t MII:1;                 /* MII Interrupt Mask */
      vuint32_t EBERR:1;               /* EBERR Interrupt Mask */
      vuint32_t LC:1;                  /* LC Interrupt Mask */
      vuint32_t RL:1;                  /* RL Interrupt Mask */
      vuint32_t UN:1;                  /* UN Interrupt Mask */
      vuint32_t PLR:1;                 /* PLR Interrupt Mask */
      vuint32_t WAKEUP:1;              /* WAKEUP Interrupt Mask */
      vuint32_t TS_AVAIL:1;            /* TS_AVAIL Interrupt Mask */
      vuint32_t TS_TIMER:1;            /* TS_TIMER Interrupt Mask */
      vuint32_t RXFLUSH_2:1;
      vuint32_t RXFLUSH_1:1;
      vuint32_t RXFLUSH_0:1;
      vuint32_t  :1;
      vuint32_t PARSERR:1;
      vuint32_t PARSRF:1;
      vuint32_t  :1;
      vuint32_t TXF2:1;                /* Transmit frame interrupt, class 2 */
      vuint32_t TXB2:1;                /* Transmit buffer interrupt, class 2 */
      vuint32_t RXF2:1;                /* Receive frame interrupt, class 2 */
      vuint32_t RXB2:1;                /* Receive buffer interrupt, class 2 */
      vuint32_t TXF1:1;                /* Transmit frame interrupt, class 1 */
      vuint32_t TXB1:1;                /* Transmit buffer interrupt, class 1 */
      vuint32_t RXF1:1;                /* Receive frame interrupt, class 1 */
      vuint32_t RXB1:1;                /* Receive buffer interrupt, class 1 */
    } B;
  } EIMR;

  uint8_t ENET_reserved1[4];
  union {                              /* Receive Descriptor Active Register - Ring 0 */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t RDAR:1;                /* Receive Descriptor Active */
      vuint32_t  :24;
    } B;
  } RDAR;

  union {                              /* Transmit Descriptor Active Register - Ring 0 */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t TDAR:1;                /* Transmit Descriptor Active */
      vuint32_t  :24;
    } B;
  } TDAR;

  uint8_t ENET_reserved2[12];
  union {                              /* Ethernet Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :20;
      vuint32_t SVLANDBL:1;            /* S-VLAN double tag */
      vuint32_t VLANUSE2ND:1;          /* VLAN use second tag */
      vuint32_t SVLANEN:1;             /* S-VLAN enable */
      vuint32_t DBSWP:1;               /* Descriptor Byte Swapping Enable */
      vuint32_t  :1;
      vuint32_t DBGEN:1;               /* Debug Enable */
      vuint32_t  :1;
      vuint32_t EN1588:1;              /* EN1588 Enable */
      vuint32_t SLEEP:1;               /* Sleep Mode Enable */
      vuint32_t MAGICEN:1;             /* Magic Packet Detection Enable */
      vuint32_t ETHEREN:1;             /* Ethernet Enable */
      vuint32_t RESET:1;               /* Ethernet MAC Reset */
    } B;
  } ECR;

  uint8_t ENET_reserved3[24];
  union {                              /* MII Management Frame Register */
    vuint32_t R;
    struct {
      vuint32_t ST:2;                  /* Start Of Frame Delimiter */
      vuint32_t OP:2;                  /* Operation Code */
      vuint32_t PA:5;                  /* PHY Address */
      vuint32_t RA:5;                  /* Register Address */
      vuint32_t TA:2;                  /* Turn Around */
      vuint32_t DATA:16;               /* Management Frame Data */
    } B;
  } MMFR;

  union {                              /* MII Speed Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :21;
      vuint32_t HOLDTIME:3;            /* Hold time On MDIO Output */
      vuint32_t DIS_PRE:1;             /* Disable Preamble */
      vuint32_t MII_SPEED:6;           /* MII Speed */
      vuint32_t  :1;
    } B;
  } MSCR;

  uint8_t ENET_reserved4[28];
  union {                              /* MIB Control Register */
    vuint32_t R;
    struct {
      vuint32_t MIB_DIS:1;             /* Disable MIB Logic */
      vuint32_t MIB_IDLE:1;            /* MIB Idle */
      vuint32_t MIB_CLEAR:1;           /* MIB Clear */
      vuint32_t  :29;
    } B;
  } MIBC;

  uint8_t ENET_reserved5[28];
  union {                              /* Receive Control Register */
    vuint32_t R;
    struct {
      vuint32_t GRS:1;                 /* Graceful Receive Stopped */
      vuint32_t NLC:1;                 /* Payload Length Check Disable */
      vuint32_t MAX_FL:14;             /* Maximum Frame Length */
      vuint32_t CFEN:1;                /* MAC Control Frame Enable */
      vuint32_t CRCFWD:1;              /* Terminate/Forward Received CRC */
      vuint32_t PAUFWD:1;              /* Terminate/Forward Pause Frames */
      vuint32_t PADEN:1;               /* Enable Frame Padding Remove On Receive */
      vuint32_t  :2;
      vuint32_t RMII_10T:1;
      vuint32_t RMII_MODE:1;           /* RMII Mode Enable */
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t FCE:1;                 /* Flow Control Enable */
      vuint32_t BC_REJ:1;              /* Broadcast Frame Reject */
      vuint32_t PROM:1;                /* Promiscuous Mode */
      vuint32_t MII_MODE:1;            /* Media Independent Interface Mode */
      vuint32_t DRT:1;                 /* Disable Receive On Transmit */
      vuint32_t LOOP:1;                /* Internal Loopback */
    } B;
  } RCR;

  uint8_t ENET_reserved6[60];
  union {                              /* Transmit Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :21;
      vuint32_t  :1;
      vuint32_t CRCFWD:1;              /* Forward Frame From Application With CRC */
      vuint32_t ADDINS:1;              /* Set MAC Address On Transmit */
      vuint32_t ADDSEL:3;              /* Source MAC Address Select On Transmit */
      vuint32_t RFC_PAUSE:1;           /* Receive Frame Control Pause */
      vuint32_t TFC_PAUSE:1;           /* Transmit Frame Control Pause */
      vuint32_t FDEN:1;                /* Full-Duplex Enable */
      vuint32_t  :1;
      vuint32_t GTS:1;                 /* Graceful Transmit Stop */
    } B;
  } TCR;

  uint8_t ENET_reserved7[28];
  union {                              /* Physical Address Lower Register */
    vuint32_t R;
    struct {
      vuint32_t PADDR1:32;             /* Pause Address */
    } B;
  } PALR;

  union {                              /* Physical Address Upper Register */
    vuint32_t R;
    struct {
      vuint32_t PADDR2:16;
      vuint32_t TYPE:16;               /* Type Field In PAUSE Frames */
    } B;
  } PAUR;

  union {                              /* Opcode/Pause Duration Register */
    vuint32_t R;
    struct {
      vuint32_t OPCODE:16;             /* Opcode Field In PAUSE Frames */
      vuint32_t PAUSE_DUR:16;          /* Pause Duration */
    } B;
  } OPD;

  union {                              /* Transmit Interrupt Coalescing Register */
    vuint32_t R;
    struct {
      vuint32_t ICEN:1;                /* Interrupt Coalescing Enable */
      vuint32_t ICCS:1;                /* Interrupt Coalescing Timer Clock Source Select */
      vuint32_t  :2;                   /* This field must be set to 0. */
      vuint32_t ICFT:8;                /* Interrupt coalescing frame count threshold */
      vuint32_t  :4;                   /* This field must be set to 0. */
      vuint32_t ICTT:16;               /* Interrupt coalescing timer threshold */
    } B;
  } TXIC[3];

  uint8_t ENET_reserved8[4];
  union {                              /* Receive Interrupt Coalescing Register */
    vuint32_t R;
    struct {
      vuint32_t ICEN:1;                /* Interrupt Coalescing Enable */
      vuint32_t ICCS:1;                /* Interrupt Coalescing Timer Clock Source Select */
      vuint32_t  :2;                   /* This field must be set to 0. */
      vuint32_t ICFT:8;                /* Interrupt coalescing frame count threshold */
      vuint32_t  :4;                   /* This field must be set to 0. */
      vuint32_t ICTT:16;               /* Interrupt coalescing timer threshold */
    } B;
  } RXIC[3];

  uint8_t ENET_reserved9[12];
  union {                              /* Descriptor Individual Upper Address Register */
    vuint32_t R;
    struct {
      vuint32_t IADDR1:32;
    } B;
  } IAUR;

  union {                              /* Descriptor Individual Lower Address Register */
    vuint32_t R;
    struct {
      vuint32_t IADDR2:32;
    } B;
  } IALR;

  union {                              /* Descriptor Group Upper Address Register */
    vuint32_t R;
    struct {
      vuint32_t GADDR1:32;
    } B;
  } GAUR;

  union {                              /* Descriptor Group Lower Address Register */
    vuint32_t R;
    struct {
      vuint32_t GADDR2:32;
    } B;
  } GALR;

  uint8_t ENET_reserved10[28];
  union {                              /* Transmit FIFO Watermark Register */
    vuint32_t R;
    struct {
      vuint32_t  :23;
      vuint32_t STRFWD:1;              /* Store And Forward Enable */
      vuint32_t  :2;
      vuint32_t TFWR:6;                /* Transmit FIFO Write */
    } B;
  } TFWR;

  uint8_t ENET_reserved11[24];
  union {                              /* Receive Descriptor Ring 1 Start Register */
    vuint32_t R;
    struct {
      vuint32_t R_DES_START:29;
      vuint32_t  :1;
      vuint32_t  :2;
    } B;
  } RDSR1;

  union {                              /* Transmit Buffer Descriptor Ring 1 Start Register */
    vuint32_t R;
    struct {
      vuint32_t X_DES_START:29;
      vuint32_t  :1;
      vuint32_t  :2;
    } B;
  } TDSR1;

  union {                              /* Maximum Receive Buffer Size Register - Ring 1 */
    vuint32_t R;
    struct {
      vuint32_t  :18;
      vuint32_t R_BUF_SIZE:10;
      vuint32_t  :4;
    } B;
  } MRBR1;

  union {                              /* Receive Descriptor Ring 2 Start Register */
    vuint32_t R;
    struct {
      vuint32_t R_DES_START:29;
      vuint32_t  :1;
      vuint32_t  :2;
    } B;
  } RDSR2;

  union {                              /* Transmit Buffer Descriptor Ring 2 Start Register */
    vuint32_t R;
    struct {
      vuint32_t X_DES_START:29;
      vuint32_t  :1;
      vuint32_t  :2;
    } B;
  } TDSR2;

  union {                              /* Maximum Receive Buffer Size Register - Ring 2 */
    vuint32_t R;
    struct {
      vuint32_t  :18;
      vuint32_t R_BUF_SIZE:10;
      vuint32_t  :4;
    } B;
  } MRBR2;

  uint8_t ENET_reserved12[8];
  union {                              /* Receive Descriptor Ring 0 Start Register */
    vuint32_t R;
    struct {
      vuint32_t R_DES_START:29;
      vuint32_t  :1;
      vuint32_t  :2;
    } B;
  } RDSR;

  union {                              /* Transmit Buffer Descriptor Ring 0 Start Register */
    vuint32_t R;
    struct {
      vuint32_t X_DES_START:29;
      vuint32_t  :1;
      vuint32_t  :2;
    } B;
  } TDSR;

  union {                              /* Maximum Receive Buffer Size Register - Ring 0 */
    vuint32_t R;
    struct {
      vuint32_t  :18;
      vuint32_t R_BUF_SIZE:10;
      vuint32_t  :4;
    } B;
  } MRBR;

  uint8_t ENET_reserved13[4];
  union {                              /* Receive FIFO Section Full Threshold */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t RX_SECTION_FULL:8;     /* Value Of Receive FIFO Section Full Threshold */
    } B;
  } RSFL;

  union {                              /* Receive FIFO Section Empty Threshold */
    vuint32_t R;
    struct {
      vuint32_t  :11;
      vuint32_t STAT_SECTION_EMPTY:5;  /* RX Status FIFO Section Empty Threshold */
      vuint32_t  :8;
      vuint32_t RX_SECTION_EMPTY:8;    /* Value Of The Receive FIFO Section Empty Threshold */
    } B;
  } RSEM;

  union {                              /* Receive FIFO Almost Empty Threshold */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t RX_ALMOST_EMPTY:8;     /* Value Of The Receive FIFO Almost Empty Threshold */
    } B;
  } RAEM;

  union {                              /* Receive FIFO Almost Full Threshold */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t RX_ALMOST_FULL:8;      /* Value Of The Receive FIFO Almost Full Threshold */
    } B;
  } RAFL;

  union {                              /* Transmit FIFO Section Empty Threshold */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t TX_SECTION_EMPTY:8;    /* Value Of The Transmit FIFO Section Empty Threshold */
    } B;
  } TSEM;

  union {                              /* Transmit FIFO Almost Empty Threshold */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t TX_ALMOST_EMPTY:8;     /* Value of Transmit FIFO Almost Empty Threshold */
    } B;
  } TAEM;

  union {                              /* Transmit FIFO Almost Full Threshold */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t TX_ALMOST_FULL:8;      /* Value Of The Transmit FIFO Almost Full Threshold */
    } B;
  } TAFL;

  union {                              /* Transmit Inter-Packet Gap */
    vuint32_t R;
    struct {
      vuint32_t  :27;
      vuint32_t IPG:5;                 /* Transmit Inter-Packet Gap */
    } B;
  } TIPG;

  union {                              /* Frame Truncation Length */
    vuint32_t R;
    struct {
      vuint32_t  :18;
      vuint32_t TRUNC_FL:14;           /* Frame Truncation Length */
    } B;
  } FTRL;

  uint8_t ENET_reserved14[12];
  union {                              /* Transmit Accelerator Function Configuration */
    vuint32_t R;
    struct {
      vuint32_t  :27;
      vuint32_t PROCHK:1;
      vuint32_t IPCHK:1;
      vuint32_t  :2;
      vuint32_t SHIFT16:1;             /* TX FIFO Shift-16 */
    } B;
  } TACC;

  union {                              /* Receive Accelerator Function Configuration */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t SHIFT16:1;             /* RX FIFO Shift-16 */
      vuint32_t LINEDIS:1;             /* Enable Discard Of Frames With MAC Layer Errors */
      vuint32_t  :3;
      vuint32_t PRODIS:1;              /* Enable Discard Of Frames With Wrong Protocol Checksum */
      vuint32_t IPDIS:1;               /* Enable Discard Of Frames With Wrong IPv4 Header Checksum */
      vuint32_t PADREM:1;              /* Enable Padding Removal For Short IP Frames */
    } B;
  } RACC;

  union {                              /* Receive Classification Match Register for Class n */
    vuint32_t R;
    struct {
      vuint32_t  :15;
      vuint32_t MATCHEN:1;             /* Match Enable */
      vuint32_t  :1;
      vuint32_t CMP3:3;                /* Compare 3 */
      vuint32_t  :1;
      vuint32_t CMP2:3;                /* Compare 2 */
      vuint32_t  :1;
      vuint32_t CMP1:3;                /* Compare 1 */
      vuint32_t  :1;
      vuint32_t CMP0:3;                /* Compare 0 */
    } B;
  } RCMR[2];

  uint8_t ENET_reserved15[8];
  union {                              /* DMA Class Based Configuration */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t  :6;
      vuint32_t CALC_NOIPG:1;          /* Calculate no IPG */
      vuint32_t DMA_CLASS_EN:1;        /* DMA class enable */
      vuint32_t IDLE_SLOPE:16;         /* Idle slope */
    } B;
  } DMACFG[2];

  union {                              /* Receive Descriptor Active Register - Ring 1 */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t RDAR:1;                /* Receive Descriptor Active */
      vuint32_t  :24;
    } B;
  } RDAR1;

  union {                              /* Transmit Descriptor Active Register - Ring 1 */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t TDAR:1;                /* Transmit Descriptor Active */
      vuint32_t  :24;
    } B;
  } TDAR1;

  union {                              /* Receive Descriptor Active Register - Ring 2 */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t RDAR:1;                /* Receive Descriptor Active */
      vuint32_t  :24;
    } B;
  } RDAR2;

  union {                              /* Transmit Descriptor Active Register - Ring 2 */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t TDAR:1;                /* Transmit Descriptor Active */
      vuint32_t  :24;
    } B;
  } TDAR2;

  union {                              /* QOS Scheme */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t RX_FLUSH2:1;           /* RX Flush Ring 2 */
      vuint32_t RX_FLUSH1:1;           /* RX Flush Ring 1 */
      vuint32_t RX_FLUSH0:1;           /* RX Flush Ring 0 */
      vuint32_t TX_SCHEME:3;           /* TX scheme configuration */
    } B;
  } QOS;

  uint8_t ENET_reserved16[16];
  union {                              /* Tx Packet Count Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t TXPKTS15:1;            /* Packet count */
      vuint32_t TXPKTS14:1;            /* Packet count */
      vuint32_t TXPKTS13:1;            /* Packet count */
      vuint32_t TXPKTS12:1;            /* Packet count */
      vuint32_t TXPKTS11:1;            /* Packet count */
      vuint32_t TXPKTS10:1;            /* Packet count */
      vuint32_t TXPKTS9:1;             /* Packet count */
      vuint32_t TXPKTS8:1;             /* Packet count */
      vuint32_t TXPKTS7:1;             /* Packet count */
      vuint32_t TXPKTS6:1;             /* Packet count */
      vuint32_t TXPKTS5:1;             /* Packet count */
      vuint32_t TXPKTS4:1;             /* Packet count */
      vuint32_t TXPKTS3:1;             /* Packet count */
      vuint32_t TXPKTS2:1;             /* Packet count */
      vuint32_t TXPKTS1:1;             /* Packet count */
      vuint32_t TXPKTS0:1;             /* Packet count */
    } B;
  } RMON_T_PACKETS;

  union {                              /* Tx Broadcast Packets Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t TXPKTS15:1;            /* Broadcast packets */
      vuint32_t TXPKTS14:1;            /* Broadcast packets */
      vuint32_t TXPKTS13:1;            /* Broadcast packets */
      vuint32_t TXPKTS12:1;            /* Broadcast packets */
      vuint32_t TXPKTS11:1;            /* Broadcast packets */
      vuint32_t TXPKTS10:1;            /* Broadcast packets */
      vuint32_t TXPKTS9:1;             /* Broadcast packets */
      vuint32_t TXPKTS8:1;             /* Broadcast packets */
      vuint32_t TXPKTS7:1;             /* Broadcast packets */
      vuint32_t TXPKTS6:1;             /* Broadcast packets */
      vuint32_t TXPKTS5:1;             /* Broadcast packets */
      vuint32_t TXPKTS4:1;             /* Broadcast packets */
      vuint32_t TXPKTS3:1;             /* Broadcast packets */
      vuint32_t TXPKTS2:1;             /* Broadcast packets */
      vuint32_t TXPKTS1:1;             /* Broadcast packets */
      vuint32_t TXPKTS0:1;             /* Broadcast packets */
    } B;
  } RMON_T_BC_PKT;

  union {                              /* Tx Multicast Packets Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t TXPKTS15:1;            /* Multicast packets */
      vuint32_t TXPKTS14:1;            /* Multicast packets */
      vuint32_t TXPKTS13:1;            /* Multicast packets */
      vuint32_t TXPKTS12:1;            /* Multicast packets */
      vuint32_t TXPKTS11:1;            /* Multicast packets */
      vuint32_t TXPKTS10:1;            /* Multicast packets */
      vuint32_t TXPKTS9:1;             /* Multicast packets */
      vuint32_t TXPKTS8:1;             /* Multicast packets */
      vuint32_t TXPKTS7:1;             /* Multicast packets */
      vuint32_t TXPKTS6:1;             /* Multicast packets */
      vuint32_t TXPKTS5:1;             /* Multicast packets */
      vuint32_t TXPKTS4:1;             /* Multicast packets */
      vuint32_t TXPKTS3:1;             /* Multicast packets */
      vuint32_t TXPKTS2:1;             /* Multicast packets */
      vuint32_t TXPKTS1:1;             /* Multicast packets */
      vuint32_t TXPKTS0:1;             /* Multicast packets */
    } B;
  } RMON_T_MC_PKT;

  union {                              /* Tx Packets with CRC/Align Error Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t TXPKTS15:1;            /* Packets with CRC/align error */
      vuint32_t TXPKTS14:1;            /* Packets with CRC/align error */
      vuint32_t TXPKTS13:1;            /* Packets with CRC/align error */
      vuint32_t TXPKTS12:1;            /* Packets with CRC/align error */
      vuint32_t TXPKTS11:1;            /* Packets with CRC/align error */
      vuint32_t TXPKTS10:1;            /* Packets with CRC/align error */
      vuint32_t TXPKTS9:1;             /* Packets with CRC/align error */
      vuint32_t TXPKTS8:1;             /* Packets with CRC/align error */
      vuint32_t TXPKTS7:1;             /* Packets with CRC/align error */
      vuint32_t TXPKTS6:1;             /* Packets with CRC/align error */
      vuint32_t TXPKTS5:1;             /* Packets with CRC/align error */
      vuint32_t TXPKTS4:1;             /* Packets with CRC/align error */
      vuint32_t TXPKTS3:1;             /* Packets with CRC/align error */
      vuint32_t TXPKTS2:1;             /* Packets with CRC/align error */
      vuint32_t TXPKTS1:1;             /* Packets with CRC/align error */
      vuint32_t TXPKTS0:1;             /* Packets with CRC/align error */
    } B;
  } RMON_T_CRC_ALIGN;

  union {                              /* Tx Packets Less Than Bytes and Good CRC Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t TXPKTS15:1;            /* Packet count */
      vuint32_t TXPKTS14:1;            /* Packet count */
      vuint32_t TXPKTS13:1;            /* Packet count */
      vuint32_t TXPKTS12:1;            /* Packet count */
      vuint32_t TXPKTS11:1;            /* Packet count */
      vuint32_t TXPKTS10:1;            /* Packet count */
      vuint32_t TXPKTS9:1;             /* Packet count */
      vuint32_t TXPKTS8:1;             /* Packet count */
      vuint32_t TXPKTS7:1;             /* Packet count */
      vuint32_t TXPKTS6:1;             /* Packet count */
      vuint32_t TXPKTS5:1;             /* Packet count */
      vuint32_t TXPKTS4:1;             /* Packet count */
      vuint32_t TXPKTS3:1;             /* Packet count */
      vuint32_t TXPKTS2:1;             /* Packet count */
      vuint32_t TXPKTS1:1;             /* Packet count */
      vuint32_t TXPKTS0:1;             /* Packet count */
    } B;
  } RMON_T_UNDERSIZE;

  union {                              /* Tx Packets GT MAX_FL bytes and Good CRC Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t TXPKTS15:1;            /* Packet count */
      vuint32_t TXPKTS14:1;            /* Packet count */
      vuint32_t TXPKTS13:1;            /* Packet count */
      vuint32_t TXPKTS12:1;            /* Packet count */
      vuint32_t TXPKTS11:1;            /* Packet count */
      vuint32_t TXPKTS10:1;            /* Packet count */
      vuint32_t TXPKTS9:1;             /* Packet count */
      vuint32_t TXPKTS8:1;             /* Packet count */
      vuint32_t TXPKTS7:1;             /* Packet count */
      vuint32_t TXPKTS6:1;             /* Packet count */
      vuint32_t TXPKTS5:1;             /* Packet count */
      vuint32_t TXPKTS4:1;             /* Packet count */
      vuint32_t TXPKTS3:1;             /* Packet count */
      vuint32_t TXPKTS2:1;             /* Packet count */
      vuint32_t TXPKTS1:1;             /* Packet count */
      vuint32_t TXPKTS0:1;             /* Packet count */
    } B;
  } RMON_T_OVERSIZE;

  union {                              /* Tx Packets Less Than 64 Bytes and Bad CRC Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t TXPKTS15:1;            /* Packet count */
      vuint32_t TXPKTS14:1;            /* Packet count */
      vuint32_t TXPKTS13:1;            /* Packet count */
      vuint32_t TXPKTS12:1;            /* Packet count */
      vuint32_t TXPKTS11:1;            /* Packet count */
      vuint32_t TXPKTS10:1;            /* Packet count */
      vuint32_t TXPKTS9:1;             /* Packet count */
      vuint32_t TXPKTS8:1;             /* Packet count */
      vuint32_t TXPKTS7:1;             /* Packet count */
      vuint32_t TXPKTS6:1;             /* Packet count */
      vuint32_t TXPKTS5:1;             /* Packet count */
      vuint32_t TXPKTS4:1;             /* Packet count */
      vuint32_t TXPKTS3:1;             /* Packet count */
      vuint32_t TXPKTS2:1;             /* Packet count */
      vuint32_t TXPKTS1:1;             /* Packet count */
      vuint32_t TXPKTS0:1;             /* Packet count */
    } B;
  } RMON_T_FRAG;

  union {                              /* Tx Packets Greater Than MAX_FL bytes and Bad CRC Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t TXPKTS15:1;            /* Packet count */
      vuint32_t TXPKTS14:1;            /* Packet count */
      vuint32_t TXPKTS13:1;            /* Packet count */
      vuint32_t TXPKTS12:1;            /* Packet count */
      vuint32_t TXPKTS11:1;            /* Packet count */
      vuint32_t TXPKTS10:1;            /* Packet count */
      vuint32_t TXPKTS9:1;             /* Packet count */
      vuint32_t TXPKTS8:1;             /* Packet count */
      vuint32_t TXPKTS7:1;             /* Packet count */
      vuint32_t TXPKTS6:1;             /* Packet count */
      vuint32_t TXPKTS5:1;             /* Packet count */
      vuint32_t TXPKTS4:1;             /* Packet count */
      vuint32_t TXPKTS3:1;             /* Packet count */
      vuint32_t TXPKTS2:1;             /* Packet count */
      vuint32_t TXPKTS1:1;             /* Packet count */
      vuint32_t TXPKTS0:1;             /* Packet count */
    } B;
  } RMON_T_JAB;

  union {                              /* Tx Collision Count Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t TXPKTS15:1;            /* Packet count */
      vuint32_t TXPKTS14:1;            /* Packet count */
      vuint32_t TXPKTS13:1;            /* Packet count */
      vuint32_t TXPKTS12:1;            /* Packet count */
      vuint32_t TXPKTS11:1;            /* Packet count */
      vuint32_t TXPKTS10:1;            /* Packet count */
      vuint32_t TXPKTS9:1;             /* Packet count */
      vuint32_t TXPKTS8:1;             /* Packet count */
      vuint32_t TXPKTS7:1;             /* Packet count */
      vuint32_t TXPKTS6:1;             /* Packet count */
      vuint32_t TXPKTS5:1;             /* Packet count */
      vuint32_t TXPKTS4:1;             /* Packet count */
      vuint32_t TXPKTS3:1;             /* Packet count */
      vuint32_t TXPKTS2:1;             /* Packet count */
      vuint32_t TXPKTS1:1;             /* Packet count */
      vuint32_t TXPKTS0:1;             /* Packet count */
    } B;
  } RMON_T_COL;

  union {                              /* Tx 64-Byte Packets Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t TXPKTS15:1;            /* Packet count */
      vuint32_t TXPKTS14:1;            /* Packet count */
      vuint32_t TXPKTS13:1;            /* Packet count */
      vuint32_t TXPKTS12:1;            /* Packet count */
      vuint32_t TXPKTS11:1;            /* Packet count */
      vuint32_t TXPKTS10:1;            /* Packet count */
      vuint32_t TXPKTS9:1;             /* Packet count */
      vuint32_t TXPKTS8:1;             /* Packet count */
      vuint32_t TXPKTS7:1;             /* Packet count */
      vuint32_t TXPKTS6:1;             /* Packet count */
      vuint32_t TXPKTS5:1;             /* Packet count */
      vuint32_t TXPKTS4:1;             /* Packet count */
      vuint32_t TXPKTS3:1;             /* Packet count */
      vuint32_t TXPKTS2:1;             /* Packet count */
      vuint32_t TXPKTS1:1;             /* Packet count */
      vuint32_t TXPKTS0:1;             /* Packet count */
    } B;
  } RMON_T_P64;

  union {                              /* Tx 65- to 127-byte Packets Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t TXPKTS15:1;            /* Packet count */
      vuint32_t TXPKTS14:1;            /* Packet count */
      vuint32_t TXPKTS13:1;            /* Packet count */
      vuint32_t TXPKTS12:1;            /* Packet count */
      vuint32_t TXPKTS11:1;            /* Packet count */
      vuint32_t TXPKTS10:1;            /* Packet count */
      vuint32_t TXPKTS9:1;             /* Packet count */
      vuint32_t TXPKTS8:1;             /* Packet count */
      vuint32_t TXPKTS7:1;             /* Packet count */
      vuint32_t TXPKTS6:1;             /* Packet count */
      vuint32_t TXPKTS5:1;             /* Packet count */
      vuint32_t TXPKTS4:1;             /* Packet count */
      vuint32_t TXPKTS3:1;             /* Packet count */
      vuint32_t TXPKTS2:1;             /* Packet count */
      vuint32_t TXPKTS1:1;             /* Packet count */
      vuint32_t TXPKTS0:1;             /* Packet count */
    } B;
  } RMON_T_P65TO127;

  union {                              /* Tx 128- to 255-byte Packets Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t TXPKTS15:1;            /* Packet count */
      vuint32_t TXPKTS14:1;            /* Packet count */
      vuint32_t TXPKTS13:1;            /* Packet count */
      vuint32_t TXPKTS12:1;            /* Packet count */
      vuint32_t TXPKTS11:1;            /* Packet count */
      vuint32_t TXPKTS10:1;            /* Packet count */
      vuint32_t TXPKTS9:1;             /* Packet count */
      vuint32_t TXPKTS8:1;             /* Packet count */
      vuint32_t TXPKTS7:1;             /* Packet count */
      vuint32_t TXPKTS6:1;             /* Packet count */
      vuint32_t TXPKTS5:1;             /* Packet count */
      vuint32_t TXPKTS4:1;             /* Packet count */
      vuint32_t TXPKTS3:1;             /* Packet count */
      vuint32_t TXPKTS2:1;             /* Packet count */
      vuint32_t TXPKTS1:1;             /* Packet count */
      vuint32_t TXPKTS0:1;             /* Packet count */
    } B;
  } RMON_T_P128TO255;

  union {                              /* Tx 256- to 511-byte Packets Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t TXPKTS15:1;            /* Packet count */
      vuint32_t TXPKTS14:1;            /* Packet count */
      vuint32_t TXPKTS13:1;            /* Packet count */
      vuint32_t TXPKTS12:1;            /* Packet count */
      vuint32_t TXPKTS11:1;            /* Packet count */
      vuint32_t TXPKTS10:1;            /* Packet count */
      vuint32_t TXPKTS9:1;             /* Packet count */
      vuint32_t TXPKTS8:1;             /* Packet count */
      vuint32_t TXPKTS7:1;             /* Packet count */
      vuint32_t TXPKTS6:1;             /* Packet count */
      vuint32_t TXPKTS5:1;             /* Packet count */
      vuint32_t TXPKTS4:1;             /* Packet count */
      vuint32_t TXPKTS3:1;             /* Packet count */
      vuint32_t TXPKTS2:1;             /* Packet count */
      vuint32_t TXPKTS1:1;             /* Packet count */
      vuint32_t TXPKTS0:1;             /* Packet count */
    } B;
  } RMON_T_P256TO511;

  union {                              /* Tx 512- to 1023-byte Packets Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t TXPKTS15:1;            /* Packet count */
      vuint32_t TXPKTS14:1;            /* Packet count */
      vuint32_t TXPKTS13:1;            /* Packet count */
      vuint32_t TXPKTS12:1;            /* Packet count */
      vuint32_t TXPKTS11:1;            /* Packet count */
      vuint32_t TXPKTS10:1;            /* Packet count */
      vuint32_t TXPKTS9:1;             /* Packet count */
      vuint32_t TXPKTS8:1;             /* Packet count */
      vuint32_t TXPKTS7:1;             /* Packet count */
      vuint32_t TXPKTS6:1;             /* Packet count */
      vuint32_t TXPKTS5:1;             /* Packet count */
      vuint32_t TXPKTS4:1;             /* Packet count */
      vuint32_t TXPKTS3:1;             /* Packet count */
      vuint32_t TXPKTS2:1;             /* Packet count */
      vuint32_t TXPKTS1:1;             /* Packet count */
      vuint32_t TXPKTS0:1;             /* Packet count */
    } B;
  } RMON_T_P512TO1023;

  union {                              /* Tx 1024- to 2047-byte Packets Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t TXPKTS15:1;            /* Packet count */
      vuint32_t TXPKTS14:1;            /* Packet count */
      vuint32_t TXPKTS13:1;            /* Packet count */
      vuint32_t TXPKTS12:1;            /* Packet count */
      vuint32_t TXPKTS11:1;            /* Packet count */
      vuint32_t TXPKTS10:1;            /* Packet count */
      vuint32_t TXPKTS9:1;             /* Packet count */
      vuint32_t TXPKTS8:1;             /* Packet count */
      vuint32_t TXPKTS7:1;             /* Packet count */
      vuint32_t TXPKTS6:1;             /* Packet count */
      vuint32_t TXPKTS5:1;             /* Packet count */
      vuint32_t TXPKTS4:1;             /* Packet count */
      vuint32_t TXPKTS3:1;             /* Packet count */
      vuint32_t TXPKTS2:1;             /* Packet count */
      vuint32_t TXPKTS1:1;             /* Packet count */
      vuint32_t TXPKTS0:1;             /* Packet count */
    } B;
  } RMON_T_P1024TO2047;

  union {                              /* Tx Packets Greater Than 2048 Bytes Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t TXPKTS15:1;            /* Packet count */
      vuint32_t TXPKTS14:1;            /* Packet count */
      vuint32_t TXPKTS13:1;            /* Packet count */
      vuint32_t TXPKTS12:1;            /* Packet count */
      vuint32_t TXPKTS11:1;            /* Packet count */
      vuint32_t TXPKTS10:1;            /* Packet count */
      vuint32_t TXPKTS9:1;             /* Packet count */
      vuint32_t TXPKTS8:1;             /* Packet count */
      vuint32_t TXPKTS7:1;             /* Packet count */
      vuint32_t TXPKTS6:1;             /* Packet count */
      vuint32_t TXPKTS5:1;             /* Packet count */
      vuint32_t TXPKTS4:1;             /* Packet count */
      vuint32_t TXPKTS3:1;             /* Packet count */
      vuint32_t TXPKTS2:1;             /* Packet count */
      vuint32_t TXPKTS1:1;             /* Packet count */
      vuint32_t TXPKTS0:1;             /* Packet count */
    } B;
  } RMON_T_P_GTE2048;

  union {                              /* Tx Octets Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t TXOCTS31:1;            /* Octet count */
      vuint32_t TXOCTS30:1;            /* Octet count */
      vuint32_t TXOCTS29:1;            /* Octet count */
      vuint32_t TXOCTS28:1;            /* Octet count */
      vuint32_t TXOCTS27:1;            /* Octet count */
      vuint32_t TXOCTS26:1;            /* Octet count */
      vuint32_t TXOCTS25:1;            /* Octet count */
      vuint32_t TXOCTS24:1;            /* Octet count */
      vuint32_t TXOCTS23:1;            /* Octet count */
      vuint32_t TXOCTS22:1;            /* Octet count */
      vuint32_t TXOCTS21:1;            /* Octet count */
      vuint32_t TXOCTS20:1;            /* Octet count */
      vuint32_t TXOCTS19:1;            /* Octet count */
      vuint32_t TXOCTS18:1;            /* Octet count */
      vuint32_t TXOCTS17:1;            /* Octet count */
      vuint32_t TXOCTS16:1;            /* Octet count */
      vuint32_t TXOCTS15:1;            /* Octet count */
      vuint32_t TXOCTS14:1;            /* Octet count */
      vuint32_t TXOCTS13:1;            /* Octet count */
      vuint32_t TXOCTS12:1;            /* Octet count */
      vuint32_t TXOCTS11:1;            /* Octet count */
      vuint32_t TXOCTS10:1;            /* Octet count */
      vuint32_t TXOCTS9:1;             /* Octet count */
      vuint32_t TXOCTS8:1;             /* Octet count */
      vuint32_t TXOCTS7:1;             /* Octet count */
      vuint32_t TXOCTS6:1;             /* Octet count */
      vuint32_t TXOCTS5:1;             /* Octet count */
      vuint32_t TXOCTS4:1;             /* Octet count */
      vuint32_t TXOCTS3:1;             /* Octet count */
      vuint32_t TXOCTS2:1;             /* Octet count */
      vuint32_t TXOCTS1:1;             /* Octet count */
      vuint32_t TXOCTS0:1;             /* Octet count */
    } B;
  } RMON_T_OCTETS;

  uint8_t ENET_reserved17[4];
  union {                              /* Frames Transmitted OK Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t COUNT15:1;             /* Frame count */
      vuint32_t COUNT14:1;             /* Frame count */
      vuint32_t COUNT13:1;             /* Frame count */
      vuint32_t COUNT12:1;             /* Frame count */
      vuint32_t COUNT11:1;             /* Frame count */
      vuint32_t COUNT10:1;             /* Frame count */
      vuint32_t COUNT9:1;              /* Frame count */
      vuint32_t COUNT8:1;              /* Frame count */
      vuint32_t COUNT7:1;              /* Frame count */
      vuint32_t COUNT6:1;              /* Frame count */
      vuint32_t COUNT5:1;              /* Frame count */
      vuint32_t COUNT4:1;              /* Frame count */
      vuint32_t COUNT3:1;              /* Frame count */
      vuint32_t COUNT2:1;              /* Frame count */
      vuint32_t COUNT1:1;              /* Frame count */
      vuint32_t COUNT0:1;              /* Frame count */
    } B;
  } IEEE_T_FRAME_OK;

  union {                              /* Frames Transmitted with Single Collision Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t COUNT15:1;             /* Frame count */
      vuint32_t COUNT14:1;             /* Frame count */
      vuint32_t COUNT13:1;             /* Frame count */
      vuint32_t COUNT12:1;             /* Frame count */
      vuint32_t COUNT11:1;             /* Frame count */
      vuint32_t COUNT10:1;             /* Frame count */
      vuint32_t COUNT9:1;              /* Frame count */
      vuint32_t COUNT8:1;              /* Frame count */
      vuint32_t COUNT7:1;              /* Frame count */
      vuint32_t COUNT6:1;              /* Frame count */
      vuint32_t COUNT5:1;              /* Frame count */
      vuint32_t COUNT4:1;              /* Frame count */
      vuint32_t COUNT3:1;              /* Frame count */
      vuint32_t COUNT2:1;              /* Frame count */
      vuint32_t COUNT1:1;              /* Frame count */
      vuint32_t COUNT0:1;              /* Frame count */
    } B;
  } IEEE_T_1COL;

  union {                              /* Frames Transmitted with Multiple Collisions Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t COUNT15:1;             /* Frame count */
      vuint32_t COUNT14:1;             /* Frame count */
      vuint32_t COUNT13:1;             /* Frame count */
      vuint32_t COUNT12:1;             /* Frame count */
      vuint32_t COUNT11:1;             /* Frame count */
      vuint32_t COUNT10:1;             /* Frame count */
      vuint32_t COUNT9:1;              /* Frame count */
      vuint32_t COUNT8:1;              /* Frame count */
      vuint32_t COUNT7:1;              /* Frame count */
      vuint32_t COUNT6:1;              /* Frame count */
      vuint32_t COUNT5:1;              /* Frame count */
      vuint32_t COUNT4:1;              /* Frame count */
      vuint32_t COUNT3:1;              /* Frame count */
      vuint32_t COUNT2:1;              /* Frame count */
      vuint32_t COUNT1:1;              /* Frame count */
      vuint32_t COUNT0:1;              /* Frame count */
    } B;
  } IEEE_T_MCOL;

  union {                              /* Frames Transmitted after Deferral Delay Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t COUNT15:1;             /* Frame count */
      vuint32_t COUNT14:1;             /* Frame count */
      vuint32_t COUNT13:1;             /* Frame count */
      vuint32_t COUNT12:1;             /* Frame count */
      vuint32_t COUNT11:1;             /* Frame count */
      vuint32_t COUNT10:1;             /* Frame count */
      vuint32_t COUNT9:1;              /* Frame count */
      vuint32_t COUNT8:1;              /* Frame count */
      vuint32_t COUNT7:1;              /* Frame count */
      vuint32_t COUNT6:1;              /* Frame count */
      vuint32_t COUNT5:1;              /* Frame count */
      vuint32_t COUNT4:1;              /* Frame count */
      vuint32_t COUNT3:1;              /* Frame count */
      vuint32_t COUNT2:1;              /* Frame count */
      vuint32_t COUNT1:1;              /* Frame count */
      vuint32_t COUNT0:1;              /* Frame count */
    } B;
  } IEEE_T_DEF;

  union {                              /* Frames Transmitted with Late Collision Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t COUNT15:1;             /* Frame count */
      vuint32_t COUNT14:1;             /* Frame count */
      vuint32_t COUNT13:1;             /* Frame count */
      vuint32_t COUNT12:1;             /* Frame count */
      vuint32_t COUNT11:1;             /* Frame count */
      vuint32_t COUNT10:1;             /* Frame count */
      vuint32_t COUNT9:1;              /* Frame count */
      vuint32_t COUNT8:1;              /* Frame count */
      vuint32_t COUNT7:1;              /* Frame count */
      vuint32_t COUNT6:1;              /* Frame count */
      vuint32_t COUNT5:1;              /* Frame count */
      vuint32_t COUNT4:1;              /* Frame count */
      vuint32_t COUNT3:1;              /* Frame count */
      vuint32_t COUNT2:1;              /* Frame count */
      vuint32_t COUNT1:1;              /* Frame count */
      vuint32_t COUNT0:1;              /* Frame count */
    } B;
  } IEEE_T_LCOL;

  union {                              /* Frames Transmitted with Excessive Collisions Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t COUNT15:1;             /* Frame count */
      vuint32_t COUNT14:1;             /* Frame count */
      vuint32_t COUNT13:1;             /* Frame count */
      vuint32_t COUNT12:1;             /* Frame count */
      vuint32_t COUNT11:1;             /* Frame count */
      vuint32_t COUNT10:1;             /* Frame count */
      vuint32_t COUNT9:1;              /* Frame count */
      vuint32_t COUNT8:1;              /* Frame count */
      vuint32_t COUNT7:1;              /* Frame count */
      vuint32_t COUNT6:1;              /* Frame count */
      vuint32_t COUNT5:1;              /* Frame count */
      vuint32_t COUNT4:1;              /* Frame count */
      vuint32_t COUNT3:1;              /* Frame count */
      vuint32_t COUNT2:1;              /* Frame count */
      vuint32_t COUNT1:1;              /* Frame count */
      vuint32_t COUNT0:1;              /* Frame count */
    } B;
  } IEEE_T_EXCOL;

  union {                              /* Frames Transmitted with Tx FIFO Underrun Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t COUNT15:1;             /* Frame count */
      vuint32_t COUNT14:1;             /* Frame count */
      vuint32_t COUNT13:1;             /* Frame count */
      vuint32_t COUNT12:1;             /* Frame count */
      vuint32_t COUNT11:1;             /* Frame count */
      vuint32_t COUNT10:1;             /* Frame count */
      vuint32_t COUNT9:1;              /* Frame count */
      vuint32_t COUNT8:1;              /* Frame count */
      vuint32_t COUNT7:1;              /* Frame count */
      vuint32_t COUNT6:1;              /* Frame count */
      vuint32_t COUNT5:1;              /* Frame count */
      vuint32_t COUNT4:1;              /* Frame count */
      vuint32_t COUNT3:1;              /* Frame count */
      vuint32_t COUNT2:1;              /* Frame count */
      vuint32_t COUNT1:1;              /* Frame count */
      vuint32_t COUNT0:1;              /* Frame count */
    } B;
  } IEEE_T_MACERR;

  union {                              /* Frames Transmitted with Carrier Sense Error Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t COUNT15:1;             /* Frame count */
      vuint32_t COUNT14:1;             /* Frame count */
      vuint32_t COUNT13:1;             /* Frame count */
      vuint32_t COUNT12:1;             /* Frame count */
      vuint32_t COUNT11:1;             /* Frame count */
      vuint32_t COUNT10:1;             /* Frame count */
      vuint32_t COUNT9:1;              /* Frame count */
      vuint32_t COUNT8:1;              /* Frame count */
      vuint32_t COUNT7:1;              /* Frame count */
      vuint32_t COUNT6:1;              /* Frame count */
      vuint32_t COUNT5:1;              /* Frame count */
      vuint32_t COUNT4:1;              /* Frame count */
      vuint32_t COUNT3:1;              /* Frame count */
      vuint32_t COUNT2:1;              /* Frame count */
      vuint32_t COUNT1:1;              /* Frame count */
      vuint32_t COUNT0:1;              /* Frame count */
    } B;
  } IEEE_T_CSERR;

  uint8_t ENET_reserved18[4];
  union {                              /* Flow Control Pause Frames Transmitted Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t COUNT15:1;             /* Frame count */
      vuint32_t COUNT14:1;             /* Frame count */
      vuint32_t COUNT13:1;             /* Frame count */
      vuint32_t COUNT12:1;             /* Frame count */
      vuint32_t COUNT11:1;             /* Frame count */
      vuint32_t COUNT10:1;             /* Frame count */
      vuint32_t COUNT9:1;              /* Frame count */
      vuint32_t COUNT8:1;              /* Frame count */
      vuint32_t COUNT7:1;              /* Frame count */
      vuint32_t COUNT6:1;              /* Frame count */
      vuint32_t COUNT5:1;              /* Frame count */
      vuint32_t COUNT4:1;              /* Frame count */
      vuint32_t COUNT3:1;              /* Frame count */
      vuint32_t COUNT2:1;              /* Frame count */
      vuint32_t COUNT1:1;              /* Frame count */
      vuint32_t COUNT0:1;              /* Frame count */
    } B;
  } IEEE_T_FDXFC;

  union {                              /* Octet Count for Frames Transmitted w/o Error Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t COUNT31:1;             /* Octet count */
      vuint32_t COUNT30:1;             /* Octet count */
      vuint32_t COUNT29:1;             /* Octet count */
      vuint32_t COUNT28:1;             /* Octet count */
      vuint32_t COUNT27:1;             /* Octet count */
      vuint32_t COUNT26:1;             /* Octet count */
      vuint32_t COUNT25:1;             /* Octet count */
      vuint32_t COUNT24:1;             /* Octet count */
      vuint32_t COUNT23:1;             /* Octet count */
      vuint32_t COUNT22:1;             /* Octet count */
      vuint32_t COUNT21:1;             /* Octet count */
      vuint32_t COUNT20:1;             /* Octet count */
      vuint32_t COUNT19:1;             /* Octet count */
      vuint32_t COUNT18:1;             /* Octet count */
      vuint32_t COUNT17:1;             /* Octet count */
      vuint32_t COUNT16:1;             /* Octet count */
      vuint32_t COUNT15:1;             /* Octet count */
      vuint32_t COUNT14:1;             /* Octet count */
      vuint32_t COUNT13:1;             /* Octet count */
      vuint32_t COUNT12:1;             /* Octet count */
      vuint32_t COUNT11:1;             /* Octet count */
      vuint32_t COUNT10:1;             /* Octet count */
      vuint32_t COUNT9:1;              /* Octet count */
      vuint32_t COUNT8:1;              /* Octet count */
      vuint32_t COUNT7:1;              /* Octet count */
      vuint32_t COUNT6:1;              /* Octet count */
      vuint32_t COUNT5:1;              /* Octet count */
      vuint32_t COUNT4:1;              /* Octet count */
      vuint32_t COUNT3:1;              /* Octet count */
      vuint32_t COUNT2:1;              /* Octet count */
      vuint32_t COUNT1:1;              /* Octet count */
      vuint32_t COUNT0:1;              /* Octet count */
    } B;
  } IEEE_T_OCTETS_OK;

  uint8_t ENET_reserved19[12];
  union {                              /* Rx Packet Count Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t COUNT15:1;             /* Packet count */
      vuint32_t COUNT14:1;             /* Packet count */
      vuint32_t COUNT13:1;             /* Packet count */
      vuint32_t COUNT12:1;             /* Packet count */
      vuint32_t COUNT11:1;             /* Packet count */
      vuint32_t COUNT10:1;             /* Packet count */
      vuint32_t COUNT9:1;              /* Packet count */
      vuint32_t COUNT8:1;              /* Packet count */
      vuint32_t COUNT7:1;              /* Packet count */
      vuint32_t COUNT6:1;              /* Packet count */
      vuint32_t COUNT5:1;              /* Packet count */
      vuint32_t COUNT4:1;              /* Packet count */
      vuint32_t COUNT3:1;              /* Packet count */
      vuint32_t COUNT2:1;              /* Packet count */
      vuint32_t COUNT1:1;              /* Packet count */
      vuint32_t COUNT0:1;              /* Packet count */
    } B;
  } RMON_R_PACKETS;

  union {                              /* Rx Broadcast Packets Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t COUNT15:1;             /* Packet count */
      vuint32_t COUNT14:1;             /* Packet count */
      vuint32_t COUNT13:1;             /* Packet count */
      vuint32_t COUNT12:1;             /* Packet count */
      vuint32_t COUNT11:1;             /* Packet count */
      vuint32_t COUNT10:1;             /* Packet count */
      vuint32_t COUNT9:1;              /* Packet count */
      vuint32_t COUNT8:1;              /* Packet count */
      vuint32_t COUNT7:1;              /* Packet count */
      vuint32_t COUNT6:1;              /* Packet count */
      vuint32_t COUNT5:1;              /* Packet count */
      vuint32_t COUNT4:1;              /* Packet count */
      vuint32_t COUNT3:1;              /* Packet count */
      vuint32_t COUNT2:1;              /* Packet count */
      vuint32_t COUNT1:1;              /* Packet count */
      vuint32_t COUNT0:1;              /* Packet count */
    } B;
  } RMON_R_BC_PKT;

  union {                              /* Rx Multicast Packets Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t COUNT15:1;             /* Packet count */
      vuint32_t COUNT14:1;             /* Packet count */
      vuint32_t COUNT13:1;             /* Packet count */
      vuint32_t COUNT12:1;             /* Packet count */
      vuint32_t COUNT11:1;             /* Packet count */
      vuint32_t COUNT10:1;             /* Packet count */
      vuint32_t COUNT9:1;              /* Packet count */
      vuint32_t COUNT8:1;              /* Packet count */
      vuint32_t COUNT7:1;              /* Packet count */
      vuint32_t COUNT6:1;              /* Packet count */
      vuint32_t COUNT5:1;              /* Packet count */
      vuint32_t COUNT4:1;              /* Packet count */
      vuint32_t COUNT3:1;              /* Packet count */
      vuint32_t COUNT2:1;              /* Packet count */
      vuint32_t COUNT1:1;              /* Packet count */
      vuint32_t COUNT0:1;              /* Packet count */
    } B;
  } RMON_R_MC_PKT;

  union {                              /* Rx Packets with CRC/Align Error Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t COUNT15:1;             /* Packet count */
      vuint32_t COUNT14:1;             /* Packet count */
      vuint32_t COUNT13:1;             /* Packet count */
      vuint32_t COUNT12:1;             /* Packet count */
      vuint32_t COUNT11:1;             /* Packet count */
      vuint32_t COUNT10:1;             /* Packet count */
      vuint32_t COUNT9:1;              /* Packet count */
      vuint32_t COUNT8:1;              /* Packet count */
      vuint32_t COUNT7:1;              /* Packet count */
      vuint32_t COUNT6:1;              /* Packet count */
      vuint32_t COUNT5:1;              /* Packet count */
      vuint32_t COUNT4:1;              /* Packet count */
      vuint32_t COUNT3:1;              /* Packet count */
      vuint32_t COUNT2:1;              /* Packet count */
      vuint32_t COUNT1:1;              /* Packet count */
      vuint32_t COUNT0:1;              /* Packet count */
    } B;
  } RMON_R_CRC_ALIGN;

  union {                              /* Rx Packets with Less Than 64 Bytes and Good CRC Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t COUNT15:1;             /* Packet count */
      vuint32_t COUNT14:1;             /* Packet count */
      vuint32_t COUNT13:1;             /* Packet count */
      vuint32_t COUNT12:1;             /* Packet count */
      vuint32_t COUNT11:1;             /* Packet count */
      vuint32_t COUNT10:1;             /* Packet count */
      vuint32_t COUNT9:1;              /* Packet count */
      vuint32_t COUNT8:1;              /* Packet count */
      vuint32_t COUNT7:1;              /* Packet count */
      vuint32_t COUNT6:1;              /* Packet count */
      vuint32_t COUNT5:1;              /* Packet count */
      vuint32_t COUNT4:1;              /* Packet count */
      vuint32_t COUNT3:1;              /* Packet count */
      vuint32_t COUNT2:1;              /* Packet count */
      vuint32_t COUNT1:1;              /* Packet count */
      vuint32_t COUNT0:1;              /* Packet count */
    } B;
  } RMON_R_UNDERSIZE;

  union {                              /* Rx Packets Greater Than MAX_FL and Good CRC Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t COUNT15:1;             /* Packet count */
      vuint32_t COUNT14:1;             /* Packet count */
      vuint32_t COUNT13:1;             /* Packet count */
      vuint32_t COUNT12:1;             /* Packet count */
      vuint32_t COUNT11:1;             /* Packet count */
      vuint32_t COUNT10:1;             /* Packet count */
      vuint32_t COUNT9:1;              /* Packet count */
      vuint32_t COUNT8:1;              /* Packet count */
      vuint32_t COUNT7:1;              /* Packet count */
      vuint32_t COUNT6:1;              /* Packet count */
      vuint32_t COUNT5:1;              /* Packet count */
      vuint32_t COUNT4:1;              /* Packet count */
      vuint32_t COUNT3:1;              /* Packet count */
      vuint32_t COUNT2:1;              /* Packet count */
      vuint32_t COUNT1:1;              /* Packet count */
      vuint32_t COUNT0:1;              /* Packet count */
    } B;
  } RMON_R_OVERSIZE;

  union {                              /* Rx Packets Less Than 64 Bytes and Bad CRC Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t COUNT15:1;             /* Packet count */
      vuint32_t COUNT14:1;             /* Packet count */
      vuint32_t COUNT13:1;             /* Packet count */
      vuint32_t COUNT12:1;             /* Packet count */
      vuint32_t COUNT11:1;             /* Packet count */
      vuint32_t COUNT10:1;             /* Packet count */
      vuint32_t COUNT9:1;              /* Packet count */
      vuint32_t COUNT8:1;              /* Packet count */
      vuint32_t COUNT7:1;              /* Packet count */
      vuint32_t COUNT6:1;              /* Packet count */
      vuint32_t COUNT5:1;              /* Packet count */
      vuint32_t COUNT4:1;              /* Packet count */
      vuint32_t COUNT3:1;              /* Packet count */
      vuint32_t COUNT2:1;              /* Packet count */
      vuint32_t COUNT1:1;              /* Packet count */
      vuint32_t COUNT0:1;              /* Packet count */
    } B;
  } RMON_R_FRAG;

  union {                              /* Rx Packets Greater Than MAX_FL Bytes and Bad CRC Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t COUNT15:1;             /* Packet count */
      vuint32_t COUNT14:1;             /* Packet count */
      vuint32_t COUNT13:1;             /* Packet count */
      vuint32_t COUNT12:1;             /* Packet count */
      vuint32_t COUNT11:1;             /* Packet count */
      vuint32_t COUNT10:1;             /* Packet count */
      vuint32_t COUNT9:1;              /* Packet count */
      vuint32_t COUNT8:1;              /* Packet count */
      vuint32_t COUNT7:1;              /* Packet count */
      vuint32_t COUNT6:1;              /* Packet count */
      vuint32_t COUNT5:1;              /* Packet count */
      vuint32_t COUNT4:1;              /* Packet count */
      vuint32_t COUNT3:1;              /* Packet count */
      vuint32_t COUNT2:1;              /* Packet count */
      vuint32_t COUNT1:1;              /* Packet count */
      vuint32_t COUNT0:1;              /* Packet count */
    } B;
  } RMON_R_JAB;

  uint8_t ENET_reserved20[4];
  union {                              /* Rx 64-Byte Packets Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t COUNT15:1;             /* Packet count */
      vuint32_t COUNT14:1;             /* Packet count */
      vuint32_t COUNT13:1;             /* Packet count */
      vuint32_t COUNT12:1;             /* Packet count */
      vuint32_t COUNT11:1;             /* Packet count */
      vuint32_t COUNT10:1;             /* Packet count */
      vuint32_t COUNT9:1;              /* Packet count */
      vuint32_t COUNT8:1;              /* Packet count */
      vuint32_t COUNT7:1;              /* Packet count */
      vuint32_t COUNT6:1;              /* Packet count */
      vuint32_t COUNT5:1;              /* Packet count */
      vuint32_t COUNT4:1;              /* Packet count */
      vuint32_t COUNT3:1;              /* Packet count */
      vuint32_t COUNT2:1;              /* Packet count */
      vuint32_t COUNT1:1;              /* Packet count */
      vuint32_t COUNT0:1;              /* Packet count */
    } B;
  } RMON_R_P64;

  union {                              /* Rx 65- to 127-Byte Packets Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t COUNT15:1;             /* Packet count */
      vuint32_t COUNT14:1;             /* Packet count */
      vuint32_t COUNT13:1;             /* Packet count */
      vuint32_t COUNT12:1;             /* Packet count */
      vuint32_t COUNT11:1;             /* Packet count */
      vuint32_t COUNT10:1;             /* Packet count */
      vuint32_t COUNT9:1;              /* Packet count */
      vuint32_t COUNT8:1;              /* Packet count */
      vuint32_t COUNT7:1;              /* Packet count */
      vuint32_t COUNT6:1;              /* Packet count */
      vuint32_t COUNT5:1;              /* Packet count */
      vuint32_t COUNT4:1;              /* Packet count */
      vuint32_t COUNT3:1;              /* Packet count */
      vuint32_t COUNT2:1;              /* Packet count */
      vuint32_t COUNT1:1;              /* Packet count */
      vuint32_t COUNT0:1;              /* Packet count */
    } B;
  } RMON_R_P65TO127;

  union {                              /* Rx 128- to 255-Byte Packets Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t COUNT15:1;             /* Packet count */
      vuint32_t COUNT14:1;             /* Packet count */
      vuint32_t COUNT13:1;             /* Packet count */
      vuint32_t COUNT12:1;             /* Packet count */
      vuint32_t COUNT11:1;             /* Packet count */
      vuint32_t COUNT10:1;             /* Packet count */
      vuint32_t COUNT9:1;              /* Packet count */
      vuint32_t COUNT8:1;              /* Packet count */
      vuint32_t COUNT7:1;              /* Packet count */
      vuint32_t COUNT6:1;              /* Packet count */
      vuint32_t COUNT5:1;              /* Packet count */
      vuint32_t COUNT4:1;              /* Packet count */
      vuint32_t COUNT3:1;              /* Packet count */
      vuint32_t COUNT2:1;              /* Packet count */
      vuint32_t COUNT1:1;              /* Packet count */
      vuint32_t COUNT0:1;              /* Packet count */
    } B;
  } RMON_R_P128TO255;

  union {                              /* Rx 256- to 511-Byte Packets Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t COUNT15:1;             /* Packet count */
      vuint32_t COUNT14:1;             /* Packet count */
      vuint32_t COUNT13:1;             /* Packet count */
      vuint32_t COUNT12:1;             /* Packet count */
      vuint32_t COUNT11:1;             /* Packet count */
      vuint32_t COUNT10:1;             /* Packet count */
      vuint32_t COUNT9:1;              /* Packet count */
      vuint32_t COUNT8:1;              /* Packet count */
      vuint32_t COUNT7:1;              /* Packet count */
      vuint32_t COUNT6:1;              /* Packet count */
      vuint32_t COUNT5:1;              /* Packet count */
      vuint32_t COUNT4:1;              /* Packet count */
      vuint32_t COUNT3:1;              /* Packet count */
      vuint32_t COUNT2:1;              /* Packet count */
      vuint32_t COUNT1:1;              /* Packet count */
      vuint32_t COUNT0:1;              /* Packet count */
    } B;
  } RMON_R_P256TO511;

  union {                              /* Rx 512- to 1023-Byte Packets Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t COUNT15:1;             /* Packet count */
      vuint32_t COUNT14:1;             /* Packet count */
      vuint32_t COUNT13:1;             /* Packet count */
      vuint32_t COUNT12:1;             /* Packet count */
      vuint32_t COUNT11:1;             /* Packet count */
      vuint32_t COUNT10:1;             /* Packet count */
      vuint32_t COUNT9:1;              /* Packet count */
      vuint32_t COUNT8:1;              /* Packet count */
      vuint32_t COUNT7:1;              /* Packet count */
      vuint32_t COUNT6:1;              /* Packet count */
      vuint32_t COUNT5:1;              /* Packet count */
      vuint32_t COUNT4:1;              /* Packet count */
      vuint32_t COUNT3:1;              /* Packet count */
      vuint32_t COUNT2:1;              /* Packet count */
      vuint32_t COUNT1:1;              /* Packet count */
      vuint32_t COUNT0:1;              /* Packet count */
    } B;
  } RMON_R_P512TO1023;

  union {                              /* Rx 1024- to 2047-Byte Packets Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t COUNT15:1;             /* Packet count */
      vuint32_t COUNT14:1;             /* Packet count */
      vuint32_t COUNT13:1;             /* Packet count */
      vuint32_t COUNT12:1;             /* Packet count */
      vuint32_t COUNT11:1;             /* Packet count */
      vuint32_t COUNT10:1;             /* Packet count */
      vuint32_t COUNT9:1;              /* Packet count */
      vuint32_t COUNT8:1;              /* Packet count */
      vuint32_t COUNT7:1;              /* Packet count */
      vuint32_t COUNT6:1;              /* Packet count */
      vuint32_t COUNT5:1;              /* Packet count */
      vuint32_t COUNT4:1;              /* Packet count */
      vuint32_t COUNT3:1;              /* Packet count */
      vuint32_t COUNT2:1;              /* Packet count */
      vuint32_t COUNT1:1;              /* Packet count */
      vuint32_t COUNT0:1;              /* Packet count */
    } B;
  } RMON_R_P1024TO2047;

  union {                              /* Rx Packets Greater than 2048 Bytes Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t COUNT15:1;             /* Packet count */
      vuint32_t COUNT14:1;             /* Packet count */
      vuint32_t COUNT13:1;             /* Packet count */
      vuint32_t COUNT12:1;             /* Packet count */
      vuint32_t COUNT11:1;             /* Packet count */
      vuint32_t COUNT10:1;             /* Packet count */
      vuint32_t COUNT9:1;              /* Packet count */
      vuint32_t COUNT8:1;              /* Packet count */
      vuint32_t COUNT7:1;              /* Packet count */
      vuint32_t COUNT6:1;              /* Packet count */
      vuint32_t COUNT5:1;              /* Packet count */
      vuint32_t COUNT4:1;              /* Packet count */
      vuint32_t COUNT3:1;              /* Packet count */
      vuint32_t COUNT2:1;              /* Packet count */
      vuint32_t COUNT1:1;              /* Packet count */
      vuint32_t COUNT0:1;              /* Packet count */
    } B;
  } RMON_R_P_GTE2048;

  union {                              /* Rx Octets Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t COUNT31:1;             /* Octet count */
      vuint32_t COUNT30:1;             /* Octet count */
      vuint32_t COUNT29:1;             /* Octet count */
      vuint32_t COUNT28:1;             /* Octet count */
      vuint32_t COUNT27:1;             /* Octet count */
      vuint32_t COUNT26:1;             /* Octet count */
      vuint32_t COUNT25:1;             /* Octet count */
      vuint32_t COUNT24:1;             /* Octet count */
      vuint32_t COUNT23:1;             /* Octet count */
      vuint32_t COUNT22:1;             /* Octet count */
      vuint32_t COUNT21:1;             /* Octet count */
      vuint32_t COUNT20:1;             /* Octet count */
      vuint32_t COUNT19:1;             /* Octet count */
      vuint32_t COUNT18:1;             /* Octet count */
      vuint32_t COUNT17:1;             /* Octet count */
      vuint32_t COUNT16:1;             /* Octet count */
      vuint32_t COUNT15:1;             /* Octet count */
      vuint32_t COUNT14:1;             /* Octet count */
      vuint32_t COUNT13:1;             /* Octet count */
      vuint32_t COUNT12:1;             /* Octet count */
      vuint32_t COUNT11:1;             /* Octet count */
      vuint32_t COUNT10:1;             /* Octet count */
      vuint32_t COUNT9:1;              /* Octet count */
      vuint32_t COUNT8:1;              /* Octet count */
      vuint32_t COUNT7:1;              /* Octet count */
      vuint32_t COUNT6:1;              /* Octet count */
      vuint32_t COUNT5:1;              /* Octet count */
      vuint32_t COUNT4:1;              /* Octet count */
      vuint32_t COUNT3:1;              /* Octet count */
      vuint32_t COUNT2:1;              /* Octet count */
      vuint32_t COUNT1:1;              /* Octet count */
      vuint32_t COUNT0:1;              /* Octet count */
    } B;
  } RMON_R_OCTETS;

  union {                              /* Frames not Counted Correctly Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t COUNT15:1;             /* Frame count */
      vuint32_t COUNT14:1;             /* Frame count */
      vuint32_t COUNT13:1;             /* Frame count */
      vuint32_t COUNT12:1;             /* Frame count */
      vuint32_t COUNT11:1;             /* Frame count */
      vuint32_t COUNT10:1;             /* Frame count */
      vuint32_t COUNT9:1;              /* Frame count */
      vuint32_t COUNT8:1;              /* Frame count */
      vuint32_t COUNT7:1;              /* Frame count */
      vuint32_t COUNT6:1;              /* Frame count */
      vuint32_t COUNT5:1;              /* Frame count */
      vuint32_t COUNT4:1;              /* Frame count */
      vuint32_t COUNT3:1;              /* Frame count */
      vuint32_t COUNT2:1;              /* Frame count */
      vuint32_t COUNT1:1;              /* Frame count */
      vuint32_t COUNT0:1;              /* Frame count */
    } B;
  } IEEE_R_DROP;

  union {                              /* Frames Received OK Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t COUNT15:1;             /* Frame count */
      vuint32_t COUNT14:1;             /* Frame count */
      vuint32_t COUNT13:1;             /* Frame count */
      vuint32_t COUNT12:1;             /* Frame count */
      vuint32_t COUNT11:1;             /* Frame count */
      vuint32_t COUNT10:1;             /* Frame count */
      vuint32_t COUNT9:1;              /* Frame count */
      vuint32_t COUNT8:1;              /* Frame count */
      vuint32_t COUNT7:1;              /* Frame count */
      vuint32_t COUNT6:1;              /* Frame count */
      vuint32_t COUNT5:1;              /* Frame count */
      vuint32_t COUNT4:1;              /* Frame count */
      vuint32_t COUNT3:1;              /* Frame count */
      vuint32_t COUNT2:1;              /* Frame count */
      vuint32_t COUNT1:1;              /* Frame count */
      vuint32_t COUNT0:1;              /* Frame count */
    } B;
  } IEEE_R_FRAME_OK;

  union {                              /* Frames Received with CRC Error Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t COUNT15:1;             /* Frame count */
      vuint32_t COUNT14:1;             /* Frame count */
      vuint32_t COUNT13:1;             /* Frame count */
      vuint32_t COUNT12:1;             /* Frame count */
      vuint32_t COUNT11:1;             /* Frame count */
      vuint32_t COUNT10:1;             /* Frame count */
      vuint32_t COUNT9:1;              /* Frame count */
      vuint32_t COUNT8:1;              /* Frame count */
      vuint32_t COUNT7:1;              /* Frame count */
      vuint32_t COUNT6:1;              /* Frame count */
      vuint32_t COUNT5:1;              /* Frame count */
      vuint32_t COUNT4:1;              /* Frame count */
      vuint32_t COUNT3:1;              /* Frame count */
      vuint32_t COUNT2:1;              /* Frame count */
      vuint32_t COUNT1:1;              /* Frame count */
      vuint32_t COUNT0:1;              /* Frame count */
    } B;
  } IEEE_R_CRC;

  union {                              /* Frames Received with Alignment Error Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t COUNT15:1;             /* Frame count */
      vuint32_t COUNT14:1;             /* Frame count */
      vuint32_t COUNT13:1;             /* Frame count */
      vuint32_t COUNT12:1;             /* Frame count */
      vuint32_t COUNT11:1;             /* Frame count */
      vuint32_t COUNT10:1;             /* Frame count */
      vuint32_t COUNT9:1;              /* Frame count */
      vuint32_t COUNT8:1;              /* Frame count */
      vuint32_t COUNT7:1;              /* Frame count */
      vuint32_t COUNT6:1;              /* Frame count */
      vuint32_t COUNT5:1;              /* Frame count */
      vuint32_t COUNT4:1;              /* Frame count */
      vuint32_t COUNT3:1;              /* Frame count */
      vuint32_t COUNT2:1;              /* Frame count */
      vuint32_t COUNT1:1;              /* Frame count */
      vuint32_t COUNT0:1;              /* Frame count */
    } B;
  } IEEE_R_ALIGN;

  union {                              /* Receive FIFO Overflow Count Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t COUNT15:1;             /* Count */
      vuint32_t COUNT14:1;             /* Count */
      vuint32_t COUNT13:1;             /* Count */
      vuint32_t COUNT12:1;             /* Count */
      vuint32_t COUNT11:1;             /* Count */
      vuint32_t COUNT10:1;             /* Count */
      vuint32_t COUNT9:1;              /* Count */
      vuint32_t COUNT8:1;              /* Count */
      vuint32_t COUNT7:1;              /* Count */
      vuint32_t COUNT6:1;              /* Count */
      vuint32_t COUNT5:1;              /* Count */
      vuint32_t COUNT4:1;              /* Count */
      vuint32_t COUNT3:1;              /* Count */
      vuint32_t COUNT2:1;              /* Count */
      vuint32_t COUNT1:1;              /* Count */
      vuint32_t COUNT0:1;              /* Count */
    } B;
  } IEEE_R_MACERR;

  union {                              /* Flow Control Pause Frames Received Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t COUNT15:1;             /* Pause frame count */
      vuint32_t COUNT14:1;             /* Pause frame count */
      vuint32_t COUNT13:1;             /* Pause frame count */
      vuint32_t COUNT12:1;             /* Pause frame count */
      vuint32_t COUNT11:1;             /* Pause frame count */
      vuint32_t COUNT10:1;             /* Pause frame count */
      vuint32_t COUNT9:1;              /* Pause frame count */
      vuint32_t COUNT8:1;              /* Pause frame count */
      vuint32_t COUNT7:1;              /* Pause frame count */
      vuint32_t COUNT6:1;              /* Pause frame count */
      vuint32_t COUNT5:1;              /* Pause frame count */
      vuint32_t COUNT4:1;              /* Pause frame count */
      vuint32_t COUNT3:1;              /* Pause frame count */
      vuint32_t COUNT2:1;              /* Pause frame count */
      vuint32_t COUNT1:1;              /* Pause frame count */
      vuint32_t COUNT0:1;              /* Pause frame count */
    } B;
  } IEEE_R_FDXFC;

  union {                              /* Octet Count for Frames Received without Error Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t COUNT31:1;             /* Octet count */
      vuint32_t COUNT30:1;             /* Octet count */
      vuint32_t COUNT29:1;             /* Octet count */
      vuint32_t COUNT28:1;             /* Octet count */
      vuint32_t COUNT27:1;             /* Octet count */
      vuint32_t COUNT26:1;             /* Octet count */
      vuint32_t COUNT25:1;             /* Octet count */
      vuint32_t COUNT24:1;             /* Octet count */
      vuint32_t COUNT23:1;             /* Octet count */
      vuint32_t COUNT22:1;             /* Octet count */
      vuint32_t COUNT21:1;             /* Octet count */
      vuint32_t COUNT20:1;             /* Octet count */
      vuint32_t COUNT19:1;             /* Octet count */
      vuint32_t COUNT18:1;             /* Octet count */
      vuint32_t COUNT17:1;             /* Octet count */
      vuint32_t COUNT16:1;             /* Octet count */
      vuint32_t COUNT15:1;             /* Octet count */
      vuint32_t COUNT14:1;             /* Octet count */
      vuint32_t COUNT13:1;             /* Octet count */
      vuint32_t COUNT12:1;             /* Octet count */
      vuint32_t COUNT11:1;             /* Octet count */
      vuint32_t COUNT10:1;             /* Octet count */
      vuint32_t COUNT9:1;              /* Octet count */
      vuint32_t COUNT8:1;              /* Octet count */
      vuint32_t COUNT7:1;              /* Octet count */
      vuint32_t COUNT6:1;              /* Octet count */
      vuint32_t COUNT5:1;              /* Octet count */
      vuint32_t COUNT4:1;              /* Octet count */
      vuint32_t COUNT3:1;              /* Octet count */
      vuint32_t COUNT2:1;              /* Octet count */
      vuint32_t COUNT1:1;              /* Octet count */
      vuint32_t COUNT0:1;              /* Octet count */
    } B;
  } IEEE_R_OCTETS_OK;

  uint8_t ENET_reserved21[284];
  union {                              /* Adjustable Timer Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :18;
      vuint32_t SLAVE:1;               /* Enable Timer Slave Mode */
      vuint32_t  :1;
      vuint32_t CAPTURE:1;             /* Capture Timer Value */
      vuint32_t  :1;
      vuint32_t RESTART:1;             /* Reset Timer */
      vuint32_t  :1;
      vuint32_t PINPER:1;
      vuint32_t  :2;
      vuint32_t PEREN:1;               /* Enable Periodical Event */
      vuint32_t OFFRST:1;              /* Reset Timer On Offset Event */
      vuint32_t OFFEN:1;               /* Enable One-Shot Offset Event */
      vuint32_t  :1;
      vuint32_t EN:1;                  /* Enable Timer */
    } B;
  } ATCR;

  union {                              /* Timer Value Register */
    vuint32_t R;
    struct {
      vuint32_t ATIME:32;
    } B;
  } ATVR;

  union {                              /* Timer Offset Register */
    vuint32_t R;
    struct {
      vuint32_t OFFSET:32;
    } B;
  } ATOFF;

  union {                              /* Timer Period Register */
    vuint32_t R;
    struct {
      vuint32_t PERIOD:32;
    } B;
  } ATPER;

  union {                              /* Timer Correction Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t COR:31;                /* Correction Counter Wrap-Around Value */
    } B;
  } ATCOR;

  union {                              /* Time-Stamping Clock Period Register */
    vuint32_t R;
    struct {
      vuint32_t  :17;
      vuint32_t INC_CORR:7;            /* Correction Increment Value */
      vuint32_t  :1;
      vuint32_t INC:7;                 /* Clock Period Of The Timestamping Clock (ts_clk) In Nanoseconds */
    } B;
  } ATINC;

  union {                              /* Timestamp of Last Transmitted Frame */
    vuint32_t R;
    struct {
      vuint32_t TIMESTAMP:32;
    } B;
  } ATSTMP;

  uint8_t ENET_reserved22[356];
  union {                              /* Pattern Match Data Register */
    vuint32_t R;
    struct {
      vuint32_t MATCHDATA:32;          /* Match Data */
    } B;
  } MDATA;

  union {                              /* Match Entry Mask Register */
    vuint32_t R;
    struct {
      vuint32_t MATCHMASK:32;          /* Match Mask */
    } B;
  } MMASK;

  union {                              /* Match Entry Rules Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t AF:1;                  /* Accept Frame */
      vuint32_t RF:1;                  /* Reject Frame */
      vuint32_t IM:1;                  /* Invert Match */
      vuint32_t  :5;
      vuint32_t OK_INDEX:8;
      vuint32_t  :8;
      vuint32_t FRMOFF:6;              /* Frame Offset */
      vuint32_t  :2;
    } B;
  } MCONFIG;

  union {                              /* Match Entry Read/Write Command Register */
    vuint32_t R;
    struct {
      vuint32_t  :22;
      vuint32_t RD:1;                  /* Entry Read Command */
      vuint32_t WR:1;                  /* Entry write command */
      vuint32_t ENTRYADD:8;            /* Entry Address */
    } B;
  } MENTRYRW;

  union {                              /* Receive Parser Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t ACPTEERR:1;            /* Accept End Error */
      vuint32_t ENDERRQ:8;             /* End Error Queue */
      vuint32_t MAXINDEX:8;            /* Maximum Index */
      vuint32_t  :3;
      vuint32_t PRSRSCLR:1;            /* Clear Parser Statistics Counter */
      vuint32_t  :2;
      vuint32_t INVBYTORD:1;           /* Inverse Frame Byte Order */
      vuint32_t ENPARSER:1;            /* Enable Receive Parser */
    } B;
  } RXPCTL;

  union {                              /* Maximum Frame Offset */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t MXFRMOFF:6;            /* Max. Frame Offset */
    } B;
  } MAXFRMOFF;

  union {                              /* Receive Parser Status */
    vuint32_t R;
    struct {
      vuint32_t  :23;
      vuint32_t RXPRSDN:1;             /* Receive Parser Done */
      vuint32_t  :2;
      vuint32_t INVMAXIDX:1;           /* Invalid Value of MAXINDEX */
      vuint32_t PRSENDERR:1;           /* Parser End Error */
      vuint32_t FMOFFERR:1;            /* Maximum Frame Offset Error */
      vuint32_t NOMTCERR:1;            /* No Match Error */
      vuint32_t TBLDPTERR:1;           /* Table Depth Error */
      vuint32_t MXINDERR:1;            /* Maximum Index Error */
    } B;
  } RXPARST;

  uint8_t ENET_reserved23[4];
  union {                              /* Parser Discard Count */
    vuint32_t R;
    struct {
      vuint32_t COUNT:32;              /* Count */
    } B;
  } PARSDSCD;

  union {                              /* Parser Accept Count 0 */
    vuint32_t R;
    struct {
      vuint32_t COUNT:32;              /* Count */
    } B;
  } PRSACPT0;

  union {                              /* Parser Reject Count 0 */
    vuint32_t R;
    struct {
      vuint32_t COUNT:32;              /* Count */
    } B;
  } PRSRJCT0;

  union {                              /* Parser Accept Count 1 */
    vuint32_t R;
    struct {
      vuint32_t COUNT:32;              /* Count */
    } B;
  } PRSACPT1;

  union {                              /* Parser Reject Count 1 */
    vuint32_t R;
    struct {
      vuint32_t COUNT:32;              /* Count */
    } B;
  } PRSRJCT1;

  union {                              /* Parser Accept Count 2 */
    vuint32_t R;
    struct {
      vuint32_t COUNT:32;              /* Count */
    } B;
  } PRSACPT2;

  union {                              /* Parser Reject Count 2 */
    vuint32_t R;
    struct {
      vuint32_t COUNT:32;              /* Count */
    } B;
  } PRSRJCT2;

  uint8_t ENET_reserved24[72];
  union {                              /* Timer Global Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :28;
      vuint32_t TF3:1;                 /* Copy Of Timer Flag For Channel 3 */
      vuint32_t TF2:1;                 /* Copy Of Timer Flag For Channel 2 */
      vuint32_t TF1:1;                 /* Copy Of Timer Flag For Channel 1 */
      vuint32_t TF0:1;                 /* Copy Of Timer Flag For Channel 0 */
    } B;
  } TGSR;

  struct {
    union {                            /* Timer Control Status Register */
      vuint32_t R;
      struct {
        vuint32_t  :24;
        vuint32_t TF:1;                /* Timer Flag */
        vuint32_t TIE:1;               /* Timer Interrupt Enable */
        vuint32_t TMODE:4;             /* Timer Mode */
        vuint32_t  :1;
        vuint32_t TDRE:1;              /* Timer DMA Request Enable */
      } B;
    } TCSR;
    union {                            /* Timer Compare Capture Register */
      vuint32_t R;
      struct {
        vuint32_t TCC:32;              /* Timer Capture Compare */
      } B;
    } TCCR;
  } TIMER[4];
};


/* ============================================================================
   =============================== Module: FCCU ===============================
   ============================================================================ */

struct FCCU_tag {
  union {                              /* Control Register */
    vuint32_t R;
    struct {
      vuint32_t FILTER_BYPASS:1;
      vuint32_t FILTER_WIDTH:2;
      vuint32_t  :19;
      vuint32_t DEBUG:1;
      vuint32_t  :1;
      vuint32_t OPS:2;
      vuint32_t  :1;
      vuint32_t OPR:5;
    } B;
  } CTRL;

  union {                              /* CTRL Key Register */
    vuint32_t R;
    struct {
      vuint32_t CTRLK:32;
    } B;
  } CTRLK;

  union {                              /* Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t TGL:7;                 /* EOUT Toggling Time */
      vuint32_t FCCU_SET_AFTER_RESET:1;
      vuint32_t FCCU_SET_CLEAR:2;
      vuint32_t  :2;
      vuint32_t  :4;
      vuint32_t  :1;
      vuint32_t FOME:2;                /* Fault Output Mode Extension */
      vuint32_t OD:1;
      vuint32_t CM:1;
      vuint32_t SM:1;
      vuint32_t PS:1;
      vuint32_t FOM:3;
      vuint32_t  :6;
    } B;
  } CFG;

  uint8_t FCCU_reserved0[16];
  union {                              /* NCF Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t NCFC31:1;
      vuint32_t NCFC30:1;
      vuint32_t NCFC29:1;
      vuint32_t NCFC28:1;
      vuint32_t NCFC27:1;
      vuint32_t NCFC26:1;
      vuint32_t NCFC25:1;
      vuint32_t NCFC24:1;
      vuint32_t NCFC23:1;
      vuint32_t NCFC22:1;
      vuint32_t NCFC21:1;
      vuint32_t NCFC20:1;
      vuint32_t NCFC19:1;
      vuint32_t NCFC18:1;
      vuint32_t NCFC17:1;
      vuint32_t NCFC16:1;
      vuint32_t NCFC15:1;
      vuint32_t NCFC14:1;
      vuint32_t NCFC13:1;
      vuint32_t NCFC12:1;
      vuint32_t NCFC11:1;
      vuint32_t NCFC10:1;
      vuint32_t NCFC9:1;
      vuint32_t NCFC8:1;
      vuint32_t NCFC7:1;
      vuint32_t NCFC6:1;
      vuint32_t NCFC5:1;
      vuint32_t NCFC4:1;
      vuint32_t NCFC3:1;
      vuint32_t NCFC2:1;
      vuint32_t NCFC1:1;
      vuint32_t NCFC0:1;
    } B;
  } NCF_CFG[3];

  uint8_t FCCU_reserved1[36];
  union {                              /* NCFS Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t NCFSC31:1;
      vuint32_t NCFSC30:1;
      vuint32_t NCFSC29:1;
      vuint32_t NCFSC28:1;
      vuint32_t NCFSC27:1;
      vuint32_t NCFSC26:1;
      vuint32_t NCFSC25:1;
      vuint32_t NCFSC24:1;
      vuint32_t NCFSC23:1;
      vuint32_t NCFSC22:1;
      vuint32_t NCFSC21:1;
      vuint32_t NCFSC20:1;
      vuint32_t NCFSC19:1;
      vuint32_t NCFSC18:1;
      vuint32_t NCFSC17:1;
      vuint32_t NCFSC16:1;
      vuint32_t NCFSC15:1;
      vuint32_t NCFSC14:1;
      vuint32_t NCFSC13:1;
      vuint32_t NCFSC12:1;
      vuint32_t NCFSC11:1;
      vuint32_t NCFSC10:1;
      vuint32_t NCFSC9:1;
      vuint32_t NCFSC8:1;
      vuint32_t NCFSC7:1;
      vuint32_t NCFSC6:1;
      vuint32_t NCFSC5:1;
      vuint32_t NCFSC4:1;
      vuint32_t NCFSC3:1;
      vuint32_t NCFSC2:1;
      vuint32_t NCFSC1:1;
      vuint32_t NCFSC0:1;
    } B;
  } NCFS_CFG[5];

  uint8_t FCCU_reserved2[32];
  union {                              /* NCF Status Register */
    vuint32_t R;
    struct {
      vuint32_t NCFS31:1;
      vuint32_t NCFS30:1;
      vuint32_t NCFS29:1;
      vuint32_t NCFS28:1;
      vuint32_t NCFS27:1;
      vuint32_t NCFS26:1;
      vuint32_t NCFS25:1;
      vuint32_t NCFS24:1;
      vuint32_t NCFS23:1;
      vuint32_t NCFS22:1;
      vuint32_t NCFS21:1;
      vuint32_t NCFS20:1;
      vuint32_t NCFS19:1;
      vuint32_t NCFS18:1;
      vuint32_t NCFS17:1;
      vuint32_t NCFS16:1;
      vuint32_t NCFS15:1;
      vuint32_t NCFS14:1;
      vuint32_t NCFS13:1;
      vuint32_t NCFS12:1;
      vuint32_t NCFS11:1;
      vuint32_t NCFS10:1;
      vuint32_t NCFS9:1;
      vuint32_t NCFS8:1;
      vuint32_t NCFS7:1;
      vuint32_t NCFS6:1;
      vuint32_t NCFS5:1;
      vuint32_t NCFS4:1;
      vuint32_t NCFS3:1;
      vuint32_t NCFS2:1;
      vuint32_t NCFS1:1;
      vuint32_t NCFS0:1;
    } B;
  } NCF_S[3];

  uint8_t FCCU_reserved3[4];
  union {                              /* NCF Key Register */
    vuint32_t R;
    struct {
      vuint32_t NCFK:32;
    } B;
  } NCFK;

  union {                              /* NCF Enable Register */
    vuint32_t R;
    struct {
      vuint32_t NCFE31:1;
      vuint32_t NCFE30:1;
      vuint32_t NCFE29:1;
      vuint32_t NCFE28:1;
      vuint32_t NCFE27:1;
      vuint32_t NCFE26:1;
      vuint32_t NCFE25:1;
      vuint32_t NCFE24:1;
      vuint32_t NCFE23:1;
      vuint32_t NCFE22:1;
      vuint32_t NCFE21:1;
      vuint32_t NCFE20:1;
      vuint32_t NCFE19:1;
      vuint32_t NCFE18:1;
      vuint32_t NCFE17:1;
      vuint32_t NCFE16:1;
      vuint32_t NCFE15:1;
      vuint32_t NCFE14:1;
      vuint32_t NCFE13:1;
      vuint32_t NCFE12:1;
      vuint32_t NCFE11:1;
      vuint32_t NCFE10:1;
      vuint32_t NCFE9:1;
      vuint32_t NCFE8:1;
      vuint32_t NCFE7:1;
      vuint32_t NCFE6:1;
      vuint32_t NCFE5:1;
      vuint32_t NCFE4:1;
      vuint32_t NCFE3:1;
      vuint32_t NCFE2:1;
      vuint32_t NCFE1:1;
      vuint32_t NCFE0:1;
    } B;
  } NCF_E[3];

  uint8_t FCCU_reserved4[4];
  union {                              /* NCF Time-out Enable Register */
    vuint32_t R;
    struct {
      vuint32_t NCFTOE31:1;
      vuint32_t NCFTOE30:1;
      vuint32_t NCFTOE29:1;
      vuint32_t NCFTOE28:1;
      vuint32_t NCFTOE27:1;
      vuint32_t NCFTOE26:1;
      vuint32_t NCFTOE25:1;
      vuint32_t NCFTOE24:1;
      vuint32_t NCFTOE23:1;
      vuint32_t NCFTOE22:1;
      vuint32_t NCFTOE21:1;
      vuint32_t NCFTOE20:1;
      vuint32_t NCFTOE19:1;
      vuint32_t NCFTOE18:1;
      vuint32_t NCFTOE17:1;
      vuint32_t NCFTOE16:1;
      vuint32_t NCFTOE15:1;
      vuint32_t NCFTOE14:1;
      vuint32_t NCFTOE13:1;
      vuint32_t NCFTOE12:1;
      vuint32_t NCFTOE11:1;
      vuint32_t NCFTOE10:1;
      vuint32_t NCFTOE9:1;
      vuint32_t NCFTOE8:1;
      vuint32_t NCFTOE7:1;
      vuint32_t NCFTOE6:1;
      vuint32_t NCFTOE5:1;
      vuint32_t NCFTOE4:1;
      vuint32_t NCFTOE3:1;
      vuint32_t NCFTOE2:1;
      vuint32_t NCFTOE1:1;
      vuint32_t NCFTOE0:1;
    } B;
  } NCF_TOE[3];

  uint8_t FCCU_reserved5[4];
  union {                              /* NCF Time-out Register */
    vuint32_t R;
    struct {
      vuint32_t TO:32;
    } B;
  } NCF_TO;

  union {                              /* CFG Timeout Register */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t TO:3;
    } B;
  } CFG_TO;

  union {                              /* IO Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t EIN1:1;
      vuint32_t EIN0:1;
      vuint32_t  :2;
      vuint32_t EOUTX:2;
    } B;
  } EINOUT;

  union {                              /* Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t PhysicErrorPin:2;
      vuint32_t ESTAT:1;
      vuint32_t STATUS:3;
    } B;
  } STAT;

  union {                              /* NA Freeze Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t NAFS:8;
    } B;
  } N2AF_STATUS;

  union {                              /* AF Freeze Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :22;
      vuint32_t AF_SRC:2;
      vuint32_t AFFS:8;
    } B;
  } A2FF_STATUS;

  union {                              /* NF Freeze Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :22;
      vuint32_t NF_SRC:2;
      vuint32_t NFFS:8;
    } B;
  } N2FF_STATUS;

  union {                              /* FA Freeze Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :23;
      vuint32_t FAFS:9;
    } B;
  } F2A_STATUS;

  uint8_t FCCU_reserved6[8];
  union {                              /* NCF Fake Register */
    vuint32_t R;
    struct {
      vuint32_t  :25;
      vuint32_t FNCFC:7;
    } B;
  } NCFF;

  union {                              /* IRQ Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :27;
      vuint32_t DMA_REQ:1;
      vuint32_t IRQ_EOUT:1;
      vuint32_t NMI_STAT:1;
      vuint32_t ALRM_STAT:1;
      vuint32_t CFG_TO_STAT:1;
    } B;
  } IRQ_STAT;

  union {                              /* IRQ Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :28;
      vuint32_t IRQ_EOUT_EN:1;
      vuint32_t  :2;
      vuint32_t CFG_TO_IEN:1;
    } B;
  } IRQ_EN;

  union {                              /* XTMR Register */
    vuint32_t R;
    struct {
      vuint32_t XTMR:32;
    } B;
  } XTMR;

  union {                              /* MCS Register */
    vuint32_t R;
    struct {
      vuint32_t VL3:1;
      vuint32_t FS3:1;
      vuint32_t  :2;
      vuint32_t MCS3:4;
      vuint32_t VL2:1;
      vuint32_t FS2:1;
      vuint32_t  :2;
      vuint32_t MCS2:4;
      vuint32_t VL1:1;
      vuint32_t FS1:1;
      vuint32_t  :2;
      vuint32_t MCS1:4;
      vuint32_t VL0:1;
      vuint32_t FS0:1;
      vuint32_t  :2;
      vuint32_t MCS0:4;
    } B;
  } MCS;

  union {                              /* Transient Lock Register */
    vuint32_t R;
    struct {
      vuint32_t  :23;
      vuint32_t TRANSKEY:9;
    } B;
  } TRANS_LOCK;

  union {                              /* Permanent Lock Register */
    vuint32_t R;
    struct {
      vuint32_t  :23;
      vuint32_t PERMNTKEY:9;
    } B;
  } PERMNT_LOCK;

  union {                              /* Delta T Register */
    vuint32_t R;
    struct {
      vuint32_t  :2;
      vuint32_t T_TRG:14;              /* IRQ DMA trigger time */
      vuint32_t  :2;
      vuint32_t DELTA_T:14;
    } B;
  } DELTA_T;

  union {                              /* IRQ Alarm Enable Register */
    vuint32_t R;
    struct {
      vuint32_t IRQEN31:1;
      vuint32_t IRQEN30:1;
      vuint32_t IRQEN29:1;
      vuint32_t IRQEN28:1;
      vuint32_t IRQEN27:1;
      vuint32_t IRQEN26:1;
      vuint32_t IRQEN25:1;
      vuint32_t IRQEN24:1;
      vuint32_t IRQEN23:1;
      vuint32_t IRQEN22:1;
      vuint32_t IRQEN21:1;
      vuint32_t IRQEN20:1;
      vuint32_t IRQEN19:1;
      vuint32_t IRQEN18:1;
      vuint32_t IRQEN17:1;
      vuint32_t IRQEN16:1;
      vuint32_t IRQEN15:1;
      vuint32_t IRQEN14:1;
      vuint32_t IRQEN13:1;
      vuint32_t IRQEN12:1;
      vuint32_t IRQEN11:1;
      vuint32_t IRQEN10:1;
      vuint32_t IRQEN9:1;
      vuint32_t IRQEN8:1;
      vuint32_t IRQEN7:1;
      vuint32_t IRQEN6:1;
      vuint32_t IRQEN5:1;
      vuint32_t IRQEN4:1;
      vuint32_t IRQEN3:1;
      vuint32_t IRQEN2:1;
      vuint32_t IRQEN1:1;
      vuint32_t IRQEN0:1;
    } B;
  } IRQ_ALARM_EN[3];

  uint8_t FCCU_reserved7[4];
  union {                              /* NMI Enable Register */
    vuint32_t R;
    struct {
      vuint32_t NMIEN31:1;
      vuint32_t NMIEN30:1;
      vuint32_t NMIEN29:1;
      vuint32_t NMIEN28:1;
      vuint32_t NMIEN27:1;
      vuint32_t NMIEN26:1;
      vuint32_t NMIEN25:1;
      vuint32_t NMIEN24:1;
      vuint32_t NMIEN23:1;
      vuint32_t NMIEN22:1;
      vuint32_t NMIEN21:1;
      vuint32_t NMIEN20:1;
      vuint32_t NMIEN19:1;
      vuint32_t NMIEN18:1;
      vuint32_t NMIEN17:1;
      vuint32_t NMIEN16:1;
      vuint32_t NMIEN15:1;
      vuint32_t NMIEN14:1;
      vuint32_t NMIEN13:1;
      vuint32_t NMIEN12:1;
      vuint32_t NMIEN11:1;
      vuint32_t NMIEN10:1;
      vuint32_t NMIEN9:1;
      vuint32_t NMIEN8:1;
      vuint32_t NMIEN7:1;
      vuint32_t NMIEN6:1;
      vuint32_t NMIEN5:1;
      vuint32_t NMIEN4:1;
      vuint32_t NMIEN3:1;
      vuint32_t NMIEN2:1;
      vuint32_t NMIEN1:1;
      vuint32_t NMIEN0:1;
    } B;
  } NMI_EN[3];

  uint8_t FCCU_reserved8[4];
  union {                              /* EOUT Signaling Enable Register */
    vuint32_t R;
    struct {
      vuint32_t EOUTEN31:1;
      vuint32_t EOUTEN30:1;
      vuint32_t EOUTEN29:1;
      vuint32_t EOUTEN28:1;
      vuint32_t EOUTEN27:1;
      vuint32_t EOUTEN26:1;
      vuint32_t EOUTEN25:1;
      vuint32_t EOUTEN24:1;
      vuint32_t EOUTEN23:1;
      vuint32_t EOUTEN22:1;
      vuint32_t EOUTEN21:1;
      vuint32_t EOUTEN20:1;
      vuint32_t EOUTEN19:1;
      vuint32_t EOUTEN18:1;
      vuint32_t EOUTEN17:1;
      vuint32_t EOUTEN16:1;
      vuint32_t EOUTEN15:1;
      vuint32_t EOUTEN14:1;
      vuint32_t EOUTEN13:1;
      vuint32_t EOUTEN12:1;
      vuint32_t EOUTEN11:1;
      vuint32_t EOUTEN10:1;
      vuint32_t EOUTEN9:1;
      vuint32_t EOUTEN8:1;
      vuint32_t EOUTEN7:1;
      vuint32_t EOUTEN6:1;
      vuint32_t EOUTEN5:1;
      vuint32_t EOUTEN4:1;
      vuint32_t EOUTEN3:1;
      vuint32_t EOUTEN2:1;
      vuint32_t EOUTEN1:1;
      vuint32_t EOUTEN0:1;
    } B;
  } EOUT_SIG_EN[3];
};


/* ============================================================================
   =============================== Module: FIRC ===============================
   ============================================================================ */

struct FIRC_tag {
  union {                              /* Control register */
    vuint32_t R;
    struct {
      vuint32_t  :10;
      vuint32_t  :6;
      vuint32_t  :3;
      vuint32_t FIRCDIV:5;             /* The FIRC Divider bits select the clock divider factor. */
      vuint32_t  :3;
      vuint32_t FIRCS:1;               /* Describes the FIRC clock status. */
      vuint32_t  :3;
      vuint32_t  :1;
    } B;
  } CTL;
};


/* ============================================================================
   =============================== Module: FR =================================
   ============================================================================ */

struct FR_tag {
  union {                              /* Module Version Register */
    vuint16_t R;
    struct {
      vuint16_t CHIVER:8;
      vuint16_t PEVER:8;
    } B;
  } MVR;

  union {                              /* Module Configuration Register */
    vuint16_t R;
    struct {
      vuint16_t MEN:1;
      vuint16_t SBFF:1;                /* System Bus Failure Freeze */
      vuint16_t SCM:1;
      vuint16_t CHB:1;
      vuint16_t CHA:1;
      vuint16_t SFFE:1;
      vuint16_t ECCE:1;
      vuint16_t  :1;                   /* Reserved bit, will not be changed. Application must not write any value different from the reset value. */
      vuint16_t FUM:1;
      vuint16_t FAM:1;
      vuint16_t  :1;
      vuint16_t CLKSEL:1;
      vuint16_t BITRATE:3;
      vuint16_t  :1;
    } B;
  } MCR;

  union {                              /* System Memory Base Address High Register */
    vuint16_t R;
    struct {
      vuint16_t SMBA:16;               /* System Memory Base Address high. This is the value of the system memory base address for the individual message buffers and sync frame table. This is the value of the system memory base address for the receive FIFO if the FIFO address mode bit FR_MCR[FAM] is set to 1. It is defines as a byte address. */
    } B;
  } SYMBADHR;

  union {                              /* System Memory Base Address Low Register */
    vuint16_t R;
    struct {
      vuint16_t SMBA:12;
      vuint16_t  :4;
    } B;
  } SYMBADLR;

  union {                              /* Strobe Signal Control Register */
    vuint16_t R;
    struct {
      vuint16_t WMD:1;
      vuint16_t  :3;
      vuint16_t SEL:4;
      vuint16_t  :3;
      vuint16_t ENB:1;
      vuint16_t  :2;
      vuint16_t STBPSEL:2;
    } B;
  } STBSCR;

  uint8_t FR_reserved0[2];
  union {                              /* Message Buffer Data Size Register */
    vuint16_t R;
    struct {
      vuint16_t  :1;
      vuint16_t MBSEG2DS:7;
      vuint16_t  :1;
      vuint16_t MBSEG1DS:7;
    } B;
  } MBDSR;

  union {                              /* Message Buffer Segment Size and Utilization Register */
    vuint16_t R;
    struct {
      vuint16_t  :1;
      vuint16_t LAST_MB_SEG1:7;
      vuint16_t  :1;
      vuint16_t LAST_MB_UTIL:7;
    } B;
  } MBSSUTR;

  union {                              /* PE DRAM Access Register */
    vuint16_t R;
    struct {
      vuint16_t INST:4;
      vuint16_t ADDR:11;
      vuint16_t DAD:1;
    } B;
  } PEDRAR;

  union {                              /* PE DRAM Data Register */
    vuint16_t R;
    struct {
      vuint16_t DATA:16;
    } B;
  } PEDRDR;

  union {                              /* Protocol Operation Control Register */
    vuint16_t R;
    struct {
      vuint16_t WME:1;
      vuint16_t  :3;
      vuint16_t EOC_AP:2;
      vuint16_t ERC_AP:2;
      vuint16_t BSY_WMC:1;
      vuint16_t  :3;
      vuint16_t POCCMD:4;
    } B;
  } POCR;

  union {                              /* Global Interrupt Flag and Enable Register */
    vuint16_t R;
    struct {
      vuint16_t MIF:1;
      vuint16_t PRIF:1;
      vuint16_t CHIF:1;
      vuint16_t WUPIF:1;
      vuint16_t FAFBIF:1;
      vuint16_t FAFAIF:1;
      vuint16_t RBIF:1;
      vuint16_t TBIF:1;
      vuint16_t MIE:1;
      vuint16_t PRIE:1;
      vuint16_t CHIE:1;
      vuint16_t WUPIE:1;
      vuint16_t FAFBIE:1;
      vuint16_t FAFAIE:1;
      vuint16_t RBIE:1;
      vuint16_t TBIE:1;
    } B;
  } GIFER;

  union {                              /* Protocol Interrupt Flag Register 0 */
    vuint16_t R;
    struct {
      vuint16_t FATL_IF:1;
      vuint16_t INTL_IF:1;
      vuint16_t ILCF_IF:1;
      vuint16_t CSA_IF:1;
      vuint16_t MRC_IF:1;
      vuint16_t MOC_IF:1;
      vuint16_t CCL_IF:1;
      vuint16_t MXS_IF:1;
      vuint16_t MTX_IF:1;
      vuint16_t LTXB_IF:1;
      vuint16_t LTXA_IF:1;
      vuint16_t TBVB_IF:1;
      vuint16_t TBVA_IF:1;
      vuint16_t TI2_IF:1;
      vuint16_t TI1_IF:1;
      vuint16_t CYS_IF:1;
    } B;
  } PIFR0;

  union {                              /* Protocol Interrupt Flag Register 1 */
    vuint16_t R;
    struct {
      vuint16_t EMC_IF:1;
      vuint16_t IPC_IF:1;
      vuint16_t PECF_IF:1;
      vuint16_t PSC_IF:1;
      vuint16_t SSI3_IF:1;
      vuint16_t SSI2_IF:1;
      vuint16_t SSI1_IF:1;
      vuint16_t SSI0_IF:1;
      vuint16_t  :2;
      vuint16_t EVT_IF:1;
      vuint16_t ODT_IF:1;
      vuint16_t  :4;
    } B;
  } PIFR1;

  union {                              /* Protocol Interrupt Enable Register 0 */
    vuint16_t R;
    struct {
      vuint16_t FATL_IE:1;
      vuint16_t INTL_IE:1;
      vuint16_t ILCF_IE:1;
      vuint16_t CSA_IE:1;
      vuint16_t MRC_IE:1;
      vuint16_t MOC_IE:1;
      vuint16_t CCL_IE:1;
      vuint16_t MXS_IE:1;
      vuint16_t MTX_IE:1;
      vuint16_t LTXB_IE:1;
      vuint16_t LTXA_IE:1;
      vuint16_t TBVB_IE:1;
      vuint16_t TBVA_IE:1;
      vuint16_t TI2_IE:1;
      vuint16_t TI1_IE:1;
      vuint16_t CYS_IE:1;
    } B;
  } PIER0;

  union {                              /* Protocol Interrupt Enable Register 1 */
    vuint16_t R;
    struct {
      vuint16_t EMC_IE:1;
      vuint16_t IPC_IE:1;
      vuint16_t PECF_IE:1;
      vuint16_t PSC_IE:1;
      vuint16_t SSI3_IE:1;
      vuint16_t SSI2_IE:1;
      vuint16_t SSI1_IE:1;
      vuint16_t SSI0_IE:1;
      vuint16_t  :2;
      vuint16_t EVT_IE:1;
      vuint16_t ODT_IE:1;
      vuint16_t  :4;
    } B;
  } PIER1;

  union {                              /* CHI Error Flag Register */
    vuint16_t R;
    struct {
      vuint16_t FRLB_EF:1;
      vuint16_t FRLA_EF:1;
      vuint16_t PCMI_EF:1;
      vuint16_t FOVB_EF:1;
      vuint16_t FOVA_EF:1;
      vuint16_t MBS_EF:1;
      vuint16_t MBU_EF:1;
      vuint16_t LCK_EF:1;
      vuint16_t  :1;
      vuint16_t SBCF_EF:1;
      vuint16_t FID_EF:1;
      vuint16_t DPL_EF:1;
      vuint16_t SPL_EF:1;
      vuint16_t NML_EF:1;
      vuint16_t NMF_EF:1;
      vuint16_t ILSA_EF:1;
    } B;
  } CHIERFR;

  union {                              /* Message Buffer Interrupt Vector Register */
    vuint16_t R;
    struct {
      vuint16_t  :1;
      vuint16_t TBIVEC:7;
      vuint16_t  :1;
      vuint16_t RBIVEC:7;
    } B;
  } MBIVEC;

  union {                              /* Channel A Status Error Counter Register */
    vuint16_t R;
    struct {
      vuint16_t CHAERSCNT:16;
    } B;
  } CASERCR;

  union {                              /* Channel B Status Error Counter Register */
    vuint16_t R;
    struct {
      vuint16_t CHBERSCNT:16;
    } B;
  } CBSERCR;

  union {                              /* Protocol Status Register 0 */
    vuint16_t R;
    struct {
      vuint16_t ERRMODE:2;
      vuint16_t SLOTMODE:2;
      vuint16_t  :1;
      vuint16_t PROTSTATE:3;
      vuint16_t STARTUPSTATE:4;
      vuint16_t  :1;
      vuint16_t WAKEUPSTATUS:3;
    } B;
  } PSR0;

  union {                              /* Protocol Status Register 1 */
    vuint16_t R;
    struct {
      vuint16_t CSAA:1;
      vuint16_t CSP:1;
      vuint16_t  :1;
      vuint16_t REMCSAT:5;
      vuint16_t CPN:1;
      vuint16_t HHR:1;
      vuint16_t FRZ:1;
      vuint16_t APTAC:5;
    } B;
  } PSR1;

  union {                              /* Protocol Status Register 2 */
    vuint16_t R;
    struct {
      vuint16_t NBVB:1;
      vuint16_t NSEB:1;
      vuint16_t STCB:1;
      vuint16_t SBVB:1;
      vuint16_t SSEB:1;
      vuint16_t MTB:1;
      vuint16_t NBVA:1;
      vuint16_t NSEA:1;
      vuint16_t STCA:1;
      vuint16_t SBVA:1;
      vuint16_t SSEA:1;
      vuint16_t MTA:1;
      vuint16_t CKCORFCNT:4;
    } B;
  } PSR2;

  union {                              /* Protocol Status Register 3 */
    vuint16_t R;
    struct {
      vuint16_t  :2;
      vuint16_t WUB:1;
      vuint16_t ABVB:1;
      vuint16_t AACB:1;
      vuint16_t ACEB:1;
      vuint16_t ASEB:1;
      vuint16_t AVFB:1;
      vuint16_t  :2;
      vuint16_t WUA:1;
      vuint16_t ABVA:1;
      vuint16_t AACA:1;
      vuint16_t ACEA:1;
      vuint16_t ASEA:1;
      vuint16_t AVFA:1;
    } B;
  } PSR3;

  union {                              /* Macrotick Counter Register */
    vuint16_t R;
    struct {
      vuint16_t  :2;
      vuint16_t MTCT:14;
    } B;
  } MTCTR;

  union {                              /* Cycle Counter Register */
    vuint16_t R;
    struct {
      vuint16_t  :10;
      vuint16_t CYCCNT:6;
    } B;
  } CYCTR;

  union {                              /* Slot Counter Channel A Register */
    vuint16_t R;
    struct {
      vuint16_t  :5;
      vuint16_t SLOTCNTA:11;
    } B;
  } SLTCTAR;

  union {                              /* Slot Counter Channel B Register */
    vuint16_t R;
    struct {
      vuint16_t  :5;
      vuint16_t SLOTCNTB:11;
    } B;
  } SLTCTBR;

  union {                              /* Rate Correction Value Register */
    vuint16_t R;
    struct {
      vuint16_t RATECORR:16;
    } B;
  } RTCORVR;

  union {                              /* Offset Correction Value Register */
    vuint16_t R;
    struct {
      vuint16_t OFFSETCORR:16;
    } B;
  } OFCORVR;

  union {                              /* Combined Interrupt Flag Register */
    vuint16_t R;
    struct {
      vuint16_t  :8;
      vuint16_t MIF:1;
      vuint16_t PRIF:1;
      vuint16_t CHIF:1;
      vuint16_t WUPIF:1;
      vuint16_t FAFBIF:1;
      vuint16_t FAFAIF:1;
      vuint16_t RBIF:1;
      vuint16_t TBIF:1;
    } B;
  } CIFR;

  union {                              /* System Memory Access Time-Out Register */
    vuint16_t R;
    struct {
      vuint16_t  :8;
      vuint16_t TIMEOUT:8;
    } B;
  } SYMATOR;

  union {                              /* Sync Frame Counter Register */
    vuint16_t R;
    struct {
      vuint16_t SFEVB:4;
      vuint16_t SFEVA:4;
      vuint16_t SFODB:4;
      vuint16_t SFODA:4;
    } B;
  } SFCNTR;

  union {                              /* Sync Frame Table Offset Register */
    vuint16_t R;
    struct {
      vuint16_t SFT_OFFSET:15;
      vuint16_t  :1;
    } B;
  } SFTOR;

  union {                              /* Sync Frame Table Configuration, Control, Status Register */
    vuint16_t R;
    struct {
      vuint16_t ELKT:1;
      vuint16_t OLKT:1;
      vuint16_t CYCNUM:6;
      vuint16_t ELKS:1;
      vuint16_t OLKS:1;
      vuint16_t EVAL:1;
      vuint16_t OVAL:1;
      vuint16_t  :1;
      vuint16_t OPT:1;
      vuint16_t SDVEN:1;
      vuint16_t SIDEN:1;
    } B;
  } SFTCCSR;

  union {                              /* Sync Frame ID Rejection Filter Register */
    vuint16_t R;
    struct {
      vuint16_t  :6;
      vuint16_t SYNFRID:10;
    } B;
  } SFIDRFR;

  union {                              /* Sync Frame ID Acceptance Filter Value Register */
    vuint16_t R;
    struct {
      vuint16_t  :6;
      vuint16_t FVAL:10;
    } B;
  } SFIDAFVR;

  union {                              /* Sync Frame ID Acceptance Filter Mask Register */
    vuint16_t R;
    struct {
      vuint16_t  :6;
      vuint16_t FMSK:10;
    } B;
  } SFIDAFMR;

  union {                              /* Network Management Vector Register */
    vuint16_t R;
    struct {
      vuint16_t NMVP:16;
    } B;
  } NMVR[6];

  union {                              /* Network Management Vector Length Register */
    vuint16_t R;
    struct {
      vuint16_t  :12;
      vuint16_t NMVL:4;
    } B;
  } NMVLR;

  union {                              /* Timer Configuration and Control Register */
    vuint16_t R;
    struct {
      vuint16_t  :2;
      vuint16_t T2_CFG:1;
      vuint16_t T2_REP:1;
      vuint16_t  :1;
      vuint16_t T2SP:1;
      vuint16_t T2TR:1;
      vuint16_t T2ST:1;
      vuint16_t  :3;
      vuint16_t T1_REP:1;
      vuint16_t  :1;
      vuint16_t T1SP:1;
      vuint16_t T1TR:1;
      vuint16_t T1ST:1;
    } B;
  } TICCR;

  union {                              /* Timer 1 Cycle Set Register */
    vuint16_t R;
    struct {
      vuint16_t  :2;
      vuint16_t T1_CYC_VAL:6;
      vuint16_t  :2;
      vuint16_t T1_CYC_MSK:6;
    } B;
  } TI1CYSR;

  union {                              /* Timer 1 Macrotick Offset Register */
    vuint16_t R;
    struct {
      vuint16_t  :2;
      vuint16_t T1_MTOFFSET:14;
    } B;
  } TI1MTOR;

  union {
    union {                            /* Timer 2 Configuration Register 0 (Absolute Timer Configuration) */
      vuint16_t R;
      struct {
        vuint16_t  :2;
        vuint16_t T2CYCVAL:6;          /* Timer T2 Cycle Filter Mask */
        vuint16_t  :2;
        vuint16_t T2CYCMSK:6;          /* Timer T2 Cycle Filter Mask */
      } B;
    } ABS;
    union {                            /* Timer 2 Configuration Register 0 (Relative Timer Configuration) */
      vuint16_t R;
      struct {
        vuint16_t T2MTCNT:16;          /* Timer T2 Macrotick High Word */
      } B;
    } REL;
  } TI2CR0;

  union {
    union {                            /* Timer 2 Configuration Register 1 (Absolute Timer Configuration) */
      vuint16_t R;
      struct {
        vuint16_t  :2;
        vuint16_t T2MOFF:14;           /* Timer T2 Macrotick Offset */
      } B;
    } ABS;
    union {                            /* Timer 2 Configuration Register 1 (Relative Timer Configuration) */
      vuint16_t R;
      struct {
        vuint16_t T2MTCNT:16;
      } B;
    } REL;
  } TI2CR1;

  union {                              /* Slot Status Selection Register */
    vuint16_t R;
    struct {
      vuint16_t WMD:1;
      vuint16_t  :1;
      vuint16_t SEL:2;
      vuint16_t  :1;
      vuint16_t SLOTNUMBER:11;
    } B;
  } SSSR;

  union {                              /* Slot Status Counter Condition Register */
    vuint16_t R;
    struct {
      vuint16_t WMD:1;
      vuint16_t  :1;
      vuint16_t SEL:2;
      vuint16_t  :1;
      vuint16_t CNTCFG:2;
      vuint16_t MCY:1;
      vuint16_t VFR:1;
      vuint16_t SYF:1;
      vuint16_t NUF:1;
      vuint16_t SUF:1;
      vuint16_t STATUSMASK:4;
    } B;
  } SSCCR;

  union {                              /* Slot Status Register */
    vuint16_t R;
    struct {
      vuint16_t VFB:1;
      vuint16_t SYB:1;
      vuint16_t NFB:1;
      vuint16_t SUB:1;
      vuint16_t SEB:1;
      vuint16_t CEB:1;
      vuint16_t BVB:1;
      vuint16_t TCB:1;
      vuint16_t VFA:1;
      vuint16_t SYA:1;
      vuint16_t NFA:1;
      vuint16_t SUA:1;
      vuint16_t SEA:1;
      vuint16_t CEA:1;
      vuint16_t BVA:1;
      vuint16_t TCA:1;
    } B;
  } SSR[8];

  union {                              /* Slot Status Counter Register */
    vuint16_t R;
    struct {
      vuint16_t SLOTSTATUSCNT:16;
    } B;
  } SSCR[4];

  union {                              /* MTS A Configuration Register */
    vuint16_t R;
    struct {
      vuint16_t MTE:1;
      vuint16_t  :1;
      vuint16_t CYCCNTMSK:6;
      vuint16_t  :2;
      vuint16_t CYCCNTVAL:6;
    } B;
  } MTSACFR;

  union {                              /* MTS B Configuration Register */
    vuint16_t R;
    struct {
      vuint16_t MTE:1;
      vuint16_t  :1;
      vuint16_t CYCCNTMSK:6;
      vuint16_t  :2;
      vuint16_t CYCCNTVAL:6;
    } B;
  } MTSBCFR;

  union {                              /* Receive Shadow Buffer Index Register */
    vuint16_t R;
    struct {
      vuint16_t WMD:1;
      vuint16_t  :1;
      vuint16_t SEL:2;
      vuint16_t  :4;
      vuint16_t RSBIDX:8;              /* RSBIDXA1/RSBIDXA2/RSBIDXB1/RSBIDXB2- Receive Shadow Buffer Index */
    } B;
  } RSBIR;

  union {                              /* Receive FIFO Watermark and Selection Register */
    vuint16_t R;
    struct {
      vuint16_t WM:8;                  /* WMA/WMB - Watermark */
      vuint16_t  :7;
      vuint16_t SEL:1;
    } B;
  } RFWMSR;

  union {                              /* Receive FIFO Start Index Register */
    vuint16_t R;
    struct {
      vuint16_t  :6;
      vuint16_t SIDX:10;               /* SIDXA/SIDXB - Start Index */
    } B;
  } RFSIR;

  union {                              /* Receive FIFO Depth and Size Register */
    vuint16_t R;
    struct {
      vuint16_t FIFO_DEPTH:8;          /* FIFO_DEPTHA/FIFO_DEPTHB - FIFO Depth */
      vuint16_t  :1;
      vuint16_t ENTRY_SIZE:7;          /* ENTRY_SIZEA/ENTRY_SIZEB - Entry Size */
    } B;
  } RFDSR;

  union {                              /* Receive FIFO A Read Index Register */
    vuint16_t R;
    struct {
      vuint16_t  :6;
      vuint16_t RDIDX:10;
    } B;
  } RFARIR;

  union {                              /* Receive FIFO B Read Index Register */
    vuint16_t R;
    struct {
      vuint16_t  :6;
      vuint16_t RDIDX:10;
    } B;
  } RFBRIR;

  union {                              /* Receive FIFO Message ID Acceptance Filter Value Register */
    vuint16_t R;
    struct {
      vuint16_t MIDAFVAL:16;           /* MIDAFVALA/MIDAFVALB - Message ID Acceptance Filter Value */
    } B;
  } RFMIDAFVR;

  union {                              /* Receive FIFO Message ID Acceptance Filter Mask Register */
    vuint16_t R;
    struct {
      vuint16_t MIDAFMSK:16;           /* MIDAFMSKA/MIDAFMSKB - Message ID Acceptance Filter Mask */
    } B;
  } RFMIDAFMR;

  union {                              /* Receive FIFO Frame ID Rejection Filter Value Register */
    vuint16_t R;
    struct {
      vuint16_t  :5;
      vuint16_t FIDRFVAL:11;           /* FIDRFVALA/FIDRFVALB - Frame ID Rejection Filter Value */
    } B;
  } RFFIDRFVR;

  union {                              /* Receive FIFO Frame ID Rejection Filter Mask Register */
    vuint16_t R;
    struct {
      vuint16_t  :5;
      vuint16_t FIDRFMSK:11;
    } B;
  } RFFIDRFMR;

  union {                              /* Receive FIFO Range Filter Configuration Register */
    vuint16_t R;
    struct {
      vuint16_t WMD:1;
      vuint16_t IBD:1;
      vuint16_t SEL:2;
      vuint16_t  :1;
      vuint16_t SID:11;                /* Slot ID */
    } B;
  } RFRFCFR;

  union {                              /* Receive FIFO Range Filter Control Register */
    vuint16_t R;
    struct {
      vuint16_t  :4;
      vuint16_t F3MD:1;
      vuint16_t F2MD:1;
      vuint16_t F1MD:1;
      vuint16_t F0MD:1;
      vuint16_t  :4;
      vuint16_t F3EN:1;
      vuint16_t F2EN:1;
      vuint16_t F1EN:1;
      vuint16_t F0EN:1;
    } B;
  } RFRFCTR;

  union {                              /* Last Dynamic Transmit Slot Channel A Register */
    vuint16_t R;
    struct {
      vuint16_t  :5;
      vuint16_t LDYNTXSLOTA:11;
    } B;
  } LDTXSLAR;

  union {                              /* Last Dynamic Transmit Slot Channel B Register */
    vuint16_t R;
    struct {
      vuint16_t  :5;
      vuint16_t LDYNTXSLOTB:11;
    } B;
  } LDTXSLBR;

  union {                              /* Protocol Configuration Register 0 */
    vuint16_t R;
    struct {
      vuint16_t action_point_offset:6;
      vuint16_t static_slot_length:10;
    } B;
  } PCR0;

  union {                              /* Protocol Configuration Register 1 */
    vuint16_t R;
    struct {
      vuint16_t  :2;
      vuint16_t macro_after_first_static_slot:14;
    } B;
  } PCR1;

  union {                              /* Protocol Configuration Register 2 */
    vuint16_t R;
    struct {
      vuint16_t minislot_after_action_point:6;
      vuint16_t number_of_static_slots:10; /* gNumberOfStaticSlots */
    } B;
  } PCR2;

  union {                              /* Protocol Configuration Register 3 */
    vuint16_t R;
    struct {
      vuint16_t wakeup_symbol_rx_low:6;
      vuint16_t minislot_action_point_offset:5;
      vuint16_t coldstart_attempts:5;
    } B;
  } PCR3;

  union {                              /* Protocol Configuration Register 4 */
    vuint16_t R;
    struct {
      vuint16_t cas_rx_low_max:7;
      vuint16_t wakeup_symbol_rx_window:9;
    } B;
  } PCR4;

  union {                              /* Protocol Configuration Register 5 */
    vuint16_t R;
    struct {
      vuint16_t tss_transmitter:4;
      vuint16_t wakeup_symbol_tx_low:6;
      vuint16_t wakeup_symbol_rx_idle:6;
    } B;
  } PCR5;

  union {                              /* Protocol Configuration Register 6 */
    vuint16_t R;
    struct {
      vuint16_t  :1;
      vuint16_t symbol_window_after_action_point:8;
      vuint16_t macro_initial_offset_a:7;
    } B;
  } PCR6;

  union {                              /* Protocol Configuration Register 7 */
    vuint16_t R;
    struct {
      vuint16_t decoding_correction_b:9;
      vuint16_t micro_per_macro_nom_half:7;
    } B;
  } PCR7;

  union {                              /* Protocol Configuration Register 8 */
    vuint16_t R;
    struct {
      vuint16_t max_without_clock_correction_fatal:4;
      vuint16_t max_without_clock_correction_passive:4;
      vuint16_t wakeup_symbol_tx_idle:8;
    } B;
  } PCR8;

  union {                              /* Protocol Configuration Register 9 */
    vuint16_t R;
    struct {
      vuint16_t minislot_exists:1;
      vuint16_t symbol_window_exists:1;
      vuint16_t offset_correction_out:14;
    } B;
  } PCR9;

  union {                              /* Protocol Configuration Register 10 */
    vuint16_t R;
    struct {
      vuint16_t single_slot_enabled:1;
      vuint16_t wakeup_channel:1;
      vuint16_t macro_per_cycle:14;
    } B;
  } PCR10;

  union {                              /* Protocol Configuration Register 11 */
    vuint16_t R;
    struct {
      vuint16_t key_slot_used_for_startup:1;
      vuint16_t key_slot_used_for_sync:1;
      vuint16_t offset_correction_start:14;
    } B;
  } PCR11;

  union {                              /* Protocol Configuration Register 12 */
    vuint16_t R;
    struct {
      vuint16_t allow_passive_to_active:5;
      vuint16_t key_slot_header_crc:11;
    } B;
  } PCR12;

  union {                              /* Protocol Configuration Register 13 */
    vuint16_t R;
    struct {
      vuint16_t first_minislot_action_point_offset:6;
      vuint16_t static_slot_after_action_point:10;
    } B;
  } PCR13;

  union {                              /* Protocol Configuration Register 14 */
    vuint16_t R;
    struct {
      vuint16_t rate_correction_out:11;
      vuint16_t listen_timeout:5;
    } B;
  } PCR14;

  union {                              /* Protocol Configuration Register 15 */
    vuint16_t R;
    struct {
      vuint16_t listen_timeout:16;
    } B;
  } PCR15;

  union {                              /* Protocol Configuration Register 16 */
    vuint16_t R;
    struct {
      vuint16_t macro_initial_offset_b:7;
      vuint16_t noise_listen_timeout:9;
    } B;
  } PCR16;

  union {                              /* Protocol Configuration Register 17 */
    vuint16_t R;
    struct {
      vuint16_t noise_listen_timeout:16;
    } B;
  } PCR17;

  union {                              /* Protocol Configuration Register 18 */
    vuint16_t R;
    struct {
      vuint16_t wakeup_pattern:6;
      vuint16_t key_slot_id:10;
    } B;
  } PCR18;

  union {                              /* Protocol Configuration Register 19 */
    vuint16_t R;
    struct {
      vuint16_t decoding_correction_a:9;
      vuint16_t payload_length_static:7;
    } B;
  } PCR19;

  union {                              /* Protocol Configuration Register 20 */
    vuint16_t R;
    struct {
      vuint16_t micro_initial_offset_b:8;
      vuint16_t micro_initial_offset_a:8;
    } B;
  } PCR20;

  union {                              /* Protocol Configuration Register 21 */
    vuint16_t R;
    struct {
      vuint16_t extern_rate_correction:3;
      vuint16_t latest_tx:13;
    } B;
  } PCR21;

  union {                              /* Protocol Configuration Register 22 */
    vuint16_t R;
    struct {
      vuint16_t  :1;                   /* Reserved bit, will not be changed. Application must not write any value different from the reset value. */
      vuint16_t comp_accepted_startup_range_a:11;
      vuint16_t micro_per_cycle:4;
    } B;
  } PCR22;

  union {                              /* Protocol Configuration Register 23 */
    vuint16_t R;
    struct {
      vuint16_t micro_per_cycle:16;
    } B;
  } PCR23;

  union {                              /* Protocol Configuration Register 24 */
    vuint16_t R;
    struct {
      vuint16_t cluster_drift_damping:5;
      vuint16_t max_payload_length_dynamic:7;
      vuint16_t micro_per_cycle_min:4;
    } B;
  } PCR24;

  union {                              /* Protocol Configuration Register 25 */
    vuint16_t R;
    struct {
      vuint16_t micro_per_cycle_min:16;
    } B;
  } PCR25;

  union {                              /* Protocol Configuration Register 26 */
    vuint16_t R;
    struct {
      vuint16_t allow_halt_due_to_clock:1;
      vuint16_t comp_accepted_startup_range_b:11;
      vuint16_t micro_per_cycle_max:4;
    } B;
  } PCR26;

  union {                              /* Protocol Configuration Register 27 */
    vuint16_t R;
    struct {
      vuint16_t micro_per_cycle_max:16;
    } B;
  } PCR27;

  union {                              /* Protocol Configuration Register 28 */
    vuint16_t R;
    struct {
      vuint16_t dynamic_slot_idle_phase:2;
      vuint16_t macro_after_offset_correction:14;
    } B;
  } PCR28;

  union {                              /* Protocol Configuration Register 29 */
    vuint16_t R;
    struct {
      vuint16_t extern_offset_correction:3;
      vuint16_t minislots_max:13;
    } B;
  } PCR29;

  union {                              /* Protocol Configuration Register 30 */
    vuint16_t R;
    struct {
      vuint16_t  :12;
      vuint16_t sync_node_max:4;
    } B;
  } PCR30;

  union {                              /* StopWatch Count Register */
    vuint16_t R;
    struct {
      vuint16_t STPW:16;               /* StopWatch Count Register */
    } B;
  } STPWR;

  uint8_t FR_reserved1[2];
  union {                              /* Protocol Event Output Enable and StopWatch Control Register */
    vuint16_t R;
    struct {
      vuint16_t  :7;
      vuint16_t STPW_EN:1;             /* Stopwatch count Enable */
      vuint16_t  :5;
      vuint16_t TIM2_EE:1;
      vuint16_t TIM1_EE:1;
      vuint16_t CYC_EE:1;
    } B;
  } PEOER;

  uint8_t FR_reserved2[2];
  union {                              /* Receive FIFO Start Data Offset Register */
    vuint16_t R;
    struct {
      vuint16_t SDO:16;                /* SDOA/SDOB - Start Data Field Offset */
    } B;
  } RFSDOR;

  union {                              /* Receive FIFO System Memory Base Address High Register */
    vuint16_t R;
    struct {
      vuint16_t SMBA:16;
    } B;
  } RFSYMBADHR;

  union {                              /* Receive FIFO System Memory Base Address Low Register */
    vuint16_t R;
    struct {
      vuint16_t SMBA:12;
      vuint16_t  :4;
    } B;
  } RFSYMBADLR;

  union {                              /* Receive FIFO Periodic Timer Register */
    vuint16_t R;
    struct {
      vuint16_t  :2;
      vuint16_t PTD:14;
    } B;
  } RFPTR;

  union {                              /* Receive FIFO Fill Level and POP Count Register */
    vuint16_t R;
    struct {
      vuint16_t FLB_or_PCB:8;
      vuint16_t FLA_or_PCA:8;
    } B;
  } RFFLPCR;

  union {                              /* ECC Error Interrupt Flag and Enable Register */
    vuint16_t R;
    struct {
      vuint16_t LRNE_OF:1;
      vuint16_t LRCE_OF:1;
      vuint16_t DRNE_OF:1;
      vuint16_t DRCE_OF:1;
      vuint16_t LRNE_IF:1;
      vuint16_t LRCE_IF:1;
      vuint16_t DRNE_IF:1;
      vuint16_t DRCE_IF:1;
      vuint16_t  :4;
      vuint16_t LRNE_IE:1;
      vuint16_t LRCE_IE:1;
      vuint16_t DRNE_IE:1;
      vuint16_t DRCE_IE:1;
    } B;
  } EEIFER;

  union {                              /* ECC Error Report and Injection Control Register */
    vuint16_t R;
    struct {
      vuint16_t BSY:1;
      vuint16_t  :5;
      vuint16_t ERS:2;
      vuint16_t  :3;
      vuint16_t ERM:1;
      vuint16_t  :2;
      vuint16_t EIM:1;
      vuint16_t EIE:1;
    } B;
  } EERICR;

  union {                              /* ECC Error Report Address Register */
    vuint16_t R;
    struct {
      vuint16_t MID:1;
      vuint16_t BANK:3;
      vuint16_t ADDR:12;
    } B;
  } EERAR;

  union {                              /* ECC Error Report Data Register */
    vuint16_t R;
    struct {
      vuint16_t DATA:16;
    } B;
  } EERDR;

  union {                              /* ECC Error Report Code Register */
    vuint16_t R;
    struct {
      vuint16_t  :11;
      vuint16_t CODE:5;
    } B;
  } EERCR;

  union {                              /* ECC Error Injection Address Register */
    vuint16_t R;
    struct {
      vuint16_t MID:1;
      vuint16_t BANK:3;
      vuint16_t ADDR:12;
    } B;
  } EEIAR;

  union {                              /* ECC Error Injection Data Register */
    vuint16_t R;
    struct {
      vuint16_t DATA:16;
    } B;
  } EEIDR;

  union {                              /* ECC Error Injection Code Register */
    vuint16_t R;
    struct {
      vuint16_t  :11;
      vuint16_t CODE:5;
    } B;
  } EEICR;

  uint8_t FR_reserved3[1792];
  struct {
    union {                            /* Message Buffer Configuration, Control, Status Register */
      vuint16_t R;
      struct {
        vuint16_t  :3;
        vuint16_t MTD:1;
        vuint16_t CMT:1;
        vuint16_t EDT:1;
        vuint16_t LCKT:1;
        vuint16_t MBIE:1;
        vuint16_t  :3;
        vuint16_t DUP:1;
        vuint16_t DVAL:1;
        vuint16_t EDS:1;
        vuint16_t LCKS:1;
        vuint16_t MBIF:1;
      } B;
    } CCSR;
    union {                            /* Message Buffer Cycle Counter Filter Register */
      vuint16_t R;
      struct {
        vuint16_t MTM:1;
        vuint16_t CHA:1;
        vuint16_t CHB:1;
        vuint16_t CCFE:1;
        vuint16_t CCFMSK:6;
        vuint16_t CCFVAL:6;
      } B;
    } CCFR;
    union {                            /* Message Buffer Frame ID Register */
      vuint16_t R;
      struct {
        vuint16_t  :5;
        vuint16_t FID:11;
      } B;
    } FIDR;
    union {                            /* Message Buffer Index Register */
      vuint16_t R;
      struct {
        vuint16_t  :8;
        vuint16_t MBIDX:8;
      } B;
    } IDXR;
  } MB[128];

  uint8_t FR_reserved4[1024];
  union {                              /* Message Buffer Data Field Offset Register */
    vuint16_t R;
    struct {
      vuint16_t MBDO:16;
    } B;
  } MBDOR[132];

  union {                              /* LRAM ECC Error Test Register */
    vuint16_t R;
    struct {
      vuint16_t LEETD:16;
    } B;
  } LEETR[6];
};


/* ============================================================================
   =============================== Module: FXOSC ==============================
   ============================================================================ */

struct FXOSC_tag {
  union {                              /* FXOSC Control Register */
    vuint32_t R;
    struct {
      vuint32_t OSCBYP:1;
      vuint32_t OSCM:1;
      vuint32_t  :1;
      vuint32_t  :5;
      vuint32_t EOCV:8;                /* End of Count Value */
      vuint32_t M_OSC:1;               /* Crystal oscillator clock interrupt mask */
      vuint32_t  :2;
      vuint32_t OSCDIV:5;
      vuint32_t I_OSC:1;
      vuint32_t  :3;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t  :1;
    } B;
  } CTL;
};


/* ============================================================================
   =============================== Module: GPR ================================
   ============================================================================ */

struct GPR_tag {
  union {                              /* GPR Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :3;
      vuint32_t EXTREGC:1;             /* This bit enables the external regulator control multiplexed function on PG[6] */
      vuint32_t DEST_ESC_CTRL2:1;      /* Enables the escalation of destructive reset source: SWT0 reset request. This bit will be reset on POR. */
      vuint32_t DEST_ESC_CTRL1:1;      /* Enables the escalation of destructive reset source: functional reset escalation. This bit will be reset on POR. */
      vuint32_t DEST_ESC_CTRL0:1;      /* Enables the escalation of destructive reset source: SSCM secured reset. This bit will be reset on POR. */
      vuint32_t  :5;
      vuint32_t CMP2_STDBY:1;
      vuint32_t CMP1_STDBY:1;
      vuint32_t CMP0_STDBY:1;
      vuint32_t CLKOUT1_STDBY:1;
      vuint32_t LPU_STOP_ACK_BYPASS:1;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t RTC_SXOSC_FREE_RUNNING:1; /* Enables seamless RTC operation across functional and destructive reset in the specific case when RTC is running on SXOSC. This Bit should be set after SXOSC is enabled by the software. */
      vuint32_t CMP_ACT_SAM:1;         /* Actual sample to the CMP */
      vuint32_t CMP_SAMP_SEL:1;        /* Sample select to the CMP */
      vuint32_t  :2;
      vuint32_t  :2;
      vuint32_t FR_BS:2;               /* FlexRay byte swapper: Swaps the AHB write/read data at the boundary of FlexRay master */
      vuint32_t ENET_TX_BS:2;          /* ENET TX byte swapper: Swaps the AHB write/read data at the TX boundary of ENET master */
      vuint32_t ENET_RX_BS:2;          /* ENET RX byte swapper: Swaps the AHB write/read data at the RX boundary of ENET master */
    } B;
  } CTL;

  union {                              /* GPR Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :21;
      vuint32_t FLASH_LP_ACK:1;        /* FLASH low power acknowledge status */
      vuint32_t  :8;
      vuint32_t  :1;
      vuint32_t  :1;
    } B;
  } STAT;

  uint8_t GPR_reserved0[8];
  union {                              /* GPR Control Register1 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t IVPR:24;               /* Interrupt Vector Prefix Register Programming */
    } B;
  } CTL1;

  union {                              /* GPR SLEEP Register */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t SRAM_8_SLEEP:1;        /* Enables the sleep mode for SRAM memory block 8. */
      vuint32_t SRAM_7_SLEEP:1;        /* Enables the sleep mode for SRAM memory block 7. */
      vuint32_t SRAM_6_SLEEP:1;        /* Enables the sleep mode for SRAM memory block 6. */
      vuint32_t SRAM_5_SLEEP:1;        /* Enables the sleep mode for SRAM memory block 5. */
      vuint32_t SRAM_4_SLEEP:1;        /* Enables the sleep mode for SRAM memory block 4. */
      vuint32_t SRAM_3_SLEEP:1;        /* Enables the sleep mode for SRAM memory block 3. */
    } B;
  } SLEEP;
};


/* ============================================================================
   =============================== Module: HFInterface ========================
   ============================================================================ */

struct HFInterface_tag {
  union {                              /* Clock Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :22;
      vuint32_t CLK_EN:1;              /* Clock Enable */
      vuint32_t CLK_SEL:1;             /* Clock Select */
      vuint32_t CLK_DIV:8;             /* Clock Divider */
    } B;
  } CCR;

  union {                              /* Short Pulse Detector Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t ENABLE:1;
      vuint32_t INVERT:1;
      vuint32_t  :6;
      vuint32_t MAX_VAL:8;             /* Maximum low level value */
      vuint32_t  :8;
      vuint32_t MIN_VAL:8;             /* Minimum Low level value */
    } B;
  } SPDCR;

  union {                              /* Long Pulse Detector Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t ENABLE:1;
      vuint32_t INVERT:1;
      vuint32_t  :1;
      vuint32_t MAX_VAL:13;            /* Maximum high level value */
      vuint32_t  :3;
      vuint32_t MIN_VAL:13;            /* Minimum high level value */
    } B;
  } LPDCR;

  union {                              /* Low-level Timeout Detector Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t ENABLE:1;
      vuint32_t  :15;
      vuint32_t MAX_VAL:16;            /* Minimum value */
    } B;
  } LTDCR;

  union {                              /* High-level Timeout Detector Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t ENABLE:1;
      vuint32_t  :15;
      vuint32_t MAX_VAL:16;            /* Minimum value */
    } B;
  } HTDCR;

  union {                              /* Interrupt Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t ACK_INT_EN:1;
      vuint32_t INIT_INT_EN:1;
      vuint32_t EOF_INT_EN:1;
    } B;
  } IER;

  union {                              /* Interrupt Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t ACK_INT_SR:1;
      vuint32_t INIT_INT_SR:1;
      vuint32_t EOF_INT_SR:1;
    } B;
  } ISR;
};


/* ============================================================================
   =============================== Module: I2C ================================
   ============================================================================ */

struct I2C_tag {
  union {                              /* I2C Bus Address Register */
    vuint8_t R;
    struct {
      vuint8_t ADR:7;
      vuint8_t  :1;
    } B;
  } IBAD;

  union {                              /* I2C Bus Frequency Divider Register */
    vuint8_t R;
    struct {
      vuint8_t IBC:8;
    } B;
  } IBFD;

  union {                              /* I2C Bus Control Register */
    vuint8_t R;
    struct {
      vuint8_t MDIS:1;
      vuint8_t IBIE:1;
      vuint8_t MSSL:1;
      vuint8_t TXRX:1;
      vuint8_t NOACK:1;
      vuint8_t RSTA:1;
      vuint8_t DMAEN:1;
      vuint8_t  :1;
    } B;
  } IBCR;

  union {                              /* I2C Bus Status Register */
    vuint8_t R;
    struct {
      vuint8_t TCF:1;
      vuint8_t IAAS:1;
      vuint8_t IBB:1;
      vuint8_t IBAL:1;
      vuint8_t  :1;
      vuint8_t SRW:1;
      vuint8_t IBIF:1;
      vuint8_t RXAK:1;
    } B;
  } IBSR;

  union {                              /* I2C Bus Data I/O Register */
    vuint8_t R;
    struct {
      vuint8_t DATA:8;
    } B;
  } IBDR;

  union {                              /* I2C Bus Interrupt Config Register */
    vuint8_t R;
    struct {
      vuint8_t BIIE:1;
      vuint8_t  :7;
    } B;
  } IBIC;

  union {                              /* I2C Bus Debug Register */
    vuint8_t R;
    struct {
      vuint8_t  :5;
      vuint8_t BYTE_RX:1;
      vuint8_t IPG_DEBUG_HALTED:1;
      vuint8_t IPG_DEBUG_EN:1;
    } B;
  } IBDBG;
};


/* ============================================================================
   =============================== Module: I2S ================================
   ============================================================================ */

struct I2S_tag {
  union {                              /* SAI Transmit Control Register */
    vuint32_t R;
    struct {
      vuint32_t TE:1;                  /* Transmitter Enable */
      vuint32_t STOPE:1;               /* Stop Enable */
      vuint32_t DBGE:1;                /* Debug Enable */
      vuint32_t BCE:1;                 /* Bit Clock Enable */
      vuint32_t  :2;
      vuint32_t FR:1;                  /* FIFO Reset */
      vuint32_t SR:1;                  /* Software Reset */
      vuint32_t  :3;
      vuint32_t WSF:1;                 /* Word Start Flag */
      vuint32_t SEF:1;                 /* Sync Error Flag */
      vuint32_t FEF:1;                 /* FIFO Error Flag */
      vuint32_t FWF:1;                 /* FIFO Warning Flag */
      vuint32_t FRF:1;                 /* FIFO Request Flag */
      vuint32_t  :3;
      vuint32_t WSIE:1;                /* Word Start Interrupt Enable */
      vuint32_t SEIE:1;                /* Sync Error Interrupt Enable */
      vuint32_t FEIE:1;                /* FIFO Error Interrupt Enable */
      vuint32_t FWIE:1;                /* FIFO Warning Interrupt Enable */
      vuint32_t FRIE:1;                /* FIFO Request Interrupt Enable */
      vuint32_t  :3;
      vuint32_t  :3;
      vuint32_t FWDE:1;                /* FIFO Warning DMA Enable */
      vuint32_t FRDE:1;                /* FIFO Request DMA Enable */
    } B;
  } TCSR;

  union {                              /* SAI Transmit Configuration 1 Register */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t TFW:3;                 /* Transmit FIFO Watermark */
    } B;
  } TCR1;

  union {                              /* SAI Transmit Configuration 2 Register */
    vuint32_t R;
    struct {
      vuint32_t SYNC:2;                /* Synchronous Mode */
      vuint32_t BCS:1;                 /* Bit Clock Swap */
      vuint32_t BCI:1;                 /* Bit Clock Input */
      vuint32_t MSEL:2;                /* MCLK Select */
      vuint32_t BCP:1;                 /* Bit Clock Polarity */
      vuint32_t BCD:1;                 /* Bit Clock Direction */
      vuint32_t  :16;
      vuint32_t DIV:8;                 /* Bit Clock Divide */
    } B;
  } TCR2;

  union {                              /* SAI Transmit Configuration 3 Register */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t CFR:4;                 /* Channel FIFO Reset */
      vuint32_t  :4;
      vuint32_t TCE:4;                 /* Transmit Channel Enable */
      vuint32_t  :12;
      vuint32_t WDFL:4;                /* Word Flag Configuration */
    } B;
  } TCR3;

  union {                              /* SAI Transmit Configuration 4 Register */
    vuint32_t R;
    struct {
      vuint32_t  :3;
      vuint32_t FCONT:1;               /* FIFO Continue on Error */
      vuint32_t FCOMB:2;               /* FIFO Combine Mode */
      vuint32_t FPACK:2;               /* FIFO Packing Mode */
      vuint32_t  :4;
      vuint32_t FRSZ:4;                /* Frame size */
      vuint32_t  :3;
      vuint32_t SYWD:5;                /* Sync Width */
      vuint32_t  :3;
      vuint32_t MF:1;                  /* MSB First */
      vuint32_t FSE:1;                 /* Frame Sync Early */
      vuint32_t ONDEM:1;               /* On Demand Mode */
      vuint32_t FSP:1;                 /* Frame Sync Polarity */
      vuint32_t FSD:1;                 /* Frame Sync Direction */
    } B;
  } TCR4;

  union {                              /* SAI Transmit Configuration 5 Register */
    vuint32_t R;
    struct {
      vuint32_t  :3;
      vuint32_t WNW:5;                 /* Word N Width */
      vuint32_t  :3;
      vuint32_t W0W:5;                 /* Word 0 Width */
      vuint32_t  :3;
      vuint32_t FBT:5;                 /* First Bit Shifted */
      vuint32_t  :8;
    } B;
  } TCR5;

  uint8_t I2S_reserved0[8];
  union {                              /* SAI Transmit Data Register */
    vuint32_t R;
    struct {
      vuint32_t TDR:32;                /* Transmit Data Register */
    } B;
  } TDR[4];

  uint8_t I2S_reserved1[16];
  union {                              /* SAI Transmit FIFO Register */
    vuint32_t R;
    struct {
      vuint32_t WCP:1;                 /* Write Channel Pointer */
      vuint32_t  :11;
      vuint32_t WFP:4;                 /* Write FIFO Pointer */
      vuint32_t  :12;
      vuint32_t RFP:4;                 /* Read FIFO Pointer */
    } B;
  } TFR[4];

  uint8_t I2S_reserved2[16];
  union {                              /* SAI Transmit Mask Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t TWM:16;                /* Transmit Word Mask */
    } B;
  } TMR;

  uint8_t I2S_reserved3[28];
  union {                              /* SAI Receive Control Register */
    vuint32_t R;
    struct {
      vuint32_t RE:1;                  /* Receiver Enable */
      vuint32_t STOPE:1;               /* Stop Enable */
      vuint32_t DBGE:1;                /* Debug Enable */
      vuint32_t BCE:1;                 /* Bit Clock Enable */
      vuint32_t  :2;
      vuint32_t FR:1;                  /* FIFO Reset */
      vuint32_t SR:1;                  /* Software Reset */
      vuint32_t  :3;
      vuint32_t WSF:1;                 /* Word Start Flag */
      vuint32_t SEF:1;                 /* Sync Error Flag */
      vuint32_t FEF:1;                 /* FIFO Error Flag */
      vuint32_t FWF:1;                 /* FIFO Warning Flag */
      vuint32_t FRF:1;                 /* FIFO Request Flag */
      vuint32_t  :3;
      vuint32_t WSIE:1;                /* Word Start Interrupt Enable */
      vuint32_t SEIE:1;                /* Sync Error Interrupt Enable */
      vuint32_t FEIE:1;                /* FIFO Error Interrupt Enable */
      vuint32_t FWIE:1;                /* FIFO Warning Interrupt Enable */
      vuint32_t FRIE:1;                /* FIFO Request Interrupt Enable */
      vuint32_t  :3;
      vuint32_t  :3;
      vuint32_t FWDE:1;                /* FIFO Warning DMA Enable */
      vuint32_t FRDE:1;                /* FIFO Request DMA Enable */
    } B;
  } RCSR;

  union {                              /* SAI Receive Configuration 1 Register */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t RFW:3;                 /* Receive FIFO Watermark */
    } B;
  } RCR1;

  union {                              /* SAI Receive Configuration 2 Register */
    vuint32_t R;
    struct {
      vuint32_t SYNC:2;                /* Synchronous Mode */
      vuint32_t BCS:1;                 /* Bit Clock Swap */
      vuint32_t BCI:1;                 /* Bit Clock Input */
      vuint32_t MSEL:2;                /* MCLK Select */
      vuint32_t BCP:1;                 /* Bit Clock Polarity */
      vuint32_t BCD:1;                 /* Bit Clock Direction */
      vuint32_t  :16;
      vuint32_t DIV:8;                 /* Bit Clock Divide */
    } B;
  } RCR2;

  union {                              /* SAI Receive Configuration 3 Register */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t CFR:4;                 /* Channel FIFO Reset */
      vuint32_t  :4;
      vuint32_t RCE:4;                 /* Receive Channel Enable */
      vuint32_t  :12;
      vuint32_t WDFL:4;                /* Word Flag Configuration */
    } B;
  } RCR3;

  union {                              /* SAI Receive Configuration 4 Register */
    vuint32_t R;
    struct {
      vuint32_t  :3;
      vuint32_t FCONT:1;               /* FIFO Continue on Error */
      vuint32_t FCOMB:2;               /* FIFO Combine Mode */
      vuint32_t FPACK:2;               /* FIFO Packing Mode */
      vuint32_t  :4;
      vuint32_t FRSZ:4;                /* Frame Size */
      vuint32_t  :3;
      vuint32_t SYWD:5;                /* Sync Width */
      vuint32_t  :3;
      vuint32_t MF:1;                  /* MSB First */
      vuint32_t FSE:1;                 /* Frame Sync Early */
      vuint32_t ONDEM:1;               /* On Demand Mode */
      vuint32_t FSP:1;                 /* Frame Sync Polarity */
      vuint32_t FSD:1;                 /* Frame Sync Direction */
    } B;
  } RCR4;

  union {                              /* SAI Receive Configuration 5 Register */
    vuint32_t R;
    struct {
      vuint32_t  :3;
      vuint32_t WNW:5;                 /* Word N Width */
      vuint32_t  :3;
      vuint32_t W0W:5;                 /* Word 0 Width */
      vuint32_t  :3;
      vuint32_t FBT:5;                 /* First Bit Shifted */
      vuint32_t  :8;
    } B;
  } RCR5;

  uint8_t I2S_reserved4[8];
  union {                              /* SAI Receive Data Register */
    vuint32_t R;
    struct {
      vuint32_t RDR:32;                /* Receive Data Register */
    } B;
  } RDR[4];

  uint8_t I2S_reserved5[16];
  union {                              /* SAI Receive FIFO Register */
    vuint32_t R;
    struct {
      vuint32_t  :12;
      vuint32_t WFP:4;                 /* Write FIFO Pointer */
      vuint32_t RCP:1;                 /* Receive Channel Pointer */
      vuint32_t  :11;
      vuint32_t RFP:4;                 /* Read FIFO Pointer */
    } B;
  } RFR[4];

  uint8_t I2S_reserved6[16];
  union {                              /* SAI Receive Mask Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t RWM:16;                /* Receive Word Mask */
    } B;
  } RMR;

  uint8_t I2S_reserved7[28];
  union {                              /* SAI MCLK Control Register */
    vuint32_t R;
    struct {
      vuint32_t DUF:1;                 /* Divider Update Flag */
      vuint32_t MOE:1;                 /* MCLK Output Enable */
      vuint32_t  :4;
      vuint32_t MICS:2;                /* MCLK Input Clock Select */
      vuint32_t  :24;
    } B;
  } MCR;

  union {                              /* SAI MCLK Divide Register */
    vuint32_t R;
    struct {
      vuint32_t  :11;
      vuint32_t FRACT:9;               /* MCLK Fraction */
      vuint32_t DIVIDE:12;             /* MCLK Divide */
    } B;
  } MDR;
};


/* ============================================================================
   =============================== Module: IGF ================================
   ============================================================================ */

struct IGF_tag {
  union {                              /* Module Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t MDIS:1;                /* Module Disable */
      vuint32_t FRZ:1;                 /* Freeze bit for debug operation */
      vuint32_t FBP:1;                 /* Force Bypass */
      vuint32_t FOH:1;                 /* Force filter output high */
      vuint32_t FOL:1;                 /* Force filter output low */
      vuint32_t  :16;
      vuint32_t IMM:1;                 /* Immediate edge propagation control bit */
      vuint32_t PSSEL:1;               /* Prescaler selection bit */
      vuint32_t POL:1;                 /* Output polarity bit */
      vuint32_t FGEN:1;                /* Filter global enable */
      vuint32_t FFM:3;                 /* Falling edge filter type selection */
      vuint32_t RFM:3;                 /* Rising edge filter type selection */
    } B;
  } MCR0;

  union {                              /* Module Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t WEDGE:1;               /* Filter is active waiting for an edge */
      vuint32_t FEDGE:1;               /* Filter is active processing an edge */
      vuint32_t RNDET:1;               /* Rise noise detected bit */
      vuint32_t FNDET:1;               /* Fall noise detected bit */
      vuint32_t FLI:1;                 /* Filter input */
      vuint32_t FLO:1;                 /* Filter output */
    } B;
  } MSR0;

  uint8_t IGF_reserved0[8];
  union {                              /* Prescaler Register */
    vuint32_t R;
    struct {
      vuint32_t  :21;
      vuint32_t FPRE:11;               /* Filter prescaler */
    } B;
  } PRESR0;

  uint8_t IGF_reserved1[8];
  union {                              /* Rising edge Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :27;
      vuint32_t RTH:5;                 /* Rising edge threshold */
    } B;
  } RTHR0;

  union {                              /* Falling edge Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :27;
      vuint32_t FTH:5;                 /* Falling edge threshold */
    } B;
  } FTHR0;
};


/* ============================================================================
   =============================== Module: INTC ===============================
   ============================================================================ */

struct INTC_tag {
  union {                              /* INTC Block Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :19;
      vuint32_t HVEN3:1;
      vuint32_t  :3;
      vuint32_t HVEN2:1;
      vuint32_t  :3;
      vuint32_t HVEN1:1;
      vuint32_t  :3;
      vuint32_t HVEN0:1;
    } B;
  } BCR;

  union {                              /* INTC Master Protection Register */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t ID:2;
      vuint32_t  :3;
      vuint32_t MPROT:1;
    } B;
  } MPROT;

  uint8_t INTC_reserved0[8];
  union {                              /* INTC Current Priority Register for Processor n */
    vuint32_t R;
    struct {
      vuint32_t  :28;
      vuint32_t PRI:4;
    } B;
  } CPR[3];

  uint8_t INTC_reserved1[4];
  union {                              /* INTC Interrupt Acknowledge Register for Processor n */
    vuint32_t R;
    struct {
      vuint32_t VTBA:20;
      vuint32_t INTVEC:10;
      vuint32_t  :2;
    } B;
  } IACKR[3];

  uint8_t INTC_reserved2[4];
  union {                              /* INTC End Of Interrupt Register for Processor n */
    vuint32_t R;
    struct {
      vuint32_t EOI:32;
    } B;
  } EOIR[3];

  uint8_t INTC_reserved3[4];
  union {                              /* INTC Software Set/Clear Interrupt Register */
    vuint8_t R;
    struct {
      vuint8_t  :6;
      vuint8_t SET:1;
      vuint8_t CLR:1;
    } B;
  } SSCIR[24];

  uint8_t INTC_reserved4[8];
  union {                              /* INTC Priority Select Register */
    vuint16_t R;
    struct {
      vuint16_t PRC_SELN:4;
      vuint16_t  :3;
      vuint16_t SWTN:1;
      vuint16_t  :4;
      vuint16_t PRIN:4;
    } B;
  } PSR[1024];
};


/* ============================================================================
   =============================== Module: JDC ================================
   ============================================================================ */

struct JDC_tag {
  union {                              /* Module Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :15;
      vuint32_t JIN_IEN:1;
      vuint32_t  :15;
      vuint32_t JOUT_IEN:1;
    } B;
  } MCR;

  union {                              /* Module Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :13;
      vuint32_t JIN_RDY:1;
      vuint32_t  :1;
      vuint32_t JIN_INT:1;
      vuint32_t  :13;
      vuint32_t JOUT_RDY:1;
      vuint32_t  :1;
      vuint32_t JOUT_INT:1;
    } B;
  } MSR;

  union {                              /* JTAG Output Data Register */
    vuint32_t R;
    struct {
      vuint32_t Data:32;
    } B;
  } JOUT_IPS;

  union {                              /* JTAG Input Data Register */
    vuint32_t R;
    struct {
      vuint32_t Data:32;
    } B;
  } JIN_IPS;
};


/* ============================================================================
   =============================== Module: LINFlexD ===========================
   ============================================================================ */

struct LINFlexD_tag {
  union {                              /* LIN Control Register 1 */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CCD:1;
      vuint32_t CFD:1;
      vuint32_t LASE:1;
      vuint32_t AUTOWU:1;
      vuint32_t MBL:4;
      vuint32_t BF:1;
      vuint32_t  :1;
      vuint32_t LBKM:1;
      vuint32_t MME:1;
      vuint32_t SSBL:1;
      vuint32_t RBLM:1;
      vuint32_t SLEEP:1;
      vuint32_t INIT:1;
    } B;
  } LINCR1;

  union {                              /* LIN Interrupt enable register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SZIE:1;
      vuint32_t OCIE:1;
      vuint32_t BEIE:1;
      vuint32_t CEIE:1;
      vuint32_t HEIE:1;
      vuint32_t  :2;
      vuint32_t FEIE:1;
      vuint32_t BOIE:1;
      vuint32_t LSIE:1;
      vuint32_t WUIE:1;
      vuint32_t DBFIE:1;
      vuint32_t DBEIETOIE:1;
      vuint32_t DRIE:1;
      vuint32_t DTIE:1;
      vuint32_t HRIE:1;
    } B;
  } LINIER;

  union {                              /* LIN Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :12;
      vuint32_t AUTOSYNC_COMP:1;
      vuint32_t RDC:3;
      vuint32_t LINS:4;                /* LIN state */
      vuint32_t  :2;
      vuint32_t RMB:1;
      vuint32_t DRBNE:1;
      vuint32_t RXbusy:1;
      vuint32_t RDI:1;
      vuint32_t WUF:1;
      vuint32_t DBFF:1;
      vuint32_t DBEF:1;
      vuint32_t DRF:1;
      vuint32_t DTF:1;
      vuint32_t HRF:1;
    } B;
  } LINSR;

  union {                              /* LIN Error Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SZF:1;
      vuint32_t OCF:1;
      vuint32_t BEF:1;
      vuint32_t CEF:1;
      vuint32_t SFEF:1;
      vuint32_t SDEF:1;
      vuint32_t IDPEF:1;
      vuint32_t FEF:1;
      vuint32_t BOF:1;
      vuint32_t  :6;
      vuint32_t NF:1;
    } B;
  } LINESR;

  union {                              /* UART Mode Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t  :8;
      vuint32_t NEF:3;
      vuint32_t DTU_PCETX:1;           /* Disable Timeout in UART mode */
      vuint32_t SBUR:2;
      vuint32_t WLS:1;
      vuint32_t TDFL_TFC:3;
      vuint32_t RDFL_RFC:3;
      vuint32_t RFBM:1;
      vuint32_t TFBM:1;
      vuint32_t WL1:1;
      vuint32_t PC1:1;
      vuint32_t RxEn:1;
      vuint32_t TxEn:1;
      vuint32_t PC0:1;
      vuint32_t PCE:1;
      vuint32_t WL0:1;
      vuint32_t UART:1;
    } B;
  } UARTCR;

  union {                              /* UART Mode Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SZF:1;
      vuint32_t OCF:1;
      vuint32_t PE:4;
      vuint32_t RMB:1;
      vuint32_t FEF:1;
      vuint32_t BOF:1;
      vuint32_t RDI:1;
      vuint32_t WUF:1;
      vuint32_t RFNE:1;
      vuint32_t TO:1;
      vuint32_t DRFRFE:1;
      vuint32_t DTFTFF:1;
      vuint32_t NF:1;
    } B;
  } UARTSR;

  union {                              /* LIN Time-Out Control Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :21;
      vuint32_t MODE:1;
      vuint32_t IOT:1;
      vuint32_t TOCE:1;
      vuint32_t CNT:8;
    } B;
  } LINTCSR;

  union {                              /* LIN Output Compare Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t OC2:8;
      vuint32_t OC1:8;
    } B;
  } LINOCR;

  union {                              /* LIN Time-Out Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :20;
      vuint32_t RTO:4;
      vuint32_t  :1;
      vuint32_t HTO:7;
    } B;
  } LINTOCR;

  union {                              /* LIN Fractional Baud Rate Register */
    vuint32_t R;
    struct {
      vuint32_t  :28;
      vuint32_t FBR:4;
    } B;
  } LINFBRR;

  union {                              /* LIN Integer Baud Rate Register */
    vuint32_t R;
    struct {
      vuint32_t  :12;
      vuint32_t IBR:20;
    } B;
  } LINIBRR;

  union {                              /* LIN Checksum Field Register */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t CF:8;
    } B;
  } LINCFR;

  union {                              /* LIN Control Register 2 */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t TBDE:1;
      vuint32_t IOBE:1;
      vuint32_t IOPE:1;
      vuint32_t WURQ:1;
      vuint32_t DDRQ:1;
      vuint32_t DTRQ:1;
      vuint32_t ABRQ:1;
      vuint32_t HTRQ:1;
      vuint32_t  :8;
    } B;
  } LINCR2;

  union {                              /* Buffer Identifier Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t DFL:6;
      vuint32_t DIR:1;
      vuint32_t CCS:1;
      vuint32_t  :2;
      vuint32_t ID:6;
    } B;
  } BIDR;

  union {                              /* Buffer Data Register Least Significant */
    vuint32_t R;
    struct {
      vuint32_t DATA3:8;
      vuint32_t DATA2:8;
      vuint32_t DATA1:8;
      vuint32_t DATA0:8;
    } B;
  } BDRL;

  union {                              /* Buffer Data Register Most Significant */
    vuint32_t R;
    struct {
      vuint32_t DATA7:8;
      vuint32_t DATA6:8;
      vuint32_t DATA5:8;
      vuint32_t DATA4:8;
    } B;
  } BDRM;

  union {                              /* Identifier Filter Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t FACT:16;
    } B;
  } IFER;

  union {                              /* Identifier Filter Match Index */
    vuint32_t R;
    struct {
      vuint32_t  :27;
      vuint32_t IFMI:5;
    } B;
  } IFMI;

  union {                              /* Identifier Filter Mode Register */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t IFM:8;
    } B;
  } IFMR;

  union {                              /* Identifier Filter Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t DFL:6;                 /* Data Field Length */
      vuint32_t DIR:1;                 /* Direction */
      vuint32_t CCS:1;                 /* Classic Checksum */
      vuint32_t  :2;
      vuint32_t ID:6;                  /* Identifier */
    } B;
  } IFCR[16];

  union {                              /* Global Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t TDFBM:1;
      vuint32_t RDFBM:1;
      vuint32_t TDLIS:1;
      vuint32_t RDLIS:1;
      vuint32_t STOP:1;
      vuint32_t SR:1;
    } B;
  } GCR;

  union {                              /* UART Preset Timeout Register */
    vuint32_t R;
    struct {
      vuint32_t  :20;
      vuint32_t PTO:12;
    } B;
  } UARTPTO;

  union {                              /* UART Current Timeout Register */
    vuint32_t R;
    struct {
      vuint32_t  :20;
      vuint32_t CTO:12;
    } B;
  } UARTCTO;

  union {                              /* DMA Tx Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t DTE:16;
    } B;
  } DMATXE;

  union {                              /* DMA Rx Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t DRE:16;
    } B;
  } DMARXE;
};


/* ============================================================================
   =============================== Module: LPU ================================
   ============================================================================ */

struct LPU_tag {
  union {                              /* LPU Mode Control Register */
    vuint32_t R;
    struct {
      vuint32_t TARGET_MODE:4;         /* Target Chip Mode */
      vuint32_t  :12;
      vuint32_t KEY:16;                /* This field provides the key to change the target mode. Any write access to the register with a value different from the keys is always ignored. Read access will always return the inverted key */
    } B;
  } MCTL;

  union {                              /* LPU Run Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :15;
      vuint32_t CAN0_CONT:1;           /* CAN0 continuous operation across LPU modes. CAN CHI frequency will switch from FS80 to LPU_SYS_CLK which will require reconfiguration thus inhibiting continuous operation across LPU modes. */
      vuint32_t  :7;
      vuint32_t DIRECT_DRUN:1;         /* Transition to DRUN on LPU_STANDBY exit */
      vuint32_t SYS_CLK_SEL:1;         /* System clock selection in LPU RUN mode */
      vuint32_t LPU_SLEEP:1;           /* Core sleep request during LPU RUN */
      vuint32_t  :1;
      vuint32_t SXOSC_ON:1;            /* SXOSC control during LPU_RUN */
      vuint32_t SIRC_ON:1;             /* SIRC control during LPU_RUN */
      vuint32_t  :1;
      vuint32_t FXOSC_ON:1;            /* FXOSC control during LPU_RUN */
      vuint32_t FIRC_ON:1;             /* FIRC oscillator control during LPU_RUN */
    } B;
  } RUN_CF;

  union {                              /* LPU Stop Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :27;
      vuint32_t SXOSC_ON:1;            /* SXOSC control during LPU_STOP */
      vuint32_t SIRC_ON:1;             /* SIRC control during LPU_STOP */
      vuint32_t  :1;
      vuint32_t FXOSC_ON:1;            /* FXOSC control during LPU_STOP */
      vuint32_t FIRC_ON:1;             /* FIRC oscillator control during LPU_STOP */
    } B;
  } STOP_CF;

  union {                              /* LPU Standby Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :27;
      vuint32_t SXOSC_ON:1;            /* SXOSC control during LPU_STANDBY */
      vuint32_t SIRC_ON:1;             /* SIRC control during LPU_STANDBY */
      vuint32_t  :1;
      vuint32_t FXOSC_ON:1;            /* FXOSC clock source control during LPU_STANDBY */
      vuint32_t FIRC_ON:1;             /* FIRC oscillator control during LPU_STANDBY */
    } B;
  } STANDBY_CF;

  union {                              /* LPU Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :10;
      vuint32_t PD2_PWR_STAT:1;        /* Ensures the main domain (power domain 2) is power gated completely. */
      vuint32_t SXOSC_STAT:1;          /* SXOSC clock source status */
      vuint32_t SIRC_STAT:1;           /* SIRC clock status */
      vuint32_t  :1;
      vuint32_t FXOSC_STAT:1;          /* FXOSC clock source status */
      vuint32_t FIRC_STAT:1;           /* FIRC clock status */
      vuint32_t CLK1_STOP:1;           /* FXOSC clock status during LPU mode */
      vuint32_t CLK0_STOP:1;           /* FIRC status during LPU mode */
      vuint32_t  :8;
      vuint32_t MTRANS:1;              /* LPU mode transition */
      vuint32_t  :1;
      vuint32_t CURRENT_MODE:4;        /* Current mode of the chip */
    } B;
  } SR;

  union {                              /* LPU Interrupt control register */
    vuint32_t R;
    struct {
      vuint32_t  :12;
      vuint32_t LPU_MRIG_E:1;          /* LPU mode request ignored interrupt enable */
      vuint32_t LPU_NEM_E:1;           /* LPU non-exist mode interrupt enable */
      vuint32_t LPU_MRI_E:1;           /* LPU mode request illegal interrupt enable */
      vuint32_t LPU_MTI_E:1;           /* LPU mode transition illegal interrupt enable */
      vuint32_t  :12;
      vuint32_t LPU_MRIG:1;            /* LPU mode request ignored */
      vuint32_t LPU_NEM:1;             /* LPU non-exist mode interrupt */
      vuint32_t LPU_MRI:1;             /* LPU mode request illegal interrupt */
      vuint32_t LPU_MTI:1;             /* LPU mode transition illegal interrupt */
    } B;
  } ICR;

  union {                              /* Module Disable */
    vuint32_t R;
    struct {
      vuint32_t  :22;
      vuint32_t eMIOS_0:1;
      vuint32_t CMP_2:1;
      vuint32_t CMP_1:1;
      vuint32_t CMP_0:1;
      vuint32_t MEMU_1:1;
      vuint32_t BCTU:1;
      vuint32_t CAN0:1;
      vuint32_t LIN_0:1;
      vuint32_t DSPI_3:1;
      vuint32_t ADC_0:1;
    } B;
  } MDIS;
};


/* ============================================================================
   =============================== Module: MC_CGM =============================
   ============================================================================ */

struct MC_CGM_tag {
  uint8_t MC_CGM_reserved0[384];
  union {                              /* Clockout 1 Select Register */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t SELCTL:4;              /* CLKOUT1 Source Select */
      vuint32_t  :24;
    } B;
  } CLKOUT1_SC;

  uint8_t MC_CGM_reserved1[4];
  union {                              /* CLKOUT1_DC Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t DE:1;                  /* CLKOUT1_DC enable */
      vuint32_t  :8;
      vuint32_t DIV:7;                 /* Divider */
      vuint32_t  :16;
    } B;
  } CLKOUT1_DC;

  uint8_t MC_CGM_reserved2[52];
  union {                              /* Auxiliary Clock 5 Select Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t SELCTL:1;
      vuint32_t  :24;
    } B;
  } AC5_SC;

  union {                              /* Auxiliary Clock 5 Select Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t SELSTAT:1;
      vuint32_t  :24;
    } B;
  } AC5_SS;

  uint8_t MC_CGM_reserved3[56];
  union {                              /* System Clock Divider 6 Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t DE:1;
      vuint32_t  :12;
      vuint32_t DIV:3;                 /* Divider */
      vuint32_t  :16;
    } B;
  } SC_DC6;

  uint8_t MC_CGM_reserved4[60];
  union {                              /* Auxiliary Clock 7 Select Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t SELCTL:1;
      vuint32_t  :24;
    } B;
  } AC7_SC;

  union {                              /* Auxiliary Clock 7 Select Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t SELCTL:1;
      vuint32_t  :24;
    } B;
  } AC7_SS;

  uint8_t MC_CGM_reserved5[56];
  union {                              /* Auxiliary Clock 8 Select Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t SELCTL:1;
      vuint32_t  :24;
    } B;
  } AC8_SC;

  union {                              /* Auxiliary Clock 8 Select Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t SELCTL:1;
      vuint32_t  :24;
    } B;
  } AC8_SS;

  uint8_t MC_CGM_reserved6[56];
  union {                              /* Auxiliary Clock 9 Select Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t SELCTL:1;
      vuint32_t  :24;
    } B;
  } AC9_SC;

  union {                              /* Auxiliary Clock 9 Select Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t SELCTL:1;
      vuint32_t  :24;
    } B;
  } AC9_SS;

  uint8_t MC_CGM_reserved7[1080];
  union {                              /* PCS Switch Duration Register */
    vuint8_t R;
    struct {
      vuint8_t SDUR:8;
    } B;
  } PCS_SDUR;

  uint8_t MC_CGM_reserved8[3];
  union {                              /* PCS Divider Change Register 1 */
    vuint32_t R;
    struct {
      vuint32_t INIT:16;
      vuint32_t  :8;
      vuint32_t RATE:8;
    } B;
  } PCS_DIVC1;

  union {                              /* PCS Divider End Register 1 */
    vuint32_t R;
    struct {
      vuint32_t  :12;
      vuint32_t DIVE:20;
    } B;
  } PCS_DIVE1;

  union {                              /* PCS Divider Start Register 1 */
    vuint32_t R;
    struct {
      vuint32_t  :12;
      vuint32_t DIVS:20;
    } B;
  } PCS_DIVS1;

  union {                              /* PCS Divider Change Register 2 */
    vuint32_t R;
    struct {
      vuint32_t INIT:16;
      vuint32_t  :8;
      vuint32_t RATE:8;
    } B;
  } PCS_DIVC2;

  union {                              /* PCS Divider End Register 2 */
    vuint32_t R;
    struct {
      vuint32_t  :12;
      vuint32_t DIVE:20;
    } B;
  } PCS_DIVE2;

  union {                              /* PCS Divider Start Register 2 */
    vuint32_t R;
    struct {
      vuint32_t  :12;
      vuint32_t DIVS:20;
    } B;
  } PCS_DIVS2;

  uint8_t MC_CGM_reserved9[176];
  union {                              /* Divider Update Abort Register */
    vuint32_t R;
    struct {
      vuint32_t  :31;
      vuint32_t DIV_UPD_ABRTD:1;
    } B;
  } DIV_UPD_ABRTD;

  union {                              /* System Clock Divider Ratio Change Register */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t HALT_ABORT_DIS:1;
      vuint32_t SYS_DIV_RATIO_CHNG:1;
    } B;
  } SC_DIV_RC;

  union {                              /* Divider Update Type Register */
    vuint32_t R;
    struct {
      vuint32_t SYS_UPD_TYPE:1;        /* System Clock Divider Update Type */
      vuint32_t  :24;
      vuint32_t AUX_UPD_TYPE:1;        /* Auxiliary Clock Divider Update Type */
      vuint32_t  :6;
    } B;
  } DIV_UPD_TYPE;

  union {                              /* Divider Update Trigger Register */
    vuint32_t R;
    struct {
      vuint32_t DIV_UPD_TRIGGER:32;
    } B;
  } DIV_UPD_TRIG;

  union {                              /* Divider Update Status Register */
    vuint32_t R;
    struct {
      vuint32_t SYS_UPD_STAT:1;        /* System Clock Divider Update Status */
      vuint32_t  :24;
      vuint32_t AUX_UPD_STAT:1;        /* Auxiliary Clock Divider Status Type */
      vuint32_t  :6;
    } B;
  } DIV_UPD_STAT;

  uint8_t MC_CGM_reserved10[4];
  union {                              /* System Clock Select Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t SELSTAT:4;
      vuint32_t  :4;
      vuint32_t SWTRG:3;
      vuint32_t SWIP:1;
      vuint32_t  :16;
    } B;
  } SC_SS;

  union {                              /* System Clock Divider 0 Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t DE:1;
      vuint32_t  :12;
      vuint32_t DIV:3;
      vuint32_t  :16;
    } B;
  } SC_DC[6];
#if 0
  union {                              /* System Clock Divider 1 Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t DE:1;
      vuint32_t  :12;
      vuint32_t DIV:3;
      vuint32_t  :16;
    } B;
  } SC_DC1;

  union {                              /* System Clock Divider 2 Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t DE:1;
      vuint32_t  :11;
      vuint32_t DIV:4;
      vuint32_t  :16;
    } B;
  } SC_DC2;

  union {                              /* System Clock Divider 3 Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t DE:1;
      vuint32_t  :13;
      vuint32_t DIV:2;
      vuint32_t  :16;
    } B;
  } SC_DC3;

  union {                              /* System Clock Divider 4 Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t DE:1;
      vuint32_t  :13;
      vuint32_t DIV:2;
      vuint32_t  :16;
    } B;
  } SC_DC4;

  union {                              /* System Clock Divider 5 Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t DE:1;
      vuint32_t  :12;
      vuint32_t DIV:3;
      vuint32_t  :16;
    } B;
  } SC_DC5;
#endif
  uint8_t MC_CGM_reserved11[64];
  union {                              /* Auxiliary Clock 2 Select Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t SELSTAT:1;
      vuint32_t  :24;
    } B;
  } AC2_SC;

  union {                              /* Auxiliary Clock 2 Select Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t SELSTAT:1;
      vuint32_t  :24;
    } B;
  } AC2_SS;

  uint8_t MC_CGM_reserved12[24];
  union {                              /* Auxiliary Clock 3 Select Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t SELCTL:1;
      vuint32_t  :24;
    } B;
  } AC3_SC;

  union {                              /* Auxiliary Clock 3 Select Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t SELSTAT:1;
      vuint32_t  :24;
    } B;
  } AC3_SS;

  uint8_t MC_CGM_reserved13[88];
  union {                              /* Auxiliary Clock 6 Select Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t SELCTL:4;
      vuint32_t  :24;
    } B;
  } AC6_SC;

  union {                              /* Auxiliary Clock 6 Select Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t SELSTAT:4;
      vuint32_t  :24;
    } B;
  } AC6_SS;

  union {                              /* Aux Clock 6 Divider Configuration 0 for CLKOUT_0 */
    vuint32_t R;
    struct {
      vuint32_t DE:1;
      vuint32_t  :10;
      vuint32_t DIV:5;
      vuint32_t  :16;
    } B;
  } AC6_DC0;
};


/* ============================================================================
   =============================== Module: MC_ME ==============================
   ============================================================================ */

struct MC_ME_tag {
  union {                              /* Global Status Register */
    vuint32_t R;
    struct {
      vuint32_t S_CURRENT_MODE:4;
      vuint32_t S_MTRANS:1;
      vuint32_t  :1;
      vuint32_t  :2;
      vuint32_t S_PDO:1;
      vuint32_t  :2;
      vuint32_t S_MVR:1;
      vuint32_t  :2;
      vuint32_t S_FLA:2;
      vuint32_t  :7;
      vuint32_t S_SXOSC:1;             /* 32KHz external oscillator status */
      vuint32_t S_SIRCON:1;            /* 128 KHz internal RC oscillator status */
      vuint32_t S_PLLON:1;             /* PLL status */
      vuint32_t S_FXOSC:1;             /* 8-40MHz crystal oscillator status */
      vuint32_t S_FIRCON:1;
      vuint32_t S_SYSCLK:4;
    } B;
  } GS;

  union {                              /* Mode Control Register */
    vuint32_t R;
    struct {
      vuint32_t TARGET_MODE:4;         /* Target chip mode */
      vuint32_t  :12;
      vuint32_t KEY:16;
    } B;
  } MCTL;

  union {                              /* Mode Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t RESET_DEST:1;
      vuint32_t  :1;
      vuint32_t STANDBY0:1;            /* STANDBY0 mode enable */
      vuint32_t  :2;
      vuint32_t STOP0:1;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t RUN3:1;
      vuint32_t RUN2:1;
      vuint32_t RUN1:1;
      vuint32_t RUN0:1;
      vuint32_t DRUN:1;
      vuint32_t SAFE:1;
      vuint32_t  :1;
      vuint32_t RESET_FUNC:1;
    } B;
  } ME;

  union {                              /* Interrupt Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t I_ICONF_CC:1;
      vuint32_t  :1;
      vuint32_t I_ICONF:1;
      vuint32_t I_IMODE:1;
      vuint32_t I_SAFE:1;
      vuint32_t I_MTC:1;
    } B;
  } IS;

  union {                              /* Interrupt Mask Register */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t M_ICONF_CC:1;
      vuint32_t  :1;
      vuint32_t M_ICONF:1;
      vuint32_t M_IMODE:1;
      vuint32_t M_SAFE:1;
      vuint32_t M_MTC:1;
    } B;
  } IM;

  union {                              /* Invalid Mode Transition Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t S_MRIG:1;
      vuint32_t S_MTI:1;
      vuint32_t S_MRI:1;
      vuint32_t S_DMA:1;
      vuint32_t S_NMA:1;
      vuint32_t S_SEA:1;
    } B;
  } IMTS;

  union {                              /* Debug Mode Transition Status Register */
    vuint32_t R;
    struct {
      vuint32_t PREVIOUS_MODE:4;
      vuint32_t  :4;
      vuint32_t MPH_BUSY:1;
      vuint32_t  :2;
      vuint32_t PMC_PROG:1;
      vuint32_t DBG_MODE:1;
      vuint32_t CCKL_PROG:1;
      vuint32_t PCS_PROG:1;
      vuint32_t SMR:1;
      vuint32_t CDP_PRPH_0_255:1;      /* Clock Disable Process Pending status for Peripherals 0…255 */
      vuint32_t VREG_CSRC_SC:1;
      vuint32_t CSRC_CSRC_SC:1;
      vuint32_t IRC_SC:1;
      vuint32_t SCSRC_SC:1;
      vuint32_t SYSCLK_SW:1;
      vuint32_t  :1;
      vuint32_t FLASH_SC:1;
      vuint32_t  :4;
      vuint32_t CDP_PRPH_96_127:1;
      vuint32_t CDP_PRPH_64_95:1;
      vuint32_t CDP_PRPH_32_63:1;
      vuint32_t CDP_PRPH_0_31:1;
    } B;
  } DMTS;

  uint8_t MC_ME_reserved0[4];
  union {                              /* RESET Mode Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t PWRLVL:3;
      vuint32_t  :4;
      vuint32_t PDO:1;
      vuint32_t  :2;
      vuint32_t MVRON:1;
      vuint32_t  :2;
      vuint32_t FLAON:2;
      vuint32_t  :7;
      vuint32_t SXOSCON:1;             /* 32Khz external oscillator control */
      vuint32_t SIRCON:1;
      vuint32_t PLLON:1;
      vuint32_t FXOSCON:1;
      vuint32_t FIRCON:1;
      vuint32_t SYSCLK:4;
    } B;
  } RESET_MC;

  uint8_t MC_ME_reserved1[4];
  union {                              /* SAFE Mode Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t PWRLVL:3;
      vuint32_t  :4;
      vuint32_t PDO:1;
      vuint32_t  :2;
      vuint32_t MVRON:1;
      vuint32_t  :2;
      vuint32_t FLAON:2;
      vuint32_t  :7;
      vuint32_t SXOSCON:1;             /* 32Khz external oscillator control */
      vuint32_t SIRCON:1;
      vuint32_t PLLON:1;
      vuint32_t FXOSCON:1;
      vuint32_t FIRCON:1;
      vuint32_t SYSCLK:4;
    } B;
  } SAFE_MC;

  union {                              /* DRUN Mode Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t PWRLVL:3;
      vuint32_t  :4;
      vuint32_t PDO:1;
      vuint32_t  :2;
      vuint32_t MVRON:1;
      vuint32_t  :2;
      vuint32_t FLAON:2;
      vuint32_t  :7;
      vuint32_t SXOSCON:1;             /* 32Khz external oscillator control */
      vuint32_t SIRCON:1;
      vuint32_t PLLON:1;
      vuint32_t FXOSCON:1;
      vuint32_t FIRCON:1;
      vuint32_t SYSCLK:4;
    } B;
  } DRUN_MC;

  union {                              /* RUN0 Mode Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t PWRLVL:3;
      vuint32_t  :4;
      vuint32_t PDO:1;
      vuint32_t  :2;
      vuint32_t MVRON:1;
      vuint32_t  :2;
      vuint32_t FLAON:2;
      vuint32_t  :7;
      vuint32_t SXOSCON:1;             /* 32KHz external oscillator control */
      vuint32_t SIRCON:1;
      vuint32_t PLLON:1;
      vuint32_t FXOSCON:1;
      vuint32_t FIRCON:1;
      vuint32_t SYSCLK:4;
    } B;
  } RUN_MC[4];

  uint8_t MC_ME_reserved2[8];
  union {                              /* STOP0 Mode Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t PWRLVL:3;
      vuint32_t  :4;
      vuint32_t PDO:1;
      vuint32_t  :2;
      vuint32_t MVRON:1;
      vuint32_t  :2;
      vuint32_t FLAON:2;
      vuint32_t  :7;
      vuint32_t SXOSCON:1;             /* 32KHz external oscillator control */
      vuint32_t SIRCON:1;
      vuint32_t PLLON:1;
      vuint32_t FXOSCON:1;
      vuint32_t FIRCON:1;
      vuint32_t SYSCLK:4;
    } B;
  } STOP_MC;

  uint8_t MC_ME_reserved3[8];
  union {                              /* STANDBY0 Mode Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t PWRLVL:3;
      vuint32_t  :4;
      vuint32_t PDO:1;
      vuint32_t  :2;
      vuint32_t MVRON:1;
      vuint32_t  :2;
      vuint32_t FLAON:2;
      vuint32_t  :7;
      vuint32_t SXOSCON:1;             /* 32KHz external oscillator control */
      vuint32_t SIRCON:1;
      vuint32_t PLLON:1;
      vuint32_t FXOSCON:1;
      vuint32_t FIRCON:1;
      vuint32_t SYSCLK:4;
    } B;
  } STANDBY_MC;

  uint8_t MC_ME_reserved4[8];
  union {                              /* Peripheral Status Register 0 */
    vuint32_t R;
    struct {
      vuint32_t S_IIC_1:1;
      vuint32_t S_IIC_0:1;
      vuint32_t  :1;
      vuint32_t S_FlexRay:1;           /* Peripheral status - These bits specify the current status of each peripheral which is controlled by the MC_ME. */
      vuint32_t  :2;
      vuint32_t S_ADC_1:1;             /* Peripheral status - These bits specify the current status of each peripheral which is controlled by the MC_ME. 0: Peripheral is frozen 1: Peripheral is active. */
      vuint32_t S_ADC_0:1;             /* Peripheral status - These bits specify the current status of each peripheral which is controlled by the MC_ME. 0: Peripheral is frozen 1: Peripheral is active */
      vuint32_t  :1;
      vuint32_t S_ACMP_2:1;            /* Peripheral status - These bits specify the current status of each peripheral which is controlled by the MC_ME. 0: Peripheral is frozen 1: Peripheral is active */
      vuint32_t S_ACMP_1:1;            /* Peripheral status - These bits specify the current status of each peripheral which is controlled by the MC_ME. 0: Peripheral is frozen 1: Peripheral is active */
      vuint32_t S_ACMP_0:1;            /* Peripheral status - These bits specify the current status of each peripheral which is controlled by the MC_ME. 0: Peripheral is frozen 1: Peripheral is active */
      vuint32_t  :4;
      vuint32_t S_ENET:1;              /* Peripheral status - These bits specify the current status of each peripheral which is controlled by the MC_ME. 0: Peripheral is frozen 1: Peripheral is active */
      vuint32_t  :2;
      vuint32_t S_SAI_2:1;             /* Peripheral status - These bits specify the current status of each peripheral which is controlled by the MC_ME. 0: Peripheral is frozen 1: Peripheral is active */
      vuint32_t S_SAI_1:1;             /* Peripheral status - These bits specify the current status of each peripheral which is controlled by the MC_ME. 0: Peripheral is frozen 1: Peripheral is active. */
      vuint32_t S_SAI_0:1;             /* Peripheral status - These bits specify the current status of each peripheral which is controlled by the MC_ME. 0: Peripheral is frozen 1: Peripheral is active */
      vuint32_t  :2;
      vuint32_t  :5;
      vuint32_t S_eMIOS_1:1;           /* Peripheral status - These bits specify the current status of each peripheral which is controlled by the MC_ME. */
      vuint32_t S_eMIOS_0:1;           /* Peripheral status - These bits specify the current status of each peripheral which is controlled by the MC_ME. */
      vuint32_t S_BCTU:1;              /* Peripheral status - These bits specify the current status of each peripheral which is controlled by the MC_ME. 0: Peripheral is frozen 1: Peripheral is active */
    } B;
  } PS0;

  union {                              /* Peripheral Status Register 1 */
    vuint32_t R;
    struct {
      vuint32_t S_LIN:14;              /* Peripheral status - These bits specify the current status of each peripheral which is controlled by the MC_ME. 0: Peripheral is frozen 1: Peripheral is active */
      vuint32_t  :6;
      vuint32_t S_DSPI:4;              /* Peripheral status - These bits specify the current status of each peripheral which is controlled by the MC_ME. 0: Peripheral is frozen 1: Peripheral is active */
      vuint32_t  :6;
      vuint32_t S_IIC:2;               /* Peripheral status - These bits specify the current status of each peripheral which is controlled by the MC_ME. 0: Peripheral is frozen 1: Peripheral is active */
    } B;
  } PS1;

  union {                              /* Peripheral Status Register 2 */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t S_WKPU:1;
      vuint32_t S_LPU_CTL:1;
      vuint32_t S_PIT_RTI_0:1;
      vuint32_t S_DMAMUX:1;            /* Peripheral status - These bits specify the current status of each peripheral which is controlled by the MC_ME. */
      vuint32_t  :5;
      vuint32_t S_CRC:1;
      vuint32_t S_MEMU_0:1;
      vuint32_t S_JDC:1;
      vuint32_t S_TDM:1;
      vuint32_t  :1;
      vuint32_t  :2;
      vuint32_t S_FLEXCAN:8;
      vuint32_t  :2;
      vuint32_t  :2;
      vuint32_t S_LIN:2;
    } B;
  } PS2;

  union {                              /* Peripheral Status Register 3 */
    vuint32_t R;
    struct {
      vuint32_t  :22;
      vuint32_t S_MEMU_1:1;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t S_RTC_API:1;
      vuint32_t  :2;
      vuint32_t S_SPI:4;
    } B;
  } PS3;

  uint8_t MC_ME_reserved5[16];
  union {                              /* Run Peripheral Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t RUN3:1;
      vuint32_t RUN2:1;
      vuint32_t RUN1:1;
      vuint32_t RUN0:1;
      vuint32_t DRUN:1;
      vuint32_t SAFE:1;
      vuint32_t  :1;
      vuint32_t RESET:1;
    } B;
  } RUN_PC[8];

  union {                              /* Low-Power Peripheral Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :18;
      vuint32_t STANDBY0:1;            /* Peripheral control during STANDBY0 */
      vuint32_t  :2;
      vuint32_t STOP0:1;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t  :8;
    } B;
  } LP_PC[8];

    /* Note on PCTL registers: There are only some PCTL implemented         */
    /*  In order to make the PCTL easily addressable, these are defined     */
    /*  as an array (ie ME.PCTL[x].R). This means you have to be careful    */
    /*  when addressing these registers in order not to access a PCTL that  */
    /*  is not implemented. Following are available: 0-2, 10-12, 15, 20-25, */
    /*  28, 30-33, 40-43, 50-65, 70-77, 81-84, 90-91, 93, 96-99, 102, 105   */

  union {                              /* BCTU Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL[106];

  uint8_t MC_ME_reserved6[150];
  union {                              /* Core Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :28;
      vuint32_t S_CORE3:1;             /* Core3 Status */
      vuint32_t  :1;
      vuint32_t S_CORE1:1;
      vuint32_t  :1;
    } B;
  } CS;

  uint8_t MC_ME_reserved7[2];
  union {                              /* Core1 Control Register */
    vuint16_t R;
    struct {
      vuint16_t  :1;
      vuint16_t STANDBY0:2;
      vuint16_t  :2;
      vuint16_t STOP0:1;
      vuint16_t  :1;
      vuint16_t  :1;
      vuint16_t RUN3:1;
      vuint16_t RUN2:1;
      vuint16_t RUN1:1;
      vuint16_t RUN0:1;
      vuint16_t DRUN:1;
      vuint16_t SAFE:1;
      vuint16_t  :1;
      vuint16_t RESET:1;
    } B;
  } CCTL1;

  uint8_t MC_ME_reserved8[2];
  union {                              /* Core3 Control Register */
    vuint16_t R;
    struct {
      vuint16_t  :1;
      vuint16_t STANDBY0:2;
      vuint16_t  :2;
      vuint16_t STOP0:1;
      vuint16_t  :1;
      vuint16_t  :1;
      vuint16_t RUN3:1;
      vuint16_t RUN2:1;
      vuint16_t RUN1:1;
      vuint16_t RUN0:1;
      vuint16_t DRUN:1;
      vuint16_t SAFE:1;
      vuint16_t  :1;
      vuint16_t RESET:1;
    } B;
  } CCTL3;

  uint8_t MC_ME_reserved9[24];
  union {                              /* CORE1 Address Register */
    vuint32_t R;
    struct {
      vuint32_t ADDR:30;
      vuint32_t  :1;
      vuint32_t RMC:1;                 /* Reset on Mode Change */
    } B;
  } CADDR1;

  uint8_t MC_ME_reserved10[4];
  union {                              /* CORE3 Address Register */
    vuint32_t R;
    struct {
      vuint32_t ADDR:30;
      vuint32_t  :1;
      vuint32_t RMC:1;                 /* Reset on Mode Change */
    } B;
  } CADDR3;
};


/* ============================================================================
   =============================== Module: MC_PCU =============================
   ============================================================================ */

struct MC_PCU_tag {
  union {                              /* Power Domain #0 Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :18;
      vuint32_t STBY0:1;               /* Power domain control during STANDBY0 mode */
      vuint32_t  :2;
      vuint32_t STOP0:1;
      vuint32_t  :1;
      vuint32_t HALT0:1;
      vuint32_t RUN3:1;
      vuint32_t RUN2:1;
      vuint32_t RUN1:1;
      vuint32_t RUN0:1;
      vuint32_t DRUN:1;
      vuint32_t SAFE:1;
      vuint32_t TEST:1;
      vuint32_t RST:1;
    } B;
  } PCONF0;

  union {                              /* Power Domain #1 Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :18;
      vuint32_t STBY0:1;               /* Power domain control during STANDBY0 mode */
      vuint32_t  :2;
      vuint32_t STOP0:1;
      vuint32_t  :1;
      vuint32_t HALT0:1;
      vuint32_t RUN3:1;
      vuint32_t RUN2:1;
      vuint32_t RUN1:1;
      vuint32_t RUN0:1;
      vuint32_t DRUN:1;
      vuint32_t SAFE:1;
      vuint32_t TEST:1;
      vuint32_t RST:1;
    } B;
  } PCONF1;

  uint8_t MC_PCU_reserved0[56];
  union {                              /* Power Domain Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t PD1:1;                 /* Power status for power domain 1 */
      vuint32_t PD0:1;
    } B;
  } PSTAT;
};


/* ============================================================================
   =============================== Module: MC_RGM =============================
   ============================================================================ */

struct MC_RGM_tag {
  union {                              /* 'Destructive' Event Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :21;
      vuint32_t  :1;
      vuint32_t F_SWT1_RES:2;          /* Flag for SWT1 Reset */
      vuint32_t F_SWT0_RES:1;          /* Flag for SWT0 (Flash Initialization Failure) Reset */
      vuint32_t F_SUF:1;               /* Flag for SUF (STCU unrecoverable fault) */
      vuint32_t F_FUNC_ESC:1;          /* Flag for Functional Reset Escalation */
      vuint32_t F_SSCM_SEC:1;          /* Flag for SSCM Secure Reset Request */
      vuint32_t F_SOFT_DEST:1;         /* Flag for Software Generated Destructive Reset */
      vuint32_t F_HSM_DEST:1;          /* Flag for HSM Destructive Reset */
      vuint32_t  :1;
      vuint32_t F_POR:1;               /* Flag for Power-On Reset */
    } B;
  } DES;

  uint8_t MC_RGM_reserved0[12];
  union {                              /* 'Destructive' Event Reset Disable Register */
    vuint32_t R;
    struct {
      vuint32_t  :21;
      vuint32_t  :1;
      vuint32_t D_SWT1_RES:2;          /* Disable SWT1 Reset */
      vuint32_t D_SWT0_RES:1;          /* Disable SWT0 (Flash Initialization Failure) Reset */
      vuint32_t D_SUF:1;               /* Disable SUF (STCU unrecoverable fault) */
      vuint32_t D_FUNC_ESC:1;          /* Disable Functional Reset Escalation */
      vuint32_t D_SSCM_SEC:1;          /* Disable SSCM Secure Reset Request */
      vuint32_t D_SOFT_DEST:1;         /* Disable Software Generated Destructive Reset */
      vuint32_t D_HSM_DEST:1;          /* Disable HSM Destructive Reset */
      vuint32_t  :1;
      vuint32_t D_POR:1;               /* Disable Power-On Reset */
    } B;
  } DERD;

  uint8_t MC_RGM_reserved1[28];
  union {                              /* 'Destructive' Bidirectional Reset Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :22;
      vuint32_t  :1;
      vuint32_t BE_SWT1_RES:1;         /* Bidirectional Reset Enable for SWT1 Reset */
      vuint32_t BE_SWT0_RES:1;         /* Bidirectional Reset Enable for SWT0 (Flash Initialization Failure) Reset */
      vuint32_t BE_SUF:1;              /* Bidirectional Reset Enable for SUF (STCU unrecoverable fault) */
      vuint32_t BE_FUNC_ESC:1;         /* Bidirectional Reset Enable for Functional Reset Escalation */
      vuint32_t BE_SSCM_SEC:1;         /* Bidirectional Reset Enable for SSCM Secure Reset Request */
      vuint32_t BE_SOFT_DEST:1;        /* Bidirectional Reset Enable for Software Generated Destructive Reset */
      vuint32_t BE_HSM_DEST:1;         /* Bidirectional Reset Enable for HSM Generated Functional Reset */
      vuint32_t  :1;
      vuint32_t BE_POR:1;              /* Bidirectional Power-On Reset */
    } B;
  } DBRE;

  uint8_t MC_RGM_reserved2[716];
//  uint8_t MC_RGM_reserved2[464];
//  union {                              /* 'Functional' Event Short Sequence Register */
//    vuint32_t R;
//    struct {
//      vuint32_t  :14;
//      vuint32_t SS_PD2_LVD_COLD:1;     /* Short Sequence for PD2 LVD at Cold Point */
//      vuint32_t  :1;
//      vuint32_t  :1;
//      vuint32_t SS_HVD:1;              /* Short Sequence for High Voltage Detect IOs */
//      vuint32_t SS_LVD_IO_A_HI:1;      /* Short Sequence for Low Voltage Detect IOs */
//      vuint32_t SS_Z2_DBG:1;           /* Short Sequence for Z2 Debug Reset */
//      vuint32_t SS_Z4B_DBG:1;          /* Short Sequence for Z4B Debug Reset */
//      vuint32_t SS_Z4A_DBG:1;          /* Short Sequence for Z4A Debug Reset */
//      vuint32_t SS_FCCU_SHORT:1;       /* Short Sequence for FCCU Short Functional Reset */
//      vuint32_t SS_FCCU_LONG:1;        /* Short Sequence for FCCU Long Functional Reset */
//      vuint32_t SS_CMU_OLR:1;          /* Short Sequence for OSC Frequency less than RC */
//      vuint32_t SS_ST_DONE:1;          /* Short Sequence for Selt Test Completed */
//      vuint32_t SS_FUNC_JTAG:1;        /* Short Sequence for JTAG Functional Reset */
//      vuint32_t SS_NMI_WKPU:1;         /* Short Sequence for Non Maskable Interrupt 3 Wakeup Unit */
//      vuint32_t SS_SOFT_FUNC:1;        /* Short Sequence for Software Generated Functional Reset */
//      vuint32_t SS_HSM_FUNC:1;         /* Short Sequence for HSM Genrated Functional Reset */
//      vuint32_t  :1;
//      vuint32_t SS_EXR:1;              /* Short Sequence for External Reset */
//    } B;
//  } FESS;
//
//  uint8_t MC_RGM_reserved3[248];
  union {                              /* 'Functional' Event Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :14;
      vuint32_t F_PD2_LVD_COLD:1;   /* Flag for PD2 LVD at cold point */
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t F_HVD:1;       /* Flag for High Voltage Detect */
      vuint32_t F_LVD_IO_A_HI:1;       /* Flag for Low-Voltage Detect IOs */
      vuint32_t F_Z2_DBG:1;            /* Flag for Z2 Debug Reset */
      vuint32_t  :1;
      vuint32_t F_Z4A_DBG:1;           /* Flag for Z4A Debug Reset */
      vuint32_t F_FCCU_SHORT:1;        /* Flag for FCCU Short Functional Reset */
      vuint32_t F_FCCU_LONG:1;         /* Flag for FCCU Long Functional Reset */
      vuint32_t F_CMU_OLR:1;           /* Flag for OSC Frequency less than RC */
      vuint32_t F_ST_DONE:1;           /* Flag for Selt Test Completed */
      vuint32_t F_JTAG_FUNC:1;         /* Flag for JTAG Functional Reset */
      vuint32_t F_NMI_WKPU:1;          /* Flag for Non Maskable Interrupt from Wakeup Unit */
      vuint32_t F_SOFT_FUNC:1;         /* Flag for Software Generated Functional Reset */
      vuint32_t F_HSM_FUNC:1;          /* Flag for HSM Generated Functional Reset */
      vuint32_t  :1;
      vuint32_t F_EXR:1;               /* Flag for External Reset */
    } B;
  } FES;

  uint8_t MC_RGM_reserved4[12];
  union {                              /* 'Functional' Event Reset Disable Register */
    vuint32_t R;
    struct {
      vuint32_t  :14;
      vuint32_t D_LVD_LV_PD2_cold:1;   /* Disable PD2 LVD at cold point */
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t D_HVD_LV_cold:1;       /* Disable High Voltage Detect */
      vuint32_t D_LVD_IO_A_HI:1;       /* Disable Low Voltage Detect IOs */
      vuint32_t D_Z2_DBG:1;            /* Disable Z2 Debug Rreset */
      vuint32_t  :1;
      vuint32_t D_Z4A_DBG:1;           /* Disable Z4A Debug Reset */
      vuint32_t D_FCCU_SHORT:1;        /* Disable FCCU Short Functional Reset */
      vuint32_t D_FCCU_LONG:1;         /* Disable FCCU Long Functional Reset */
      vuint32_t D_CMU_OLR:1;           /* Disable OSC Frequency less than RC */
      vuint32_t D_ST_DONE:1;           /* Disable Selt Test Completed */
      vuint32_t D_JTAG_FUNC:1;         /* Disable JTAG Functional Reset */
      vuint32_t D_NMI_WKPU:1;          /* Disable Non Maskable Interrupt from Wakeup Unit */
      vuint32_t D_SOFT_FUNC:1;         /* Disable Software Generated Functional Reset */
      vuint32_t D_HSM_FUNC:1;          /* Disable HSM Genrated Functional Reset */
      vuint32_t  :1;
      vuint32_t D_EXR:1;               /* Disable External Reset */
    } B;
  } FERD;

  uint8_t MC_RGM_reserved5[12];
  union {                              /* 'Functional' Event Reset DisableAlternate Request Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :14;
      vuint32_t AR_LVD_LV_PD2_cold:1;  /* Alternate Request for PD2 LVD at cold point */
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t AR_HVD_LV_cold:1;      /* Alternate Request for High Voltage Detect */
      vuint32_t AR_LVD_IO_A_HI:1;      /* Alternate Request for Low Voltage Detect IOs */
      vuint32_t AR_Z2_DBG:1;           /* Alternate Request for Z2 Debug Reset */
      vuint32_t  :1;
      vuint32_t AR_Z4A_DBG:1;          /* Alternate Request for Z4A Debug Reset */
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t AR_CMU_OLR:1;          /* Alternate Request for OSC Frequency less than RC */
      vuint32_t  :1;
      vuint32_t AR_JTAG_FUNC:1;        /* Alternate Request for JTAG functional Reset */
      vuint32_t AR_NMI_WKPU:1;         /* Alternate Request for Non Maskable Interrupt from Wakeup Unit */
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t AR_EXR:1;              /* Flag for External reset */
    } B;
  } FEAR;

  uint8_t MC_RGM_reserved6[12];
  union {                              /* 'Functional' Bidirectional Reset Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :14;
      vuint32_t BE_LVD_LV_PD2_cold:1;  /* Bidirectional Reset Enable for PD2 LVD at Cold Point */
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t BE_HVD_LV_cold:1;      /* Bidirectional Reset Enable for High Voltage Detect */
      vuint32_t BE_LVD_IO_A_HI:1;      /* Bidirectional Reset Enable for Low Voltage Detect IOs */
      vuint32_t BE_Z2_DBG:1;           /* Bidirectional Reset Enable for Z2 debug reset */
      vuint32_t  :1;
      vuint32_t BE_Z4A_DBG:1;          /* Bidirectional Reset Enable for Z4A Debug Reset */
      vuint32_t BE_FCCU_SHORT:1;       /* Bidirectional Reset Enable for FCCU Short Functional Reset */
      vuint32_t BE_FCCU_LONG:1;        /* Bidirectional Reset Enable for FCCU Long Functional Reset */
      vuint32_t BE_CMU_OLR:1;          /* Bidirectional Reset Enable for OSC Frequency less than RC */
      vuint32_t BE_ST_DONE:1;          /* Bidirectional Reset Enable for Selt Test Completed */
      vuint32_t BE_JTAG_FUNC:1;        /* Bidirectional Reset Enable for JTAG Function */
      vuint32_t BE_NMI_WKPU:1;         /* Bidirectional Reset Enable for Non Maskable Interrupt from Wakeup Unit */
      vuint32_t BE_SOFT_FUNC:1;        /* Bidirectional Reset Enable for Software Generated Functional Reset */
      vuint32_t BE_HSM_FUNC:1;         /* Bidirectional Reset Enable for HSM Generated Functional Reset */
      vuint32_t  :1;
      vuint32_t BE_EXR:1;              /* Flag for External Reset */
    } B;
  } FBRE;


 uint8_t MC_RGM_reserved7[12];
  union {                              /* 'Functional' Event Short Sequence Register */
    vuint32_t R;
    struct {
      vuint32_t  :15;
      vuint32_t SS_PLL_FOVR:1;         /* Short Sequence for PLL Frequency Overshoot */
      vuint32_t  :1;
      vuint32_t SS_HVD:1;              /* Short Sequence for High Voltage Detect IOs */
      vuint32_t SS_LVD_IO:1;           /* Short Sequence for Low Voltage Detect IOs */
      vuint32_t SS_Z2_DBG:1;           /* Short Sequence for Z2 Debug Reset */
      vuint32_t SS_Z4B_DBG:1;          /* Short Sequence for Z4B Debug Reset */
      vuint32_t SS_Z4A_DBG:1;          /* Short Sequence for Z4A Debug Reset */
      vuint32_t SS_FCCU_SHORT:1;       /* Short Sequence for FCCU Short Functional Reset */
      vuint32_t SS_FCCU_LONG:1;        /* Short Sequence for FCCU Long Functional Reset */
      vuint32_t SS_CMU_OLR:1;          /* Short Sequence for OSC Frequency less than RC */
      vuint32_t SS_ST_DONE:1;          /* Short Sequence for Selt Test Completed */
      vuint32_t SS_FUNC_JTAG:1;        /* Short Sequence for JTAG Functional Reset */
      vuint32_t SS_NMI_WKPU:1;         /* Short Sequence for Non Maskable Interrupt 3 Wakeup Unit */
      vuint32_t SS_SOFT_FUNC:1;        /* Short Sequence for Software Generated Functional Reset */
      vuint32_t SS_HSM_FUNC:1;         /* Short Sequence for HSM Genrated Functional Reset */
      vuint32_t  :1;
      vuint32_t SS_EXR:1;              /* Short Sequence for External Reset */
    } B;
  } FESS;
  
  //uint8_t MC_RGM_reserved7[720];
  uint8_t MC_RGM_reserved8[704];

  union {                              /* 'Functional' Reset Escalation Threshold Register */
    vuint8_t R;
    struct {
      vuint8_t  :4;
      vuint8_t FRET:4;
    } B;
  } FRET;

  uint8_t MC_RGM_reserved9[3];
  union {                              /* 'Destructive' Reset Escalation Threshold Register */
    vuint8_t R;
    struct {
      vuint8_t  :4;
      vuint8_t DRET:4;
    } B;
  } DRET;
};


/* ============================================================================
   =============================== Module: MEMU ===============================
   ============================================================================ */

struct MEMU_0_tag {
  union {                              /* Control register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SWR:1;
      vuint32_t  :15;
    } B;
  } CTRL;

  union {                              /* Error flag register */
    vuint32_t R;
    struct {
      vuint32_t  :11;
      vuint32_t PR_CE:1;
      vuint32_t PR_UCE:1;
      vuint32_t PR_CEO:1;
      vuint32_t PR_UCO:1;
      vuint32_t PR_EBO:1;
      vuint32_t  :3;
      vuint32_t F_CE:1;
      vuint32_t F_UCE:1;
      vuint32_t F_CEO:1;
      vuint32_t F_UCO:1;
      vuint32_t F_EBO:1;
      vuint32_t  :3;
      vuint32_t SR_CE:1;
      vuint32_t SR_UCE:1;
      vuint32_t SR_CEO:1;
      vuint32_t SR_UCO:1;
      vuint32_t SR_EBO:1;
    } B;
  } ERR_FLAG;

  uint8_t MEMU_reserved0[4];
  union {                              /* Debug register */
    vuint32_t R;
    struct {
      vuint32_t  :11;
      vuint32_t FR_PR_CE:1;
      vuint32_t FR_PR_UCE:1;
      vuint32_t FR_PR_CEO:1;
      vuint32_t FR_PR_UCO:1;
      vuint32_t FR_PR_EBO:1;
      vuint32_t  :3;
      vuint32_t FR_F_CE:1;
      vuint32_t FR_F_UCE:1;
      vuint32_t FR_F_CEO:1;
      vuint32_t FR_F_UCO:1;
      vuint32_t FR_F_EBO:1;
      vuint32_t  :3;
      vuint32_t FR_SR_CE:1;
      vuint32_t FR_SR_UCE:1;
      vuint32_t FR_SR_CEO:1;
      vuint32_t FR_SR_UCO:1;
      vuint32_t FR_SR_EBO:1;
    } B;
  } DEBUG;

  uint8_t MEMU_reserved1[16];
  struct {
    union {                            /* System RAM correctable error reporting table status register */
      vuint32_t R;
      struct {
        vuint32_t VLD:1;
        vuint32_t  :23;
        vuint32_t BAD_BIT:8;
      } B;
    } STS;
    union {                            /* System RAM correctable error reporting table address register */
      vuint32_t R;
      struct {
        vuint32_t ERR_ADD:32;
      } B;
    } ADDR;
  } SYS_RAM_CERR[10];

  union {                              /* System RAM uncorrectable error reporting table status register */
    vuint32_t R;
    struct {
      vuint32_t VLD:1;
      vuint32_t  :31;
    } B;
  } SYS_RAM_UNCERR_STS;

  union {                              /* System RAM uncorrectable error reporting table address register */
    vuint32_t R;
    struct {
      vuint32_t ERR_ADD:32;
    } B;
  } SYS_RAM_UNCERR_ADDR;

  union {                              /* System RAM concurrent overflow register */
    vuint32_t R;
    struct {
      vuint32_t OFLW:32;
    } B;
  } SYS_RAM_OFLW;

  uint8_t MEMU_reserved2[1444];
  struct {
    union {                            /* Peripheral RAM correctable error reporting table status register */
      vuint32_t R;
      struct {
        vuint32_t VLD:1;
        vuint32_t  :23;
        vuint32_t BAD_BIT:8;
      } B;
    } STS;
    union {                            /* Peripheral RAM correctable error reporting table address register */
      vuint32_t R;
      struct {
        vuint32_t ERR_ADD:32;
      } B;
    } ADDR;
  } PERIPH_RAM_CERR[2];

  union {                              /* Peripheral RAM uncorrectable error reporting table status register */
    vuint32_t R;
    struct {
      vuint32_t VLD:1;
      vuint32_t  :31;
    } B;
  } PERIPH_RAM_UNCERR_STS;

  union {                              /* Peripheral RAM uncorrectable error reporting table address register */
    vuint32_t R;
    struct {
      vuint32_t ERR_ADD:32;
    } B;
  } PERIPH_RAM_UNCERR_ADDR;

  union {                              /* Peripheral RAM concurrent overflow register */
    vuint32_t R;
    struct {
      vuint32_t OFLW:32;
    } B;
  } PERIPH_RAM_OFLW;

  uint8_t MEMU_reserved3[1508];
  struct {
    union {                            /* Flash memory correctable error reporting table status register */
      vuint32_t R;
      struct {
        vuint32_t VLD:1;
        vuint32_t  :23;
        vuint32_t BAD_BIT:8;
      } B;
    } STS;
    union {                            /* Flash memory correctable error reporting table address register */
      vuint32_t R;
      struct {
        vuint32_t ERR_ADD:32;
      } B;
    } ADDR;
  } FLASH_CERR[20];

  union {                              /* Flash memory uncorrectable error reporting table status register */
    vuint32_t R;
    struct {
      vuint32_t VLD:1;
      vuint32_t  :31;
    } B;
  } FLASH_UNCERR_STS;

  union {                              /* Flash memory uncorrectable error reporting table address register */
    vuint32_t R;
    struct {
      vuint32_t ERR_ADD:32;
    } B;
  } FLASH_UNCERR_ADDR;

  union {                              /* Flash memory concurrent overflow register */
    vuint32_t R;
    struct {
      vuint32_t OFLW:32;
    } B;
  } FLASH_OFLW;
};

struct MEMU_1_tag {
  union {                              /* Control register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SWR:1;
      vuint32_t  :15;
    } B;
  } CTRL;

  union {                              /* Error flag register */
    vuint32_t R;
    struct {
      vuint32_t  :11;
      vuint32_t PR_CE:1;
      vuint32_t PR_UCE:1;
      vuint32_t PR_CEO:1;
      vuint32_t PR_UCO:1;
      vuint32_t PR_EBO:1;
      vuint32_t  :3;
//_Ignore_  
      vuint32_t F_CE:1;
      vuint32_t F_UCE:1;
      vuint32_t F_CEO:1;
      vuint32_t F_UCO:1;
      vuint32_t F_EBO:1;
//_Ignore_  	  
      vuint32_t  :3;
      vuint32_t SR_CE:1;
      vuint32_t SR_UCE:1;
      vuint32_t SR_CEO:1;
      vuint32_t SR_UCO:1;
      vuint32_t SR_EBO:1;
    } B;
  } ERR_FLAG;

  uint8_t MEMU_reserved0[4];
  union {                              /* Debug register */
    vuint32_t R;
    struct {
      vuint32_t  :11;
      vuint32_t FR_PR_CE:1;
      vuint32_t FR_PR_UCE:1;
      vuint32_t FR_PR_CEO:1;
      vuint32_t FR_PR_UCO:1;
      vuint32_t FR_PR_EBO:1;
      vuint32_t  :3;
//_Ignore_  	  
      vuint32_t FR_F_CE:1;
      vuint32_t FR_F_UCE:1;
      vuint32_t FR_F_CEO:1;
      vuint32_t FR_F_UCO:1;
      vuint32_t FR_F_EBO:1;
//_Ignore_  	  
      vuint32_t  :3;
      vuint32_t FR_SR_CE:1;
      vuint32_t FR_SR_UCE:1;
      vuint32_t FR_SR_CEO:1;
      vuint32_t FR_SR_UCO:1;
      vuint32_t FR_SR_EBO:1;
    } B;
  } DEBUG;

  uint8_t MEMU_reserved1[16];
  struct {
    union {                            /* System RAM correctable error reporting table status register */
      vuint32_t R;
      struct {
        vuint32_t VLD:1;
        vuint32_t  :23;
        vuint32_t BAD_BIT:8;
      } B;
    } STS;
    union {                            /* System RAM correctable error reporting table address register */
      vuint32_t R;
      struct {
        vuint32_t ERR_ADD:32;
      } B;
    } ADDR;
//_Ignore_
  } SYS_RAM_CERR[3];   //It was always wrong
//_Ignore_

  union {                              /* System RAM uncorrectable error reporting table status register */
    vuint32_t R;
    struct {
      vuint32_t VLD:1;
      vuint32_t  :31;
    } B;
  } SYS_RAM_UNCERR_STS;

  union {                              /* System RAM uncorrectable error reporting table address register */
    vuint32_t R;
    struct {
      vuint32_t ERR_ADD:32;
    } B;
  } SYS_RAM_UNCERR_ADDR;

  union {                              /* System RAM concurrent overflow register */
    vuint32_t R;
    struct {
      vuint32_t OFLW:32;
    } B;
  } SYS_RAM_OFLW; // Remove array definition...
  
//_Ignore_
  uint8_t MEMU_reserved2[1500];
//_Ignore_
  
  struct {
    union {                            /* Peripheral RAM correctable error reporting table status register */
      vuint32_t R;
      struct {
        vuint32_t VLD:1;
        vuint32_t  :23;
        vuint32_t BAD_BIT:8;
      } B;
    } STS;
    union {                            /* Peripheral RAM correctable error reporting table address register */
      vuint32_t R;
      struct {
        vuint32_t ERR_ADD:32;
      } B;
    } ADDR;
//_Ignore_
  } PERIPH_RAM_CERR[1];   //It was always wrong... 
//_Ignore_

  union {                              /* Peripheral RAM uncorrectable error reporting table status register */
    vuint32_t R;
    struct {
      vuint32_t VLD:1;
      vuint32_t  :31;
    } B;
  } PERIPH_RAM_UNCERR_STS;

  union {                              /* Peripheral RAM uncorrectable error reporting table address register */
    vuint32_t R;
    struct {
      vuint32_t ERR_ADD:32;
    } B;
  } PERIPH_RAM_UNCERR_ADDR;

  union {                              /* Peripheral RAM concurrent overflow register */
    vuint32_t R;
    struct {
      vuint32_t OFLW:32;
    } B;
//_Ignore_
  } PERIPH_RAM_OFLW;
//_Ignore_

//_Ignore_
  uint8_t MEMU_reserved3[1508];
  struct {
    union {                            /* Flash memory correctable error reporting table status register */
      vuint32_t R;
      struct {
        vuint32_t VLD:1;
        vuint32_t  :23;
        vuint32_t BAD_BIT:8;
      } B;
    } STS;
    union {                            /* Flash memory correctable error reporting table address register */
      vuint32_t R;
      struct {
        vuint32_t ERR_ADD:32;
      } B;
    } ADDR;
  } FLASH_CERR[20];

  union {                              /* Flash memory uncorrectable error reporting table status register */
    vuint32_t R;
    struct {
      vuint32_t VLD:1;
      vuint32_t  :31;
    } B;
  } FLASH_UNCERR_STS;

  union {                              /* Flash memory uncorrectable error reporting table address register */
    vuint32_t R;
    struct {
      vuint32_t ERR_ADD:32;
    } B;
  } FLASH_UNCERR_ADDR;

  union {                              /* Flash memory concurrent overflow register */
    vuint32_t R;
    struct {
      vuint32_t OFLW:32;
    } B;
  } FLASH_OFLW0;
//_Ignore_
  
};
//Missing MLB title...

struct MLB_tag {
  union {                              /* MediaLB Control 0 Register */
    vuint32_t R;
    struct {
      vuint32_t  :14;                  /* Not to be written by user. */
      vuint32_t FCT:3;
      vuint32_t CTLRETRY:1;
      vuint32_t  :1;                   /* Not to be written by user. */
      vuint32_t ASYRETRY:1;
      vuint32_t  :4;                   /* Not to be written by user. */
      vuint32_t MLBLK:1;
      vuint32_t  :1;                   /* Not to be written by user. */
      vuint32_t MLBPEN:1;
      vuint32_t MCK:3;
      vuint32_t  :1;                   /* Not to be written by user. */
      vuint32_t MLBEN:1;
    } B;
  } C0;
  
//_Ignore_
  uint8_t MLB_reserved0[8];
//_Ignore_
  
  union {                              /* MediaLB Channel Status 0 Register */
    vuint32_t R;
    struct {
      vuint32_t MCS:32;
    } B;
  } MS0;

  uint8_t MLB_reserved1[4];
  union {                              /* MediaLB Channel Status1 Register */
    vuint32_t R;
    struct {
      vuint32_t MCS:32;
    } B;
  } MS1;

  uint8_t MLB_reserved2[8];
  union {                              /* MediaLB System Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :26;                  /* Not to be written by user. */
      vuint32_t SERVREQ:1;
      vuint32_t SWSYSCMD:1;
      vuint32_t CSSYSCMD:1;
      vuint32_t UKSYSCMD:1;
      vuint32_t LKSYSCMD:1;
      vuint32_t RSTSYCMD:1;
    } B;
  } MSS;

  union {                              /* MediaLB System Data Register */
    vuint32_t R;
    struct {
      vuint32_t SD3:8;
      vuint32_t SD2:8;
      vuint32_t SD1:8;
      vuint32_t SD0:8;
    } B;
  } MSD;

  uint8_t MLB_reserved3[4];
  union {                              /* MediaLB Interrupt Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :2;                   /* Not to be written by user. */
      vuint32_t CTX_BRK:1;
      vuint32_t CTX_PE:1;
      vuint32_t CTX_DONE:1;
      vuint32_t CRX_BRK:1;
      vuint32_t CRX_PE:1;
      vuint32_t CRX_DONE:1;
      vuint32_t  :1;                   /* Not to be written by user. */
      vuint32_t ATX_BRK:1;
      vuint32_t ATX_PE:1;
      vuint32_t ATX_DONE:1;
      vuint32_t ARX_BRK:1;
      vuint32_t ARX_PE:1;
      vuint32_t ARX_DONE:1;
      vuint32_t SYNC_PE:1;
      vuint32_t  :14;                  /* Not to be written by user. */
      vuint32_t ISOC_BFO:1;
      vuint32_t ISOC_PE:1;
    } B;
  } MIEN;
  
//_Ignore_
  uint8_t MLB_reserved4[12];
//_Ignore_
  
  union {                              /* MediaLB Control 1 Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;                  /* Not to be written by user. */
      vuint32_t NDA:8;
      vuint32_t CLKM:1;
      vuint32_t LOCK:1;
      vuint32_t  :6;                   /* Not to be written by user. */
    } B;
  } C1;
  
//_Ignore_
  uint8_t MLB_reserved5[64];
//_Ignore_
  
  union {                              /* HBI Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;                  /* Not to be written by user. */
      vuint32_t EN:1;
      vuint32_t  :13;                  /* Not to be written by user. */
      vuint32_t RST1:1;
      vuint32_t RST0:1;
    } B;
  } HCTL;
  
//_Ignore_
  uint8_t MLB_reserved6[4];
//_Ignore_
  
  union {                              /* HBI Channel Mask 0 Register */
    vuint32_t R;
    struct {
      vuint32_t CM:32;
    } B;
  } HCMR0;

  union {                              /* HBI Channel Mask 1 Register */
    vuint32_t R;
    struct {
      vuint32_t C:32;
    } B;
  } HCMR1;

  union {                              /* HBI Channel Error 0 Register */
    vuint32_t R;
    struct {
      vuint32_t CE:32;
    } B;
  } HCER0;

  union {                              /* HBI Channel Error 1 Register */
    vuint32_t R;
    struct {
      vuint32_t E:32;
    } B;
  } HCER1;

  union {                              /* HBI Channel Busy 0 Register */
    vuint32_t R;
    struct {
      vuint32_t CB:32;
    } B;
  } HCBR0;

  union {                              /* HBI Channel Busy 1 Register */
    vuint32_t R;
    struct {
      vuint32_t B:32;
    } B;
  } HCBR1;
  
//_Ignore_
  uint8_t MLB_reserved7[32];
//_Ignore_
  
  union {                              /* MIF Data 0 Register */
    vuint32_t R;
    struct {
      vuint32_t D:32;
    } B;
  } MDAT0;

  union {                              /* MIF Data 1 Register */
    vuint32_t R;
    struct {
      vuint32_t D:32;
    } B;
  } MDAT1;

  union {                              /* MIF Data 2 Register */
    vuint32_t R;
    struct {
      vuint32_t D:32;
    } B;
  } MDAT2;

  union {                              /* MIF Data 3 Register */
    vuint32_t R;
    struct {
      vuint32_t D:32;
    } B;
  } MDAT3;

  union {                              /* MIF Data Write Enable 0 Register */
    vuint32_t R;
    struct {
      vuint32_t M:32;
    } B;
  } MDWE0;

  union {                              /* MIF Data Write Enable 1 Register */
    vuint32_t R;
    struct {
      vuint32_t M:32;
    } B;
  } MDWE1;

  union {                              /* MIF Data Write Enable 2 Register */
    vuint32_t R;
    struct {
      vuint32_t M:32;
    } B;
  } MDWE2;

  union {                              /* MIF Data Write Enable 3 Register */
    vuint32_t R;
    struct {
      vuint32_t M:32;
    } B;
  } MDWE3;

  union {                              /* MIF Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :31;                  /* Not to be written by user. */
      vuint32_t XCMP:1;
    } B;
  } MCTL;

  union {                              /* MIF Address Register */
    vuint32_t R;
    struct {
      vuint32_t WNR:1;
      vuint32_t TB:1;
      vuint32_t  :16;                  /* Not to be written by user. */
      vuint32_t ADDR:6;
      vuint32_t ADR:8;
    } B;
  } MADR;
  
//_Ignore_
  uint8_t MLB_reserved8[728];
//_Ignore_
  
  union {                              /* AHB Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :27;                  /* Not to be written by user. */
      vuint32_t MPB:1;
      vuint32_t  :1;                   /* Not to be written by user. */
      vuint32_t DMA_MODE:1;
      vuint32_t SMX:1;
      vuint32_t SCE:1;
    } B;
  } ACTL;
  
//_Ignore_
  uint8_t MLB_reserved9[12];
//_Ignore_  

  union {                              /* AHB Channel Status 0 Register */
    vuint32_t R;
    struct {
      vuint32_t INTS_LOG:32;
    } B;
  } ACSR0;

  union {                              /* AHB Channel Status 1 Register */
    vuint32_t R;
    struct {
      vuint32_t L:32;
    } B;
  } ACSR1;

  union {                              /* AHB Channel Mask 0 Register */
    vuint32_t R;
    struct {
      vuint32_t CM:32;
    } B;
  } ACMR0;

  union {                              /* AHB Channel Mask 1 Register */
    vuint32_t R;
    struct {
      vuint32_t CHM:32;
    } B;
  } ACMR1;
};
/* ============================================================================
   =============================== Module: PASS ===============================
   ============================================================================ */

struct PASS_tag {
  union {                              /* Life Cycle Status Register */
    vuint32_t R;
    struct {
      vuint32_t CNS:1;
      vuint32_t JUN:1;
      vuint32_t FBE:1;
      vuint32_t  :26;
      vuint32_t LIFE:3;
    } B;
  } LCSTAT;

  uint8_t PASS_reserved0[4];
  union {                              /* Challenge Selector Register */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t GRP:2;
    } B;
  } CHSEL;

  uint8_t PASS_reserved1[4];
  union {                              /* Challenge Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :28;
      vuint32_t CMST:4;
    } B;
  } CSTAT;

  uint8_t PASS_reserved2[12];
  union {                              /* Challenge Input Register */
    vuint32_t R;
    struct {
      vuint32_t PW32:32;
    } B;
  } CIN[8];

  uint8_t PASS_reserved3[192];
  struct {
    union {                            /* Password Group n - Lock 0 Status Register */
      vuint32_t R;
      struct {
        vuint32_t TSLOCK:1;
        vuint32_t ATSL:1;
        vuint32_t LOWLOCK:14;
        vuint32_t MIDLOCK:16;
      } B;
    } LOCK0;
    union {                            /* Password Group n - Lock 1 Status Register */
      vuint32_t R;
      struct {
        vuint32_t  :16;
        vuint32_t HIGHLOCK:16;
      } B;
    } LOCK1;
    union {                            /* Password Group n - Lock 2 Status Register */
      vuint32_t R;
      struct {
        vuint32_t L_256LCK:32;
      } B;
    } LOCK2;
    union {                            /* Password Group n - Lock 3 Status Register */
      vuint32_t R;
      struct {
        vuint32_t PGL:1;
        vuint32_t DBL:1;
        vuint32_t MO:1;
        vuint32_t  :1;
        vuint32_t MSTR:4;
        vuint32_t  :3;
        vuint32_t RL4:1;
        vuint32_t RL3:1;
        vuint32_t RL2:1;
        vuint32_t RL1:1;
        vuint32_t RL0:1;
        vuint32_t U_256LCK:16;
      } B;
    } LOCK3;
  } PG[4];
};


/* ============================================================================
   =============================== Module: PCM ================================
   ============================================================================ */

struct PCM_tag {
  union {                              /* Bus Bridge Configuration Register 0 */
    vuint32_t R;
    struct {
      vuint32_t  :5;
      vuint32_t PRE_FLX:1;             /* Pending read enable (PRE) FLX */
      vuint32_t BRE_FLX:1;             /* Burst read enable (BRE) FLX */
      vuint32_t BWE_FLX:1;             /* Burst Write Enable */
      vuint32_t  :5;
      vuint32_t PRE_ENET:1;            /* Pending Read Enable ENET */
      vuint32_t BRE_ENET:1;            /* Burst read enable (BRE) ENET */
      vuint32_t BWE_ENET:1;            /* Burst Write Enable ENET */
      vuint32_t  :5;
      vuint32_t PRE_DMA:1;             /* Pending read enable (PRE) DMA */
      vuint32_t BRE_DMA:1;             /* Burst read enable (BRE) DMA */
      vuint32_t BWE_DMA:1;             /* Burst write enable (BWE) DMA */
      vuint32_t  :8;
    } B;
  } IAHB_BE0;

  union {                              /* Bus Bridge Configuration Register 1 */
    vuint32_t R;
    struct {
      vuint32_t  :5;
      vuint32_t PRE_PBRIDGE_A:1;       /* Pending read enable (PRE) PBRIDGE_A */
      vuint32_t BRE_PBRIDGE_A:1;       /* Burst read enable (BRE) PBRIDGE_A */
      vuint32_t BWE_PBRIDGE_A:1;       /* Burst Write Enable PBRIDGE_A */
      vuint32_t  :5;
      vuint32_t PRE_PBRIDGE_B:1;       /* Pending Read Enable PBRIDGE_B */
      vuint32_t BRE_PBRIDGE_B:1;       /* Burst read enable (BRE) PBRIDGE_B */
      vuint32_t BWE_PBRIDGE_B:1;       /* Burst Write Enable PBRIDGE_B */
      vuint32_t  :5;
      vuint32_t PRE_Z2_DATA:1;         /* Pending read enable (PRE) Z2_DATA */
      vuint32_t BRE_Z2_DATA:1;         /* Burst read enable (BRE) Z2_DATA */
      vuint32_t BWE_Z2_DATA:1;         /* Burst write enable (BWE) Z2_DATA */
      vuint32_t  :5;
      vuint32_t PRE_Z2_INST:1;         /* Pending read enable (PRE) Z2_INST */
      vuint32_t BRE_Z2_INST:1;         /* Burst read enable (BRE) Z2_INST */
      vuint32_t BWE_Z2_INST:1;         /* Burst write enable (BWE) Z2_INST */
    } B;
  } IAHB_BE1;

  uint8_t PCM_reserved0[8];
  union {                              /* IPS Clock Gating Module Enable 0 Register */
    vuint32_t R;
    struct {
      vuint32_t  :11;
      vuint32_t IPS_CGM_INTC:1;        /* IPS clock gating enable for INTC */
      vuint32_t  :3;
      vuint32_t IPS_CGM_SMPU_0:1;
      vuint32_t  :3;
      vuint32_t IPS_CGM_AXBS_0:1;      /* IPS clock gating enable for AXBS_0 */
      vuint32_t  :3;
      vuint32_t IPS_CGM_PRAM1:1;       /* IPS clock gating enable for PRAM1 */
      vuint32_t  :3;
      vuint32_t IPS_CGM_PRAM0:1;       /* IPS clock gating enable for PRAM0 */
      vuint32_t  :3;
      vuint32_t IPS_CGM_FLASH:1;       /* IPS clock gating enable for PFlash Controller */
    } B;
  } IPS_CGM_EN0;
};


/* ============================================================================
   =============================== Module: PFLASH =============================
   ============================================================================ */

struct PFLASH_tag {
  union {                              /* Platform Flash Configuration Register 1 */
    vuint32_t R;
    struct {
      vuint32_t P0_M15PFE:1;
      vuint32_t P0_M14PFE:1;
      vuint32_t P0_M13PFE:1;
      vuint32_t P0_M12PFE:1;
      vuint32_t P0_M11PFE:1;
      vuint32_t P0_M10PFE:1;
      vuint32_t P0_M9PFE:1;
      vuint32_t P0_M8PFE:1;
      vuint32_t P0_M7PFE:1;
      vuint32_t P0_M6PFE:1;
      vuint32_t P0_M5PFE:1;
      vuint32_t P0_M4PFE:1;
      vuint32_t P0_M3PFE:1;
      vuint32_t P0_M2PFE:1;
      vuint32_t P0_M1PFE:1;
      vuint32_t P0_M0PFE:1;
      vuint32_t APC:3;
      vuint32_t RWSC:5;
      vuint32_t  :1;
      vuint32_t P0_DPFEN:1;
      vuint32_t  :1;
      vuint32_t P0_IPFEN:1;
      vuint32_t  :1;
      vuint32_t P0_PFLIM:2;
      vuint32_t P0_BFEN:1;
    } B;
  } PFCR1;

  union {                              /* Platform Flash Configuration Register 2 */
    vuint32_t R;
    struct {
      vuint32_t P1_M15PFE:1;
      vuint32_t P1_M14PFE:1;
      vuint32_t P1_M13PFE:1;
      vuint32_t P1_M12PFE:1;
      vuint32_t P1_M11PFE:1;
      vuint32_t P1_M10PFE:1;
      vuint32_t P1_M9PFE:1;
      vuint32_t P1_M8PFE:1;
      vuint32_t P1_M7PFE:1;
      vuint32_t P1_M6PFE:1;
      vuint32_t P1_M5PFE:1;
      vuint32_t P1_M4PFE:1;
      vuint32_t P1_M3PFE:1;
      vuint32_t P1_M2PFE:1;
      vuint32_t P1_M1PFE:1;
      vuint32_t P1_M0PFE:1;
      vuint32_t  :9;
      vuint32_t P1_DPFEN:1;
      vuint32_t  :1;
      vuint32_t P1_IPFEN:1;
      vuint32_t  :1;
      vuint32_t P1_PFLIM:2;
      vuint32_t P1_BFEN:1;
    } B;
  } PFCR2;

  union {                              /* Platform Flash Configuration Register 3 */
    vuint32_t R;
    struct {
      vuint32_t P0_WCFG:2;
      vuint32_t P1_WCFG:2;
      vuint32_t P2_WCFG:2;
      vuint32_t  :5;
      vuint32_t  :1;
      vuint32_t  :3;
      vuint32_t BAF_DIS:1;
      vuint32_t ARBM:4;                /* Arbitration Mode. This 4-bit field controls the arbitration of concurrent flash access requests from the three AHB ports of the flash memory controller. In both fixed priority or round-robin modes, write requests are prioritized higher than read requests, and read requests are prioritized higher than speculative prefetch requests whenever multiple ports issue concurrent requests. This field is initialized by hardware reset. Specifying a reserved value in this field causes it to default to round-robin arbitration. */
      vuint32_t  :11;
      vuint32_t  :1;
    } B;
  } PFCR3;

  union {                              /* Platform Flash Access Protection Register */
    vuint32_t R;
    struct {
      vuint32_t M0AP:2;
      vuint32_t M1AP:2;
      vuint32_t M2AP:2;
      vuint32_t M3AP:2;
      vuint32_t M4AP:2;
      vuint32_t M5AP:2;
      vuint32_t M6AP:2;
      vuint32_t M7AP:2;
      vuint32_t M8AP:2;
      vuint32_t M9AP:2;
      vuint32_t M10AP:2;
      vuint32_t M11AP:2;
      vuint32_t M12AP:2;
      vuint32_t M13AP:2;
      vuint32_t M14AP:2;
      vuint32_t M15AP:2;
    } B;
  } PFAPR;

  union {                              /* Platform Flash Remap Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :23;
      vuint32_t SAFE_CAL:1;
      vuint32_t  :3;
      vuint32_t IRMEN:1;
      vuint32_t  :3;
      vuint32_t GRMEN:1;
    } B;
  } PFCRCR;

  union {                              /* Platform Flash Remap Descriptor Enable Register */
    vuint32_t R;
    struct {
      vuint32_t CRD0EN:1;
      vuint32_t CRD1EN:1;
      vuint32_t CRD2EN:1;
      vuint32_t CRD3EN:1;
      vuint32_t CRD4EN:1;
      vuint32_t CRD5EN:1;
      vuint32_t CRD6EN:1;
      vuint32_t CRD7EN:1;
      vuint32_t CRD8EN:1;
      vuint32_t CRD9EN:1;
      vuint32_t CRD10EN:1;
      vuint32_t CRD11EN:1;
      vuint32_t CRD12EN:1;
      vuint32_t CRD13EN:1;
      vuint32_t CRD14EN:1;
      vuint32_t CRD15EN:1;
      vuint32_t CRD16EN:1;
      vuint32_t CRD17EN:1;
      vuint32_t CRD18EN:1;
      vuint32_t CRD19EN:1;
      vuint32_t CRD20EN:1;
      vuint32_t CRD21EN:1;
      vuint32_t CRD22EN:1;
      vuint32_t CRD23EN:1;
      vuint32_t CRD24EN:1;
      vuint32_t CRD25EN:1;
      vuint32_t CRD26EN:1;
      vuint32_t CRD27EN:1;
      vuint32_t CRD28EN:1;
      vuint32_t CRD29EN:1;
      vuint32_t CRD30EN:1;
      vuint32_t CRD31EN:1;
    } B;
  } PFCRDE;

  union {                              /* Platform Flash Configuration Register 4 */
    vuint32_t R;
    struct {
      vuint32_t P2_M15PFE:1;
      vuint32_t P2_M14PFE:1;
      vuint32_t P2_M13PFE:1;
      vuint32_t P2_M12PFE:1;
      vuint32_t P2_M11PFE:1;
      vuint32_t P2_M10PFE:1;
      vuint32_t P2_M9PFE:1;
      vuint32_t P2_M8PFE:1;
      vuint32_t P2_M7PFE:1;
      vuint32_t P2_M6PFE:1;
      vuint32_t P2_M5PFE:1;
      vuint32_t P2_M4PFE:1;
      vuint32_t P2_M3PFE:1;
      vuint32_t P2_M2PFE:1;
      vuint32_t P2_M1PFE:1;
      vuint32_t P2_M0PFE:1;
      vuint32_t  :9;
      vuint32_t P2_DPFEN:1;
      vuint32_t  :1;
      vuint32_t P2_IPFEN:1;
      vuint32_t  :1;
      vuint32_t P2_PFLIM:2;
      vuint32_t P2_BFEN:1;
    } B;
  } PFCR4;

  uint8_t PFLASH_reserved0[228];
  struct {
    union {                            /* Platform Flash Calibration Region Descriptor n Word0 */
      vuint32_t R;
      struct {
        vuint32_t LSTARTADDR:32;
      } B;
    } Word0;
    union {                            /* Platform Flash Calibration Region Descriptor n Word1 */
      vuint32_t R;
      struct {
        vuint32_t PSTARTADDR:32;
      } B;
    } Word1;
    union {                            /* Platform Flash Calibration Region Descriptor n Word2 */
      vuint32_t R;
      struct {
        vuint32_t M0EN:1;
        vuint32_t M1EN:1;
        vuint32_t M2EN:1;
        vuint32_t M3EN:1;
        vuint32_t M4EN:1;
        vuint32_t M5EN:1;
        vuint32_t M6EN:1;
        vuint32_t M7EN:1;
        vuint32_t M8EN:1;
        vuint32_t M9EN:1;
        vuint32_t M10EN:1;
        vuint32_t M11EN:1;
        vuint32_t M12EN:1;
        vuint32_t M13EN:1;
        vuint32_t M14EN:1;
        vuint32_t M15EN:1;
        vuint32_t  :11;
        vuint32_t CRDSize:5;
      } B;
    } Word2;
    uint8_t PFCRD_reserved0[4];
  } PFCRD[8];
};


/* ============================================================================
   =============================== Module: PIT ================================
   ============================================================================ */

struct PIT_tag {
  union {                              /* PIT Module Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t MDIS_RTI:1;            /* Module Disable - RTI section */
      vuint32_t MDIS:1;                /* Module Disable - (PIT section) */
      vuint32_t FRZ:1;                 /* Freeze */
    } B;
  } MCR;

  uint8_t PIT_reserved0[236];
  union {                              /* Timer Load Value Register */
    vuint32_t R;
    struct {
      vuint32_t TSV:32;                /* Timer Start Value */
    } B;
  } RTI_LDVAL;

  union {                              /* Current Timer Value Register */
    vuint32_t R;
    struct {
      vuint32_t TVL:32;                /* Current Timer Value */
    } B;
  } RTI_CVAL;

  union {                              /* Timer Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t TIE:1;                 /* Timer Interrupt Enable */
      vuint32_t TEN:1;                 /* Timer Enable Bit */
    } B;
  } RTI_TCTRL;

  union {                              /* Timer Flag Register */
    vuint32_t R;
    struct {
      vuint32_t  :31;
      vuint32_t TIF:1;                 /* Timer Interrupt Flag. */
    } B;
  } RTI_TFLG;

  struct {
    union {                            /* Timer Load Value Register */
      vuint32_t R;
      struct {
        vuint32_t TSV:32;              /* Timer Start Value */
      } B;
    } LDVAL;
    union {                            /* Current Timer Value Register */
      vuint32_t R;
      struct {
        vuint32_t TVL:32;              /* Current Timer Value */
      } B;
    } CVAL;
    union {                            /* Timer Control Register */
      vuint32_t R;
      struct {
        vuint32_t  :29;
        vuint32_t CHN:1;               /* Chain Mode */
        vuint32_t TIE:1;               /* Timer Interrupt Enable */
        vuint32_t TEN:1;               /* Timer Enable */
      } B;
    } TCTRL;
    union {                            /* Timer Flag Register */
      vuint32_t R;
      struct {
        vuint32_t  :31;
        vuint32_t TIF:1;               /* Timer Interrupt Flag */
      } B;
    } TFLG;
  } TIMER[16];
};


/* ============================================================================
   =============================== Module: PLLDIG =============================
   ============================================================================ */

struct PLLDIG_tag {
  uint8_t PLLDIG_reserved0[24];
  union {                              /* PLL Calibration Register 3 */
    vuint32_t R;
    struct {
      vuint32_t  :2;
      vuint32_t MFDEN:16;              /* Denominator fo fractional loop division factor. */
      vuint32_t  :14;
    } B;
  } PLLCAL3;
  uint8_t PLLDIG_reserved1[4];
  union {                              /* PLLDIG PLL Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :21;
      vuint32_t  :1;
      vuint32_t  :2;
      vuint32_t EXPDIE:1;              /* External Power Down Cycle Complete indication interrupt enable. */
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t LOLIE:1;               /* Loss-of-lock interrupt enable. */
      vuint32_t LOLRE:1;               /* Loss-of-lock reset enable. */
      vuint32_t  :1;
      vuint32_t  :1;
    } B;
  } PLLCR;

  union {                              /* PLLDIG PLL Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :22;
      vuint32_t ENPHI1:1;              /* PLL PHI1 Output Enable */
      vuint32_t ENPHI:1;               /* PLL PHI Output Enable */
      vuint32_t EXTPDF:1;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t LOLF:1;                /* Loss-of-lock flag. */
      vuint32_t LOCK:1;
      vuint32_t  :1;
      vuint32_t  :1;
    } B;
  } PLLSR;

  union {                              /* PLLDIG PLL Divider Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t RFDPHI1:6;             /* PHI1 reduced frequency divider. */
      vuint32_t  :3;
      vuint32_t RFDPHI:6;              /* PHI reduced frequency divider. */
      vuint32_t  :1;
      vuint32_t PREDIV:3;              /* Input clock predivider. */
      vuint32_t  :1;
      vuint32_t  :3;
      vuint32_t MFD:8;                 /* Loop multiplication factor divider. */
    } B;
  } PLLDV;

  union {                              /* PLLDIG PLL Frequency Modulation Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t SSCGBYP:1;             /* Modulation enable. */
      vuint32_t MODSEL:1;              /* Modulation selection. */
      vuint32_t  :3;
      vuint32_t MODPRD:10;             /* Modulation period. */
      vuint32_t  :5;
      vuint32_t INCSTP:11;             /* Increment step. */
    } B;
  } PLLFM;

  union {                              /* PLLDIG PLL Fractional Divide Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t SMDEN:1;               /* Sigma Delta Modulation Enable */
      vuint32_t SDM2:1;                /* Second Order Sigma Delta Modulation Select */
      vuint32_t SDM3:1;                /* Third Order Sigma Delta Modulation Select */
      vuint32_t  :6;
      vuint32_t DTHRCTL:4;             /* Dither Control. */
      vuint32_t DTHDIS:2;              /* Dither Disable. */
      vuint32_t  :1;
      vuint32_t MFN:15;
    } B;
  } PLLFD;
};


/* ============================================================================
   =============================== Module: PMCDIG =============================
   ============================================================================ */

struct PMCDIG_tag {
  union {                              /* RAM Domain Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :11;
      vuint32_t MEM_SLEEP_EN:1;        /* Memory Sleep Enable */
      vuint32_t  :3;
      vuint32_t PAD_KEEP_EN:1;         /* PAD Keeper Enable */
      vuint32_t  :7;
      vuint32_t RD256_RET:1;           /* RAM Domain 256K Retention */
      vuint32_t  :3;
      vuint32_t RD128_RET:1;           /* RAM Domain 128K Retention */
      vuint32_t  :3;
      vuint32_t RD64_RET:1;            /* RAM Domain 64K Retention */
    } B;
  } RDCR;

  union {                              /* Supply Gauge Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :19;
      vuint32_t LP_STATUS:2;           /* Low Power Status */
      vuint32_t BROWNOUT:1;		//chetan TBC
      vuint32_t HVD_LV_COLD:1;         /* HVD LV PD2 Flag */
      vuint32_t  :1;
      vuint32_t LVD_FLASH:1;           /* LVD VDD_HV_ FLA Flag */
      vuint32_t LVD_IO_A_HI:1;         /* LVD IO Segment A High Flag */
      vuint32_t LVD_IO_A_LO:1;         /* LVD IO Segment A Low Flag */
      vuint32_t LVD_LV_PD0_HOT:1;      /* LVD VDD_LV PD0 hot point Flag */
      vuint32_t LVD_LV_PD1_HOT:1;      /* LVD VDD_LV PD1 hot point Flag */
      vuint32_t LVD_LV_PD2_COLD:1;     /* LVD_LV_PD2 Cold Point Flag */
      vuint32_t LVD_LV_PD2_HOT:1;      /* LVD LV_PD2 hot Point Flag */
      vuint32_t POR_LV:1;              /* Power On Reset Flag */
    } B;
  } SGSR;

  uint8_t PMCDIG_reserved0[8];
  union {                              /* MISC Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t  :3;
      vuint32_t  :3;
      vuint32_t  :1;
      vuint32_t  :7;
      vuint32_t LP_ST_CHG_IN_PRGRS:1;  /* Low Power State Change in Progress */
      vuint32_t  :1;
//_Ignore_
      vuint32_t  :3;
      vuint32_t LVD_PD2_COLD_REE:1;    /* LVD_PD2 Cold Point Flag Reset Event Enable */
//_Ignore_	  
      vuint32_t HVD_REE:1;             /* HVD Reset Event Enable */
      vuint32_t  :1;
      vuint32_t LVD_IO_HI_REE:1;       /* LVD_IO_HI Reset Event Enable */
      vuint32_t  :5;
      vuint32_t  :3;
    } B;
  } MCR;
};


/* ============================================================================
   =============================== Module: PRAMC ==============================
   ============================================================================ */

struct PRAMC_tag {
  union {                              /* Platform RAM Configuration Register 1 */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t  :2;
      vuint32_t  :5;
      vuint32_t FT_DIS:1;              /* Flow through disabled. */
    } B;
  } PRCR1;
};


/* ============================================================================
   =============================== Module: RTC ================================
   ============================================================================ */

struct RTC_tag {
  union {                              /* RTC Supervisor Control register */
    vuint32_t R;
    struct {
      vuint32_t SUPV:1;                /* RTC Supervisor Bit. */
      vuint32_t  :31;                  /* Reserved. */
    } B;
  } RTCSUPV;

  union {                              /* RTC Control register */
    vuint32_t R;
    struct {
      vuint32_t CNTEN:1;               /* Counter Enable. */
      vuint32_t RTCIE:1;               /* RTC Interrupt Enable. */
      vuint32_t FRZEN:1;               /* Freeze Enable Bit. */
      vuint32_t ROVREN:1;              /* Counter Roll Over Wakeup/Interrupt Enable. */
      vuint32_t  :12;                  /* Reserved. */
      vuint32_t APIEN:1;               /* Autonomous Periodic Interrupt Enable. */
      vuint32_t APIIE:1;               /* API Interrupt Enable. */
      vuint32_t CLKSEL:2;              /* Clock Select. */
      vuint32_t DIV512EN:1;            /* Divide by 512 enable. */
      vuint32_t DIV32EN:1;             /* Divide by 32 enable. */
      vuint32_t  :9;                   /* Reserved. */
      vuint32_t TRIG_EN:1;             /* Trigger enable for Analog Comparator */
    } B;
  } RTCC;

  union {                              /* RTC Status register */
    vuint32_t R;
    struct {
      vuint32_t  :2;                   /* Reserved. */
      vuint32_t RTCF:1;                /* RTC Interrupt Flag. */
      vuint32_t  :10;                  /* Reserved. */
      vuint32_t INV_RTC:1;             /* Invalid rtc write */
      vuint32_t INV_API:1;             /* Invalid APIVAL write */
      vuint32_t INV_ANL:1;             /* Invalid ANLCMP write */
      vuint32_t  :2;
      vuint32_t APIF:1;                /* API Interrupt Flag. */
      vuint32_t  :2;                   /* Reserved. */
      vuint32_t ROVRF:1;               /* Counter Roll Over Interrupt Flag. */
      vuint32_t  :10;                  /* Reserved. */
    } B;
  } RTCS;

  union {                              /* RTC Counter register */
    vuint32_t R;
    struct {
      vuint32_t RTCCNT:32;             /* RTC Counter Value. */
    } B;
  } RTCCNT;

  union {                              /* API Compare Value register */
    vuint32_t R;
    struct {
      vuint32_t APIVAL:32;             /* API Compare Value. */
    } B;
  } APIVAL;

  union {                              /* RTC Compare Value register */
    vuint32_t R;
    struct {
      vuint32_t RTCVAL:32;             /* RTC Compare Value. */
    } B;
  } RTCVAL;

  union {                              /* RTC Analogue comparator count register */
    vuint32_t R;
    struct {
      vuint32_t ANLCMP:32;             /* The trigger_en_out pulse will be generated (after the generation of wakeup_api signal) as per the number of API clocks programmed into this register. */
    } B;
  } ANLCMP_CNT;
};


/* ============================================================================
   =============================== Module: SEMA42 =============================
   ============================================================================ */

struct SEMA42_tag {
  union {                              /* Gate Register */
    vuint8_t R;
    struct {
      vuint8_t  :4;
      vuint8_t GTFSM:4;                /* Gate Finite State Machine. */
    } B;
  } GATE[16];

  uint8_t SEMA42_reserved0[48];
  union {
    struct {
      uint8_t _reserved0[2];
      union {                          /* Reset Gate Read */
        vuint16_t R;
        struct {
          vuint16_t  :2;
          vuint16_t RSTGSM:2;
          vuint16_t RSTGMS:4;
          vuint16_t RSTGTN:8;
        } B;
      } R;
    } ;
    union {                            /* Reset Gate Write */
      vuint16_t R;
      struct {
        vuint16_t RSTGDP:8;
        vuint16_t RSTGTN:8;
      } B;
    } W;
  } RSTGT;
};


/* ============================================================================
   =============================== Module: SIRC ===============================
   ============================================================================ */

struct SIRC_tag {
  union {                              /* Control register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t  :8;
      vuint32_t  :3;
      vuint32_t SIRCDIV:5;             /* The IRC Divider bits select the clock divider factor */
      vuint32_t  :3;
      vuint32_t SIRCS:1;               /* Describes the IRC clock status. */
      vuint32_t  :3;
      vuint32_t  :1;
    } B;
  } CTL;
};


/* ============================================================================
   =============================== Module: SIUL2 ==============================
   ============================================================================ */

struct SIUL2_tag {
  uint8_t SIUL2_reserved0[4];
  union {                              /* SIUL2 MCU ID Register #1 */
    vuint32_t R;
    struct {
      vuint32_t PARTNUM:16;            /* MCU Part Number */
      vuint32_t  :1;
      vuint32_t PKG:5;                 /* Package Settings */
      vuint32_t  :2;
      vuint32_t MAJOR_MASK:4;          /* Major Mask Revision */
      vuint32_t MINOR_MASK:4;          /* Minor Mask Revision */
    } B;
  } MIDR1;

  union {                              /* SIUL2 MCU ID Register #2 */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t FLASH_SIZE_1:4;        /* Coarse granularity for flash memory size */
      vuint32_t FLASH_SIZE_2:4;        /* Fine granularity for flash memory size */
      vuint32_t  :7;
      vuint32_t PARTNUM:8;             /* ASCII character in MCU Part Number */
      vuint32_t  :8;
    } B;
  } MIDR2;

  uint8_t SIUL2_reserved1[4];
  union {                              /* SIUL2 Interrupt Status Flag Register0 */
    vuint32_t R;
    struct {
      vuint32_t EIF31:1;               /* External Interrupt Status Flag x */
      vuint32_t  :7;
      vuint32_t EIF23:1;               /* External Interrupt Status Flag x */
      vuint32_t EIF22:1;               /* External Interrupt Status Flag x */
      vuint32_t EIF21:1;               /* External Interrupt Status Flag x */
      vuint32_t EIF20:1;               /* External Interrupt Status Flag x */
      vuint32_t EIF19:1;               /* External Interrupt Status Flag x */
      vuint32_t EIF18:1;               /* External Interrupt Status Flag x */
      vuint32_t EIF17:1;               /* External Interrupt Status Flag x */
      vuint32_t EIF16:1;               /* External Interrupt Status Flag x */
      vuint32_t EIF15:1;               /* External Interrupt Status Flag x */
      vuint32_t EIF14:1;               /* External Interrupt Status Flag x */
      vuint32_t EIF13:1;               /* External Interrupt Status Flag x */
      vuint32_t EIF12:1;               /* External Interrupt Status Flag x */
      vuint32_t EIF11:1;               /* External Interrupt Status Flag x */
      vuint32_t EIF10:1;               /* External Interrupt Status Flag x */
      vuint32_t EIF9:1;                /* External Interrupt Status Flag x */
      vuint32_t EIF8:1;                /* External Interrupt Status Flag x */
      vuint32_t EIF7:1;                /* External Interrupt Status Flag x */
      vuint32_t EIF6:1;                /* External Interrupt Status Flag x */
      vuint32_t EIF5:1;                /* External Interrupt Status Flag x */
      vuint32_t EIF4:1;                /* External Interrupt Status Flag x */
      vuint32_t EIF3:1;                /* External Interrupt Status Flag x */
      vuint32_t EIF2:1;                /* External Interrupt Status Flag x */
      vuint32_t EIF1:1;                /* External Interrupt Status Flag x */
      vuint32_t EIF0:1;                /* External Interrupt Status Flag x */
    } B;
  } ISR0;

  uint8_t SIUL2_reserved2[4];
  union {                              /* SIUL2 Interrupt Request Enable Register0 */
    vuint32_t R;
    struct {
      vuint32_t EIRE31:1;
      vuint32_t  :7;
      vuint32_t EIRE23:1;
      vuint32_t EIRE22:1;
      vuint32_t EIRE21:1;
      vuint32_t EIRE20:1;
      vuint32_t EIRE19:1;
      vuint32_t EIRE18:1;
      vuint32_t EIRE17:1;
      vuint32_t EIRE16:1;
      vuint32_t EIRE15:1;
      vuint32_t EIRE14:1;
      vuint32_t EIRE13:1;
      vuint32_t EIRE12:1;
      vuint32_t EIRE11:1;
      vuint32_t EIRE10:1;
      vuint32_t EIRE9:1;
      vuint32_t EIRE8:1;
      vuint32_t EIRE7:1;
      vuint32_t EIRE6:1;
      vuint32_t EIRE5:1;
      vuint32_t EIRE4:1;
      vuint32_t EIRE3:1;
      vuint32_t EIRE2:1;
      vuint32_t EIRE1:1;
      vuint32_t EIRE0:1;
    } B;
  } IRER0;

  uint8_t SIUL2_reserved3[4];
  union {                              /* SIUL2 Interrupt Request Select Register0 */
    vuint32_t R;
    struct {
      vuint32_t DIRSR31:1;
      vuint32_t  :7;
      vuint32_t DIRSR23:1;
      vuint32_t DIRSR22:1;
      vuint32_t DIRSR21:1;
      vuint32_t DIRSR20:1;
      vuint32_t DIRSR19:1;
      vuint32_t DIRSR18:1;
      vuint32_t DIRSR17:1;
      vuint32_t DIRSR16:1;
      vuint32_t DIRSR15:1;
      vuint32_t DIRSR14:1;
      vuint32_t DIRSR13:1;
      vuint32_t DIRSR12:1;
      vuint32_t DIRSR11:1;
      vuint32_t DIRSR10:1;
      vuint32_t DIRSR9:1;
      vuint32_t DIRSR8:1;
      vuint32_t DIRSR7:1;
      vuint32_t DIRSR6:1;
      vuint32_t DIRSR5:1;
      vuint32_t DIRSR4:1;
      vuint32_t DIRSR3:1;
      vuint32_t DIRSR2:1;
      vuint32_t DIRSR1:1;
      vuint32_t DIRSR0:1;
    } B;
  } IRSR0;

  uint8_t SIUL2_reserved4[4];
  union {                              /* SIUL2 Interrupt Rising-Edge Event Enable Register 0 */
    vuint32_t R;
    struct {
      vuint32_t IREE31:1;
      vuint32_t  :7;
      vuint32_t IREE23:1;
      vuint32_t IREE22:1;
      vuint32_t IREE21:1;
      vuint32_t IREE20:1;
      vuint32_t IREE19:1;
      vuint32_t IREE18:1;
      vuint32_t IREE17:1;
      vuint32_t IREE16:1;
      vuint32_t IREE15:1;
      vuint32_t IREE14:1;
      vuint32_t IREE13:1;
      vuint32_t IREE12:1;
      vuint32_t IREE11:1;
      vuint32_t IREE10:1;
      vuint32_t IREE9:1;
      vuint32_t IREE8:1;
      vuint32_t IREE7:1;
      vuint32_t IREE6:1;
      vuint32_t IREE5:1;
      vuint32_t IREE4:1;
      vuint32_t IREE3:1;
      vuint32_t IREE2:1;
      vuint32_t IREE1:1;
      vuint32_t IREE0:1;
    } B;
  } IREER0;

  uint8_t SIUL2_reserved5[4];
  union {                              /* SIUL2 Interrupt Falling-Edge Event Enable Register 0 */
    vuint32_t R;
    struct {
      vuint32_t IFEE31:1;
      vuint32_t  :7;
      vuint32_t IFEE23:1;
      vuint32_t IFEE22:1;
      vuint32_t IFEE21:1;
      vuint32_t IFEE20:1;
      vuint32_t IFEE19:1;
      vuint32_t IFEE18:1;
      vuint32_t IFEE17:1;
      vuint32_t IFEE16:1;
      vuint32_t IFEE15:1;
      vuint32_t IFEE14:1;
      vuint32_t IFEE13:1;
      vuint32_t IFEE12:1;
      vuint32_t IFEE11:1;
      vuint32_t IFEE10:1;
      vuint32_t IFEE9:1;
      vuint32_t IFEE8:1;
      vuint32_t IFEE7:1;
      vuint32_t IFEE6:1;
      vuint32_t IFEE5:1;
      vuint32_t IFEE4:1;
      vuint32_t IFEE3:1;
      vuint32_t IFEE2:1;
      vuint32_t IFEE1:1;
      vuint32_t IFEE0:1;
    } B;
  } IFEER0;

  uint8_t SIUL2_reserved6[4];
  union {                              /* SIUL2 Interrupt Filter Enable Register 0 */
    vuint32_t R;
    struct {
      vuint32_t IFE31:1;
      vuint32_t  :7;
      vuint32_t IFE23:1;
      vuint32_t IFE22:1;
      vuint32_t IFE21:1;
      vuint32_t IFE20:1;
      vuint32_t IFE19:1;
      vuint32_t IFE18:1;
      vuint32_t IFE17:1;
      vuint32_t IFE16:1;
      vuint32_t IFE15:1;
      vuint32_t IFE14:1;
      vuint32_t IFE13:1;
      vuint32_t IFE12:1;
      vuint32_t IFE11:1;
      vuint32_t IFE10:1;
      vuint32_t IFE9:1;
      vuint32_t IFE8:1;
      vuint32_t IFE7:1;
      vuint32_t IFE6:1;
      vuint32_t IFE5:1;
      vuint32_t IFE4:1;
      vuint32_t IFE3:1;
      vuint32_t IFE2:1;
      vuint32_t IFE1:1;
      vuint32_t IFE0:1;
    } B;
  } IFER0;

  uint8_t SIUL2_reserved7[4];
  union {                              /* SIUL2 Interrupt Filter Maximum Counter Register */
    vuint32_t R;
    struct {
      vuint32_t  :28;
      vuint32_t MAXCNT:4;              /* Maximum Interrupt Filter Counter setting */
    } B;
  } IFMCR[32];

  union {                              /* SIUL2 Interrupt Filter Clock Prescaler Register */
    vuint32_t R;
    struct {
      vuint32_t  :28;
      vuint32_t IFCP:4;                /* Interrupt Filter Clock Prescaler setting */
    } B;
  } IFCPR;

  uint8_t SIUL2_reserved8[380];
  union {                              /* SIUL2 Multiplexed Signal Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :2;
      vuint32_t SRC:2;                 /* Slew Rate Control */
      vuint32_t  :2;
      vuint32_t OBE:1;                 /* GPIO Output Buffer Enable */
      vuint32_t ODE:1;                 /* Open Drain Enable */
      vuint32_t SMC:1;                 /* Safe Mode Control */
      vuint32_t APC:1;                 /* Analog Pad Control */
      vuint32_t  :1;
      vuint32_t TTL:1;                 /* TTL/Automotive mode selection */
      vuint32_t IBE:1;                 /* Input Buffer Enable */
      vuint32_t HYS:1;                 /* Input Hysteresis */
      vuint32_t PUS:1;                 /* Pull Select */
      vuint32_t PUE:1;                 /* Pull Enable */
      vuint32_t  :8;
      vuint32_t  :4;
      vuint32_t SSS:4;                 /* Source Signal Select */
    } B;
  } MSCR[264];

  uint8_t SIUL2_reserved9[992];
  union {                              /* SIUL2 Input Multiplexed Signal Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t  :4;
      vuint32_t SSS:4;                 /* Source Signal Select */
    } B;
  } IMCR[512];

  uint8_t SIUL2_reserved10[192];
  union {                              /* SIUL2 GPIO Pad Data Output Register */
    vuint8_t R;
    struct {
      vuint8_t  :7;
      vuint8_t PDO_4n:1;					     /* Pad Data Out */
    } B;
  } GPDO[264];

  uint8_t SIUL2_reserved11[248];
  union {                              /* SIUL2 GPIO Pad Data Input Register */
    vuint8_t R;
    struct {
      vuint8_t  :7;
      vuint8_t PDI_4n:1;					     /* Pad Data In */
    } B;
  } GPDI[264];

  uint8_t SIUL2_reserved12[248];
  union {                              /* SIUL2 Parallel GPIO Pad Data Out Register */
    vuint16_t R;
    struct {
      vuint16_t PPDO:16;               /* Parallel Pad Data Out */
    } B;
  } PGPDO[32];

  union {                              /* SIUL2 Parallel GPIO Pad Data In Register */
    vuint16_t R;
    struct {
      vuint16_t PPDI:16;               /* Parallel Pad Data In */
    } B;
  } PGPDI[32];

  union {                              /* SIUL2 Masked Parallel GPIO Pad Data Out Register */
    vuint32_t R;
    struct {
      vuint32_t MASK:16;               /* Mask Field */
      vuint32_t MPPDO:16;              /* Masked Parallel Pad Data Out */
    } B;
  } MPGPDO[32];
};


/* ============================================================================
   =============================== Module: SMPU ===============================
   ============================================================================ */

struct SMPU_tag {
  union {                              /* Control/Error Status Register 0 */
    vuint32_t R;
    struct {
      vuint32_t MERR:16;               /* Master n error, where the bus master number matches the bit number */
      vuint32_t  :12;
      vuint32_t HRL:3;                 /* Hardware revision level */
      vuint32_t GVLD:1;                /* Global Valid (global enable/disable for the SMPU) */
    } B;
  } CES0;

  union {                              /* Control/Error Status Register 1 */
    vuint32_t R;
    struct {
      vuint32_t MEOVR:16;              /* Master n error overrun, where the bus master number matches the bit number */
      vuint32_t  :12;
      vuint32_t NRGD:4;                /* Number of region descriptors */
    } B;
  } CES1;

  uint8_t SMPU_reserved0[248];
  struct {
    union {                            /* Error Address Register, Bus Master */
      vuint32_t R;
      struct {
        vuint32_t EADDR:32;            /* Error address */
      } B;
    } ADR;
    union {                            /* Error Attribute Detail Register, Bus Master */
      vuint32_t R;
      struct {
        vuint32_t PID:8;
        vuint32_t  :14;
        vuint32_t EATTR:2;             /* Error attributes */
        vuint32_t ERW:1;               /* Error read/write */
        vuint32_t EMN:7;               /* Error master number */
      } B;
    } ADTL;
    union {                            /* Error Attribute Control Detail Register, Bus Master */
      vuint32_t R;
      struct {
        vuint32_t EACD:24;             /* Error access control detail */
        vuint32_t  :8;
      } B;
    } ACDL;
    uint8_t ERROR_reserved0[4];
  } ERROR[16];

  uint8_t SMPU_reserved1[512];
  struct {
    union {                            /* Region Descriptor n, Word 0 */
      vuint32_t R;
      struct {
        vuint32_t SRTADDR:28;          /* Start address */
        vuint32_t RD_UNRW0:4;
      } B;
    } WORD0;
    union {                            /* Region Descriptor n, Word 1 */
      vuint32_t R;
      struct {
        vuint32_t ENDADDR:28;          /* End address */
        vuint32_t RD_UNRW1:4;
      } B;
    } WORD1;
    union {
      union {                          /* Region Descriptor n, Word 2 Format 0 */
        vuint32_t R;
        struct {
          vuint32_t M0P:2;             /* Bus master 0 permissions */
          vuint32_t M1P:2;             /* Bus master 1 permissions */
          vuint32_t M2P:2;             /* Bus master 2 permissions */
          vuint32_t M3P:2;             /* Bus master 3 permissions */
          vuint32_t M4P:2;             /* Bus master 4 permissions */
          vuint32_t M5P:2;             /* Bus master 5 permissions */
          vuint32_t M6P:2;             /* Bus master 6 permissions */
          vuint32_t M7P:2;             /* Bus master 7 permissions */
          vuint32_t M8P:2;             /* Bus master 8 permissions */
          vuint32_t M9P:2;             /* Bus master 9 permissions */
          vuint32_t M10P:2;            /* Bus master 10 permissions */
          vuint32_t M11P:2;            /* Bus master 11 permissions */
          vuint32_t M12P:2;            /* Bus master 12 permissions */
          vuint32_t M13P:2;            /* Bus master 13 permissions */
          vuint32_t M14P:2;            /* Bus master 14 permissions */
          vuint32_t M15P:2;            /* Bus master 15 permissions */
        } B;
      } FMT0;
      union {                          /* Region Descriptor n, Word 2 Format 1 */
        vuint32_t R;
        struct {
          vuint32_t M0S:2;             /* Bus master 0 permission select */
          vuint32_t M1S:2;             /* Bus master 1 permission select */
          vuint32_t M2S:2;             /* Bus master 2 permission select */
          vuint32_t M3S:2;             /* Bus master 3 permission select */
          vuint32_t M4S:2;             /* Bus master 4 permission select */
          vuint32_t M5S:2;             /* Bus master 5 permission select */
          vuint32_t M6S:2;             /* Bus master 6 permission select */
          vuint32_t M7S:2;             /* Bus master 7 permission select */
          vuint32_t M8S:2;             /* Bus master 8 permission select */
          vuint32_t M9S:2;             /* Bus master 9 permission select */
          vuint32_t M10S:2;            /* Bus master 10 permission select */
          vuint32_t M11S:2;            /* Bus master 11 permission select */
          vuint32_t M12S:2;            /* Bus master 12 permission select */
          vuint32_t M13S:2;            /* Bus master 13 permission select */
          vuint32_t M14S:2;            /* Bus master 14 permission select */
          vuint32_t M15S:2;            /* Bus master 15 permission select */
        } B;
      } FMT1;
    } WORD2;
    union {                            /* Region Descriptor n, Word 3 */
      vuint32_t R;
      struct {
        vuint32_t ACCSET1:6;           /* Access controls, Set 1 */
        vuint32_t ACCSET2:6;           /* Access controls, Set 2 */
        vuint32_t ACCSET3:6;           /* Access controls, Set 3 */
        vuint32_t  :9;
        vuint32_t FMT:1;               /* Region Descriptor Format */
        vuint32_t  :2;
        vuint32_t CI:1;                /* Cache Inhibit */
        vuint32_t  :1;
      } B;
    } WORD3;
    union {                            /* Region Descriptor n, Word 4 */
      vuint32_t R;
      struct {
        vuint32_t PID:8;               /* Process Identifier */
        vuint32_t PID_MASK:8;          /* Process Identifier Mask */
        vuint32_t  :15;
        vuint32_t PIDEN:1;             /* Region Descriptor PID Enable */
      } B;
    } WORD4;
    union {                            /* Region Descriptor n, Word 5 */
      vuint32_t R;
      struct {
        vuint32_t MID:8;               /* Master ID of RGDn owner */
        vuint32_t  :20;
        vuint32_t LCK:2;               /* Region Descriptor Lock */
        vuint32_t  :1;
        vuint32_t VLD:1;               /* Valid */
      } B;
    } WORD5;
    uint8_t RGD_reserved0[40];
  } RGD[16];
};


/* ============================================================================
   =============================== Module: SSCM ===============================
   ============================================================================ */

struct SSCM_tag {
  union {                              /* SSCM System Status */
    vuint16_t R;
    struct {
      vuint16_t  :1;
      vuint16_t CER:1;                 /* Configuration Error */
      vuint16_t CERS:1;                /* Configuration Error for Safe DCF Clients */
      vuint16_t  :1;
      vuint16_t NXEN:1;                /* Processor 0 Nexus enable status */
      vuint16_t  :1;
      vuint16_t  :1;
      vuint16_t  :1;
      vuint16_t BMODE:3;               /* Device Boot Mode */
      vuint16_t  :1;
      vuint16_t  :1;
      vuint16_t  :1;
      vuint16_t  :2;
    } B;
  } STATUS;

  union {                              /* SSCM System Memory and ID Register */
    vuint16_t R;
    struct {
      vuint16_t JPIN:10;
      vuint16_t  :1;
      vuint16_t MREV:4;                /* Minor Mask Revision */
      vuint16_t  :1;
    } B;
  } MEMCONFIG;

  uint8_t SSCM_reserved0[4];
  union {                              /* SSCM Debug Status Port Register */
    vuint16_t R;
    struct {
      vuint16_t  :7;
      vuint16_t  :1;
      vuint16_t  :5;
      vuint16_t DEBUG_MODE:3;
    } B;
  } DEBUGPORT;

  uint8_t SSCM_reserved1[22];
  union {                              /* SSCM HSM and User Option Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :28;
      vuint32_t HSB:3;                 /* HSM Boot Configuration */
      vuint32_t HSE:1;                 /* HSM Enabled */
    } B;
  } UOPS;

  uint8_t SSCM_reserved2[4];
  union {                              /* Processor Start Address Register */
    vuint32_t R;
    struct {
      vuint32_t SADR:32;               /* Processor Start Address */
    } B;
  } PSA;

  uint8_t SSCM_reserved3[4];
  union {                              /* SSCM HSM Start Address Register */
    vuint32_t R;
    struct {
      vuint32_t HADR:32;               /* HSM Start Address */
    } B;
  } HSA;

  union {                              /* Life Cycle Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :22;
      vuint32_t  :2;
      vuint32_t  :5;
      vuint32_t LC:3;                  /* Life Cycle */
    } B;
  } LCSTAT;
};


/* ============================================================================
   =============================== Module: STCU2 ==============================
   ============================================================================ */

struct STCU2_tag {
  union {                              /* STCU2 Run Register */
    vuint32_t R;
    struct {
      vuint32_t  :21;
      vuint32_t BYP:1;
      vuint32_t MBPLLEN:1;
      vuint32_t  :1;
      vuint32_t  :7;
      vuint32_t RUN:1;
    } B;
  } RUN;

  union {                              /* STCU2 Run Software Register */
    vuint32_t R;
    struct {
      vuint32_t  :20;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t MBSWPLLEN:1;
      vuint32_t  :1;
      vuint32_t  :6;
      vuint32_t  :1;
      vuint32_t RUNSW:1;
    } B;
  } RUNSW;

  union {                              /* STCU2 SK Code Register */
    vuint32_t R;
    struct {
      vuint32_t SKC:32;
    } B;
  } SKC;

  union {                              /* STCU2 Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t PTR:7;
      vuint32_t  :8;
      vuint32_t  :7;
      vuint32_t WRP:1;
      vuint32_t  :2;
      vuint32_t  :1;
      vuint32_t PMOSEN:1;
      vuint32_t MBU:1;
      vuint32_t CLK_CFG:3;
    } B;
  } CFG;

  uint8_t STCU2_reserved0[4];
  union {                              /* STCU2 Watchdog Register Granularity */
    vuint32_t R;
    struct {
      vuint32_t WDGEOC:32;
    } B;
  } WDG;

  uint8_t STCU2_reserved1[12];
  union {                              /* STCU2 Error Register */
    vuint32_t R;
    struct {
      vuint32_t  :6;
      vuint32_t ABORTHW:1;
      vuint32_t  :1;
      vuint32_t  :3;
      vuint32_t LOCKESW:1;
      vuint32_t WDTOSW:1;
      vuint32_t  :1;
      vuint32_t ENGESW:1;
      vuint32_t INVPSW:1;
      vuint32_t  :6;
      vuint32_t UFSF:1;
      vuint32_t RFSF:1;
      vuint32_t  :3;
      vuint32_t LOCKE:1;
      vuint32_t WDTO:1;
      vuint32_t  :1;
      vuint32_t ENGE:1;
      vuint32_t INVP:1;
    } B;
  } ERR_STAT;

  union {                              /* STCU2 Error FM Register */
    vuint32_t R;
    struct {
      vuint32_t  :27;
      vuint32_t LOCKEUFM:1;
      vuint32_t WDTOUFM:1;
      vuint32_t  :1;
      vuint32_t ENGEUFM:1;
      vuint32_t INVPUFM:1;
    } B;
  } ERR_FM;

  uint8_t STCU2_reserved2[24];
  union {                              /* STCU2 Off-Line MBIST Status Low Register */
    vuint32_t R;
    struct {
      vuint32_t MBS31:1;
      vuint32_t MBS30:1;
      vuint32_t MBS29:1;
      vuint32_t MBS28:1;
      vuint32_t MBS27:1;
      vuint32_t MBS26:1;
      vuint32_t MBS25:1;
      vuint32_t MBS24:1;
      vuint32_t MBS23:1;
      vuint32_t MBS22:1;
      vuint32_t MBS21:1;
      vuint32_t MBS20:1;
      vuint32_t MBS19:1;
      vuint32_t MBS18:1;
      vuint32_t MBS17:1;
      vuint32_t MBS16:1;
      vuint32_t MBS15:1;
      vuint32_t MBS14:1;
      vuint32_t MBS13:1;
      vuint32_t MBS12:1;
      vuint32_t MBS11:1;
      vuint32_t MBS10:1;
      vuint32_t MBS9:1;
      vuint32_t MBS8:1;
      vuint32_t MBS7:1;
      vuint32_t MBS6:1;
      vuint32_t MBS5:1;
      vuint32_t MBS4:1;
      vuint32_t MBS3:1;
      vuint32_t MBS2:1;
      vuint32_t MBS1:1;
      vuint32_t MBS0:1;
    } B;
  } MBSL;

  union {                              /* STCU2 Off-Line MBIST Status Medium Register */
    vuint32_t R;
    struct {
      vuint32_t  :19;
      vuint32_t MBS44:1;
      vuint32_t MBS43:1;
      vuint32_t MBS42:1;
      vuint32_t MBS41:1;
      vuint32_t MBS40:1;
      vuint32_t MBS39:1;
      vuint32_t MBS38:1;
      vuint32_t MBS37:1;
      vuint32_t MBS36:1;
      vuint32_t MBS35:1;
      vuint32_t MBS34:1;
      vuint32_t MBS33:1;
      vuint32_t MBS32:1;
    } B;
  } MBSM;

  union {                              /* STCU2 Off-Line MBIST Status High Register */
    vuint32_t R;
    struct {
      vuint32_t  :32;
    } B;
  } MBSH;

  union {                              /* STCU2 Off-Line MBIST End Flag Low Register */
    vuint32_t R;
    struct {
      vuint32_t MBE31:1;
      vuint32_t MBE30:1;
      vuint32_t MBE29:1;
      vuint32_t MBE28:1;
      vuint32_t MBE27:1;
      vuint32_t MBE26:1;
      vuint32_t MBE25:1;
      vuint32_t MBE24:1;
      vuint32_t MBE23:1;
      vuint32_t MBE22:1;
      vuint32_t MBE21:1;
      vuint32_t MBE20:1;
      vuint32_t MBE19:1;
      vuint32_t MBE18:1;
      vuint32_t MBE17:1;
      vuint32_t MBE16:1;
      vuint32_t MBE15:1;
      vuint32_t MBE14:1;
      vuint32_t MBE13:1;
      vuint32_t MBE12:1;
      vuint32_t MBE11:1;
      vuint32_t MBE10:1;
      vuint32_t MBE9:1;
      vuint32_t MBE8:1;
      vuint32_t MBE7:1;
      vuint32_t MBE6:1;
      vuint32_t MBE5:1;
      vuint32_t MBE4:1;
      vuint32_t MBE3:1;
      vuint32_t MBE2:1;
      vuint32_t MBE1:1;
      vuint32_t MBE0:1;
    } B;
  } MBEL;

  union {                              /* STCU2 Off-Line MBIST End Flag Medium Register */
    vuint32_t R;
    struct {
      vuint32_t  :19;
      vuint32_t MBE44:1;
      vuint32_t MBE43:1;
      vuint32_t MBE42:1;
      vuint32_t MBE41:1;
      vuint32_t MBE40:1;
      vuint32_t MBE39:1;
      vuint32_t MBE38:1;
      vuint32_t MBE37:1;
      vuint32_t MBE36:1;
      vuint32_t MBE35:1;
      vuint32_t MBE34:1;
      vuint32_t MBE33:1;
      vuint32_t MBE32:1;
    } B;
  } MBEM;

  union {                              /* STCU2 Off-Line MBIST End Flag High Register */
    vuint32_t R;
    struct {
      vuint32_t  :32;
    } B;
  } MBEH;

  union {                              /* STCU2 On-Line MBIST Status Low Register */
    vuint32_t R;
    struct {
      vuint32_t MBSSW31:1;
      vuint32_t MBSSW30:1;
      vuint32_t MBSSW29:1;
      vuint32_t MBSSW28:1;
      vuint32_t MBSSW27:1;
      vuint32_t MBSSW26:1;
      vuint32_t MBSSW25:1;
      vuint32_t MBSSW24:1;
      vuint32_t MBSSW23:1;
      vuint32_t MBSSW22:1;
      vuint32_t MBSSW21:1;
      vuint32_t MBSSW20:1;
      vuint32_t MBSSW19:1;
      vuint32_t MBSSW18:1;
      vuint32_t MBSSW17:1;
      vuint32_t MBSSW16:1;
      vuint32_t MBSSW15:1;
      vuint32_t MBSSW14:1;
      vuint32_t MBSSW13:1;
      vuint32_t MBSSW12:1;
      vuint32_t MBSSW11:1;
      vuint32_t MBSSW10:1;
      vuint32_t MBSSW9:1;
      vuint32_t MBSSW8:1;
      vuint32_t MBSSW7:1;
      vuint32_t MBSSW6:1;
      vuint32_t MBSSW5:1;
      vuint32_t MBSSW4:1;
      vuint32_t MBSSW3:1;
      vuint32_t MBSSW2:1;
      vuint32_t MBSSW1:1;
      vuint32_t MBSSW0:1;
    } B;
  } MBSLSW;

  union {                              /* STCU2 On-Line MBIST Status Medium Register */
    vuint32_t R;
    struct {
      vuint32_t  :19;
      vuint32_t MBSSW44:1;
      vuint32_t MBSSW43:1;
      vuint32_t MBSSW42:1;
      vuint32_t MBSSW41:1;
      vuint32_t MBSSW40:1;
      vuint32_t MBSSW39:1;
      vuint32_t MBSSW38:1;
      vuint32_t MBSSW37:1;
      vuint32_t MBSSW36:1;
      vuint32_t MBSSW35:1;
      vuint32_t MBSSW34:1;
      vuint32_t MBSSW33:1;
      vuint32_t MBSSW32:1;
    } B;
  } MBSMSW;

  union {                              /* STCU2 On-Line MBIST Status High Register */
    vuint32_t R;
    struct {
      vuint32_t  :32;
    } B;
  } MBSHSW;

  union {                              /* STCU2 On-Line MBIST End Flag Low Register */
    vuint32_t R;
    struct {
      vuint32_t MBESW31:1;
      vuint32_t MBESW30:1;
      vuint32_t MBESW29:1;
      vuint32_t MBESW28:1;
      vuint32_t MBESW27:1;
      vuint32_t MBESW26:1;
      vuint32_t MBESW25:1;
      vuint32_t MBESW24:1;
      vuint32_t MBESW23:1;
      vuint32_t MBESW22:1;
      vuint32_t MBESW21:1;
      vuint32_t MBESW20:1;
      vuint32_t MBESW19:1;
      vuint32_t MBESW18:1;
      vuint32_t MBESW17:1;
      vuint32_t MBESW16:1;
      vuint32_t MBESW15:1;
      vuint32_t MBESW14:1;
      vuint32_t MBESW13:1;
      vuint32_t MBESW12:1;
      vuint32_t MBESW11:1;
      vuint32_t MBESW10:1;
      vuint32_t MBESW9:1;
      vuint32_t MBESW8:1;
      vuint32_t MBESW7:1;
      vuint32_t MBESW6:1;
      vuint32_t MBESW5:1;
      vuint32_t MBESW4:1;
      vuint32_t MBESW3:1;
      vuint32_t MBESW2:1;
      vuint32_t MBESW1:1;
      vuint32_t MBESW0:1;
    } B;
  } MBELSW;

  union {                              /* STCU2 On-Line MBIST End Flag Medium Register */
    vuint32_t R;
    struct {
      vuint32_t  :19;
      vuint32_t MBESW44:1;
      vuint32_t MBESW43:1;
      vuint32_t MBESW42:1;
      vuint32_t MBESW41:1;
      vuint32_t MBESW40:1;
      vuint32_t MBESW39:1;
      vuint32_t MBESW38:1;
      vuint32_t MBESW37:1;
      vuint32_t MBESW36:1;
      vuint32_t MBESW35:1;
      vuint32_t MBESW34:1;
      vuint32_t MBESW33:1;
      vuint32_t MBESW32:1;
    } B;
  } MBEMSW;

  union {                              /* STCU2 On-Line MBIST End Flag High Register */
    vuint32_t R;
    struct {
      vuint32_t  :32;
    } B;
  } MBEHSW;

  union {                              /* STCU2 MBIST Unrecoverable FM Low Register */
    vuint32_t R;
    struct {
      vuint32_t MBUFM31:1;
      vuint32_t MBUFM30:1;
      vuint32_t MBUFM29:1;
      vuint32_t MBUFM28:1;
      vuint32_t MBUFM27:1;
      vuint32_t MBUFM26:1;
      vuint32_t MBUFM25:1;
      vuint32_t MBUFM24:1;
      vuint32_t MBUFM23:1;
      vuint32_t MBUFM22:1;
      vuint32_t MBUFM21:1;
      vuint32_t MBUFM20:1;
      vuint32_t MBUFM19:1;
      vuint32_t MBUFM18:1;
      vuint32_t MBUFM17:1;
      vuint32_t MBUFM16:1;
      vuint32_t MBUFM15:1;
      vuint32_t MBUFM14:1;
      vuint32_t MBUFM13:1;
      vuint32_t MBUFM12:1;
      vuint32_t MBUFM11:1;
      vuint32_t MBUFM10:1;
      vuint32_t MBUFM9:1;
      vuint32_t MBUFM8:1;
      vuint32_t MBUFM7:1;
      vuint32_t MBUFM6:1;
      vuint32_t MBUFM5:1;
      vuint32_t MBUFM4:1;
      vuint32_t MBUFM3:1;
      vuint32_t MBUFM2:1;
      vuint32_t MBUFM1:1;
      vuint32_t MBUFM0:1;
    } B;
  } MBUFML;

  union {                              /* STCU2 MBIST Unrecoverable FM Medium Register */
    vuint32_t R;
    struct {
      vuint32_t  :19;
      vuint32_t MBUFM44:1;
      vuint32_t MBUFM43:1;
      vuint32_t MBUFM42:1;
      vuint32_t MBUFM41:1;
      vuint32_t MBUFM40:1;
      vuint32_t MBUFM39:1;
      vuint32_t MBUFM38:1;
      vuint32_t MBUFM37:1;
      vuint32_t MBUFM36:1;
      vuint32_t MBUFM35:1;
      vuint32_t MBUFM34:1;
      vuint32_t MBUFM33:1;
      vuint32_t MBUFM32:1;
    } B;
  } MBUFMM;

  union {                              /* STCU2 MBIST Unrecoverable FM High Register */
    vuint32_t R;
    struct {
      vuint32_t  :32;
    } B;
  } MBUFMH;

  uint8_t STCU2_reserved3[1408];
  union {                              /* STCU2 MBIST Control Register */
    vuint32_t R;
    struct {
      vuint32_t CSM:1;
      vuint32_t PTR:7;
      vuint32_t  :24;
    } B;
  } MB_CTRL[45];
};


/* ============================================================================
   =============================== Module: STM ================================
   ============================================================================ */

struct STM_tag {
  union {                              /* STM Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CPS:8;                 /* Counter Prescaler. */
      vuint32_t  :3;
      vuint32_t CSL:1;                 /* Clock Select */
      vuint32_t  :2;
      vuint32_t FRZ:1;                 /* Freeze. */
      vuint32_t TEN:1;                 /* Timer counter Enabled. */
    } B;
  } CR;

  union {                              /* STM Count Register */
    vuint32_t R;
    struct {
      vuint32_t CNT:32;                /* Timer count value used as the time base for all channels. */
    } B;
  } CNT;

  uint8_t STM_reserved0[8];
  struct {
    union {                            /* STM Channel Control Register */
      vuint32_t R;
      struct {
        vuint32_t  :31;
        vuint32_t CEN:1;               /* Channel Enable */
      } B;
    } CCR;
    union {                            /* STM Channel Interrupt Register */
      vuint32_t R;
      struct {
        vuint32_t  :31;
        vuint32_t CIF:1;               /* Channel Interrupt Flag */
      } B;
    } CIR;
    union {                            /* STM Channel Compare Register */
      vuint32_t R;
      struct {
        vuint32_t CMP:32;              /* Compare value for channel n. */
      } B;
    } CMP;
    uint8_t CHANNEL_reserved0[4];
  } CHANNEL[4];
};


/* ============================================================================
   =============================== Module: SWT ================================
   ============================================================================ */

struct SWT_tag {
  union {                              /* SWT Control Register */
    vuint32_t R;
    struct {
      vuint32_t MAP0:1;
      vuint32_t MAP1:1;
      vuint32_t MAP2:1;
      vuint32_t MAP3:1;
      vuint32_t MAP4:1;
      vuint32_t MAP5:1;
      vuint32_t MAP6:1;
      vuint32_t MAP7:1;
      vuint32_t  :13;
      vuint32_t SMD:2;                 /* Service Mode. */
      vuint32_t RIA:1;
      vuint32_t WND:1;
      vuint32_t ITR:1;
      vuint32_t HLK:1;
      vuint32_t SLK:1;
      vuint32_t  :1;                   /* Reserved. */
      vuint32_t STP:1;
      vuint32_t FRZ:1;
      vuint32_t WEN:1;
    } B;
  } CR;

  union {                              /* SWT Interrupt Register */
    vuint32_t R;
    struct {
      vuint32_t  :31;
      vuint32_t TIF:1;
    } B;
  } IR;

  union {                              /* SWT Time-out Register */
    vuint32_t R;
    struct {
      vuint32_t WTO:32;
    } B;
  } TO;

  union {                              /* SWT Window Register */
    vuint32_t R;
    struct {
      vuint32_t WST:32;
    } B;
  } WN;

  union {                              /* SWT Service Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t WSC:16;
    } B;
  } SR;

  union {                              /* SWT Counter Output Register */
    vuint32_t R;
    struct {
      vuint32_t CNT:32;
    } B;
  } CO;

  union {                              /* SWT Service Key Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SK:16;                 /* Service Key. */
    } B;
  } SK;
};


/* ============================================================================
   =============================== Module: SXOSC ==============================
   ============================================================================ */

struct SXOSC_tag {
  union {
    vuint32_t R;
    struct {
      vuint32_t OSCBYP:1;
      vuint32_t ALC:1;                 /* Auto loop control */
      vuint32_t  :6;
      vuint32_t EOCV:8;                /* End of Counter Value */
      vuint32_t M_OSC:1;               /* SXOSC clock interrupt mask */
      vuint32_t  :2;
      vuint32_t OSCDIV:5;              /* The SXOSC Divider bits select the clock divider factor. */
      vuint32_t I_OSC:1;               /* SXOSC clock interrupt */
      vuint32_t  :7;
    } B;
  } CTL;
};


/* ============================================================================
   =============================== Module: TDM ================================
   ============================================================================ */

struct TDM_tag {
  union {                              /* TDR Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t TDRSR5:1;
      vuint32_t TDRSR4:1;
      vuint32_t TDRSR3:1;
      vuint32_t TDRSR2:1;
      vuint32_t TDRSR1:1;
      vuint32_t TDRSR0:1;
    } B;
  } TDRSR;

  union {                              /* Last Flash Programmed Address Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t LFPAR:24;
    } B;
  } LFPAR;

  union {                              /* Diary Base Address */
    vuint32_t R;
    struct {
      vuint32_t DBA:32;
    } B;
  } DBA;
};


/* ============================================================================
   =============================== Module: WKPU ===============================
   ============================================================================ */

struct WKPU_tag {
  union {                              /* NMI Status Flag Register */
    vuint32_t R;
    struct {
      vuint32_t NIF0:1;
      vuint32_t NOVF0:1;
      vuint32_t  :6;
      vuint32_t NIF1:1;
      vuint32_t NOVF1:1;
      vuint32_t  :6;
      vuint32_t NIF2:1;
      vuint32_t NOVF2:1;
      vuint32_t  :6;
      vuint32_t RIF:1;                 /* Reset Status Flag */
      vuint32_t ROVF:1;                /* Reset Overrun Status Flag */
      vuint32_t  :6;
    } B;
  } NSR;

  uint8_t WKPU_reserved0[4];
  union {                              /* NMI Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t NLOCK0:1;
      vuint32_t NDSS0:2;
      vuint32_t NWRE0:1;
      vuint32_t  :1;
      vuint32_t NREE0:1;
      vuint32_t NFEE0:1;
      vuint32_t NFE0:1;
      vuint32_t NLOCK1:1;
      vuint32_t NDSS1:2;
      vuint32_t NWRE1:1;
      vuint32_t  :1;
      vuint32_t NREE1:1;
      vuint32_t NFEE1:1;
      vuint32_t  :1;
      vuint32_t NLOCK2:1;
      vuint32_t NDSS2:2;
      vuint32_t NWRE2:1;
      vuint32_t  :1;
      vuint32_t NREE2:1;
      vuint32_t NFEE2:1;
      vuint32_t  :1;
      vuint32_t RLOCK:1;
      vuint32_t RDSS:2;
      vuint32_t RWRE:1;
      vuint32_t  :1;
      vuint32_t RREE:1;
      vuint32_t RFEE:1;
      vuint32_t  :1;
    } B;
  } NCR;

  uint8_t WKPU_reserved1[8];
  union {                              /* Wakeup/Interrupt Status Flag Register */
    vuint32_t R;
    struct {
      vuint32_t EIF:32;
    } B;
  } WISR;

  union {                              /* Interrupt Request Enable Register */
    vuint32_t R;
    struct {
      vuint32_t EIRE:32;
    } B;
  } IRER;

  union {                              /* Wakeup Request Enable Register */
    vuint32_t R;
    struct {
      vuint32_t WRE:32;
    } B;
  } WRER;

  uint8_t WKPU_reserved2[8];
  union {                              /* Wakeup/Interrupt Rising-Edge Event Enable Register */
    vuint32_t R;
    struct {
      vuint32_t IREE:32;
    } B;
  } WIREER;

  union {                              /* Wakeup/Interrupt Falling-Edge Event Enable Register */
    vuint32_t R;
    struct {
      vuint32_t IFEEx:32;
    } B;
  } WIFEER;

  union {                              /* Wakeup/Interrupt Filter Enable Register */
    vuint32_t R;
    struct {
      vuint32_t IFE:32;
    } B;
  } WIFER;

  union {                              /* Wakeup/Interrupt Pullup Enable Register */
    vuint32_t R;
    struct {
      vuint32_t IPUE:32;
    } B;
  } WIPUER;
};


/* ============================================================================
   =============================== Module: eMIOS ==============================
   ============================================================================ */
struct eMIOS_tag {
 union {                              /* eMIOS Module Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t MDIS:1;                /* Module Disable bit. */
      vuint32_t FRZ:1;                 /* Freeze bit. */
      vuint32_t GTBE:1;                /* Global Time Base Enable bit. */
      vuint32_t  :1;
      vuint32_t GPREN:1;               /* Global Prescaler Enable bit. */
      vuint32_t  :6;
      vuint32_t  :4;
      vuint32_t GPRE:8;                /* Global Prescaler bits. */
      vuint32_t  :8;
    } B;
  } MCR;

  union {                              /* eMIOS Global FLAG Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t F23_F0:24;             /* Channel [n] mirrored FLAG bit. */
    } B;
  } GFLAG;

  union {                              /* eMIOS Output Update Disable register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t OU23_OU0:24;           /* Channel [n] Output Update Disable bit. */
    } B;
  } OUDIS;

  union {                              /* eMIOS Disable Channel register */
    vuint32_t R;
    struct {
      vuint32_t  :8;                   /* Reserved. */
      vuint32_t CHDIS23_CHDIS0:24;     /* Enable Channel n bit. */
    } B;
  } UCDIS;

 uint8_t UC_reserved0[16];

  struct {
    union {                            /* eMIOS UC A register n */
      vuint32_t R;
      struct {
        vuint32_t  :8;                 /* Reserved. */
        vuint32_t A:24;
      } B;
    } A;
    union {                            /* eMIOS UC B register n */
      vuint32_t R;
      struct {
        vuint32_t  :8;                 /* Reserved. */
        vuint32_t B:24;                /* See text above register figure. */
      } B;
    } B;
    union {                            /* eMIOS CNT register n */
      vuint32_t R;
      struct {
        vuint32_t  :16;                /* Reserved. */
        vuint32_t C:16;                /* The C field contains the value of the internal counter. */
      } B;
    } CNT;
    union {                            /* eMIOS UC Control register n */
      vuint32_t R;
      struct {
        vuint32_t FREN:1;              /* Freeze Enable bit. */
        vuint32_t ODIS:1;              /* Output Disable bit. */
        vuint32_t ODISSL:2;            /* Output Disable select bits. */
        vuint32_t UCPRE:2;             /* Prescaler bits. */
        vuint32_t UCPREN:1;            /* Prescaler Enable bit. */
        vuint32_t DMA_E:1;               /* Direct Memory Access bit. */
        vuint32_t  :1;                 /* Reserved. */
        vuint32_t IF:4;                /* Input Filter bits. */
        vuint32_t FCK:1;               /* Filter Clock select bit. */
        vuint32_t FEN:1;               /* FLAG Enable bit. */
        vuint32_t  :3;                 /* Reserved. */
        vuint32_t FORCMA:1;            /* Force Match A bit. */
        vuint32_t FORCMB:1;            /* Force Match B bit. */
        vuint32_t  :1;                 /* Reserved. */
        vuint32_t BSL:2;               /* Bus Select bits. */
        vuint32_t EDSEL:1;             /* Edge Selection bit. */
        vuint32_t EDPOL:1;             /* Edge Polarity bit. */
        vuint32_t MODE:7;              /* Mode selection bits. */
      } B;
    } C;
    union {                            /* eMIOS UC Status register n */
      vuint32_t R;
      struct {
        vuint32_t OVR:1;               /* Overrun bit. */
        vuint32_t  :15;                /* Reserved. */
        vuint32_t OVFL:1;              /* Overflow bit. */
        vuint32_t  :12;                /* Reserved. */
        vuint32_t UCIN:1;              /* Unified Channel Input pin bit. */
        vuint32_t UCOUT:1;             /* Unified Channel Output pin bit. */
        vuint32_t FLAG:1;              /* FLAG bit. */
      } B;
    } S;
    union {                            /* eMIOS Alternate Address register n */
      vuint32_t R;
      struct {
        vuint32_t  :8;                 /* Reserved. */
        vuint32_t ALTA:24;             /* See text above register figure. */
      } B;
    } ALTA;
    union {                            /* eMIOS UC Control 2 register n */
      vuint32_t R;
      struct {
        vuint32_t  :4;                 /* Reserved. */
        vuint32_t UCEXTPRE:12;         /* Extended Prescaler bits [ 0:11 ]. */
        vuint32_t  :1;                 /* Reserved. */
        vuint32_t UCPRECLK:1;          /* Prescaler Clock select bit. */
        vuint32_t  :14;                /* Reserved. */
      } B;
    } C2;
    uint8_t UC_reserved1[4];
  } UC[32];
};


#define ADC_0 (*(volatile struct ADC_tag *) 0xFFE00000UL)
#define ADC_1 (*(volatile struct ADC_tag *) 0xFBE00000UL)
#define AIPS_A (*(volatile struct AIPS_tag *) 0xFC000000UL)
#define AIPS_B (*(volatile struct AIPS_tag *) 0xF8000000UL)
#define AXBS_0 (*(volatile struct AXBS_tag *) 0xFC004000UL)
#define BCTU (*(volatile struct BCTU_tag *) 0xFFC10000UL)
#define C55FMC (*(volatile struct C55FMC_tag *) 0xFFFE0000UL)
#define C55FMCA (*(volatile struct C55FMC_tag *) 0xFFFE4000UL)
//#define CAN (*(volatile struct CAN_tag *) 0xFFEC0000UL)
#define CAN_0 (*(volatile struct CAN_1_7_tag *) 0xFFEC0000UL)
#define CAN_1 (*(volatile struct CAN_1_7_tag *) 0xFBEC0000UL)
#define CAN_2 (*(volatile struct CAN_1_7_tag *) 0xFFEC4000UL)
#define CAN_3 (*(volatile struct CAN_1_7_tag *) 0xFBEC4000UL)
#define CAN_4 (*(volatile struct CAN_1_7_tag *) 0xFFEC8000UL)
#define CAN_5 (*(volatile struct CAN_1_7_tag *) 0xFBEC8000UL)
#define CAN_6 (*(volatile struct CAN_1_7_tag *) 0xFFECC000UL)
#define CAN_7 (*(volatile struct CAN_1_7_tag *) 0xFBECC000UL)
#define CMP_0 (*(volatile struct CMP_tag *) 0xFFCDC000UL)
#define CMP_1 (*(volatile struct CMP_tag *) 0xFFCE0000UL)
#define CMP_2 (*(volatile struct CMP_tag *) 0xFFCE4000UL)
#define CMU (*(volatile struct CMU_tag *) 0xFFFB0140UL)
#define CRC (*(volatile struct CRC_tag *) 0xFFF64000UL)
#define DMA (*(volatile struct DMA_tag *) 0xFC0A0000UL)
#define DMAMUX_0 (*(volatile struct DMAMUX_tag *) 0xFFF6C000UL)
#define DMAMUX_1 (*(volatile struct DMAMUX_tag *) 0xFFF6C200UL)
#define DSPI_0 (*(volatile struct DSPI_tag *) 0xFFE70000UL)
#define DSPI_1 (*(volatile struct DSPI_tag *) 0xFBE70000UL)
#define DSPI_2 (*(volatile struct DSPI_tag *) 0xFFE74000UL)
#define DSPI_3 (*(volatile struct DSPI_tag *) 0xFBE74000UL)
#define ENET (*(volatile struct ENET_tag *) 0xFFCC4000UL)
#define FCCU (*(volatile struct FCCU_tag *) 0xFBF58000UL)
#define FIRC (*(volatile struct FIRC_tag *) 0xFFFB0000UL)
#define FR_0 (*(volatile struct FR_tag *) 0xFFE50000UL)
#define FXOSC (*(volatile struct FXOSC_tag *) 0xFFFB0040UL)
#define GPR (*(volatile struct GPR_tag *) 0xFFF94000UL)
#define HFInterface_0 (*(volatile struct HFInterface_tag *) 0xFFC34000UL)
#define HFInterface_1 (*(volatile struct HFInterface_tag *) 0xFFC30000UL)
#define HFInterface_2 (*(volatile struct HFInterface_tag *) 0xFBC2C000UL)
#define HFInterface_3 (*(volatile struct HFInterface_tag *) 0xFBC28000UL)
#define I2C_0 (*(volatile struct I2C_tag *) 0xFFE68000UL)
#define I2C_1 (*(volatile struct I2C_tag *) 0xFBE68000UL)
#define I2C_2 (*(volatile struct I2C_tag *) 0xFFE6C000UL)
#define I2C_3 (*(volatile struct I2C_tag *) 0xFBE6C000UL)
#define I2S_0 (*(volatile struct I2S_tag *) 0xFFCB4000UL)
#define I2S_1 (*(volatile struct I2S_tag *) 0xFBCB4000UL)
#define I2S_2 (*(volatile struct I2S_tag *) 0xFFCB8000UL)
#define IGF_0 (*(volatile struct IGF_tag *) 0xFFC24000UL)
#define IGF_1 (*(volatile struct IGF_tag *) 0xFFC20000UL)
#define IGF_2 (*(volatile struct IGF_tag *) 0xFBC1C000UL)
#define IGF_3 (*(volatile struct IGF_tag *) 0xFBC18000UL)
#define INTC (*(volatile struct INTC_tag *) 0xFC040000UL)
#define JDC (*(volatile struct JDC_tag *) 0xFFF3C000UL)
#define LINFlexD_0 (*(volatile struct LINFlexD_tag *) 0xFFE8C000UL)
#define LINFlexD_1 (*(volatile struct LINFlexD_tag *) 0xFBE8C000UL)
#define LINFlexD_10 (*(volatile struct LINFlexD_tag *) 0xFFEA0000UL)
#define LINFlexD_11 (*(volatile struct LINFlexD_tag *) 0xFBEA0000UL)
#define LINFlexD_12 (*(volatile struct LINFlexD_tag *) 0xFFEA4000UL)
#define LINFlexD_13 (*(volatile struct LINFlexD_tag *) 0xFBEA4000UL)
#define LINFlexD_14 (*(volatile struct LINFlexD_tag *) 0xFFEA8000UL)
#define LINFlexD_15 (*(volatile struct LINFlexD_tag *) 0xFBEA8000UL)
#define LINFlexD_2 (*(volatile struct LINFlexD_tag *) 0xFFE90000UL)
#define LINFlexD_3 (*(volatile struct LINFlexD_tag *) 0xFBE90000UL)
#define LINFlexD_4 (*(volatile struct LINFlexD_tag *) 0xFFE94000UL)
#define LINFlexD_5 (*(volatile struct LINFlexD_tag *) 0xFBE94000UL)
#define LINFlexD_6 (*(volatile struct LINFlexD_tag *) 0xFFE98000UL)
#define LINFlexD_7 (*(volatile struct LINFlexD_tag *) 0xFBE98000UL)
#define LINFlexD_8 (*(volatile struct LINFlexD_tag *) 0xFFE9C000UL)
#define LINFlexD_9 (*(volatile struct LINFlexD_tag *) 0xFBE9C000UL)
#define LPU (*(volatile struct LPU_tag *) 0xFFF9C000UL)
#define MC_CGM (*(volatile struct MC_CGM_tag *) 0xFFFB0000UL)
#define MC_ME (*(volatile struct MC_ME_tag *) 0xFFFB8000UL)
#define MC_PCU (*(volatile struct MC_PCU_tag *) 0xFFFA0000UL)
#define MC_RGM (*(volatile struct MC_RGM_tag *) 0xFFFA8000UL)
#define MEMU_0 (*(volatile struct MEMU_0_tag *) 0xFFF50000UL)
#define MEMU_1 (*(volatile struct MEMU_1_tag *) 0xFFFEC000UL)
#define PASS (*(volatile struct PASS_tag *) 0xFFFF4000UL)
#define PCM (*(volatile struct PCM_tag *) 0xFC028000UL)
#define PFLASH (*(volatile struct PFLASH_tag *) 0xFC030000UL)
#define PIT (*(volatile struct PIT_tag *) 0xFFF84000UL)
#define PLLDIG (*(volatile struct PLLDIG_tag *) 0xFFFB0080UL)
#define PMCDIG (*(volatile struct PMCDIG_tag *) 0xFFFA0400UL)
#define PRAMC_0 (*(volatile struct PRAMC_tag *) 0xFC020000UL)
#define PRAMC_1 (*(volatile struct PRAMC_tag *) 0xFC024000UL)
#define RTC (*(volatile struct RTC_tag *) 0xFFFF0000UL)
#define SEMA42 (*(volatile struct SEMA42_tag *) 0xFC03C000UL)
#define SIRC (*(volatile struct SIRC_tag *) 0xFFFB00C0UL)
#define SIUL2 (*(volatile struct SIUL2_tag *) 0xFFFC0000UL)
#define SMPU_0 (*(volatile struct SMPU_tag *) 0xFC010000UL)
#define SMPU_1 (*(volatile struct SMPU_tag *) 0xFC014000UL)
#define SSCM (*(volatile struct SSCM_tag *) 0xFFFF8000UL)
#define STCU2 (*(volatile struct STCU2_tag *) 0xFFF44000UL)
#define STM_0 (*(volatile struct STM_tag *) 0xFC068000UL)
#define STM_1 (*(volatile struct STM_tag *) 0xFC06C000UL)
#define SWT_0 (*(volatile struct SWT_tag *) 0xFC050000UL)
#define SWT_1 (*(volatile struct SWT_tag *) 0xFC054000UL)
#define SXOSC (*(volatile struct SXOSC_tag *) 0xFFFB0100UL)
#define TDM (*(volatile struct TDM_tag *) 0xFFF34000UL)
#define WKPU (*(volatile struct WKPU_tag *) 0xFFF98000UL)
#define eMIOS_0 (*(volatile struct eMIOS_tag *) 0xFFC38000UL)
#define eMIOS_1 (*(volatile struct eMIOS_tag *) 0xFBC38000UL)

/* ADC */
#define ADC_0_MCR            ADC_0.MCR.R                   /* Main Configuration Register */
#define ADC_0_MSR            ADC_0.MSR.R                   /* Main Status register */
#define ADC_0_ISR            ADC_0.ISR.R                   /* Interrupt Status Register */
#define ADC_0_CEOCFR0        ADC_0.CEOCFR0.R               /* Channel Pending register 0 */
#define ADC_0_CEOCFR1        ADC_0.CEOCFR1.R               /* Channel Pending register 1 */
#define ADC_0_CEOCFR2        ADC_0.CEOCFR2.R               /* Channel Pending register 2 */
#define ADC_0_IMR            ADC_0.IMR.R                   /* Interrupt Mask Register */
#define ADC_0_CIMR0          ADC_0.CIMR0.R                 /* Channel Interrupt Mask Register 0 */
#define ADC_0_CIMR1          ADC_0.CIMR1.R                 /* Channel Interrupt Mask Register 1 */
#define ADC_0_CIMR2          ADC_0.CIMR2.R                 /* Channel Interrupt Mask Register 2 */
#define ADC_0_WTISR          ADC_0.WTISR.R                 /* Watchdog Threshold Interrupt Status Register */
#define ADC_0_WTIMR          ADC_0.WTIMR.R                 /* Watchdog Threshold Interrupt Mask Register */
#define ADC_0_DMAE           ADC_0.DMAE.R                  /* DMA Enable register */
#define ADC_0_DMAR0          ADC_0.DMAR0.R                 /* DMA Channel Select Register 0 */
#define ADC_0_DMAR1          ADC_0.DMAR1.R                 /* DMA Channel Select Register 1 */
#define ADC_0_DMAR2          ADC_0.DMAR2.R                 /* DMA Channel Select Register 2 */
#define ADC_0_THRHLR0        ADC_0.THRHLR0.R               /* Threshold Register */
#define ADC_0_THRHLR1        ADC_0.THRHLR1.R               /* Threshold Register */
#define ADC_0_THRHLR2        ADC_0.THRHLR2.R               /* Threshold Register */
#define ADC_0_THRHLR3        ADC_0.THRHLR3.R               /* Threshold Register */
#define ADC_0_PSCR           ADC_0.PSCR.R                  /* Presampling Control Register */
#define ADC_0_PSR0           ADC_0.PSR0.R                  /* Presampling register 0 */
#define ADC_0_PSR1           ADC_0.PSR1.R                  /* Presampling register 1 */
#define ADC_0_PSR2           ADC_0.PSR2.R                  /* Presampling register 2 */
#define ADC_0_CTR0           ADC_0.CTR0.R                  /* Conversion Timing Register 0 */
#define ADC_0_CTR1           ADC_0.CTR1.R                  /* Conversion Timing Register 1 */
#define ADC_0_CTR2           ADC_0.CTR2.R                  /* Conversion Timing Register 2 */
#define ADC_0_NCMR0          ADC_0.NCMR0.R                 /* Normal Conversion Mask Register 0 */
#define ADC_0_NCMR1          ADC_0.NCMR1.R                 /* Normal Conversion Mask Register 1 */
#define ADC_0_NCMR2          ADC_0.NCMR2.R                 /* Normal Conversion Mask Register 2 */
#define ADC_0_JCMR0          ADC_0.JCMR0.R                 /* Injected Conversion Mask Register 0 */
#define ADC_0_JCMR1          ADC_0.JCMR1.R                 /* Injected Conversion Mask Register 1 */
#define ADC_0_JCMR2          ADC_0.JCMR2.R                 /* Injected Conversion Mask Register 2 */
#define ADC_0_DSDR           ADC_0.DSDR.R                  /* Decode Signals Delay Register */
#define ADC_0_PDEDR          ADC_0.PDEDR.R                 /* Power Down Exit Delay Register */
#define ADC_0_CDR0           ADC_0.CDR[0].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR1           ADC_0.CDR[1].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR2           ADC_0.CDR[2].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR3           ADC_0.CDR[3].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR4           ADC_0.CDR[4].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR5           ADC_0.CDR[5].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR6           ADC_0.CDR[6].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR7           ADC_0.CDR[7].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR8           ADC_0.CDR[8].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR9           ADC_0.CDR[9].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR10          ADC_0.CDR[10].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR11          ADC_0.CDR[11].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR12          ADC_0.CDR[12].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR13          ADC_0.CDR[13].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR14          ADC_0.CDR[14].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR15          ADC_0.CDR[15].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR16          ADC_0.CDR[16].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR17          ADC_0.CDR[17].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR18          ADC_0.CDR[18].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR19          ADC_0.CDR[19].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR20          ADC_0.CDR[20].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR21          ADC_0.CDR[21].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR22          ADC_0.CDR[22].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR23          ADC_0.CDR[23].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR24          ADC_0.CDR[24].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR25          ADC_0.CDR[25].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR26          ADC_0.CDR[26].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR27          ADC_0.CDR[27].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR28          ADC_0.CDR[28].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR29          ADC_0.CDR[29].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR30          ADC_0.CDR[30].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR31          ADC_0.CDR[31].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR32          ADC_0.CDR[32].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR33          ADC_0.CDR[33].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR34          ADC_0.CDR[34].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR35          ADC_0.CDR[35].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR36          ADC_0.CDR[36].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR37          ADC_0.CDR[37].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR38          ADC_0.CDR[38].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR39          ADC_0.CDR[39].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR40          ADC_0.CDR[40].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR41          ADC_0.CDR[41].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR42          ADC_0.CDR[42].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR43          ADC_0.CDR[43].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR44          ADC_0.CDR[44].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR45          ADC_0.CDR[45].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR46          ADC_0.CDR[46].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR47          ADC_0.CDR[47].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR48          ADC_0.CDR[48].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR49          ADC_0.CDR[49].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR50          ADC_0.CDR[50].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR51          ADC_0.CDR[51].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR52          ADC_0.CDR[52].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR53          ADC_0.CDR[53].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR54          ADC_0.CDR[54].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR55          ADC_0.CDR[55].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR56          ADC_0.CDR[56].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR57          ADC_0.CDR[57].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR58          ADC_0.CDR[58].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR59          ADC_0.CDR[59].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR60          ADC_0.CDR[60].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR61          ADC_0.CDR[61].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR62          ADC_0.CDR[62].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR63          ADC_0.CDR[63].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR64          ADC_0.CDR[64].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR65          ADC_0.CDR[65].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR66          ADC_0.CDR[66].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR67          ADC_0.CDR[67].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR68          ADC_0.CDR[68].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR69          ADC_0.CDR[69].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR70          ADC_0.CDR[70].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR71          ADC_0.CDR[71].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR72          ADC_0.CDR[72].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR73          ADC_0.CDR[73].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR74          ADC_0.CDR[74].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR75          ADC_0.CDR[75].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR76          ADC_0.CDR[76].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR77          ADC_0.CDR[77].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR78          ADC_0.CDR[78].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR79          ADC_0.CDR[79].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR80          ADC_0.CDR[80].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR81          ADC_0.CDR[81].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR82          ADC_0.CDR[82].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR83          ADC_0.CDR[83].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR84          ADC_0.CDR[84].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR85          ADC_0.CDR[85].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR86          ADC_0.CDR[86].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR87          ADC_0.CDR[87].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR88          ADC_0.CDR[88].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR89          ADC_0.CDR[89].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR90          ADC_0.CDR[90].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR91          ADC_0.CDR[91].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR92          ADC_0.CDR[92].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR93          ADC_0.CDR[93].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR94          ADC_0.CDR[94].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR95          ADC_0.CDR[95].R               /* Channel Data Register n (External Channels) */
#define ADC_0_THRHLR4        ADC_0.THRHLR4.R               /* Threshold Register */
#define ADC_0_THRHLR5        ADC_0.THRHLR5.R               /* Threshold Register */
#define ADC_0_CWSELR0        ADC_0.CWSELR0.R               /* Channel Watchdog Select Register 0 */
#define ADC_0_CWSELR1        ADC_0.CWSELR1.R               /* Channel Watchdog Select Register 1 */
#define ADC_0_CWSELR2        ADC_0.CWSELR2.R               /* Channel Watchdog Select Register 2 */
#define ADC_0_CWSELR4        ADC_0.CWSELR4.R               /* Channel Watchdog Select Register 4 */
#define ADC_0_CWSELR5        ADC_0.CWSELR5.R               /* Channel Watchdog Select Register 5 */
#define ADC_0_CWSELR6        ADC_0.CWSELR6.R               /* Channel Watchdog Select Register 6 */
#define ADC_0_CWSELR7        ADC_0.CWSELR7.R               /* Channel Watchdog Select Register 7 */
#define ADC_0_CWSELR8        ADC_0.CWSELR8.R               /* Channel Watchdog Select Register 8 */
#define ADC_0_CWSELR9        ADC_0.CWSELR9.R               /* Channel Watchdog Select Register 9 */
#define ADC_0_CWSELR10       ADC_0.CWSELR10.R              /* Channel Watchdog Select Register 10 */
#define ADC_0_CWSELR11       ADC_0.CWSELR11.R              /* Channel Watchdog Select Register 11 */
#define ADC_0_CWENR0         ADC_0.CWENR0.R                /* Channel Watchdog Enable Register 0 */
#define ADC_0_CWENR1         ADC_0.CWENR1.R                /* Channel Watchdog Enable Register 1 */
#define ADC_0_CWENR2         ADC_0.CWENR2.R                /* Channel Watchdog Enable Register 2 */
#define ADC_0_AWORR0         ADC_0.AWORR0.R                /* Analog Watchdog Out of Range Register 0 */
#define ADC_0_AWORR1         ADC_0.AWORR1.R                /* Analog Watchdog Out of Range Register 1 */
#define ADC_0_AWORR2         ADC_0.AWORR2.R                /* Analog Watchdog Out of Range Register 2 */
#define ADC_0_STCR1          ADC_0.STCR1.R                 /* Self Test Configuration Register 1 */
#define ADC_0_STCR2          ADC_0.STCR2.R                 /* Self Test Configuration Register 2 */
#define ADC_0_STCR3          ADC_0.STCR3.R                 /* Self Test Configuration Register 3 */
#define ADC_0_STBRR          ADC_0.STBRR.R                 /* Self Test Baud Rate Register */
#define ADC_0_STSR1          ADC_0.STSR1.R                 /* Self Test Status Register 1 */
#define ADC_0_STSR2          ADC_0.STSR2.R                 /* Self Test Status Register 2 */
#define ADC_0_STSR3          ADC_0.STSR3.R                 /* Self Test Status Register 3 */
#define ADC_0_STSR4          ADC_0.STSR4.R                 /* Self Test Status Register 4 */
#define ADC_0_STDR1          ADC_0.STDR1.R                 /* Self Test Data Register 1 */
#define ADC_0_STDR2          ADC_0.STDR2.R                 /* Self Test Data Register 2 */
#define ADC_0_STAW0R         ADC_0.STAW0R.R                /* Self Test Analog Watchdog Register 0 */
#define ADC_0_STAW1AR        ADC_0.STAW1AR.R               /* Self Test Analog Watchdog Register 1A */
#define ADC_0_STAW1BR        ADC_0.STAW1BR.R               /* Self Test Analog Watchdog Register 1B */
#define ADC_0_STAW2R         ADC_0.STAW2R.R                /* Self Test Analog Watchdog Register 2 */
#define ADC_0_STAW4R         ADC_0.STAW4R.R                /* Self Test Analog Watchdog Register 4 */
#define ADC_0_STAW5R         ADC_0.STAW5R.R                /* Self Test Analog Watchdog Register 5 */
#define ADC_0_CALBISTREG     ADC_0.CALBISTREG.R            /* Calibration, BIST Control and status Register */
#define ADC_0_OFSGNUSR       ADC_0.OFSGNUSR.R              /* Offset and Gain User Register */

/* ADC */
#define ADC_1_MCR            ADC_1.MCR.R                   /* Main Configuration Register */
#define ADC_1_MSR            ADC_1.MSR.R                   /* Main Status register */
#define ADC_1_ISR            ADC_1.ISR.R                   /* Interrupt Status Register */
#define ADC_1_CEOCFR0        ADC_1.CEOCFR0.R               /* Channel Pending register 0 */
#define ADC_1_CEOCFR1        ADC_1.CEOCFR1.R               /* Channel Pending register 1 */
#define ADC_1_CEOCFR2        ADC_1.CEOCFR2.R               /* Channel Pending register 2 */
#define ADC_1_IMR            ADC_1.IMR.R                   /* Interrupt Mask Register */
#define ADC_1_CIMR0          ADC_1.CIMR0.R                 /* Channel Interrupt Mask Register 0 */
#define ADC_1_CIMR1          ADC_1.CIMR1.R                 /* Channel Interrupt Mask Register 1 */
#define ADC_1_CIMR2          ADC_1.CIMR2.R                 /* Channel Interrupt Mask Register 2 */
#define ADC_1_WTISR          ADC_1.WTISR.R                 /* Watchdog Threshold Interrupt Status Register */
#define ADC_1_WTIMR          ADC_1.WTIMR.R                 /* Watchdog Threshold Interrupt Mask Register */
#define ADC_1_DMAE           ADC_1.DMAE.R                  /* DMA Enable register */
#define ADC_1_DMAR0          ADC_1.DMAR0.R                 /* DMA Channel Select Register 0 */
#define ADC_1_DMAR1          ADC_1.DMAR1.R                 /* DMA Channel Select Register 1 */
#define ADC_1_DMAR2          ADC_1.DMAR2.R                 /* DMA Channel Select Register 2 */
#define ADC_1_THRHLR0        ADC_1.THRHLR0.R               /* Threshold Register */
#define ADC_1_THRHLR1        ADC_1.THRHLR1.R               /* Threshold Register */
#define ADC_1_THRHLR2        ADC_1.THRHLR2.R               /* Threshold Register */
#define ADC_1_THRHLR3        ADC_1.THRHLR3.R               /* Threshold Register */
#define ADC_1_PSCR           ADC_1.PSCR.R                  /* Presampling Control Register */
#define ADC_1_PSR0           ADC_1.PSR0.R                  /* Presampling register 0 */
#define ADC_1_PSR1           ADC_1.PSR1.R                  /* Presampling register 1 */
#define ADC_1_PSR2           ADC_1.PSR2.R                  /* Presampling register 2 */
#define ADC_1_CTR0           ADC_1.CTR0.R                  /* Conversion Timing Register 0 */
#define ADC_1_CTR1           ADC_1.CTR1.R                  /* Conversion Timing Register 1 */
#define ADC_1_CTR2           ADC_1.CTR2.R                  /* Conversion Timing Register 2 */
#define ADC_1_NCMR0          ADC_1.NCMR0.R                 /* Normal Conversion Mask Register 0 */
#define ADC_1_NCMR1          ADC_1.NCMR1.R                 /* Normal Conversion Mask Register 1 */
#define ADC_1_NCMR2          ADC_1.NCMR2.R                 /* Normal Conversion Mask Register 2 */
#define ADC_1_JCMR0          ADC_1.JCMR0.R                 /* Injected Conversion Mask Register 0 */
#define ADC_1_JCMR1          ADC_1.JCMR1.R                 /* Injected Conversion Mask Register 1 */
#define ADC_1_JCMR2          ADC_1.JCMR2.R                 /* Injected Conversion Mask Register 2 */
#define ADC_1_DSDR           ADC_1.DSDR.R                  /* Decode Signals Delay Register */
#define ADC_1_PDEDR          ADC_1.PDEDR.R                 /* Power Down Exit Delay Register */
#define ADC_1_CDR0           ADC_1.CDR[0].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR1           ADC_1.CDR[1].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR2           ADC_1.CDR[2].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR3           ADC_1.CDR[3].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR4           ADC_1.CDR[4].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR5           ADC_1.CDR[5].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR6           ADC_1.CDR[6].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR7           ADC_1.CDR[7].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR8           ADC_1.CDR[8].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR9           ADC_1.CDR[9].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR10          ADC_1.CDR[10].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR11          ADC_1.CDR[11].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR12          ADC_1.CDR[12].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR13          ADC_1.CDR[13].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR14          ADC_1.CDR[14].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR15          ADC_1.CDR[15].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR16          ADC_1.CDR[16].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR17          ADC_1.CDR[17].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR18          ADC_1.CDR[18].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR19          ADC_1.CDR[19].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR20          ADC_1.CDR[20].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR21          ADC_1.CDR[21].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR22          ADC_1.CDR[22].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR23          ADC_1.CDR[23].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR24          ADC_1.CDR[24].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR25          ADC_1.CDR[25].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR26          ADC_1.CDR[26].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR27          ADC_1.CDR[27].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR28          ADC_1.CDR[28].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR29          ADC_1.CDR[29].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR30          ADC_1.CDR[30].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR31          ADC_1.CDR[31].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR32          ADC_1.CDR[32].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR33          ADC_1.CDR[33].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR34          ADC_1.CDR[34].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR35          ADC_1.CDR[35].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR36          ADC_1.CDR[36].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR37          ADC_1.CDR[37].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR38          ADC_1.CDR[38].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR39          ADC_1.CDR[39].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR40          ADC_1.CDR[40].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR41          ADC_1.CDR[41].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR42          ADC_1.CDR[42].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR43          ADC_1.CDR[43].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR44          ADC_1.CDR[44].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR45          ADC_1.CDR[45].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR46          ADC_1.CDR[46].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR47          ADC_1.CDR[47].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR48          ADC_1.CDR[48].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR49          ADC_1.CDR[49].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR50          ADC_1.CDR[50].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR51          ADC_1.CDR[51].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR52          ADC_1.CDR[52].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR53          ADC_1.CDR[53].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR54          ADC_1.CDR[54].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR55          ADC_1.CDR[55].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR56          ADC_1.CDR[56].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR57          ADC_1.CDR[57].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR58          ADC_1.CDR[58].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR59          ADC_1.CDR[59].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR60          ADC_1.CDR[60].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR61          ADC_1.CDR[61].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR62          ADC_1.CDR[62].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR63          ADC_1.CDR[63].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR64          ADC_1.CDR[64].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR65          ADC_1.CDR[65].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR66          ADC_1.CDR[66].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR67          ADC_1.CDR[67].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR68          ADC_1.CDR[68].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR69          ADC_1.CDR[69].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR70          ADC_1.CDR[70].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR71          ADC_1.CDR[71].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR72          ADC_1.CDR[72].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR73          ADC_1.CDR[73].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR74          ADC_1.CDR[74].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR75          ADC_1.CDR[75].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR76          ADC_1.CDR[76].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR77          ADC_1.CDR[77].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR78          ADC_1.CDR[78].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR79          ADC_1.CDR[79].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR80          ADC_1.CDR[80].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR81          ADC_1.CDR[81].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR82          ADC_1.CDR[82].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR83          ADC_1.CDR[83].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR84          ADC_1.CDR[84].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR85          ADC_1.CDR[85].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR86          ADC_1.CDR[86].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR87          ADC_1.CDR[87].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR88          ADC_1.CDR[88].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR89          ADC_1.CDR[89].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR90          ADC_1.CDR[90].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR91          ADC_1.CDR[91].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR92          ADC_1.CDR[92].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR93          ADC_1.CDR[93].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR94          ADC_1.CDR[94].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR95          ADC_1.CDR[95].R               /* Channel Data Register n (External Channels) */
#define ADC_1_THRHLR4        ADC_1.THRHLR4.R               /* Threshold Register */
#define ADC_1_THRHLR5        ADC_1.THRHLR5.R               /* Threshold Register */
#define ADC_1_CWSELR0        ADC_1.CWSELR0.R               /* Channel Watchdog Select Register 0 */
#define ADC_1_CWSELR1        ADC_1.CWSELR1.R               /* Channel Watchdog Select Register 1 */
#define ADC_1_CWSELR2        ADC_1.CWSELR2.R               /* Channel Watchdog Select Register 2 */
#define ADC_1_CWSELR4        ADC_1.CWSELR4.R               /* Channel Watchdog Select Register 4 */
#define ADC_1_CWSELR5        ADC_1.CWSELR5.R               /* Channel Watchdog Select Register 5 */
#define ADC_1_CWSELR6        ADC_1.CWSELR6.R               /* Channel Watchdog Select Register 6 */
#define ADC_1_CWSELR7        ADC_1.CWSELR7.R               /* Channel Watchdog Select Register 7 */
#define ADC_1_CWSELR8        ADC_1.CWSELR8.R               /* Channel Watchdog Select Register 8 */
#define ADC_1_CWSELR9        ADC_1.CWSELR9.R               /* Channel Watchdog Select Register 9 */
#define ADC_1_CWSELR10       ADC_1.CWSELR10.R              /* Channel Watchdog Select Register 10 */
#define ADC_1_CWSELR11       ADC_1.CWSELR11.R              /* Channel Watchdog Select Register 11 */
#define ADC_1_CWENR0         ADC_1.CWENR0.R                /* Channel Watchdog Enable Register 0 */
#define ADC_1_CWENR1         ADC_1.CWENR1.R                /* Channel Watchdog Enable Register 1 */
#define ADC_1_CWENR2         ADC_1.CWENR2.R                /* Channel Watchdog Enable Register 2 */
#define ADC_1_AWORR0         ADC_1.AWORR0.R                /* Analog Watchdog Out of Range Register 0 */
#define ADC_1_AWORR1         ADC_1.AWORR1.R                /* Analog Watchdog Out of Range Register 1 */
#define ADC_1_AWORR2         ADC_1.AWORR2.R                /* Analog Watchdog Out of Range Register 2 */
#define ADC_1_STCR1          ADC_1.STCR1.R                 /* Self Test Configuration Register 1 */
#define ADC_1_STCR2          ADC_1.STCR2.R                 /* Self Test Configuration Register 2 */
#define ADC_1_STCR3          ADC_1.STCR3.R                 /* Self Test Configuration Register 3 */
#define ADC_1_STBRR          ADC_1.STBRR.R                 /* Self Test Baud Rate Register */
#define ADC_1_STSR1          ADC_1.STSR1.R                 /* Self Test Status Register 1 */
#define ADC_1_STSR2          ADC_1.STSR2.R                 /* Self Test Status Register 2 */
#define ADC_1_STSR3          ADC_1.STSR3.R                 /* Self Test Status Register 3 */
#define ADC_1_STSR4          ADC_1.STSR4.R                 /* Self Test Status Register 4 */
#define ADC_1_STDR1          ADC_1.STDR1.R                 /* Self Test Data Register 1 */
#define ADC_1_STDR2          ADC_1.STDR2.R                 /* Self Test Data Register 2 */
#define ADC_1_STAW0R         ADC_1.STAW0R.R                /* Self Test Analog Watchdog Register 0 */
#define ADC_1_STAW1AR        ADC_1.STAW1AR.R               /* Self Test Analog Watchdog Register 1A */
#define ADC_1_STAW1BR        ADC_1.STAW1BR.R               /* Self Test Analog Watchdog Register 1B */
#define ADC_1_STAW2R         ADC_1.STAW2R.R                /* Self Test Analog Watchdog Register 2 */
#define ADC_1_STAW4R         ADC_1.STAW4R.R                /* Self Test Analog Watchdog Register 4 */
#define ADC_1_STAW5R         ADC_1.STAW5R.R                /* Self Test Analog Watchdog Register 5 */
#define ADC_1_CALBISTREG     ADC_1.CALBISTREG.R            /* Calibration, BIST Control and status Register */
#define ADC_1_OFSGNUSR       ADC_1.OFSGNUSR.R              /* Offset and Gain User Register */

/* AIPS */
#define AIPS_A_MPRA          AIPS_A.MPRA.R                 /* Master Privilege Register A */
#define AIPS_A_MPRB          AIPS_A.MPRB.R                 /* Master Privilege Register B */
#define AIPS_A_PACRA         AIPS_A.PACR[0].R              /* Peripheral Access Control Register */
#define AIPS_A_PACRB         AIPS_A.PACR[1].R              /* Peripheral Access Control Register */
#define AIPS_A_PACRC         AIPS_A.PACR[2].R              /* Peripheral Access Control Register */
#define AIPS_A_PACRD         AIPS_A.PACR[3].R              /* Peripheral Access Control Register */
#define AIPS_A_OPACRA        AIPS_A.OPACR[0].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRB        AIPS_A.OPACR[1].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRC        AIPS_A.OPACR[2].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRD        AIPS_A.OPACR[3].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRE        AIPS_A.OPACR[4].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRF        AIPS_A.OPACR[5].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRG        AIPS_A.OPACR[6].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRH        AIPS_A.OPACR[7].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRI        AIPS_A.OPACR[8].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRJ        AIPS_A.OPACR[9].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRK        AIPS_A.OPACR[10].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRL        AIPS_A.OPACR[11].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRM        AIPS_A.OPACR[12].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRN        AIPS_A.OPACR[13].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRO        AIPS_A.OPACR[14].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRP        AIPS_A.OPACR[15].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRQ        AIPS_A.OPACR[16].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRR        AIPS_A.OPACR[17].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRS        AIPS_A.OPACR[18].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRT        AIPS_A.OPACR[19].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRU        AIPS_A.OPACR[20].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRV        AIPS_A.OPACR[21].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRW        AIPS_A.OPACR[22].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRX        AIPS_A.OPACR[23].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRY        AIPS_A.OPACR[24].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRZ        AIPS_A.OPACR[25].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRAA       AIPS_A.OPACR[26].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRAB       AIPS_A.OPACR[27].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRAC       AIPS_A.OPACR[28].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRAD       AIPS_A.OPACR[29].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRAE       AIPS_A.OPACR[30].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRAF       AIPS_A.OPACR[31].R            /* Off-Platform Peripheral Access Control Register */

/* AIPS */
#define AIPS_B_MPRA          AIPS_B.MPRA.R                 /* Master Privilege Register A */
#define AIPS_B_MPRB          AIPS_B.MPRB.R                 /* Master Privilege Register B */
#define AIPS_B_PACRA         AIPS_B.PACR[0].R              /* Peripheral Access Control Register */
#define AIPS_B_PACRB         AIPS_B.PACR[1].R              /* Peripheral Access Control Register */
#define AIPS_B_PACRC         AIPS_B.PACR[2].R              /* Peripheral Access Control Register */
#define AIPS_B_PACRD         AIPS_B.PACR[3].R              /* Peripheral Access Control Register */
#define AIPS_B_OPACRA        AIPS_B.OPACR[0].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRB        AIPS_B.OPACR[1].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRC        AIPS_B.OPACR[2].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRD        AIPS_B.OPACR[3].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRE        AIPS_B.OPACR[4].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRF        AIPS_B.OPACR[5].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRG        AIPS_B.OPACR[6].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRH        AIPS_B.OPACR[7].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRI        AIPS_B.OPACR[8].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRJ        AIPS_B.OPACR[9].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRK        AIPS_B.OPACR[10].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRL        AIPS_B.OPACR[11].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRM        AIPS_B.OPACR[12].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRN        AIPS_B.OPACR[13].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRO        AIPS_B.OPACR[14].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRP        AIPS_B.OPACR[15].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRQ        AIPS_B.OPACR[16].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRR        AIPS_B.OPACR[17].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRS        AIPS_B.OPACR[18].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRT        AIPS_B.OPACR[19].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRU        AIPS_B.OPACR[20].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRV        AIPS_B.OPACR[21].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRW        AIPS_B.OPACR[22].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRX        AIPS_B.OPACR[23].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRY        AIPS_B.OPACR[24].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRZ        AIPS_B.OPACR[25].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRAA       AIPS_B.OPACR[26].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRAB       AIPS_B.OPACR[27].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRAC       AIPS_B.OPACR[28].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRAD       AIPS_B.OPACR[29].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRAE       AIPS_B.OPACR[30].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRAF       AIPS_B.OPACR[31].R            /* Off-Platform Peripheral Access Control Register */

/* AXBS */
#define AXBS_0_PRS0          AXBS_0.PORT[0].PRS.R          /* Priority Registers Slave */
#define AXBS_0_CRS0          AXBS_0.PORT[0].CRS.R          /* Control Register */
#define AXBS_0_PRS1          AXBS_0.PORT[1].PRS.R          /* Priority Registers Slave */
#define AXBS_0_CRS1          AXBS_0.PORT[1].CRS.R          /* Control Register */
#define AXBS_0_PRS2          AXBS_0.PORT[2].PRS.R          /* Priority Registers Slave */
#define AXBS_0_CRS2          AXBS_0.PORT[2].CRS.R          /* Control Register */
#define AXBS_0_PRS3          AXBS_0.PORT[3].PRS.R          /* Priority Registers Slave */
#define AXBS_0_CRS3          AXBS_0.PORT[3].CRS.R          /* Control Register */
#define AXBS_0_PRS4          AXBS_0.PORT[4].PRS.R          /* Priority Registers Slave */
#define AXBS_0_CRS4          AXBS_0.PORT[4].CRS.R          /* Control Register */
#define AXBS_0_PRS5          AXBS_0.PORT[5].PRS.R          /* Priority Registers Slave */
#define AXBS_0_CRS5          AXBS_0.PORT[5].CRS.R          /* Control Register */
#define AXBS_0_PRS6          AXBS_0.PORT[6].PRS.R          /* Priority Registers Slave */
#define AXBS_0_CRS6          AXBS_0.PORT[6].CRS.R          /* Control Register */
#define AXBS_0_PRS7          AXBS_0.PORT[7].PRS.R          /* Priority Registers Slave */
#define AXBS_0_CRS7          AXBS_0.PORT[7].CRS.R          /* Control Register */
#define AXBS_0_MGPCR0        AXBS_0.MGPCR[0].MGPCR.R       /* Master General Purpose Control Register */
#define AXBS_0_MGPCR1        AXBS_0.MGPCR[1].MGPCR.R       /* Master General Purpose Control Register */
#define AXBS_0_MGPCR2        AXBS_0.MGPCR[2].MGPCR.R       /* Master General Purpose Control Register */
#define AXBS_0_MGPCR3        AXBS_0.MGPCR[3].MGPCR.R       /* Master General Purpose Control Register */
#define AXBS_0_MGPCR4        AXBS_0.MGPCR[4].MGPCR.R       /* Master General Purpose Control Register */
#define AXBS_0_MGPCR5        AXBS_0.MGPCR[5].MGPCR.R       /* Master General Purpose Control Register */
#define AXBS_0_MGPCR6        AXBS_0.MGPCR[6].MGPCR.R       /* Master General Purpose Control Register */
#define AXBS_0_MGPCR7        AXBS_0.MGPCR[7].MGPCR.R       /* Master General Purpose Control Register */

/* BCTU */
#define BCTU_MCR             BCTU.MCR.R                    /* Module Configuration Register */
#define BCTU_MSR             BCTU.MSR.R                    /* Module Status register */
#define BCTU_TRGCFG_0        BCTU.TRGCFG[0].R              /* Trigger Configuration Register */
#define BCTU_TRGCFG_1        BCTU.TRGCFG[1].R              /* Trigger Configuration Register */
#define BCTU_TRGCFG_2        BCTU.TRGCFG[2].R              /* Trigger Configuration Register */
#define BCTU_TRGCFG_3        BCTU.TRGCFG[3].R              /* Trigger Configuration Register */
#define BCTU_TRGCFG_4        BCTU.TRGCFG[4].R              /* Trigger Configuration Register */
#define BCTU_TRGCFG_5        BCTU.TRGCFG[5].R              /* Trigger Configuration Register */
#define BCTU_TRGCFG_6        BCTU.TRGCFG[6].R              /* Trigger Configuration Register */
#define BCTU_TRGCFG_7        BCTU.TRGCFG[7].R              /* Trigger Configuration Register */
#define BCTU_TRGCFG_8        BCTU.TRGCFG[8].R              /* Trigger Configuration Register */
#define BCTU_TRGCFG_9        BCTU.TRGCFG[9].R              /* Trigger Configuration Register */
#define BCTU_TRGCFG_10       BCTU.TRGCFG[10].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_11       BCTU.TRGCFG[11].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_12       BCTU.TRGCFG[12].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_13       BCTU.TRGCFG[13].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_14       BCTU.TRGCFG[14].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_15       BCTU.TRGCFG[15].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_16       BCTU.TRGCFG[16].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_17       BCTU.TRGCFG[17].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_18       BCTU.TRGCFG[18].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_19       BCTU.TRGCFG[19].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_20       BCTU.TRGCFG[20].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_21       BCTU.TRGCFG[21].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_22       BCTU.TRGCFG[22].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_23       BCTU.TRGCFG[23].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_24       BCTU.TRGCFG[24].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_25       BCTU.TRGCFG[25].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_26       BCTU.TRGCFG[26].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_27       BCTU.TRGCFG[27].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_28       BCTU.TRGCFG[28].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_29       BCTU.TRGCFG[29].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_30       BCTU.TRGCFG[30].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_31       BCTU.TRGCFG[31].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_32       BCTU.TRGCFG[32].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_33       BCTU.TRGCFG[33].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_34       BCTU.TRGCFG[34].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_35       BCTU.TRGCFG[35].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_36       BCTU.TRGCFG[36].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_37       BCTU.TRGCFG[37].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_38       BCTU.TRGCFG[38].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_39       BCTU.TRGCFG[39].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_40       BCTU.TRGCFG[40].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_41       BCTU.TRGCFG[41].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_42       BCTU.TRGCFG[42].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_43       BCTU.TRGCFG[43].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_44       BCTU.TRGCFG[44].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_45       BCTU.TRGCFG[45].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_46       BCTU.TRGCFG[46].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_47       BCTU.TRGCFG[47].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_48       BCTU.TRGCFG[48].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_49       BCTU.TRGCFG[49].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_50       BCTU.TRGCFG[50].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_51       BCTU.TRGCFG[51].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_52       BCTU.TRGCFG[52].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_53       BCTU.TRGCFG[53].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_54       BCTU.TRGCFG[54].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_55       BCTU.TRGCFG[55].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_56       BCTU.TRGCFG[56].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_57       BCTU.TRGCFG[57].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_58       BCTU.TRGCFG[58].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_59       BCTU.TRGCFG[59].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_60       BCTU.TRGCFG[60].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_61       BCTU.TRGCFG[61].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_62       BCTU.TRGCFG[62].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_63       BCTU.TRGCFG[63].R             /* Trigger Configuration Register */
#define BCTU_WRPROT          BCTU.WRPROT.R                 /* Write Protection register */
#define BCTU_SFTRGR1         BCTU.SFTRGR1.R                /* Software Trigger register 1 */
#define BCTU_SFTRGR2         BCTU.SFTRGR2.R                /* Software Trigger register 1 */
#define BCTU_SFTRGR3         BCTU.SFTRGR3.R                /* Software Trigger register 1 */
#define BCTU_ADC0DR          BCTU.ADC0DR.R                 /* ADC0 Result Data register */
#define BCTU_ADC1DR          BCTU.ADC1DR.R                 /* ADC1 result data register */
#define BCTU_LISTSTAR        BCTU.LISTSTAR.R               /* LIST Size Status register */
#define BCTU_LISTCHR_0       BCTU.LISTCHR[0].R             /* LIST Channel Address Register */
#define BCTU_LISTCHR_1       BCTU.LISTCHR[1].R             /* LIST Channel Address Register */
#define BCTU_LISTCHR_2       BCTU.LISTCHR[2].R             /* LIST Channel Address Register */
#define BCTU_LISTCHR_3       BCTU.LISTCHR[3].R             /* LIST Channel Address Register */
#define BCTU_LISTCHR_4       BCTU.LISTCHR[4].R             /* LIST Channel Address Register */
#define BCTU_LISTCHR_5       BCTU.LISTCHR[5].R             /* LIST Channel Address Register */
#define BCTU_LISTCHR_6       BCTU.LISTCHR[6].R             /* LIST Channel Address Register */
#define BCTU_LISTCHR_7       BCTU.LISTCHR[7].R             /* LIST Channel Address Register */
#define BCTU_LISTCHR_8       BCTU.LISTCHR[8].R             /* LIST Channel Address Register */
#define BCTU_LISTCHR_9       BCTU.LISTCHR[9].R             /* LIST Channel Address Register */
#define BCTU_LISTCHR_10      BCTU.LISTCHR[10].R            /* LIST Channel Address Register */
#define BCTU_LISTCHR_11      BCTU.LISTCHR[11].R            /* LIST Channel Address Register */
#define BCTU_LISTCHR_12      BCTU.LISTCHR[12].R            /* LIST Channel Address Register */
#define BCTU_LISTCHR_13      BCTU.LISTCHR[13].R            /* LIST Channel Address Register */
#define BCTU_LISTCHR_14      BCTU.LISTCHR[14].R            /* LIST Channel Address Register */
#define BCTU_LISTCHR_15      BCTU.LISTCHR[15].R            /* LIST Channel Address Register */

/* C55FMC */
#define C55FMC_MCR           C55FMC.MCR.R                  /* Module Configuration Register */
#define C55FMC_MCRE          C55FMC.MCRE.R                 /* Extended Module Configuration Register */
#define C55FMC_LOCK0         C55FMC.LOCK0.R                /* Lock 0 register */
#define C55FMC_LOCK1         C55FMC.LOCK1.R                /* Lock 1 register */
#define C55FMC_LOCK2         C55FMC.LOCK2.R                /* Lock 2 register */
#define C55FMC_LOCK3         C55FMC.LOCK3.R                /* Lock 3 register */
#define C55FMC_SEL0          C55FMC.SEL0.R                 /* Select 0 register */
#define C55FMC_SEL1          C55FMC.SEL1.R                 /* Select 1 register */
#define C55FMC_SEL2          C55FMC.SEL2.R                 /* Select 2 register */
#define C55FMC_SEL3          C55FMC.SEL3.R                 /* Select 3 register */
#define C55FMC_ADR           C55FMC.ADR.R                  /* Address register */
#define C55FMC_UT0           C55FMC.UT0.R                  /* UTest 0 register */
#define C55FMC_UM0           C55FMC.UM[0].R                /* UMISR register */
#define C55FMC_UM1           C55FMC.UM[1].R                /* UMISR register */
#define C55FMC_UM2           C55FMC.UM[2].R                /* UMISR register */
#define C55FMC_UM3           C55FMC.UM[3].R                /* UMISR register */
#define C55FMC_UM4           C55FMC.UM[4].R                /* UMISR register */
#define C55FMC_UM5           C55FMC.UM[5].R                /* UMISR register */
#define C55FMC_UM6           C55FMC.UM[6].R                /* UMISR register */
#define C55FMC_UM7           C55FMC.UM[7].R                /* UMISR register */
#define C55FMC_UM8           C55FMC.UM[8].R                /* UMISR register */
#define C55FMC_UM9           C55FMC.UM9.R                  /* UMISR register */
#define C55FMC_OPP0          C55FMC.OPP0.R                 /* Over-Program Protection 0 register */
#define C55FMC_OPP1          C55FMC.OPP1.R                 /* Over-Program Protection 1 register */
#define C55FMC_OPP2          C55FMC.OPP2.R                 /* Over-Program Protection 2 register */
#define C55FMC_OPP3          C55FMC.OPP3.R                 /* Over-Program Protection 3 register */
#define C55FMC_TMD           C55FMC.TMD.R                  /* Test Mode Disable Password Check register */

/* CAN */
#define CAN_MCR              CAN.MCR.R                     /* Module Configuration Register */
#define CAN_CTRL1            CAN.CTRL1.R                   /* Control 1 register */
#define CAN_TIMER            CAN.TIMER.R                   /* Free Running Timer */
#define CAN_RXMGMASK         CAN.RXMGMASK.R                /* Rx Mailboxes Global Mask Register */
#define CAN_RX14MASK         CAN.RX14MASK.R                /* Rx 14 Mask register */
#define CAN_RX15MASK         CAN.RX15MASK.R                /* Rx 15 Mask register */
#define CAN_ECR              CAN.ECR.R                     /* Error Counter */
#define CAN_ESR1             CAN.ESR1.R                    /* Error and Status 1 register */
#define CAN_IMASK2           CAN.IMASK2.R                  /* Interrupt Masks 2 register */
#define CAN_IMASK1           CAN.IMASK1.R                  /* Interrupt Masks 1 register */
#define CAN_IFLAG2           CAN.IFLAG2.R                  /* Interrupt Flags 2 register */
#define CAN_IFLAG1           CAN.IFLAG1.R                  /* Interrupt Flags 1 register */
#define CAN_CTRL2            CAN.CTRL2.R                   /* Control 2 register */
#define CAN_ESR2             CAN.ESR2.R                    /* Error and Status 2 register */
#define CAN_CRCR             CAN.CRCR.R                    /* CRC Register */
#define CAN_RXFGMASK         CAN.RXFGMASK.R                /* Rx FIFO Global Mask register */
#define CAN_RXFIR            CAN.RXFIR.R                   /* Rx FIFO Information Register */
#define CAN_CBT              CAN.CBT.R                     /* CAN Bit Timing Register */
#define CAN_IMASK3           CAN.IMASK3.R                  /* Interrupt Masks 3 Register */
#define CAN_IFLAG3           CAN.IFLAG3.R                  /* Interrupt Flags 3 Register */
#define CAN_CS0              CAN.MB[0].CS.R                /* Message Buffer 0 CS Register */
#define CAN_ID0              CAN.MB[0].ID.R                /* Message Buffer 0 ID Register */
#define CAN_B0               CAN.MB[0].DATA.B              /* Message Buffer 0 B Register */
#define CAN_H0               CAN.MB[0].DATA.H              /* Message Buffer 0 H Register */
#define CAN_W0               CAN.MB[0].DATA.W              /* Message Buffer 0 W Register */
#define CAN_CS1              CAN.MB[1].CS.R                /* Message Buffer 1 CS Register */
#define CAN_ID1              CAN.MB[1].ID.R                /* Message Buffer 1 ID Register */
#define CAN_B1               CAN.MB[1].DATA.B              /* Message Buffer 1 B Register */
#define CAN_H1               CAN.MB[1].DATA.H              /* Message Buffer 1 H Register */
#define CAN_W1               CAN.MB[1].DATA.W              /* Message Buffer 1 W Register */
#define CAN_CS2              CAN.MB[2].CS.R                /* Message Buffer 2 CS Register */
#define CAN_ID2              CAN.MB[2].ID.R                /* Message Buffer 2 ID Register */
#define CAN_B2               CAN.MB[2].DATA.B              /* Message Buffer 2 B Register */
#define CAN_H2               CAN.MB[2].DATA.H              /* Message Buffer 2 H Register */
#define CAN_W2               CAN.MB[2].DATA.W              /* Message Buffer 2 W Register */
#define CAN_CS3              CAN.MB[3].CS.R                /* Message Buffer 3 CS Register */
#define CAN_ID3              CAN.MB[3].ID.R                /* Message Buffer 3 ID Register */
#define CAN_B3               CAN.MB[3].DATA.B              /* Message Buffer 3 B Register */
#define CAN_H3               CAN.MB[3].DATA.H              /* Message Buffer 3 H Register */
#define CAN_W3               CAN.MB[3].DATA.W              /* Message Buffer 3 W Register */
#define CAN_CS4              CAN.MB[4].CS.R                /* Message Buffer 4 CS Register */
#define CAN_ID4              CAN.MB[4].ID.R                /* Message Buffer 4 ID Register */
#define CAN_B4               CAN.MB[4].DATA.B              /* Message Buffer 4 B Register */
#define CAN_H4               CAN.MB[4].DATA.H              /* Message Buffer 4 H Register */
#define CAN_W4               CAN.MB[4].DATA.W              /* Message Buffer 4 W Register */
#define CAN_CS5              CAN.MB[5].CS.R                /* Message Buffer 5 CS Register */
#define CAN_ID5              CAN.MB[5].ID.R                /* Message Buffer 5 ID Register */
#define CAN_B5               CAN.MB[5].DATA.B              /* Message Buffer 5 B Register */
#define CAN_H5               CAN.MB[5].DATA.H              /* Message Buffer 5 H Register */
#define CAN_W5               CAN.MB[5].DATA.W              /* Message Buffer 5 W Register */
#define CAN_CS6              CAN.MB[6].CS.R                /* Message Buffer 6 CS Register */
#define CAN_ID6              CAN.MB[6].ID.R                /* Message Buffer 6 ID Register */
#define CAN_B6               CAN.MB[6].DATA.B              /* Message Buffer 6 B Register */
#define CAN_H6               CAN.MB[6].DATA.H              /* Message Buffer 6 H Register */
#define CAN_W6               CAN.MB[6].DATA.W              /* Message Buffer 6 W Register */
#define CAN_CS7              CAN.MB[7].CS.R                /* Message Buffer 7 CS Register */
#define CAN_ID7              CAN.MB[7].ID.R                /* Message Buffer 7 ID Register */
#define CAN_B7               CAN.MB[7].DATA.B              /* Message Buffer 7 B Register */
#define CAN_H7               CAN.MB[7].DATA.H              /* Message Buffer 7 H Register */
#define CAN_W7               CAN.MB[7].DATA.W              /* Message Buffer 7 W Register */
#define CAN_CS8              CAN.MB[8].CS.R                /* Message Buffer 8 CS Register */
#define CAN_ID8              CAN.MB[8].ID.R                /* Message Buffer 8 ID Register */
#define CAN_B8               CAN.MB[8].DATA.B              /* Message Buffer 8 B Register */
#define CAN_H8               CAN.MB[8].DATA.H              /* Message Buffer 8 H Register */
#define CAN_W8               CAN.MB[8].DATA.W              /* Message Buffer 8 W Register */
#define CAN_CS9              CAN.MB[9].CS.R                /* Message Buffer 9 CS Register */
#define CAN_ID9              CAN.MB[9].ID.R                /* Message Buffer 9 ID Register */
#define CAN_B9               CAN.MB[9].DATA.B              /* Message Buffer 9 B Register */
#define CAN_H9               CAN.MB[9].DATA.H              /* Message Buffer 9 H Register */
#define CAN_W9               CAN.MB[9].DATA.W              /* Message Buffer 9 W Register */
#define CAN_CS10             CAN.MB[10].CS.R               /* Message Buffer 10 CS Register */
#define CAN_ID10             CAN.MB[10].ID.R               /* Message Buffer 10 ID Register */
#define CAN_B10              CAN.MB[10].DATA.B             /* Message Buffer 10 B Register */
#define CAN_H10              CAN.MB[10].DATA.H             /* Message Buffer 10 H Register */
#define CAN_W10              CAN.MB[10].DATA.W             /* Message Buffer 10 W Register */
#define CAN_CS11             CAN.MB[11].CS.R               /* Message Buffer 11 CS Register */
#define CAN_ID11             CAN.MB[11].ID.R               /* Message Buffer 11 ID Register */
#define CAN_B11              CAN.MB[11].DATA.B             /* Message Buffer 11 B Register */
#define CAN_H11              CAN.MB[11].DATA.H             /* Message Buffer 11 H Register */
#define CAN_W11              CAN.MB[11].DATA.W             /* Message Buffer 11 W Register */
#define CAN_CS12             CAN.MB[12].CS.R               /* Message Buffer 12 CS Register */
#define CAN_ID12             CAN.MB[12].ID.R               /* Message Buffer 12 ID Register */
#define CAN_B12              CAN.MB[12].DATA.B             /* Message Buffer 12 B Register */
#define CAN_H12              CAN.MB[12].DATA.H             /* Message Buffer 12 H Register */
#define CAN_W12              CAN.MB[12].DATA.W             /* Message Buffer 12 W Register */
#define CAN_CS13             CAN.MB[13].CS.R               /* Message Buffer 13 CS Register */
#define CAN_ID13             CAN.MB[13].ID.R               /* Message Buffer 13 ID Register */
#define CAN_B13              CAN.MB[13].DATA.B             /* Message Buffer 13 B Register */
#define CAN_H13              CAN.MB[13].DATA.H             /* Message Buffer 13 H Register */
#define CAN_W13              CAN.MB[13].DATA.W             /* Message Buffer 13 W Register */
#define CAN_CS14             CAN.MB[14].CS.R               /* Message Buffer 14 CS Register */
#define CAN_ID14             CAN.MB[14].ID.R               /* Message Buffer 14 ID Register */
#define CAN_B14              CAN.MB[14].DATA.B             /* Message Buffer 14 B Register */
#define CAN_H14              CAN.MB[14].DATA.H             /* Message Buffer 14 H Register */
#define CAN_W14              CAN.MB[14].DATA.W             /* Message Buffer 14 W Register */
#define CAN_CS15             CAN.MB[15].CS.R               /* Message Buffer 15 CS Register */
#define CAN_ID15             CAN.MB[15].ID.R               /* Message Buffer 15 ID Register */
#define CAN_B15              CAN.MB[15].DATA.B             /* Message Buffer 15 B Register */
#define CAN_H15              CAN.MB[15].DATA.H             /* Message Buffer 15 H Register */
#define CAN_W15              CAN.MB[15].DATA.W             /* Message Buffer 15 W Register */
#define CAN_CS16             CAN.MB[16].CS.R               /* Message Buffer 16 CS Register */
#define CAN_ID16             CAN.MB[16].ID.R               /* Message Buffer 16 ID Register */
#define CAN_B16              CAN.MB[16].DATA.B             /* Message Buffer 16 B Register */
#define CAN_H16              CAN.MB[16].DATA.H             /* Message Buffer 16 H Register */
#define CAN_W16              CAN.MB[16].DATA.W             /* Message Buffer 16 W Register */
#define CAN_CS17             CAN.MB[17].CS.R               /* Message Buffer 17 CS Register */
#define CAN_ID17             CAN.MB[17].ID.R               /* Message Buffer 17 ID Register */
#define CAN_B17              CAN.MB[17].DATA.B             /* Message Buffer 17 B Register */
#define CAN_H17              CAN.MB[17].DATA.H             /* Message Buffer 17 H Register */
#define CAN_W17              CAN.MB[17].DATA.W             /* Message Buffer 17 W Register */
#define CAN_CS18             CAN.MB[18].CS.R               /* Message Buffer 18 CS Register */
#define CAN_ID18             CAN.MB[18].ID.R               /* Message Buffer 18 ID Register */
#define CAN_B18              CAN.MB[18].DATA.B             /* Message Buffer 18 B Register */
#define CAN_H18              CAN.MB[18].DATA.H             /* Message Buffer 18 H Register */
#define CAN_W18              CAN.MB[18].DATA.W             /* Message Buffer 18 W Register */
#define CAN_CS19             CAN.MB[19].CS.R               /* Message Buffer 19 CS Register */
#define CAN_ID19             CAN.MB[19].ID.R               /* Message Buffer 19 ID Register */
#define CAN_B19              CAN.MB[19].DATA.B             /* Message Buffer 19 B Register */
#define CAN_H19              CAN.MB[19].DATA.H             /* Message Buffer 19 H Register */
#define CAN_W19              CAN.MB[19].DATA.W             /* Message Buffer 19 W Register */
#define CAN_CS20             CAN.MB[20].CS.R               /* Message Buffer 20 CS Register */
#define CAN_ID20             CAN.MB[20].ID.R               /* Message Buffer 20 ID Register */
#define CAN_B20              CAN.MB[20].DATA.B             /* Message Buffer 20 B Register */
#define CAN_H20              CAN.MB[20].DATA.H             /* Message Buffer 20 H Register */
#define CAN_W20              CAN.MB[20].DATA.W             /* Message Buffer 20 W Register */
#define CAN_CS21             CAN.MB[21].CS.R               /* Message Buffer 21 CS Register */
#define CAN_ID21             CAN.MB[21].ID.R               /* Message Buffer 21 ID Register */
#define CAN_B21              CAN.MB[21].DATA.B             /* Message Buffer 21 B Register */
#define CAN_H21              CAN.MB[21].DATA.H             /* Message Buffer 21 H Register */
#define CAN_W21              CAN.MB[21].DATA.W             /* Message Buffer 21 W Register */
#define CAN_CS22             CAN.MB[22].CS.R               /* Message Buffer 22 CS Register */
#define CAN_ID22             CAN.MB[22].ID.R               /* Message Buffer 22 ID Register */
#define CAN_B22              CAN.MB[22].DATA.B             /* Message Buffer 22 B Register */
#define CAN_H22              CAN.MB[22].DATA.H             /* Message Buffer 22 H Register */
#define CAN_W22              CAN.MB[22].DATA.W             /* Message Buffer 22 W Register */
#define CAN_CS23             CAN.MB[23].CS.R               /* Message Buffer 23 CS Register */
#define CAN_ID23             CAN.MB[23].ID.R               /* Message Buffer 23 ID Register */
#define CAN_B23              CAN.MB[23].DATA.B             /* Message Buffer 23 B Register */
#define CAN_H23              CAN.MB[23].DATA.H             /* Message Buffer 23 H Register */
#define CAN_W23              CAN.MB[23].DATA.W             /* Message Buffer 23 W Register */
#define CAN_CS24             CAN.MB[24].CS.R               /* Message Buffer 24 CS Register */
#define CAN_ID24             CAN.MB[24].ID.R               /* Message Buffer 24 ID Register */
#define CAN_B24              CAN.MB[24].DATA.B             /* Message Buffer 24 B Register */
#define CAN_H24              CAN.MB[24].DATA.H             /* Message Buffer 24 H Register */
#define CAN_W24              CAN.MB[24].DATA.W             /* Message Buffer 24 W Register */
#define CAN_CS25             CAN.MB[25].CS.R               /* Message Buffer 25 CS Register */
#define CAN_ID25             CAN.MB[25].ID.R               /* Message Buffer 25 ID Register */
#define CAN_B25              CAN.MB[25].DATA.B             /* Message Buffer 25 B Register */
#define CAN_H25              CAN.MB[25].DATA.H             /* Message Buffer 25 H Register */
#define CAN_W25              CAN.MB[25].DATA.W             /* Message Buffer 25 W Register */
#define CAN_CS26             CAN.MB[26].CS.R               /* Message Buffer 26 CS Register */
#define CAN_ID26             CAN.MB[26].ID.R               /* Message Buffer 26 ID Register */
#define CAN_B26              CAN.MB[26].DATA.B             /* Message Buffer 26 B Register */
#define CAN_H26              CAN.MB[26].DATA.H             /* Message Buffer 26 H Register */
#define CAN_W26              CAN.MB[26].DATA.W             /* Message Buffer 26 W Register */
#define CAN_CS27             CAN.MB[27].CS.R               /* Message Buffer 27 CS Register */
#define CAN_ID27             CAN.MB[27].ID.R               /* Message Buffer 27 ID Register */
#define CAN_B27              CAN.MB[27].DATA.B             /* Message Buffer 27 B Register */
#define CAN_H27              CAN.MB[27].DATA.H             /* Message Buffer 27 H Register */
#define CAN_W27              CAN.MB[27].DATA.W             /* Message Buffer 27 W Register */
#define CAN_CS28             CAN.MB[28].CS.R               /* Message Buffer 28 CS Register */
#define CAN_ID28             CAN.MB[28].ID.R               /* Message Buffer 28 ID Register */
#define CAN_B28              CAN.MB[28].DATA.B             /* Message Buffer 28 B Register */
#define CAN_H28              CAN.MB[28].DATA.H             /* Message Buffer 28 H Register */
#define CAN_W28              CAN.MB[28].DATA.W             /* Message Buffer 28 W Register */
#define CAN_CS29             CAN.MB[29].CS.R               /* Message Buffer 29 CS Register */
#define CAN_ID29             CAN.MB[29].ID.R               /* Message Buffer 29 ID Register */
#define CAN_B29              CAN.MB[29].DATA.B             /* Message Buffer 29 B Register */
#define CAN_H29              CAN.MB[29].DATA.H             /* Message Buffer 29 H Register */
#define CAN_W29              CAN.MB[29].DATA.W             /* Message Buffer 29 W Register */
#define CAN_CS30             CAN.MB[30].CS.R               /* Message Buffer 30 CS Register */
#define CAN_ID30             CAN.MB[30].ID.R               /* Message Buffer 30 ID Register */
#define CAN_B30              CAN.MB[30].DATA.B             /* Message Buffer 30 B Register */
#define CAN_H30              CAN.MB[30].DATA.H             /* Message Buffer 30 H Register */
#define CAN_W30              CAN.MB[30].DATA.W             /* Message Buffer 30 W Register */
#define CAN_CS31             CAN.MB[31].CS.R               /* Message Buffer 31 CS Register */
#define CAN_ID31             CAN.MB[31].ID.R               /* Message Buffer 31 ID Register */
#define CAN_B31              CAN.MB[31].DATA.B             /* Message Buffer 31 B Register */
#define CAN_H31              CAN.MB[31].DATA.H             /* Message Buffer 31 H Register */
#define CAN_W31              CAN.MB[31].DATA.W             /* Message Buffer 31 W Register */
#define CAN_CS32             CAN.MB[32].CS.R               /* Message Buffer 32 CS Register */
#define CAN_ID32             CAN.MB[32].ID.R               /* Message Buffer 32 ID Register */
#define CAN_B32              CAN.MB[32].DATA.B             /* Message Buffer 32 B Register */
#define CAN_H32              CAN.MB[32].DATA.H             /* Message Buffer 32 H Register */
#define CAN_W32              CAN.MB[32].DATA.W             /* Message Buffer 32 W Register */
#define CAN_CS33             CAN.MB[33].CS.R               /* Message Buffer 33 CS Register */
#define CAN_ID33             CAN.MB[33].ID.R               /* Message Buffer 33 ID Register */
#define CAN_B33              CAN.MB[33].DATA.B             /* Message Buffer 33 B Register */
#define CAN_H33              CAN.MB[33].DATA.H             /* Message Buffer 33 H Register */
#define CAN_W33              CAN.MB[33].DATA.W             /* Message Buffer 33 W Register */
#define CAN_CS34             CAN.MB[34].CS.R               /* Message Buffer 34 CS Register */
#define CAN_ID34             CAN.MB[34].ID.R               /* Message Buffer 34 ID Register */
#define CAN_B34              CAN.MB[34].DATA.B             /* Message Buffer 34 B Register */
#define CAN_H34              CAN.MB[34].DATA.H             /* Message Buffer 34 H Register */
#define CAN_W34              CAN.MB[34].DATA.W             /* Message Buffer 34 W Register */
#define CAN_CS35             CAN.MB[35].CS.R               /* Message Buffer 35 CS Register */
#define CAN_ID35             CAN.MB[35].ID.R               /* Message Buffer 35 ID Register */
#define CAN_B35              CAN.MB[35].DATA.B             /* Message Buffer 35 B Register */
#define CAN_H35              CAN.MB[35].DATA.H             /* Message Buffer 35 H Register */
#define CAN_W35              CAN.MB[35].DATA.W             /* Message Buffer 35 W Register */
#define CAN_CS36             CAN.MB[36].CS.R               /* Message Buffer 36 CS Register */
#define CAN_ID36             CAN.MB[36].ID.R               /* Message Buffer 36 ID Register */
#define CAN_B36              CAN.MB[36].DATA.B             /* Message Buffer 36 B Register */
#define CAN_H36              CAN.MB[36].DATA.H             /* Message Buffer 36 H Register */
#define CAN_W36              CAN.MB[36].DATA.W             /* Message Buffer 36 W Register */
#define CAN_CS37             CAN.MB[37].CS.R               /* Message Buffer 37 CS Register */
#define CAN_ID37             CAN.MB[37].ID.R               /* Message Buffer 37 ID Register */
#define CAN_B37              CAN.MB[37].DATA.B             /* Message Buffer 37 B Register */
#define CAN_H37              CAN.MB[37].DATA.H             /* Message Buffer 37 H Register */
#define CAN_W37              CAN.MB[37].DATA.W             /* Message Buffer 37 W Register */
#define CAN_CS38             CAN.MB[38].CS.R               /* Message Buffer 38 CS Register */
#define CAN_ID38             CAN.MB[38].ID.R               /* Message Buffer 38 ID Register */
#define CAN_B38              CAN.MB[38].DATA.B             /* Message Buffer 38 B Register */
#define CAN_H38              CAN.MB[38].DATA.H             /* Message Buffer 38 H Register */
#define CAN_W38              CAN.MB[38].DATA.W             /* Message Buffer 38 W Register */
#define CAN_CS39             CAN.MB[39].CS.R               /* Message Buffer 39 CS Register */
#define CAN_ID39             CAN.MB[39].ID.R               /* Message Buffer 39 ID Register */
#define CAN_B39              CAN.MB[39].DATA.B             /* Message Buffer 39 B Register */
#define CAN_H39              CAN.MB[39].DATA.H             /* Message Buffer 39 H Register */
#define CAN_W39              CAN.MB[39].DATA.W             /* Message Buffer 39 W Register */
#define CAN_CS40             CAN.MB[40].CS.R               /* Message Buffer 40 CS Register */
#define CAN_ID40             CAN.MB[40].ID.R               /* Message Buffer 40 ID Register */
#define CAN_B40              CAN.MB[40].DATA.B             /* Message Buffer 40 B Register */
#define CAN_H40              CAN.MB[40].DATA.H             /* Message Buffer 40 H Register */
#define CAN_W40              CAN.MB[40].DATA.W             /* Message Buffer 40 W Register */
#define CAN_CS41             CAN.MB[41].CS.R               /* Message Buffer 41 CS Register */
#define CAN_ID41             CAN.MB[41].ID.R               /* Message Buffer 41 ID Register */
#define CAN_B41              CAN.MB[41].DATA.B             /* Message Buffer 41 B Register */
#define CAN_H41              CAN.MB[41].DATA.H             /* Message Buffer 41 H Register */
#define CAN_W41              CAN.MB[41].DATA.W             /* Message Buffer 41 W Register */
#define CAN_CS42             CAN.MB[42].CS.R               /* Message Buffer 42 CS Register */
#define CAN_ID42             CAN.MB[42].ID.R               /* Message Buffer 42 ID Register */
#define CAN_B42              CAN.MB[42].DATA.B             /* Message Buffer 42 B Register */
#define CAN_H42              CAN.MB[42].DATA.H             /* Message Buffer 42 H Register */
#define CAN_W42              CAN.MB[42].DATA.W             /* Message Buffer 42 W Register */
#define CAN_CS43             CAN.MB[43].CS.R               /* Message Buffer 43 CS Register */
#define CAN_ID43             CAN.MB[43].ID.R               /* Message Buffer 43 ID Register */
#define CAN_B43              CAN.MB[43].DATA.B             /* Message Buffer 43 B Register */
#define CAN_H43              CAN.MB[43].DATA.H             /* Message Buffer 43 H Register */
#define CAN_W43              CAN.MB[43].DATA.W             /* Message Buffer 43 W Register */
#define CAN_CS44             CAN.MB[44].CS.R               /* Message Buffer 44 CS Register */
#define CAN_ID44             CAN.MB[44].ID.R               /* Message Buffer 44 ID Register */
#define CAN_B44              CAN.MB[44].DATA.B             /* Message Buffer 44 B Register */
#define CAN_H44              CAN.MB[44].DATA.H             /* Message Buffer 44 H Register */
#define CAN_W44              CAN.MB[44].DATA.W             /* Message Buffer 44 W Register */
#define CAN_CS45             CAN.MB[45].CS.R               /* Message Buffer 45 CS Register */
#define CAN_ID45             CAN.MB[45].ID.R               /* Message Buffer 45 ID Register */
#define CAN_B45              CAN.MB[45].DATA.B             /* Message Buffer 45 B Register */
#define CAN_H45              CAN.MB[45].DATA.H             /* Message Buffer 45 H Register */
#define CAN_W45              CAN.MB[45].DATA.W             /* Message Buffer 45 W Register */
#define CAN_CS46             CAN.MB[46].CS.R               /* Message Buffer 46 CS Register */
#define CAN_ID46             CAN.MB[46].ID.R               /* Message Buffer 46 ID Register */
#define CAN_B46              CAN.MB[46].DATA.B             /* Message Buffer 46 B Register */
#define CAN_H46              CAN.MB[46].DATA.H             /* Message Buffer 46 H Register */
#define CAN_W46              CAN.MB[46].DATA.W             /* Message Buffer 46 W Register */
#define CAN_CS47             CAN.MB[47].CS.R               /* Message Buffer 47 CS Register */
#define CAN_ID47             CAN.MB[47].ID.R               /* Message Buffer 47 ID Register */
#define CAN_B47              CAN.MB[47].DATA.B             /* Message Buffer 47 B Register */
#define CAN_H47              CAN.MB[47].DATA.H             /* Message Buffer 47 H Register */
#define CAN_W47              CAN.MB[47].DATA.W             /* Message Buffer 47 W Register */
#define CAN_CS48             CAN.MB[48].CS.R               /* Message Buffer 48 CS Register */
#define CAN_ID48             CAN.MB[48].ID.R               /* Message Buffer 48 ID Register */
#define CAN_B48              CAN.MB[48].DATA.B             /* Message Buffer 48 B Register */
#define CAN_H48              CAN.MB[48].DATA.H             /* Message Buffer 48 H Register */
#define CAN_W48              CAN.MB[48].DATA.W             /* Message Buffer 48 W Register */
#define CAN_CS49             CAN.MB[49].CS.R               /* Message Buffer 49 CS Register */
#define CAN_ID49             CAN.MB[49].ID.R               /* Message Buffer 49 ID Register */
#define CAN_B49              CAN.MB[49].DATA.B             /* Message Buffer 49 B Register */
#define CAN_H49              CAN.MB[49].DATA.H             /* Message Buffer 49 H Register */
#define CAN_W49              CAN.MB[49].DATA.W             /* Message Buffer 49 W Register */
#define CAN_CS50             CAN.MB[50].CS.R               /* Message Buffer 50 CS Register */
#define CAN_ID50             CAN.MB[50].ID.R               /* Message Buffer 50 ID Register */
#define CAN_B50              CAN.MB[50].DATA.B             /* Message Buffer 50 B Register */
#define CAN_H50              CAN.MB[50].DATA.H             /* Message Buffer 50 H Register */
#define CAN_W50              CAN.MB[50].DATA.W             /* Message Buffer 50 W Register */
#define CAN_CS51             CAN.MB[51].CS.R               /* Message Buffer 51 CS Register */
#define CAN_ID51             CAN.MB[51].ID.R               /* Message Buffer 51 ID Register */
#define CAN_B51              CAN.MB[51].DATA.B             /* Message Buffer 51 B Register */
#define CAN_H51              CAN.MB[51].DATA.H             /* Message Buffer 51 H Register */
#define CAN_W51              CAN.MB[51].DATA.W             /* Message Buffer 51 W Register */
#define CAN_CS52             CAN.MB[52].CS.R               /* Message Buffer 52 CS Register */
#define CAN_ID52             CAN.MB[52].ID.R               /* Message Buffer 52 ID Register */
#define CAN_B52              CAN.MB[52].DATA.B             /* Message Buffer 52 B Register */
#define CAN_H52              CAN.MB[52].DATA.H             /* Message Buffer 52 H Register */
#define CAN_W52              CAN.MB[52].DATA.W             /* Message Buffer 52 W Register */
#define CAN_CS53             CAN.MB[53].CS.R               /* Message Buffer 53 CS Register */
#define CAN_ID53             CAN.MB[53].ID.R               /* Message Buffer 53 ID Register */
#define CAN_B53              CAN.MB[53].DATA.B             /* Message Buffer 53 B Register */
#define CAN_H53              CAN.MB[53].DATA.H             /* Message Buffer 53 H Register */
#define CAN_W53              CAN.MB[53].DATA.W             /* Message Buffer 53 W Register */
#define CAN_CS54             CAN.MB[54].CS.R               /* Message Buffer 54 CS Register */
#define CAN_ID54             CAN.MB[54].ID.R               /* Message Buffer 54 ID Register */
#define CAN_B54              CAN.MB[54].DATA.B             /* Message Buffer 54 B Register */
#define CAN_H54              CAN.MB[54].DATA.H             /* Message Buffer 54 H Register */
#define CAN_W54              CAN.MB[54].DATA.W             /* Message Buffer 54 W Register */
#define CAN_CS55             CAN.MB[55].CS.R               /* Message Buffer 55 CS Register */
#define CAN_ID55             CAN.MB[55].ID.R               /* Message Buffer 55 ID Register */
#define CAN_B55              CAN.MB[55].DATA.B             /* Message Buffer 55 B Register */
#define CAN_H55              CAN.MB[55].DATA.H             /* Message Buffer 55 H Register */
#define CAN_W55              CAN.MB[55].DATA.W             /* Message Buffer 55 W Register */
#define CAN_CS56             CAN.MB[56].CS.R               /* Message Buffer 56 CS Register */
#define CAN_ID56             CAN.MB[56].ID.R               /* Message Buffer 56 ID Register */
#define CAN_B56              CAN.MB[56].DATA.B             /* Message Buffer 56 B Register */
#define CAN_H56              CAN.MB[56].DATA.H             /* Message Buffer 56 H Register */
#define CAN_W56              CAN.MB[56].DATA.W             /* Message Buffer 56 W Register */
#define CAN_CS57             CAN.MB[57].CS.R               /* Message Buffer 57 CS Register */
#define CAN_ID57             CAN.MB[57].ID.R               /* Message Buffer 57 ID Register */
#define CAN_B57              CAN.MB[57].DATA.B             /* Message Buffer 57 B Register */
#define CAN_H57              CAN.MB[57].DATA.H             /* Message Buffer 57 H Register */
#define CAN_W57              CAN.MB[57].DATA.W             /* Message Buffer 57 W Register */
#define CAN_CS58             CAN.MB[58].CS.R               /* Message Buffer 58 CS Register */
#define CAN_ID58             CAN.MB[58].ID.R               /* Message Buffer 58 ID Register */
#define CAN_B58              CAN.MB[58].DATA.B             /* Message Buffer 58 B Register */
#define CAN_H58              CAN.MB[58].DATA.H             /* Message Buffer 58 H Register */
#define CAN_W58              CAN.MB[58].DATA.W             /* Message Buffer 58 W Register */
#define CAN_CS59             CAN.MB[59].CS.R               /* Message Buffer 59 CS Register */
#define CAN_ID59             CAN.MB[59].ID.R               /* Message Buffer 59 ID Register */
#define CAN_B59              CAN.MB[59].DATA.B             /* Message Buffer 59 B Register */
#define CAN_H59              CAN.MB[59].DATA.H             /* Message Buffer 59 H Register */
#define CAN_W59              CAN.MB[59].DATA.W             /* Message Buffer 59 W Register */
#define CAN_CS60             CAN.MB[60].CS.R               /* Message Buffer 60 CS Register */
#define CAN_ID60             CAN.MB[60].ID.R               /* Message Buffer 60 ID Register */
#define CAN_B60              CAN.MB[60].DATA.B             /* Message Buffer 60 B Register */
#define CAN_H60              CAN.MB[60].DATA.H             /* Message Buffer 60 H Register */
#define CAN_W60              CAN.MB[60].DATA.W             /* Message Buffer 60 W Register */
#define CAN_CS61             CAN.MB[61].CS.R               /* Message Buffer 61 CS Register */
#define CAN_ID61             CAN.MB[61].ID.R               /* Message Buffer 61 ID Register */
#define CAN_B61              CAN.MB[61].DATA.B             /* Message Buffer 61 B Register */
#define CAN_H61              CAN.MB[61].DATA.H             /* Message Buffer 61 H Register */
#define CAN_W61              CAN.MB[61].DATA.W             /* Message Buffer 61 W Register */
#define CAN_CS62             CAN.MB[62].CS.R               /* Message Buffer 62 CS Register */
#define CAN_ID62             CAN.MB[62].ID.R               /* Message Buffer 62 ID Register */
#define CAN_B62              CAN.MB[62].DATA.B             /* Message Buffer 62 B Register */
#define CAN_H62              CAN.MB[62].DATA.H             /* Message Buffer 62 H Register */
#define CAN_W62              CAN.MB[62].DATA.W             /* Message Buffer 62 W Register */
#define CAN_CS63             CAN.MB[63].CS.R               /* Message Buffer 63 CS Register */
#define CAN_ID63             CAN.MB[63].ID.R               /* Message Buffer 63 ID Register */
#define CAN_B63              CAN.MB[63].DATA.B             /* Message Buffer 63 B Register */
#define CAN_H63              CAN.MB[63].DATA.H             /* Message Buffer 63 H Register */
#define CAN_W63              CAN.MB[63].DATA.W             /* Message Buffer 63 W Register */
#define CAN_RXIMR0           CAN.RXIMR[0].R                /* Rx Individual Mask Registers */
#define CAN_RXIMR1           CAN.RXIMR[1].R                /* Rx Individual Mask Registers */
#define CAN_RXIMR2           CAN.RXIMR[2].R                /* Rx Individual Mask Registers */
#define CAN_RXIMR3           CAN.RXIMR[3].R                /* Rx Individual Mask Registers */
#define CAN_RXIMR4           CAN.RXIMR[4].R                /* Rx Individual Mask Registers */
#define CAN_RXIMR5           CAN.RXIMR[5].R                /* Rx Individual Mask Registers */
#define CAN_RXIMR6           CAN.RXIMR[6].R                /* Rx Individual Mask Registers */
#define CAN_RXIMR7           CAN.RXIMR[7].R                /* Rx Individual Mask Registers */
#define CAN_RXIMR8           CAN.RXIMR[8].R                /* Rx Individual Mask Registers */
#define CAN_RXIMR9           CAN.RXIMR[9].R                /* Rx Individual Mask Registers */
#define CAN_RXIMR10          CAN.RXIMR[10].R               /* Rx Individual Mask Registers */
#define CAN_RXIMR11          CAN.RXIMR[11].R               /* Rx Individual Mask Registers */
#define CAN_RXIMR12          CAN.RXIMR[12].R               /* Rx Individual Mask Registers */
#define CAN_RXIMR13          CAN.RXIMR[13].R               /* Rx Individual Mask Registers */
#define CAN_RXIMR14          CAN.RXIMR[14].R               /* Rx Individual Mask Registers */
#define CAN_RXIMR15          CAN.RXIMR[15].R               /* Rx Individual Mask Registers */
#define CAN_RXIMR16          CAN.RXIMR[16].R               /* Rx Individual Mask Registers */
#define CAN_RXIMR17          CAN.RXIMR[17].R               /* Rx Individual Mask Registers */
#define CAN_RXIMR18          CAN.RXIMR[18].R               /* Rx Individual Mask Registers */
#define CAN_RXIMR19          CAN.RXIMR[19].R               /* Rx Individual Mask Registers */
#define CAN_RXIMR20          CAN.RXIMR[20].R               /* Rx Individual Mask Registers */
#define CAN_RXIMR21          CAN.RXIMR[21].R               /* Rx Individual Mask Registers */
#define CAN_RXIMR22          CAN.RXIMR[22].R               /* Rx Individual Mask Registers */
#define CAN_RXIMR23          CAN.RXIMR[23].R               /* Rx Individual Mask Registers */
#define CAN_RXIMR24          CAN.RXIMR[24].R               /* Rx Individual Mask Registers */
#define CAN_RXIMR25          CAN.RXIMR[25].R               /* Rx Individual Mask Registers */
#define CAN_RXIMR26          CAN.RXIMR[26].R               /* Rx Individual Mask Registers */
#define CAN_RXIMR27          CAN.RXIMR[27].R               /* Rx Individual Mask Registers */
#define CAN_RXIMR28          CAN.RXIMR[28].R               /* Rx Individual Mask Registers */
#define CAN_RXIMR29          CAN.RXIMR[29].R               /* Rx Individual Mask Registers */
#define CAN_RXIMR30          CAN.RXIMR[30].R               /* Rx Individual Mask Registers */
#define CAN_RXIMR31          CAN.RXIMR[31].R               /* Rx Individual Mask Registers */
#define CAN_RXIMR32          CAN.RXIMR[32].R               /* Rx Individual Mask Registers */
#define CAN_RXIMR33          CAN.RXIMR[33].R               /* Rx Individual Mask Registers */
#define CAN_RXIMR34          CAN.RXIMR[34].R               /* Rx Individual Mask Registers */
#define CAN_RXIMR35          CAN.RXIMR[35].R               /* Rx Individual Mask Registers */
#define CAN_RXIMR36          CAN.RXIMR[36].R               /* Rx Individual Mask Registers */
#define CAN_RXIMR37          CAN.RXIMR[37].R               /* Rx Individual Mask Registers */
#define CAN_RXIMR38          CAN.RXIMR[38].R               /* Rx Individual Mask Registers */
#define CAN_RXIMR39          CAN.RXIMR[39].R               /* Rx Individual Mask Registers */
#define CAN_RXIMR40          CAN.RXIMR[40].R               /* Rx Individual Mask Registers */
#define CAN_RXIMR41          CAN.RXIMR[41].R               /* Rx Individual Mask Registers */
#define CAN_RXIMR42          CAN.RXIMR[42].R               /* Rx Individual Mask Registers */
#define CAN_RXIMR43          CAN.RXIMR[43].R               /* Rx Individual Mask Registers */
#define CAN_RXIMR44          CAN.RXIMR[44].R               /* Rx Individual Mask Registers */
#define CAN_RXIMR45          CAN.RXIMR[45].R               /* Rx Individual Mask Registers */
#define CAN_RXIMR46          CAN.RXIMR[46].R               /* Rx Individual Mask Registers */
#define CAN_RXIMR47          CAN.RXIMR[47].R               /* Rx Individual Mask Registers */
#define CAN_RXIMR48          CAN.RXIMR[48].R               /* Rx Individual Mask Registers */
#define CAN_RXIMR49          CAN.RXIMR[49].R               /* Rx Individual Mask Registers */
#define CAN_RXIMR50          CAN.RXIMR[50].R               /* Rx Individual Mask Registers */
#define CAN_RXIMR51          CAN.RXIMR[51].R               /* Rx Individual Mask Registers */
#define CAN_RXIMR52          CAN.RXIMR[52].R               /* Rx Individual Mask Registers */
#define CAN_RXIMR53          CAN.RXIMR[53].R               /* Rx Individual Mask Registers */
#define CAN_RXIMR54          CAN.RXIMR[54].R               /* Rx Individual Mask Registers */
#define CAN_RXIMR55          CAN.RXIMR[55].R               /* Rx Individual Mask Registers */
#define CAN_RXIMR56          CAN.RXIMR[56].R               /* Rx Individual Mask Registers */
#define CAN_RXIMR57          CAN.RXIMR[57].R               /* Rx Individual Mask Registers */
#define CAN_RXIMR58          CAN.RXIMR[58].R               /* Rx Individual Mask Registers */
#define CAN_RXIMR59          CAN.RXIMR[59].R               /* Rx Individual Mask Registers */
#define CAN_RXIMR60          CAN.RXIMR[60].R               /* Rx Individual Mask Registers */
#define CAN_RXIMR61          CAN.RXIMR[61].R               /* Rx Individual Mask Registers */
#define CAN_RXIMR62          CAN.RXIMR[62].R               /* Rx Individual Mask Registers */
#define CAN_RXIMR63          CAN.RXIMR[63].R               /* Rx Individual Mask Registers */
#define CAN_CTRL1_PN         CAN.CTRL1_PN.R                /* Pretended Networking Control 1 Register */
#define CAN_CTRL2_PN         CAN.CTRL2_PN.R                /* Pretended Networking Control 2 Register */
#define CAN_WU_MTC           CAN.WU_MTC.R                  /* Pretended Networking Wake Up Match Register */
#define CAN_FLT_ID1          CAN.FLT_ID1.R                 /* Pretended Networking ID Filter 1 Register */
#define CAN_FLT_DLC          CAN.FLT_DLC.R                 /* Pretended Networking DLC Filter Register */
#define CAN_PL1_LO           CAN.PL1_LO.R                  /* Pretended Networking Payload Low Filter 1 Register */
#define CAN_PL1_HI           CAN.PL1_HI.R                  /* Pretended Networking Payload High Filter 1 Register */
#define CAN_FLT_ID2_IDMASK   CAN.FLT_ID2_IDMASK.R          /* Pretended Networking ID Filter 2 Register / ID Mask Register */
#define CAN_PL2_PLMASK_LO    CAN.PL2_PLMASK_LO.R           /* Pretended Networking Payload Low Filter 2 Register / Payload Low Mask Register */
#define CAN_PL2_PLMASK_HI    CAN.PL2_PLMASK_HI.R           /* Pretended Networking Payload High Filter 2 low order bits / Payload High Mask Register */
#define CAN_WMB0_CS          CAN.WMB[0].CS.R               /* Wake Up Message Buffer Register for C/S */
#define CAN_WMB0_ID          CAN.WMB[0].ID.R               /* Wake Up Message Buffer Register for ID */
#define CAN_WMB0_D03         CAN.WMB[0].D03.R              /* Wake Up Message Buffer Register for Data 0-3 */
#define CAN_WMB0_D47         CAN.WMB[0].D47.R              /* Wake Up Message Buffer Register Data 4-7 */
#define CAN_WMB1_CS          CAN.WMB[1].CS.R               /* Wake Up Message Buffer Register for C/S */
#define CAN_WMB1_ID          CAN.WMB[1].ID.R               /* Wake Up Message Buffer Register for ID */
#define CAN_WMB1_D03         CAN.WMB[1].D03.R              /* Wake Up Message Buffer Register for Data 0-3 */
#define CAN_WMB1_D47         CAN.WMB[1].D47.R              /* Wake Up Message Buffer Register Data 4-7 */
#define CAN_WMB2_CS          CAN.WMB[2].CS.R               /* Wake Up Message Buffer Register for C/S */
#define CAN_WMB2_ID          CAN.WMB[2].ID.R               /* Wake Up Message Buffer Register for ID */
#define CAN_WMB2_D03         CAN.WMB[2].D03.R              /* Wake Up Message Buffer Register for Data 0-3 */
#define CAN_WMB2_D47         CAN.WMB[2].D47.R              /* Wake Up Message Buffer Register Data 4-7 */
#define CAN_WMB3_CS          CAN.WMB[3].CS.R               /* Wake Up Message Buffer Register for C/S */
#define CAN_WMB3_ID          CAN.WMB[3].ID.R               /* Wake Up Message Buffer Register for ID */
#define CAN_WMB3_D03         CAN.WMB[3].D03.R              /* Wake Up Message Buffer Register for Data 0-3 */
#define CAN_WMB3_D47         CAN.WMB[3].D47.R              /* Wake Up Message Buffer Register Data 4-7 */
#define CAN_FDCTRL           CAN.FDCTRL.R                  /* CAN FD Control Register */
#define CAN_FDCBT            CAN.FDCBT.R                   /* CAN FD Bit Timing Register */
#define CAN_FDCRC            CAN.FDCRC.R                   /* CAN FD CRC Register */

/* CMP */
#define CMP_0_C0             CMP_0.C0.R                    /* CMP Control Register 0 */
#define CMP_0_C1             CMP_0.C1.R                    /* CMP Control Register 1 */
#define CMP_0_C2             CMP_0.C2.R                    /* CMP Control Register 2 */

/* CMP */
#define CMP_1_C0             CMP_1.C0.R                    /* CMP Control Register 0 */
#define CMP_1_C1             CMP_1.C1.R                    /* CMP Control Register 1 */
#define CMP_1_C2             CMP_1.C2.R                    /* CMP Control Register 2 */

/* CMP */
#define CMP_2_C0             CMP_2.C0.R                    /* CMP Control Register 0 */
#define CMP_2_C1             CMP_2.C1.R                    /* CMP Control Register 1 */
#define CMP_2_C2             CMP_2.C2.R                    /* CMP Control Register 2 */

/* CMU */
#define CMU_CSR              CMU.CSR.R                     /* CMU Control Status Register */
#define CMU_FDR              CMU.FDR.R                     /* CMU Frequency Display Register */
#define CMU_HFREFR           CMU.HFREFR.R                  /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_LFREFR           CMU.LFREFR.R                  /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_ISR              CMU.ISR.R                     /* CMU Interrupt Status Register */
#define CMU_MDR              CMU.MDR.R                     /* CMU Measurement Duration Register */

/* CRC */
#define CRC_CFG              CRC.CFG.R                     /* Configuration Register */
#define CRC_INP              CRC.INP.R                     /* Input Register */
#define CRC_CSTAT            CRC.CSTAT.R                   /* Current Status Register */
#define CRC_OUTP             CRC.OUTP.R                    /* Output Register */

/* DMA */
#define DMA_CR               DMA.CR.R                      /* Control Register */
#define DMA_ES               DMA.ES.R                      /* Error Status Register */
#define DMA_ERQ              DMA.ERQ.R                     /* Enable Request Register */
#define DMA_EEI              DMA.EEI.R                     /* Enable Error Interrupt Register */
#define DMA_SERQ             DMA.SERQ.R                    /* Set Enable Request Register */
#define DMA_CERQ             DMA.CERQ.R                    /* Clear Enable Request Register */
#define DMA_SEEI             DMA.SEEI.R                    /* Set Enable Error Interrupt Register */
#define DMA_CEEI             DMA.CEEI.R                    /* Clear Enable Error Interrupt Register */
#define DMA_CINT             DMA.CINT.R                    /* Clear Interrupt Request Register */
#define DMA_CERR             DMA.CERR.R                    /* Clear Error Register */
#define DMA_SSRT             DMA.SSRT.R                    /* Set START Bit Register */
#define DMA_CDNE             DMA.CDNE.R                    /* Clear DONE Status Bit Register */
#define DMA_INT              DMA.INT.R                     /* Interrupt Request Register */
#define DMA_ERR              DMA.ERR.R                     /* Error Register */
#define DMA_HRS              DMA.HRS.R                     /* Hardware Request Status Register */
#define DMA_DCHPRI0          DMA.DCHPRI[0].R               /* Channel n Priority Register */
#define DMA_DCHPRI1          DMA.DCHPRI[1].R               /* Channel n Priority Register */
#define DMA_DCHPRI2          DMA.DCHPRI[2].R               /* Channel n Priority Register */
#define DMA_DCHPRI3          DMA.DCHPRI[3].R               /* Channel n Priority Register */
#define DMA_DCHPRI4          DMA.DCHPRI[4].R               /* Channel n Priority Register */
#define DMA_DCHPRI5          DMA.DCHPRI[5].R               /* Channel n Priority Register */
#define DMA_DCHPRI6          DMA.DCHPRI[6].R               /* Channel n Priority Register */
#define DMA_DCHPRI7          DMA.DCHPRI[7].R               /* Channel n Priority Register */
#define DMA_DCHPRI8          DMA.DCHPRI[8].R               /* Channel n Priority Register */
#define DMA_DCHPRI9          DMA.DCHPRI[9].R               /* Channel n Priority Register */
#define DMA_DCHPRI10         DMA.DCHPRI[10].R              /* Channel n Priority Register */
#define DMA_DCHPRI11         DMA.DCHPRI[11].R              /* Channel n Priority Register */
#define DMA_DCHPRI12         DMA.DCHPRI[12].R              /* Channel n Priority Register */
#define DMA_DCHPRI13         DMA.DCHPRI[13].R              /* Channel n Priority Register */
#define DMA_DCHPRI14         DMA.DCHPRI[14].R              /* Channel n Priority Register */
#define DMA_DCHPRI15         DMA.DCHPRI[15].R              /* Channel n Priority Register */
#define DMA_DCHPRI16         DMA.DCHPRI[16].R              /* Channel n Priority Register */
#define DMA_DCHPRI17         DMA.DCHPRI[17].R              /* Channel n Priority Register */
#define DMA_DCHPRI18         DMA.DCHPRI[18].R              /* Channel n Priority Register */
#define DMA_DCHPRI19         DMA.DCHPRI[19].R              /* Channel n Priority Register */
#define DMA_DCHPRI20         DMA.DCHPRI[20].R              /* Channel n Priority Register */
#define DMA_DCHPRI21         DMA.DCHPRI[21].R              /* Channel n Priority Register */
#define DMA_DCHPRI22         DMA.DCHPRI[22].R              /* Channel n Priority Register */
#define DMA_DCHPRI23         DMA.DCHPRI[23].R              /* Channel n Priority Register */
#define DMA_DCHPRI24         DMA.DCHPRI[24].R              /* Channel n Priority Register */
#define DMA_DCHPRI25         DMA.DCHPRI[25].R              /* Channel n Priority Register */
#define DMA_DCHPRI26         DMA.DCHPRI[26].R              /* Channel n Priority Register */
#define DMA_DCHPRI27         DMA.DCHPRI[27].R              /* Channel n Priority Register */
#define DMA_DCHPRI28         DMA.DCHPRI[28].R              /* Channel n Priority Register */
#define DMA_DCHPRI29         DMA.DCHPRI[29].R              /* Channel n Priority Register */
#define DMA_DCHPRI30         DMA.DCHPRI[30].R              /* Channel n Priority Register */
#define DMA_DCHPRI31         DMA.DCHPRI[31].R              /* Channel n Priority Register */
#define DMA_DCHMID0          DMA.DCHMID[0].R               /* Channel n Master ID Register */
#define DMA_DCHMID1          DMA.DCHMID[1].R               /* Channel n Master ID Register */
#define DMA_DCHMID2          DMA.DCHMID[2].R               /* Channel n Master ID Register */
#define DMA_DCHMID3          DMA.DCHMID[3].R               /* Channel n Master ID Register */
#define DMA_DCHMID4          DMA.DCHMID[4].R               /* Channel n Master ID Register */
#define DMA_DCHMID5          DMA.DCHMID[5].R               /* Channel n Master ID Register */
#define DMA_DCHMID6          DMA.DCHMID[6].R               /* Channel n Master ID Register */
#define DMA_DCHMID7          DMA.DCHMID[7].R               /* Channel n Master ID Register */
#define DMA_DCHMID8          DMA.DCHMID[8].R               /* Channel n Master ID Register */
#define DMA_DCHMID9          DMA.DCHMID[9].R               /* Channel n Master ID Register */
#define DMA_DCHMID10         DMA.DCHMID[10].R              /* Channel n Master ID Register */
#define DMA_DCHMID11         DMA.DCHMID[11].R              /* Channel n Master ID Register */
#define DMA_DCHMID12         DMA.DCHMID[12].R              /* Channel n Master ID Register */
#define DMA_DCHMID13         DMA.DCHMID[13].R              /* Channel n Master ID Register */
#define DMA_DCHMID14         DMA.DCHMID[14].R              /* Channel n Master ID Register */
#define DMA_DCHMID15         DMA.DCHMID[15].R              /* Channel n Master ID Register */
#define DMA_DCHMID16         DMA.DCHMID[16].R              /* Channel n Master ID Register */
#define DMA_DCHMID17         DMA.DCHMID[17].R              /* Channel n Master ID Register */
#define DMA_DCHMID18         DMA.DCHMID[18].R              /* Channel n Master ID Register */
#define DMA_DCHMID19         DMA.DCHMID[19].R              /* Channel n Master ID Register */
#define DMA_DCHMID20         DMA.DCHMID[20].R              /* Channel n Master ID Register */
#define DMA_DCHMID21         DMA.DCHMID[21].R              /* Channel n Master ID Register */
#define DMA_DCHMID22         DMA.DCHMID[22].R              /* Channel n Master ID Register */
#define DMA_DCHMID23         DMA.DCHMID[23].R              /* Channel n Master ID Register */
#define DMA_DCHMID24         DMA.DCHMID[24].R              /* Channel n Master ID Register */
#define DMA_DCHMID25         DMA.DCHMID[25].R              /* Channel n Master ID Register */
#define DMA_DCHMID26         DMA.DCHMID[26].R              /* Channel n Master ID Register */
#define DMA_DCHMID27         DMA.DCHMID[27].R              /* Channel n Master ID Register */
#define DMA_DCHMID28         DMA.DCHMID[28].R              /* Channel n Master ID Register */
#define DMA_DCHMID29         DMA.DCHMID[29].R              /* Channel n Master ID Register */
#define DMA_DCHMID30         DMA.DCHMID[30].R              /* Channel n Master ID Register */
#define DMA_DCHMID31         DMA.DCHMID[31].R              /* Channel n Master ID Register */
#define DMA_TCD0_SADDR       DMA.TCD[0].SADDR.R            /* TCD Source Address */
#define DMA_TCD0_ATTR        DMA.TCD[0].ATTR.R             /* TCD Transfer Attributes */
#define DMA_TCD0_SOFF        DMA.TCD[0].SOFF.R             /* TCD Signed Source Address Offset */
#define DMA_TCD0_NBYTES_MLNO DMA.TCD[0].NBYTES.MLNO.R      /* TCD Minor Byte Count (Minor Loop Disabled) */
#define DMA_TCD0_NBYTES_MLOFFNO DMA.TCD[0].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Enabled and Offset Disabled) */
#define DMA_TCD0_NBYTES_MLOFFYES DMA.TCD[0].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_TCD0_SLAST       DMA.TCD[0].SLAST.R            /* TCD Last Source Address Adjustment */
#define DMA_TCD0_DADDR       DMA.TCD[0].DADDR.R            /* TCD Destination Address */
#define DMA_TCD0_CITER_ELINKNO DMA.TCD[0].CITER.ELINKNO.R  /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD0_CITER_ELINKYES DMA.TCD[0].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD0_DOFF        DMA.TCD[0].DOFF.R             /* TCD Signed Destination Address Offset */
#define DMA_TCD0_DLASTSGA    DMA.TCD[0].DLASTSGA.R         /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_TCD0_BITER_ELINKNO DMA.TCD[0].BITER.ELINKNO.R  /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD0_BITER_ELINKYES DMA.TCD[0].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD0_CSR         DMA.TCD[0].CSR.R              /* TCD Control and Status */
#define DMA_TCD1_SADDR       DMA.TCD[1].SADDR.R            /* TCD Source Address */
#define DMA_TCD1_ATTR        DMA.TCD[1].ATTR.R             /* TCD Transfer Attributes */
#define DMA_TCD1_SOFF        DMA.TCD[1].SOFF.R             /* TCD Signed Source Address Offset */
#define DMA_TCD1_NBYTES_MLNO DMA.TCD[1].NBYTES.MLNO.R      /* TCD Minor Byte Count (Minor Loop Disabled) */
#define DMA_TCD1_NBYTES_MLOFFNO DMA.TCD[1].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Enabled and Offset Disabled) */
#define DMA_TCD1_NBYTES_MLOFFYES DMA.TCD[1].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_TCD1_SLAST       DMA.TCD[1].SLAST.R            /* TCD Last Source Address Adjustment */
#define DMA_TCD1_DADDR       DMA.TCD[1].DADDR.R            /* TCD Destination Address */
#define DMA_TCD1_CITER_ELINKNO DMA.TCD[1].CITER.ELINKNO.R  /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD1_CITER_ELINKYES DMA.TCD[1].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD1_DOFF        DMA.TCD[1].DOFF.R             /* TCD Signed Destination Address Offset */
#define DMA_TCD1_DLASTSGA    DMA.TCD[1].DLASTSGA.R         /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_TCD1_BITER_ELINKNO DMA.TCD[1].BITER.ELINKNO.R  /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD1_BITER_ELINKYES DMA.TCD[1].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD1_CSR         DMA.TCD[1].CSR.R              /* TCD Control and Status */
#define DMA_TCD2_SADDR       DMA.TCD[2].SADDR.R            /* TCD Source Address */
#define DMA_TCD2_ATTR        DMA.TCD[2].ATTR.R             /* TCD Transfer Attributes */
#define DMA_TCD2_SOFF        DMA.TCD[2].SOFF.R             /* TCD Signed Source Address Offset */
#define DMA_TCD2_NBYTES_MLNO DMA.TCD[2].NBYTES.MLNO.R      /* TCD Minor Byte Count (Minor Loop Disabled) */
#define DMA_TCD2_NBYTES_MLOFFNO DMA.TCD[2].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Enabled and Offset Disabled) */
#define DMA_TCD2_NBYTES_MLOFFYES DMA.TCD[2].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_TCD2_SLAST       DMA.TCD[2].SLAST.R            /* TCD Last Source Address Adjustment */
#define DMA_TCD2_DADDR       DMA.TCD[2].DADDR.R            /* TCD Destination Address */
#define DMA_TCD2_CITER_ELINKNO DMA.TCD[2].CITER.ELINKNO.R  /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD2_CITER_ELINKYES DMA.TCD[2].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD2_DOFF        DMA.TCD[2].DOFF.R             /* TCD Signed Destination Address Offset */
#define DMA_TCD2_DLASTSGA    DMA.TCD[2].DLASTSGA.R         /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_TCD2_BITER_ELINKNO DMA.TCD[2].BITER.ELINKNO.R  /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD2_BITER_ELINKYES DMA.TCD[2].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD2_CSR         DMA.TCD[2].CSR.R              /* TCD Control and Status */
#define DMA_TCD3_SADDR       DMA.TCD[3].SADDR.R            /* TCD Source Address */
#define DMA_TCD3_ATTR        DMA.TCD[3].ATTR.R             /* TCD Transfer Attributes */
#define DMA_TCD3_SOFF        DMA.TCD[3].SOFF.R             /* TCD Signed Source Address Offset */
#define DMA_TCD3_NBYTES_MLNO DMA.TCD[3].NBYTES.MLNO.R      /* TCD Minor Byte Count (Minor Loop Disabled) */
#define DMA_TCD3_NBYTES_MLOFFNO DMA.TCD[3].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Enabled and Offset Disabled) */
#define DMA_TCD3_NBYTES_MLOFFYES DMA.TCD[3].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_TCD3_SLAST       DMA.TCD[3].SLAST.R            /* TCD Last Source Address Adjustment */
#define DMA_TCD3_DADDR       DMA.TCD[3].DADDR.R            /* TCD Destination Address */
#define DMA_TCD3_CITER_ELINKNO DMA.TCD[3].CITER.ELINKNO.R  /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD3_CITER_ELINKYES DMA.TCD[3].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD3_DOFF        DMA.TCD[3].DOFF.R             /* TCD Signed Destination Address Offset */
#define DMA_TCD3_DLASTSGA    DMA.TCD[3].DLASTSGA.R         /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_TCD3_BITER_ELINKNO DMA.TCD[3].BITER.ELINKNO.R  /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD3_BITER_ELINKYES DMA.TCD[3].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD3_CSR         DMA.TCD[3].CSR.R              /* TCD Control and Status */
#define DMA_TCD4_SADDR       DMA.TCD[4].SADDR.R            /* TCD Source Address */
#define DMA_TCD4_ATTR        DMA.TCD[4].ATTR.R             /* TCD Transfer Attributes */
#define DMA_TCD4_SOFF        DMA.TCD[4].SOFF.R             /* TCD Signed Source Address Offset */
#define DMA_TCD4_NBYTES_MLNO DMA.TCD[4].NBYTES.MLNO.R      /* TCD Minor Byte Count (Minor Loop Disabled) */
#define DMA_TCD4_NBYTES_MLOFFNO DMA.TCD[4].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Enabled and Offset Disabled) */
#define DMA_TCD4_NBYTES_MLOFFYES DMA.TCD[4].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_TCD4_SLAST       DMA.TCD[4].SLAST.R            /* TCD Last Source Address Adjustment */
#define DMA_TCD4_DADDR       DMA.TCD[4].DADDR.R            /* TCD Destination Address */
#define DMA_TCD4_CITER_ELINKNO DMA.TCD[4].CITER.ELINKNO.R  /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD4_CITER_ELINKYES DMA.TCD[4].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD4_DOFF        DMA.TCD[4].DOFF.R             /* TCD Signed Destination Address Offset */
#define DMA_TCD4_DLASTSGA    DMA.TCD[4].DLASTSGA.R         /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_TCD4_BITER_ELINKNO DMA.TCD[4].BITER.ELINKNO.R  /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD4_BITER_ELINKYES DMA.TCD[4].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD4_CSR         DMA.TCD[4].CSR.R              /* TCD Control and Status */
#define DMA_TCD5_SADDR       DMA.TCD[5].SADDR.R            /* TCD Source Address */
#define DMA_TCD5_ATTR        DMA.TCD[5].ATTR.R             /* TCD Transfer Attributes */
#define DMA_TCD5_SOFF        DMA.TCD[5].SOFF.R             /* TCD Signed Source Address Offset */
#define DMA_TCD5_NBYTES_MLNO DMA.TCD[5].NBYTES.MLNO.R      /* TCD Minor Byte Count (Minor Loop Disabled) */
#define DMA_TCD5_NBYTES_MLOFFNO DMA.TCD[5].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Enabled and Offset Disabled) */
#define DMA_TCD5_NBYTES_MLOFFYES DMA.TCD[5].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_TCD5_SLAST       DMA.TCD[5].SLAST.R            /* TCD Last Source Address Adjustment */
#define DMA_TCD5_DADDR       DMA.TCD[5].DADDR.R            /* TCD Destination Address */
#define DMA_TCD5_CITER_ELINKNO DMA.TCD[5].CITER.ELINKNO.R  /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD5_CITER_ELINKYES DMA.TCD[5].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD5_DOFF        DMA.TCD[5].DOFF.R             /* TCD Signed Destination Address Offset */
#define DMA_TCD5_DLASTSGA    DMA.TCD[5].DLASTSGA.R         /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_TCD5_BITER_ELINKNO DMA.TCD[5].BITER.ELINKNO.R  /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD5_BITER_ELINKYES DMA.TCD[5].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD5_CSR         DMA.TCD[5].CSR.R              /* TCD Control and Status */
#define DMA_TCD6_SADDR       DMA.TCD[6].SADDR.R            /* TCD Source Address */
#define DMA_TCD6_ATTR        DMA.TCD[6].ATTR.R             /* TCD Transfer Attributes */
#define DMA_TCD6_SOFF        DMA.TCD[6].SOFF.R             /* TCD Signed Source Address Offset */
#define DMA_TCD6_NBYTES_MLNO DMA.TCD[6].NBYTES.MLNO.R      /* TCD Minor Byte Count (Minor Loop Disabled) */
#define DMA_TCD6_NBYTES_MLOFFNO DMA.TCD[6].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Enabled and Offset Disabled) */
#define DMA_TCD6_NBYTES_MLOFFYES DMA.TCD[6].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_TCD6_SLAST       DMA.TCD[6].SLAST.R            /* TCD Last Source Address Adjustment */
#define DMA_TCD6_DADDR       DMA.TCD[6].DADDR.R            /* TCD Destination Address */
#define DMA_TCD6_CITER_ELINKNO DMA.TCD[6].CITER.ELINKNO.R  /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD6_CITER_ELINKYES DMA.TCD[6].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD6_DOFF        DMA.TCD[6].DOFF.R             /* TCD Signed Destination Address Offset */
#define DMA_TCD6_DLASTSGA    DMA.TCD[6].DLASTSGA.R         /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_TCD6_BITER_ELINKNO DMA.TCD[6].BITER.ELINKNO.R  /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD6_BITER_ELINKYES DMA.TCD[6].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD6_CSR         DMA.TCD[6].CSR.R              /* TCD Control and Status */
#define DMA_TCD7_SADDR       DMA.TCD[7].SADDR.R            /* TCD Source Address */
#define DMA_TCD7_ATTR        DMA.TCD[7].ATTR.R             /* TCD Transfer Attributes */
#define DMA_TCD7_SOFF        DMA.TCD[7].SOFF.R             /* TCD Signed Source Address Offset */
#define DMA_TCD7_NBYTES_MLNO DMA.TCD[7].NBYTES.MLNO.R      /* TCD Minor Byte Count (Minor Loop Disabled) */
#define DMA_TCD7_NBYTES_MLOFFNO DMA.TCD[7].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Enabled and Offset Disabled) */
#define DMA_TCD7_NBYTES_MLOFFYES DMA.TCD[7].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_TCD7_SLAST       DMA.TCD[7].SLAST.R            /* TCD Last Source Address Adjustment */
#define DMA_TCD7_DADDR       DMA.TCD[7].DADDR.R            /* TCD Destination Address */
#define DMA_TCD7_CITER_ELINKNO DMA.TCD[7].CITER.ELINKNO.R  /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD7_CITER_ELINKYES DMA.TCD[7].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD7_DOFF        DMA.TCD[7].DOFF.R             /* TCD Signed Destination Address Offset */
#define DMA_TCD7_DLASTSGA    DMA.TCD[7].DLASTSGA.R         /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_TCD7_BITER_ELINKNO DMA.TCD[7].BITER.ELINKNO.R  /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD7_BITER_ELINKYES DMA.TCD[7].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD7_CSR         DMA.TCD[7].CSR.R              /* TCD Control and Status */
#define DMA_TCD8_SADDR       DMA.TCD[8].SADDR.R            /* TCD Source Address */
#define DMA_TCD8_ATTR        DMA.TCD[8].ATTR.R             /* TCD Transfer Attributes */
#define DMA_TCD8_SOFF        DMA.TCD[8].SOFF.R             /* TCD Signed Source Address Offset */
#define DMA_TCD8_NBYTES_MLNO DMA.TCD[8].NBYTES.MLNO.R      /* TCD Minor Byte Count (Minor Loop Disabled) */
#define DMA_TCD8_NBYTES_MLOFFNO DMA.TCD[8].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Enabled and Offset Disabled) */
#define DMA_TCD8_NBYTES_MLOFFYES DMA.TCD[8].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_TCD8_SLAST       DMA.TCD[8].SLAST.R            /* TCD Last Source Address Adjustment */
#define DMA_TCD8_DADDR       DMA.TCD[8].DADDR.R            /* TCD Destination Address */
#define DMA_TCD8_CITER_ELINKNO DMA.TCD[8].CITER.ELINKNO.R  /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD8_CITER_ELINKYES DMA.TCD[8].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD8_DOFF        DMA.TCD[8].DOFF.R             /* TCD Signed Destination Address Offset */
#define DMA_TCD8_DLASTSGA    DMA.TCD[8].DLASTSGA.R         /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_TCD8_BITER_ELINKNO DMA.TCD[8].BITER.ELINKNO.R  /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD8_BITER_ELINKYES DMA.TCD[8].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD8_CSR         DMA.TCD[8].CSR.R              /* TCD Control and Status */
#define DMA_TCD9_SADDR       DMA.TCD[9].SADDR.R            /* TCD Source Address */
#define DMA_TCD9_ATTR        DMA.TCD[9].ATTR.R             /* TCD Transfer Attributes */
#define DMA_TCD9_SOFF        DMA.TCD[9].SOFF.R             /* TCD Signed Source Address Offset */
#define DMA_TCD9_NBYTES_MLNO DMA.TCD[9].NBYTES.MLNO.R      /* TCD Minor Byte Count (Minor Loop Disabled) */
#define DMA_TCD9_NBYTES_MLOFFNO DMA.TCD[9].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Enabled and Offset Disabled) */
#define DMA_TCD9_NBYTES_MLOFFYES DMA.TCD[9].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_TCD9_SLAST       DMA.TCD[9].SLAST.R            /* TCD Last Source Address Adjustment */
#define DMA_TCD9_DADDR       DMA.TCD[9].DADDR.R            /* TCD Destination Address */
#define DMA_TCD9_CITER_ELINKNO DMA.TCD[9].CITER.ELINKNO.R  /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD9_CITER_ELINKYES DMA.TCD[9].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD9_DOFF        DMA.TCD[9].DOFF.R             /* TCD Signed Destination Address Offset */
#define DMA_TCD9_DLASTSGA    DMA.TCD[9].DLASTSGA.R         /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_TCD9_BITER_ELINKNO DMA.TCD[9].BITER.ELINKNO.R  /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD9_BITER_ELINKYES DMA.TCD[9].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD9_CSR         DMA.TCD[9].CSR.R              /* TCD Control and Status */
#define DMA_TCD10_SADDR      DMA.TCD[10].SADDR.R           /* TCD Source Address */
#define DMA_TCD10_ATTR       DMA.TCD[10].ATTR.R            /* TCD Transfer Attributes */
#define DMA_TCD10_SOFF       DMA.TCD[10].SOFF.R            /* TCD Signed Source Address Offset */
#define DMA_TCD10_NBYTES_MLNO DMA.TCD[10].NBYTES.MLNO.R    /* TCD Minor Byte Count (Minor Loop Disabled) */
#define DMA_TCD10_NBYTES_MLOFFNO DMA.TCD[10].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Enabled and Offset Disabled) */
#define DMA_TCD10_NBYTES_MLOFFYES DMA.TCD[10].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_TCD10_SLAST      DMA.TCD[10].SLAST.R           /* TCD Last Source Address Adjustment */
#define DMA_TCD10_DADDR      DMA.TCD[10].DADDR.R           /* TCD Destination Address */
#define DMA_TCD10_CITER_ELINKNO DMA.TCD[10].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD10_CITER_ELINKYES DMA.TCD[10].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD10_DOFF       DMA.TCD[10].DOFF.R            /* TCD Signed Destination Address Offset */
#define DMA_TCD10_DLASTSGA   DMA.TCD[10].DLASTSGA.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_TCD10_BITER_ELINKNO DMA.TCD[10].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD10_BITER_ELINKYES DMA.TCD[10].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD10_CSR        DMA.TCD[10].CSR.R             /* TCD Control and Status */
#define DMA_TCD11_SADDR      DMA.TCD[11].SADDR.R           /* TCD Source Address */
#define DMA_TCD11_ATTR       DMA.TCD[11].ATTR.R            /* TCD Transfer Attributes */
#define DMA_TCD11_SOFF       DMA.TCD[11].SOFF.R            /* TCD Signed Source Address Offset */
#define DMA_TCD11_NBYTES_MLNO DMA.TCD[11].NBYTES.MLNO.R    /* TCD Minor Byte Count (Minor Loop Disabled) */
#define DMA_TCD11_NBYTES_MLOFFNO DMA.TCD[11].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Enabled and Offset Disabled) */
#define DMA_TCD11_NBYTES_MLOFFYES DMA.TCD[11].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_TCD11_SLAST      DMA.TCD[11].SLAST.R           /* TCD Last Source Address Adjustment */
#define DMA_TCD11_DADDR      DMA.TCD[11].DADDR.R           /* TCD Destination Address */
#define DMA_TCD11_CITER_ELINKNO DMA.TCD[11].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD11_CITER_ELINKYES DMA.TCD[11].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD11_DOFF       DMA.TCD[11].DOFF.R            /* TCD Signed Destination Address Offset */
#define DMA_TCD11_DLASTSGA   DMA.TCD[11].DLASTSGA.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_TCD11_BITER_ELINKNO DMA.TCD[11].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD11_BITER_ELINKYES DMA.TCD[11].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD11_CSR        DMA.TCD[11].CSR.R             /* TCD Control and Status */
#define DMA_TCD12_SADDR      DMA.TCD[12].SADDR.R           /* TCD Source Address */
#define DMA_TCD12_ATTR       DMA.TCD[12].ATTR.R            /* TCD Transfer Attributes */
#define DMA_TCD12_SOFF       DMA.TCD[12].SOFF.R            /* TCD Signed Source Address Offset */
#define DMA_TCD12_NBYTES_MLNO DMA.TCD[12].NBYTES.MLNO.R    /* TCD Minor Byte Count (Minor Loop Disabled) */
#define DMA_TCD12_NBYTES_MLOFFNO DMA.TCD[12].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Enabled and Offset Disabled) */
#define DMA_TCD12_NBYTES_MLOFFYES DMA.TCD[12].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_TCD12_SLAST      DMA.TCD[12].SLAST.R           /* TCD Last Source Address Adjustment */
#define DMA_TCD12_DADDR      DMA.TCD[12].DADDR.R           /* TCD Destination Address */
#define DMA_TCD12_CITER_ELINKNO DMA.TCD[12].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD12_CITER_ELINKYES DMA.TCD[12].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD12_DOFF       DMA.TCD[12].DOFF.R            /* TCD Signed Destination Address Offset */
#define DMA_TCD12_DLASTSGA   DMA.TCD[12].DLASTSGA.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_TCD12_BITER_ELINKNO DMA.TCD[12].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD12_BITER_ELINKYES DMA.TCD[12].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD12_CSR        DMA.TCD[12].CSR.R             /* TCD Control and Status */
#define DMA_TCD13_SADDR      DMA.TCD[13].SADDR.R           /* TCD Source Address */
#define DMA_TCD13_ATTR       DMA.TCD[13].ATTR.R            /* TCD Transfer Attributes */
#define DMA_TCD13_SOFF       DMA.TCD[13].SOFF.R            /* TCD Signed Source Address Offset */
#define DMA_TCD13_NBYTES_MLNO DMA.TCD[13].NBYTES.MLNO.R    /* TCD Minor Byte Count (Minor Loop Disabled) */
#define DMA_TCD13_NBYTES_MLOFFNO DMA.TCD[13].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Enabled and Offset Disabled) */
#define DMA_TCD13_NBYTES_MLOFFYES DMA.TCD[13].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_TCD13_SLAST      DMA.TCD[13].SLAST.R           /* TCD Last Source Address Adjustment */
#define DMA_TCD13_DADDR      DMA.TCD[13].DADDR.R           /* TCD Destination Address */
#define DMA_TCD13_CITER_ELINKNO DMA.TCD[13].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD13_CITER_ELINKYES DMA.TCD[13].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD13_DOFF       DMA.TCD[13].DOFF.R            /* TCD Signed Destination Address Offset */
#define DMA_TCD13_DLASTSGA   DMA.TCD[13].DLASTSGA.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_TCD13_BITER_ELINKNO DMA.TCD[13].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD13_BITER_ELINKYES DMA.TCD[13].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD13_CSR        DMA.TCD[13].CSR.R             /* TCD Control and Status */
#define DMA_TCD14_SADDR      DMA.TCD[14].SADDR.R           /* TCD Source Address */
#define DMA_TCD14_ATTR       DMA.TCD[14].ATTR.R            /* TCD Transfer Attributes */
#define DMA_TCD14_SOFF       DMA.TCD[14].SOFF.R            /* TCD Signed Source Address Offset */
#define DMA_TCD14_NBYTES_MLNO DMA.TCD[14].NBYTES.MLNO.R    /* TCD Minor Byte Count (Minor Loop Disabled) */
#define DMA_TCD14_NBYTES_MLOFFNO DMA.TCD[14].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Enabled and Offset Disabled) */
#define DMA_TCD14_NBYTES_MLOFFYES DMA.TCD[14].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_TCD14_SLAST      DMA.TCD[14].SLAST.R           /* TCD Last Source Address Adjustment */
#define DMA_TCD14_DADDR      DMA.TCD[14].DADDR.R           /* TCD Destination Address */
#define DMA_TCD14_CITER_ELINKNO DMA.TCD[14].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD14_CITER_ELINKYES DMA.TCD[14].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD14_DOFF       DMA.TCD[14].DOFF.R            /* TCD Signed Destination Address Offset */
#define DMA_TCD14_DLASTSGA   DMA.TCD[14].DLASTSGA.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_TCD14_BITER_ELINKNO DMA.TCD[14].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD14_BITER_ELINKYES DMA.TCD[14].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD14_CSR        DMA.TCD[14].CSR.R             /* TCD Control and Status */
#define DMA_TCD15_SADDR      DMA.TCD[15].SADDR.R           /* TCD Source Address */
#define DMA_TCD15_ATTR       DMA.TCD[15].ATTR.R            /* TCD Transfer Attributes */
#define DMA_TCD15_SOFF       DMA.TCD[15].SOFF.R            /* TCD Signed Source Address Offset */
#define DMA_TCD15_NBYTES_MLNO DMA.TCD[15].NBYTES.MLNO.R    /* TCD Minor Byte Count (Minor Loop Disabled) */
#define DMA_TCD15_NBYTES_MLOFFNO DMA.TCD[15].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Enabled and Offset Disabled) */
#define DMA_TCD15_NBYTES_MLOFFYES DMA.TCD[15].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_TCD15_SLAST      DMA.TCD[15].SLAST.R           /* TCD Last Source Address Adjustment */
#define DMA_TCD15_DADDR      DMA.TCD[15].DADDR.R           /* TCD Destination Address */
#define DMA_TCD15_CITER_ELINKNO DMA.TCD[15].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD15_CITER_ELINKYES DMA.TCD[15].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD15_DOFF       DMA.TCD[15].DOFF.R            /* TCD Signed Destination Address Offset */
#define DMA_TCD15_DLASTSGA   DMA.TCD[15].DLASTSGA.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_TCD15_BITER_ELINKNO DMA.TCD[15].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD15_BITER_ELINKYES DMA.TCD[15].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD15_CSR        DMA.TCD[15].CSR.R             /* TCD Control and Status */
#define DMA_TCD16_SADDR      DMA.TCD[16].SADDR.R           /* TCD Source Address */
#define DMA_TCD16_ATTR       DMA.TCD[16].ATTR.R            /* TCD Transfer Attributes */
#define DMA_TCD16_SOFF       DMA.TCD[16].SOFF.R            /* TCD Signed Source Address Offset */
#define DMA_TCD16_NBYTES_MLNO DMA.TCD[16].NBYTES.MLNO.R    /* TCD Minor Byte Count (Minor Loop Disabled) */
#define DMA_TCD16_NBYTES_MLOFFNO DMA.TCD[16].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Enabled and Offset Disabled) */
#define DMA_TCD16_NBYTES_MLOFFYES DMA.TCD[16].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_TCD16_SLAST      DMA.TCD[16].SLAST.R           /* TCD Last Source Address Adjustment */
#define DMA_TCD16_DADDR      DMA.TCD[16].DADDR.R           /* TCD Destination Address */
#define DMA_TCD16_CITER_ELINKNO DMA.TCD[16].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD16_CITER_ELINKYES DMA.TCD[16].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD16_DOFF       DMA.TCD[16].DOFF.R            /* TCD Signed Destination Address Offset */
#define DMA_TCD16_DLASTSGA   DMA.TCD[16].DLASTSGA.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_TCD16_BITER_ELINKNO DMA.TCD[16].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD16_BITER_ELINKYES DMA.TCD[16].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD16_CSR        DMA.TCD[16].CSR.R             /* TCD Control and Status */
#define DMA_TCD17_SADDR      DMA.TCD[17].SADDR.R           /* TCD Source Address */
#define DMA_TCD17_ATTR       DMA.TCD[17].ATTR.R            /* TCD Transfer Attributes */
#define DMA_TCD17_SOFF       DMA.TCD[17].SOFF.R            /* TCD Signed Source Address Offset */
#define DMA_TCD17_NBYTES_MLNO DMA.TCD[17].NBYTES.MLNO.R    /* TCD Minor Byte Count (Minor Loop Disabled) */
#define DMA_TCD17_NBYTES_MLOFFNO DMA.TCD[17].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Enabled and Offset Disabled) */
#define DMA_TCD17_NBYTES_MLOFFYES DMA.TCD[17].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_TCD17_SLAST      DMA.TCD[17].SLAST.R           /* TCD Last Source Address Adjustment */
#define DMA_TCD17_DADDR      DMA.TCD[17].DADDR.R           /* TCD Destination Address */
#define DMA_TCD17_CITER_ELINKNO DMA.TCD[17].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD17_CITER_ELINKYES DMA.TCD[17].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD17_DOFF       DMA.TCD[17].DOFF.R            /* TCD Signed Destination Address Offset */
#define DMA_TCD17_DLASTSGA   DMA.TCD[17].DLASTSGA.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_TCD17_BITER_ELINKNO DMA.TCD[17].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD17_BITER_ELINKYES DMA.TCD[17].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD17_CSR        DMA.TCD[17].CSR.R             /* TCD Control and Status */
#define DMA_TCD18_SADDR      DMA.TCD[18].SADDR.R           /* TCD Source Address */
#define DMA_TCD18_ATTR       DMA.TCD[18].ATTR.R            /* TCD Transfer Attributes */
#define DMA_TCD18_SOFF       DMA.TCD[18].SOFF.R            /* TCD Signed Source Address Offset */
#define DMA_TCD18_NBYTES_MLNO DMA.TCD[18].NBYTES.MLNO.R    /* TCD Minor Byte Count (Minor Loop Disabled) */
#define DMA_TCD18_NBYTES_MLOFFNO DMA.TCD[18].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Enabled and Offset Disabled) */
#define DMA_TCD18_NBYTES_MLOFFYES DMA.TCD[18].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_TCD18_SLAST      DMA.TCD[18].SLAST.R           /* TCD Last Source Address Adjustment */
#define DMA_TCD18_DADDR      DMA.TCD[18].DADDR.R           /* TCD Destination Address */
#define DMA_TCD18_CITER_ELINKNO DMA.TCD[18].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD18_CITER_ELINKYES DMA.TCD[18].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD18_DOFF       DMA.TCD[18].DOFF.R            /* TCD Signed Destination Address Offset */
#define DMA_TCD18_DLASTSGA   DMA.TCD[18].DLASTSGA.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_TCD18_BITER_ELINKNO DMA.TCD[18].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD18_BITER_ELINKYES DMA.TCD[18].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD18_CSR        DMA.TCD[18].CSR.R             /* TCD Control and Status */
#define DMA_TCD19_SADDR      DMA.TCD[19].SADDR.R           /* TCD Source Address */
#define DMA_TCD19_ATTR       DMA.TCD[19].ATTR.R            /* TCD Transfer Attributes */
#define DMA_TCD19_SOFF       DMA.TCD[19].SOFF.R            /* TCD Signed Source Address Offset */
#define DMA_TCD19_NBYTES_MLNO DMA.TCD[19].NBYTES.MLNO.R    /* TCD Minor Byte Count (Minor Loop Disabled) */
#define DMA_TCD19_NBYTES_MLOFFNO DMA.TCD[19].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Enabled and Offset Disabled) */
#define DMA_TCD19_NBYTES_MLOFFYES DMA.TCD[19].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_TCD19_SLAST      DMA.TCD[19].SLAST.R           /* TCD Last Source Address Adjustment */
#define DMA_TCD19_DADDR      DMA.TCD[19].DADDR.R           /* TCD Destination Address */
#define DMA_TCD19_CITER_ELINKNO DMA.TCD[19].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD19_CITER_ELINKYES DMA.TCD[19].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD19_DOFF       DMA.TCD[19].DOFF.R            /* TCD Signed Destination Address Offset */
#define DMA_TCD19_DLASTSGA   DMA.TCD[19].DLASTSGA.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_TCD19_BITER_ELINKNO DMA.TCD[19].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD19_BITER_ELINKYES DMA.TCD[19].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD19_CSR        DMA.TCD[19].CSR.R             /* TCD Control and Status */
#define DMA_TCD20_SADDR      DMA.TCD[20].SADDR.R           /* TCD Source Address */
#define DMA_TCD20_ATTR       DMA.TCD[20].ATTR.R            /* TCD Transfer Attributes */
#define DMA_TCD20_SOFF       DMA.TCD[20].SOFF.R            /* TCD Signed Source Address Offset */
#define DMA_TCD20_NBYTES_MLNO DMA.TCD[20].NBYTES.MLNO.R    /* TCD Minor Byte Count (Minor Loop Disabled) */
#define DMA_TCD20_NBYTES_MLOFFNO DMA.TCD[20].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Enabled and Offset Disabled) */
#define DMA_TCD20_NBYTES_MLOFFYES DMA.TCD[20].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_TCD20_SLAST      DMA.TCD[20].SLAST.R           /* TCD Last Source Address Adjustment */
#define DMA_TCD20_DADDR      DMA.TCD[20].DADDR.R           /* TCD Destination Address */
#define DMA_TCD20_CITER_ELINKNO DMA.TCD[20].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD20_CITER_ELINKYES DMA.TCD[20].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD20_DOFF       DMA.TCD[20].DOFF.R            /* TCD Signed Destination Address Offset */
#define DMA_TCD20_DLASTSGA   DMA.TCD[20].DLASTSGA.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_TCD20_BITER_ELINKNO DMA.TCD[20].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD20_BITER_ELINKYES DMA.TCD[20].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD20_CSR        DMA.TCD[20].CSR.R             /* TCD Control and Status */
#define DMA_TCD21_SADDR      DMA.TCD[21].SADDR.R           /* TCD Source Address */
#define DMA_TCD21_ATTR       DMA.TCD[21].ATTR.R            /* TCD Transfer Attributes */
#define DMA_TCD21_SOFF       DMA.TCD[21].SOFF.R            /* TCD Signed Source Address Offset */
#define DMA_TCD21_NBYTES_MLNO DMA.TCD[21].NBYTES.MLNO.R    /* TCD Minor Byte Count (Minor Loop Disabled) */
#define DMA_TCD21_NBYTES_MLOFFNO DMA.TCD[21].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Enabled and Offset Disabled) */
#define DMA_TCD21_NBYTES_MLOFFYES DMA.TCD[21].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_TCD21_SLAST      DMA.TCD[21].SLAST.R           /* TCD Last Source Address Adjustment */
#define DMA_TCD21_DADDR      DMA.TCD[21].DADDR.R           /* TCD Destination Address */
#define DMA_TCD21_CITER_ELINKNO DMA.TCD[21].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD21_CITER_ELINKYES DMA.TCD[21].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD21_DOFF       DMA.TCD[21].DOFF.R            /* TCD Signed Destination Address Offset */
#define DMA_TCD21_DLASTSGA   DMA.TCD[21].DLASTSGA.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_TCD21_BITER_ELINKNO DMA.TCD[21].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD21_BITER_ELINKYES DMA.TCD[21].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD21_CSR        DMA.TCD[21].CSR.R             /* TCD Control and Status */
#define DMA_TCD22_SADDR      DMA.TCD[22].SADDR.R           /* TCD Source Address */
#define DMA_TCD22_ATTR       DMA.TCD[22].ATTR.R            /* TCD Transfer Attributes */
#define DMA_TCD22_SOFF       DMA.TCD[22].SOFF.R            /* TCD Signed Source Address Offset */
#define DMA_TCD22_NBYTES_MLNO DMA.TCD[22].NBYTES.MLNO.R    /* TCD Minor Byte Count (Minor Loop Disabled) */
#define DMA_TCD22_NBYTES_MLOFFNO DMA.TCD[22].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Enabled and Offset Disabled) */
#define DMA_TCD22_NBYTES_MLOFFYES DMA.TCD[22].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_TCD22_SLAST      DMA.TCD[22].SLAST.R           /* TCD Last Source Address Adjustment */
#define DMA_TCD22_DADDR      DMA.TCD[22].DADDR.R           /* TCD Destination Address */
#define DMA_TCD22_CITER_ELINKNO DMA.TCD[22].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD22_CITER_ELINKYES DMA.TCD[22].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD22_DOFF       DMA.TCD[22].DOFF.R            /* TCD Signed Destination Address Offset */
#define DMA_TCD22_DLASTSGA   DMA.TCD[22].DLASTSGA.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_TCD22_BITER_ELINKNO DMA.TCD[22].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD22_BITER_ELINKYES DMA.TCD[22].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD22_CSR        DMA.TCD[22].CSR.R             /* TCD Control and Status */
#define DMA_TCD23_SADDR      DMA.TCD[23].SADDR.R           /* TCD Source Address */
#define DMA_TCD23_ATTR       DMA.TCD[23].ATTR.R            /* TCD Transfer Attributes */
#define DMA_TCD23_SOFF       DMA.TCD[23].SOFF.R            /* TCD Signed Source Address Offset */
#define DMA_TCD23_NBYTES_MLNO DMA.TCD[23].NBYTES.MLNO.R    /* TCD Minor Byte Count (Minor Loop Disabled) */
#define DMA_TCD23_NBYTES_MLOFFNO DMA.TCD[23].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Enabled and Offset Disabled) */
#define DMA_TCD23_NBYTES_MLOFFYES DMA.TCD[23].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_TCD23_SLAST      DMA.TCD[23].SLAST.R           /* TCD Last Source Address Adjustment */
#define DMA_TCD23_DADDR      DMA.TCD[23].DADDR.R           /* TCD Destination Address */
#define DMA_TCD23_CITER_ELINKNO DMA.TCD[23].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD23_CITER_ELINKYES DMA.TCD[23].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD23_DOFF       DMA.TCD[23].DOFF.R            /* TCD Signed Destination Address Offset */
#define DMA_TCD23_DLASTSGA   DMA.TCD[23].DLASTSGA.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_TCD23_BITER_ELINKNO DMA.TCD[23].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD23_BITER_ELINKYES DMA.TCD[23].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD23_CSR        DMA.TCD[23].CSR.R             /* TCD Control and Status */
#define DMA_TCD24_SADDR      DMA.TCD[24].SADDR.R           /* TCD Source Address */
#define DMA_TCD24_ATTR       DMA.TCD[24].ATTR.R            /* TCD Transfer Attributes */
#define DMA_TCD24_SOFF       DMA.TCD[24].SOFF.R            /* TCD Signed Source Address Offset */
#define DMA_TCD24_NBYTES_MLNO DMA.TCD[24].NBYTES.MLNO.R    /* TCD Minor Byte Count (Minor Loop Disabled) */
#define DMA_TCD24_NBYTES_MLOFFNO DMA.TCD[24].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Enabled and Offset Disabled) */
#define DMA_TCD24_NBYTES_MLOFFYES DMA.TCD[24].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_TCD24_SLAST      DMA.TCD[24].SLAST.R           /* TCD Last Source Address Adjustment */
#define DMA_TCD24_DADDR      DMA.TCD[24].DADDR.R           /* TCD Destination Address */
#define DMA_TCD24_CITER_ELINKNO DMA.TCD[24].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD24_CITER_ELINKYES DMA.TCD[24].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD24_DOFF       DMA.TCD[24].DOFF.R            /* TCD Signed Destination Address Offset */
#define DMA_TCD24_DLASTSGA   DMA.TCD[24].DLASTSGA.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_TCD24_BITER_ELINKNO DMA.TCD[24].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD24_BITER_ELINKYES DMA.TCD[24].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD24_CSR        DMA.TCD[24].CSR.R             /* TCD Control and Status */
#define DMA_TCD25_SADDR      DMA.TCD[25].SADDR.R           /* TCD Source Address */
#define DMA_TCD25_ATTR       DMA.TCD[25].ATTR.R            /* TCD Transfer Attributes */
#define DMA_TCD25_SOFF       DMA.TCD[25].SOFF.R            /* TCD Signed Source Address Offset */
#define DMA_TCD25_NBYTES_MLNO DMA.TCD[25].NBYTES.MLNO.R    /* TCD Minor Byte Count (Minor Loop Disabled) */
#define DMA_TCD25_NBYTES_MLOFFNO DMA.TCD[25].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Enabled and Offset Disabled) */
#define DMA_TCD25_NBYTES_MLOFFYES DMA.TCD[25].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_TCD25_SLAST      DMA.TCD[25].SLAST.R           /* TCD Last Source Address Adjustment */
#define DMA_TCD25_DADDR      DMA.TCD[25].DADDR.R           /* TCD Destination Address */
#define DMA_TCD25_CITER_ELINKNO DMA.TCD[25].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD25_CITER_ELINKYES DMA.TCD[25].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD25_DOFF       DMA.TCD[25].DOFF.R            /* TCD Signed Destination Address Offset */
#define DMA_TCD25_DLASTSGA   DMA.TCD[25].DLASTSGA.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_TCD25_BITER_ELINKNO DMA.TCD[25].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD25_BITER_ELINKYES DMA.TCD[25].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD25_CSR        DMA.TCD[25].CSR.R             /* TCD Control and Status */
#define DMA_TCD26_SADDR      DMA.TCD[26].SADDR.R           /* TCD Source Address */
#define DMA_TCD26_ATTR       DMA.TCD[26].ATTR.R            /* TCD Transfer Attributes */
#define DMA_TCD26_SOFF       DMA.TCD[26].SOFF.R            /* TCD Signed Source Address Offset */
#define DMA_TCD26_NBYTES_MLNO DMA.TCD[26].NBYTES.MLNO.R    /* TCD Minor Byte Count (Minor Loop Disabled) */
#define DMA_TCD26_NBYTES_MLOFFNO DMA.TCD[26].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Enabled and Offset Disabled) */
#define DMA_TCD26_NBYTES_MLOFFYES DMA.TCD[26].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_TCD26_SLAST      DMA.TCD[26].SLAST.R           /* TCD Last Source Address Adjustment */
#define DMA_TCD26_DADDR      DMA.TCD[26].DADDR.R           /* TCD Destination Address */
#define DMA_TCD26_CITER_ELINKNO DMA.TCD[26].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD26_CITER_ELINKYES DMA.TCD[26].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD26_DOFF       DMA.TCD[26].DOFF.R            /* TCD Signed Destination Address Offset */
#define DMA_TCD26_DLASTSGA   DMA.TCD[26].DLASTSGA.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_TCD26_BITER_ELINKNO DMA.TCD[26].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD26_BITER_ELINKYES DMA.TCD[26].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD26_CSR        DMA.TCD[26].CSR.R             /* TCD Control and Status */
#define DMA_TCD27_SADDR      DMA.TCD[27].SADDR.R           /* TCD Source Address */
#define DMA_TCD27_ATTR       DMA.TCD[27].ATTR.R            /* TCD Transfer Attributes */
#define DMA_TCD27_SOFF       DMA.TCD[27].SOFF.R            /* TCD Signed Source Address Offset */
#define DMA_TCD27_NBYTES_MLNO DMA.TCD[27].NBYTES.MLNO.R    /* TCD Minor Byte Count (Minor Loop Disabled) */
#define DMA_TCD27_NBYTES_MLOFFNO DMA.TCD[27].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Enabled and Offset Disabled) */
#define DMA_TCD27_NBYTES_MLOFFYES DMA.TCD[27].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_TCD27_SLAST      DMA.TCD[27].SLAST.R           /* TCD Last Source Address Adjustment */
#define DMA_TCD27_DADDR      DMA.TCD[27].DADDR.R           /* TCD Destination Address */
#define DMA_TCD27_CITER_ELINKNO DMA.TCD[27].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD27_CITER_ELINKYES DMA.TCD[27].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD27_DOFF       DMA.TCD[27].DOFF.R            /* TCD Signed Destination Address Offset */
#define DMA_TCD27_DLASTSGA   DMA.TCD[27].DLASTSGA.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_TCD27_BITER_ELINKNO DMA.TCD[27].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD27_BITER_ELINKYES DMA.TCD[27].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD27_CSR        DMA.TCD[27].CSR.R             /* TCD Control and Status */
#define DMA_TCD28_SADDR      DMA.TCD[28].SADDR.R           /* TCD Source Address */
#define DMA_TCD28_ATTR       DMA.TCD[28].ATTR.R            /* TCD Transfer Attributes */
#define DMA_TCD28_SOFF       DMA.TCD[28].SOFF.R            /* TCD Signed Source Address Offset */
#define DMA_TCD28_NBYTES_MLNO DMA.TCD[28].NBYTES.MLNO.R    /* TCD Minor Byte Count (Minor Loop Disabled) */
#define DMA_TCD28_NBYTES_MLOFFNO DMA.TCD[28].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Enabled and Offset Disabled) */
#define DMA_TCD28_NBYTES_MLOFFYES DMA.TCD[28].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_TCD28_SLAST      DMA.TCD[28].SLAST.R           /* TCD Last Source Address Adjustment */
#define DMA_TCD28_DADDR      DMA.TCD[28].DADDR.R           /* TCD Destination Address */
#define DMA_TCD28_CITER_ELINKNO DMA.TCD[28].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD28_CITER_ELINKYES DMA.TCD[28].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD28_DOFF       DMA.TCD[28].DOFF.R            /* TCD Signed Destination Address Offset */
#define DMA_TCD28_DLASTSGA   DMA.TCD[28].DLASTSGA.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_TCD28_BITER_ELINKNO DMA.TCD[28].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD28_BITER_ELINKYES DMA.TCD[28].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD28_CSR        DMA.TCD[28].CSR.R             /* TCD Control and Status */
#define DMA_TCD29_SADDR      DMA.TCD[29].SADDR.R           /* TCD Source Address */
#define DMA_TCD29_ATTR       DMA.TCD[29].ATTR.R            /* TCD Transfer Attributes */
#define DMA_TCD29_SOFF       DMA.TCD[29].SOFF.R            /* TCD Signed Source Address Offset */
#define DMA_TCD29_NBYTES_MLNO DMA.TCD[29].NBYTES.MLNO.R    /* TCD Minor Byte Count (Minor Loop Disabled) */
#define DMA_TCD29_NBYTES_MLOFFNO DMA.TCD[29].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Enabled and Offset Disabled) */
#define DMA_TCD29_NBYTES_MLOFFYES DMA.TCD[29].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_TCD29_SLAST      DMA.TCD[29].SLAST.R           /* TCD Last Source Address Adjustment */
#define DMA_TCD29_DADDR      DMA.TCD[29].DADDR.R           /* TCD Destination Address */
#define DMA_TCD29_CITER_ELINKNO DMA.TCD[29].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD29_CITER_ELINKYES DMA.TCD[29].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD29_DOFF       DMA.TCD[29].DOFF.R            /* TCD Signed Destination Address Offset */
#define DMA_TCD29_DLASTSGA   DMA.TCD[29].DLASTSGA.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_TCD29_BITER_ELINKNO DMA.TCD[29].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD29_BITER_ELINKYES DMA.TCD[29].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD29_CSR        DMA.TCD[29].CSR.R             /* TCD Control and Status */
#define DMA_TCD30_SADDR      DMA.TCD[30].SADDR.R           /* TCD Source Address */
#define DMA_TCD30_ATTR       DMA.TCD[30].ATTR.R            /* TCD Transfer Attributes */
#define DMA_TCD30_SOFF       DMA.TCD[30].SOFF.R            /* TCD Signed Source Address Offset */
#define DMA_TCD30_NBYTES_MLNO DMA.TCD[30].NBYTES.MLNO.R    /* TCD Minor Byte Count (Minor Loop Disabled) */
#define DMA_TCD30_NBYTES_MLOFFNO DMA.TCD[30].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Enabled and Offset Disabled) */
#define DMA_TCD30_NBYTES_MLOFFYES DMA.TCD[30].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_TCD30_SLAST      DMA.TCD[30].SLAST.R           /* TCD Last Source Address Adjustment */
#define DMA_TCD30_DADDR      DMA.TCD[30].DADDR.R           /* TCD Destination Address */
#define DMA_TCD30_CITER_ELINKNO DMA.TCD[30].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD30_CITER_ELINKYES DMA.TCD[30].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD30_DOFF       DMA.TCD[30].DOFF.R            /* TCD Signed Destination Address Offset */
#define DMA_TCD30_DLASTSGA   DMA.TCD[30].DLASTSGA.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_TCD30_BITER_ELINKNO DMA.TCD[30].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD30_BITER_ELINKYES DMA.TCD[30].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD30_CSR        DMA.TCD[30].CSR.R             /* TCD Control and Status */
#define DMA_TCD31_SADDR      DMA.TCD[31].SADDR.R           /* TCD Source Address */
#define DMA_TCD31_ATTR       DMA.TCD[31].ATTR.R            /* TCD Transfer Attributes */
#define DMA_TCD31_SOFF       DMA.TCD[31].SOFF.R            /* TCD Signed Source Address Offset */
#define DMA_TCD31_NBYTES_MLNO DMA.TCD[31].NBYTES.MLNO.R    /* TCD Minor Byte Count (Minor Loop Disabled) */
#define DMA_TCD31_NBYTES_MLOFFNO DMA.TCD[31].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor Loop Enabled and Offset Disabled) */
#define DMA_TCD31_NBYTES_MLOFFYES DMA.TCD[31].NBYTES.MLOFFYES.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_TCD31_SLAST      DMA.TCD[31].SLAST.R           /* TCD Last Source Address Adjustment */
#define DMA_TCD31_DADDR      DMA.TCD[31].DADDR.R           /* TCD Destination Address */
#define DMA_TCD31_CITER_ELINKNO DMA.TCD[31].CITER.ELINKNO.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD31_CITER_ELINKYES DMA.TCD[31].CITER.ELINKYES.R /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD31_DOFF       DMA.TCD[31].DOFF.R            /* TCD Signed Destination Address Offset */
#define DMA_TCD31_DLASTSGA   DMA.TCD[31].DLASTSGA.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_TCD31_BITER_ELINKNO DMA.TCD[31].BITER.ELINKNO.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_TCD31_BITER_ELINKYES DMA.TCD[31].BITER.ELINKYES.R /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_TCD31_CSR        DMA.TCD[31].CSR.R             /* TCD Control and Status */

/* DMAMUX */
#define DMAMUX_0_CHCFG0      DMAMUX_0.CHCFG[0].R           /* Channel Configuration register */
#define DMAMUX_0_CHCFG1      DMAMUX_0.CHCFG[1].R           /* Channel Configuration register */
#define DMAMUX_0_CHCFG2      DMAMUX_0.CHCFG[2].R           /* Channel Configuration register */
#define DMAMUX_0_CHCFG3      DMAMUX_0.CHCFG[3].R           /* Channel Configuration register */
#define DMAMUX_0_CHCFG4      DMAMUX_0.CHCFG[4].R           /* Channel Configuration register */
#define DMAMUX_0_CHCFG5      DMAMUX_0.CHCFG[5].R           /* Channel Configuration register */
#define DMAMUX_0_CHCFG6      DMAMUX_0.CHCFG[6].R           /* Channel Configuration register */
#define DMAMUX_0_CHCFG7      DMAMUX_0.CHCFG[7].R           /* Channel Configuration register */
#define DMAMUX_0_CHCFG8      DMAMUX_0.CHCFG[8].R           /* Channel Configuration register */
#define DMAMUX_0_CHCFG9      DMAMUX_0.CHCFG[9].R           /* Channel Configuration register */
#define DMAMUX_0_CHCFG10     DMAMUX_0.CHCFG[10].R          /* Channel Configuration register */
#define DMAMUX_0_CHCFG11     DMAMUX_0.CHCFG[11].R          /* Channel Configuration register */
#define DMAMUX_0_CHCFG12     DMAMUX_0.CHCFG[12].R          /* Channel Configuration register */
#define DMAMUX_0_CHCFG13     DMAMUX_0.CHCFG[13].R          /* Channel Configuration register */
#define DMAMUX_0_CHCFG14     DMAMUX_0.CHCFG[14].R          /* Channel Configuration register */
#define DMAMUX_0_CHCFG15     DMAMUX_0.CHCFG[15].R          /* Channel Configuration register */

/* DMAMUX */
#define DMAMUX_1_CHCFG0      DMAMUX_1.CHCFG[0].R           /* Channel Configuration register */
#define DMAMUX_1_CHCFG1      DMAMUX_1.CHCFG[1].R           /* Channel Configuration register */
#define DMAMUX_1_CHCFG2      DMAMUX_1.CHCFG[2].R           /* Channel Configuration register */
#define DMAMUX_1_CHCFG3      DMAMUX_1.CHCFG[3].R           /* Channel Configuration register */
#define DMAMUX_1_CHCFG4      DMAMUX_1.CHCFG[4].R           /* Channel Configuration register */
#define DMAMUX_1_CHCFG5      DMAMUX_1.CHCFG[5].R           /* Channel Configuration register */
#define DMAMUX_1_CHCFG6      DMAMUX_1.CHCFG[6].R           /* Channel Configuration register */
#define DMAMUX_1_CHCFG7      DMAMUX_1.CHCFG[7].R           /* Channel Configuration register */
#define DMAMUX_1_CHCFG8      DMAMUX_1.CHCFG[8].R           /* Channel Configuration register */
#define DMAMUX_1_CHCFG9      DMAMUX_1.CHCFG[9].R           /* Channel Configuration register */
#define DMAMUX_1_CHCFG10     DMAMUX_1.CHCFG[10].R          /* Channel Configuration register */
#define DMAMUX_1_CHCFG11     DMAMUX_1.CHCFG[11].R          /* Channel Configuration register */
#define DMAMUX_1_CHCFG12     DMAMUX_1.CHCFG[12].R          /* Channel Configuration register */
#define DMAMUX_1_CHCFG13     DMAMUX_1.CHCFG[13].R          /* Channel Configuration register */
#define DMAMUX_1_CHCFG14     DMAMUX_1.CHCFG[14].R          /* Channel Configuration register */
#define DMAMUX_1_CHCFG15     DMAMUX_1.CHCFG[15].R          /* Channel Configuration register */

/* DSPI */
#define DSPI_0_MCR           DSPI_0.MCR.R                  /* Module Configuration Register */
#define DSPI_0_TCR           DSPI_0.TCR.R                  /* Transfer Count Register */
#define DSPI_0_CTAR0         DSPI_0.MODE.CTAR[0].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_0_CTAR1         DSPI_0.MODE.CTAR[1].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_0_CTAR0_SLAVE   DSPI_0.MODE.CTAR_SLAVE[0].R   /* Clock and Transfer Attributes Register (In Slave Mode) */
#define DSPI_0_CTAR1_SLAVE   DSPI_0.MODE.CTAR_SLAVE[1].R   /* Clock and Transfer Attributes Register (In Slave Mode) */
#define DSPI_0_CTAR2         DSPI_0.CTAR[0].R              /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_0_CTAR3         DSPI_0.CTAR[1].R              /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_0_CTAR4         DSPI_0.CTAR[2].R              /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_0_CTAR5         DSPI_0.CTAR[3].R              /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_0_SR            DSPI_0.SR.R                   /* Status Register */
#define DSPI_0_RSER          DSPI_0.RSER.R                 /* DMA/Interrupt Request Select and Enable Register */
#define DSPI_0_PUSHR         DSPI_0.PUSHR.PUSHR.R          /* PUSH TX FIFO Register In Master Mode */
#define DSPI_0_PUSHR_SLAVE   DSPI_0.PUSHR.PUSHR_SLAVE.R    /* PUSH TX FIFO Register In Slave Mode */
#define DSPI_0_POPR          DSPI_0.POPR.R                 /* POP RX FIFO Register */
#define DSPI_0_TXFR0         DSPI_0.TXFR[0].R              /* Transmit FIFO Registers */
#define DSPI_0_TXFR1         DSPI_0.TXFR[1].R              /* Transmit FIFO Registers */
#define DSPI_0_TXFR2         DSPI_0.TXFR[2].R              /* Transmit FIFO Registers */
#define DSPI_0_TXFR3         DSPI_0.TXFR[3].R              /* Transmit FIFO Registers */
#define DSPI_0_RXFR0         DSPI_0.RXFR[0].R              /* Receive FIFO Registers */
#define DSPI_0_RXFR1         DSPI_0.RXFR[1].R              /* Receive FIFO Registers */
#define DSPI_0_RXFR2         DSPI_0.RXFR[2].R              /* Receive FIFO Registers */
#define DSPI_0_RXFR3         DSPI_0.RXFR[3].R              /* Receive FIFO Registers */
#define DSPI_0_DSICR0        DSPI_0.DSICR0.R               /* DSI Configuration Register 0 */
#define DSPI_0_SDR0          DSPI_0.SDR0.R                 /* DSI Serialization Data Register 0 */
#define DSPI_0_ASDR0         DSPI_0.ASDR0.R                /* DSI Alternate Serialization Data Register 0 */
#define DSPI_0_COMPR0        DSPI_0.COMPR0.R               /* DSI Transmit Comparison Register 0 */
#define DSPI_0_DDR0          DSPI_0.DDR0.R                 /* DSI Deserialization Data Register 0 */
#define DSPI_0_DSICR1        DSPI_0.DSICR1.R               /* DSI Configuration Register 1 */
#define DSPI_0_SSR0          DSPI_0.SSR0.R                 /* DSI Serialization Source Select Register 0 */
#define DSPI_0_PISR0         DSPI_0.PISR0.R                /* DSI Parallel Input Select Register 0 */
#define DSPI_0_PISR1         DSPI_0.PISR1.R                /* DSI Parallel Input Select Register 1 */
#define DSPI_0_PISR2         DSPI_0.PISR2.R                /* DSI Parallel Input Select Register 2 */
#define DSPI_0_PISR3         DSPI_0.PISR3.R                /* DSI Parallel Input Select Register 3 */
#define DSPI_0_DIMR0         DSPI_0.DIMR0.R                /* DSI Deserialized Data Interrupt Mask Register 0 */
#define DSPI_0_DPIR0         DSPI_0.DPIR0.R                /* DSI Deserialized Data Polarity Interrupt Register 0 */
#define DSPI_0_SDR1          DSPI_0.SDR1.R                 /* DSI Serialization Data Register 1 */
#define DSPI_0_ASDR1         DSPI_0.ASDR1.R                /* DSI Alternate Serialization Data Register 1 */
#define DSPI_0_COMPR1        DSPI_0.COMPR1.R               /* DSI Transmit Comparison Register 1 */
#define DSPI_0_DDR1          DSPI_0.DDR1.R                 /* DSI Deserialization Data Register 1 */
#define DSPI_0_SSR1          DSPI_0.SSR1.R                 /* DSI Serialization Source Select Register 1 */
#define DSPI_0_PISR4         DSPI_0.PISR4.R                /* DSI Parallel Input Select Register 4 */
#define DSPI_0_PISR5         DSPI_0.PISR5.R                /* DSI Parallel Input Select Register 5 */
#define DSPI_0_PISR6         DSPI_0.PISR6.R                /* DSI Parallel Input Select Register 6 */
#define DSPI_0_PISR7         DSPI_0.PISR7.R                /* DSI Parallel Input Select Register 7 */
#define DSPI_0_DIMR1         DSPI_0.DIMR1.R                /* DSI Deserialized Data Interrupt Mask Register 1 */
#define DSPI_0_DPIR1         DSPI_0.DPIR1.R                /* DSI Deserialized Data Polarity Interrupt Register 1 */
#define DSPI_0_CTARE0        DSPI_0.CTARE[0].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_0_CTARE1        DSPI_0.CTARE[1].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_0_CTARE2        DSPI_0.CTARE[2].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_0_CTARE3        DSPI_0.CTARE[3].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_0_CTARE4        DSPI_0.CTARE[4].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_0_CTARE5        DSPI_0.CTARE[5].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_0_SREX          DSPI_0.SREX.R                 /* Status Register Extended */
#define DSPI_0_TRIG          DSPI_0.TRIG.R                 /* Trigger Register */

/* DSPI */
#define DSPI_1_MCR           DSPI_1.MCR.R                  /* Module Configuration Register */
#define DSPI_1_TCR           DSPI_1.TCR.R                  /* Transfer Count Register */
#define DSPI_1_CTAR0         DSPI_1.MODE.CTAR[0].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_1_CTAR1         DSPI_1.MODE.CTAR[1].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_1_CTAR0_SLAVE   DSPI_1.MODE.CTAR_SLAVE[0].R   /* Clock and Transfer Attributes Register (In Slave Mode) */
#define DSPI_1_CTAR1_SLAVE   DSPI_1.MODE.CTAR_SLAVE[1].R   /* Clock and Transfer Attributes Register (In Slave Mode) */
#define DSPI_1_CTAR2         DSPI_1.CTAR[0].R              /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_1_CTAR3         DSPI_1.CTAR[1].R              /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_1_CTAR4         DSPI_1.CTAR[2].R              /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_1_CTAR5         DSPI_1.CTAR[3].R              /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_1_SR            DSPI_1.SR.R                   /* Status Register */
#define DSPI_1_RSER          DSPI_1.RSER.R                 /* DMA/Interrupt Request Select and Enable Register */
#define DSPI_1_PUSHR         DSPI_1.PUSHR.PUSHR.R          /* PUSH TX FIFO Register In Master Mode */
#define DSPI_1_PUSHR_SLAVE   DSPI_1.PUSHR.PUSHR_SLAVE.R    /* PUSH TX FIFO Register In Slave Mode */
#define DSPI_1_POPR          DSPI_1.POPR.R                 /* POP RX FIFO Register */
#define DSPI_1_TXFR0         DSPI_1.TXFR[0].R              /* Transmit FIFO Registers */
#define DSPI_1_TXFR1         DSPI_1.TXFR[1].R              /* Transmit FIFO Registers */
#define DSPI_1_TXFR2         DSPI_1.TXFR[2].R              /* Transmit FIFO Registers */
#define DSPI_1_TXFR3         DSPI_1.TXFR[3].R              /* Transmit FIFO Registers */
#define DSPI_1_RXFR0         DSPI_1.RXFR[0].R              /* Receive FIFO Registers */
#define DSPI_1_RXFR1         DSPI_1.RXFR[1].R              /* Receive FIFO Registers */
#define DSPI_1_RXFR2         DSPI_1.RXFR[2].R              /* Receive FIFO Registers */
#define DSPI_1_RXFR3         DSPI_1.RXFR[3].R              /* Receive FIFO Registers */
#define DSPI_1_DSICR0        DSPI_1.DSICR0.R               /* DSI Configuration Register 0 */
#define DSPI_1_SDR0          DSPI_1.SDR0.R                 /* DSI Serialization Data Register 0 */
#define DSPI_1_ASDR0         DSPI_1.ASDR0.R                /* DSI Alternate Serialization Data Register 0 */
#define DSPI_1_COMPR0        DSPI_1.COMPR0.R               /* DSI Transmit Comparison Register 0 */
#define DSPI_1_DDR0          DSPI_1.DDR0.R                 /* DSI Deserialization Data Register 0 */
#define DSPI_1_DSICR1        DSPI_1.DSICR1.R               /* DSI Configuration Register 1 */
#define DSPI_1_SSR0          DSPI_1.SSR0.R                 /* DSI Serialization Source Select Register 0 */
#define DSPI_1_PISR0         DSPI_1.PISR0.R                /* DSI Parallel Input Select Register 0 */
#define DSPI_1_PISR1         DSPI_1.PISR1.R                /* DSI Parallel Input Select Register 1 */
#define DSPI_1_PISR2         DSPI_1.PISR2.R                /* DSI Parallel Input Select Register 2 */
#define DSPI_1_PISR3         DSPI_1.PISR3.R                /* DSI Parallel Input Select Register 3 */
#define DSPI_1_DIMR0         DSPI_1.DIMR0.R                /* DSI Deserialized Data Interrupt Mask Register 0 */
#define DSPI_1_DPIR0         DSPI_1.DPIR0.R                /* DSI Deserialized Data Polarity Interrupt Register 0 */
#define DSPI_1_SDR1          DSPI_1.SDR1.R                 /* DSI Serialization Data Register 1 */
#define DSPI_1_ASDR1         DSPI_1.ASDR1.R                /* DSI Alternate Serialization Data Register 1 */
#define DSPI_1_COMPR1        DSPI_1.COMPR1.R               /* DSI Transmit Comparison Register 1 */
#define DSPI_1_DDR1          DSPI_1.DDR1.R                 /* DSI Deserialization Data Register 1 */
#define DSPI_1_SSR1          DSPI_1.SSR1.R                 /* DSI Serialization Source Select Register 1 */
#define DSPI_1_PISR4         DSPI_1.PISR4.R                /* DSI Parallel Input Select Register 4 */
#define DSPI_1_PISR5         DSPI_1.PISR5.R                /* DSI Parallel Input Select Register 5 */
#define DSPI_1_PISR6         DSPI_1.PISR6.R                /* DSI Parallel Input Select Register 6 */
#define DSPI_1_PISR7         DSPI_1.PISR7.R                /* DSI Parallel Input Select Register 7 */
#define DSPI_1_DIMR1         DSPI_1.DIMR1.R                /* DSI Deserialized Data Interrupt Mask Register 1 */
#define DSPI_1_DPIR1         DSPI_1.DPIR1.R                /* DSI Deserialized Data Polarity Interrupt Register 1 */
#define DSPI_1_CTARE0        DSPI_1.CTARE[0].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_1_CTARE1        DSPI_1.CTARE[1].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_1_CTARE2        DSPI_1.CTARE[2].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_1_CTARE3        DSPI_1.CTARE[3].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_1_CTARE4        DSPI_1.CTARE[4].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_1_CTARE5        DSPI_1.CTARE[5].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_1_SREX          DSPI_1.SREX.R                 /* Status Register Extended */
#define DSPI_1_TRIG          DSPI_1.TRIG.R                 /* Trigger Register */

/* DSPI */
#define DSPI_2_MCR           DSPI_2.MCR.R                  /* Module Configuration Register */
#define DSPI_2_TCR           DSPI_2.TCR.R                  /* Transfer Count Register */
#define DSPI_2_CTAR0         DSPI_2.MODE.CTAR[0].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_2_CTAR1         DSPI_2.MODE.CTAR[1].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_2_CTAR0_SLAVE   DSPI_2.MODE.CTAR_SLAVE[0].R   /* Clock and Transfer Attributes Register (In Slave Mode) */
#define DSPI_2_CTAR1_SLAVE   DSPI_2.MODE.CTAR_SLAVE[1].R   /* Clock and Transfer Attributes Register (In Slave Mode) */
#define DSPI_2_CTAR2         DSPI_2.CTAR[0].R              /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_2_CTAR3         DSPI_2.CTAR[1].R              /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_2_CTAR4         DSPI_2.CTAR[2].R              /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_2_CTAR5         DSPI_2.CTAR[3].R              /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_2_SR            DSPI_2.SR.R                   /* Status Register */
#define DSPI_2_RSER          DSPI_2.RSER.R                 /* DMA/Interrupt Request Select and Enable Register */
#define DSPI_2_PUSHR         DSPI_2.PUSHR.PUSHR.R          /* PUSH TX FIFO Register In Master Mode */
#define DSPI_2_PUSHR_SLAVE   DSPI_2.PUSHR.PUSHR_SLAVE.R    /* PUSH TX FIFO Register In Slave Mode */
#define DSPI_2_POPR          DSPI_2.POPR.R                 /* POP RX FIFO Register */
#define DSPI_2_TXFR0         DSPI_2.TXFR[0].R              /* Transmit FIFO Registers */
#define DSPI_2_TXFR1         DSPI_2.TXFR[1].R              /* Transmit FIFO Registers */
#define DSPI_2_TXFR2         DSPI_2.TXFR[2].R              /* Transmit FIFO Registers */
#define DSPI_2_TXFR3         DSPI_2.TXFR[3].R              /* Transmit FIFO Registers */
#define DSPI_2_RXFR0         DSPI_2.RXFR[0].R              /* Receive FIFO Registers */
#define DSPI_2_RXFR1         DSPI_2.RXFR[1].R              /* Receive FIFO Registers */
#define DSPI_2_RXFR2         DSPI_2.RXFR[2].R              /* Receive FIFO Registers */
#define DSPI_2_RXFR3         DSPI_2.RXFR[3].R              /* Receive FIFO Registers */
#define DSPI_2_DSICR0        DSPI_2.DSICR0.R               /* DSI Configuration Register 0 */
#define DSPI_2_SDR0          DSPI_2.SDR0.R                 /* DSI Serialization Data Register 0 */
#define DSPI_2_ASDR0         DSPI_2.ASDR0.R                /* DSI Alternate Serialization Data Register 0 */
#define DSPI_2_COMPR0        DSPI_2.COMPR0.R               /* DSI Transmit Comparison Register 0 */
#define DSPI_2_DDR0          DSPI_2.DDR0.R                 /* DSI Deserialization Data Register 0 */
#define DSPI_2_DSICR1        DSPI_2.DSICR1.R               /* DSI Configuration Register 1 */
#define DSPI_2_SSR0          DSPI_2.SSR0.R                 /* DSI Serialization Source Select Register 0 */
#define DSPI_2_PISR0         DSPI_2.PISR0.R                /* DSI Parallel Input Select Register 0 */
#define DSPI_2_PISR1         DSPI_2.PISR1.R                /* DSI Parallel Input Select Register 1 */
#define DSPI_2_PISR2         DSPI_2.PISR2.R                /* DSI Parallel Input Select Register 2 */
#define DSPI_2_PISR3         DSPI_2.PISR3.R                /* DSI Parallel Input Select Register 3 */
#define DSPI_2_DIMR0         DSPI_2.DIMR0.R                /* DSI Deserialized Data Interrupt Mask Register 0 */
#define DSPI_2_DPIR0         DSPI_2.DPIR0.R                /* DSI Deserialized Data Polarity Interrupt Register 0 */
#define DSPI_2_SDR1          DSPI_2.SDR1.R                 /* DSI Serialization Data Register 1 */
#define DSPI_2_ASDR1         DSPI_2.ASDR1.R                /* DSI Alternate Serialization Data Register 1 */
#define DSPI_2_COMPR1        DSPI_2.COMPR1.R               /* DSI Transmit Comparison Register 1 */
#define DSPI_2_DDR1          DSPI_2.DDR1.R                 /* DSI Deserialization Data Register 1 */
#define DSPI_2_SSR1          DSPI_2.SSR1.R                 /* DSI Serialization Source Select Register 1 */
#define DSPI_2_PISR4         DSPI_2.PISR4.R                /* DSI Parallel Input Select Register 4 */
#define DSPI_2_PISR5         DSPI_2.PISR5.R                /* DSI Parallel Input Select Register 5 */
#define DSPI_2_PISR6         DSPI_2.PISR6.R                /* DSI Parallel Input Select Register 6 */
#define DSPI_2_PISR7         DSPI_2.PISR7.R                /* DSI Parallel Input Select Register 7 */
#define DSPI_2_DIMR1         DSPI_2.DIMR1.R                /* DSI Deserialized Data Interrupt Mask Register 1 */
#define DSPI_2_DPIR1         DSPI_2.DPIR1.R                /* DSI Deserialized Data Polarity Interrupt Register 1 */
#define DSPI_2_CTARE0        DSPI_2.CTARE[0].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_2_CTARE1        DSPI_2.CTARE[1].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_2_CTARE2        DSPI_2.CTARE[2].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_2_CTARE3        DSPI_2.CTARE[3].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_2_CTARE4        DSPI_2.CTARE[4].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_2_CTARE5        DSPI_2.CTARE[5].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_2_SREX          DSPI_2.SREX.R                 /* Status Register Extended */
#define DSPI_2_TRIG          DSPI_2.TRIG.R                 /* Trigger Register */

/* DSPI */
#define DSPI_3_MCR           DSPI_3.MCR.R                  /* Module Configuration Register */
#define DSPI_3_TCR           DSPI_3.TCR.R                  /* Transfer Count Register */
#define DSPI_3_CTAR0         DSPI_3.MODE.CTAR[0].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_3_CTAR1         DSPI_3.MODE.CTAR[1].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_3_CTAR0_SLAVE   DSPI_3.MODE.CTAR_SLAVE[0].R   /* Clock and Transfer Attributes Register (In Slave Mode) */
#define DSPI_3_CTAR1_SLAVE   DSPI_3.MODE.CTAR_SLAVE[1].R   /* Clock and Transfer Attributes Register (In Slave Mode) */
#define DSPI_3_CTAR2         DSPI_3.CTAR[0].R              /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_3_CTAR3         DSPI_3.CTAR[1].R              /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_3_CTAR4         DSPI_3.CTAR[2].R              /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_3_CTAR5         DSPI_3.CTAR[3].R              /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_3_SR            DSPI_3.SR.R                   /* Status Register */
#define DSPI_3_RSER          DSPI_3.RSER.R                 /* DMA/Interrupt Request Select and Enable Register */
#define DSPI_3_PUSHR         DSPI_3.PUSHR.PUSHR.R          /* PUSH TX FIFO Register In Master Mode */
#define DSPI_3_PUSHR_SLAVE   DSPI_3.PUSHR.PUSHR_SLAVE.R    /* PUSH TX FIFO Register In Slave Mode */
#define DSPI_3_POPR          DSPI_3.POPR.R                 /* POP RX FIFO Register */
#define DSPI_3_TXFR0         DSPI_3.TXFR[0].R              /* Transmit FIFO Registers */
#define DSPI_3_TXFR1         DSPI_3.TXFR[1].R              /* Transmit FIFO Registers */
#define DSPI_3_TXFR2         DSPI_3.TXFR[2].R              /* Transmit FIFO Registers */
#define DSPI_3_TXFR3         DSPI_3.TXFR[3].R              /* Transmit FIFO Registers */
#define DSPI_3_RXFR0         DSPI_3.RXFR[0].R              /* Receive FIFO Registers */
#define DSPI_3_RXFR1         DSPI_3.RXFR[1].R              /* Receive FIFO Registers */
#define DSPI_3_RXFR2         DSPI_3.RXFR[2].R              /* Receive FIFO Registers */
#define DSPI_3_RXFR3         DSPI_3.RXFR[3].R              /* Receive FIFO Registers */
#define DSPI_3_DSICR0        DSPI_3.DSICR0.R               /* DSI Configuration Register 0 */
#define DSPI_3_SDR0          DSPI_3.SDR0.R                 /* DSI Serialization Data Register 0 */
#define DSPI_3_ASDR0         DSPI_3.ASDR0.R                /* DSI Alternate Serialization Data Register 0 */
#define DSPI_3_COMPR0        DSPI_3.COMPR0.R               /* DSI Transmit Comparison Register 0 */
#define DSPI_3_DDR0          DSPI_3.DDR0.R                 /* DSI Deserialization Data Register 0 */
#define DSPI_3_DSICR1        DSPI_3.DSICR1.R               /* DSI Configuration Register 1 */
#define DSPI_3_SSR0          DSPI_3.SSR0.R                 /* DSI Serialization Source Select Register 0 */
#define DSPI_3_PISR0         DSPI_3.PISR0.R                /* DSI Parallel Input Select Register 0 */
#define DSPI_3_PISR1         DSPI_3.PISR1.R                /* DSI Parallel Input Select Register 1 */
#define DSPI_3_PISR2         DSPI_3.PISR2.R                /* DSI Parallel Input Select Register 2 */
#define DSPI_3_PISR3         DSPI_3.PISR3.R                /* DSI Parallel Input Select Register 3 */
#define DSPI_3_DIMR0         DSPI_3.DIMR0.R                /* DSI Deserialized Data Interrupt Mask Register 0 */
#define DSPI_3_DPIR0         DSPI_3.DPIR0.R                /* DSI Deserialized Data Polarity Interrupt Register 0 */
#define DSPI_3_SDR1          DSPI_3.SDR1.R                 /* DSI Serialization Data Register 1 */
#define DSPI_3_ASDR1         DSPI_3.ASDR1.R                /* DSI Alternate Serialization Data Register 1 */
#define DSPI_3_COMPR1        DSPI_3.COMPR1.R               /* DSI Transmit Comparison Register 1 */
#define DSPI_3_DDR1          DSPI_3.DDR1.R                 /* DSI Deserialization Data Register 1 */
#define DSPI_3_SSR1          DSPI_3.SSR1.R                 /* DSI Serialization Source Select Register 1 */
#define DSPI_3_PISR4         DSPI_3.PISR4.R                /* DSI Parallel Input Select Register 4 */
#define DSPI_3_PISR5         DSPI_3.PISR5.R                /* DSI Parallel Input Select Register 5 */
#define DSPI_3_PISR6         DSPI_3.PISR6.R                /* DSI Parallel Input Select Register 6 */
#define DSPI_3_PISR7         DSPI_3.PISR7.R                /* DSI Parallel Input Select Register 7 */
#define DSPI_3_DIMR1         DSPI_3.DIMR1.R                /* DSI Deserialized Data Interrupt Mask Register 1 */
#define DSPI_3_DPIR1         DSPI_3.DPIR1.R                /* DSI Deserialized Data Polarity Interrupt Register 1 */
#define DSPI_3_CTARE0        DSPI_3.CTARE[0].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_3_CTARE1        DSPI_3.CTARE[1].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_3_CTARE2        DSPI_3.CTARE[2].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_3_CTARE3        DSPI_3.CTARE[3].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_3_CTARE4        DSPI_3.CTARE[4].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_3_CTARE5        DSPI_3.CTARE[5].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_3_SREX          DSPI_3.SREX.R                 /* Status Register Extended */
#define DSPI_3_TRIG          DSPI_3.TRIG.R                 /* Trigger Register */

/* ENET */
#define ENET_EIR             ENET.EIR.R                    /* Interrupt Event Register */
#define ENET_EIMR            ENET.EIMR.R                   /* Interrupt Mask Register */
#define ENET_RDAR            ENET.RDAR.R                   /* Receive Descriptor Active Register - Ring 0 */
#define ENET_TDAR            ENET.TDAR.R                   /* Transmit Descriptor Active Register - Ring 0 */
#define ENET_ECR             ENET.ECR.R                    /* Ethernet Control Register */
#define ENET_MMFR            ENET.MMFR.R                   /* MII Management Frame Register */
#define ENET_MSCR            ENET.MSCR.R                   /* MII Speed Control Register */
#define ENET_MIBC            ENET.MIBC.R                   /* MIB Control Register */
#define ENET_RCR             ENET.RCR.R                    /* Receive Control Register */
#define ENET_TCR             ENET.TCR.R                    /* Transmit Control Register */
#define ENET_PALR            ENET.PALR.R                   /* Physical Address Lower Register */
#define ENET_PAUR            ENET.PAUR.R                   /* Physical Address Upper Register */
#define ENET_OPD             ENET.OPD.R                    /* Opcode/Pause Duration Register */
#define ENET_TXIC0           ENET.TXIC[0].R                /* Transmit Interrupt Coalescing Register */
#define ENET_TXIC1           ENET.TXIC[1].R                /* Transmit Interrupt Coalescing Register */
#define ENET_TXIC2           ENET.TXIC[2].R                /* Transmit Interrupt Coalescing Register */
#define ENET_RXIC0           ENET.RXIC[0].R                /* Receive Interrupt Coalescing Register */
#define ENET_RXIC1           ENET.RXIC[1].R                /* Receive Interrupt Coalescing Register */
#define ENET_RXIC2           ENET.RXIC[2].R                /* Receive Interrupt Coalescing Register */
#define ENET_IAUR            ENET.IAUR.R                   /* Descriptor Individual Upper Address Register */
#define ENET_IALR            ENET.IALR.R                   /* Descriptor Individual Lower Address Register */
#define ENET_GAUR            ENET.GAUR.R                   /* Descriptor Group Upper Address Register */
#define ENET_GALR            ENET.GALR.R                   /* Descriptor Group Lower Address Register */
#define ENET_TFWR            ENET.TFWR.R                   /* Transmit FIFO Watermark Register */
#define ENET_RDSR1           ENET.RDSR1.R                  /* Receive Descriptor Ring 1 Start Register */
#define ENET_TDSR1           ENET.TDSR1.R                  /* Transmit Buffer Descriptor Ring 1 Start Register */
#define ENET_MRBR1           ENET.MRBR1.R                  /* Maximum Receive Buffer Size Register - Ring 1 */
#define ENET_RDSR2           ENET.RDSR2.R                  /* Receive Descriptor Ring 2 Start Register */
#define ENET_TDSR2           ENET.TDSR2.R                  /* Transmit Buffer Descriptor Ring 2 Start Register */
#define ENET_MRBR2           ENET.MRBR2.R                  /* Maximum Receive Buffer Size Register - Ring 2 */
#define ENET_RDSR            ENET.RDSR.R                   /* Receive Descriptor Ring 0 Start Register */
#define ENET_TDSR            ENET.TDSR.R                   /* Transmit Buffer Descriptor Ring 0 Start Register */
#define ENET_MRBR            ENET.MRBR.R                   /* Maximum Receive Buffer Size Register - Ring 0 */
#define ENET_RSFL            ENET.RSFL.R                   /* Receive FIFO Section Full Threshold */
#define ENET_RSEM            ENET.RSEM.R                   /* Receive FIFO Section Empty Threshold */
#define ENET_RAEM            ENET.RAEM.R                   /* Receive FIFO Almost Empty Threshold */
#define ENET_RAFL            ENET.RAFL.R                   /* Receive FIFO Almost Full Threshold */
#define ENET_TSEM            ENET.TSEM.R                   /* Transmit FIFO Section Empty Threshold */
#define ENET_TAEM            ENET.TAEM.R                   /* Transmit FIFO Almost Empty Threshold */
#define ENET_TAFL            ENET.TAFL.R                   /* Transmit FIFO Almost Full Threshold */
#define ENET_TIPG            ENET.TIPG.R                   /* Transmit Inter-Packet Gap */
#define ENET_FTRL            ENET.FTRL.R                   /* Frame Truncation Length */
#define ENET_TACC            ENET.TACC.R                   /* Transmit Accelerator Function Configuration */
#define ENET_RACC            ENET.RACC.R                   /* Receive Accelerator Function Configuration */
#define ENET_RCMR1           ENET.RCMR[0].R                /* Receive Classification Match Register for Class n */
#define ENET_RCMR2           ENET.RCMR[1].R                /* Receive Classification Match Register for Class n */
#define ENET_DMA1CFG         ENET.DMACFG[0].R              /* DMA Class Based Configuration */
#define ENET_DMA2CFG         ENET.DMACFG[1].R              /* DMA Class Based Configuration */
#define ENET_RDAR1           ENET.RDAR1.R                  /* Receive Descriptor Active Register - Ring 1 */
#define ENET_TDAR1           ENET.TDAR1.R                  /* Transmit Descriptor Active Register - Ring 1 */
#define ENET_RDAR2           ENET.RDAR2.R                  /* Receive Descriptor Active Register - Ring 2 */
#define ENET_TDAR2           ENET.TDAR2.R                  /* Transmit Descriptor Active Register - Ring 2 */
#define ENET_QOS             ENET.QOS.R                    /* QOS Scheme */
#define ENET_RMON_T_PACKETS  ENET.RMON_T_PACKETS.R         /* Tx Packet Count Statistic Register */
#define ENET_RMON_T_BC_PKT   ENET.RMON_T_BC_PKT.R          /* Tx Broadcast Packets Statistic Register */
#define ENET_RMON_T_MC_PKT   ENET.RMON_T_MC_PKT.R          /* Tx Multicast Packets Statistic Register */
#define ENET_RMON_T_CRC_ALIGN ENET.RMON_T_CRC_ALIGN.R      /* Tx Packets with CRC/Align Error Statistic Register */
#define ENET_RMON_T_UNDERSIZE ENET.RMON_T_UNDERSIZE.R      /* Tx Packets Less Than Bytes and Good CRC Statistic Register */
#define ENET_RMON_T_OVERSIZE ENET.RMON_T_OVERSIZE.R        /* Tx Packets GT MAX_FL bytes and Good CRC Statistic Register */
#define ENET_RMON_T_FRAG     ENET.RMON_T_FRAG.R            /* Tx Packets Less Than 64 Bytes and Bad CRC Statistic Register */
#define ENET_RMON_T_JAB      ENET.RMON_T_JAB.R             /* Tx Packets Greater Than MAX_FL bytes and Bad CRC Statistic Register */
#define ENET_RMON_T_COL      ENET.RMON_T_COL.R             /* Tx Collision Count Statistic Register */
#define ENET_RMON_T_P64      ENET.RMON_T_P64.R             /* Tx 64-Byte Packets Statistic Register */
#define ENET_RMON_T_P65TO127 ENET.RMON_T_P65TO127.R        /* Tx 65- to 127-byte Packets Statistic Register */
#define ENET_RMON_T_P128TO255 ENET.RMON_T_P128TO255.R      /* Tx 128- to 255-byte Packets Statistic Register */
#define ENET_RMON_T_P256TO511 ENET.RMON_T_P256TO511.R      /* Tx 256- to 511-byte Packets Statistic Register */
#define ENET_RMON_T_P512TO1023 ENET.RMON_T_P512TO1023.R    /* Tx 512- to 1023-byte Packets Statistic Register */
#define ENET_RMON_T_P1024TO2047 ENET.RMON_T_P1024TO2047.R  /* Tx 1024- to 2047-byte Packets Statistic Register */
#define ENET_RMON_T_P_GTE2048 ENET.RMON_T_P_GTE2048.R      /* Tx Packets Greater Than 2048 Bytes Statistic Register */
#define ENET_RMON_T_OCTETS   ENET.RMON_T_OCTETS.R          /* Tx Octets Statistic Register */
#define ENET_IEEE_T_FRAME_OK ENET.IEEE_T_FRAME_OK.R        /* Frames Transmitted OK Statistic Register */
#define ENET_IEEE_T_1COL     ENET.IEEE_T_1COL.R            /* Frames Transmitted with Single Collision Statistic Register */
#define ENET_IEEE_T_MCOL     ENET.IEEE_T_MCOL.R            /* Frames Transmitted with Multiple Collisions Statistic Register */
#define ENET_IEEE_T_DEF      ENET.IEEE_T_DEF.R             /* Frames Transmitted after Deferral Delay Statistic Register */
#define ENET_IEEE_T_LCOL     ENET.IEEE_T_LCOL.R            /* Frames Transmitted with Late Collision Statistic Register */
#define ENET_IEEE_T_EXCOL    ENET.IEEE_T_EXCOL.R           /* Frames Transmitted with Excessive Collisions Statistic Register */
#define ENET_IEEE_T_MACERR   ENET.IEEE_T_MACERR.R          /* Frames Transmitted with Tx FIFO Underrun Statistic Register */
#define ENET_IEEE_T_CSERR    ENET.IEEE_T_CSERR.R           /* Frames Transmitted with Carrier Sense Error Statistic Register */
#define ENET_IEEE_T_FDXFC    ENET.IEEE_T_FDXFC.R           /* Flow Control Pause Frames Transmitted Statistic Register */
#define ENET_IEEE_T_OCTETS_OK ENET.IEEE_T_OCTETS_OK.R      /* Octet Count for Frames Transmitted w/o Error Statistic Register */
#define ENET_RMON_R_PACKETS  ENET.RMON_R_PACKETS.R         /* Rx Packet Count Statistic Register */
#define ENET_RMON_R_BC_PKT   ENET.RMON_R_BC_PKT.R          /* Rx Broadcast Packets Statistic Register */
#define ENET_RMON_R_MC_PKT   ENET.RMON_R_MC_PKT.R          /* Rx Multicast Packets Statistic Register */
#define ENET_RMON_R_CRC_ALIGN ENET.RMON_R_CRC_ALIGN.R      /* Rx Packets with CRC/Align Error Statistic Register */
#define ENET_RMON_R_UNDERSIZE ENET.RMON_R_UNDERSIZE.R      /* Rx Packets with Less Than 64 Bytes and Good CRC Statistic Register */
#define ENET_RMON_R_OVERSIZE ENET.RMON_R_OVERSIZE.R        /* Rx Packets Greater Than MAX_FL and Good CRC Statistic Register */
#define ENET_RMON_R_FRAG     ENET.RMON_R_FRAG.R            /* Rx Packets Less Than 64 Bytes and Bad CRC Statistic Register */
#define ENET_RMON_R_JAB      ENET.RMON_R_JAB.R             /* Rx Packets Greater Than MAX_FL Bytes and Bad CRC Statistic Register */
#define ENET_RMON_R_P64      ENET.RMON_R_P64.R             /* Rx 64-Byte Packets Statistic Register */
#define ENET_RMON_R_P65TO127 ENET.RMON_R_P65TO127.R        /* Rx 65- to 127-Byte Packets Statistic Register */
#define ENET_RMON_R_P128TO255 ENET.RMON_R_P128TO255.R      /* Rx 128- to 255-Byte Packets Statistic Register */
#define ENET_RMON_R_P256TO511 ENET.RMON_R_P256TO511.R      /* Rx 256- to 511-Byte Packets Statistic Register */
#define ENET_RMON_R_P512TO1023 ENET.RMON_R_P512TO1023.R    /* Rx 512- to 1023-Byte Packets Statistic Register */
#define ENET_RMON_R_P1024TO2047 ENET.RMON_R_P1024TO2047.R  /* Rx 1024- to 2047-Byte Packets Statistic Register */
#define ENET_RMON_R_P_GTE2048 ENET.RMON_R_P_GTE2048.R      /* Rx Packets Greater than 2048 Bytes Statistic Register */
#define ENET_RMON_R_OCTETS   ENET.RMON_R_OCTETS.R          /* Rx Octets Statistic Register */
#define ENET_IEEE_R_DROP     ENET.IEEE_R_DROP.R            /* Frames not Counted Correctly Statistic Register */
#define ENET_IEEE_R_FRAME_OK ENET.IEEE_R_FRAME_OK.R        /* Frames Received OK Statistic Register */
#define ENET_IEEE_R_CRC      ENET.IEEE_R_CRC.R             /* Frames Received with CRC Error Statistic Register */
#define ENET_IEEE_R_ALIGN    ENET.IEEE_R_ALIGN.R           /* Frames Received with Alignment Error Statistic Register */
#define ENET_IEEE_R_MACERR   ENET.IEEE_R_MACERR.R          /* Receive FIFO Overflow Count Statistic Register */
#define ENET_IEEE_R_FDXFC    ENET.IEEE_R_FDXFC.R           /* Flow Control Pause Frames Received Statistic Register */
#define ENET_IEEE_R_OCTETS_OK ENET.IEEE_R_OCTETS_OK.R      /* Octet Count for Frames Received without Error Statistic Register */
#define ENET_ATCR            ENET.ATCR.R                   /* Adjustable Timer Control Register */
#define ENET_ATVR            ENET.ATVR.R                   /* Timer Value Register */
#define ENET_ATOFF           ENET.ATOFF.R                  /* Timer Offset Register */
#define ENET_ATPER           ENET.ATPER.R                  /* Timer Period Register */
#define ENET_ATCOR           ENET.ATCOR.R                  /* Timer Correction Register */
#define ENET_ATINC           ENET.ATINC.R                  /* Time-Stamping Clock Period Register */
#define ENET_ATSTMP          ENET.ATSTMP.R                 /* Timestamp of Last Transmitted Frame */
#define ENET_MDATA           ENET.MDATA.R                  /* Pattern Match Data Register */
#define ENET_MMASK           ENET.MMASK.R                  /* Match Entry Mask Register */
#define ENET_MCONFIG         ENET.MCONFIG.R                /* Match Entry Rules Configuration Register */
#define ENET_MENTRYRW        ENET.MENTRYRW.R               /* Match Entry Read/Write Command Register */
#define ENET_RXPCTL          ENET.RXPCTL.R                 /* Receive Parser Control Register */
#define ENET_MAXFRMOFF       ENET.MAXFRMOFF.R              /* Maximum Frame Offset */
#define ENET_RXPARST         ENET.RXPARST.R                /* Receive Parser Status */
#define ENET_PARSDSCD        ENET.PARSDSCD.R               /* Parser Discard Count */
#define ENET_PRSACPT0        ENET.PRSACPT0.R               /* Parser Accept Count 0 */
#define ENET_PRSRJCT0        ENET.PRSRJCT0.R               /* Parser Reject Count 0 */
#define ENET_PRSACPT1        ENET.PRSACPT1.R               /* Parser Accept Count 1 */
#define ENET_PRSRJCT1        ENET.PRSRJCT1.R               /* Parser Reject Count 1 */
#define ENET_PRSACPT2        ENET.PRSACPT2.R               /* Parser Accept Count 2 */
#define ENET_PRSRJCT2        ENET.PRSRJCT2.R               /* Parser Reject Count 2 */
#define ENET_TGSR            ENET.TGSR.R                   /* Timer Global Status Register */
#define ENET_TCSR0           ENET.TIMER[0].TCSR.R          /* Timer Control Status Register */
#define ENET_TCCR0           ENET.TIMER[0].TCCR.R          /* Timer Compare Capture Register */
#define ENET_TCSR1           ENET.TIMER[1].TCSR.R          /* Timer Control Status Register */
#define ENET_TCCR1           ENET.TIMER[1].TCCR.R          /* Timer Compare Capture Register */
#define ENET_TCSR2           ENET.TIMER[2].TCSR.R          /* Timer Control Status Register */
#define ENET_TCCR2           ENET.TIMER[2].TCCR.R          /* Timer Compare Capture Register */
#define ENET_TCSR3           ENET.TIMER[3].TCSR.R          /* Timer Control Status Register */
#define ENET_TCCR3           ENET.TIMER[3].TCCR.R          /* Timer Compare Capture Register */

/* FCCU */
#define FCCU_CTRL            FCCU.CTRL.R                   /* Control Register */
#define FCCU_CTRLK           FCCU.CTRLK.R                  /* CTRL Key Register */
#define FCCU_CFG             FCCU.CFG.R                    /* Configuration Register */
#define FCCU_NCF_CFG0        FCCU.NCF_CFG[0].R             /* NCF Configuration Register */
#define FCCU_NCF_CFG1        FCCU.NCF_CFG[1].R             /* NCF Configuration Register */
#define FCCU_NCF_CFG2        FCCU.NCF_CFG[2].R             /* NCF Configuration Register */
#define FCCU_NCFS_CFG0       FCCU.NCFS_CFG[0].R            /* NCFS Configuration Register */
#define FCCU_NCFS_CFG1       FCCU.NCFS_CFG[1].R            /* NCFS Configuration Register */
#define FCCU_NCFS_CFG2       FCCU.NCFS_CFG[2].R            /* NCFS Configuration Register */
#define FCCU_NCFS_CFG3       FCCU.NCFS_CFG[3].R            /* NCFS Configuration Register */
#define FCCU_NCFS_CFG4       FCCU.NCFS_CFG[4].R            /* NCFS Configuration Register */
#define FCCU_NCF_S0          FCCU.NCF_S[0].R               /* NCF Status Register */
#define FCCU_NCF_S1          FCCU.NCF_S[1].R               /* NCF Status Register */
#define FCCU_NCF_S2          FCCU.NCF_S[2].R               /* NCF Status Register */
#define FCCU_NCFK            FCCU.NCFK.R                   /* NCF Key Register */
#define FCCU_NCF_E0          FCCU.NCF_E[0].R               /* NCF Enable Register */
#define FCCU_NCF_E1          FCCU.NCF_E[1].R               /* NCF Enable Register */
#define FCCU_NCF_E2          FCCU.NCF_E[2].R               /* NCF Enable Register */
#define FCCU_NCF_TOE0        FCCU.NCF_TOE[0].R             /* NCF Time-out Enable Register */
#define FCCU_NCF_TOE1        FCCU.NCF_TOE[1].R             /* NCF Time-out Enable Register */
#define FCCU_NCF_TOE2        FCCU.NCF_TOE[2].R             /* NCF Time-out Enable Register */
#define FCCU_NCF_TO          FCCU.NCF_TO.R                 /* NCF Time-out Register */
#define FCCU_CFG_TO          FCCU.CFG_TO.R                 /* CFG Timeout Register */
#define FCCU_EINOUT          FCCU.EINOUT.R                 /* IO Control Register */
#define FCCU_STAT            FCCU.STAT.R                   /* Status Register */
#define FCCU_N2AF_STATUS     FCCU.N2AF_STATUS.R            /* NA Freeze Status Register */
#define FCCU_A2FF_STATUS     FCCU.A2FF_STATUS.R            /* AF Freeze Status Register */
#define FCCU_N2FF_STATUS     FCCU.N2FF_STATUS.R            /* NF Freeze Status Register */
#define FCCU_F2A_STATUS      FCCU.F2A_STATUS.R             /* FA Freeze Status Register */
#define FCCU_NCFF            FCCU.NCFF.R                   /* NCF Fake Register */
#define FCCU_IRQ_STAT        FCCU.IRQ_STAT.R               /* IRQ Status Register */
#define FCCU_IRQ_EN          FCCU.IRQ_EN.R                 /* IRQ Enable Register */
#define FCCU_XTMR            FCCU.XTMR.R                   /* XTMR Register */
#define FCCU_MCS             FCCU.MCS.R                    /* MCS Register */
#define FCCU_TRANS_LOCK      FCCU.TRANS_LOCK.R             /* Transient Lock Register */
#define FCCU_PERMNT_LOCK     FCCU.PERMNT_LOCK.R            /* Permanent Lock Register */
#define FCCU_DELTA_T         FCCU.DELTA_T.R                /* Delta T Register */
#define FCCU_IRQ_ALARM_EN0   FCCU.IRQ_ALARM_EN[0].R        /* IRQ Alarm Enable Register */
#define FCCU_IRQ_ALARM_EN1   FCCU.IRQ_ALARM_EN[1].R        /* IRQ Alarm Enable Register */
#define FCCU_IRQ_ALARM_EN2   FCCU.IRQ_ALARM_EN[2].R        /* IRQ Alarm Enable Register */
#define FCCU_NMI_EN0         FCCU.NMI_EN[0].R              /* NMI Enable Register */
#define FCCU_NMI_EN1         FCCU.NMI_EN[1].R              /* NMI Enable Register */
#define FCCU_NMI_EN2         FCCU.NMI_EN[2].R              /* NMI Enable Register */
#define FCCU_EOUT_SIG_EN0    FCCU.EOUT_SIG_EN[0].R         /* EOUT Signaling Enable Register */
#define FCCU_EOUT_SIG_EN1    FCCU.EOUT_SIG_EN[1].R         /* EOUT Signaling Enable Register */
#define FCCU_EOUT_SIG_EN2    FCCU.EOUT_SIG_EN[2].R         /* EOUT Signaling Enable Register */

/* FIRC */
#define FIRC_CTL             FIRC.CTL.R                    /* Control register */

/* FR */
#define FR_MVR               FR.MVR.R                      /* Module Version Register */
#define FR_MCR               FR.MCR.R                      /* Module Configuration Register */
#define FR_SYMBADHR          FR.SYMBADHR.R                 /* System Memory Base Address High Register */
#define FR_SYMBADLR          FR.SYMBADLR.R                 /* System Memory Base Address Low Register */
#define FR_STBSCR            FR.STBSCR.R                   /* Strobe Signal Control Register */
#define FR_MBDSR             FR.MBDSR.R                    /* Message Buffer Data Size Register */
#define FR_MBSSUTR           FR.MBSSUTR.R                  /* Message Buffer Segment Size and Utilization Register */
#define FR_PEDRAR            FR.PEDRAR.R                   /* PE DRAM Access Register */
#define FR_PEDRDR            FR.PEDRDR.R                   /* PE DRAM Data Register */
#define FR_POCR              FR.POCR.R                     /* Protocol Operation Control Register */
#define FR_GIFER             FR.GIFER.R                    /* Global Interrupt Flag and Enable Register */
#define FR_PIFR0             FR.PIFR0.R                    /* Protocol Interrupt Flag Register 0 */
#define FR_PIFR1             FR.PIFR1.R                    /* Protocol Interrupt Flag Register 1 */
#define FR_PIER0             FR.PIER0.R                    /* Protocol Interrupt Enable Register 0 */
#define FR_PIER1             FR.PIER1.R                    /* Protocol Interrupt Enable Register 1 */
#define FR_CHIERFR           FR.CHIERFR.R                  /* CHI Error Flag Register */
#define FR_MBIVEC            FR.MBIVEC.R                   /* Message Buffer Interrupt Vector Register */
#define FR_CASERCR           FR.CASERCR.R                  /* Channel A Status Error Counter Register */
#define FR_CBSERCR           FR.CBSERCR.R                  /* Channel B Status Error Counter Register */
#define FR_PSR0              FR.PSR0.R                     /* Protocol Status Register 0 */
#define FR_PSR1              FR.PSR1.R                     /* Protocol Status Register 1 */
#define FR_PSR2              FR.PSR2.R                     /* Protocol Status Register 2 */
#define FR_PSR3              FR.PSR3.R                     /* Protocol Status Register 3 */
#define FR_MTCTR             FR.MTCTR.R                    /* Macrotick Counter Register */
#define FR_CYCTR             FR.CYCTR.R                    /* Cycle Counter Register */
#define FR_SLTCTAR           FR.SLTCTAR.R                  /* Slot Counter Channel A Register */
#define FR_SLTCTBR           FR.SLTCTBR.R                  /* Slot Counter Channel B Register */
#define FR_RTCORVR           FR.RTCORVR.R                  /* Rate Correction Value Register */
#define FR_OFCORVR           FR.OFCORVR.R                  /* Offset Correction Value Register */
#define FR_CIFR              FR.CIFR.R                     /* Combined Interrupt Flag Register */
#define FR_SYMATOR           FR.SYMATOR.R                  /* System Memory Access Time-Out Register */
#define FR_SFCNTR            FR.SFCNTR.R                   /* Sync Frame Counter Register */
#define FR_SFTOR             FR.SFTOR.R                    /* Sync Frame Table Offset Register */
#define FR_SFTCCSR           FR.SFTCCSR.R                  /* Sync Frame Table Configuration, Control, Status Register */
#define FR_SFIDRFR           FR.SFIDRFR.R                  /* Sync Frame ID Rejection Filter Register */
#define FR_SFIDAFVR          FR.SFIDAFVR.R                 /* Sync Frame ID Acceptance Filter Value Register */
#define FR_SFIDAFMR          FR.SFIDAFMR.R                 /* Sync Frame ID Acceptance Filter Mask Register */
#define FR_NMVR0             FR.NMVR[0].R                  /* Network Management Vector Register */
#define FR_NMVR1             FR.NMVR[1].R                  /* Network Management Vector Register */
#define FR_NMVR2             FR.NMVR[2].R                  /* Network Management Vector Register */
#define FR_NMVR3             FR.NMVR[3].R                  /* Network Management Vector Register */
#define FR_NMVR4             FR.NMVR[4].R                  /* Network Management Vector Register */
#define FR_NMVR5             FR.NMVR[5].R                  /* Network Management Vector Register */
#define FR_NMVLR             FR.NMVLR.R                    /* Network Management Vector Length Register */
#define FR_TICCR             FR.TICCR.R                    /* Timer Configuration and Control Register */
#define FR_TI1CYSR           FR.TI1CYSR.R                  /* Timer 1 Cycle Set Register */
#define FR_TI1MTOR           FR.TI1MTOR.R                  /* Timer 1 Macrotick Offset Register */
#define FR_TI2CR0_ABS        FR.TI2CR0.ABS.R               /* Timer 2 Configuration Register 0 (Absolute Timer Configuration) */
#define FR_TI2CR0_REL        FR.TI2CR0.REL.R               /* Timer 2 Configuration Register 0 (Relative Timer Configuration) */
#define FR_TI2CR1_ABS        FR.TI2CR1.ABS.R               /* Timer 2 Configuration Register 1 (Absolute Timer Configuration) */
#define FR_TI2CR1_REL        FR.TI2CR1.REL.R               /* Timer 2 Configuration Register 1 (Relative Timer Configuration) */
#define FR_SSSR              FR.SSSR.R                     /* Slot Status Selection Register */
#define FR_SSCCR             FR.SSCCR.R                    /* Slot Status Counter Condition Register */
#define FR_SSR0              FR.SSR[0].R                   /* Slot Status Register */
#define FR_SSR1              FR.SSR[1].R                   /* Slot Status Register */
#define FR_SSR2              FR.SSR[2].R                   /* Slot Status Register */
#define FR_SSR3              FR.SSR[3].R                   /* Slot Status Register */
#define FR_SSR4              FR.SSR[4].R                   /* Slot Status Register */
#define FR_SSR5              FR.SSR[5].R                   /* Slot Status Register */
#define FR_SSR6              FR.SSR[6].R                   /* Slot Status Register */
#define FR_SSR7              FR.SSR[7].R                   /* Slot Status Register */
#define FR_SSCR0             FR.SSCR[0].R                  /* Slot Status Counter Register */
#define FR_SSCR1             FR.SSCR[1].R                  /* Slot Status Counter Register */
#define FR_SSCR2             FR.SSCR[2].R                  /* Slot Status Counter Register */
#define FR_SSCR3             FR.SSCR[3].R                  /* Slot Status Counter Register */
#define FR_MTSACFR           FR.MTSACFR.R                  /* MTS A Configuration Register */
#define FR_MTSBCFR           FR.MTSBCFR.R                  /* MTS B Configuration Register */
#define FR_RSBIR             FR.RSBIR.R                    /* Receive Shadow Buffer Index Register */
#define FR_RFWMSR            FR.RFWMSR.R                   /* Receive FIFO Watermark and Selection Register */
#define FR_RFSIR             FR.RFSIR.R                    /* Receive FIFO Start Index Register */
#define FR_RFDSR             FR.RFDSR.R                    /* Receive FIFO Depth and Size Register */
#define FR_RFARIR            FR.RFARIR.R                   /* Receive FIFO A Read Index Register */
#define FR_RFBRIR            FR.RFBRIR.R                   /* Receive FIFO B Read Index Register */
#define FR_RFMIDAFVR         FR.RFMIDAFVR.R                /* Receive FIFO Message ID Acceptance Filter Value Register */
#define FR_RFMIDAFMR         FR.RFMIDAFMR.R                /* Receive FIFO Message ID Acceptance Filter Mask Register */
#define FR_RFFIDRFVR         FR.RFFIDRFVR.R                /* Receive FIFO Frame ID Rejection Filter Value Register */
#define FR_RFFIDRFMR         FR.RFFIDRFMR.R                /* Receive FIFO Frame ID Rejection Filter Mask Register */
#define FR_RFRFCFR           FR.RFRFCFR.R                  /* Receive FIFO Range Filter Configuration Register */
#define FR_RFRFCTR           FR.RFRFCTR.R                  /* Receive FIFO Range Filter Control Register */
#define FR_LDTXSLAR          FR.LDTXSLAR.R                 /* Last Dynamic Transmit Slot Channel A Register */
#define FR_LDTXSLBR          FR.LDTXSLBR.R                 /* Last Dynamic Transmit Slot Channel B Register */
#define FR_PCR0              FR.PCR0.R                     /* Protocol Configuration Register 0 */
#define FR_PCR1              FR.PCR1.R                     /* Protocol Configuration Register 1 */
#define FR_PCR2              FR.PCR2.R                     /* Protocol Configuration Register 2 */
#define FR_PCR3              FR.PCR3.R                     /* Protocol Configuration Register 3 */
#define FR_PCR4              FR.PCR4.R                     /* Protocol Configuration Register 4 */
#define FR_PCR5              FR.PCR5.R                     /* Protocol Configuration Register 5 */
#define FR_PCR6              FR.PCR6.R                     /* Protocol Configuration Register 6 */
#define FR_PCR7              FR.PCR7.R                     /* Protocol Configuration Register 7 */
#define FR_PCR8              FR.PCR8.R                     /* Protocol Configuration Register 8 */
#define FR_PCR9              FR.PCR9.R                     /* Protocol Configuration Register 9 */
#define FR_PCR10             FR.PCR10.R                    /* Protocol Configuration Register 10 */
#define FR_PCR11             FR.PCR11.R                    /* Protocol Configuration Register 11 */
#define FR_PCR12             FR.PCR12.R                    /* Protocol Configuration Register 12 */
#define FR_PCR13             FR.PCR13.R                    /* Protocol Configuration Register 13 */
#define FR_PCR14             FR.PCR14.R                    /* Protocol Configuration Register 14 */
#define FR_PCR15             FR.PCR15.R                    /* Protocol Configuration Register 15 */
#define FR_PCR16             FR.PCR16.R                    /* Protocol Configuration Register 16 */
#define FR_PCR17             FR.PCR17.R                    /* Protocol Configuration Register 17 */
#define FR_PCR18             FR.PCR18.R                    /* Protocol Configuration Register 18 */
#define FR_PCR19             FR.PCR19.R                    /* Protocol Configuration Register 19 */
#define FR_PCR20             FR.PCR20.R                    /* Protocol Configuration Register 20 */
#define FR_PCR21             FR.PCR21.R                    /* Protocol Configuration Register 21 */
#define FR_PCR22             FR.PCR22.R                    /* Protocol Configuration Register 22 */
#define FR_PCR23             FR.PCR23.R                    /* Protocol Configuration Register 23 */
#define FR_PCR24             FR.PCR24.R                    /* Protocol Configuration Register 24 */
#define FR_PCR25             FR.PCR25.R                    /* Protocol Configuration Register 25 */
#define FR_PCR26             FR.PCR26.R                    /* Protocol Configuration Register 26 */
#define FR_PCR27             FR.PCR27.R                    /* Protocol Configuration Register 27 */
#define FR_PCR28             FR.PCR28.R                    /* Protocol Configuration Register 28 */
#define FR_PCR29             FR.PCR29.R                    /* Protocol Configuration Register 29 */
#define FR_PCR30             FR.PCR30.R                    /* Protocol Configuration Register 30 */
#define FR_STPWR             FR.STPWR.R                    /* StopWatch Count Register */
#define FR_PEOER             FR.PEOER.R                    /* Protocol Event Output Enable and StopWatch Control Register */
#define FR_RFSDOR            FR.RFSDOR.R                   /* Receive FIFO Start Data Offset Register */
#define FR_RFSYMBADHR        FR.RFSYMBADHR.R               /* Receive FIFO System Memory Base Address High Register */
#define FR_RFSYMBADLR        FR.RFSYMBADLR.R               /* Receive FIFO System Memory Base Address Low Register */
#define FR_RFPTR             FR.RFPTR.R                    /* Receive FIFO Periodic Timer Register */
#define FR_RFFLPCR           FR.RFFLPCR.R                  /* Receive FIFO Fill Level and POP Count Register */
#define FR_EEIFER            FR.EEIFER.R                   /* ECC Error Interrupt Flag and Enable Register */
#define FR_EERICR            FR.EERICR.R                   /* ECC Error Report and Injection Control Register */
#define FR_EERAR             FR.EERAR.R                    /* ECC Error Report Address Register */
#define FR_EERDR             FR.EERDR.R                    /* ECC Error Report Data Register */
#define FR_EERCR             FR.EERCR.R                    /* ECC Error Report Code Register */
#define FR_EEIAR             FR.EEIAR.R                    /* ECC Error Injection Address Register */
#define FR_EEIDR             FR.EEIDR.R                    /* ECC Error Injection Data Register */
#define FR_EEICR             FR.EEICR.R                    /* ECC Error Injection Code Register */
#define FR_MBCCSR0           FR.MB[0].CCSR.R               /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR0           FR.MB[0].CCFR.R               /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR0           FR.MB[0].FIDR.R               /* Message Buffer Frame ID Register */
#define FR_MBIDXR0           FR.MB[0].IDXR.R               /* Message Buffer Index Register */
#define FR_MBCCSR1           FR.MB[1].CCSR.R               /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR1           FR.MB[1].CCFR.R               /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR1           FR.MB[1].FIDR.R               /* Message Buffer Frame ID Register */
#define FR_MBIDXR1           FR.MB[1].IDXR.R               /* Message Buffer Index Register */
#define FR_MBCCSR2           FR.MB[2].CCSR.R               /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR2           FR.MB[2].CCFR.R               /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR2           FR.MB[2].FIDR.R               /* Message Buffer Frame ID Register */
#define FR_MBIDXR2           FR.MB[2].IDXR.R               /* Message Buffer Index Register */
#define FR_MBCCSR3           FR.MB[3].CCSR.R               /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR3           FR.MB[3].CCFR.R               /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR3           FR.MB[3].FIDR.R               /* Message Buffer Frame ID Register */
#define FR_MBIDXR3           FR.MB[3].IDXR.R               /* Message Buffer Index Register */
#define FR_MBCCSR4           FR.MB[4].CCSR.R               /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR4           FR.MB[4].CCFR.R               /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR4           FR.MB[4].FIDR.R               /* Message Buffer Frame ID Register */
#define FR_MBIDXR4           FR.MB[4].IDXR.R               /* Message Buffer Index Register */
#define FR_MBCCSR5           FR.MB[5].CCSR.R               /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR5           FR.MB[5].CCFR.R               /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR5           FR.MB[5].FIDR.R               /* Message Buffer Frame ID Register */
#define FR_MBIDXR5           FR.MB[5].IDXR.R               /* Message Buffer Index Register */
#define FR_MBCCSR6           FR.MB[6].CCSR.R               /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR6           FR.MB[6].CCFR.R               /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR6           FR.MB[6].FIDR.R               /* Message Buffer Frame ID Register */
#define FR_MBIDXR6           FR.MB[6].IDXR.R               /* Message Buffer Index Register */
#define FR_MBCCSR7           FR.MB[7].CCSR.R               /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR7           FR.MB[7].CCFR.R               /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR7           FR.MB[7].FIDR.R               /* Message Buffer Frame ID Register */
#define FR_MBIDXR7           FR.MB[7].IDXR.R               /* Message Buffer Index Register */
#define FR_MBCCSR8           FR.MB[8].CCSR.R               /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR8           FR.MB[8].CCFR.R               /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR8           FR.MB[8].FIDR.R               /* Message Buffer Frame ID Register */
#define FR_MBIDXR8           FR.MB[8].IDXR.R               /* Message Buffer Index Register */
#define FR_MBCCSR9           FR.MB[9].CCSR.R               /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR9           FR.MB[9].CCFR.R               /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR9           FR.MB[9].FIDR.R               /* Message Buffer Frame ID Register */
#define FR_MBIDXR9           FR.MB[9].IDXR.R               /* Message Buffer Index Register */
#define FR_MBCCSR10          FR.MB[10].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR10          FR.MB[10].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR10          FR.MB[10].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR10          FR.MB[10].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR11          FR.MB[11].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR11          FR.MB[11].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR11          FR.MB[11].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR11          FR.MB[11].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR12          FR.MB[12].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR12          FR.MB[12].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR12          FR.MB[12].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR12          FR.MB[12].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR13          FR.MB[13].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR13          FR.MB[13].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR13          FR.MB[13].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR13          FR.MB[13].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR14          FR.MB[14].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR14          FR.MB[14].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR14          FR.MB[14].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR14          FR.MB[14].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR15          FR.MB[15].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR15          FR.MB[15].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR15          FR.MB[15].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR15          FR.MB[15].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR16          FR.MB[16].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR16          FR.MB[16].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR16          FR.MB[16].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR16          FR.MB[16].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR17          FR.MB[17].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR17          FR.MB[17].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR17          FR.MB[17].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR17          FR.MB[17].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR18          FR.MB[18].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR18          FR.MB[18].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR18          FR.MB[18].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR18          FR.MB[18].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR19          FR.MB[19].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR19          FR.MB[19].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR19          FR.MB[19].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR19          FR.MB[19].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR20          FR.MB[20].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR20          FR.MB[20].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR20          FR.MB[20].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR20          FR.MB[20].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR21          FR.MB[21].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR21          FR.MB[21].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR21          FR.MB[21].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR21          FR.MB[21].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR22          FR.MB[22].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR22          FR.MB[22].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR22          FR.MB[22].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR22          FR.MB[22].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR23          FR.MB[23].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR23          FR.MB[23].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR23          FR.MB[23].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR23          FR.MB[23].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR24          FR.MB[24].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR24          FR.MB[24].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR24          FR.MB[24].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR24          FR.MB[24].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR25          FR.MB[25].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR25          FR.MB[25].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR25          FR.MB[25].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR25          FR.MB[25].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR26          FR.MB[26].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR26          FR.MB[26].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR26          FR.MB[26].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR26          FR.MB[26].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR27          FR.MB[27].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR27          FR.MB[27].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR27          FR.MB[27].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR27          FR.MB[27].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR28          FR.MB[28].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR28          FR.MB[28].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR28          FR.MB[28].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR28          FR.MB[28].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR29          FR.MB[29].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR29          FR.MB[29].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR29          FR.MB[29].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR29          FR.MB[29].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR30          FR.MB[30].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR30          FR.MB[30].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR30          FR.MB[30].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR30          FR.MB[30].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR31          FR.MB[31].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR31          FR.MB[31].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR31          FR.MB[31].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR31          FR.MB[31].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR32          FR.MB[32].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR32          FR.MB[32].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR32          FR.MB[32].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR32          FR.MB[32].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR33          FR.MB[33].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR33          FR.MB[33].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR33          FR.MB[33].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR33          FR.MB[33].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR34          FR.MB[34].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR34          FR.MB[34].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR34          FR.MB[34].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR34          FR.MB[34].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR35          FR.MB[35].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR35          FR.MB[35].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR35          FR.MB[35].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR35          FR.MB[35].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR36          FR.MB[36].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR36          FR.MB[36].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR36          FR.MB[36].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR36          FR.MB[36].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR37          FR.MB[37].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR37          FR.MB[37].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR37          FR.MB[37].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR37          FR.MB[37].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR38          FR.MB[38].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR38          FR.MB[38].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR38          FR.MB[38].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR38          FR.MB[38].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR39          FR.MB[39].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR39          FR.MB[39].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR39          FR.MB[39].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR39          FR.MB[39].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR40          FR.MB[40].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR40          FR.MB[40].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR40          FR.MB[40].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR40          FR.MB[40].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR41          FR.MB[41].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR41          FR.MB[41].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR41          FR.MB[41].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR41          FR.MB[41].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR42          FR.MB[42].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR42          FR.MB[42].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR42          FR.MB[42].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR42          FR.MB[42].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR43          FR.MB[43].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR43          FR.MB[43].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR43          FR.MB[43].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR43          FR.MB[43].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR44          FR.MB[44].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR44          FR.MB[44].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR44          FR.MB[44].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR44          FR.MB[44].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR45          FR.MB[45].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR45          FR.MB[45].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR45          FR.MB[45].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR45          FR.MB[45].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR46          FR.MB[46].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR46          FR.MB[46].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR46          FR.MB[46].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR46          FR.MB[46].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR47          FR.MB[47].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR47          FR.MB[47].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR47          FR.MB[47].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR47          FR.MB[47].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR48          FR.MB[48].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR48          FR.MB[48].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR48          FR.MB[48].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR48          FR.MB[48].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR49          FR.MB[49].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR49          FR.MB[49].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR49          FR.MB[49].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR49          FR.MB[49].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR50          FR.MB[50].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR50          FR.MB[50].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR50          FR.MB[50].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR50          FR.MB[50].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR51          FR.MB[51].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR51          FR.MB[51].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR51          FR.MB[51].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR51          FR.MB[51].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR52          FR.MB[52].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR52          FR.MB[52].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR52          FR.MB[52].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR52          FR.MB[52].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR53          FR.MB[53].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR53          FR.MB[53].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR53          FR.MB[53].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR53          FR.MB[53].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR54          FR.MB[54].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR54          FR.MB[54].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR54          FR.MB[54].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR54          FR.MB[54].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR55          FR.MB[55].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR55          FR.MB[55].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR55          FR.MB[55].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR55          FR.MB[55].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR56          FR.MB[56].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR56          FR.MB[56].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR56          FR.MB[56].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR56          FR.MB[56].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR57          FR.MB[57].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR57          FR.MB[57].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR57          FR.MB[57].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR57          FR.MB[57].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR58          FR.MB[58].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR58          FR.MB[58].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR58          FR.MB[58].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR58          FR.MB[58].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR59          FR.MB[59].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR59          FR.MB[59].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR59          FR.MB[59].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR59          FR.MB[59].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR60          FR.MB[60].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR60          FR.MB[60].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR60          FR.MB[60].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR60          FR.MB[60].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR61          FR.MB[61].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR61          FR.MB[61].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR61          FR.MB[61].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR61          FR.MB[61].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR62          FR.MB[62].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR62          FR.MB[62].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR62          FR.MB[62].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR62          FR.MB[62].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR63          FR.MB[63].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR63          FR.MB[63].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR63          FR.MB[63].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR63          FR.MB[63].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR64          FR.MB[64].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR64          FR.MB[64].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR64          FR.MB[64].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR64          FR.MB[64].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR65          FR.MB[65].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR65          FR.MB[65].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR65          FR.MB[65].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR65          FR.MB[65].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR66          FR.MB[66].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR66          FR.MB[66].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR66          FR.MB[66].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR66          FR.MB[66].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR67          FR.MB[67].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR67          FR.MB[67].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR67          FR.MB[67].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR67          FR.MB[67].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR68          FR.MB[68].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR68          FR.MB[68].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR68          FR.MB[68].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR68          FR.MB[68].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR69          FR.MB[69].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR69          FR.MB[69].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR69          FR.MB[69].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR69          FR.MB[69].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR70          FR.MB[70].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR70          FR.MB[70].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR70          FR.MB[70].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR70          FR.MB[70].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR71          FR.MB[71].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR71          FR.MB[71].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR71          FR.MB[71].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR71          FR.MB[71].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR72          FR.MB[72].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR72          FR.MB[72].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR72          FR.MB[72].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR72          FR.MB[72].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR73          FR.MB[73].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR73          FR.MB[73].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR73          FR.MB[73].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR73          FR.MB[73].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR74          FR.MB[74].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR74          FR.MB[74].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR74          FR.MB[74].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR74          FR.MB[74].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR75          FR.MB[75].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR75          FR.MB[75].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR75          FR.MB[75].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR75          FR.MB[75].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR76          FR.MB[76].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR76          FR.MB[76].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR76          FR.MB[76].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR76          FR.MB[76].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR77          FR.MB[77].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR77          FR.MB[77].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR77          FR.MB[77].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR77          FR.MB[77].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR78          FR.MB[78].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR78          FR.MB[78].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR78          FR.MB[78].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR78          FR.MB[78].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR79          FR.MB[79].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR79          FR.MB[79].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR79          FR.MB[79].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR79          FR.MB[79].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR80          FR.MB[80].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR80          FR.MB[80].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR80          FR.MB[80].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR80          FR.MB[80].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR81          FR.MB[81].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR81          FR.MB[81].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR81          FR.MB[81].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR81          FR.MB[81].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR82          FR.MB[82].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR82          FR.MB[82].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR82          FR.MB[82].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR82          FR.MB[82].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR83          FR.MB[83].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR83          FR.MB[83].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR83          FR.MB[83].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR83          FR.MB[83].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR84          FR.MB[84].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR84          FR.MB[84].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR84          FR.MB[84].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR84          FR.MB[84].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR85          FR.MB[85].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR85          FR.MB[85].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR85          FR.MB[85].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR85          FR.MB[85].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR86          FR.MB[86].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR86          FR.MB[86].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR86          FR.MB[86].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR86          FR.MB[86].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR87          FR.MB[87].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR87          FR.MB[87].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR87          FR.MB[87].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR87          FR.MB[87].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR88          FR.MB[88].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR88          FR.MB[88].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR88          FR.MB[88].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR88          FR.MB[88].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR89          FR.MB[89].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR89          FR.MB[89].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR89          FR.MB[89].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR89          FR.MB[89].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR90          FR.MB[90].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR90          FR.MB[90].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR90          FR.MB[90].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR90          FR.MB[90].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR91          FR.MB[91].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR91          FR.MB[91].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR91          FR.MB[91].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR91          FR.MB[91].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR92          FR.MB[92].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR92          FR.MB[92].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR92          FR.MB[92].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR92          FR.MB[92].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR93          FR.MB[93].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR93          FR.MB[93].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR93          FR.MB[93].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR93          FR.MB[93].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR94          FR.MB[94].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR94          FR.MB[94].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR94          FR.MB[94].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR94          FR.MB[94].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR95          FR.MB[95].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR95          FR.MB[95].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR95          FR.MB[95].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR95          FR.MB[95].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR96          FR.MB[96].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR96          FR.MB[96].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR96          FR.MB[96].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR96          FR.MB[96].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR97          FR.MB[97].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR97          FR.MB[97].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR97          FR.MB[97].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR97          FR.MB[97].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR98          FR.MB[98].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR98          FR.MB[98].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR98          FR.MB[98].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR98          FR.MB[98].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR99          FR.MB[99].CCSR.R              /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR99          FR.MB[99].CCFR.R              /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR99          FR.MB[99].FIDR.R              /* Message Buffer Frame ID Register */
#define FR_MBIDXR99          FR.MB[99].IDXR.R              /* Message Buffer Index Register */
#define FR_MBCCSR100         FR.MB[100].CCSR.R             /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR100         FR.MB[100].CCFR.R             /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR100         FR.MB[100].FIDR.R             /* Message Buffer Frame ID Register */
#define FR_MBIDXR100         FR.MB[100].IDXR.R             /* Message Buffer Index Register */
#define FR_MBCCSR101         FR.MB[101].CCSR.R             /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR101         FR.MB[101].CCFR.R             /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR101         FR.MB[101].FIDR.R             /* Message Buffer Frame ID Register */
#define FR_MBIDXR101         FR.MB[101].IDXR.R             /* Message Buffer Index Register */
#define FR_MBCCSR102         FR.MB[102].CCSR.R             /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR102         FR.MB[102].CCFR.R             /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR102         FR.MB[102].FIDR.R             /* Message Buffer Frame ID Register */
#define FR_MBIDXR102         FR.MB[102].IDXR.R             /* Message Buffer Index Register */
#define FR_MBCCSR103         FR.MB[103].CCSR.R             /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR103         FR.MB[103].CCFR.R             /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR103         FR.MB[103].FIDR.R             /* Message Buffer Frame ID Register */
#define FR_MBIDXR103         FR.MB[103].IDXR.R             /* Message Buffer Index Register */
#define FR_MBCCSR104         FR.MB[104].CCSR.R             /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR104         FR.MB[104].CCFR.R             /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR104         FR.MB[104].FIDR.R             /* Message Buffer Frame ID Register */
#define FR_MBIDXR104         FR.MB[104].IDXR.R             /* Message Buffer Index Register */
#define FR_MBCCSR105         FR.MB[105].CCSR.R             /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR105         FR.MB[105].CCFR.R             /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR105         FR.MB[105].FIDR.R             /* Message Buffer Frame ID Register */
#define FR_MBIDXR105         FR.MB[105].IDXR.R             /* Message Buffer Index Register */
#define FR_MBCCSR106         FR.MB[106].CCSR.R             /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR106         FR.MB[106].CCFR.R             /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR106         FR.MB[106].FIDR.R             /* Message Buffer Frame ID Register */
#define FR_MBIDXR106         FR.MB[106].IDXR.R             /* Message Buffer Index Register */
#define FR_MBCCSR107         FR.MB[107].CCSR.R             /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR107         FR.MB[107].CCFR.R             /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR107         FR.MB[107].FIDR.R             /* Message Buffer Frame ID Register */
#define FR_MBIDXR107         FR.MB[107].IDXR.R             /* Message Buffer Index Register */
#define FR_MBCCSR108         FR.MB[108].CCSR.R             /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR108         FR.MB[108].CCFR.R             /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR108         FR.MB[108].FIDR.R             /* Message Buffer Frame ID Register */
#define FR_MBIDXR108         FR.MB[108].IDXR.R             /* Message Buffer Index Register */
#define FR_MBCCSR109         FR.MB[109].CCSR.R             /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR109         FR.MB[109].CCFR.R             /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR109         FR.MB[109].FIDR.R             /* Message Buffer Frame ID Register */
#define FR_MBIDXR109         FR.MB[109].IDXR.R             /* Message Buffer Index Register */
#define FR_MBCCSR110         FR.MB[110].CCSR.R             /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR110         FR.MB[110].CCFR.R             /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR110         FR.MB[110].FIDR.R             /* Message Buffer Frame ID Register */
#define FR_MBIDXR110         FR.MB[110].IDXR.R             /* Message Buffer Index Register */
#define FR_MBCCSR111         FR.MB[111].CCSR.R             /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR111         FR.MB[111].CCFR.R             /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR111         FR.MB[111].FIDR.R             /* Message Buffer Frame ID Register */
#define FR_MBIDXR111         FR.MB[111].IDXR.R             /* Message Buffer Index Register */
#define FR_MBCCSR112         FR.MB[112].CCSR.R             /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR112         FR.MB[112].CCFR.R             /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR112         FR.MB[112].FIDR.R             /* Message Buffer Frame ID Register */
#define FR_MBIDXR112         FR.MB[112].IDXR.R             /* Message Buffer Index Register */
#define FR_MBCCSR113         FR.MB[113].CCSR.R             /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR113         FR.MB[113].CCFR.R             /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR113         FR.MB[113].FIDR.R             /* Message Buffer Frame ID Register */
#define FR_MBIDXR113         FR.MB[113].IDXR.R             /* Message Buffer Index Register */
#define FR_MBCCSR114         FR.MB[114].CCSR.R             /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR114         FR.MB[114].CCFR.R             /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR114         FR.MB[114].FIDR.R             /* Message Buffer Frame ID Register */
#define FR_MBIDXR114         FR.MB[114].IDXR.R             /* Message Buffer Index Register */
#define FR_MBCCSR115         FR.MB[115].CCSR.R             /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR115         FR.MB[115].CCFR.R             /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR115         FR.MB[115].FIDR.R             /* Message Buffer Frame ID Register */
#define FR_MBIDXR115         FR.MB[115].IDXR.R             /* Message Buffer Index Register */
#define FR_MBCCSR116         FR.MB[116].CCSR.R             /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR116         FR.MB[116].CCFR.R             /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR116         FR.MB[116].FIDR.R             /* Message Buffer Frame ID Register */
#define FR_MBIDXR116         FR.MB[116].IDXR.R             /* Message Buffer Index Register */
#define FR_MBCCSR117         FR.MB[117].CCSR.R             /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR117         FR.MB[117].CCFR.R             /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR117         FR.MB[117].FIDR.R             /* Message Buffer Frame ID Register */
#define FR_MBIDXR117         FR.MB[117].IDXR.R             /* Message Buffer Index Register */
#define FR_MBCCSR118         FR.MB[118].CCSR.R             /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR118         FR.MB[118].CCFR.R             /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR118         FR.MB[118].FIDR.R             /* Message Buffer Frame ID Register */
#define FR_MBIDXR118         FR.MB[118].IDXR.R             /* Message Buffer Index Register */
#define FR_MBCCSR119         FR.MB[119].CCSR.R             /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR119         FR.MB[119].CCFR.R             /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR119         FR.MB[119].FIDR.R             /* Message Buffer Frame ID Register */
#define FR_MBIDXR119         FR.MB[119].IDXR.R             /* Message Buffer Index Register */
#define FR_MBCCSR120         FR.MB[120].CCSR.R             /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR120         FR.MB[120].CCFR.R             /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR120         FR.MB[120].FIDR.R             /* Message Buffer Frame ID Register */
#define FR_MBIDXR120         FR.MB[120].IDXR.R             /* Message Buffer Index Register */
#define FR_MBCCSR121         FR.MB[121].CCSR.R             /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR121         FR.MB[121].CCFR.R             /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR121         FR.MB[121].FIDR.R             /* Message Buffer Frame ID Register */
#define FR_MBIDXR121         FR.MB[121].IDXR.R             /* Message Buffer Index Register */
#define FR_MBCCSR122         FR.MB[122].CCSR.R             /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR122         FR.MB[122].CCFR.R             /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR122         FR.MB[122].FIDR.R             /* Message Buffer Frame ID Register */
#define FR_MBIDXR122         FR.MB[122].IDXR.R             /* Message Buffer Index Register */
#define FR_MBCCSR123         FR.MB[123].CCSR.R             /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR123         FR.MB[123].CCFR.R             /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR123         FR.MB[123].FIDR.R             /* Message Buffer Frame ID Register */
#define FR_MBIDXR123         FR.MB[123].IDXR.R             /* Message Buffer Index Register */
#define FR_MBCCSR124         FR.MB[124].CCSR.R             /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR124         FR.MB[124].CCFR.R             /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR124         FR.MB[124].FIDR.R             /* Message Buffer Frame ID Register */
#define FR_MBIDXR124         FR.MB[124].IDXR.R             /* Message Buffer Index Register */
#define FR_MBCCSR125         FR.MB[125].CCSR.R             /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR125         FR.MB[125].CCFR.R             /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR125         FR.MB[125].FIDR.R             /* Message Buffer Frame ID Register */
#define FR_MBIDXR125         FR.MB[125].IDXR.R             /* Message Buffer Index Register */
#define FR_MBCCSR126         FR.MB[126].CCSR.R             /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR126         FR.MB[126].CCFR.R             /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR126         FR.MB[126].FIDR.R             /* Message Buffer Frame ID Register */
#define FR_MBIDXR126         FR.MB[126].IDXR.R             /* Message Buffer Index Register */
#define FR_MBCCSR127         FR.MB[127].CCSR.R             /* Message Buffer Configuration, Control, Status Register */
#define FR_MBCCFR127         FR.MB[127].CCFR.R             /* Message Buffer Cycle Counter Filter Register */
#define FR_MBFIDR127         FR.MB[127].FIDR.R             /* Message Buffer Frame ID Register */
#define FR_MBIDXR127         FR.MB[127].IDXR.R             /* Message Buffer Index Register */
#define FR_MBDOR0            FR.MBDOR[0].R                 /* Message Buffer Data Field Offset Register */
#define FR_MBDOR1            FR.MBDOR[1].R                 /* Message Buffer Data Field Offset Register */
#define FR_MBDOR2            FR.MBDOR[2].R                 /* Message Buffer Data Field Offset Register */
#define FR_MBDOR3            FR.MBDOR[3].R                 /* Message Buffer Data Field Offset Register */
#define FR_MBDOR4            FR.MBDOR[4].R                 /* Message Buffer Data Field Offset Register */
#define FR_MBDOR5            FR.MBDOR[5].R                 /* Message Buffer Data Field Offset Register */
#define FR_MBDOR6            FR.MBDOR[6].R                 /* Message Buffer Data Field Offset Register */
#define FR_MBDOR7            FR.MBDOR[7].R                 /* Message Buffer Data Field Offset Register */
#define FR_MBDOR8            FR.MBDOR[8].R                 /* Message Buffer Data Field Offset Register */
#define FR_MBDOR9            FR.MBDOR[9].R                 /* Message Buffer Data Field Offset Register */
#define FR_MBDOR10           FR.MBDOR[10].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR11           FR.MBDOR[11].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR12           FR.MBDOR[12].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR13           FR.MBDOR[13].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR14           FR.MBDOR[14].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR15           FR.MBDOR[15].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR16           FR.MBDOR[16].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR17           FR.MBDOR[17].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR18           FR.MBDOR[18].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR19           FR.MBDOR[19].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR20           FR.MBDOR[20].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR21           FR.MBDOR[21].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR22           FR.MBDOR[22].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR23           FR.MBDOR[23].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR24           FR.MBDOR[24].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR25           FR.MBDOR[25].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR26           FR.MBDOR[26].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR27           FR.MBDOR[27].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR28           FR.MBDOR[28].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR29           FR.MBDOR[29].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR30           FR.MBDOR[30].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR31           FR.MBDOR[31].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR32           FR.MBDOR[32].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR33           FR.MBDOR[33].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR34           FR.MBDOR[34].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR35           FR.MBDOR[35].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR36           FR.MBDOR[36].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR37           FR.MBDOR[37].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR38           FR.MBDOR[38].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR39           FR.MBDOR[39].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR40           FR.MBDOR[40].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR41           FR.MBDOR[41].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR42           FR.MBDOR[42].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR43           FR.MBDOR[43].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR44           FR.MBDOR[44].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR45           FR.MBDOR[45].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR46           FR.MBDOR[46].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR47           FR.MBDOR[47].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR48           FR.MBDOR[48].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR49           FR.MBDOR[49].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR50           FR.MBDOR[50].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR51           FR.MBDOR[51].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR52           FR.MBDOR[52].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR53           FR.MBDOR[53].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR54           FR.MBDOR[54].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR55           FR.MBDOR[55].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR56           FR.MBDOR[56].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR57           FR.MBDOR[57].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR58           FR.MBDOR[58].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR59           FR.MBDOR[59].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR60           FR.MBDOR[60].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR61           FR.MBDOR[61].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR62           FR.MBDOR[62].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR63           FR.MBDOR[63].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR64           FR.MBDOR[64].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR65           FR.MBDOR[65].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR66           FR.MBDOR[66].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR67           FR.MBDOR[67].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR68           FR.MBDOR[68].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR69           FR.MBDOR[69].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR70           FR.MBDOR[70].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR71           FR.MBDOR[71].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR72           FR.MBDOR[72].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR73           FR.MBDOR[73].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR74           FR.MBDOR[74].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR75           FR.MBDOR[75].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR76           FR.MBDOR[76].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR77           FR.MBDOR[77].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR78           FR.MBDOR[78].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR79           FR.MBDOR[79].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR80           FR.MBDOR[80].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR81           FR.MBDOR[81].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR82           FR.MBDOR[82].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR83           FR.MBDOR[83].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR84           FR.MBDOR[84].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR85           FR.MBDOR[85].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR86           FR.MBDOR[86].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR87           FR.MBDOR[87].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR88           FR.MBDOR[88].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR89           FR.MBDOR[89].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR90           FR.MBDOR[90].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR91           FR.MBDOR[91].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR92           FR.MBDOR[92].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR93           FR.MBDOR[93].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR94           FR.MBDOR[94].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR95           FR.MBDOR[95].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR96           FR.MBDOR[96].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR97           FR.MBDOR[97].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR98           FR.MBDOR[98].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR99           FR.MBDOR[99].R                /* Message Buffer Data Field Offset Register */
#define FR_MBDOR100          FR.MBDOR[100].R               /* Message Buffer Data Field Offset Register */
#define FR_MBDOR101          FR.MBDOR[101].R               /* Message Buffer Data Field Offset Register */
#define FR_MBDOR102          FR.MBDOR[102].R               /* Message Buffer Data Field Offset Register */
#define FR_MBDOR103          FR.MBDOR[103].R               /* Message Buffer Data Field Offset Register */
#define FR_MBDOR104          FR.MBDOR[104].R               /* Message Buffer Data Field Offset Register */
#define FR_MBDOR105          FR.MBDOR[105].R               /* Message Buffer Data Field Offset Register */
#define FR_MBDOR106          FR.MBDOR[106].R               /* Message Buffer Data Field Offset Register */
#define FR_MBDOR107          FR.MBDOR[107].R               /* Message Buffer Data Field Offset Register */
#define FR_MBDOR108          FR.MBDOR[108].R               /* Message Buffer Data Field Offset Register */
#define FR_MBDOR109          FR.MBDOR[109].R               /* Message Buffer Data Field Offset Register */
#define FR_MBDOR110          FR.MBDOR[110].R               /* Message Buffer Data Field Offset Register */
#define FR_MBDOR111          FR.MBDOR[111].R               /* Message Buffer Data Field Offset Register */
#define FR_MBDOR112          FR.MBDOR[112].R               /* Message Buffer Data Field Offset Register */
#define FR_MBDOR113          FR.MBDOR[113].R               /* Message Buffer Data Field Offset Register */
#define FR_MBDOR114          FR.MBDOR[114].R               /* Message Buffer Data Field Offset Register */
#define FR_MBDOR115          FR.MBDOR[115].R               /* Message Buffer Data Field Offset Register */
#define FR_MBDOR116          FR.MBDOR[116].R               /* Message Buffer Data Field Offset Register */
#define FR_MBDOR117          FR.MBDOR[117].R               /* Message Buffer Data Field Offset Register */
#define FR_MBDOR118          FR.MBDOR[118].R               /* Message Buffer Data Field Offset Register */
#define FR_MBDOR119          FR.MBDOR[119].R               /* Message Buffer Data Field Offset Register */
#define FR_MBDOR120          FR.MBDOR[120].R               /* Message Buffer Data Field Offset Register */
#define FR_MBDOR121          FR.MBDOR[121].R               /* Message Buffer Data Field Offset Register */
#define FR_MBDOR122          FR.MBDOR[122].R               /* Message Buffer Data Field Offset Register */
#define FR_MBDOR123          FR.MBDOR[123].R               /* Message Buffer Data Field Offset Register */
#define FR_MBDOR124          FR.MBDOR[124].R               /* Message Buffer Data Field Offset Register */
#define FR_MBDOR125          FR.MBDOR[125].R               /* Message Buffer Data Field Offset Register */
#define FR_MBDOR126          FR.MBDOR[126].R               /* Message Buffer Data Field Offset Register */
#define FR_MBDOR127          FR.MBDOR[127].R               /* Message Buffer Data Field Offset Register */
#define FR_MBDOR128          FR.MBDOR[128].R               /* Message Buffer Data Field Offset Register */
#define FR_MBDOR129          FR.MBDOR[129].R               /* Message Buffer Data Field Offset Register */
#define FR_MBDOR130          FR.MBDOR[130].R               /* Message Buffer Data Field Offset Register */
#define FR_MBDOR131          FR.MBDOR[131].R               /* Message Buffer Data Field Offset Register */
#define FR_LEETR0            FR.LEETR[0].R                 /* LRAM ECC Error Test Register */
#define FR_LEETR1            FR.LEETR[1].R                 /* LRAM ECC Error Test Register */
#define FR_LEETR2            FR.LEETR[2].R                 /* LRAM ECC Error Test Register */
#define FR_LEETR3            FR.LEETR[3].R                 /* LRAM ECC Error Test Register */
#define FR_LEETR4            FR.LEETR[4].R                 /* LRAM ECC Error Test Register */
#define FR_LEETR5            FR.LEETR[5].R                 /* LRAM ECC Error Test Register */

/* FXOSC */
#define FXOSC_CTL            FXOSC.CTL.R                   /* FXOSC Control Register */

/* GPR */
#define GPR_CTL              GPR.CTL.R                     /* GPR Control Register */
#define GPR_STAT             GPR.STAT.R                    /* GPR Status Register */
#define GPR_CTL1             GPR.CTL1.R                    /* GPR Control Register1 */
#define GPR_SLEEP            GPR.SLEEP.R                   /* GPR SLEEP Register */

/* HFInterface */
#define HFInterface_0_CCR    HFInterface_0.CCR.R           /* Clock Configuration Register */
#define HFInterface_0_SPDCR  HFInterface_0.SPDCR.R         /* Short Pulse Detector Configuration Register */
#define HFInterface_0_LPDCR  HFInterface_0.LPDCR.R         /* Long Pulse Detector Configuration Register */
#define HFInterface_0_LTDCR  HFInterface_0.LTDCR.R         /* Low-level Timeout Detector Configuration Register */
#define HFInterface_0_HTDCR  HFInterface_0.HTDCR.R         /* High-level Timeout Detector Configuration Register */
#define HFInterface_0_IER    HFInterface_0.IER.R           /* Interrupt Enable Register */
#define HFInterface_0_ISR    HFInterface_0.ISR.R           /* Interrupt Status Register */

/* HFInterface */
#define HFInterface_1_CCR    HFInterface_1.CCR.R           /* Clock Configuration Register */
#define HFInterface_1_SPDCR  HFInterface_1.SPDCR.R         /* Short Pulse Detector Configuration Register */
#define HFInterface_1_LPDCR  HFInterface_1.LPDCR.R         /* Long Pulse Detector Configuration Register */
#define HFInterface_1_LTDCR  HFInterface_1.LTDCR.R         /* Low-level Timeout Detector Configuration Register */
#define HFInterface_1_HTDCR  HFInterface_1.HTDCR.R         /* High-level Timeout Detector Configuration Register */
#define HFInterface_1_IER    HFInterface_1.IER.R           /* Interrupt Enable Register */
#define HFInterface_1_ISR    HFInterface_1.ISR.R           /* Interrupt Status Register */

/* HFInterface */
#define HFInterface_2_CCR    HFInterface_2.CCR.R           /* Clock Configuration Register */
#define HFInterface_2_SPDCR  HFInterface_2.SPDCR.R         /* Short Pulse Detector Configuration Register */
#define HFInterface_2_LPDCR  HFInterface_2.LPDCR.R         /* Long Pulse Detector Configuration Register */
#define HFInterface_2_LTDCR  HFInterface_2.LTDCR.R         /* Low-level Timeout Detector Configuration Register */
#define HFInterface_2_HTDCR  HFInterface_2.HTDCR.R         /* High-level Timeout Detector Configuration Register */
#define HFInterface_2_IER    HFInterface_2.IER.R           /* Interrupt Enable Register */
#define HFInterface_2_ISR    HFInterface_2.ISR.R           /* Interrupt Status Register */

/* HFInterface */
#define HFInterface_3_CCR    HFInterface_3.CCR.R           /* Clock Configuration Register */
#define HFInterface_3_SPDCR  HFInterface_3.SPDCR.R         /* Short Pulse Detector Configuration Register */
#define HFInterface_3_LPDCR  HFInterface_3.LPDCR.R         /* Long Pulse Detector Configuration Register */
#define HFInterface_3_LTDCR  HFInterface_3.LTDCR.R         /* Low-level Timeout Detector Configuration Register */
#define HFInterface_3_HTDCR  HFInterface_3.HTDCR.R         /* High-level Timeout Detector Configuration Register */
#define HFInterface_3_IER    HFInterface_3.IER.R           /* Interrupt Enable Register */
#define HFInterface_3_ISR    HFInterface_3.ISR.R           /* Interrupt Status Register */

/* I2C */
#define I2C_0_IBAD           I2C_0.IBAD.R                  /* I2C Bus Address Register */
#define I2C_0_IBFD           I2C_0.IBFD.R                  /* I2C Bus Frequency Divider Register */
#define I2C_0_IBCR           I2C_0.IBCR.R                  /* I2C Bus Control Register */
#define I2C_0_IBSR           I2C_0.IBSR.R                  /* I2C Bus Status Register */
#define I2C_0_IBDR           I2C_0.IBDR.R                  /* I2C Bus Data I/O Register */
#define I2C_0_IBIC           I2C_0.IBIC.R                  /* I2C Bus Interrupt Config Register */
#define I2C_0_IBDBG          I2C_0.IBDBG.R                 /* I2C Bus Debug Register */

/* I2C */
#define I2C_1_IBAD           I2C_1.IBAD.R                  /* I2C Bus Address Register */
#define I2C_1_IBFD           I2C_1.IBFD.R                  /* I2C Bus Frequency Divider Register */
#define I2C_1_IBCR           I2C_1.IBCR.R                  /* I2C Bus Control Register */
#define I2C_1_IBSR           I2C_1.IBSR.R                  /* I2C Bus Status Register */
#define I2C_1_IBDR           I2C_1.IBDR.R                  /* I2C Bus Data I/O Register */
#define I2C_1_IBIC           I2C_1.IBIC.R                  /* I2C Bus Interrupt Config Register */
#define I2C_1_IBDBG          I2C_1.IBDBG.R                 /* I2C Bus Debug Register */

/* I2C */
#define I2C_2_IBAD           I2C_2.IBAD.R                  /* I2C Bus Address Register */
#define I2C_2_IBFD           I2C_2.IBFD.R                  /* I2C Bus Frequency Divider Register */
#define I2C_2_IBCR           I2C_2.IBCR.R                  /* I2C Bus Control Register */
#define I2C_2_IBSR           I2C_2.IBSR.R                  /* I2C Bus Status Register */
#define I2C_2_IBDR           I2C_2.IBDR.R                  /* I2C Bus Data I/O Register */
#define I2C_2_IBIC           I2C_2.IBIC.R                  /* I2C Bus Interrupt Config Register */
#define I2C_2_IBDBG          I2C_2.IBDBG.R                 /* I2C Bus Debug Register */

/* I2C */
#define I2C_3_IBAD           I2C_3.IBAD.R                  /* I2C Bus Address Register */
#define I2C_3_IBFD           I2C_3.IBFD.R                  /* I2C Bus Frequency Divider Register */
#define I2C_3_IBCR           I2C_3.IBCR.R                  /* I2C Bus Control Register */
#define I2C_3_IBSR           I2C_3.IBSR.R                  /* I2C Bus Status Register */
#define I2C_3_IBDR           I2C_3.IBDR.R                  /* I2C Bus Data I/O Register */
#define I2C_3_IBIC           I2C_3.IBIC.R                  /* I2C Bus Interrupt Config Register */
#define I2C_3_IBDBG          I2C_3.IBDBG.R                 /* I2C Bus Debug Register */

/* I2S */
#define I2S_0_TCSR           I2S_0.TCSR.R                  /* SAI Transmit Control Register */
#define I2S_0_TCR1           I2S_0.TCR1.R                  /* SAI Transmit Configuration 1 Register */
#define I2S_0_TCR2           I2S_0.TCR2.R                  /* SAI Transmit Configuration 2 Register */
#define I2S_0_TCR3           I2S_0.TCR3.R                  /* SAI Transmit Configuration 3 Register */
#define I2S_0_TCR4           I2S_0.TCR4.R                  /* SAI Transmit Configuration 4 Register */
#define I2S_0_TCR5           I2S_0.TCR5.R                  /* SAI Transmit Configuration 5 Register */
#define I2S_0_TDR0           I2S_0.TDR[0].R                /* SAI Transmit Data Register */
#define I2S_0_TDR1           I2S_0.TDR[1].R                /* SAI Transmit Data Register */
#define I2S_0_TDR2           I2S_0.TDR[2].R                /* SAI Transmit Data Register */
#define I2S_0_TDR3           I2S_0.TDR[3].R                /* SAI Transmit Data Register */
#define I2S_0_TFR0           I2S_0.TFR[0].R                /* SAI Transmit FIFO Register */
#define I2S_0_TFR1           I2S_0.TFR[1].R                /* SAI Transmit FIFO Register */
#define I2S_0_TFR2           I2S_0.TFR[2].R                /* SAI Transmit FIFO Register */
#define I2S_0_TFR3           I2S_0.TFR[3].R                /* SAI Transmit FIFO Register */
#define I2S_0_TMR            I2S_0.TMR.R                   /* SAI Transmit Mask Register */
#define I2S_0_RCSR           I2S_0.RCSR.R                  /* SAI Receive Control Register */
#define I2S_0_RCR1           I2S_0.RCR1.R                  /* SAI Receive Configuration 1 Register */
#define I2S_0_RCR2           I2S_0.RCR2.R                  /* SAI Receive Configuration 2 Register */
#define I2S_0_RCR3           I2S_0.RCR3.R                  /* SAI Receive Configuration 3 Register */
#define I2S_0_RCR4           I2S_0.RCR4.R                  /* SAI Receive Configuration 4 Register */
#define I2S_0_RCR5           I2S_0.RCR5.R                  /* SAI Receive Configuration 5 Register */
#define I2S_0_RDR0           I2S_0.RDR[0].R                /* SAI Receive Data Register */
#define I2S_0_RDR1           I2S_0.RDR[1].R                /* SAI Receive Data Register */
#define I2S_0_RDR2           I2S_0.RDR[2].R                /* SAI Receive Data Register */
#define I2S_0_RDR3           I2S_0.RDR[3].R                /* SAI Receive Data Register */
#define I2S_0_RFR0           I2S_0.RFR[0].R                /* SAI Receive FIFO Register */
#define I2S_0_RFR1           I2S_0.RFR[1].R                /* SAI Receive FIFO Register */
#define I2S_0_RFR2           I2S_0.RFR[2].R                /* SAI Receive FIFO Register */
#define I2S_0_RFR3           I2S_0.RFR[3].R                /* SAI Receive FIFO Register */
#define I2S_0_RMR            I2S_0.RMR.R                   /* SAI Receive Mask Register */
#define I2S_0_MCR            I2S_0.MCR.R                   /* SAI MCLK Control Register */
#define I2S_0_MDR            I2S_0.MDR.R                   /* SAI MCLK Divide Register */

/* I2S */
#define I2S_1_TCSR           I2S_1.TCSR.R                  /* SAI Transmit Control Register */
#define I2S_1_TCR1           I2S_1.TCR1.R                  /* SAI Transmit Configuration 1 Register */
#define I2S_1_TCR2           I2S_1.TCR2.R                  /* SAI Transmit Configuration 2 Register */
#define I2S_1_TCR3           I2S_1.TCR3.R                  /* SAI Transmit Configuration 3 Register */
#define I2S_1_TCR4           I2S_1.TCR4.R                  /* SAI Transmit Configuration 4 Register */
#define I2S_1_TCR5           I2S_1.TCR5.R                  /* SAI Transmit Configuration 5 Register */
#define I2S_1_TDR0           I2S_1.TDR[0].R                /* SAI Transmit Data Register */
#define I2S_1_TDR1           I2S_1.TDR[1].R                /* SAI Transmit Data Register */
#define I2S_1_TDR2           I2S_1.TDR[2].R                /* SAI Transmit Data Register */
#define I2S_1_TDR3           I2S_1.TDR[3].R                /* SAI Transmit Data Register */
#define I2S_1_TFR0           I2S_1.TFR[0].R                /* SAI Transmit FIFO Register */
#define I2S_1_TFR1           I2S_1.TFR[1].R                /* SAI Transmit FIFO Register */
#define I2S_1_TFR2           I2S_1.TFR[2].R                /* SAI Transmit FIFO Register */
#define I2S_1_TFR3           I2S_1.TFR[3].R                /* SAI Transmit FIFO Register */
#define I2S_1_TMR            I2S_1.TMR.R                   /* SAI Transmit Mask Register */
#define I2S_1_RCSR           I2S_1.RCSR.R                  /* SAI Receive Control Register */
#define I2S_1_RCR1           I2S_1.RCR1.R                  /* SAI Receive Configuration 1 Register */
#define I2S_1_RCR2           I2S_1.RCR2.R                  /* SAI Receive Configuration 2 Register */
#define I2S_1_RCR3           I2S_1.RCR3.R                  /* SAI Receive Configuration 3 Register */
#define I2S_1_RCR4           I2S_1.RCR4.R                  /* SAI Receive Configuration 4 Register */
#define I2S_1_RCR5           I2S_1.RCR5.R                  /* SAI Receive Configuration 5 Register */
#define I2S_1_RDR0           I2S_1.RDR[0].R                /* SAI Receive Data Register */
#define I2S_1_RDR1           I2S_1.RDR[1].R                /* SAI Receive Data Register */
#define I2S_1_RDR2           I2S_1.RDR[2].R                /* SAI Receive Data Register */
#define I2S_1_RDR3           I2S_1.RDR[3].R                /* SAI Receive Data Register */
#define I2S_1_RFR0           I2S_1.RFR[0].R                /* SAI Receive FIFO Register */
#define I2S_1_RFR1           I2S_1.RFR[1].R                /* SAI Receive FIFO Register */
#define I2S_1_RFR2           I2S_1.RFR[2].R                /* SAI Receive FIFO Register */
#define I2S_1_RFR3           I2S_1.RFR[3].R                /* SAI Receive FIFO Register */
#define I2S_1_RMR            I2S_1.RMR.R                   /* SAI Receive Mask Register */
#define I2S_1_MCR            I2S_1.MCR.R                   /* SAI MCLK Control Register */
#define I2S_1_MDR            I2S_1.MDR.R                   /* SAI MCLK Divide Register */

/* I2S */
#define I2S_2_TCSR           I2S_2.TCSR.R                  /* SAI Transmit Control Register */
#define I2S_2_TCR1           I2S_2.TCR1.R                  /* SAI Transmit Configuration 1 Register */
#define I2S_2_TCR2           I2S_2.TCR2.R                  /* SAI Transmit Configuration 2 Register */
#define I2S_2_TCR3           I2S_2.TCR3.R                  /* SAI Transmit Configuration 3 Register */
#define I2S_2_TCR4           I2S_2.TCR4.R                  /* SAI Transmit Configuration 4 Register */
#define I2S_2_TCR5           I2S_2.TCR5.R                  /* SAI Transmit Configuration 5 Register */
#define I2S_2_TDR0           I2S_2.TDR[0].R                /* SAI Transmit Data Register */
#define I2S_2_TDR1           I2S_2.TDR[1].R                /* SAI Transmit Data Register */
#define I2S_2_TDR2           I2S_2.TDR[2].R                /* SAI Transmit Data Register */
#define I2S_2_TDR3           I2S_2.TDR[3].R                /* SAI Transmit Data Register */
#define I2S_2_TFR0           I2S_2.TFR[0].R                /* SAI Transmit FIFO Register */
#define I2S_2_TFR1           I2S_2.TFR[1].R                /* SAI Transmit FIFO Register */
#define I2S_2_TFR2           I2S_2.TFR[2].R                /* SAI Transmit FIFO Register */
#define I2S_2_TFR3           I2S_2.TFR[3].R                /* SAI Transmit FIFO Register */
#define I2S_2_TMR            I2S_2.TMR.R                   /* SAI Transmit Mask Register */
#define I2S_2_RCSR           I2S_2.RCSR.R                  /* SAI Receive Control Register */
#define I2S_2_RCR1           I2S_2.RCR1.R                  /* SAI Receive Configuration 1 Register */
#define I2S_2_RCR2           I2S_2.RCR2.R                  /* SAI Receive Configuration 2 Register */
#define I2S_2_RCR3           I2S_2.RCR3.R                  /* SAI Receive Configuration 3 Register */
#define I2S_2_RCR4           I2S_2.RCR4.R                  /* SAI Receive Configuration 4 Register */
#define I2S_2_RCR5           I2S_2.RCR5.R                  /* SAI Receive Configuration 5 Register */
#define I2S_2_RDR0           I2S_2.RDR[0].R                /* SAI Receive Data Register */
#define I2S_2_RDR1           I2S_2.RDR[1].R                /* SAI Receive Data Register */
#define I2S_2_RDR2           I2S_2.RDR[2].R                /* SAI Receive Data Register */
#define I2S_2_RDR3           I2S_2.RDR[3].R                /* SAI Receive Data Register */
#define I2S_2_RFR0           I2S_2.RFR[0].R                /* SAI Receive FIFO Register */
#define I2S_2_RFR1           I2S_2.RFR[1].R                /* SAI Receive FIFO Register */
#define I2S_2_RFR2           I2S_2.RFR[2].R                /* SAI Receive FIFO Register */
#define I2S_2_RFR3           I2S_2.RFR[3].R                /* SAI Receive FIFO Register */
#define I2S_2_RMR            I2S_2.RMR.R                   /* SAI Receive Mask Register */
#define I2S_2_MCR            I2S_2.MCR.R                   /* SAI MCLK Control Register */
#define I2S_2_MDR            I2S_2.MDR.R                   /* SAI MCLK Divide Register */

/* IGF */
#define IGF_0_MCR0           IGF_0.MCR0.R                  /* Module Configuration Register */
#define IGF_0_MSR0           IGF_0.MSR0.R                  /* Module Status Register */
#define IGF_0_PRESR0         IGF_0.PRESR0.R                /* Prescaler Register */
#define IGF_0_RTHR0          IGF_0.RTHR0.R                 /* Rising edge Threshold Register */
#define IGF_0_FTHR           IGF_0.FTHR0.R                 /* Falling edge Threshold Register */

/* IGF */
#define IGF_1_MCR0           IGF_1.MCR0.R                  /* Module Configuration Register */
#define IGF_1_MSR0           IGF_1.MSR0.R                  /* Module Status Register */
#define IGF_1_PRESR0         IGF_1.PRESR0.R                /* Prescaler Register */
#define IGF_1_RTHR0          IGF_1.RTHR0.R                 /* Rising edge Threshold Register */
#define IGF_1_FTHR           IGF_1.FTHR0.R                 /* Falling edge Threshold Register */

/* IGF */
#define IGF_2_MCR0           IGF_2.MCR0.R                  /* Module Configuration Register */
#define IGF_2_MSR0           IGF_2.MSR0.R                  /* Module Status Register */
#define IGF_2_PRESR0         IGF_2.PRESR0.R                /* Prescaler Register */
#define IGF_2_RTHR0          IGF_2.RTHR0.R                 /* Rising edge Threshold Register */
#define IGF_2_FTHR           IGF_2.FTHR0.R                 /* Falling edge Threshold Register */

/* IGF */
#define IGF_3_MCR0           IGF_3.MCR0.R                  /* Module Configuration Register */
#define IGF_3_MSR0           IGF_3.MSR0.R                  /* Module Status Register */
#define IGF_3_PRESR0         IGF_3.PRESR0.R                /* Prescaler Register */
#define IGF_3_RTHR0          IGF_3.RTHR0.R                 /* Rising edge Threshold Register */
#define IGF_3_FTHR           IGF_3.FTHR0.R                 /* Falling edge Threshold Register */

/* INTC */
#define INTC_BCR             INTC.BCR.R                    /* INTC Block Configuration Register */
#define INTC_MPROT           INTC.MPROT.R                  /* INTC Master Protection Register */
#define INTC_CPR0            INTC.CPR[0].R                 /* INTC Current Priority Register for Processor n */
#define INTC_CPR1            INTC.CPR[1].R                 /* INTC Current Priority Register for Processor n */
#define INTC_CPR2            INTC.CPR[2].R                 /* INTC Current Priority Register for Processor n */
#define INTC_IACKR0          INTC.IACKR[0].R               /* INTC Interrupt Acknowledge Register for Processor n */
#define INTC_IACKR1          INTC.IACKR[1].R               /* INTC Interrupt Acknowledge Register for Processor n */
#define INTC_IACKR2          INTC.IACKR[2].R               /* INTC Interrupt Acknowledge Register for Processor n */
#define INTC_EOIR0           INTC.EOIR[0].R                /* INTC End Of Interrupt Register for Processor n */
#define INTC_EOIR1           INTC.EOIR[1].R                /* INTC End Of Interrupt Register for Processor n */
#define INTC_EOIR2           INTC.EOIR[2].R                /* INTC End Of Interrupt Register for Processor n */
#define INTC_SSCIR0          INTC.SSCIR[0].R               /* INTC Software Set/Clear Interrupt Register */
#define INTC_SSCIR1          INTC.SSCIR[1].R               /* INTC Software Set/Clear Interrupt Register */
#define INTC_SSCIR2          INTC.SSCIR[2].R               /* INTC Software Set/Clear Interrupt Register */
#define INTC_SSCIR3          INTC.SSCIR[3].R               /* INTC Software Set/Clear Interrupt Register */
#define INTC_SSCIR4          INTC.SSCIR[4].R               /* INTC Software Set/Clear Interrupt Register */
#define INTC_SSCIR5          INTC.SSCIR[5].R               /* INTC Software Set/Clear Interrupt Register */
#define INTC_SSCIR6          INTC.SSCIR[6].R               /* INTC Software Set/Clear Interrupt Register */
#define INTC_SSCIR7          INTC.SSCIR[7].R               /* INTC Software Set/Clear Interrupt Register */
#define INTC_SSCIR8          INTC.SSCIR[8].R               /* INTC Software Set/Clear Interrupt Register */
#define INTC_SSCIR9          INTC.SSCIR[9].R               /* INTC Software Set/Clear Interrupt Register */
#define INTC_SSCIR10         INTC.SSCIR[10].R              /* INTC Software Set/Clear Interrupt Register */
#define INTC_SSCIR11         INTC.SSCIR[11].R              /* INTC Software Set/Clear Interrupt Register */
#define INTC_SSCIR12         INTC.SSCIR[12].R              /* INTC Software Set/Clear Interrupt Register */
#define INTC_SSCIR13         INTC.SSCIR[13].R              /* INTC Software Set/Clear Interrupt Register */
#define INTC_SSCIR14         INTC.SSCIR[14].R              /* INTC Software Set/Clear Interrupt Register */
#define INTC_SSCIR15         INTC.SSCIR[15].R              /* INTC Software Set/Clear Interrupt Register */
#define INTC_SSCIR16         INTC.SSCIR[16].R              /* INTC Software Set/Clear Interrupt Register */
#define INTC_SSCIR17         INTC.SSCIR[17].R              /* INTC Software Set/Clear Interrupt Register */
#define INTC_SSCIR18         INTC.SSCIR[18].R              /* INTC Software Set/Clear Interrupt Register */
#define INTC_SSCIR19         INTC.SSCIR[19].R              /* INTC Software Set/Clear Interrupt Register */
#define INTC_SSCIR20         INTC.SSCIR[20].R              /* INTC Software Set/Clear Interrupt Register */
#define INTC_SSCIR21         INTC.SSCIR[21].R              /* INTC Software Set/Clear Interrupt Register */
#define INTC_SSCIR22         INTC.SSCIR[22].R              /* INTC Software Set/Clear Interrupt Register */
#define INTC_SSCIR23         INTC.SSCIR[23].R              /* INTC Software Set/Clear Interrupt Register */
#define INTC_PSR0            INTC.PSR[0].R                 /* INTC Priority Select Register */
#define INTC_PSR1            INTC.PSR[1].R                 /* INTC Priority Select Register */
#define INTC_PSR2            INTC.PSR[2].R                 /* INTC Priority Select Register */
#define INTC_PSR3            INTC.PSR[3].R                 /* INTC Priority Select Register */
#define INTC_PSR4            INTC.PSR[4].R                 /* INTC Priority Select Register */
#define INTC_PSR5            INTC.PSR[5].R                 /* INTC Priority Select Register */
#define INTC_PSR6            INTC.PSR[6].R                 /* INTC Priority Select Register */
#define INTC_PSR7            INTC.PSR[7].R                 /* INTC Priority Select Register */
#define INTC_PSR8            INTC.PSR[8].R                 /* INTC Priority Select Register */
#define INTC_PSR9            INTC.PSR[9].R                 /* INTC Priority Select Register */
#define INTC_PSR10           INTC.PSR[10].R                /* INTC Priority Select Register */
#define INTC_PSR11           INTC.PSR[11].R                /* INTC Priority Select Register */
#define INTC_PSR12           INTC.PSR[12].R                /* INTC Priority Select Register */
#define INTC_PSR13           INTC.PSR[13].R                /* INTC Priority Select Register */
#define INTC_PSR14           INTC.PSR[14].R                /* INTC Priority Select Register */
#define INTC_PSR15           INTC.PSR[15].R                /* INTC Priority Select Register */
#define INTC_PSR16           INTC.PSR[16].R                /* INTC Priority Select Register */
#define INTC_PSR17           INTC.PSR[17].R                /* INTC Priority Select Register */
#define INTC_PSR18           INTC.PSR[18].R                /* INTC Priority Select Register */
#define INTC_PSR19           INTC.PSR[19].R                /* INTC Priority Select Register */
#define INTC_PSR20           INTC.PSR[20].R                /* INTC Priority Select Register */
#define INTC_PSR21           INTC.PSR[21].R                /* INTC Priority Select Register */
#define INTC_PSR22           INTC.PSR[22].R                /* INTC Priority Select Register */
#define INTC_PSR23           INTC.PSR[23].R                /* INTC Priority Select Register */
#define INTC_PSR24           INTC.PSR[24].R                /* INTC Priority Select Register */
#define INTC_PSR25           INTC.PSR[25].R                /* INTC Priority Select Register */
#define INTC_PSR26           INTC.PSR[26].R                /* INTC Priority Select Register */
#define INTC_PSR27           INTC.PSR[27].R                /* INTC Priority Select Register */
#define INTC_PSR28           INTC.PSR[28].R                /* INTC Priority Select Register */
#define INTC_PSR29           INTC.PSR[29].R                /* INTC Priority Select Register */
#define INTC_PSR30           INTC.PSR[30].R                /* INTC Priority Select Register */
#define INTC_PSR31           INTC.PSR[31].R                /* INTC Priority Select Register */
#define INTC_PSR32           INTC.PSR[32].R                /* INTC Priority Select Register */
#define INTC_PSR33           INTC.PSR[33].R                /* INTC Priority Select Register */
#define INTC_PSR34           INTC.PSR[34].R                /* INTC Priority Select Register */
#define INTC_PSR35           INTC.PSR[35].R                /* INTC Priority Select Register */
#define INTC_PSR36           INTC.PSR[36].R                /* INTC Priority Select Register */
#define INTC_PSR37           INTC.PSR[37].R                /* INTC Priority Select Register */
#define INTC_PSR38           INTC.PSR[38].R                /* INTC Priority Select Register */
#define INTC_PSR39           INTC.PSR[39].R                /* INTC Priority Select Register */
#define INTC_PSR40           INTC.PSR[40].R                /* INTC Priority Select Register */
#define INTC_PSR41           INTC.PSR[41].R                /* INTC Priority Select Register */
#define INTC_PSR42           INTC.PSR[42].R                /* INTC Priority Select Register */
#define INTC_PSR43           INTC.PSR[43].R                /* INTC Priority Select Register */
#define INTC_PSR44           INTC.PSR[44].R                /* INTC Priority Select Register */
#define INTC_PSR45           INTC.PSR[45].R                /* INTC Priority Select Register */
#define INTC_PSR46           INTC.PSR[46].R                /* INTC Priority Select Register */
#define INTC_PSR47           INTC.PSR[47].R                /* INTC Priority Select Register */
#define INTC_PSR48           INTC.PSR[48].R                /* INTC Priority Select Register */
#define INTC_PSR49           INTC.PSR[49].R                /* INTC Priority Select Register */
#define INTC_PSR50           INTC.PSR[50].R                /* INTC Priority Select Register */
#define INTC_PSR51           INTC.PSR[51].R                /* INTC Priority Select Register */
#define INTC_PSR52           INTC.PSR[52].R                /* INTC Priority Select Register */
#define INTC_PSR53           INTC.PSR[53].R                /* INTC Priority Select Register */
#define INTC_PSR54           INTC.PSR[54].R                /* INTC Priority Select Register */
#define INTC_PSR55           INTC.PSR[55].R                /* INTC Priority Select Register */
#define INTC_PSR56           INTC.PSR[56].R                /* INTC Priority Select Register */
#define INTC_PSR57           INTC.PSR[57].R                /* INTC Priority Select Register */
#define INTC_PSR58           INTC.PSR[58].R                /* INTC Priority Select Register */
#define INTC_PSR59           INTC.PSR[59].R                /* INTC Priority Select Register */
#define INTC_PSR60           INTC.PSR[60].R                /* INTC Priority Select Register */
#define INTC_PSR61           INTC.PSR[61].R                /* INTC Priority Select Register */
#define INTC_PSR62           INTC.PSR[62].R                /* INTC Priority Select Register */
#define INTC_PSR63           INTC.PSR[63].R                /* INTC Priority Select Register */
#define INTC_PSR64           INTC.PSR[64].R                /* INTC Priority Select Register */
#define INTC_PSR65           INTC.PSR[65].R                /* INTC Priority Select Register */
#define INTC_PSR66           INTC.PSR[66].R                /* INTC Priority Select Register */
#define INTC_PSR67           INTC.PSR[67].R                /* INTC Priority Select Register */
#define INTC_PSR68           INTC.PSR[68].R                /* INTC Priority Select Register */
#define INTC_PSR69           INTC.PSR[69].R                /* INTC Priority Select Register */
#define INTC_PSR70           INTC.PSR[70].R                /* INTC Priority Select Register */
#define INTC_PSR71           INTC.PSR[71].R                /* INTC Priority Select Register */
#define INTC_PSR72           INTC.PSR[72].R                /* INTC Priority Select Register */
#define INTC_PSR73           INTC.PSR[73].R                /* INTC Priority Select Register */
#define INTC_PSR74           INTC.PSR[74].R                /* INTC Priority Select Register */
#define INTC_PSR75           INTC.PSR[75].R                /* INTC Priority Select Register */
#define INTC_PSR76           INTC.PSR[76].R                /* INTC Priority Select Register */
#define INTC_PSR77           INTC.PSR[77].R                /* INTC Priority Select Register */
#define INTC_PSR78           INTC.PSR[78].R                /* INTC Priority Select Register */
#define INTC_PSR79           INTC.PSR[79].R                /* INTC Priority Select Register */
#define INTC_PSR80           INTC.PSR[80].R                /* INTC Priority Select Register */
#define INTC_PSR81           INTC.PSR[81].R                /* INTC Priority Select Register */
#define INTC_PSR82           INTC.PSR[82].R                /* INTC Priority Select Register */
#define INTC_PSR83           INTC.PSR[83].R                /* INTC Priority Select Register */
#define INTC_PSR84           INTC.PSR[84].R                /* INTC Priority Select Register */
#define INTC_PSR85           INTC.PSR[85].R                /* INTC Priority Select Register */
#define INTC_PSR86           INTC.PSR[86].R                /* INTC Priority Select Register */
#define INTC_PSR87           INTC.PSR[87].R                /* INTC Priority Select Register */
#define INTC_PSR88           INTC.PSR[88].R                /* INTC Priority Select Register */
#define INTC_PSR89           INTC.PSR[89].R                /* INTC Priority Select Register */
#define INTC_PSR90           INTC.PSR[90].R                /* INTC Priority Select Register */
#define INTC_PSR91           INTC.PSR[91].R                /* INTC Priority Select Register */
#define INTC_PSR92           INTC.PSR[92].R                /* INTC Priority Select Register */
#define INTC_PSR93           INTC.PSR[93].R                /* INTC Priority Select Register */
#define INTC_PSR94           INTC.PSR[94].R                /* INTC Priority Select Register */
#define INTC_PSR95           INTC.PSR[95].R                /* INTC Priority Select Register */
#define INTC_PSR96           INTC.PSR[96].R                /* INTC Priority Select Register */
#define INTC_PSR97           INTC.PSR[97].R                /* INTC Priority Select Register */
#define INTC_PSR98           INTC.PSR[98].R                /* INTC Priority Select Register */
#define INTC_PSR99           INTC.PSR[99].R                /* INTC Priority Select Register */
#define INTC_PSR100          INTC.PSR[100].R               /* INTC Priority Select Register */
#define INTC_PSR101          INTC.PSR[101].R               /* INTC Priority Select Register */
#define INTC_PSR102          INTC.PSR[102].R               /* INTC Priority Select Register */
#define INTC_PSR103          INTC.PSR[103].R               /* INTC Priority Select Register */
#define INTC_PSR104          INTC.PSR[104].R               /* INTC Priority Select Register */
#define INTC_PSR105          INTC.PSR[105].R               /* INTC Priority Select Register */
#define INTC_PSR106          INTC.PSR[106].R               /* INTC Priority Select Register */
#define INTC_PSR107          INTC.PSR[107].R               /* INTC Priority Select Register */
#define INTC_PSR108          INTC.PSR[108].R               /* INTC Priority Select Register */
#define INTC_PSR109          INTC.PSR[109].R               /* INTC Priority Select Register */
#define INTC_PSR110          INTC.PSR[110].R               /* INTC Priority Select Register */
#define INTC_PSR111          INTC.PSR[111].R               /* INTC Priority Select Register */
#define INTC_PSR112          INTC.PSR[112].R               /* INTC Priority Select Register */
#define INTC_PSR113          INTC.PSR[113].R               /* INTC Priority Select Register */
#define INTC_PSR114          INTC.PSR[114].R               /* INTC Priority Select Register */
#define INTC_PSR115          INTC.PSR[115].R               /* INTC Priority Select Register */
#define INTC_PSR116          INTC.PSR[116].R               /* INTC Priority Select Register */
#define INTC_PSR117          INTC.PSR[117].R               /* INTC Priority Select Register */
#define INTC_PSR118          INTC.PSR[118].R               /* INTC Priority Select Register */
#define INTC_PSR119          INTC.PSR[119].R               /* INTC Priority Select Register */
#define INTC_PSR120          INTC.PSR[120].R               /* INTC Priority Select Register */
#define INTC_PSR121          INTC.PSR[121].R               /* INTC Priority Select Register */
#define INTC_PSR122          INTC.PSR[122].R               /* INTC Priority Select Register */
#define INTC_PSR123          INTC.PSR[123].R               /* INTC Priority Select Register */
#define INTC_PSR124          INTC.PSR[124].R               /* INTC Priority Select Register */
#define INTC_PSR125          INTC.PSR[125].R               /* INTC Priority Select Register */
#define INTC_PSR126          INTC.PSR[126].R               /* INTC Priority Select Register */
#define INTC_PSR127          INTC.PSR[127].R               /* INTC Priority Select Register */
#define INTC_PSR128          INTC.PSR[128].R               /* INTC Priority Select Register */
#define INTC_PSR129          INTC.PSR[129].R               /* INTC Priority Select Register */
#define INTC_PSR130          INTC.PSR[130].R               /* INTC Priority Select Register */
#define INTC_PSR131          INTC.PSR[131].R               /* INTC Priority Select Register */
#define INTC_PSR132          INTC.PSR[132].R               /* INTC Priority Select Register */
#define INTC_PSR133          INTC.PSR[133].R               /* INTC Priority Select Register */
#define INTC_PSR134          INTC.PSR[134].R               /* INTC Priority Select Register */
#define INTC_PSR135          INTC.PSR[135].R               /* INTC Priority Select Register */
#define INTC_PSR136          INTC.PSR[136].R               /* INTC Priority Select Register */
#define INTC_PSR137          INTC.PSR[137].R               /* INTC Priority Select Register */
#define INTC_PSR138          INTC.PSR[138].R               /* INTC Priority Select Register */
#define INTC_PSR139          INTC.PSR[139].R               /* INTC Priority Select Register */
#define INTC_PSR140          INTC.PSR[140].R               /* INTC Priority Select Register */
#define INTC_PSR141          INTC.PSR[141].R               /* INTC Priority Select Register */
#define INTC_PSR142          INTC.PSR[142].R               /* INTC Priority Select Register */
#define INTC_PSR143          INTC.PSR[143].R               /* INTC Priority Select Register */
#define INTC_PSR144          INTC.PSR[144].R               /* INTC Priority Select Register */
#define INTC_PSR145          INTC.PSR[145].R               /* INTC Priority Select Register */
#define INTC_PSR146          INTC.PSR[146].R               /* INTC Priority Select Register */
#define INTC_PSR147          INTC.PSR[147].R               /* INTC Priority Select Register */
#define INTC_PSR148          INTC.PSR[148].R               /* INTC Priority Select Register */
#define INTC_PSR149          INTC.PSR[149].R               /* INTC Priority Select Register */
#define INTC_PSR150          INTC.PSR[150].R               /* INTC Priority Select Register */
#define INTC_PSR151          INTC.PSR[151].R               /* INTC Priority Select Register */
#define INTC_PSR152          INTC.PSR[152].R               /* INTC Priority Select Register */
#define INTC_PSR153          INTC.PSR[153].R               /* INTC Priority Select Register */
#define INTC_PSR154          INTC.PSR[154].R               /* INTC Priority Select Register */
#define INTC_PSR155          INTC.PSR[155].R               /* INTC Priority Select Register */
#define INTC_PSR156          INTC.PSR[156].R               /* INTC Priority Select Register */
#define INTC_PSR157          INTC.PSR[157].R               /* INTC Priority Select Register */
#define INTC_PSR158          INTC.PSR[158].R               /* INTC Priority Select Register */
#define INTC_PSR159          INTC.PSR[159].R               /* INTC Priority Select Register */
#define INTC_PSR160          INTC.PSR[160].R               /* INTC Priority Select Register */
#define INTC_PSR161          INTC.PSR[161].R               /* INTC Priority Select Register */
#define INTC_PSR162          INTC.PSR[162].R               /* INTC Priority Select Register */
#define INTC_PSR163          INTC.PSR[163].R               /* INTC Priority Select Register */
#define INTC_PSR164          INTC.PSR[164].R               /* INTC Priority Select Register */
#define INTC_PSR165          INTC.PSR[165].R               /* INTC Priority Select Register */
#define INTC_PSR166          INTC.PSR[166].R               /* INTC Priority Select Register */
#define INTC_PSR167          INTC.PSR[167].R               /* INTC Priority Select Register */
#define INTC_PSR168          INTC.PSR[168].R               /* INTC Priority Select Register */
#define INTC_PSR169          INTC.PSR[169].R               /* INTC Priority Select Register */
#define INTC_PSR170          INTC.PSR[170].R               /* INTC Priority Select Register */
#define INTC_PSR171          INTC.PSR[171].R               /* INTC Priority Select Register */
#define INTC_PSR172          INTC.PSR[172].R               /* INTC Priority Select Register */
#define INTC_PSR173          INTC.PSR[173].R               /* INTC Priority Select Register */
#define INTC_PSR174          INTC.PSR[174].R               /* INTC Priority Select Register */
#define INTC_PSR175          INTC.PSR[175].R               /* INTC Priority Select Register */
#define INTC_PSR176          INTC.PSR[176].R               /* INTC Priority Select Register */
#define INTC_PSR177          INTC.PSR[177].R               /* INTC Priority Select Register */
#define INTC_PSR178          INTC.PSR[178].R               /* INTC Priority Select Register */
#define INTC_PSR179          INTC.PSR[179].R               /* INTC Priority Select Register */
#define INTC_PSR180          INTC.PSR[180].R               /* INTC Priority Select Register */
#define INTC_PSR181          INTC.PSR[181].R               /* INTC Priority Select Register */
#define INTC_PSR182          INTC.PSR[182].R               /* INTC Priority Select Register */
#define INTC_PSR183          INTC.PSR[183].R               /* INTC Priority Select Register */
#define INTC_PSR184          INTC.PSR[184].R               /* INTC Priority Select Register */
#define INTC_PSR185          INTC.PSR[185].R               /* INTC Priority Select Register */
#define INTC_PSR186          INTC.PSR[186].R               /* INTC Priority Select Register */
#define INTC_PSR187          INTC.PSR[187].R               /* INTC Priority Select Register */
#define INTC_PSR188          INTC.PSR[188].R               /* INTC Priority Select Register */
#define INTC_PSR189          INTC.PSR[189].R               /* INTC Priority Select Register */
#define INTC_PSR190          INTC.PSR[190].R               /* INTC Priority Select Register */
#define INTC_PSR191          INTC.PSR[191].R               /* INTC Priority Select Register */
#define INTC_PSR192          INTC.PSR[192].R               /* INTC Priority Select Register */
#define INTC_PSR193          INTC.PSR[193].R               /* INTC Priority Select Register */
#define INTC_PSR194          INTC.PSR[194].R               /* INTC Priority Select Register */
#define INTC_PSR195          INTC.PSR[195].R               /* INTC Priority Select Register */
#define INTC_PSR196          INTC.PSR[196].R               /* INTC Priority Select Register */
#define INTC_PSR197          INTC.PSR[197].R               /* INTC Priority Select Register */
#define INTC_PSR198          INTC.PSR[198].R               /* INTC Priority Select Register */
#define INTC_PSR199          INTC.PSR[199].R               /* INTC Priority Select Register */
#define INTC_PSR200          INTC.PSR[200].R               /* INTC Priority Select Register */
#define INTC_PSR201          INTC.PSR[201].R               /* INTC Priority Select Register */
#define INTC_PSR202          INTC.PSR[202].R               /* INTC Priority Select Register */
#define INTC_PSR203          INTC.PSR[203].R               /* INTC Priority Select Register */
#define INTC_PSR204          INTC.PSR[204].R               /* INTC Priority Select Register */
#define INTC_PSR205          INTC.PSR[205].R               /* INTC Priority Select Register */
#define INTC_PSR206          INTC.PSR[206].R               /* INTC Priority Select Register */
#define INTC_PSR207          INTC.PSR[207].R               /* INTC Priority Select Register */
#define INTC_PSR208          INTC.PSR[208].R               /* INTC Priority Select Register */
#define INTC_PSR209          INTC.PSR[209].R               /* INTC Priority Select Register */
#define INTC_PSR210          INTC.PSR[210].R               /* INTC Priority Select Register */
#define INTC_PSR211          INTC.PSR[211].R               /* INTC Priority Select Register */
#define INTC_PSR212          INTC.PSR[212].R               /* INTC Priority Select Register */
#define INTC_PSR213          INTC.PSR[213].R               /* INTC Priority Select Register */
#define INTC_PSR214          INTC.PSR[214].R               /* INTC Priority Select Register */
#define INTC_PSR215          INTC.PSR[215].R               /* INTC Priority Select Register */
#define INTC_PSR216          INTC.PSR[216].R               /* INTC Priority Select Register */
#define INTC_PSR217          INTC.PSR[217].R               /* INTC Priority Select Register */
#define INTC_PSR218          INTC.PSR[218].R               /* INTC Priority Select Register */
#define INTC_PSR219          INTC.PSR[219].R               /* INTC Priority Select Register */
#define INTC_PSR220          INTC.PSR[220].R               /* INTC Priority Select Register */
#define INTC_PSR221          INTC.PSR[221].R               /* INTC Priority Select Register */
#define INTC_PSR222          INTC.PSR[222].R               /* INTC Priority Select Register */
#define INTC_PSR223          INTC.PSR[223].R               /* INTC Priority Select Register */
#define INTC_PSR224          INTC.PSR[224].R               /* INTC Priority Select Register */
#define INTC_PSR225          INTC.PSR[225].R               /* INTC Priority Select Register */
#define INTC_PSR226          INTC.PSR[226].R               /* INTC Priority Select Register */
#define INTC_PSR227          INTC.PSR[227].R               /* INTC Priority Select Register */
#define INTC_PSR228          INTC.PSR[228].R               /* INTC Priority Select Register */
#define INTC_PSR229          INTC.PSR[229].R               /* INTC Priority Select Register */
#define INTC_PSR230          INTC.PSR[230].R               /* INTC Priority Select Register */
#define INTC_PSR231          INTC.PSR[231].R               /* INTC Priority Select Register */
#define INTC_PSR232          INTC.PSR[232].R               /* INTC Priority Select Register */
#define INTC_PSR233          INTC.PSR[233].R               /* INTC Priority Select Register */
#define INTC_PSR234          INTC.PSR[234].R               /* INTC Priority Select Register */
#define INTC_PSR235          INTC.PSR[235].R               /* INTC Priority Select Register */
#define INTC_PSR236          INTC.PSR[236].R               /* INTC Priority Select Register */
#define INTC_PSR237          INTC.PSR[237].R               /* INTC Priority Select Register */
#define INTC_PSR238          INTC.PSR[238].R               /* INTC Priority Select Register */
#define INTC_PSR239          INTC.PSR[239].R               /* INTC Priority Select Register */
#define INTC_PSR240          INTC.PSR[240].R               /* INTC Priority Select Register */
#define INTC_PSR241          INTC.PSR[241].R               /* INTC Priority Select Register */
#define INTC_PSR242          INTC.PSR[242].R               /* INTC Priority Select Register */
#define INTC_PSR243          INTC.PSR[243].R               /* INTC Priority Select Register */
#define INTC_PSR244          INTC.PSR[244].R               /* INTC Priority Select Register */
#define INTC_PSR245          INTC.PSR[245].R               /* INTC Priority Select Register */
#define INTC_PSR246          INTC.PSR[246].R               /* INTC Priority Select Register */
#define INTC_PSR247          INTC.PSR[247].R               /* INTC Priority Select Register */
#define INTC_PSR248          INTC.PSR[248].R               /* INTC Priority Select Register */
#define INTC_PSR249          INTC.PSR[249].R               /* INTC Priority Select Register */
#define INTC_PSR250          INTC.PSR[250].R               /* INTC Priority Select Register */
#define INTC_PSR251          INTC.PSR[251].R               /* INTC Priority Select Register */
#define INTC_PSR252          INTC.PSR[252].R               /* INTC Priority Select Register */
#define INTC_PSR253          INTC.PSR[253].R               /* INTC Priority Select Register */
#define INTC_PSR254          INTC.PSR[254].R               /* INTC Priority Select Register */
#define INTC_PSR255          INTC.PSR[255].R               /* INTC Priority Select Register */
#define INTC_PSR256          INTC.PSR[256].R               /* INTC Priority Select Register */
#define INTC_PSR257          INTC.PSR[257].R               /* INTC Priority Select Register */
#define INTC_PSR258          INTC.PSR[258].R               /* INTC Priority Select Register */
#define INTC_PSR259          INTC.PSR[259].R               /* INTC Priority Select Register */
#define INTC_PSR260          INTC.PSR[260].R               /* INTC Priority Select Register */
#define INTC_PSR261          INTC.PSR[261].R               /* INTC Priority Select Register */
#define INTC_PSR262          INTC.PSR[262].R               /* INTC Priority Select Register */
#define INTC_PSR263          INTC.PSR[263].R               /* INTC Priority Select Register */
#define INTC_PSR264          INTC.PSR[264].R               /* INTC Priority Select Register */
#define INTC_PSR265          INTC.PSR[265].R               /* INTC Priority Select Register */
#define INTC_PSR266          INTC.PSR[266].R               /* INTC Priority Select Register */
#define INTC_PSR267          INTC.PSR[267].R               /* INTC Priority Select Register */
#define INTC_PSR268          INTC.PSR[268].R               /* INTC Priority Select Register */
#define INTC_PSR269          INTC.PSR[269].R               /* INTC Priority Select Register */
#define INTC_PSR270          INTC.PSR[270].R               /* INTC Priority Select Register */
#define INTC_PSR271          INTC.PSR[271].R               /* INTC Priority Select Register */
#define INTC_PSR272          INTC.PSR[272].R               /* INTC Priority Select Register */
#define INTC_PSR273          INTC.PSR[273].R               /* INTC Priority Select Register */
#define INTC_PSR274          INTC.PSR[274].R               /* INTC Priority Select Register */
#define INTC_PSR275          INTC.PSR[275].R               /* INTC Priority Select Register */
#define INTC_PSR276          INTC.PSR[276].R               /* INTC Priority Select Register */
#define INTC_PSR277          INTC.PSR[277].R               /* INTC Priority Select Register */
#define INTC_PSR278          INTC.PSR[278].R               /* INTC Priority Select Register */
#define INTC_PSR279          INTC.PSR[279].R               /* INTC Priority Select Register */
#define INTC_PSR280          INTC.PSR[280].R               /* INTC Priority Select Register */
#define INTC_PSR281          INTC.PSR[281].R               /* INTC Priority Select Register */
#define INTC_PSR282          INTC.PSR[282].R               /* INTC Priority Select Register */
#define INTC_PSR283          INTC.PSR[283].R               /* INTC Priority Select Register */
#define INTC_PSR284          INTC.PSR[284].R               /* INTC Priority Select Register */
#define INTC_PSR285          INTC.PSR[285].R               /* INTC Priority Select Register */
#define INTC_PSR286          INTC.PSR[286].R               /* INTC Priority Select Register */
#define INTC_PSR287          INTC.PSR[287].R               /* INTC Priority Select Register */
#define INTC_PSR288          INTC.PSR[288].R               /* INTC Priority Select Register */
#define INTC_PSR289          INTC.PSR[289].R               /* INTC Priority Select Register */
#define INTC_PSR290          INTC.PSR[290].R               /* INTC Priority Select Register */
#define INTC_PSR291          INTC.PSR[291].R               /* INTC Priority Select Register */
#define INTC_PSR292          INTC.PSR[292].R               /* INTC Priority Select Register */
#define INTC_PSR293          INTC.PSR[293].R               /* INTC Priority Select Register */
#define INTC_PSR294          INTC.PSR[294].R               /* INTC Priority Select Register */
#define INTC_PSR295          INTC.PSR[295].R               /* INTC Priority Select Register */
#define INTC_PSR296          INTC.PSR[296].R               /* INTC Priority Select Register */
#define INTC_PSR297          INTC.PSR[297].R               /* INTC Priority Select Register */
#define INTC_PSR298          INTC.PSR[298].R               /* INTC Priority Select Register */
#define INTC_PSR299          INTC.PSR[299].R               /* INTC Priority Select Register */
#define INTC_PSR300          INTC.PSR[300].R               /* INTC Priority Select Register */
#define INTC_PSR301          INTC.PSR[301].R               /* INTC Priority Select Register */
#define INTC_PSR302          INTC.PSR[302].R               /* INTC Priority Select Register */
#define INTC_PSR303          INTC.PSR[303].R               /* INTC Priority Select Register */
#define INTC_PSR304          INTC.PSR[304].R               /* INTC Priority Select Register */
#define INTC_PSR305          INTC.PSR[305].R               /* INTC Priority Select Register */
#define INTC_PSR306          INTC.PSR[306].R               /* INTC Priority Select Register */
#define INTC_PSR307          INTC.PSR[307].R               /* INTC Priority Select Register */
#define INTC_PSR308          INTC.PSR[308].R               /* INTC Priority Select Register */
#define INTC_PSR309          INTC.PSR[309].R               /* INTC Priority Select Register */
#define INTC_PSR310          INTC.PSR[310].R               /* INTC Priority Select Register */
#define INTC_PSR311          INTC.PSR[311].R               /* INTC Priority Select Register */
#define INTC_PSR312          INTC.PSR[312].R               /* INTC Priority Select Register */
#define INTC_PSR313          INTC.PSR[313].R               /* INTC Priority Select Register */
#define INTC_PSR314          INTC.PSR[314].R               /* INTC Priority Select Register */
#define INTC_PSR315          INTC.PSR[315].R               /* INTC Priority Select Register */
#define INTC_PSR316          INTC.PSR[316].R               /* INTC Priority Select Register */
#define INTC_PSR317          INTC.PSR[317].R               /* INTC Priority Select Register */
#define INTC_PSR318          INTC.PSR[318].R               /* INTC Priority Select Register */
#define INTC_PSR319          INTC.PSR[319].R               /* INTC Priority Select Register */
#define INTC_PSR320          INTC.PSR[320].R               /* INTC Priority Select Register */
#define INTC_PSR321          INTC.PSR[321].R               /* INTC Priority Select Register */
#define INTC_PSR322          INTC.PSR[322].R               /* INTC Priority Select Register */
#define INTC_PSR323          INTC.PSR[323].R               /* INTC Priority Select Register */
#define INTC_PSR324          INTC.PSR[324].R               /* INTC Priority Select Register */
#define INTC_PSR325          INTC.PSR[325].R               /* INTC Priority Select Register */
#define INTC_PSR326          INTC.PSR[326].R               /* INTC Priority Select Register */
#define INTC_PSR327          INTC.PSR[327].R               /* INTC Priority Select Register */
#define INTC_PSR328          INTC.PSR[328].R               /* INTC Priority Select Register */
#define INTC_PSR329          INTC.PSR[329].R               /* INTC Priority Select Register */
#define INTC_PSR330          INTC.PSR[330].R               /* INTC Priority Select Register */
#define INTC_PSR331          INTC.PSR[331].R               /* INTC Priority Select Register */
#define INTC_PSR332          INTC.PSR[332].R               /* INTC Priority Select Register */
#define INTC_PSR333          INTC.PSR[333].R               /* INTC Priority Select Register */
#define INTC_PSR334          INTC.PSR[334].R               /* INTC Priority Select Register */
#define INTC_PSR335          INTC.PSR[335].R               /* INTC Priority Select Register */
#define INTC_PSR336          INTC.PSR[336].R               /* INTC Priority Select Register */
#define INTC_PSR337          INTC.PSR[337].R               /* INTC Priority Select Register */
#define INTC_PSR338          INTC.PSR[338].R               /* INTC Priority Select Register */
#define INTC_PSR339          INTC.PSR[339].R               /* INTC Priority Select Register */
#define INTC_PSR340          INTC.PSR[340].R               /* INTC Priority Select Register */
#define INTC_PSR341          INTC.PSR[341].R               /* INTC Priority Select Register */
#define INTC_PSR342          INTC.PSR[342].R               /* INTC Priority Select Register */
#define INTC_PSR343          INTC.PSR[343].R               /* INTC Priority Select Register */
#define INTC_PSR344          INTC.PSR[344].R               /* INTC Priority Select Register */
#define INTC_PSR345          INTC.PSR[345].R               /* INTC Priority Select Register */
#define INTC_PSR346          INTC.PSR[346].R               /* INTC Priority Select Register */
#define INTC_PSR347          INTC.PSR[347].R               /* INTC Priority Select Register */
#define INTC_PSR348          INTC.PSR[348].R               /* INTC Priority Select Register */
#define INTC_PSR349          INTC.PSR[349].R               /* INTC Priority Select Register */
#define INTC_PSR350          INTC.PSR[350].R               /* INTC Priority Select Register */
#define INTC_PSR351          INTC.PSR[351].R               /* INTC Priority Select Register */
#define INTC_PSR352          INTC.PSR[352].R               /* INTC Priority Select Register */
#define INTC_PSR353          INTC.PSR[353].R               /* INTC Priority Select Register */
#define INTC_PSR354          INTC.PSR[354].R               /* INTC Priority Select Register */
#define INTC_PSR355          INTC.PSR[355].R               /* INTC Priority Select Register */
#define INTC_PSR356          INTC.PSR[356].R               /* INTC Priority Select Register */
#define INTC_PSR357          INTC.PSR[357].R               /* INTC Priority Select Register */
#define INTC_PSR358          INTC.PSR[358].R               /* INTC Priority Select Register */
#define INTC_PSR359          INTC.PSR[359].R               /* INTC Priority Select Register */
#define INTC_PSR360          INTC.PSR[360].R               /* INTC Priority Select Register */
#define INTC_PSR361          INTC.PSR[361].R               /* INTC Priority Select Register */
#define INTC_PSR362          INTC.PSR[362].R               /* INTC Priority Select Register */
#define INTC_PSR363          INTC.PSR[363].R               /* INTC Priority Select Register */
#define INTC_PSR364          INTC.PSR[364].R               /* INTC Priority Select Register */
#define INTC_PSR365          INTC.PSR[365].R               /* INTC Priority Select Register */
#define INTC_PSR366          INTC.PSR[366].R               /* INTC Priority Select Register */
#define INTC_PSR367          INTC.PSR[367].R               /* INTC Priority Select Register */
#define INTC_PSR368          INTC.PSR[368].R               /* INTC Priority Select Register */
#define INTC_PSR369          INTC.PSR[369].R               /* INTC Priority Select Register */
#define INTC_PSR370          INTC.PSR[370].R               /* INTC Priority Select Register */
#define INTC_PSR371          INTC.PSR[371].R               /* INTC Priority Select Register */
#define INTC_PSR372          INTC.PSR[372].R               /* INTC Priority Select Register */
#define INTC_PSR373          INTC.PSR[373].R               /* INTC Priority Select Register */
#define INTC_PSR374          INTC.PSR[374].R               /* INTC Priority Select Register */
#define INTC_PSR375          INTC.PSR[375].R               /* INTC Priority Select Register */
#define INTC_PSR376          INTC.PSR[376].R               /* INTC Priority Select Register */
#define INTC_PSR377          INTC.PSR[377].R               /* INTC Priority Select Register */
#define INTC_PSR378          INTC.PSR[378].R               /* INTC Priority Select Register */
#define INTC_PSR379          INTC.PSR[379].R               /* INTC Priority Select Register */
#define INTC_PSR380          INTC.PSR[380].R               /* INTC Priority Select Register */
#define INTC_PSR381          INTC.PSR[381].R               /* INTC Priority Select Register */
#define INTC_PSR382          INTC.PSR[382].R               /* INTC Priority Select Register */
#define INTC_PSR383          INTC.PSR[383].R               /* INTC Priority Select Register */
#define INTC_PSR384          INTC.PSR[384].R               /* INTC Priority Select Register */
#define INTC_PSR385          INTC.PSR[385].R               /* INTC Priority Select Register */
#define INTC_PSR386          INTC.PSR[386].R               /* INTC Priority Select Register */
#define INTC_PSR387          INTC.PSR[387].R               /* INTC Priority Select Register */
#define INTC_PSR388          INTC.PSR[388].R               /* INTC Priority Select Register */
#define INTC_PSR389          INTC.PSR[389].R               /* INTC Priority Select Register */
#define INTC_PSR390          INTC.PSR[390].R               /* INTC Priority Select Register */
#define INTC_PSR391          INTC.PSR[391].R               /* INTC Priority Select Register */
#define INTC_PSR392          INTC.PSR[392].R               /* INTC Priority Select Register */
#define INTC_PSR393          INTC.PSR[393].R               /* INTC Priority Select Register */
#define INTC_PSR394          INTC.PSR[394].R               /* INTC Priority Select Register */
#define INTC_PSR395          INTC.PSR[395].R               /* INTC Priority Select Register */
#define INTC_PSR396          INTC.PSR[396].R               /* INTC Priority Select Register */
#define INTC_PSR397          INTC.PSR[397].R               /* INTC Priority Select Register */
#define INTC_PSR398          INTC.PSR[398].R               /* INTC Priority Select Register */
#define INTC_PSR399          INTC.PSR[399].R               /* INTC Priority Select Register */
#define INTC_PSR400          INTC.PSR[400].R               /* INTC Priority Select Register */
#define INTC_PSR401          INTC.PSR[401].R               /* INTC Priority Select Register */
#define INTC_PSR402          INTC.PSR[402].R               /* INTC Priority Select Register */
#define INTC_PSR403          INTC.PSR[403].R               /* INTC Priority Select Register */
#define INTC_PSR404          INTC.PSR[404].R               /* INTC Priority Select Register */
#define INTC_PSR405          INTC.PSR[405].R               /* INTC Priority Select Register */
#define INTC_PSR406          INTC.PSR[406].R               /* INTC Priority Select Register */
#define INTC_PSR407          INTC.PSR[407].R               /* INTC Priority Select Register */
#define INTC_PSR408          INTC.PSR[408].R               /* INTC Priority Select Register */
#define INTC_PSR409          INTC.PSR[409].R               /* INTC Priority Select Register */
#define INTC_PSR410          INTC.PSR[410].R               /* INTC Priority Select Register */
#define INTC_PSR411          INTC.PSR[411].R               /* INTC Priority Select Register */
#define INTC_PSR412          INTC.PSR[412].R               /* INTC Priority Select Register */
#define INTC_PSR413          INTC.PSR[413].R               /* INTC Priority Select Register */
#define INTC_PSR414          INTC.PSR[414].R               /* INTC Priority Select Register */
#define INTC_PSR415          INTC.PSR[415].R               /* INTC Priority Select Register */
#define INTC_PSR416          INTC.PSR[416].R               /* INTC Priority Select Register */
#define INTC_PSR417          INTC.PSR[417].R               /* INTC Priority Select Register */
#define INTC_PSR418          INTC.PSR[418].R               /* INTC Priority Select Register */
#define INTC_PSR419          INTC.PSR[419].R               /* INTC Priority Select Register */
#define INTC_PSR420          INTC.PSR[420].R               /* INTC Priority Select Register */
#define INTC_PSR421          INTC.PSR[421].R               /* INTC Priority Select Register */
#define INTC_PSR422          INTC.PSR[422].R               /* INTC Priority Select Register */
#define INTC_PSR423          INTC.PSR[423].R               /* INTC Priority Select Register */
#define INTC_PSR424          INTC.PSR[424].R               /* INTC Priority Select Register */
#define INTC_PSR425          INTC.PSR[425].R               /* INTC Priority Select Register */
#define INTC_PSR426          INTC.PSR[426].R               /* INTC Priority Select Register */
#define INTC_PSR427          INTC.PSR[427].R               /* INTC Priority Select Register */
#define INTC_PSR428          INTC.PSR[428].R               /* INTC Priority Select Register */
#define INTC_PSR429          INTC.PSR[429].R               /* INTC Priority Select Register */
#define INTC_PSR430          INTC.PSR[430].R               /* INTC Priority Select Register */
#define INTC_PSR431          INTC.PSR[431].R               /* INTC Priority Select Register */
#define INTC_PSR432          INTC.PSR[432].R               /* INTC Priority Select Register */
#define INTC_PSR433          INTC.PSR[433].R               /* INTC Priority Select Register */
#define INTC_PSR434          INTC.PSR[434].R               /* INTC Priority Select Register */
#define INTC_PSR435          INTC.PSR[435].R               /* INTC Priority Select Register */
#define INTC_PSR436          INTC.PSR[436].R               /* INTC Priority Select Register */
#define INTC_PSR437          INTC.PSR[437].R               /* INTC Priority Select Register */
#define INTC_PSR438          INTC.PSR[438].R               /* INTC Priority Select Register */
#define INTC_PSR439          INTC.PSR[439].R               /* INTC Priority Select Register */
#define INTC_PSR440          INTC.PSR[440].R               /* INTC Priority Select Register */
#define INTC_PSR441          INTC.PSR[441].R               /* INTC Priority Select Register */
#define INTC_PSR442          INTC.PSR[442].R               /* INTC Priority Select Register */
#define INTC_PSR443          INTC.PSR[443].R               /* INTC Priority Select Register */
#define INTC_PSR444          INTC.PSR[444].R               /* INTC Priority Select Register */
#define INTC_PSR445          INTC.PSR[445].R               /* INTC Priority Select Register */
#define INTC_PSR446          INTC.PSR[446].R               /* INTC Priority Select Register */
#define INTC_PSR447          INTC.PSR[447].R               /* INTC Priority Select Register */
#define INTC_PSR448          INTC.PSR[448].R               /* INTC Priority Select Register */
#define INTC_PSR449          INTC.PSR[449].R               /* INTC Priority Select Register */
#define INTC_PSR450          INTC.PSR[450].R               /* INTC Priority Select Register */
#define INTC_PSR451          INTC.PSR[451].R               /* INTC Priority Select Register */
#define INTC_PSR452          INTC.PSR[452].R               /* INTC Priority Select Register */
#define INTC_PSR453          INTC.PSR[453].R               /* INTC Priority Select Register */
#define INTC_PSR454          INTC.PSR[454].R               /* INTC Priority Select Register */
#define INTC_PSR455          INTC.PSR[455].R               /* INTC Priority Select Register */
#define INTC_PSR456          INTC.PSR[456].R               /* INTC Priority Select Register */
#define INTC_PSR457          INTC.PSR[457].R               /* INTC Priority Select Register */
#define INTC_PSR458          INTC.PSR[458].R               /* INTC Priority Select Register */
#define INTC_PSR459          INTC.PSR[459].R               /* INTC Priority Select Register */
#define INTC_PSR460          INTC.PSR[460].R               /* INTC Priority Select Register */
#define INTC_PSR461          INTC.PSR[461].R               /* INTC Priority Select Register */
#define INTC_PSR462          INTC.PSR[462].R               /* INTC Priority Select Register */
#define INTC_PSR463          INTC.PSR[463].R               /* INTC Priority Select Register */
#define INTC_PSR464          INTC.PSR[464].R               /* INTC Priority Select Register */
#define INTC_PSR465          INTC.PSR[465].R               /* INTC Priority Select Register */
#define INTC_PSR466          INTC.PSR[466].R               /* INTC Priority Select Register */
#define INTC_PSR467          INTC.PSR[467].R               /* INTC Priority Select Register */
#define INTC_PSR468          INTC.PSR[468].R               /* INTC Priority Select Register */
#define INTC_PSR469          INTC.PSR[469].R               /* INTC Priority Select Register */
#define INTC_PSR470          INTC.PSR[470].R               /* INTC Priority Select Register */
#define INTC_PSR471          INTC.PSR[471].R               /* INTC Priority Select Register */
#define INTC_PSR472          INTC.PSR[472].R               /* INTC Priority Select Register */
#define INTC_PSR473          INTC.PSR[473].R               /* INTC Priority Select Register */
#define INTC_PSR474          INTC.PSR[474].R               /* INTC Priority Select Register */
#define INTC_PSR475          INTC.PSR[475].R               /* INTC Priority Select Register */
#define INTC_PSR476          INTC.PSR[476].R               /* INTC Priority Select Register */
#define INTC_PSR477          INTC.PSR[477].R               /* INTC Priority Select Register */
#define INTC_PSR478          INTC.PSR[478].R               /* INTC Priority Select Register */
#define INTC_PSR479          INTC.PSR[479].R               /* INTC Priority Select Register */
#define INTC_PSR480          INTC.PSR[480].R               /* INTC Priority Select Register */
#define INTC_PSR481          INTC.PSR[481].R               /* INTC Priority Select Register */
#define INTC_PSR482          INTC.PSR[482].R               /* INTC Priority Select Register */
#define INTC_PSR483          INTC.PSR[483].R               /* INTC Priority Select Register */
#define INTC_PSR484          INTC.PSR[484].R               /* INTC Priority Select Register */
#define INTC_PSR485          INTC.PSR[485].R               /* INTC Priority Select Register */
#define INTC_PSR486          INTC.PSR[486].R               /* INTC Priority Select Register */
#define INTC_PSR487          INTC.PSR[487].R               /* INTC Priority Select Register */
#define INTC_PSR488          INTC.PSR[488].R               /* INTC Priority Select Register */
#define INTC_PSR489          INTC.PSR[489].R               /* INTC Priority Select Register */
#define INTC_PSR490          INTC.PSR[490].R               /* INTC Priority Select Register */
#define INTC_PSR491          INTC.PSR[491].R               /* INTC Priority Select Register */
#define INTC_PSR492          INTC.PSR[492].R               /* INTC Priority Select Register */
#define INTC_PSR493          INTC.PSR[493].R               /* INTC Priority Select Register */
#define INTC_PSR494          INTC.PSR[494].R               /* INTC Priority Select Register */
#define INTC_PSR495          INTC.PSR[495].R               /* INTC Priority Select Register */
#define INTC_PSR496          INTC.PSR[496].R               /* INTC Priority Select Register */
#define INTC_PSR497          INTC.PSR[497].R               /* INTC Priority Select Register */
#define INTC_PSR498          INTC.PSR[498].R               /* INTC Priority Select Register */
#define INTC_PSR499          INTC.PSR[499].R               /* INTC Priority Select Register */
#define INTC_PSR500          INTC.PSR[500].R               /* INTC Priority Select Register */
#define INTC_PSR501          INTC.PSR[501].R               /* INTC Priority Select Register */
#define INTC_PSR502          INTC.PSR[502].R               /* INTC Priority Select Register */
#define INTC_PSR503          INTC.PSR[503].R               /* INTC Priority Select Register */
#define INTC_PSR504          INTC.PSR[504].R               /* INTC Priority Select Register */
#define INTC_PSR505          INTC.PSR[505].R               /* INTC Priority Select Register */
#define INTC_PSR506          INTC.PSR[506].R               /* INTC Priority Select Register */
#define INTC_PSR507          INTC.PSR[507].R               /* INTC Priority Select Register */
#define INTC_PSR508          INTC.PSR[508].R               /* INTC Priority Select Register */
#define INTC_PSR509          INTC.PSR[509].R               /* INTC Priority Select Register */
#define INTC_PSR510          INTC.PSR[510].R               /* INTC Priority Select Register */
#define INTC_PSR511          INTC.PSR[511].R               /* INTC Priority Select Register */
#define INTC_PSR512          INTC.PSR[512].R               /* INTC Priority Select Register */
#define INTC_PSR513          INTC.PSR[513].R               /* INTC Priority Select Register */
#define INTC_PSR514          INTC.PSR[514].R               /* INTC Priority Select Register */
#define INTC_PSR515          INTC.PSR[515].R               /* INTC Priority Select Register */
#define INTC_PSR516          INTC.PSR[516].R               /* INTC Priority Select Register */
#define INTC_PSR517          INTC.PSR[517].R               /* INTC Priority Select Register */
#define INTC_PSR518          INTC.PSR[518].R               /* INTC Priority Select Register */
#define INTC_PSR519          INTC.PSR[519].R               /* INTC Priority Select Register */
#define INTC_PSR520          INTC.PSR[520].R               /* INTC Priority Select Register */
#define INTC_PSR521          INTC.PSR[521].R               /* INTC Priority Select Register */
#define INTC_PSR522          INTC.PSR[522].R               /* INTC Priority Select Register */
#define INTC_PSR523          INTC.PSR[523].R               /* INTC Priority Select Register */
#define INTC_PSR524          INTC.PSR[524].R               /* INTC Priority Select Register */
#define INTC_PSR525          INTC.PSR[525].R               /* INTC Priority Select Register */
#define INTC_PSR526          INTC.PSR[526].R               /* INTC Priority Select Register */
#define INTC_PSR527          INTC.PSR[527].R               /* INTC Priority Select Register */
#define INTC_PSR528          INTC.PSR[528].R               /* INTC Priority Select Register */
#define INTC_PSR529          INTC.PSR[529].R               /* INTC Priority Select Register */
#define INTC_PSR530          INTC.PSR[530].R               /* INTC Priority Select Register */
#define INTC_PSR531          INTC.PSR[531].R               /* INTC Priority Select Register */
#define INTC_PSR532          INTC.PSR[532].R               /* INTC Priority Select Register */
#define INTC_PSR533          INTC.PSR[533].R               /* INTC Priority Select Register */
#define INTC_PSR534          INTC.PSR[534].R               /* INTC Priority Select Register */
#define INTC_PSR535          INTC.PSR[535].R               /* INTC Priority Select Register */
#define INTC_PSR536          INTC.PSR[536].R               /* INTC Priority Select Register */
#define INTC_PSR537          INTC.PSR[537].R               /* INTC Priority Select Register */
#define INTC_PSR538          INTC.PSR[538].R               /* INTC Priority Select Register */
#define INTC_PSR539          INTC.PSR[539].R               /* INTC Priority Select Register */
#define INTC_PSR540          INTC.PSR[540].R               /* INTC Priority Select Register */
#define INTC_PSR541          INTC.PSR[541].R               /* INTC Priority Select Register */
#define INTC_PSR542          INTC.PSR[542].R               /* INTC Priority Select Register */
#define INTC_PSR543          INTC.PSR[543].R               /* INTC Priority Select Register */
#define INTC_PSR544          INTC.PSR[544].R               /* INTC Priority Select Register */
#define INTC_PSR545          INTC.PSR[545].R               /* INTC Priority Select Register */
#define INTC_PSR546          INTC.PSR[546].R               /* INTC Priority Select Register */
#define INTC_PSR547          INTC.PSR[547].R               /* INTC Priority Select Register */
#define INTC_PSR548          INTC.PSR[548].R               /* INTC Priority Select Register */
#define INTC_PSR549          INTC.PSR[549].R               /* INTC Priority Select Register */
#define INTC_PSR550          INTC.PSR[550].R               /* INTC Priority Select Register */
#define INTC_PSR551          INTC.PSR[551].R               /* INTC Priority Select Register */
#define INTC_PSR552          INTC.PSR[552].R               /* INTC Priority Select Register */
#define INTC_PSR553          INTC.PSR[553].R               /* INTC Priority Select Register */
#define INTC_PSR554          INTC.PSR[554].R               /* INTC Priority Select Register */
#define INTC_PSR555          INTC.PSR[555].R               /* INTC Priority Select Register */
#define INTC_PSR556          INTC.PSR[556].R               /* INTC Priority Select Register */
#define INTC_PSR557          INTC.PSR[557].R               /* INTC Priority Select Register */
#define INTC_PSR558          INTC.PSR[558].R               /* INTC Priority Select Register */
#define INTC_PSR559          INTC.PSR[559].R               /* INTC Priority Select Register */
#define INTC_PSR560          INTC.PSR[560].R               /* INTC Priority Select Register */
#define INTC_PSR561          INTC.PSR[561].R               /* INTC Priority Select Register */
#define INTC_PSR562          INTC.PSR[562].R               /* INTC Priority Select Register */
#define INTC_PSR563          INTC.PSR[563].R               /* INTC Priority Select Register */
#define INTC_PSR564          INTC.PSR[564].R               /* INTC Priority Select Register */
#define INTC_PSR565          INTC.PSR[565].R               /* INTC Priority Select Register */
#define INTC_PSR566          INTC.PSR[566].R               /* INTC Priority Select Register */
#define INTC_PSR567          INTC.PSR[567].R               /* INTC Priority Select Register */
#define INTC_PSR568          INTC.PSR[568].R               /* INTC Priority Select Register */
#define INTC_PSR569          INTC.PSR[569].R               /* INTC Priority Select Register */
#define INTC_PSR570          INTC.PSR[570].R               /* INTC Priority Select Register */
#define INTC_PSR571          INTC.PSR[571].R               /* INTC Priority Select Register */
#define INTC_PSR572          INTC.PSR[572].R               /* INTC Priority Select Register */
#define INTC_PSR573          INTC.PSR[573].R               /* INTC Priority Select Register */
#define INTC_PSR574          INTC.PSR[574].R               /* INTC Priority Select Register */
#define INTC_PSR575          INTC.PSR[575].R               /* INTC Priority Select Register */
#define INTC_PSR576          INTC.PSR[576].R               /* INTC Priority Select Register */
#define INTC_PSR577          INTC.PSR[577].R               /* INTC Priority Select Register */
#define INTC_PSR578          INTC.PSR[578].R               /* INTC Priority Select Register */
#define INTC_PSR579          INTC.PSR[579].R               /* INTC Priority Select Register */
#define INTC_PSR580          INTC.PSR[580].R               /* INTC Priority Select Register */
#define INTC_PSR581          INTC.PSR[581].R               /* INTC Priority Select Register */
#define INTC_PSR582          INTC.PSR[582].R               /* INTC Priority Select Register */
#define INTC_PSR583          INTC.PSR[583].R               /* INTC Priority Select Register */
#define INTC_PSR584          INTC.PSR[584].R               /* INTC Priority Select Register */
#define INTC_PSR585          INTC.PSR[585].R               /* INTC Priority Select Register */
#define INTC_PSR586          INTC.PSR[586].R               /* INTC Priority Select Register */
#define INTC_PSR587          INTC.PSR[587].R               /* INTC Priority Select Register */
#define INTC_PSR588          INTC.PSR[588].R               /* INTC Priority Select Register */
#define INTC_PSR589          INTC.PSR[589].R               /* INTC Priority Select Register */
#define INTC_PSR590          INTC.PSR[590].R               /* INTC Priority Select Register */
#define INTC_PSR591          INTC.PSR[591].R               /* INTC Priority Select Register */
#define INTC_PSR592          INTC.PSR[592].R               /* INTC Priority Select Register */
#define INTC_PSR593          INTC.PSR[593].R               /* INTC Priority Select Register */
#define INTC_PSR594          INTC.PSR[594].R               /* INTC Priority Select Register */
#define INTC_PSR595          INTC.PSR[595].R               /* INTC Priority Select Register */
#define INTC_PSR596          INTC.PSR[596].R               /* INTC Priority Select Register */
#define INTC_PSR597          INTC.PSR[597].R               /* INTC Priority Select Register */
#define INTC_PSR598          INTC.PSR[598].R               /* INTC Priority Select Register */
#define INTC_PSR599          INTC.PSR[599].R               /* INTC Priority Select Register */
#define INTC_PSR600          INTC.PSR[600].R               /* INTC Priority Select Register */
#define INTC_PSR601          INTC.PSR[601].R               /* INTC Priority Select Register */
#define INTC_PSR602          INTC.PSR[602].R               /* INTC Priority Select Register */
#define INTC_PSR603          INTC.PSR[603].R               /* INTC Priority Select Register */
#define INTC_PSR604          INTC.PSR[604].R               /* INTC Priority Select Register */
#define INTC_PSR605          INTC.PSR[605].R               /* INTC Priority Select Register */
#define INTC_PSR606          INTC.PSR[606].R               /* INTC Priority Select Register */
#define INTC_PSR607          INTC.PSR[607].R               /* INTC Priority Select Register */
#define INTC_PSR608          INTC.PSR[608].R               /* INTC Priority Select Register */
#define INTC_PSR609          INTC.PSR[609].R               /* INTC Priority Select Register */
#define INTC_PSR610          INTC.PSR[610].R               /* INTC Priority Select Register */
#define INTC_PSR611          INTC.PSR[611].R               /* INTC Priority Select Register */
#define INTC_PSR612          INTC.PSR[612].R               /* INTC Priority Select Register */
#define INTC_PSR613          INTC.PSR[613].R               /* INTC Priority Select Register */
#define INTC_PSR614          INTC.PSR[614].R               /* INTC Priority Select Register */
#define INTC_PSR615          INTC.PSR[615].R               /* INTC Priority Select Register */
#define INTC_PSR616          INTC.PSR[616].R               /* INTC Priority Select Register */
#define INTC_PSR617          INTC.PSR[617].R               /* INTC Priority Select Register */
#define INTC_PSR618          INTC.PSR[618].R               /* INTC Priority Select Register */
#define INTC_PSR619          INTC.PSR[619].R               /* INTC Priority Select Register */
#define INTC_PSR620          INTC.PSR[620].R               /* INTC Priority Select Register */
#define INTC_PSR621          INTC.PSR[621].R               /* INTC Priority Select Register */
#define INTC_PSR622          INTC.PSR[622].R               /* INTC Priority Select Register */
#define INTC_PSR623          INTC.PSR[623].R               /* INTC Priority Select Register */
#define INTC_PSR624          INTC.PSR[624].R               /* INTC Priority Select Register */
#define INTC_PSR625          INTC.PSR[625].R               /* INTC Priority Select Register */
#define INTC_PSR626          INTC.PSR[626].R               /* INTC Priority Select Register */
#define INTC_PSR627          INTC.PSR[627].R               /* INTC Priority Select Register */
#define INTC_PSR628          INTC.PSR[628].R               /* INTC Priority Select Register */
#define INTC_PSR629          INTC.PSR[629].R               /* INTC Priority Select Register */
#define INTC_PSR630          INTC.PSR[630].R               /* INTC Priority Select Register */
#define INTC_PSR631          INTC.PSR[631].R               /* INTC Priority Select Register */
#define INTC_PSR632          INTC.PSR[632].R               /* INTC Priority Select Register */
#define INTC_PSR633          INTC.PSR[633].R               /* INTC Priority Select Register */
#define INTC_PSR634          INTC.PSR[634].R               /* INTC Priority Select Register */
#define INTC_PSR635          INTC.PSR[635].R               /* INTC Priority Select Register */
#define INTC_PSR636          INTC.PSR[636].R               /* INTC Priority Select Register */
#define INTC_PSR637          INTC.PSR[637].R               /* INTC Priority Select Register */
#define INTC_PSR638          INTC.PSR[638].R               /* INTC Priority Select Register */
#define INTC_PSR639          INTC.PSR[639].R               /* INTC Priority Select Register */
#define INTC_PSR640          INTC.PSR[640].R               /* INTC Priority Select Register */
#define INTC_PSR641          INTC.PSR[641].R               /* INTC Priority Select Register */
#define INTC_PSR642          INTC.PSR[642].R               /* INTC Priority Select Register */
#define INTC_PSR643          INTC.PSR[643].R               /* INTC Priority Select Register */
#define INTC_PSR644          INTC.PSR[644].R               /* INTC Priority Select Register */
#define INTC_PSR645          INTC.PSR[645].R               /* INTC Priority Select Register */
#define INTC_PSR646          INTC.PSR[646].R               /* INTC Priority Select Register */
#define INTC_PSR647          INTC.PSR[647].R               /* INTC Priority Select Register */
#define INTC_PSR648          INTC.PSR[648].R               /* INTC Priority Select Register */
#define INTC_PSR649          INTC.PSR[649].R               /* INTC Priority Select Register */
#define INTC_PSR650          INTC.PSR[650].R               /* INTC Priority Select Register */
#define INTC_PSR651          INTC.PSR[651].R               /* INTC Priority Select Register */
#define INTC_PSR652          INTC.PSR[652].R               /* INTC Priority Select Register */
#define INTC_PSR653          INTC.PSR[653].R               /* INTC Priority Select Register */
#define INTC_PSR654          INTC.PSR[654].R               /* INTC Priority Select Register */
#define INTC_PSR655          INTC.PSR[655].R               /* INTC Priority Select Register */
#define INTC_PSR656          INTC.PSR[656].R               /* INTC Priority Select Register */
#define INTC_PSR657          INTC.PSR[657].R               /* INTC Priority Select Register */
#define INTC_PSR658          INTC.PSR[658].R               /* INTC Priority Select Register */
#define INTC_PSR659          INTC.PSR[659].R               /* INTC Priority Select Register */
#define INTC_PSR660          INTC.PSR[660].R               /* INTC Priority Select Register */
#define INTC_PSR661          INTC.PSR[661].R               /* INTC Priority Select Register */
#define INTC_PSR662          INTC.PSR[662].R               /* INTC Priority Select Register */
#define INTC_PSR663          INTC.PSR[663].R               /* INTC Priority Select Register */
#define INTC_PSR664          INTC.PSR[664].R               /* INTC Priority Select Register */
#define INTC_PSR665          INTC.PSR[665].R               /* INTC Priority Select Register */
#define INTC_PSR666          INTC.PSR[666].R               /* INTC Priority Select Register */
#define INTC_PSR667          INTC.PSR[667].R               /* INTC Priority Select Register */
#define INTC_PSR668          INTC.PSR[668].R               /* INTC Priority Select Register */
#define INTC_PSR669          INTC.PSR[669].R               /* INTC Priority Select Register */
#define INTC_PSR670          INTC.PSR[670].R               /* INTC Priority Select Register */
#define INTC_PSR671          INTC.PSR[671].R               /* INTC Priority Select Register */
#define INTC_PSR672          INTC.PSR[672].R               /* INTC Priority Select Register */
#define INTC_PSR673          INTC.PSR[673].R               /* INTC Priority Select Register */
#define INTC_PSR674          INTC.PSR[674].R               /* INTC Priority Select Register */
#define INTC_PSR675          INTC.PSR[675].R               /* INTC Priority Select Register */
#define INTC_PSR676          INTC.PSR[676].R               /* INTC Priority Select Register */
#define INTC_PSR677          INTC.PSR[677].R               /* INTC Priority Select Register */
#define INTC_PSR678          INTC.PSR[678].R               /* INTC Priority Select Register */
#define INTC_PSR679          INTC.PSR[679].R               /* INTC Priority Select Register */
#define INTC_PSR680          INTC.PSR[680].R               /* INTC Priority Select Register */
#define INTC_PSR681          INTC.PSR[681].R               /* INTC Priority Select Register */
#define INTC_PSR682          INTC.PSR[682].R               /* INTC Priority Select Register */
#define INTC_PSR683          INTC.PSR[683].R               /* INTC Priority Select Register */
#define INTC_PSR684          INTC.PSR[684].R               /* INTC Priority Select Register */
#define INTC_PSR685          INTC.PSR[685].R               /* INTC Priority Select Register */
#define INTC_PSR686          INTC.PSR[686].R               /* INTC Priority Select Register */
#define INTC_PSR687          INTC.PSR[687].R               /* INTC Priority Select Register */
#define INTC_PSR688          INTC.PSR[688].R               /* INTC Priority Select Register */
#define INTC_PSR689          INTC.PSR[689].R               /* INTC Priority Select Register */
#define INTC_PSR690          INTC.PSR[690].R               /* INTC Priority Select Register */
#define INTC_PSR691          INTC.PSR[691].R               /* INTC Priority Select Register */
#define INTC_PSR692          INTC.PSR[692].R               /* INTC Priority Select Register */
#define INTC_PSR693          INTC.PSR[693].R               /* INTC Priority Select Register */
#define INTC_PSR694          INTC.PSR[694].R               /* INTC Priority Select Register */
#define INTC_PSR695          INTC.PSR[695].R               /* INTC Priority Select Register */
#define INTC_PSR696          INTC.PSR[696].R               /* INTC Priority Select Register */
#define INTC_PSR697          INTC.PSR[697].R               /* INTC Priority Select Register */
#define INTC_PSR698          INTC.PSR[698].R               /* INTC Priority Select Register */
#define INTC_PSR699          INTC.PSR[699].R               /* INTC Priority Select Register */
#define INTC_PSR700          INTC.PSR[700].R               /* INTC Priority Select Register */
#define INTC_PSR701          INTC.PSR[701].R               /* INTC Priority Select Register */
#define INTC_PSR702          INTC.PSR[702].R               /* INTC Priority Select Register */
#define INTC_PSR703          INTC.PSR[703].R               /* INTC Priority Select Register */
#define INTC_PSR704          INTC.PSR[704].R               /* INTC Priority Select Register */
#define INTC_PSR705          INTC.PSR[705].R               /* INTC Priority Select Register */
#define INTC_PSR706          INTC.PSR[706].R               /* INTC Priority Select Register */
#define INTC_PSR707          INTC.PSR[707].R               /* INTC Priority Select Register */
#define INTC_PSR708          INTC.PSR[708].R               /* INTC Priority Select Register */
#define INTC_PSR709          INTC.PSR[709].R               /* INTC Priority Select Register */
#define INTC_PSR710          INTC.PSR[710].R               /* INTC Priority Select Register */
#define INTC_PSR711          INTC.PSR[711].R               /* INTC Priority Select Register */
#define INTC_PSR712          INTC.PSR[712].R               /* INTC Priority Select Register */
#define INTC_PSR713          INTC.PSR[713].R               /* INTC Priority Select Register */
#define INTC_PSR714          INTC.PSR[714].R               /* INTC Priority Select Register */
#define INTC_PSR715          INTC.PSR[715].R               /* INTC Priority Select Register */
#define INTC_PSR716          INTC.PSR[716].R               /* INTC Priority Select Register */
#define INTC_PSR717          INTC.PSR[717].R               /* INTC Priority Select Register */
#define INTC_PSR718          INTC.PSR[718].R               /* INTC Priority Select Register */
#define INTC_PSR719          INTC.PSR[719].R               /* INTC Priority Select Register */
#define INTC_PSR720          INTC.PSR[720].R               /* INTC Priority Select Register */
#define INTC_PSR721          INTC.PSR[721].R               /* INTC Priority Select Register */
#define INTC_PSR722          INTC.PSR[722].R               /* INTC Priority Select Register */
#define INTC_PSR723          INTC.PSR[723].R               /* INTC Priority Select Register */
#define INTC_PSR724          INTC.PSR[724].R               /* INTC Priority Select Register */
#define INTC_PSR725          INTC.PSR[725].R               /* INTC Priority Select Register */
#define INTC_PSR726          INTC.PSR[726].R               /* INTC Priority Select Register */
#define INTC_PSR727          INTC.PSR[727].R               /* INTC Priority Select Register */
#define INTC_PSR728          INTC.PSR[728].R               /* INTC Priority Select Register */
#define INTC_PSR729          INTC.PSR[729].R               /* INTC Priority Select Register */
#define INTC_PSR730          INTC.PSR[730].R               /* INTC Priority Select Register */
#define INTC_PSR731          INTC.PSR[731].R               /* INTC Priority Select Register */
#define INTC_PSR732          INTC.PSR[732].R               /* INTC Priority Select Register */
#define INTC_PSR733          INTC.PSR[733].R               /* INTC Priority Select Register */
#define INTC_PSR734          INTC.PSR[734].R               /* INTC Priority Select Register */
#define INTC_PSR735          INTC.PSR[735].R               /* INTC Priority Select Register */
#define INTC_PSR736          INTC.PSR[736].R               /* INTC Priority Select Register */
#define INTC_PSR737          INTC.PSR[737].R               /* INTC Priority Select Register */
#define INTC_PSR738          INTC.PSR[738].R               /* INTC Priority Select Register */
#define INTC_PSR739          INTC.PSR[739].R               /* INTC Priority Select Register */
#define INTC_PSR740          INTC.PSR[740].R               /* INTC Priority Select Register */
#define INTC_PSR741          INTC.PSR[741].R               /* INTC Priority Select Register */
#define INTC_PSR742          INTC.PSR[742].R               /* INTC Priority Select Register */
#define INTC_PSR743          INTC.PSR[743].R               /* INTC Priority Select Register */
#define INTC_PSR744          INTC.PSR[744].R               /* INTC Priority Select Register */
#define INTC_PSR745          INTC.PSR[745].R               /* INTC Priority Select Register */
#define INTC_PSR746          INTC.PSR[746].R               /* INTC Priority Select Register */
#define INTC_PSR747          INTC.PSR[747].R               /* INTC Priority Select Register */
#define INTC_PSR748          INTC.PSR[748].R               /* INTC Priority Select Register */
#define INTC_PSR749          INTC.PSR[749].R               /* INTC Priority Select Register */
#define INTC_PSR750          INTC.PSR[750].R               /* INTC Priority Select Register */
#define INTC_PSR751          INTC.PSR[751].R               /* INTC Priority Select Register */
#define INTC_PSR752          INTC.PSR[752].R               /* INTC Priority Select Register */
#define INTC_PSR753          INTC.PSR[753].R               /* INTC Priority Select Register */
#define INTC_PSR754          INTC.PSR[754].R               /* INTC Priority Select Register */
#define INTC_PSR755          INTC.PSR[755].R               /* INTC Priority Select Register */
#define INTC_PSR756          INTC.PSR[756].R               /* INTC Priority Select Register */
#define INTC_PSR757          INTC.PSR[757].R               /* INTC Priority Select Register */
#define INTC_PSR758          INTC.PSR[758].R               /* INTC Priority Select Register */
#define INTC_PSR759          INTC.PSR[759].R               /* INTC Priority Select Register */
#define INTC_PSR760          INTC.PSR[760].R               /* INTC Priority Select Register */
#define INTC_PSR761          INTC.PSR[761].R               /* INTC Priority Select Register */
#define INTC_PSR762          INTC.PSR[762].R               /* INTC Priority Select Register */
#define INTC_PSR763          INTC.PSR[763].R               /* INTC Priority Select Register */
#define INTC_PSR764          INTC.PSR[764].R               /* INTC Priority Select Register */
#define INTC_PSR765          INTC.PSR[765].R               /* INTC Priority Select Register */
#define INTC_PSR766          INTC.PSR[766].R               /* INTC Priority Select Register */
#define INTC_PSR767          INTC.PSR[767].R               /* INTC Priority Select Register */
#define INTC_PSR768          INTC.PSR[768].R               /* INTC Priority Select Register */
#define INTC_PSR769          INTC.PSR[769].R               /* INTC Priority Select Register */
#define INTC_PSR770          INTC.PSR[770].R               /* INTC Priority Select Register */
#define INTC_PSR771          INTC.PSR[771].R               /* INTC Priority Select Register */
#define INTC_PSR772          INTC.PSR[772].R               /* INTC Priority Select Register */
#define INTC_PSR773          INTC.PSR[773].R               /* INTC Priority Select Register */
#define INTC_PSR774          INTC.PSR[774].R               /* INTC Priority Select Register */
#define INTC_PSR775          INTC.PSR[775].R               /* INTC Priority Select Register */
#define INTC_PSR776          INTC.PSR[776].R               /* INTC Priority Select Register */
#define INTC_PSR777          INTC.PSR[777].R               /* INTC Priority Select Register */
#define INTC_PSR778          INTC.PSR[778].R               /* INTC Priority Select Register */
#define INTC_PSR779          INTC.PSR[779].R               /* INTC Priority Select Register */
#define INTC_PSR780          INTC.PSR[780].R               /* INTC Priority Select Register */
#define INTC_PSR781          INTC.PSR[781].R               /* INTC Priority Select Register */
#define INTC_PSR782          INTC.PSR[782].R               /* INTC Priority Select Register */
#define INTC_PSR783          INTC.PSR[783].R               /* INTC Priority Select Register */
#define INTC_PSR784          INTC.PSR[784].R               /* INTC Priority Select Register */
#define INTC_PSR785          INTC.PSR[785].R               /* INTC Priority Select Register */
#define INTC_PSR786          INTC.PSR[786].R               /* INTC Priority Select Register */
#define INTC_PSR787          INTC.PSR[787].R               /* INTC Priority Select Register */
#define INTC_PSR788          INTC.PSR[788].R               /* INTC Priority Select Register */
#define INTC_PSR789          INTC.PSR[789].R               /* INTC Priority Select Register */
#define INTC_PSR790          INTC.PSR[790].R               /* INTC Priority Select Register */
#define INTC_PSR791          INTC.PSR[791].R               /* INTC Priority Select Register */
#define INTC_PSR792          INTC.PSR[792].R               /* INTC Priority Select Register */
#define INTC_PSR793          INTC.PSR[793].R               /* INTC Priority Select Register */
#define INTC_PSR794          INTC.PSR[794].R               /* INTC Priority Select Register */
#define INTC_PSR795          INTC.PSR[795].R               /* INTC Priority Select Register */
#define INTC_PSR796          INTC.PSR[796].R               /* INTC Priority Select Register */
#define INTC_PSR797          INTC.PSR[797].R               /* INTC Priority Select Register */
#define INTC_PSR798          INTC.PSR[798].R               /* INTC Priority Select Register */
#define INTC_PSR799          INTC.PSR[799].R               /* INTC Priority Select Register */
#define INTC_PSR800          INTC.PSR[800].R               /* INTC Priority Select Register */
#define INTC_PSR801          INTC.PSR[801].R               /* INTC Priority Select Register */
#define INTC_PSR802          INTC.PSR[802].R               /* INTC Priority Select Register */
#define INTC_PSR803          INTC.PSR[803].R               /* INTC Priority Select Register */
#define INTC_PSR804          INTC.PSR[804].R               /* INTC Priority Select Register */
#define INTC_PSR805          INTC.PSR[805].R               /* INTC Priority Select Register */
#define INTC_PSR806          INTC.PSR[806].R               /* INTC Priority Select Register */
#define INTC_PSR807          INTC.PSR[807].R               /* INTC Priority Select Register */
#define INTC_PSR808          INTC.PSR[808].R               /* INTC Priority Select Register */
#define INTC_PSR809          INTC.PSR[809].R               /* INTC Priority Select Register */
#define INTC_PSR810          INTC.PSR[810].R               /* INTC Priority Select Register */
#define INTC_PSR811          INTC.PSR[811].R               /* INTC Priority Select Register */
#define INTC_PSR812          INTC.PSR[812].R               /* INTC Priority Select Register */
#define INTC_PSR813          INTC.PSR[813].R               /* INTC Priority Select Register */
#define INTC_PSR814          INTC.PSR[814].R               /* INTC Priority Select Register */
#define INTC_PSR815          INTC.PSR[815].R               /* INTC Priority Select Register */
#define INTC_PSR816          INTC.PSR[816].R               /* INTC Priority Select Register */
#define INTC_PSR817          INTC.PSR[817].R               /* INTC Priority Select Register */
#define INTC_PSR818          INTC.PSR[818].R               /* INTC Priority Select Register */
#define INTC_PSR819          INTC.PSR[819].R               /* INTC Priority Select Register */
#define INTC_PSR820          INTC.PSR[820].R               /* INTC Priority Select Register */
#define INTC_PSR821          INTC.PSR[821].R               /* INTC Priority Select Register */
#define INTC_PSR822          INTC.PSR[822].R               /* INTC Priority Select Register */
#define INTC_PSR823          INTC.PSR[823].R               /* INTC Priority Select Register */
#define INTC_PSR824          INTC.PSR[824].R               /* INTC Priority Select Register */
#define INTC_PSR825          INTC.PSR[825].R               /* INTC Priority Select Register */
#define INTC_PSR826          INTC.PSR[826].R               /* INTC Priority Select Register */
#define INTC_PSR827          INTC.PSR[827].R               /* INTC Priority Select Register */
#define INTC_PSR828          INTC.PSR[828].R               /* INTC Priority Select Register */
#define INTC_PSR829          INTC.PSR[829].R               /* INTC Priority Select Register */
#define INTC_PSR830          INTC.PSR[830].R               /* INTC Priority Select Register */
#define INTC_PSR831          INTC.PSR[831].R               /* INTC Priority Select Register */
#define INTC_PSR832          INTC.PSR[832].R               /* INTC Priority Select Register */
#define INTC_PSR833          INTC.PSR[833].R               /* INTC Priority Select Register */
#define INTC_PSR834          INTC.PSR[834].R               /* INTC Priority Select Register */
#define INTC_PSR835          INTC.PSR[835].R               /* INTC Priority Select Register */
#define INTC_PSR836          INTC.PSR[836].R               /* INTC Priority Select Register */
#define INTC_PSR837          INTC.PSR[837].R               /* INTC Priority Select Register */
#define INTC_PSR838          INTC.PSR[838].R               /* INTC Priority Select Register */
#define INTC_PSR839          INTC.PSR[839].R               /* INTC Priority Select Register */
#define INTC_PSR840          INTC.PSR[840].R               /* INTC Priority Select Register */
#define INTC_PSR841          INTC.PSR[841].R               /* INTC Priority Select Register */
#define INTC_PSR842          INTC.PSR[842].R               /* INTC Priority Select Register */
#define INTC_PSR843          INTC.PSR[843].R               /* INTC Priority Select Register */
#define INTC_PSR844          INTC.PSR[844].R               /* INTC Priority Select Register */
#define INTC_PSR845          INTC.PSR[845].R               /* INTC Priority Select Register */
#define INTC_PSR846          INTC.PSR[846].R               /* INTC Priority Select Register */
#define INTC_PSR847          INTC.PSR[847].R               /* INTC Priority Select Register */
#define INTC_PSR848          INTC.PSR[848].R               /* INTC Priority Select Register */
#define INTC_PSR849          INTC.PSR[849].R               /* INTC Priority Select Register */
#define INTC_PSR850          INTC.PSR[850].R               /* INTC Priority Select Register */
#define INTC_PSR851          INTC.PSR[851].R               /* INTC Priority Select Register */
#define INTC_PSR852          INTC.PSR[852].R               /* INTC Priority Select Register */
#define INTC_PSR853          INTC.PSR[853].R               /* INTC Priority Select Register */
#define INTC_PSR854          INTC.PSR[854].R               /* INTC Priority Select Register */
#define INTC_PSR855          INTC.PSR[855].R               /* INTC Priority Select Register */
#define INTC_PSR856          INTC.PSR[856].R               /* INTC Priority Select Register */
#define INTC_PSR857          INTC.PSR[857].R               /* INTC Priority Select Register */
#define INTC_PSR858          INTC.PSR[858].R               /* INTC Priority Select Register */
#define INTC_PSR859          INTC.PSR[859].R               /* INTC Priority Select Register */
#define INTC_PSR860          INTC.PSR[860].R               /* INTC Priority Select Register */
#define INTC_PSR861          INTC.PSR[861].R               /* INTC Priority Select Register */
#define INTC_PSR862          INTC.PSR[862].R               /* INTC Priority Select Register */
#define INTC_PSR863          INTC.PSR[863].R               /* INTC Priority Select Register */
#define INTC_PSR864          INTC.PSR[864].R               /* INTC Priority Select Register */
#define INTC_PSR865          INTC.PSR[865].R               /* INTC Priority Select Register */
#define INTC_PSR866          INTC.PSR[866].R               /* INTC Priority Select Register */
#define INTC_PSR867          INTC.PSR[867].R               /* INTC Priority Select Register */
#define INTC_PSR868          INTC.PSR[868].R               /* INTC Priority Select Register */
#define INTC_PSR869          INTC.PSR[869].R               /* INTC Priority Select Register */
#define INTC_PSR870          INTC.PSR[870].R               /* INTC Priority Select Register */
#define INTC_PSR871          INTC.PSR[871].R               /* INTC Priority Select Register */
#define INTC_PSR872          INTC.PSR[872].R               /* INTC Priority Select Register */
#define INTC_PSR873          INTC.PSR[873].R               /* INTC Priority Select Register */
#define INTC_PSR874          INTC.PSR[874].R               /* INTC Priority Select Register */
#define INTC_PSR875          INTC.PSR[875].R               /* INTC Priority Select Register */
#define INTC_PSR876          INTC.PSR[876].R               /* INTC Priority Select Register */
#define INTC_PSR877          INTC.PSR[877].R               /* INTC Priority Select Register */
#define INTC_PSR878          INTC.PSR[878].R               /* INTC Priority Select Register */
#define INTC_PSR879          INTC.PSR[879].R               /* INTC Priority Select Register */
#define INTC_PSR880          INTC.PSR[880].R               /* INTC Priority Select Register */
#define INTC_PSR881          INTC.PSR[881].R               /* INTC Priority Select Register */
#define INTC_PSR882          INTC.PSR[882].R               /* INTC Priority Select Register */
#define INTC_PSR883          INTC.PSR[883].R               /* INTC Priority Select Register */
#define INTC_PSR884          INTC.PSR[884].R               /* INTC Priority Select Register */
#define INTC_PSR885          INTC.PSR[885].R               /* INTC Priority Select Register */
#define INTC_PSR886          INTC.PSR[886].R               /* INTC Priority Select Register */
#define INTC_PSR887          INTC.PSR[887].R               /* INTC Priority Select Register */
#define INTC_PSR888          INTC.PSR[888].R               /* INTC Priority Select Register */
#define INTC_PSR889          INTC.PSR[889].R               /* INTC Priority Select Register */
#define INTC_PSR890          INTC.PSR[890].R               /* INTC Priority Select Register */
#define INTC_PSR891          INTC.PSR[891].R               /* INTC Priority Select Register */
#define INTC_PSR892          INTC.PSR[892].R               /* INTC Priority Select Register */
#define INTC_PSR893          INTC.PSR[893].R               /* INTC Priority Select Register */
#define INTC_PSR894          INTC.PSR[894].R               /* INTC Priority Select Register */
#define INTC_PSR895          INTC.PSR[895].R               /* INTC Priority Select Register */
#define INTC_PSR896          INTC.PSR[896].R               /* INTC Priority Select Register */
#define INTC_PSR897          INTC.PSR[897].R               /* INTC Priority Select Register */
#define INTC_PSR898          INTC.PSR[898].R               /* INTC Priority Select Register */
#define INTC_PSR899          INTC.PSR[899].R               /* INTC Priority Select Register */
#define INTC_PSR900          INTC.PSR[900].R               /* INTC Priority Select Register */
#define INTC_PSR901          INTC.PSR[901].R               /* INTC Priority Select Register */
#define INTC_PSR902          INTC.PSR[902].R               /* INTC Priority Select Register */
#define INTC_PSR903          INTC.PSR[903].R               /* INTC Priority Select Register */
#define INTC_PSR904          INTC.PSR[904].R               /* INTC Priority Select Register */
#define INTC_PSR905          INTC.PSR[905].R               /* INTC Priority Select Register */
#define INTC_PSR906          INTC.PSR[906].R               /* INTC Priority Select Register */
#define INTC_PSR907          INTC.PSR[907].R               /* INTC Priority Select Register */
#define INTC_PSR908          INTC.PSR[908].R               /* INTC Priority Select Register */
#define INTC_PSR909          INTC.PSR[909].R               /* INTC Priority Select Register */
#define INTC_PSR910          INTC.PSR[910].R               /* INTC Priority Select Register */
#define INTC_PSR911          INTC.PSR[911].R               /* INTC Priority Select Register */
#define INTC_PSR912          INTC.PSR[912].R               /* INTC Priority Select Register */
#define INTC_PSR913          INTC.PSR[913].R               /* INTC Priority Select Register */
#define INTC_PSR914          INTC.PSR[914].R               /* INTC Priority Select Register */
#define INTC_PSR915          INTC.PSR[915].R               /* INTC Priority Select Register */
#define INTC_PSR916          INTC.PSR[916].R               /* INTC Priority Select Register */
#define INTC_PSR917          INTC.PSR[917].R               /* INTC Priority Select Register */
#define INTC_PSR918          INTC.PSR[918].R               /* INTC Priority Select Register */
#define INTC_PSR919          INTC.PSR[919].R               /* INTC Priority Select Register */
#define INTC_PSR920          INTC.PSR[920].R               /* INTC Priority Select Register */
#define INTC_PSR921          INTC.PSR[921].R               /* INTC Priority Select Register */
#define INTC_PSR922          INTC.PSR[922].R               /* INTC Priority Select Register */
#define INTC_PSR923          INTC.PSR[923].R               /* INTC Priority Select Register */
#define INTC_PSR924          INTC.PSR[924].R               /* INTC Priority Select Register */
#define INTC_PSR925          INTC.PSR[925].R               /* INTC Priority Select Register */
#define INTC_PSR926          INTC.PSR[926].R               /* INTC Priority Select Register */
#define INTC_PSR927          INTC.PSR[927].R               /* INTC Priority Select Register */
#define INTC_PSR928          INTC.PSR[928].R               /* INTC Priority Select Register */
#define INTC_PSR929          INTC.PSR[929].R               /* INTC Priority Select Register */
#define INTC_PSR930          INTC.PSR[930].R               /* INTC Priority Select Register */
#define INTC_PSR931          INTC.PSR[931].R               /* INTC Priority Select Register */
#define INTC_PSR932          INTC.PSR[932].R               /* INTC Priority Select Register */
#define INTC_PSR933          INTC.PSR[933].R               /* INTC Priority Select Register */
#define INTC_PSR934          INTC.PSR[934].R               /* INTC Priority Select Register */
#define INTC_PSR935          INTC.PSR[935].R               /* INTC Priority Select Register */
#define INTC_PSR936          INTC.PSR[936].R               /* INTC Priority Select Register */
#define INTC_PSR937          INTC.PSR[937].R               /* INTC Priority Select Register */
#define INTC_PSR938          INTC.PSR[938].R               /* INTC Priority Select Register */
#define INTC_PSR939          INTC.PSR[939].R               /* INTC Priority Select Register */
#define INTC_PSR940          INTC.PSR[940].R               /* INTC Priority Select Register */
#define INTC_PSR941          INTC.PSR[941].R               /* INTC Priority Select Register */
#define INTC_PSR942          INTC.PSR[942].R               /* INTC Priority Select Register */
#define INTC_PSR943          INTC.PSR[943].R               /* INTC Priority Select Register */
#define INTC_PSR944          INTC.PSR[944].R               /* INTC Priority Select Register */
#define INTC_PSR945          INTC.PSR[945].R               /* INTC Priority Select Register */
#define INTC_PSR946          INTC.PSR[946].R               /* INTC Priority Select Register */
#define INTC_PSR947          INTC.PSR[947].R               /* INTC Priority Select Register */
#define INTC_PSR948          INTC.PSR[948].R               /* INTC Priority Select Register */
#define INTC_PSR949          INTC.PSR[949].R               /* INTC Priority Select Register */
#define INTC_PSR950          INTC.PSR[950].R               /* INTC Priority Select Register */
#define INTC_PSR951          INTC.PSR[951].R               /* INTC Priority Select Register */
#define INTC_PSR952          INTC.PSR[952].R               /* INTC Priority Select Register */
#define INTC_PSR953          INTC.PSR[953].R               /* INTC Priority Select Register */
#define INTC_PSR954          INTC.PSR[954].R               /* INTC Priority Select Register */
#define INTC_PSR955          INTC.PSR[955].R               /* INTC Priority Select Register */
#define INTC_PSR956          INTC.PSR[956].R               /* INTC Priority Select Register */
#define INTC_PSR957          INTC.PSR[957].R               /* INTC Priority Select Register */
#define INTC_PSR958          INTC.PSR[958].R               /* INTC Priority Select Register */
#define INTC_PSR959          INTC.PSR[959].R               /* INTC Priority Select Register */
#define INTC_PSR960          INTC.PSR[960].R               /* INTC Priority Select Register */
#define INTC_PSR961          INTC.PSR[961].R               /* INTC Priority Select Register */
#define INTC_PSR962          INTC.PSR[962].R               /* INTC Priority Select Register */
#define INTC_PSR963          INTC.PSR[963].R               /* INTC Priority Select Register */
#define INTC_PSR964          INTC.PSR[964].R               /* INTC Priority Select Register */
#define INTC_PSR965          INTC.PSR[965].R               /* INTC Priority Select Register */
#define INTC_PSR966          INTC.PSR[966].R               /* INTC Priority Select Register */
#define INTC_PSR967          INTC.PSR[967].R               /* INTC Priority Select Register */
#define INTC_PSR968          INTC.PSR[968].R               /* INTC Priority Select Register */
#define INTC_PSR969          INTC.PSR[969].R               /* INTC Priority Select Register */
#define INTC_PSR970          INTC.PSR[970].R               /* INTC Priority Select Register */
#define INTC_PSR971          INTC.PSR[971].R               /* INTC Priority Select Register */
#define INTC_PSR972          INTC.PSR[972].R               /* INTC Priority Select Register */
#define INTC_PSR973          INTC.PSR[973].R               /* INTC Priority Select Register */
#define INTC_PSR974          INTC.PSR[974].R               /* INTC Priority Select Register */
#define INTC_PSR975          INTC.PSR[975].R               /* INTC Priority Select Register */
#define INTC_PSR976          INTC.PSR[976].R               /* INTC Priority Select Register */
#define INTC_PSR977          INTC.PSR[977].R               /* INTC Priority Select Register */
#define INTC_PSR978          INTC.PSR[978].R               /* INTC Priority Select Register */
#define INTC_PSR979          INTC.PSR[979].R               /* INTC Priority Select Register */
#define INTC_PSR980          INTC.PSR[980].R               /* INTC Priority Select Register */
#define INTC_PSR981          INTC.PSR[981].R               /* INTC Priority Select Register */
#define INTC_PSR982          INTC.PSR[982].R               /* INTC Priority Select Register */
#define INTC_PSR983          INTC.PSR[983].R               /* INTC Priority Select Register */
#define INTC_PSR984          INTC.PSR[984].R               /* INTC Priority Select Register */
#define INTC_PSR985          INTC.PSR[985].R               /* INTC Priority Select Register */
#define INTC_PSR986          INTC.PSR[986].R               /* INTC Priority Select Register */
#define INTC_PSR987          INTC.PSR[987].R               /* INTC Priority Select Register */
#define INTC_PSR988          INTC.PSR[988].R               /* INTC Priority Select Register */
#define INTC_PSR989          INTC.PSR[989].R               /* INTC Priority Select Register */
#define INTC_PSR990          INTC.PSR[990].R               /* INTC Priority Select Register */
#define INTC_PSR991          INTC.PSR[991].R               /* INTC Priority Select Register */
#define INTC_PSR992          INTC.PSR[992].R               /* INTC Priority Select Register */
#define INTC_PSR993          INTC.PSR[993].R               /* INTC Priority Select Register */
#define INTC_PSR994          INTC.PSR[994].R               /* INTC Priority Select Register */
#define INTC_PSR995          INTC.PSR[995].R               /* INTC Priority Select Register */
#define INTC_PSR996          INTC.PSR[996].R               /* INTC Priority Select Register */
#define INTC_PSR997          INTC.PSR[997].R               /* INTC Priority Select Register */
#define INTC_PSR998          INTC.PSR[998].R               /* INTC Priority Select Register */
#define INTC_PSR999          INTC.PSR[999].R               /* INTC Priority Select Register */
#define INTC_PSR1000         INTC.PSR[1000].R              /* INTC Priority Select Register */
#define INTC_PSR1001         INTC.PSR[1001].R              /* INTC Priority Select Register */
#define INTC_PSR1002         INTC.PSR[1002].R              /* INTC Priority Select Register */
#define INTC_PSR1003         INTC.PSR[1003].R              /* INTC Priority Select Register */
#define INTC_PSR1004         INTC.PSR[1004].R              /* INTC Priority Select Register */
#define INTC_PSR1005         INTC.PSR[1005].R              /* INTC Priority Select Register */
#define INTC_PSR1006         INTC.PSR[1006].R              /* INTC Priority Select Register */
#define INTC_PSR1007         INTC.PSR[1007].R              /* INTC Priority Select Register */
#define INTC_PSR1008         INTC.PSR[1008].R              /* INTC Priority Select Register */
#define INTC_PSR1009         INTC.PSR[1009].R              /* INTC Priority Select Register */
#define INTC_PSR1010         INTC.PSR[1010].R              /* INTC Priority Select Register */
#define INTC_PSR1011         INTC.PSR[1011].R              /* INTC Priority Select Register */
#define INTC_PSR1012         INTC.PSR[1012].R              /* INTC Priority Select Register */
#define INTC_PSR1013         INTC.PSR[1013].R              /* INTC Priority Select Register */
#define INTC_PSR1014         INTC.PSR[1014].R              /* INTC Priority Select Register */
#define INTC_PSR1015         INTC.PSR[1015].R              /* INTC Priority Select Register */
#define INTC_PSR1016         INTC.PSR[1016].R              /* INTC Priority Select Register */
#define INTC_PSR1017         INTC.PSR[1017].R              /* INTC Priority Select Register */
#define INTC_PSR1018         INTC.PSR[1018].R              /* INTC Priority Select Register */
#define INTC_PSR1019         INTC.PSR[1019].R              /* INTC Priority Select Register */
#define INTC_PSR1020         INTC.PSR[1020].R              /* INTC Priority Select Register */
#define INTC_PSR1021         INTC.PSR[1021].R              /* INTC Priority Select Register */
#define INTC_PSR1022         INTC.PSR[1022].R              /* INTC Priority Select Register */
#define INTC_PSR1023         INTC.PSR[1023].R              /* INTC Priority Select Register */

/* JDC */
#define JDC_MCR              JDC.MCR.R                     /* Module Configuration Register */
#define JDC_MSR              JDC.MSR.R                     /* Module Status Register */
#define JDC_JOUT_IPS         JDC.JOUT_IPS.R                /* JTAG Output Data Register */
#define JDC_JIN_IPS          JDC.JIN_IPS.R                 /* JTAG Input Data Register */

/* LINFlexD */
#define LINFlexD_0_LINCR1    LINFlexD_0.LINCR1.R           /* LIN Control Register 1 */
#define LINFlexD_0_LINIER    LINFlexD_0.LINIER.R           /* LIN Interrupt enable register */
#define LINFlexD_0_LINSR     LINFlexD_0.LINSR.R            /* LIN Status Register */
#define LINFlexD_0_LINESR    LINFlexD_0.LINESR.R           /* LIN Error Status Register */
#define LINFlexD_0_UARTCR    LINFlexD_0.UARTCR.R           /* UART Mode Control Register */
#define LINFlexD_0_UARTSR    LINFlexD_0.UARTSR.R           /* UART Mode Status Register */
#define LINFlexD_0_LINTCSR   LINFlexD_0.LINTCSR.R          /* LIN Time-Out Control Status Register */
#define LINFlexD_0_LINOCR    LINFlexD_0.LINOCR.R           /* LIN Output Compare Register */
#define LINFlexD_0_LINTOCR   LINFlexD_0.LINTOCR.R          /* LIN Time-Out Control Register */
#define LINFlexD_0_LINFBRR   LINFlexD_0.LINFBRR.R          /* LIN Fractional Baud Rate Register */
#define LINFlexD_0_LINIBRR   LINFlexD_0.LINIBRR.R          /* LIN Integer Baud Rate Register */
#define LINFlexD_0_LINCFR    LINFlexD_0.LINCFR.R           /* LIN Checksum Field Register */
#define LINFlexD_0_LINCR2    LINFlexD_0.LINCR2.R           /* LIN Control Register 2 */
#define LINFlexD_0_BIDR      LINFlexD_0.BIDR.R             /* Buffer Identifier Register */
#define LINFlexD_0_BDRL      LINFlexD_0.BDRL.R             /* Buffer Data Register Least Significant */
#define LINFlexD_0_BDRM      LINFlexD_0.BDRM.R             /* Buffer Data Register Most Significant */
#define LINFlexD_0_IFER      LINFlexD_0.IFER.R             /* Identifier Filter Enable Register */
#define LINFlexD_0_IFMI      LINFlexD_0.IFMI.R             /* Identifier Filter Match Index */
#define LINFlexD_0_IFMR      LINFlexD_0.IFMR.R             /* Identifier Filter Mode Register */
#define LINFlexD_0_IFCR0     LINFlexD_0.IFCR[0].R          /* Identifier Filter Control Register */
#define LINFlexD_0_IFCR1     LINFlexD_0.IFCR[1].R          /* Identifier Filter Control Register */
#define LINFlexD_0_IFCR2     LINFlexD_0.IFCR[2].R          /* Identifier Filter Control Register */
#define LINFlexD_0_IFCR3     LINFlexD_0.IFCR[3].R          /* Identifier Filter Control Register */
#define LINFlexD_0_IFCR4     LINFlexD_0.IFCR[4].R          /* Identifier Filter Control Register */
#define LINFlexD_0_IFCR5     LINFlexD_0.IFCR[5].R          /* Identifier Filter Control Register */
#define LINFlexD_0_IFCR6     LINFlexD_0.IFCR[6].R          /* Identifier Filter Control Register */
#define LINFlexD_0_IFCR7     LINFlexD_0.IFCR[7].R          /* Identifier Filter Control Register */
#define LINFlexD_0_IFCR8     LINFlexD_0.IFCR[8].R          /* Identifier Filter Control Register */
#define LINFlexD_0_IFCR9     LINFlexD_0.IFCR[9].R          /* Identifier Filter Control Register */
#define LINFlexD_0_IFCR10    LINFlexD_0.IFCR[10].R         /* Identifier Filter Control Register */
#define LINFlexD_0_IFCR11    LINFlexD_0.IFCR[11].R         /* Identifier Filter Control Register */
#define LINFlexD_0_IFCR12    LINFlexD_0.IFCR[12].R         /* Identifier Filter Control Register */
#define LINFlexD_0_IFCR13    LINFlexD_0.IFCR[13].R         /* Identifier Filter Control Register */
#define LINFlexD_0_IFCR14    LINFlexD_0.IFCR[14].R         /* Identifier Filter Control Register */
#define LINFlexD_0_IFCR15    LINFlexD_0.IFCR[15].R         /* Identifier Filter Control Register */
#define LINFlexD_0_GCR       LINFlexD_0.GCR.R              /* Global Control Register */
#define LINFlexD_0_UARTPTO   LINFlexD_0.UARTPTO.R          /* UART Preset Timeout Register */
#define LINFlexD_0_UARTCTO   LINFlexD_0.UARTCTO.R          /* UART Current Timeout Register */
#define LINFlexD_0_DMATXE    LINFlexD_0.DMATXE.R           /* DMA Tx Enable Register */
#define LINFlexD_0_DMARXE    LINFlexD_0.DMARXE.R           /* DMA Rx Enable Register */

/* LINFlexD */
#define LINFlexD_1_LINCR1    LINFlexD_1.LINCR1.R           /* LIN Control Register 1 */
#define LINFlexD_1_LINIER    LINFlexD_1.LINIER.R           /* LIN Interrupt enable register */
#define LINFlexD_1_LINSR     LINFlexD_1.LINSR.R            /* LIN Status Register */
#define LINFlexD_1_LINESR    LINFlexD_1.LINESR.R           /* LIN Error Status Register */
#define LINFlexD_1_UARTCR    LINFlexD_1.UARTCR.R           /* UART Mode Control Register */
#define LINFlexD_1_UARTSR    LINFlexD_1.UARTSR.R           /* UART Mode Status Register */
#define LINFlexD_1_LINTCSR   LINFlexD_1.LINTCSR.R          /* LIN Time-Out Control Status Register */
#define LINFlexD_1_LINOCR    LINFlexD_1.LINOCR.R           /* LIN Output Compare Register */
#define LINFlexD_1_LINTOCR   LINFlexD_1.LINTOCR.R          /* LIN Time-Out Control Register */
#define LINFlexD_1_LINFBRR   LINFlexD_1.LINFBRR.R          /* LIN Fractional Baud Rate Register */
#define LINFlexD_1_LINIBRR   LINFlexD_1.LINIBRR.R          /* LIN Integer Baud Rate Register */
#define LINFlexD_1_LINCFR    LINFlexD_1.LINCFR.R           /* LIN Checksum Field Register */
#define LINFlexD_1_LINCR2    LINFlexD_1.LINCR2.R           /* LIN Control Register 2 */
#define LINFlexD_1_BIDR      LINFlexD_1.BIDR.R             /* Buffer Identifier Register */
#define LINFlexD_1_BDRL      LINFlexD_1.BDRL.R             /* Buffer Data Register Least Significant */
#define LINFlexD_1_BDRM      LINFlexD_1.BDRM.R             /* Buffer Data Register Most Significant */
#define LINFlexD_1_IFER      LINFlexD_1.IFER.R             /* Identifier Filter Enable Register */
#define LINFlexD_1_IFMI      LINFlexD_1.IFMI.R             /* Identifier Filter Match Index */
#define LINFlexD_1_IFMR      LINFlexD_1.IFMR.R             /* Identifier Filter Mode Register */
#define LINFlexD_1_IFCR0     LINFlexD_1.IFCR[0].R          /* Identifier Filter Control Register */
#define LINFlexD_1_IFCR1     LINFlexD_1.IFCR[1].R          /* Identifier Filter Control Register */
#define LINFlexD_1_IFCR2     LINFlexD_1.IFCR[2].R          /* Identifier Filter Control Register */
#define LINFlexD_1_IFCR3     LINFlexD_1.IFCR[3].R          /* Identifier Filter Control Register */
#define LINFlexD_1_IFCR4     LINFlexD_1.IFCR[4].R          /* Identifier Filter Control Register */
#define LINFlexD_1_IFCR5     LINFlexD_1.IFCR[5].R          /* Identifier Filter Control Register */
#define LINFlexD_1_IFCR6     LINFlexD_1.IFCR[6].R          /* Identifier Filter Control Register */
#define LINFlexD_1_IFCR7     LINFlexD_1.IFCR[7].R          /* Identifier Filter Control Register */
#define LINFlexD_1_IFCR8     LINFlexD_1.IFCR[8].R          /* Identifier Filter Control Register */
#define LINFlexD_1_IFCR9     LINFlexD_1.IFCR[9].R          /* Identifier Filter Control Register */
#define LINFlexD_1_IFCR10    LINFlexD_1.IFCR[10].R         /* Identifier Filter Control Register */
#define LINFlexD_1_IFCR11    LINFlexD_1.IFCR[11].R         /* Identifier Filter Control Register */
#define LINFlexD_1_IFCR12    LINFlexD_1.IFCR[12].R         /* Identifier Filter Control Register */
#define LINFlexD_1_IFCR13    LINFlexD_1.IFCR[13].R         /* Identifier Filter Control Register */
#define LINFlexD_1_IFCR14    LINFlexD_1.IFCR[14].R         /* Identifier Filter Control Register */
#define LINFlexD_1_IFCR15    LINFlexD_1.IFCR[15].R         /* Identifier Filter Control Register */
#define LINFlexD_1_GCR       LINFlexD_1.GCR.R              /* Global Control Register */
#define LINFlexD_1_UARTPTO   LINFlexD_1.UARTPTO.R          /* UART Preset Timeout Register */
#define LINFlexD_1_UARTCTO   LINFlexD_1.UARTCTO.R          /* UART Current Timeout Register */
#define LINFlexD_1_DMATXE    LINFlexD_1.DMATXE.R           /* DMA Tx Enable Register */
#define LINFlexD_1_DMARXE    LINFlexD_1.DMARXE.R           /* DMA Rx Enable Register */

/* LINFlexD */
#define LINFlexD_10_LINCR1   LINFlexD_10.LINCR1.R          /* LIN Control Register 1 */
#define LINFlexD_10_LINIER   LINFlexD_10.LINIER.R          /* LIN Interrupt enable register */
#define LINFlexD_10_LINSR    LINFlexD_10.LINSR.R           /* LIN Status Register */
#define LINFlexD_10_LINESR   LINFlexD_10.LINESR.R          /* LIN Error Status Register */
#define LINFlexD_10_UARTCR   LINFlexD_10.UARTCR.R          /* UART Mode Control Register */
#define LINFlexD_10_UARTSR   LINFlexD_10.UARTSR.R          /* UART Mode Status Register */
#define LINFlexD_10_LINTCSR  LINFlexD_10.LINTCSR.R         /* LIN Time-Out Control Status Register */
#define LINFlexD_10_LINOCR   LINFlexD_10.LINOCR.R          /* LIN Output Compare Register */
#define LINFlexD_10_LINTOCR  LINFlexD_10.LINTOCR.R         /* LIN Time-Out Control Register */
#define LINFlexD_10_LINFBRR  LINFlexD_10.LINFBRR.R         /* LIN Fractional Baud Rate Register */
#define LINFlexD_10_LINIBRR  LINFlexD_10.LINIBRR.R         /* LIN Integer Baud Rate Register */
#define LINFlexD_10_LINCFR   LINFlexD_10.LINCFR.R          /* LIN Checksum Field Register */
#define LINFlexD_10_LINCR2   LINFlexD_10.LINCR2.R          /* LIN Control Register 2 */
#define LINFlexD_10_BIDR     LINFlexD_10.BIDR.R            /* Buffer Identifier Register */
#define LINFlexD_10_BDRL     LINFlexD_10.BDRL.R            /* Buffer Data Register Least Significant */
#define LINFlexD_10_BDRM     LINFlexD_10.BDRM.R            /* Buffer Data Register Most Significant */
#define LINFlexD_10_IFER     LINFlexD_10.IFER.R            /* Identifier Filter Enable Register */
#define LINFlexD_10_IFMI     LINFlexD_10.IFMI.R            /* Identifier Filter Match Index */
#define LINFlexD_10_IFMR     LINFlexD_10.IFMR.R            /* Identifier Filter Mode Register */
#define LINFlexD_10_IFCR0    LINFlexD_10.IFCR[0].R         /* Identifier Filter Control Register */
#define LINFlexD_10_IFCR1    LINFlexD_10.IFCR[1].R         /* Identifier Filter Control Register */
#define LINFlexD_10_IFCR2    LINFlexD_10.IFCR[2].R         /* Identifier Filter Control Register */
#define LINFlexD_10_IFCR3    LINFlexD_10.IFCR[3].R         /* Identifier Filter Control Register */
#define LINFlexD_10_IFCR4    LINFlexD_10.IFCR[4].R         /* Identifier Filter Control Register */
#define LINFlexD_10_IFCR5    LINFlexD_10.IFCR[5].R         /* Identifier Filter Control Register */
#define LINFlexD_10_IFCR6    LINFlexD_10.IFCR[6].R         /* Identifier Filter Control Register */
#define LINFlexD_10_IFCR7    LINFlexD_10.IFCR[7].R         /* Identifier Filter Control Register */
#define LINFlexD_10_IFCR8    LINFlexD_10.IFCR[8].R         /* Identifier Filter Control Register */
#define LINFlexD_10_IFCR9    LINFlexD_10.IFCR[9].R         /* Identifier Filter Control Register */
#define LINFlexD_10_IFCR10   LINFlexD_10.IFCR[10].R        /* Identifier Filter Control Register */
#define LINFlexD_10_IFCR11   LINFlexD_10.IFCR[11].R        /* Identifier Filter Control Register */
#define LINFlexD_10_IFCR12   LINFlexD_10.IFCR[12].R        /* Identifier Filter Control Register */
#define LINFlexD_10_IFCR13   LINFlexD_10.IFCR[13].R        /* Identifier Filter Control Register */
#define LINFlexD_10_IFCR14   LINFlexD_10.IFCR[14].R        /* Identifier Filter Control Register */
#define LINFlexD_10_IFCR15   LINFlexD_10.IFCR[15].R        /* Identifier Filter Control Register */
#define LINFlexD_10_GCR      LINFlexD_10.GCR.R             /* Global Control Register */
#define LINFlexD_10_UARTPTO  LINFlexD_10.UARTPTO.R         /* UART Preset Timeout Register */
#define LINFlexD_10_UARTCTO  LINFlexD_10.UARTCTO.R         /* UART Current Timeout Register */
#define LINFlexD_10_DMATXE   LINFlexD_10.DMATXE.R          /* DMA Tx Enable Register */
#define LINFlexD_10_DMARXE   LINFlexD_10.DMARXE.R          /* DMA Rx Enable Register */

/* LINFlexD */
#define LINFlexD_11_LINCR1   LINFlexD_11.LINCR1.R          /* LIN Control Register 1 */
#define LINFlexD_11_LINIER   LINFlexD_11.LINIER.R          /* LIN Interrupt enable register */
#define LINFlexD_11_LINSR    LINFlexD_11.LINSR.R           /* LIN Status Register */
#define LINFlexD_11_LINESR   LINFlexD_11.LINESR.R          /* LIN Error Status Register */
#define LINFlexD_11_UARTCR   LINFlexD_11.UARTCR.R          /* UART Mode Control Register */
#define LINFlexD_11_UARTSR   LINFlexD_11.UARTSR.R          /* UART Mode Status Register */
#define LINFlexD_11_LINTCSR  LINFlexD_11.LINTCSR.R         /* LIN Time-Out Control Status Register */
#define LINFlexD_11_LINOCR   LINFlexD_11.LINOCR.R          /* LIN Output Compare Register */
#define LINFlexD_11_LINTOCR  LINFlexD_11.LINTOCR.R         /* LIN Time-Out Control Register */
#define LINFlexD_11_LINFBRR  LINFlexD_11.LINFBRR.R         /* LIN Fractional Baud Rate Register */
#define LINFlexD_11_LINIBRR  LINFlexD_11.LINIBRR.R         /* LIN Integer Baud Rate Register */
#define LINFlexD_11_LINCFR   LINFlexD_11.LINCFR.R          /* LIN Checksum Field Register */
#define LINFlexD_11_LINCR2   LINFlexD_11.LINCR2.R          /* LIN Control Register 2 */
#define LINFlexD_11_BIDR     LINFlexD_11.BIDR.R            /* Buffer Identifier Register */
#define LINFlexD_11_BDRL     LINFlexD_11.BDRL.R            /* Buffer Data Register Least Significant */
#define LINFlexD_11_BDRM     LINFlexD_11.BDRM.R            /* Buffer Data Register Most Significant */
#define LINFlexD_11_IFER     LINFlexD_11.IFER.R            /* Identifier Filter Enable Register */
#define LINFlexD_11_IFMI     LINFlexD_11.IFMI.R            /* Identifier Filter Match Index */
#define LINFlexD_11_IFMR     LINFlexD_11.IFMR.R            /* Identifier Filter Mode Register */
#define LINFlexD_11_IFCR0    LINFlexD_11.IFCR[0].R         /* Identifier Filter Control Register */
#define LINFlexD_11_IFCR1    LINFlexD_11.IFCR[1].R         /* Identifier Filter Control Register */
#define LINFlexD_11_IFCR2    LINFlexD_11.IFCR[2].R         /* Identifier Filter Control Register */
#define LINFlexD_11_IFCR3    LINFlexD_11.IFCR[3].R         /* Identifier Filter Control Register */
#define LINFlexD_11_IFCR4    LINFlexD_11.IFCR[4].R         /* Identifier Filter Control Register */
#define LINFlexD_11_IFCR5    LINFlexD_11.IFCR[5].R         /* Identifier Filter Control Register */
#define LINFlexD_11_IFCR6    LINFlexD_11.IFCR[6].R         /* Identifier Filter Control Register */
#define LINFlexD_11_IFCR7    LINFlexD_11.IFCR[7].R         /* Identifier Filter Control Register */
#define LINFlexD_11_IFCR8    LINFlexD_11.IFCR[8].R         /* Identifier Filter Control Register */
#define LINFlexD_11_IFCR9    LINFlexD_11.IFCR[9].R         /* Identifier Filter Control Register */
#define LINFlexD_11_IFCR10   LINFlexD_11.IFCR[10].R        /* Identifier Filter Control Register */
#define LINFlexD_11_IFCR11   LINFlexD_11.IFCR[11].R        /* Identifier Filter Control Register */
#define LINFlexD_11_IFCR12   LINFlexD_11.IFCR[12].R        /* Identifier Filter Control Register */
#define LINFlexD_11_IFCR13   LINFlexD_11.IFCR[13].R        /* Identifier Filter Control Register */
#define LINFlexD_11_IFCR14   LINFlexD_11.IFCR[14].R        /* Identifier Filter Control Register */
#define LINFlexD_11_IFCR15   LINFlexD_11.IFCR[15].R        /* Identifier Filter Control Register */
#define LINFlexD_11_GCR      LINFlexD_11.GCR.R             /* Global Control Register */
#define LINFlexD_11_UARTPTO  LINFlexD_11.UARTPTO.R         /* UART Preset Timeout Register */
#define LINFlexD_11_UARTCTO  LINFlexD_11.UARTCTO.R         /* UART Current Timeout Register */
#define LINFlexD_11_DMATXE   LINFlexD_11.DMATXE.R          /* DMA Tx Enable Register */
#define LINFlexD_11_DMARXE   LINFlexD_11.DMARXE.R          /* DMA Rx Enable Register */

/* LINFlexD */
#define LINFlexD_12_LINCR1   LINFlexD_12.LINCR1.R          /* LIN Control Register 1 */
#define LINFlexD_12_LINIER   LINFlexD_12.LINIER.R          /* LIN Interrupt enable register */
#define LINFlexD_12_LINSR    LINFlexD_12.LINSR.R           /* LIN Status Register */
#define LINFlexD_12_LINESR   LINFlexD_12.LINESR.R          /* LIN Error Status Register */
#define LINFlexD_12_UARTCR   LINFlexD_12.UARTCR.R          /* UART Mode Control Register */
#define LINFlexD_12_UARTSR   LINFlexD_12.UARTSR.R          /* UART Mode Status Register */
#define LINFlexD_12_LINTCSR  LINFlexD_12.LINTCSR.R         /* LIN Time-Out Control Status Register */
#define LINFlexD_12_LINOCR   LINFlexD_12.LINOCR.R          /* LIN Output Compare Register */
#define LINFlexD_12_LINTOCR  LINFlexD_12.LINTOCR.R         /* LIN Time-Out Control Register */
#define LINFlexD_12_LINFBRR  LINFlexD_12.LINFBRR.R         /* LIN Fractional Baud Rate Register */
#define LINFlexD_12_LINIBRR  LINFlexD_12.LINIBRR.R         /* LIN Integer Baud Rate Register */
#define LINFlexD_12_LINCFR   LINFlexD_12.LINCFR.R          /* LIN Checksum Field Register */
#define LINFlexD_12_LINCR2   LINFlexD_12.LINCR2.R          /* LIN Control Register 2 */
#define LINFlexD_12_BIDR     LINFlexD_12.BIDR.R            /* Buffer Identifier Register */
#define LINFlexD_12_BDRL     LINFlexD_12.BDRL.R            /* Buffer Data Register Least Significant */
#define LINFlexD_12_BDRM     LINFlexD_12.BDRM.R            /* Buffer Data Register Most Significant */
#define LINFlexD_12_IFER     LINFlexD_12.IFER.R            /* Identifier Filter Enable Register */
#define LINFlexD_12_IFMI     LINFlexD_12.IFMI.R            /* Identifier Filter Match Index */
#define LINFlexD_12_IFMR     LINFlexD_12.IFMR.R            /* Identifier Filter Mode Register */
#define LINFlexD_12_IFCR0    LINFlexD_12.IFCR[0].R         /* Identifier Filter Control Register */
#define LINFlexD_12_IFCR1    LINFlexD_12.IFCR[1].R         /* Identifier Filter Control Register */
#define LINFlexD_12_IFCR2    LINFlexD_12.IFCR[2].R         /* Identifier Filter Control Register */
#define LINFlexD_12_IFCR3    LINFlexD_12.IFCR[3].R         /* Identifier Filter Control Register */
#define LINFlexD_12_IFCR4    LINFlexD_12.IFCR[4].R         /* Identifier Filter Control Register */
#define LINFlexD_12_IFCR5    LINFlexD_12.IFCR[5].R         /* Identifier Filter Control Register */
#define LINFlexD_12_IFCR6    LINFlexD_12.IFCR[6].R         /* Identifier Filter Control Register */
#define LINFlexD_12_IFCR7    LINFlexD_12.IFCR[7].R         /* Identifier Filter Control Register */
#define LINFlexD_12_IFCR8    LINFlexD_12.IFCR[8].R         /* Identifier Filter Control Register */
#define LINFlexD_12_IFCR9    LINFlexD_12.IFCR[9].R         /* Identifier Filter Control Register */
#define LINFlexD_12_IFCR10   LINFlexD_12.IFCR[10].R        /* Identifier Filter Control Register */
#define LINFlexD_12_IFCR11   LINFlexD_12.IFCR[11].R        /* Identifier Filter Control Register */
#define LINFlexD_12_IFCR12   LINFlexD_12.IFCR[12].R        /* Identifier Filter Control Register */
#define LINFlexD_12_IFCR13   LINFlexD_12.IFCR[13].R        /* Identifier Filter Control Register */
#define LINFlexD_12_IFCR14   LINFlexD_12.IFCR[14].R        /* Identifier Filter Control Register */
#define LINFlexD_12_IFCR15   LINFlexD_12.IFCR[15].R        /* Identifier Filter Control Register */
#define LINFlexD_12_GCR      LINFlexD_12.GCR.R             /* Global Control Register */
#define LINFlexD_12_UARTPTO  LINFlexD_12.UARTPTO.R         /* UART Preset Timeout Register */
#define LINFlexD_12_UARTCTO  LINFlexD_12.UARTCTO.R         /* UART Current Timeout Register */
#define LINFlexD_12_DMATXE   LINFlexD_12.DMATXE.R          /* DMA Tx Enable Register */
#define LINFlexD_12_DMARXE   LINFlexD_12.DMARXE.R          /* DMA Rx Enable Register */

/* LINFlexD */
#define LINFlexD_13_LINCR1   LINFlexD_13.LINCR1.R          /* LIN Control Register 1 */
#define LINFlexD_13_LINIER   LINFlexD_13.LINIER.R          /* LIN Interrupt enable register */
#define LINFlexD_13_LINSR    LINFlexD_13.LINSR.R           /* LIN Status Register */
#define LINFlexD_13_LINESR   LINFlexD_13.LINESR.R          /* LIN Error Status Register */
#define LINFlexD_13_UARTCR   LINFlexD_13.UARTCR.R          /* UART Mode Control Register */
#define LINFlexD_13_UARTSR   LINFlexD_13.UARTSR.R          /* UART Mode Status Register */
#define LINFlexD_13_LINTCSR  LINFlexD_13.LINTCSR.R         /* LIN Time-Out Control Status Register */
#define LINFlexD_13_LINOCR   LINFlexD_13.LINOCR.R          /* LIN Output Compare Register */
#define LINFlexD_13_LINTOCR  LINFlexD_13.LINTOCR.R         /* LIN Time-Out Control Register */
#define LINFlexD_13_LINFBRR  LINFlexD_13.LINFBRR.R         /* LIN Fractional Baud Rate Register */
#define LINFlexD_13_LINIBRR  LINFlexD_13.LINIBRR.R         /* LIN Integer Baud Rate Register */
#define LINFlexD_13_LINCFR   LINFlexD_13.LINCFR.R          /* LIN Checksum Field Register */
#define LINFlexD_13_LINCR2   LINFlexD_13.LINCR2.R          /* LIN Control Register 2 */
#define LINFlexD_13_BIDR     LINFlexD_13.BIDR.R            /* Buffer Identifier Register */
#define LINFlexD_13_BDRL     LINFlexD_13.BDRL.R            /* Buffer Data Register Least Significant */
#define LINFlexD_13_BDRM     LINFlexD_13.BDRM.R            /* Buffer Data Register Most Significant */
#define LINFlexD_13_IFER     LINFlexD_13.IFER.R            /* Identifier Filter Enable Register */
#define LINFlexD_13_IFMI     LINFlexD_13.IFMI.R            /* Identifier Filter Match Index */
#define LINFlexD_13_IFMR     LINFlexD_13.IFMR.R            /* Identifier Filter Mode Register */
#define LINFlexD_13_IFCR0    LINFlexD_13.IFCR[0].R         /* Identifier Filter Control Register */
#define LINFlexD_13_IFCR1    LINFlexD_13.IFCR[1].R         /* Identifier Filter Control Register */
#define LINFlexD_13_IFCR2    LINFlexD_13.IFCR[2].R         /* Identifier Filter Control Register */
#define LINFlexD_13_IFCR3    LINFlexD_13.IFCR[3].R         /* Identifier Filter Control Register */
#define LINFlexD_13_IFCR4    LINFlexD_13.IFCR[4].R         /* Identifier Filter Control Register */
#define LINFlexD_13_IFCR5    LINFlexD_13.IFCR[5].R         /* Identifier Filter Control Register */
#define LINFlexD_13_IFCR6    LINFlexD_13.IFCR[6].R         /* Identifier Filter Control Register */
#define LINFlexD_13_IFCR7    LINFlexD_13.IFCR[7].R         /* Identifier Filter Control Register */
#define LINFlexD_13_IFCR8    LINFlexD_13.IFCR[8].R         /* Identifier Filter Control Register */
#define LINFlexD_13_IFCR9    LINFlexD_13.IFCR[9].R         /* Identifier Filter Control Register */
#define LINFlexD_13_IFCR10   LINFlexD_13.IFCR[10].R        /* Identifier Filter Control Register */
#define LINFlexD_13_IFCR11   LINFlexD_13.IFCR[11].R        /* Identifier Filter Control Register */
#define LINFlexD_13_IFCR12   LINFlexD_13.IFCR[12].R        /* Identifier Filter Control Register */
#define LINFlexD_13_IFCR13   LINFlexD_13.IFCR[13].R        /* Identifier Filter Control Register */
#define LINFlexD_13_IFCR14   LINFlexD_13.IFCR[14].R        /* Identifier Filter Control Register */
#define LINFlexD_13_IFCR15   LINFlexD_13.IFCR[15].R        /* Identifier Filter Control Register */
#define LINFlexD_13_GCR      LINFlexD_13.GCR.R             /* Global Control Register */
#define LINFlexD_13_UARTPTO  LINFlexD_13.UARTPTO.R         /* UART Preset Timeout Register */
#define LINFlexD_13_UARTCTO  LINFlexD_13.UARTCTO.R         /* UART Current Timeout Register */
#define LINFlexD_13_DMATXE   LINFlexD_13.DMATXE.R          /* DMA Tx Enable Register */
#define LINFlexD_13_DMARXE   LINFlexD_13.DMARXE.R          /* DMA Rx Enable Register */

/* LINFlexD */
#define LINFlexD_14_LINCR1   LINFlexD_14.LINCR1.R          /* LIN Control Register 1 */
#define LINFlexD_14_LINIER   LINFlexD_14.LINIER.R          /* LIN Interrupt enable register */
#define LINFlexD_14_LINSR    LINFlexD_14.LINSR.R           /* LIN Status Register */
#define LINFlexD_14_LINESR   LINFlexD_14.LINESR.R          /* LIN Error Status Register */
#define LINFlexD_14_UARTCR   LINFlexD_14.UARTCR.R          /* UART Mode Control Register */
#define LINFlexD_14_UARTSR   LINFlexD_14.UARTSR.R          /* UART Mode Status Register */
#define LINFlexD_14_LINTCSR  LINFlexD_14.LINTCSR.R         /* LIN Time-Out Control Status Register */
#define LINFlexD_14_LINOCR   LINFlexD_14.LINOCR.R          /* LIN Output Compare Register */
#define LINFlexD_14_LINTOCR  LINFlexD_14.LINTOCR.R         /* LIN Time-Out Control Register */
#define LINFlexD_14_LINFBRR  LINFlexD_14.LINFBRR.R         /* LIN Fractional Baud Rate Register */
#define LINFlexD_14_LINIBRR  LINFlexD_14.LINIBRR.R         /* LIN Integer Baud Rate Register */
#define LINFlexD_14_LINCFR   LINFlexD_14.LINCFR.R          /* LIN Checksum Field Register */
#define LINFlexD_14_LINCR2   LINFlexD_14.LINCR2.R          /* LIN Control Register 2 */
#define LINFlexD_14_BIDR     LINFlexD_14.BIDR.R            /* Buffer Identifier Register */
#define LINFlexD_14_BDRL     LINFlexD_14.BDRL.R            /* Buffer Data Register Least Significant */
#define LINFlexD_14_BDRM     LINFlexD_14.BDRM.R            /* Buffer Data Register Most Significant */
#define LINFlexD_14_IFER     LINFlexD_14.IFER.R            /* Identifier Filter Enable Register */
#define LINFlexD_14_IFMI     LINFlexD_14.IFMI.R            /* Identifier Filter Match Index */
#define LINFlexD_14_IFMR     LINFlexD_14.IFMR.R            /* Identifier Filter Mode Register */
#define LINFlexD_14_IFCR0    LINFlexD_14.IFCR[0].R         /* Identifier Filter Control Register */
#define LINFlexD_14_IFCR1    LINFlexD_14.IFCR[1].R         /* Identifier Filter Control Register */
#define LINFlexD_14_IFCR2    LINFlexD_14.IFCR[2].R         /* Identifier Filter Control Register */
#define LINFlexD_14_IFCR3    LINFlexD_14.IFCR[3].R         /* Identifier Filter Control Register */
#define LINFlexD_14_IFCR4    LINFlexD_14.IFCR[4].R         /* Identifier Filter Control Register */
#define LINFlexD_14_IFCR5    LINFlexD_14.IFCR[5].R         /* Identifier Filter Control Register */
#define LINFlexD_14_IFCR6    LINFlexD_14.IFCR[6].R         /* Identifier Filter Control Register */
#define LINFlexD_14_IFCR7    LINFlexD_14.IFCR[7].R         /* Identifier Filter Control Register */
#define LINFlexD_14_IFCR8    LINFlexD_14.IFCR[8].R         /* Identifier Filter Control Register */
#define LINFlexD_14_IFCR9    LINFlexD_14.IFCR[9].R         /* Identifier Filter Control Register */
#define LINFlexD_14_IFCR10   LINFlexD_14.IFCR[10].R        /* Identifier Filter Control Register */
#define LINFlexD_14_IFCR11   LINFlexD_14.IFCR[11].R        /* Identifier Filter Control Register */
#define LINFlexD_14_IFCR12   LINFlexD_14.IFCR[12].R        /* Identifier Filter Control Register */
#define LINFlexD_14_IFCR13   LINFlexD_14.IFCR[13].R        /* Identifier Filter Control Register */
#define LINFlexD_14_IFCR14   LINFlexD_14.IFCR[14].R        /* Identifier Filter Control Register */
#define LINFlexD_14_IFCR15   LINFlexD_14.IFCR[15].R        /* Identifier Filter Control Register */
#define LINFlexD_14_GCR      LINFlexD_14.GCR.R             /* Global Control Register */
#define LINFlexD_14_UARTPTO  LINFlexD_14.UARTPTO.R         /* UART Preset Timeout Register */
#define LINFlexD_14_UARTCTO  LINFlexD_14.UARTCTO.R         /* UART Current Timeout Register */
#define LINFlexD_14_DMATXE   LINFlexD_14.DMATXE.R          /* DMA Tx Enable Register */
#define LINFlexD_14_DMARXE   LINFlexD_14.DMARXE.R          /* DMA Rx Enable Register */

/* LINFlexD */
#define LINFlexD_15_LINCR1   LINFlexD_15.LINCR1.R          /* LIN Control Register 1 */
#define LINFlexD_15_LINIER   LINFlexD_15.LINIER.R          /* LIN Interrupt enable register */
#define LINFlexD_15_LINSR    LINFlexD_15.LINSR.R           /* LIN Status Register */
#define LINFlexD_15_LINESR   LINFlexD_15.LINESR.R          /* LIN Error Status Register */
#define LINFlexD_15_UARTCR   LINFlexD_15.UARTCR.R          /* UART Mode Control Register */
#define LINFlexD_15_UARTSR   LINFlexD_15.UARTSR.R          /* UART Mode Status Register */
#define LINFlexD_15_LINTCSR  LINFlexD_15.LINTCSR.R         /* LIN Time-Out Control Status Register */
#define LINFlexD_15_LINOCR   LINFlexD_15.LINOCR.R          /* LIN Output Compare Register */
#define LINFlexD_15_LINTOCR  LINFlexD_15.LINTOCR.R         /* LIN Time-Out Control Register */
#define LINFlexD_15_LINFBRR  LINFlexD_15.LINFBRR.R         /* LIN Fractional Baud Rate Register */
#define LINFlexD_15_LINIBRR  LINFlexD_15.LINIBRR.R         /* LIN Integer Baud Rate Register */
#define LINFlexD_15_LINCFR   LINFlexD_15.LINCFR.R          /* LIN Checksum Field Register */
#define LINFlexD_15_LINCR2   LINFlexD_15.LINCR2.R          /* LIN Control Register 2 */
#define LINFlexD_15_BIDR     LINFlexD_15.BIDR.R            /* Buffer Identifier Register */
#define LINFlexD_15_BDRL     LINFlexD_15.BDRL.R            /* Buffer Data Register Least Significant */
#define LINFlexD_15_BDRM     LINFlexD_15.BDRM.R            /* Buffer Data Register Most Significant */
#define LINFlexD_15_IFER     LINFlexD_15.IFER.R            /* Identifier Filter Enable Register */
#define LINFlexD_15_IFMI     LINFlexD_15.IFMI.R            /* Identifier Filter Match Index */
#define LINFlexD_15_IFMR     LINFlexD_15.IFMR.R            /* Identifier Filter Mode Register */
#define LINFlexD_15_IFCR0    LINFlexD_15.IFCR[0].R         /* Identifier Filter Control Register */
#define LINFlexD_15_IFCR1    LINFlexD_15.IFCR[1].R         /* Identifier Filter Control Register */
#define LINFlexD_15_IFCR2    LINFlexD_15.IFCR[2].R         /* Identifier Filter Control Register */
#define LINFlexD_15_IFCR3    LINFlexD_15.IFCR[3].R         /* Identifier Filter Control Register */
#define LINFlexD_15_IFCR4    LINFlexD_15.IFCR[4].R         /* Identifier Filter Control Register */
#define LINFlexD_15_IFCR5    LINFlexD_15.IFCR[5].R         /* Identifier Filter Control Register */
#define LINFlexD_15_IFCR6    LINFlexD_15.IFCR[6].R         /* Identifier Filter Control Register */
#define LINFlexD_15_IFCR7    LINFlexD_15.IFCR[7].R         /* Identifier Filter Control Register */
#define LINFlexD_15_IFCR8    LINFlexD_15.IFCR[8].R         /* Identifier Filter Control Register */
#define LINFlexD_15_IFCR9    LINFlexD_15.IFCR[9].R         /* Identifier Filter Control Register */
#define LINFlexD_15_IFCR10   LINFlexD_15.IFCR[10].R        /* Identifier Filter Control Register */
#define LINFlexD_15_IFCR11   LINFlexD_15.IFCR[11].R        /* Identifier Filter Control Register */
#define LINFlexD_15_IFCR12   LINFlexD_15.IFCR[12].R        /* Identifier Filter Control Register */
#define LINFlexD_15_IFCR13   LINFlexD_15.IFCR[13].R        /* Identifier Filter Control Register */
#define LINFlexD_15_IFCR14   LINFlexD_15.IFCR[14].R        /* Identifier Filter Control Register */
#define LINFlexD_15_IFCR15   LINFlexD_15.IFCR[15].R        /* Identifier Filter Control Register */
#define LINFlexD_15_GCR      LINFlexD_15.GCR.R             /* Global Control Register */
#define LINFlexD_15_UARTPTO  LINFlexD_15.UARTPTO.R         /* UART Preset Timeout Register */
#define LINFlexD_15_UARTCTO  LINFlexD_15.UARTCTO.R         /* UART Current Timeout Register */
#define LINFlexD_15_DMATXE   LINFlexD_15.DMATXE.R          /* DMA Tx Enable Register */
#define LINFlexD_15_DMARXE   LINFlexD_15.DMARXE.R          /* DMA Rx Enable Register */

/* LINFlexD */
#define LINFlexD_2_LINCR1    LINFlexD_2.LINCR1.R           /* LIN Control Register 1 */
#define LINFlexD_2_LINIER    LINFlexD_2.LINIER.R           /* LIN Interrupt enable register */
#define LINFlexD_2_LINSR     LINFlexD_2.LINSR.R            /* LIN Status Register */
#define LINFlexD_2_LINESR    LINFlexD_2.LINESR.R           /* LIN Error Status Register */
#define LINFlexD_2_UARTCR    LINFlexD_2.UARTCR.R           /* UART Mode Control Register */
#define LINFlexD_2_UARTSR    LINFlexD_2.UARTSR.R           /* UART Mode Status Register */
#define LINFlexD_2_LINTCSR   LINFlexD_2.LINTCSR.R          /* LIN Time-Out Control Status Register */
#define LINFlexD_2_LINOCR    LINFlexD_2.LINOCR.R           /* LIN Output Compare Register */
#define LINFlexD_2_LINTOCR   LINFlexD_2.LINTOCR.R          /* LIN Time-Out Control Register */
#define LINFlexD_2_LINFBRR   LINFlexD_2.LINFBRR.R          /* LIN Fractional Baud Rate Register */
#define LINFlexD_2_LINIBRR   LINFlexD_2.LINIBRR.R          /* LIN Integer Baud Rate Register */
#define LINFlexD_2_LINCFR    LINFlexD_2.LINCFR.R           /* LIN Checksum Field Register */
#define LINFlexD_2_LINCR2    LINFlexD_2.LINCR2.R           /* LIN Control Register 2 */
#define LINFlexD_2_BIDR      LINFlexD_2.BIDR.R             /* Buffer Identifier Register */
#define LINFlexD_2_BDRL      LINFlexD_2.BDRL.R             /* Buffer Data Register Least Significant */
#define LINFlexD_2_BDRM      LINFlexD_2.BDRM.R             /* Buffer Data Register Most Significant */
#define LINFlexD_2_IFER      LINFlexD_2.IFER.R             /* Identifier Filter Enable Register */
#define LINFlexD_2_IFMI      LINFlexD_2.IFMI.R             /* Identifier Filter Match Index */
#define LINFlexD_2_IFMR      LINFlexD_2.IFMR.R             /* Identifier Filter Mode Register */
#define LINFlexD_2_IFCR0     LINFlexD_2.IFCR[0].R          /* Identifier Filter Control Register */
#define LINFlexD_2_IFCR1     LINFlexD_2.IFCR[1].R          /* Identifier Filter Control Register */
#define LINFlexD_2_IFCR2     LINFlexD_2.IFCR[2].R          /* Identifier Filter Control Register */
#define LINFlexD_2_IFCR3     LINFlexD_2.IFCR[3].R          /* Identifier Filter Control Register */
#define LINFlexD_2_IFCR4     LINFlexD_2.IFCR[4].R          /* Identifier Filter Control Register */
#define LINFlexD_2_IFCR5     LINFlexD_2.IFCR[5].R          /* Identifier Filter Control Register */
#define LINFlexD_2_IFCR6     LINFlexD_2.IFCR[6].R          /* Identifier Filter Control Register */
#define LINFlexD_2_IFCR7     LINFlexD_2.IFCR[7].R          /* Identifier Filter Control Register */
#define LINFlexD_2_IFCR8     LINFlexD_2.IFCR[8].R          /* Identifier Filter Control Register */
#define LINFlexD_2_IFCR9     LINFlexD_2.IFCR[9].R          /* Identifier Filter Control Register */
#define LINFlexD_2_IFCR10    LINFlexD_2.IFCR[10].R         /* Identifier Filter Control Register */
#define LINFlexD_2_IFCR11    LINFlexD_2.IFCR[11].R         /* Identifier Filter Control Register */
#define LINFlexD_2_IFCR12    LINFlexD_2.IFCR[12].R         /* Identifier Filter Control Register */
#define LINFlexD_2_IFCR13    LINFlexD_2.IFCR[13].R         /* Identifier Filter Control Register */
#define LINFlexD_2_IFCR14    LINFlexD_2.IFCR[14].R         /* Identifier Filter Control Register */
#define LINFlexD_2_IFCR15    LINFlexD_2.IFCR[15].R         /* Identifier Filter Control Register */
#define LINFlexD_2_GCR       LINFlexD_2.GCR.R              /* Global Control Register */
#define LINFlexD_2_UARTPTO   LINFlexD_2.UARTPTO.R          /* UART Preset Timeout Register */
#define LINFlexD_2_UARTCTO   LINFlexD_2.UARTCTO.R          /* UART Current Timeout Register */
#define LINFlexD_2_DMATXE    LINFlexD_2.DMATXE.R           /* DMA Tx Enable Register */
#define LINFlexD_2_DMARXE    LINFlexD_2.DMARXE.R           /* DMA Rx Enable Register */

/* LINFlexD */
#define LINFlexD_3_LINCR1    LINFlexD_3.LINCR1.R           /* LIN Control Register 1 */
#define LINFlexD_3_LINIER    LINFlexD_3.LINIER.R           /* LIN Interrupt enable register */
#define LINFlexD_3_LINSR     LINFlexD_3.LINSR.R            /* LIN Status Register */
#define LINFlexD_3_LINESR    LINFlexD_3.LINESR.R           /* LIN Error Status Register */
#define LINFlexD_3_UARTCR    LINFlexD_3.UARTCR.R           /* UART Mode Control Register */
#define LINFlexD_3_UARTSR    LINFlexD_3.UARTSR.R           /* UART Mode Status Register */
#define LINFlexD_3_LINTCSR   LINFlexD_3.LINTCSR.R          /* LIN Time-Out Control Status Register */
#define LINFlexD_3_LINOCR    LINFlexD_3.LINOCR.R           /* LIN Output Compare Register */
#define LINFlexD_3_LINTOCR   LINFlexD_3.LINTOCR.R          /* LIN Time-Out Control Register */
#define LINFlexD_3_LINFBRR   LINFlexD_3.LINFBRR.R          /* LIN Fractional Baud Rate Register */
#define LINFlexD_3_LINIBRR   LINFlexD_3.LINIBRR.R          /* LIN Integer Baud Rate Register */
#define LINFlexD_3_LINCFR    LINFlexD_3.LINCFR.R           /* LIN Checksum Field Register */
#define LINFlexD_3_LINCR2    LINFlexD_3.LINCR2.R           /* LIN Control Register 2 */
#define LINFlexD_3_BIDR      LINFlexD_3.BIDR.R             /* Buffer Identifier Register */
#define LINFlexD_3_BDRL      LINFlexD_3.BDRL.R             /* Buffer Data Register Least Significant */
#define LINFlexD_3_BDRM      LINFlexD_3.BDRM.R             /* Buffer Data Register Most Significant */
#define LINFlexD_3_IFER      LINFlexD_3.IFER.R             /* Identifier Filter Enable Register */
#define LINFlexD_3_IFMI      LINFlexD_3.IFMI.R             /* Identifier Filter Match Index */
#define LINFlexD_3_IFMR      LINFlexD_3.IFMR.R             /* Identifier Filter Mode Register */
#define LINFlexD_3_IFCR0     LINFlexD_3.IFCR[0].R          /* Identifier Filter Control Register */
#define LINFlexD_3_IFCR1     LINFlexD_3.IFCR[1].R          /* Identifier Filter Control Register */
#define LINFlexD_3_IFCR2     LINFlexD_3.IFCR[2].R          /* Identifier Filter Control Register */
#define LINFlexD_3_IFCR3     LINFlexD_3.IFCR[3].R          /* Identifier Filter Control Register */
#define LINFlexD_3_IFCR4     LINFlexD_3.IFCR[4].R          /* Identifier Filter Control Register */
#define LINFlexD_3_IFCR5     LINFlexD_3.IFCR[5].R          /* Identifier Filter Control Register */
#define LINFlexD_3_IFCR6     LINFlexD_3.IFCR[6].R          /* Identifier Filter Control Register */
#define LINFlexD_3_IFCR7     LINFlexD_3.IFCR[7].R          /* Identifier Filter Control Register */
#define LINFlexD_3_IFCR8     LINFlexD_3.IFCR[8].R          /* Identifier Filter Control Register */
#define LINFlexD_3_IFCR9     LINFlexD_3.IFCR[9].R          /* Identifier Filter Control Register */
#define LINFlexD_3_IFCR10    LINFlexD_3.IFCR[10].R         /* Identifier Filter Control Register */
#define LINFlexD_3_IFCR11    LINFlexD_3.IFCR[11].R         /* Identifier Filter Control Register */
#define LINFlexD_3_IFCR12    LINFlexD_3.IFCR[12].R         /* Identifier Filter Control Register */
#define LINFlexD_3_IFCR13    LINFlexD_3.IFCR[13].R         /* Identifier Filter Control Register */
#define LINFlexD_3_IFCR14    LINFlexD_3.IFCR[14].R         /* Identifier Filter Control Register */
#define LINFlexD_3_IFCR15    LINFlexD_3.IFCR[15].R         /* Identifier Filter Control Register */
#define LINFlexD_3_GCR       LINFlexD_3.GCR.R              /* Global Control Register */
#define LINFlexD_3_UARTPTO   LINFlexD_3.UARTPTO.R          /* UART Preset Timeout Register */
#define LINFlexD_3_UARTCTO   LINFlexD_3.UARTCTO.R          /* UART Current Timeout Register */
#define LINFlexD_3_DMATXE    LINFlexD_3.DMATXE.R           /* DMA Tx Enable Register */
#define LINFlexD_3_DMARXE    LINFlexD_3.DMARXE.R           /* DMA Rx Enable Register */

/* LINFlexD */
#define LINFlexD_4_LINCR1    LINFlexD_4.LINCR1.R           /* LIN Control Register 1 */
#define LINFlexD_4_LINIER    LINFlexD_4.LINIER.R           /* LIN Interrupt enable register */
#define LINFlexD_4_LINSR     LINFlexD_4.LINSR.R            /* LIN Status Register */
#define LINFlexD_4_LINESR    LINFlexD_4.LINESR.R           /* LIN Error Status Register */
#define LINFlexD_4_UARTCR    LINFlexD_4.UARTCR.R           /* UART Mode Control Register */
#define LINFlexD_4_UARTSR    LINFlexD_4.UARTSR.R           /* UART Mode Status Register */
#define LINFlexD_4_LINTCSR   LINFlexD_4.LINTCSR.R          /* LIN Time-Out Control Status Register */
#define LINFlexD_4_LINOCR    LINFlexD_4.LINOCR.R           /* LIN Output Compare Register */
#define LINFlexD_4_LINTOCR   LINFlexD_4.LINTOCR.R          /* LIN Time-Out Control Register */
#define LINFlexD_4_LINFBRR   LINFlexD_4.LINFBRR.R          /* LIN Fractional Baud Rate Register */
#define LINFlexD_4_LINIBRR   LINFlexD_4.LINIBRR.R          /* LIN Integer Baud Rate Register */
#define LINFlexD_4_LINCFR    LINFlexD_4.LINCFR.R           /* LIN Checksum Field Register */
#define LINFlexD_4_LINCR2    LINFlexD_4.LINCR2.R           /* LIN Control Register 2 */
#define LINFlexD_4_BIDR      LINFlexD_4.BIDR.R             /* Buffer Identifier Register */
#define LINFlexD_4_BDRL      LINFlexD_4.BDRL.R             /* Buffer Data Register Least Significant */
#define LINFlexD_4_BDRM      LINFlexD_4.BDRM.R             /* Buffer Data Register Most Significant */
#define LINFlexD_4_IFER      LINFlexD_4.IFER.R             /* Identifier Filter Enable Register */
#define LINFlexD_4_IFMI      LINFlexD_4.IFMI.R             /* Identifier Filter Match Index */
#define LINFlexD_4_IFMR      LINFlexD_4.IFMR.R             /* Identifier Filter Mode Register */
#define LINFlexD_4_IFCR0     LINFlexD_4.IFCR[0].R          /* Identifier Filter Control Register */
#define LINFlexD_4_IFCR1     LINFlexD_4.IFCR[1].R          /* Identifier Filter Control Register */
#define LINFlexD_4_IFCR2     LINFlexD_4.IFCR[2].R          /* Identifier Filter Control Register */
#define LINFlexD_4_IFCR3     LINFlexD_4.IFCR[3].R          /* Identifier Filter Control Register */
#define LINFlexD_4_IFCR4     LINFlexD_4.IFCR[4].R          /* Identifier Filter Control Register */
#define LINFlexD_4_IFCR5     LINFlexD_4.IFCR[5].R          /* Identifier Filter Control Register */
#define LINFlexD_4_IFCR6     LINFlexD_4.IFCR[6].R          /* Identifier Filter Control Register */
#define LINFlexD_4_IFCR7     LINFlexD_4.IFCR[7].R          /* Identifier Filter Control Register */
#define LINFlexD_4_IFCR8     LINFlexD_4.IFCR[8].R          /* Identifier Filter Control Register */
#define LINFlexD_4_IFCR9     LINFlexD_4.IFCR[9].R          /* Identifier Filter Control Register */
#define LINFlexD_4_IFCR10    LINFlexD_4.IFCR[10].R         /* Identifier Filter Control Register */
#define LINFlexD_4_IFCR11    LINFlexD_4.IFCR[11].R         /* Identifier Filter Control Register */
#define LINFlexD_4_IFCR12    LINFlexD_4.IFCR[12].R         /* Identifier Filter Control Register */
#define LINFlexD_4_IFCR13    LINFlexD_4.IFCR[13].R         /* Identifier Filter Control Register */
#define LINFlexD_4_IFCR14    LINFlexD_4.IFCR[14].R         /* Identifier Filter Control Register */
#define LINFlexD_4_IFCR15    LINFlexD_4.IFCR[15].R         /* Identifier Filter Control Register */
#define LINFlexD_4_GCR       LINFlexD_4.GCR.R              /* Global Control Register */
#define LINFlexD_4_UARTPTO   LINFlexD_4.UARTPTO.R          /* UART Preset Timeout Register */
#define LINFlexD_4_UARTCTO   LINFlexD_4.UARTCTO.R          /* UART Current Timeout Register */
#define LINFlexD_4_DMATXE    LINFlexD_4.DMATXE.R           /* DMA Tx Enable Register */
#define LINFlexD_4_DMARXE    LINFlexD_4.DMARXE.R           /* DMA Rx Enable Register */

/* LINFlexD */
#define LINFlexD_5_LINCR1    LINFlexD_5.LINCR1.R           /* LIN Control Register 1 */
#define LINFlexD_5_LINIER    LINFlexD_5.LINIER.R           /* LIN Interrupt enable register */
#define LINFlexD_5_LINSR     LINFlexD_5.LINSR.R            /* LIN Status Register */
#define LINFlexD_5_LINESR    LINFlexD_5.LINESR.R           /* LIN Error Status Register */
#define LINFlexD_5_UARTCR    LINFlexD_5.UARTCR.R           /* UART Mode Control Register */
#define LINFlexD_5_UARTSR    LINFlexD_5.UARTSR.R           /* UART Mode Status Register */
#define LINFlexD_5_LINTCSR   LINFlexD_5.LINTCSR.R          /* LIN Time-Out Control Status Register */
#define LINFlexD_5_LINOCR    LINFlexD_5.LINOCR.R           /* LIN Output Compare Register */
#define LINFlexD_5_LINTOCR   LINFlexD_5.LINTOCR.R          /* LIN Time-Out Control Register */
#define LINFlexD_5_LINFBRR   LINFlexD_5.LINFBRR.R          /* LIN Fractional Baud Rate Register */
#define LINFlexD_5_LINIBRR   LINFlexD_5.LINIBRR.R          /* LIN Integer Baud Rate Register */
#define LINFlexD_5_LINCFR    LINFlexD_5.LINCFR.R           /* LIN Checksum Field Register */
#define LINFlexD_5_LINCR2    LINFlexD_5.LINCR2.R           /* LIN Control Register 2 */
#define LINFlexD_5_BIDR      LINFlexD_5.BIDR.R             /* Buffer Identifier Register */
#define LINFlexD_5_BDRL      LINFlexD_5.BDRL.R             /* Buffer Data Register Least Significant */
#define LINFlexD_5_BDRM      LINFlexD_5.BDRM.R             /* Buffer Data Register Most Significant */
#define LINFlexD_5_IFER      LINFlexD_5.IFER.R             /* Identifier Filter Enable Register */
#define LINFlexD_5_IFMI      LINFlexD_5.IFMI.R             /* Identifier Filter Match Index */
#define LINFlexD_5_IFMR      LINFlexD_5.IFMR.R             /* Identifier Filter Mode Register */
#define LINFlexD_5_IFCR0     LINFlexD_5.IFCR[0].R          /* Identifier Filter Control Register */
#define LINFlexD_5_IFCR1     LINFlexD_5.IFCR[1].R          /* Identifier Filter Control Register */
#define LINFlexD_5_IFCR2     LINFlexD_5.IFCR[2].R          /* Identifier Filter Control Register */
#define LINFlexD_5_IFCR3     LINFlexD_5.IFCR[3].R          /* Identifier Filter Control Register */
#define LINFlexD_5_IFCR4     LINFlexD_5.IFCR[4].R          /* Identifier Filter Control Register */
#define LINFlexD_5_IFCR5     LINFlexD_5.IFCR[5].R          /* Identifier Filter Control Register */
#define LINFlexD_5_IFCR6     LINFlexD_5.IFCR[6].R          /* Identifier Filter Control Register */
#define LINFlexD_5_IFCR7     LINFlexD_5.IFCR[7].R          /* Identifier Filter Control Register */
#define LINFlexD_5_IFCR8     LINFlexD_5.IFCR[8].R          /* Identifier Filter Control Register */
#define LINFlexD_5_IFCR9     LINFlexD_5.IFCR[9].R          /* Identifier Filter Control Register */
#define LINFlexD_5_IFCR10    LINFlexD_5.IFCR[10].R         /* Identifier Filter Control Register */
#define LINFlexD_5_IFCR11    LINFlexD_5.IFCR[11].R         /* Identifier Filter Control Register */
#define LINFlexD_5_IFCR12    LINFlexD_5.IFCR[12].R         /* Identifier Filter Control Register */
#define LINFlexD_5_IFCR13    LINFlexD_5.IFCR[13].R         /* Identifier Filter Control Register */
#define LINFlexD_5_IFCR14    LINFlexD_5.IFCR[14].R         /* Identifier Filter Control Register */
#define LINFlexD_5_IFCR15    LINFlexD_5.IFCR[15].R         /* Identifier Filter Control Register */
#define LINFlexD_5_GCR       LINFlexD_5.GCR.R              /* Global Control Register */
#define LINFlexD_5_UARTPTO   LINFlexD_5.UARTPTO.R          /* UART Preset Timeout Register */
#define LINFlexD_5_UARTCTO   LINFlexD_5.UARTCTO.R          /* UART Current Timeout Register */
#define LINFlexD_5_DMATXE    LINFlexD_5.DMATXE.R           /* DMA Tx Enable Register */
#define LINFlexD_5_DMARXE    LINFlexD_5.DMARXE.R           /* DMA Rx Enable Register */

/* LINFlexD */
#define LINFlexD_6_LINCR1    LINFlexD_6.LINCR1.R           /* LIN Control Register 1 */
#define LINFlexD_6_LINIER    LINFlexD_6.LINIER.R           /* LIN Interrupt enable register */
#define LINFlexD_6_LINSR     LINFlexD_6.LINSR.R            /* LIN Status Register */
#define LINFlexD_6_LINESR    LINFlexD_6.LINESR.R           /* LIN Error Status Register */
#define LINFlexD_6_UARTCR    LINFlexD_6.UARTCR.R           /* UART Mode Control Register */
#define LINFlexD_6_UARTSR    LINFlexD_6.UARTSR.R           /* UART Mode Status Register */
#define LINFlexD_6_LINTCSR   LINFlexD_6.LINTCSR.R          /* LIN Time-Out Control Status Register */
#define LINFlexD_6_LINOCR    LINFlexD_6.LINOCR.R           /* LIN Output Compare Register */
#define LINFlexD_6_LINTOCR   LINFlexD_6.LINTOCR.R          /* LIN Time-Out Control Register */
#define LINFlexD_6_LINFBRR   LINFlexD_6.LINFBRR.R          /* LIN Fractional Baud Rate Register */
#define LINFlexD_6_LINIBRR   LINFlexD_6.LINIBRR.R          /* LIN Integer Baud Rate Register */
#define LINFlexD_6_LINCFR    LINFlexD_6.LINCFR.R           /* LIN Checksum Field Register */
#define LINFlexD_6_LINCR2    LINFlexD_6.LINCR2.R           /* LIN Control Register 2 */
#define LINFlexD_6_BIDR      LINFlexD_6.BIDR.R             /* Buffer Identifier Register */
#define LINFlexD_6_BDRL      LINFlexD_6.BDRL.R             /* Buffer Data Register Least Significant */
#define LINFlexD_6_BDRM      LINFlexD_6.BDRM.R             /* Buffer Data Register Most Significant */
#define LINFlexD_6_IFER      LINFlexD_6.IFER.R             /* Identifier Filter Enable Register */
#define LINFlexD_6_IFMI      LINFlexD_6.IFMI.R             /* Identifier Filter Match Index */
#define LINFlexD_6_IFMR      LINFlexD_6.IFMR.R             /* Identifier Filter Mode Register */
#define LINFlexD_6_IFCR0     LINFlexD_6.IFCR[0].R          /* Identifier Filter Control Register */
#define LINFlexD_6_IFCR1     LINFlexD_6.IFCR[1].R          /* Identifier Filter Control Register */
#define LINFlexD_6_IFCR2     LINFlexD_6.IFCR[2].R          /* Identifier Filter Control Register */
#define LINFlexD_6_IFCR3     LINFlexD_6.IFCR[3].R          /* Identifier Filter Control Register */
#define LINFlexD_6_IFCR4     LINFlexD_6.IFCR[4].R          /* Identifier Filter Control Register */
#define LINFlexD_6_IFCR5     LINFlexD_6.IFCR[5].R          /* Identifier Filter Control Register */
#define LINFlexD_6_IFCR6     LINFlexD_6.IFCR[6].R          /* Identifier Filter Control Register */
#define LINFlexD_6_IFCR7     LINFlexD_6.IFCR[7].R          /* Identifier Filter Control Register */
#define LINFlexD_6_IFCR8     LINFlexD_6.IFCR[8].R          /* Identifier Filter Control Register */
#define LINFlexD_6_IFCR9     LINFlexD_6.IFCR[9].R          /* Identifier Filter Control Register */
#define LINFlexD_6_IFCR10    LINFlexD_6.IFCR[10].R         /* Identifier Filter Control Register */
#define LINFlexD_6_IFCR11    LINFlexD_6.IFCR[11].R         /* Identifier Filter Control Register */
#define LINFlexD_6_IFCR12    LINFlexD_6.IFCR[12].R         /* Identifier Filter Control Register */
#define LINFlexD_6_IFCR13    LINFlexD_6.IFCR[13].R         /* Identifier Filter Control Register */
#define LINFlexD_6_IFCR14    LINFlexD_6.IFCR[14].R         /* Identifier Filter Control Register */
#define LINFlexD_6_IFCR15    LINFlexD_6.IFCR[15].R         /* Identifier Filter Control Register */
#define LINFlexD_6_GCR       LINFlexD_6.GCR.R              /* Global Control Register */
#define LINFlexD_6_UARTPTO   LINFlexD_6.UARTPTO.R          /* UART Preset Timeout Register */
#define LINFlexD_6_UARTCTO   LINFlexD_6.UARTCTO.R          /* UART Current Timeout Register */
#define LINFlexD_6_DMATXE    LINFlexD_6.DMATXE.R           /* DMA Tx Enable Register */
#define LINFlexD_6_DMARXE    LINFlexD_6.DMARXE.R           /* DMA Rx Enable Register */

/* LINFlexD */
#define LINFlexD_7_LINCR1    LINFlexD_7.LINCR1.R           /* LIN Control Register 1 */
#define LINFlexD_7_LINIER    LINFlexD_7.LINIER.R           /* LIN Interrupt enable register */
#define LINFlexD_7_LINSR     LINFlexD_7.LINSR.R            /* LIN Status Register */
#define LINFlexD_7_LINESR    LINFlexD_7.LINESR.R           /* LIN Error Status Register */
#define LINFlexD_7_UARTCR    LINFlexD_7.UARTCR.R           /* UART Mode Control Register */
#define LINFlexD_7_UARTSR    LINFlexD_7.UARTSR.R           /* UART Mode Status Register */
#define LINFlexD_7_LINTCSR   LINFlexD_7.LINTCSR.R          /* LIN Time-Out Control Status Register */
#define LINFlexD_7_LINOCR    LINFlexD_7.LINOCR.R           /* LIN Output Compare Register */
#define LINFlexD_7_LINTOCR   LINFlexD_7.LINTOCR.R          /* LIN Time-Out Control Register */
#define LINFlexD_7_LINFBRR   LINFlexD_7.LINFBRR.R          /* LIN Fractional Baud Rate Register */
#define LINFlexD_7_LINIBRR   LINFlexD_7.LINIBRR.R          /* LIN Integer Baud Rate Register */
#define LINFlexD_7_LINCFR    LINFlexD_7.LINCFR.R           /* LIN Checksum Field Register */
#define LINFlexD_7_LINCR2    LINFlexD_7.LINCR2.R           /* LIN Control Register 2 */
#define LINFlexD_7_BIDR      LINFlexD_7.BIDR.R             /* Buffer Identifier Register */
#define LINFlexD_7_BDRL      LINFlexD_7.BDRL.R             /* Buffer Data Register Least Significant */
#define LINFlexD_7_BDRM      LINFlexD_7.BDRM.R             /* Buffer Data Register Most Significant */
#define LINFlexD_7_IFER      LINFlexD_7.IFER.R             /* Identifier Filter Enable Register */
#define LINFlexD_7_IFMI      LINFlexD_7.IFMI.R             /* Identifier Filter Match Index */
#define LINFlexD_7_IFMR      LINFlexD_7.IFMR.R             /* Identifier Filter Mode Register */
#define LINFlexD_7_IFCR0     LINFlexD_7.IFCR[0].R          /* Identifier Filter Control Register */
#define LINFlexD_7_IFCR1     LINFlexD_7.IFCR[1].R          /* Identifier Filter Control Register */
#define LINFlexD_7_IFCR2     LINFlexD_7.IFCR[2].R          /* Identifier Filter Control Register */
#define LINFlexD_7_IFCR3     LINFlexD_7.IFCR[3].R          /* Identifier Filter Control Register */
#define LINFlexD_7_IFCR4     LINFlexD_7.IFCR[4].R          /* Identifier Filter Control Register */
#define LINFlexD_7_IFCR5     LINFlexD_7.IFCR[5].R          /* Identifier Filter Control Register */
#define LINFlexD_7_IFCR6     LINFlexD_7.IFCR[6].R          /* Identifier Filter Control Register */
#define LINFlexD_7_IFCR7     LINFlexD_7.IFCR[7].R          /* Identifier Filter Control Register */
#define LINFlexD_7_IFCR8     LINFlexD_7.IFCR[8].R          /* Identifier Filter Control Register */
#define LINFlexD_7_IFCR9     LINFlexD_7.IFCR[9].R          /* Identifier Filter Control Register */
#define LINFlexD_7_IFCR10    LINFlexD_7.IFCR[10].R         /* Identifier Filter Control Register */
#define LINFlexD_7_IFCR11    LINFlexD_7.IFCR[11].R         /* Identifier Filter Control Register */
#define LINFlexD_7_IFCR12    LINFlexD_7.IFCR[12].R         /* Identifier Filter Control Register */
#define LINFlexD_7_IFCR13    LINFlexD_7.IFCR[13].R         /* Identifier Filter Control Register */
#define LINFlexD_7_IFCR14    LINFlexD_7.IFCR[14].R         /* Identifier Filter Control Register */
#define LINFlexD_7_IFCR15    LINFlexD_7.IFCR[15].R         /* Identifier Filter Control Register */
#define LINFlexD_7_GCR       LINFlexD_7.GCR.R              /* Global Control Register */
#define LINFlexD_7_UARTPTO   LINFlexD_7.UARTPTO.R          /* UART Preset Timeout Register */
#define LINFlexD_7_UARTCTO   LINFlexD_7.UARTCTO.R          /* UART Current Timeout Register */
#define LINFlexD_7_DMATXE    LINFlexD_7.DMATXE.R           /* DMA Tx Enable Register */
#define LINFlexD_7_DMARXE    LINFlexD_7.DMARXE.R           /* DMA Rx Enable Register */

/* LINFlexD */
#define LINFlexD_8_LINCR1    LINFlexD_8.LINCR1.R           /* LIN Control Register 1 */
#define LINFlexD_8_LINIER    LINFlexD_8.LINIER.R           /* LIN Interrupt enable register */
#define LINFlexD_8_LINSR     LINFlexD_8.LINSR.R            /* LIN Status Register */
#define LINFlexD_8_LINESR    LINFlexD_8.LINESR.R           /* LIN Error Status Register */
#define LINFlexD_8_UARTCR    LINFlexD_8.UARTCR.R           /* UART Mode Control Register */
#define LINFlexD_8_UARTSR    LINFlexD_8.UARTSR.R           /* UART Mode Status Register */
#define LINFlexD_8_LINTCSR   LINFlexD_8.LINTCSR.R          /* LIN Time-Out Control Status Register */
#define LINFlexD_8_LINOCR    LINFlexD_8.LINOCR.R           /* LIN Output Compare Register */
#define LINFlexD_8_LINTOCR   LINFlexD_8.LINTOCR.R          /* LIN Time-Out Control Register */
#define LINFlexD_8_LINFBRR   LINFlexD_8.LINFBRR.R          /* LIN Fractional Baud Rate Register */
#define LINFlexD_8_LINIBRR   LINFlexD_8.LINIBRR.R          /* LIN Integer Baud Rate Register */
#define LINFlexD_8_LINCFR    LINFlexD_8.LINCFR.R           /* LIN Checksum Field Register */
#define LINFlexD_8_LINCR2    LINFlexD_8.LINCR2.R           /* LIN Control Register 2 */
#define LINFlexD_8_BIDR      LINFlexD_8.BIDR.R             /* Buffer Identifier Register */
#define LINFlexD_8_BDRL      LINFlexD_8.BDRL.R             /* Buffer Data Register Least Significant */
#define LINFlexD_8_BDRM      LINFlexD_8.BDRM.R             /* Buffer Data Register Most Significant */
#define LINFlexD_8_IFER      LINFlexD_8.IFER.R             /* Identifier Filter Enable Register */
#define LINFlexD_8_IFMI      LINFlexD_8.IFMI.R             /* Identifier Filter Match Index */
#define LINFlexD_8_IFMR      LINFlexD_8.IFMR.R             /* Identifier Filter Mode Register */
#define LINFlexD_8_IFCR0     LINFlexD_8.IFCR[0].R          /* Identifier Filter Control Register */
#define LINFlexD_8_IFCR1     LINFlexD_8.IFCR[1].R          /* Identifier Filter Control Register */
#define LINFlexD_8_IFCR2     LINFlexD_8.IFCR[2].R          /* Identifier Filter Control Register */
#define LINFlexD_8_IFCR3     LINFlexD_8.IFCR[3].R          /* Identifier Filter Control Register */
#define LINFlexD_8_IFCR4     LINFlexD_8.IFCR[4].R          /* Identifier Filter Control Register */
#define LINFlexD_8_IFCR5     LINFlexD_8.IFCR[5].R          /* Identifier Filter Control Register */
#define LINFlexD_8_IFCR6     LINFlexD_8.IFCR[6].R          /* Identifier Filter Control Register */
#define LINFlexD_8_IFCR7     LINFlexD_8.IFCR[7].R          /* Identifier Filter Control Register */
#define LINFlexD_8_IFCR8     LINFlexD_8.IFCR[8].R          /* Identifier Filter Control Register */
#define LINFlexD_8_IFCR9     LINFlexD_8.IFCR[9].R          /* Identifier Filter Control Register */
#define LINFlexD_8_IFCR10    LINFlexD_8.IFCR[10].R         /* Identifier Filter Control Register */
#define LINFlexD_8_IFCR11    LINFlexD_8.IFCR[11].R         /* Identifier Filter Control Register */
#define LINFlexD_8_IFCR12    LINFlexD_8.IFCR[12].R         /* Identifier Filter Control Register */
#define LINFlexD_8_IFCR13    LINFlexD_8.IFCR[13].R         /* Identifier Filter Control Register */
#define LINFlexD_8_IFCR14    LINFlexD_8.IFCR[14].R         /* Identifier Filter Control Register */
#define LINFlexD_8_IFCR15    LINFlexD_8.IFCR[15].R         /* Identifier Filter Control Register */
#define LINFlexD_8_GCR       LINFlexD_8.GCR.R              /* Global Control Register */
#define LINFlexD_8_UARTPTO   LINFlexD_8.UARTPTO.R          /* UART Preset Timeout Register */
#define LINFlexD_8_UARTCTO   LINFlexD_8.UARTCTO.R          /* UART Current Timeout Register */
#define LINFlexD_8_DMATXE    LINFlexD_8.DMATXE.R           /* DMA Tx Enable Register */
#define LINFlexD_8_DMARXE    LINFlexD_8.DMARXE.R           /* DMA Rx Enable Register */

/* LINFlexD */
#define LINFlexD_9_LINCR1    LINFlexD_9.LINCR1.R           /* LIN Control Register 1 */
#define LINFlexD_9_LINIER    LINFlexD_9.LINIER.R           /* LIN Interrupt enable register */
#define LINFlexD_9_LINSR     LINFlexD_9.LINSR.R            /* LIN Status Register */
#define LINFlexD_9_LINESR    LINFlexD_9.LINESR.R           /* LIN Error Status Register */
#define LINFlexD_9_UARTCR    LINFlexD_9.UARTCR.R           /* UART Mode Control Register */
#define LINFlexD_9_UARTSR    LINFlexD_9.UARTSR.R           /* UART Mode Status Register */
#define LINFlexD_9_LINTCSR   LINFlexD_9.LINTCSR.R          /* LIN Time-Out Control Status Register */
#define LINFlexD_9_LINOCR    LINFlexD_9.LINOCR.R           /* LIN Output Compare Register */
#define LINFlexD_9_LINTOCR   LINFlexD_9.LINTOCR.R          /* LIN Time-Out Control Register */
#define LINFlexD_9_LINFBRR   LINFlexD_9.LINFBRR.R          /* LIN Fractional Baud Rate Register */
#define LINFlexD_9_LINIBRR   LINFlexD_9.LINIBRR.R          /* LIN Integer Baud Rate Register */
#define LINFlexD_9_LINCFR    LINFlexD_9.LINCFR.R           /* LIN Checksum Field Register */
#define LINFlexD_9_LINCR2    LINFlexD_9.LINCR2.R           /* LIN Control Register 2 */
#define LINFlexD_9_BIDR      LINFlexD_9.BIDR.R             /* Buffer Identifier Register */
#define LINFlexD_9_BDRL      LINFlexD_9.BDRL.R             /* Buffer Data Register Least Significant */
#define LINFlexD_9_BDRM      LINFlexD_9.BDRM.R             /* Buffer Data Register Most Significant */
#define LINFlexD_9_IFER      LINFlexD_9.IFER.R             /* Identifier Filter Enable Register */
#define LINFlexD_9_IFMI      LINFlexD_9.IFMI.R             /* Identifier Filter Match Index */
#define LINFlexD_9_IFMR      LINFlexD_9.IFMR.R             /* Identifier Filter Mode Register */
#define LINFlexD_9_IFCR0     LINFlexD_9.IFCR[0].R          /* Identifier Filter Control Register */
#define LINFlexD_9_IFCR1     LINFlexD_9.IFCR[1].R          /* Identifier Filter Control Register */
#define LINFlexD_9_IFCR2     LINFlexD_9.IFCR[2].R          /* Identifier Filter Control Register */
#define LINFlexD_9_IFCR3     LINFlexD_9.IFCR[3].R          /* Identifier Filter Control Register */
#define LINFlexD_9_IFCR4     LINFlexD_9.IFCR[4].R          /* Identifier Filter Control Register */
#define LINFlexD_9_IFCR5     LINFlexD_9.IFCR[5].R          /* Identifier Filter Control Register */
#define LINFlexD_9_IFCR6     LINFlexD_9.IFCR[6].R          /* Identifier Filter Control Register */
#define LINFlexD_9_IFCR7     LINFlexD_9.IFCR[7].R          /* Identifier Filter Control Register */
#define LINFlexD_9_IFCR8     LINFlexD_9.IFCR[8].R          /* Identifier Filter Control Register */
#define LINFlexD_9_IFCR9     LINFlexD_9.IFCR[9].R          /* Identifier Filter Control Register */
#define LINFlexD_9_IFCR10    LINFlexD_9.IFCR[10].R         /* Identifier Filter Control Register */
#define LINFlexD_9_IFCR11    LINFlexD_9.IFCR[11].R         /* Identifier Filter Control Register */
#define LINFlexD_9_IFCR12    LINFlexD_9.IFCR[12].R         /* Identifier Filter Control Register */
#define LINFlexD_9_IFCR13    LINFlexD_9.IFCR[13].R         /* Identifier Filter Control Register */
#define LINFlexD_9_IFCR14    LINFlexD_9.IFCR[14].R         /* Identifier Filter Control Register */
#define LINFlexD_9_IFCR15    LINFlexD_9.IFCR[15].R         /* Identifier Filter Control Register */
#define LINFlexD_9_GCR       LINFlexD_9.GCR.R              /* Global Control Register */
#define LINFlexD_9_UARTPTO   LINFlexD_9.UARTPTO.R          /* UART Preset Timeout Register */
#define LINFlexD_9_UARTCTO   LINFlexD_9.UARTCTO.R          /* UART Current Timeout Register */
#define LINFlexD_9_DMATXE    LINFlexD_9.DMATXE.R           /* DMA Tx Enable Register */
#define LINFlexD_9_DMARXE    LINFlexD_9.DMARXE.R           /* DMA Rx Enable Register */

/* LPU */
#define LPU_MCTL             LPU.MCTL.R                    /* LPU Mode Control Register */
#define LPU_RUN_CF           LPU.RUN_CF.R                  /* LPU Run Configuration Register */
#define LPU_STOP_CF          LPU.STOP_CF.R                 /* LPU Stop Configuration Register */
#define LPU_STANDBY_CF       LPU.STANDBY_CF.R              /* LPU Standby Configuration Register */
#define LPU_SR               LPU.SR.R                      /* LPU Status Register */
#define LPU_ICR              LPU.ICR.R                     /* LPU Interrupt control register */
#define LPU_MDIS             LPU.MDIS.R                    /* Module Disable */

/* MC_CGM */
#define MC_CGM_CLKOUT1_SC    MC_CGM.CLKOUT1_SC.R           /* Clockout 1 Select Register */
#define MC_CGM_CLKOUT1_DC    MC_CGM.CLKOUT1_DC.R           /* CLKOUT1_DC Configuration Register */
#define MC_CGM_AC5_SC        MC_CGM.AC5_SC.R               /* Auxiliary Clock 5 Select Control Register */
#define MC_CGM_AC5_SS        MC_CGM.AC5_SS.R               /* Auxiliary Clock 5 Select Status Register */
#define MC_CGM_SC_DC6        MC_CGM.SC_DC6.R               /* System Clock Divider 6 Configuration Register */
#define MC_CGM_AC7_SC        MC_CGM.AC7_SC.R               /* Auxiliary Clock 7 Select Control Register */
#define MC_CGM_AC7_SS        MC_CGM.AC7_SS.R               /* Auxiliary Clock 7 Select Status Register */
#define MC_CGM_AC8_SC        MC_CGM.AC8_SC.R               /* Auxiliary Clock 8 Select Control Register */
#define MC_CGM_AC8_SS        MC_CGM.AC8_SS.R               /* Auxiliary Clock 8 Select Status Register */
#define MC_CGM_AC9_SC        MC_CGM.AC9_SC.R               /* Auxiliary Clock 9 Select Control Register */
#define MC_CGM_AC9_SS        MC_CGM.AC9_SS.R               /* Auxiliary Clock 9 Select Status Register */
#define MC_CGM_PCS_SDUR      MC_CGM.PCS_SDUR.R             /* PCS Switch Duration Register */
#define MC_CGM_PCS_DIVC1     MC_CGM.PCS_DIVC1.R            /* PCS Divider Change Register 1 */
#define MC_CGM_PCS_DIVE1     MC_CGM.PCS_DIVE1.R            /* PCS Divider End Register 1 */
#define MC_CGM_PCS_DIVS1     MC_CGM.PCS_DIVS1.R            /* PCS Divider Start Register 1 */
#define MC_CGM_PCS_DIVC2     MC_CGM.PCS_DIVC2.R            /* PCS Divider Change Register 2 */
#define MC_CGM_PCS_DIVE2     MC_CGM.PCS_DIVE2.R            /* PCS Divider End Register 2 */
#define MC_CGM_PCS_DIVS2     MC_CGM.PCS_DIVS2.R            /* PCS Divider Start Register 2 */
#define MC_CGM_DIV_UPD_ABRTD MC_CGM.DIV_UPD_ABRTD.R        /* Divider Update Abort Register */
#define MC_CGM_SC_DIV_RC     MC_CGM.SC_DIV_RC.R            /* System Clock Divider Ratio Change Register */
#define MC_CGM_DIV_UPD_TYPE  MC_CGM.DIV_UPD_TYPE.R         /* Divider Update Type Register */
#define MC_CGM_DIV_UPD_TRIG  MC_CGM.DIV_UPD_TRIG.R         /* Divider Update Trigger Register */
#define MC_CGM_DIV_UPD_STAT  MC_CGM.DIV_UPD_STAT.R         /* Divider Update Status Register */
#define MC_CGM_SC_SS         MC_CGM.SC_SS.R                /* System Clock Select Status Register */
#define MC_CGM_SC_DC0        MC_CGM.SC_DC0.R               /* System Clock Divider 0 Configuration Register */
#define MC_CGM_SC_DC1        MC_CGM.SC_DC1.R               /* System Clock Divider 1 Configuration Register */
#define MC_CGM_SC_DC2        MC_CGM.SC_DC2.R               /* System Clock Divider 2 Configuration Register */
#define MC_CGM_SC_DC3        MC_CGM.SC_DC3.R               /* System Clock Divider 3 Configuration Register */
#define MC_CGM_SC_DC4        MC_CGM.SC_DC4.R               /* System Clock Divider 4 Configuration Register */
#define MC_CGM_SC_DC5        MC_CGM.SC_DC5.R               /* System Clock Divider 5 Configuration Register */
#define MC_CGM_AC2_SC        MC_CGM.AC2_SC.R               /* Auxiliary Clock 2 Select Control Register */
#define MC_CGM_AC2_SS        MC_CGM.AC2_SS.R               /* Auxiliary Clock 2 Select Status Register */
#define MC_CGM_AC3_SC        MC_CGM.AC3_SC.R               /* Auxiliary Clock 3 Select Control Register */
#define MC_CGM_AC3_SS        MC_CGM.AC3_SS.R               /* Auxiliary Clock 3 Select Status Register */
#define MC_CGM_AC6_SC        MC_CGM.AC6_SC.R               /* Auxiliary Clock 6 Select Control Register */
#define MC_CGM_AC6_SS        MC_CGM.AC6_SS.R               /* Auxiliary Clock 6 Select Status Register */
#define MC_CGM_AC6_DC0       MC_CGM.AC6_DC0.R              /* Aux Clock 6 Divider Configuration 0 for CLKOUT_0 */

/* MC_ME */
#define MC_ME_GS             MC_ME.GS.R                    /* Global Status Register */
#define MC_ME_MCTL           MC_ME.MCTL.R                  /* Mode Control Register */
#define MC_ME_ME             MC_ME.ME.R                    /* Mode Enable Register */
#define MC_ME_IS             MC_ME.IS.R                    /* Interrupt Status Register */
#define MC_ME_IM             MC_ME.IM.R                    /* Interrupt Mask Register */
#define MC_ME_IMTS           MC_ME.IMTS.R                  /* Invalid Mode Transition Status Register */
#define MC_ME_DMTS           MC_ME.DMTS.R                  /* Debug Mode Transition Status Register */
#define MC_ME_RESET_MC       MC_ME.RESET_MC.R              /* RESET Mode Configuration Register */
#define MC_ME_SAFE_MC        MC_ME.SAFE_MC.R               /* SAFE Mode Configuration Register */
#define MC_ME_DRUN_MC        MC_ME.DRUN_MC.R               /* DRUN Mode Configuration Register */
#define MC_ME_RUN0_MC        MC_ME.RUN_MC[0].R             /* RUN0 Mode Configuration Register */
#define MC_ME_RUN1_MC        MC_ME.RUN_MC[1].R             /* RUN1 Mode Configuration Register */
#define MC_ME_RUN2_MC        MC_ME.RUN_MC[2].R             /* RUN2 Mode Configuration Register */
#define MC_ME_RUN3_MC        MC_ME.RUN_MC[3].R             /* RUN3 Mode Configuration Register */
#define MC_ME_STOP_MC        MC_ME.STOP_MC.R               /* STOP0 Mode Configuration Register */
#define MC_ME_STANDBY_MC     MC_ME.STANDBY_MC.R            /* STANDBY0 Mode Configuration Register */
#define MC_ME_PS0            MC_ME.PS0.R                   /* Peripheral Status Register 0 */
#define MC_ME_PS1            MC_ME.PS1.R                   /* Peripheral Status Register 1 */
#define MC_ME_PS2            MC_ME.PS2.R                   /* Peripheral Status Register 2 */
#define MC_ME_PS3            MC_ME.PS3.R                   /* Peripheral Status Register 3 */
#define MC_ME_RUN_PC0        MC_ME.RUN_PC[0].R             /* Run Peripheral Configuration Register */
#define MC_ME_RUN_PC1        MC_ME.RUN_PC[1].R             /* Run Peripheral Configuration Register */
#define MC_ME_RUN_PC2        MC_ME.RUN_PC[2].R             /* Run Peripheral Configuration Register */
#define MC_ME_RUN_PC3        MC_ME.RUN_PC[3].R             /* Run Peripheral Configuration Register */
#define MC_ME_RUN_PC4        MC_ME.RUN_PC[4].R             /* Run Peripheral Configuration Register */
#define MC_ME_RUN_PC5        MC_ME.RUN_PC[5].R             /* Run Peripheral Configuration Register */
#define MC_ME_RUN_PC6        MC_ME.RUN_PC[6].R             /* Run Peripheral Configuration Register */
#define MC_ME_RUN_PC7        MC_ME.RUN_PC[7].R             /* Run Peripheral Configuration Register */
#define MC_ME_LP_PC0         MC_ME.LP_PC[0].R              /* Low-Power Peripheral Configuration Register */
#define MC_ME_LP_PC1         MC_ME.LP_PC[1].R              /* Low-Power Peripheral Configuration Register */
#define MC_ME_LP_PC2         MC_ME.LP_PC[2].R              /* Low-Power Peripheral Configuration Register */
#define MC_ME_LP_PC3         MC_ME.LP_PC[3].R              /* Low-Power Peripheral Configuration Register */
#define MC_ME_LP_PC4         MC_ME.LP_PC[4].R              /* Low-Power Peripheral Configuration Register */
#define MC_ME_LP_PC5         MC_ME.LP_PC[5].R              /* Low-Power Peripheral Configuration Register */
#define MC_ME_LP_PC6         MC_ME.LP_PC[6].R              /* Low-Power Peripheral Configuration Register */
#define MC_ME_LP_PC7         MC_ME.LP_PC[7].R              /* Low-Power Peripheral Configuration Register */
#define MC_ME_PCTL0          MC_ME.PCTL[0].R               /* BCTU Peripheral Control Register */
#define MC_ME_PCTL1          MC_ME.PCTL[1].R               /* eMIOS_0 Peripheral Control Register */
#define MC_ME_PCTL2          MC_ME.PCTL[2].R               /* eMIOS_1 Peripheral Control Register */
#define MC_ME_PCTL3          MC_ME.PCTL[3].R               /*  */
#define MC_ME_PCTL4          MC_ME.PCTL[4].R               /*  */
#define MC_ME_PCTL5          MC_ME.PCTL[5].R               /*  */
#define MC_ME_PCTL6          MC_ME.PCTL[6].R               /*  */
#define MC_ME_PCTL7          MC_ME.PCTL[7].R               /*  */
#define MC_ME_PCTL8          MC_ME.PCTL[8].R               /*  */
#define MC_ME_PCTL9          MC_ME.PCTL[9].R               /*  */
#define MC_ME_PCTL10         MC_ME.PCTL[10].R              /* SAI0 Peripheral Control Register */
#define MC_ME_PCTL11         MC_ME.PCTL[11].R              /* SAI1 Peripheral Control Register */
#define MC_ME_PCTL12         MC_ME.PCTL[12].R              /* SAI2 Peripheral Control Register */
#define MC_ME_PCTL13         MC_ME.PCTL[13].R              /*  */
#define MC_ME_PCTL14         MC_ME.PCTL[14].R              /*  */
#define MC_ME_PCTL15         MC_ME.PCTL[15].R              /* ENET Peripheral Control Register */
#define MC_ME_PCTL16         MC_ME.PCTL[16].R              /*  */
#define MC_ME_PCTL17         MC_ME.PCTL[17].R              /*  */
#define MC_ME_PCTL18         MC_ME.PCTL[18].R              /*  */
#define MC_ME_PCTL19         MC_ME.PCTL[19].R              /*  */
#define MC_ME_PCTL20         MC_ME.PCTL[20].R              /* CMP_0 Peripheral Control Register */
#define MC_ME_PCTL21         MC_ME.PCTL[21].R              /* CMP_1 Peripheral Control Register */
#define MC_ME_PCTL22         MC_ME.PCTL[22].R              /* CMP_2 Peripheral Control Register */
#define MC_ME_PCTL23         MC_ME.PCTL[23].R              /*  */
#define MC_ME_PCTL24         MC_ME.PCTL[24].R              /* ADC_0 Peripheral Control Register */
#define MC_ME_PCTL25         MC_ME.PCTL[25].R              /* ADC_1 Peripheral Control Register */
#define MC_ME_PCTL26         MC_ME.PCTL[26].R              /*  */
#define MC_ME_PCTL27         MC_ME.PCTL[27].R              /*  */
#define MC_ME_PCTL28         MC_ME.PCTL[28].R              /* FlexRay Peripheral Control Register */
#define MC_ME_PCTL29         MC_ME.PCTL[29].R              /*  */
#define MC_ME_PCTL30         MC_ME.PCTL[30].R              /* IIC_0 Peripheral Control Register */
#define MC_ME_PCTL31         MC_ME.PCTL[31].R              /* IIC_1 Peripheral Control Register */
#define MC_ME_PCTL32         MC_ME.PCTL[32].R              /* IIC_2 Peripheral Control Register */
#define MC_ME_PCTL33         MC_ME.PCTL[33].R              /* IIC_3 Peripheral Control Register */
#define MC_ME_PCTL34         MC_ME.PCTL[34].R              /*  */
#define MC_ME_PCTL35         MC_ME.PCTL[35].R              /*  */
#define MC_ME_PCTL36         MC_ME.PCTL[36].R              /*  */
#define MC_ME_PCTL37         MC_ME.PCTL[37].R              /*  */
#define MC_ME_PCTL38         MC_ME.PCTL[38].R              /*  */
#define MC_ME_PCTL39         MC_ME.PCTL[39].R              /*  */
#define MC_ME_PCTL40         MC_ME.PCTL[40].R              /* DSPI_0 Peripheral Control Register */
#define MC_ME_PCTL41         MC_ME.PCTL[41].R              /* DSPI_1 Peripheral Control Register */
#define MC_ME_PCTL42         MC_ME.PCTL[42].R              /* DSPI_2 Peripheral Control Register */
#define MC_ME_PCTL43         MC_ME.PCTL[43].R              /* DSPI_3 Peripheral Control Register */
#define MC_ME_PCTL44         MC_ME.PCTL[44].R              /*  */
#define MC_ME_PCTL45         MC_ME.PCTL[45].R              /*  */
#define MC_ME_PCTL46         MC_ME.PCTL[46].R              /*  */
#define MC_ME_PCTL47         MC_ME.PCTL[47].R              /*  */
#define MC_ME_PCTL48         MC_ME.PCTL[48].R              /*  */
#define MC_ME_PCTL49         MC_ME.PCTL[49].R              /*  */
#define MC_ME_PCTL50         MC_ME.PCTL[50].R              /* LIN_0 Peripheral Control Register */
#define MC_ME_PCTL51         MC_ME.PCTL[51].R              /* LIN_1 Peripheral Control Register */
#define MC_ME_PCTL52         MC_ME.PCTL[52].R              /* LIN_2 Peripheral Control Register */
#define MC_ME_PCTL53         MC_ME.PCTL[53].R              /* LIN_3 Peripheral Control Register */
#define MC_ME_PCTL54         MC_ME.PCTL[54].R              /* LIN_4 Peripheral Control Register */
#define MC_ME_PCTL55         MC_ME.PCTL[55].R              /* LIN_5 Peripheral Control Register */
#define MC_ME_PCTL56         MC_ME.PCTL[56].R              /* LIN_6 Peripheral Control Register */
#define MC_ME_PCTL57         MC_ME.PCTL[57].R              /* LIN_7 Peripheral Control Register */
#define MC_ME_PCTL58         MC_ME.PCTL[58].R              /* LIN 8 Peripheral Control Register */
#define MC_ME_PCTL59         MC_ME.PCTL[59].R              /* LIN_9 Peripheral Control Register */
#define MC_ME_PCTL60         MC_ME.PCTL[60].R              /* LIN_10 Peripheral Control Register */
#define MC_ME_PCTL61         MC_ME.PCTL[61].R              /* LIN_11 Peripheral Control Register */
#define MC_ME_PCTL62         MC_ME.PCTL[62].R              /* LIN 12 Peripheral Control Register */
#define MC_ME_PCTL63         MC_ME.PCTL[63].R              /* LIN_13 Peripheral Control Register */
#define MC_ME_PCTL64         MC_ME.PCTL[64].R              /* LIN 14 Peripheral Control Register */
#define MC_ME_PCTL65         MC_ME.PCTL[65].R              /* LIN_15 Peripheral Control Register */
#define MC_ME_PCTL66         MC_ME.PCTL[66].R              /*  */
#define MC_ME_PCTL67         MC_ME.PCTL[67].R              /*  */
#define MC_ME_PCTL68         MC_ME.PCTL[68].R              /*  */
#define MC_ME_PCTL69         MC_ME.PCTL[69].R              /*  */
#define MC_ME_PCTL70         MC_ME.PCTL[70].R              /* FLEXCAN_0 Peripheral Control Register */
#define MC_ME_PCTL71         MC_ME.PCTL[71].R              /* FLEXCAN_1 Peripheral Control Register */
#define MC_ME_PCTL72         MC_ME.PCTL[72].R              /* FLEXCAN_2 Peripheral Control Register */
#define MC_ME_PCTL73         MC_ME.PCTL[73].R              /* FLEXCAN_3 Peripheral Control Register */
#define MC_ME_PCTL74         MC_ME.PCTL[74].R              /* FLEXCAN_4 Peripheral Control Register */
#define MC_ME_PCTL75         MC_ME.PCTL[75].R              /* FLEXCAN_5 Peripheral Control Register */
#define MC_ME_PCTL76         MC_ME.PCTL[76].R              /* FLEXCAN_6 Peripheral Control Register */
#define MC_ME_PCTL77         MC_ME.PCTL[77].R              /* FLEXCAN_7 Peripheral Control Register */
#define MC_ME_PCTL78         MC_ME.PCTL[78].R              /*  */
#define MC_ME_PCTL79         MC_ME.PCTL[79].R              /*  */
#define MC_ME_PCTL80         MC_ME.PCTL[80].R              /*  */
#define MC_ME_PCTL81         MC_ME.PCTL[81].R              /* TDM Control Register */
#define MC_ME_PCTL82         MC_ME.PCTL[82].R              /* JDC Control Register */
#define MC_ME_PCTL83         MC_ME.PCTL[83].R              /* MEMU_0 Control Register */
#define MC_ME_PCTL84         MC_ME.PCTL[84].R              /* CRC Control Register */
#define MC_ME_PCTL85         MC_ME.PCTL[85].R              /*  */
#define MC_ME_PCTL86         MC_ME.PCTL[86].R              /*  */
#define MC_ME_PCTL87         MC_ME.PCTL[87].R              /*  */
#define MC_ME_PCTL88         MC_ME.PCTL[88].R              /*  */
#define MC_ME_PCTL89         MC_ME.PCTL[89].R              /*  */
#define MC_ME_PCTL90         MC_ME.PCTL[90].R              /* DMAMUX Control Register */
#define MC_ME_PCTL91         MC_ME.PCTL[91].R              /* PIT_RTI_0 Control Register */
#define MC_ME_PCTL92         MC_ME.PCTL[92].R              /*  */
#define MC_ME_PCTL93         MC_ME.PCTL[93].R              /* WKPU Control Register */
#define MC_ME_PCTL94         MC_ME.PCTL[94].R              /*  */
#define MC_ME_PCTL95         MC_ME.PCTL[95].R              /*  */
#define MC_ME_PCTL96         MC_ME.PCTL[96].R              /* SPI0 Control Register */
#define MC_ME_PCTL97         MC_ME.PCTL[97].R              /* SPI1 Control Register */
#define MC_ME_PCTL98         MC_ME.PCTL[98].R              /* SPI2 Control Register */
#define MC_ME_PCTL99         MC_ME.PCTL[99].R              /* SPI3 Control Register */
#define MC_ME_PCTL100        MC_ME.PCTL[100].R             /*  */
#define MC_ME_PCTL101        MC_ME.PCTL[101].R             /*  */
#define MC_ME_PCTL102        MC_ME.PCTL[102].R             /* RTC-API Control Register */
#define MC_ME_PCTL103        MC_ME.PCTL[103].R             /*  */
#define MC_ME_PCTL104        MC_ME.PCTL[104].R             /*  */
#define MC_ME_PCTL105        MC_ME.PCTL[105].R             /* MEMU_1 Control Register */
#define MC_ME_CS             MC_ME.CS.R                    /* Core Status Register */
#define MC_ME_CCTL1          MC_ME.CCTL1.R                 /* Core1 Control Register */
#define MC_ME_CCTL3          MC_ME.CCTL3.R                 /* Core3 Control Register */
#define MC_ME_CADDR1         MC_ME.CADDR1.R                /* CORE1 Address Register */
#define MC_ME_CADDR3         MC_ME.CADDR3.R                /* CORE3 Address Register */

/* MC_PCU */
#define MC_PCU_PCONF0        MC_PCU.PCONF0.R               /* Power Domain #0 Configuration Register */
#define MC_PCU_PCONF1        MC_PCU.PCONF1.R               /* Power Domain #1 Configuration Register */
#define MC_PCU_PSTAT         MC_PCU.PSTAT.R                /* Power Domain Status Register */

/* MC_RGM */
#define MC_RGM_DES           MC_RGM.DES.R                  /* 'Destructive' Event Status Register */
#define MC_RGM_DERD          MC_RGM.DERD.R                 /* 'Destructive' Event Reset Disable Register */
#define MC_RGM_DBRE          MC_RGM.DBRE.R                 /* 'Destructive' Bidirectional Reset Enable Register */
#define MC_RGM_FESS          MC_RGM.FESS.R                 /* 'Functional' Event Short Sequence Register */
#define MC_RGM_FES           MC_RGM.FES.R                  /* 'Functional' Event Status Register */
#define MC_RGM_FERD          MC_RGM.FERD.R                 /* 'Functional' Event Reset Disable Register */
#define