/*-----------------------------------------------------------------------------
  Copyright (c) 2015 by Freescale Semiconductor, All Rights reserved.

  This is unpublished proprietary source code of Freescale.
  The copyright notice above does not imply any actual or
  intended publication of such source code.

  FREESCALE CONFIDENTIAL PROPRIETARY

  ---------------------------------------------------------------------------*/
/*-----------------------------------------------------------------------------
  FILE NAME      : CBC_testflash.c
  DEPARTMENT     : AISG
  -----------------------------------------------------------------------------
  REVISION HISTORY
            Date D/M/Y                     DESCRIPTION              
            ----------                 ---------------------
            27/7/2015                    Initial Version
       --------------------- 	       ---------------------
  KEYWORDS :HSM, Security
  -----------------------------------------------------------------------------
  PURPOSE : To check the CBC encryption and decryption functionalities 
  ---------------------------------------------------------------------------*/

/*=============================================================================
  INCLUDE FILES
  ===========================================================================*/
#include "common.h"
#include "hsm.h"
/*=============================================================================
  LOCAL CONSTANTS
  ===========================================================================*/

/*=============================================================================
  LOCAL TYPEDEFS (STRUCTURES, UNIONS, ENUMS)
  ===========================================================================*/
extern struct HSM_CMD_struct HSM_CMD;
/*=============================================================================
  LOCAL VARIABLES
  ===========================================================================*/

/*AES 128 CBC mode test vectors*/
/* key for encryption and decryption */
#pragma alignvar (4)
uint8_t key_cbc[16] = {                                	
    0x2b, 0x7e, 0x15, 0x16, 0x28, 0xae, 0xd2, 0xa6,
    0xab, 0xf7, 0x15, 0x88, 0x09, 0xcf, 0x4f, 0x3c
};
/* Initialization Vector */
#pragma alignvar (4)
uint8_t IV[16] = {					
    0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
    0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f
};
/* Plain text data */
#pragma alignvar (4)
uint8_t cbc_plaintext[64] = {				
    0x6b, 0xc1, 0xbe, 0xe2, 0x2e, 0x40, 0x9f, 0x96,
    0xe9, 0x3d, 0x7e, 0x11, 0x73, 0x93, 0x17, 0x2a,
    0xae, 0x2d, 0x8a, 0x57, 0x1e, 0x03, 0xac, 0x9c,
    0x9e, 0xb7, 0x6f, 0xac, 0x45, 0xaf, 0x8e, 0x51,
    0x30, 0xc8, 0x1c, 0x46, 0xa3, 0x5c, 0xe4, 0x11,
    0xe5, 0xfb, 0xc1, 0x19, 0x1a, 0x0a, 0x52, 0xef,
    0xf6, 0x9f, 0x24, 0x45, 0xdf, 0x4f, 0x9b, 0x17,
    0xad, 0x2b, 0x41, 0x7b, 0xe6, 0x6c, 0x37, 0x10
};
/* Encrypted above plaintext data */
#pragma alignvar (4)
uint8_t cbc_cycphertext[64] = {				
    0x76, 0x49, 0xab, 0xac, 0x81, 0x19, 0xb2, 0x46,
    0xce, 0xe9, 0x8e, 0x9b, 0x12, 0xe9, 0x19, 0x7d,
    0x50, 0x86, 0xcb, 0x9b, 0x50, 0x72, 0x19, 0xee,
    0x95, 0xdb, 0x11, 0x3a, 0x91, 0x76, 0x78, 0xb2,
    0x73, 0xbe, 0xd6, 0xb8, 0xe3, 0xc1, 0x74, 0x3b,
    0x71, 0x16, 0xe6, 0x9e, 0x22, 0x22, 0x95, 0x16,
    0x3f, 0xf1, 0xca, 0xa1, 0x68, 0x1f, 0xac, 0x09,
    0x12, 0x0e, 0xca, 0x30, 0x75, 0x86, 0xe1, 0xa7
};
#pragma alignvar (4)
uint8_t cbc_cyphertextDst[64];

#pragma alignvar(4)
uint8_t cbc_plaintxtDst[64];

/*=============================================================================
  LOCAL FUNCTION PROTOTYPES
  ===========================================================================*/
extern void host_pll_fxosc_setup();
extern void host_pll_firc_setup();
/*=============================================================================
  GLOBAL VARIABLES
  ===========================================================================*/

/*=============================================================================
  LOCAL FUNCTIONS
  ===========================================================================*/
void CBC_Test();
/*=============================================================================
  FUNCTION: CBC_Test

  DESCRIPTION:
  This function is used to check CBC encryption and decryption functionalities 

  ARGUMENTS PASSED:
  None

  RETURN VALUE:
  None

  PRE-CONDITIONS:
  None

  POST-CONDITIONS:
  None

  IMPORTANT NOTES:
  None

  ===========================================================================*/
void CBC_Test()
{
    uint32_t i;
    uint32_t error1=0,error2=0,error3=0,error4=0;

/* load key_cbc in RAM Key */
    /* key_cbc is loaded to RAM_KEY for encryption and decryption */
    while(HSM.HSM2HTS.B.BUSY == 1);   
    HSM_load_plain_key((uint32_t) &key_cbc);		
    HSM.HT2HSMS.R         = (uint32_t) &HSM_CMD;
    /* send command */
    HSM.HT2HSMF.B.CMD_INT = 1;  			
    hsm_done();

    for (i = 0;i<64; i++)
    {
	cbc_cyphertextDst[i] = 0;
    }

/* CBC ENCRYPT 1*/
    /* prepares data structure for encrypt CBC command */
    HSM_encrypt_CBC(4,
	    (uint32_t) &cbc_plaintext,
	    (uint32_t) &cbc_cyphertextDst,
	    (uint32_t)&IV);    				
    HSM.HT2HSMS.R         = (uint32_t) &HSM_CMD;
    /* send command */
    HSM.HT2HSMF.B.CMD_INT = 1;  			
    hsm_done();

    for (i = 0;i<64;i++)
    {
	/* compare if CBC encryption is right */
	if ( cbc_cyphertextDst[i]!= cbc_cycphertext[i])   	
	{
	    while(1);
	}
    }

    for (i = 0;i<64; i++)
    {
	cbc_cyphertextDst[i] = 0;
    }

    /*CBC ENCRYPT 2*/
    /* prepares data structure for encrypt CBC command */
    HSM_encrypt_CBC(4,
	    (uint32_t) &cbc_plaintext,
	    (uint32_t) &cbc_cyphertextDst,
	    (uint32_t)&IV);    				
    HSM.HT2HSMS.R  = (uint32_t) &HSM_CMD;
    /* send command */
    HSM.HT2HSMF.B.CMD_INT = 1;  									
    hsm_done();

    for (i = 0;i<64;i++)
    {
	/* compare if CBC encryption is right */
	if ( cbc_cyphertextDst[i]!= cbc_cycphertext[i])   						
	{
	    while(1);
	}
    }

    for (i = 0;i<64; i++)
    {
	cbc_plaintxtDst[i] = 0;
    }

/*CBC DECRYPT 2*/
    /* prepares data structure for decrypt CBC command */
    HSM_decrypt_CBC(4,
	    (uint32_t) &cbc_plaintxtDst,
	    (uint32_t) &cbc_cycphertext,
	    (uint32_t)&IV);  	
    HSM.HT2HSMS.R         = (uint32_t) &HSM_CMD;
    /* send command */
    HSM.HT2HSMF.B.CMD_INT = 1;  									
    hsm_done();

    for (i = 0;i<64;i++)
    {
	/* compare if CBC decryption is right */
	if ( cbc_plaintxtDst[i]!= cbc_plaintext[i])   							
	{
	    while(1);
	}
    }

}
/*=============================================================================
  FUNCTION: main

  DESCRIPTION:
  This is the main function/entry point for the application 

  ARGUMENTS PASSED:
  None

  RETURN VALUE:
  None

  PRE-CONDITIONS:
  None

  POST-CONDITIONS:
  None

  IMPORTANT NOTES:
  None
  ===========================================================================*/

void main(void)
{   
#ifdef FXOSCPLLSRC
    host_pll_fxosc_setup();
#else
    host_pll_firc_setup();

#endif
    CBC_Test();
    while(1);
}

