/*-----------------------------------------------------------------------------
  Copyright (c) 2015 by Freescale Semiconductor, All Rights reserved.

  This is unpublished proprietary source code of Freescale.
  The copyright notice above does not imply any actual or
  intended publication of such source code.

  FREESCALE CONFIDENTIAL PROPRIETARY
  ---------------------------------------------------------------------------*/
/*-----------------------------------------------------------------------------
  FILE NAME      : ECB_Testflash.c
  DEPARTMENT     : AISG
  -----------------------------------------------------------------------------
  REVISION HISTORY
            Date D/M/Y                     DESCRIPTION              
            ----------                 ---------------------
            27/7/2015                    Initial Version
       --------------------- 	       ---------------------
  KEYWORDS :HSM, Security
  -----------------------------------------------------------------------------
  PURPOSE : To check ECB encryption and decryption functionalities
  ---------------------------------------------------------------------------*/

/*=============================================================================
  INCLUDE FILES
  ==============================================================================*/
#include "common.h"
#include "hsm.h"
/*=============================================================================
  LOCAL CONSTANTS
  ==============================================================================*/

/*=============================================================================
  LOCAL TYPEDEFS (STRUCTURES, UNIONS, ENUMS)
  ==============================================================================*/
extern struct HSM_CMD_struct HSM_CMD;
/*=============================================================================
  LOCAL VARIABLES
  ==============================================================================*/
#pragma alignvar (4)
uint8_t ecbPlainText[16] = {
    0x00, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77,
    0x88, 0x99, 0xAA, 0xBB, 0xCC, 0xDD, 0xEE, 0xFF
};

#pragma alignvar (4)
uint8_t ecbCypheredText1[16];

#pragma alignvar (4)
/*AES 128 ECB mode reference ciphertext */
uint8_t ecbRefCypherText[16] = {
    0x69, 0xc4, 0xe0, 0xd8, 0x6a, 0x7b, 0x04, 0x30,
    0xd8, 0xcd, 0xb7, 0x80, 0x70, 0xb4, 0xc5, 0x5a
};

#pragma alignvar (4)
uint8_t ecbPlainText2[16] = {
    0x00, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77,
    0x88, 0x99, 0xAA, 0xBB, 0xCC, 0xDD, 0xEE, 0xFF
};

#pragma alignvar (4)
uint8_t ecbCypheredText2[16];

#pragma alignvar (4)
uint8_t ecbkey[21] = {    0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
                          0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f};

/*=============================================================================
  LOCAL FUNCTION PROTOTYPES
  ==============================================================================*/
extern void host_pll_fxosc_setup();
extern void host_pll_firc_setup();
/*=============================================================================
  GLOBAL VARIABLES
  ==============================================================================*/

/*=============================================================================
  LOCAL FUNCTIONS
  ==============================================================================*/
void ECB_test();
/*=============================================================================
  FUNCTION: ECB_test

  DESCRIPTION:
  This function is used to check ECB encryption and decryption functionalities  

  ARGUMENTS PASSED:
  None
  
  RETURN VALUE:
  None
  
  PRE-CONDITIONS:
  None

  POST-CONDITIONS:
  None

  IMPORTANT NOTES:
  None
  ===========================================================================*/
void ECB_test(void)
{
    uint32_t i;
    uint32_t error1 = 0;
    uint32_t error2 = 0;   

    for (i = 0;i<16; i++)
    {
	ecbCypheredText1[i] = 0;
    }

    for (i = 0;i<16; i++)
    {
	ecbCypheredText2[i] = 0;
    }

/* load ecbkey in RAM Key */
    while(HSM.HSM2HTS.B.BUSY == 1);
    /* ebckey is loaded to RAM_KEY for encryption and decryption */
    HSM_load_plain_key((uint32_t) &ecbkey);   					
    HSM.HT2HSMS.R         = (uint32_t) &HSM_CMD;
    /* send command */
    HSM.HT2HSMF.B.CMD_INT = 1;  						
    hsm_done();

/* encrypt ecbPlainText to ecbCypheredText1 using ecbkey */
    /* prepares data structure for encrypt ECB command */
    HSM_encrypt_ECB(1,
	    (uint32_t) &ecbPlainText,
	    (uint32_t) &ecbCypheredText1); 
    HSM.HT2HSMS.R         = (uint32_t) &HSM_CMD;
    /* send command */
    HSM.HT2HSMF.B.CMD_INT = 1;  						
    hsm_done();

    for (i = 0;i<16;i++)
    {
	/* compare if encryption is right */
	if ( ecbCypheredText1[i]!= ecbRefCypherText[i])   			
	{
	    while(1);
	}
    }

    for (i = 0;i<16; i++)
    {
	ecbCypheredText1[i] = 0;
    }

/* encrypt ecbPlainText2 to ecbCypheredText1 using ecbkey*/
    /* prepares data structure for encrypt ECB command */
    HSM_encrypt_ECB(1,
	    (uint32_t) &ecbPlainText2,
	    (uint32_t) &ecbCypheredText1); 
    HSM.HT2HSMS.R         = (uint32_t) &HSM_CMD;
    /* send command */
    HSM.HT2HSMF.B.CMD_INT = 1;  						
    hsm_done();

    for (i = 0;i<16;i++)
    {
	/* compare if encryption is right*/
	if ( ecbCypheredText1[i]!= ecbRefCypherText[i])   			
	{
	    while(1);
	}
    }

/* ECB Decryption */
    for (i = 0;i<16; i++)
    {
	ecbPlainText2[i] = 0;
    }

/* decrypt ecbPlainText2 to ecbCypheredText1 using ecbkey */
    /* prepares data structure for decrypt ECB command */
    HSM_decrypt_ECB(1,
	    (uint32_t)&ecbPlainText2,
	    (uint32_t)&ecbCypheredText1);	
    HSM.HT2HSMS.R         = (uint32_t) &HSM_CMD;
    /* send command */
    HSM.HT2HSMF.B.CMD_INT = 1;  						
    hsm_done();

    for (i = 0;i<16;i++)
    {
	/* compare if decryption is right */
	if ( ecbPlainText2[i]!= ecbPlainText[i])   				
	{
	    while(1);
	}
    }

    for (i = 0;i<16; i++)
    {
	ecbPlainText2[i] = 0;
    }

/* decrypt ecbPlainText2 to ecbCypheredText1 using ecbkey */
    /* prepares data structure for decrypt ECB command */
    HSM_decrypt_ECB(1,
	    (uint32_t)&ecbPlainText2,
	    (uint32_t)&ecbCypheredText1);	
    HSM.HT2HSMS.R         = (uint32_t) &HSM_CMD;
    /* send command */
    HSM.HT2HSMF.B.CMD_INT = 1;  						
    hsm_done();

    for (i = 0;i<16;i++)
    {
	/* compare if decryption is right */
	if ( ecbPlainText2[i]!= ecbPlainText[i])    				
	{
	    while(1);
	}
    }
}
/*=============================================================================
  FUNCTION: main

  DESCRIPTION:
  This is the main function/entry point for the application 

  ARGUMENTS PASSED:
  None

  RETURN VALUE:
  None

  PRE-CONDITIONS:
  None

  POST-CONDITIONS:
  None

  IMPORTANT NOTES:
  None
  ===========================================================================*/

void main(void)
{
#ifdef FXOSCPLLSRC
    host_pll_fxosc_setup();
#else
    host_pll_firc_setup();

#endif

    ECB_test();
    while(1);
}

