/*-----------------------------------------------------------------------------
  Copyright (c) 2015 by Freescale Semiconductor, All Rights reserved.

  This is unpublished proprietary source code of Freescale.
  The copyright notice above does not imply any actual or
  intended publication of such source code.

  FREESCALE CONFIDENTIAL PROPRIETARY

  ---------------------------------------------------------------------------*/
/*-----------------------------------------------------------------------------
  FILE NAME      : UID_testflash.c
  DEPARTMENT     : AISG
  -----------------------------------------------------------------------------
  REVISION HISTORY
            Date D/M/Y                     DESCRIPTION              
            ----------                 ---------------------
            27/7/2015                    Initial Version
       --------------------- 	       ---------------------
  KEYWORDS :HSM, Security
  -----------------------------------------------------------------------------
  PURPOSE : To check the UID. 
  ---------------------------------------------------------------------------*/

/*=============================================================================
  INCLUDE FILES
  ===========================================================================*/
#include "common.h"
#include "hsm.h"
//=============================================================================
//LOCAL CONSTANTS
//===========================================================================*/

/*=============================================================================
  LOCAL TYPEDEFS (STRUCTURES, UNIONS, ENUMS)
  ===========================================================================*/
extern struct HSM_CMD_struct HSM_CMD;
/*=============================================================================
  LOCAL VARIABLES
  ===========================================================================*/

/*=============================================================================
  LOCAL FUNCTION PROTOTYPES
  ===========================================================================*/
extern void host_pll_fxosc_setup();
extern void host_pll_firc_setup();
/*=============================================================================
  GLOBAL VARIABLES
  ===========================================================================*/

/*=============================================================================
  LOCAL FUNCTIONS
  ===========================================================================*/
void UID_test();
/*=============================================================================
  FUNCTION: UID_test

  DESCRIPTION:
  This is used to check UID 

  ARGUMENTS PASSED:
  None

  RETURN VALUE:
  None

  PRE-CONDITIONS:
  None

  POST-CONDITIONS:
  None

  IMPORTANT NOTES:
  None
  ===========================================================================*/
void UID_test(void)
{
#define UID_ADDRESS	(0x004000A0)

#pragma alignvar (4)
/* GET ID command specific challenge*/
    uint8_t challenge[16] = {
	0x6b, 0xc1, 0xbe, 0xe2, 0x2e, 0x40, 0x9f, 0x96,
	0xe9, 0x3d, 0x7e, 0x11, 0x73, 0x93, 0x17, 0x2a
    };

#pragma alignvar (4)
/* GET ID command specific returne uid */
    uint8_t uid[15];//120bit UID
    uint8_t sreg8 = 0;
    uint8_t cmac[16];	
    uint8_t *uidPtr = (unsigned char *)UID_ADDRESS;
    int i;

/* command to get UID */   
    while(HSM.HSM2HTS.B.BUSY == 1);
    /* Get ID*/
    HSM_CMD.CMD = 0x10;
    /* challenge address*/
    HSM_CMD.PARAM_1 = (uint32_t)&challenge;
    /* UID Output address */
    HSM_CMD.PARAM_2 = (uint32_t)&uid;
    /* HSM to HOST status HSM2HTS[7:0] value address */
    HSM_CMD.PARAM_3 = (uint32_t)&sreg8;
    /* MAC address */
    HSM_CMD.PARAM_4 = (uint32_t)&cmac;    					
    HSM.HT2HSMS.R   = (uint32_t) &HSM_CMD;
    HSM.HT2HSMF.B.CMD_INT = 1;  						
    hsm_done();

/* compare UID 120bits */
    for(i=0; i<(15); i++)
    {
	if(uid[i] != *(uidPtr + i))
	{
	    while(1);
	}
    }
}

/*=============================================================================
  FUNCTION: main

  DESCRIPTION:
  This is the main function/entry point for the application 

  ARGUMENTS PASSED:
  None

  RETURN VALUE:
  None

  PRE-CONDITIONS:
  None

  POST-CONDITIONS:
  None

  IMPORTANT NOTES:
  None
  ===========================================================================*/

void main(void)
{   
#ifdef FXOSCPLLSRC
    host_pll_fxosc_setup();
#else
    host_pll_firc_setup();

#endif
    UID_test();
    while(1);
}

