/*-----------------------------------------------------------------------------
  Copyright (c) 2015 by Freescale Semiconductor, All Rights reserved.

  This is unpublished proprietary source code of Freescale.
  The copyright notice above does not imply any actual or
  intended publication of such source code.

  FREESCALE CONFIDENTIAL PROPRIETARY

  ---------------------------------------------------------------------------*/
/*-----------------------------------------------------------------------------
  FILE NAME      : debug_protocol_testflash.c
  DEPARTMENT     : AISG
  -----------------------------------------------------------------------------
  REVISION HISTORY
            Date D/M/Y                     DESCRIPTION              
            ----------                 ---------------------
            27/7/2015                    Initial Version
       --------------------- 	       ---------------------
  KEYWORDS :HSM, Security
  -----------------------------------------------------------------------------
  PURPOSE : To erase the key storage area 
  ---------------------------------------------------------------------------*/

/*=============================================================================
  INCLUDE FILES
  ===========================================================================*/
#include "common.h"
#include "hsm.h"
//=============================================================================
//LOCAL CONSTANTS
//===========================================================================*/

/*=============================================================================
  LOCAL TYPEDEFS (STRUCTURES, UNIONS, ENUMS)
  ===========================================================================*/
extern struct HSM_CMD_struct HSM_CMD;
/*=============================================================================
  LOCAL VARIABLES
  ===========================================================================*/

/*=============================================================================
  LOCAL FUNCTION PROTOTYPES
  ===========================================================================*/
extern void host_pll_fxosc_setup();
extern void host_pll_firc_setup();
/*=============================================================================
  GLOBAL VARIABLES
  ===========================================================================*/

/*=============================================================================
  LOCAL FUNCTIONS
  ===========================================================================*/
void debug_protocol_test();
/*=============================================================================
  FUNCTION: debug_protocol_test

  DESCRIPTION:
  This function is used to erase the key storage area

  ARGUMENTS PASSED:
  None

  RETURN VALUE:
  None

  PRE-CONDITIONS:
  None

  POST-CONDITIONS:
  None

  IMPORTANT NOTES:
  None
  ===========================================================================*/
void debug_protocol_test(void)
{
#define UID_ADDRESS	(0x004000A0)

#pragma alignvar (4)
/* GET ID command specific challenge*/
    uint8_t getid_challenge[16] = {
	0x6b, 0xc1, 0xbe, 0xe2, 0x2e, 0x40, 0x9f, 0x96,
	0xe9, 0x3d, 0x7e, 0x11, 0x73, 0x93, 0x17, 0x2a
    };

#pragma alignvar (4)
/* GET ID command specific returne uid */
    uint8_t uid[15];							
    uint8_t sreg8 = 0;
    uint8_t cmac[16];	
    uint8_t *uidPtr = (unsigned char *)UID_ADDRESS;

#define KEY_SIZE_IN_WORD 4
#define AES_BLOCK_SIZE	16

    const uint32_t KEY_DEBUG_C[KEY_SIZE_IN_WORD] =		   \
    {(uint32_t)0x01035348UL, (uint32_t)0x45008000UL,
	(uint32_t)0x00000000UL, (uint32_t)0x000000B0UL};

    uint32_t MASTER_ECU_KEY [KEY_SIZE_IN_WORD]= 		   \
    {(uint32_t)0x00010203UL, (uint32_t)0x04050607UL,
	(uint32_t)0x08090A0BUL, (uint32_t)0x0C0D0E0FUL};

    uint32_t Kdebug[KEY_SIZE_IN_WORD];
    uint32_t plaintext[KEY_SIZE_IN_WORD*2];
    uint8_t debug_chal[AES_BLOCK_SIZE];
    uint8_t debug_auth[AES_BLOCK_SIZE];
    /* corresponding to CHALLENGE+UID length */
    uint8_t debug_cmac_plaintext[AES_BLOCK_SIZE+15UL];    			
    int i=0;

    uint8_t messagedebugcmaclen[AES_BLOCK_SIZE/2] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8};

/*Issue Init_RNG*/
/*Write command ID to the command structure*/
    while(HSM.HSM2HTS.B.BUSY == 1);
    /* Init_RNG */
    HSM_CMD.CMD = 0xA;   							
    /*Write the address of the command structure to register "HT2HSMS".*/
    HSM.HT2HSMS.R         = (uint32_t) &HSM_CMD;
    /*Start the command by writing "1" to bit 1 of register "HT2HSMF"*/
    HSM.HT2HSMF.B.CMD_INT = 1;  						
    hsm_done();

/*Generate Kdebug */
    for(i=0;i<KEY_SIZE_IN_WORD;i++)
	plaintext[i]=MASTER_ECU_KEY[i];
    for(;i<KEY_SIZE_IN_WORD*2;i++)
	plaintext[i]=KEY_DEBUG_C[i-KEY_SIZE_IN_WORD];
    hsm_kdf((uint32_t *)&plaintext, (uint32_t *) &Kdebug, 2UL);


/*get UID*/
    while(HSM.HSM2HTS.B.BUSY == 1);
    /* Get ID*/
    HSM_CMD.CMD = 0x10;
    /* challenge address */
    HSM_CMD.PARAM_1 = (uint32_t)&getid_challenge;
    /* UID Output address */
    HSM_CMD.PARAM_2 = (uint32_t)&uid;
    /* HSM to HOST status HSM2HTS[7:0] value address */
    HSM_CMD.PARAM_3 = (uint32_t)&sreg8;
    /* MAC address */
    HSM_CMD.PARAM_4 = (uint32_t)&cmac;       			 		
    HSM.HT2HSMS.R   = (uint32_t) &HSM_CMD;
    /* send command */
    HSM.HT2HSMF.B.CMD_INT = 1; 					 		
    hsm_done();  

/* compare UID 120bits */
    for(i=0; i<(15); i++)
    {
	if(uid[i] != *(uidPtr + i))
	{
	    while(1);
	}
    }

/*generate challenge value*/
    /* debug challenge*/
    HSM_CMD.CMD = 0x12;
    /* challenge address */ 
    HSM_CMD.PARAM_1 = (uint32_t)&debug_chal;      				    
    HSM.HT2HSMS.R   = (uint32_t) &HSM_CMD;
    HSM.HT2HSMF.B.CMD_INT = 1;  						
    hsm_done(); 

/*Load Kdebug in RAM key*/
    /* Kdebug is loaded to RAM KEY */
    HSM_load_plain_key((uint32_t)&Kdebug);					
    HSM.HT2HSMS.R    = (uint32_t) &HSM_CMD;
    HSM.HT2HSMF.B.CMD_INT = 1;  						
    hsm_done(); 

/*Generate MAC  over (CHALLENGE|UID)*/
    for(i=0;i<AES_BLOCK_SIZE;i++)
	debug_cmac_plaintext[i]=debug_chal[i];
    for(i=0;i<15;i++)
	debug_cmac_plaintext[i+AES_BLOCK_SIZE]=uid[i];

/*debug_cmac*/
    HSM_CMD.CMD = 0x5;
    /* key ID = RAM_KEY (Plain key) = Kdebug*/
    HSM_CMD.PARAM_1 = (uint32_t)0xE;
    /* Message length (in bits) address */
    HSM_CMD.PARAM_2 = (uint32_t)&messagedebugcmaclen;
    /* Message start address */
    HSM_CMD.PARAM_3 = (uint32_t)&debug_cmac_plaintext;
    /* Authorization address */
    HSM_CMD.PARAM_4 = (uint32_t)&debug_auth;   					
    HSM.HT2HSMS.R   = (uint32_t) &HSM_CMD;
    HSM.HT2HSMF.B.CMD_INT = 1;  						
    hsm_done();

/*Debug Authorise*/
    /* DEBUG_AUTH */
    HSM_CMD.CMD = 0x13;
    /* Authorization address */
    HSM_CMD.PARAM_1 = (uint32_t)&debug_auth;    				
    HSM.HT2HSMS.R   = (uint32_t) &HSM_CMD;
    HSM.HT2HSMF.B.CMD_INT = 1;  						
    hsm_done(); 
}

/*=============================================================================
  FUNCTION: main

  DESCRIPTION:
  This is the main function/entry point for the application 

  ARGUMENTS PASSED:
  None

  RETURN VALUE:
  None

  PRE-CONDITIONS:
  None

  POST-CONDITIONS:
  None

  IMPORTANT NOTES:
  None
  ===========================================================================*/
void main(void)
{   
#ifdef FXOSCPLLSRC
    host_pll_fxosc_setup();
#else
    host_pll_firc_setup();    
#endif

    debug_protocol_test();
    while(1);
}

