//*********************************************************************************/
//* Freescale reserves  the right to make  changes without  further notice to any */
//* product herein to improve  reliability, function,  or design.  Freescale does */
//* not  assume  any  liability  arising  out of  the application  or use  of any */
//* product, circuit,  or software described herein;  neither does  it convey any */
//* license under its patent rights nor the rights of others.  Freescale products */
//* are not designed, intended,  or authorized for use as  components  in systems */
//* intended for  surgical implant into the body,  or other applications intended */
//* to support life,  or for any other  application  in which the failure  of the */
//* Freescale product could create a situation where personal injury or death may */
//* occur.  Should Buyer purchase or use Freescale products for any such intended */
//* or unauthorized  application,  Buyer shall indemnify and  hold  Freescale and */
//* its officers, employees, subsidiaries, affiliates,  and distributors harmless */
//* against all claims costs, damages, and expenses, and reasonable attorney fees */
//* arising  out of,  directly or indirectly,  any claim  of personal  injury  or */
//* death  associated  with  such unintended  or unauthorized use,  even if  such */
//* claim  alleges  that  Freescale  was  negligent   regarding   the  design  or */
//* manufacture  of the part.  Freescale and the  Freescale logo*  are registered */
//* trademarks of Freescale Ltd.                                                  */
//*********************************************************************************/

//////////////////////////////////////////////////////////////////////////////////
//                                                                              //
// File Name: main.c                                                            //
// Current Revision: 1.0                                                        //
// Purpose: Initializes the MC33816 device using an embedded MCU                //
// Description: Main program that loads the code RAM, data RAM and register     //
//              configurations of the MC33816 device.                           //
// File created by: Freescale Analog, Tempe                                     //
//                                                                              //
// UPDATE HISTORY                                                               //
// REV   AUTHOR      DATE        DESCRIPTION OF CHANGE                          //
// ---   ------     ----         ---------------------                          //
//                                                                              //
//////////////////////////////////////////////////////////////////////////////////

/********************************* INCLUDES *************************************/
#include "functions.h" 

//********************************************************************************
//   Function Name   : main
//   Author          : 
//   Date            : 
//   Parameters      : NONE
//   Returns         : int
//   Notes           : NONE
//********************************************************************************
int main(void) 
{
   init_SPI();                     // initializes all SPI related parameters
   init_GPIO();                    // initializes all GPIO related parameters

   set_reset_pin(LOW);             // Sets MC33816 reset signal low

   delay(100);                     // pause 100ms

   set_reset_pin(HIGH);            // Sets MC33816 reset signal high

   delay(100);                     // pause 100ms

   download_RAM(CODE_RAM1);        // transfers code RAM1
   download_RAM(CODE_RAM2);        // transfers code RAM2
   download_RAM(CODE_RAM3);        // transfers code RAM3
   download_RAM(DATA_RAM);         // transfers data RAM

   download_register(MAIN_REG);    // download main register configurations
   download_register(CH1_REG);     // download channel 1 register configurations
   download_register(CH2_REG);     // download channel 2 register configurations
   download_register(CH3_REG);     // download channel 3 register configurations
   download_register(IO_REG);      // download IO register configurations
   download_register(DIAG_REG);    // download diag register configurations
   
   send_16bit_SPI(0x2001);         // enable flash and dual sequence ch1 (address = 0x100)
   send_16bit_SPI(0x0018);

   send_16bit_SPI(0x2401);         // enable flash and dual sequence ch2 (address = 0x120)
   send_16bit_SPI(0x0018);

   send_16bit_SPI(0x2801);         // enable flash and dual sequence ch3 (address = 0x140)
   send_16bit_SPI(0x0018);

   set_drven_pin(HIGH);            // Sets drive enable signal high (enables outputs and vboost)

   return 0;

} //end main

