/*******************************************************************************
* Freescale Semiconductor Inc.
* (c) Copyright 2014 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
********************************************************************************
Services performed by FREESCALE in this matter are performed AS IS and without 
any warranty. CUSTOMER retains the final decision relative to the total design 
and functionality of the end product. FREESCALE neither guarantees nor will be 
held liable by CUSTOMER for the success of this project.
FREESCALE DISCLAIMS ALL WARRANTIES, EXPRESSED, IMPLIED OR STATUTORY INCLUDING, 
BUT NOT LIMITED TO, IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR 
A PARTICULAR PURPOSE ON ANY HARDWARE, SOFTWARE ORE ADVISE SUPPLIED TO THE PROJECT
BY FREESCALE, AND OR NAY PRODUCT RESULTING FROM FREESCALE SERVICES. IN NO EVENT
SHALL FREESCALE BE LIABLE FOR INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF 
THIS AGREEMENT.

CUSTOMER agrees to hold FREESCALE harmless against any and all claims demands or 
actions by anyone on account of any damage, or injury, whether commercial, 
contractual, or tortuous, rising directly or indirectly as a result of the advise
or assistance supplied CUSTOMER in connection with product, services or goods 
supplied under this Agreement.
********************************************************************************
* File              e200z4_SPR_read_write_macros.h
* Owner             b05111
* Version           0.0
* Date              Sep-25-2014
* Classification    General Business Information
* Brief             Macros for access to SPR registers (CPU regs)
********************************************************************************
* Detailed Description:
********************************************************************************
Revision History:
Version  Date         Author   Description of Changes
0.0      Sep-25-2014  b05111   Initial version
*******************************************************************************/

#ifndef _E200Z4_SPR_READ_WRITE_MACROS_
#define _E200Z4_SPR_READ_WRITE_MACROS_

/*******************************************************************************
* Includes
*******************************************************************************/

#include "MPC5600_Z4_SPR.h"


/*******************************************************************************
* Macros 
*******************************************************************************/

/**************    macro for SPR WRITE    **************/
// param 'spr_number' choose from MPC5600_Z4_SPR.h
// param 'address' is a variable name (thus its address)
#define WRITE_TO_SPR(spr_number,address)  \
asm (lis r30, (address)@h);               \
asm (ori r30, r30, (address)@l);          \
asm (lwz r31, 0x0(r30));                  \
asm (mtspr(spr_number), r31);

/**************    macro for SPR READ     **************/
// param 'spr_number' take from MPC5600_Z4_SPR.h
// param 'address' is a variable name (thus its address)
#define READ_FROM_SPR(spr_number,address) \
asm (lis r30, (address)@h);               \
asm (ori r30, r30, (address)@l);          \
asm (mfspr r31, (spr_number));            \
asm (stw r31, 0(r30));            

/**************    macro for MSR WRITE    **************/
// param 'address' is a variable name (thus its address)
#define WRITE_TO_MSR(address)             \
asm (lis r30, (address)@h);               \
asm (ori r30, r30, (address)@l);          \
asm (lwz r31, 0x0(r30));                  \
asm (mtmsr r31);

/**************    macro for MSR READ     **************/
// param 'address' is a variable name (thus its address)
#define READ_FROM_MSR(address)            \
asm (lis r30, (address)@h);               \
asm (ori r30, r30, (address)@l);          \
asm (mfmsr r31);                          \
asm (stw r31, 0(r30));


/******************************************************************************/
/* Example of usage:                                                          */
/*                                                                            */
/*      // must be static local or global variable                            */
/*      static vuint32_t test = 0;                                            */
/*      static vuint32_t address_capture;                                     */
/*      static vuint32_t IVOR0_offset;                                        */
/*                                                                            */
/*      READ_FROM_MSR(test);                                                  */
/*      WRITE_TO_MSR(test);                                                   */
/*      ..                                                                    */
/*      WRITE_TO_SPR(SPR_IVOR0, test_variable);                               */
/*      READ_FROM_SPR(SPR_MCAR,address_capture)                               */
/*      ..                                                                    */
/*                                                                            */
/******************************************************************************/

#endif /* _E200Z4_SPR_READ_WRITE_MACROS_ */
