#include <hidef.h>      /* common defines and macros */
#include "derivative.h"      /* derivative-specific definitions */
#include "lin.h"

#define SW_up PTIS_PTIS2
#define SW_down PTIP_PTIP1
#define UP_LIMIT 6000
#define MIN_SPEED 1492


char SW_state = 0;
char tim3_cnt = 0;
unsigned int PWM_counter = 0;
unsigned int PWM_val = 1492;
unsigned char risingFlag = 1;

/*Functions */

void GPIO_init(void);
void LIN_Phy(void);
void MCU_init(void);
void TIM2_init(void);

/* Switch init */
void GPIO_init(void){
  HSCR=1; 
  HSDR=1; 
  PERS_PERS2=0; 
  ATDDIENL=1; /*3. Enable ADC0 input buffer*/
}

/*Initialize MCU */
void MCU_init(void) {
   /* Fvco = 48Mhz */	
	CPMUSYNR_SYNDIV = 0x17U; 
	CPMUSYNR_VCOFRQ = 0x01U;
   /* Fpll = 16Mhz*/	                         
	CPMUPOSTDIV_POSTDIV = 0x02U;
	/* Internal clock*/
	CPMUOSC_OSCE = 0x00U;
   /* Wait until stable clock */
 	while(!CPMUFLG_LOCK ) ;/* Wait for PLL stable */
   CPMUFLG = 0xFF;			/* clear CMPMU int flags - not needed but good practice   */ 
}

/* Enable LIN_PHY module */
void LIN_Phy(void){

    LPCR_LPPUE = 1;     /* Pull up to strong signal  */
    LPSLRM = 0x01;      /* LIN Slew Rate selection */
                        /* With the LIN baudrate selected as 9600bps, 
                        the Slew Rate is set as 01 which is optimized for 10400Bit/s*/
    LPCR_LPE = 1;       /* Enable LIN Phy  */
}

/*Enable TIM 2 as output compare */
void TIM2_init(){
  TIOS_IOS2 = 1;     //Set tim ch 2 as output compare
  TC2H = 0x4E;       /* interrupt every 2.5 ms */
  TC2L = 0x20;
  TIE_C2I = 1;      //Interrupt enable
  TSCR1_TEN = 1; //timmer enable
  
}

void main(void) {
  /* put your own code here */
  GPIO_init();
  MCU_init();
  LIN_Phy();
  TCNT = 0;
  l_sys_init();
  l_ifc_init(LI0);
  l_sch_set(LI0,LI0_motor,0);
  TIM2_init();


	EnableInterrupts;


  for(;;) {
    _FEED_COP(); /* feeds the dog */
    
    if(SW_up){     /* UP-DOWN velocity sequence */
      SW_state = 1;
      l_u16_wr_LI0_req_speed(PWM_val);
    } 
    else if(SW_down){    /* Velocity at stablished UP limit */
      SW_state = 0;
      l_u16_wr_LI0_req_speed(UP_LIMIT);
    } 
    else{
      SW_state = 2;
      l_u16_wr_LI0_req_speed(MIN_SPEED);  /* Velocity at stablished min speed */
    }
    
  } /* loop forever */
  /* please make sure that you never leave main */
}


/* Timer 2 interrupt service routine */

interrupt VectorNumber_Vtimch2 void TIMCH2_ISR(void){

   TFLG1_C2F = 1;        /*Clear flag */
   if(tim3_cnt>=2){      /*tick schedule every 10 ms */
    l_sch_tick(LI0);
    tim3_cnt = 0;
   }
   if(risingFlag == 1){
      if(PWM_counter>=100&&SW_up){     /* Rise velocity when switch up */
        PWM_val+=50;
        if(PWM_val >= 8200){
          risingFlag = 0;
        }
        PWM_counter = 0;
      }
      PWM_counter++;
   }
   else{
      if(PWM_counter>=100&&SW_up){     /* Decrese Velocity when switch up*/
        PWM_val-=50;
        if(PWM_val <= 1490){
          risingFlag = 1;
        }
        PWM_counter = 0;
      }
      PWM_counter++;
   }
   tim3_cnt++;
   
   TC2 = (TC2+20000)&0xFFFF; 
}  
