/****************************************************************************** 
* 
* Freescale Semiconductor Inc. 
* (c) Copyright 2014-2015 Freescale Semiconductor, Inc. 
* ALL RIGHTS RESERVED. 
* 
****************************************************************************//*!  
* 
* @file      lin_cfg.h 
* 
* @author    FPT Software
*  
* @version   1.0 
*  
* @date      Mon Aug 03 12:13:36 CDT 2015
*  
* @brief     Hardware configuration file
* 
******************************************************************************/
#ifndef    _LIN_CFG_H_  
#define    _LIN_CFG_H_  
#include "lin_hw_cfg.h" 
/* Define operating mode */
#define _MASTER_MODE_     0 
#define _SLAVE_MODE_      1 
#define LIN_MODE   _MASTER_MODE_ 
/* Define protocol version */
#define PROTOCOL_21       0  
#define PROTOCOL_J2602    1  
#define PROTOCOL_20       2 
#define LIN_PROTOCOL    PROTOCOL_21
#define LIN_NUM_OF_IFCS  1		/* For master */
/**********************************************************************/
/***************          Diagnostic class selection  *****************/
/**********************************************************************/
#define _DIAG_CLASS_I_          0
#define _DIAG_CLASS_II_         1
#define _DIAG_CLASS_III_        2

#define _DIAG_CLASS_SUPPORT_    _DIAG_CLASS_I_
/**************** FRAME SUPPORT DEFINITION ******************/
#define _TL_SINGLE_FRAME_       0
#define _TL_MULTI_FRAME_        1

#define _TL_FRAME_SUPPORT_      _TL_SINGLE_FRAME_

/* frame buffer size */
#define LIN_FRAME_BUF_SIZE			5
#define LIN_FLAG_BUF_SIZE			2

/**********************************************************************/
/***************               Interfaces           *******************/
/**********************************************************************/
typedef enum { 
   LI0
}l_ifc_handle; 

/**********************************************************************/
/***************               Signals              *******************/
/**********************************************************************/
/* Number of signals */
#define LIN_NUM_OF_SIGS  3
/* List of signals */   
typedef enum {

   /* Interface_name = LI0 */

   LI0_req_speed

   , LI0_status_current_speed
  
   , LI0_error
  
  
} l_signal_handle; 
/**********************************************************************/
/*****************               Frame             ********************/
/**********************************************************************/
/* Number of frames */
#define LIN_NUM_OF_FRMS  4 
/* List of frames */
typedef enum {
/* All frames for master node */

   /* Interface_name = LI0 */

   LI0_speed_cmd

   , LI0_motor_status
  
   , LI0_MasterReq
  
   , LI0_SlaveResp
  
  
} l_frame_handle; 
/**********************************************************************/
/***************        schedule table       *******************/
/**********************************************************************/
/* Number of schedule tables */
#define  LIN_NUM_OF_SCHD_TBL   5 
/* List of schedules */
typedef enum {

   /* Interface_name = LI0 */

   LI0_LIN_NULL_SCHEDULE

   ,LI0_GOTO_SLEEP_SCHEDULE
   
   ,LI0_MasterReqTable
   
   ,LI0_SlaveRespTable
   
   ,LI0_motor
   
}l_schedule_handle;  
/**********************************************************************/
/***************             Configuration          *******************/
/**********************************************************************/

/* Size of configuration in ROM and RAM used for interface: LI0 */
#define LI0_LIN_SIZE_OF_CFG  6
 
/*********************************************************************
 * global macros
 *********************************************************************/
#define l_bool_rd(SIGNAL) l_bool_rd_##SIGNAL()
#define l_bool_wr(SIGNAL, A) l_bool_wr_##SIGNAL(A)
#define l_u8_rd(SIGNAL) l_u8_rd_##SIGNAL()
#define l_u8_wr(SIGNAL, A) l_u8_wr_##SIGNAL(A)
#define l_u16_rd(SIGNAL) l_u16_rd_##SIGNAL()
#define l_u16_wr(SIGNAL, A) l_u16_wr_##SIGNAL(A)
#define l_bytes_rd(SIGNAL, start, count, data)  l_bytes_rd_##SIGNAL(start, count, data)
#define l_bytes_wr(SIGNAL, start, count, data) l_bytes_wr_##SIGNAL(start, count, data)
#define l_flg_tst(FLAG) l_flg_tst_##FLAG()
#define l_flg_clr(FLAG) l_flg_clr_##FLAG()
#define LIN_TEST_BIT(A,B) ((l_bool)((((A) & (1U << (B))) != 0U) ? 1U : 0U))
#define LIN_SET_BIT(A,B)                      ((A) |= (l_u8) (1U << (B)))
#define LIN_CLEAR_BIT(A,B)               ((A) &= ((l_u8) (~(1U << (B)))))
#define LIN_BYTE_MASK  ((l_u16)(((l_u16)((l_u16)1 << CHAR_BIT)) - (l_u16)1))
#define LIN_FRAME_LEN_MAX                                             10U

/* Returns the low byte of the 32-bit value    */
#define BYTE_0(n)                              ((l_u8)((n) & (l_u8)0xFF))
/* Returns the second byte of the 32-bit value */
#define BYTE_1(n)                        ((l_u8)(BYTE_0((n) >> (l_u8)8)))
/* Returns the third byte of the 32-bit value  */
#define BYTE_2(n)                       ((l_u8)(BYTE_0((n) >> (l_u8)16)))
/* Returns high byte of the 32-bit value       */
#define BYTE_3(n)                       ((l_u8)(BYTE_0((n) >> (l_u8)24)))

/*
 * defines for signal access
 */


#define LIN_BYTE_OFFSET_LI0_req_speed    0
#define LIN_BIT_OFFSET_LI0_req_speed    0
#define LIN_SIGNAL_SIZE_LI0_req_speed    16
#define LIN_FLAG_BYTE_OFFSET_LI0_req_speed    0
#define LIN_FLAG_BIT_OFFSET_LI0_req_speed    1
#define LIN_FLAG_UPDATE_BYTE_OFFSET_LI0_req_speed    0

#define LIN_BYTE_OFFSET_LI0_status_current_speed    2
#define LIN_BIT_OFFSET_LI0_status_current_speed    0
#define LIN_SIGNAL_SIZE_LI0_status_current_speed    16
#define LIN_FLAG_BYTE_OFFSET_LI0_status_current_speed    1
#define LIN_FLAG_BIT_OFFSET_LI0_status_current_speed    1
#define LIN_FLAG_UPDATE_BYTE_OFFSET_LI0_status_current_speed    1

#define LIN_BYTE_OFFSET_LI0_error    4
#define LIN_BIT_OFFSET_LI0_error    0
#define LIN_SIGNAL_SIZE_LI0_error    1
#define LIN_FLAG_BYTE_OFFSET_LI0_error    1
#define LIN_FLAG_BIT_OFFSET_LI0_error    2
#define LIN_FLAG_UPDATE_BYTE_OFFSET_LI0_error    1




#define LIN_FLAG_BYTE_OFFSET_LI0_speed_cmd             0
#define LIN_FLAG_BIT_OFFSET_LI0_speed_cmd              0

#define LIN_FLAG_BYTE_OFFSET_LI0_motor_status             1
#define LIN_FLAG_BIT_OFFSET_LI0_motor_status              0


/**********************************************************************/
/***************        Static API Functions        *******************/
/**********************************************************************/
/*
 * the static signal access macros
 */


/* static access macros for signal LI0_req_speed */
#define l_u16_rd_LI0_req_speed() \
    ((l_u16) ((lin_pFrameBuf[LIN_BYTE_OFFSET_LI0_req_speed + 1] & 0xff) << 8) + ((l_u16) (lin_pFrameBuf[LIN_BYTE_OFFSET_LI0_req_speed]) >> 0x00))
#define l_u16_wr_LI0_req_speed(A) \
    {lin_pFrameBuf[LIN_BYTE_OFFSET_LI0_req_speed + 1] = \
	((l_u8) (((l_u8) (lin_pFrameBuf[LIN_BYTE_OFFSET_LI0_req_speed + 1] &  (0x00))) | \
	((l_u8) ((l_u8) ((A) >> 8)) & 0xff))); \
	lin_pFrameBuf[LIN_BYTE_OFFSET_LI0_req_speed] = \
	((l_u8) (((l_u8) (lin_pFrameBuf[LIN_BYTE_OFFSET_LI0_req_speed] & (0x00))) | \
	((l_u8) (A) << LIN_BIT_OFFSET_LI0_req_speed))); \
	lin_frame_flag_tbl[LIN_FLAG_UPDATE_BYTE_OFFSET_LI0_req_speed] = 1;}

/* static access macros for signal LI0_status_current_speed */
#define l_u16_rd_LI0_status_current_speed() \
    ((l_u16) ((lin_pFrameBuf[LIN_BYTE_OFFSET_LI0_status_current_speed + 1] & 0xff) << 8) + ((l_u16) (lin_pFrameBuf[LIN_BYTE_OFFSET_LI0_status_current_speed]) >> 0x00))
#define l_u16_wr_LI0_status_current_speed(A) \
    {lin_pFrameBuf[LIN_BYTE_OFFSET_LI0_status_current_speed + 1] = \
	((l_u8) (((l_u8) (lin_pFrameBuf[LIN_BYTE_OFFSET_LI0_status_current_speed + 1] &  (0x00))) | \
	((l_u8) ((l_u8) ((A) >> 8)) & 0xff))); \
	lin_pFrameBuf[LIN_BYTE_OFFSET_LI0_status_current_speed] = \
	((l_u8) (((l_u8) (lin_pFrameBuf[LIN_BYTE_OFFSET_LI0_status_current_speed] & (0x00))) | \
	((l_u8) (A) << LIN_BIT_OFFSET_LI0_status_current_speed))); \
	lin_frame_flag_tbl[LIN_FLAG_UPDATE_BYTE_OFFSET_LI0_status_current_speed] = 1;}

/* static access macros for signal LI0_error */
#define l_bool_rd_LI0_error() \
   	(LIN_TEST_BIT(lin_pFrameBuf[LIN_BYTE_OFFSET_LI0_error], \
   	LIN_BIT_OFFSET_LI0_error))
#define l_bool_wr_LI0_error(A) \
	{(A) ? \
  	(LIN_SET_BIT(lin_pFrameBuf[LIN_BYTE_OFFSET_LI0_error], \
  	LIN_BIT_OFFSET_LI0_error)):\
  	(LIN_CLEAR_BIT(lin_pFrameBuf[LIN_BYTE_OFFSET_LI0_error], \
  	LIN_BIT_OFFSET_LI0_error));\
  	lin_frame_flag_tbl[LIN_FLAG_UPDATE_BYTE_OFFSET_LI0_error] = 1;}



/* Signal flag APIs */


#define l_flg_tst_LI0_req_speed_flag() \
         LIN_TEST_BIT(lin_flag_handle_tbl[LIN_FLAG_BYTE_OFFSET_LI0_req_speed],\
         LIN_FLAG_BIT_OFFSET_LI0_req_speed)
#define l_flg_clr_LI0_req_speed_flag() \
         LIN_CLEAR_BIT(lin_flag_handle_tbl[LIN_FLAG_BYTE_OFFSET_LI0_req_speed],\
         LIN_FLAG_BIT_OFFSET_LI0_req_speed)

#define l_flg_tst_LI0_status_current_speed_flag() \
         LIN_TEST_BIT(lin_flag_handle_tbl[LIN_FLAG_BYTE_OFFSET_LI0_status_current_speed],\
         LIN_FLAG_BIT_OFFSET_LI0_status_current_speed)
#define l_flg_clr_LI0_status_current_speed_flag() \
         LIN_CLEAR_BIT(lin_flag_handle_tbl[LIN_FLAG_BYTE_OFFSET_LI0_status_current_speed],\
         LIN_FLAG_BIT_OFFSET_LI0_status_current_speed)

#define l_flg_tst_LI0_error_flag() \
         LIN_TEST_BIT(lin_flag_handle_tbl[LIN_FLAG_BYTE_OFFSET_LI0_error],\
         LIN_FLAG_BIT_OFFSET_LI0_error)
#define l_flg_clr_LI0_error_flag() \
         LIN_CLEAR_BIT(lin_flag_handle_tbl[LIN_FLAG_BYTE_OFFSET_LI0_error],\
         LIN_FLAG_BIT_OFFSET_LI0_error)



/* Frame flag APIs */

#define l_flg_tst_LI0_speed_cmd_flag() \
         LIN_TEST_BIT(lin_flag_handle_tbl[LIN_FLAG_BYTE_OFFSET_LI0_speed_cmd],\
         LIN_FLAG_BIT_OFFSET_LI0_speed_cmd)
#define l_flg_clr_LI0_speed_cmd_flag() \
         LIN_CLEAR_BIT(lin_flag_handle_tbl[LIN_FLAG_BYTE_OFFSET_LI0_speed_cmd],\
         LIN_FLAG_BIT_OFFSET_LI0_speed_cmd)

#define l_flg_tst_LI0_motor_status_flag() \
         LIN_TEST_BIT(lin_flag_handle_tbl[LIN_FLAG_BYTE_OFFSET_LI0_motor_status],\
         LIN_FLAG_BIT_OFFSET_LI0_motor_status)
#define l_flg_clr_LI0_motor_status_flag() \
         LIN_CLEAR_BIT(lin_flag_handle_tbl[LIN_FLAG_BYTE_OFFSET_LI0_motor_status],\
         LIN_FLAG_BIT_OFFSET_LI0_motor_status)



/* SCHEDULE MANAGEMENT */

#define l_sch_tick_LI0() l_sch_tick(LI0)



#define l_sch_set_LI0(schedule, entry) l_sch_set(LI0, schedule, entry)

/* INTERFACE MANAGEMENT */

#define l_ifc_init_LI0() l_ifc_init(LI0)



#define l_ifc_goto_sleep_LI0() l_ifc_goto_sleep(LI0)


#define l_ifc_wake_up_LI0() l_ifc_wake_up(LI0)



#define l_ifc_rx_LI0() l_ifc_rx(LI0)



#define l_ifc_tx_LI0() l_ifc_tx(LI0)



#define l_ifc_aux_LI0() l_ifc_aux(LI0)



#define l_ifc_read_status_LI0() l_ifc_read_status(LI0)


#endif    /* _LIN_CFG_H_ */