/*
** ###################################################################
**     Compilers:           Keil ARM C/C++ Compiler
**                          Freescale C/C++ for Embedded ARM
**                          GNU C Compiler
**                          GNU C Compiler - CodeSourcery Sourcery G++
**                          IAR ANSI C/C++ Compiler for ARM
**
**     Reference manual:    KL27P64M48SF2RM, Rev. 1, Sep 2014
**     Version:             rev. 1.4, 2014-09-22
**     Build:               b150215
**
**     Abstract:
**         Extension to the CMSIS register access layer header.
**
**     Copyright (c) 2014 Freescale Semiconductor, Inc.
**     All rights reserved.
**
**     Redistribution and use in source and binary forms, with or without modification,
**     are permitted provided that the following conditions are met:
**
**     o Redistributions of source code must retain the above copyright notice, this list
**       of conditions and the following disclaimer.
**
**     o Redistributions in binary form must reproduce the above copyright notice, this
**       list of conditions and the following disclaimer in the documentation and/or
**       other materials provided with the distribution.
**
**     o Neither the name of Freescale Semiconductor, Inc. nor the names of its
**       contributors may be used to endorse or promote products derived from this
**       software without specific prior written permission.
**
**     THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
**     ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
**     WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
**     DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
**     ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
**     (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
**     LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
**     ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
**     (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
**     SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
**     http:                 www.freescale.com
**     mail:                 support@freescale.com
**
**     Revisions:
**     - rev. 1.0 (2014-05-12)
**         Initial version.
**     - rev. 1.1 (2014-07-10)
**         UART0 - UART0 module renamed to UART2.
**     - rev. 1.2 (2014-08-12)
**         CRC - CRC register renamed to DATA.
**     - rev. 1.3 (2014-09-02)
**         USB - USB0_CTL0 was renamed to USB0_OTGCTL register.
**         USB - USB0_CTL1 was renamed to USB0_CTL register.
**         USB - Two new bitfields (STOP_ACK_DLY_EN, AHB_DLY_EN) was added to the USB0_KEEP_ALIVE_CTRL register.
**     - rev. 1.4 (2014-09-22)
**         FLEXIO - Offsets of the SHIFTBUFBIS registers were interchanged with offsets of the SHIFTBUFBBS registers.
**         SIM - Changed bitfield value MCGIRCLK to LIRC_CLK of bitfield CLKOUTSEL in SOPT2 register.
**         SIM - Removed bitfield DIEID in SDID register.
**         UART2 - Removed ED register.
**         UART2 - Removed MODEM register.
**         UART2 - Removed IR register.
**         UART2 - Removed PFIFO register.
**         UART2 - Removed CFIFO register.
**         UART2 - Removed SFIFO register.
**         UART2 - Removed TWFIFO register.
**         UART2 - Removed TCFIFO register.
**         UART2 - Removed RWFIFO register.
**         UART2 - Removed RCFIFO register.
**         USB - Removed bitfield REG_EN in CLK_RECOVER_IRC_EN register.
**         USB - Renamed USBEN bitfield of USB0_CTL was renamed to USBENSOFEN.
**
** ###################################################################
*/

/*
 * WARNING! DO NOT EDIT THIS FILE DIRECTLY!
 *
 * This file was generated automatically and any changes may be lost.
 */
#ifndef __MKL27Z644_EXTENSION_H__
#define __MKL27Z644_EXTENSION_H__

#include "MKL27Z644.h"
#include "fsl_bitaccess.h"

/*
 * MKL27Z644 ADC
 *
 * Analog-to-Digital Converter
 *
 * Registers defined in this header file:
 * - ADC_SC1 - ADC Status and Control Registers 1
 * - ADC_CFG1 - ADC Configuration Register 1
 * - ADC_CFG2 - ADC Configuration Register 2
 * - ADC_R - ADC Data Result Register
 * - ADC_CV1 - Compare Value Registers
 * - ADC_CV2 - Compare Value Registers
 * - ADC_SC2 - Status and Control Register 2
 * - ADC_SC3 - Status and Control Register 3
 * - ADC_OFS - ADC Offset Correction Register
 * - ADC_PG - ADC Plus-Side Gain Register
 * - ADC_MG - ADC Minus-Side Gain Register
 * - ADC_CLPD - ADC Plus-Side General Calibration Value Register
 * - ADC_CLPS - ADC Plus-Side General Calibration Value Register
 * - ADC_CLP4 - ADC Plus-Side General Calibration Value Register
 * - ADC_CLP3 - ADC Plus-Side General Calibration Value Register
 * - ADC_CLP2 - ADC Plus-Side General Calibration Value Register
 * - ADC_CLP1 - ADC Plus-Side General Calibration Value Register
 * - ADC_CLP0 - ADC Plus-Side General Calibration Value Register
 * - ADC_CLMD - ADC Minus-Side General Calibration Value Register
 * - ADC_CLMS - ADC Minus-Side General Calibration Value Register
 * - ADC_CLM4 - ADC Minus-Side General Calibration Value Register
 * - ADC_CLM3 - ADC Minus-Side General Calibration Value Register
 * - ADC_CLM2 - ADC Minus-Side General Calibration Value Register
 * - ADC_CLM1 - ADC Minus-Side General Calibration Value Register
 * - ADC_CLM0 - ADC Minus-Side General Calibration Value Register
 */

#define ADC_INSTANCE_COUNT (1U) /*!< Number of instances of the ADC module. */
#define ADC0_IDX (0U) /*!< Instance number for ADC0. */

/*******************************************************************************
 * ADC_SC1 - ADC Status and Control Registers 1
 ******************************************************************************/

/*!
 * @brief ADC_SC1 - ADC Status and Control Registers 1 (RW)
 *
 * Reset value: 0x0000001FU
 *
 * SC1A is used for both software and hardware trigger modes of operation. To
 * allow sequential conversions of the ADC to be triggered by internal peripherals,
 * the ADC can have more than one status and control register: one for each
 * conversion. The SC1B-SC1n registers indicate potentially multiple SC1 registers
 * for use only in hardware trigger mode. See the chip configuration information
 * about the number of SC1n registers specific to this device. The SC1n registers
 * have identical fields, and are used in a "ping-pong" approach to control ADC
 * operation. At any one point in time, only one of the SC1n registers is actively
 * controlling ADC conversions. Updating SC1A while SC1n is actively controlling
 * a conversion is allowed, and vice-versa for any of the SC1n registers specific
 * to this MCU. Writing SC1A while SC1A is actively controlling a conversion
 * aborts the current conversion. In Software Trigger mode, when SC2[ADTRG]=0,
 * writes to SC1A subsequently initiate a new conversion, if SC1[ADCH] contains a
 * value other than all 1s. Writing any of the SC1n registers while that specific
 * SC1n register is actively controlling a conversion aborts the current conversion.
 * None of the SC1B-SC1n registers are used for software trigger operation and
 * therefore writes to the SC1B-SC1n registers do not initiate a new conversion.
 */
/*!
 * @name Constants and macros for entire ADC_SC1 register
 */
/*@{*/
#define ADC_RD_SC1(base, index)  (ADC_SC1_REG(base, index))
#define ADC_WR_SC1(base, index, value) (ADC_SC1_REG(base, index) = (value))
#define ADC_RMW_SC1(base, index, mask, value) (ADC_WR_SC1(base, index, (ADC_RD_SC1(base, index) & ~(mask)) | (value)))
#define ADC_SET_SC1(base, index, value) (BME_OR32(&ADC_SC1_REG(base, index), (uint32_t)(value)))
#define ADC_CLR_SC1(base, index, value) (BME_AND32(&ADC_SC1_REG(base, index), (uint32_t)(~(value))))
#define ADC_TOG_SC1(base, index, value) (BME_XOR32(&ADC_SC1_REG(base, index), (uint32_t)(value)))
/*@}*/

/*
 * Constants & macros for individual ADC_SC1 bitfields
 */

/*!
 * @name Register ADC_SC1, field ADCH[4:0] (RW)
 *
 * Selects one of the input channels. The input channel decode depends on the
 * value of DIFF. DAD0-DAD3 are associated with the input pin pairs DADPx and
 * DADMx. Some of the input channel options in the bitfield-setting descriptions might
 * not be available for your device. For the actual ADC channel assignments for
 * your device, see the Chip Configuration details. The successive approximation
 * converter subsystem is turned off when the channel select bits are all set,
 * that is, ADCH = 11111. This feature allows explicit disabling of the ADC and
 * isolation of the input channel from all sources. Terminating continuous
 * conversions this way prevents an additional single conversion from being performed. It
 * is not necessary to set ADCH to all 1s to place the ADC in a low-power state
 * when continuous conversions are not enabled because the module automatically
 * enters a low-power state when a conversion completes.
 *
 * Values:
 * - 00000 - When DIFF=0, DADP0 is selected as input; when DIFF=1, DAD0 is
 *     selected as input.
 * - 00001 - When DIFF=0, DADP1 is selected as input; when DIFF=1, DAD1 is
 *     selected as input.
 * - 00010 - When DIFF=0, DADP2 is selected as input; when DIFF=1, DAD2 is
 *     selected as input.
 * - 00011 - When DIFF=0, DADP3 is selected as input; when DIFF=1, DAD3 is
 *     selected as input.
 * - 00100 - When DIFF=0, AD4 is selected as input; when DIFF=1, it is reserved.
 * - 00101 - When DIFF=0, AD5 is selected as input; when DIFF=1, it is reserved.
 * - 00110 - When DIFF=0, AD6 is selected as input; when DIFF=1, it is reserved.
 * - 00111 - When DIFF=0, AD7 is selected as input; when DIFF=1, it is reserved.
 * - 01000 - When DIFF=0, AD8 is selected as input; when DIFF=1, it is reserved.
 * - 01001 - When DIFF=0, AD9 is selected as input; when DIFF=1, it is reserved.
 * - 01010 - When DIFF=0, AD10 is selected as input; when DIFF=1, it is reserved.
 * - 01011 - When DIFF=0, AD11 is selected as input; when DIFF=1, it is reserved.
 * - 01100 - When DIFF=0, AD12 is selected as input; when DIFF=1, it is reserved.
 * - 01101 - When DIFF=0, AD13 is selected as input; when DIFF=1, it is reserved.
 * - 01110 - When DIFF=0, AD14 is selected as input; when DIFF=1, it is reserved.
 * - 01111 - When DIFF=0, AD15 is selected as input; when DIFF=1, it is reserved.
 * - 10000 - When DIFF=0, AD16 is selected as input; when DIFF=1, it is reserved.
 * - 10001 - When DIFF=0, AD17 is selected as input; when DIFF=1, it is reserved.
 * - 10010 - When DIFF=0, AD18 is selected as input; when DIFF=1, it is reserved.
 * - 10011 - When DIFF=0, AD19 is selected as input; when DIFF=1, it is reserved.
 * - 10100 - When DIFF=0, AD20 is selected as input; when DIFF=1, it is reserved.
 * - 10101 - When DIFF=0, AD21 is selected as input; when DIFF=1, it is reserved.
 * - 10110 - When DIFF=0, AD22 is selected as input; when DIFF=1, it is reserved.
 * - 10111 - When DIFF=0, AD23 is selected as input; when DIFF=1, it is reserved.
 * - 11000 - Reserved.
 * - 11001 - Reserved.
 * - 11010 - When DIFF=0, Temp Sensor (single-ended) is selected as input; when
 *     DIFF=1, Temp Sensor (differential) is selected as input.
 * - 11011 - When DIFF=0, Bandgap (single-ended) is selected as input; when
 *     DIFF=1, Bandgap (differential) is selected as input.
 * - 11100 - Reserved.
 * - 11101 - When DIFF=0,VREFSH is selected as input; when DIFF=1, -VREFSH
 *     (differential) is selected as input. Voltage reference selected is determined
 *     by SC2[REFSEL].
 * - 11110 - When DIFF=0,VREFSL is selected as input; when DIFF=1, it is
 *     reserved. Voltage reference selected is determined by SC2[REFSEL].
 * - 11111 - Module is disabled.
 */
/*@{*/
/*! @brief Read current value of the ADC_SC1_ADCH field. */
#define ADC_RD_SC1_ADCH(base, index) ((ADC_SC1_REG(base, index) & ADC_SC1_ADCH_MASK) >> ADC_SC1_ADCH_SHIFT)
#define ADC_BRD_SC1_ADCH(base, index) (BME_UBFX32(&ADC_SC1_REG(base, index), ADC_SC1_ADCH_SHIFT, ADC_SC1_ADCH_WIDTH))

/*! @brief Set the ADCH field to a new value. */
#define ADC_WR_SC1_ADCH(base, index, value) (ADC_RMW_SC1(base, index, ADC_SC1_ADCH_MASK, ADC_SC1_ADCH(value)))
#define ADC_BWR_SC1_ADCH(base, index, value) (BME_BFI32(&ADC_SC1_REG(base, index), ((uint32_t)(value) << ADC_SC1_ADCH_SHIFT), ADC_SC1_ADCH_SHIFT, ADC_SC1_ADCH_WIDTH))
/*@}*/

/*!
 * @name Register ADC_SC1, field DIFF[5] (RW)
 *
 * Configures the ADC to operate in differential mode. When enabled, this mode
 * automatically selects from the differential channels, and changes the
 * conversion algorithm and the number of cycles to complete a conversion.
 *
 * Values:
 * - 0 - Single-ended conversions and input channels are selected.
 * - 1 - Differential conversions and input channels are selected.
 */
/*@{*/
/*! @brief Read current value of the ADC_SC1_DIFF field. */
#define ADC_RD_SC1_DIFF(base, index) ((ADC_SC1_REG(base, index) & ADC_SC1_DIFF_MASK) >> ADC_SC1_DIFF_SHIFT)
#define ADC_BRD_SC1_DIFF(base, index) (BME_UBFX32(&ADC_SC1_REG(base, index), ADC_SC1_DIFF_SHIFT, ADC_SC1_DIFF_WIDTH))

/*! @brief Set the DIFF field to a new value. */
#define ADC_WR_SC1_DIFF(base, index, value) (ADC_RMW_SC1(base, index, ADC_SC1_DIFF_MASK, ADC_SC1_DIFF(value)))
#define ADC_BWR_SC1_DIFF(base, index, value) (BME_BFI32(&ADC_SC1_REG(base, index), ((uint32_t)(value) << ADC_SC1_DIFF_SHIFT), ADC_SC1_DIFF_SHIFT, ADC_SC1_DIFF_WIDTH))
/*@}*/

/*!
 * @name Register ADC_SC1, field AIEN[6] (RW)
 *
 * Enables conversion complete interrupts. When COCO becomes set while the
 * respective AIEN is high, an interrupt is asserted.
 *
 * Values:
 * - 0 - Conversion complete interrupt is disabled.
 * - 1 - Conversion complete interrupt is enabled.
 */
/*@{*/
/*! @brief Read current value of the ADC_SC1_AIEN field. */
#define ADC_RD_SC1_AIEN(base, index) ((ADC_SC1_REG(base, index) & ADC_SC1_AIEN_MASK) >> ADC_SC1_AIEN_SHIFT)
#define ADC_BRD_SC1_AIEN(base, index) (BME_UBFX32(&ADC_SC1_REG(base, index), ADC_SC1_AIEN_SHIFT, ADC_SC1_AIEN_WIDTH))

/*! @brief Set the AIEN field to a new value. */
#define ADC_WR_SC1_AIEN(base, index, value) (ADC_RMW_SC1(base, index, ADC_SC1_AIEN_MASK, ADC_SC1_AIEN(value)))
#define ADC_BWR_SC1_AIEN(base, index, value) (BME_BFI32(&ADC_SC1_REG(base, index), ((uint32_t)(value) << ADC_SC1_AIEN_SHIFT), ADC_SC1_AIEN_SHIFT, ADC_SC1_AIEN_WIDTH))
/*@}*/

/*!
 * @name Register ADC_SC1, field COCO[7] (RO)
 *
 * This is a read-only field that is set each time a conversion is completed
 * when the compare function is disabled, or SC2[ACFE]=0 and the hardware average
 * function is disabled, or SC3[AVGE]=0. When the compare function is enabled, or
 * SC2[ACFE]=1, COCO is set upon completion of a conversion only if the compare
 * result is true. When the hardware average function is enabled, or SC3[AVGE]=1,
 * COCO is set upon completion of the selected number of conversions (determined
 * by AVGS). COCO in SC1A is also set at the completion of a calibration sequence.
 * COCO is cleared when the respective SC1n register is written or when the
 * respective Rn register is read.
 *
 * Values:
 * - 0 - Conversion is not completed.
 * - 1 - Conversion is completed.
 */
/*@{*/
/*! @brief Read current value of the ADC_SC1_COCO field. */
#define ADC_RD_SC1_COCO(base, index) ((ADC_SC1_REG(base, index) & ADC_SC1_COCO_MASK) >> ADC_SC1_COCO_SHIFT)
#define ADC_BRD_SC1_COCO(base, index) (BME_UBFX32(&ADC_SC1_REG(base, index), ADC_SC1_COCO_SHIFT, ADC_SC1_COCO_WIDTH))
/*@}*/

/*******************************************************************************
 * ADC_CFG1 - ADC Configuration Register 1
 ******************************************************************************/

/*!
 * @brief ADC_CFG1 - ADC Configuration Register 1 (RW)
 *
 * Reset value: 0x00000000U
 *
 * The configuration Register 1 (CFG1) selects the mode of operation, clock
 * source, clock divide, and configuration for low power or long sample time.
 */
/*!
 * @name Constants and macros for entire ADC_CFG1 register
 */
/*@{*/
#define ADC_RD_CFG1(base)        (ADC_CFG1_REG(base))
#define ADC_WR_CFG1(base, value) (ADC_CFG1_REG(base) = (value))
#define ADC_RMW_CFG1(base, mask, value) (ADC_WR_CFG1(base, (ADC_RD_CFG1(base) & ~(mask)) | (value)))
#define ADC_SET_CFG1(base, value) (BME_OR32(&ADC_CFG1_REG(base), (uint32_t)(value)))
#define ADC_CLR_CFG1(base, value) (BME_AND32(&ADC_CFG1_REG(base), (uint32_t)(~(value))))
#define ADC_TOG_CFG1(base, value) (BME_XOR32(&ADC_CFG1_REG(base), (uint32_t)(value)))
/*@}*/

/*
 * Constants & macros for individual ADC_CFG1 bitfields
 */

/*!
 * @name Register ADC_CFG1, field ADICLK[1:0] (RW)
 *
 * Selects the input clock source to generate the internal clock, ADCK. Note
 * that when the ADACK clock source is selected, it is not required to be active
 * prior to conversion start. When it is selected and it is not active prior to a
 * conversion start, when CFG2[ADACKEN]=0, the asynchronous clock is activated at
 * the start of a conversion and deactivated when conversions are terminated. In
 * this case, there is an associated clock startup delay each time the clock
 * source is re-activated.
 *
 * Values:
 * - 00 - Bus clock
 * - 01 - Bus clock divided by 2(BUSCLK/DIV2)
 * - 10 - Alternate clock (ALTCLK)
 * - 11 - Asynchronous clock (ADACK)
 */
/*@{*/
/*! @brief Read current value of the ADC_CFG1_ADICLK field. */
#define ADC_RD_CFG1_ADICLK(base) ((ADC_CFG1_REG(base) & ADC_CFG1_ADICLK_MASK) >> ADC_CFG1_ADICLK_SHIFT)
#define ADC_BRD_CFG1_ADICLK(base) (BME_UBFX32(&ADC_CFG1_REG(base), ADC_CFG1_ADICLK_SHIFT, ADC_CFG1_ADICLK_WIDTH))

/*! @brief Set the ADICLK field to a new value. */
#define ADC_WR_CFG1_ADICLK(base, value) (ADC_RMW_CFG1(base, ADC_CFG1_ADICLK_MASK, ADC_CFG1_ADICLK(value)))
#define ADC_BWR_CFG1_ADICLK(base, value) (BME_BFI32(&ADC_CFG1_REG(base), ((uint32_t)(value) << ADC_CFG1_ADICLK_SHIFT), ADC_CFG1_ADICLK_SHIFT, ADC_CFG1_ADICLK_WIDTH))
/*@}*/

/*!
 * @name Register ADC_CFG1, field MODE[3:2] (RW)
 *
 * Selects the ADC resolution mode.
 *
 * Values:
 * - 00 - When DIFF=0:It is single-ended 8-bit conversion; when DIFF=1, it is
 *     differential 9-bit conversion with 2's complement output.
 * - 01 - When DIFF=0:It is single-ended 12-bit conversion ; when DIFF=1, it is
 *     differential 13-bit conversion with 2's complement output.
 * - 10 - When DIFF=0:It is single-ended 10-bit conversion. ; when DIFF=1, it is
 *     differential 11-bit conversion with 2's complement output
 * - 11 - When DIFF=0:It is single-ended 16-bit conversion..; when DIFF=1, it is
 *     differential 16-bit conversion with 2's complement output
 */
/*@{*/
/*! @brief Read current value of the ADC_CFG1_MODE field. */
#define ADC_RD_CFG1_MODE(base) ((ADC_CFG1_REG(base) & ADC_CFG1_MODE_MASK) >> ADC_CFG1_MODE_SHIFT)
#define ADC_BRD_CFG1_MODE(base) (BME_UBFX32(&ADC_CFG1_REG(base), ADC_CFG1_MODE_SHIFT, ADC_CFG1_MODE_WIDTH))

/*! @brief Set the MODE field to a new value. */
#define ADC_WR_CFG1_MODE(base, value) (ADC_RMW_CFG1(base, ADC_CFG1_MODE_MASK, ADC_CFG1_MODE(value)))
#define ADC_BWR_CFG1_MODE(base, value) (BME_BFI32(&ADC_CFG1_REG(base), ((uint32_t)(value) << ADC_CFG1_MODE_SHIFT), ADC_CFG1_MODE_SHIFT, ADC_CFG1_MODE_WIDTH))
/*@}*/

/*!
 * @name Register ADC_CFG1, field ADLSMP[4] (RW)
 *
 * Selects between different sample times based on the conversion mode selected.
 * This field adjusts the sample period to allow higher impedance inputs to be
 * accurately sampled or to maximize conversion speed for lower impedance inputs.
 * Longer sample times can also be used to lower overall power consumption if
 * continuous conversions are enabled and high conversion rates are not required.
 * When ADLSMP=1, the long sample time select bits, (ADLSTS[1:0]), can select the
 * extent of the long sample time.
 *
 * Values:
 * - 0 - Short sample time.
 * - 1 - Long sample time.
 */
/*@{*/
/*! @brief Read current value of the ADC_CFG1_ADLSMP field. */
#define ADC_RD_CFG1_ADLSMP(base) ((ADC_CFG1_REG(base) & ADC_CFG1_ADLSMP_MASK) >> ADC_CFG1_ADLSMP_SHIFT)
#define ADC_BRD_CFG1_ADLSMP(base) (BME_UBFX32(&ADC_CFG1_REG(base), ADC_CFG1_ADLSMP_SHIFT, ADC_CFG1_ADLSMP_WIDTH))

/*! @brief Set the ADLSMP field to a new value. */
#define ADC_WR_CFG1_ADLSMP(base, value) (ADC_RMW_CFG1(base, ADC_CFG1_ADLSMP_MASK, ADC_CFG1_ADLSMP(value)))
#define ADC_BWR_CFG1_ADLSMP(base, value) (BME_BFI32(&ADC_CFG1_REG(base), ((uint32_t)(value) << ADC_CFG1_ADLSMP_SHIFT), ADC_CFG1_ADLSMP_SHIFT, ADC_CFG1_ADLSMP_WIDTH))
/*@}*/

/*!
 * @name Register ADC_CFG1, field ADIV[6:5] (RW)
 *
 * Selects the divide ratio used by the ADC to generate the internal clock ADCK.
 *
 * Values:
 * - 00 - The divide ratio is 1 and the clock rate is input clock.
 * - 01 - The divide ratio is 2 and the clock rate is (input clock)/2.
 * - 10 - The divide ratio is 4 and the clock rate is (input clock)/4.
 * - 11 - The divide ratio is 8 and the clock rate is (input clock)/8.
 */
/*@{*/
/*! @brief Read current value of the ADC_CFG1_ADIV field. */
#define ADC_RD_CFG1_ADIV(base) ((ADC_CFG1_REG(base) & ADC_CFG1_ADIV_MASK) >> ADC_CFG1_ADIV_SHIFT)
#define ADC_BRD_CFG1_ADIV(base) (BME_UBFX32(&ADC_CFG1_REG(base), ADC_CFG1_ADIV_SHIFT, ADC_CFG1_ADIV_WIDTH))

/*! @brief Set the ADIV field to a new value. */
#define ADC_WR_CFG1_ADIV(base, value) (ADC_RMW_CFG1(base, ADC_CFG1_ADIV_MASK, ADC_CFG1_ADIV(value)))
#define ADC_BWR_CFG1_ADIV(base, value) (BME_BFI32(&ADC_CFG1_REG(base), ((uint32_t)(value) << ADC_CFG1_ADIV_SHIFT), ADC_CFG1_ADIV_SHIFT, ADC_CFG1_ADIV_WIDTH))
/*@}*/

/*!
 * @name Register ADC_CFG1, field ADLPC[7] (RW)
 *
 * Controls the power configuration of the successive approximation converter.
 * This optimizes power consumption when higher sample rates are not required.
 *
 * Values:
 * - 0 - Normal power configuration.
 * - 1 - Low-power configuration. The power is reduced at the expense of maximum
 *     clock speed.
 */
/*@{*/
/*! @brief Read current value of the ADC_CFG1_ADLPC field. */
#define ADC_RD_CFG1_ADLPC(base) ((ADC_CFG1_REG(base) & ADC_CFG1_ADLPC_MASK) >> ADC_CFG1_ADLPC_SHIFT)
#define ADC_BRD_CFG1_ADLPC(base) (BME_UBFX32(&ADC_CFG1_REG(base), ADC_CFG1_ADLPC_SHIFT, ADC_CFG1_ADLPC_WIDTH))

/*! @brief Set the ADLPC field to a new value. */
#define ADC_WR_CFG1_ADLPC(base, value) (ADC_RMW_CFG1(base, ADC_CFG1_ADLPC_MASK, ADC_CFG1_ADLPC(value)))
#define ADC_BWR_CFG1_ADLPC(base, value) (BME_BFI32(&ADC_CFG1_REG(base), ((uint32_t)(value) << ADC_CFG1_ADLPC_SHIFT), ADC_CFG1_ADLPC_SHIFT, ADC_CFG1_ADLPC_WIDTH))
/*@}*/

/*******************************************************************************
 * ADC_CFG2 - ADC Configuration Register 2
 ******************************************************************************/

/*!
 * @brief ADC_CFG2 - ADC Configuration Register 2 (RW)
 *
 * Reset value: 0x00000000U
 *
 * Configuration Register 2 (CFG2) selects the special high-speed configuration
 * for very high speed conversions and selects the long sample time duration
 * during long sample mode.
 */
/*!
 * @name Constants and macros for entire ADC_CFG2 register
 */
/*@{*/
#define ADC_RD_CFG2(base)        (ADC_CFG2_REG(base))
#define ADC_WR_CFG2(base, value) (ADC_CFG2_REG(base) = (value))
#define ADC_RMW_CFG2(base, mask, value) (ADC_WR_CFG2(base, (ADC_RD_CFG2(base) & ~(mask)) | (value)))
#define ADC_SET_CFG2(base, value) (BME_OR32(&ADC_CFG2_REG(base), (uint32_t)(value)))
#define ADC_CLR_CFG2(base, value) (BME_AND32(&ADC_CFG2_REG(base), (uint32_t)(~(value))))
#define ADC_TOG_CFG2(base, value) (BME_XOR32(&ADC_CFG2_REG(base), (uint32_t)(value)))
/*@}*/

/*
 * Constants & macros for individual ADC_CFG2 bitfields
 */

/*!
 * @name Register ADC_CFG2, field ADLSTS[1:0] (RW)
 *
 * Selects between the extended sample times when long sample time is selected,
 * that is, when CFG1[ADLSMP]=1. This allows higher impedance inputs to be
 * accurately sampled or to maximize conversion speed for lower impedance inputs.
 * Longer sample times can also be used to lower overall power consumption when
 * continuous conversions are enabled if high conversion rates are not required.
 *
 * Values:
 * - 00 - Default longest sample time; 20 extra ADCK cycles; 24 ADCK cycles
 *     total.
 * - 01 - 12 extra ADCK cycles; 16 ADCK cycles total sample time.
 * - 10 - 6 extra ADCK cycles; 10 ADCK cycles total sample time.
 * - 11 - 2 extra ADCK cycles; 6 ADCK cycles total sample time.
 */
/*@{*/
/*! @brief Read current value of the ADC_CFG2_ADLSTS field. */
#define ADC_RD_CFG2_ADLSTS(base) ((ADC_CFG2_REG(base) & ADC_CFG2_ADLSTS_MASK) >> ADC_CFG2_ADLSTS_SHIFT)
#define ADC_BRD_CFG2_ADLSTS(base) (BME_UBFX32(&ADC_CFG2_REG(base), ADC_CFG2_ADLSTS_SHIFT, ADC_CFG2_ADLSTS_WIDTH))

/*! @brief Set the ADLSTS field to a new value. */
#define ADC_WR_CFG2_ADLSTS(base, value) (ADC_RMW_CFG2(base, ADC_CFG2_ADLSTS_MASK, ADC_CFG2_ADLSTS(value)))
#define ADC_BWR_CFG2_ADLSTS(base, value) (BME_BFI32(&ADC_CFG2_REG(base), ((uint32_t)(value) << ADC_CFG2_ADLSTS_SHIFT), ADC_CFG2_ADLSTS_SHIFT, ADC_CFG2_ADLSTS_WIDTH))
/*@}*/

/*!
 * @name Register ADC_CFG2, field ADHSC[2] (RW)
 *
 * Configures the ADC for very high-speed operation. The conversion sequence is
 * altered with 2 ADCK cycles added to the conversion time to allow higher speed
 * conversion clocks.
 *
 * Values:
 * - 0 - Normal conversion sequence selected.
 * - 1 - High-speed conversion sequence selected with 2 additional ADCK cycles
 *     to total conversion time.
 */
/*@{*/
/*! @brief Read current value of the ADC_CFG2_ADHSC field. */
#define ADC_RD_CFG2_ADHSC(base) ((ADC_CFG2_REG(base) & ADC_CFG2_ADHSC_MASK) >> ADC_CFG2_ADHSC_SHIFT)
#define ADC_BRD_CFG2_ADHSC(base) (BME_UBFX32(&ADC_CFG2_REG(base), ADC_CFG2_ADHSC_SHIFT, ADC_CFG2_ADHSC_WIDTH))

/*! @brief Set the ADHSC field to a new value. */
#define ADC_WR_CFG2_ADHSC(base, value) (ADC_RMW_CFG2(base, ADC_CFG2_ADHSC_MASK, ADC_CFG2_ADHSC(value)))
#define ADC_BWR_CFG2_ADHSC(base, value) (BME_BFI32(&ADC_CFG2_REG(base), ((uint32_t)(value) << ADC_CFG2_ADHSC_SHIFT), ADC_CFG2_ADHSC_SHIFT, ADC_CFG2_ADHSC_WIDTH))
/*@}*/

/*!
 * @name Register ADC_CFG2, field ADACKEN[3] (RW)
 *
 * Enables the asynchronous clock source and the clock source output regardless
 * of the conversion and status of CFG1[ADICLK]. Based on MCU configuration, the
 * asynchronous clock may be used by other modules. See chip configuration
 * information. Setting this field allows the clock to be used even while the ADC is
 * idle or operating from a different clock source. Also, latency of initiating a
 * single or first-continuous conversion with the asynchronous clock selected is
 * reduced because the ADACK clock is already operational.
 *
 * Values:
 * - 0 - Asynchronous clock output disabled; Asynchronous clock is enabled only
 *     if selected by ADICLK and a conversion is active.
 * - 1 - Asynchronous clock and clock output is enabled regardless of the state
 *     of the ADC.
 */
/*@{*/
/*! @brief Read current value of the ADC_CFG2_ADACKEN field. */
#define ADC_RD_CFG2_ADACKEN(base) ((ADC_CFG2_REG(base) & ADC_CFG2_ADACKEN_MASK) >> ADC_CFG2_ADACKEN_SHIFT)
#define ADC_BRD_CFG2_ADACKEN(base) (BME_UBFX32(&ADC_CFG2_REG(base), ADC_CFG2_ADACKEN_SHIFT, ADC_CFG2_ADACKEN_WIDTH))

/*! @brief Set the ADACKEN field to a new value. */
#define ADC_WR_CFG2_ADACKEN(base, value) (ADC_RMW_CFG2(base, ADC_CFG2_ADACKEN_MASK, ADC_CFG2_ADACKEN(value)))
#define ADC_BWR_CFG2_ADACKEN(base, value) (BME_BFI32(&ADC_CFG2_REG(base), ((uint32_t)(value) << ADC_CFG2_ADACKEN_SHIFT), ADC_CFG2_ADACKEN_SHIFT, ADC_CFG2_ADACKEN_WIDTH))
/*@}*/

/*!
 * @name Register ADC_CFG2, field MUXSEL[4] (RW)
 *
 * Changes the ADC mux setting to select between alternate sets of ADC channels.
 *
 * Values:
 * - 0 - ADxxa channels are selected.
 * - 1 - ADxxb channels are selected.
 */
/*@{*/
/*! @brief Read current value of the ADC_CFG2_MUXSEL field. */
#define ADC_RD_CFG2_MUXSEL(base) ((ADC_CFG2_REG(base) & ADC_CFG2_MUXSEL_MASK) >> ADC_CFG2_MUXSEL_SHIFT)
#define ADC_BRD_CFG2_MUXSEL(base) (BME_UBFX32(&ADC_CFG2_REG(base), ADC_CFG2_MUXSEL_SHIFT, ADC_CFG2_MUXSEL_WIDTH))

/*! @brief Set the MUXSEL field to a new value. */
#define ADC_WR_CFG2_MUXSEL(base, value) (ADC_RMW_CFG2(base, ADC_CFG2_MUXSEL_MASK, ADC_CFG2_MUXSEL(value)))
#define ADC_BWR_CFG2_MUXSEL(base, value) (BME_BFI32(&ADC_CFG2_REG(base), ((uint32_t)(value) << ADC_CFG2_MUXSEL_SHIFT), ADC_CFG2_MUXSEL_SHIFT, ADC_CFG2_MUXSEL_WIDTH))
/*@}*/

/*******************************************************************************
 * ADC_R - ADC Data Result Register
 ******************************************************************************/

/*!
 * @brief ADC_R - ADC Data Result Register (RO)
 *
 * Reset value: 0x00000000U
 *
 * The data result registers (Rn) contain the result of an ADC conversion of the
 * channel selected by the corresponding status and channel control register
 * (SC1A:SC1n). For every status and channel control register, there is a
 * corresponding data result register. Unused bits in R n are cleared in unsigned
 * right-aligned modes and carry the sign bit (MSB) in sign-extended 2's complement modes.
 * For example, when configured for 10-bit single-ended mode, D[15:10] are
 * cleared. When configured for 11-bit differential mode, D[15:10] carry the sign bit,
 * that is, bit 10 extended through bit 15. The following table describes the
 * behavior of the data result registers in the different modes of operation. Data
 * result register description Conversion mode D15 D14 D13 D12 D11 D10 D9 D8 D7
 * D6 D5 D4 D3 D2 D1 D0 Format 16-bit differential S D D D D D D D D D D D D D D D
 * Signed 2's complement 16-bit single-ended D D D D D D D D D D D D D D D D
 * Unsigned right justified 13-bit differential S S S S D D D D D D D D D D D D
 * Sign-extended 2's complement 12-bit single-ended 0 0 0 0 D D D D D D D D D D D D
 * Unsigned right-justified 11-bit differential S S S S S S D D D D D D D D D D
 * Sign-extended 2's complement 10-bit single-ended 0 0 0 0 0 0 D D D D D D D D D D
 * Unsigned right-justified 9-bit differential S S S S S S S S D D D D D D D D
 * Sign-extended 2's complement 8-bit single-ended 0 0 0 0 0 0 0 0 D D D D D D D D
 * Unsigned right-justified S: Sign bit or sign bit extension; D: Data, which is
 * 2's complement data if indicated
 */
/*!
 * @name Constants and macros for entire ADC_R register
 */
/*@{*/
#define ADC_RD_R(base, index)    (ADC_R_REG(base, index))
/*@}*/

/*
 * Constants & macros for individual ADC_R bitfields
 */

/*!
 * @name Register ADC_R, field D[15:0] (RO)
 */
/*@{*/
/*! @brief Read current value of the ADC_R_D field. */
#define ADC_RD_R_D(base, index) ((ADC_R_REG(base, index) & ADC_R_D_MASK) >> ADC_R_D_SHIFT)
#define ADC_BRD_R_D(base, index) (BME_UBFX32(&ADC_R_REG(base, index), ADC_R_D_SHIFT, ADC_R_D_WIDTH))
/*@}*/

/*******************************************************************************
 * ADC_CV1 - Compare Value Registers
 ******************************************************************************/

/*!
 * @brief ADC_CV1 - Compare Value Registers (RW)
 *
 * Reset value: 0x00000000U
 *
 * The Compare Value Registers (CV1 and CV2) contain a compare value used to
 * compare the conversion result when the compare function is enabled, that is,
 * SC2[ACFE]=1. This register is formatted in the same way as the Rn registers in
 * different modes of operation for both bit position definition and value format
 * using unsigned or sign-extended 2's complement. Therefore, the compare function
 * uses only the CVn fields that are related to the ADC mode of operation. The
 * compare value 2 register (CV2) is used only when the compare range function is
 * enabled, that is, SC2[ACREN]=1.
 */
/*!
 * @name Constants and macros for entire ADC_CV1 register
 */
/*@{*/
#define ADC_RD_CV1(base)         (ADC_CV1_REG(base))
#define ADC_WR_CV1(base, value)  (ADC_CV1_REG(base) = (value))
#define ADC_RMW_CV1(base, mask, value) (ADC_WR_CV1(base, (ADC_RD_CV1(base) & ~(mask)) | (value)))
#define ADC_SET_CV1(base, value) (BME_OR32(&ADC_CV1_REG(base), (uint32_t)(value)))
#define ADC_CLR_CV1(base, value) (BME_AND32(&ADC_CV1_REG(base), (uint32_t)(~(value))))
#define ADC_TOG_CV1(base, value) (BME_XOR32(&ADC_CV1_REG(base), (uint32_t)(value)))
/*@}*/

/*
 * Constants & macros for individual ADC_CV1 bitfields
 */

/*!
 * @name Register ADC_CV1, field CV[15:0] (RW)
 */
/*@{*/
/*! @brief Read current value of the ADC_CV1_CV field. */
#define ADC_RD_CV1_CV(base)  ((ADC_CV1_REG(base) & ADC_CV1_CV_MASK) >> ADC_CV1_CV_SHIFT)
#define ADC_BRD_CV1_CV(base) (BME_UBFX32(&ADC_CV1_REG(base), ADC_CV1_CV_SHIFT, ADC_CV1_CV_WIDTH))

/*! @brief Set the CV field to a new value. */
#define ADC_WR_CV1_CV(base, value) (ADC_RMW_CV1(base, ADC_CV1_CV_MASK, ADC_CV1_CV(value)))
#define ADC_BWR_CV1_CV(base, value) (BME_BFI32(&ADC_CV1_REG(base), ((uint32_t)(value) << ADC_CV1_CV_SHIFT), ADC_CV1_CV_SHIFT, ADC_CV1_CV_WIDTH))
/*@}*/

/*******************************************************************************
 * ADC_CV2 - Compare Value Registers
 ******************************************************************************/

/*!
 * @brief ADC_CV2 - Compare Value Registers (RW)
 *
 * Reset value: 0x00000000U
 *
 * The Compare Value Registers (CV1 and CV2) contain a compare value used to
 * compare the conversion result when the compare function is enabled, that is,
 * SC2[ACFE]=1. This register is formatted in the same way as the Rn registers in
 * different modes of operation for both bit position definition and value format
 * using unsigned or sign-extended 2's complement. Therefore, the compare function
 * uses only the CVn fields that are related to the ADC mode of operation. The
 * compare value 2 register (CV2) is used only when the compare range function is
 * enabled, that is, SC2[ACREN]=1.
 */
/*!
 * @name Constants and macros for entire ADC_CV2 register
 */
/*@{*/
#define ADC_RD_CV2(base)         (ADC_CV2_REG(base))
#define ADC_WR_CV2(base, value)  (ADC_CV2_REG(base) = (value))
#define ADC_RMW_CV2(base, mask, value) (ADC_WR_CV2(base, (ADC_RD_CV2(base) & ~(mask)) | (value)))
#define ADC_SET_CV2(base, value) (BME_OR32(&ADC_CV2_REG(base), (uint32_t)(value)))
#define ADC_CLR_CV2(base, value) (BME_AND32(&ADC_CV2_REG(base), (uint32_t)(~(value))))
#define ADC_TOG_CV2(base, value) (BME_XOR32(&ADC_CV2_REG(base), (uint32_t)(value)))
/*@}*/

/*
 * Constants & macros for individual ADC_CV2 bitfields
 */

/*!
 * @name Register ADC_CV2, field CV[15:0] (RW)
 */
/*@{*/
/*! @brief Read current value of the ADC_CV2_CV field. */
#define ADC_RD_CV2_CV(base)  ((ADC_CV2_REG(base) & ADC_CV2_CV_MASK) >> ADC_CV2_CV_SHIFT)
#define ADC_BRD_CV2_CV(base) (BME_UBFX32(&ADC_CV2_REG(base), ADC_CV2_CV_SHIFT, ADC_CV2_CV_WIDTH))

/*! @brief Set the CV field to a new value. */
#define ADC_WR_CV2_CV(base, value) (ADC_RMW_CV2(base, ADC_CV2_CV_MASK, ADC_CV2_CV(value)))
#define ADC_BWR_CV2_CV(base, value) (BME_BFI32(&ADC_CV2_REG(base), ((uint32_t)(value) << ADC_CV2_CV_SHIFT), ADC_CV2_CV_SHIFT, ADC_CV2_CV_WIDTH))
/*@}*/

/*******************************************************************************
 * ADC_SC2 - Status and Control Register 2
 ******************************************************************************/

/*!
 * @brief ADC_SC2 - Status and Control Register 2 (RW)
 *
 * Reset value: 0x00000000U
 *
 * The status and control register 2 (SC2) contains the conversion active,
 * hardware/software trigger select, compare function, and voltage reference select of
 * the ADC module.
 */
/*!
 * @name Constants and macros for entire ADC_SC2 register
 */
/*@{*/
#define ADC_RD_SC2(base)         (ADC_SC2_REG(base))
#define ADC_WR_SC2(base, value)  (ADC_SC2_REG(base) = (value))
#define ADC_RMW_SC2(base, mask, value) (ADC_WR_SC2(base, (ADC_RD_SC2(base) & ~(mask)) | (value)))
#define ADC_SET_SC2(base, value) (BME_OR32(&ADC_SC2_REG(base), (uint32_t)(value)))
#define ADC_CLR_SC2(base, value) (BME_AND32(&ADC_SC2_REG(base), (uint32_t)(~(value))))
#define ADC_TOG_SC2(base, value) (BME_XOR32(&ADC_SC2_REG(base), (uint32_t)(value)))
/*@}*/

/*
 * Constants & macros for individual ADC_SC2 bitfields
 */

/*!
 * @name Register ADC_SC2, field REFSEL[1:0] (RW)
 *
 * Selects the voltage reference source used for conversions.
 *
 * Values:
 * - 00 - Default voltage reference pin pair, that is, external pins VREFH and
 *     VREFL
 * - 01 - Alternate reference pair, that is, VALTH and VALTL . This pair may be
 *     additional external pins or internal sources depending on the MCU
 *     configuration. See the chip configuration information for details specific to this
 *     MCU
 * - 10 - Reserved
 * - 11 - Reserved
 */
/*@{*/
/*! @brief Read current value of the ADC_SC2_REFSEL field. */
#define ADC_RD_SC2_REFSEL(base) ((ADC_SC2_REG(base) & ADC_SC2_REFSEL_MASK) >> ADC_SC2_REFSEL_SHIFT)
#define ADC_BRD_SC2_REFSEL(base) (BME_UBFX32(&ADC_SC2_REG(base), ADC_SC2_REFSEL_SHIFT, ADC_SC2_REFSEL_WIDTH))

/*! @brief Set the REFSEL field to a new value. */
#define ADC_WR_SC2_REFSEL(base, value) (ADC_RMW_SC2(base, ADC_SC2_REFSEL_MASK, ADC_SC2_REFSEL(value)))
#define ADC_BWR_SC2_REFSEL(base, value) (BME_BFI32(&ADC_SC2_REG(base), ((uint32_t)(value) << ADC_SC2_REFSEL_SHIFT), ADC_SC2_REFSEL_SHIFT, ADC_SC2_REFSEL_WIDTH))
/*@}*/

/*!
 * @name Register ADC_SC2, field DMAEN[2] (RW)
 *
 * Values:
 * - 0 - DMA is disabled.
 * - 1 - DMA is enabled and will assert the ADC DMA request during an ADC
 *     conversion complete event noted when any of the SC1n[COCO] flags is asserted.
 */
/*@{*/
/*! @brief Read current value of the ADC_SC2_DMAEN field. */
#define ADC_RD_SC2_DMAEN(base) ((ADC_SC2_REG(base) & ADC_SC2_DMAEN_MASK) >> ADC_SC2_DMAEN_SHIFT)
#define ADC_BRD_SC2_DMAEN(base) (BME_UBFX32(&ADC_SC2_REG(base), ADC_SC2_DMAEN_SHIFT, ADC_SC2_DMAEN_WIDTH))

/*! @brief Set the DMAEN field to a new value. */
#define ADC_WR_SC2_DMAEN(base, value) (ADC_RMW_SC2(base, ADC_SC2_DMAEN_MASK, ADC_SC2_DMAEN(value)))
#define ADC_BWR_SC2_DMAEN(base, value) (BME_BFI32(&ADC_SC2_REG(base), ((uint32_t)(value) << ADC_SC2_DMAEN_SHIFT), ADC_SC2_DMAEN_SHIFT, ADC_SC2_DMAEN_WIDTH))
/*@}*/

/*!
 * @name Register ADC_SC2, field ACREN[3] (RW)
 *
 * Configures the compare function to check if the conversion result of the
 * input being monitored is either between or outside the range formed by CV1 and CV2
 * determined by the value of ACFGT. ACFE must be set for ACFGT to have any
 * effect.
 *
 * Values:
 * - 0 - Range function disabled. Only CV1 is compared.
 * - 1 - Range function enabled. Both CV1 and CV2 are compared.
 */
/*@{*/
/*! @brief Read current value of the ADC_SC2_ACREN field. */
#define ADC_RD_SC2_ACREN(base) ((ADC_SC2_REG(base) & ADC_SC2_ACREN_MASK) >> ADC_SC2_ACREN_SHIFT)
#define ADC_BRD_SC2_ACREN(base) (BME_UBFX32(&ADC_SC2_REG(base), ADC_SC2_ACREN_SHIFT, ADC_SC2_ACREN_WIDTH))

/*! @brief Set the ACREN field to a new value. */
#define ADC_WR_SC2_ACREN(base, value) (ADC_RMW_SC2(base, ADC_SC2_ACREN_MASK, ADC_SC2_ACREN(value)))
#define ADC_BWR_SC2_ACREN(base, value) (BME_BFI32(&ADC_SC2_REG(base), ((uint32_t)(value) << ADC_SC2_ACREN_SHIFT), ADC_SC2_ACREN_SHIFT, ADC_SC2_ACREN_WIDTH))
/*@}*/

/*!
 * @name Register ADC_SC2, field ACFGT[4] (RW)
 *
 * Configures the compare function to check the conversion result relative to
 * the CV1 and CV2 based upon the value of ACREN. ACFE must be set for ACFGT to
 * have any effect.
 *
 * Values:
 * - 0 - Configures less than threshold, outside range not inclusive and inside
 *     range not inclusive; functionality based on the values placed in CV1 and
 *     CV2.
 * - 1 - Configures greater than or equal to threshold, outside and inside
 *     ranges inclusive; functionality based on the values placed in CV1 and CV2.
 */
/*@{*/
/*! @brief Read current value of the ADC_SC2_ACFGT field. */
#define ADC_RD_SC2_ACFGT(base) ((ADC_SC2_REG(base) & ADC_SC2_ACFGT_MASK) >> ADC_SC2_ACFGT_SHIFT)
#define ADC_BRD_SC2_ACFGT(base) (BME_UBFX32(&ADC_SC2_REG(base), ADC_SC2_ACFGT_SHIFT, ADC_SC2_ACFGT_WIDTH))

/*! @brief Set the ACFGT field to a new value. */
#define ADC_WR_SC2_ACFGT(base, value) (ADC_RMW_SC2(base, ADC_SC2_ACFGT_MASK, ADC_SC2_ACFGT(value)))
#define ADC_BWR_SC2_ACFGT(base, value) (BME_BFI32(&ADC_SC2_REG(base), ((uint32_t)(value) << ADC_SC2_ACFGT_SHIFT), ADC_SC2_ACFGT_SHIFT, ADC_SC2_ACFGT_WIDTH))
/*@}*/

/*!
 * @name Register ADC_SC2, field ACFE[5] (RW)
 *
 * Enables the compare function.
 *
 * Values:
 * - 0 - Compare function disabled.
 * - 1 - Compare function enabled.
 */
/*@{*/
/*! @brief Read current value of the ADC_SC2_ACFE field. */
#define ADC_RD_SC2_ACFE(base) ((ADC_SC2_REG(base) & ADC_SC2_ACFE_MASK) >> ADC_SC2_ACFE_SHIFT)
#define ADC_BRD_SC2_ACFE(base) (BME_UBFX32(&ADC_SC2_REG(base), ADC_SC2_ACFE_SHIFT, ADC_SC2_ACFE_WIDTH))

/*! @brief Set the ACFE field to a new value. */
#define ADC_WR_SC2_ACFE(base, value) (ADC_RMW_SC2(base, ADC_SC2_ACFE_MASK, ADC_SC2_ACFE(value)))
#define ADC_BWR_SC2_ACFE(base, value) (BME_BFI32(&ADC_SC2_REG(base), ((uint32_t)(value) << ADC_SC2_ACFE_SHIFT), ADC_SC2_ACFE_SHIFT, ADC_SC2_ACFE_WIDTH))
/*@}*/

/*!
 * @name Register ADC_SC2, field ADTRG[6] (RW)
 *
 * Selects the type of trigger used for initiating a conversion. Two types of
 * trigger are selectable: Software trigger: When software trigger is selected, a
 * conversion is initiated following a write to SC1A. Hardware trigger: When
 * hardware trigger is selected, a conversion is initiated following the assertion of
 * the ADHWT input after a pulse of the ADHWTSn input.
 *
 * Values:
 * - 0 - Software trigger selected.
 * - 1 - Hardware trigger selected.
 */
/*@{*/
/*! @brief Read current value of the ADC_SC2_ADTRG field. */
#define ADC_RD_SC2_ADTRG(base) ((ADC_SC2_REG(base) & ADC_SC2_ADTRG_MASK) >> ADC_SC2_ADTRG_SHIFT)
#define ADC_BRD_SC2_ADTRG(base) (BME_UBFX32(&ADC_SC2_REG(base), ADC_SC2_ADTRG_SHIFT, ADC_SC2_ADTRG_WIDTH))

/*! @brief Set the ADTRG field to a new value. */
#define ADC_WR_SC2_ADTRG(base, value) (ADC_RMW_SC2(base, ADC_SC2_ADTRG_MASK, ADC_SC2_ADTRG(value)))
#define ADC_BWR_SC2_ADTRG(base, value) (BME_BFI32(&ADC_SC2_REG(base), ((uint32_t)(value) << ADC_SC2_ADTRG_SHIFT), ADC_SC2_ADTRG_SHIFT, ADC_SC2_ADTRG_WIDTH))
/*@}*/

/*!
 * @name Register ADC_SC2, field ADACT[7] (RO)
 *
 * Indicates that a conversion or hardware averaging is in progress. ADACT is
 * set when a conversion is initiated and cleared when a conversion is completed or
 * aborted.
 *
 * Values:
 * - 0 - Conversion not in progress.
 * - 1 - Conversion in progress.
 */
/*@{*/
/*! @brief Read current value of the ADC_SC2_ADACT field. */
#define ADC_RD_SC2_ADACT(base) ((ADC_SC2_REG(base) & ADC_SC2_ADACT_MASK) >> ADC_SC2_ADACT_SHIFT)
#define ADC_BRD_SC2_ADACT(base) (BME_UBFX32(&ADC_SC2_REG(base), ADC_SC2_ADACT_SHIFT, ADC_SC2_ADACT_WIDTH))
/*@}*/

/*******************************************************************************
 * ADC_SC3 - Status and Control Register 3
 ******************************************************************************/

/*!
 * @brief ADC_SC3 - Status and Control Register 3 (RW)
 *
 * Reset value: 0x00000000U
 *
 * The Status and Control Register 3 (SC3) controls the calibration, continuous
 * convert, and hardware averaging functions of the ADC module.
 */
/*!
 * @name Constants and macros for entire ADC_SC3 register
 */
/*@{*/
#define ADC_RD_SC3(base)         (ADC_SC3_REG(base))
#define ADC_WR_SC3(base, value)  (ADC_SC3_REG(base) = (value))
#define ADC_RMW_SC3(base, mask, value) (ADC_WR_SC3(base, (ADC_RD_SC3(base) & ~(mask)) | (value)))
#define ADC_SET_SC3(base, value) (BME_OR32(&ADC_SC3_REG(base), (uint32_t)(value)))
#define ADC_CLR_SC3(base, value) (BME_AND32(&ADC_SC3_REG(base), (uint32_t)(~(value))))
#define ADC_TOG_SC3(base, value) (BME_XOR32(&ADC_SC3_REG(base), (uint32_t)(value)))
/*@}*/

/*
 * Constants & macros for individual ADC_SC3 bitfields
 */

/*!
 * @name Register ADC_SC3, field AVGS[1:0] (RW)
 *
 * Determines how many ADC conversions will be averaged to create the ADC
 * average result.
 *
 * Values:
 * - 00 - 4 samples averaged.
 * - 01 - 8 samples averaged.
 * - 10 - 16 samples averaged.
 * - 11 - 32 samples averaged.
 */
/*@{*/
/*! @brief Read current value of the ADC_SC3_AVGS field. */
#define ADC_RD_SC3_AVGS(base) ((ADC_SC3_REG(base) & ADC_SC3_AVGS_MASK) >> ADC_SC3_AVGS_SHIFT)
#define ADC_BRD_SC3_AVGS(base) (BME_UBFX32(&ADC_SC3_REG(base), ADC_SC3_AVGS_SHIFT, ADC_SC3_AVGS_WIDTH))

/*! @brief Set the AVGS field to a new value. */
#define ADC_WR_SC3_AVGS(base, value) (ADC_RMW_SC3(base, (ADC_SC3_AVGS_MASK | ADC_SC3_CALF_MASK), ADC_SC3_AVGS(value)))
#define ADC_BWR_SC3_AVGS(base, value) (BME_BFI32(&ADC_SC3_REG(base), ((uint32_t)(value) << ADC_SC3_AVGS_SHIFT), ADC_SC3_AVGS_SHIFT, ADC_SC3_AVGS_WIDTH))
/*@}*/

/*!
 * @name Register ADC_SC3, field AVGE[2] (RW)
 *
 * Enables the hardware average function of the ADC.
 *
 * Values:
 * - 0 - Hardware average function disabled.
 * - 1 - Hardware average function enabled.
 */
/*@{*/
/*! @brief Read current value of the ADC_SC3_AVGE field. */
#define ADC_RD_SC3_AVGE(base) ((ADC_SC3_REG(base) & ADC_SC3_AVGE_MASK) >> ADC_SC3_AVGE_SHIFT)
#define ADC_BRD_SC3_AVGE(base) (BME_UBFX32(&ADC_SC3_REG(base), ADC_SC3_AVGE_SHIFT, ADC_SC3_AVGE_WIDTH))

/*! @brief Set the AVGE field to a new value. */
#define ADC_WR_SC3_AVGE(base, value) (ADC_RMW_SC3(base, (ADC_SC3_AVGE_MASK | ADC_SC3_CALF_MASK), ADC_SC3_AVGE(value)))
#define ADC_BWR_SC3_AVGE(base, value) (BME_BFI32(&ADC_SC3_REG(base), ((uint32_t)(value) << ADC_SC3_AVGE_SHIFT), ADC_SC3_AVGE_SHIFT, ADC_SC3_AVGE_WIDTH))
/*@}*/

/*!
 * @name Register ADC_SC3, field ADCO[3] (RW)
 *
 * Enables continuous conversions.
 *
 * Values:
 * - 0 - One conversion or one set of conversions if the hardware average
 *     function is enabled, that is, AVGE=1, after initiating a conversion.
 * - 1 - Continuous conversions or sets of conversions if the hardware average
 *     function is enabled, that is, AVGE=1, after initiating a conversion.
 */
/*@{*/
/*! @brief Read current value of the ADC_SC3_ADCO field. */
#define ADC_RD_SC3_ADCO(base) ((ADC_SC3_REG(base) & ADC_SC3_ADCO_MASK) >> ADC_SC3_ADCO_SHIFT)
#define ADC_BRD_SC3_ADCO(base) (BME_UBFX32(&ADC_SC3_REG(base), ADC_SC3_ADCO_SHIFT, ADC_SC3_ADCO_WIDTH))

/*! @brief Set the ADCO field to a new value. */
#define ADC_WR_SC3_ADCO(base, value) (ADC_RMW_SC3(base, (ADC_SC3_ADCO_MASK | ADC_SC3_CALF_MASK), ADC_SC3_ADCO(value)))
#define ADC_BWR_SC3_ADCO(base, value) (BME_BFI32(&ADC_SC3_REG(base), ((uint32_t)(value) << ADC_SC3_ADCO_SHIFT), ADC_SC3_ADCO_SHIFT, ADC_SC3_ADCO_WIDTH))
/*@}*/

/*!
 * @name Register ADC_SC3, field CALF[6] (W1C)
 *
 * Displays the result of the calibration sequence. The calibration sequence
 * will fail if SC2[ADTRG] = 1, any ADC register is written, or any stop mode is
 * entered before the calibration sequence completes. Writing 1 to CALF clears it.
 *
 * Values:
 * - 0 - Calibration completed normally.
 * - 1 - Calibration failed. ADC accuracy specifications are not guaranteed.
 */
/*@{*/
/*! @brief Read current value of the ADC_SC3_CALF field. */
#define ADC_RD_SC3_CALF(base) ((ADC_SC3_REG(base) & ADC_SC3_CALF_MASK) >> ADC_SC3_CALF_SHIFT)
#define ADC_BRD_SC3_CALF(base) (BME_UBFX32(&ADC_SC3_REG(base), ADC_SC3_CALF_SHIFT, ADC_SC3_CALF_WIDTH))

/*! @brief Set the CALF field to a new value. */
#define ADC_WR_SC3_CALF(base, value) (ADC_RMW_SC3(base, ADC_SC3_CALF_MASK, ADC_SC3_CALF(value)))
#define ADC_BWR_SC3_CALF(base, value) (BME_BFI32(&ADC_SC3_REG(base), ((uint32_t)(value) << ADC_SC3_CALF_SHIFT), ADC_SC3_CALF_SHIFT, ADC_SC3_CALF_WIDTH))
/*@}*/

/*!
 * @name Register ADC_SC3, field CAL[7] (RW)
 *
 * Begins the calibration sequence when set. This field stays set while the
 * calibration is in progress and is cleared when the calibration sequence is
 * completed. CALF must be checked to determine the result of the calibration sequence.
 * Once started, the calibration routine cannot be interrupted by writes to the
 * ADC registers or the results will be invalid and CALF will set. Setting CAL
 * will abort any current conversion.
 */
/*@{*/
/*! @brief Read current value of the ADC_SC3_CAL field. */
#define ADC_RD_SC3_CAL(base) ((ADC_SC3_REG(base) & ADC_SC3_CAL_MASK) >> ADC_SC3_CAL_SHIFT)
#define ADC_BRD_SC3_CAL(base) (BME_UBFX32(&ADC_SC3_REG(base), ADC_SC3_CAL_SHIFT, ADC_SC3_CAL_WIDTH))

/*! @brief Set the CAL field to a new value. */
#define ADC_WR_SC3_CAL(base, value) (ADC_RMW_SC3(base, (ADC_SC3_CAL_MASK | ADC_SC3_CALF_MASK), ADC_SC3_CAL(value)))
#define ADC_BWR_SC3_CAL(base, value) (BME_BFI32(&ADC_SC3_REG(base), ((uint32_t)(value) << ADC_SC3_CAL_SHIFT), ADC_SC3_CAL_SHIFT, ADC_SC3_CAL_WIDTH))
/*@}*/

/*******************************************************************************
 * ADC_OFS - ADC Offset Correction Register
 ******************************************************************************/

/*!
 * @brief ADC_OFS - ADC Offset Correction Register (RW)
 *
 * Reset value: 0x00000004U
 *
 * The ADC Offset Correction Register (OFS) contains the user-selected or
 * calibration-generated offset error correction value. This register is a 2's
 * complement, left-justified, 16-bit value . The value in OFS is subtracted from the
 * conversion and the result is transferred into the result registers, Rn. If the
 * result is greater than the maximum or less than the minimum result value, it is
 * forced to the appropriate limit for the current mode of operation.
 */
/*!
 * @name Constants and macros for entire ADC_OFS register
 */
/*@{*/
#define ADC_RD_OFS(base)         (ADC_OFS_REG(base))
#define ADC_WR_OFS(base, value)  (ADC_OFS_REG(base) = (value))
#define ADC_RMW_OFS(base, mask, value) (ADC_WR_OFS(base, (ADC_RD_OFS(base) & ~(mask)) | (value)))
#define ADC_SET_OFS(base, value) (BME_OR32(&ADC_OFS_REG(base), (uint32_t)(value)))
#define ADC_CLR_OFS(base, value) (BME_AND32(&ADC_OFS_REG(base), (uint32_t)(~(value))))
#define ADC_TOG_OFS(base, value) (BME_XOR32(&ADC_OFS_REG(base), (uint32_t)(value)))
/*@}*/

/*
 * Constants & macros for individual ADC_OFS bitfields
 */

/*!
 * @name Register ADC_OFS, field OFS[15:0] (RW)
 */
/*@{*/
/*! @brief Read current value of the ADC_OFS_OFS field. */
#define ADC_RD_OFS_OFS(base) ((ADC_OFS_REG(base) & ADC_OFS_OFS_MASK) >> ADC_OFS_OFS_SHIFT)
#define ADC_BRD_OFS_OFS(base) (BME_UBFX32(&ADC_OFS_REG(base), ADC_OFS_OFS_SHIFT, ADC_OFS_OFS_WIDTH))

/*! @brief Set the OFS field to a new value. */
#define ADC_WR_OFS_OFS(base, value) (ADC_RMW_OFS(base, ADC_OFS_OFS_MASK, ADC_OFS_OFS(value)))
#define ADC_BWR_OFS_OFS(base, value) (BME_BFI32(&ADC_OFS_REG(base), ((uint32_t)(value) << ADC_OFS_OFS_SHIFT), ADC_OFS_OFS_SHIFT, ADC_OFS_OFS_WIDTH))
/*@}*/

/*******************************************************************************
 * ADC_PG - ADC Plus-Side Gain Register
 ******************************************************************************/

/*!
 * @brief ADC_PG - ADC Plus-Side Gain Register (RW)
 *
 * Reset value: 0x00008200U
 *
 * The Plus-Side Gain Register (PG) contains the gain error correction for the
 * plus-side input in differential mode or the overall conversion in single-ended
 * mode. PG, a 16-bit real number in binary format, is the gain adjustment
 * factor, with the radix point fixed between PG[15] and PG[14]. This register must be
 * written by the user with the value described in the calibration procedure.
 * Otherwise, the gain error specifications may not be met.
 */
/*!
 * @name Constants and macros for entire ADC_PG register
 */
/*@{*/
#define ADC_RD_PG(base)          (ADC_PG_REG(base))
#define ADC_WR_PG(base, value)   (ADC_PG_REG(base) = (value))
#define ADC_RMW_PG(base, mask, value) (ADC_WR_PG(base, (ADC_RD_PG(base) & ~(mask)) | (value)))
#define ADC_SET_PG(base, value)  (BME_OR32(&ADC_PG_REG(base), (uint32_t)(value)))
#define ADC_CLR_PG(base, value)  (BME_AND32(&ADC_PG_REG(base), (uint32_t)(~(value))))
#define ADC_TOG_PG(base, value)  (BME_XOR32(&ADC_PG_REG(base), (uint32_t)(value)))
/*@}*/

/*
 * Constants & macros for individual ADC_PG bitfields
 */

/*!
 * @name Register ADC_PG, field PG[15:0] (RW)
 */
/*@{*/
/*! @brief Read current value of the ADC_PG_PG field. */
#define ADC_RD_PG_PG(base)   ((ADC_PG_REG(base) & ADC_PG_PG_MASK) >> ADC_PG_PG_SHIFT)
#define ADC_BRD_PG_PG(base)  (BME_UBFX32(&ADC_PG_REG(base), ADC_PG_PG_SHIFT, ADC_PG_PG_WIDTH))

/*! @brief Set the PG field to a new value. */
#define ADC_WR_PG_PG(base, value) (ADC_RMW_PG(base, ADC_PG_PG_MASK, ADC_PG_PG(value)))
#define ADC_BWR_PG_PG(base, value) (BME_BFI32(&ADC_PG_REG(base), ((uint32_t)(value) << ADC_PG_PG_SHIFT), ADC_PG_PG_SHIFT, ADC_PG_PG_WIDTH))
/*@}*/

/*******************************************************************************
 * ADC_MG - ADC Minus-Side Gain Register
 ******************************************************************************/

/*!
 * @brief ADC_MG - ADC Minus-Side Gain Register (RW)
 *
 * Reset value: 0x00008200U
 *
 * The Minus-Side Gain Register (MG) contains the gain error correction for the
 * minus-side input in differential mode. This register is ignored in
 * single-ended mode. MG, a 16-bit real number in binary format, is the gain adjustment
 * factor, with the radix point fixed between MG[15] and MG[14]. This register must
 * be written by the user with the value described in the calibration procedure.
 * Otherwise, the gain error specifications may not be met.
 */
/*!
 * @name Constants and macros for entire ADC_MG register
 */
/*@{*/
#define ADC_RD_MG(base)          (ADC_MG_REG(base))
#define ADC_WR_MG(base, value)   (ADC_MG_REG(base) = (value))
#define ADC_RMW_MG(base, mask, value) (ADC_WR_MG(base, (ADC_RD_MG(base) & ~(mask)) | (value)))
#define ADC_SET_MG(base, value)  (BME_OR32(&ADC_MG_REG(base), (uint32_t)(value)))
#define ADC_CLR_MG(base, value)  (BME_AND32(&ADC_MG_REG(base), (uint32_t)(~(value))))
#define ADC_TOG_MG(base, value)  (BME_XOR32(&ADC_MG_REG(base), (uint32_t)(value)))
/*@}*/

/*
 * Constants & macros for individual ADC_MG bitfields
 */

/*!
 * @name Register ADC_MG, field MG[15:0] (RW)
 */
/*@{*/
/*! @brief Read current value of the ADC_MG_MG field. */
#define ADC_RD_MG_MG(base)   ((ADC_MG_REG(base) & ADC_MG_MG_MASK) >> ADC_MG_MG_SHIFT)
#define ADC_BRD_MG_MG(base)  (BME_UBFX32(&ADC_MG_REG(base), ADC_MG_MG_SHIFT, ADC_MG_MG_WIDTH))

/*! @brief Set the MG field to a new value. */
#define ADC_WR_MG_MG(base, value) (ADC_RMW_MG(base, ADC_MG_MG_MASK, ADC_MG_MG(value)))
#define ADC_BWR_MG_MG(base, value) (BME_BFI32(&ADC_MG_REG(base), ((uint32_t)(value) << ADC_MG_MG_SHIFT), ADC_MG_MG_SHIFT, ADC_MG_MG_WIDTH))
/*@}*/

/*******************************************************************************
 * ADC_CLPD - ADC Plus-Side General Calibration Value Register
 ******************************************************************************/

/*!
 * @brief ADC_CLPD - ADC Plus-Side General Calibration Value Register (RW)
 *
 * Reset value: 0x0000000AU
 *
 * The Plus-Side General Calibration Value Registers (CLPx) contain calibration
 * information that is generated by the calibration function. These registers
 * contain seven calibration values of varying widths: CLP0[5:0], CLP1[6:0],
 * CLP2[7:0], CLP3[8:0], CLP4[9:0], CLPS[5:0], and CLPD[5:0]. CLPx are automatically set
 * when the self-calibration sequence is done, that is, CAL is cleared. If these
 * registers are written by the user after calibration, the linearity error
 * specifications may not be met.
 */
/*!
 * @name Constants and macros for entire ADC_CLPD register
 */
/*@{*/
#define ADC_RD_CLPD(base)        (ADC_CLPD_REG(base))
#define ADC_WR_CLPD(base, value) (ADC_CLPD_REG(base) = (value))
#define ADC_RMW_CLPD(base, mask, value) (ADC_WR_CLPD(base, (ADC_RD_CLPD(base) & ~(mask)) | (value)))
#define ADC_SET_CLPD(base, value) (BME_OR32(&ADC_CLPD_REG(base), (uint32_t)(value)))
#define ADC_CLR_CLPD(base, value) (BME_AND32(&ADC_CLPD_REG(base), (uint32_t)(~(value))))
#define ADC_TOG_CLPD(base, value) (BME_XOR32(&ADC_CLPD_REG(base), (uint32_t)(value)))
/*@}*/

/*
 * Constants & macros for individual ADC_CLPD bitfields
 */

/*!
 * @name Register ADC_CLPD, field CLPD[5:0] (RW)
 *
 * Calibration Value
 */
/*@{*/
/*! @brief Read current value of the ADC_CLPD_CLPD field. */
#define ADC_RD_CLPD_CLPD(base) ((ADC_CLPD_REG(base) & ADC_CLPD_CLPD_MASK) >> ADC_CLPD_CLPD_SHIFT)
#define ADC_BRD_CLPD_CLPD(base) (BME_UBFX32(&ADC_CLPD_REG(base), ADC_CLPD_CLPD_SHIFT, ADC_CLPD_CLPD_WIDTH))

/*! @brief Set the CLPD field to a new value. */
#define ADC_WR_CLPD_CLPD(base, value) (ADC_RMW_CLPD(base, ADC_CLPD_CLPD_MASK, ADC_CLPD_CLPD(value)))
#define ADC_BWR_CLPD_CLPD(base, value) (BME_BFI32(&ADC_CLPD_REG(base), ((uint32_t)(value) << ADC_CLPD_CLPD_SHIFT), ADC_CLPD_CLPD_SHIFT, ADC_CLPD_CLPD_WIDTH))
/*@}*/

/*******************************************************************************
 * ADC_CLPS - ADC Plus-Side General Calibration Value Register
 ******************************************************************************/

/*!
 * @brief ADC_CLPS - ADC Plus-Side General Calibration Value Register (RW)
 *
 * Reset value: 0x00000020U
 *
 * For more information, see CLPD register description.
 */
/*!
 * @name Constants and macros for entire ADC_CLPS register
 */
/*@{*/
#define ADC_RD_CLPS(base)        (ADC_CLPS_REG(base))
#define ADC_WR_CLPS(base, value) (ADC_CLPS_REG(base) = (value))
#define ADC_RMW_CLPS(base, mask, value) (ADC_WR_CLPS(base, (ADC_RD_CLPS(base) & ~(mask)) | (value)))
#define ADC_SET_CLPS(base, value) (BME_OR32(&ADC_CLPS_REG(base), (uint32_t)(value)))
#define ADC_CLR_CLPS(base, value) (BME_AND32(&ADC_CLPS_REG(base), (uint32_t)(~(value))))
#define ADC_TOG_CLPS(base, value) (BME_XOR32(&ADC_CLPS_REG(base), (uint32_t)(value)))
/*@}*/

/*
 * Constants & macros for individual ADC_CLPS bitfields
 */

/*!
 * @name Register ADC_CLPS, field CLPS[5:0] (RW)
 *
 * Calibration Value
 */
/*@{*/
/*! @brief Read current value of the ADC_CLPS_CLPS field. */
#define ADC_RD_CLPS_CLPS(base) ((ADC_CLPS_REG(base) & ADC_CLPS_CLPS_MASK) >> ADC_CLPS_CLPS_SHIFT)
#define ADC_BRD_CLPS_CLPS(base) (BME_UBFX32(&ADC_CLPS_REG(base), ADC_CLPS_CLPS_SHIFT, ADC_CLPS_CLPS_WIDTH))

/*! @brief Set the CLPS field to a new value. */
#define ADC_WR_CLPS_CLPS(base, value) (ADC_RMW_CLPS(base, ADC_CLPS_CLPS_MASK, ADC_CLPS_CLPS(value)))
#define ADC_BWR_CLPS_CLPS(base, value) (BME_BFI32(&ADC_CLPS_REG(base), ((uint32_t)(value) << ADC_CLPS_CLPS_SHIFT), ADC_CLPS_CLPS_SHIFT, ADC_CLPS_CLPS_WIDTH))
/*@}*/

/*******************************************************************************
 * ADC_CLP4 - ADC Plus-Side General Calibration Value Register
 ******************************************************************************/

/*!
 * @brief ADC_CLP4 - ADC Plus-Side General Calibration Value Register (RW)
 *
 * Reset value: 0x00000200U
 *
 * For more information, see CLPD register description.
 */
/*!
 * @name Constants and macros for entire ADC_CLP4 register
 */
/*@{*/
#define ADC_RD_CLP4(base)        (ADC_CLP4_REG(base))
#define ADC_WR_CLP4(base, value) (ADC_CLP4_REG(base) = (value))
#define ADC_RMW_CLP4(base, mask, value) (ADC_WR_CLP4(base, (ADC_RD_CLP4(base) & ~(mask)) | (value)))
#define ADC_SET_CLP4(base, value) (BME_OR32(&ADC_CLP4_REG(base), (uint32_t)(value)))
#define ADC_CLR_CLP4(base, value) (BME_AND32(&ADC_CLP4_REG(base), (uint32_t)(~(value))))
#define ADC_TOG_CLP4(base, value) (BME_XOR32(&ADC_CLP4_REG(base), (uint32_t)(value)))
/*@}*/

/*
 * Constants & macros for individual ADC_CLP4 bitfields
 */

/*!
 * @name Register ADC_CLP4, field CLP4[9:0] (RW)
 *
 * Calibration Value
 */
/*@{*/
/*! @brief Read current value of the ADC_CLP4_CLP4 field. */
#define ADC_RD_CLP4_CLP4(base) ((ADC_CLP4_REG(base) & ADC_CLP4_CLP4_MASK) >> ADC_CLP4_CLP4_SHIFT)
#define ADC_BRD_CLP4_CLP4(base) (BME_UBFX32(&ADC_CLP4_REG(base), ADC_CLP4_CLP4_SHIFT, ADC_CLP4_CLP4_WIDTH))

/*! @brief Set the CLP4 field to a new value. */
#define ADC_WR_CLP4_CLP4(base, value) (ADC_RMW_CLP4(base, ADC_CLP4_CLP4_MASK, ADC_CLP4_CLP4(value)))
#define ADC_BWR_CLP4_CLP4(base, value) (BME_BFI32(&ADC_CLP4_REG(base), ((uint32_t)(value) << ADC_CLP4_CLP4_SHIFT), ADC_CLP4_CLP4_SHIFT, ADC_CLP4_CLP4_WIDTH))
/*@}*/

/*******************************************************************************
 * ADC_CLP3 - ADC Plus-Side General Calibration Value Register
 ******************************************************************************/

/*!
 * @brief ADC_CLP3 - ADC Plus-Side General Calibration Value Register (RW)
 *
 * Reset value: 0x00000100U
 *
 * For more information, see CLPD register description.
 */
/*!
 * @name Constants and macros for entire ADC_CLP3 register
 */
/*@{*/
#define ADC_RD_CLP3(base)        (ADC_CLP3_REG(base))
#define ADC_WR_CLP3(base, value) (ADC_CLP3_REG(base) = (value))
#define ADC_RMW_CLP3(base, mask, value) (ADC_WR_CLP3(base, (ADC_RD_CLP3(base) & ~(mask)) | (value)))
#define ADC_SET_CLP3(base, value) (BME_OR32(&ADC_CLP3_REG(base), (uint32_t)(value)))
#define ADC_CLR_CLP3(base, value) (BME_AND32(&ADC_CLP3_REG(base), (uint32_t)(~(value))))
#define ADC_TOG_CLP3(base, value) (BME_XOR32(&ADC_CLP3_REG(base), (uint32_t)(value)))
/*@}*/

/*
 * Constants & macros for individual ADC_CLP3 bitfields
 */

/*!
 * @name Register ADC_CLP3, field CLP3[8:0] (RW)
 *
 * Calibration Value
 */
/*@{*/
/*! @brief Read current value of the ADC_CLP3_CLP3 field. */
#define ADC_RD_CLP3_CLP3(base) ((ADC_CLP3_REG(base) & ADC_CLP3_CLP3_MASK) >> ADC_CLP3_CLP3_SHIFT)
#define ADC_BRD_CLP3_CLP3(base) (BME_UBFX32(&ADC_CLP3_REG(base), ADC_CLP3_CLP3_SHIFT, ADC_CLP3_CLP3_WIDTH))

/*! @brief Set the CLP3 field to a new value. */
#define ADC_WR_CLP3_CLP3(base, value) (ADC_RMW_CLP3(base, ADC_CLP3_CLP3_MASK, ADC_CLP3_CLP3(value)))
#define ADC_BWR_CLP3_CLP3(base, value) (BME_BFI32(&ADC_CLP3_REG(base), ((uint32_t)(value) << ADC_CLP3_CLP3_SHIFT), ADC_CLP3_CLP3_SHIFT, ADC_CLP3_CLP3_WIDTH))
/*@}*/

/*******************************************************************************
 * ADC_CLP2 - ADC Plus-Side General Calibration Value Register
 ******************************************************************************/

/*!
 * @brief ADC_CLP2 - ADC Plus-Side General Calibration Value Register (RW)
 *
 * Reset value: 0x00000080U
 *
 * For more information, see CLPD register description.
 */
/*!
 * @name Constants and macros for entire ADC_CLP2 register
 */
/*@{*/
#define ADC_RD_CLP2(base)        (ADC_CLP2_REG(base))
#define ADC_WR_CLP2(base, value) (ADC_CLP2_REG(base) = (value))
#define ADC_RMW_CLP2(base, mask, value) (ADC_WR_CLP2(base, (ADC_RD_CLP2(base) & ~(mask)) | (value)))
#define ADC_SET_CLP2(base, value) (BME_OR32(&ADC_CLP2_REG(base), (uint32_t)(value)))
#define ADC_CLR_CLP2(base, value) (BME_AND32(&ADC_CLP2_REG(base), (uint32_t)(~(value))))
#define ADC_TOG_CLP2(base, value) (BME_XOR32(&ADC_CLP2_REG(base), (uint32_t)(value)))
/*@}*/

/*
 * Constants & macros for individual ADC_CLP2 bitfields
 */

/*!
 * @name Register ADC_CLP2, field CLP2[7:0] (RW)
 *
 * Calibration Value
 */
/*@{*/
/*! @brief Read current value of the ADC_CLP2_CLP2 field. */
#define ADC_RD_CLP2_CLP2(base) ((ADC_CLP2_REG(base) & ADC_CLP2_CLP2_MASK) >> ADC_CLP2_CLP2_SHIFT)
#define ADC_BRD_CLP2_CLP2(base) (BME_UBFX32(&ADC_CLP2_REG(base), ADC_CLP2_CLP2_SHIFT, ADC_CLP2_CLP2_WIDTH))

/*! @brief Set the CLP2 field to a new value. */
#define ADC_WR_CLP2_CLP2(base, value) (ADC_RMW_CLP2(base, ADC_CLP2_CLP2_MASK, ADC_CLP2_CLP2(value)))
#define ADC_BWR_CLP2_CLP2(base, value) (BME_BFI32(&ADC_CLP2_REG(base), ((uint32_t)(value) << ADC_CLP2_CLP2_SHIFT), ADC_CLP2_CLP2_SHIFT, ADC_CLP2_CLP2_WIDTH))
/*@}*/

/*******************************************************************************
 * ADC_CLP1 - ADC Plus-Side General Calibration Value Register
 ******************************************************************************/

/*!
 * @brief ADC_CLP1 - ADC Plus-Side General Calibration Value Register (RW)
 *
 * Reset value: 0x00000040U
 *
 * For more information, see CLPD register description.
 */
/*!
 * @name Constants and macros for entire ADC_CLP1 register
 */
/*@{*/
#define ADC_RD_CLP1(base)        (ADC_CLP1_REG(base))
#define ADC_WR_CLP1(base, value) (ADC_CLP1_REG(base) = (value))
#define ADC_RMW_CLP1(base, mask, value) (ADC_WR_CLP1(base, (ADC_RD_CLP1(base) & ~(mask)) | (value)))
#define ADC_SET_CLP1(base, value) (BME_OR32(&ADC_CLP1_REG(base), (uint32_t)(value)))
#define ADC_CLR_CLP1(base, value) (BME_AND32(&ADC_CLP1_REG(base), (uint32_t)(~(value))))
#define ADC_TOG_CLP1(base, value) (BME_XOR32(&ADC_CLP1_REG(base), (uint32_t)(value)))
/*@}*/

/*
 * Constants & macros for individual ADC_CLP1 bitfields
 */

/*!
 * @name Register ADC_CLP1, field CLP1[6:0] (RW)
 *
 * Calibration Value
 */
/*@{*/
/*! @brief Read current value of the ADC_CLP1_CLP1 field. */
#define ADC_RD_CLP1_CLP1(base) ((ADC_CLP1_REG(base) & ADC_CLP1_CLP1_MASK) >> ADC_CLP1_CLP1_SHIFT)
#define ADC_BRD_CLP1_CLP1(base) (BME_UBFX32(&ADC_CLP1_REG(base), ADC_CLP1_CLP1_SHIFT, ADC_CLP1_CLP1_WIDTH))

/*! @brief Set the CLP1 field to a new value. */
#define ADC_WR_CLP1_CLP1(base, value) (ADC_RMW_CLP1(base, ADC_CLP1_CLP1_MASK, ADC_CLP1_CLP1(value)))
#define ADC_BWR_CLP1_CLP1(base, value) (BME_BFI32(&ADC_CLP1_REG(base), ((uint32_t)(value) << ADC_CLP1_CLP1_SHIFT), ADC_CLP1_CLP1_SHIFT, ADC_CLP1_CLP1_WIDTH))
/*@}*/

/*******************************************************************************
 * ADC_CLP0 - ADC Plus-Side General Calibration Value Register
 ******************************************************************************/

/*!
 * @brief ADC_CLP0 - ADC Plus-Side General Calibration Value Register (RW)
 *
 * Reset value: 0x00000020U
 *
 * For more information, see CLPD register description.
 */
/*!
 * @name Constants and macros for entire ADC_CLP0 register
 */
/*@{*/
#define ADC_RD_CLP0(base)        (ADC_CLP0_REG(base))
#define ADC_WR_CLP0(base, value) (ADC_CLP0_REG(base) = (value))
#define ADC_RMW_CLP0(base, mask, value) (ADC_WR_CLP0(base, (ADC_RD_CLP0(base) & ~(mask)) | (value)))
#define ADC_SET_CLP0(base, value) (BME_OR32(&ADC_CLP0_REG(base), (uint32_t)(value)))
#define ADC_CLR_CLP0(base, value) (BME_AND32(&ADC_CLP0_REG(base), (uint32_t)(~(value))))
#define ADC_TOG_CLP0(base, value) (BME_XOR32(&ADC_CLP0_REG(base), (uint32_t)(value)))
/*@}*/

/*
 * Constants & macros for individual ADC_CLP0 bitfields
 */

/*!
 * @name Register ADC_CLP0, field CLP0[5:0] (RW)
 *
 * Calibration Value
 */
/*@{*/
/*! @brief Read current value of the ADC_CLP0_CLP0 field. */
#define ADC_RD_CLP0_CLP0(base) ((ADC_CLP0_REG(base) & ADC_CLP0_CLP0_MASK) >> ADC_CLP0_CLP0_SHIFT)
#define ADC_BRD_CLP0_CLP0(base) (BME_UBFX32(&ADC_CLP0_REG(base), ADC_CLP0_CLP0_SHIFT, ADC_CLP0_CLP0_WIDTH))

/*! @brief Set the CLP0 field to a new value. */
#define ADC_WR_CLP0_CLP0(base, value) (ADC_RMW_CLP0(base, ADC_CLP0_CLP0_MASK, ADC_CLP0_CLP0(value)))
#define ADC_BWR_CLP0_CLP0(base, value) (BME_BFI32(&ADC_CLP0_REG(base), ((uint32_t)(value) << ADC_CLP0_CLP0_SHIFT), ADC_CLP0_CLP0_SHIFT, ADC_CLP0_CLP0_WIDTH))
/*@}*/

/*******************************************************************************
 * ADC_CLMD - ADC Minus-Side General Calibration Value Register
 ******************************************************************************/

/*!
 * @brief ADC_CLMD - ADC Minus-Side General Calibration Value Register (RW)
 *
 * Reset value: 0x0000000AU
 *
 * The Minus-Side General Calibration Value (CLMx) registers contain calibration
 * information that is generated by the calibration function. These registers
 * contain seven calibration values of varying widths: CLM0[5:0], CLM1[6:0],
 * CLM2[7:0], CLM3[8:0], CLM4[9:0], CLMS[5:0], and CLMD[5:0]. CLMx are automatically
 * set when the self-calibration sequence is done, that is, CAL is cleared. If
 * these registers are written by the user after calibration, the linearity error
 * specifications may not be met.
 */
/*!
 * @name Constants and macros for entire ADC_CLMD register
 */
/*@{*/
#define ADC_RD_CLMD(base)        (ADC_CLMD_REG(base))
#define ADC_WR_CLMD(base, value) (ADC_CLMD_REG(base) = (value))
#define ADC_RMW_CLMD(base, mask, value) (ADC_WR_CLMD(base, (ADC_RD_CLMD(base) & ~(mask)) | (value)))
#define ADC_SET_CLMD(base, value) (BME_OR32(&ADC_CLMD_REG(base), (uint32_t)(value)))
#define ADC_CLR_CLMD(base, value) (BME_AND32(&ADC_CLMD_REG(base), (uint32_t)(~(value))))
#define ADC_TOG_CLMD(base, value) (BME_XOR32(&ADC_CLMD_REG(base), (uint32_t)(value)))
/*@}*/

/*
 * Constants & macros for individual ADC_CLMD bitfields
 */

/*!
 * @name Register ADC_CLMD, field CLMD[5:0] (RW)
 *
 * Calibration Value
 */
/*@{*/
/*! @brief Read current value of the ADC_CLMD_CLMD field. */
#define ADC_RD_CLMD_CLMD(base) ((ADC_CLMD_REG(base) & ADC_CLMD_CLMD_MASK) >> ADC_CLMD_CLMD_SHIFT)
#define ADC_BRD_CLMD_CLMD(base) (BME_UBFX32(&ADC_CLMD_REG(base), ADC_CLMD_CLMD_SHIFT, ADC_CLMD_CLMD_WIDTH))

/*! @brief Set the CLMD field to a new value. */
#define ADC_WR_CLMD_CLMD(base, value) (ADC_RMW_CLMD(base, ADC_CLMD_CLMD_MASK, ADC_CLMD_CLMD(value)))
#define ADC_BWR_CLMD_CLMD(base, value) (BME_BFI32(&ADC_CLMD_REG(base), ((uint32_t)(value) << ADC_CLMD_CLMD_SHIFT), ADC_CLMD_CLMD_SHIFT, ADC_CLMD_CLMD_WIDTH))
/*@}*/

/*******************************************************************************
 * ADC_CLMS - ADC Minus-Side General Calibration Value Register
 ******************************************************************************/

/*!
 * @brief ADC_CLMS - ADC Minus-Side General Calibration Value Register (RW)
 *
 * Reset value: 0x00000020U
 *
 * For more information, see CLMD register description.
 */
/*!
 * @name Constants and macros for entire ADC_CLMS register
 */
/*@{*/
#define ADC_RD_CLMS(base)        (ADC_CLMS_REG(base))
#define ADC_WR_CLMS(base, value) (ADC_CLMS_REG(base) = (value))
#define ADC_RMW_CLMS(base, mask, value) (ADC_WR_CLMS(base, (ADC_RD_CLMS(base) & ~(mask)) | (value)))
#define ADC_SET_CLMS(base, value) (BME_OR32(&ADC_CLMS_REG(base), (uint32_t)(value)))
#define ADC_CLR_CLMS(base, value) (BME_AND32(&ADC_CLMS_REG(base), (uint32_t)(~(value))))
#define ADC_TOG_CLMS(base, value) (BME_XOR32(&ADC_CLMS_REG(base), (uint32_t)(value)))
/*@}*/

/*
 * Constants & macros for individual ADC_CLMS bitfields
 */

/*!
 * @name Register ADC_CLMS, field CLMS[5:0] (RW)
 *
 * Calibration Value
 */
/*@{*/
/*! @brief Read current value of the ADC_CLMS_CLMS field. */
#define ADC_RD_CLMS_CLMS(base) ((ADC_CLMS_REG(base) & ADC_CLMS_CLMS_MASK) >> ADC_CLMS_CLMS_SHIFT)
#define ADC_BRD_CLMS_CLMS(base) (BME_UBFX32(&ADC_CLMS_REG(base), ADC_CLMS_CLMS_SHIFT, ADC_CLMS_CLMS_WIDTH))

/*! @brief Set the CLMS field to a new value. */
#define ADC_WR_CLMS_CLMS(base, value) (ADC_RMW_CLMS(base, ADC_CLMS_CLMS_MASK, ADC_CLMS_CLMS(value)))
#define ADC_BWR_CLMS_CLMS(base, value) (BME_BFI32(&ADC_CLMS_REG(base), ((uint32_t)(value) << ADC_CLMS_CLMS_SHIFT), ADC_CLMS_CLMS_SHIFT, ADC_CLMS_CLMS_WIDTH))
/*@}*/

/*******************************************************************************
 * ADC_CLM4 - ADC Minus-Side General Calibration Value Register
 ******************************************************************************/

/*!
 * @brief ADC_CLM4 - ADC Minus-Side General Calibration Value Register (RW)
 *
 * Reset value: 0x00000200U
 *
 * For more information, see CLMD register description.
 */
/*!
 * @name Constants and macros for entire ADC_CLM4 register
 */
/*@{*/
#define ADC_RD_CLM4(base)        (ADC_CLM4_REG(base))
#define ADC_WR_CLM4(base, value) (ADC_CLM4_REG(base) = (value))
#define ADC_RMW_CLM4(base, mask, value) (ADC_WR_CLM4(base, (ADC_RD_CLM4(base) & ~(mask)) | (value)))
#define ADC_SET_CLM4(base, value) (BME_OR32(&ADC_CLM4_REG(base), (uint32_t)(value)))
#define ADC_CLR_CLM4(base, value) (BME_AND32(&ADC_CLM4_REG(base), (uint32_t)(~(value))))
#define ADC_TOG_CLM4(base, value) (BME_XOR32(&ADC_CLM4_REG(base), (uint32_t)(value)))
/*@}*/

/*
 * Constants & macros for individual ADC_CLM4 bitfields
 */

/*!
 * @name Register ADC_CLM4, field CLM4[9:0] (RW)
 *
 * Calibration Value
 */
/*@{*/
/*! @brief Read current value of the ADC_CLM4_CLM4 field. */
#define ADC_RD_CLM4_CLM4(base) ((ADC_CLM4_REG(base) & ADC_CLM4_CLM4_MASK) >> ADC_CLM4_CLM4_SHIFT)
#define ADC_BRD_CLM4_CLM4(base) (BME_UBFX32(&ADC_CLM4_REG(base), ADC_CLM4_CLM4_SHIFT, ADC_CLM4_CLM4_WIDTH))

/*! @brief Set the CLM4 field to a new value. */
#define ADC_WR_CLM4_CLM4(base, value) (ADC_RMW_CLM4(base, ADC_CLM4_CLM4_MASK, ADC_CLM4_CLM4(value)))
#define ADC_BWR_CLM4_CLM4(base, value) (BME_BFI32(&ADC_CLM4_REG(base), ((uint32_t)(value) << ADC_CLM4_CLM4_SHIFT), ADC_CLM4_CLM4_SHIFT, ADC_CLM4_CLM4_WIDTH))
/*@}*/

/*******************************************************************************
 * ADC_CLM3 - ADC Minus-Side General Calibration Value Register
 ******************************************************************************/

/*!
 * @brief ADC_CLM3 - ADC Minus-Side General Calibration Value Register (RW)
 *
 * Reset value: 0x00000100U
 *
 * For more information, see CLMD register description.
 */
/*!
 * @name Constants and macros for entire ADC_CLM3 register
 */
/*@{*/
#define ADC_RD_CLM3(base)        (ADC_CLM3_REG(base))
#define ADC_WR_CLM3(base, value) (ADC_CLM3_REG(base) = (value))
#define ADC_RMW_CLM3(base, mask, value) (ADC_WR_CLM3(base, (ADC_RD_CLM3(base) & ~(mask)) | (value)))
#define ADC_SET_CLM3(base, value) (BME_OR32(&ADC_CLM3_REG(base), (uint32_t)(value)))
#define ADC_CLR_CLM3(base, value) (BME_AND32(&ADC_CLM3_REG(base), (uint32_t)(~(value))))
#define ADC_TOG_CLM3(base, value) (BME_XOR32(&ADC_CLM3_REG(base), (uint32_t)(value)))
/*@}*/

/*
 * Constants & macros for individual ADC_CLM3 bitfields
 */

/*!
 * @name Register ADC_CLM3, field CLM3[8:0] (RW)
 *
 * Calibration Value
 */
/*@{*/
/*! @brief Read current value of the ADC_CLM3_CLM3 field. */
#define ADC_RD_CLM3_CLM3(base) ((ADC_CLM3_REG(base) & ADC_CLM3_CLM3_MASK) >> ADC_CLM3_CLM3_SHIFT)
#define ADC_BRD_CLM3_CLM3(base) (BME_UBFX32(&ADC_CLM3_REG(base), ADC_CLM3_CLM3_SHIFT, ADC_CLM3_CLM3_WIDTH))

/*! @brief Set the CLM3 field to a new value. */
#define ADC_WR_CLM3_CLM3(base, value) (ADC_RMW_CLM3(base, ADC_CLM3_CLM3_MASK, ADC_CLM3_CLM3(value)))
#define ADC_BWR_CLM3_CLM3(base, value) (BME_BFI32(&ADC_CLM3_REG(base), ((uint32_t)(value) << ADC_CLM3_CLM3_SHIFT), ADC_CLM3_CLM3_SHIFT, ADC_CLM3_CLM3_WIDTH))
/*@}*/

/*******************************************************************************
 * ADC_CLM2 - ADC Minus-Side General Calibration Value Register
 ******************************************************************************/

/*!
 * @brief ADC_CLM2 - ADC Minus-Side General Calibration Value Register (RW)
 *
 * Reset value: 0x00000080U
 *
 * For more information, see CLMD register description.
 */
/*!
 * @name Constants and macros for entire ADC_CLM2 register
 */
/*@{*/
#define ADC_RD_CLM2(base)        (ADC_CLM2_REG(base))
#define ADC_WR_CLM2(base, value) (ADC_CLM2_REG(base) = (value))
#define ADC_RMW_CLM2(base, mask, value) (ADC_WR_CLM2(base, (ADC_RD_CLM2(base) & ~(mask)) | (value)))
#define ADC_SET_CLM2(base, value) (BME_OR32(&ADC_CLM2_REG(base), (uint32_t)(value)))
#define ADC_CLR_CLM2(base, value) (BME_AND32(&ADC_CLM2_REG(base), (uint32_t)(~(value))))
#define ADC_TOG_CLM2(base, value) (BME_XOR32(&ADC_CLM2_REG(base), (uint32_t)(value)))
/*@}*/

/*
 * Constants & macros for individual ADC_CLM2 bitfields
 */

/*!
 * @name Register ADC_CLM2, field CLM2[7:0] (RW)
 *
 * Calibration Value
 */
/*@{*/
/*! @brief Read current value of the ADC_CLM2_CLM2 field. */
#define ADC_RD_CLM2_CLM2(base) ((ADC_CLM2_REG(base) & ADC_CLM2_CLM2_MASK) >> ADC_CLM2_CLM2_SHIFT)
#define ADC_BRD_CLM2_CLM2(base) (BME_UBFX32(&ADC_CLM2_REG(base), ADC_CLM2_CLM2_SHIFT, ADC_CLM2_CLM2_WIDTH))

/*! @brief Set the CLM2 field to a new value. */
#define ADC_WR_CLM2_CLM2(base, value) (ADC_RMW_CLM2(base, ADC_CLM2_CLM2_MASK, ADC_CLM2_CLM2(value)))
#define ADC_BWR_CLM2_CLM2(base, value) (BME_BFI32(&ADC_CLM2_REG(base), ((uint32_t)(value) << ADC_CLM2_CLM2_SHIFT), ADC_CLM2_CLM2_SHIFT, ADC_CLM2_CLM2_WIDTH))
/*@}*/

/*******************************************************************************
 * ADC_CLM1 - ADC Minus-Side General Calibration Value Register
 ******************************************************************************/

/*!
 * @brief ADC_CLM1 - ADC Minus-Side General Calibration Value Register (RW)
 *
 * Reset value: 0x00000040U
 *
 * For more information, see CLMD register description.
 */
/*!
 * @name Constants and macros for entire ADC_CLM1 register
 */
/*@{*/
#define ADC_RD_CLM1(base)        (ADC_CLM1_REG(base))
#define ADC_WR_CLM1(base, value) (ADC_CLM1_REG(base) = (value))
#define ADC_RMW_CLM1(base, mask, value) (ADC_WR_CLM1(base, (ADC_RD_CLM1(base) & ~(mask)) | (value)))
#define ADC_SET_CLM1(base, value) (BME_OR32(&ADC_CLM1_REG(base), (uint32_t)(value)))
#define ADC_CLR_CLM1(base, value) (BME_AND32(&ADC_CLM1_REG(base), (uint32_t)(~(value))))
#define ADC_TOG_CLM1(base, value) (BME_XOR32(&ADC_CLM1_REG(base), (uint32_t)(value)))
/*@}*/

/*
 * Constants & macros for individual ADC_CLM1 bitfields
 */

/*!
 * @name Register ADC_CLM1, field CLM1[6:0] (RW)
 *
 * Calibration Value
 */
/*@{*/
/*! @brief Read current value of the ADC_CLM1_CLM1 field. */
#define ADC_RD_CLM1_CLM1(base) ((ADC_CLM1_REG(base) & ADC_CLM1_CLM1_MASK) >> ADC_CLM1_CLM1_SHIFT)
#define ADC_BRD_CLM1_CLM1(base) (BME_UBFX32(&ADC_CLM1_REG(base), ADC_CLM1_CLM1_SHIFT, ADC_CLM1_CLM1_WIDTH))

/*! @brief Set the CLM1 field to a new value. */
#define ADC_WR_CLM1_CLM1(base, value) (ADC_RMW_CLM1(base, ADC_CLM1_CLM1_MASK, ADC_CLM1_CLM1(value)))
#define ADC_BWR_CLM1_CLM1(base, value) (BME_BFI32(&ADC_CLM1_REG(base), ((uint32_t)(value) << ADC_CLM1_CLM1_SHIFT), ADC_CLM1_CLM1_SHIFT, ADC_CLM1_CLM1_WIDTH))
/*@}*/

/*******************************************************************************
 * ADC_CLM0 - ADC Minus-Side General Calibration Value Register
 ******************************************************************************/

/*!
 * @brief ADC_CLM0 - ADC Minus-Side General Calibration Value Register (RW)
 *
 * Reset value: 0x00000020U
 *
 * For more information, see CLMD register description.
 */
/*!
 * @name Constants and macros for entire ADC_CLM0 register
 */
/*@{*/
#define ADC_RD_CLM0(base)        (ADC_CLM0_REG(base))
#define ADC_WR_CLM0(base, value) (ADC_CLM0_REG(base) = (value))
#define ADC_RMW_CLM0(base, mask, value) (ADC_WR_CLM0(base, (ADC_RD_CLM0(base) & ~(mask)) | (value)))
#define ADC_SET_CLM0(base, value) (BME_OR32(&ADC_CLM0_REG(base), (uint32_t)(value)))
#define ADC_CLR_CLM0(base, value) (BME_AND32(&ADC_CLM0_REG(base), (uint32_t)(~(value))))
#define ADC_TOG_CLM0(base, value) (BME_XOR32(&ADC_CLM0_REG(base), (uint32_t)(value)))
/*@}*/

/*
 * Constants & macros for individual ADC_CLM0 bitfields
 */

/*!
 * @name Register ADC_CLM0, field CLM0[5:0] (RW)
 *
 * Calibration Value
 */
/*@{*/
/*! @brief Read current value of the ADC_CLM0_CLM0 field. */
#define ADC_RD_CLM0_CLM0(base) ((ADC_CLM0_REG(base) & ADC_CLM0_CLM0_MASK) >> ADC_CLM0_CLM0_SHIFT)
#define ADC_BRD_CLM0_CLM0(base) (BME_UBFX32(&ADC_CLM0_REG(base), ADC_CLM0_CLM0_SHIFT, ADC_CLM0_CLM0_WIDTH))

/*! @brief Set the CLM0 field to a new value. */
#define ADC_WR_CLM0_CLM0(base, value) (ADC_RMW_CLM0(base, ADC_CLM0_CLM0_MASK, ADC_CLM0_CLM0(value)))
#define ADC_BWR_CLM0_CLM0(base, value) (BME_BFI32(&ADC_CLM0_REG(base), ((uint32_t)(value) << ADC_CLM0_CLM0_SHIFT), ADC_CLM0_CLM0_SHIFT, ADC_CLM0_CLM0_WIDTH))
/*@}*/

/*
 * MKL27Z644 CMP
 *
 * High-Speed Comparator (CMP), Voltage Reference (VREF) Digital-to-Analog Converter (DAC), and Analog Mux (ANMUX)
 *
 * Registers defined in this header file:
 * - CMP_CR0 - CMP Control Register 0
 * - CMP_CR1 - CMP Control Register 1
 * - CMP_FPR - CMP Filter Period Register
 * - CMP_SCR - CMP Status and Control Register
 * - CMP_DACCR - DAC Control Register
 * - CMP_MUXCR - MUX Control Register
 */

#define CMP_INSTANCE_COUNT (1U) /*!< Number of instances of the CMP module. */
#define CMP0_IDX (0U) /*!< Instance number for CMP0. */

/*******************************************************************************
 * CMP_CR0 - CMP Control Register 0
 ******************************************************************************/

/*!
 * @brief CMP_CR0 - CMP Control Register 0 (RW)
 *
 * Reset value: 0x00U
 */
/*!
 * @name Constants and macros for entire CMP_CR0 register
 */
/*@{*/
#define CMP_RD_CR0(base)         (CMP_CR0_REG(base))
#define CMP_WR_CR0(base, value)  (CMP_CR0_REG(base) = (value))
#define CMP_RMW_CR0(base, mask, value) (CMP_WR_CR0(base, (CMP_RD_CR0(base) & ~(mask)) | (value)))
#define CMP_SET_CR0(base, value) (BME_OR8(&CMP_CR0_REG(base), (uint8_t)(value)))
#define CMP_CLR_CR0(base, value) (BME_AND8(&CMP_CR0_REG(base), (uint8_t)(~(value))))
#define CMP_TOG_CR0(base, value) (BME_XOR8(&CMP_CR0_REG(base), (uint8_t)(value)))
/*@}*/

/*
 * Constants & macros for individual CMP_CR0 bitfields
 */

/*!
 * @name Register CMP_CR0, field HYSTCTR[1:0] (RW)
 *
 * Defines the programmable hysteresis level. The hysteresis values associated
 * with each level are device-specific. See the Data Sheet of the device for the
 * exact values.
 *
 * Values:
 * - 00 - Level 0
 * - 01 - Level 1
 * - 10 - Level 2
 * - 11 - Level 3
 */
/*@{*/
/*! @brief Read current value of the CMP_CR0_HYSTCTR field. */
#define CMP_RD_CR0_HYSTCTR(base) ((CMP_CR0_REG(base) & CMP_CR0_HYSTCTR_MASK) >> CMP_CR0_HYSTCTR_SHIFT)
#define CMP_BRD_CR0_HYSTCTR(base) (BME_UBFX8(&CMP_CR0_REG(base), CMP_CR0_HYSTCTR_SHIFT, CMP_CR0_HYSTCTR_WIDTH))

/*! @brief Set the HYSTCTR field to a new value. */
#define CMP_WR_CR0_HYSTCTR(base, value) (CMP_RMW_CR0(base, CMP_CR0_HYSTCTR_MASK, CMP_CR0_HYSTCTR(value)))
#define CMP_BWR_CR0_HYSTCTR(base, value) (BME_BFI8(&CMP_CR0_REG(base), ((uint8_t)(value) << CMP_CR0_HYSTCTR_SHIFT), CMP_CR0_HYSTCTR_SHIFT, CMP_CR0_HYSTCTR_WIDTH))
/*@}*/

/*!
 * @name Register CMP_CR0, field FILTER_CNT[6:4] (RW)
 *
 * Represents the number of consecutive samples that must agree prior to the
 * comparator ouput filter accepting a new output state. For information regarding
 * filter programming and latency, see the Functional descriptionThe CMP module
 * can be used to compare two analog input voltages applied to INP and INM. .
 *
 * Values:
 * - 000 - Filter is disabled. SE = 0, COUT = COUTA.
 * - 001 - One sample must agree. The comparator output is simply sampled.
 * - 010 - 2 consecutive samples must agree.
 * - 011 - 3 consecutive samples must agree.
 * - 100 - 4 consecutive samples must agree.
 * - 101 - 5 consecutive samples must agree.
 * - 110 - 6 consecutive samples must agree.
 * - 111 - 7 consecutive samples must agree.
 */
/*@{*/
/*! @brief Read current value of the CMP_CR0_FILTER_CNT field. */
#define CMP_RD_CR0_FILTER_CNT(base) ((CMP_CR0_REG(base) & CMP_CR0_FILTER_CNT_MASK) >> CMP_CR0_FILTER_CNT_SHIFT)
#define CMP_BRD_CR0_FILTER_CNT(base) (BME_UBFX8(&CMP_CR0_REG(base), CMP_CR0_FILTER_CNT_SHIFT, CMP_CR0_FILTER_CNT_WIDTH))

/*! @brief Set the FILTER_CNT field to a new value. */
#define CMP_WR_CR0_FILTER_CNT(base, value) (CMP_RMW_CR0(base, CMP_CR0_FILTER_CNT_MASK, CMP_CR0_FILTER_CNT(value)))
#define CMP_BWR_CR0_FILTER_CNT(base, value) (BME_BFI8(&CMP_CR0_REG(base), ((uint8_t)(value) << CMP_CR0_FILTER_CNT_SHIFT), CMP_CR0_FILTER_CNT_SHIFT, CMP_CR0_FILTER_CNT_WIDTH))
/*@}*/

/*******************************************************************************
 * CMP_CR1 - CMP Control Register 1
 ******************************************************************************/

/*!
 * @brief CMP_CR1 - CMP Control Register 1 (RW)
 *
 * Reset value: 0x00U
 */
/*!
 * @name Constants and macros for entire CMP_CR1 register
 */
/*@{*/
#define CMP_RD_CR1(base)         (CMP_CR1_REG(base))
#define CMP_WR_CR1(base, value)  (CMP_CR1_REG(base) = (value))
#define CMP_RMW_CR1(base, mask, value) (CMP_WR_CR1(base, (CMP_RD_CR1(base) & ~(mask)) | (value)))
#define CMP_SET_CR1(base, value) (BME_OR8(&CMP_CR1_REG(base), (uint8_t)(value)))
#define CMP_CLR_CR1(base, value) (BME_AND8(&CMP_CR1_REG(base), (uint8_t)(~(value))))
#define CMP_TOG_CR1(base, value) (BME_XOR8(&CMP_CR1_REG(base), (uint8_t)(value)))
/*@}*/

/*
 * Constants & macros for individual CMP_CR1 bitfields
 */

/*!
 * @name Register CMP_CR1, field EN[0] (RW)
 *
 * Enables the Analog Comparator module. When the module is not enabled, it
 * remains in the off state, and consumes no power. When the user selects the same
 * input from analog mux to the positive and negative port, the comparator is
 * disabled automatically.
 *
 * Values:
 * - 0 - Analog Comparator is disabled.
 * - 1 - Analog Comparator is enabled.
 */
/*@{*/
/*! @brief Read current value of the CMP_CR1_EN field. */
#define CMP_RD_CR1_EN(base)  ((CMP_CR1_REG(base) & CMP_CR1_EN_MASK) >> CMP_CR1_EN_SHIFT)
#define CMP_BRD_CR1_EN(base) (BME_UBFX8(&CMP_CR1_REG(base), CMP_CR1_EN_SHIFT, CMP_CR1_EN_WIDTH))

/*! @brief Set the EN field to a new value. */
#define CMP_WR_CR1_EN(base, value) (CMP_RMW_CR1(base, CMP_CR1_EN_MASK, CMP_CR1_EN(value)))
#define CMP_BWR_CR1_EN(base, value) (BME_BFI8(&CMP_CR1_REG(base), ((uint8_t)(value) << CMP_CR1_EN_SHIFT), CMP_CR1_EN_SHIFT, CMP_CR1_EN_WIDTH))
/*@}*/

/*!
 * @name Register CMP_CR1, field OPE[1] (RW)
 *
 * Values:
 * - 0 - CMPO is not available on the associated CMPO output pin. If the
 *     comparator does not own the pin, this field has no effect.
 * - 1 - CMPO is available on the associated CMPO output pin. The comparator
 *     output (CMPO) is driven out on the associated CMPO output pin if the
 *     comparator owns the pin. If the comparator does not own the field, this bit has no
 *     effect.
 */
/*@{*/
/*! @brief Read current value of the CMP_CR1_OPE field. */
#define CMP_RD_CR1_OPE(base) ((CMP_CR1_REG(base) & CMP_CR1_OPE_MASK) >> CMP_CR1_OPE_SHIFT)
#define CMP_BRD_CR1_OPE(base) (BME_UBFX8(&CMP_CR1_REG(base), CMP_CR1_OPE_SHIFT, CMP_CR1_OPE_WIDTH))

/*! @brief Set the OPE field to a new value. */
#define CMP_WR_CR1_OPE(base, value) (CMP_RMW_CR1(base, CMP_CR1_OPE_MASK, CMP_CR1_OPE(value)))
#define CMP_BWR_CR1_OPE(base, value) (BME_BFI8(&CMP_CR1_REG(base), ((uint8_t)(value) << CMP_CR1_OPE_SHIFT), CMP_CR1_OPE_SHIFT, CMP_CR1_OPE_WIDTH))
/*@}*/

/*!
 * @name Register CMP_CR1, field COS[2] (RW)
 *
 * Values:
 * - 0 - Set the filtered comparator output (CMPO) to equal COUT.
 * - 1 - Set the unfiltered comparator output (CMPO) to equal COUTA.
 */
/*@{*/
/*! @brief Read current value of the CMP_CR1_COS field. */
#define CMP_RD_CR1_COS(base) ((CMP_CR1_REG(base) & CMP_CR1_COS_MASK) >> CMP_CR1_COS_SHIFT)
#define CMP_BRD_CR1_COS(base) (BME_UBFX8(&CMP_CR1_REG(base), CMP_CR1_COS_SHIFT, CMP_CR1_COS_WIDTH))

/*! @brief Set the COS field to a new value. */
#define CMP_WR_CR1_COS(base, value) (CMP_RMW_CR1(base, CMP_CR1_COS_MASK, CMP_CR1_COS(value)))
#define CMP_BWR_CR1_COS(base, value) (BME_BFI8(&CMP_CR1_REG(base), ((uint8_t)(value) << CMP_CR1_COS_SHIFT), CMP_CR1_COS_SHIFT, CMP_CR1_COS_WIDTH))
/*@}*/

/*!
 * @name Register CMP_CR1, field INV[3] (RW)
 *
 * Allows selection of the polarity of the analog comparator function. It is
 * also driven to the COUT output, on both the device pin and as SCR[COUT], when
 * OPE=0.
 *
 * Values:
 * - 0 - Does not invert the comparator output.
 * - 1 - Inverts the comparator output.
 */
/*@{*/
/*! @brief Read current value of the CMP_CR1_INV field. */
#define CMP_RD_CR1_INV(base) ((CMP_CR1_REG(base) & CMP_CR1_INV_MASK) >> CMP_CR1_INV_SHIFT)
#define CMP_BRD_CR1_INV(base) (BME_UBFX8(&CMP_CR1_REG(base), CMP_CR1_INV_SHIFT, CMP_CR1_INV_WIDTH))

/*! @brief Set the INV field to a new value. */
#define CMP_WR_CR1_INV(base, value) (CMP_RMW_CR1(base, CMP_CR1_INV_MASK, CMP_CR1_INV(value)))
#define CMP_BWR_CR1_INV(base, value) (BME_BFI8(&CMP_CR1_REG(base), ((uint8_t)(value) << CMP_CR1_INV_SHIFT), CMP_CR1_INV_SHIFT, CMP_CR1_INV_WIDTH))
/*@}*/

/*!
 * @name Register CMP_CR1, field PMODE[4] (RW)
 *
 * See the electrical specifications table in the device Data Sheet for details.
 *
 * Values:
 * - 0 - Low-Speed (LS) Comparison mode selected. In this mode, CMP has slower
 *     output propagation delay and lower current consumption.
 * - 1 - High-Speed (HS) Comparison mode selected. In this mode, CMP has faster
 *     output propagation delay and higher current consumption.
 */
/*@{*/
/*! @brief Read current value of the CMP_CR1_PMODE field. */
#define CMP_RD_CR1_PMODE(base) ((CMP_CR1_REG(base) & CMP_CR1_PMODE_MASK) >> CMP_CR1_PMODE_SHIFT)
#define CMP_BRD_CR1_PMODE(base) (BME_UBFX8(&CMP_CR1_REG(base), CMP_CR1_PMODE_SHIFT, CMP_CR1_PMODE_WIDTH))

/*! @brief Set the PMODE field to a new value. */
#define CMP_WR_CR1_PMODE(base, value) (CMP_RMW_CR1(base, CMP_CR1_PMODE_MASK, CMP_CR1_PMODE(value)))
#define CMP_BWR_CR1_PMODE(base, value) (BME_BFI8(&CMP_CR1_REG(base), ((uint8_t)(value) << CMP_CR1_PMODE_SHIFT), CMP_CR1_PMODE_SHIFT, CMP_CR1_PMODE_WIDTH))
/*@}*/

/*!
 * @name Register CMP_CR1, field TRIGM[5] (RW)
 *
 * CMP and DAC are configured to CMP Trigger mode when CMP_CR1[TRIGM] is set to
 * 1. In addition, the CMP should be enabled. If the DAC is to be used as a
 * reference to the CMP, it should also be enabled. CMP Trigger mode depends on an
 * external timer resource to periodically enable the CMP and 6-bit DAC in order to
 * generate a triggered compare. Upon setting TRIGM, the CMP and DAC are placed
 * in a standby state until an external timer resource trigger is received. See
 * the chip configuration for details about the external timer resource.
 *
 * Values:
 * - 0 - Trigger mode is disabled.
 * - 1 - Trigger mode is enabled.
 */
/*@{*/
/*! @brief Read current value of the CMP_CR1_TRIGM field. */
#define CMP_RD_CR1_TRIGM(base) ((CMP_CR1_REG(base) & CMP_CR1_TRIGM_MASK) >> CMP_CR1_TRIGM_SHIFT)
#define CMP_BRD_CR1_TRIGM(base) (BME_UBFX8(&CMP_CR1_REG(base), CMP_CR1_TRIGM_SHIFT, CMP_CR1_TRIGM_WIDTH))

/*! @brief Set the TRIGM field to a new value. */
#define CMP_WR_CR1_TRIGM(base, value) (CMP_RMW_CR1(base, CMP_CR1_TRIGM_MASK, CMP_CR1_TRIGM(value)))
#define CMP_BWR_CR1_TRIGM(base, value) (BME_BFI8(&CMP_CR1_REG(base), ((uint8_t)(value) << CMP_CR1_TRIGM_SHIFT), CMP_CR1_TRIGM_SHIFT, CMP_CR1_TRIGM_WIDTH))
/*@}*/

/*!
 * @name Register CMP_CR1, field WE[6] (RW)
 *
 * The CMP does not support window compare function and a 0 must always be
 * written to WE.
 *
 * Values:
 * - 0 - Windowing mode is not selected.
 * - 1 - Windowing mode is selected.
 */
/*@{*/
/*! @brief Read current value of the CMP_CR1_WE field. */
#define CMP_RD_CR1_WE(base)  ((CMP_CR1_REG(base) & CMP_CR1_WE_MASK) >> CMP_CR1_WE_SHIFT)
#define CMP_BRD_CR1_WE(base) (BME_UBFX8(&CMP_CR1_REG(base), CMP_CR1_WE_SHIFT, CMP_CR1_WE_WIDTH))

/*! @brief Set the WE field to a new value. */
#define CMP_WR_CR1_WE(base, value) (CMP_RMW_CR1(base, CMP_CR1_WE_MASK, CMP_CR1_WE(value)))
#define CMP_BWR_CR1_WE(base, value) (BME_BFI8(&CMP_CR1_REG(base), ((uint8_t)(value) << CMP_CR1_WE_SHIFT), CMP_CR1_WE_SHIFT, CMP_CR1_WE_WIDTH))
/*@}*/

/*!
 * @name Register CMP_CR1, field SE[7] (RW)
 *
 * SE must be clear to 0 and usage of sample operation is limited to a divided
 * version of the bus clock.
 *
 * Values:
 * - 0 - Sampling mode is not selected.
 * - 1 - Sampling mode is selected.
 */
/*@{*/
/*! @brief Read current value of the CMP_CR1_SE field. */
#define CMP_RD_CR1_SE(base)  ((CMP_CR1_REG(base) & CMP_CR1_SE_MASK) >> CMP_CR1_SE_SHIFT)
#define CMP_BRD_CR1_SE(base) (BME_UBFX8(&CMP_CR1_REG(base), CMP_CR1_SE_SHIFT, CMP_CR1_SE_WIDTH))

/*! @brief Set the SE field to a new value. */
#define CMP_WR_CR1_SE(base, value) (CMP_RMW_CR1(base, CMP_CR1_SE_MASK, CMP_CR1_SE(value)))
#define CMP_BWR_CR1_SE(base, value) (BME_BFI8(&CMP_CR1_REG(base), ((uint8_t)(value) << CMP_CR1_SE_SHIFT), CMP_CR1_SE_SHIFT, CMP_CR1_SE_WIDTH))
/*@}*/

/*******************************************************************************
 * CMP_FPR - CMP Filter Period Register
 ******************************************************************************/

/*!
 * @brief CMP_FPR - CMP Filter Period Register (RW)
 *
 * Reset value: 0x00U
 */
/*!
 * @name Constants and macros for entire CMP_FPR register
 */
/*@{*/
#define CMP_RD_FPR(base)         (CMP_FPR_REG(base))
#define CMP_WR_FPR(base, value)  (CMP_FPR_REG(base) = (value))
#define CMP_RMW_FPR(base, mask, value) (CMP_WR_FPR(base, (CMP_RD_FPR(base) & ~(mask)) | (value)))
#define CMP_SET_FPR(base, value) (BME_OR8(&CMP_FPR_REG(base), (uint8_t)(value)))
#define CMP_CLR_FPR(base, value) (BME_AND8(&CMP_FPR_REG(base), (uint8_t)(~(value))))
#define CMP_TOG_FPR(base, value) (BME_XOR8(&CMP_FPR_REG(base), (uint8_t)(value)))
/*@}*/

/*******************************************************************************
 * CMP_SCR - CMP Status and Control Register
 ******************************************************************************/

/*!
 * @brief CMP_SCR - CMP Status and Control Register (RW)
 *
 * Reset value: 0x00U
 */
/*!
 * @name Constants and macros for entire CMP_SCR register
 */
/*@{*/
#define CMP_RD_SCR(base)         (CMP_SCR_REG(base))
#define CMP_WR_SCR(base, value)  (CMP_SCR_REG(base) = (value))
#define CMP_RMW_SCR(base, mask, value) (CMP_WR_SCR(base, (CMP_RD_SCR(base) & ~(mask)) | (value)))
#define CMP_SET_SCR(base, value) (BME_OR8(&CMP_SCR_REG(base), (uint8_t)(value)))
#define CMP_CLR_SCR(base, value) (BME_AND8(&CMP_SCR_REG(base), (uint8_t)(~(value))))
#define CMP_TOG_SCR(base, value) (BME_XOR8(&CMP_SCR_REG(base), (uint8_t)(value)))
/*@}*/

/*
 * Constants & macros for individual CMP_SCR bitfields
 */

/*!
 * @name Register CMP_SCR, field COUT[0] (RO)
 *
 * Returns the current value of the Analog Comparator output, when read. The
 * field is reset to 0 and will read as CR1[INV] when the Analog Comparator module
 * is disabled, that is, when CR1[EN] = 0. Writes to this field are ignored.
 */
/*@{*/
/*! @brief Read current value of the CMP_SCR_COUT field. */
#define CMP_RD_SCR_COUT(base) ((CMP_SCR_REG(base) & CMP_SCR_COUT_MASK) >> CMP_SCR_COUT_SHIFT)
#define CMP_BRD_SCR_COUT(base) (BME_UBFX8(&CMP_SCR_REG(base), CMP_SCR_COUT_SHIFT, CMP_SCR_COUT_WIDTH))
/*@}*/

/*!
 * @name Register CMP_SCR, field CFF[1] (W1C)
 *
 * Detects a falling-edge on COUT, when set, during normal operation. CFF is
 * cleared by writing 1 to it. During Stop modes, CFF is edge sensitive .
 *
 * Values:
 * - 0 - Falling-edge on COUT has not been detected.
 * - 1 - Falling-edge on COUT has occurred.
 */
/*@{*/
/*! @brief Read current value of the CMP_SCR_CFF field. */
#define CMP_RD_SCR_CFF(base) ((CMP_SCR_REG(base) & CMP_SCR_CFF_MASK) >> CMP_SCR_CFF_SHIFT)
#define CMP_BRD_SCR_CFF(base) (BME_UBFX8(&CMP_SCR_REG(base), CMP_SCR_CFF_SHIFT, CMP_SCR_CFF_WIDTH))

/*! @brief Set the CFF field to a new value. */
#define CMP_WR_SCR_CFF(base, value) (CMP_RMW_SCR(base, (CMP_SCR_CFF_MASK | CMP_SCR_CFR_MASK), CMP_SCR_CFF(value)))
#define CMP_BWR_SCR_CFF(base, value) (BME_BFI8(&CMP_SCR_REG(base), ((uint8_t)(value) << CMP_SCR_CFF_SHIFT), CMP_SCR_CFF_SHIFT, CMP_SCR_CFF_WIDTH))
/*@}*/

/*!
 * @name Register CMP_SCR, field CFR[2] (W1C)
 *
 * Detects a rising-edge on COUT, when set, during normal operation. CFR is
 * cleared by writing 1 to it. During Stop modes, CFR is edge sensitive .
 *
 * Values:
 * - 0 - Rising-edge on COUT has not been detected.
 * - 1 - Rising-edge on COUT has occurred.
 */
/*@{*/
/*! @brief Read current value of the CMP_SCR_CFR field. */
#define CMP_RD_SCR_CFR(base) ((CMP_SCR_REG(base) & CMP_SCR_CFR_MASK) >> CMP_SCR_CFR_SHIFT)
#define CMP_BRD_SCR_CFR(base) (BME_UBFX8(&CMP_SCR_REG(base), CMP_SCR_CFR_SHIFT, CMP_SCR_CFR_WIDTH))

/*! @brief Set the CFR field to a new value. */
#define CMP_WR_SCR_CFR(base, value) (CMP_RMW_SCR(base, (CMP_SCR_CFR_MASK | CMP_SCR_CFF_MASK), CMP_SCR_CFR(value)))
#define CMP_BWR_SCR_CFR(base, value) (BME_BFI8(&CMP_SCR_REG(base), ((uint8_t)(value) << CMP_SCR_CFR_SHIFT), CMP_SCR_CFR_SHIFT, CMP_SCR_CFR_WIDTH))
/*@}*/

/*!
 * @name Register CMP_SCR, field IEF[3] (RW)
 *
 * Enables the CFF interrupt from the CMP. When this field is set, an interrupt
 * will be asserted when CFF is set.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
/*@{*/
/*! @brief Read current value of the CMP_SCR_IEF field. */
#define CMP_RD_SCR_IEF(base) ((CMP_SCR_REG(base) & CMP_SCR_IEF_MASK) >> CMP_SCR_IEF_SHIFT)
#define CMP_BRD_SCR_IEF(base) (BME_UBFX8(&CMP_SCR_REG(base), CMP_SCR_IEF_SHIFT, CMP_SCR_IEF_WIDTH))

/*! @brief Set the IEF field to a new value. */
#define CMP_WR_SCR_IEF(base, value) (CMP_RMW_SCR(base, (CMP_SCR_IEF_MASK | CMP_SCR_CFF_MASK | CMP_SCR_CFR_MASK), CMP_SCR_IEF(value)))
#define CMP_BWR_SCR_IEF(base, value) (BME_BFI8(&CMP_SCR_REG(base), ((uint8_t)(value) << CMP_SCR_IEF_SHIFT), CMP_SCR_IEF_SHIFT, CMP_SCR_IEF_WIDTH))
/*@}*/

/*!
 * @name Register CMP_SCR, field IER[4] (RW)
 *
 * Enables the CFR interrupt from the CMP. When this field is set, an interrupt
 * will be asserted when CFR is set.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
/*@{*/
/*! @brief Read current value of the CMP_SCR_IER field. */
#define CMP_RD_SCR_IER(base) ((CMP_SCR_REG(base) & CMP_SCR_IER_MASK) >> CMP_SCR_IER_SHIFT)
#define CMP_BRD_SCR_IER(base) (BME_UBFX8(&CMP_SCR_REG(base), CMP_SCR_IER_SHIFT, CMP_SCR_IER_WIDTH))

/*! @brief Set the IER field to a new value. */
#define CMP_WR_SCR_IER(base, value) (CMP_RMW_SCR(base, (CMP_SCR_IER_MASK | CMP_SCR_CFF_MASK | CMP_SCR_CFR_MASK), CMP_SCR_IER(value)))
#define CMP_BWR_SCR_IER(base, value) (BME_BFI8(&CMP_SCR_REG(base), ((uint8_t)(value) << CMP_SCR_IER_SHIFT), CMP_SCR_IER_SHIFT, CMP_SCR_IER_WIDTH))
/*@}*/

/*!
 * @name Register CMP_SCR, field DMAEN[6] (RW)
 *
 * Enables the DMA transfer triggered from the CMP module. When this field is
 * set, a DMA request is asserted when CFR or CFF is set.
 *
 * Values:
 * - 0 - DMA is disabled.
 * - 1 - DMA is enabled.
 */
/*@{*/
/*! @brief Read current value of the CMP_SCR_DMAEN field. */
#define CMP_RD_SCR_DMAEN(base) ((CMP_SCR_REG(base) & CMP_SCR_DMAEN_MASK) >> CMP_SCR_DMAEN_SHIFT)
#define CMP_BRD_SCR_DMAEN(base) (BME_UBFX8(&CMP_SCR_REG(base), CMP_SCR_DMAEN_SHIFT, CMP_SCR_DMAEN_WIDTH))

/*! @brief Set the DMAEN field to a new value. */
#define CMP_WR_SCR_DMAEN(base, value) (CMP_RMW_SCR(base, (CMP_SCR_DMAEN_MASK | CMP_SCR_CFF_MASK | CMP_SCR_CFR_MASK), CMP_SCR_DMAEN(value)))
#define CMP_BWR_SCR_DMAEN(base, value) (BME_BFI8(&CMP_SCR_REG(base), ((uint8_t)(value) << CMP_SCR_DMAEN_SHIFT), CMP_SCR_DMAEN_SHIFT, CMP_SCR_DMAEN_WIDTH))
/*@}*/

/*******************************************************************************
 * CMP_DACCR - DAC Control Register
 ******************************************************************************/

/*!
 * @brief CMP_DACCR - DAC Control Register (RW)
 *
 * Reset value: 0x00U
 */
/*!
 * @name Constants and macros for entire CMP_DACCR register
 */
/*@{*/
#define CMP_RD_DACCR(base)       (CMP_DACCR_REG(base))
#define CMP_WR_DACCR(base, value) (CMP_DACCR_REG(base) = (value))
#define CMP_RMW_DACCR(base, mask, value) (CMP_WR_DACCR(base, (CMP_RD_DACCR(base) & ~(mask)) | (value)))
#define CMP_SET_DACCR(base, value) (BME_OR8(&CMP_DACCR_REG(base), (uint8_t)(value)))
#define CMP_CLR_DACCR(base, value) (BME_AND8(&CMP_DACCR_REG(base), (uint8_t)(~(value))))
#define CMP_TOG_DACCR(base, value) (BME_XOR8(&CMP_DACCR_REG(base), (uint8_t)(value)))
/*@}*/

/*
 * Constants & macros for individual CMP_DACCR bitfields
 */

/*!
 * @name Register CMP_DACCR, field VOSEL[5:0] (RW)
 *
 * Selects an output voltage from one of 64 distinct levels. DACO = (V in /64) *
 * (VOSEL[5:0] + 1) , so the DACO range is from V in /64 to V in .
 */
/*@{*/
/*! @brief Read current value of the CMP_DACCR_VOSEL field. */
#define CMP_RD_DACCR_VOSEL(base) ((CMP_DACCR_REG(base) & CMP_DACCR_VOSEL_MASK) >> CMP_DACCR_VOSEL_SHIFT)
#define CMP_BRD_DACCR_VOSEL(base) (BME_UBFX8(&CMP_DACCR_REG(base), CMP_DACCR_VOSEL_SHIFT, CMP_DACCR_VOSEL_WIDTH))

/*! @brief Set the VOSEL field to a new value. */
#define CMP_WR_DACCR_VOSEL(base, value) (CMP_RMW_DACCR(base, CMP_DACCR_VOSEL_MASK, CMP_DACCR_VOSEL(value)))
#define CMP_BWR_DACCR_VOSEL(base, value) (BME_BFI8(&CMP_DACCR_REG(base), ((uint8_t)(value) << CMP_DACCR_VOSEL_SHIFT), CMP_DACCR_VOSEL_SHIFT, CMP_DACCR_VOSEL_WIDTH))
/*@}*/

/*!
 * @name Register CMP_DACCR, field VRSEL[6] (RW)
 *
 * Values:
 * - 0 - Vin1 is selected as resistor ladder network supply reference.
 * - 1 - Vin2 is selected as resistor ladder network supply reference.
 */
/*@{*/
/*! @brief Read current value of the CMP_DACCR_VRSEL field. */
#define CMP_RD_DACCR_VRSEL(base) ((CMP_DACCR_REG(base) & CMP_DACCR_VRSEL_MASK) >> CMP_DACCR_VRSEL_SHIFT)
#define CMP_BRD_DACCR_VRSEL(base) (BME_UBFX8(&CMP_DACCR_REG(base), CMP_DACCR_VRSEL_SHIFT, CMP_DACCR_VRSEL_WIDTH))

/*! @brief Set the VRSEL field to a new value. */
#define CMP_WR_DACCR_VRSEL(base, value) (CMP_RMW_DACCR(base, CMP_DACCR_VRSEL_MASK, CMP_DACCR_VRSEL(value)))
#define CMP_BWR_DACCR_VRSEL(base, value) (BME_BFI8(&CMP_DACCR_REG(base), ((uint8_t)(value) << CMP_DACCR_VRSEL_SHIFT), CMP_DACCR_VRSEL_SHIFT, CMP_DACCR_VRSEL_WIDTH))
/*@}*/

/*!
 * @name Register CMP_DACCR, field DACEN[7] (RW)
 *
 * Enables the DAC. When the DAC is disabled, it is powered down to conserve
 * power.
 *
 * Values:
 * - 0 - DAC is disabled.
 * - 1 - DAC is enabled.
 */
/*@{*/
/*! @brief Read current value of the CMP_DACCR_DACEN field. */
#define CMP_RD_DACCR_DACEN(base) ((CMP_DACCR_REG(base) & CMP_DACCR_DACEN_MASK) >> CMP_DACCR_DACEN_SHIFT)
#define CMP_BRD_DACCR_DACEN(base) (BME_UBFX8(&CMP_DACCR_REG(base), CMP_DACCR_DACEN_SHIFT, CMP_DACCR_DACEN_WIDTH))

/*! @brief Set the DACEN field to a new value. */
#define CMP_WR_DACCR_DACEN(base, value) (CMP_RMW_DACCR(base, CMP_DACCR_DACEN_MASK, CMP_DACCR_DACEN(value)))
#define CMP_BWR_DACCR_DACEN(base, value) (BME_BFI8(&CMP_DACCR_REG(base), ((uint8_t)(value) << CMP_DACCR_DACEN_SHIFT), CMP_DACCR_DACEN_SHIFT, CMP_DACCR_DACEN_WIDTH))
/*@}*/

/*******************************************************************************
 * CMP_MUXCR - MUX Control Register
 ******************************************************************************/

/*!
 * @brief CMP_MUXCR - MUX Control Register (RW)
 *
 * Reset value: 0x00U
 */
/*!
 * @name Constants and macros for entire CMP_MUXCR register
 */
/*@{*/
#define CMP_RD_MUXCR(base)       (CMP_MUXCR_REG(base))
#define CMP_WR_MUXCR(base, value) (CMP_MUXCR_REG(base) = (value))
#define CMP_RMW_MUXCR(base, mask, value) (CMP_WR_MUXCR(base, (CMP_RD_MUXCR(base) & ~(mask)) | (value)))
#define CMP_SET_MUXCR(base, value) (BME_OR8(&CMP_MUXCR_REG(base), (uint8_t)(value)))
#define CMP_CLR_MUXCR(base, value) (BME_AND8(&CMP_MUXCR_REG(base), (uint8_t)(~(value))))
#define CMP_TOG_MUXCR(base, value) (BME_XOR8(&CMP_MUXCR_REG(base), (uint8_t)(value)))
/*@}*/

/*
 * Constants & macros for individual CMP_MUXCR bitfields
 */

/*!
 * @name Register CMP_MUXCR, field MSEL[2:0] (RW)
 *
 * Determines which input is selected for the minus input of the comparator. For
 * INx inputs, see CMP, DAC, and ANMUX block diagrams. When an inappropriate
 * operation selects the same input for both muxes, the comparator automatically
 * shuts down to prevent itself from becoming a noise generator.
 *
 * Values:
 * - 000 - IN0
 * - 001 - IN1
 * - 010 - IN2
 * - 011 - IN3
 * - 100 - IN4
 * - 101 - IN5
 * - 110 - IN6
 * - 111 - IN7
 */
/*@{*/
/*! @brief Read current value of the CMP_MUXCR_MSEL field. */
#define CMP_RD_MUXCR_MSEL(base) ((CMP_MUXCR_REG(base) & CMP_MUXCR_MSEL_MASK) >> CMP_MUXCR_MSEL_SHIFT)
#define CMP_BRD_MUXCR_MSEL(base) (BME_UBFX8(&CMP_MUXCR_REG(base), CMP_MUXCR_MSEL_SHIFT, CMP_MUXCR_MSEL_WIDTH))

/*! @brief Set the MSEL field to a new value. */
#define CMP_WR_MUXCR_MSEL(base, value) (CMP_RMW_MUXCR(base, CMP_MUXCR_MSEL_MASK, CMP_MUXCR_MSEL(value)))
#define CMP_BWR_MUXCR_MSEL(base, value) (BME_BFI8(&CMP_MUXCR_REG(base), ((uint8_t)(value) << CMP_MUXCR_MSEL_SHIFT), CMP_MUXCR_MSEL_SHIFT, CMP_MUXCR_MSEL_WIDTH))
/*@}*/

/*!
 * @name Register CMP_MUXCR, field PSEL[5:3] (RW)
 *
 * Determines which input is selected for the plus input of the comparator. For
 * INx inputs, see CMP, DAC, and ANMUX block diagrams. When an inappropriate
 * operation selects the same input for both muxes, the comparator automatically
 * shuts down to prevent itself from becoming a noise generator.
 *
 * Values:
 * - 000 - IN0
 * - 001 - IN1
 * - 010 - IN2
 * - 011 - IN3
 * - 100 - IN4
 * - 101 - IN5
 * - 110 - IN6
 * - 111 - IN7
 */
/*@{*/
/*! @brief Read current value of the CMP_MUXCR_PSEL field. */
#define CMP_RD_MUXCR_PSEL(base) ((CMP_MUXCR_REG(base) & CMP_MUXCR_PSEL_MASK) >> CMP_MUXCR_PSEL_SHIFT)
#define CMP_BRD_MUXCR_PSEL(base) (BME_UBFX8(&CMP_MUXCR_REG(base), CMP_MUXCR_PSEL_SHIFT, CMP_MUXCR_PSEL_WIDTH))

/*! @brief Set the PSEL field to a new value. */
#define CMP_WR_MUXCR_PSEL(base, value) (CMP_RMW_MUXCR(base, CMP_MUXCR_PSEL_MASK, CMP_MUXCR_PSEL(value)))
#define CMP_BWR_MUXCR_PSEL(base, value) (BME_BFI8(&CMP_MUXCR_REG(base), ((uint8_t)(value) << CMP_MUXCR_PSEL_SHIFT), CMP_MUXCR_PSEL_SHIFT, CMP_MUXCR_PSEL_WIDTH))
/*@}*/

/*!
 * @name Register CMP_MUXCR, field PSTM[7] (RW)
 *
 * This bit is used to enable to MUX pass through mode. Pass through mode is
 * always available but for some devices this feature must be always disabled due to
 * the lack of package pins.
 *
 * Values:
 * - 0 - Pass Through Mode is disabled.
 * - 1 - Pass Through Mode is enabled.
 */
/*@{*/
/*! @brief Read current value of the CMP_MUXCR_PSTM field. */
#define CMP_RD_MUXCR_PSTM(base) ((CMP_MUXCR_REG(base) & CMP_MUXCR_PSTM_MASK) >> CMP_MUXCR_PSTM_SHIFT)
#define CMP_BRD_MUXCR_PSTM(base) (BME_UBFX8(&CMP_MUXCR_REG(base), CMP_MUXCR_PSTM_SHIFT, CMP_MUXCR_PSTM_WIDTH))

/*! @brief Set the PSTM field to a new value. */
#define CMP_WR_MUXCR_PSTM(base, value) (CMP_RMW_MUXCR(base, CMP_MUXCR_PSTM_MASK, CMP_MUXCR_PSTM(value)))
#define CMP_BWR_MUXCR_PSTM(base, value) (BME_BFI8(&CMP_MUXCR_REG(base), ((uint8_t)(value) << CMP_MUXCR_PSTM_SHIFT), CMP_MUXCR_PSTM_SHIFT, CMP_MUXCR_PSTM_WIDTH))
/*@}*/

/*
 * MKL27Z644 CRC
 *
 * Cyclic Redundancy Check
 *
 * Registers defined in this header file:
 * - CRC_DATAL - CRC_DATAL register.
 * - CRC_DATAH - CRC_DATAH register.
 * - CRC_DATALL - CRC_DATALL register.
 * - CRC_DATALU - CRC_DATALU register.
 * - CRC_DATAHL - CRC_DATAHL register.
 * - CRC_DATAHU - CRC_DATAHU register.
 * - CRC_DATA - CRC Data register
 * - CRC_GPOLY - CRC Polynomial register
 * - CRC_GPOLYL - CRC_GPOLYL register.
 * - CRC_GPOLYH - CRC_GPOLYH register.
 * - CRC_GPOLYLL - CRC_GPOLYLL register.
 * - CRC_GPOLYLU - CRC_GPOLYLU register.
 * - CRC_GPOLYHL - CRC_GPOLYHL register.
 * - CRC_GPOLYHU - CRC_GPOLYHU register.
 * - CRC_CTRL - CRC Control register
 * - CRC_CTRLHU - CRC_CTRLHU register.
 */

#define CRC_INSTANCE_COUNT (1U) /*!< Number of instances of the CRC module. */
#define CRC_IDX (0U) /*!< Instance number for CRC. */

/*******************************************************************************
 * CRC_DATALL - CRC_DATALL register.
 ******************************************************************************/

/*!
 * @brief CRC_DATALL - CRC_DATALL register. (RW)
 *
 * Reset value: 0xFFU
 */
/*!
 * @name Constants and macros for entire CRC_DATALL register
 */
/*@{*/
#define CRC_RD_DATALL(base)      (CRC_DATALL_REG(base))
#define CRC_WR_DATALL(base, value) (CRC_DATALL_REG(base) = (value))
#define CRC_RMW_DATALL(base, mask, value) (CRC_WR_DATALL(base, (CRC_RD_DATALL(base) & ~(mask)) | (value)))
#define CRC_SET_DATALL(base, value) (BME_OR8(&CRC_DATALL_REG(base), (uint8_t)(value)))
#define CRC_CLR_DATALL(base, value) (BME_AND8(&CRC_DATALL_REG(base), (uint8_t)(~(value))))
#define CRC_TOG_DATALL(base, value) (BME_XOR8(&CRC_DATALL_REG(base), (uint8_t)(value)))
/*@}*/

/*******************************************************************************
 * CRC_DATAL - CRC_DATAL register.
 ******************************************************************************/

/*!
 * @brief CRC_DATAL - CRC_DATAL register. (RW)
 *
 * Reset value: 0xFFFFU
 */
/*!
 * @name Constants and macros for entire CRC_DATAL register
 */
/*@{*/
#define CRC_RD_DATAL(base)       (CRC_DATAL_REG(base))
#define CRC_WR_DATAL(base, value) (CRC_DATAL_REG(base) = (value))
#define CRC_RMW_DATAL(base, mask, value) (CRC_WR_DATAL(base, (CRC_RD_DATAL(base) & ~(mask)) | (value)))
#define CRC_SET_DATAL(base, value) (BME_OR16(&CRC_DATAL_REG(base), (uint16_t)(value)))
#define CRC_CLR_DATAL(base, value) (BME_AND16(&CRC_DATAL_REG(base), (uint16_t)(~(value))))
#define CRC_TOG_DATAL(base, value) (BME_XOR16(&CRC_DATAL_REG(base), (uint16_t)(value)))
/*@}*/

/*******************************************************************************
 * CRC_DATA - CRC Data register
 ******************************************************************************/

/*!
 * @brief CRC_DATA - CRC Data register (RW)
 *
 * Reset value: 0xFFFFFFFFU
 *
 * The CRC Data register contains the value of the seed, data, and checksum.
 * When CTRL[WAS] is set, any write to the data register is regarded as the seed
 * value. When CTRL[WAS] is cleared, any write to the data register is regarded as
 * data for general CRC computation. In 16-bit CRC mode, the HU and HL fields are
 * not used for programming the seed value, and reads of these fields return an
 * indeterminate value. In 32-bit CRC mode, all fields are used for programming
 * the seed value. When programming data values, the values can be written 8 bits,
 * 16 bits, or 32 bits at a time, provided all bytes are contiguous; with MSB of
 * data value written first. After all data values are written, the CRC result
 * can be read from this data register. In 16-bit CRC mode, the CRC result is
 * available in the LU and LL fields. In 32-bit CRC mode, all fields contain the
 * result. Reads of this register at any time return the intermediate CRC value,
 * provided the CRC module is configured.
 */
/*!
 * @name Constants and macros for entire CRC_DATA register
 */
/*@{*/
#define CRC_RD_DATA(base)        (CRC_DATA_REG(base))
#define CRC_WR_DATA(base, value) (CRC_DATA_REG(base) = (value))
#define CRC_RMW_DATA(base, mask, value) (CRC_WR_DATA(base, (CRC_RD_DATA(base) & ~(mask)) | (value)))
#define CRC_SET_DATA(base, value) (BME_OR32(&CRC_DATA_REG(base), (uint32_t)(value)))
#define CRC_CLR_DATA(base, value) (BME_AND32(&CRC_DATA_REG(base), (uint32_t)(~(value))))
#define CRC_TOG_DATA(base, value) (BME_XOR32(&CRC_DATA_REG(base), (uint32_t)(value)))
/*@}*/

/*
 * Constants & macros for individual CRC_DATA bitfields
 */

/*!
 * @name Register CRC_DATA, field LL[7:0] (RW)
 *
 * When CTRL[WAS] is 1, values written to this field are part of the seed value.
 * When CTRL[WAS] is 0, data written to this field is used for CRC checksum
 * generation.
 */
/*@{*/
/*! @brief Read current value of the CRC_DATA_LL field. */
#define CRC_RD_DATA_LL(base) ((CRC_DATA_REG(base) & CRC_DATA_LL_MASK) >> CRC_DATA_LL_SHIFT)
#define CRC_BRD_DATA_LL(base) (BME_UBFX32(&CRC_DATA_REG(base), CRC_DATA_LL_SHIFT, CRC_DATA_LL_WIDTH))

/*! @brief Set the LL field to a new value. */
#define CRC_WR_DATA_LL(base, value) (CRC_RMW_DATA(base, CRC_DATA_LL_MASK, CRC_DATA_LL(value)))
#define CRC_BWR_DATA_LL(base, value) (BME_BFI32(&CRC_DATA_REG(base), ((uint32_t)(value) << CRC_DATA_LL_SHIFT), CRC_DATA_LL_SHIFT, CRC_DATA_LL_WIDTH))
/*@}*/

/*!
 * @name Register CRC_DATA, field LU[15:8] (RW)
 *
 * When CTRL[WAS] is 1, values written to this field are part of the seed value.
 * When CTRL[WAS] is 0, data written to this field is used for CRC checksum
 * generation.
 */
/*@{*/
/*! @brief Read current value of the CRC_DATA_LU field. */
#define CRC_RD_DATA_LU(base) ((CRC_DATA_REG(base) & CRC_DATA_LU_MASK) >> CRC_DATA_LU_SHIFT)
#define CRC_BRD_DATA_LU(base) (BME_UBFX32(&CRC_DATA_REG(base), CRC_DATA_LU_SHIFT, CRC_DATA_LU_WIDTH))

/*! @brief Set the LU field to a new value. */
#define CRC_WR_DATA_LU(base, value) (CRC_RMW_DATA(base, CRC_DATA_LU_MASK, CRC_DATA_LU(value)))
#define CRC_BWR_DATA_LU(base, value) (BME_BFI32(&CRC_DATA_REG(base), ((uint32_t)(value) << CRC_DATA_LU_SHIFT), CRC_DATA_LU_SHIFT, CRC_DATA_LU_WIDTH))
/*@}*/

/*!
 * @name Register CRC_DATA, field HL[23:16] (RW)
 *
 * In 16-bit CRC mode (CTRL[TCRC] is 0), this field is not used for programming
 * a seed value. In 32-bit CRC mode (CTRL[TCRC] is 1), values written to this
 * field are part of the seed value when CTRL[WAS] is 1. When CTRL[WAS] is 0, data
 * written to this field is used for CRC checksum generation in both 16-bit and
 * 32-bit CRC modes.
 */
/*@{*/
/*! @brief Read current value of the CRC_DATA_HL field. */
#define CRC_RD_DATA_HL(base) ((CRC_DATA_REG(base) & CRC_DATA_HL_MASK) >> CRC_DATA_HL_SHIFT)
#define CRC_BRD_DATA_HL(base) (BME_UBFX32(&CRC_DATA_REG(base), CRC_DATA_HL_SHIFT, CRC_DATA_HL_WIDTH))

/*! @brief Set the HL field to a new value. */
#define CRC_WR_DATA_HL(base, value) (CRC_RMW_DATA(base, CRC_DATA_HL_MASK, CRC_DATA_HL(value)))
#define CRC_BWR_DATA_HL(base, value) (BME_BFI32(&CRC_DATA_REG(base), ((uint32_t)(value) << CRC_DATA_HL_SHIFT), CRC_DATA_HL_SHIFT, CRC_DATA_HL_WIDTH))
/*@}*/

/*!
 * @name Register CRC_DATA, field HU[31:24] (RW)
 *
 * In 16-bit CRC mode (CTRL[TCRC] is 0), this field is not used for programming
 * a seed value. In 32-bit CRC mode (CTRL[TCRC] is 1), values written to this
 * field are part of the seed value when CTRL[WAS] is 1. When CTRL[WAS] is 0, data
 * written to this field is used for CRC checksum generation in both 16-bit and
 * 32-bit CRC modes.
 */
/*@{*/
/*! @brief Read current value of the CRC_DATA_HU field. */
#define CRC_RD_DATA_HU(base) ((CRC_DATA_REG(base) & CRC_DATA_HU_MASK) >> CRC_DATA_HU_SHIFT)
#define CRC_BRD_DATA_HU(base) (BME_UBFX32(&CRC_DATA_REG(base), CRC_DATA_HU_SHIFT, CRC_DATA_HU_WIDTH))

/*! @brief Set the HU field to a new value. */
#define CRC_WR_DATA_HU(base, value) (CRC_RMW_DATA(base, CRC_DATA_HU_MASK, CRC_DATA_HU(value)))
#define CRC_BWR_DATA_HU(base, value) (BME_BFI32(&CRC_DATA_REG(base), ((uint32_t)(value) << CRC_DATA_HU_SHIFT), CRC_DATA_HU_SHIFT, CRC_DATA_HU_WIDTH))
/*@}*/

/*******************************************************************************
 * CRC_DATALU - CRC_DATALU register.
 ******************************************************************************/

/*!
 * @brief CRC_DATALU - CRC_DATALU register. (RW)
 *
 * Reset value: 0xFFU
 */
/*!
 * @name Constants and macros for entire CRC_DATALU register
 */
/*@{*/
#define CRC_RD_DATALU(base)      (CRC_DATALU_REG(base))
#define CRC_WR_DATALU(base, value) (CRC_DATALU_REG(base) = (value))
#define CRC_RMW_DATALU(base, mask, value) (CRC_WR_DATALU(base, (CRC_RD_DATALU(base) & ~(mask)) | (value)))
#define CRC_SET_DATALU(base, value) (BME_OR8(&CRC_DATALU_REG(base), (uint8_t)(value)))
#define CRC_CLR_DATALU(base, value) (BME_AND8(&CRC_DATALU_REG(base), (uint8_t)(~(value))))
#define CRC_TOG_DATALU(base, value) (BME_XOR8(&CRC_DATALU_REG(base), (uint8_t)(value)))
/*@}*/

/*******************************************************************************
 * CRC_DATAHL - CRC_DATAHL register.
 ******************************************************************************/

/*!
 * @brief CRC_DATAHL - CRC_DATAHL register. (RW)
 *
 * Reset value: 0xFFU
 */
/*!
 * @name Constants and macros for entire CRC_DATAHL register
 */
/*@{*/
#define CRC_RD_DATAHL(base)      (CRC_DATAHL_REG(base))
#define CRC_WR_DATAHL(base, value) (CRC_DATAHL_REG(base) = (value))
#define CRC_RMW_DATAHL(base, mask, value) (CRC_WR_DATAHL(base, (CRC_RD_DATAHL(base) & ~(mask)) | (value)))
#define CRC_SET_DATAHL(base, value) (BME_OR8(&CRC_DATAHL_REG(base), (uint8_t)(value)))
#define CRC_CLR_DATAHL(base, value) (BME_AND8(&CRC_DATAHL_REG(base), (uint8_t)(~(value))))
#define CRC_TOG_DATAHL(base, value) (BME_XOR8(&CRC_DATAHL_REG(base), (uint8_t)(value)))
/*@}*/

/*******************************************************************************
 * CRC_DATAH - CRC_DATAH register.
 ******************************************************************************/

/*!
 * @brief CRC_DATAH - CRC_DATAH register. (RW)
 *
 * Reset value: 0xFFFFU
 */
/*!
 * @name Constants and macros for entire CRC_DATAH register
 */
/*@{*/
#define CRC_RD_DATAH(base)       (CRC_DATAH_REG(base))
#define CRC_WR_DATAH(base, value) (CRC_DATAH_REG(base) = (value))
#define CRC_RMW_DATAH(base, mask, value) (CRC_WR_DATAH(base, (CRC_RD_DATAH(base) & ~(mask)) | (value)))
#define CRC_SET_DATAH(base, value) (BME_OR16(&CRC_DATAH_REG(base), (uint16_t)(value)))
#define CRC_CLR_DATAH(base, value) (BME_AND16(&CRC_DATAH_REG(base), (uint16_t)(~(value))))
#define CRC_TOG_DATAH(base, value) (BME_XOR16(&CRC_DATAH_REG(base), (uint16_t)(value)))
/*@}*/

/*******************************************************************************
 * CRC_DATAHU - CRC_DATAHU register.
 ******************************************************************************/

/*!
 * @brief CRC_DATAHU - CRC_DATAHU register. (RW)
 *
 * Reset value: 0xFFU
 */
/*!
 * @name Constants and macros for entire CRC_DATAHU register
 */
/*@{*/
#define CRC_RD_DATAHU(base)      (CRC_DATAHU_REG(base))
#define CRC_WR_DATAHU(base, value) (CRC_DATAHU_REG(base) = (value))
#define CRC_RMW_DATAHU(base, mask, value) (CRC_WR_DATAHU(base, (CRC_RD_DATAHU(base) & ~(mask)) | (value)))
#define CRC_SET_DATAHU(base, value) (BME_OR8(&CRC_DATAHU_REG(base), (uint8_t)(value)))
#define CRC_CLR_DATAHU(base, value) (BME_AND8(&CRC_DATAHU_REG(base), (uint8_t)(~(value))))
#define CRC_TOG_DATAHU(base, value) (BME_XOR8(&CRC_DATAHU_REG(base), (uint8_t)(value)))
/*@}*/

/*******************************************************************************
 * CRC_GPOLYLL - CRC_GPOLYLL register.
 ******************************************************************************/

/*!
 * @brief CRC_GPOLYLL - CRC_GPOLYLL register. (RW)
 *
 * Reset value: 0xFFU
 */
/*!
 * @name Constants and macros for entire CRC_GPOLYLL register
 */
/*@{*/
#define CRC_RD_GPOLYLL(base)     (CRC_GPOLYLL_REG(base))
#define CRC_WR_GPOLYLL(base, value) (CRC_GPOLYLL_REG(base) = (value))
#define CRC_RMW_GPOLYLL(base, mask, value) (CRC_WR_GPOLYLL(base, (CRC_RD_GPOLYLL(base) & ~(mask)) | (value)))
#define CRC_SET_GPOLYLL(base, value) (BME_OR8(&CRC_GPOLYLL_REG(base), (uint8_t)(value)))
#define CRC_CLR_GPOLYLL(base, value) (BME_AND8(&CRC_GPOLYLL_REG(base), (uint8_t)(~(value))))
#define CRC_TOG_GPOLYLL(base, value) (BME_XOR8(&CRC_GPOLYLL_REG(base), (uint8_t)(value)))
/*@}*/

/*******************************************************************************
 * CRC_GPOLY - CRC Polynomial register
 ******************************************************************************/

/*!
 * @brief CRC_GPOLY - CRC Polynomial register (RW)
 *
 * Reset value: 0x00001021U
 *
 * This register contains the value of the polynomial for the CRC calculation.
 * The HIGH field contains the upper 16 bits of the CRC polynomial, which are used
 * only in 32-bit CRC mode. Writes to the HIGH field are ignored in 16-bit CRC
 * mode. The LOW field contains the lower 16 bits of the CRC polynomial, which are
 * used in both 16- and 32-bit CRC modes.
 */
/*!
 * @name Constants and macros for entire CRC_GPOLY register
 */
/*@{*/
#define CRC_RD_GPOLY(base)       (CRC_GPOLY_REG(base))
#define CRC_WR_GPOLY(base, value) (CRC_GPOLY_REG(base) = (value))
#define CRC_RMW_GPOLY(base, mask, value) (CRC_WR_GPOLY(base, (CRC_RD_GPOLY(base) & ~(mask)) | (value)))
#define CRC_SET_GPOLY(base, value) (BME_OR32(&CRC_GPOLY_REG(base), (uint32_t)(value)))
#define CRC_CLR_GPOLY(base, value) (BME_AND32(&CRC_GPOLY_REG(base), (uint32_t)(~(value))))
#define CRC_TOG_GPOLY(base, value) (BME_XOR32(&CRC_GPOLY_REG(base), (uint32_t)(value)))
/*@}*/

/*
 * Constants & macros for individual CRC_GPOLY bitfields
 */

/*!
 * @name Register CRC_GPOLY, field LOW[15:0] (RW)
 *
 * Writable and readable in both 32-bit and 16-bit CRC modes.
 */
/*@{*/
/*! @brief Read current value of the CRC_GPOLY_LOW field. */
#define CRC_RD_GPOLY_LOW(base) ((CRC_GPOLY_REG(base) & CRC_GPOLY_LOW_MASK) >> CRC_GPOLY_LOW_SHIFT)
#define CRC_BRD_GPOLY_LOW(base) (BME_UBFX32(&CRC_GPOLY_REG(base), CRC_GPOLY_LOW_SHIFT, CRC_GPOLY_LOW_WIDTH))

/*! @brief Set the LOW field to a new value. */
#define CRC_WR_GPOLY_LOW(base, value) (CRC_RMW_GPOLY(base, CRC_GPOLY_LOW_MASK, CRC_GPOLY_LOW(value)))
#define CRC_BWR_GPOLY_LOW(base, value) (BME_BFI32(&CRC_GPOLY_REG(base), ((uint32_t)(value) << CRC_GPOLY_LOW_SHIFT), CRC_GPOLY_LOW_SHIFT, CRC_GPOLY_LOW_WIDTH))
/*@}*/

/*!
 * @name Register CRC_GPOLY, field HIGH[31:16] (RW)
 *
 * Writable and readable in 32-bit CRC mode (CTRL[TCRC] is 1). This field is not
 * writable in 16-bit CRC mode (CTRL[TCRC] is 0).
 */
/*@{*/
/*! @brief Read current value of the CRC_GPOLY_HIGH field. */
#define CRC_RD_GPOLY_HIGH(base) ((CRC_GPOLY_REG(base) & CRC_GPOLY_HIGH_MASK) >> CRC_GPOLY_HIGH_SHIFT)
#define CRC_BRD_GPOLY_HIGH(base) (BME_UBFX32(&CRC_GPOLY_REG(base), CRC_GPOLY_HIGH_SHIFT, CRC_GPOLY_HIGH_WIDTH))

/*! @brief Set the HIGH field to a new value. */
#define CRC_WR_GPOLY_HIGH(base, value) (CRC_RMW_GPOLY(base, CRC_GPOLY_HIGH_MASK, CRC_GPOLY_HIGH(value)))
#define CRC_BWR_GPOLY_HIGH(base, value) (BME_BFI32(&CRC_GPOLY_REG(base), ((uint32_t)(value) << CRC_GPOLY_HIGH_SHIFT), CRC_GPOLY_HIGH_SHIFT, CRC_GPOLY_HIGH_WIDTH))
/*@}*/

/*******************************************************************************
 * CRC_GPOLYL - CRC_GPOLYL register.
 ******************************************************************************/

/*!
 * @brief CRC_GPOLYL - CRC_GPOLYL register. (RW)
 *
 * Reset value: 0xFFFFU
 */
/*!
 * @name Constants and macros for entire CRC_GPOLYL register
 */
/*@{*/
#define CRC_RD_GPOLYL(base)      (CRC_GPOLYL_REG(base))
#define CRC_WR_GPOLYL(base, value) (CRC_GPOLYL_REG(base) = (value))
#define CRC_RMW_GPOLYL(base, mask, value) (CRC_WR_GPOLYL(base, (CRC_RD_GPOLYL(base) & ~(mask)) | (value)))
#define CRC_SET_GPOLYL(base, value) (BME_OR16(&CRC_GPOLYL_REG(base), (uint16_t)(value)))
#define CRC_CLR_GPOLYL(base, value) (BME_AND16(&CRC_GPOLYL_REG(base), (uint16_t)(~(value))))
#define CRC_TOG_GPOLYL(base, value) (BME_XOR16(&CRC_GPOLYL_REG(base), (uint16_t)(value)))
/*@}*/

/*******************************************************************************
 * CRC_GPOLYLU - CRC_GPOLYLU register.
 ******************************************************************************/

/*!
 * @brief CRC_GPOLYLU - CRC_GPOLYLU register. (RW)
 *
 * Reset value: 0xFFU
 */
/*!
 * @name Constants and macros for entire CRC_GPOLYLU register
 */
/*@{*/
#define CRC_RD_GPOLYLU(base)     (CRC_GPOLYLU_REG(base))
#define CRC_WR_GPOLYLU(base, value) (CRC_GPOLYLU_REG(base) = (value))
#define CRC_RMW_GPOLYLU(base, mask, value) (CRC_WR_GPOLYLU(base, (CRC_RD_GPOLYLU(base) & ~(mask)) | (value)))
#define CRC_SET_GPOLYLU(base, value) (BME_OR8(&CRC_GPOLYLU_REG(base), (uint8_t)(value)))
#define CRC_CLR_GPOLYLU(base, value) (BME_AND8(&CRC_GPOLYLU_REG(base), (uint8_t)(~(value))))
#define CRC_TOG_GPOLYLU(base, value) (BME_XOR8(&CRC_GPOLYLU_REG(base), (uint8_t)(value)))
/*@}*/

/*******************************************************************************
 * CRC_GPOLYH - CRC_GPOLYH register.
 ******************************************************************************/

/*!
 * @brief CRC_GPOLYH - CRC_GPOLYH register. (RW)
 *
 * Reset value: 0xFFFFU
 */
/*!
 * @name Constants and macros for entire CRC_GPOLYH register
 */
/*@{*/
#define CRC_RD_GPOLYH(base)      (CRC_GPOLYH_REG(base))
#define CRC_WR_GPOLYH(base, value) (CRC_GPOLYH_REG(base) = (value))
#define CRC_RMW_GPOLYH(base, mask, value) (CRC_WR_GPOLYH(base, (CRC_RD_GPOLYH(base) & ~(mask)) | (value)))
#define CRC_SET_GPOLYH(base, value) (BME_OR16(&CRC_GPOLYH_REG(base), (uint16_t)(value)))
#define CRC_CLR_GPOLYH(base, value) (BME_AND16(&CRC_GPOLYH_REG(base), (uint16_t)(~(value))))
#define CRC_TOG_GPOLYH(base, value) (BME_XOR16(&CRC_GPOLYH_REG(base), (uint16_t)(value)))
/*@}*/

/*******************************************************************************
 * CRC_GPOLYHL - CRC_GPOLYHL register.
 ******************************************************************************/

/*!
 * @brief CRC_GPOLYHL - CRC_GPOLYHL register. (RW)
 *
 * Reset value: 0xFFU
 */
/*!
 * @name Constants and macros for entire CRC_GPOLYHL register
 */
/*@{*/
#define CRC_RD_GPOLYHL(base)     (CRC_GPOLYHL_REG(base))
#define CRC_WR_GPOLYHL(base, value) (CRC_GPOLYHL_REG(base) = (value))
#define CRC_RMW_GPOLYHL(base, mask, value) (CRC_WR_GPOLYHL(base, (CRC_RD_GPOLYHL(base) & ~(mask)) | (value)))
#define CRC_SET_GPOLYHL(base, value) (BME_OR8(&CRC_GPOLYHL_REG(base), (uint8_t)(value)))
#define CRC_CLR_GPOLYHL(base, value) (BME_AND8(&CRC_GPOLYHL_REG(base), (uint8_t)(~(value))))
#define CRC_TOG_GPOLYHL(base, value) (BME_XOR8(&CRC_GPOLYHL_REG(base), (uint8_t)(value)))
/*@}*/

/*******************************************************************************
 * CRC_GPOLYHU - CRC_GPOLYHU register.
 ******************************************************************************/

/*!
 * @brief CRC_GPOLYHU - CRC_GPOLYHU register. (RW)
 *
 * Reset value: 0xFFU
 */
/*!
 * @name Constants and macros for entire CRC_GPOLYHU register
 */
/*@{*/
#define CRC_RD_GPOLYHU(base)     (CRC_GPOLYHU_REG(base))
#define CRC_WR_GPOLYHU(base, value) (CRC_GPOLYHU_REG(base) = (value))
#define CRC_RMW_GPOLYHU(base, mask, value) (CRC_WR_GPOLYHU(base, (CRC_RD_GPOLYHU(base) & ~(mask)) | (value)))
#define CRC_SET_GPOLYHU(base, value) (BME_OR8(&CRC_GPOLYHU_REG(base), (uint8_t)(value)))
#define CRC_CLR_GPOLYHU(base, value) (BME_AND8(&CRC_GPOLYHU_REG(base), (uint8_t)(~(value))))
#define CRC_TOG_GPOLYHU(base, value) (BME_XOR8(&CRC_GPOLYHU_REG(base), (uint8_t)(value)))
/*@}*/

/*******************************************************************************
 * CRC_CTRL - CRC Control register
 ******************************************************************************/

/*!
 * @brief CRC_CTRL - CRC Control register (RW)
 *
 * Reset value: 0x00000000U
 *
 * This register controls the configuration and working of the CRC module.
 * Appropriate bits must be set before starting a new CRC calculation. A new CRC
 * calculation is initialized by asserting CTRL[WAS] and then writing the seed into
 * the CRC data register.
 */
/*!
 * @name Constants and macros for entire CRC_CTRL register
 */
/*@{*/
#define CRC_RD_CTRL(base)        (CRC_CTRL_REG(base))
#define CRC_WR_CTRL(base, value) (CRC_CTRL_REG(base) = (value))
#define CRC_RMW_CTRL(base, mask, value) (CRC_WR_CTRL(base, (CRC_RD_CTRL(base) & ~(mask)) | (value)))
#define CRC_SET_CTRL(base, value) (BME_OR32(&CRC_CTRL_REG(base), (uint32_t)(value)))
#define CRC_CLR_CTRL(base, value) (BME_AND32(&CRC_CTRL_REG(base), (uint32_t)(~(value))))
#define CRC_TOG_CTRL(base, value) (BME_XOR32(&CRC_CTRL_REG(base), (uint32_t)(value)))
/*@}*/

/*
 * Constants & macros for individual CRC_CTRL bitfields
 */

/*!
 * @name Register CRC_CTRL, field TCRC[24] (RW)
 *
 * Width of CRC protocol.
 *
 * Values:
 * - 0 - 16-bit CRC protocol.
 * - 1 - 32-bit CRC protocol.
 */
/*@{*/
/*! @brief Read current value of the CRC_CTRL_TCRC field. */
#define CRC_RD_CTRL_TCRC(base) ((CRC_CTRL_REG(base) & CRC_CTRL_TCRC_MASK) >> CRC_CTRL_TCRC_SHIFT)
#define CRC_BRD_CTRL_TCRC(base) (BME_UBFX32(&CRC_CTRL_REG(base), CRC_CTRL_TCRC_SHIFT, CRC_CTRL_TCRC_WIDTH))

/*! @brief Set the TCRC field to a new value. */
#define CRC_WR_CTRL_TCRC(base, value) (CRC_RMW_CTRL(base, CRC_CTRL_TCRC_MASK, CRC_CTRL_TCRC(value)))
#define CRC_BWR_CTRL_TCRC(base, value) (BME_BFI32(&CRC_CTRL_REG(base), ((uint32_t)(value) << CRC_CTRL_TCRC_SHIFT), CRC_CTRL_TCRC_SHIFT, CRC_CTRL_TCRC_WIDTH))
/*@}*/

/*!
 * @name Register CRC_CTRL, field WAS[25] (RW)
 *
 * When asserted, a value written to the CRC data register is considered a seed
 * value. When deasserted, a value written to the CRC data register is taken as
 * data for CRC computation.
 *
 * Values:
 * - 0 - Writes to the CRC data register are data values.
 * - 1 - Writes to the CRC data register are seed values.
 */
/*@{*/
/*! @brief Read current value of the CRC_CTRL_WAS field. */
#define CRC_RD_CTRL_WAS(base) ((CRC_CTRL_REG(base) & CRC_CTRL_WAS_MASK) >> CRC_CTRL_WAS_SHIFT)
#define CRC_BRD_CTRL_WAS(base) (BME_UBFX32(&CRC_CTRL_REG(base), CRC_CTRL_WAS_SHIFT, CRC_CTRL_WAS_WIDTH))

/*! @brief Set the WAS field to a new value. */
#define CRC_WR_CTRL_WAS(base, value) (CRC_RMW_CTRL(base, CRC_CTRL_WAS_MASK, CRC_CTRL_WAS(value)))
#define CRC_BWR_CTRL_WAS(base, value) (BME_BFI32(&CRC_CTRL_REG(base), ((uint32_t)(value) << CRC_CTRL_WAS_SHIFT), CRC_CTRL_WAS_SHIFT, CRC_CTRL_WAS_WIDTH))
/*@}*/

/*!
 * @name Register CRC_CTRL, field FXOR[26] (RW)
 *
 * Some CRC protocols require the final checksum to be XORed with 0xFFFFFFFF or
 * 0xFFFF. Asserting this bit enables on the fly complementing of read data.
 *
 * Values:
 * - 0 - No XOR on reading.
 * - 1 - Invert or complement the read value of the CRC Data register.
 */
/*@{*/
/*! @brief Read current value of the CRC_CTRL_FXOR field. */
#define CRC_RD_CTRL_FXOR(base) ((CRC_CTRL_REG(base) & CRC_CTRL_FXOR_MASK) >> CRC_CTRL_FXOR_SHIFT)
#define CRC_BRD_CTRL_FXOR(base) (BME_UBFX32(&CRC_CTRL_REG(base), CRC_CTRL_FXOR_SHIFT, CRC_CTRL_FXOR_WIDTH))

/*! @brief Set the FXOR field to a new value. */
#define CRC_WR_CTRL_FXOR(base, value) (CRC_RMW_CTRL(base, CRC_CTRL_FXOR_MASK, CRC_CTRL_FXOR(value)))
#define CRC_BWR_CTRL_FXOR(base, value) (BME_BFI32(&CRC_CTRL_REG(base), ((uint32_t)(value) << CRC_CTRL_FXOR_SHIFT), CRC_CTRL_FXOR_SHIFT, CRC_CTRL_FXOR_WIDTH))
/*@}*/

/*!
 * @name Register CRC_CTRL, field TOTR[29:28] (RW)
 *
 * Identifies the transpose configuration of the value read from the CRC Data
 * register. See the description of the transpose feature for the available
 * transpose options.
 *
 * Values:
 * - 00 - No transposition.
 * - 01 - Bits in bytes are transposed; bytes are not transposed.
 * - 10 - Both bits in bytes and bytes are transposed.
 * - 11 - Only bytes are transposed; no bits in a byte are transposed.
 */
/*@{*/
/*! @brief Read current value of the CRC_CTRL_TOTR field. */
#define CRC_RD_CTRL_TOTR(base) ((CRC_CTRL_REG(base) & CRC_CTRL_TOTR_MASK) >> CRC_CTRL_TOTR_SHIFT)
#define CRC_BRD_CTRL_TOTR(base) (BME_UBFX32(&CRC_CTRL_REG(base), CRC_CTRL_TOTR_SHIFT, CRC_CTRL_TOTR_WIDTH))

/*! @brief Set the TOTR field to a new value. */
#define CRC_WR_CTRL_TOTR(base, value) (CRC_RMW_CTRL(base, CRC_CTRL_TOTR_MASK, CRC_CTRL_TOTR(value)))
#define CRC_BWR_CTRL_TOTR(base, value) (BME_BFI32(&CRC_CTRL_REG(base), ((uint32_t)(value) << CRC_CTRL_TOTR_SHIFT), CRC_CTRL_TOTR_SHIFT, CRC_CTRL_TOTR_WIDTH))
/*@}*/

/*!
 * @name Register CRC_CTRL, field TOT[31:30] (RW)
 *
 * Defines the transpose configuration of the data written to the CRC data
 * register. See the description of the transpose feature for the available transpose
 * options.
 *
 * Values:
 * - 00 - No transposition.
 * - 01 - Bits in bytes are transposed; bytes are not transposed.
 * - 10 - Both bits in bytes and bytes are transposed.
 * - 11 - Only bytes are transposed; no bits in a byte are transposed.
 */
/*@{*/
/*! @brief Read current value of the CRC_CTRL_TOT field. */
#define CRC_RD_CTRL_TOT(base) ((CRC_CTRL_REG(base) & CRC_CTRL_TOT_MASK) >> CRC_CTRL_TOT_SHIFT)
#define CRC_BRD_CTRL_TOT(base) (BME_UBFX32(&CRC_CTRL_REG(base), CRC_CTRL_TOT_SHIFT, CRC_CTRL_TOT_WIDTH))

/*! @brief Set the TOT field to a new value. */
#define CRC_WR_CTRL_TOT(base, value) (CRC_RMW_CTRL(base, CRC_CTRL_TOT_MASK, CRC_CTRL_TOT(value)))
#define CRC_BWR_CTRL_TOT(base, value) (BME_BFI32(&CRC_CTRL_REG(base), ((uint32_t)(value) << CRC_CTRL_TOT_SHIFT), CRC_CTRL_TOT_SHIFT, CRC_CTRL_TOT_WIDTH))
/*@}*/

/*******************************************************************************
 * CRC_CTRLHU - CRC_CTRLHU register.
 ******************************************************************************/

/*!
 * @brief CRC_CTRLHU - CRC_CTRLHU register. (RW)
 *
 * Reset value: 0x00U
 */
/*!
 * @name Constants and macros for entire CRC_CTRLHU register
 */
/*@{*/
#define CRC_RD_CTRLHU(base)      (CRC_CTRLHU_REG(base))
#define CRC_WR_CTRLHU(base, value) (CRC_CTRLHU_REG(base) = (value))
#define CRC_RMW_CTRLHU(base, mask, value) (CRC_WR_CTRLHU(base, (CRC_RD_CTRLHU(base) & ~(mask)) | (value)))
#define CRC_SET_CTRLHU(base, value) (BME_OR8(&CRC_CTRLHU_REG(base), (uint8_t)(value)))
#define CRC_CLR_CTRLHU(base, value) (BME_AND8(&CRC_CTRLHU_REG(base), (uint8_t)(~(value))))
#define CRC_TOG_CTRLHU(base, value) (BME_XOR8(&CRC_CTRLHU_REG(base), (uint8_t)(value)))
/*@}*/

/*
 * Constants & macros for individual CRC_CTRLHU bitfields
 */

/*!
 * @name Register CRC_CTRLHU, field TCRC[0] (RW)
 *
 * Values:
 * - 0 - 16-bit CRC protocol.
 * - 1 - 32-bit CRC protocol.
 */
/*@{*/
/*! @brief Read current value of the CRC_CTRLHU_TCRC field. */
#define CRC_RD_CTRLHU_TCRC(base) ((CRC_CTRLHU_REG(base) & CRC_CTRLHU_TCRC_MASK) >> CRC_CTRLHU_TCRC_SHIFT)
#define CRC_BRD_CTRLHU_TCRC(base) (BME_UBFX8(&CRC_CTRLHU_REG(base), CRC_CTRLHU_TCRC_SHIFT, CRC_CTRLHU_TCRC_WIDTH))

/*! @brief Set the TCRC field to a new value. */
#define CRC_WR_CTRLHU_TCRC(base, value) (CRC_RMW_CTRLHU(base, CRC_CTRLHU_TCRC_MASK, CRC_CTRLHU_TCRC(value)))
#define CRC_BWR_CTRLHU_TCRC(base, value) (BME_BFI8(&CRC_CTRLHU_REG(base), ((uint8_t)(value) << CRC_CTRLHU_TCRC_SHIFT), CRC_CTRLHU_TCRC_SHIFT, CRC_CTRLHU_TCRC_WIDTH))
/*@}*/

/*!
 * @name Register CRC_CTRLHU, field WAS[1] (RW)
 *
 * Values:
 * - 0 - Writes to CRC data register are data values.
 * - 1 - Writes to CRC data reguster are seed values.
 */
/*@{*/
/*! @brief Read current value of the CRC_CTRLHU_WAS field. */
#define CRC_RD_CTRLHU_WAS(base) ((CRC_CTRLHU_REG(base) & CRC_CTRLHU_WAS_MASK) >> CRC_CTRLHU_WAS_SHIFT)
#define CRC_BRD_CTRLHU_WAS(base) (BME_UBFX8(&CRC_CTRLHU_REG(base), CRC_CTRLHU_WAS_SHIFT, CRC_CTRLHU_WAS_WIDTH))

/*! @brief Set the WAS field to a new value. */
#define CRC_WR_CTRLHU_WAS(base, value) (CRC_RMW_CTRLHU(base, CRC_CTRLHU_WAS_MASK, CRC_CTRLHU_WAS(value)))
#define CRC_BWR_CTRLHU_WAS(base, value) (BME_BFI8(&CRC_CTRLHU_REG(base), ((uint8_t)(value) << CRC_CTRLHU_WAS_SHIFT), CRC_CTRLHU_WAS_SHIFT, CRC_CTRLHU_WAS_WIDTH))
/*@}*/

/*!
 * @name Register CRC_CTRLHU, field FXOR[2] (RW)
 *
 * Values:
 * - 0 - No XOR on reading.
 * - 1 - Invert or complement the read value of CRC data register.
 */
/*@{*/
/*! @brief Read current value of the CRC_CTRLHU_FXOR field. */
#define CRC_RD_CTRLHU_FXOR(base) ((CRC_CTRLHU_REG(base) & CRC_CTRLHU_FXOR_MASK) >> CRC_CTRLHU_FXOR_SHIFT)
#define CRC_BRD_CTRLHU_FXOR(base) (BME_UBFX8(&CRC_CTRLHU_REG(base), CRC_CTRLHU_FXOR_SHIFT, CRC_CTRLHU_FXOR_WIDTH))

/*! @brief Set the FXOR field to a new value. */
#define CRC_WR_CTRLHU_FXOR(base, value) (CRC_RMW_CTRLHU(base, CRC_CTRLHU_FXOR_MASK, CRC_CTRLHU_FXOR(value)))
#define CRC_BWR_CTRLHU_FXOR(base, value) (BME_BFI8(&CRC_CTRLHU_REG(base), ((uint8_t)(value) << CRC_CTRLHU_FXOR_SHIFT), CRC_CTRLHU_FXOR_SHIFT, CRC_CTRLHU_FXOR_WIDTH))
/*@}*/

/*!
 * @name Register CRC_CTRLHU, field TOTR[5:4] (RW)
 *
 * Values:
 * - 00 - No Transposition.
 * - 01 - Bits in bytes are transposed, bytes are not transposed.
 * - 10 - Both bits in bytes and bytes are transposed.
 * - 11 - Only bytes are transposed; no bits in a byte are transposed.
 */
/*@{*/
/*! @brief Read current value of the CRC_CTRLHU_TOTR field. */
#define CRC_RD_CTRLHU_TOTR(base) ((CRC_CTRLHU_REG(base) & CRC_CTRLHU_TOTR_MASK) >> CRC_CTRLHU_TOTR_SHIFT)
#define CRC_BRD_CTRLHU_TOTR(base) (BME_UBFX8(&CRC_CTRLHU_REG(base), CRC_CTRLHU_TOTR_SHIFT, CRC_CTRLHU_TOTR_WIDTH))

/*! @brief Set the TOTR field to a new value. */
#define CRC_WR_CTRLHU_TOTR(base, value) (CRC_RMW_CTRLHU(base, CRC_CTRLHU_TOTR_MASK, CRC_CTRLHU_TOTR(value)))
#define CRC_BWR_CTRLHU_TOTR(base, value) (BME_BFI8(&CRC_CTRLHU_REG(base), ((uint8_t)(value) << CRC_CTRLHU_TOTR_SHIFT), CRC_CTRLHU_TOTR_SHIFT, CRC_CTRLHU_TOTR_WIDTH))
/*@}*/

/*!
 * @name Register CRC_CTRLHU, field TOT[7:6] (RW)
 *
 * Values:
 * - 00 - No Transposition.
 * - 01 - Bits in bytes are transposed, bytes are not transposed.
 * - 10 - Both bits in bytes and bytes are transposed.
 * - 11 - Only bytes are transposed; no bits in a byte are transposed.
 */
/*@{*/
/*! @brief Read current value of the CRC_CTRLHU_TOT field. */
#define CRC_RD_CTRLHU_TOT(base) ((CRC_CTRLHU_REG(base) & CRC_CTRLHU_TOT_MASK) >> CRC_CTRLHU_TOT_SHIFT)
#define CRC_BRD_CTRLHU_TOT(base) (BME_UBFX8(&CRC_CTRLHU_REG(base), CRC_CTRLHU_TOT_SHIFT, CRC_CTRLHU_TOT_WIDTH))

/*! @brief Set the TOT field to a new value. */
#define CRC_WR_CTRLHU_TOT(base, value) (CRC_RMW_CTRLHU(base, CRC_CTRLHU_TOT_MASK, CRC_CTRLHU_TOT(value)))
#define CRC_BWR_CTRLHU_TOT(base, value) (BME_BFI8(&CRC_CTRLHU_REG(base), ((uint8_t)(value) << CRC_CTRLHU_TOT_SHIFT), CRC_CTRLHU_TOT_SHIFT, CRC_CTRLHU_TOT_WIDTH))
/*@}*/

/*
 * MKL27Z644 DMA
 *
 * DMA Controller
 *
 * Registers defined in this header file:
 * - DMA_SAR - Source Address Register
 * - DMA_DAR - Destination Address Register
 * - DMA_DSR - DMA_DSR0 register.
 * - DMA_DSR_BCR - DMA Status Register / Byte Count Register
 * - DMA_DCR - DMA Control Register
 */

#define DMA_INSTANCE_COUNT (1U) /*!< Number of instances of the DMA module. */
#define DMA_IDX (0U) /*!< Instance number for DMA. */

/*******************************************************************************
 * DMA_SAR - Source Address Register
 ******************************************************************************/

/*!
 * @brief DMA_SAR - Source Address Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * For this register: Only 32-bit writes are allowed. 16-bit and 8-bit writes
 * result in a bus error. Only several values are allowed to be written to bits
 * 31-20 of this register, see the value list in the field description. A write of
 * any other value to these bits causes a configuration error when the channel
 * starts to execute. For more information about the configuration error, see the
 * description of the CEConfiguration Error field of DSR.
 */
/*!
 * @name Constants and macros for entire DMA_SAR register
 */
/*@{*/
#define DMA_RD_SAR(base, index)  (DMA_SAR_REG(base, index))
#define DMA_WR_SAR(base, index, value) (DMA_SAR_REG(base, index) = (value))
#define DMA_RMW_SAR(base, index, mask, value) (DMA_WR_SAR(base, index, (DMA_RD_SAR(base, index) & ~(mask)) | (value)))
#define DMA_SET_SAR(base, index, value) (BME_OR32(&DMA_SAR_REG(base, index), (uint32_t)(value)))
#define DMA_CLR_SAR(base, index, value) (BME_AND32(&DMA_SAR_REG(base, index), (uint32_t)(~(value))))
#define DMA_TOG_SAR(base, index, value) (BME_XOR32(&DMA_SAR_REG(base, index), (uint32_t)(value)))
/*@}*/

/*******************************************************************************
 * DMA_DAR - Destination Address Register
 ******************************************************************************/

/*!
 * @brief DMA_DAR - Destination Address Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * For this register: Only 32-bit writes are allowed. 16-bit and 8-bit writes
 * result in a bus error. Only several values are allowed to be written to bits
 * 31-20 of this register, see the value list in the field description. A write of
 * any other value to these bits causes a configuration error when the channel
 * starts to execute. For more information about the configuration error, see the
 * description of the CEConfiguration Error field of DSR.
 */
/*!
 * @name Constants and macros for entire DMA_DAR register
 */
/*@{*/
#define DMA_RD_DAR(base, index)  (DMA_DAR_REG(base, index))
#define DMA_WR_DAR(base, index, value) (DMA_DAR_REG(base, index) = (value))
#define DMA_RMW_DAR(base, index, mask, value) (DMA_WR_DAR(base, index, (DMA_RD_DAR(base, index) & ~(mask)) | (value)))
#define DMA_SET_DAR(base, index, value) (BME_OR32(&DMA_DAR_REG(base, index), (uint32_t)(value)))
#define DMA_CLR_DAR(base, index, value) (BME_AND32(&DMA_DAR_REG(base, index), (uint32_t)(~(value))))
#define DMA_TOG_DAR(base, index, value) (BME_XOR32(&DMA_DAR_REG(base, index), (uint32_t)(value)))
/*@}*/

/*******************************************************************************
 * DMA_DSR_BCR - DMA Status Register / Byte Count Register
 ******************************************************************************/

/*!
 * @brief DMA_DSR_BCR - DMA Status Register / Byte Count Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * DSR and BCR are two logical registers that occupy one 32-bit address. DSRn
 * occupies bits 31-24, and BCRn occupies bits 23-0. DSRn contains flags indicating
 * the channel status, and BCRn contains the number of bytes yet to be
 * transferred for a given block. On the successful completion of the write transfer, BCRn
 * decrements by 1, 2, or 4 for 8-bit, 16-bit, or 32-bit accesses, respectively.
 * BCRn is cleared if a 1 is written to DSR[DONE]. In response to an event, the
 * DMA controller writes to the appropriate DSRn bit. Only a write to DSRn[DONE]
 * results in action. DSRn[DONE] is set when the block transfer is complete. When
 * a transfer sequence is initiated and BCRn[BCR] is not a multiple of 4 or 2
 * when the DMA is configured for 32-bit or 16-bit transfers, respectively,
 * DSRn[CE] is set and no transfer occurs.
 */
/*!
 * @name Constants and macros for entire DMA_DSR_BCR register
 */
/*@{*/
#define DMA_RD_DSR_BCR(base, index) (DMA_DSR_BCR_REG(base, index))
#define DMA_WR_DSR_BCR(base, index, value) (DMA_DSR_BCR_REG(base, index) = (value))
#define DMA_RMW_DSR_BCR(base, index, mask, value) (DMA_WR_DSR_BCR(base, index, (DMA_RD_DSR_BCR(base, index) & ~(mask)) | (value)))
#define DMA_SET_DSR_BCR(base, index, value) (BME_OR32(&DMA_DSR_BCR_REG(base, index), (uint32_t)(value)))
#define DMA_CLR_DSR_BCR(base, index, value) (BME_AND32(&DMA_DSR_BCR_REG(base, index), (uint32_t)(~(value))))
#define DMA_TOG_DSR_BCR(base, index, value) (BME_XOR32(&DMA_DSR_BCR_REG(base, index), (uint32_t)(value)))
/*@}*/

/*
 * Constants & macros for individual DMA_DSR_BCR bitfields
 */

/*!
 * @name Register DMA_DSR_BCR, field BCR[23:0] (RW)
 *
 * This field contains the number of bytes yet to be transferred for a given
 * block. BCR must be written with a value equal to or less than 0F_FFFFh. After
 * being written with a value in this range, bits 23-20 of BCR read back as 0000b. A
 * write to BCR of a value greater than 0F_FFFFh causes a configuration error
 * when the channel starts to execute. After being written with a value in this
 * range, bits 23-20 of BCR read back as 0001b.
 */
/*@{*/
/*! @brief Read current value of the DMA_DSR_BCR_BCR field. */
#define DMA_RD_DSR_BCR_BCR(base, index) ((DMA_DSR_BCR_REG(base, index) & DMA_DSR_BCR_BCR_MASK) >> DMA_DSR_BCR_BCR_SHIFT)
#define DMA_BRD_DSR_BCR_BCR(base, index) (DMA_RD_DSR_BCR_BCR(base, index))

/*! @brief Set the BCR field to a new value. */
#define DMA_WR_DSR_BCR_BCR(base, index, value) (DMA_RMW_DSR_BCR(base, index, (DMA_DSR_BCR_BCR_MASK | DMA_DSR_BCR_DONE_MASK), DMA_DSR_BCR_BCR(value)))
#define DMA_BWR_DSR_BCR_BCR(base, index, value) (DMA_WR_DSR_BCR_BCR(base, index, value))
/*@}*/

/*!
 * @name Register DMA_DSR_BCR, field DONE[24] (W1C)
 *
 * Set when all DMA controller transactions complete as determined by transfer
 * count, or based on error conditions. When BCR reaches 0, DONE is set when the
 * final transfer completes successfully. DONE can also be used to abort a
 * transfer by resetting the status bits. When a transfer completes, software must clear
 * DONE before reprogramming the DMA.
 *
 * Values:
 * - 0 - DMA transfer is not yet complete. Writing a 0 has no effect.
 * - 1 - DMA transfer completed. Writing a 1 to this bit clears all DMA status
 *     bits and should be used in an interrupt service routine to clear the DMA
 *     interrupt and error bits.
 */
/*@{*/
/*! @brief Read current value of the DMA_DSR_BCR_DONE field. */
#define DMA_RD_DSR_BCR_DONE(base, index) ((DMA_DSR_BCR_REG(base, index) & DMA_DSR_BCR_DONE_MASK) >> DMA_DSR_BCR_DONE_SHIFT)
#define DMA_BRD_DSR_BCR_DONE(base, index) (BME_UBFX32(&DMA_DSR_BCR_REG(base, index), DMA_DSR_BCR_DONE_SHIFT, DMA_DSR_BCR_DONE_WIDTH))

/*! @brief Set the DONE field to a new value. */
#define DMA_WR_DSR_BCR_DONE(base, index, value) (DMA_RMW_DSR_BCR(base, index, DMA_DSR_BCR_DONE_MASK, DMA_DSR_BCR_DONE(value)))
#define DMA_BWR_DSR_BCR_DONE(base, index, value) (BME_BFI32(&DMA_DSR_BCR_REG(base, index), ((uint32_t)(value) << DMA_DSR_BCR_DONE_SHIFT), DMA_DSR_BCR_DONE_SHIFT, DMA_DSR_BCR_DONE_WIDTH))
/*@}*/

/*!
 * @name Register DMA_DSR_BCR, field BSY[25] (RO)
 *
 * Values:
 * - 0 - DMA channel is inactive. Cleared when the DMA has finished the last
 *     transaction.
 * - 1 - BSY is set the first time the channel is enabled after a transfer is
 *     initiated.
 */
/*@{*/
/*! @brief Read current value of the DMA_DSR_BCR_BSY field. */
#define DMA_RD_DSR_BCR_BSY(base, index) ((DMA_DSR_BCR_REG(base, index) & DMA_DSR_BCR_BSY_MASK) >> DMA_DSR_BCR_BSY_SHIFT)
#define DMA_BRD_DSR_BCR_BSY(base, index) (BME_UBFX32(&DMA_DSR_BCR_REG(base, index), DMA_DSR_BCR_BSY_SHIFT, DMA_DSR_BCR_BSY_WIDTH))
/*@}*/

/*!
 * @name Register DMA_DSR_BCR, field REQ[26] (RO)
 *
 * Values:
 * - 0 - No request is pending or the channel is currently active. Cleared when
 *     the channel is selected.
 * - 1 - The DMA channel has a transfer remaining and the channel is not
 *     selected.
 */
/*@{*/
/*! @brief Read current value of the DMA_DSR_BCR_REQ field. */
#define DMA_RD_DSR_BCR_REQ(base, index) ((DMA_DSR_BCR_REG(base, index) & DMA_DSR_BCR_REQ_MASK) >> DMA_DSR_BCR_REQ_SHIFT)
#define DMA_BRD_DSR_BCR_REQ(base, index) (BME_UBFX32(&DMA_DSR_BCR_REG(base, index), DMA_DSR_BCR_REQ_SHIFT, DMA_DSR_BCR_REQ_WIDTH))
/*@}*/

/*!
 * @name Register DMA_DSR_BCR, field BED[28] (RO)
 *
 * BED is cleared at hardware reset or by writing a 1 to DONE.
 *
 * Values:
 * - 0 - No bus error occurred.
 * - 1 - The DMA channel terminated with a bus error during the write portion of
 *     a transfer.
 */
/*@{*/
/*! @brief Read current value of the DMA_DSR_BCR_BED field. */
#define DMA_RD_DSR_BCR_BED(base, index) ((DMA_DSR_BCR_REG(base, index) & DMA_DSR_BCR_BED_MASK) >> DMA_DSR_BCR_BED_SHIFT)
#define DMA_BRD_DSR_BCR_BED(base, index) (BME_UBFX32(&DMA_DSR_BCR_REG(base, index), DMA_DSR_BCR_BED_SHIFT, DMA_DSR_BCR_BED_WIDTH))
/*@}*/

/*!
 * @name Register DMA_DSR_BCR, field BES[29] (RO)
 *
 * BES is cleared at hardware reset or by writing a 1 to DONE.
 *
 * Values:
 * - 0 - No bus error occurred.
 * - 1 - The DMA channel terminated with a bus error during the read portion of
 *     a transfer.
 */
/*@{*/
/*! @brief Read current value of the DMA_DSR_BCR_BES field. */
#define DMA_RD_DSR_BCR_BES(base, index) ((DMA_DSR_BCR_REG(base, index) & DMA_DSR_BCR_BES_MASK) >> DMA_DSR_BCR_BES_SHIFT)
#define DMA_BRD_DSR_BCR_BES(base, index) (BME_UBFX32(&DMA_DSR_BCR_REG(base, index), DMA_DSR_BCR_BES_SHIFT, DMA_DSR_BCR_BES_WIDTH))
/*@}*/

/*!
 * @name Register DMA_DSR_BCR, field CE[30] (RO)
 *
 * Any of the following conditions causes a configuration error: BCR, SAR, or
 * DAR does not match the requested transfer size. A value greater than 0F_FFFFh is
 * written to BCR. Bits 31-20 of SAR or DAR are written with a value other than
 * one of the allowed values. See SARSAR and DARDAR . SSIZE or DSIZE is set to an
 * unsupported value. BCR equals 0 when the DMA receives a start condition. CE
 * is cleared at hardware reset or by writing a 1 to DONE.
 *
 * Values:
 * - 0 - No configuration error exists.
 * - 1 - A configuration error has occurred.
 */
/*@{*/
/*! @brief Read current value of the DMA_DSR_BCR_CE field. */
#define DMA_RD_DSR_BCR_CE(base, index) ((DMA_DSR_BCR_REG(base, index) & DMA_DSR_BCR_CE_MASK) >> DMA_DSR_BCR_CE_SHIFT)
#define DMA_BRD_DSR_BCR_CE(base, index) (BME_UBFX32(&DMA_DSR_BCR_REG(base, index), DMA_DSR_BCR_CE_SHIFT, DMA_DSR_BCR_CE_WIDTH))
/*@}*/

/*******************************************************************************
 * DMA_DSR - DMA_DSR0 register.
 ******************************************************************************/

/*!
 * @brief DMA_DSR - DMA_DSR0 register. (RW)
 *
 * Reset value: 0x00U
 */
/*!
 * @name Constants and macros for entire DMA_DSR register
 */
/*@{*/
#define DMA_RD_DSR(base, index)  (DMA_DSR_REG(base, index))
#define DMA_WR_DSR(base, index, value) (DMA_DSR_REG(base, index) = (value))
#define DMA_RMW_DSR(base, index, mask, value) (DMA_WR_DSR(base, index, (DMA_RD_DSR(base, index) & ~(mask)) | (value)))
#define DMA_SET_DSR(base, index, value) (BME_OR8(&DMA_DSR_REG(base, index), (uint8_t)(value)))
#define DMA_CLR_DSR(base, index, value) (BME_AND8(&DMA_DSR_REG(base, index), (uint8_t)(~(value))))
#define DMA_TOG_DSR(base, index, value) (BME_XOR8(&DMA_DSR_REG(base, index), (uint8_t)(value)))
/*@}*/

/*******************************************************************************
 * DMA_DCR - DMA Control Register
 ******************************************************************************/

/*!
 * @brief DMA_DCR - DMA Control Register (RW)
 *
 * Reset value: 0x00000000U
 */
/*!
 * @name Constants and macros for entire DMA_DCR register
 */
/*@{*/
#define DMA_RD_DCR(base, index)  (DMA_DCR_REG(base, index))
#define DMA_WR_DCR(base, index, value) (DMA_DCR_REG(base, index) = (value))
#define DMA_RMW_DCR(base, index, mask, value) (DMA_WR_DCR(base, index, (DMA_RD_DCR(base, index) & ~(mask)) | (value)))
#define DMA_SET_DCR(base, index, value) (BME_OR32(&DMA_DCR_REG(base, index), (uint32_t)(value)))
#define DMA_CLR_DCR(base, index, value) (BME_AND32(&DMA_DCR_REG(base, index), (uint32_t)(~(value))))
#define DMA_TOG_DCR(base, index, value) (BME_XOR32(&DMA_DCR_REG(base, index), (uint32_t)(value)))
/*@}*/

/*
 * Constants & macros for individual DMA_DCR bitfields
 */

/*!
 * @name Register DMA_DCR, field LCH2[1:0] (RW)
 *
 * Indicates the DMA channel assigned as link channel 2. The link channel number
 * cannot be the same as the currently executing channel, and generates a
 * configuration error if this is attempted (DSRn[CE] is set).
 *
 * Values:
 * - 00 - DMA Channel 0
 * - 01 - DMA Channel 1
 * - 10 - DMA Channel 2
 * - 11 - DMA Channel 3
 */
/*@{*/
/*! @brief Read current value of the DMA_DCR_LCH2 field. */
#define DMA_RD_DCR_LCH2(base, index) ((DMA_DCR_REG(base, index) & DMA_DCR_LCH2_MASK) >> DMA_DCR_LCH2_SHIFT)
#define DMA_BRD_DCR_LCH2(base, index) (BME_UBFX32(&DMA_DCR_REG(base, index), DMA_DCR_LCH2_SHIFT, DMA_DCR_LCH2_WIDTH))

/*! @brief Set the LCH2 field to a new value. */
#define DMA_WR_DCR_LCH2(base, index, value) (DMA_RMW_DCR(base, index, DMA_DCR_LCH2_MASK, DMA_DCR_LCH2(value)))
#define DMA_BWR_DCR_LCH2(base, index, value) (BME_BFI32(&DMA_DCR_REG(base, index), ((uint32_t)(value) << DMA_DCR_LCH2_SHIFT), DMA_DCR_LCH2_SHIFT, DMA_DCR_LCH2_WIDTH))
/*@}*/

/*!
 * @name Register DMA_DCR, field LCH1[3:2] (RW)
 *
 * Indicates the DMA channel assigned as link channel 1. The link channel number
 * cannot be the same as the currently executing channel, and generates a
 * configuration error if this is attempted (DSRn[CE] is set).
 *
 * Values:
 * - 00 - DMA Channel 0
 * - 01 - DMA Channel 1
 * - 10 - DMA Channel 2
 * - 11 - DMA Channel 3
 */
/*@{*/
/*! @brief Read current value of the DMA_DCR_LCH1 field. */
#define DMA_RD_DCR_LCH1(base, index) ((DMA_DCR_REG(base, index) & DMA_DCR_LCH1_MASK) >> DMA_DCR_LCH1_SHIFT)
#define DMA_BRD_DCR_LCH1(base, index) (BME_UBFX32(&DMA_DCR_REG(base, index), DMA_DCR_LCH1_SHIFT, DMA_DCR_LCH1_WIDTH))

/*! @brief Set the LCH1 field to a new value. */
#define DMA_WR_DCR_LCH1(base, index, value) (DMA_RMW_DCR(base, index, DMA_DCR_LCH1_MASK, DMA_DCR_LCH1(value)))
#define DMA_BWR_DCR_LCH1(base, index, value) (BME_BFI32(&DMA_DCR_REG(base, index), ((uint32_t)(value) << DMA_DCR_LCH1_SHIFT), DMA_DCR_LCH1_SHIFT, DMA_DCR_LCH1_WIDTH))
/*@}*/

/*!
 * @name Register DMA_DCR, field LINKCC[5:4] (RW)
 *
 * Allows DMA channels to have their transfers linked. The current DMA channel
 * triggers a DMA request to the linked channels (LCH1 or LCH2) depending on the
 * condition described by the LINKCC bits. If not in cycle steal mode (DCRn[CS]=0)
 * and LINKCC equals 01 or 10, no link to LCH1 occurs. If LINKCC equals 01, a
 * link to LCH1 is created after each cycle-steal transfer performed by the current
 * DMA channel is completed. As the last cycle-steal is performed and the BCR
 * reaches zero, then the link to LCH1 is closed and a link to LCH2 is created.
 *
 * Values:
 * - 00 - No channel-to-channel linking
 * - 01 - Perform a link to channel LCH1 after each cycle-steal transfer
 *     followed by a link to LCH2 after the BCR decrements to 0.
 * - 10 - Perform a link to channel LCH1 after each cycle-steal transfer
 * - 11 - Perform a link to channel LCH1 after the BCR decrements to 0.
 */
/*@{*/
/*! @brief Read current value of the DMA_DCR_LINKCC field. */
#define DMA_RD_DCR_LINKCC(base, index) ((DMA_DCR_REG(base, index) & DMA_DCR_LINKCC_MASK) >> DMA_DCR_LINKCC_SHIFT)
#define DMA_BRD_DCR_LINKCC(base, index) (BME_UBFX32(&DMA_DCR_REG(base, index), DMA_DCR_LINKCC_SHIFT, DMA_DCR_LINKCC_WIDTH))

/*! @brief Set the LINKCC field to a new value. */
#define DMA_WR_DCR_LINKCC(base, index, value) (DMA_RMW_DCR(base, index, DMA_DCR_LINKCC_MASK, DMA_DCR_LINKCC(value)))
#define DMA_BWR_DCR_LINKCC(base, index, value) (BME_BFI32(&DMA_DCR_REG(base, index), ((uint32_t)(value) << DMA_DCR_LINKCC_SHIFT), DMA_DCR_LINKCC_SHIFT, DMA_DCR_LINKCC_WIDTH))
/*@}*/

/*!
 * @name Register DMA_DCR, field D_REQ[7] (RW)
 *
 * DMA hardware automatically clears the corresponding DCRn[ERQ] bit when the
 * byte count register reaches 0.
 *
 * Values:
 * - 0 - ERQ bit is not affected.
 * - 1 - ERQ bit is cleared when the BCR is exhausted.
 */
/*@{*/
/*! @brief Read current value of the DMA_DCR_D_REQ field. */
#define DMA_RD_DCR_D_REQ(base, index) ((DMA_DCR_REG(base, index) & DMA_DCR_D_REQ_MASK) >> DMA_DCR_D_REQ_SHIFT)
#define DMA_BRD_DCR_D_REQ(base, index) (BME_UBFX32(&DMA_DCR_REG(base, index), DMA_DCR_D_REQ_SHIFT, DMA_DCR_D_REQ_WIDTH))

/*! @brief Set the D_REQ field to a new value. */
#define DMA_WR_DCR_D_REQ(base, index, value) (DMA_RMW_DCR(base, index, DMA_DCR_D_REQ_MASK, DMA_DCR_D_REQ(value)))
#define DMA_BWR_DCR_D_REQ(base, index, value) (BME_BFI32(&DMA_DCR_REG(base, index), ((uint32_t)(value) << DMA_DCR_D_REQ_SHIFT), DMA_DCR_D_REQ_SHIFT, DMA_DCR_D_REQ_WIDTH))
/*@}*/

/*!
 * @name Register DMA_DCR, field DMOD[11:8] (RW)
 *
 * Defines the size of the destination data circular buffer used by the DMA
 * Controller. If enabled (DMOD value is non-zero), the buffer base address is
 * located on a boundary of the buffer size. The value of this boundary depends on the
 * initial destination address (DAR). The base address should be aligned to a
 * 0-modulo-(circular buffer size) boundary. Misaligned buffers are not possible.
 * The boundary is forced to the value determined by the upper address bits in the
 * field selection.
 *
 * Values:
 * - 0000 - Buffer disabled
 * - 0001 - Circular buffer size is 16 bytes
 * - 0010 - Circular buffer size is 32 bytes
 * - 0011 - Circular buffer size is 64 bytes
 * - 0100 - Circular buffer size is 128 bytes
 * - 0101 - Circular buffer size is 256 bytes
 * - 0110 - Circular buffer size is 512 bytes
 * - 0111 - Circular buffer size is 1 KB
 * - 1000 - Circular buffer size is 2 KB
 * - 1001 - Circular buffer size is 4 KB
 * - 1010 - Circular buffer size is 8 KB
 * - 1011 - Circular buffer size is 16 KB
 * - 1100 - Circular buffer size is 32 KB
 * - 1101 - Circular buffer size is 64 KB
 * - 1110 - Circular buffer size is 128 KB
 * - 1111 - Circular buffer size is 256 KB
 */
/*@{*/
/*! @brief Read current value of the DMA_DCR_DMOD field. */
#define DMA_RD_DCR_DMOD(base, index) ((DMA_DCR_REG(base, index) & DMA_DCR_DMOD_MASK) >> DMA_DCR_DMOD_SHIFT)
#define DMA_BRD_DCR_DMOD(base, index) (BME_UBFX32(&DMA_DCR_REG(base, index), DMA_DCR_DMOD_SHIFT, DMA_DCR_DMOD_WIDTH))

/*! @brief Set the DMOD field to a new value. */
#define DMA_WR_DCR_DMOD(base, index, value) (DMA_RMW_DCR(base, index, DMA_DCR_DMOD_MASK, DMA_DCR_DMOD(value)))
#define DMA_BWR_DCR_DMOD(base, index, value) (BME_BFI32(&DMA_DCR_REG(base, index), ((uint32_t)(value) << DMA_DCR_DMOD_SHIFT), DMA_DCR_DMOD_SHIFT, DMA_DCR_DMOD_WIDTH))
/*@}*/

/*!
 * @name Register DMA_DCR, field SMOD[15:12] (RW)
 *
 * Defines the size of the source data circular buffer used by the DMA
 * Controller. If enabled (SMOD is non-zero), the buffer base address is located on a
 * boundary of the buffer size. The value of this boundary is based upon the initial
 * source address (SAR). The base address should be aligned to a
 * 0-modulo-(circular buffer size) boundary. Misaligned buffers are not possible. The boundary is
 * forced to the value determined by the upper address bits in the field
 * selection.
 *
 * Values:
 * - 0000 - Buffer disabled
 * - 0001 - Circular buffer size is 16 bytes.
 * - 0010 - Circular buffer size is 32 bytes.
 * - 0011 - Circular buffer size is 64 bytes.
 * - 0100 - Circular buffer size is 128 bytes.
 * - 0101 - Circular buffer size is 256 bytes.
 * - 0110 - Circular buffer size is 512 bytes.
 * - 0111 - Circular buffer size is 1 KB.
 * - 1000 - Circular buffer size is 2 KB.
 * - 1001 - Circular buffer size is 4 KB.
 * - 1010 - Circular buffer size is 8 KB.
 * - 1011 - Circular buffer size is 16 KB.
 * - 1100 - Circular buffer size is 32 KB.
 * - 1101 - Circular buffer size is 64 KB.
 * - 1110 - Circular buffer size is 128 KB.
 * - 1111 - Circular buffer size is 256 KB.
 */
/*@{*/
/*! @brief Read current value of the DMA_DCR_SMOD field. */
#define DMA_RD_DCR_SMOD(base, index) ((DMA_DCR_REG(base, index) & DMA_DCR_SMOD_MASK) >> DMA_DCR_SMOD_SHIFT)
#define DMA_BRD_DCR_SMOD(base, index) (BME_UBFX32(&DMA_DCR_REG(base, index), DMA_DCR_SMOD_SHIFT, DMA_DCR_SMOD_WIDTH))

/*! @brief Set the SMOD field to a new value. */
#define DMA_WR_DCR_SMOD(base, index, value) (DMA_RMW_DCR(base, index, DMA_DCR_SMOD_MASK, DMA_DCR_SMOD(value)))
#define DMA_BWR_DCR_SMOD(base, index, value) (BME_BFI32(&DMA_DCR_REG(base, index), ((uint32_t)(value) << DMA_DCR_SMOD_SHIFT), DMA_DCR_SMOD_SHIFT, DMA_DCR_SMOD_WIDTH))
/*@}*/

/*!
 * @name Register DMA_DCR, field START[16] (WORZ)
 *
 * Values:
 * - 0 - DMA inactive
 * - 1 - The DMA begins the transfer in accordance to the values in the TCDn.
 *     START is cleared automatically after one module clock and always reads as
 *     logic 0.
 */
/*@{*/
/*! @brief Set the START field to a new value. */
#define DMA_WR_DCR_START(base, index, value) (DMA_RMW_DCR(base, index, DMA_DCR_START_MASK, DMA_DCR_START(value)))
#define DMA_BWR_DCR_START(base, index, value) (BME_BFI32(&DMA_DCR_REG(base, index), ((uint32_t)(value) << DMA_DCR_START_SHIFT), DMA_DCR_START_SHIFT, DMA_DCR_START_WIDTH))
/*@}*/

/*!
 * @name Register DMA_DCR, field DSIZE[18:17] (RW)
 *
 * Determines the data size of the destination bus cycle for the DMA controller.
 *
 * Values:
 * - 00 - 32-bit
 * - 01 - 8-bit
 * - 10 - 16-bit
 * - 11 - Reserved (generates a configuration error (DSRn[CE]) if incorrectly
 *     specified at time of channel activation)
 */
/*@{*/
/*! @brief Read current value of the DMA_DCR_DSIZE field. */
#define DMA_RD_DCR_DSIZE(base, index) ((DMA_DCR_REG(base, index) & DMA_DCR_DSIZE_MASK) >> DMA_DCR_DSIZE_SHIFT)
#define DMA_BRD_DCR_DSIZE(base, index) (BME_UBFX32(&DMA_DCR_REG(base, index), DMA_DCR_DSIZE_SHIFT, DMA_DCR_DSIZE_WIDTH))

/*! @brief Set the DSIZE field to a new value. */
#define DMA_WR_DCR_DSIZE(base, index, value) (DMA_RMW_DCR(base, index, DMA_DCR_DSIZE_MASK, DMA_DCR_DSIZE(value)))
#define DMA_BWR_DCR_DSIZE(base, index, value) (BME_BFI32(&DMA_DCR_REG(base, index), ((uint32_t)(value) << DMA_DCR_DSIZE_SHIFT), DMA_DCR_DSIZE_SHIFT, DMA_DCR_DSIZE_WIDTH))
/*@}*/

/*!
 * @name Register DMA_DCR, field DINC[19] (RW)
 *
 * Controls whether the destination address increments after each successful
 * transfer.
 *
 * Values:
 * - 0 - No change to the DAR after a successful transfer.
 * - 1 - The DAR increments by 1, 2, 4 depending upon the size of the transfer.
 */
/*@{*/
/*! @brief Read current value of the DMA_DCR_DINC field. */
#define DMA_RD_DCR_DINC(base, index) ((DMA_DCR_REG(base, index) & DMA_DCR_DINC_MASK) >> DMA_DCR_DINC_SHIFT)
#define DMA_BRD_DCR_DINC(base, index) (BME_UBFX32(&DMA_DCR_REG(base, index), DMA_DCR_DINC_SHIFT, DMA_DCR_DINC_WIDTH))

/*! @brief Set the DINC field to a new value. */
#define DMA_WR_DCR_DINC(base, index, value) (DMA_RMW_DCR(base, index, DMA_DCR_DINC_MASK, DMA_DCR_DINC(value)))
#define DMA_BWR_DCR_DINC(base, index, value) (BME_BFI32(&DMA_DCR_REG(base, index), ((uint32_t)(value) << DMA_DCR_DINC_SHIFT), DMA_DCR_DINC_SHIFT, DMA_DCR_DINC_WIDTH))
/*@}*/

/*!
 * @name Register DMA_DCR, field SSIZE[21:20] (RW)
 *
 * Determines the data size of the source bus cycle for the DMA controller.
 *
 * Values:
 * - 00 - 32-bit
 * - 01 - 8-bit
 * - 10 - 16-bit
 * - 11 - Reserved (generates a configuration error (DSRn[CE]) if incorrectly
 *     specified at time of channel activation)
 */
/*@{*/
/*! @brief Read current value of the DMA_DCR_SSIZE field. */
#define DMA_RD_DCR_SSIZE(base, index) ((DMA_DCR_REG(base, index) & DMA_DCR_SSIZE_MASK) >> DMA_DCR_SSIZE_SHIFT)
#define DMA_BRD_DCR_SSIZE(base, index) (BME_UBFX32(&DMA_DCR_REG(base, index), DMA_DCR_SSIZE_SHIFT, DMA_DCR_SSIZE_WIDTH))

/*! @brief Set the SSIZE field to a new value. */
#define DMA_WR_DCR_SSIZE(base, index, value) (DMA_RMW_DCR(base, index, DMA_DCR_SSIZE_MASK, DMA_DCR_SSIZE(value)))
#define DMA_BWR_DCR_SSIZE(base, index, value) (BME_BFI32(&DMA_DCR_REG(base, index), ((uint32_t)(value) << DMA_DCR_SSIZE_SHIFT), DMA_DCR_SSIZE_SHIFT, DMA_DCR_SSIZE_WIDTH))
/*@}*/

/*!
 * @name Register DMA_DCR, field SINC[22] (RW)
 *
 * Controls whether the source address increments after each successful transfer.
 *
 * Values:
 * - 0 - No change to SAR after a successful transfer.
 * - 1 - The SAR increments by 1, 2, 4 as determined by the transfer size.
 */
/*@{*/
/*! @brief Read current value of the DMA_DCR_SINC field. */
#define DMA_RD_DCR_SINC(base, index) ((DMA_DCR_REG(base, index) & DMA_DCR_SINC_MASK) >> DMA_DCR_SINC_SHIFT)
#define DMA_BRD_DCR_SINC(base, index) (BME_UBFX32(&DMA_DCR_REG(base, index), DMA_DCR_SINC_SHIFT, DMA_DCR_SINC_WIDTH))

/*! @brief Set the SINC field to a new value. */
#define DMA_WR_DCR_SINC(base, index, value) (DMA_RMW_DCR(base, index, DMA_DCR_SINC_MASK, DMA_DCR_SINC(value)))
#define DMA_BWR_DCR_SINC(base, index, value) (BME_BFI32(&DMA_DCR_REG(base, index), ((uint32_t)(value) << DMA_DCR_SINC_SHIFT), DMA_DCR_SINC_SHIFT, DMA_DCR_SINC_WIDTH))
/*@}*/

/*!
 * @name Register DMA_DCR, field EADREQ[23] (RW)
 *
 * Enables the channel to support asynchronous DREQs while the MCU is in Stop
 * mode.
 *
 * Values:
 * - 0 - Disabled
 * - 1 - Enabled
 */
/*@{*/
/*! @brief Read current value of the DMA_DCR_EADREQ field. */
#define DMA_RD_DCR_EADREQ(base, index) ((DMA_DCR_REG(base, index) & DMA_DCR_EADREQ_MASK) >> DMA_DCR_EADREQ_SHIFT)
#define DMA_BRD_DCR_EADREQ(base, index) (BME_UBFX32(&DMA_DCR_REG(base, index), DMA_DCR_EADREQ_SHIFT, DMA_DCR_EADREQ_WIDTH))

/*! @brief Set the EADREQ field to a new value. */
#define DMA_WR_DCR_EADREQ(base, index, value) (DMA_RMW_DCR(base, index, DMA_DCR_EADREQ_MASK, DMA_DCR_EADREQ(value)))
#define DMA_BWR_DCR_EADREQ(base, index, value) (BME_BFI32(&DMA_DCR_REG(base, index), ((uint32_t)(value) << DMA_DCR_EADREQ_SHIFT), DMA_DCR_EADREQ_SHIFT, DMA_DCR_EADREQ_WIDTH))
/*@}*/

/*!
 * @name Register DMA_DCR, field AA[28] (RW)
 *
 * AA and SIZE bits determine whether the source or destination is auto-aligned;
 * that is, transfers are optimized based on the address and size.
 *
 * Values:
 * - 0 - Auto-align disabled
 * - 1 - If SSIZE indicates a transfer no smaller than DSIZE, source accesses
 *     are auto-aligned; otherwise, destination accesses are auto-aligned. Source
 *     alignment takes precedence over destination alignment. If auto-alignment is
 *     enabled, the appropriate address register increments, regardless of DINC
 *     or SINC.
 */
/*@{*/
/*! @brief Read current value of the DMA_DCR_AA field. */
#define DMA_RD_DCR_AA(base, index) ((DMA_DCR_REG(base, index) & DMA_DCR_AA_MASK) >> DMA_DCR_AA_SHIFT)
#define DMA_BRD_DCR_AA(base, index) (BME_UBFX32(&DMA_DCR_REG(base, index), DMA_DCR_AA_SHIFT, DMA_DCR_AA_WIDTH))

/*! @brief Set the AA field to a new value. */
#define DMA_WR_DCR_AA(base, index, value) (DMA_RMW_DCR(base, index, DMA_DCR_AA_MASK, DMA_DCR_AA(value)))
#define DMA_BWR_DCR_AA(base, index, value) (BME_BFI32(&DMA_DCR_REG(base, index), ((uint32_t)(value) << DMA_DCR_AA_SHIFT), DMA_DCR_AA_SHIFT, DMA_DCR_AA_WIDTH))
/*@}*/

/*!
 * @name Register DMA_DCR, field CS[29] (RW)
 *
 * Values:
 * - 0 - DMA continuously makes read/write transfers until the BCR decrements to
 *     0.
 * - 1 - Forces a single read/write transfer per request.
 */
/*@{*/
/*! @brief Read current value of the DMA_DCR_CS field. */
#define DMA_RD_DCR_CS(base, index) ((DMA_DCR_REG(base, index) & DMA_DCR_CS_MASK) >> DMA_DCR_CS_SHIFT)
#define DMA_BRD_DCR_CS(base, index) (BME_UBFX32(&DMA_DCR_REG(base, index), DMA_DCR_CS_SHIFT, DMA_DCR_CS_WIDTH))

/*! @brief Set the CS field to a new value. */
#define DMA_WR_DCR_CS(base, index, value) (DMA_RMW_DCR(base, index, DMA_DCR_CS_MASK, DMA_DCR_CS(value)))
#define DMA_BWR_DCR_CS(base, index, value) (BME_BFI32(&DMA_DCR_REG(base, index), ((uint32_t)(value) << DMA_DCR_CS_SHIFT), DMA_DCR_CS_SHIFT, DMA_DCR_CS_WIDTH))
/*@}*/

/*!
 * @name Register DMA_DCR, field ERQ[30] (RW)
 *
 * Be careful: a collision can occur between START and D_REQ when ERQ is 1.
 *
 * Values:
 * - 0 - Peripheral request is ignored.
 * - 1 - Enables peripheral request to initiate transfer. A software-initiated
 *     request (setting START) is always enabled.
 */
/*@{*/
/*! @brief Read current value of the DMA_DCR_ERQ field. */
#define DMA_RD_DCR_ERQ(base, index) ((DMA_DCR_REG(base, index) & DMA_DCR_ERQ_MASK) >> DMA_DCR_ERQ_SHIFT)
#define DMA_BRD_DCR_ERQ(base, index) (BME_UBFX32(&DMA_DCR_REG(base, index), DMA_DCR_ERQ_SHIFT, DMA_DCR_ERQ_WIDTH))

/*! @brief Set the ERQ field to a new value. */
#define DMA_WR_DCR_ERQ(base, index, value) (DMA_RMW_DCR(base, index, DMA_DCR_ERQ_MASK, DMA_DCR_ERQ(value)))
#define DMA_BWR_DCR_ERQ(base, index, value) (BME_BFI32(&DMA_DCR_REG(base, index), ((uint32_t)(value) << DMA_DCR_ERQ_SHIFT), DMA_DCR_ERQ_SHIFT, DMA_DCR_ERQ_WIDTH))
/*@}*/

/*!
 * @name Register DMA_DCR, field EINT[31] (RW)
 *
 * Determines whether an interrupt is generated by completing a transfer or by
 * the occurrence of an error condition.
 *
 * Values:
 * - 0 - No interrupt is generated.
 * - 1 - Interrupt signal is enabled.
 */
/*@{*/
/*! @brief Read current value of the DMA_DCR_EINT field. */
#define DMA_RD_DCR_EINT(base, index) ((DMA_DCR_REG(base, index) & DMA_DCR_EINT_MASK) >> DMA_DCR_EINT_SHIFT)
#define DMA_BRD_DCR_EINT(base, index) (BME_UBFX32(&DMA_DCR_REG(base, index), DMA_DCR_EINT_SHIFT, DMA_DCR_EINT_WIDTH))

/*! @brief Set the EINT field to a new value. */
#define DMA_WR_DCR_EINT(base, index, value) (DMA_RMW_DCR(base, index, DMA_DCR_EINT_MASK, DMA_DCR_EINT(value)))
#define DMA_BWR_DCR_EINT(base, index, value) (BME_BFI32(&DMA_DCR_REG(base, index), ((uint32_t)(value) << DMA_DCR_EINT_SHIFT), DMA_DCR_EINT_SHIFT, DMA_DCR_EINT_WIDTH))
/*@}*/

/*
 * MKL27Z644 DMAMUX
 *
 * DMA channel multiplexor
 *
 * Registers defined in this header file:
 * - DMAMUX_CHCFG - Channel Configuration register
 */

#define DMAMUX_INSTANCE_COUNT (1U) /*!< Number of instances of the DMAMUX module. */
#define DMAMUX0_IDX (0U) /*!< Instance number for DMAMUX0. */

/*******************************************************************************
 * DMAMUX_CHCFG - Channel Configuration register
 ******************************************************************************/

/*!
 * @brief DMAMUX_CHCFG - Channel Configuration register (RW)
 *
 * Reset value: 0x00U
 *
 * Each of the DMA channels can be independently enabled/disabled and associated
 * with one of the DMA slots (peripheral slots or always-on slots) in the
 * system. Setting multiple CHCFG registers with the same source value will result in
 * unpredictable behavior. This is true, even if a channel is disabled (ENBL==0).
 * Before changing the trigger or source settings, a DMA channel must be disabled
 * via CHCFGn[ENBL].
 */
/*!
 * @name Constants and macros for entire DMAMUX_CHCFG register
 */
/*@{*/
#define DMAMUX_RD_CHCFG(base, index) (DMAMUX_CHCFG_REG(base, index))
#define DMAMUX_WR_CHCFG(base, index, value) (DMAMUX_CHCFG_REG(base, index) = (value))
#define DMAMUX_RMW_CHCFG(base, index, mask, value) (DMAMUX_WR_CHCFG(base, index, (DMAMUX_RD_CHCFG(base, index) & ~(mask)) | (value)))
#define DMAMUX_SET_CHCFG(base, index, value) (BME_OR8(&DMAMUX_CHCFG_REG(base, index), (uint8_t)(value)))
#define DMAMUX_CLR_CHCFG(base, index, value) (BME_AND8(&DMAMUX_CHCFG_REG(base, index), (uint8_t)(~(value))))
#define DMAMUX_TOG_CHCFG(base, index, value) (BME_XOR8(&DMAMUX_CHCFG_REG(base, index), (uint8_t)(value)))
/*@}*/

/*
 * Constants & macros for individual DMAMUX_CHCFG bitfields
 */

/*!
 * @name Register DMAMUX_CHCFG, field SOURCE[5:0] (RW)
 *
 * Specifies which DMA source, if any, is routed to a particular DMA channel.
 * See the chip-specific DMAMUX information for details about the peripherals and
 * their slot numbers.
 */
/*@{*/
/*! @brief Read current value of the DMAMUX_CHCFG_SOURCE field. */
#define DMAMUX_RD_CHCFG_SOURCE(base, index) ((DMAMUX_CHCFG_REG(base, index) & DMAMUX_CHCFG_SOURCE_MASK) >> DMAMUX_CHCFG_SOURCE_SHIFT)
#define DMAMUX_BRD_CHCFG_SOURCE(base, index) (BME_UBFX8(&DMAMUX_CHCFG_REG(base, index), DMAMUX_CHCFG_SOURCE_SHIFT, DMAMUX_CHCFG_SOURCE_WIDTH))

/*! @brief Set the SOURCE field to a new value. */
#define DMAMUX_WR_CHCFG_SOURCE(base, index, value) (DMAMUX_RMW_CHCFG(base, index, DMAMUX_CHCFG_SOURCE_MASK, DMAMUX_CHCFG_SOURCE(value)))
#define DMAMUX_BWR_CHCFG_SOURCE(base, index, value) (BME_BFI8(&DMAMUX_CHCFG_REG(base, index), ((uint8_t)(value) << DMAMUX_CHCFG_SOURCE_SHIFT), DMAMUX_CHCFG_SOURCE_SHIFT, DMAMUX_CHCFG_SOURCE_WIDTH))
/*@}*/

/*!
 * @name Register DMAMUX_CHCFG, field TRIG[6] (RW)
 *
 * Enables the periodic trigger capability for the triggered DMA channel.
 *
 * Values:
 * - 0 - Triggering is disabled. If triggering is disabled and ENBL is set, the
 *     DMA Channel will simply route the specified source to the DMA channel.
 *     (Normal mode)
 * - 1 - Triggering is enabled. If triggering is enabled and ENBL is set, the
 *     DMAMUX is in Periodic Trigger mode.
 */
/*@{*/
/*! @brief Read current value of the DMAMUX_CHCFG_TRIG field. */
#define DMAMUX_RD_CHCFG_TRIG(base, index) ((DMAMUX_CHCFG_REG(base, index) & DMAMUX_CHCFG_TRIG_MASK) >> DMAMUX_CHCFG_TRIG_SHIFT)
#define DMAMUX_BRD_CHCFG_TRIG(base, index) (BME_UBFX8(&DMAMUX_CHCFG_REG(base, index), DMAMUX_CHCFG_TRIG_SHIFT, DMAMUX_CHCFG_TRIG_WIDTH))

/*! @brief Set the TRIG field to a new value. */
#define DMAMUX_WR_CHCFG_TRIG(base, index, value) (DMAMUX_RMW_CHCFG(base, index, DMAMUX_CHCFG_TRIG_MASK, DMAMUX_CHCFG_TRIG(value)))
#define DMAMUX_BWR_CHCFG_TRIG(base, index, value) (BME_BFI8(&DMAMUX_CHCFG_REG(base, index), ((uint8_t)(value) << DMAMUX_CHCFG_TRIG_SHIFT), DMAMUX_CHCFG_TRIG_SHIFT, DMAMUX_CHCFG_TRIG_WIDTH))
/*@}*/

/*!
 * @name Register DMAMUX_CHCFG, field ENBL[7] (RW)
 *
 * Enables the DMA channel.
 *
 * Values:
 * - 0 - DMA channel is disabled. This mode is primarily used during
 *     configuration of the DMAMux. The DMA has separate channel enables/disables, which
 *     should be used to disable or reconfigure a DMA channel.
 * - 1 - DMA channel is enabled
 */
/*@{*/
/*! @brief Read current value of the DMAMUX_CHCFG_ENBL field. */
#define DMAMUX_RD_CHCFG_ENBL(base, index) ((DMAMUX_CHCFG_REG(base, index) & DMAMUX_CHCFG_ENBL_MASK) >> DMAMUX_CHCFG_ENBL_SHIFT)
#define DMAMUX_BRD_CHCFG_ENBL(base, index) (BME_UBFX8(&DMAMUX_CHCFG_REG(base, index), DMAMUX_CHCFG_ENBL_SHIFT, DMAMUX_CHCFG_ENBL_WIDTH))

/*! @brief Set the ENBL field to a new value. */
#define DMAMUX_WR_CHCFG_ENBL(base, index, value) (DMAMUX_RMW_CHCFG(base, index, DMAMUX_CHCFG_ENBL_MASK, DMAMUX_CHCFG_ENBL(value)))
#define DMAMUX_BWR_CHCFG_ENBL(base, index, value) (BME_BFI8(&DMAMUX_CHCFG_REG(base, index), ((uint8_t)(value) << DMAMUX_CHCFG_ENBL_SHIFT), DMAMUX_CHCFG_ENBL_SHIFT, DMAMUX_CHCFG_ENBL_WIDTH))
/*@}*/

/*
 * MKL27Z644 FLEXIO
 *
 * The FLEXIO Memory Map/Register Definition can be found here.
 *
 * Registers defined in this header file:
 * - FLEXIO_VERID - Version ID Register
 * - FLEXIO_PARAM - Parameter Register
 * - FLEXIO_CTRL - FlexIO Control Register
 * - FLEXIO_SHIFTSTAT - Shifter Status Register
 * - FLEXIO_SHIFTERR - Shifter Error Register
 * - FLEXIO_TIMSTAT - Timer Status Register
 * - FLEXIO_SHIFTSIEN - Shifter Status Interrupt Enable
 * - FLEXIO_SHIFTEIEN - Shifter Error Interrupt Enable
 * - FLEXIO_TIMIEN - Timer Interrupt Enable Register
 * - FLEXIO_SHIFTSDEN - Shifter Status DMA Enable
 * - FLEXIO_SHIFTCTL - Shifter Control N Register
 * - FLEXIO_SHIFTCFG - Shifter Configuration N Register
 * - FLEXIO_SHIFTBUF - Shifter Buffer N Register
 * - FLEXIO_SHIFTBUFBIS - Shifter Buffer N Bit Swapped Register
 * - FLEXIO_SHIFTBUFBYS - Shifter Buffer N Byte Swapped Register
 * - FLEXIO_SHIFTBUFBBS - Shifter Buffer N Bit Byte Swapped Register
 * - FLEXIO_TIMCTL - Timer Control N Register
 * - FLEXIO_TIMCFG - Timer Configuration N Register
 * - FLEXIO_TIMCMP - Timer Compare N Register
 */

#define FLEXIO_INSTANCE_COUNT (1U) /*!< Number of instances of the FLEXIO module. */
#define FLEXIO_IDX (0U) /*!< Instance number for FLEXIO. */

/*******************************************************************************
 * FLEXIO_VERID - Version ID Register
 ******************************************************************************/

/*!
 * @brief FLEXIO_VERID - Version ID Register (RO)
 *
 * Reset value: 0x01000000U
 *
 * .
 */
/*!
 * @name Constants and macros for entire FLEXIO_VERID register
 */
/*@{*/
#define FLEXIO_RD_VERID(base)    (FLEXIO_VERID_REG(base))
/*@}*/

/*
 * Constants & macros for individual FLEXIO_VERID bitfields
 */

/*!
 * @name Register FLEXIO_VERID, field FEATURE[15:0] (RO)
 *
 * This read only field returns the feature set number.
 *
 * Values:
 * - 0 - Standard features implemented.
 * - 1 - Supports state, logic and parallel modes.
 */
/*@{*/
/*! @brief Read current value of the FLEXIO_VERID_FEATURE field. */
#define FLEXIO_RD_VERID_FEATURE(base) ((FLEXIO_VERID_REG(base) & FLEXIO_VERID_FEATURE_MASK) >> FLEXIO_VERID_FEATURE_SHIFT)
#define FLEXIO_BRD_VERID_FEATURE(base) (BME_UBFX32(&FLEXIO_VERID_REG(base), FLEXIO_VERID_FEATURE_SHIFT, FLEXIO_VERID_FEATURE_WIDTH))
/*@}*/

/*!
 * @name Register FLEXIO_VERID, field MINOR[23:16] (RO)
 *
 * This read only field returns the minor version number for the module
 * specification.
 */
/*@{*/
/*! @brief Read current value of the FLEXIO_VERID_MINOR field. */
#define FLEXIO_RD_VERID_MINOR(base) ((FLEXIO_VERID_REG(base) & FLEXIO_VERID_MINOR_MASK) >> FLEXIO_VERID_MINOR_SHIFT)
#define FLEXIO_BRD_VERID_MINOR(base) (BME_UBFX32(&FLEXIO_VERID_REG(base), FLEXIO_VERID_MINOR_SHIFT, FLEXIO_VERID_MINOR_WIDTH))
/*@}*/

/*!
 * @name Register FLEXIO_VERID, field MAJOR[31:24] (RO)
 *
 * This read only field returns the major version number for the module
 * specification.
 */
/*@{*/
/*! @brief Read current value of the FLEXIO_VERID_MAJOR field. */
#define FLEXIO_RD_VERID_MAJOR(base) ((FLEXIO_VERID_REG(base) & FLEXIO_VERID_MAJOR_MASK) >> FLEXIO_VERID_MAJOR_SHIFT)
#define FLEXIO_BRD_VERID_MAJOR(base) (BME_UBFX32(&FLEXIO_VERID_REG(base), FLEXIO_VERID_MAJOR_SHIFT, FLEXIO_VERID_MAJOR_WIDTH))
/*@}*/

/*******************************************************************************
 * FLEXIO_PARAM - Parameter Register
 ******************************************************************************/

/*!
 * @brief FLEXIO_PARAM - Parameter Register (RO)
 *
 * Reset value: 0x10080404U
 *
 * .
 */
/*!
 * @name Constants and macros for entire FLEXIO_PARAM register
 */
/*@{*/
#define FLEXIO_RD_PARAM(base)    (FLEXIO_PARAM_REG(base))
/*@}*/

/*
 * Constants & macros for individual FLEXIO_PARAM bitfields
 */

/*!
 * @name Register FLEXIO_PARAM, field SHIFTER[7:0] (RO)
 *
 * Number of Shifters implemented.
 */
/*@{*/
/*! @brief Read current value of the FLEXIO_PARAM_SHIFTER field. */
#define FLEXIO_RD_PARAM_SHIFTER(base) ((FLEXIO_PARAM_REG(base) & FLEXIO_PARAM_SHIFTER_MASK) >> FLEXIO_PARAM_SHIFTER_SHIFT)
#define FLEXIO_BRD_PARAM_SHIFTER(base) (BME_UBFX32(&FLEXIO_PARAM_REG(base), FLEXIO_PARAM_SHIFTER_SHIFT, FLEXIO_PARAM_SHIFTER_WIDTH))
/*@}*/

/*!
 * @name Register FLEXIO_PARAM, field TIMER[15:8] (RO)
 *
 * Number of Timers implemented.
 */
/*@{*/
/*! @brief Read current value of the FLEXIO_PARAM_TIMER field. */
#define FLEXIO_RD_PARAM_TIMER(base) ((FLEXIO_PARAM_REG(base) & FLEXIO_PARAM_TIMER_MASK) >> FLEXIO_PARAM_TIMER_SHIFT)
#define FLEXIO_BRD_PARAM_TIMER(base) (BME_UBFX32(&FLEXIO_PARAM_REG(base), FLEXIO_PARAM_TIMER_SHIFT, FLEXIO_PARAM_TIMER_WIDTH))
/*@}*/

/*!
 * @name Register FLEXIO_PARAM, field PIN[23:16] (RO)
 *
 * Number of Pins implemented.
 */
/*@{*/
/*! @brief Read current value of the FLEXIO_PARAM_PIN field. */
#define FLEXIO_RD_PARAM_PIN(base) ((FLEXIO_PARAM_REG(base) & FLEXIO_PARAM_PIN_MASK) >> FLEXIO_PARAM_PIN_SHIFT)
#define FLEXIO_BRD_PARAM_PIN(base) (BME_UBFX32(&FLEXIO_PARAM_REG(base), FLEXIO_PARAM_PIN_SHIFT, FLEXIO_PARAM_PIN_WIDTH))
/*@}*/

/*!
 * @name Register FLEXIO_PARAM, field TRIGGER[31:24] (RO)
 *
 * Number of external triggers implemented.
 */
/*@{*/
/*! @brief Read current value of the FLEXIO_PARAM_TRIGGER field. */
#define FLEXIO_RD_PARAM_TRIGGER(base) ((FLEXIO_PARAM_REG(base) & FLEXIO_PARAM_TRIGGER_MASK) >> FLEXIO_PARAM_TRIGGER_SHIFT)
#define FLEXIO_BRD_PARAM_TRIGGER(base) (BME_UBFX32(&FLEXIO_PARAM_REG(base), FLEXIO_PARAM_TRIGGER_SHIFT, FLEXIO_PARAM_TRIGGER_WIDTH))
/*@}*/

/*******************************************************************************
 * FLEXIO_CTRL - FlexIO Control Register
 ******************************************************************************/

/*!
 * @brief FLEXIO_CTRL - FlexIO Control Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * .
 */
/*!
 * @name Constants and macros for entire FLEXIO_CTRL register
 */
/*@{*/
#define FLEXIO_RD_CTRL(base)     (FLEXIO_CTRL_REG(base))
#define FLEXIO_WR_CTRL(base, value) (FLEXIO_CTRL_REG(base) = (value))
#define FLEXIO_RMW_CTRL(base, mask, value) (FLEXIO_WR_CTRL(base, (FLEXIO_RD_CTRL(base) & ~(mask)) | (value)))
#define FLEXIO_SET_CTRL(base, value) (BME_OR32(&FLEXIO_CTRL_REG(base), (uint32_t)(value)))
#define FLEXIO_CLR_CTRL(base, value) (BME_AND32(&FLEXIO_CTRL_REG(base), (uint32_t)(~(value))))
#define FLEXIO_TOG_CTRL(base, value) (BME_XOR32(&FLEXIO_CTRL_REG(base), (uint32_t)(value)))
/*@}*/

/*
 * Constants & macros for individual FLEXIO_CTRL bitfields
 */

/*!
 * @name Register FLEXIO_CTRL, field FLEXEN[0] (RW)
 *
 * Values:
 * - 0 - FlexIO module is disabled.
 * - 1 - FlexIO module is enabled.
 */
/*@{*/
/*! @brief Read current value of the FLEXIO_CTRL_FLEXEN field. */
#define FLEXIO_RD_CTRL_FLEXEN(base) ((FLEXIO_CTRL_REG(base) & FLEXIO_CTRL_FLEXEN_MASK) >> FLEXIO_CTRL_FLEXEN_SHIFT)
#define FLEXIO_BRD_CTRL_FLEXEN(base) (BME_UBFX32(&FLEXIO_CTRL_REG(base), FLEXIO_CTRL_FLEXEN_SHIFT, FLEXIO_CTRL_FLEXEN_WIDTH))

/*! @brief Set the FLEXEN field to a new value. */
#define FLEXIO_WR_CTRL_FLEXEN(base, value) (FLEXIO_RMW_CTRL(base, FLEXIO_CTRL_FLEXEN_MASK, FLEXIO_CTRL_FLEXEN(value)))
#define FLEXIO_BWR_CTRL_FLEXEN(base, value) (BME_BFI32(&FLEXIO_CTRL_REG(base), ((uint32_t)(value) << FLEXIO_CTRL_FLEXEN_SHIFT), FLEXIO_CTRL_FLEXEN_SHIFT, FLEXIO_CTRL_FLEXEN_WIDTH))
/*@}*/

/*!
 * @name Register FLEXIO_CTRL, field SWRST[1] (RW)
 *
 * The FlexIO Control Register is not affected by the software reset, all other
 * logic in the FlexIO is affected by the software reset and register accesses
 * are ignored until this bit is cleared. This register bit will remain set until
 * cleared by software, and the reset has cleared in the FlexIO clock domain.
 *
 * Values:
 * - 0 - Software reset is disabled
 * - 1 - Software reset is enabled, all FlexIO registers except the Control
 *     Register are reset.
 */
/*@{*/
/*! @brief Read current value of the FLEXIO_CTRL_SWRST field. */
#define FLEXIO_RD_CTRL_SWRST(base) ((FLEXIO_CTRL_REG(base) & FLEXIO_CTRL_SWRST_MASK) >> FLEXIO_CTRL_SWRST_SHIFT)
#define FLEXIO_BRD_CTRL_SWRST(base) (BME_UBFX32(&FLEXIO_CTRL_REG(base), FLEXIO_CTRL_SWRST_SHIFT, FLEXIO_CTRL_SWRST_WIDTH))

/*! @brief Set the SWRST field to a new value. */
#define FLEXIO_WR_CTRL_SWRST(base, value) (FLEXIO_RMW_CTRL(base, FLEXIO_CTRL_SWRST_MASK, FLEXIO_CTRL_SWRST(value)))
#define FLEXIO_BWR_CTRL_SWRST(base, value) (BME_BFI32(&FLEXIO_CTRL_REG(base), ((uint32_t)(value) << FLEXIO_CTRL_SWRST_SHIFT), FLEXIO_CTRL_SWRST_SHIFT, FLEXIO_CTRL_SWRST_WIDTH))
/*@}*/

/*!
 * @name Register FLEXIO_CTRL, field FASTACC[2] (RW)
 *
 * Enables fast register accesses to FlexIO registers, but requires the FlexIO
 * clock to be at least twice the frequency of the bus clock.
 *
 * Values:
 * - 0 - Configures for normal register accesses to FlexIO
 * - 1 - Configures for fast register accesses to FlexIO
 */
/*@{*/
/*! @brief Read current value of the FLEXIO_CTRL_FASTACC field. */
#define FLEXIO_RD_CTRL_FASTACC(base) ((FLEXIO_CTRL_REG(base) & FLEXIO_CTRL_FASTACC_MASK) >> FLEXIO_CTRL_FASTACC_SHIFT)
#define FLEXIO_BRD_CTRL_FASTACC(base) (BME_UBFX32(&FLEXIO_CTRL_REG(base), FLEXIO_CTRL_FASTACC_SHIFT, FLEXIO_CTRL_FASTACC_WIDTH))

/*! @brief Set the FASTACC field to a new value. */
#define FLEXIO_WR_CTRL_FASTACC(base, value) (FLEXIO_RMW_CTRL(base, FLEXIO_CTRL_FASTACC_MASK, FLEXIO_CTRL_FASTACC(value)))
#define FLEXIO_BWR_CTRL_FASTACC(base, value) (BME_BFI32(&FLEXIO_CTRL_REG(base), ((uint32_t)(value) << FLEXIO_CTRL_FASTACC_SHIFT), FLEXIO_CTRL_FASTACC_SHIFT, FLEXIO_CTRL_FASTACC_WIDTH))
/*@}*/

/*!
 * @name Register FLEXIO_CTRL, field DBGE[30] (RW)
 *
 * Enables FlexIO operation in Debug mode.
 *
 * Values:
 * - 0 - FlexIO is disabled in debug modes.
 * - 1 - FlexIO is enabled in debug modes
 */
/*@{*/
/*! @brief Read current value of the FLEXIO_CTRL_DBGE field. */
#define FLEXIO_RD_CTRL_DBGE(base) ((FLEXIO_CTRL_REG(base) & FLEXIO_CTRL_DBGE_MASK) >> FLEXIO_CTRL_DBGE_SHIFT)
#define FLEXIO_BRD_CTRL_DBGE(base) (BME_UBFX32(&FLEXIO_CTRL_REG(base), FLEXIO_CTRL_DBGE_SHIFT, FLEXIO_CTRL_DBGE_WIDTH))

/*! @brief Set the DBGE field to a new value. */
#define FLEXIO_WR_CTRL_DBGE(base, value) (FLEXIO_RMW_CTRL(base, FLEXIO_CTRL_DBGE_MASK, FLEXIO_CTRL_DBGE(value)))
#define FLEXIO_BWR_CTRL_DBGE(base, value) (BME_BFI32(&FLEXIO_CTRL_REG(base), ((uint32_t)(value) << FLEXIO_CTRL_DBGE_SHIFT), FLEXIO_CTRL_DBGE_SHIFT, FLEXIO_CTRL_DBGE_WIDTH))
/*@}*/

/*!
 * @name Register FLEXIO_CTRL, field DOZEN[31] (RW)
 *
 * Disables FlexIO operation in Doze modes. This field is ignored and the FlexIO
 * always disabled in low-leakage stop modes.
 *
 * Values:
 * - 0 - FlexIO enabled in Doze modes.
 * - 1 - FlexIO disabled in Doze modes.
 */
/*@{*/
/*! @brief Read current value of the FLEXIO_CTRL_DOZEN field. */
#define FLEXIO_RD_CTRL_DOZEN(base) ((FLEXIO_CTRL_REG(base) & FLEXIO_CTRL_DOZEN_MASK) >> FLEXIO_CTRL_DOZEN_SHIFT)
#define FLEXIO_BRD_CTRL_DOZEN(base) (BME_UBFX32(&FLEXIO_CTRL_REG(base), FLEXIO_CTRL_DOZEN_SHIFT, FLEXIO_CTRL_DOZEN_WIDTH))

/*! @brief Set the DOZEN field to a new value. */
#define FLEXIO_WR_CTRL_DOZEN(base, value) (FLEXIO_RMW_CTRL(base, FLEXIO_CTRL_DOZEN_MASK, FLEXIO_CTRL_DOZEN(value)))
#define FLEXIO_BWR_CTRL_DOZEN(base, value) (BME_BFI32(&FLEXIO_CTRL_REG(base), ((uint32_t)(value) << FLEXIO_CTRL_DOZEN_SHIFT), FLEXIO_CTRL_DOZEN_SHIFT, FLEXIO_CTRL_DOZEN_WIDTH))
/*@}*/

/*******************************************************************************
 * FLEXIO_SHIFTSTAT - Shifter Status Register
 ******************************************************************************/

/*!
 * @brief FLEXIO_SHIFTSTAT - Shifter Status Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * .
 */
/*!
 * @name Constants and macros for entire FLEXIO_SHIFTSTAT register
 */
/*@{*/
#define FLEXIO_RD_SHIFTSTAT(base) (FLEXIO_SHIFTSTAT_REG(base))
#define FLEXIO_WR_SHIFTSTAT(base, value) (FLEXIO_SHIFTSTAT_REG(base) = (value))
#define FLEXIO_RMW_SHIFTSTAT(base, mask, value) (FLEXIO_WR_SHIFTSTAT(base, (FLEXIO_RD_SHIFTSTAT(base) & ~(mask)) | (value)))
#define FLEXIO_SET_SHIFTSTAT(base, value) (BME_OR32(&FLEXIO_SHIFTSTAT_REG(base), (uint32_t)(value)))
#define FLEXIO_CLR_SHIFTSTAT(base, value) (BME_AND32(&FLEXIO_SHIFTSTAT_REG(base), (uint32_t)(~(value))))
#define FLEXIO_TOG_SHIFTSTAT(base, value) (BME_XOR32(&FLEXIO_SHIFTSTAT_REG(base), (uint32_t)(value)))
/*@}*/

/*
 * Constants & macros for individual FLEXIO_SHIFTSTAT bitfields
 */

/*!
 * @name Register FLEXIO_SHIFTSTAT, field SSF[3:0] (W1C)
 *
 * The shifter status flag is updated when one of the following events occurs:
 * For SMOD=Receive, the status flag is set when SHIFTBUF has been loaded with
 * data from Shifter (SHIFTBUF is full), and the status flag is cleared when
 * SHIFTBUF register is read. For SMOD=Transmit, the status flag is set when SHIFTBUF
 * data has been transferred to the Shifter (SHIFTBUF is empty) or when initially
 * configured for SMOD=Transmit, and the status flag is cleared when the SHIFTBUF
 * register is written. For SMOD=Match Store, the status flag is set when a match
 * has occured between SHIFTBUF and Shifter, and the status flag is cleared when
 * the SHIFTBUF register is read. For SMOD=Match Continuous, returns the current
 * match result between the SHIFTBUF and Shifter. The status flag can also be
 * cleared by writing a logic one to the flag for all modes except Match Continuous.
 *
 * Values:
 * - 0 - Status flag is clear
 * - 1 - Status flag is set
 */
/*@{*/
/*! @brief Read current value of the FLEXIO_SHIFTSTAT_SSF field. */
#define FLEXIO_RD_SHIFTSTAT_SSF(base) ((FLEXIO_SHIFTSTAT_REG(base) & FLEXIO_SHIFTSTAT_SSF_MASK) >> FLEXIO_SHIFTSTAT_SSF_SHIFT)
#define FLEXIO_BRD_SHIFTSTAT_SSF(base) (BME_UBFX32(&FLEXIO_SHIFTSTAT_REG(base), FLEXIO_SHIFTSTAT_SSF_SHIFT, FLEXIO_SHIFTSTAT_SSF_WIDTH))

/*! @brief Set the SSF field to a new value. */
#define FLEXIO_WR_SHIFTSTAT_SSF(base, value) (FLEXIO_RMW_SHIFTSTAT(base, FLEXIO_SHIFTSTAT_SSF_MASK, FLEXIO_SHIFTSTAT_SSF(value)))
#define FLEXIO_BWR_SHIFTSTAT_SSF(base, value) (BME_BFI32(&FLEXIO_SHIFTSTAT_REG(base), ((uint32_t)(value) << FLEXIO_SHIFTSTAT_SSF_SHIFT), FLEXIO_SHIFTSTAT_SSF_SHIFT, FLEXIO_SHIFTSTAT_SSF_WIDTH))
/*@}*/

/*******************************************************************************
 * FLEXIO_SHIFTERR - Shifter Error Register
 ******************************************************************************/

/*!
 * @brief FLEXIO_SHIFTERR - Shifter Error Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * .
 */
/*!
 * @name Constants and macros for entire FLEXIO_SHIFTERR register
 */
/*@{*/
#define FLEXIO_RD_SHIFTERR(base) (FLEXIO_SHIFTERR_REG(base))
#define FLEXIO_WR_SHIFTERR(base, value) (FLEXIO_SHIFTERR_REG(base) = (value))
#define FLEXIO_RMW_SHIFTERR(base, mask, value) (FLEXIO_WR_SHIFTERR(base, (FLEXIO_RD_SHIFTERR(base) & ~(mask)) | (value)))
#define FLEXIO_SET_SHIFTERR(base, value) (BME_OR32(&FLEXIO_SHIFTERR_REG(base), (uint32_t)(value)))
#define FLEXIO_CLR_SHIFTERR(base, value) (BME_AND32(&FLEXIO_SHIFTERR_REG(base), (uint32_t)(~(value))))
#define FLEXIO_TOG_SHIFTERR(base, value) (BME_XOR32(&FLEXIO_SHIFTERR_REG(base), (uint32_t)(value)))
/*@}*/

/*
 * Constants & macros for individual FLEXIO_SHIFTERR bitfields
 */

/*!
 * @name Register FLEXIO_SHIFTERR, field SEF[3:0] (W1C)
 *
 * The shifter error flag is set when one of the following events occurs: For
 * SMOD=Receive, indicates Shifter was ready to store new data into SHIFTBUF before
 * the previous data was read from SHIFTBUF (SHIFTBUF Overrun), or indicates
 * that the received start or stop bit does not match the expected value. For
 * SMOD=Transmit, indicates Shifter was ready to load new data from SHIFTBUF before new
 * data had been written into SHIFTBUF (SHIFTBUF Underrun). For SMOD=Match
 * Store, indicates a match event occured before the previous match data was read from
 * SHIFTBUF (SHIFTBUF Overrun). For SMOD=Match Continuous, the error flag is set
 * when a match has occured between SHIFTBUF and Shifter. Can be cleared by
 * writing logic one to the flag. For SMOD=Match Continuous, can also be cleared when
 * the SHIFTBUF register is read.
 *
 * Values:
 * - 0 - Shifter Error Flag is clear
 * - 1 - Shifter Error Flag is set
 */
/*@{*/
/*! @brief Read current value of the FLEXIO_SHIFTERR_SEF field. */
#define FLEXIO_RD_SHIFTERR_SEF(base) ((FLEXIO_SHIFTERR_REG(base) & FLEXIO_SHIFTERR_SEF_MASK) >> FLEXIO_SHIFTERR_SEF_SHIFT)
#define FLEXIO_BRD_SHIFTERR_SEF(base) (BME_UBFX32(&FLEXIO_SHIFTERR_REG(base), FLEXIO_SHIFTERR_SEF_SHIFT, FLEXIO_SHIFTERR_SEF_WIDTH))

/*! @brief Set the SEF field to a new value. */
#define FLEXIO_WR_SHIFTERR_SEF(base, value) (FLEXIO_RMW_SHIFTERR(base, FLEXIO_SHIFTERR_SEF_MASK, FLEXIO_SHIFTERR_SEF(value)))
#define FLEXIO_BWR_SHIFTERR_SEF(base, value) (BME_BFI32(&FLEXIO_SHIFTERR_REG(base), ((uint32_t)(value) << FLEXIO_SHIFTERR_SEF_SHIFT), FLEXIO_SHIFTERR_SEF_SHIFT, FLEXIO_SHIFTERR_SEF_WIDTH))
/*@}*/

/*******************************************************************************
 * FLEXIO_TIMSTAT - Timer Status Register
 ******************************************************************************/

/*!
 * @brief FLEXIO_TIMSTAT - Timer Status Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * .
 */
/*!
 * @name Constants and macros for entire FLEXIO_TIMSTAT register
 */
/*@{*/
#define FLEXIO_RD_TIMSTAT(base)  (FLEXIO_TIMSTAT_REG(base))
#define FLEXIO_WR_TIMSTAT(base, value) (FLEXIO_TIMSTAT_REG(base) = (value))
#define FLEXIO_RMW_TIMSTAT(base, mask, value) (FLEXIO_WR_TIMSTAT(base, (FLEXIO_RD_TIMSTAT(base) & ~(mask)) | (value)))
#define FLEXIO_SET_TIMSTAT(base, value) (BME_OR32(&FLEXIO_TIMSTAT_REG(base), (uint32_t)(value)))
#define FLEXIO_CLR_TIMSTAT(base, value) (BME_AND32(&FLEXIO_TIMSTAT_REG(base), (uint32_t)(~(value))))
#define FLEXIO_TOG_TIMSTAT(base, value) (BME_XOR32(&FLEXIO_TIMSTAT_REG(base), (uint32_t)(value)))
/*@}*/

/*
 * Constants & macros for individual FLEXIO_TIMSTAT bitfields
 */

/*!
 * @name Register FLEXIO_TIMSTAT, field TSF[3:0] (W1C)
 *
 * The timer status flag sets depending on the timer mode, and can be cleared by
 * writing logic one to the flag. In 8-bit counter mode, the timer status flag
 * is set when the upper 8-bit counter equals zero and decrements, this also
 * causes the counter to reload with the value in the compare register. In 8-bit PWM
 * mode, the timer status flag is set when the upper 8-bit counter equals zero and
 * decrements, this also causes the counter to reload with the value in the
 * compare register.. In 16-bit counter mode, the timer status flag is set when the
 * 16-bit counter equals zero and decrements, this also causes the counter to
 * reload with the value in the compare register..
 *
 * Values:
 * - 0 - Timer Status Flag is clear
 * - 1 - Timer Status Flag is set
 */
/*@{*/
/*! @brief Read current value of the FLEXIO_TIMSTAT_TSF field. */
#define FLEXIO_RD_TIMSTAT_TSF(base) ((FLEXIO_TIMSTAT_REG(base) & FLEXIO_TIMSTAT_TSF_MASK) >> FLEXIO_TIMSTAT_TSF_SHIFT)
#define FLEXIO_BRD_TIMSTAT_TSF(base) (BME_UBFX32(&FLEXIO_TIMSTAT_REG(base), FLEXIO_TIMSTAT_TSF_SHIFT, FLEXIO_TIMSTAT_TSF_WIDTH))

/*! @brief Set the TSF field to a new value. */
#define FLEXIO_WR_TIMSTAT_TSF(base, value) (FLEXIO_RMW_TIMSTAT(base, FLEXIO_TIMSTAT_TSF_MASK, FLEXIO_TIMSTAT_TSF(value)))
#define FLEXIO_BWR_TIMSTAT_TSF(base, value) (BME_BFI32(&FLEXIO_TIMSTAT_REG(base), ((uint32_t)(value) << FLEXIO_TIMSTAT_TSF_SHIFT), FLEXIO_TIMSTAT_TSF_SHIFT, FLEXIO_TIMSTAT_TSF_WIDTH))
/*@}*/

/*******************************************************************************
 * FLEXIO_SHIFTSIEN - Shifter Status Interrupt Enable
 ******************************************************************************/

/*!
 * @brief FLEXIO_SHIFTSIEN - Shifter Status Interrupt Enable (RW)
 *
 * Reset value: 0x00000000U
 *
 * .
 */
/*!
 * @name Constants and macros for entire FLEXIO_SHIFTSIEN register
 */
/*@{*/
#define FLEXIO_RD_SHIFTSIEN(base) (FLEXIO_SHIFTSIEN_REG(base))
#define FLEXIO_WR_SHIFTSIEN(base, value) (FLEXIO_SHIFTSIEN_REG(base) = (value))
#define FLEXIO_RMW_SHIFTSIEN(base, mask, value) (FLEXIO_WR_SHIFTSIEN(base, (FLEXIO_RD_SHIFTSIEN(base) & ~(mask)) | (value)))
#define FLEXIO_SET_SHIFTSIEN(base, value) (BME_OR32(&FLEXIO_SHIFTSIEN_REG(base), (uint32_t)(value)))
#define FLEXIO_CLR_SHIFTSIEN(base, value) (BME_AND32(&FLEXIO_SHIFTSIEN_REG(base), (uint32_t)(~(value))))
#define FLEXIO_TOG_SHIFTSIEN(base, value) (BME_XOR32(&FLEXIO_SHIFTSIEN_REG(base), (uint32_t)(value)))
/*@}*/

/*
 * Constants & macros for individual FLEXIO_SHIFTSIEN bitfields
 */

/*!
 * @name Register FLEXIO_SHIFTSIEN, field SSIE[3:0] (RW)
 *
 * Enables interrupt generation when corresponding SSF is set.
 *
 * Values:
 * - 0 - Shifter Status Flag interrupt disabled
 * - 1 - Shifter Status Flag interrupt enabled
 */
/*@{*/
/*! @brief Read current value of the FLEXIO_SHIFTSIEN_SSIE field. */
#define FLEXIO_RD_SHIFTSIEN_SSIE(base) ((FLEXIO_SHIFTSIEN_REG(base) & FLEXIO_SHIFTSIEN_SSIE_MASK) >> FLEXIO_SHIFTSIEN_SSIE_SHIFT)
#define FLEXIO_BRD_SHIFTSIEN_SSIE(base) (BME_UBFX32(&FLEXIO_SHIFTSIEN_REG(base), FLEXIO_SHIFTSIEN_SSIE_SHIFT, FLEXIO_SHIFTSIEN_SSIE_WIDTH))

/*! @brief Set the SSIE field to a new value. */
#define FLEXIO_WR_SHIFTSIEN_SSIE(base, value) (FLEXIO_RMW_SHIFTSIEN(base, FLEXIO_SHIFTSIEN_SSIE_MASK, FLEXIO_SHIFTSIEN_SSIE(value)))
#define FLEXIO_BWR_SHIFTSIEN_SSIE(base, value) (BME_BFI32(&FLEXIO_SHIFTSIEN_REG(base), ((uint32_t)(value) << FLEXIO_SHIFTSIEN_SSIE_SHIFT), FLEXIO_SHIFTSIEN_SSIE_SHIFT, FLEXIO_SHIFTSIEN_SSIE_WIDTH))
/*@}*/

/*******************************************************************************
 * FLEXIO_SHIFTEIEN - Shifter Error Interrupt Enable
 ******************************************************************************/

/*!
 * @brief FLEXIO_SHIFTEIEN - Shifter Error Interrupt Enable (RW)
 *
 * Reset value: 0x00000000U
 *
 * .
 */
/*!
 * @name Constants and macros for entire FLEXIO_SHIFTEIEN register
 */
/*@{*/
#define FLEXIO_RD_SHIFTEIEN(base) (FLEXIO_SHIFTEIEN_REG(base))
#define FLEXIO_WR_SHIFTEIEN(base, value) (FLEXIO_SHIFTEIEN_REG(base) = (value))
#define FLEXIO_RMW_SHIFTEIEN(base, mask, value) (FLEXIO_WR_SHIFTEIEN(base, (FLEXIO_RD_SHIFTEIEN(base) & ~(mask)) | (value)))
#define FLEXIO_SET_SHIFTEIEN(base, value) (BME_OR32(&FLEXIO_SHIFTEIEN_REG(base), (uint32_t)(value)))
#define FLEXIO_CLR_SHIFTEIEN(base, value) (BME_AND32(&FLEXIO_SHIFTEIEN_REG(base), (uint32_t)(~(value))))
#define FLEXIO_TOG_SHIFTEIEN(base, value) (BME_XOR32(&FLEXIO_SHIFTEIEN_REG(base), (uint32_t)(value)))
/*@}*/

/*
 * Constants & macros for individual FLEXIO_SHIFTEIEN bitfields
 */

/*!
 * @name Register FLEXIO_SHIFTEIEN, field SEIE[3:0] (RW)
 *
 * Enables interrupt generation when corresponding SEF is set.
 *
 * Values:
 * - 0 - Shifter Error Flag interrupt disabled
 * - 1 - Shifter Error Flag interrupt enabled
 */
/*@{*/
/*! @brief Read current value of the FLEXIO_SHIFTEIEN_SEIE field. */
#define FLEXIO_RD_SHIFTEIEN_SEIE(base) ((FLEXIO_SHIFTEIEN_REG(base) & FLEXIO_SHIFTEIEN_SEIE_MASK) >> FLEXIO_SHIFTEIEN_SEIE_SHIFT)
#define FLEXIO_BRD_SHIFTEIEN_SEIE(base) (BME_UBFX32(&FLEXIO_SHIFTEIEN_REG(base), FLEXIO_SHIFTEIEN_SEIE_SHIFT, FLEXIO_SHIFTEIEN_SEIE_WIDTH))

/*! @brief Set the SEIE field to a new value. */
#define FLEXIO_WR_SHIFTEIEN_SEIE(base, value) (FLEXIO_RMW_SHIFTEIEN(base, FLEXIO_SHIFTEIEN_SEIE_MASK, FLEXIO_SHIFTEIEN_SEIE(value)))
#define FLEXIO_BWR_SHIFTEIEN_SEIE(base, value) (BME_BFI32(&FLEXIO_SHIFTEIEN_REG(base), ((uint32_t)(value) << FLEXIO_SHIFTEIEN_SEIE_SHIFT), FLEXIO_SHIFTEIEN_SEIE_SHIFT, FLEXIO_SHIFTEIEN_SEIE_WIDTH))
/*@}*/

/*******************************************************************************
 * FLEXIO_TIMIEN - Timer Interrupt Enable Register
 ******************************************************************************/

/*!
 * @brief FLEXIO_TIMIEN - Timer Interrupt Enable Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * .
 */
/*!
 * @name Constants and macros for entire FLEXIO_TIMIEN register
 */
/*@{*/
#define FLEXIO_RD_TIMIEN(base)   (FLEXIO_TIMIEN_REG(base))
#define FLEXIO_WR_TIMIEN(base, value) (FLEXIO_TIMIEN_REG(base) = (value))
#define FLEXIO_RMW_TIMIEN(base, mask, value) (FLEXIO_WR_TIMIEN(base, (FLEXIO_RD_TIMIEN(base) & ~(mask)) | (value)))
#define FLEXIO_SET_TIMIEN(base, value) (BME_OR32(&FLEXIO_TIMIEN_REG(base), (uint32_t)(value)))
#define FLEXIO_CLR_TIMIEN(base, value) (BME_AND32(&FLEXIO_TIMIEN_REG(base), (uint32_t)(~(value))))
#define FLEXIO_TOG_TIMIEN(base, value) (BME_XOR32(&FLEXIO_TIMIEN_REG(base), (uint32_t)(value)))
/*@}*/

/*
 * Constants & macros for individual FLEXIO_TIMIEN bitfields
 */

/*!
 * @name Register FLEXIO_TIMIEN, field TEIE[3:0] (RW)
 *
 * Enables interrupt generation when corresponding TSF is set.
 *
 * Values:
 * - 0 - Timer Status Flag interrupt is disabled
 * - 1 - Timer Status Flag interrupt is enabled
 */
/*@{*/
/*! @brief Read current value of the FLEXIO_TIMIEN_TEIE field. */
#define FLEXIO_RD_TIMIEN_TEIE(base) ((FLEXIO_TIMIEN_REG(base) & FLEXIO_TIMIEN_TEIE_MASK) >> FLEXIO_TIMIEN_TEIE_SHIFT)
#define FLEXIO_BRD_TIMIEN_TEIE(base) (BME_UBFX32(&FLEXIO_TIMIEN_REG(base), FLEXIO_TIMIEN_TEIE_SHIFT, FLEXIO_TIMIEN_TEIE_WIDTH))

/*! @brief Set the TEIE field to a new value. */
#define FLEXIO_WR_TIMIEN_TEIE(base, value) (FLEXIO_RMW_TIMIEN(base, FLEXIO_TIMIEN_TEIE_MASK, FLEXIO_TIMIEN_TEIE(value)))
#define FLEXIO_BWR_TIMIEN_TEIE(base, value) (BME_BFI32(&FLEXIO_TIMIEN_REG(base), ((uint32_t)(value) << FLEXIO_TIMIEN_TEIE_SHIFT), FLEXIO_TIMIEN_TEIE_SHIFT, FLEXIO_TIMIEN_TEIE_WIDTH))
/*@}*/

/*******************************************************************************
 * FLEXIO_SHIFTSDEN - Shifter Status DMA Enable
 ******************************************************************************/

/*!
 * @brief FLEXIO_SHIFTSDEN - Shifter Status DMA Enable (RW)
 *
 * Reset value: 0x00000000U
 *
 * .
 */
/*!
 * @name Constants and macros for entire FLEXIO_SHIFTSDEN register
 */
/*@{*/
#define FLEXIO_RD_SHIFTSDEN(base) (FLEXIO_SHIFTSDEN_REG(base))
#define FLEXIO_WR_SHIFTSDEN(base, value) (FLEXIO_SHIFTSDEN_REG(base) = (value))
#define FLEXIO_RMW_SHIFTSDEN(base, mask, value) (FLEXIO_WR_SHIFTSDEN(base, (FLEXIO_RD_SHIFTSDEN(base) & ~(mask)) | (value)))
#define FLEXIO_SET_SHIFTSDEN(base, value) (BME_OR32(&FLEXIO_SHIFTSDEN_REG(base), (uint32_t)(value)))
#define FLEXIO_CLR_SHIFTSDEN(base, value) (BME_AND32(&FLEXIO_SHIFTSDEN_REG(base), (uint32_t)(~(value))))
#define FLEXIO_TOG_SHIFTSDEN(base, value) (BME_XOR32(&FLEXIO_SHIFTSDEN_REG(base), (uint32_t)(value)))
/*@}*/

/*
 * Constants & macros for individual FLEXIO_SHIFTSDEN bitfields
 */

/*!
 * @name Register FLEXIO_SHIFTSDEN, field SSDE[3:0] (RW)
 *
 * Enables DMA request generation when corresponding SSF is set.
 *
 * Values:
 * - 0 - Shifter Status Flag DMA request is disabled
 * - 1 - Shifter Status Flag DMA request is enabled
 */
/*@{*/
/*! @brief Read current value of the FLEXIO_SHIFTSDEN_SSDE field. */
#define FLEXIO_RD_SHIFTSDEN_SSDE(base) ((FLEXIO_SHIFTSDEN_REG(base) & FLEXIO_SHIFTSDEN_SSDE_MASK) >> FLEXIO_SHIFTSDEN_SSDE_SHIFT)
#define FLEXIO_BRD_SHIFTSDEN_SSDE(base) (BME_UBFX32(&FLEXIO_SHIFTSDEN_REG(base), FLEXIO_SHIFTSDEN_SSDE_SHIFT, FLEXIO_SHIFTSDEN_SSDE_WIDTH))

/*! @brief Set the SSDE field to a new value. */
#define FLEXIO_WR_SHIFTSDEN_SSDE(base, value) (FLEXIO_RMW_SHIFTSDEN(base, FLEXIO_SHIFTSDEN_SSDE_MASK, FLEXIO_SHIFTSDEN_SSDE(value)))
#define FLEXIO_BWR_SHIFTSDEN_SSDE(base, value) (BME_BFI32(&FLEXIO_SHIFTSDEN_REG(base), ((uint32_t)(value) << FLEXIO_SHIFTSDEN_SSDE_SHIFT), FLEXIO_SHIFTSDEN_SSDE_SHIFT, FLEXIO_SHIFTSDEN_SSDE_WIDTH))
/*@}*/

/*******************************************************************************
 * FLEXIO_SHIFTCTL - Shifter Control N Register
 ******************************************************************************/

/*!
 * @brief FLEXIO_SHIFTCTL - Shifter Control N Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * .
 */
/*!
 * @name Constants and macros for entire FLEXIO_SHIFTCTL register
 */
/*@{*/
#define FLEXIO_RD_SHIFTCTL(base, index) (FLEXIO_SHIFTCTL_REG(base, index))
#define FLEXIO_WR_SHIFTCTL(base, index, value) (FLEXIO_SHIFTCTL_REG(base, index) = (value))
#define FLEXIO_RMW_SHIFTCTL(base, index, mask, value) (FLEXIO_WR_SHIFTCTL(base, index, (FLEXIO_RD_SHIFTCTL(base, index) & ~(mask)) | (value)))
#define FLEXIO_SET_SHIFTCTL(base, index, value) (BME_OR32(&FLEXIO_SHIFTCTL_REG(base, index), (uint32_t)(value)))
#define FLEXIO_CLR_SHIFTCTL(base, index, value) (BME_AND32(&FLEXIO_SHIFTCTL_REG(base, index), (uint32_t)(~(value))))
#define FLEXIO_TOG_SHIFTCTL(base, index, value) (BME_XOR32(&FLEXIO_SHIFTCTL_REG(base, index), (uint32_t)(value)))
/*@}*/

/*
 * Constants & macros for individual FLEXIO_SHIFTCTL bitfields
 */

/*!
 * @name Register FLEXIO_SHIFTCTL, field SMOD[2:0] (RW)
 *
 * Configures the mode of the Shifter.
 *
 * Values:
 * - 000 - Disabled.
 * - 001 - Receive mode. Captures the current Shifter content into the SHIFTBUF
 *     on expiration of the Timer.
 * - 010 - Transmit mode. Load SHIFTBUF contents into the Shifter on expiration
 *     of the Timer.
 * - 011 - Reserved.
 * - 100 - Match Store mode. Shifter data is compared to SHIFTBUF content on
 *     expiration of the Timer.
 * - 101 - Match Continuous mode. Shifter data is continuously compared to
 *     SHIFTBUF contents.
 * - 110 - Reserved.
 * - 111 - Reserved.
 */
/*@{*/
/*! @brief Read current value of the FLEXIO_SHIFTCTL_SMOD field. */
#define FLEXIO_RD_SHIFTCTL_SMOD(base, index) ((FLEXIO_SHIFTCTL_REG(base, index) & FLEXIO_SHIFTCTL_SMOD_MASK) >> FLEXIO_SHIFTCTL_SMOD_SHIFT)
#define FLEXIO_BRD_SHIFTCTL_SMOD(base, index) (BME_UBFX32(&FLEXIO_SHIFTCTL_REG(base, index), FLEXIO_SHIFTCTL_SMOD_SHIFT, FLEXIO_SHIFTCTL_SMOD_WIDTH))

/*! @brief Set the SMOD field to a new value. */
#define FLEXIO_WR_SHIFTCTL_SMOD(base, index, value) (FLEXIO_RMW_SHIFTCTL(base, index, FLEXIO_SHIFTCTL_SMOD_MASK, FLEXIO_SHIFTCTL_SMOD(value)))
#define FLEXIO_BWR_SHIFTCTL_SMOD(base, index, value) (BME_BFI32(&FLEXIO_SHIFTCTL_REG(base, index), ((uint32_t)(value) << FLEXIO_SHIFTCTL_SMOD_SHIFT), FLEXIO_SHIFTCTL_SMOD_SHIFT, FLEXIO_SHIFTCTL_SMOD_WIDTH))
/*@}*/

/*!
 * @name Register FLEXIO_SHIFTCTL, field PINPOL[7] (RW)
 *
 * Values:
 * - 0 - Pin is active high
 * - 1 - Pin is active low
 */
/*@{*/
/*! @brief Read current value of the FLEXIO_SHIFTCTL_PINPOL field. */
#define FLEXIO_RD_SHIFTCTL_PINPOL(base, index) ((FLEXIO_SHIFTCTL_REG(base, index) & FLEXIO_SHIFTCTL_PINPOL_MASK) >> FLEXIO_SHIFTCTL_PINPOL_SHIFT)
#define FLEXIO_BRD_SHIFTCTL_PINPOL(base, index) (BME_UBFX32(&FLEXIO_SHIFTCTL_REG(base, index), FLEXIO_SHIFTCTL_PINPOL_SHIFT, FLEXIO_SHIFTCTL_PINPOL_WIDTH))

/*! @brief Set the PINPOL field to a new value. */
#define FLEXIO_WR_SHIFTCTL_PINPOL(base, index, value) (FLEXIO_RMW_SHIFTCTL(base, index, FLEXIO_SHIFTCTL_PINPOL_MASK, FLEXIO_SHIFTCTL_PINPOL(value)))
#define FLEXIO_BWR_SHIFTCTL_PINPOL(base, index, value) (BME_BFI32(&FLEXIO_SHIFTCTL_REG(base, index), ((uint32_t)(value) << FLEXIO_SHIFTCTL_PINPOL_SHIFT), FLEXIO_SHIFTCTL_PINPOL_SHIFT, FLEXIO_SHIFTCTL_PINPOL_WIDTH))
/*@}*/

/*!
 * @name Register FLEXIO_SHIFTCTL, field PINSEL[10:8] (RW)
 *
 * Selects which pin is used by the Shifter input or output.
 */
/*@{*/
/*! @brief Read current value of the FLEXIO_SHIFTCTL_PINSEL field. */
#define FLEXIO_RD_SHIFTCTL_PINSEL(base, index) ((FLEXIO_SHIFTCTL_REG(base, index) & FLEXIO_SHIFTCTL_PINSEL_MASK) >> FLEXIO_SHIFTCTL_PINSEL_SHIFT)
#define FLEXIO_BRD_SHIFTCTL_PINSEL(base, index) (BME_UBFX32(&FLEXIO_SHIFTCTL_REG(base, index), FLEXIO_SHIFTCTL_PINSEL_SHIFT, FLEXIO_SHIFTCTL_PINSEL_WIDTH))

/*! @brief Set the PINSEL field to a new value. */
#define FLEXIO_WR_SHIFTCTL_PINSEL(base, index, value) (FLEXIO_RMW_SHIFTCTL(base, index, FLEXIO_SHIFTCTL_PINSEL_MASK, FLEXIO_SHIFTCTL_PINSEL(value)))
#define FLEXIO_BWR_SHIFTCTL_PINSEL(base, index, value) (BME_BFI32(&FLEXIO_SHIFTCTL_REG(base, index), ((uint32_t)(value) << FLEXIO_SHIFTCTL_PINSEL_SHIFT), FLEXIO_SHIFTCTL_PINSEL_SHIFT, FLEXIO_SHIFTCTL_PINSEL_WIDTH))
/*@}*/

/*!
 * @name Register FLEXIO_SHIFTCTL, field PINCFG[17:16] (RW)
 *
 * Values:
 * - 00 - Shifter pin output disabled
 * - 01 - Shifter pin open drain or bidirectional output enable
 * - 10 - Shifter pin bidirectional output data
 * - 11 - Shifter pin output
 */
/*@{*/
/*! @brief Read current value of the FLEXIO_SHIFTCTL_PINCFG field. */
#define FLEXIO_RD_SHIFTCTL_PINCFG(base, index) ((FLEXIO_SHIFTCTL_REG(base, index) & FLEXIO_SHIFTCTL_PINCFG_MASK) >> FLEXIO_SHIFTCTL_PINCFG_SHIFT)
#define FLEXIO_BRD_SHIFTCTL_PINCFG(base, index) (BME_UBFX32(&FLEXIO_SHIFTCTL_REG(base, index), FLEXIO_SHIFTCTL_PINCFG_SHIFT, FLEXIO_SHIFTCTL_PINCFG_WIDTH))

/*! @brief Set the PINCFG field to a new value. */
#define FLEXIO_WR_SHIFTCTL_PINCFG(base, index, value) (FLEXIO_RMW_SHIFTCTL(base, index, FLEXIO_SHIFTCTL_PINCFG_MASK, FLEXIO_SHIFTCTL_PINCFG(value)))
#define FLEXIO_BWR_SHIFTCTL_PINCFG(base, index, value) (BME_BFI32(&FLEXIO_SHIFTCTL_REG(base, index), ((uint32_t)(value) << FLEXIO_SHIFTCTL_PINCFG_SHIFT), FLEXIO_SHIFTCTL_PINCFG_SHIFT, FLEXIO_SHIFTCTL_PINCFG_WIDTH))
/*@}*/

/*!
 * @name Register FLEXIO_SHIFTCTL, field TIMPOL[23] (RW)
 *
 * Values:
 * - 0 - Shift on posedge of Shift clock
 * - 1 - Shift on negedge of Shift clock
 */
/*@{*/
/*! @brief Read current value of the FLEXIO_SHIFTCTL_TIMPOL field. */
#define FLEXIO_RD_SHIFTCTL_TIMPOL(base, index) ((FLEXIO_SHIFTCTL_REG(base, index) & FLEXIO_SHIFTCTL_TIMPOL_MASK) >> FLEXIO_SHIFTCTL_TIMPOL_SHIFT)
#define FLEXIO_BRD_SHIFTCTL_TIMPOL(base, index) (BME_UBFX32(&FLEXIO_SHIFTCTL_REG(base, index), FLEXIO_SHIFTCTL_TIMPOL_SHIFT, FLEXIO_SHIFTCTL_TIMPOL_WIDTH))

/*! @brief Set the TIMPOL field to a new value. */
#define FLEXIO_WR_SHIFTCTL_TIMPOL(base, index, value) (FLEXIO_RMW_SHIFTCTL(base, index, FLEXIO_SHIFTCTL_TIMPOL_MASK, FLEXIO_SHIFTCTL_TIMPOL(value)))
#define FLEXIO_BWR_SHIFTCTL_TIMPOL(base, index, value) (BME_BFI32(&FLEXIO_SHIFTCTL_REG(base, index), ((uint32_t)(value) << FLEXIO_SHIFTCTL_TIMPOL_SHIFT), FLEXIO_SHIFTCTL_TIMPOL_SHIFT, FLEXIO_SHIFTCTL_TIMPOL_WIDTH))
/*@}*/

/*!
 * @name Register FLEXIO_SHIFTCTL, field TIMSEL[25:24] (RW)
 *
 * Selects which Timer is used for controlling the logic/shift register and
 * generating the Shift clock.
 */
/*@{*/
/*! @brief Read current value of the FLEXIO_SHIFTCTL_TIMSEL field. */
#define FLEXIO_RD_SHIFTCTL_TIMSEL(base, index) ((FLEXIO_SHIFTCTL_REG(base, index) & FLEXIO_SHIFTCTL_TIMSEL_MASK) >> FLEXIO_SHIFTCTL_TIMSEL_SHIFT)
#define FLEXIO_BRD_SHIFTCTL_TIMSEL(base, index) (BME_UBFX32(&FLEXIO_SHIFTCTL_REG(base, index), FLEXIO_SHIFTCTL_TIMSEL_SHIFT, FLEXIO_SHIFTCTL_TIMSEL_WIDTH))

/*! @brief Set the TIMSEL field to a new value. */
#define FLEXIO_WR_SHIFTCTL_TIMSEL(base, index, value) (FLEXIO_RMW_SHIFTCTL(base, index, FLEXIO_SHIFTCTL_TIMSEL_MASK, FLEXIO_SHIFTCTL_TIMSEL(value)))
#define FLEXIO_BWR_SHIFTCTL_TIMSEL(base, index, value) (BME_BFI32(&FLEXIO_SHIFTCTL_REG(base, index), ((uint32_t)(value) << FLEXIO_SHIFTCTL_TIMSEL_SHIFT), FLEXIO_SHIFTCTL_TIMSEL_SHIFT, FLEXIO_SHIFTCTL_TIMSEL_WIDTH))
/*@}*/

/*******************************************************************************
 * FLEXIO_SHIFTCFG - Shifter Configuration N Register
 ******************************************************************************/

/*!
 * @brief FLEXIO_SHIFTCFG - Shifter Configuration N Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * .
 */
/*!
 * @name Constants and macros for entire FLEXIO_SHIFTCFG register
 */
/*@{*/
#define FLEXIO_RD_SHIFTCFG(base, index) (FLEXIO_SHIFTCFG_REG(base, index))
#define FLEXIO_WR_SHIFTCFG(base, index, value) (FLEXIO_SHIFTCFG_REG(base, index) = (value))
#define FLEXIO_RMW_SHIFTCFG(base, index, mask, value) (FLEXIO_WR_SHIFTCFG(base, index, (FLEXIO_RD_SHIFTCFG(base, index) & ~(mask)) | (value)))
#define FLEXIO_SET_SHIFTCFG(base, index, value) (BME_OR32(&FLEXIO_SHIFTCFG_REG(base, index), (uint32_t)(value)))
#define FLEXIO_CLR_SHIFTCFG(base, index, value) (BME_AND32(&FLEXIO_SHIFTCFG_REG(base, index), (uint32_t)(~(value))))
#define FLEXIO_TOG_SHIFTCFG(base, index, value) (BME_XOR32(&FLEXIO_SHIFTCFG_REG(base, index), (uint32_t)(value)))
/*@}*/

/*
 * Constants & macros for individual FLEXIO_SHIFTCFG bitfields
 */

/*!
 * @name Register FLEXIO_SHIFTCFG, field SSTART[1:0] (RW)
 *
 * For SMOD=Transmit, this field allows automatic start bit insertion if the
 * selected timer has also enabled a start bit. For SMOD=Receive or Match Store,
 * this field allows automatic start bit checking if the selected timer has also
 * enabled a start bit.
 *
 * Values:
 * - 00 - Start bit disabled for transmitter/receiver/match store, transmitter
 *     loads data on enable
 * - 01 - Start bit disabled for transmitter/receiver/match store, transmitter
 *     loads data on first shift
 * - 10 - Transmitter outputs start bit value 0 before loading data on first
 *     shift, receiver/match store sets error flag if start bit is not 0
 * - 11 - Transmitter outputs start bit value 1 before loading data on first
 *     shift, receiver/match store sets error flag if start bit is not 1
 */
/*@{*/
/*! @brief Read current value of the FLEXIO_SHIFTCFG_SSTART field. */
#define FLEXIO_RD_SHIFTCFG_SSTART(base, index) ((FLEXIO_SHIFTCFG_REG(base, index) & FLEXIO_SHIFTCFG_SSTART_MASK) >> FLEXIO_SHIFTCFG_SSTART_SHIFT)
#define FLEXIO_BRD_SHIFTCFG_SSTART(base, index) (BME_UBFX32(&FLEXIO_SHIFTCFG_REG(base, index), FLEXIO_SHIFTCFG_SSTART_SHIFT, FLEXIO_SHIFTCFG_SSTART_WIDTH))

/*! @brief Set the SSTART field to a new value. */
#define FLEXIO_WR_SHIFTCFG_SSTART(base, index, value) (FLEXIO_RMW_SHIFTCFG(base, index, FLEXIO_SHIFTCFG_SSTART_MASK, FLEXIO_SHIFTCFG_SSTART(value)))
#define FLEXIO_BWR_SHIFTCFG_SSTART(base, index, value) (BME_BFI32(&FLEXIO_SHIFTCFG_REG(base, index), ((uint32_t)(value) << FLEXIO_SHIFTCFG_SSTART_SHIFT), FLEXIO_SHIFTCFG_SSTART_SHIFT, FLEXIO_SHIFTCFG_SSTART_WIDTH))
/*@}*/

/*!
 * @name Register FLEXIO_SHIFTCFG, field SSTOP[5:4] (RW)
 *
 * For SMOD=Transmit, this field allows automatic stop bit insertion if the
 * selected timer has also enabled a stop bit. For SMOD=Receive or Match Store, this
 * field allows automatic stop bit checking if the selected timer has also
 * enabled a stop bit.
 *
 * Values:
 * - 00 - Stop bit disabled for transmitter/receiver/match store
 * - 01 - Reserved for transmitter/receiver/match store
 * - 10 - Transmitter outputs stop bit value 0 on store, receiver/match store
 *     sets error flag if stop bit is not 0
 * - 11 - Transmitter outputs stop bit value 1 on store, receiver/match store
 *     sets error flag if stop bit is not 1
 */
/*@{*/
/*! @brief Read current value of the FLEXIO_SHIFTCFG_SSTOP field. */
#define FLEXIO_RD_SHIFTCFG_SSTOP(base, index) ((FLEXIO_SHIFTCFG_REG(base, index) & FLEXIO_SHIFTCFG_SSTOP_MASK) >> FLEXIO_SHIFTCFG_SSTOP_SHIFT)
#define FLEXIO_BRD_SHIFTCFG_SSTOP(base, index) (BME_UBFX32(&FLEXIO_SHIFTCFG_REG(base, index), FLEXIO_SHIFTCFG_SSTOP_SHIFT, FLEXIO_SHIFTCFG_SSTOP_WIDTH))

/*! @brief Set the SSTOP field to a new value. */
#define FLEXIO_WR_SHIFTCFG_SSTOP(base, index, value) (FLEXIO_RMW_SHIFTCFG(base, index, FLEXIO_SHIFTCFG_SSTOP_MASK, FLEXIO_SHIFTCFG_SSTOP(value)))
#define FLEXIO_BWR_SHIFTCFG_SSTOP(base, index, value) (BME_BFI32(&FLEXIO_SHIFTCFG_REG(base, index), ((uint32_t)(value) << FLEXIO_SHIFTCFG_SSTOP_SHIFT), FLEXIO_SHIFTCFG_SSTOP_SHIFT, FLEXIO_SHIFTCFG_SSTOP_WIDTH))
/*@}*/

/*!
 * @name Register FLEXIO_SHIFTCFG, field INSRC[8] (RW)
 *
 * Selects the input source for the shifter.
 *
 * Values:
 * - 0 - Pin
 * - 1 - Shifter N+1 Output
 */
/*@{*/
/*! @brief Read current value of the FLEXIO_SHIFTCFG_INSRC field. */
#define FLEXIO_RD_SHIFTCFG_INSRC(base, index) ((FLEXIO_SHIFTCFG_REG(base, index) & FLEXIO_SHIFTCFG_INSRC_MASK) >> FLEXIO_SHIFTCFG_INSRC_SHIFT)
#define FLEXIO_BRD_SHIFTCFG_INSRC(base, index) (BME_UBFX32(&FLEXIO_SHIFTCFG_REG(base, index), FLEXIO_SHIFTCFG_INSRC_SHIFT, FLEXIO_SHIFTCFG_INSRC_WIDTH))

/*! @brief Set the INSRC field to a new value. */
#define FLEXIO_WR_SHIFTCFG_INSRC(base, index, value) (FLEXIO_RMW_SHIFTCFG(base, index, FLEXIO_SHIFTCFG_INSRC_MASK, FLEXIO_SHIFTCFG_INSRC(value)))
#define FLEXIO_BWR_SHIFTCFG_INSRC(base, index, value) (BME_BFI32(&FLEXIO_SHIFTCFG_REG(base, index), ((uint32_t)(value) << FLEXIO_SHIFTCFG_INSRC_SHIFT), FLEXIO_SHIFTCFG_INSRC_SHIFT, FLEXIO_SHIFTCFG_INSRC_WIDTH))
/*@}*/

/*******************************************************************************
 * FLEXIO_SHIFTBUF - Shifter Buffer N Register
 ******************************************************************************/

/*!
 * @brief FLEXIO_SHIFTBUF - Shifter Buffer N Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * .
 */
/*!
 * @name Constants and macros for entire FLEXIO_SHIFTBUF register
 */
/*@{*/
#define FLEXIO_RD_SHIFTBUF(base, index) (FLEXIO_SHIFTBUF_REG(base, index))
#define FLEXIO_WR_SHIFTBUF(base, index, value) (FLEXIO_SHIFTBUF_REG(base, index) = (value))
#define FLEXIO_RMW_SHIFTBUF(base, index, mask, value) (FLEXIO_WR_SHIFTBUF(base, index, (FLEXIO_RD_SHIFTBUF(base, index) & ~(mask)) | (value)))
#define FLEXIO_SET_SHIFTBUF(base, index, value) (BME_OR32(&FLEXIO_SHIFTBUF_REG(base, index), (uint32_t)(value)))
#define FLEXIO_CLR_SHIFTBUF(base, index, value) (BME_AND32(&FLEXIO_SHIFTBUF_REG(base, index), (uint32_t)(~(value))))
#define FLEXIO_TOG_SHIFTBUF(base, index, value) (BME_XOR32(&FLEXIO_SHIFTBUF_REG(base, index), (uint32_t)(value)))
/*@}*/

/*******************************************************************************
 * FLEXIO_SHIFTBUFBIS - Shifter Buffer N Bit Swapped Register
 ******************************************************************************/

/*!
 * @brief FLEXIO_SHIFTBUFBIS - Shifter Buffer N Bit Swapped Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * .
 */
/*!
 * @name Constants and macros for entire FLEXIO_SHIFTBUFBIS register
 */
/*@{*/
#define FLEXIO_RD_SHIFTBUFBIS(base, index) (FLEXIO_SHIFTBUFBIS_REG(base, index))
#define FLEXIO_WR_SHIFTBUFBIS(base, index, value) (FLEXIO_SHIFTBUFBIS_REG(base, index) = (value))
#define FLEXIO_RMW_SHIFTBUFBIS(base, index, mask, value) (FLEXIO_WR_SHIFTBUFBIS(base, index, (FLEXIO_RD_SHIFTBUFBIS(base, index) & ~(mask)) | (value)))
#define FLEXIO_SET_SHIFTBUFBIS(base, index, value) (BME_OR32(&FLEXIO_SHIFTBUFBIS_REG(base, index), (uint32_t)(value)))
#define FLEXIO_CLR_SHIFTBUFBIS(base, index, value) (BME_AND32(&FLEXIO_SHIFTBUFBIS_REG(base, index), (uint32_t)(~(value))))
#define FLEXIO_TOG_SHIFTBUFBIS(base, index, value) (BME_XOR32(&FLEXIO_SHIFTBUFBIS_REG(base, index), (uint32_t)(value)))
/*@}*/

/*******************************************************************************
 * FLEXIO_SHIFTBUFBYS - Shifter Buffer N Byte Swapped Register
 ******************************************************************************/

/*!
 * @brief FLEXIO_SHIFTBUFBYS - Shifter Buffer N Byte Swapped Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * .
 */
/*!
 * @name Constants and macros for entire FLEXIO_SHIFTBUFBYS register
 */
/*@{*/
#define FLEXIO_RD_SHIFTBUFBYS(base, index) (FLEXIO_SHIFTBUFBYS_REG(base, index))
#define FLEXIO_WR_SHIFTBUFBYS(base, index, value) (FLEXIO_SHIFTBUFBYS_REG(base, index) = (value))
#define FLEXIO_RMW_SHIFTBUFBYS(base, index, mask, value) (FLEXIO_WR_SHIFTBUFBYS(base, index, (FLEXIO_RD_SHIFTBUFBYS(base, index) & ~(mask)) | (value)))
#define FLEXIO_SET_SHIFTBUFBYS(base, index, value) (BME_OR32(&FLEXIO_SHIFTBUFBYS_REG(base, index), (uint32_t)(value)))
#define FLEXIO_CLR_SHIFTBUFBYS(base, index, value) (BME_AND32(&FLEXIO_SHIFTBUFBYS_REG(base, index), (uint32_t)(~(value))))
#define FLEXIO_TOG_SHIFTBUFBYS(base, index, value) (BME_XOR32(&FLEXIO_SHIFTBUFBYS_REG(base, index), (uint32_t)(value)))
/*@}*/

/*******************************************************************************
 * FLEXIO_SHIFTBUFBBS - Shifter Buffer N Bit Byte Swapped Register
 ******************************************************************************/

/*!
 * @brief FLEXIO_SHIFTBUFBBS - Shifter Buffer N Bit Byte Swapped Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * .
 */
/*!
 * @name Constants and macros for entire FLEXIO_SHIFTBUFBBS register
 */
/*@{*/
#define FLEXIO_RD_SHIFTBUFBBS(base, index) (FLEXIO_SHIFTBUFBBS_REG(base, index))
#define FLEXIO_WR_SHIFTBUFBBS(base, index, value) (FLEXIO_SHIFTBUFBBS_REG(base, index) = (value))
#define FLEXIO_RMW_SHIFTBUFBBS(base, index, mask, value) (FLEXIO_WR_SHIFTBUFBBS(base, index, (FLEXIO_RD_SHIFTBUFBBS(base, index) & ~(mask)) | (value)))
#define FLEXIO_SET_SHIFTBUFBBS(base, index, value) (BME_OR32(&FLEXIO_SHIFTBUFBBS_REG(base, index), (uint32_t)(value)))
#define FLEXIO_CLR_SHIFTBUFBBS(base, index, value) (BME_AND32(&FLEXIO_SHIFTBUFBBS_REG(base, index), (uint32_t)(~(value))))
#define FLEXIO_TOG_SHIFTBUFBBS(base, index, value) (BME_XOR32(&FLEXIO_SHIFTBUFBBS_REG(base, index), (uint32_t)(value)))
/*@}*/

/*******************************************************************************
 * FLEXIO_TIMCTL - Timer Control N Register
 ******************************************************************************/

/*!
 * @brief FLEXIO_TIMCTL - Timer Control N Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * .
 */
/*!
 * @name Constants and macros for entire FLEXIO_TIMCTL register
 */
/*@{*/
#define FLEXIO_RD_TIMCTL(base, index) (FLEXIO_TIMCTL_REG(base, index))
#define FLEXIO_WR_TIMCTL(base, index, value) (FLEXIO_TIMCTL_REG(base, index) = (value))
#define FLEXIO_RMW_TIMCTL(base, index, mask, value) (FLEXIO_WR_TIMCTL(base, index, (FLEXIO_RD_TIMCTL(base, index) & ~(mask)) | (value)))
#define FLEXIO_SET_TIMCTL(base, index, value) (BME_OR32(&FLEXIO_TIMCTL_REG(base, index), (uint32_t)(value)))
#define FLEXIO_CLR_TIMCTL(base, index, value) (BME_AND32(&FLEXIO_TIMCTL_REG(base, index), (uint32_t)(~(value))))
#define FLEXIO_TOG_TIMCTL(base, index, value) (BME_XOR32(&FLEXIO_TIMCTL_REG(base, index), (uint32_t)(value)))
/*@}*/

/*
 * Constants & macros for individual FLEXIO_TIMCTL bitfields
 */

/*!
 * @name Register FLEXIO_TIMCTL, field TIMOD[1:0] (RW)
 *
 * In 8-bit counter mode, the lower 8-bits of the counter and compare register
 * are used to configure the baud rate of the timer shift clock and the upper
 * 8-bits are used to configure the shifter bit count. In 8-bit PWM mode, the lower
 * 8-bits of the counter and compare register are used to configure the high
 * period of the timer shift clock and the upper 8-bits are used to configure the low
 * period of the timer shift clock. The shifter bit count is configured using
 * another timer or external signal. In 16-bit counter mode, the full 16-bits of the
 * counter and compare register are used to configure either the baud rate of
 * the shift clock or the shifter bit count.
 *
 * Values:
 * - 00 - Timer Disabled.
 * - 01 - Dual 8-bit counters baud/bit mode.
 * - 10 - Dual 8-bit counters PWM mode.
 * - 11 - Single 16-bit counter mode.
 */
/*@{*/
/*! @brief Read current value of the FLEXIO_TIMCTL_TIMOD field. */
#define FLEXIO_RD_TIMCTL_TIMOD(base, index) ((FLEXIO_TIMCTL_REG(base, index) & FLEXIO_TIMCTL_TIMOD_MASK) >> FLEXIO_TIMCTL_TIMOD_SHIFT)
#define FLEXIO_BRD_TIMCTL_TIMOD(base, index) (BME_UBFX32(&FLEXIO_TIMCTL_REG(base, index), FLEXIO_TIMCTL_TIMOD_SHIFT, FLEXIO_TIMCTL_TIMOD_WIDTH))

/*! @brief Set the TIMOD field to a new value. */
#define FLEXIO_WR_TIMCTL_TIMOD(base, index, value) (FLEXIO_RMW_TIMCTL(base, index, FLEXIO_TIMCTL_TIMOD_MASK, FLEXIO_TIMCTL_TIMOD(value)))
#define FLEXIO_BWR_TIMCTL_TIMOD(base, index, value) (BME_BFI32(&FLEXIO_TIMCTL_REG(base, index), ((uint32_t)(value) << FLEXIO_TIMCTL_TIMOD_SHIFT), FLEXIO_TIMCTL_TIMOD_SHIFT, FLEXIO_TIMCTL_TIMOD_WIDTH))
/*@}*/

/*!
 * @name Register FLEXIO_TIMCTL, field PINPOL[7] (RW)
 *
 * Values:
 * - 0 - Pin is active high
 * - 1 - Pin is active low
 */
/*@{*/
/*! @brief Read current value of the FLEXIO_TIMCTL_PINPOL field. */
#define FLEXIO_RD_TIMCTL_PINPOL(base, index) ((FLEXIO_TIMCTL_REG(base, index) & FLEXIO_TIMCTL_PINPOL_MASK) >> FLEXIO_TIMCTL_PINPOL_SHIFT)
#define FLEXIO_BRD_TIMCTL_PINPOL(base, index) (BME_UBFX32(&FLEXIO_TIMCTL_REG(base, index), FLEXIO_TIMCTL_PINPOL_SHIFT, FLEXIO_TIMCTL_PINPOL_WIDTH))

/*! @brief Set the PINPOL field to a new value. */
#define FLEXIO_WR_TIMCTL_PINPOL(base, index, value) (FLEXIO_RMW_TIMCTL(base, index, FLEXIO_TIMCTL_PINPOL_MASK, FLEXIO_TIMCTL_PINPOL(value)))
#define FLEXIO_BWR_TIMCTL_PINPOL(base, index, value) (BME_BFI32(&FLEXIO_TIMCTL_REG(base, index), ((uint32_t)(value) << FLEXIO_TIMCTL_PINPOL_SHIFT), FLEXIO_TIMCTL_PINPOL_SHIFT, FLEXIO_TIMCTL_PINPOL_WIDTH))
/*@}*/

/*!
 * @name Register FLEXIO_TIMCTL, field PINSEL[10:8] (RW)
 *
 * Selects which pin is used by the Timer input or output.
 */
/*@{*/
/*! @brief Read current value of the FLEXIO_TIMCTL_PINSEL field. */
#define FLEXIO_RD_TIMCTL_PINSEL(base, index) ((FLEXIO_TIMCTL_REG(base, index) & FLEXIO_TIMCTL_PINSEL_MASK) >> FLEXIO_TIMCTL_PINSEL_SHIFT)
#define FLEXIO_BRD_TIMCTL_PINSEL(base, index) (BME_UBFX32(&FLEXIO_TIMCTL_REG(base, index), FLEXIO_TIMCTL_PINSEL_SHIFT, FLEXIO_TIMCTL_PINSEL_WIDTH))

/*! @brief Set the PINSEL field to a new value. */
#define FLEXIO_WR_TIMCTL_PINSEL(base, index, value) (FLEXIO_RMW_TIMCTL(base, index, FLEXIO_TIMCTL_PINSEL_MASK, FLEXIO_TIMCTL_PINSEL(value)))
#define FLEXIO_BWR_TIMCTL_PINSEL(base, index, value) (BME_BFI32(&FLEXIO_TIMCTL_REG(base, index), ((uint32_t)(value) << FLEXIO_TIMCTL_PINSEL_SHIFT), FLEXIO_TIMCTL_PINSEL_SHIFT, FLEXIO_TIMCTL_PINSEL_WIDTH))
/*@}*/

/*!
 * @name Register FLEXIO_TIMCTL, field PINCFG[17:16] (RW)
 *
 * Values:
 * - 00 - Timer pin output disabled
 * - 01 - Timer pin open drain or bidirectional output enable
 * - 10 - Timer pin bidirectional output data
 * - 11 - Timer pin output
 */
/*@{*/
/*! @brief Read current value of the FLEXIO_TIMCTL_PINCFG field. */
#define FLEXIO_RD_TIMCTL_PINCFG(base, index) ((FLEXIO_TIMCTL_REG(base, index) & FLEXIO_TIMCTL_PINCFG_MASK) >> FLEXIO_TIMCTL_PINCFG_SHIFT)
#define FLEXIO_BRD_TIMCTL_PINCFG(base, index) (BME_UBFX32(&FLEXIO_TIMCTL_REG(base, index), FLEXIO_TIMCTL_PINCFG_SHIFT, FLEXIO_TIMCTL_PINCFG_WIDTH))

/*! @brief Set the PINCFG field to a new value. */
#define FLEXIO_WR_TIMCTL_PINCFG(base, index, value) (FLEXIO_RMW_TIMCTL(base, index, FLEXIO_TIMCTL_PINCFG_MASK, FLEXIO_TIMCTL_PINCFG(value)))
#define FLEXIO_BWR_TIMCTL_PINCFG(base, index, value) (BME_BFI32(&FLEXIO_TIMCTL_REG(base, index), ((uint32_t)(value) << FLEXIO_TIMCTL_PINCFG_SHIFT), FLEXIO_TIMCTL_PINCFG_SHIFT, FLEXIO_TIMCTL_PINCFG_WIDTH))
/*@}*/

/*!
 * @name Register FLEXIO_TIMCTL, field TRGSRC[22] (RW)
 *
 * Values:
 * - 0 - External trigger selected
 * - 1 - Internal trigger selected
 */
/*@{*/
/*! @brief Read current value of the FLEXIO_TIMCTL_TRGSRC field. */
#define FLEXIO_RD_TIMCTL_TRGSRC(base, index) ((FLEXIO_TIMCTL_REG(base, index) & FLEXIO_TIMCTL_TRGSRC_MASK) >> FLEXIO_TIMCTL_TRGSRC_SHIFT)
#define FLEXIO_BRD_TIMCTL_TRGSRC(base, index) (BME_UBFX32(&FLEXIO_TIMCTL_REG(base, index), FLEXIO_TIMCTL_TRGSRC_SHIFT, FLEXIO_TIMCTL_TRGSRC_WIDTH))

/*! @brief Set the TRGSRC field to a new value. */
#define FLEXIO_WR_TIMCTL_TRGSRC(base, index, value) (FLEXIO_RMW_TIMCTL(base, index, FLEXIO_TIMCTL_TRGSRC_MASK, FLEXIO_TIMCTL_TRGSRC(value)))
#define FLEXIO_BWR_TIMCTL_TRGSRC(base, index, value) (BME_BFI32(&FLEXIO_TIMCTL_REG(base, index), ((uint32_t)(value) << FLEXIO_TIMCTL_TRGSRC_SHIFT), FLEXIO_TIMCTL_TRGSRC_SHIFT, FLEXIO_TIMCTL_TRGSRC_WIDTH))
/*@}*/

/*!
 * @name Register FLEXIO_TIMCTL, field TRGPOL[23] (RW)
 *
 * Values:
 * - 0 - Trigger active high
 * - 1 - Trigger active low
 */
/*@{*/
/*! @brief Read current value of the FLEXIO_TIMCTL_TRGPOL field. */
#define FLEXIO_RD_TIMCTL_TRGPOL(base, index) ((FLEXIO_TIMCTL_REG(base, index) & FLEXIO_TIMCTL_TRGPOL_MASK) >> FLEXIO_TIMCTL_TRGPOL_SHIFT)
#define FLEXIO_BRD_TIMCTL_TRGPOL(base, index) (BME_UBFX32(&FLEXIO_TIMCTL_REG(base, index), FLEXIO_TIMCTL_TRGPOL_SHIFT, FLEXIO_TIMCTL_TRGPOL_WIDTH))

/*! @brief Set the TRGPOL field to a new value. */
#define FLEXIO_WR_TIMCTL_TRGPOL(base, index, value) (FLEXIO_RMW_TIMCTL(base, index, FLEXIO_TIMCTL_TRGPOL_MASK, FLEXIO_TIMCTL_TRGPOL(value)))
#define FLEXIO_BWR_TIMCTL_TRGPOL(base, index, value) (BME_BFI32(&FLEXIO_TIMCTL_REG(base, index), ((uint32_t)(value) << FLEXIO_TIMCTL_TRGPOL_SHIFT), FLEXIO_TIMCTL_TRGPOL_SHIFT, FLEXIO_TIMCTL_TRGPOL_WIDTH))
/*@}*/

/*!
 * @name Register FLEXIO_TIMCTL, field TRGSEL[27:24] (RW)
 *
 * Refer to the chip configuration section for external trigger selection. The
 * internal trigger selection is configured as follows.
 */
/*@{*/
/*! @brief Read current value of the FLEXIO_TIMCTL_TRGSEL field. */
#define FLEXIO_RD_TIMCTL_TRGSEL(base, index) ((FLEXIO_TIMCTL_REG(base, index) & FLEXIO_TIMCTL_TRGSEL_MASK) >> FLEXIO_TIMCTL_TRGSEL_SHIFT)
#define FLEXIO_BRD_TIMCTL_TRGSEL(base, index) (BME_UBFX32(&FLEXIO_TIMCTL_REG(base, index), FLEXIO_TIMCTL_TRGSEL_SHIFT, FLEXIO_TIMCTL_TRGSEL_WIDTH))

/*! @brief Set the TRGSEL field to a new value. */
#define FLEXIO_WR_TIMCTL_TRGSEL(base, index, value) (FLEXIO_RMW_TIMCTL(base, index, FLEXIO_TIMCTL_TRGSEL_MASK, FLEXIO_TIMCTL_TRGSEL(value)))
#define FLEXIO_BWR_TIMCTL_TRGSEL(base, index, value) (BME_BFI32(&FLEXIO_TIMCTL_REG(base, index), ((uint32_t)(value) << FLEXIO_TIMCTL_TRGSEL_SHIFT), FLEXIO_TIMCTL_TRGSEL_SHIFT, FLEXIO_TIMCTL_TRGSEL_WIDTH))
/*@}*/

/*******************************************************************************
 * FLEXIO_TIMCFG - Timer Configuration N Register
 ******************************************************************************/

/*!
 * @brief FLEXIO_TIMCFG - Timer Configuration N Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * The options to enable or disable the timer using the Timer N-1 enable or
 * disable are reserved when N is evenly divisible by 4 (eg: Timer 0).
 */
/*!
 * @name Constants and macros for entire FLEXIO_TIMCFG register
 */
/*@{*/
#define FLEXIO_RD_TIMCFG(base, index) (FLEXIO_TIMCFG_REG(base, index))
#define FLEXIO_WR_TIMCFG(base, index, value) (FLEXIO_TIMCFG_REG(base, index) = (value))
#define FLEXIO_RMW_TIMCFG(base, index, mask, value) (FLEXIO_WR_TIMCFG(base, index, (FLEXIO_RD_TIMCFG(base, index) & ~(mask)) | (value)))
#define FLEXIO_SET_TIMCFG(base, index, value) (BME_OR32(&FLEXIO_TIMCFG_REG(base, index), (uint32_t)(value)))
#define FLEXIO_CLR_TIMCFG(base, index, value) (BME_AND32(&FLEXIO_TIMCFG_REG(base, index), (uint32_t)(~(value))))
#define FLEXIO_TOG_TIMCFG(base, index, value) (BME_XOR32(&FLEXIO_TIMCFG_REG(base, index), (uint32_t)(value)))
/*@}*/

/*
 * Constants & macros for individual FLEXIO_TIMCFG bitfields
 */

/*!
 * @name Register FLEXIO_TIMCFG, field TSTART[1] (RW)
 *
 * When start bit is enabled, configured shifters will output the contents of
 * the start bit when the timer is enabled and the timer counter will reload from
 * the compare register on the first rising edge of the shift clock.
 *
 * Values:
 * - 0 - Start bit disabled
 * - 1 - Start bit enabled
 */
/*@{*/
/*! @brief Read current value of the FLEXIO_TIMCFG_TSTART field. */
#define FLEXIO_RD_TIMCFG_TSTART(base, index) ((FLEXIO_TIMCFG_REG(base, index) & FLEXIO_TIMCFG_TSTART_MASK) >> FLEXIO_TIMCFG_TSTART_SHIFT)
#define FLEXIO_BRD_TIMCFG_TSTART(base, index) (BME_UBFX32(&FLEXIO_TIMCFG_REG(base, index), FLEXIO_TIMCFG_TSTART_SHIFT, FLEXIO_TIMCFG_TSTART_WIDTH))

/*! @brief Set the TSTART field to a new value. */
#define FLEXIO_WR_TIMCFG_TSTART(base, index, value) (FLEXIO_RMW_TIMCFG(base, index, FLEXIO_TIMCFG_TSTART_MASK, FLEXIO_TIMCFG_TSTART(value)))
#define FLEXIO_BWR_TIMCFG_TSTART(base, index, value) (BME_BFI32(&FLEXIO_TIMCFG_REG(base, index), ((uint32_t)(value) << FLEXIO_TIMCFG_TSTART_SHIFT), FLEXIO_TIMCFG_TSTART_SHIFT, FLEXIO_TIMCFG_TSTART_WIDTH))
/*@}*/

/*!
 * @name Register FLEXIO_TIMCFG, field TSTOP[5:4] (RW)
 *
 * The stop bit can be added on a timer compare (between each word) or on a
 * timer disable. When stop bit is enabled, configured shifters will output the
 * contents of the stop bit when the timer is disabled. When stop bit is enabled on
 * timer disable, the timer remains disabled until the next rising edge of the
 * shift clock. If configured for both timer compare and timer disable, only one stop
 * bit is inserted on timer disable.
 *
 * Values:
 * - 00 - Stop bit disabled
 * - 01 - Stop bit is enabled on timer compare
 * - 10 - Stop bit is enabled on timer disable
 * - 11 - Stop bit is enabled on timer compare and timer disable
 */
/*@{*/
/*! @brief Read current value of the FLEXIO_TIMCFG_TSTOP field. */
#define FLEXIO_RD_TIMCFG_TSTOP(base, index) ((FLEXIO_TIMCFG_REG(base, index) & FLEXIO_TIMCFG_TSTOP_MASK) >> FLEXIO_TIMCFG_TSTOP_SHIFT)
#define FLEXIO_BRD_TIMCFG_TSTOP(base, index) (BME_UBFX32(&FLEXIO_TIMCFG_REG(base, index), FLEXIO_TIMCFG_TSTOP_SHIFT, FLEXIO_TIMCFG_TSTOP_WIDTH))

/*! @brief Set the TSTOP field to a new value. */
#define FLEXIO_WR_TIMCFG_TSTOP(base, index, value) (FLEXIO_RMW_TIMCFG(base, index, FLEXIO_TIMCFG_TSTOP_MASK, FLEXIO_TIMCFG_TSTOP(value)))
#define FLEXIO_BWR_TIMCFG_TSTOP(base, index, value) (BME_BFI32(&FLEXIO_TIMCFG_REG(base, index), ((uint32_t)(value) << FLEXIO_TIMCFG_TSTOP_SHIFT), FLEXIO_TIMCFG_TSTOP_SHIFT, FLEXIO_TIMCFG_TSTOP_WIDTH))
/*@}*/

/*!
 * @name Register FLEXIO_TIMCFG, field TIMENA[10:8] (RW)
 *
 * Configures the condition that causes the Timer to be enabled and start
 * decrementing.
 *
 * Values:
 * - 000 - Timer always enabled
 * - 001 - Timer enabled on Timer N-1 enable
 * - 010 - Timer enabled on Trigger high
 * - 011 - Timer enabled on Trigger high and Pin high
 * - 100 - Timer enabled on Pin rising edge
 * - 101 - Timer enabled on Pin rising edge and Trigger high
 * - 110 - Timer enabled on Trigger rising edge
 * - 111 - Timer enabled on Trigger rising or falling edge
 */
/*@{*/
/*! @brief Read current value of the FLEXIO_TIMCFG_TIMENA field. */
#define FLEXIO_RD_TIMCFG_TIMENA(base, index) ((FLEXIO_TIMCFG_REG(base, index) & FLEXIO_TIMCFG_TIMENA_MASK) >> FLEXIO_TIMCFG_TIMENA_SHIFT)
#define FLEXIO_BRD_TIMCFG_TIMENA(base, index) (BME_UBFX32(&FLEXIO_TIMCFG_REG(base, index), FLEXIO_TIMCFG_TIMENA_SHIFT, FLEXIO_TIMCFG_TIMENA_WIDTH))

/*! @brief Set the TIMENA field to a new value. */
#define FLEXIO_WR_TIMCFG_TIMENA(base, index, value) (FLEXIO_RMW_TIMCFG(base, index, FLEXIO_TIMCFG_TIMENA_MASK, FLEXIO_TIMCFG_TIMENA(value)))
#define FLEXIO_BWR_TIMCFG_TIMENA(base, index, value) (BME_BFI32(&FLEXIO_TIMCFG_REG(base, index), ((uint32_t)(value) << FLEXIO_TIMCFG_TIMENA_SHIFT), FLEXIO_TIMCFG_TIMENA_SHIFT, FLEXIO_TIMCFG_TIMENA_WIDTH))
/*@}*/

/*!
 * @name Register FLEXIO_TIMCFG, field TIMDIS[14:12] (RW)
 *
 * Configures the condition that causes the Timer to be disabled and stop
 * decrementing.
 *
 * Values:
 * - 000 - Timer never disabled
 * - 001 - Timer disabled on Timer N-1 disable
 * - 010 - Timer disabled on Timer compare
 * - 011 - Timer disabled on Timer compare and Trigger Low
 * - 100 - Timer disabled on Pin rising or falling edge
 * - 101 - Timer disabled on Pin rising or falling edge provided Trigger is high
 * - 110 - Timer disabled on Trigger falling edge
 * - 111 - Reserved
 */
/*@{*/
/*! @brief Read current value of the FLEXIO_TIMCFG_TIMDIS field. */
#define FLEXIO_RD_TIMCFG_TIMDIS(base, index) ((FLEXIO_TIMCFG_REG(base, index) & FLEXIO_TIMCFG_TIMDIS_MASK) >> FLEXIO_TIMCFG_TIMDIS_SHIFT)
#define FLEXIO_BRD_TIMCFG_TIMDIS(base, index) (BME_UBFX32(&FLEXIO_TIMCFG_REG(base, index), FLEXIO_TIMCFG_TIMDIS_SHIFT, FLEXIO_TIMCFG_TIMDIS_WIDTH))

/*! @brief Set the TIMDIS field to a new value. */
#define FLEXIO_WR_TIMCFG_TIMDIS(base, index, value) (FLEXIO_RMW_TIMCFG(base, index, FLEXIO_TIMCFG_TIMDIS_MASK, FLEXIO_TIMCFG_TIMDIS(value)))
#define FLEXIO_BWR_TIMCFG_TIMDIS(base, index, value) (BME_BFI32(&FLEXIO_TIMCFG_REG(base, index), ((uint32_t)(value) << FLEXIO_TIMCFG_TIMDIS_SHIFT), FLEXIO_TIMCFG_TIMDIS_SHIFT, FLEXIO_TIMCFG_TIMDIS_WIDTH))
/*@}*/

/*!
 * @name Register FLEXIO_TIMCFG, field TIMRST[18:16] (RW)
 *
 * Configures the condition that causes the timer counter (and optionally the
 * timer output) to be reset. In 8-bit counter mode, the timer reset will only
 * reset the lower 8-bits that configure the baud rate. In all other modes, the timer
 * reset will reset the full 16-bits of the counter.
 *
 * Values:
 * - 000 - Timer never reset
 * - 001 - Reserved
 * - 010 - Timer reset on Timer Pin equal to Timer Output
 * - 011 - Timer reset on Timer Trigger equal to Timer Output
 * - 100 - Timer reset on Timer Pin rising edge
 * - 101 - Reserved
 * - 110 - Timer reset on Trigger rising edge
 * - 111 - Timer reset on Trigger rising or falling edge
 */
/*@{*/
/*! @brief Read current value of the FLEXIO_TIMCFG_TIMRST field. */
#define FLEXIO_RD_TIMCFG_TIMRST(base, index) ((FLEXIO_TIMCFG_REG(base, index) & FLEXIO_TIMCFG_TIMRST_MASK) >> FLEXIO_TIMCFG_TIMRST_SHIFT)
#define FLEXIO_BRD_TIMCFG_TIMRST(base, index) (BME_UBFX32(&FLEXIO_TIMCFG_REG(base, index), FLEXIO_TIMCFG_TIMRST_SHIFT, FLEXIO_TIMCFG_TIMRST_WIDTH))

/*! @brief Set the TIMRST field to a new value. */
#define FLEXIO_WR_TIMCFG_TIMRST(base, index, value) (FLEXIO_RMW_TIMCFG(base, index, FLEXIO_TIMCFG_TIMRST_MASK, FLEXIO_TIMCFG_TIMRST(value)))
#define FLEXIO_BWR_TIMCFG_TIMRST(base, index, value) (BME_BFI32(&FLEXIO_TIMCFG_REG(base, index), ((uint32_t)(value) << FLEXIO_TIMCFG_TIMRST_SHIFT), FLEXIO_TIMCFG_TIMRST_SHIFT, FLEXIO_TIMCFG_TIMRST_WIDTH))
/*@}*/

/*!
 * @name Register FLEXIO_TIMCFG, field TIMDEC[21:20] (RW)
 *
 * Configures the source of the Timer decrement and the source of the Shift
 * clock.
 *
 * Values:
 * - 00 - Decrement counter on FlexIO clock, Shift clock equals Timer output.
 * - 01 - Decrement counter on Trigger input (both edges), Shift clock equals
 *     Timer output.
 * - 10 - Decrement counter on Pin input (both edges), Shift clock equals Pin
 *     input.
 * - 11 - Decrement counter on Trigger input (both edges), Shift clock equals
 *     Trigger input.
 */
/*@{*/
/*! @brief Read current value of the FLEXIO_TIMCFG_TIMDEC field. */
#define FLEXIO_RD_TIMCFG_TIMDEC(base, index) ((FLEXIO_TIMCFG_REG(base, index) & FLEXIO_TIMCFG_TIMDEC_MASK) >> FLEXIO_TIMCFG_TIMDEC_SHIFT)
#define FLEXIO_BRD_TIMCFG_TIMDEC(base, index) (BME_UBFX32(&FLEXIO_TIMCFG_REG(base, index), FLEXIO_TIMCFG_TIMDEC_SHIFT, FLEXIO_TIMCFG_TIMDEC_WIDTH))

/*! @brief Set the TIMDEC field to a new value. */
#define FLEXIO_WR_TIMCFG_TIMDEC(base, index, value) (FLEXIO_RMW_TIMCFG(base, index, FLEXIO_TIMCFG_TIMDEC_MASK, FLEXIO_TIMCFG_TIMDEC(value)))
#define FLEXIO_BWR_TIMCFG_TIMDEC(base, index, value) (BME_BFI32(&FLEXIO_TIMCFG_REG(base, index), ((uint32_t)(value) << FLEXIO_TIMCFG_TIMDEC_SHIFT), FLEXIO_TIMCFG_TIMDEC_SHIFT, FLEXIO_TIMCFG_TIMDEC_WIDTH))
/*@}*/

/*!
 * @name Register FLEXIO_TIMCFG, field TIMOUT[25:24] (RW)
 *
 * Configures the initial state of the Timer Output and whether it is affected
 * by the Timer reset.
 *
 * Values:
 * - 00 - Timer output is logic one when enabled and is not affected by timer
 *     reset
 * - 01 - Timer output is logic zero when enabled and is not affected by timer
 *     reset
 * - 10 - Timer output is logic one when enabled and on timer reset
 * - 11 - Timer output is logic zero when enabled and on timer reset
 */
/*@{*/
/*! @brief Read current value of the FLEXIO_TIMCFG_TIMOUT field. */
#define FLEXIO_RD_TIMCFG_TIMOUT(base, index) ((FLEXIO_TIMCFG_REG(base, index) & FLEXIO_TIMCFG_TIMOUT_MASK) >> FLEXIO_TIMCFG_TIMOUT_SHIFT)
#define FLEXIO_BRD_TIMCFG_TIMOUT(base, index) (BME_UBFX32(&FLEXIO_TIMCFG_REG(base, index), FLEXIO_TIMCFG_TIMOUT_SHIFT, FLEXIO_TIMCFG_TIMOUT_WIDTH))

/*! @brief Set the TIMOUT field to a new value. */
#define FLEXIO_WR_TIMCFG_TIMOUT(base, index, value) (FLEXIO_RMW_TIMCFG(base, index, FLEXIO_TIMCFG_TIMOUT_MASK, FLEXIO_TIMCFG_TIMOUT(value)))
#define FLEXIO_BWR_TIMCFG_TIMOUT(base, index, value) (BME_BFI32(&FLEXIO_TIMCFG_REG(base, index), ((uint32_t)(value) << FLEXIO_TIMCFG_TIMOUT_SHIFT), FLEXIO_TIMCFG_TIMOUT_SHIFT, FLEXIO_TIMCFG_TIMOUT_WIDTH))
/*@}*/

/*******************************************************************************
 * FLEXIO_TIMCMP - Timer Compare N Register
 ******************************************************************************/

/*!
 * @brief FLEXIO_TIMCMP - Timer Compare N Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * .
 */
/*!
 * @name Constants and macros for entire FLEXIO_TIMCMP register
 */
/*@{*/
#define FLEXIO_RD_TIMCMP(base, index) (FLEXIO_TIMCMP_REG(base, index))
#define FLEXIO_WR_TIMCMP(base, index, value) (FLEXIO_TIMCMP_REG(base, index) = (value))
#define FLEXIO_RMW_TIMCMP(base, index, mask, value) (FLEXIO_WR_TIMCMP(base, index, (FLEXIO_RD_TIMCMP(base, index) & ~(mask)) | (value)))
#define FLEXIO_SET_TIMCMP(base, index, value) (BME_OR32(&FLEXIO_TIMCMP_REG(base, index), (uint32_t)(value)))
#define FLEXIO_CLR_TIMCMP(base, index, value) (BME_AND32(&FLEXIO_TIMCMP_REG(base, index), (uint32_t)(~(value))))
#define FLEXIO_TOG_TIMCMP(base, index, value) (BME_XOR32(&FLEXIO_TIMCMP_REG(base, index), (uint32_t)(value)))
/*@}*/

/*
 * Constants & macros for individual FLEXIO_TIMCMP bitfields
 */

/*!
 * @name Register FLEXIO_TIMCMP, field CMP[15:0] (RW)
 *
 * The timer compare value is loaded into the timer counter when the timer is
 * first enabled, when the timer is reset and when the timer decrements down to
 * zero. In dual 8-bit counters baud/bit mode, the lower 8-bits configures the baud
 * rate divider equal to (CMP[7:0] + 1) * 2. The upper 8-bits configure the
 * number of bits in each word equal to (CMP[15:8] + 1) / 2. In dual 8-bit counters
 * PWM mode, the lower 8-bits configure the high period of the output to (CMP[7:0]
 * + 1) * 2. The upper 8-bits configure the low period of the output to
 * (CMP[15:8] + 1) * 2. In 16-bit counter mode, the compare value can be used to generate
 * the baud rate divider (if shift clock source is timer output) to equal
 * (CMP[15:0] + 1) * 2. When the shift clock source is a pin or trigger input, the
 * compare register is used to set the number of bits in each word equal to (CMP[15:0]
 * + 1) / 2.
 */
/*@{*/
/*! @brief Read current value of the FLEXIO_TIMCMP_CMP field. */
#define FLEXIO_RD_TIMCMP_CMP(base, index) ((FLEXIO_TIMCMP_REG(base, index) & FLEXIO_TIMCMP_CMP_MASK) >> FLEXIO_TIMCMP_CMP_SHIFT)
#define FLEXIO_BRD_TIMCMP_CMP(base, index) (BME_UBFX32(&FLEXIO_TIMCMP_REG(base, index), FLEXIO_TIMCMP_CMP_SHIFT, FLEXIO_TIMCMP_CMP_WIDTH))

/*! @brief Set the CMP field to a new value. */
#define FLEXIO_WR_TIMCMP_CMP(base, index, value) (FLEXIO_RMW_TIMCMP(base, index, FLEXIO_TIMCMP_CMP_MASK, FLEXIO_TIMCMP_CMP(value)))
#define FLEXIO_BWR_TIMCMP_CMP(base, index, value) (BME_BFI32(&FLEXIO_TIMCMP_REG(base, index), ((uint32_t)(value) << FLEXIO_TIMCMP_CMP_SHIFT), FLEXIO_TIMCMP_CMP_SHIFT, FLEXIO_TIMCMP_CMP_WIDTH))
/*@}*/

/*
 * MKL27Z644 FTFA
 *
 * Flash Memory Interface
 *
 * Registers defined in this header file:
 * - FTFA_FSTAT - Flash Status Register
 * - FTFA_FCNFG - Flash Configuration Register
 * - FTFA_FSEC - Flash Security Register
 * - FTFA_FOPT - Flash Option Register
 * - FTFA_FCCOB3 - Flash Common Command Object Registers
 * - FTFA_FCCOB2 - Flash Common Command Object Registers
 * - FTFA_FCCOB1 - Flash Common Command Object Registers
 * - FTFA_FCCOB0 - Flash Common Command Object Registers
 * - FTFA_FCCOB7 - Flash Common Command Object Registers
 * - FTFA_FCCOB6 - Flash Common Command Object Registers
 * - FTFA_FCCOB5 - Flash Common Command Object Registers
 * - FTFA_FCCOB4 - Flash Common Command Object Registers
 * - FTFA_FCCOBB - Flash Common Command Object Registers
 * - FTFA_FCCOBA - Flash Common Command Object Registers
 * - FTFA_FCCOB9 - Flash Common Command Object Registers
 * - FTFA_FCCOB8 - Flash Common Command Object Registers
 * - FTFA_FPROT3 - Program Flash Protection Registers
 * - FTFA_FPROT2 - Program Flash Protection Registers
 * - FTFA_FPROT1 - Program Flash Protection Registers
 * - FTFA_FPROT0 - Program Flash Protection Registers
 */

#define FTFA_INSTANCE_COUNT (1U) /*!< Number of instances of the FTFA module. */
#define FTFA_IDX (0U) /*!< Instance number for FTFA. */

/*******************************************************************************
 * FTFA_FSTAT - Flash Status Register
 ******************************************************************************/

/*!
 * @brief FTFA_FSTAT - Flash Status Register (RW)
 *
 * Reset value: 0x00U
 *
 * The FSTAT register reports the operational status of the flash memory module.
 * The CCIF, RDCOLERR, ACCERR, and FPVIOL bits are readable and writable. The
 * MGSTAT0 bit is read only. The unassigned bits read 0 and are not writable. When
 * set, the Access Error (ACCERR) and Flash Protection Violation (FPVIOL) bits in
 * this register prevent the launch of any more commands until the flag is
 * cleared (by writing a one to it).
 */
/*!
 * @name Constants and macros for entire FTFA_FSTAT register
 */
/*@{*/
#define FTFA_RD_FSTAT(base)      (FTFA_FSTAT_REG(base))
#define FTFA_WR_FSTAT(base, value) (FTFA_FSTAT_REG(base) = (value))
#define FTFA_RMW_FSTAT(base, mask, value) (FTFA_WR_FSTAT(base, (FTFA_RD_FSTAT(base) & ~(mask)) | (value)))
#define FTFA_SET_FSTAT(base, value) (BME_OR8(&FTFA_FSTAT_REG(base), (uint8_t)(value)))
#define FTFA_CLR_FSTAT(base, value) (BME_AND8(&FTFA_FSTAT_REG(base), (uint8_t)(~(value))))
#define FTFA_TOG_FSTAT(base, value) (BME_XOR8(&FTFA_FSTAT_REG(base), (uint8_t)(value)))
/*@}*/

/*
 * Constants & macros for individual FTFA_FSTAT bitfields
 */

/*!
 * @name Register FTFA_FSTAT, field MGSTAT0[0] (RO)
 *
 * The MGSTAT0 status flag is set if an error is detected during execution of a
 * flash command or during the flash reset sequence. As a status flag, this field
 * cannot (and need not) be cleared by the user like the other error flags in
 * this register. The value of the MGSTAT0 bit for "command-N" is valid only at the
 * end of the "command-N" execution when CCIF=1 and before the next command has
 * been launched. At some point during the execution of "command-N+1," the
 * previous result is discarded and any previous error is cleared.
 */
/*@{*/
/*! @brief Read current value of the FTFA_FSTAT_MGSTAT0 field. */
#define FTFA_RD_FSTAT_MGSTAT0(base) ((FTFA_FSTAT_REG(base) & FTFA_FSTAT_MGSTAT0_MASK) >> FTFA_FSTAT_MGSTAT0_SHIFT)
#define FTFA_BRD_FSTAT_MGSTAT0(base) (BME_UBFX8(&FTFA_FSTAT_REG(base), FTFA_FSTAT_MGSTAT0_SHIFT, FTFA_FSTAT_MGSTAT0_WIDTH))
/*@}*/

/*!
 * @name Register FTFA_FSTAT, field FPVIOL[4] (W1C)
 *
 * Indicates an attempt was made to program or erase an address in a protected
 * area of program flash memory during a command write sequence . While FPVIOL is
 * set, the CCIF flag cannot be cleared to launch a command. The FPVIOL bit is
 * cleared by writing a 1 to it. Writing a 0 to the FPVIOL bit has no effect.
 *
 * Values:
 * - 0 - No protection violation detected
 * - 1 - Protection violation detected
 */
/*@{*/
/*! @brief Read current value of the FTFA_FSTAT_FPVIOL field. */
#define FTFA_RD_FSTAT_FPVIOL(base) ((FTFA_FSTAT_REG(base) & FTFA_FSTAT_FPVIOL_MASK) >> FTFA_FSTAT_FPVIOL_SHIFT)
#define FTFA_BRD_FSTAT_FPVIOL(base) (BME_UBFX8(&FTFA_FSTAT_REG(base), FTFA_FSTAT_FPVIOL_SHIFT, FTFA_FSTAT_FPVIOL_WIDTH))

/*! @brief Set the FPVIOL field to a new value. */
#define FTFA_WR_FSTAT_FPVIOL(base, value) (FTFA_RMW_FSTAT(base, (FTFA_FSTAT_FPVIOL_MASK | FTFA_FSTAT_ACCERR_MASK | FTFA_FSTAT_RDCOLERR_MASK | FTFA_FSTAT_CCIF_MASK), FTFA_FSTAT_FPVIOL(value)))
#define FTFA_BWR_FSTAT_FPVIOL(base, value) (BME_BFI8(&FTFA_FSTAT_REG(base), ((uint8_t)(value) << FTFA_FSTAT_FPVIOL_SHIFT), FTFA_FSTAT_FPVIOL_SHIFT, FTFA_FSTAT_FPVIOL_WIDTH))
/*@}*/

/*!
 * @name Register FTFA_FSTAT, field ACCERR[5] (W1C)
 *
 * Indicates an illegal access has occurred to a flash memory resource caused by
 * a violation of the command write sequence or issuing an illegal flash
 * command. While ACCERR is set, the CCIF flag cannot be cleared to launch a command.
 * The ACCERR bit is cleared by writing a 1 to it. Writing a 0 to the ACCERR bit
 * has no effect.
 *
 * Values:
 * - 0 - No access error detected
 * - 1 - Access error detected
 */
/*@{*/
/*! @brief Read current value of the FTFA_FSTAT_ACCERR field. */
#define FTFA_RD_FSTAT_ACCERR(base) ((FTFA_FSTAT_REG(base) & FTFA_FSTAT_ACCERR_MASK) >> FTFA_FSTAT_ACCERR_SHIFT)
#define FTFA_BRD_FSTAT_ACCERR(base) (BME_UBFX8(&FTFA_FSTAT_REG(base), FTFA_FSTAT_ACCERR_SHIFT, FTFA_FSTAT_ACCERR_WIDTH))

/*! @brief Set the ACCERR field to a new value. */
#define FTFA_WR_FSTAT_ACCERR(base, value) (FTFA_RMW_FSTAT(base, (FTFA_FSTAT_ACCERR_MASK | FTFA_FSTAT_FPVIOL_MASK | FTFA_FSTAT_RDCOLERR_MASK | FTFA_FSTAT_CCIF_MASK), FTFA_FSTAT_ACCERR(value)))
#define FTFA_BWR_FSTAT_ACCERR(base, value) (BME_BFI8(&FTFA_FSTAT_REG(base), ((uint8_t)(value) << FTFA_FSTAT_ACCERR_SHIFT), FTFA_FSTAT_ACCERR_SHIFT, FTFA_FSTAT_ACCERR_WIDTH))
/*@}*/

/*!
 * @name Register FTFA_FSTAT, field RDCOLERR[6] (W1C)
 *
 * Indicates that the MCU attempted a read from a flash memory resource that was
 * being manipulated by a flash command (CCIF=0). Any simultaneous access is
 * detected as a collision error by the block arbitration logic. The read data in
 * this case cannot be guaranteed. The RDCOLERR bit is cleared by writing a 1 to
 * it. Writing a 0 to RDCOLERR has no effect.
 *
 * Values:
 * - 0 - No collision error detected
 * - 1 - Collision error detected
 */
/*@{*/
/*! @brief Read current value of the FTFA_FSTAT_RDCOLERR field. */
#define FTFA_RD_FSTAT_RDCOLERR(base) ((FTFA_FSTAT_REG(base) & FTFA_FSTAT_RDCOLERR_MASK) >> FTFA_FSTAT_RDCOLERR_SHIFT)
#define FTFA_BRD_FSTAT_RDCOLERR(base) (BME_UBFX8(&FTFA_FSTAT_REG(base), FTFA_FSTAT_RDCOLERR_SHIFT, FTFA_FSTAT_RDCOLERR_WIDTH))

/*! @brief Set the RDCOLERR field to a new value. */
#define FTFA_WR_FSTAT_RDCOLERR(base, value) (FTFA_RMW_FSTAT(base, (FTFA_FSTAT_RDCOLERR_MASK | FTFA_FSTAT_FPVIOL_MASK | FTFA_FSTAT_ACCERR_MASK | FTFA_FSTAT_CCIF_MASK), FTFA_FSTAT_RDCOLERR(value)))
#define FTFA_BWR_FSTAT_RDCOLERR(base, value) (BME_BFI8(&FTFA_FSTAT_REG(base), ((uint8_t)(value) << FTFA_FSTAT_RDCOLERR_SHIFT), FTFA_FSTAT_RDCOLERR_SHIFT, FTFA_FSTAT_RDCOLERR_WIDTH))
/*@}*/

/*!
 * @name Register FTFA_FSTAT, field CCIF[7] (W1C)
 *
 * Indicates that a flash command has completed. The CCIF flag is cleared by
 * writing a 1 to CCIF to launch a command, and CCIF stays low until command
 * completion or command violation. CCIF is reset to 0 but is set to 1 by the memory
 * controller at the end of the reset initialization sequence. Depending on how
 * quickly the read occurs after reset release, the user may or may not see the 0
 * hardware reset value.
 *
 * Values:
 * - 0 - Flash command in progress
 * - 1 - Flash command has completed
 */
/*@{*/
/*! @brief Read current value of the FTFA_FSTAT_CCIF field. */
#define FTFA_RD_FSTAT_CCIF(base) ((FTFA_FSTAT_REG(base) & FTFA_FSTAT_CCIF_MASK) >> FTFA_FSTAT_CCIF_SHIFT)
#define FTFA_BRD_FSTAT_CCIF(base) (BME_UBFX8(&FTFA_FSTAT_REG(base), FTFA_FSTAT_CCIF_SHIFT, FTFA_FSTAT_CCIF_WIDTH))

/*! @brief Set the CCIF field to a new value. */
#define FTFA_WR_FSTAT_CCIF(base, value) (FTFA_RMW_FSTAT(base, (FTFA_FSTAT_CCIF_MASK | FTFA_FSTAT_FPVIOL_MASK | FTFA_FSTAT_ACCERR_MASK | FTFA_FSTAT_RDCOLERR_MASK), FTFA_FSTAT_CCIF(value)))
#define FTFA_BWR_FSTAT_CCIF(base, value) (BME_BFI8(&FTFA_FSTAT_REG(base), ((uint8_t)(value) << FTFA_FSTAT_CCIF_SHIFT), FTFA_FSTAT_CCIF_SHIFT, FTFA_FSTAT_CCIF_WIDTH))
/*@}*/

/*******************************************************************************
 * FTFA_FCNFG - Flash Configuration Register
 ******************************************************************************/

/*!
 * @brief FTFA_FCNFG - Flash Configuration Register (RW)
 *
 * Reset value: 0x00U
 *
 * This register provides information on the current functional state of the
 * flash memory module. The erase control bits (ERSAREQ and ERSSUSP) have write
 * restrictions. The unassigned bits read as noted and are not writable.
 */
/*!
 * @name Constants and macros for entire FTFA_FCNFG register
 */
/*@{*/
#define FTFA_RD_FCNFG(base)      (FTFA_FCNFG_REG(base))
#define FTFA_WR_FCNFG(base, value) (FTFA_FCNFG_REG(base) = (value))
#define FTFA_RMW_FCNFG(base, mask, value) (FTFA_WR_FCNFG(base, (FTFA_RD_FCNFG(base) & ~(mask)) | (value)))
#define FTFA_SET_FCNFG(base, value) (BME_OR8(&FTFA_FCNFG_REG(base), (uint8_t)(value)))
#define FTFA_CLR_FCNFG(base, value) (BME_AND8(&FTFA_FCNFG_REG(base), (uint8_t)(~(value))))
#define FTFA_TOG_FCNFG(base, value) (BME_XOR8(&FTFA_FCNFG_REG(base), (uint8_t)(value)))
/*@}*/

/*
 * Constants & macros for individual FTFA_FCNFG bitfields
 */

/*!
 * @name Register FTFA_FCNFG, field ERSSUSP[4] (RW)
 *
 * Allows the user to suspend (interrupt) the Erase Flash Sector command while
 * it is executing.
 *
 * Values:
 * - 0 - No suspend requested
 * - 1 - Suspend the current Erase Flash Sector command execution.
 */
/*@{*/
/*! @brief Read current value of the FTFA_FCNFG_ERSSUSP field. */
#define FTFA_RD_FCNFG_ERSSUSP(base) ((FTFA_FCNFG_REG(base) & FTFA_FCNFG_ERSSUSP_MASK) >> FTFA_FCNFG_ERSSUSP_SHIFT)
#define FTFA_BRD_FCNFG_ERSSUSP(base) (BME_UBFX8(&FTFA_FCNFG_REG(base), FTFA_FCNFG_ERSSUSP_SHIFT, FTFA_FCNFG_ERSSUSP_WIDTH))

/*! @brief Set the ERSSUSP field to a new value. */
#define FTFA_WR_FCNFG_ERSSUSP(base, value) (FTFA_RMW_FCNFG(base, FTFA_FCNFG_ERSSUSP_MASK, FTFA_FCNFG_ERSSUSP(value)))
#define FTFA_BWR_FCNFG_ERSSUSP(base, value) (BME_BFI8(&FTFA_FCNFG_REG(base), ((uint8_t)(value) << FTFA_FCNFG_ERSSUSP_SHIFT), FTFA_FCNFG_ERSSUSP_SHIFT, FTFA_FCNFG_ERSSUSP_WIDTH))
/*@}*/

/*!
 * @name Register FTFA_FCNFG, field ERSAREQ[5] (RO)
 *
 * Issues a request to the memory controller to execute the Erase All Blocks
 * command and release security. ERSAREQ is not directly writable but is under
 * indirect user control. Refer to the device's Chip Configuration details on how to
 * request this command. ERSAREQ sets when an erase all request is triggered
 * external to the flash memory module and CCIF is set (no command is currently being
 * executed). ERSAREQ is cleared by the flash memory module when the operation
 * completes.
 *
 * Values:
 * - 0 - No request or request complete
 * - 1 - Request to: run the Erase All Blocks command, verify the erased state,
 *     program the security byte in the Flash Configuration Field to the unsecure
 *     state, and release MCU security by setting the FSEC[SEC] field to the
 *     unsecure state.
 */
/*@{*/
/*! @brief Read current value of the FTFA_FCNFG_ERSAREQ field. */
#define FTFA_RD_FCNFG_ERSAREQ(base) ((FTFA_FCNFG_REG(base) & FTFA_FCNFG_ERSAREQ_MASK) >> FTFA_FCNFG_ERSAREQ_SHIFT)
#define FTFA_BRD_FCNFG_ERSAREQ(base) (BME_UBFX8(&FTFA_FCNFG_REG(base), FTFA_FCNFG_ERSAREQ_SHIFT, FTFA_FCNFG_ERSAREQ_WIDTH))
/*@}*/

/*!
 * @name Register FTFA_FCNFG, field RDCOLLIE[6] (RW)
 *
 * Controls interrupt generation when a flash memory read collision error occurs.
 *
 * Values:
 * - 0 - Read collision error interrupt disabled
 * - 1 - Read collision error interrupt enabled. An interrupt request is
 *     generated whenever a flash memory read collision error is detected (see the
 *     description of FSTAT[RDCOLERR]).
 */
/*@{*/
/*! @brief Read current value of the FTFA_FCNFG_RDCOLLIE field. */
#define FTFA_RD_FCNFG_RDCOLLIE(base) ((FTFA_FCNFG_REG(base) & FTFA_FCNFG_RDCOLLIE_MASK) >> FTFA_FCNFG_RDCOLLIE_SHIFT)
#define FTFA_BRD_FCNFG_RDCOLLIE(base) (BME_UBFX8(&FTFA_FCNFG_REG(base), FTFA_FCNFG_RDCOLLIE_SHIFT, FTFA_FCNFG_RDCOLLIE_WIDTH))

/*! @brief Set the RDCOLLIE field to a new value. */
#define FTFA_WR_FCNFG_RDCOLLIE(base, value) (FTFA_RMW_FCNFG(base, FTFA_FCNFG_RDCOLLIE_MASK, FTFA_FCNFG_RDCOLLIE(value)))
#define FTFA_BWR_FCNFG_RDCOLLIE(base, value) (BME_BFI8(&FTFA_FCNFG_REG(base), ((uint8_t)(value) << FTFA_FCNFG_RDCOLLIE_SHIFT), FTFA_FCNFG_RDCOLLIE_SHIFT, FTFA_FCNFG_RDCOLLIE_WIDTH))
/*@}*/

/*!
 * @name Register FTFA_FCNFG, field CCIE[7] (RW)
 *
 * Controls interrupt generation when a flash command completes.
 *
 * Values:
 * - 0 - Command complete interrupt disabled
 * - 1 - Command complete interrupt enabled. An interrupt request is generated
 *     whenever the FSTAT[CCIF] flag is set.
 */
/*@{*/
/*! @brief Read current value of the FTFA_FCNFG_CCIE field. */
#define FTFA_RD_FCNFG_CCIE(base) ((FTFA_FCNFG_REG(base) & FTFA_FCNFG_CCIE_MASK) >> FTFA_FCNFG_CCIE_SHIFT)
#define FTFA_BRD_FCNFG_CCIE(base) (BME_UBFX8(&FTFA_FCNFG_REG(base), FTFA_FCNFG_CCIE_SHIFT, FTFA_FCNFG_CCIE_WIDTH))

/*! @brief Set the CCIE field to a new value. */
#define FTFA_WR_FCNFG_CCIE(base, value) (FTFA_RMW_FCNFG(base, FTFA_FCNFG_CCIE_MASK, FTFA_FCNFG_CCIE(value)))
#define FTFA_BWR_FCNFG_CCIE(base, value) (BME_BFI8(&FTFA_FCNFG_REG(base), ((uint8_t)(value) << FTFA_FCNFG_CCIE_SHIFT), FTFA_FCNFG_CCIE_SHIFT, FTFA_FCNFG_CCIE_WIDTH))
/*@}*/

/*******************************************************************************
 * FTFA_FSEC - Flash Security Register
 ******************************************************************************/

/*!
 * @brief FTFA_FSEC - Flash Security Register (RO)
 *
 * Reset value: 0x00U
 *
 * This read-only register holds all bits associated with the security of the
 * MCU and flash memory module. During the reset sequence, the register is loaded
 * with the contents of the flash security byte in the Flash Configuration Field
 * located in program flash memory. The flash basis for the values is signified by
 * X in the reset value.
 */
/*!
 * @name Constants and macros for entire FTFA_FSEC register
 */
/*@{*/
#define FTFA_RD_FSEC(base)       (FTFA_FSEC_REG(base))
/*@}*/

/*
 * Constants & macros for individual FTFA_FSEC bitfields
 */

/*!
 * @name Register FTFA_FSEC, field SEC[1:0] (RO)
 *
 * Defines the security state of the MCU. In the secure state, the MCU limits
 * access to flash memory module resources. The limitations are defined per device
 * and are detailed in the Chip Configuration details. If the flash memory module
 * is unsecured using backdoor key access, SEC is forced to 10b.
 *
 * Values:
 * - 00 - MCU security status is secure.
 * - 01 - MCU security status is secure.
 * - 10 - MCU security status is unsecure. (The standard shipping condition of
 *     the flash memory module is unsecure.)
 * - 11 - MCU security status is secure.
 */
/*@{*/
/*! @brief Read current value of the FTFA_FSEC_SEC field. */
#define FTFA_RD_FSEC_SEC(base) ((FTFA_FSEC_REG(base) & FTFA_FSEC_SEC_MASK) >> FTFA_FSEC_SEC_SHIFT)
#define FTFA_BRD_FSEC_SEC(base) (BME_UBFX8(&FTFA_FSEC_REG(base), FTFA_FSEC_SEC_SHIFT, FTFA_FSEC_SEC_WIDTH))
/*@}*/

/*!
 * @name Register FTFA_FSEC, field FSLACC[3:2] (RO)
 *
 * Enables or disables access to the flash memory contents during returned part
 * failure analysis at Freescale. When SEC is secure and FSLACC is denied, access
 * to the program flash contents is denied and any failure analysis performed by
 * Freescale factory test must begin with a full erase to unsecure the part.
 * When access is granted (SEC is unsecure, or SEC is secure and FSLACC is granted),
 * Freescale factory testing has visibility of the current flash contents. The
 * state of the FSLACC bits is only relevant when SEC is set to secure. When SEC
 * is set to unsecure, the FSLACC setting does not matter.
 *
 * Values:
 * - 00 - Freescale factory access granted
 * - 01 - Freescale factory access denied
 * - 10 - Freescale factory access denied
 * - 11 - Freescale factory access granted
 */
/*@{*/
/*! @brief Read current value of the FTFA_FSEC_FSLACC field. */
#define FTFA_RD_FSEC_FSLACC(base) ((FTFA_FSEC_REG(base) & FTFA_FSEC_FSLACC_MASK) >> FTFA_FSEC_FSLACC_SHIFT)
#define FTFA_BRD_FSEC_FSLACC(base) (BME_UBFX8(&FTFA_FSEC_REG(base), FTFA_FSEC_FSLACC_SHIFT, FTFA_FSEC_FSLACC_WIDTH))
/*@}*/

/*!
 * @name Register FTFA_FSEC, field MEEN[5:4] (RO)
 *
 * Enables and disables mass erase capability of the flash memory module. The
 * state of this field is relevant only when SEC is set to secure outside of NVM
 * Normal Mode. When SEC is set to unsecure, the MEEN setting does not matter.
 *
 * Values:
 * - 00 - Mass erase is enabled
 * - 01 - Mass erase is enabled
 * - 10 - Mass erase is disabled
 * - 11 - Mass erase is enabled
 */
/*@{*/
/*! @brief Read current value of the FTFA_FSEC_MEEN field. */
#define FTFA_RD_FSEC_MEEN(base) ((FTFA_FSEC_REG(base) & FTFA_FSEC_MEEN_MASK) >> FTFA_FSEC_MEEN_SHIFT)
#define FTFA_BRD_FSEC_MEEN(base) (BME_UBFX8(&FTFA_FSEC_REG(base), FTFA_FSEC_MEEN_SHIFT, FTFA_FSEC_MEEN_WIDTH))
/*@}*/

/*!
 * @name Register FTFA_FSEC, field KEYEN[7:6] (RO)
 *
 * Enables or disables backdoor key access to the flash memory module.
 *
 * Values:
 * - 00 - Backdoor key access disabled
 * - 01 - Backdoor key access disabled (preferred KEYEN state to disable
 *     backdoor key access)
 * - 10 - Backdoor key access enabled
 * - 11 - Backdoor key access disabled
 */
/*@{*/
/*! @brief Read current value of the FTFA_FSEC_KEYEN field. */
#define FTFA_RD_FSEC_KEYEN(base) ((FTFA_FSEC_REG(base) & FTFA_FSEC_KEYEN_MASK) >> FTFA_FSEC_KEYEN_SHIFT)
#define FTFA_BRD_FSEC_KEYEN(base) (BME_UBFX8(&FTFA_FSEC_REG(base), FTFA_FSEC_KEYEN_SHIFT, FTFA_FSEC_KEYEN_WIDTH))
/*@}*/

/*******************************************************************************
 * FTFA_FOPT - Flash Option Register
 ******************************************************************************/

/*!
 * @brief FTFA_FOPT - Flash Option Register (RO)
 *
 * Reset value: 0x00U
 *
 * The flash option register allows the MCU to customize its operations by
 * examining the state of these read-only bits, which are loaded from NVM at reset.
 * The function of the bits is defined in the device's Chip Configuration details.
 * All bits in the register are read-only . During the reset sequence, the
 * register is loaded from the flash nonvolatile option byte in the Flash Configuration
 * Field located in program flash memory. The flash basis for the values is
 * signified by X in the reset value. However, the register is written to 0xFF if the
 * contents of the flash nonvolatile option byte are 0x00.
 */
/*!
 * @name Constants and macros for entire FTFA_FOPT register
 */
/*@{*/
#define FTFA_RD_FOPT(base)       (FTFA_FOPT_REG(base))
/*@}*/

/*******************************************************************************
 * FTFA_FCCOB3 - Flash Common Command Object Registers
 ******************************************************************************/

/*!
 * @brief FTFA_FCCOB3 - Flash Common Command Object Registers (RW)
 *
 * Reset value: 0x00U
 *
 * The FCCOB register group provides 12 bytes for command codes and parameters.
 * The individual bytes within the set append a 0-B hex identifier to the FCCOB
 * register name: FCCOB0, FCCOB1, ..., FCCOBB.
 */
/*!
 * @name Constants and macros for entire FTFA_FCCOB3 register
 */
/*@{*/
#define FTFA_RD_FCCOB3(base)     (FTFA_FCCOB3_REG(base))
#define FTFA_WR_FCCOB3(base, value) (FTFA_FCCOB3_REG(base) = (value))
#define FTFA_RMW_FCCOB3(base, mask, value) (FTFA_WR_FCCOB3(base, (FTFA_RD_FCCOB3(base) & ~(mask)) | (value)))
#define FTFA_SET_FCCOB3(base, value) (BME_OR8(&FTFA_FCCOB3_REG(base), (uint8_t)(value)))
#define FTFA_CLR_FCCOB3(base, value) (BME_AND8(&FTFA_FCCOB3_REG(base), (uint8_t)(~(value))))
#define FTFA_TOG_FCCOB3(base, value) (BME_XOR8(&FTFA_FCCOB3_REG(base), (uint8_t)(value)))
/*@}*/

/*******************************************************************************
 * FTFA_FCCOB2 - Flash Common Command Object Registers
 ******************************************************************************/

/*!
 * @brief FTFA_FCCOB2 - Flash Common Command Object Registers (RW)
 *
 * Reset value: 0x00U
 *
 * The FCCOB register group provides 12 bytes for command codes and parameters.
 * The individual bytes within the set append a 0-B hex identifier to the FCCOB
 * register name: FCCOB0, FCCOB1, ..., FCCOBB.
 */
/*!
 * @name Constants and macros for entire FTFA_FCCOB2 register
 */
/*@{*/
#define FTFA_RD_FCCOB2(base)     (FTFA_FCCOB2_REG(base))
#define FTFA_WR_FCCOB2(base, value) (FTFA_FCCOB2_REG(base) = (value))
#define FTFA_RMW_FCCOB2(base, mask, value) (FTFA_WR_FCCOB2(base, (FTFA_RD_FCCOB2(base) & ~(mask)) | (value)))
#define FTFA_SET_FCCOB2(base, value) (BME_OR8(&FTFA_FCCOB2_REG(base), (uint8_t)(value)))
#define FTFA_CLR_FCCOB2(base, value) (BME_AND8(&FTFA_FCCOB2_REG(base), (uint8_t)(~(value))))
#define FTFA_TOG_FCCOB2(base, value) (BME_XOR8(&FTFA_FCCOB2_REG(base), (uint8_t)(value)))
/*@}*/

/*******************************************************************************
 * FTFA_FCCOB1 - Flash Common Command Object Registers
 ******************************************************************************/

/*!
 * @brief FTFA_FCCOB1 - Flash Common Command Object Registers (RW)
 *
 * Reset value: 0x00U
 *
 * The FCCOB register group provides 12 bytes for command codes and parameters.
 * The individual bytes within the set append a 0-B hex identifier to the FCCOB
 * register name: FCCOB0, FCCOB1, ..., FCCOBB.
 */
/*!
 * @name Constants and macros for entire FTFA_FCCOB1 register
 */
/*@{*/
#define FTFA_RD_FCCOB1(base)     (FTFA_FCCOB1_REG(base))
#define FTFA_WR_FCCOB1(base, value) (FTFA_FCCOB1_REG(base) = (value))
#define FTFA_RMW_FCCOB1(base, mask, value) (FTFA_WR_FCCOB1(base, (FTFA_RD_FCCOB1(base) & ~(mask)) | (value)))
#define FTFA_SET_FCCOB1(base, value) (BME_OR8(&FTFA_FCCOB1_REG(base), (uint8_t)(value)))
#define FTFA_CLR_FCCOB1(base, value) (BME_AND8(&FTFA_FCCOB1_REG(base), (uint8_t)(~(value))))
#define FTFA_TOG_FCCOB1(base, value) (BME_XOR8(&FTFA_FCCOB1_REG(base), (uint8_t)(value)))
/*@}*/

/*******************************************************************************
 * FTFA_FCCOB0 - Flash Common Command Object Registers
 ******************************************************************************/

/*!
 * @brief FTFA_FCCOB0 - Flash Common Command Object Registers (RW)
 *
 * Reset value: 0x00U
 *
 * The FCCOB register group provides 12 bytes for command codes and parameters.
 * The individual bytes within the set append a 0-B hex identifier to the FCCOB
 * register name: FCCOB0, FCCOB1, ..., FCCOBB.
 */
/*!
 * @name Constants and macros for entire FTFA_FCCOB0 register
 */
/*@{*/
#define FTFA_RD_FCCOB0(base)     (FTFA_FCCOB0_REG(base))
#define FTFA_WR_FCCOB0(base, value) (FTFA_FCCOB0_REG(base) = (value))
#define FTFA_RMW_FCCOB0(base, mask, value) (FTFA_WR_FCCOB0(base, (FTFA_RD_FCCOB0(base) & ~(mask)) | (value)))
#define FTFA_SET_FCCOB0(base, value) (BME_OR8(&FTFA_FCCOB0_REG(base), (uint8_t)(value)))
#define FTFA_CLR_FCCOB0(base, value) (BME_AND8(&FTFA_FCCOB0_REG(base), (uint8_t)(~(value))))
#define FTFA_TOG_FCCOB0(base, value) (BME_XOR8(&FTFA_FCCOB0_REG(base), (uint8_t)(value)))
/*@}*/

/*******************************************************************************
 * FTFA_FCCOB7 - Flash Common Command Object Registers
 ******************************************************************************/

/*!
 * @brief FTFA_FCCOB7 - Flash Common Command Object Registers (RW)
 *
 * Reset value: 0x00U
 *
 * The FCCOB register group provides 12 bytes for command codes and parameters.
 * The individual bytes within the set append a 0-B hex identifier to the FCCOB
 * register name: FCCOB0, FCCOB1, ..., FCCOBB.
 */
/*!
 * @name Constants and macros for entire FTFA_FCCOB7 register
 */
/*@{*/
#define FTFA_RD_FCCOB7(base)     (FTFA_FCCOB7_REG(base))
#define FTFA_WR_FCCOB7(base, value) (FTFA_FCCOB7_REG(base) = (value))
#define FTFA_RMW_FCCOB7(base, mask, value) (FTFA_WR_FCCOB7(base, (FTFA_RD_FCCOB7(base) & ~(mask)) | (value)))
#define FTFA_SET_FCCOB7(base, value) (BME_OR8(&FTFA_FCCOB7_REG(base), (uint8_t)(value)))
#define FTFA_CLR_FCCOB7(base, value) (BME_AND8(&FTFA_FCCOB7_REG(base), (uint8_t)(~(value))))
#define FTFA_TOG_FCCOB7(base, value) (BME_XOR8(&FTFA_FCCOB7_REG(base), (uint8_t)(value)))
/*@}*/

/*******************************************************************************
 * FTFA_FCCOB6 - Flash Common Command Object Registers
 ******************************************************************************/

/*!
 * @brief FTFA_FCCOB6 - Flash Common Command Object Registers (RW)
 *
 * Reset value: 0x00U
 *
 * The FCCOB register group provides 12 bytes for command codes and parameters.
 * The individual bytes within the set append a 0-B hex identifier to the FCCOB
 * register name: FCCOB0, FCCOB1, ..., FCCOBB.
 */
/*!
 * @name Constants and macros for entire FTFA_FCCOB6 register
 */
/*@{*/
#define FTFA_RD_FCCOB6(base)     (FTFA_FCCOB6_REG(base))
#define FTFA_WR_FCCOB6(base, value) (FTFA_FCCOB6_REG(base) = (value))
#define FTFA_RMW_FCCOB6(base, mask, value) (FTFA_WR_FCCOB6(base, (FTFA_RD_FCCOB6(base) & ~(mask)) | (value)))
#define FTFA_SET_FCCOB6(base, value) (BME_OR8(&FTFA_FCCOB6_REG(base), (uint8_t)(value)))
#define FTFA_CLR_FCCOB6(base, value) (BME_AND8(&FTFA_FCCOB6_REG(base), (uint8_t)(~(value))))
#define FTFA_TOG_FCCOB6(base, value) (BME_XOR8(&FTFA_FCCOB6_REG(base), (uint8_t)(value)))
/*@}*/

/*******************************************************************************
 * FTFA_FCCOB5 - Flash Common Command Object Registers
 ******************************************************************************/

/*!
 * @brief FTFA_FCCOB5 - Flash Common Command Object Registers (RW)
 *
 * Reset value: 0x00U
 *
 * The FCCOB register group provides 12 bytes for command codes and parameters.
 * The individual bytes within the set append a 0-B hex identifier to the FCCOB
 * register name: FCCOB0, FCCOB1, ..., FCCOBB.
 */
/*!
 * @name Constants and macros for entire FTFA_FCCOB5 register
 */
/*@{*/
#define FTFA_RD_FCCOB5(base)     (FTFA_FCCOB5_REG(base))
#define FTFA_WR_FCCOB5(base, value) (FTFA_FCCOB5_REG(base) = (value))
#define FTFA_RMW_FCCOB5(base, mask, value) (FTFA_WR_FCCOB5(base, (FTFA_RD_FCCOB5(base) & ~(mask)) | (value)))
#define FTFA_SET_FCCOB5(base, value) (BME_OR8(&FTFA_FCCOB5_REG(base), (uint8_t)(value)))
#define FTFA_CLR_FCCOB5(base, value) (BME_AND8(&FTFA_FCCOB5_REG(base), (uint8_t)(~(value))))
#define FTFA_TOG_FCCOB5(base, value) (BME_XOR8(&FTFA_FCCOB5_REG(base), (uint8_t)(value)))
/*@}*/

/*******************************************************************************
 * FTFA_FCCOB4 - Flash Common Command Object Registers
 ******************************************************************************/

/*!
 * @brief FTFA_FCCOB4 - Flash Common Command Object Registers (RW)
 *
 * Reset value: 0x00U
 *
 * The FCCOB register group provides 12 bytes for command codes and parameters.
 * The individual bytes within the set append a 0-B hex identifier to the FCCOB
 * register name: FCCOB0, FCCOB1, ..., FCCOBB.
 */
/*!
 * @name Constants and macros for entire FTFA_FCCOB4 register
 */
/*@{*/
#define FTFA_RD_FCCOB4(base)     (FTFA_FCCOB4_REG(base))
#define FTFA_WR_FCCOB4(base, value) (FTFA_FCCOB4_REG(base) = (value))
#define FTFA_RMW_FCCOB4(base, mask, value) (FTFA_WR_FCCOB4(base, (FTFA_RD_FCCOB4(base) & ~(mask)) | (value)))
#define FTFA_SET_FCCOB4(base, value) (BME_OR8(&FTFA_FCCOB4_REG(base), (uint8_t)(value)))
#define FTFA_CLR_FCCOB4(base, value) (BME_AND8(&FTFA_FCCOB4_REG(base), (uint8_t)(~(value))))
#define FTFA_TOG_FCCOB4(base, value) (BME_XOR8(&FTFA_FCCOB4_REG(base), (uint8_t)(value)))
/*@}*/

/*******************************************************************************
 * FTFA_FCCOBB - Flash Common Command Object Registers
 ******************************************************************************/

/*!
 * @brief FTFA_FCCOBB - Flash Common Command Object Registers (RW)
 *
 * Reset value: 0x00U
 *
 * The FCCOB register group provides 12 bytes for command codes and parameters.
 * The individual bytes within the set append a 0-B hex identifier to the FCCOB
 * register name: FCCOB0, FCCOB1, ..., FCCOBB.
 */
/*!
 * @name Constants and macros for entire FTFA_FCCOBB register
 */
/*@{*/
#define FTFA_RD_FCCOBB(base)     (FTFA_FCCOBB_REG(base))
#define FTFA_WR_FCCOBB(base, value) (FTFA_FCCOBB_REG(base) = (value))
#define FTFA_RMW_FCCOBB(base, mask, value) (FTFA_WR_FCCOBB(base, (FTFA_RD_FCCOBB(base) & ~(mask)) | (value)))
#define FTFA_SET_FCCOBB(base, value) (BME_OR8(&FTFA_FCCOBB_REG(base), (uint8_t)(value)))
#define FTFA_CLR_FCCOBB(base, value) (BME_AND8(&FTFA_FCCOBB_REG(base), (uint8_t)(~(value))))
#define FTFA_TOG_FCCOBB(base, value) (BME_XOR8(&FTFA_FCCOBB_REG(base), (uint8_t)(value)))
/*@}*/

/*******************************************************************************
 * FTFA_FCCOBA - Flash Common Command Object Registers
 ******************************************************************************/

/*!
 * @brief FTFA_FCCOBA - Flash Common Command Object Registers (RW)
 *
 * Reset value: 0x00U
 *
 * The FCCOB register group provides 12 bytes for command codes and parameters.
 * The individual bytes within the set append a 0-B hex identifier to the FCCOB
 * register name: FCCOB0, FCCOB1, ..., FCCOBB.
 */
/*!
 * @name Constants and macros for entire FTFA_FCCOBA register
 */
/*@{*/
#define FTFA_RD_FCCOBA(base)     (FTFA_FCCOBA_REG(base))
#define FTFA_WR_FCCOBA(base, value) (FTFA_FCCOBA_REG(base) = (value))
#define FTFA_RMW_FCCOBA(base, mask, value) (FTFA_WR_FCCOBA(base, (FTFA_RD_FCCOBA(base) & ~(mask)) | (value)))
#define FTFA_SET_FCCOBA(base, value) (BME_OR8(&FTFA_FCCOBA_REG(base), (uint8_t)(value)))
#define FTFA_CLR_FCCOBA(base, value) (BME_AND8(&FTFA_FCCOBA_REG(base), (uint8_t)(~(value))))
#define FTFA_TOG_FCCOBA(base, value) (BME_XOR8(&FTFA_FCCOBA_REG(base), (uint8_t)(value)))
/*@}*/

/*******************************************************************************
 * FTFA_FCCOB9 - Flash Common Command Object Registers
 ******************************************************************************/

/*!
 * @brief FTFA_FCCOB9 - Flash Common Command Object Registers (RW)
 *
 * Reset value: 0x00U
 *
 * The FCCOB register group provides 12 bytes for command codes and parameters.
 * The individual bytes within the set append a 0-B hex identifier to the FCCOB
 * register name: FCCOB0, FCCOB1, ..., FCCOBB.
 */
/*!
 * @name Constants and macros for entire FTFA_FCCOB9 register
 */
/*@{*/
#define FTFA_RD_FCCOB9(base)     (FTFA_FCCOB9_REG(base))
#define FTFA_WR_FCCOB9(base, value) (FTFA_FCCOB9_REG(base) = (value))
#define FTFA_RMW_FCCOB9(base, mask, value) (FTFA_WR_FCCOB9(base, (FTFA_RD_FCCOB9(base) & ~(mask)) | (value)))
#define FTFA_SET_FCCOB9(base, value) (BME_OR8(&FTFA_FCCOB9_REG(base), (uint8_t)(value)))
#define FTFA_CLR_FCCOB9(base, value) (BME_AND8(&FTFA_FCCOB9_REG(base), (uint8_t)(~(value))))
#define FTFA_TOG_FCCOB9(base, value) (BME_XOR8(&FTFA_FCCOB9_REG(base), (uint8_t)(value)))
/*@}*/

/*******************************************************************************
 * FTFA_FCCOB8 - Flash Common Command Object Registers
 ******************************************************************************/

/*!
 * @brief FTFA_FCCOB8 - Flash Common Command Object Registers (RW)
 *
 * Reset value: 0x00U
 *
 * The FCCOB register group provides 12 bytes for command codes and parameters.
 * The individual bytes within the set append a 0-B hex identifier to the FCCOB
 * register name: FCCOB0, FCCOB1, ..., FCCOBB.
 */
/*!
 * @name Constants and macros for entire FTFA_FCCOB8 register
 */
/*@{*/
#define FTFA_RD_FCCOB8(base)     (FTFA_FCCOB8_REG(base))
#define FTFA_WR_FCCOB8(base, value) (FTFA_FCCOB8_REG(base) = (value))
#define FTFA_RMW_FCCOB8(base, mask, value) (FTFA_WR_FCCOB8(base, (FTFA_RD_FCCOB8(base) & ~(mask)) | (value)))
#define FTFA_SET_FCCOB8(base, value) (BME_OR8(&FTFA_FCCOB8_REG(base), (uint8_t)(value)))
#define FTFA_CLR_FCCOB8(base, value) (BME_AND8(&FTFA_FCCOB8_REG(base), (uint8_t)(~(value))))
#define FTFA_TOG_FCCOB8(base, value) (BME_XOR8(&FTFA_FCCOB8_REG(base), (uint8_t)(value)))
/*@}*/

/*******************************************************************************
 * FTFA_FPROT3 - Program Flash Protection Registers
 ******************************************************************************/

/*!
 * @brief FTFA_FPROT3 - Program Flash Protection Registers (RW)
 *
 * Reset value: 0x00U
 *
 * The FPROT registers define which program flash regions are protected from
 * program and erase operations. Protected flash regions cannot have their content
 * changed; that is, these regions cannot be programmed and cannot be erased by
 * any flash command. Unprotected regions can be changed by program and erase
 * operations. The four FPROT registers allow up to 32 protectable regions. Each bit
 * protects a 1/32 region of the program flash memory except for memory
 * configurations with less than 32 KB of program flash where each assigned bit protects 1
 * KB . For configurations with 24 KB of program flash memory or less, FPROT0 is
 * not used. For configurations with 16 KB of program flash memory or less,
 * FPROT1 is not used. For configurations with 8 KB of program flash memory, FPROT2 is
 * not used. The bitfields are defined in each register as follows: Program
 * flash protection register Program flash protection bits FPROT0 PROT[31:24] FPROT1
 * PROT[23:16] FPROT2 PROT[15:8] FPROT3 PROT[7:0] During the reset sequence, the
 * FPROT registers are loaded with the contents of the program flash protection
 * bytes in the Flash Configuration Field as indicated in the following table.
 * Program flash protection register Flash Configuration Field offset address FPROT0
 * 0x000B FPROT1 0x000A FPROT2 0x0009 FPROT3 0x0008 To change the program flash
 * protection that is loaded during the reset sequence, unprotect the sector of
 * program flash memory that contains the Flash Configuration Field. Then,
 * reprogram the program flash protection byte.
 */
/*!
 * @name Constants and macros for entire FTFA_FPROT3 register
 */
/*@{*/
#define FTFA_RD_FPROT3(base)     (FTFA_FPROT3_REG(base))
#define FTFA_WR_FPROT3(base, value) (FTFA_FPROT3_REG(base) = (value))
#define FTFA_RMW_FPROT3(base, mask, value) (FTFA_WR_FPROT3(base, (FTFA_RD_FPROT3(base) & ~(mask)) | (value)))
#define FTFA_SET_FPROT3(base, value) (BME_OR8(&FTFA_FPROT3_REG(base), (uint8_t)(value)))
#define FTFA_CLR_FPROT3(base, value) (BME_AND8(&FTFA_FPROT3_REG(base), (uint8_t)(~(value))))
#define FTFA_TOG_FPROT3(base, value) (BME_XOR8(&FTFA_FPROT3_REG(base), (uint8_t)(value)))
/*@}*/

/*******************************************************************************
 * FTFA_FPROT2 - Program Flash Protection Registers
 ******************************************************************************/

/*!
 * @brief FTFA_FPROT2 - Program Flash Protection Registers (RW)
 *
 * Reset value: 0x00U
 *
 * The FPROT registers define which program flash regions are protected from
 * program and erase operations. Protected flash regions cannot have their content
 * changed; that is, these regions cannot be programmed and cannot be erased by
 * any flash command. Unprotected regions can be changed by program and erase
 * operations. The four FPROT registers allow up to 32 protectable regions. Each bit
 * protects a 1/32 region of the program flash memory except for memory
 * configurations with less than 32 KB of program flash where each assigned bit protects 1
 * KB . For configurations with 24 KB of program flash memory or less, FPROT0 is
 * not used. For configurations with 16 KB of program flash memory or less,
 * FPROT1 is not used. For configurations with 8 KB of program flash memory, FPROT2 is
 * not used. The bitfields are defined in each register as follows: Program
 * flash protection register Program flash protection bits FPROT0 PROT[31:24] FPROT1
 * PROT[23:16] FPROT2 PROT[15:8] FPROT3 PROT[7:0] During the reset sequence, the
 * FPROT registers are loaded with the contents of the program flash protection
 * bytes in the Flash Configuration Field as indicated in the following table.
 * Program flash protection register Flash Configuration Field offset address FPROT0
 * 0x000B FPROT1 0x000A FPROT2 0x0009 FPROT3 0x0008 To change the program flash
 * protection that is loaded during the reset sequence, unprotect the sector of
 * program flash memory that contains the Flash Configuration Field. Then,
 * reprogram the program flash protection byte.
 */
/*!
 * @name Constants and macros for entire FTFA_FPROT2 register
 */
/*@{*/
#define FTFA_RD_FPROT2(base)     (FTFA_FPROT2_REG(base))
#define FTFA_WR_FPROT2(base, value) (FTFA_FPROT2_REG(base) = (value))
#define FTFA_RMW_FPROT2(base, mask, value) (FTFA_WR_FPROT2(base, (FTFA_RD_FPROT2(base) & ~(mask)) | (value)))
#define FTFA_SET_FPROT2(base, value) (BME_OR8(&FTFA_FPROT2_REG(base), (uint8_t)(value)))
#define FTFA_CLR_FPROT2(base, value) (BME_AND8(&FTFA_FPROT2_REG(base), (uint8_t)(~(value))))
#define FTFA_TOG_FPROT2(base, value) (BME_XOR8(&FTFA_FPROT2_REG(base), (uint8_t)(value)))
/*@}*/

/*******************************************************************************
 * FTFA_FPROT1 - Program Flash Protection Registers
 ******************************************************************************/

/*!
 * @brief FTFA_FPROT1 - Program Flash Protection Registers (RW)
 *
 * Reset value: 0x00U
 *
 * The FPROT registers define which program flash regions are protected from
 * program and erase operations. Protected flash regions cannot have their content
 * changed; that is, these regions cannot be programmed and cannot be erased by
 * any flash command. Unprotected regions can be changed by program and erase
 * operations. The four FPROT registers allow up to 32 protectable regions. Each bit
 * protects a 1/32 region of the program flash memory except for memory
 * configurations with less than 32 KB of program flash where each assigned bit protects 1
 * KB . For configurations with 24 KB of program flash memory or less, FPROT0 is
 * not used. For configurations with 16 KB of program flash memory or less,
 * FPROT1 is not used. For configurations with 8 KB of program flash memory, FPROT2 is
 * not used. The bitfields are defined in each register as follows: Program
 * flash protection register Program flash protection bits FPROT0 PROT[31:24] FPROT1
 * PROT[23:16] FPROT2 PROT[15:8] FPROT3 PROT[7:0] During the reset sequence, the
 * FPROT registers are loaded with the contents of the program flash protection
 * bytes in the Flash Configuration Field as indicated in the following table.
 * Program flash protection register Flash Configuration Field offset address FPROT0
 * 0x000B FPROT1 0x000A FPROT2 0x0009 FPROT3 0x0008 To change the program flash
 * protection that is loaded during the reset sequence, unprotect the sector of
 * program flash memory that contains the Flash Configuration Field. Then,
 * reprogram the program flash protection byte.
 */
/*!
 * @name Constants and macros for entire FTFA_FPROT1 register
 */
/*@{*/
#define FTFA_RD_FPROT1(base)     (FTFA_FPROT1_REG(base))
#define FTFA_WR_FPROT1(base, value) (FTFA_FPROT1_REG(base) = (value))
#define FTFA_RMW_FPROT1(base, mask, value) (FTFA_WR_FPROT1(base, (FTFA_RD_FPROT1(base) & ~(mask)) | (value)))
#define FTFA_SET_FPROT1(base, value) (BME_OR8(&FTFA_FPROT1_REG(base), (uint8_t)(value)))
#define FTFA_CLR_FPROT1(base, value) (BME_AND8(&FTFA_FPROT1_REG(base), (uint8_t)(~(value))))
#define FTFA_TOG_FPROT1(base, value) (BME_XOR8(&FTFA_FPROT1_REG(base), (uint8_t)(value)))
/*@}*/

/*******************************************************************************
 * FTFA_FPROT0 - Program Flash Protection Registers
 ******************************************************************************/

/*!
 * @brief FTFA_FPROT0 - Program Flash Protection Registers (RW)
 *
 * Reset value: 0x00U
 *
 * The FPROT registers define which program flash regions are protected from
 * program and erase operations. Protected flash regions cannot have their content
 * changed; that is, these regions cannot be programmed and cannot be erased by
 * any flash command. Unprotected regions can be changed by program and erase
 * operations. The four FPROT registers allow up to 32 protectable regions. Each bit
 * protects a 1/32 region of the program flash memory except for memory
 * configurations with less than 32 KB of program flash where each assigned bit protects 1
 * KB . For configurations with 24 KB of program flash memory or less, FPROT0 is
 * not used. For configurations with 16 KB of program flash memory or less,
 * FPROT1 is not used. For configurations with 8 KB of program flash memory, FPROT2 is
 * not used. The bitfields are defined in each register as follows: Program
 * flash protection register Program flash protection bits FPROT0 PROT[31:24] FPROT1
 * PROT[23:16] FPROT2 PROT[15:8] FPROT3 PROT[7:0] During the reset sequence, the
 * FPROT registers are loaded with the contents of the program flash protection
 * bytes in the Flash Configuration Field as indicated in the following table.
 * Program flash protection register Flash Configuration Field offset address FPROT0
 * 0x000B FPROT1 0x000A FPROT2 0x0009 FPROT3 0x0008 To change the program flash
 * protection that is loaded during the reset sequence, unprotect the sector of
 * program flash memory that contains the Flash Configuration Field. Then,
 * reprogram the program flash protection byte.
 */
/*!
 * @name Constants and macros for entire FTFA_FPROT0 register
 */
/*@{*/
#define FTFA_RD_FPROT0(base)     (FTFA_FPROT0_REG(base))
#define FTFA_WR_FPROT0(base, value) (FTFA_FPROT0_REG(base) = (value))
#define FTFA_RMW_FPROT0(base, mask, value) (FTFA_WR_FPROT0(base, (FTFA_RD_FPROT0(base) & ~(mask)) | (value)))
#define FTFA_SET_FPROT0(base, value) (BME_OR8(&FTFA_FPROT0_REG(base), (uint8_t)(value)))
#define FTFA_CLR_FPROT0(base, value) (BME_AND8(&FTFA_FPROT0_REG(base), (uint8_t)(~(value))))
#define FTFA_TOG_FPROT0(base, value) (BME_XOR8(&FTFA_FPROT0_REG(base), (uint8_t)(value)))
/*@}*/

/*
 * MKL27Z644 GPIO
 *
 * General Purpose Input/Output
 *
 * Registers defined in this header file:
 * - GPIO_PDOR - Port Data Output Register
 * - GPIO_PSOR - Port Set Output Register
 * - GPIO_PCOR - Port Clear Output Register
 * - GPIO_PTOR - Port Toggle Output Register
 * - GPIO_PDIR - Port Data Input Register
 * - GPIO_PDDR - Port Data Direction Register
 */

#define GPIO_INSTANCE_COUNT (5U) /*!< Number of instances of the GPIO module. */
#define GPIOA_IDX (0U) /*!< Instance number for GPIOA. */
#define GPIOB_IDX (1U) /*!< Instance number for GPIOB. */
#define GPIOC_IDX (2U) /*!< Instance number for GPIOC. */
#define GPIOD_IDX (3U) /*!< Instance number for GPIOD. */
#define GPIOE_IDX (4U) /*!< Instance number for GPIOE. */

/*******************************************************************************
 * GPIO_PDOR - Port Data Output Register
 ******************************************************************************/

/*!
 * @brief GPIO_PDOR - Port Data Output Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * This register configures the logic levels that are driven on each
 * general-purpose output pins. Do not modify pin configuration registers associated with
 * pins not available in your selected package. All unbonded pins not available in
 * your package will default to DISABLE state for lowest power consumption.
 */
/*!
 * @name Constants and macros for entire GPIO_PDOR register
 */
/*@{*/
#define GPIO_RD_PDOR(base)       (GPIO_PDOR_REG(base))
#define GPIO_WR_PDOR(base, value) (GPIO_PDOR_REG(base) = (value))
#define GPIO_RMW_PDOR(base, mask, value) (GPIO_WR_PDOR(base, (GPIO_RD_PDOR(base) & ~(mask)) | (value)))
#define GPIO_SET_PDOR(base, value) (BME_OR32(&GPIO_PDOR_REG(base), (uint32_t)(value)))
#define GPIO_CLR_PDOR(base, value) (BME_AND32(&GPIO_PDOR_REG(base), (uint32_t)(~(value))))
#define GPIO_TOG_PDOR(base, value) (BME_XOR32(&GPIO_PDOR_REG(base), (uint32_t)(value)))
/*@}*/

/*******************************************************************************
 * GPIO_PSOR - Port Set Output Register
 ******************************************************************************/

/*!
 * @brief GPIO_PSOR - Port Set Output Register (WORZ)
 *
 * Reset value: 0x00000000U
 *
 * This register configures whether to set the fields of the PDOR.
 */
/*!
 * @name Constants and macros for entire GPIO_PSOR register
 */
/*@{*/
#define GPIO_RD_PSOR(base)       (GPIO_PSOR_REG(base))
#define GPIO_WR_PSOR(base, value) (GPIO_PSOR_REG(base) = (value))
#define GPIO_RMW_PSOR(base, mask, value) (GPIO_WR_PSOR(base, (GPIO_RD_PSOR(base) & ~(mask)) | (value)))
/*@}*/

/*******************************************************************************
 * GPIO_PCOR - Port Clear Output Register
 ******************************************************************************/

/*!
 * @brief GPIO_PCOR - Port Clear Output Register (WORZ)
 *
 * Reset value: 0x00000000U
 *
 * This register configures whether to clear the fields of PDOR.
 */
/*!
 * @name Constants and macros for entire GPIO_PCOR register
 */
/*@{*/
#define GPIO_RD_PCOR(base)       (GPIO_PCOR_REG(base))
#define GPIO_WR_PCOR(base, value) (GPIO_PCOR_REG(base) = (value))
#define GPIO_RMW_PCOR(base, mask, value) (GPIO_WR_PCOR(base, (GPIO_RD_PCOR(base) & ~(mask)) | (value)))
/*@}*/

/*******************************************************************************
 * GPIO_PTOR - Port Toggle Output Register
 ******************************************************************************/

/*!
 * @brief GPIO_PTOR - Port Toggle Output Register (WORZ)
 *
 * Reset value: 0x00000000U
 */
/*!
 * @name Constants and macros for entire GPIO_PTOR register
 */
/*@{*/
#define GPIO_RD_PTOR(base)       (GPIO_PTOR_REG(base))
#define GPIO_WR_PTOR(base, value) (GPIO_PTOR_REG(base) = (value))
#define GPIO_RMW_PTOR(base, mask, value) (GPIO_WR_PTOR(base, (GPIO_RD_PTOR(base) & ~(mask)) | (value)))
/*@}*/

/*******************************************************************************
 * GPIO_PDIR - Port Data Input Register
 ******************************************************************************/

/*!
 * @brief GPIO_PDIR - Port Data Input Register (RO)
 *
 * Reset value: 0x00000000U
 *
 * Do not modify pin configuration registers associated with pins not available
 * in your selected package. All unbonded pins not available in your package will
 * default to DISABLE state for lowest power consumption.
 */
/*!
 * @name Constants and macros for entire GPIO_PDIR register
 */
/*@{*/
#define GPIO_RD_PDIR(base)       (GPIO_PDIR_REG(base))
/*@}*/

/*******************************************************************************
 * GPIO_PDDR - Port Data Direction Register
 ******************************************************************************/

/*!
 * @brief GPIO_PDDR - Port Data Direction Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * The PDDR configures the individual port pins for input or output.
 */
/*!
 * @name Constants and macros for entire GPIO_PDDR register
 */
/*@{*/
#define GPIO_RD_PDDR(base)       (GPIO_PDDR_REG(base))
#define GPIO_WR_PDDR(base, value) (GPIO_PDDR_REG(base) = (value))
#define GPIO_RMW_PDDR(base, mask, value) (GPIO_WR_PDDR(base, (GPIO_RD_PDDR(base) & ~(mask)) | (value)))
#define GPIO_SET_PDDR(base, value) (BME_OR32(&GPIO_PDDR_REG(base), (uint32_t)(value)))
#define GPIO_CLR_PDDR(base, value) (BME_AND32(&GPIO_PDDR_REG(base), (uint32_t)(~(value))))
#define GPIO_TOG_PDDR(base, value) (BME_XOR32(&GPIO_PDDR_REG(base), (uint32_t)(value)))
/*@}*/

/*
 * MKL27Z644 I2C
 *
 * Inter-Integrated Circuit
 *
 * Registers defined in this header file:
 * - I2C_A1 - I2C Address Register 1
 * - I2C_F - I2C Frequency Divider register
 * - I2C_C1 - I2C Control Register 1
 * - I2C_S - I2C Status register
 * - I2C_D - I2C Data I/O register
 * - I2C_C2 - I2C Control Register 2
 * - I2C_FLT - I2C Programmable Input Glitch Filter Register
 * - I2C_RA - I2C Range Address register
 * - I2C_SMB - I2C SMBus Control and Status register
 * - I2C_A2 - I2C Address Register 2
 * - I2C_SLTH - I2C SCL Low Timeout Register High
 * - I2C_SLTL - I2C SCL Low Timeout Register Low
 * - I2C_S2 - I2C Status register 2
 */

#define I2C_INSTANCE_COUNT (2U) /*!< Number of instances of the I2C module. */
#define I2C0_IDX (0U) /*!< Instance number for I2C0. */
#define I2C1_IDX (1U) /*!< Instance number for I2C1. */

/*******************************************************************************
 * I2C_A1 - I2C Address Register 1
 ******************************************************************************/

/*!
 * @brief I2C_A1 - I2C Address Register 1 (RW)
 *
 * Reset value: 0x00U
 *
 * This register contains the slave address to be used by the I2C module.
 */
/*!
 * @name Constants and macros for entire I2C_A1 register
 */
/*@{*/
#define I2C_RD_A1(base)          (I2C_A1_REG(base))
#define I2C_WR_A1(base, value)   (I2C_A1_REG(base) = (value))
#define I2C_RMW_A1(base, mask, value) (I2C_WR_A1(base, (I2C_RD_A1(base) & ~(mask)) | (value)))
#define I2C_SET_A1(base, value)  (BME_OR8(&I2C_A1_REG(base), (uint8_t)(value)))
#define I2C_CLR_A1(base, value)  (BME_AND8(&I2C_A1_REG(base), (uint8_t)(~(value))))
#define I2C_TOG_A1(base, value)  (BME_XOR8(&I2C_A1_REG(base), (uint8_t)(value)))
/*@}*/

/*
 * Constants & macros for individual I2C_A1 bitfields
 */

/*!
 * @name Register I2C_A1, field AD[7:1] (RW)
 *
 * Contains the primary slave address used by the I2C module when it is
 * addressed as a slave. This field is used in the 7-bit address scheme and the lower
 * seven bits in the 10-bit address scheme.
 */
/*@{*/
/*! @brief Read current value of the I2C_A1_AD field. */
#define I2C_RD_A1_AD(base)   ((I2C_A1_REG(base) & I2C_A1_AD_MASK) >> I2C_A1_AD_SHIFT)
#define I2C_BRD_A1_AD(base)  (BME_UBFX8(&I2C_A1_REG(base), I2C_A1_AD_SHIFT, I2C_A1_AD_WIDTH))

/*! @brief Set the AD field to a new value. */
#define I2C_WR_A1_AD(base, value) (I2C_RMW_A1(base, I2C_A1_AD_MASK, I2C_A1_AD(value)))
#define I2C_BWR_A1_AD(base, value) (BME_BFI8(&I2C_A1_REG(base), ((uint8_t)(value) << I2C_A1_AD_SHIFT), I2C_A1_AD_SHIFT, I2C_A1_AD_WIDTH))
/*@}*/

/*******************************************************************************
 * I2C_F - I2C Frequency Divider register
 ******************************************************************************/

/*!
 * @brief I2C_F - I2C Frequency Divider register (RW)
 *
 * Reset value: 0x00U
 */
/*!
 * @name Constants and macros for entire I2C_F register
 */
/*@{*/
#define I2C_RD_F(base)           (I2C_F_REG(base))
#define I2C_WR_F(base, value)    (I2C_F_REG(base) = (value))
#define I2C_RMW_F(base, mask, value) (I2C_WR_F(base, (I2C_RD_F(base) & ~(mask)) | (value)))
#define I2C_SET_F(base, value)   (BME_OR8(&I2C_F_REG(base), (uint8_t)(value)))
#define I2C_CLR_F(base, value)   (BME_AND8(&I2C_F_REG(base), (uint8_t)(~(value))))
#define I2C_TOG_F(base, value)   (BME_XOR8(&I2C_F_REG(base), (uint8_t)(value)))
/*@}*/

/*
 * Constants & macros for individual I2C_F bitfields
 */

/*!
 * @name Register I2C_F, field ICR[5:0] (RW)
 *
 * Prescales the I2C module clock for bit rate selection. This field and the
 * MULT field determine the I2C baud rate, the SDA hold time, the SCL start hold
 * time, and the SCL stop hold time. For a list of values corresponding to each ICR
 * setting, see I2C divider and hold values. The SCL divider multiplied by
 * multiplier factor (mul) determines the I2C baud rate. I2C baud rate = I2C module
 * clock speed (Hz)/(mul * SCL divider) The SDA hold time is the delay from the
 * falling edge of SCL (I2C clock) to the changing of SDA (I2C data). SDA hold time =
 * I2C module clock period (s) * mul * SDA hold value The SCL start hold time is
 * the delay from the falling edge of SDA (I2C data) while SCL is high (start
 * condition) to the falling edge of SCL (I2C clock). SCL start hold time = I2C
 * module clock period (s) * mul * SCL start hold value The SCL stop hold time is
 * the delay from the rising edge of SCL (I2C clock) to the rising edge of SDA (I2C
 * data) while SCL is high (stop condition). SCL stop hold time = I2C module
 * clock period (s) * mul * SCL stop hold value For example, if the I2C module clock
 * speed is 8 MHz, the following table shows the possible hold time values with
 * different ICR and MULT selections to achieve an I2C baud rate of 100 kbit/s.
 * MULT ICR Hold times (us) SDA SCL Start SCL Stop 2h 00h 3.500 3.000 5.500 1h 07h
 * 2.500 4.000 5.250 1h 0Bh 2.250 4.000 5.250 0h 14h 2.125 4.250 5.125 0h 18h
 * 1.125 4.750 5.125
 */
/*@{*/
/*! @brief Read current value of the I2C_F_ICR field. */
#define I2C_RD_F_ICR(base)   ((I2C_F_REG(base) & I2C_F_ICR_MASK) >> I2C_F_ICR_SHIFT)
#define I2C_BRD_F_ICR(base)  (BME_UBFX8(&I2C_F_REG(base), I2C_F_ICR_SHIFT, I2C_F_ICR_WIDTH))

/*! @brief Set the ICR field to a new value. */
#define I2C_WR_F_ICR(base, value) (I2C_RMW_F(base, I2C_F_ICR_MASK, I2C_F_ICR(value)))
#define I2C_BWR_F_ICR(base, value) (BME_BFI8(&I2C_F_REG(base), ((uint8_t)(value) << I2C_F_ICR_SHIFT), I2C_F_ICR_SHIFT, I2C_F_ICR_WIDTH))
/*@}*/

/*!
 * @name Register I2C_F, field MULT[7:6] (RW)
 *
 * Defines the multiplier factor (mul). This factor is used along with the SCL
 * divider to generate the I2C baud rate.
 *
 * Values:
 * - 00 - mul = 1
 * - 01 - mul = 2
 * - 10 - mul = 4
 * - 11 - Reserved
 */
/*@{*/
/*! @brief Read current value of the I2C_F_MULT field. */
#define I2C_RD_F_MULT(base)  ((I2C_F_REG(base) & I2C_F_MULT_MASK) >> I2C_F_MULT_SHIFT)
#define I2C_BRD_F_MULT(base) (BME_UBFX8(&I2C_F_REG(base), I2C_F_MULT_SHIFT, I2C_F_MULT_WIDTH))

/*! @brief Set the MULT field to a new value. */
#define I2C_WR_F_MULT(base, value) (I2C_RMW_F(base, I2C_F_MULT_MASK, I2C_F_MULT(value)))
#define I2C_BWR_F_MULT(base, value) (BME_BFI8(&I2C_F_REG(base), ((uint8_t)(value) << I2C_F_MULT_SHIFT), I2C_F_MULT_SHIFT, I2C_F_MULT_WIDTH))
/*@}*/

/*******************************************************************************
 * I2C_C1 - I2C Control Register 1
 ******************************************************************************/

/*!
 * @brief I2C_C1 - I2C Control Register 1 (RW)
 *
 * Reset value: 0x00U
 */
/*!
 * @name Constants and macros for entire I2C_C1 register
 */
/*@{*/
#define I2C_RD_C1(base)          (I2C_C1_REG(base))
#define I2C_WR_C1(base, value)   (I2C_C1_REG(base) = (value))
#define I2C_RMW_C1(base, mask, value) (I2C_WR_C1(base, (I2C_RD_C1(base) & ~(mask)) | (value)))
#define I2C_SET_C1(base, value)  (BME_OR8(&I2C_C1_REG(base), (uint8_t)(value)))
#define I2C_CLR_C1(base, value)  (BME_AND8(&I2C_C1_REG(base), (uint8_t)(~(value))))
#define I2C_TOG_C1(base, value)  (BME_XOR8(&I2C_C1_REG(base), (uint8_t)(value)))
/*@}*/

/*
 * Constants & macros for individual I2C_C1 bitfields
 */

/*!
 * @name Register I2C_C1, field DMAEN[0] (RW)
 *
 * Enables or disables the DMA function.
 *
 * Values:
 * - 0 - All DMA signalling disabled.
 * - 1 - DMA transfer is enabled. While SMB[FACK] = 0, the following conditions
 *     trigger the DMA request: a data byte is received, and either address or
 *     data is transmitted. (ACK/NACK is automatic) the first byte received matches
 *     the A1 register or is a general call address. If any address matching
 *     occurs, S[IAAS] and S[TCF] are set. If the direction of transfer is known
 *     from master to slave, then it is not required to check S[SRW]. With this
 *     assumption, DMA can also be used in this case. In other cases, if the master
 *     reads data from the slave, then it is required to rewrite the C1 register
 *     operation. With this assumption, DMA cannot be used. When FACK = 1, an
 *     address or a data byte is transmitted.
 */
/*@{*/
/*! @brief Read current value of the I2C_C1_DMAEN field. */
#define I2C_RD_C1_DMAEN(base) ((I2C_C1_REG(base) & I2C_C1_DMAEN_MASK) >> I2C_C1_DMAEN_SHIFT)
#define I2C_BRD_C1_DMAEN(base) (BME_UBFX8(&I2C_C1_REG(base), I2C_C1_DMAEN_SHIFT, I2C_C1_DMAEN_WIDTH))

/*! @brief Set the DMAEN field to a new value. */
#define I2C_WR_C1_DMAEN(base, value) (I2C_RMW_C1(base, I2C_C1_DMAEN_MASK, I2C_C1_DMAEN(value)))
#define I2C_BWR_C1_DMAEN(base, value) (BME_BFI8(&I2C_C1_REG(base), ((uint8_t)(value) << I2C_C1_DMAEN_SHIFT), I2C_C1_DMAEN_SHIFT, I2C_C1_DMAEN_WIDTH))
/*@}*/

/*!
 * @name Register I2C_C1, field WUEN[1] (RW)
 *
 * The I2C module can wake the MCU from low power mode with no peripheral bus
 * running when slave address matching occurs.
 *
 * Values:
 * - 0 - Normal operation. No interrupt generated when address matching in low
 *     power mode.
 * - 1 - Enables the wakeup function in low power mode.
 */
/*@{*/
/*! @brief Read current value of the I2C_C1_WUEN field. */
#define I2C_RD_C1_WUEN(base) ((I2C_C1_REG(base) & I2C_C1_WUEN_MASK) >> I2C_C1_WUEN_SHIFT)
#define I2C_BRD_C1_WUEN(base) (BME_UBFX8(&I2C_C1_REG(base), I2C_C1_WUEN_SHIFT, I2C_C1_WUEN_WIDTH))

/*! @brief Set the WUEN field to a new value. */
#define I2C_WR_C1_WUEN(base, value) (I2C_RMW_C1(base, I2C_C1_WUEN_MASK, I2C_C1_WUEN(value)))
#define I2C_BWR_C1_WUEN(base, value) (BME_BFI8(&I2C_C1_REG(base), ((uint8_t)(value) << I2C_C1_WUEN_SHIFT), I2C_C1_WUEN_SHIFT, I2C_C1_WUEN_WIDTH))
/*@}*/

/*!
 * @name Register I2C_C1, field RSTA[2] (WORZ)
 *
 * Writing 1 to this bit generates a repeated START condition provided it is the
 * current master. This bit will always be read as 0. Attempting a repeat at the
 * wrong time results in loss of arbitration.
 */
/*@{*/
/*! @brief Set the RSTA field to a new value. */
#define I2C_WR_C1_RSTA(base, value) (I2C_RMW_C1(base, I2C_C1_RSTA_MASK, I2C_C1_RSTA(value)))
#define I2C_BWR_C1_RSTA(base, value) (BME_BFI8(&I2C_C1_REG(base), ((uint8_t)(value) << I2C_C1_RSTA_SHIFT), I2C_C1_RSTA_SHIFT, I2C_C1_RSTA_WIDTH))
/*@}*/

/*!
 * @name Register I2C_C1, field TXAK[3] (RW)
 *
 * Specifies the value driven onto the SDA during data acknowledge cycles for
 * both master and slave receivers. The value of SMB[FACK] affects NACK/ACK
 * generation. SCL is held low until TXAK is written.
 *
 * Values:
 * - 0 - An acknowledge signal is sent to the bus on the following receiving
 *     byte (if FACK is cleared) or the current receiving byte (if FACK is set).
 * - 1 - No acknowledge signal is sent to the bus on the following receiving
 *     data byte (if FACK is cleared) or the current receiving data byte (if FACK is
 *     set).
 */
/*@{*/
/*! @brief Read current value of the I2C_C1_TXAK field. */
#define I2C_RD_C1_TXAK(base) ((I2C_C1_REG(base) & I2C_C1_TXAK_MASK) >> I2C_C1_TXAK_SHIFT)
#define I2C_BRD_C1_TXAK(base) (BME_UBFX8(&I2C_C1_REG(base), I2C_C1_TXAK_SHIFT, I2C_C1_TXAK_WIDTH))

/*! @brief Set the TXAK field to a new value. */
#define I2C_WR_C1_TXAK(base, value) (I2C_RMW_C1(base, I2C_C1_TXAK_MASK, I2C_C1_TXAK(value)))
#define I2C_BWR_C1_TXAK(base, value) (BME_BFI8(&I2C_C1_REG(base), ((uint8_t)(value) << I2C_C1_TXAK_SHIFT), I2C_C1_TXAK_SHIFT, I2C_C1_TXAK_WIDTH))
/*@}*/

/*!
 * @name Register I2C_C1, field TX[4] (RW)
 *
 * Selects the direction of master and slave transfers. In master mode this bit
 * must be set according to the type of transfer required. Therefore, for address
 * cycles, this bit is always set. When addressed as a slave this bit must be
 * set by software according to the SRW bit in the status register.
 *
 * Values:
 * - 0 - Receive
 * - 1 - Transmit
 */
/*@{*/
/*! @brief Read current value of the I2C_C1_TX field. */
#define I2C_RD_C1_TX(base)   ((I2C_C1_REG(base) & I2C_C1_TX_MASK) >> I2C_C1_TX_SHIFT)
#define I2C_BRD_C1_TX(base)  (BME_UBFX8(&I2C_C1_REG(base), I2C_C1_TX_SHIFT, I2C_C1_TX_WIDTH))

/*! @brief Set the TX field to a new value. */
#define I2C_WR_C1_TX(base, value) (I2C_RMW_C1(base, I2C_C1_TX_MASK, I2C_C1_TX(value)))
#define I2C_BWR_C1_TX(base, value) (BME_BFI8(&I2C_C1_REG(base), ((uint8_t)(value) << I2C_C1_TX_SHIFT), I2C_C1_TX_SHIFT, I2C_C1_TX_WIDTH))
/*@}*/

/*!
 * @name Register I2C_C1, field MST[5] (RW)
 *
 * When MST is changed from 0 to 1, a START signal is generated on the bus and
 * master mode is selected. When this bit changes from 1 to 0, a STOP signal is
 * generated and the mode of operation changes from master to slave.
 *
 * Values:
 * - 0 - Slave mode
 * - 1 - Master mode
 */
/*@{*/
/*! @brief Read current value of the I2C_C1_MST field. */
#define I2C_RD_C1_MST(base)  ((I2C_C1_REG(base) & I2C_C1_MST_MASK) >> I2C_C1_MST_SHIFT)
#define I2C_BRD_C1_MST(base) (BME_UBFX8(&I2C_C1_REG(base), I2C_C1_MST_SHIFT, I2C_C1_MST_WIDTH))

/*! @brief Set the MST field to a new value. */
#define I2C_WR_C1_MST(base, value) (I2C_RMW_C1(base, I2C_C1_MST_MASK, I2C_C1_MST(value)))
#define I2C_BWR_C1_MST(base, value) (BME_BFI8(&I2C_C1_REG(base), ((uint8_t)(value) << I2C_C1_MST_SHIFT), I2C_C1_MST_SHIFT, I2C_C1_MST_WIDTH))
/*@}*/

/*!
 * @name Register I2C_C1, field IICIE[6] (RW)
 *
 * Enables I2C interrupt requests.
 *
 * Values:
 * - 0 - Disabled
 * - 1 - Enabled
 */
/*@{*/
/*! @brief Read current value of the I2C_C1_IICIE field. */
#define I2C_RD_C1_IICIE(base) ((I2C_C1_REG(base) & I2C_C1_IICIE_MASK) >> I2C_C1_IICIE_SHIFT)
#define I2C_BRD_C1_IICIE(base) (BME_UBFX8(&I2C_C1_REG(base), I2C_C1_IICIE_SHIFT, I2C_C1_IICIE_WIDTH))

/*! @brief Set the IICIE field to a new value. */
#define I2C_WR_C1_IICIE(base, value) (I2C_RMW_C1(base, I2C_C1_IICIE_MASK, I2C_C1_IICIE(value)))
#define I2C_BWR_C1_IICIE(base, value) (BME_BFI8(&I2C_C1_REG(base), ((uint8_t)(value) << I2C_C1_IICIE_SHIFT), I2C_C1_IICIE_SHIFT, I2C_C1_IICIE_WIDTH))
/*@}*/

/*!
 * @name Register I2C_C1, field IICEN[7] (RW)
 *
 * Enables I2C module operation.
 *
 * Values:
 * - 0 - Disabled
 * - 1 - Enabled
 */
/*@{*/
/*! @brief Read current value of the I2C_C1_IICEN field. */
#define I2C_RD_C1_IICEN(base) ((I2C_C1_REG(base) & I2C_C1_IICEN_MASK) >> I2C_C1_IICEN_SHIFT)
#define I2C_BRD_C1_IICEN(base) (BME_UBFX8(&I2C_C1_REG(base), I2C_C1_IICEN_SHIFT, I2C_C1_IICEN_WIDTH))

/*! @brief Set the IICEN field to a new value. */
#define I2C_WR_C1_IICEN(base, value) (I2C_RMW_C1(base, I2C_C1_IICEN_MASK, I2C_C1_IICEN(value)))
#define I2C_BWR_C1_IICEN(base, value) (BME_BFI8(&I2C_C1_REG(base), ((uint8_t)(value) << I2C_C1_IICEN_SHIFT), I2C_C1_IICEN_SHIFT, I2C_C1_IICEN_WIDTH))
/*@}*/

/*******************************************************************************
 * I2C_S - I2C Status register
 ******************************************************************************/

/*!
 * @brief I2C_S - I2C Status register (RW)
 *
 * Reset value: 0x80U
 */
/*!
 * @name Constants and macros for entire I2C_S register
 */
/*@{*/
#define I2C_RD_S(base)           (I2C_S_REG(base))
#define I2C_WR_S(base, value)    (I2C_S_REG(base) = (value))
#define I2C_RMW_S(base, mask, value) (I2C_WR_S(base, (I2C_RD_S(base) & ~(mask)) | (value)))
#define I2C_SET_S(base, value)   (BME_OR8(&I2C_S_REG(base), (uint8_t)(value)))
#define I2C_CLR_S(base, value)   (BME_AND8(&I2C_S_REG(base), (uint8_t)(~(value))))
#define I2C_TOG_S(base, value)   (BME_XOR8(&I2C_S_REG(base), (uint8_t)(value)))
/*@}*/

/*
 * Constants & macros for individual I2C_S bitfields
 */

/*!
 * @name Register I2C_S, field RXAK[0] (RO)
 *
 * Values:
 * - 0 - Acknowledge signal was received after the completion of one byte of
 *     data transmission on the bus
 * - 1 - No acknowledge signal detected
 */
/*@{*/
/*! @brief Read current value of the I2C_S_RXAK field. */
#define I2C_RD_S_RXAK(base)  ((I2C_S_REG(base) & I2C_S_RXAK_MASK) >> I2C_S_RXAK_SHIFT)
#define I2C_BRD_S_RXAK(base) (BME_UBFX8(&I2C_S_REG(base), I2C_S_RXAK_SHIFT, I2C_S_RXAK_WIDTH))
/*@}*/

/*!
 * @name Register I2C_S, field IICIF[1] (W1C)
 *
 * This bit sets when an interrupt is pending. This bit must be cleared by
 * software by writing 1 to it, such as in the interrupt routine. One of the following
 * events can set this bit: One byte transfer, including ACK/NACK bit, completes
 * if FACK is 0. An ACK or NACK is sent on the bus by writing 0 or 1 to TXAK
 * after this bit is set in receive mode. One byte transfer, excluding ACK/NACK bit,
 * completes if FACK is 1. Match of slave address to calling address including
 * primary slave address, range slave address , alert response address, second
 * slave address, or general call address. Arbitration lost In SMBus mode, any
 * timeouts except SCL and SDA high timeouts I2C bus stop or start detection if the
 * SSIE bit in the Input Glitch Filter register is 1 To clear the I2C bus stop or
 * start detection interrupt: In the interrupt service routine, first clear the
 * STOPF or STARTF bit in the Input Glitch Filter register by writing 1 to it, and
 * then clear the IICIF bit. If this sequence is reversed, the IICIF bit is
 * asserted again.
 *
 * Values:
 * - 0 - No interrupt pending
 * - 1 - Interrupt pending
 */
/*@{*/
/*! @brief Read current value of the I2C_S_IICIF field. */
#define I2C_RD_S_IICIF(base) ((I2C_S_REG(base) & I2C_S_IICIF_MASK) >> I2C_S_IICIF_SHIFT)
#define I2C_BRD_S_IICIF(base) (BME_UBFX8(&I2C_S_REG(base), I2C_S_IICIF_SHIFT, I2C_S_IICIF_WIDTH))

/*! @brief Set the IICIF field to a new value. */
#define I2C_WR_S_IICIF(base, value) (I2C_RMW_S(base, (I2C_S_IICIF_MASK | I2C_S_ARBL_MASK), I2C_S_IICIF(value)))
#define I2C_BWR_S_IICIF(base, value) (BME_BFI8(&I2C_S_REG(base), ((uint8_t)(value) << I2C_S_IICIF_SHIFT), I2C_S_IICIF_SHIFT, I2C_S_IICIF_WIDTH))
/*@}*/

/*!
 * @name Register I2C_S, field SRW[2] (RO)
 *
 * When addressed as a slave, SRW indicates the value of the R/W command bit of
 * the calling address sent to the master.
 *
 * Values:
 * - 0 - Slave receive, master writing to slave
 * - 1 - Slave transmit, master reading from slave
 */
/*@{*/
/*! @brief Read current value of the I2C_S_SRW field. */
#define I2C_RD_S_SRW(base)   ((I2C_S_REG(base) & I2C_S_SRW_MASK) >> I2C_S_SRW_SHIFT)
#define I2C_BRD_S_SRW(base)  (BME_UBFX8(&I2C_S_REG(base), I2C_S_SRW_SHIFT, I2C_S_SRW_WIDTH))
/*@}*/

/*!
 * @name Register I2C_S, field RAM[3] (RW)
 *
 * This bit is set to 1 by any of the following conditions, if I2C_C2[RMEN] = 1:
 * Any nonzero calling address is received that matches the address in the RA
 * register. The calling address is within the range of values of the A1 and RA
 * registers. For the RAM bit to be set to 1 correctly, C1[IICIE] must be set to 1.
 * Writing the C1 register with any value clears this bit to 0.
 *
 * Values:
 * - 0 - Not addressed
 * - 1 - Addressed as a slave
 */
/*@{*/
/*! @brief Read current value of the I2C_S_RAM field. */
#define I2C_RD_S_RAM(base)   ((I2C_S_REG(base) & I2C_S_RAM_MASK) >> I2C_S_RAM_SHIFT)
#define I2C_BRD_S_RAM(base)  (BME_UBFX8(&I2C_S_REG(base), I2C_S_RAM_SHIFT, I2C_S_RAM_WIDTH))

/*! @brief Set the RAM field to a new value. */
#define I2C_WR_S_RAM(base, value) (I2C_RMW_S(base, (I2C_S_RAM_MASK | I2C_S_IICIF_MASK | I2C_S_ARBL_MASK), I2C_S_RAM(value)))
#define I2C_BWR_S_RAM(base, value) (BME_BFI8(&I2C_S_REG(base), ((uint8_t)(value) << I2C_S_RAM_SHIFT), I2C_S_RAM_SHIFT, I2C_S_RAM_WIDTH))
/*@}*/

/*!
 * @name Register I2C_S, field ARBL[4] (W1C)
 *
 * This bit is set by hardware when the arbitration procedure is lost. The ARBL
 * bit must be cleared by software, by writing 1 to it.
 *
 * Values:
 * - 0 - Standard bus operation.
 * - 1 - Loss of arbitration.
 */
/*@{*/
/*! @brief Read current value of the I2C_S_ARBL field. */
#define I2C_RD_S_ARBL(base)  ((I2C_S_REG(base) & I2C_S_ARBL_MASK) >> I2C_S_ARBL_SHIFT)
#define I2C_BRD_S_ARBL(base) (BME_UBFX8(&I2C_S_REG(base), I2C_S_ARBL_SHIFT, I2C_S_ARBL_WIDTH))

/*! @brief Set the ARBL field to a new value. */
#define I2C_WR_S_ARBL(base, value) (I2C_RMW_S(base, (I2C_S_ARBL_MASK | I2C_S_IICIF_MASK), I2C_S_ARBL(value)))
#define I2C_BWR_S_ARBL(base, value) (BME_BFI8(&I2C_S_REG(base), ((uint8_t)(value) << I2C_S_ARBL_SHIFT), I2C_S_ARBL_SHIFT, I2C_S_ARBL_WIDTH))
/*@}*/

/*!
 * @name Register I2C_S, field BUSY[5] (RO)
 *
 * Indicates the status of the bus regardless of slave or master mode. This bit
 * is set when a START signal is detected and cleared when a STOP signal is
 * detected.
 *
 * Values:
 * - 0 - Bus is idle
 * - 1 - Bus is busy
 */
/*@{*/
/*! @brief Read current value of the I2C_S_BUSY field. */
#define I2C_RD_S_BUSY(base)  ((I2C_S_REG(base) & I2C_S_BUSY_MASK) >> I2C_S_BUSY_SHIFT)
#define I2C_BRD_S_BUSY(base) (BME_UBFX8(&I2C_S_REG(base), I2C_S_BUSY_SHIFT, I2C_S_BUSY_WIDTH))
/*@}*/

/*!
 * @name Register I2C_S, field IAAS[6] (RW)
 *
 * This bit is set by one of the following conditions: The calling address
 * matches the programmed primary slave address in the A1 register, or matches the
 * range address in the RA register (which must be set to a nonzero value and under
 * the condition I2C_C2[RMEN] = 1). C2[GCAEN] is set and a general call is
 * received. SMB[SIICAEN] is set and the calling address matches the second programmed
 * slave address. ALERTEN is set and an SMBus alert response address is received
 * RMEN is set and an address is received that is within the range between the
 * values of the A1 and RA registers. IAAS sets before the ACK bit. The CPU must
 * check the SRW bit and set TX/RX accordingly. Writing the C1 register with any
 * value clears this bit.
 *
 * Values:
 * - 0 - Not addressed
 * - 1 - Addressed as a slave
 */
/*@{*/
/*! @brief Read current value of the I2C_S_IAAS field. */
#define I2C_RD_S_IAAS(base)  ((I2C_S_REG(base) & I2C_S_IAAS_MASK) >> I2C_S_IAAS_SHIFT)
#define I2C_BRD_S_IAAS(base) (BME_UBFX8(&I2C_S_REG(base), I2C_S_IAAS_SHIFT, I2C_S_IAAS_WIDTH))

/*! @brief Set the IAAS field to a new value. */
#define I2C_WR_S_IAAS(base, value) (I2C_RMW_S(base, (I2C_S_IAAS_MASK | I2C_S_IICIF_MASK | I2C_S_ARBL_MASK), I2C_S_IAAS(value)))
#define I2C_BWR_S_IAAS(base, value) (BME_BFI8(&I2C_S_REG(base), ((uint8_t)(value) << I2C_S_IAAS_SHIFT), I2C_S_IAAS_SHIFT, I2C_S_IAAS_WIDTH))
/*@}*/

/*!
 * @name Register I2C_S, field TCF[7] (RO)
 *
 * Acknowledges a byte transfer; TCF is set on the completion of a byte
 * transfer. This bit is valid only during or immediately following a transfer to or from
 * the I2C module. TCF is cleared by reading the I2C data register in receive
 * mode or by writing to the I2C data register in transmit mode.In the buffer mode,
 * TCF is cleared automatically by internal reading or writing the data register
 * I2C_D, with no need waiting for manually reading/writing the I2C data
 * register in Rx/Tx mode.
 *
 * Values:
 * - 0 - Transfer in progress
 * - 1 - Transfer complete
 */
/*@{*/
/*! @brief Read current value of the I2C_S_TCF field. */
#define I2C_RD_S_TCF(base)   ((I2C_S_REG(base) & I2C_S_TCF_MASK) >> I2C_S_TCF_SHIFT)
#define I2C_BRD_S_TCF(base)  (BME_UBFX8(&I2C_S_REG(base), I2C_S_TCF_SHIFT, I2C_S_TCF_WIDTH))
/*@}*/

/*******************************************************************************
 * I2C_D - I2C Data I/O register
 ******************************************************************************/

/*!
 * @brief I2C_D - I2C Data I/O register (RW)
 *
 * Reset value: 0x00U
 */
/*!
 * @name Constants and macros for entire I2C_D register
 */
/*@{*/
#define I2C_RD_D(base)           (I2C_D_REG(base))
#define I2C_WR_D(base, value)    (I2C_D_REG(base) = (value))
#define I2C_RMW_D(base, mask, value) (I2C_WR_D(base, (I2C_RD_D(base) & ~(mask)) | (value)))
#define I2C_SET_D(base, value)   (BME_OR8(&I2C_D_REG(base), (uint8_t)(value)))
#define I2C_CLR_D(base, value)   (BME_AND8(&I2C_D_REG(base), (uint8_t)(~(value))))
#define I2C_TOG_D(base, value)   (BME_XOR8(&I2C_D_REG(base), (uint8_t)(value)))
/*@}*/

/*******************************************************************************
 * I2C_C2 - I2C Control Register 2
 ******************************************************************************/

/*!
 * @brief I2C_C2 - I2C Control Register 2 (RW)
 *
 * Reset value: 0x00U
 */
/*!
 * @name Constants and macros for entire I2C_C2 register
 */
/*@{*/
#define I2C_RD_C2(base)          (I2C_C2_REG(base))
#define I2C_WR_C2(base, value)   (I2C_C2_REG(base) = (value))
#define I2C_RMW_C2(base, mask, value) (I2C_WR_C2(base, (I2C_RD_C2(base) & ~(mask)) | (value)))
#define I2C_SET_C2(base, value)  (BME_OR8(&I2C_C2_REG(base), (uint8_t)(value)))
#define I2C_CLR_C2(base, value)  (BME_AND8(&I2C_C2_REG(base), (uint8_t)(~(value))))
#define I2C_TOG_C2(base, value)  (BME_XOR8(&I2C_C2_REG(base), (uint8_t)(value)))
/*@}*/

/*
 * Constants & macros for individual I2C_C2 bitfields
 */

/*!
 * @name Register I2C_C2, field AD[2:0] (RW)
 *
 * Contains the upper three bits of the slave address in the 10-bit address
 * scheme. This field is valid only while the ADEXT bit is set.
 */
/*@{*/
/*! @brief Read current value of the I2C_C2_AD field. */
#define I2C_RD_C2_AD(base)   ((I2C_C2_REG(base) & I2C_C2_AD_MASK) >> I2C_C2_AD_SHIFT)
#define I2C_BRD_C2_AD(base)  (BME_UBFX8(&I2C_C2_REG(base), I2C_C2_AD_SHIFT, I2C_C2_AD_WIDTH))

/*! @brief Set the AD field to a new value. */
#define I2C_WR_C2_AD(base, value) (I2C_RMW_C2(base, I2C_C2_AD_MASK, I2C_C2_AD(value)))
#define I2C_BWR_C2_AD(base, value) (BME_BFI8(&I2C_C2_REG(base), ((uint8_t)(value) << I2C_C2_AD_SHIFT), I2C_C2_AD_SHIFT, I2C_C2_AD_WIDTH))
/*@}*/

/*!
 * @name Register I2C_C2, field RMEN[3] (RW)
 *
 * This bit controls the slave address matching for addresses between the values
 * of the A1 and RA registers. When this bit is set, a slave address matching
 * occurs for any address greater than the value of the A1 register and less than
 * or equal to the value of the RA register.
 *
 * Values:
 * - 0 - Range mode disabled. No address matching occurs for an address within
 *     the range of values of the A1 and RA registers.
 * - 1 - Range mode enabled. Address matching occurs when a slave receives an
 *     address within the range of values of the A1 and RA registers.
 */
/*@{*/
/*! @brief Read current value of the I2C_C2_RMEN field. */
#define I2C_RD_C2_RMEN(base) ((I2C_C2_REG(base) & I2C_C2_RMEN_MASK) >> I2C_C2_RMEN_SHIFT)
#define I2C_BRD_C2_RMEN(base) (BME_UBFX8(&I2C_C2_REG(base), I2C_C2_RMEN_SHIFT, I2C_C2_RMEN_WIDTH))

/*! @brief Set the RMEN field to a new value. */
#define I2C_WR_C2_RMEN(base, value) (I2C_RMW_C2(base, I2C_C2_RMEN_MASK, I2C_C2_RMEN(value)))
#define I2C_BWR_C2_RMEN(base, value) (BME_BFI8(&I2C_C2_REG(base), ((uint8_t)(value) << I2C_C2_RMEN_SHIFT), I2C_C2_RMEN_SHIFT, I2C_C2_RMEN_WIDTH))
/*@}*/

/*!
 * @name Register I2C_C2, field SBRC[4] (RW)
 *
 * Enables independent slave mode baud rate at maximum frequency, which forces
 * clock stretching on SCL in very fast I2C modes. To a slave, an example of a
 * "very fast" mode is when the master transfers at 40 kbit/s but the slave can
 * capture the master's data at only 10 kbit/s.
 *
 * Values:
 * - 0 - The slave baud rate follows the master baud rate and clock stretching
 *     may occur
 * - 1 - Slave baud rate is independent of the master baud rate
 */
/*@{*/
/*! @brief Read current value of the I2C_C2_SBRC field. */
#define I2C_RD_C2_SBRC(base) ((I2C_C2_REG(base) & I2C_C2_SBRC_MASK) >> I2C_C2_SBRC_SHIFT)
#define I2C_BRD_C2_SBRC(base) (BME_UBFX8(&I2C_C2_REG(base), I2C_C2_SBRC_SHIFT, I2C_C2_SBRC_WIDTH))

/*! @brief Set the SBRC field to a new value. */
#define I2C_WR_C2_SBRC(base, value) (I2C_RMW_C2(base, I2C_C2_SBRC_MASK, I2C_C2_SBRC(value)))
#define I2C_BWR_C2_SBRC(base, value) (BME_BFI8(&I2C_C2_REG(base), ((uint8_t)(value) << I2C_C2_SBRC_SHIFT), I2C_C2_SBRC_SHIFT, I2C_C2_SBRC_WIDTH))
/*@}*/

/*!
 * @name Register I2C_C2, field HDRS[5] (RW)
 *
 * Controls the drive capability of the I2C pads.
 *
 * Values:
 * - 0 - Normal drive mode
 * - 1 - High drive mode
 */
/*@{*/
/*! @brief Read current value of the I2C_C2_HDRS field. */
#define I2C_RD_C2_HDRS(base) ((I2C_C2_REG(base) & I2C_C2_HDRS_MASK) >> I2C_C2_HDRS_SHIFT)
#define I2C_BRD_C2_HDRS(base) (BME_UBFX8(&I2C_C2_REG(base), I2C_C2_HDRS_SHIFT, I2C_C2_HDRS_WIDTH))

/*! @brief Set the HDRS field to a new value. */
#define I2C_WR_C2_HDRS(base, value) (I2C_RMW_C2(base, I2C_C2_HDRS_MASK, I2C_C2_HDRS(value)))
#define I2C_BWR_C2_HDRS(base, value) (BME_BFI8(&I2C_C2_REG(base), ((uint8_t)(value) << I2C_C2_HDRS_SHIFT), I2C_C2_HDRS_SHIFT, I2C_C2_HDRS_WIDTH))
/*@}*/

/*!
 * @name Register I2C_C2, field ADEXT[6] (RW)
 *
 * Controls the number of bits used for the slave address.
 *
 * Values:
 * - 0 - 7-bit address scheme
 * - 1 - 10-bit address scheme
 */
/*@{*/
/*! @brief Read current value of the I2C_C2_ADEXT field. */
#define I2C_RD_C2_ADEXT(base) ((I2C_C2_REG(base) & I2C_C2_ADEXT_MASK) >> I2C_C2_ADEXT_SHIFT)
#define I2C_BRD_C2_ADEXT(base) (BME_UBFX8(&I2C_C2_REG(base), I2C_C2_ADEXT_SHIFT, I2C_C2_ADEXT_WIDTH))

/*! @brief Set the ADEXT field to a new value. */
#define I2C_WR_C2_ADEXT(base, value) (I2C_RMW_C2(base, I2C_C2_ADEXT_MASK, I2C_C2_ADEXT(value)))
#define I2C_BWR_C2_ADEXT(base, value) (BME_BFI8(&I2C_C2_REG(base), ((uint8_t)(value) << I2C_C2_ADEXT_SHIFT), I2C_C2_ADEXT_SHIFT, I2C_C2_ADEXT_WIDTH))
/*@}*/

/*!
 * @name Register I2C_C2, field GCAEN[7] (RW)
 *
 * Enables general call address.
 *
 * Values:
 * - 0 - Disabled
 * - 1 - Enabled
 */
/*@{*/
/*! @brief Read current value of the I2C_C2_GCAEN field. */
#define I2C_RD_C2_GCAEN(base) ((I2C_C2_REG(base) & I2C_C2_GCAEN_MASK) >> I2C_C2_GCAEN_SHIFT)
#define I2C_BRD_C2_GCAEN(base) (BME_UBFX8(&I2C_C2_REG(base), I2C_C2_GCAEN_SHIFT, I2C_C2_GCAEN_WIDTH))

/*! @brief Set the GCAEN field to a new value. */
#define I2C_WR_C2_GCAEN(base, value) (I2C_RMW_C2(base, I2C_C2_GCAEN_MASK, I2C_C2_GCAEN(value)))
#define I2C_BWR_C2_GCAEN(base, value) (BME_BFI8(&I2C_C2_REG(base), ((uint8_t)(value) << I2C_C2_GCAEN_SHIFT), I2C_C2_GCAEN_SHIFT, I2C_C2_GCAEN_WIDTH))
/*@}*/

/*******************************************************************************
 * I2C_FLT - I2C Programmable Input Glitch Filter Register
 ******************************************************************************/

/*!
 * @brief I2C_FLT - I2C Programmable Input Glitch Filter Register (RW)
 *
 * Reset value: 0x00U
 */
/*!
 * @name Constants and macros for entire I2C_FLT register
 */
/*@{*/
#define I2C_RD_FLT(base)         (I2C_FLT_REG(base))
#define I2C_WR_FLT(base, value)  (I2C_FLT_REG(base) = (value))
#define I2C_RMW_FLT(base, mask, value) (I2C_WR_FLT(base, (I2C_RD_FLT(base) & ~(mask)) | (value)))
#define I2C_SET_FLT(base, value) (BME_OR8(&I2C_FLT_REG(base), (uint8_t)(value)))
#define I2C_CLR_FLT(base, value) (BME_AND8(&I2C_FLT_REG(base), (uint8_t)(~(value))))
#define I2C_TOG_FLT(base, value) (BME_XOR8(&I2C_FLT_REG(base), (uint8_t)(value)))
/*@}*/

/*
 * Constants & macros for individual I2C_FLT bitfields
 */

/*!
 * @name Register I2C_FLT, field FLT[3:0] (RW)
 *
 * Controls the width of the glitch, in terms of I2C module clock cycles, that
 * the filter must absorb. For any glitch whose size is less than or equal to this
 * width setting, the filter does not allow the glitch to pass.
 *
 * Values:
 * - 0 - No filter/bypass
 */
/*@{*/
/*! @brief Read current value of the I2C_FLT_FLT field. */
#define I2C_RD_FLT_FLT(base) ((I2C_FLT_REG(base) & I2C_FLT_FLT_MASK) >> I2C_FLT_FLT_SHIFT)
#define I2C_BRD_FLT_FLT(base) (BME_UBFX8(&I2C_FLT_REG(base), I2C_FLT_FLT_SHIFT, I2C_FLT_FLT_WIDTH))

/*! @brief Set the FLT field to a new value. */
#define I2C_WR_FLT_FLT(base, value) (I2C_RMW_FLT(base, (I2C_FLT_FLT_MASK | I2C_FLT_STARTF_MASK | I2C_FLT_STOPF_MASK), I2C_FLT_FLT(value)))
#define I2C_BWR_FLT_FLT(base, value) (BME_BFI8(&I2C_FLT_REG(base), ((uint8_t)(value) << I2C_FLT_FLT_SHIFT), I2C_FLT_FLT_SHIFT, I2C_FLT_FLT_WIDTH))
/*@}*/

/*!
 * @name Register I2C_FLT, field STARTF[4] (W1C)
 *
 * Hardware sets this bit when the I2C bus's start status is detected. The
 * STARTF bit must be cleared by writing 1 to it.
 *
 * Values:
 * - 0 - No start happens on I2C bus
 * - 1 - Start detected on I2C bus
 */
/*@{*/
/*! @brief Read current value of the I2C_FLT_STARTF field. */
#define I2C_RD_FLT_STARTF(base) ((I2C_FLT_REG(base) & I2C_FLT_STARTF_MASK) >> I2C_FLT_STARTF_SHIFT)
#define I2C_BRD_FLT_STARTF(base) (BME_UBFX8(&I2C_FLT_REG(base), I2C_FLT_STARTF_SHIFT, I2C_FLT_STARTF_WIDTH))

/*! @brief Set the STARTF field to a new value. */
#define I2C_WR_FLT_STARTF(base, value) (I2C_RMW_FLT(base, (I2C_FLT_STARTF_MASK | I2C_FLT_STOPF_MASK), I2C_FLT_STARTF(value)))
#define I2C_BWR_FLT_STARTF(base, value) (BME_BFI8(&I2C_FLT_REG(base), ((uint8_t)(value) << I2C_FLT_STARTF_SHIFT), I2C_FLT_STARTF_SHIFT, I2C_FLT_STARTF_WIDTH))
/*@}*/

/*!
 * @name Register I2C_FLT, field SSIE[5] (RW)
 *
 * This bit enables the interrupt for I2C bus stop or start detection. To clear
 * the I2C bus stop or start detection interrupt: In the interrupt service
 * routine, first clear the STOPF or STARTF bit by writing 1 to it, and then clear the
 * IICIF bit in the status register. If this sequence is reversed, the IICIF bit
 * is asserted again.
 *
 * Values:
 * - 0 - Stop or start detection interrupt is disabled
 * - 1 - Stop or start detection interrupt is enabled
 */
/*@{*/
/*! @brief Read current value of the I2C_FLT_SSIE field. */
#define I2C_RD_FLT_SSIE(base) ((I2C_FLT_REG(base) & I2C_FLT_SSIE_MASK) >> I2C_FLT_SSIE_SHIFT)
#define I2C_BRD_FLT_SSIE(base) (BME_UBFX8(&I2C_FLT_REG(base), I2C_FLT_SSIE_SHIFT, I2C_FLT_SSIE_WIDTH))

/*! @brief Set the SSIE field to a new value. */
#define I2C_WR_FLT_SSIE(base, value) (I2C_RMW_FLT(base, (I2C_FLT_SSIE_MASK | I2C_FLT_STARTF_MASK | I2C_FLT_STOPF_MASK), I2C_FLT_SSIE(value)))
#define I2C_BWR_FLT_SSIE(base, value) (BME_BFI8(&I2C_FLT_REG(base), ((uint8_t)(value) << I2C_FLT_SSIE_SHIFT), I2C_FLT_SSIE_SHIFT, I2C_FLT_SSIE_WIDTH))
/*@}*/

/*!
 * @name Register I2C_FLT, field STOPF[6] (W1C)
 *
 * Hardware sets this bit when the I2C bus's stop status is detected. The STOPF
 * bit must be cleared by writing 1 to it.
 *
 * Values:
 * - 0 - No stop happens on I2C bus
 * - 1 - Stop detected on I2C bus
 */
/*@{*/
/*! @brief Read current value of the I2C_FLT_STOPF field. */
#define I2C_RD_FLT_STOPF(base) ((I2C_FLT_REG(base) & I2C_FLT_STOPF_MASK) >> I2C_FLT_STOPF_SHIFT)
#define I2C_BRD_FLT_STOPF(base) (BME_UBFX8(&I2C_FLT_REG(base), I2C_FLT_STOPF_SHIFT, I2C_FLT_STOPF_WIDTH))

/*! @brief Set the STOPF field to a new value. */
#define I2C_WR_FLT_STOPF(base, value) (I2C_RMW_FLT(base, (I2C_FLT_STOPF_MASK | I2C_FLT_STARTF_MASK), I2C_FLT_STOPF(value)))
#define I2C_BWR_FLT_STOPF(base, value) (BME_BFI8(&I2C_FLT_REG(base), ((uint8_t)(value) << I2C_FLT_STOPF_SHIFT), I2C_FLT_STOPF_SHIFT, I2C_FLT_STOPF_WIDTH))
/*@}*/

/*!
 * @name Register I2C_FLT, field SHEN[7] (RW)
 *
 * Set this bit to hold off entry to stop mode when any data transmission or
 * reception is occurring. The following scenario explains the holdoff
 * functionality: The I2C module is configured for a basic transfer, and the SHEN bit is set
 * to 1. A transfer begins. The MCU signals the I2C module to enter stop mode. The
 * byte currently being transferred, including both address and data, completes
 * its transfer. The I2C slave or master acknowledges that the in-transfer byte
 * completed its transfer and acknowledges the request to enter stop mode. After
 * receiving the I2C module's acknowledgment of the request to enter stop mode,
 * the MCU determines whether to shut off the I2C module's clock. If the SHEN bit
 * is set to 1 and the I2C module is in an idle or disabled state when the MCU
 * signals to enter stop mode, the module immediately acknowledges the request to
 * enter stop mode. If SHEN is cleared to 0 and the overall data transmission or
 * reception that was suspended by stop mode entry was incomplete: To resume the
 * overall transmission or reception after the MCU exits stop mode, software must
 * reinitialize the transfer by resending the address of the slave. If the I2C
 * Control Register 1's IICIE bit was set to 1 before the MCU entered stop mode,
 * system software will receive the interrupt triggered by the I2C Status Register's
 * TCF bit after the MCU wakes from the stop mode.
 *
 * Values:
 * - 0 - Stop holdoff is disabled. The MCU's entry to stop mode is not gated.
 * - 1 - Stop holdoff is enabled.
 */
/*@{*/
/*! @brief Read current value of the I2C_FLT_SHEN field. */
#define I2C_RD_FLT_SHEN(base) ((I2C_FLT_REG(base) & I2C_FLT_SHEN_MASK) >> I2C_FLT_SHEN_SHIFT)
#define I2C_BRD_FLT_SHEN(base) (BME_UBFX8(&I2C_FLT_REG(base), I2C_FLT_SHEN_SHIFT, I2C_FLT_SHEN_WIDTH))

/*! @brief Set the SHEN field to a new value. */
#define I2C_WR_FLT_SHEN(base, value) (I2C_RMW_FLT(base, (I2C_FLT_SHEN_MASK | I2C_FLT_STARTF_MASK | I2C_FLT_STOPF_MASK), I2C_FLT_SHEN(value)))
#define I2C_BWR_FLT_SHEN(base, value) (BME_BFI8(&I2C_FLT_REG(base), ((uint8_t)(value) << I2C_FLT_SHEN_SHIFT), I2C_FLT_SHEN_SHIFT, I2C_FLT_SHEN_WIDTH))
/*@}*/

/*******************************************************************************
 * I2C_RA - I2C Range Address register
 ******************************************************************************/

/*!
 * @brief I2C_RA - I2C Range Address register (RW)
 *
 * Reset value: 0x00U
 */
/*!
 * @name Constants and macros for entire I2C_RA register
 */
/*@{*/
#define I2C_RD_RA(base)          (I2C_RA_REG(base))
#define I2C_WR_RA(base, value)   (I2C_RA_REG(base) = (value))
#define I2C_RMW_RA(base, mask, value) (I2C_WR_RA(base, (I2C_RD_RA(base) & ~(mask)) | (value)))
#define I2C_SET_RA(base, value)  (BME_OR8(&I2C_RA_REG(base), (uint8_t)(value)))
#define I2C_CLR_RA(base, value)  (BME_AND8(&I2C_RA_REG(base), (uint8_t)(~(value))))
#define I2C_TOG_RA(base, value)  (BME_XOR8(&I2C_RA_REG(base), (uint8_t)(value)))
/*@}*/

/*
 * Constants & macros for individual I2C_RA bitfields
 */

/*!
 * @name Register I2C_RA, field RAD[7:1] (RW)
 *
 * This field contains the slave address to be used by the I2C module. The field
 * is used in the 7-bit address scheme. If I2C_C2[RMEN] is set to 1, any nonzero
 * value write enables this register. This register value can be considered as a
 * maximum boundary in the range matching mode.
 */
/*@{*/
/*! @brief Read current value of the I2C_RA_RAD field. */
#define I2C_RD_RA_RAD(base)  ((I2C_RA_REG(base) & I2C_RA_RAD_MASK) >> I2C_RA_RAD_SHIFT)
#define I2C_BRD_RA_RAD(base) (BME_UBFX8(&I2C_RA_REG(base), I2C_RA_RAD_SHIFT, I2C_RA_RAD_WIDTH))

/*! @brief Set the RAD field to a new value. */
#define I2C_WR_RA_RAD(base, value) (I2C_RMW_RA(base, I2C_RA_RAD_MASK, I2C_RA_RAD(value)))
#define I2C_BWR_RA_RAD(base, value) (BME_BFI8(&I2C_RA_REG(base), ((uint8_t)(value) << I2C_RA_RAD_SHIFT), I2C_RA_RAD_SHIFT, I2C_RA_RAD_WIDTH))
/*@}*/

/*******************************************************************************
 * I2C_SMB - I2C SMBus Control and Status register
 ******************************************************************************/

/*!
 * @brief I2C_SMB - I2C SMBus Control and Status register (RW)
 *
 * Reset value: 0x00U
 *
 * When the SCL and SDA signals are held high for a length of time greater than
 * the high timeout period, the SHTF1 flag sets. Before reaching this threshold,
 * while the system is detecting how long these signals are being held high, a
 * master assumes that the bus is free. However, the SHTF1 bit is set to 1 in the
 * bus transmission process with the idle bus state. When the TCKSEL bit is set,
 * there is no need to monitor the SHTF1 bit because the bus speed is too high to
 * match the protocol of SMBus.
 */
/*!
 * @name Constants and macros for entire I2C_SMB register
 */
/*@{*/
#define I2C_RD_SMB(base)         (I2C_SMB_REG(base))
#define I2C_WR_SMB(base, value)  (I2C_SMB_REG(base) = (value))
#define I2C_RMW_SMB(base, mask, value) (I2C_WR_SMB(base, (I2C_RD_SMB(base) & ~(mask)) | (value)))
#define I2C_SET_SMB(base, value) (BME_OR8(&I2C_SMB_REG(base), (uint8_t)(value)))
#define I2C_CLR_SMB(base, value) (BME_AND8(&I2C_SMB_REG(base), (uint8_t)(~(value))))
#define I2C_TOG_SMB(base, value) (BME_XOR8(&I2C_SMB_REG(base), (uint8_t)(value)))
/*@}*/

/*
 * Constants & macros for individual I2C_SMB bitfields
 */

/*!
 * @name Register I2C_SMB, field SHTF2IE[0] (RW)
 *
 * Enables SCL high and SDA low timeout interrupt.
 *
 * Values:
 * - 0 - SHTF2 interrupt is disabled
 * - 1 - SHTF2 interrupt is enabled
 */
/*@{*/
/*! @brief Read current value of the I2C_SMB_SHTF2IE field. */
#define I2C_RD_SMB_SHTF2IE(base) ((I2C_SMB_REG(base) & I2C_SMB_SHTF2IE_MASK) >> I2C_SMB_SHTF2IE_SHIFT)
#define I2C_BRD_SMB_SHTF2IE(base) (BME_UBFX8(&I2C_SMB_REG(base), I2C_SMB_SHTF2IE_SHIFT, I2C_SMB_SHTF2IE_WIDTH))

/*! @brief Set the SHTF2IE field to a new value. */
#define I2C_WR_SMB_SHTF2IE(base, value) (I2C_RMW_SMB(base, (I2C_SMB_SHTF2IE_MASK | I2C_SMB_SHTF2_MASK | I2C_SMB_SLTF_MASK), I2C_SMB_SHTF2IE(value)))
#define I2C_BWR_SMB_SHTF2IE(base, value) (BME_BFI8(&I2C_SMB_REG(base), ((uint8_t)(value) << I2C_SMB_SHTF2IE_SHIFT), I2C_SMB_SHTF2IE_SHIFT, I2C_SMB_SHTF2IE_WIDTH))
/*@}*/

/*!
 * @name Register I2C_SMB, field SHTF2[1] (W1C)
 *
 * This bit sets when SCL is held high and SDA is held low more than clock *
 * LoValue / 512. Software clears this bit by writing 1 to it.
 *
 * Values:
 * - 0 - No SCL high and SDA low timeout occurs
 * - 1 - SCL high and SDA low timeout occurs
 */
/*@{*/
/*! @brief Read current value of the I2C_SMB_SHTF2 field. */
#define I2C_RD_SMB_SHTF2(base) ((I2C_SMB_REG(base) & I2C_SMB_SHTF2_MASK) >> I2C_SMB_SHTF2_SHIFT)
#define I2C_BRD_SMB_SHTF2(base) (BME_UBFX8(&I2C_SMB_REG(base), I2C_SMB_SHTF2_SHIFT, I2C_SMB_SHTF2_WIDTH))

/*! @brief Set the SHTF2 field to a new value. */
#define I2C_WR_SMB_SHTF2(base, value) (I2C_RMW_SMB(base, (I2C_SMB_SHTF2_MASK | I2C_SMB_SLTF_MASK), I2C_SMB_SHTF2(value)))
#define I2C_BWR_SMB_SHTF2(base, value) (BME_BFI8(&I2C_SMB_REG(base), ((uint8_t)(value) << I2C_SMB_SHTF2_SHIFT), I2C_SMB_SHTF2_SHIFT, I2C_SMB_SHTF2_WIDTH))
/*@}*/

/*!
 * @name Register I2C_SMB, field SHTF1[2] (RO)
 *
 * This read-only bit sets when SCL and SDA are held high more than clock *
 * LoValue / 512, which indicates the bus is free. This bit is cleared automatically.
 *
 * Values:
 * - 0 - No SCL high and SDA high timeout occurs
 * - 1 - SCL high and SDA high timeout occurs
 */
/*@{*/
/*! @brief Read current value of the I2C_SMB_SHTF1 field. */
#define I2C_RD_SMB_SHTF1(base) ((I2C_SMB_REG(base) & I2C_SMB_SHTF1_MASK) >> I2C_SMB_SHTF1_SHIFT)
#define I2C_BRD_SMB_SHTF1(base) (BME_UBFX8(&I2C_SMB_REG(base), I2C_SMB_SHTF1_SHIFT, I2C_SMB_SHTF1_WIDTH))
/*@}*/

/*!
 * @name Register I2C_SMB, field SLTF[3] (W1C)
 *
 * This bit is set when the SLT register (consisting of the SLTH and SLTL
 * registers) is loaded with a non-zero value (LoValue) and an SCL low timeout occurs.
 * Software clears this bit by writing a logic 1 to it. The low timeout function
 * is disabled when the SLT register's value is 0.
 *
 * Values:
 * - 0 - No low timeout occurs
 * - 1 - Low timeout occurs
 */
/*@{*/
/*! @brief Read current value of the I2C_SMB_SLTF field. */
#define I2C_RD_SMB_SLTF(base) ((I2C_SMB_REG(base) & I2C_SMB_SLTF_MASK) >> I2C_SMB_SLTF_SHIFT)
#define I2C_BRD_SMB_SLTF(base) (BME_UBFX8(&I2C_SMB_REG(base), I2C_SMB_SLTF_SHIFT, I2C_SMB_SLTF_WIDTH))

/*! @brief Set the SLTF field to a new value. */
#define I2C_WR_SMB_SLTF(base, value) (I2C_RMW_SMB(base, (I2C_SMB_SLTF_MASK | I2C_SMB_SHTF2_MASK), I2C_SMB_SLTF(value)))
#define I2C_BWR_SMB_SLTF(base, value) (BME_BFI8(&I2C_SMB_REG(base), ((uint8_t)(value) << I2C_SMB_SLTF_SHIFT), I2C_SMB_SLTF_SHIFT, I2C_SMB_SLTF_WIDTH))
/*@}*/

/*!
 * @name Register I2C_SMB, field TCKSEL[4] (RW)
 *
 * Selects the clock source of the timeout counter.
 *
 * Values:
 * - 0 - Timeout counter counts at the frequency of the I2C module clock / 64
 * - 1 - Timeout counter counts at the frequency of the I2C module clock
 */
/*@{*/
/*! @brief Read current value of the I2C_SMB_TCKSEL field. */
#define I2C_RD_SMB_TCKSEL(base) ((I2C_SMB_REG(base) & I2C_SMB_TCKSEL_MASK) >> I2C_SMB_TCKSEL_SHIFT)
#define I2C_BRD_SMB_TCKSEL(base) (BME_UBFX8(&I2C_SMB_REG(base), I2C_SMB_TCKSEL_SHIFT, I2C_SMB_TCKSEL_WIDTH))

/*! @brief Set the TCKSEL field to a new value. */
#define I2C_WR_SMB_TCKSEL(base, value) (I2C_RMW_SMB(base, (I2C_SMB_TCKSEL_MASK | I2C_SMB_SHTF2_MASK | I2C_SMB_SLTF_MASK), I2C_SMB_TCKSEL(value)))
#define I2C_BWR_SMB_TCKSEL(base, value) (BME_BFI8(&I2C_SMB_REG(base), ((uint8_t)(value) << I2C_SMB_TCKSEL_SHIFT), I2C_SMB_TCKSEL_SHIFT, I2C_SMB_TCKSEL_WIDTH))
/*@}*/

/*!
 * @name Register I2C_SMB, field SIICAEN[5] (RW)
 *
 * Enables or disables SMBus device default address.
 *
 * Values:
 * - 0 - I2C address register 2 matching is disabled
 * - 1 - I2C address register 2 matching is enabled
 */
/*@{*/
/*! @brief Read current value of the I2C_SMB_SIICAEN field. */
#define I2C_RD_SMB_SIICAEN(base) ((I2C_SMB_REG(base) & I2C_SMB_SIICAEN_MASK) >> I2C_SMB_SIICAEN_SHIFT)
#define I2C_BRD_SMB_SIICAEN(base) (BME_UBFX8(&I2C_SMB_REG(base), I2C_SMB_SIICAEN_SHIFT, I2C_SMB_SIICAEN_WIDTH))

/*! @brief Set the SIICAEN field to a new value. */
#define I2C_WR_SMB_SIICAEN(base, value) (I2C_RMW_SMB(base, (I2C_SMB_SIICAEN_MASK | I2C_SMB_SHTF2_MASK | I2C_SMB_SLTF_MASK), I2C_SMB_SIICAEN(value)))
#define I2C_BWR_SMB_SIICAEN(base, value) (BME_BFI8(&I2C_SMB_REG(base), ((uint8_t)(value) << I2C_SMB_SIICAEN_SHIFT), I2C_SMB_SIICAEN_SHIFT, I2C_SMB_SIICAEN_WIDTH))
/*@}*/

/*!
 * @name Register I2C_SMB, field ALERTEN[6] (RW)
 *
 * Enables or disables SMBus alert response address matching. After the host
 * responds to a device that used the alert response address, you must use software
 * to put the device's address on the bus. The alert protocol is described in the
 * SMBus specification.
 *
 * Values:
 * - 0 - SMBus alert response address matching is disabled
 * - 1 - SMBus alert response address matching is enabled
 */
/*@{*/
/*! @brief Read current value of the I2C_SMB_ALERTEN field. */
#define I2C_RD_SMB_ALERTEN(base) ((I2C_SMB_REG(base) & I2C_SMB_ALERTEN_MASK) >> I2C_SMB_ALERTEN_SHIFT)
#define I2C_BRD_SMB_ALERTEN(base) (BME_UBFX8(&I2C_SMB_REG(base), I2C_SMB_ALERTEN_SHIFT, I2C_SMB_ALERTEN_WIDTH))

/*! @brief Set the ALERTEN field to a new value. */
#define I2C_WR_SMB_ALERTEN(base, value) (I2C_RMW_SMB(base, (I2C_SMB_ALERTEN_MASK | I2C_SMB_SHTF2_MASK | I2C_SMB_SLTF_MASK), I2C_SMB_ALERTEN(value)))
#define I2C_BWR_SMB_ALERTEN(base, value) (BME_BFI8(&I2C_SMB_REG(base), ((uint8_t)(value) << I2C_SMB_ALERTEN_SHIFT), I2C_SMB_ALERTEN_SHIFT, I2C_SMB_ALERTEN_WIDTH))
/*@}*/

/*!
 * @name Register I2C_SMB, field FACK[7] (RW)
 *
 * For SMBus packet error checking, the CPU must be able to issue an ACK or NACK
 * according to the result of receiving data byte.
 *
 * Values:
 * - 0 - An ACK or NACK is sent on the following receiving data byte
 * - 1 - Writing 0 to TXAK after receiving a data byte generates an ACK. Writing
 *     1 to TXAK after receiving a data byte generates a NACK.
 */
/*@{*/
/*! @brief Read current value of the I2C_SMB_FACK field. */
#define I2C_RD_SMB_FACK(base) ((I2C_SMB_REG(base) & I2C_SMB_FACK_MASK) >> I2C_SMB_FACK_SHIFT)
#define I2C_BRD_SMB_FACK(base) (BME_UBFX8(&I2C_SMB_REG(base), I2C_SMB_FACK_SHIFT, I2C_SMB_FACK_WIDTH))

/*! @brief Set the FACK field to a new value. */
#define I2C_WR_SMB_FACK(base, value) (I2C_RMW_SMB(base, (I2C_SMB_FACK_MASK | I2C_SMB_SHTF2_MASK | I2C_SMB_SLTF_MASK), I2C_SMB_FACK(value)))
#define I2C_BWR_SMB_FACK(base, value) (BME_BFI8(&I2C_SMB_REG(base), ((uint8_t)(value) << I2C_SMB_FACK_SHIFT), I2C_SMB_FACK_SHIFT, I2C_SMB_FACK_WIDTH))
/*@}*/

/*******************************************************************************
 * I2C_A2 - I2C Address Register 2
 ******************************************************************************/

/*!
 * @brief I2C_A2 - I2C Address Register 2 (RW)
 *
 * Reset value: 0xC2U
 */
/*!
 * @name Constants and macros for entire I2C_A2 register
 */
/*@{*/
#define I2C_RD_A2(base)          (I2C_A2_REG(base))
#define I2C_WR_A2(base, value)   (I2C_A2_REG(base) = (value))
#define I2C_RMW_A2(base, mask, value) (I2C_WR_A2(base, (I2C_RD_A2(base) & ~(mask)) | (value)))
#define I2C_SET_A2(base, value)  (BME_OR8(&I2C_A2_REG(base), (uint8_t)(value)))
#define I2C_CLR_A2(base, value)  (BME_AND8(&I2C_A2_REG(base), (uint8_t)(~(value))))
#define I2C_TOG_A2(base, value)  (BME_XOR8(&I2C_A2_REG(base), (uint8_t)(value)))
/*@}*/

/*
 * Constants & macros for individual I2C_A2 bitfields
 */

/*!
 * @name Register I2C_A2, field SAD[7:1] (RW)
 *
 * Contains the slave address used by the SMBus. This field is used on the
 * device default address or other related addresses.
 */
/*@{*/
/*! @brief Read current value of the I2C_A2_SAD field. */
#define I2C_RD_A2_SAD(base)  ((I2C_A2_REG(base) & I2C_A2_SAD_MASK) >> I2C_A2_SAD_SHIFT)
#define I2C_BRD_A2_SAD(base) (BME_UBFX8(&I2C_A2_REG(base), I2C_A2_SAD_SHIFT, I2C_A2_SAD_WIDTH))

/*! @brief Set the SAD field to a new value. */
#define I2C_WR_A2_SAD(base, value) (I2C_RMW_A2(base, I2C_A2_SAD_MASK, I2C_A2_SAD(value)))
#define I2C_BWR_A2_SAD(base, value) (BME_BFI8(&I2C_A2_REG(base), ((uint8_t)(value) << I2C_A2_SAD_SHIFT), I2C_A2_SAD_SHIFT, I2C_A2_SAD_WIDTH))
/*@}*/

/*******************************************************************************
 * I2C_SLTH - I2C SCL Low Timeout Register High
 ******************************************************************************/

/*!
 * @brief I2C_SLTH - I2C SCL Low Timeout Register High (RW)
 *
 * Reset value: 0x00U
 */
/*!
 * @name Constants and macros for entire I2C_SLTH register
 */
/*@{*/
#define I2C_RD_SLTH(base)        (I2C_SLTH_REG(base))
#define I2C_WR_SLTH(base, value) (I2C_SLTH_REG(base) = (value))
#define I2C_RMW_SLTH(base, mask, value) (I2C_WR_SLTH(base, (I2C_RD_SLTH(base) & ~(mask)) | (value)))
#define I2C_SET_SLTH(base, value) (BME_OR8(&I2C_SLTH_REG(base), (uint8_t)(value)))
#define I2C_CLR_SLTH(base, value) (BME_AND8(&I2C_SLTH_REG(base), (uint8_t)(~(value))))
#define I2C_TOG_SLTH(base, value) (BME_XOR8(&I2C_SLTH_REG(base), (uint8_t)(value)))
/*@}*/

/*******************************************************************************
 * I2C_SLTL - I2C SCL Low Timeout Register Low
 ******************************************************************************/

/*!
 * @brief I2C_SLTL - I2C SCL Low Timeout Register Low (RW)
 *
 * Reset value: 0x00U
 */
/*!
 * @name Constants and macros for entire I2C_SLTL register
 */
/*@{*/
#define I2C_RD_SLTL(base)        (I2C_SLTL_REG(base))
#define I2C_WR_SLTL(base, value) (I2C_SLTL_REG(base) = (value))
#define I2C_RMW_SLTL(base, mask, value) (I2C_WR_SLTL(base, (I2C_RD_SLTL(base) & ~(mask)) | (value)))
#define I2C_SET_SLTL(base, value) (BME_OR8(&I2C_SLTL_REG(base), (uint8_t)(value)))
#define I2C_CLR_SLTL(base, value) (BME_AND8(&I2C_SLTL_REG(base), (uint8_t)(~(value))))
#define I2C_TOG_SLTL(base, value) (BME_XOR8(&I2C_SLTL_REG(base), (uint8_t)(value)))
/*@}*/

/*******************************************************************************
 * I2C_S2 - I2C Status register 2
 ******************************************************************************/

/*!
 * @brief I2C_S2 - I2C Status register 2 (RW)
 *
 * Reset value: 0x01U
 */
/*!
 * @name Constants and macros for entire I2C_S2 register
 */
/*@{*/
#define I2C_RD_S2(base)          (I2C_S2_REG(base))
#define I2C_WR_S2(base, value)   (I2C_S2_REG(base) = (value))
#define I2C_RMW_S2(base, mask, value) (I2C_WR_S2(base, (I2C_RD_S2(base) & ~(mask)) | (value)))
#define I2C_SET_S2(base, value)  (BME_OR8(&I2C_S2_REG(base), (uint8_t)(value)))
#define I2C_CLR_S2(base, value)  (BME_AND8(&I2C_S2_REG(base), (uint8_t)(~(value))))
#define I2C_TOG_S2(base, value)  (BME_XOR8(&I2C_S2_REG(base), (uint8_t)(value)))
/*@}*/

/*
 * Constants & macros for individual I2C_S2 bitfields
 */

/*!
 * @name Register I2C_S2, field EMPTY[0] (RO)
 *
 * Indicates if the Tx or Rx buffer is empty.
 *
 * Values:
 * - 0 - Tx or Rx buffer is not empty and cannot be written to, that is new data
 *     cannot be loaded into the buffer.
 * - 1 - Tx or Rx buffer is empty and can be written to, that is new data can be
 *     loaded into the buffer.
 */
/*@{*/
/*! @brief Read current value of the I2C_S2_EMPTY field. */
#define I2C_RD_S2_EMPTY(base) ((I2C_S2_REG(base) & I2C_S2_EMPTY_MASK) >> I2C_S2_EMPTY_SHIFT)
#define I2C_BRD_S2_EMPTY(base) (BME_UBFX8(&I2C_S2_REG(base), I2C_S2_EMPTY_SHIFT, I2C_S2_EMPTY_WIDTH))
/*@}*/

/*!
 * @name Register I2C_S2, field ERROR[1] (W1C)
 *
 * Indicates if there are read or write errors with the Tx and Rx buffers.
 *
 * Values:
 * - 0 - The buffer is not full and all write/read operations have no errors.
 * - 1 - There are 3 or more write/read errors during the data transfer phase
 *     (when the Empty flag is not set and the buffer is busy).
 */
/*@{*/
/*! @brief Read current value of the I2C_S2_ERROR field. */
#define I2C_RD_S2_ERROR(base) ((I2C_S2_REG(base) & I2C_S2_ERROR_MASK) >> I2C_S2_ERROR_SHIFT)
#define I2C_BRD_S2_ERROR(base) (BME_UBFX8(&I2C_S2_REG(base), I2C_S2_ERROR_SHIFT, I2C_S2_ERROR_WIDTH))

/*! @brief Set the ERROR field to a new value. */
#define I2C_WR_S2_ERROR(base, value) (I2C_RMW_S2(base, I2C_S2_ERROR_MASK, I2C_S2_ERROR(value)))
#define I2C_BWR_S2_ERROR(base, value) (BME_BFI8(&I2C_S2_REG(base), ((uint8_t)(value) << I2C_S2_ERROR_SHIFT), I2C_S2_ERROR_SHIFT, I2C_S2_ERROR_WIDTH))
/*@}*/

/*
 * MKL27Z644 LLWU
 *
 * Low leakage wakeup unit
 *
 * Registers defined in this header file:
 * - LLWU_PE1 - LLWU Pin Enable 1 register
 * - LLWU_PE2 - LLWU Pin Enable 2 register
 * - LLWU_PE3 - LLWU Pin Enable 3 register
 * - LLWU_PE4 - LLWU Pin Enable 4 register
 * - LLWU_ME - LLWU Module Enable register
 * - LLWU_F1 - LLWU Flag 1 register
 * - LLWU_F2 - LLWU Flag 2 register
 * - LLWU_F3 - LLWU Flag 3 register
 * - LLWU_FILT1 - LLWU Pin Filter 1 register
 * - LLWU_FILT2 - LLWU Pin Filter 2 register
 */

#define LLWU_INSTANCE_COUNT (1U) /*!< Number of instances of the LLWU module. */
#define LLWU_IDX (0U) /*!< Instance number for LLWU. */

/*******************************************************************************
 * LLWU_PE1 - LLWU Pin Enable 1 register
 ******************************************************************************/

/*!
 * @brief LLWU_PE1 - LLWU Pin Enable 1 register (RW)
 *
 * Reset value: 0x00U
 *
 * LLWU_PE1 contains the field to enable and select the edge detect type for the
 * external wakeup input pins LLWU_P3-LLWU_P0. This register is reset on Chip
 * Reset not VLLS and by reset types that trigger Chip Reset not VLLS. It is
 * unaffected by reset types that do not trigger Chip Reset not VLLS. See the
 * IntroductionInformation found here describes the registers of the Reset Control Module
 * (RCM). The RCM implements many of the reset functions for the chip. See the
 * chip's reset chapter for more information. details for more information.
 */
/*!
 * @name Constants and macros for entire LLWU_PE1 register
 */
/*@{*/
#define LLWU_RD_PE1(base)        (LLWU_PE1_REG(base))
#define LLWU_WR_PE1(base, value) (LLWU_PE1_REG(base) = (value))
#define LLWU_RMW_PE1(base, mask, value) (LLWU_WR_PE1(base, (LLWU_RD_PE1(base) & ~(mask)) | (value)))
#define LLWU_SET_PE1(base, value) (BME_OR8(&LLWU_PE1_REG(base), (uint8_t)(value)))
#define LLWU_CLR_PE1(base, value) (BME_AND8(&LLWU_PE1_REG(base), (uint8_t)(~(value))))
#define LLWU_TOG_PE1(base, value) (BME_XOR8(&LLWU_PE1_REG(base), (uint8_t)(value)))
/*@}*/

/*
 * Constants & macros for individual LLWU_PE1 bitfields
 */

/*!
 * @name Register LLWU_PE1, field WUPE0[1:0] (RW)
 *
 * Enables and configures the edge detection for the wakeup pin.
 *
 * Values:
 * - 00 - External input pin disabled as wakeup input
 * - 01 - External input pin enabled with rising edge detection
 * - 10 - External input pin enabled with falling edge detection
 * - 11 - External input pin enabled with any change detection
 */
/*@{*/
/*! @brief Read current value of the LLWU_PE1_WUPE0 field. */
#define LLWU_RD_PE1_WUPE0(base) ((LLWU_PE1_REG(base) & LLWU_PE1_WUPE0_MASK) >> LLWU_PE1_WUPE0_SHIFT)
#define LLWU_BRD_PE1_WUPE0(base) (BME_UBFX8(&LLWU_PE1_REG(base), LLWU_PE1_WUPE0_SHIFT, LLWU_PE1_WUPE0_WIDTH))

/*! @brief Set the WUPE0 field to a new value. */
#define LLWU_WR_PE1_WUPE0(base, value) (LLWU_RMW_PE1(base, LLWU_PE1_WUPE0_MASK, LLWU_PE1_WUPE0(value)))
#define LLWU_BWR_PE1_WUPE0(base, value) (BME_BFI8(&LLWU_PE1_REG(base), ((uint8_t)(value) << LLWU_PE1_WUPE0_SHIFT), LLWU_PE1_WUPE0_SHIFT, LLWU_PE1_WUPE0_WIDTH))
/*@}*/

/*!
 * @name Register LLWU_PE1, field WUPE1[3:2] (RW)
 *
 * Enables and configures the edge detection for the wakeup pin.
 *
 * Values:
 * - 00 - External input pin disabled as wakeup input
 * - 01 - External input pin enabled with rising edge detection
 * - 10 - External input pin enabled with falling edge detection
 * - 11 - External input pin enabled with any change detection
 */
/*@{*/
/*! @brief Read current value of the LLWU_PE1_WUPE1 field. */
#define LLWU_RD_PE1_WUPE1(base) ((LLWU_PE1_REG(base) & LLWU_PE1_WUPE1_MASK) >> LLWU_PE1_WUPE1_SHIFT)
#define LLWU_BRD_PE1_WUPE1(base) (BME_UBFX8(&LLWU_PE1_REG(base), LLWU_PE1_WUPE1_SHIFT, LLWU_PE1_WUPE1_WIDTH))

/*! @brief Set the WUPE1 field to a new value. */
#define LLWU_WR_PE1_WUPE1(base, value) (LLWU_RMW_PE1(base, LLWU_PE1_WUPE1_MASK, LLWU_PE1_WUPE1(value)))
#define LLWU_BWR_PE1_WUPE1(base, value) (BME_BFI8(&LLWU_PE1_REG(base), ((uint8_t)(value) << LLWU_PE1_WUPE1_SHIFT), LLWU_PE1_WUPE1_SHIFT, LLWU_PE1_WUPE1_WIDTH))
/*@}*/

/*!
 * @name Register LLWU_PE1, field WUPE2[5:4] (RW)
 *
 * Enables and configures the edge detection for the wakeup pin.
 *
 * Values:
 * - 00 - External input pin disabled as wakeup input
 * - 01 - External input pin enabled with rising edge detection
 * - 10 - External input pin enabled with falling edge detection
 * - 11 - External input pin enabled with any change detection
 */
/*@{*/
/*! @brief Read current value of the LLWU_PE1_WUPE2 field. */
#define LLWU_RD_PE1_WUPE2(base) ((LLWU_PE1_REG(base) & LLWU_PE1_WUPE2_MASK) >> LLWU_PE1_WUPE2_SHIFT)
#define LLWU_BRD_PE1_WUPE2(base) (BME_UBFX8(&LLWU_PE1_REG(base), LLWU_PE1_WUPE2_SHIFT, LLWU_PE1_WUPE2_WIDTH))

/*! @brief Set the WUPE2 field to a new value. */
#define LLWU_WR_PE1_WUPE2(base, value) (LLWU_RMW_PE1(base, LLWU_PE1_WUPE2_MASK, LLWU_PE1_WUPE2(value)))
#define LLWU_BWR_PE1_WUPE2(base, value) (BME_BFI8(&LLWU_PE1_REG(base), ((uint8_t)(value) << LLWU_PE1_WUPE2_SHIFT), LLWU_PE1_WUPE2_SHIFT, LLWU_PE1_WUPE2_WIDTH))
/*@}*/

/*!
 * @name Register LLWU_PE1, field WUPE3[7:6] (RW)
 *
 * Enables and configures the edge detection for the wakeup pin.
 *
 * Values:
 * - 00 - External input pin disabled as wakeup input
 * - 01 - External input pin enabled with rising edge detection
 * - 10 - External input pin enabled with falling edge detection
 * - 11 - External input pin enabled with any change detection
 */
/*@{*/
/*! @brief Read current value of the LLWU_PE1_WUPE3 field. */
#define LLWU_RD_PE1_WUPE3(base) ((LLWU_PE1_REG(base) & LLWU_PE1_WUPE3_MASK) >> LLWU_PE1_WUPE3_SHIFT)
#define LLWU_BRD_PE1_WUPE3(base) (BME_UBFX8(&LLWU_PE1_REG(base), LLWU_PE1_WUPE3_SHIFT, LLWU_PE1_WUPE3_WIDTH))

/*! @brief Set the WUPE3 field to a new value. */
#define LLWU_WR_PE1_WUPE3(base, value) (LLWU_RMW_PE1(base, LLWU_PE1_WUPE3_MASK, LLWU_PE1_WUPE3(value)))
#define LLWU_BWR_PE1_WUPE3(base, value) (BME_BFI8(&LLWU_PE1_REG(base), ((uint8_t)(value) << LLWU_PE1_WUPE3_SHIFT), LLWU_PE1_WUPE3_SHIFT, LLWU_PE1_WUPE3_WIDTH))
/*@}*/

/*******************************************************************************
 * LLWU_PE2 - LLWU Pin Enable 2 register
 ******************************************************************************/

/*!
 * @brief LLWU_PE2 - LLWU Pin Enable 2 register (RW)
 *
 * Reset value: 0x00U
 *
 * LLWU_PE2 contains the field to enable and select the edge detect type for the
 * external wakeup input pins LLWU_P7-LLWU_P4. This register is reset on Chip
 * Reset not VLLS and by reset types that trigger Chip Reset not VLLS. It is
 * unaffected by reset types that do not trigger Chip Reset not VLLS. See the
 * IntroductionInformation found here describes the registers of the Reset Control Module
 * (RCM). The RCM implements many of the reset functions for the chip. See the
 * chip's reset chapter for more information. details for more information.
 */
/*!
 * @name Constants and macros for entire LLWU_PE2 register
 */
/*@{*/
#define LLWU_RD_PE2(base)        (LLWU_PE2_REG(base))
#define LLWU_WR_PE2(base, value) (LLWU_PE2_REG(base) = (value))
#define LLWU_RMW_PE2(base, mask, value) (LLWU_WR_PE2(base, (LLWU_RD_PE2(base) & ~(mask)) | (value)))
#define LLWU_SET_PE2(base, value) (BME_OR8(&LLWU_PE2_REG(base), (uint8_t)(value)))
#define LLWU_CLR_PE2(base, value) (BME_AND8(&LLWU_PE2_REG(base), (uint8_t)(~(value))))
#define LLWU_TOG_PE2(base, value) (BME_XOR8(&LLWU_PE2_REG(base), (uint8_t)(value)))
/*@}*/

/*
 * Constants & macros for individual LLWU_PE2 bitfields
 */

/*!
 * @name Register LLWU_PE2, field WUPE4[1:0] (RW)
 *
 * Enables and configures the edge detection for the wakeup pin.
 *
 * Values:
 * - 00 - External input pin disabled as wakeup input
 * - 01 - External input pin enabled with rising edge detection
 * - 10 - External input pin enabled with falling edge detection
 * - 11 - External input pin enabled with any change detection
 */
/*@{*/
/*! @brief Read current value of the LLWU_PE2_WUPE4 field. */
#define LLWU_RD_PE2_WUPE4(base) ((LLWU_PE2_REG(base) & LLWU_PE2_WUPE4_MASK) >> LLWU_PE2_WUPE4_SHIFT)
#define LLWU_BRD_PE2_WUPE4(base) (BME_UBFX8(&LLWU_PE2_REG(base), LLWU_PE2_WUPE4_SHIFT, LLWU_PE2_WUPE4_WIDTH))

/*! @brief Set the WUPE4 field to a new value. */
#define LLWU_WR_PE2_WUPE4(base, value) (LLWU_RMW_PE2(base, LLWU_PE2_WUPE4_MASK, LLWU_PE2_WUPE4(value)))
#define LLWU_BWR_PE2_WUPE4(base, value) (BME_BFI8(&LLWU_PE2_REG(base), ((uint8_t)(value) << LLWU_PE2_WUPE4_SHIFT), LLWU_PE2_WUPE4_SHIFT, LLWU_PE2_WUPE4_WIDTH))
/*@}*/

/*!
 * @name Register LLWU_PE2, field WUPE5[3:2] (RW)
 *
 * Enables and configures the edge detection for the wakeup pin.
 *
 * Values:
 * - 00 - External input pin disabled as wakeup input
 * - 01 - External input pin enabled with rising edge detection
 * - 10 - External input pin enabled with falling edge detection
 * - 11 - External input pin enabled with any change detection
 */
/*@{*/
/*! @brief Read current value of the LLWU_PE2_WUPE5 field. */
#define LLWU_RD_PE2_WUPE5(base) ((LLWU_PE2_REG(base) & LLWU_PE2_WUPE5_MASK) >> LLWU_PE2_WUPE5_SHIFT)
#define LLWU_BRD_PE2_WUPE5(base) (BME_UBFX8(&LLWU_PE2_REG(base), LLWU_PE2_WUPE5_SHIFT, LLWU_PE2_WUPE5_WIDTH))

/*! @brief Set the WUPE5 field to a new value. */
#define LLWU_WR_PE2_WUPE5(base, value) (LLWU_RMW_PE2(base, LLWU_PE2_WUPE5_MASK, LLWU_PE2_WUPE5(value)))
#define LLWU_BWR_PE2_WUPE5(base, value) (BME_BFI8(&LLWU_PE2_REG(base), ((uint8_t)(value) << LLWU_PE2_WUPE5_SHIFT), LLWU_PE2_WUPE5_SHIFT, LLWU_PE2_WUPE5_WIDTH))
/*@}*/

/*!
 * @name Register LLWU_PE2, field WUPE6[5:4] (RW)
 *
 * Enables and configures the edge detection for the wakeup pin.
 *
 * Values:
 * - 00 - External input pin disabled as wakeup input
 * - 01 - External input pin enabled with rising edge detection
 * - 10 - External input pin enabled with falling edge detection
 * - 11 - External input pin enabled with any change detection
 */
/*@{*/
/*! @brief Read current value of the LLWU_PE2_WUPE6 field. */
#define LLWU_RD_PE2_WUPE6(base) ((LLWU_PE2_REG(base) & LLWU_PE2_WUPE6_MASK) >> LLWU_PE2_WUPE6_SHIFT)
#define LLWU_BRD_PE2_WUPE6(base) (BME_UBFX8(&LLWU_PE2_REG(base), LLWU_PE2_WUPE6_SHIFT, LLWU_PE2_WUPE6_WIDTH))

/*! @brief Set the WUPE6 field to a new value. */
#define LLWU_WR_PE2_WUPE6(base, value) (LLWU_RMW_PE2(base, LLWU_PE2_WUPE6_MASK, LLWU_PE2_WUPE6(value)))
#define LLWU_BWR_PE2_WUPE6(base, value) (BME_BFI8(&LLWU_PE2_REG(base), ((uint8_t)(value) << LLWU_PE2_WUPE6_SHIFT), LLWU_PE2_WUPE6_SHIFT, LLWU_PE2_WUPE6_WIDTH))
/*@}*/

/*!
 * @name Register LLWU_PE2, field WUPE7[7:6] (RW)
 *
 * Enables and configures the edge detection for the wakeup pin.
 *
 * Values:
 * - 00 - External input pin disabled as wakeup input
 * - 01 - External input pin enabled with rising edge detection
 * - 10 - External input pin enabled with falling edge detection
 * - 11 - External input pin enabled with any change detection
 */
/*@{*/
/*! @brief Read current value of the LLWU_PE2_WUPE7 field. */
#define LLWU_RD_PE2_WUPE7(base) ((LLWU_PE2_REG(base) & LLWU_PE2_WUPE7_MASK) >> LLWU_PE2_WUPE7_SHIFT)
#define LLWU_BRD_PE2_WUPE7(base) (BME_UBFX8(&LLWU_PE2_REG(base), LLWU_PE2_WUPE7_SHIFT, LLWU_PE2_WUPE7_WIDTH))

/*! @brief Set the WUPE7 field to a new value. */
#define LLWU_WR_PE2_WUPE7(base, value) (LLWU_RMW_PE2(base, LLWU_PE2_WUPE7_MASK, LLWU_PE2_WUPE7(value)))
#define LLWU_BWR_PE2_WUPE7(base, value) (BME_BFI8(&LLWU_PE2_REG(base), ((uint8_t)(value) << LLWU_PE2_WUPE7_SHIFT), LLWU_PE2_WUPE7_SHIFT, LLWU_PE2_WUPE7_WIDTH))
/*@}*/

/*******************************************************************************
 * LLWU_PE3 - LLWU Pin Enable 3 register
 ******************************************************************************/

/*!
 * @brief LLWU_PE3 - LLWU Pin Enable 3 register (RW)
 *
 * Reset value: 0x00U
 *
 * LLWU_PE3 contains the field to enable and select the edge detect type for the
 * external wakeup input pins LLWU_P11-LLWU_P8. This register is reset on Chip
 * Reset not VLLS and by reset types that trigger Chip Reset not VLLS. It is
 * unaffected by reset types that do not trigger Chip Reset not VLLS. See the
 * IntroductionInformation found here describes the registers of the Reset Control Module
 * (RCM). The RCM implements many of the reset functions for the chip. See the
 * chip's reset chapter for more information. details for more information.
 */
/*!
 * @name Constants and macros for entire LLWU_PE3 register
 */
/*@{*/
#define LLWU_RD_PE3(base)        (LLWU_PE3_REG(base))
#define LLWU_WR_PE3(base, value) (LLWU_PE3_REG(base) = (value))
#define LLWU_RMW_PE3(base, mask, value) (LLWU_WR_PE3(base, (LLWU_RD_PE3(base) & ~(mask)) | (value)))
#define LLWU_SET_PE3(base, value) (BME_OR8(&LLWU_PE3_REG(base), (uint8_t)(value)))
#define LLWU_CLR_PE3(base, value) (BME_AND8(&LLWU_PE3_REG(base), (uint8_t)(~(value))))
#define LLWU_TOG_PE3(base, value) (BME_XOR8(&LLWU_PE3_REG(base), (uint8_t)(value)))
/*@}*/

/*
 * Constants & macros for individual LLWU_PE3 bitfields
 */

/*!
 * @name Register LLWU_PE3, field WUPE8[1:0] (RW)
 *
 * Enables and configures the edge detection for the wakeup pin.
 *
 * Values:
 * - 00 - External input pin disabled as wakeup input
 * - 01 - External input pin enabled with rising edge detection
 * - 10 - External input pin enabled with falling edge detection
 * - 11 - External input pin enabled with any change detection
 */
/*@{*/
/*! @brief Read current value of the LLWU_PE3_WUPE8 field. */
#define LLWU_RD_PE3_WUPE8(base) ((LLWU_PE3_REG(base) & LLWU_PE3_WUPE8_MASK) >> LLWU_PE3_WUPE8_SHIFT)
#define LLWU_BRD_PE3_WUPE8(base) (BME_UBFX8(&LLWU_PE3_REG(base), LLWU_PE3_WUPE8_SHIFT, LLWU_PE3_WUPE8_WIDTH))

/*! @brief Set the WUPE8 field to a new value. */
#define LLWU_WR_PE3_WUPE8(base, value) (LLWU_RMW_PE3(base, LLWU_PE3_WUPE8_MASK, LLWU_PE3_WUPE8(value)))
#define LLWU_BWR_PE3_WUPE8(base, value) (BME_BFI8(&LLWU_PE3_REG(base), ((uint8_t)(value) << LLWU_PE3_WUPE8_SHIFT), LLWU_PE3_WUPE8_SHIFT, LLWU_PE3_WUPE8_WIDTH))
/*@}*/

/*!
 * @name Register LLWU_PE3, field WUPE9[3:2] (RW)
 *
 * Enables and configures the edge detection for the wakeup pin.
 *
 * Values:
 * - 00 - External input pin disabled as wakeup input
 * - 01 - External input pin enabled with rising edge detection
 * - 10 - External input pin enabled with falling edge detection
 * - 11 - External input pin enabled with any change detection
 */
/*@{*/
/*! @brief Read current value of the LLWU_PE3_WUPE9 field. */
#define LLWU_RD_PE3_WUPE9(base) ((LLWU_PE3_REG(base) & LLWU_PE3_WUPE9_MASK) >> LLWU_PE3_WUPE9_SHIFT)
#define LLWU_BRD_PE3_WUPE9(base) (BME_UBFX8(&LLWU_PE3_REG(base), LLWU_PE3_WUPE9_SHIFT, LLWU_PE3_WUPE9_WIDTH))

/*! @brief Set the WUPE9 field to a new value. */
#define LLWU_WR_PE3_WUPE9(base, value) (LLWU_RMW_PE3(base, LLWU_PE3_WUPE9_MASK, LLWU_PE3_WUPE9(value)))
#define LLWU_BWR_PE3_WUPE9(base, value) (BME_BFI8(&LLWU_PE3_REG(base), ((uint8_t)(value) << LLWU_PE3_WUPE9_SHIFT), LLWU_PE3_WUPE9_SHIFT, LLWU_PE3_WUPE9_WIDTH))
/*@}*/

/*!
 * @name Register LLWU_PE3, field WUPE10[5:4] (RW)
 *
 * Enables and configures the edge detection for the wakeup pin.
 *
 * Values:
 * - 00 - External input pin disabled as wakeup input
 * - 01 - External input pin enabled with rising edge detection
 * - 10 - External input pin enabled with falling edge detection
 * - 11 - External input pin enabled with any change detection
 */
/*@{*/
/*! @brief Read current value of the LLWU_PE3_WUPE10 field. */
#define LLWU_RD_PE3_WUPE10(base) ((LLWU_PE3_REG(base) & LLWU_PE3_WUPE10_MASK) >> LLWU_PE3_WUPE10_SHIFT)
#define LLWU_BRD_PE3_WUPE10(base) (BME_UBFX8(&LLWU_PE3_REG(base), LLWU_PE3_WUPE10_SHIFT, LLWU_PE3_WUPE10_WIDTH))

/*! @brief Set the WUPE10 field to a new value. */
#define LLWU_WR_PE3_WUPE10(base, value) (LLWU_RMW_PE3(base, LLWU_PE3_WUPE10_MASK, LLWU_PE3_WUPE10(value)))
#define LLWU_BWR_PE3_WUPE10(base, value) (BME_BFI8(&LLWU_PE3_REG(base), ((uint8_t)(value) << LLWU_PE3_WUPE10_SHIFT), LLWU_PE3_WUPE10_SHIFT, LLWU_PE3_WUPE10_WIDTH))
/*@}*/

/*!
 * @name Register LLWU_PE3, field WUPE11[7:6] (RW)
 *
 * Enables and configures the edge detection for the wakeup pin.
 *
 * Values:
 * - 00 - External input pin disabled as wakeup input
 * - 01 - External input pin enabled with rising edge detection
 * - 10 - External input pin enabled with falling edge detection
 * - 11 - External input pin enabled with any change detection
 */
/*@{*/
/*! @brief Read current value of the LLWU_PE3_WUPE11 field. */
#define LLWU_RD_PE3_WUPE11(base) ((LLWU_PE3_REG(base) & LLWU_PE3_WUPE11_MASK) >> LLWU_PE3_WUPE11_SHIFT)
#define LLWU_BRD_PE3_WUPE11(base) (BME_UBFX8(&LLWU_PE3_REG(base), LLWU_PE3_WUPE11_SHIFT, LLWU_PE3_WUPE11_WIDTH))

/*! @brief Set the WUPE11 field to a new value. */
#define LLWU_WR_PE3_WUPE11(base, value) (LLWU_RMW_PE3(base, LLWU_PE3_WUPE11_MASK, LLWU_PE3_WUPE11(value)))
#define LLWU_BWR_PE3_WUPE11(base, value) (BME_BFI8(&LLWU_PE3_REG(base), ((uint8_t)(value) << LLWU_PE3_WUPE11_SHIFT), LLWU_PE3_WUPE11_SHIFT, LLWU_PE3_WUPE11_WIDTH))
/*@}*/

/*******************************************************************************
 * LLWU_PE4 - LLWU Pin Enable 4 register
 ******************************************************************************/

/*!
 * @brief LLWU_PE4 - LLWU Pin Enable 4 register (RW)
 *
 * Reset value: 0x00U
 *
 * LLWU_PE4 contains the field to enable and select the edge detect type for the
 * external wakeup input pins LLWU_P15-LLWU_P12. This register is reset on Chip
 * Reset not VLLS and by reset types that trigger Chip Reset not VLLS. It is
 * unaffected by reset types that do not trigger Chip Reset not VLLS. See the
 * IntroductionInformation found here describes the registers of the Reset Control
 * Module (RCM). The RCM implements many of the reset functions for the chip. See the
 * chip's reset chapter for more information. details for more information.
 */
/*!
 * @name Constants and macros for entire LLWU_PE4 register
 */
/*@{*/
#define LLWU_RD_PE4(base)        (LLWU_PE4_REG(base))
#define LLWU_WR_PE4(base, value) (LLWU_PE4_REG(base) = (value))
#define LLWU_RMW_PE4(base, mask, value) (LLWU_WR_PE4(base, (LLWU_RD_PE4(base) & ~(mask)) | (value)))
#define LLWU_SET_PE4(base, value) (BME_OR8(&LLWU_PE4_REG(base), (uint8_t)(value)))
#define LLWU_CLR_PE4(base, value) (BME_AND8(&LLWU_PE4_REG(base), (uint8_t)(~(value))))
#define LLWU_TOG_PE4(base, value) (BME_XOR8(&LLWU_PE4_REG(base), (uint8_t)(value)))
/*@}*/

/*
 * Constants & macros for individual LLWU_PE4 bitfields
 */

/*!
 * @name Register LLWU_PE4, field WUPE12[1:0] (RW)
 *
 * Enables and configures the edge detection for the wakeup pin.
 *
 * Values:
 * - 00 - External input pin disabled as wakeup input
 * - 01 - External input pin enabled with rising edge detection
 * - 10 - External input pin enabled with falling edge detection
 * - 11 - External input pin enabled with any change detection
 */
/*@{*/
/*! @brief Read current value of the LLWU_PE4_WUPE12 field. */
#define LLWU_RD_PE4_WUPE12(base) ((LLWU_PE4_REG(base) & LLWU_PE4_WUPE12_MASK) >> LLWU_PE4_WUPE12_SHIFT)
#define LLWU_BRD_PE4_WUPE12(base) (BME_UBFX8(&LLWU_PE4_REG(base), LLWU_PE4_WUPE12_SHIFT, LLWU_PE4_WUPE12_WIDTH))

/*! @brief Set the WUPE12 field to a new value. */
#define LLWU_WR_PE4_WUPE12(base, value) (LLWU_RMW_PE4(base, LLWU_PE4_WUPE12_MASK, LLWU_PE4_WUPE12(value)))
#define LLWU_BWR_PE4_WUPE12(base, value) (BME_BFI8(&LLWU_PE4_REG(base), ((uint8_t)(value) << LLWU_PE4_WUPE12_SHIFT), LLWU_PE4_WUPE12_SHIFT, LLWU_PE4_WUPE12_WIDTH))
/*@}*/

/*!
 * @name Register LLWU_PE4, field WUPE13[3:2] (RW)
 *
 * Enables and configures the edge detection for the wakeup pin.
 *
 * Values:
 * - 00 - External input pin disabled as wakeup input
 * - 01 - External input pin enabled with rising edge detection
 * - 10 - External input pin enabled with falling edge detection
 * - 11 - External input pin enabled with any change detection
 */
/*@{*/
/*! @brief Read current value of the LLWU_PE4_WUPE13 field. */
#define LLWU_RD_PE4_WUPE13(base) ((LLWU_PE4_REG(base) & LLWU_PE4_WUPE13_MASK) >> LLWU_PE4_WUPE13_SHIFT)
#define LLWU_BRD_PE4_WUPE13(base) (BME_UBFX8(&LLWU_PE4_REG(base), LLWU_PE4_WUPE13_SHIFT, LLWU_PE4_WUPE13_WIDTH))

/*! @brief Set the WUPE13 field to a new value. */
#define LLWU_WR_PE4_WUPE13(base, value) (LLWU_RMW_PE4(base, LLWU_PE4_WUPE13_MASK, LLWU_PE4_WUPE13(value)))
#define LLWU_BWR_PE4_WUPE13(base, value) (BME_BFI8(&LLWU_PE4_REG(base), ((uint8_t)(value) << LLWU_PE4_WUPE13_SHIFT), LLWU_PE4_WUPE13_SHIFT, LLWU_PE4_WUPE13_WIDTH))
/*@}*/

/*!
 * @name Register LLWU_PE4, field WUPE14[5:4] (RW)
 *
 * Enables and configures the edge detection for the wakeup pin.
 *
 * Values:
 * - 00 - External input pin disabled as wakeup input
 * - 01 - External input pin enabled with rising edge detection
 * - 10 - External input pin enabled with falling edge detection
 * - 11 - External input pin enabled with any change detection
 */
/*@{*/
/*! @brief Read current value of the LLWU_PE4_WUPE14 field. */
#define LLWU_RD_PE4_WUPE14(base) ((LLWU_PE4_REG(base) & LLWU_PE4_WUPE14_MASK) >> LLWU_PE4_WUPE14_SHIFT)
#define LLWU_BRD_PE4_WUPE14(base) (BME_UBFX8(&LLWU_PE4_REG(base), LLWU_PE4_WUPE14_SHIFT, LLWU_PE4_WUPE14_WIDTH))

/*! @brief Set the WUPE14 field to a new value. */
#define LLWU_WR_PE4_WUPE14(base, value) (LLWU_RMW_PE4(base, LLWU_PE4_WUPE14_MASK, LLWU_PE4_WUPE14(value)))
#define LLWU_BWR_PE4_WUPE14(base, value) (BME_BFI8(&LLWU_PE4_REG(base), ((uint8_t)(value) << LLWU_PE4_WUPE14_SHIFT), LLWU_PE4_WUPE14_SHIFT, LLWU_PE4_WUPE14_WIDTH))
/*@}*/

/*!
 * @name Register LLWU_PE4, field WUPE15[7:6] (RW)
 *
 * Enables and configures the edge detection for the wakeup pin.
 *
 * Values:
 * - 00 - External input pin disabled as wakeup input
 * - 01 - External input pin enabled with rising edge detection
 * - 10 - External input pin enabled with falling edge detection
 * - 11 - External input pin enabled with any change detection
 */
/*@{*/
/*! @brief Read current value of the LLWU_PE4_WUPE15 field. */
#define LLWU_RD_PE4_WUPE15(base) ((LLWU_PE4_REG(base) & LLWU_PE4_WUPE15_MASK) >> LLWU_PE4_WUPE15_SHIFT)
#define LLWU_BRD_PE4_WUPE15(base) (BME_UBFX8(&LLWU_PE4_REG(base), LLWU_PE4_WUPE15_SHIFT, LLWU_PE4_WUPE15_WIDTH))

/*! @brief Set the WUPE15 field to a new value. */
#define LLWU_WR_PE4_WUPE15(base, value) (LLWU_RMW_PE4(base, LLWU_PE4_WUPE15_MASK, LLWU_PE4_WUPE15(value)))
#define LLWU_BWR_PE4_WUPE15(base, value) (BME_BFI8(&LLWU_PE4_REG(base), ((uint8_t)(value) << LLWU_PE4_WUPE15_SHIFT), LLWU_PE4_WUPE15_SHIFT, LLWU_PE4_WUPE15_WIDTH))
/*@}*/

/*******************************************************************************
 * LLWU_ME - LLWU Module Enable register
 ******************************************************************************/

/*!
 * @brief LLWU_ME - LLWU Module Enable register (RW)
 *
 * Reset value: 0x00U
 *
 * LLWU_ME contains the bits to enable the internal module flag as a wakeup
 * input source for inputs MWUF7-MWUF0. This register is reset on Chip Reset not VLLS
 * and by reset types that trigger Chip Reset not VLLS. It is unaffected by
 * reset types that do not trigger Chip Reset not VLLS. See the
 * IntroductionInformation found here describes the registers of the Reset Control Module (RCM). The
 * RCM implements many of the reset functions for the chip. See the chip's reset
 * chapter for more information. details for more information.
 */
/*!
 * @name Constants and macros for entire LLWU_ME register
 */
/*@{*/
#define LLWU_RD_ME(base)         (LLWU_ME_REG(base))
#define LLWU_WR_ME(base, value)  (LLWU_ME_REG(base) = (value))
#define LLWU_RMW_ME(base, mask, value) (LLWU_WR_ME(base, (LLWU_RD_ME(base) & ~(mask)) | (value)))
#define LLWU_SET_ME(base, value) (BME_OR8(&LLWU_ME_REG(base), (uint8_t)(value)))
#define LLWU_CLR_ME(base, value) (BME_AND8(&LLWU_ME_REG(base), (uint8_t)(~(value))))
#define LLWU_TOG_ME(base, value) (BME_XOR8(&LLWU_ME_REG(base), (uint8_t)(value)))
/*@}*/

/*
 * Constants & macros for individual LLWU_ME bitfields
 */

/*!
 * @name Register LLWU_ME, field WUME0[0] (RW)
 *
 * Enables an internal module as a wakeup source input.
 *
 * Values:
 * - 0 - Internal module flag not used as wakeup source
 * - 1 - Internal module flag used as wakeup source
 */
/*@{*/
/*! @brief Read current value of the LLWU_ME_WUME0 field. */
#define LLWU_RD_ME_WUME0(base) ((LLWU_ME_REG(base) & LLWU_ME_WUME0_MASK) >> LLWU_ME_WUME0_SHIFT)
#define LLWU_BRD_ME_WUME0(base) (BME_UBFX8(&LLWU_ME_REG(base), LLWU_ME_WUME0_SHIFT, LLWU_ME_WUME0_WIDTH))

/*! @brief Set the WUME0 field to a new value. */
#define LLWU_WR_ME_WUME0(base, value) (LLWU_RMW_ME(base, LLWU_ME_WUME0_MASK, LLWU_ME_WUME0(value)))
#define LLWU_BWR_ME_WUME0(base, value) (BME_BFI8(&LLWU_ME_REG(base), ((uint8_t)(value) << LLWU_ME_WUME0_SHIFT), LLWU_ME_WUME0_SHIFT, LLWU_ME_WUME0_WIDTH))
/*@}*/

/*!
 * @name Register LLWU_ME, field WUME1[1] (RW)
 *
 * Enables an internal module as a wakeup source input.
 *
 * Values:
 * - 0 - Internal module flag not used as wakeup source
 * - 1 - Internal module flag used as wakeup source
 */
/*@{*/
/*! @brief Read current value of the LLWU_ME_WUME1 field. */
#define LLWU_RD_ME_WUME1(base) ((LLWU_ME_REG(base) & LLWU_ME_WUME1_MASK) >> LLWU_ME_WUME1_SHIFT)
#define LLWU_BRD_ME_WUME1(base) (BME_UBFX8(&LLWU_ME_REG(base), LLWU_ME_WUME1_SHIFT, LLWU_ME_WUME1_WIDTH))

/*! @brief Set the WUME1 field to a new value. */
#define LLWU_WR_ME_WUME1(base, value) (LLWU_RMW_ME(base, LLWU_ME_WUME1_MASK, LLWU_ME_WUME1(value)))
#define LLWU_BWR_ME_WUME1(base, value) (BME_BFI8(&LLWU_ME_REG(base), ((uint8_t)(value) << LLWU_ME_WUME1_SHIFT), LLWU_ME_WUME1_SHIFT, LLWU_ME_WUME1_WIDTH))
/*@}*/

/*!
 * @name Register LLWU_ME, field WUME2[2] (RW)
 *
 * Enables an internal module as a wakeup source input.
 *
 * Values:
 * - 0 - Internal module flag not used as wakeup source
 * - 1 - Internal module flag used as wakeup source
 */
/*@{*/
/*! @brief Read current value of the LLWU_ME_WUME2 field. */
#define LLWU_RD_ME_WUME2(base) ((LLWU_ME_REG(base) & LLWU_ME_WUME2_MASK) >> LLWU_ME_WUME2_SHIFT)
#define LLWU_BRD_ME_WUME2(base) (BME_UBFX8(&LLWU_ME_REG(base), LLWU_ME_WUME2_SHIFT, LLWU_ME_WUME2_WIDTH))

/*! @brief Set the WUME2 field to a new value. */
#define LLWU_WR_ME_WUME2(base, value) (LLWU_RMW_ME(base, LLWU_ME_WUME2_MASK, LLWU_ME_WUME2(value)))
#define LLWU_BWR_ME_WUME2(base, value) (BME_BFI8(&LLWU_ME_REG(base), ((uint8_t)(value) << LLWU_ME_WUME2_SHIFT), LLWU_ME_WUME2_SHIFT, LLWU_ME_WUME2_WIDTH))
/*@}*/

/*!
 * @name Register LLWU_ME, field WUME3[3] (RW)
 *
 * Enables an internal module as a wakeup source input.
 *
 * Values:
 * - 0 - Internal module flag not used as wakeup source
 * - 1 - Internal module flag used as wakeup source
 */
/*@{*/
/*! @brief Read current value of the LLWU_ME_WUME3 field. */
#define LLWU_RD_ME_WUME3(base) ((LLWU_ME_REG(base) & LLWU_ME_WUME3_MASK) >> LLWU_ME_WUME3_SHIFT)
#define LLWU_BRD_ME_WUME3(base) (BME_UBFX8(&LLWU_ME_REG(base), LLWU_ME_WUME3_SHIFT, LLWU_ME_WUME3_WIDTH))

/*! @brief Set the WUME3 field to a new value. */
#define LLWU_WR_ME_WUME3(base, value) (LLWU_RMW_ME(base, LLWU_ME_WUME3_MASK, LLWU_ME_WUME3(value)))
#define LLWU_BWR_ME_WUME3(base, value) (BME_BFI8(&LLWU_ME_REG(base), ((uint8_t)(value) << LLWU_ME_WUME3_SHIFT), LLWU_ME_WUME3_SHIFT, LLWU_ME_WUME3_WIDTH))
/*@}*/

/*!
 * @name Register LLWU_ME, field WUME4[4] (RW)
 *
 * Enables an internal module as a wakeup source input.
 *
 * Values:
 * - 0 - Internal module flag not used as wakeup source
 * - 1 - Internal module flag used as wakeup source
 */
/*@{*/
/*! @brief Read current value of the LLWU_ME_WUME4 field. */
#define LLWU_RD_ME_WUME4(base) ((LLWU_ME_REG(base) & LLWU_ME_WUME4_MASK) >> LLWU_ME_WUME4_SHIFT)
#define LLWU_BRD_ME_WUME4(base) (BME_UBFX8(&LLWU_ME_REG(base), LLWU_ME_WUME4_SHIFT, LLWU_ME_WUME4_WIDTH))

/*! @brief Set the WUME4 field to a new value. */
#define LLWU_WR_ME_WUME4(base, value) (LLWU_RMW_ME(base, LLWU_ME_WUME4_MASK, LLWU_ME_WUME4(value)))
#define LLWU_BWR_ME_WUME4(base, value) (BME_BFI8(&LLWU_ME_REG(base), ((uint8_t)(value) << LLWU_ME_WUME4_SHIFT), LLWU_ME_WUME4_SHIFT, LLWU_ME_WUME4_WIDTH))
/*@}*/

/*!
 * @name Register LLWU_ME, field WUME5[5] (RW)
 *
 * Enables an internal module as a wakeup source input.
 *
 * Values:
 * - 0 - Internal module flag not used as wakeup source
 * - 1 - Internal module flag used as wakeup source
 */
/*@{*/
/*! @brief Read current value of the LLWU_ME_WUME5 field. */
#define LLWU_RD_ME_WUME5(base) ((LLWU_ME_REG(base) & LLWU_ME_WUME5_MASK) >> LLWU_ME_WUME5_SHIFT)
#define LLWU_BRD_ME_WUME5(base) (BME_UBFX8(&LLWU_ME_REG(base), LLWU_ME_WUME5_SHIFT, LLWU_ME_WUME5_WIDTH))

/*! @brief Set the WUME5 field to a new value. */
#define LLWU_WR_ME_WUME5(base, value) (LLWU_RMW_ME(base, LLWU_ME_WUME5_MASK, LLWU_ME_WUME5(value)))
#define LLWU_BWR_ME_WUME5(base, value) (BME_BFI8(&LLWU_ME_REG(base), ((uint8_t)(value) << LLWU_ME_WUME5_SHIFT), LLWU_ME_WUME5_SHIFT, LLWU_ME_WUME5_WIDTH))
/*@}*/

/*!
 * @name Register LLWU_ME, field WUME6[6] (RW)
 *
 * Enables an internal module as a wakeup source input.
 *
 * Values:
 * - 0 - Internal module flag not used as wakeup source
 * - 1 - Internal module flag used as wakeup source
 */
/*@{*/
/*! @brief Read current value of the LLWU_ME_WUME6 field. */
#define LLWU_RD_ME_WUME6(base) ((LLWU_ME_REG(base) & LLWU_ME_WUME6_MASK) >> LLWU_ME_WUME6_SHIFT)
#define LLWU_BRD_ME_WUME6(base) (BME_UBFX8(&LLWU_ME_REG(base), LLWU_ME_WUME6_SHIFT, LLWU_ME_WUME6_WIDTH))

/*! @brief Set the WUME6 field to a new value. */
#define LLWU_WR_ME_WUME6(base, value) (LLWU_RMW_ME(base, LLWU_ME_WUME6_MASK, LLWU_ME_WUME6(value)))
#define LLWU_BWR_ME_WUME6(base, value) (BME_BFI8(&LLWU_ME_REG(base), ((uint8_t)(value) << LLWU_ME_WUME6_SHIFT), LLWU_ME_WUME6_SHIFT, LLWU_ME_WUME6_WIDTH))
/*@}*/

/*!
 * @name Register LLWU_ME, field WUME7[7] (RW)
 *
 * Enables an internal module as a wakeup source input.
 *
 * Values:
 * - 0 - Internal module flag not used as wakeup source
 * - 1 - Internal module flag used as wakeup source
 */
/*@{*/
/*! @brief Read current value of the LLWU_ME_WUME7 field. */
#define LLWU_RD_ME_WUME7(base) ((LLWU_ME_REG(base) & LLWU_ME_WUME7_MASK) >> LLWU_ME_WUME7_SHIFT)
#define LLWU_BRD_ME_WUME7(base) (BME_UBFX8(&LLWU_ME_REG(base), LLWU_ME_WUME7_SHIFT, LLWU_ME_WUME7_WIDTH))

/*! @brief Set the WUME7 field to a new value. */
#define LLWU_WR_ME_WUME7(base, value) (LLWU_RMW_ME(base, LLWU_ME_WUME7_MASK, LLWU_ME_WUME7(value)))
#define LLWU_BWR_ME_WUME7(base, value) (BME_BFI8(&LLWU_ME_REG(base), ((uint8_t)(value) << LLWU_ME_WUME7_SHIFT), LLWU_ME_WUME7_SHIFT, LLWU_ME_WUME7_WIDTH))
/*@}*/

/*******************************************************************************
 * LLWU_F1 - LLWU Flag 1 register
 ******************************************************************************/

/*!
 * @brief LLWU_F1 - LLWU Flag 1 register (W1C)
 *
 * Reset value: 0x00U
 *
 * LLWU_F1 contains the wakeup flags indicating which wakeup source caused the
 * MCU to exit LLS or VLLS mode. For LLS, this is the source causing the CPU
 * interrupt flow. For VLLS, this is the source causing the MCU reset flow. The
 * external wakeup flags are read-only and clearing a flag is accomplished by a write
 * of a 1 to the corresponding WUFx bit. The wakeup flag (WUFx), if set, will
 * remain set if the associated WUPEx bit is cleared. This register is reset on Chip
 * Reset not VLLS and by reset types that trigger Chip Reset not VLLS. It is
 * unaffected by reset types that do not trigger Chip Reset not VLLS. See the
 * IntroductionInformation found here describes the registers of the Reset Control
 * Module (RCM). The RCM implements many of the reset functions for the chip. See the
 * chip's reset chapter for more information. details for more information.
 */
/*!
 * @name Constants and macros for entire LLWU_F1 register
 */
/*@{*/
#define LLWU_RD_F1(base)         (LLWU_F1_REG(base))
#define LLWU_WR_F1(base, value)  (LLWU_F1_REG(base) = (value))
#define LLWU_RMW_F1(base, mask, value) (LLWU_WR_F1(base, (LLWU_RD_F1(base) & ~(mask)) | (value)))
#define LLWU_SET_F1(base, value) (BME_OR8(&LLWU_F1_REG(base), (uint8_t)(value)))
#define LLWU_CLR_F1(base, value) (BME_AND8(&LLWU_F1_REG(base), (uint8_t)(~(value))))
#define LLWU_TOG_F1(base, value) (BME_XOR8(&LLWU_F1_REG(base), (uint8_t)(value)))
/*@}*/

/*
 * Constants & macros for individual LLWU_F1 bitfields
 */

/*!
 * @name Register LLWU_F1, field WUF0[0] (W1C)
 *
 * Indicates that an enabled external wake-up pin was a source of exiting a
 * low-leakage power mode. To clear the flag, write a 1 to WUF0.
 *
 * Values:
 * - 0 - LLWU_P0 input was not a wakeup source
 * - 1 - LLWU_P0 input was a wakeup source
 */
/*@{*/
/*! @brief Read current value of the LLWU_F1_WUF0 field. */
#define LLWU_RD_F1_WUF0(base) ((LLWU_F1_REG(base) & LLWU_F1_WUF0_MASK) >> LLWU_F1_WUF0_SHIFT)
#define LLWU_BRD_F1_WUF0(base) (BME_UBFX8(&LLWU_F1_REG(base), LLWU_F1_WUF0_SHIFT, LLWU_F1_WUF0_WIDTH))

/*! @brief Set the WUF0 field to a new value. */
#define LLWU_WR_F1_WUF0(base, value) (LLWU_RMW_F1(base, (LLWU_F1_WUF0_MASK | LLWU_F1_WUF1_MASK | LLWU_F1_WUF2_MASK | LLWU_F1_WUF3_MASK | LLWU_F1_WUF4_MASK | LLWU_F1_WUF5_MASK | LLWU_F1_WUF6_MASK | LLWU_F1_WUF7_MASK), LLWU_F1_WUF0(value)))
#define LLWU_BWR_F1_WUF0(base, value) (BME_BFI8(&LLWU_F1_REG(base), ((uint8_t)(value) << LLWU_F1_WUF0_SHIFT), LLWU_F1_WUF0_SHIFT, LLWU_F1_WUF0_WIDTH))
/*@}*/

/*!
 * @name Register LLWU_F1, field WUF1[1] (W1C)
 *
 * Indicates that an enabled external wakeup pin was a source of exiting a
 * low-leakage power mode. To clear the flag, write a 1 to WUF1.
 *
 * Values:
 * - 0 - LLWU_P1 input was not a wakeup source
 * - 1 - LLWU_P1 input was a wakeup source
 */
/*@{*/
/*! @brief Read current value of the LLWU_F1_WUF1 field. */
#define LLWU_RD_F1_WUF1(base) ((LLWU_F1_REG(base) & LLWU_F1_WUF1_MASK) >> LLWU_F1_WUF1_SHIFT)
#define LLWU_BRD_F1_WUF1(base) (BME_UBFX8(&LLWU_F1_REG(base), LLWU_F1_WUF1_SHIFT, LLWU_F1_WUF1_WIDTH))

/*! @brief Set the WUF1 field to a new value. */
#define LLWU_WR_F1_WUF1(base, value) (LLWU_RMW_F1(base, (LLWU_F1_WUF1_MASK | LLWU_F1_WUF0_MASK | LLWU_F1_WUF2_MASK | LLWU_F1_WUF3_MASK | LLWU_F1_WUF4_MASK | LLWU_F1_WUF5_MASK | LLWU_F1_WUF6_MASK | LLWU_F1_WUF7_MASK), LLWU_F1_WUF1(value)))
#define LLWU_BWR_F1_WUF1(base, value) (BME_BFI8(&LLWU_F1_REG(base), ((uint8_t)(value) << LLWU_F1_WUF1_SHIFT), LLWU_F1_WUF1_SHIFT, LLWU_F1_WUF1_WIDTH))
/*@}*/

/*!
 * @name Register LLWU_F1, field WUF2[2] (W1C)
 *
 * Indicates that an enabled external wakeup pin was a source of exiting a
 * low-leakage power mode. To clear the flag, write a 1 to WUF2.
 *
 * Values:
 * - 0 - LLWU_P2 input was not a wakeup source
 * - 1 - LLWU_P2 input was a wakeup source
 */
/*@{*/
/*! @brief Read current value of the LLWU_F1_WUF2 field. */
#define LLWU_RD_F1_WUF2(base) ((LLWU_F1_REG(base) & LLWU_F1_WUF2_MASK) >> LLWU_F1_WUF2_SHIFT)
#define LLWU_BRD_F1_WUF2(base) (BME_UBFX8(&LLWU_F1_REG(base), LLWU_F1_WUF2_SHIFT, LLWU_F1_WUF2_WIDTH))

/*! @brief Set the WUF2 field to a new value. */
#define LLWU_WR_F1_WUF2(base, value) (LLWU_RMW_F1(base, (LLWU_F1_WUF2_MASK | LLWU_F1_WUF0_MASK | LLWU_F1_WUF1_MASK | LLWU_F1_WUF3_MASK | LLWU_F1_WUF4_MASK | LLWU_F1_WUF5_MASK | LLWU_F1_WUF6_MASK | LLWU_F1_WUF7_MASK), LLWU_F1_WUF2(value)))
#define LLWU_BWR_F1_WUF2(base, value) (BME_BFI8(&LLWU_F1_REG(base), ((uint8_t)(value) << LLWU_F1_WUF2_SHIFT), LLWU_F1_WUF2_SHIFT, LLWU_F1_WUF2_WIDTH))
/*@}*/

/*!
 * @name Register LLWU_F1, field WUF3[3] (W1C)
 *
 * Indicates that an enabled external wakeup pin was a source of exiting a
 * low-leakage power mode. To clear the flag, write a 1 to WUF3.
 *
 * Values:
 * - 0 - LLWU_P3 input was not a wake-up source
 * - 1 - LLWU_P3 input was a wake-up source
 */
/*@{*/
/*! @brief Read current value of the LLWU_F1_WUF3 field. */
#define LLWU_RD_F1_WUF3(base) ((LLWU_F1_REG(base) & LLWU_F1_WUF3_MASK) >> LLWU_F1_WUF3_SHIFT)
#define LLWU_BRD_F1_WUF3(base) (BME_UBFX8(&LLWU_F1_REG(base), LLWU_F1_WUF3_SHIFT, LLWU_F1_WUF3_WIDTH))

/*! @brief Set the WUF3 field to a new value. */
#define LLWU_WR_F1_WUF3(base, value) (LLWU_RMW_F1(base, (LLWU_F1_WUF3_MASK | LLWU_F1_WUF0_MASK | LLWU_F1_WUF1_MASK | LLWU_F1_WUF2_MASK | LLWU_F1_WUF4_MASK | LLWU_F1_WUF5_MASK | LLWU_F1_WUF6_MASK | LLWU_F1_WUF7_MASK), LLWU_F1_WUF3(value)))
#define LLWU_BWR_F1_WUF3(base, value) (BME_BFI8(&LLWU_F1_REG(base), ((uint8_t)(value) << LLWU_F1_WUF3_SHIFT), LLWU_F1_WUF3_SHIFT, LLWU_F1_WUF3_WIDTH))
/*@}*/

/*!
 * @name Register LLWU_F1, field WUF4[4] (W1C)
 *
 * Indicates that an enabled external wake-up pin was a source of exiting a
 * low-leakage power mode. To clear the flag, write a 1 to WUF4.
 *
 * Values:
 * - 0 - LLWU_P4 input was not a wakeup source
 * - 1 - LLWU_P4 input was a wakeup source
 */
/*@{*/
/*! @brief Read current value of the LLWU_F1_WUF4 field. */
#define LLWU_RD_F1_WUF4(base) ((LLWU_F1_REG(base) & LLWU_F1_WUF4_MASK) >> LLWU_F1_WUF4_SHIFT)
#define LLWU_BRD_F1_WUF4(base) (BME_UBFX8(&LLWU_F1_REG(base), LLWU_F1_WUF4_SHIFT, LLWU_F1_WUF4_WIDTH))

/*! @brief Set the WUF4 field to a new value. */
#define LLWU_WR_F1_WUF4(base, value) (LLWU_RMW_F1(base, (LLWU_F1_WUF4_MASK | LLWU_F1_WUF0_MASK | LLWU_F1_WUF1_MASK | LLWU_F1_WUF2_MASK | LLWU_F1_WUF3_MASK | LLWU_F1_WUF5_MASK | LLWU_F1_WUF6_MASK | LLWU_F1_WUF7_MASK), LLWU_F1_WUF4(value)))
#define LLWU_BWR_F1_WUF4(base, value) (BME_BFI8(&LLWU_F1_REG(base), ((uint8_t)(value) << LLWU_F1_WUF4_SHIFT), LLWU_F1_WUF4_SHIFT, LLWU_F1_WUF4_WIDTH))
/*@}*/

/*!
 * @name Register LLWU_F1, field WUF5[5] (W1C)
 *
 * Indicates that an enabled external wakeup pin was a source of exiting a
 * low-leakage power mode. To clear the flag, write a 1 to WUF5.
 *
 * Values:
 * - 0 - LLWU_P5 input was not a wakeup source
 * - 1 - LLWU_P5 input was a wakeup source
 */
/*@{*/
/*! @brief Read current value of the LLWU_F1_WUF5 field. */
#define LLWU_RD_F1_WUF5(base) ((LLWU_F1_REG(base) & LLWU_F1_WUF5_MASK) >> LLWU_F1_WUF5_SHIFT)
#define LLWU_BRD_F1_WUF5(base) (BME_UBFX8(&LLWU_F1_REG(base), LLWU_F1_WUF5_SHIFT, LLWU_F1_WUF5_WIDTH))

/*! @brief Set the WUF5 field to a new value. */
#define LLWU_WR_F1_WUF5(base, value) (LLWU_RMW_F1(base, (LLWU_F1_WUF5_MASK | LLWU_F1_WUF0_MASK | LLWU_F1_WUF1_MASK | LLWU_F1_WUF2_MASK | LLWU_F1_WUF3_MASK | LLWU_F1_WUF4_MASK | LLWU_F1_WUF6_MASK | LLWU_F1_WUF7_MASK), LLWU_F1_WUF5(value)))
#define LLWU_BWR_F1_WUF5(base, value) (BME_BFI8(&LLWU_F1_REG(base), ((uint8_t)(value) << LLWU_F1_WUF5_SHIFT), LLWU_F1_WUF5_SHIFT, LLWU_F1_WUF5_WIDTH))
/*@}*/

/*!
 * @name Register LLWU_F1, field WUF6[6] (W1C)
 *
 * Indicates that an enabled external wakeup pin was a source of exiting a
 * low-leakage power mode. To clear the flag, write a 1 to WUF6.
 *
 * Values:
 * - 0 - LLWU_P6 input was not a wakeup source
 * - 1 - LLWU_P6 input was a wakeup source
 */
/*@{*/
/*! @brief Read current value of the LLWU_F1_WUF6 field. */
#define LLWU_RD_F1_WUF6(base) ((LLWU_F1_REG(base) & LLWU_F1_WUF6_MASK) >> LLWU_F1_WUF6_SHIFT)
#define LLWU_BRD_F1_WUF6(base) (BME_UBFX8(&LLWU_F1_REG(base), LLWU_F1_WUF6_SHIFT, LLWU_F1_WUF6_WIDTH))

/*! @brief Set the WUF6 field to a new value. */
#define LLWU_WR_F1_WUF6(base, value) (LLWU_RMW_F1(base, (LLWU_F1_WUF6_MASK | LLWU_F1_WUF0_MASK | LLWU_F1_WUF1_MASK | LLWU_F1_WUF2_MASK | LLWU_F1_WUF3_MASK | LLWU_F1_WUF4_MASK | LLWU_F1_WUF5_MASK | LLWU_F1_WUF7_MASK), LLWU_F1_WUF6(value)))
#define LLWU_BWR_F1_WUF6(base, value) (BME_BFI8(&LLWU_F1_REG(base), ((uint8_t)(value) << LLWU_F1_WUF6_SHIFT), LLWU_F1_WUF6_SHIFT, LLWU_F1_WUF6_WIDTH))
/*@}*/

/*!
 * @name Register LLWU_F1, field WUF7[7] (W1C)
 *
 * Indicates that an enabled external wakeup pin was a source of exiting a
 * low-leakage power mode. To clear the flag, write a 1 to WUF7.
 *
 * Values:
 * - 0 - LLWU_P7 input was not a wakeup source
 * - 1 - LLWU_P7 input was a wakeup source
 */
/*@{*/
/*! @brief Read current value of the LLWU_F1_WUF7 field. */
#define LLWU_RD_F1_WUF7(base) ((LLWU_F1_REG(base) & LLWU_F1_WUF7_MASK) >> LLWU_F1_WUF7_SHIFT)
#define LLWU_BRD_F1_WUF7(base) (BME_UBFX8(&LLWU_F1_REG(base), LLWU_F1_WUF7_SHIFT, LLWU_F1_WUF7_WIDTH))

/*! @brief Set the WUF7 field to a new value. */
#define LLWU_WR_F1_WUF7(base, value) (LLWU_RMW_F1(base, (LLWU_F1_WUF7_MASK | LLWU_F1_WUF0_MASK | LLWU_F1_WUF1_MASK | LLWU_F1_WUF2_MASK | LLWU_F1_WUF3_MASK | LLWU_F1_WUF4_MASK | LLWU_F1_WUF5_MASK | LLWU_F1_WUF6_MASK), LLWU_F1_WUF7(value)))
#define LLWU_BWR_F1_WUF7(base, value) (BME_BFI8(&LLWU_F1_REG(base), ((uint8_t)(value) << LLWU_F1_WUF7_SHIFT), LLWU_F1_WUF7_SHIFT, LLWU_F1_WUF7_WIDTH))
/*@}*/

/*******************************************************************************
 * LLWU_F2 - LLWU Flag 2 register
 ******************************************************************************/

/*!
 * @brief LLWU_F2 - LLWU Flag 2 register (W1C)
 *
 * Reset value: 0x00U
 *
 * LLWU_F2 contains the wakeup flags indicating which wakeup source caused the
 * MCU to exit LLS or VLLS mode. For LLS, this is the source causing the CPU
 * interrupt flow. For VLLS, this is the source causing the MCU reset flow. The
 * external wakeup flags are read-only and clearing a flag is accomplished by a write
 * of a 1 to the corresponding WUFx bit. The wakeup flag (WUFx), if set, will
 * remain set if the associated WUPEx bit is cleared. This register is reset on Chip
 * Reset not VLLS and by reset types that trigger Chip Reset not VLLS. It is
 * unaffected by reset types that do not trigger Chip Reset not VLLS. See the
 * IntroductionInformation found here describes the registers of the Reset Control
 * Module (RCM). The RCM implements many of the reset functions for the chip. See the
 * chip's reset chapter for more information. details for more information.
 */
/*!
 * @name Constants and macros for entire LLWU_F2 register
 */
/*@{*/
#define LLWU_RD_F2(base)         (LLWU_F2_REG(base))
#define LLWU_WR_F2(base, value)  (LLWU_F2_REG(base) = (value))
#define LLWU_RMW_F2(base, mask, value) (LLWU_WR_F2(base, (LLWU_RD_F2(base) & ~(mask)) | (value)))
#define LLWU_SET_F2(base, value) (BME_OR8(&LLWU_F2_REG(base), (uint8_t)(value)))
#define LLWU_CLR_F2(base, value) (BME_AND8(&LLWU_F2_REG(base), (uint8_t)(~(value))))
#define LLWU_TOG_F2(base, value) (BME_XOR8(&LLWU_F2_REG(base), (uint8_t)(value)))
/*@}*/

/*
 * Constants & macros for individual LLWU_F2 bitfields
 */

/*!
 * @name Register LLWU_F2, field WUF8[0] (W1C)
 *
 * Indicates that an enabled external wakeup pin was a source of exiting a
 * low-leakage power mode. To clear the flag, write a 1 to WUF8.
 *
 * Values:
 * - 0 - LLWU_P8 input was not a wakeup source
 * - 1 - LLWU_P8 input was a wakeup source
 */
/*@{*/
/*! @brief Read current value of the LLWU_F2_WUF8 field. */
#define LLWU_RD_F2_WUF8(base) ((LLWU_F2_REG(base) & LLWU_F2_WUF8_MASK) >> LLWU_F2_WUF8_SHIFT)
#define LLWU_BRD_F2_WUF8(base) (BME_UBFX8(&LLWU_F2_REG(base), LLWU_F2_WUF8_SHIFT, LLWU_F2_WUF8_WIDTH))

/*! @brief Set the WUF8 field to a new value. */
#define LLWU_WR_F2_WUF8(base, value) (LLWU_RMW_F2(base, (LLWU_F2_WUF8_MASK | LLWU_F2_WUF9_MASK | LLWU_F2_WUF10_MASK | LLWU_F2_WUF11_MASK | LLWU_F2_WUF12_MASK | LLWU_F2_WUF13_MASK | LLWU_F2_WUF14_MASK | LLWU_F2_WUF15_MASK), LLWU_F2_WUF8(value)))
#define LLWU_BWR_F2_WUF8(base, value) (BME_BFI8(&LLWU_F2_REG(base), ((uint8_t)(value) << LLWU_F2_WUF8_SHIFT), LLWU_F2_WUF8_SHIFT, LLWU_F2_WUF8_WIDTH))
/*@}*/

/*!
 * @name Register LLWU_F2, field WUF9[1] (W1C)
 *
 * Indicates that an enabled external wakeup pin was a source of exiting a
 * low-leakage power mode. To clear the flag, write a 1 to WUF9.
 *
 * Values:
 * - 0 - LLWU_P9 input was not a wakeup source
 * - 1 - LLWU_P9 input was a wakeup source
 */
/*@{*/
/*! @brief Read current value of the LLWU_F2_WUF9 field. */
#define LLWU_RD_F2_WUF9(base) ((LLWU_F2_REG(base) & LLWU_F2_WUF9_MASK) >> LLWU_F2_WUF9_SHIFT)
#define LLWU_BRD_F2_WUF9(base) (BME_UBFX8(&LLWU_F2_REG(base), LLWU_F2_WUF9_SHIFT, LLWU_F2_WUF9_WIDTH))

/*! @brief Set the WUF9 field to a new value. */
#define LLWU_WR_F2_WUF9(base, value) (LLWU_RMW_F2(base, (LLWU_F2_WUF9_MASK | LLWU_F2_WUF8_MASK | LLWU_F2_WUF10_MASK | LLWU_F2_WUF11_MASK | LLWU_F2_WUF12_MASK | LLWU_F2_WUF13_MASK | LLWU_F2_WUF14_MASK | LLWU_F2_WUF15_MASK), LLWU_F2_WUF9(value)))
#define LLWU_BWR_F2_WUF9(base, value) (BME_BFI8(&LLWU_F2_REG(base), ((uint8_t)(value) << LLWU_F2_WUF9_SHIFT), LLWU_F2_WUF9_SHIFT, LLWU_F2_WUF9_WIDTH))
/*@}*/

/*!
 * @name Register LLWU_F2, field WUF10[2] (W1C)
 *
 * Indicates that an enabled external wakeup pin was a source of exiting a
 * low-leakage power mode. To clear the flag, write a 1 to WUF10.
 *
 * Values:
 * - 0 - LLWU_P10 input was not a wakeup source
 * - 1 - LLWU_P10 input was a wakeup source
 */
/*@{*/
/*! @brief Read current value of the LLWU_F2_WUF10 field. */
#define LLWU_RD_F2_WUF10(base) ((LLWU_F2_REG(base) & LLWU_F2_WUF10_MASK) >> LLWU_F2_WUF10_SHIFT)
#define LLWU_BRD_F2_WUF10(base) (BME_UBFX8(&LLWU_F2_REG(base), LLWU_F2_WUF10_SHIFT, LLWU_F2_WUF10_WIDTH))

/*! @brief Set the WUF10 field to a new value. */
#define LLWU_WR_F2_WUF10(base, value) (LLWU_RMW_F2(base, (LLWU_F2_WUF10_MASK | LLWU_F2_WUF8_MASK | LLWU_F2_WUF9_MASK | LLWU_F2_WUF11_MASK | LLWU_F2_WUF12_MASK | LLWU_F2_WUF13_MASK | LLWU_F2_WUF14_MASK | LLWU_F2_WUF15_MASK), LLWU_F2_WUF10(value)))
#define LLWU_BWR_F2_WUF10(base, value) (BME_BFI8(&LLWU_F2_REG(base), ((uint8_t)(value) << LLWU_F2_WUF10_SHIFT), LLWU_F2_WUF10_SHIFT, LLWU_F2_WUF10_WIDTH))
/*@}*/

/*!
 * @name Register LLWU_F2, field WUF11[3] (W1C)
 *
 * Indicates that an enabled external wakeup pin was a source of exiting a
 * low-leakage power mode. To clear the flag, write a 1 to WUF11.
 *
 * Values:
 * - 0 - LLWU_P11 input was not a wakeup source
 * - 1 - LLWU_P11 input was a wakeup source
 */
/*@{*/
/*! @brief Read current value of the LLWU_F2_WUF11 field. */
#define LLWU_RD_F2_WUF11(base) ((LLWU_F2_REG(base) & LLWU_F2_WUF11_MASK) >> LLWU_F2_WUF11_SHIFT)
#define LLWU_BRD_F2_WUF11(base) (BME_UBFX8(&LLWU_F2_REG(base), LLWU_F2_WUF11_SHIFT, LLWU_F2_WUF11_WIDTH))

/*! @brief Set the WUF11 field to a new value. */
#define LLWU_WR_F2_WUF11(base, value) (LLWU_RMW_F2(base, (LLWU_F2_WUF11_MASK | LLWU_F2_WUF8_MASK | LLWU_F2_WUF9_MASK | LLWU_F2_WUF10_MASK | LLWU_F2_WUF12_MASK | LLWU_F2_WUF13_MASK | LLWU_F2_WUF14_MASK | LLWU_F2_WUF15_MASK), LLWU_F2_WUF11(value)))
#define LLWU_BWR_F2_WUF11(base, value) (BME_BFI8(&LLWU_F2_REG(base), ((uint8_t)(value) << LLWU_F2_WUF11_SHIFT), LLWU_F2_WUF11_SHIFT, LLWU_F2_WUF11_WIDTH))
/*@}*/

/*!
 * @name Register LLWU_F2, field WUF12[4] (W1C)
 *
 * Indicates that an enabled external wakeup pin was a source of exiting a
 * low-leakage power mode. To clear the flag, write a 1 to WUF12.
 *
 * Values:
 * - 0 - LLWU_P12 input was not a wakeup source
 * - 1 - LLWU_P12 input was a wakeup source
 */
/*@{*/
/*! @brief Read current value of the LLWU_F2_WUF12 field. */
#define LLWU_RD_F2_WUF12(base) ((LLWU_F2_REG(base) & LLWU_F2_WUF12_MASK) >> LLWU_F2_WUF12_SHIFT)
#define LLWU_BRD_F2_WUF12(base) (BME_UBFX8(&LLWU_F2_REG(base), LLWU_F2_WUF12_SHIFT, LLWU_F2_WUF12_WIDTH))

/*! @brief Set the WUF12 field to a new value. */
#define LLWU_WR_F2_WUF12(base, value) (LLWU_RMW_F2(base, (LLWU_F2_WUF12_MASK | LLWU_F2_WUF8_MASK | LLWU_F2_WUF9_MASK | LLWU_F2_WUF10_MASK | LLWU_F2_WUF11_MASK | LLWU_F2_WUF13_MASK | LLWU_F2_WUF14_MASK | LLWU_F2_WUF15_MASK), LLWU_F2_WUF12(value)))
#define LLWU_BWR_F2_WUF12(base, value) (BME_BFI8(&LLWU_F2_REG(base), ((uint8_t)(value) << LLWU_F2_WUF12_SHIFT), LLWU_F2_WUF12_SHIFT, LLWU_F2_WUF12_WIDTH))
/*@}*/

/*!
 * @name Register LLWU_F2, field WUF13[5] (W1C)
 *
 * Indicates that an enabled external wakeup pin was a source of exiting a
 * low-leakage power mode. To clear the flag, write a 1 to WUF13.
 *
 * Values:
 * - 0 - LLWU_P13 input was not a wakeup source
 * - 1 - LLWU_P13 input was a wakeup source
 */
/*@{*/
/*! @brief Read current value of the LLWU_F2_WUF13 field. */
#define LLWU_RD_F2_WUF13(base) ((LLWU_F2_REG(base) & LLWU_F2_WUF13_MASK) >> LLWU_F2_WUF13_SHIFT)
#define LLWU_BRD_F2_WUF13(base) (BME_UBFX8(&LLWU_F2_REG(base), LLWU_F2_WUF13_SHIFT, LLWU_F2_WUF13_WIDTH))

/*! @brief Set the WUF13 field to a new value. */
#define LLWU_WR_F2_WUF13(base, value) (LLWU_RMW_F2(base, (LLWU_F2_WUF13_MASK | LLWU_F2_WUF8_MASK | LLWU_F2_WUF9_MASK | LLWU_F2_WUF10_MASK | LLWU_F2_WUF11_MASK | LLWU_F2_WUF12_MASK | LLWU_F2_WUF14_MASK | LLWU_F2_WUF15_MASK), LLWU_F2_WUF13(value)))
#define LLWU_BWR_F2_WUF13(base, value) (BME_BFI8(&LLWU_F2_REG(base), ((uint8_t)(value) << LLWU_F2_WUF13_SHIFT), LLWU_F2_WUF13_SHIFT, LLWU_F2_WUF13_WIDTH))
/*@}*/

/*!
 * @name Register LLWU_F2, field WUF14[6] (W1C)
 *
 * Indicates that an enabled external wakeup pin was a source of exiting a
 * low-leakage power mode. To clear the flag, write a 1 to WUF14.
 *
 * Values:
 * - 0 - LLWU_P14 input was not a wakeup source
 * - 1 - LLWU_P14 input was a wakeup source
 */
/*@{*/
/*! @brief Read current value of the LLWU_F2_WUF14 field. */
#define LLWU_RD_F2_WUF14(base) ((LLWU_F2_REG(base) & LLWU_F2_WUF14_MASK) >> LLWU_F2_WUF14_SHIFT)
#define LLWU_BRD_F2_WUF14(base) (BME_UBFX8(&LLWU_F2_REG(base), LLWU_F2_WUF14_SHIFT, LLWU_F2_WUF14_WIDTH))

/*! @brief Set the WUF14 field to a new value. */
#define LLWU_WR_F2_WUF14(base, value) (LLWU_RMW_F2(base, (LLWU_F2_WUF14_MASK | LLWU_F2_WUF8_MASK | LLWU_F2_WUF9_MASK | LLWU_F2_WUF10_MASK | LLWU_F2_WUF11_MASK | LLWU_F2_WUF12_MASK | LLWU_F2_WUF13_MASK | LLWU_F2_WUF15_MASK), LLWU_F2_WUF14(value)))
#define LLWU_BWR_F2_WUF14(base, value) (BME_BFI8(&LLWU_F2_REG(base), ((uint8_t)(value) << LLWU_F2_WUF14_SHIFT), LLWU_F2_WUF14_SHIFT, LLWU_F2_WUF14_WIDTH))
/*@}*/

/*!
 * @name Register LLWU_F2, field WUF15[7] (W1C)
 *
 * Indicates that an enabled external wakeup pin was a source of exiting a
 * low-leakage power mode. To clear the flag, write a 1 to WUF15.
 *
 * Values:
 * - 0 - LLWU_P15 input was not a wakeup source
 * - 1 - LLWU_P15 input was a wakeup source
 */
/*@{*/
/*! @brief Read current value of the LLWU_F2_WUF15 field. */
#define LLWU_RD_F2_WUF15(base) ((LLWU_F2_REG(base) & LLWU_F2_WUF15_MASK) >> LLWU_F2_WUF15_SHIFT)
#define LLWU_BRD_F2_WUF15(base) (BME_UBFX8(&LLWU_F2_REG(base), LLWU_F2_WUF15_SHIFT, LLWU_F2_WUF15_WIDTH))

/*! @brief Set the WUF15 field to a new value. */
#define LLWU_WR_F2_WUF15(base, value) (LLWU_RMW_F2(base, (LLWU_F2_WUF15_MASK | LLWU_F2_WUF8_MASK | LLWU_F2_WUF9_MASK | LLWU_F2_WUF10_MASK | LLWU_F2_WUF11_MASK | LLWU_F2_WUF12_MASK | LLWU_F2_WUF13_MASK | LLWU_F2_WUF14_MASK), LLWU_F2_WUF15(value)))
#define LLWU_BWR_F2_WUF15(base, value) (BME_BFI8(&LLWU_F2_REG(base), ((uint8_t)(value) << LLWU_F2_WUF15_SHIFT), LLWU_F2_WUF15_SHIFT, LLWU_F2_WUF15_WIDTH))
/*@}*/

/*******************************************************************************
 * LLWU_F3 - LLWU Flag 3 register
 ******************************************************************************/

/*!
 * @brief LLWU_F3 - LLWU Flag 3 register (RO)
 *
 * Reset value: 0x00U
 *
 * LLWU_F3 contains the wakeup flags indicating which internal wakeup source
 * caused the MCU to exit LLS or VLLS mode. For LLS, this is the source causing the
 * CPU interrupt flow. For VLLS, this is the source causing the MCU reset flow.
 * For internal peripherals that are capable of running in a low-leakage power
 * mode, such as a real time clock module or CMP module, the flag from the
 * associated peripheral is accessible as the MWUFx bit. The flag will need to be cleared
 * in the peripheral instead of writing a 1 to the MWUFx bit. This register is
 * reset on Chip Reset not VLLS and by reset types that trigger Chip Reset not
 * VLLS. It is unaffected by reset types that do not trigger Chip Reset not VLLS. See
 * the IntroductionInformation found here describes the registers of the Reset
 * Control Module (RCM). The RCM implements many of the reset functions for the
 * chip. See the chip's reset chapter for more information. details for more
 * information.
 */
/*!
 * @name Constants and macros for entire LLWU_F3 register
 */
/*@{*/
#define LLWU_RD_F3(base)         (LLWU_F3_REG(base))
/*@}*/

/*
 * Constants & macros for individual LLWU_F3 bitfields
 */

/*!
 * @name Register LLWU_F3, field MWUF0[0] (RO)
 *
 * Indicates that an enabled internal peripheral was a source of exiting a
 * low-leakage power mode. To clear the flag, follow the internal peripheral flag
 * clearing mechanism.
 *
 * Values:
 * - 0 - Module 0 input was not a wakeup source
 * - 1 - Module 0 input was a wakeup source
 */
/*@{*/
/*! @brief Read current value of the LLWU_F3_MWUF0 field. */
#define LLWU_RD_F3_MWUF0(base) ((LLWU_F3_REG(base) & LLWU_F3_MWUF0_MASK) >> LLWU_F3_MWUF0_SHIFT)
#define LLWU_BRD_F3_MWUF0(base) (BME_UBFX8(&LLWU_F3_REG(base), LLWU_F3_MWUF0_SHIFT, LLWU_F3_MWUF0_WIDTH))
/*@}*/

/*!
 * @name Register LLWU_F3, field MWUF1[1] (RO)
 *
 * Indicates that an enabled internal peripheral was a source of exiting a
 * low-leakage power mode. To clear the flag, follow the internal peripheral flag
 * clearing mechanism.
 *
 * Values:
 * - 0 - Module 1 input was not a wakeup source
 * - 1 - Module 1 input was a wakeup source
 */
/*@{*/
/*! @brief Read current value of the LLWU_F3_MWUF1 field. */
#define LLWU_RD_F3_MWUF1(base) ((LLWU_F3_REG(base) & LLWU_F3_MWUF1_MASK) >> LLWU_F3_MWUF1_SHIFT)
#define LLWU_BRD_F3_MWUF1(base) (BME_UBFX8(&LLWU_F3_REG(base), LLWU_F3_MWUF1_SHIFT, LLWU_F3_MWUF1_WIDTH))
/*@}*/

/*!
 * @name Register LLWU_F3, field MWUF2[2] (RO)
 *
 * Indicates that an enabled internal peripheral was a source of exiting a
 * low-leakage power mode. To clear the flag, follow the internal peripheral flag
 * clearing mechanism.
 *
 * Values:
 * - 0 - Module 2 input was not a wakeup source
 * - 1 - Module 2 input was a wakeup source
 */
/*@{*/
/*! @brief Read current value of the LLWU_F3_MWUF2 field. */
#define LLWU_RD_F3_MWUF2(base) ((LLWU_F3_REG(base) & LLWU_F3_MWUF2_MASK) >> LLWU_F3_MWUF2_SHIFT)
#define LLWU_BRD_F3_MWUF2(base) (BME_UBFX8(&LLWU_F3_REG(base), LLWU_F3_MWUF2_SHIFT, LLWU_F3_MWUF2_WIDTH))
/*@}*/

/*!
 * @name Register LLWU_F3, field MWUF3[3] (RO)
 *
 * Indicates that an enabled internal peripheral was a source of exiting a
 * low-leakage power mode. To clear the flag, follow the internal peripheral flag
 * clearing mechanism.
 *
 * Values:
 * - 0 - Module 3 input was not a wakeup source
 * - 1 - Module 3 input was a wakeup source
 */
/*@{*/
/*! @brief Read current value of the LLWU_F3_MWUF3 field. */
#define LLWU_RD_F3_MWUF3(base) ((LLWU_F3_REG(base) & LLWU_F3_MWUF3_MASK) >> LLWU_F3_MWUF3_SHIFT)
#define LLWU_BRD_F3_MWUF3(base) (BME_UBFX8(&LLWU_F3_REG(base), LLWU_F3_MWUF3_SHIFT, LLWU_F3_MWUF3_WIDTH))
/*@}*/

/*!
 * @name Register LLWU_F3, field MWUF4[4] (RO)
 *
 * Indicates that an enabled internal peripheral was a source of exiting a
 * low-leakage power mode. To clear the flag, follow the internal peripheral flag
 * clearing mechanism.
 *
 * Values:
 * - 0 - Module 4 input was not a wakeup source
 * - 1 - Module 4 input was a wakeup source
 */
/*@{*/
/*! @brief Read current value of the LLWU_F3_MWUF4 field. */
#define LLWU_RD_F3_MWUF4(base) ((LLWU_F3_REG(base) & LLWU_F3_MWUF4_MASK) >> LLWU_F3_MWUF4_SHIFT)
#define LLWU_BRD_F3_MWUF4(base) (BME_UBFX8(&LLWU_F3_REG(base), LLWU_F3_MWUF4_SHIFT, LLWU_F3_MWUF4_WIDTH))
/*@}*/

/*!
 * @name Register LLWU_F3, field MWUF5[5] (RO)
 *
 * Indicates that an enabled internal peripheral was a source of exiting a
 * low-leakage power mode. To clear the flag, follow the internal peripheral flag
 * clearing mechanism.
 *
 * Values:
 * - 0 - Module 5 input was not a wakeup source
 * - 1 - Module 5 input was a wakeup source
 */
/*@{*/
/*! @brief Read current value of the LLWU_F3_MWUF5 field. */
#define LLWU_RD_F3_MWUF5(base) ((LLWU_F3_REG(base) & LLWU_F3_MWUF5_MASK) >> LLWU_F3_MWUF5_SHIFT)
#define LLWU_BRD_F3_MWUF5(base) (BME_UBFX8(&LLWU_F3_REG(base), LLWU_F3_MWUF5_SHIFT, LLWU_F3_MWUF5_WIDTH))
/*@}*/

/*!
 * @name Register LLWU_F3, field MWUF6[6] (RO)
 *
 * Indicates that an enabled internal peripheral was a source of exiting a
 * low-leakage power mode. To clear the flag, follow the internal peripheral flag
 * clearing mechanism.
 *
 * Values:
 * - 0 - Module 6 input was not a wakeup source
 * - 1 - Module 6 input was a wakeup source
 */
/*@{*/
/*! @brief Read current value of the LLWU_F3_MWUF6 field. */
#define LLWU_RD_F3_MWUF6(base) ((LLWU_F3_REG(base) & LLWU_F3_MWUF6_MASK) >> LLWU_F3_MWUF6_SHIFT)
#define LLWU_BRD_F3_MWUF6(base) (BME_UBFX8(&LLWU_F3_REG(base), LLWU_F3_MWUF6_SHIFT, LLWU_F3_MWUF6_WIDTH))
/*@}*/

/*!
 * @name Register LLWU_F3, field MWUF7[7] (RO)
 *
 * Indicates that an enabled internal peripheral was a source of exiting a
 * low-leakage power mode. To clear the flag, follow the internal peripheral flag
 * clearing mechanism.
 *
 * Values:
 * - 0 - Module 7 input was not a wakeup source
 * - 1 - Module 7 input was a wakeup source
 */
/*@{*/
/*! @brief Read current value of the LLWU_F3_MWUF7 field. */
#define LLWU_RD_F3_MWUF7(base) ((LLWU_F3_REG(base) & LLWU_F3_MWUF7_MASK) >> LLWU_F3_MWUF7_SHIFT)
#define LLWU_BRD_F3_MWUF7(base) (BME_UBFX8(&LLWU_F3_REG(base), LLWU_F3_MWUF7_SHIFT, LLWU_F3_MWUF7_WIDTH))
/*@}*/

/*******************************************************************************
 * LLWU_FILT1 - LLWU Pin Filter 1 register
 ******************************************************************************/

/*!
 * @brief LLWU_FILT1 - LLWU Pin Filter 1 register (RW)
 *
 * Reset value: 0x00U
 *
 * LLWU_FILT1 is a control and status register that is used to enable/disable
 * the digital filter 1 features for an external pin. This register is reset on
 * Chip Reset not VLLS and by reset types that trigger Chip Reset not VLLS. It is
 * unaffected by reset types that do not trigger Chip Reset not VLLS. See the
 * IntroductionInformation found here describes the registers of the Reset Control
 * Module (RCM). The RCM implements many of the reset functions for the chip. See
 * the chip's reset chapter for more information. details for more information.
 */
/*!
 * @name Constants and macros for entire LLWU_FILT1 register
 */
/*@{*/
#define LLWU_RD_FILT1(base)      (LLWU_FILT1_REG(base))
#define LLWU_WR_FILT1(base, value) (LLWU_FILT1_REG(base) = (value))
#define LLWU_RMW_FILT1(base, mask, value) (LLWU_WR_FILT1(base, (LLWU_RD_FILT1(base) & ~(mask)) | (value)))
#define LLWU_SET_FILT1(base, value) (BME_OR8(&LLWU_FILT1_REG(base), (uint8_t)(value)))
#define LLWU_CLR_FILT1(base, value) (BME_AND8(&LLWU_FILT1_REG(base), (uint8_t)(~(value))))
#define LLWU_TOG_FILT1(base, value) (BME_XOR8(&LLWU_FILT1_REG(base), (uint8_t)(value)))
/*@}*/

/*
 * Constants & macros for individual LLWU_FILT1 bitfields
 */

/*!
 * @name Register LLWU_FILT1, field FILTSEL[3:0] (RW)
 *
 * Selects 1 out of the 16 wakeup pins to be muxed into the filter.
 *
 * Values:
 * - 0000 - Select LLWU_P0 for filter
 * - 1111 - Select LLWU_P15 for filter
 */
/*@{*/
/*! @brief Read current value of the LLWU_FILT1_FILTSEL field. */
#define LLWU_RD_FILT1_FILTSEL(base) ((LLWU_FILT1_REG(base) & LLWU_FILT1_FILTSEL_MASK) >> LLWU_FILT1_FILTSEL_SHIFT)
#define LLWU_BRD_FILT1_FILTSEL(base) (BME_UBFX8(&LLWU_FILT1_REG(base), LLWU_FILT1_FILTSEL_SHIFT, LLWU_FILT1_FILTSEL_WIDTH))

/*! @brief Set the FILTSEL field to a new value. */
#define LLWU_WR_FILT1_FILTSEL(base, value) (LLWU_RMW_FILT1(base, (LLWU_FILT1_FILTSEL_MASK | LLWU_FILT1_FILTF_MASK), LLWU_FILT1_FILTSEL(value)))
#define LLWU_BWR_FILT1_FILTSEL(base, value) (BME_BFI8(&LLWU_FILT1_REG(base), ((uint8_t)(value) << LLWU_FILT1_FILTSEL_SHIFT), LLWU_FILT1_FILTSEL_SHIFT, LLWU_FILT1_FILTSEL_WIDTH))
/*@}*/

/*!
 * @name Register LLWU_FILT1, field FILTE[6:5] (RW)
 *
 * Controls the digital filter options for the external pin detect.
 *
 * Values:
 * - 00 - Filter disabled
 * - 01 - Filter posedge detect enabled
 * - 10 - Filter negedge detect enabled
 * - 11 - Filter any edge detect enabled
 */
/*@{*/
/*! @brief Read current value of the LLWU_FILT1_FILTE field. */
#define LLWU_RD_FILT1_FILTE(base) ((LLWU_FILT1_REG(base) & LLWU_FILT1_FILTE_MASK) >> LLWU_FILT1_FILTE_SHIFT)
#define LLWU_BRD_FILT1_FILTE(base) (BME_UBFX8(&LLWU_FILT1_REG(base), LLWU_FILT1_FILTE_SHIFT, LLWU_FILT1_FILTE_WIDTH))

/*! @brief Set the FILTE field to a new value. */
#define LLWU_WR_FILT1_FILTE(base, value) (LLWU_RMW_FILT1(base, (LLWU_FILT1_FILTE_MASK | LLWU_FILT1_FILTF_MASK), LLWU_FILT1_FILTE(value)))
#define LLWU_BWR_FILT1_FILTE(base, value) (BME_BFI8(&LLWU_FILT1_REG(base), ((uint8_t)(value) << LLWU_FILT1_FILTE_SHIFT), LLWU_FILT1_FILTE_SHIFT, LLWU_FILT1_FILTE_WIDTH))
/*@}*/

/*!
 * @name Register LLWU_FILT1, field FILTF[7] (W1C)
 *
 * Indicates that the filtered external wakeup pin, selected by FILTSEL, was a
 * source of exiting a low-leakage power mode. To clear the flag write a one to
 * FILTF.
 *
 * Values:
 * - 0 - Pin Filter 1 was not a wakeup source
 * - 1 - Pin Filter 1 was a wakeup source
 */
/*@{*/
/*! @brief Read current value of the LLWU_FILT1_FILTF field. */
#define LLWU_RD_FILT1_FILTF(base) ((LLWU_FILT1_REG(base) & LLWU_FILT1_FILTF_MASK) >> LLWU_FILT1_FILTF_SHIFT)
#define LLWU_BRD_FILT1_FILTF(base) (BME_UBFX8(&LLWU_FILT1_REG(base), LLWU_FILT1_FILTF_SHIFT, LLWU_FILT1_FILTF_WIDTH))

/*! @brief Set the FILTF field to a new value. */
#define LLWU_WR_FILT1_FILTF(base, value) (LLWU_RMW_FILT1(base, LLWU_FILT1_FILTF_MASK, LLWU_FILT1_FILTF(value)))
#define LLWU_BWR_FILT1_FILTF(base, value) (BME_BFI8(&LLWU_FILT1_REG(base), ((uint8_t)(value) << LLWU_FILT1_FILTF_SHIFT), LLWU_FILT1_FILTF_SHIFT, LLWU_FILT1_FILTF_WIDTH))
/*@}*/

/*******************************************************************************
 * LLWU_FILT2 - LLWU Pin Filter 2 register
 ******************************************************************************/

/*!
 * @brief LLWU_FILT2 - LLWU Pin Filter 2 register (RW)
 *
 * Reset value: 0x00U
 *
 * LLWU_FILT2 is a control and status register that is used to enable/disable
 * the digital filter 2 features for an external pin. This register is reset on
 * Chip Reset not VLLS and by reset types that trigger Chip Reset not VLLS. It is
 * unaffected by reset types that do not trigger Chip Reset not VLLS. See the
 * IntroductionInformation found here describes the registers of the Reset Control
 * Module (RCM). The RCM implements many of the reset functions for the chip. See
 * the chip's reset chapter for more information. details for more information.
 */
/*!
 * @name Constants and macros for entire LLWU_FILT2 register
 */
/*@{*/
#define LLWU_RD_FILT2(base)      (LLWU_FILT2_REG(base))
#define LLWU_WR_FILT2(base, value) (LLWU_FILT2_REG(base) = (value))
#define LLWU_RMW_FILT2(base, mask, value) (LLWU_WR_FILT2(base, (LLWU_RD_FILT2(base) & ~(mask)) | (value)))
#define LLWU_SET_FILT2(base, value) (BME_OR8(&LLWU_FILT2_REG(base), (uint8_t)(value)))
#define LLWU_CLR_FILT2(base, value) (BME_AND8(&LLWU_FILT2_REG(base), (uint8_t)(~(value))))
#define LLWU_TOG_FILT2(base, value) (BME_XOR8(&LLWU_FILT2_REG(base), (uint8_t)(value)))
/*@}*/

/*
 * Constants & macros for individual LLWU_FILT2 bitfields
 */

/*!
 * @name Register LLWU_FILT2, field FILTSEL[3:0] (RW)
 *
 * Selects 1 out of the 16 wakeup pins to be muxed into the filter.
 *
 * Values:
 * - 0000 - Select LLWU_P0 for filter
 * - 1111 - Select LLWU_P15 for filter
 */
/*@{*/
/*! @brief Read current value of the LLWU_FILT2_FILTSEL field. */
#define LLWU_RD_FILT2_FILTSEL(base) ((LLWU_FILT2_REG(base) & LLWU_FILT2_FILTSEL_MASK) >> LLWU_FILT2_FILTSEL_SHIFT)
#define LLWU_BRD_FILT2_FILTSEL(base) (BME_UBFX8(&LLWU_FILT2_REG(base), LLWU_FILT2_FILTSEL_SHIFT, LLWU_FILT2_FILTSEL_WIDTH))

/*! @brief Set the FILTSEL field to a new value. */
#define LLWU_WR_FILT2_FILTSEL(base, value) (LLWU_RMW_FILT2(base, (LLWU_FILT2_FILTSEL_MASK | LLWU_FILT2_FILTF_MASK), LLWU_FILT2_FILTSEL(value)))
#define LLWU_BWR_FILT2_FILTSEL(base, value) (BME_BFI8(&LLWU_FILT2_REG(base), ((uint8_t)(value) << LLWU_FILT2_FILTSEL_SHIFT), LLWU_FILT2_FILTSEL_SHIFT, LLWU_FILT2_FILTSEL_WIDTH))
/*@}*/

/*!
 * @name Register LLWU_FILT2, field FILTE[6:5] (RW)
 *
 * Controls the digital filter options for the external pin detect.
 *
 * Values:
 * - 00 - Filter disabled
 * - 01 - Filter posedge detect enabled
 * - 10 - Filter negedge detect enabled
 * - 11 - Filter any edge detect enabled
 */
/*@{*/
/*! @brief Read current value of the LLWU_FILT2_FILTE field. */
#define LLWU_RD_FILT2_FILTE(base) ((LLWU_FILT2_REG(base) & LLWU_FILT2_FILTE_MASK) >> LLWU_FILT2_FILTE_SHIFT)
#define LLWU_BRD_FILT2_FILTE(base) (BME_UBFX8(&LLWU_FILT2_REG(base), LLWU_FILT2_FILTE_SHIFT, LLWU_FILT2_FILTE_WIDTH))

/*! @brief Set the FILTE field to a new value. */
#define LLWU_WR_FILT2_FILTE(base, value) (LLWU_RMW_FILT2(base, (LLWU_FILT2_FILTE_MASK | LLWU_FILT2_FILTF_MASK), LLWU_FILT2_FILTE(value)))
#define LLWU_BWR_FILT2_FILTE(base, value) (BME_BFI8(&LLWU_FILT2_REG(base), ((uint8_t)(value) << LLWU_FILT2_FILTE_SHIFT), LLWU_FILT2_FILTE_SHIFT, LLWU_FILT2_FILTE_WIDTH))
/*@}*/

/*!
 * @name Register LLWU_FILT2, field FILTF[7] (W1C)
 *
 * Indicates that the filtered external wakeup pin, selected by FILTSEL, was a
 * source of exiting a low-leakage power mode. To clear the flag write a one to
 * FILTF.
 *
 * Values:
 * - 0 - Pin Filter 2 was not a wakeup source
 * - 1 - Pin Filter 2 was a wakeup source
 */
/*@{*/
/*! @brief Read current value of the LLWU_FILT2_FILTF field. */
#define LLWU_RD_FILT2_FILTF(base) ((LLWU_FILT2_REG(base) & LLWU_FILT2_FILTF_MASK) >> LLWU_FILT2_FILTF_SHIFT)
#define LLWU_BRD_FILT2_FILTF(base) (BME_UBFX8(&LLWU_FILT2_REG(base), LLWU_FILT2_FILTF_SHIFT, LLWU_FILT2_FILTF_WIDTH))

/*! @brief Set the FILTF field to a new value. */
#define LLWU_WR_FILT2_FILTF(base, value) (LLWU_RMW_FILT2(base, LLWU_FILT2_FILTF_MASK, LLWU_FILT2_FILTF(value)))
#define LLWU_BWR_FILT2_FILTF(base, value) (BME_BFI8(&LLWU_FILT2_REG(base), ((uint8_t)(value) << LLWU_FILT2_FILTF_SHIFT), LLWU_FILT2_FILTF_SHIFT, LLWU_FILT2_FILTF_WIDTH))
/*@}*/

/*
 * MKL27Z644 LPTMR
 *
 * Low Power Timer
 *
 * Registers defined in this header file:
 * - LPTMR_CSR - Low Power Timer Control Status Register
 * - LPTMR_PSR - Low Power Timer Prescale Register
 * - LPTMR_CMR - Low Power Timer Compare Register
 * - LPTMR_CNR - Low Power Timer Counter Register
 */

#define LPTMR_INSTANCE_COUNT (1U) /*!< Number of instances of the LPTMR module. */
#define LPTMR0_IDX (0U) /*!< Instance number for LPTMR0. */

/*******************************************************************************
 * LPTMR_CSR - Low Power Timer Control Status Register
 ******************************************************************************/

/*!
 * @brief LPTMR_CSR - Low Power Timer Control Status Register (RW)
 *
 * Reset value: 0x00000000U
 */
/*!
 * @name Constants and macros for entire LPTMR_CSR register
 */
/*@{*/
#define LPTMR_RD_CSR(base)       (LPTMR_CSR_REG(base))
#define LPTMR_WR_CSR(base, value) (LPTMR_CSR_REG(base) = (value))
#define LPTMR_RMW_CSR(base, mask, value) (LPTMR_WR_CSR(base, (LPTMR_RD_CSR(base) & ~(mask)) | (value)))
#define LPTMR_SET_CSR(base, value) (BME_OR32(&LPTMR_CSR_REG(base), (uint32_t)(value)))
#define LPTMR_CLR_CSR(base, value) (BME_AND32(&LPTMR_CSR_REG(base), (uint32_t)(~(value))))
#define LPTMR_TOG_CSR(base, value) (BME_XOR32(&LPTMR_CSR_REG(base), (uint32_t)(value)))
/*@}*/

/*
 * Constants & macros for individual LPTMR_CSR bitfields
 */

/*!
 * @name Register LPTMR_CSR, field TEN[0] (RW)
 *
 * When TEN is clear, it resets the LPTMR internal logic, including the CNR and
 * TCF. When TEN is set, the LPTMR is enabled. While writing 1 to this field,
 * CSR[5:1] must not be altered.
 *
 * Values:
 * - 0 - LPTMR is disabled and internal logic is reset.
 * - 1 - LPTMR is enabled.
 */
/*@{*/
/*! @brief Read current value of the LPTMR_CSR_TEN field. */
#define LPTMR_RD_CSR_TEN(base) ((LPTMR_CSR_REG(base) & LPTMR_CSR_TEN_MASK) >> LPTMR_CSR_TEN_SHIFT)
#define LPTMR_BRD_CSR_TEN(base) (BME_UBFX32(&LPTMR_CSR_REG(base), LPTMR_CSR_TEN_SHIFT, LPTMR_CSR_TEN_WIDTH))

/*! @brief Set the TEN field to a new value. */
#define LPTMR_WR_CSR_TEN(base, value) (LPTMR_RMW_CSR(base, (LPTMR_CSR_TEN_MASK | LPTMR_CSR_TCF_MASK), LPTMR_CSR_TEN(value)))
#define LPTMR_BWR_CSR_TEN(base, value) (BME_BFI32(&LPTMR_CSR_REG(base), ((uint32_t)(value) << LPTMR_CSR_TEN_SHIFT), LPTMR_CSR_TEN_SHIFT, LPTMR_CSR_TEN_WIDTH))
/*@}*/

/*!
 * @name Register LPTMR_CSR, field TMS[1] (RW)
 *
 * Configures the mode of the LPTMR. TMS must be altered only when the LPTMR is
 * disabled.
 *
 * Values:
 * - 0 - Time Counter mode.
 * - 1 - Pulse Counter mode.
 */
/*@{*/
/*! @brief Read current value of the LPTMR_CSR_TMS field. */
#define LPTMR_RD_CSR_TMS(base) ((LPTMR_CSR_REG(base) & LPTMR_CSR_TMS_MASK) >> LPTMR_CSR_TMS_SHIFT)
#define LPTMR_BRD_CSR_TMS(base) (BME_UBFX32(&LPTMR_CSR_REG(base), LPTMR_CSR_TMS_SHIFT, LPTMR_CSR_TMS_WIDTH))

/*! @brief Set the TMS field to a new value. */
#define LPTMR_WR_CSR_TMS(base, value) (LPTMR_RMW_CSR(base, (LPTMR_CSR_TMS_MASK | LPTMR_CSR_TCF_MASK), LPTMR_CSR_TMS(value)))
#define LPTMR_BWR_CSR_TMS(base, value) (BME_BFI32(&LPTMR_CSR_REG(base), ((uint32_t)(value) << LPTMR_CSR_TMS_SHIFT), LPTMR_CSR_TMS_SHIFT, LPTMR_CSR_TMS_WIDTH))
/*@}*/

/*!
 * @name Register LPTMR_CSR, field TFC[2] (RW)
 *
 * When clear, TFC configures the CNR to reset whenever TCF is set. When set,
 * TFC configures the CNR to reset on overflow. TFC must be altered only when the
 * LPTMR is disabled.
 *
 * Values:
 * - 0 - CNR is reset whenever TCF is set.
 * - 1 - CNR is reset on overflow.
 */
/*@{*/
/*! @brief Read current value of the LPTMR_CSR_TFC field. */
#define LPTMR_RD_CSR_TFC(base) ((LPTMR_CSR_REG(base) & LPTMR_CSR_TFC_MASK) >> LPTMR_CSR_TFC_SHIFT)
#define LPTMR_BRD_CSR_TFC(base) (BME_UBFX32(&LPTMR_CSR_REG(base), LPTMR_CSR_TFC_SHIFT, LPTMR_CSR_TFC_WIDTH))

/*! @brief Set the TFC field to a new value. */
#define LPTMR_WR_CSR_TFC(base, value) (LPTMR_RMW_CSR(base, (LPTMR_CSR_TFC_MASK | LPTMR_CSR_TCF_MASK), LPTMR_CSR_TFC(value)))
#define LPTMR_BWR_CSR_TFC(base, value) (BME_BFI32(&LPTMR_CSR_REG(base), ((uint32_t)(value) << LPTMR_CSR_TFC_SHIFT), LPTMR_CSR_TFC_SHIFT, LPTMR_CSR_TFC_WIDTH))
/*@}*/

/*!
 * @name Register LPTMR_CSR, field TPP[3] (RW)
 *
 * Configures the polarity of the input source in Pulse Counter mode. TPP must
 * be changed only when the LPTMR is disabled.
 *
 * Values:
 * - 0 - Pulse Counter input source is active-high, and the CNR will increment
 *     on the rising-edge.
 * - 1 - Pulse Counter input source is active-low, and the CNR will increment on
 *     the falling-edge.
 */
/*@{*/
/*! @brief Read current value of the LPTMR_CSR_TPP field. */
#define LPTMR_RD_CSR_TPP(base) ((LPTMR_CSR_REG(base) & LPTMR_CSR_TPP_MASK) >> LPTMR_CSR_TPP_SHIFT)
#define LPTMR_BRD_CSR_TPP(base) (BME_UBFX32(&LPTMR_CSR_REG(base), LPTMR_CSR_TPP_SHIFT, LPTMR_CSR_TPP_WIDTH))

/*! @brief Set the TPP field to a new value. */
#define LPTMR_WR_CSR_TPP(base, value) (LPTMR_RMW_CSR(base, (LPTMR_CSR_TPP_MASK | LPTMR_CSR_TCF_MASK), LPTMR_CSR_TPP(value)))
#define LPTMR_BWR_CSR_TPP(base, value) (BME_BFI32(&LPTMR_CSR_REG(base), ((uint32_t)(value) << LPTMR_CSR_TPP_SHIFT), LPTMR_CSR_TPP_SHIFT, LPTMR_CSR_TPP_WIDTH))
/*@}*/

/*!
 * @name Register LPTMR_CSR, field TPS[5:4] (RW)
 *
 * Configures the input source to be used in Pulse Counter mode. TPS must be
 * altered only when the LPTMR is disabled. The input connections vary by device.
 * See the for information on the connections to these inputs.
 *
 * Values:
 * - 00 - Pulse counter input 0 is selected.
 * - 01 - Pulse counter input 1 is selected.
 * - 10 - Pulse counter input 2 is selected.
 * - 11 - Pulse counter input 3 is selected.
 */
/*@{*/
/*! @brief Read current value of the LPTMR_CSR_TPS field. */
#define LPTMR_RD_CSR_TPS(base) ((LPTMR_CSR_REG(base) & LPTMR_CSR_TPS_MASK) >> LPTMR_CSR_TPS_SHIFT)
#define LPTMR_BRD_CSR_TPS(base) (BME_UBFX32(&LPTMR_CSR_REG(base), LPTMR_CSR_TPS_SHIFT, LPTMR_CSR_TPS_WIDTH))

/*! @brief Set the TPS field to a new value. */
#define LPTMR_WR_CSR_TPS(base, value) (LPTMR_RMW_CSR(base, (LPTMR_CSR_TPS_MASK | LPTMR_CSR_TCF_MASK), LPTMR_CSR_TPS(value)))
#define LPTMR_BWR_CSR_TPS(base, value) (BME_BFI32(&LPTMR_CSR_REG(base), ((uint32_t)(value) << LPTMR_CSR_TPS_SHIFT), LPTMR_CSR_TPS_SHIFT, LPTMR_CSR_TPS_WIDTH))
/*@}*/

/*!
 * @name Register LPTMR_CSR, field TIE[6] (RW)
 *
 * When TIE is set, the LPTMR Interrupt is generated whenever TCF is also set.
 *
 * Values:
 * - 0 - Timer interrupt disabled.
 * - 1 - Timer interrupt enabled.
 */
/*@{*/
/*! @brief Read current value of the LPTMR_CSR_TIE field. */
#define LPTMR_RD_CSR_TIE(base) ((LPTMR_CSR_REG(base) & LPTMR_CSR_TIE_MASK) >> LPTMR_CSR_TIE_SHIFT)
#define LPTMR_BRD_CSR_TIE(base) (BME_UBFX32(&LPTMR_CSR_REG(base), LPTMR_CSR_TIE_SHIFT, LPTMR_CSR_TIE_WIDTH))

/*! @brief Set the TIE field to a new value. */
#define LPTMR_WR_CSR_TIE(base, value) (LPTMR_RMW_CSR(base, (LPTMR_CSR_TIE_MASK | LPTMR_CSR_TCF_MASK), LPTMR_CSR_TIE(value)))
#define LPTMR_BWR_CSR_TIE(base, value) (BME_BFI32(&LPTMR_CSR_REG(base), ((uint32_t)(value) << LPTMR_CSR_TIE_SHIFT), LPTMR_CSR_TIE_SHIFT, LPTMR_CSR_TIE_WIDTH))
/*@}*/

/*!
 * @name Register LPTMR_CSR, field TCF[7] (W1C)
 *
 * TCF is set when the LPTMR is enabled and the CNR equals the CMR and
 * increments. TCF is cleared when the LPTMR is disabled or a logic 1 is written to it.
 *
 * Values:
 * - 0 - The value of CNR is not equal to CMR and increments.
 * - 1 - The value of CNR is equal to CMR and increments.
 */
/*@{*/
/*! @brief Read current value of the LPTMR_CSR_TCF field. */
#define LPTMR_RD_CSR_TCF(base) ((LPTMR_CSR_REG(base) & LPTMR_CSR_TCF_MASK) >> LPTMR_CSR_TCF_SHIFT)
#define LPTMR_BRD_CSR_TCF(base) (BME_UBFX32(&LPTMR_CSR_REG(base), LPTMR_CSR_TCF_SHIFT, LPTMR_CSR_TCF_WIDTH))

/*! @brief Set the TCF field to a new value. */
#define LPTMR_WR_CSR_TCF(base, value) (LPTMR_RMW_CSR(base, LPTMR_CSR_TCF_MASK, LPTMR_CSR_TCF(value)))
#define LPTMR_BWR_CSR_TCF(base, value) (BME_BFI32(&LPTMR_CSR_REG(base), ((uint32_t)(value) << LPTMR_CSR_TCF_SHIFT), LPTMR_CSR_TCF_SHIFT, LPTMR_CSR_TCF_WIDTH))
/*@}*/

/*******************************************************************************
 * LPTMR_PSR - Low Power Timer Prescale Register
 ******************************************************************************/

/*!
 * @brief LPTMR_PSR - Low Power Timer Prescale Register (RW)
 *
 * Reset value: 0x00000000U
 */
/*!
 * @name Constants and macros for entire LPTMR_PSR register
 */
/*@{*/
#define LPTMR_RD_PSR(base)       (LPTMR_PSR_REG(base))
#define LPTMR_WR_PSR(base, value) (LPTMR_PSR_REG(base) = (value))
#define LPTMR_RMW_PSR(base, mask, value) (LPTMR_WR_PSR(base, (LPTMR_RD_PSR(base) & ~(mask)) | (value)))
#define LPTMR_SET_PSR(base, value) (BME_OR32(&LPTMR_PSR_REG(base), (uint32_t)(value)))
#define LPTMR_CLR_PSR(base, value) (BME_AND32(&LPTMR_PSR_REG(base), (uint32_t)(~(value))))
#define LPTMR_TOG_PSR(base, value) (BME_XOR32(&LPTMR_PSR_REG(base), (uint32_t)(value)))
/*@}*/

/*
 * Constants & macros for individual LPTMR_PSR bitfields
 */

/*!
 * @name Register LPTMR_PSR, field PCS[1:0] (RW)
 *
 * Selects the clock to be used by the LPTMR prescaler/glitch filter. PCS must
 * be altered only when the LPTMR is disabled. The clock connections vary by
 * device. See the chip configuration details for information on the connections to
 * these inputs.
 *
 * Values:
 * - 00 - Prescaler/glitch filter clock 0 selected.
 * - 01 - Prescaler/glitch filter clock 1 selected.
 * - 10 - Prescaler/glitch filter clock 2 selected.
 * - 11 - Prescaler/glitch filter clock 3 selected.
 */
/*@{*/
/*! @brief Read current value of the LPTMR_PSR_PCS field. */
#define LPTMR_RD_PSR_PCS(base) ((LPTMR_PSR_REG(base) & LPTMR_PSR_PCS_MASK) >> LPTMR_PSR_PCS_SHIFT)
#define LPTMR_BRD_PSR_PCS(base) (BME_UBFX32(&LPTMR_PSR_REG(base), LPTMR_PSR_PCS_SHIFT, LPTMR_PSR_PCS_WIDTH))

/*! @brief Set the PCS field to a new value. */
#define LPTMR_WR_PSR_PCS(base, value) (LPTMR_RMW_PSR(base, LPTMR_PSR_PCS_MASK, LPTMR_PSR_PCS(value)))
#define LPTMR_BWR_PSR_PCS(base, value) (BME_BFI32(&LPTMR_PSR_REG(base), ((uint32_t)(value) << LPTMR_PSR_PCS_SHIFT), LPTMR_PSR_PCS_SHIFT, LPTMR_PSR_PCS_WIDTH))
/*@}*/

/*!
 * @name Register LPTMR_PSR, field PBYP[2] (RW)
 *
 * When PBYP is set, the selected prescaler clock in Time Counter mode or
 * selected input source in Pulse Counter mode directly clocks the CNR. When PBYP is
 * clear, the CNR is clocked by the output of the prescaler/glitch filter. PBYP
 * must be altered only when the LPTMR is disabled.
 *
 * Values:
 * - 0 - Prescaler/glitch filter is enabled.
 * - 1 - Prescaler/glitch filter is bypassed.
 */
/*@{*/
/*! @brief Read current value of the LPTMR_PSR_PBYP field. */
#define LPTMR_RD_PSR_PBYP(base) ((LPTMR_PSR_REG(base) & LPTMR_PSR_PBYP_MASK) >> LPTMR_PSR_PBYP_SHIFT)
#define LPTMR_BRD_PSR_PBYP(base) (BME_UBFX32(&LPTMR_PSR_REG(base), LPTMR_PSR_PBYP_SHIFT, LPTMR_PSR_PBYP_WIDTH))

/*! @brief Set the PBYP field to a new value. */
#define LPTMR_WR_PSR_PBYP(base, value) (LPTMR_RMW_PSR(base, LPTMR_PSR_PBYP_MASK, LPTMR_PSR_PBYP(value)))
#define LPTMR_BWR_PSR_PBYP(base, value) (BME_BFI32(&LPTMR_PSR_REG(base), ((uint32_t)(value) << LPTMR_PSR_PBYP_SHIFT), LPTMR_PSR_PBYP_SHIFT, LPTMR_PSR_PBYP_WIDTH))
/*@}*/

/*!
 * @name Register LPTMR_PSR, field PRESCALE[6:3] (RW)
 *
 * Configures the size of the Prescaler in Time Counter mode or width of the
 * glitch filter in Pulse Counter mode. PRESCALE must be altered only when the LPTMR
 * is disabled.
 *
 * Values:
 * - 0000 - Prescaler divides the prescaler clock by 2; glitch filter does not
 *     support this configuration.
 * - 0001 - Prescaler divides the prescaler clock by 4; glitch filter recognizes
 *     change on input pin after 2 rising clock edges.
 * - 0010 - Prescaler divides the prescaler clock by 8; glitch filter recognizes
 *     change on input pin after 4 rising clock edges.
 * - 0011 - Prescaler divides the prescaler clock by 16; glitch filter
 *     recognizes change on input pin after 8 rising clock edges.
 * - 0100 - Prescaler divides the prescaler clock by 32; glitch filter
 *     recognizes change on input pin after 16 rising clock edges.
 * - 0101 - Prescaler divides the prescaler clock by 64; glitch filter
 *     recognizes change on input pin after 32 rising clock edges.
 * - 0110 - Prescaler divides the prescaler clock by 128; glitch filter
 *     recognizes change on input pin after 64 rising clock edges.
 * - 0111 - Prescaler divides the prescaler clock by 256; glitch filter
 *     recognizes change on input pin after 128 rising clock edges.
 * - 1000 - Prescaler divides the prescaler clock by 512; glitch filter
 *     recognizes change on input pin after 256 rising clock edges.
 * - 1001 - Prescaler divides the prescaler clock by 1024; glitch filter
 *     recognizes change on input pin after 512 rising clock edges.
 * - 1010 - Prescaler divides the prescaler clock by 2048; glitch filter
 *     recognizes change on input pin after 1024 rising clock edges.
 * - 1011 - Prescaler divides the prescaler clock by 4096; glitch filter
 *     recognizes change on input pin after 2048 rising clock edges.
 * - 1100 - Prescaler divides the prescaler clock by 8192; glitch filter
 *     recognizes change on input pin after 4096 rising clock edges.
 * - 1101 - Prescaler divides the prescaler clock by 16,384; glitch filter
 *     recognizes change on input pin after 8192 rising clock edges.
 * - 1110 - Prescaler divides the prescaler clock by 32,768; glitch filter
 *     recognizes change on input pin after 16,384 rising clock edges.
 * - 1111 - Prescaler divides the prescaler clock by 65,536; glitch filter
 *     recognizes change on input pin after 32,768 rising clock edges.
 */
/*@{*/
/*! @brief Read current value of the LPTMR_PSR_PRESCALE field. */
#define LPTMR_RD_PSR_PRESCALE(base) ((LPTMR_PSR_REG(base) & LPTMR_PSR_PRESCALE_MASK) >> LPTMR_PSR_PRESCALE_SHIFT)
#define LPTMR_BRD_PSR_PRESCALE(base) (BME_UBFX32(&LPTMR_PSR_REG(base), LPTMR_PSR_PRESCALE_SHIFT, LPTMR_PSR_PRESCALE_WIDTH))

/*! @brief Set the PRESCALE field to a new value. */
#define LPTMR_WR_PSR_PRESCALE(base, value) (LPTMR_RMW_PSR(base, LPTMR_PSR_PRESCALE_MASK, LPTMR_PSR_PRESCALE(value)))
#define LPTMR_BWR_PSR_PRESCALE(base, value) (BME_BFI32(&LPTMR_PSR_REG(base), ((uint32_t)(value) << LPTMR_PSR_PRESCALE_SHIFT), LPTMR_PSR_PRESCALE_SHIFT, LPTMR_PSR_PRESCALE_WIDTH))
/*@}*/

/*******************************************************************************
 * LPTMR_CMR - Low Power Timer Compare Register
 ******************************************************************************/

/*!
 * @brief LPTMR_CMR - Low Power Timer Compare Register (RW)
 *
 * Reset value: 0x00000000U
 */
/*!
 * @name Constants and macros for entire LPTMR_CMR register
 */
/*@{*/
#define LPTMR_RD_CMR(base)       (LPTMR_CMR_REG(base))
#define LPTMR_WR_CMR(base, value) (LPTMR_CMR_REG(base) = (value))
#define LPTMR_RMW_CMR(base, mask, value) (LPTMR_WR_CMR(base, (LPTMR_RD_CMR(base) & ~(mask)) | (value)))
#define LPTMR_SET_CMR(base, value) (BME_OR32(&LPTMR_CMR_REG(base), (uint32_t)(value)))
#define LPTMR_CLR_CMR(base, value) (BME_AND32(&LPTMR_CMR_REG(base), (uint32_t)(~(value))))
#define LPTMR_TOG_CMR(base, value) (BME_XOR32(&LPTMR_CMR_REG(base), (uint32_t)(value)))
/*@}*/

/*
 * Constants & macros for individual LPTMR_CMR bitfields
 */

/*!
 * @name Register LPTMR_CMR, field COMPARE[15:0] (RW)
 *
 * When the LPTMR is enabled and the CNR equals the value in the CMR and
 * increments, TCF is set and the hardware trigger asserts until the next time the CNR
 * increments. If the CMR is 0, the hardware trigger will remain asserted until
 * the LPTMR is disabled. If the LPTMR is enabled, the CMR must be altered only
 * when TCF is set.
 */
/*@{*/
/*! @brief Read current value of the LPTMR_CMR_COMPARE field. */
#define LPTMR_RD_CMR_COMPARE(base) ((LPTMR_CMR_REG(base) & LPTMR_CMR_COMPARE_MASK) >> LPTMR_CMR_COMPARE_SHIFT)
#define LPTMR_BRD_CMR_COMPARE(base) (BME_UBFX32(&LPTMR_CMR_REG(base), LPTMR_CMR_COMPARE_SHIFT, LPTMR_CMR_COMPARE_WIDTH))

/*! @brief Set the COMPARE field to a new value. */
#define LPTMR_WR_CMR_COMPARE(base, value) (LPTMR_RMW_CMR(base, LPTMR_CMR_COMPARE_MASK, LPTMR_CMR_COMPARE(value)))
#define LPTMR_BWR_CMR_COMPARE(base, value) (BME_BFI32(&LPTMR_CMR_REG(base), ((uint32_t)(value) << LPTMR_CMR_COMPARE_SHIFT), LPTMR_CMR_COMPARE_SHIFT, LPTMR_CMR_COMPARE_WIDTH))
/*@}*/

/*******************************************************************************
 * LPTMR_CNR - Low Power Timer Counter Register
 ******************************************************************************/

/*!
 * @brief LPTMR_CNR - Low Power Timer Counter Register (RW)
 *
 * Reset value: 0x00000000U
 */
/*!
 * @name Constants and macros for entire LPTMR_CNR register
 */
/*@{*/
#define LPTMR_RD_CNR(base)       (LPTMR_CNR_REG(base))
#define LPTMR_WR_CNR(base, value) (LPTMR_CNR_REG(base) = (value))
#define LPTMR_RMW_CNR(base, mask, value) (LPTMR_WR_CNR(base, (LPTMR_RD_CNR(base) & ~(mask)) | (value)))
#define LPTMR_SET_CNR(base, value) (BME_OR32(&LPTMR_CNR_REG(base), (uint32_t)(value)))
#define LPTMR_CLR_CNR(base, value) (BME_AND32(&LPTMR_CNR_REG(base), (uint32_t)(~(value))))
#define LPTMR_TOG_CNR(base, value) (BME_XOR32(&LPTMR_CNR_REG(base), (uint32_t)(value)))
/*@}*/

/*
 * Constants & macros for individual LPTMR_CNR bitfields
 */

/*!
 * @name Register LPTMR_CNR, field COUNTER[15:0] (RW)
 *
 * The CNR returns the value of the LPTMR counter at the time this register was
 * last written. Writing the CNR will latch the current value of the LPTMR for
 * subsequent resets, the value written is ignored.
 */
/*@{*/
/*! @brief Read current value of the LPTMR_CNR_COUNTER field. */
#define LPTMR_RD_CNR_COUNTER(base) ((LPTMR_CNR_REG(base) & LPTMR_CNR_COUNTER_MASK) >> LPTMR_CNR_COUNTER_SHIFT)
#define LPTMR_BRD_CNR_COUNTER(base) (BME_UBFX32(&LPTMR_CNR_REG(base), LPTMR_CNR_COUNTER_SHIFT, LPTMR_CNR_COUNTER_WIDTH))

/*! @brief Set the COUNTER field to a new value. */
#define LPTMR_WR_CNR_COUNTER(base, value) (LPTMR_RMW_CNR(base, LPTMR_CNR_COUNTER_MASK, LPTMR_CNR_COUNTER(value)))
#define LPTMR_BWR_CNR_COUNTER(base, value) (BME_BFI32(&LPTMR_CNR_REG(base), ((uint32_t)(value) << LPTMR_CNR_COUNTER_SHIFT), LPTMR_CNR_COUNTER_SHIFT, LPTMR_CNR_COUNTER_WIDTH))
/*@}*/

/*
 * MKL27Z644 LPUART
 *
 * Universal Asynchronous Receiver/Transmitter
 *
 * Registers defined in this header file:
 * - LPUART_BAUD - LPUART Baud Rate Register
 * - LPUART_STAT - LPUART Status Register
 * - LPUART_CTRL - LPUART Control Register
 * - LPUART_DATA - LPUART Data Register
 * - LPUART_MATCH - LPUART Match Address Register
 */

#define LPUART_INSTANCE_COUNT (2U) /*!< Number of instances of the LPUART module. */
#define LPUART0_IDX (0U) /*!< Instance number for LPUART0. */
#define LPUART1_IDX (1U) /*!< Instance number for LPUART1. */

/*******************************************************************************
 * LPUART_BAUD - LPUART Baud Rate Register
 ******************************************************************************/

/*!
 * @brief LPUART_BAUD - LPUART Baud Rate Register (RW)
 *
 * Reset value: 0x0F000004U
 */
/*!
 * @name Constants and macros for entire LPUART_BAUD register
 */
/*@{*/
#define LPUART_RD_BAUD(base)     (LPUART_BAUD_REG(base))
#define LPUART_WR_BAUD(base, value) (LPUART_BAUD_REG(base) = (value))
#define LPUART_RMW_BAUD(base, mask, value) (LPUART_WR_BAUD(base, (LPUART_RD_BAUD(base) & ~(mask)) | (value)))
#define LPUART_SET_BAUD(base, value) (BME_OR32(&LPUART_BAUD_REG(base), (uint32_t)(value)))
#define LPUART_CLR_BAUD(base, value) (BME_AND32(&LPUART_BAUD_REG(base), (uint32_t)(~(value))))
#define LPUART_TOG_BAUD(base, value) (BME_XOR32(&LPUART_BAUD_REG(base), (uint32_t)(value)))
/*@}*/

/*
 * Constants & macros for individual LPUART_BAUD bitfields
 */

/*!
 * @name Register LPUART_BAUD, field SBR[12:0] (RW)
 *
 * The 13 bits in SBR[12:0] set the modulo divide rate for the baud rate
 * generator. When SBR is 1 - 8191, the baud rate equals "baud clock / ((OSR+1) * SBR)".
 * The 13-bit baud rate setting [SBR12:SBR0] must only be updated when the
 * transmitter and receiver are both disabled (LPUART_CTRL[RE] and LPUART_CTRL[TE] are
 * both 0).
 */
/*@{*/
/*! @brief Read current value of the LPUART_BAUD_SBR field. */
#define LPUART_RD_BAUD_SBR(base) ((LPUART_BAUD_REG(base) & LPUART_BAUD_SBR_MASK) >> LPUART_BAUD_SBR_SHIFT)
#define LPUART_BRD_BAUD_SBR(base) (BME_UBFX32(&LPUART_BAUD_REG(base), LPUART_BAUD_SBR_SHIFT, LPUART_BAUD_SBR_WIDTH))

/*! @brief Set the SBR field to a new value. */
#define LPUART_WR_BAUD_SBR(base, value) (LPUART_RMW_BAUD(base, LPUART_BAUD_SBR_MASK, LPUART_BAUD_SBR(value)))
#define LPUART_BWR_BAUD_SBR(base, value) (BME_BFI32(&LPUART_BAUD_REG(base), ((uint32_t)(value) << LPUART_BAUD_SBR_SHIFT), LPUART_BAUD_SBR_SHIFT, LPUART_BAUD_SBR_WIDTH))
/*@}*/

/*!
 * @name Register LPUART_BAUD, field SBNS[13] (RW)
 *
 * SBNS determines whether data characters are one or two stop bits. This bit
 * should only be changed when the transmitter and receiver are both disabled.
 *
 * Values:
 * - 0 - One stop bit.
 * - 1 - Two stop bits.
 */
/*@{*/
/*! @brief Read current value of the LPUART_BAUD_SBNS field. */
#define LPUART_RD_BAUD_SBNS(base) ((LPUART_BAUD_REG(base) & LPUART_BAUD_SBNS_MASK) >> LPUART_BAUD_SBNS_SHIFT)
#define LPUART_BRD_BAUD_SBNS(base) (BME_UBFX32(&LPUART_BAUD_REG(base), LPUART_BAUD_SBNS_SHIFT, LPUART_BAUD_SBNS_WIDTH))

/*! @brief Set the SBNS field to a new value. */
#define LPUART_WR_BAUD_SBNS(base, value) (LPUART_RMW_BAUD(base, LPUART_BAUD_SBNS_MASK, LPUART_BAUD_SBNS(value)))
#define LPUART_BWR_BAUD_SBNS(base, value) (BME_BFI32(&LPUART_BAUD_REG(base), ((uint32_t)(value) << LPUART_BAUD_SBNS_SHIFT), LPUART_BAUD_SBNS_SHIFT, LPUART_BAUD_SBNS_WIDTH))
/*@}*/

/*!
 * @name Register LPUART_BAUD, field RXEDGIE[14] (RW)
 *
 * Enables the receive input active edge, RXEDGIF, to generate interrupt
 * requests. Changing CTRL[LOOP] or CTRL[RSRC] when RXEDGIE is set can cause the RXEDGIF
 * to set.
 *
 * Values:
 * - 0 - Hardware interrupts from LPUART_STAT[RXEDGIF] disabled (use polling).
 * - 1 - Hardware interrupt requested when LPUART_STAT[RXEDGIF] flag is 1.
 */
/*@{*/
/*! @brief Read current value of the LPUART_BAUD_RXEDGIE field. */
#define LPUART_RD_BAUD_RXEDGIE(base) ((LPUART_BAUD_REG(base) & LPUART_BAUD_RXEDGIE_MASK) >> LPUART_BAUD_RXEDGIE_SHIFT)
#define LPUART_BRD_BAUD_RXEDGIE(base) (BME_UBFX32(&LPUART_BAUD_REG(base), LPUART_BAUD_RXEDGIE_SHIFT, LPUART_BAUD_RXEDGIE_WIDTH))

/*! @brief Set the RXEDGIE field to a new value. */
#define LPUART_WR_BAUD_RXEDGIE(base, value) (LPUART_RMW_BAUD(base, LPUART_BAUD_RXEDGIE_MASK, LPUART_BAUD_RXEDGIE(value)))
#define LPUART_BWR_BAUD_RXEDGIE(base, value) (BME_BFI32(&LPUART_BAUD_REG(base), ((uint32_t)(value) << LPUART_BAUD_RXEDGIE_SHIFT), LPUART_BAUD_RXEDGIE_SHIFT, LPUART_BAUD_RXEDGIE_WIDTH))
/*@}*/

/*!
 * @name Register LPUART_BAUD, field LBKDIE[15] (RW)
 *
 * LBKDIE enables the LIN break detect flag, LBKDIF, to generate interrupt
 * requests.
 *
 * Values:
 * - 0 - Hardware interrupts from LPUART_STAT[LBKDIF] disabled (use polling).
 * - 1 - Hardware interrupt requested when LPUART_STAT[LBKDIF] flag is 1.
 */
/*@{*/
/*! @brief Read current value of the LPUART_BAUD_LBKDIE field. */
#define LPUART_RD_BAUD_LBKDIE(base) ((LPUART_BAUD_REG(base) & LPUART_BAUD_LBKDIE_MASK) >> LPUART_BAUD_LBKDIE_SHIFT)
#define LPUART_BRD_BAUD_LBKDIE(base) (BME_UBFX32(&LPUART_BAUD_REG(base), LPUART_BAUD_LBKDIE_SHIFT, LPUART_BAUD_LBKDIE_WIDTH))

/*! @brief Set the LBKDIE field to a new value. */
#define LPUART_WR_BAUD_LBKDIE(base, value) (LPUART_RMW_BAUD(base, LPUART_BAUD_LBKDIE_MASK, LPUART_BAUD_LBKDIE(value)))
#define LPUART_BWR_BAUD_LBKDIE(base, value) (BME_BFI32(&LPUART_BAUD_REG(base), ((uint32_t)(value) << LPUART_BAUD_LBKDIE_SHIFT), LPUART_BAUD_LBKDIE_SHIFT, LPUART_BAUD_LBKDIE_WIDTH))
/*@}*/

/*!
 * @name Register LPUART_BAUD, field RESYNCDIS[16] (RW)
 *
 * When set, disables the resynchronization of the received data word when a
 * data one followed by data zero transition is detected. This bit should only be
 * changed when the receiver is disabled.
 *
 * Values:
 * - 0 - Resynchronization during received data word is supported
 * - 1 - Resynchronization during received data word is disabled
 */
/*@{*/
/*! @brief Read current value of the LPUART_BAUD_RESYNCDIS field. */
#define LPUART_RD_BAUD_RESYNCDIS(base) ((LPUART_BAUD_REG(base) & LPUART_BAUD_RESYNCDIS_MASK) >> LPUART_BAUD_RESYNCDIS_SHIFT)
#define LPUART_BRD_BAUD_RESYNCDIS(base) (BME_UBFX32(&LPUART_BAUD_REG(base), LPUART_BAUD_RESYNCDIS_SHIFT, LPUART_BAUD_RESYNCDIS_WIDTH))

/*! @brief Set the RESYNCDIS field to a new value. */
#define LPUART_WR_BAUD_RESYNCDIS(base, value) (LPUART_RMW_BAUD(base, LPUART_BAUD_RESYNCDIS_MASK, LPUART_BAUD_RESYNCDIS(value)))
#define LPUART_BWR_BAUD_RESYNCDIS(base, value) (BME_BFI32(&LPUART_BAUD_REG(base), ((uint32_t)(value) << LPUART_BAUD_RESYNCDIS_SHIFT), LPUART_BAUD_RESYNCDIS_SHIFT, LPUART_BAUD_RESYNCDIS_WIDTH))
/*@}*/

/*!
 * @name Register LPUART_BAUD, field BOTHEDGE[17] (RW)
 *
 * Enables sampling of the received data on both edges of the baud rate clock,
 * effectively doubling the number of times the receiver samples the input data
 * for a given oversampling ratio. This bit must be set for oversampling ratios
 * between x4 and x7 and is optional for higher oversampling ratios. This bit should
 * only be changed when the receiver is disabled.
 *
 * Values:
 * - 0 - Receiver samples input data using the rising edge of the baud rate
 *     clock.
 * - 1 - Receiver samples input data using the rising and falling edge of the
 *     baud rate clock.
 */
/*@{*/
/*! @brief Read current value of the LPUART_BAUD_BOTHEDGE field. */
#define LPUART_RD_BAUD_BOTHEDGE(base) ((LPUART_BAUD_REG(base) & LPUART_BAUD_BOTHEDGE_MASK) >> LPUART_BAUD_BOTHEDGE_SHIFT)
#define LPUART_BRD_BAUD_BOTHEDGE(base) (BME_UBFX32(&LPUART_BAUD_REG(base), LPUART_BAUD_BOTHEDGE_SHIFT, LPUART_BAUD_BOTHEDGE_WIDTH))

/*! @brief Set the BOTHEDGE field to a new value. */
#define LPUART_WR_BAUD_BOTHEDGE(base, value) (LPUART_RMW_BAUD(base, LPUART_BAUD_BOTHEDGE_MASK, LPUART_BAUD_BOTHEDGE(value)))
#define LPUART_BWR_BAUD_BOTHEDGE(base, value) (BME_BFI32(&LPUART_BAUD_REG(base), ((uint32_t)(value) << LPUART_BAUD_BOTHEDGE_SHIFT), LPUART_BAUD_BOTHEDGE_SHIFT, LPUART_BAUD_BOTHEDGE_WIDTH))
/*@}*/

/*!
 * @name Register LPUART_BAUD, field MATCFG[19:18] (RW)
 *
 * Configures the match addressing mode used.
 *
 * Values:
 * - 00 - Address Match Wakeup
 * - 01 - Idle Match Wakeup
 * - 10 - Match On and Match Off
 * - 11 - Enables RWU on Data Match and Match On/Off for transmitter CTS input
 */
/*@{*/
/*! @brief Read current value of the LPUART_BAUD_MATCFG field. */
#define LPUART_RD_BAUD_MATCFG(base) ((LPUART_BAUD_REG(base) & LPUART_BAUD_MATCFG_MASK) >> LPUART_BAUD_MATCFG_SHIFT)
#define LPUART_BRD_BAUD_MATCFG(base) (BME_UBFX32(&LPUART_BAUD_REG(base), LPUART_BAUD_MATCFG_SHIFT, LPUART_BAUD_MATCFG_WIDTH))

/*! @brief Set the MATCFG field to a new value. */
#define LPUART_WR_BAUD_MATCFG(base, value) (LPUART_RMW_BAUD(base, LPUART_BAUD_MATCFG_MASK, LPUART_BAUD_MATCFG(value)))
#define LPUART_BWR_BAUD_MATCFG(base, value) (BME_BFI32(&LPUART_BAUD_REG(base), ((uint32_t)(value) << LPUART_BAUD_MATCFG_SHIFT), LPUART_BAUD_MATCFG_SHIFT, LPUART_BAUD_MATCFG_WIDTH))
/*@}*/

/*!
 * @name Register LPUART_BAUD, field RDMAE[21] (RW)
 *
 * RDMAE configures the receiver data register full flag, LPUART_STAT[RDRF], to
 * generate a DMA request.
 *
 * Values:
 * - 0 - DMA request disabled.
 * - 1 - DMA request enabled.
 */
/*@{*/
/*! @brief Read current value of the LPUART_BAUD_RDMAE field. */
#define LPUART_RD_BAUD_RDMAE(base) ((LPUART_BAUD_REG(base) & LPUART_BAUD_RDMAE_MASK) >> LPUART_BAUD_RDMAE_SHIFT)
#define LPUART_BRD_BAUD_RDMAE(base) (BME_UBFX32(&LPUART_BAUD_REG(base), LPUART_BAUD_RDMAE_SHIFT, LPUART_BAUD_RDMAE_WIDTH))

/*! @brief Set the RDMAE field to a new value. */
#define LPUART_WR_BAUD_RDMAE(base, value) (LPUART_RMW_BAUD(base, LPUART_BAUD_RDMAE_MASK, LPUART_BAUD_RDMAE(value)))
#define LPUART_BWR_BAUD_RDMAE(base, value) (BME_BFI32(&LPUART_BAUD_REG(base), ((uint32_t)(value) << LPUART_BAUD_RDMAE_SHIFT), LPUART_BAUD_RDMAE_SHIFT, LPUART_BAUD_RDMAE_WIDTH))
/*@}*/

/*!
 * @name Register LPUART_BAUD, field TDMAE[23] (RW)
 *
 * TDMAE configures the transmit data register empty flag, LPUART_STAT[TDRE], to
 * generate a DMA request.
 *
 * Values:
 * - 0 - DMA request disabled.
 * - 1 - DMA request enabled.
 */
/*@{*/
/*! @brief Read current value of the LPUART_BAUD_TDMAE field. */
#define LPUART_RD_BAUD_TDMAE(base) ((LPUART_BAUD_REG(base) & LPUART_BAUD_TDMAE_MASK) >> LPUART_BAUD_TDMAE_SHIFT)
#define LPUART_BRD_BAUD_TDMAE(base) (BME_UBFX32(&LPUART_BAUD_REG(base), LPUART_BAUD_TDMAE_SHIFT, LPUART_BAUD_TDMAE_WIDTH))

/*! @brief Set the TDMAE field to a new value. */
#define LPUART_WR_BAUD_TDMAE(base, value) (LPUART_RMW_BAUD(base, LPUART_BAUD_TDMAE_MASK, LPUART_BAUD_TDMAE(value)))
#define LPUART_BWR_BAUD_TDMAE(base, value) (BME_BFI32(&LPUART_BAUD_REG(base), ((uint32_t)(value) << LPUART_BAUD_TDMAE_SHIFT), LPUART_BAUD_TDMAE_SHIFT, LPUART_BAUD_TDMAE_WIDTH))
/*@}*/

/*!
 * @name Register LPUART_BAUD, field OSR[28:24] (RW)
 *
 * This field configures the oversampling ratio for the receiver between 4x
 * (00011) and 32x (11111). Writing an invalid oversampling ratio will default to an
 * oversampling ratio of 16 (01111). This field should only be changed when the
 * transmitter and receiver are both disabled.
 */
/*@{*/
/*! @brief Read current value of the LPUART_BAUD_OSR field. */
#define LPUART_RD_BAUD_OSR(base) ((LPUART_BAUD_REG(base) & LPUART_BAUD_OSR_MASK) >> LPUART_BAUD_OSR_SHIFT)
#define LPUART_BRD_BAUD_OSR(base) (BME_UBFX32(&LPUART_BAUD_REG(base), LPUART_BAUD_OSR_SHIFT, LPUART_BAUD_OSR_WIDTH))

/*! @brief Set the OSR field to a new value. */
#define LPUART_WR_BAUD_OSR(base, value) (LPUART_RMW_BAUD(base, LPUART_BAUD_OSR_MASK, LPUART_BAUD_OSR(value)))
#define LPUART_BWR_BAUD_OSR(base, value) (BME_BFI32(&LPUART_BAUD_REG(base), ((uint32_t)(value) << LPUART_BAUD_OSR_SHIFT), LPUART_BAUD_OSR_SHIFT, LPUART_BAUD_OSR_WIDTH))
/*@}*/

/*!
 * @name Register LPUART_BAUD, field M10[29] (RW)
 *
 * The M10 bit causes a tenth bit to be part of the serial transmission. This
 * bit should only be changed when the transmitter and receiver are both disabled.
 *
 * Values:
 * - 0 - Receiver and transmitter use 8-bit or 9-bit data characters.
 * - 1 - Receiver and transmitter use 10-bit data characters.
 */
/*@{*/
/*! @brief Read current value of the LPUART_BAUD_M10 field. */
#define LPUART_RD_BAUD_M10(base) ((LPUART_BAUD_REG(base) & LPUART_BAUD_M10_MASK) >> LPUART_BAUD_M10_SHIFT)
#define LPUART_BRD_BAUD_M10(base) (BME_UBFX32(&LPUART_BAUD_REG(base), LPUART_BAUD_M10_SHIFT, LPUART_BAUD_M10_WIDTH))

/*! @brief Set the M10 field to a new value. */
#define LPUART_WR_BAUD_M10(base, value) (LPUART_RMW_BAUD(base, LPUART_BAUD_M10_MASK, LPUART_BAUD_M10(value)))
#define LPUART_BWR_BAUD_M10(base, value) (BME_BFI32(&LPUART_BAUD_REG(base), ((uint32_t)(value) << LPUART_BAUD_M10_SHIFT), LPUART_BAUD_M10_SHIFT, LPUART_BAUD_M10_WIDTH))
/*@}*/

/*!
 * @name Register LPUART_BAUD, field MAEN2[30] (RW)
 *
 * Values:
 * - 0 - Normal operation.
 * - 1 - Enables automatic address matching or data matching mode for MATCH[MA2].
 */
/*@{*/
/*! @brief Read current value of the LPUART_BAUD_MAEN2 field. */
#define LPUART_RD_BAUD_MAEN2(base) ((LPUART_BAUD_REG(base) & LPUART_BAUD_MAEN2_MASK) >> LPUART_BAUD_MAEN2_SHIFT)
#define LPUART_BRD_BAUD_MAEN2(base) (BME_UBFX32(&LPUART_BAUD_REG(base), LPUART_BAUD_MAEN2_SHIFT, LPUART_BAUD_MAEN2_WIDTH))

/*! @brief Set the MAEN2 field to a new value. */
#define LPUART_WR_BAUD_MAEN2(base, value) (LPUART_RMW_BAUD(base, LPUART_BAUD_MAEN2_MASK, LPUART_BAUD_MAEN2(value)))
#define LPUART_BWR_BAUD_MAEN2(base, value) (BME_BFI32(&LPUART_BAUD_REG(base), ((uint32_t)(value) << LPUART_BAUD_MAEN2_SHIFT), LPUART_BAUD_MAEN2_SHIFT, LPUART_BAUD_MAEN2_WIDTH))
/*@}*/

/*!
 * @name Register LPUART_BAUD, field MAEN1[31] (RW)
 *
 * Values:
 * - 0 - Normal operation.
 * - 1 - Enables automatic address matching or data matching mode for MATCH[MA1].
 */
/*@{*/
/*! @brief Read current value of the LPUART_BAUD_MAEN1 field. */
#define LPUART_RD_BAUD_MAEN1(base) ((LPUART_BAUD_REG(base) & LPUART_BAUD_MAEN1_MASK) >> LPUART_BAUD_MAEN1_SHIFT)
#define LPUART_BRD_BAUD_MAEN1(base) (BME_UBFX32(&LPUART_BAUD_REG(base), LPUART_BAUD_MAEN1_SHIFT, LPUART_BAUD_MAEN1_WIDTH))

/*! @brief Set the MAEN1 field to a new value. */
#define LPUART_WR_BAUD_MAEN1(base, value) (LPUART_RMW_BAUD(base, LPUART_BAUD_MAEN1_MASK, LPUART_BAUD_MAEN1(value)))
#define LPUART_BWR_BAUD_MAEN1(base, value) (BME_BFI32(&LPUART_BAUD_REG(base), ((uint32_t)(value) << LPUART_BAUD_MAEN1_SHIFT), LPUART_BAUD_MAEN1_SHIFT, LPUART_BAUD_MAEN1_WIDTH))
/*@}*/

/*******************************************************************************
 * LPUART_STAT - LPUART Status Register
 ******************************************************************************/

/*!
 * @brief LPUART_STAT - LPUART Status Register (RW)
 *
 * Reset value: 0x00C00000U
 */
/*!
 * @name Constants and macros for entire LPUART_STAT register
 */
/*@{*/
#define LPUART_RD_STAT(base)     (LPUART_STAT_REG(base))
#define LPUART_WR_STAT(base, value) (LPUART_STAT_REG(base) = (value))
#define LPUART_RMW_STAT(base, mask, value) (LPUART_WR_STAT(base, (LPUART_RD_STAT(base) & ~(mask)) | (value)))
#define LPUART_SET_STAT(base, value) (BME_OR32(&LPUART_STAT_REG(base), (uint32_t)(value)))
#define LPUART_CLR_STAT(base, value) (BME_AND32(&LPUART_STAT_REG(base), (uint32_t)(~(value))))
#define LPUART_TOG_STAT(base, value) (BME_XOR32(&LPUART_STAT_REG(base), (uint32_t)(value)))
/*@}*/

/*
 * Constants & macros for individual LPUART_STAT bitfields
 */

/*!
 * @name Register LPUART_STAT, field MA2F[14] (W1C)
 *
 * MA2F is set whenever the next character to be read from LPUART_DATA matches
 * MA2. To clear MA2F, write a logic one to the MA2F.
 *
 * Values:
 * - 0 - Received data is not equal to MA2
 * - 1 - Received data is equal to MA2
 */
/*@{*/
/*! @brief Read current value of the LPUART_STAT_MA2F field. */
#define LPUART_RD_STAT_MA2F(base) ((LPUART_STAT_REG(base) & LPUART_STAT_MA2F_MASK) >> LPUART_STAT_MA2F_SHIFT)
#define LPUART_BRD_STAT_MA2F(base) (BME_UBFX32(&LPUART_STAT_REG(base), LPUART_STAT_MA2F_SHIFT, LPUART_STAT_MA2F_WIDTH))

/*! @brief Set the MA2F field to a new value. */
#define LPUART_WR_STAT_MA2F(base, value) (LPUART_RMW_STAT(base, (LPUART_STAT_MA2F_MASK | LPUART_STAT_MA1F_MASK | LPUART_STAT_PF_MASK | LPUART_STAT_FE_MASK | LPUART_STAT_NF_MASK | LPUART_STAT_OR_MASK | LPUART_STAT_IDLE_MASK | LPUART_STAT_RXEDGIF_MASK | LPUART_STAT_LBKDIF_MASK), LPUART_STAT_MA2F(value)))
#define LPUART_BWR_STAT_MA2F(base, value) (BME_BFI32(&LPUART_STAT_REG(base), ((uint32_t)(value) << LPUART_STAT_MA2F_SHIFT), LPUART_STAT_MA2F_SHIFT, LPUART_STAT_MA2F_WIDTH))
/*@}*/

/*!
 * @name Register LPUART_STAT, field MA1F[15] (W1C)
 *
 * MA1F is set whenever the next character to be read from LPUART_DATA matches
 * MA1. To clear MA1F, write a logic one to the MA1F.
 *
 * Values:
 * - 0 - Received data is not equal to MA1
 * - 1 - Received data is equal to MA1
 */
/*@{*/
/*! @brief Read current value of the LPUART_STAT_MA1F field. */
#define LPUART_RD_STAT_MA1F(base) ((LPUART_STAT_REG(base) & LPUART_STAT_MA1F_MASK) >> LPUART_STAT_MA1F_SHIFT)
#define LPUART_BRD_STAT_MA1F(base) (BME_UBFX32(&LPUART_STAT_REG(base), LPUART_STAT_MA1F_SHIFT, LPUART_STAT_MA1F_WIDTH))

/*! @brief Set the MA1F field to a new value. */
#define LPUART_WR_STAT_MA1F(base, value) (LPUART_RMW_STAT(base, (LPUART_STAT_MA1F_MASK | LPUART_STAT_MA2F_MASK | LPUART_STAT_PF_MASK | LPUART_STAT_FE_MASK | LPUART_STAT_NF_MASK | LPUART_STAT_OR_MASK | LPUART_STAT_IDLE_MASK | LPUART_STAT_RXEDGIF_MASK | LPUART_STAT_LBKDIF_MASK), LPUART_STAT_MA1F(value)))
#define LPUART_BWR_STAT_MA1F(base, value) (BME_BFI32(&LPUART_STAT_REG(base), ((uint32_t)(value) << LPUART_STAT_MA1F_SHIFT), LPUART_STAT_MA1F_SHIFT, LPUART_STAT_MA1F_WIDTH))
/*@}*/

/*!
 * @name Register LPUART_STAT, field PF[16] (W1C)
 *
 * PF is set whenever the next character to be read from LPUART_DATA was
 * received when parity is enabled (PE = 1) and the parity bit in the received character
 * does not agree with the expected parity value. To clear PF, write a logic one
 * to the PF.
 *
 * Values:
 * - 0 - No parity error.
 * - 1 - Parity error.
 */
/*@{*/
/*! @brief Read current value of the LPUART_STAT_PF field. */
#define LPUART_RD_STAT_PF(base) ((LPUART_STAT_REG(base) & LPUART_STAT_PF_MASK) >> LPUART_STAT_PF_SHIFT)
#define LPUART_BRD_STAT_PF(base) (BME_UBFX32(&LPUART_STAT_REG(base), LPUART_STAT_PF_SHIFT, LPUART_STAT_PF_WIDTH))

/*! @brief Set the PF field to a new value. */
#define LPUART_WR_STAT_PF(base, value) (LPUART_RMW_STAT(base, (LPUART_STAT_PF_MASK | LPUART_STAT_MA2F_MASK | LPUART_STAT_MA1F_MASK | LPUART_STAT_FE_MASK | LPUART_STAT_NF_MASK | LPUART_STAT_OR_MASK | LPUART_STAT_IDLE_MASK | LPUART_STAT_RXEDGIF_MASK | LPUART_STAT_LBKDIF_MASK), LPUART_STAT_PF(value)))
#define LPUART_BWR_STAT_PF(base, value) (BME_BFI32(&LPUART_STAT_REG(base), ((uint32_t)(value) << LPUART_STAT_PF_SHIFT), LPUART_STAT_PF_SHIFT, LPUART_STAT_PF_WIDTH))
/*@}*/

/*!
 * @name Register LPUART_STAT, field FE[17] (W1C)
 *
 * FE is set whenever the next character to be read from LPUART_DATA was
 * received with logic 0 detected where a stop bit was expected. To clear NF, write
 * logic one to the NF.
 *
 * Values:
 * - 0 - No framing error detected. This does not guarantee the framing is
 *     correct.
 * - 1 - Framing error.
 */
/*@{*/
/*! @brief Read current value of the LPUART_STAT_FE field. */
#define LPUART_RD_STAT_FE(base) ((LPUART_STAT_REG(base) & LPUART_STAT_FE_MASK) >> LPUART_STAT_FE_SHIFT)
#define LPUART_BRD_STAT_FE(base) (BME_UBFX32(&LPUART_STAT_REG(base), LPUART_STAT_FE_SHIFT, LPUART_STAT_FE_WIDTH))

/*! @brief Set the FE field to a new value. */
#define LPUART_WR_STAT_FE(base, value) (LPUART_RMW_STAT(base, (LPUART_STAT_FE_MASK | LPUART_STAT_MA2F_MASK | LPUART_STAT_MA1F_MASK | LPUART_STAT_PF_MASK | LPUART_STAT_NF_MASK | LPUART_STAT_OR_MASK | LPUART_STAT_IDLE_MASK | LPUART_STAT_RXEDGIF_MASK | LPUART_STAT_LBKDIF_MASK), LPUART_STAT_FE(value)))
#define LPUART_BWR_STAT_FE(base, value) (BME_BFI32(&LPUART_STAT_REG(base), ((uint32_t)(value) << LPUART_STAT_FE_SHIFT), LPUART_STAT_FE_SHIFT, LPUART_STAT_FE_WIDTH))
/*@}*/

/*!
 * @name Register LPUART_STAT, field NF[18] (W1C)
 *
 * The advanced sampling technique used in the receiver takes three samples in
 * each of the received bits. If any of these samples disagrees with the rest of
 * the samples within any bit time in the frame then noise is detected for that
 * character. NF is set whenever the next character to be read from LPUART_DATA was
 * received with noise detected within the character. To clear NF, write logic
 * one to the NF.
 *
 * Values:
 * - 0 - No noise detected.
 * - 1 - Noise detected in the received character in LPUART_DATA.
 */
/*@{*/
/*! @brief Read current value of the LPUART_STAT_NF field. */
#define LPUART_RD_STAT_NF(base) ((LPUART_STAT_REG(base) & LPUART_STAT_NF_MASK) >> LPUART_STAT_NF_SHIFT)
#define LPUART_BRD_STAT_NF(base) (BME_UBFX32(&LPUART_STAT_REG(base), LPUART_STAT_NF_SHIFT, LPUART_STAT_NF_WIDTH))

/*! @brief Set the NF field to a new value. */
#define LPUART_WR_STAT_NF(base, value) (LPUART_RMW_STAT(base, (LPUART_STAT_NF_MASK | LPUART_STAT_MA2F_MASK | LPUART_STAT_MA1F_MASK | LPUART_STAT_PF_MASK | LPUART_STAT_FE_MASK | LPUART_STAT_OR_MASK | LPUART_STAT_IDLE_MASK | LPUART_STAT_RXEDGIF_MASK | LPUART_STAT_LBKDIF_MASK), LPUART_STAT_NF(value)))
#define LPUART_BWR_STAT_NF(base, value) (BME_BFI32(&LPUART_STAT_REG(base), ((uint32_t)(value) << LPUART_STAT_NF_SHIFT), LPUART_STAT_NF_SHIFT, LPUART_STAT_NF_WIDTH))
/*@}*/

/*!
 * @name Register LPUART_STAT, field OR[19] (W1C)
 *
 * OR is set when software fails to prevent the receive data register from
 * overflowing with data. The OR bit is set immediately after the stop bit has been
 * completely received for the dataword that overflows the buffer and all the other
 * error flags (FE, NF, and PF) are prevented from setting. The data in the
 * shift register is lost, but the data already in the LPUART data registers is not
 * affected. If LBKDE is enabled and a LIN Break is detected, the OR field asserts
 * if LBKDIF is not cleared before the next data character is received. While
 * the OR flag is set, no additional data is stored in the data buffer even if
 * sufficient room exists. To clear OR, write logic 1 to the OR flag.
 *
 * Values:
 * - 0 - No overrun.
 * - 1 - Receive overrun (new LPUART data lost).
 */
/*@{*/
/*! @brief Read current value of the LPUART_STAT_OR field. */
#define LPUART_RD_STAT_OR(base) ((LPUART_STAT_REG(base) & LPUART_STAT_OR_MASK) >> LPUART_STAT_OR_SHIFT)
#define LPUART_BRD_STAT_OR(base) (BME_UBFX32(&LPUART_STAT_REG(base), LPUART_STAT_OR_SHIFT, LPUART_STAT_OR_WIDTH))

/*! @brief Set the OR field to a new value. */
#define LPUART_WR_STAT_OR(base, value) (LPUART_RMW_STAT(base, (LPUART_STAT_OR_MASK | LPUART_STAT_MA2F_MASK | LPUART_STAT_MA1F_MASK | LPUART_STAT_PF_MASK | LPUART_STAT_FE_MASK | LPUART_STAT_NF_MASK | LPUART_STAT_IDLE_MASK | LPUART_STAT_RXEDGIF_MASK | LPUART_STAT_LBKDIF_MASK), LPUART_STAT_OR(value)))
#define LPUART_BWR_STAT_OR(base, value) (BME_BFI32(&LPUART_STAT_REG(base), ((uint32_t)(value) << LPUART_STAT_OR_SHIFT), LPUART_STAT_OR_SHIFT, LPUART_STAT_OR_WIDTH))
/*@}*/

/*!
 * @name Register LPUART_STAT, field IDLE[20] (W1C)
 *
 * IDLE is set when the LPUART receive line becomes idle for a full character
 * time after a period of activity. When ILT is cleared, the receiver starts
 * counting idle bit times after the start bit. If the receive character is all 1s,
 * these bit times and the stop bits time count toward the full character time of
 * logic high, 10 to 13 bit times, needed for the receiver to detect an idle line.
 * When ILT is set, the receiver doesn't start counting idle bit times until
 * after the stop bits. The stop bits and any logic high bit times at the end of the
 * previous character do not count toward the full character time of logic high
 * needed for the receiver to detect an idle line. To clear IDLE, write logic 1 to
 * the IDLE flag. After IDLE has been cleared, it cannot become set again until
 * after a new character has been stored in the receive buffer or a LIN break
 * character has set the LBKDIF flag . IDLE is set only once even if the receive
 * line remains idle for an extended period.
 *
 * Values:
 * - 0 - No idle line detected.
 * - 1 - Idle line was detected.
 */
/*@{*/
/*! @brief Read current value of the LPUART_STAT_IDLE field. */
#define LPUART_RD_STAT_IDLE(base) ((LPUART_STAT_REG(base) & LPUART_STAT_IDLE_MASK) >> LPUART_STAT_IDLE_SHIFT)
#define LPUART_BRD_STAT_IDLE(base) (BME_UBFX32(&LPUART_STAT_REG(base), LPUART_STAT_IDLE_SHIFT, LPUART_STAT_IDLE_WIDTH))

/*! @brief Set the IDLE field to a new value. */
#define LPUART_WR_STAT_IDLE(base, value) (LPUART_RMW_STAT(base, (LPUART_STAT_IDLE_MASK | LPUART_STAT_MA2F_MASK | LPUART_STAT_MA1F_MASK | LPUART_STAT_PF_MASK | LPUART_STAT_FE_MASK | LPUART_STAT_NF_MASK | LPUART_STAT_OR_MASK | LPUART_STAT_RXEDGIF_MASK | LPUART_STAT_LBKDIF_MASK), LPUART_STAT_IDLE(value)))
#define LPUART_BWR_STAT_IDLE(base, value) (BME_BFI32(&LPUART_STAT_REG(base), ((uint32_t)(value) << LPUART_STAT_IDLE_SHIFT), LPUART_STAT_IDLE_SHIFT, LPUART_STAT_IDLE_WIDTH))
/*@}*/

/*!
 * @name Register LPUART_STAT, field RDRF[21] (RO)
 *
 * RDRF is set when the receive buffer (LPUART_DATA) is full. To clear RDRF,
 * read the LPUART_DATA register. A character that is in the process of being
 * received does not cause a change in RDRF until the entire character is received.
 * Even if RDRF is set, the character will continue to be received until an overrun
 * condition occurs once the entire character is received.
 *
 * Values:
 * - 0 - Receive data buffer empty.
 * - 1 - Receive data buffer full.
 */
/*@{*/
/*! @brief Read current value of the LPUART_STAT_RDRF field. */
#define LPUART_RD_STAT_RDRF(base) ((LPUART_STAT_REG(base) & LPUART_STAT_RDRF_MASK) >> LPUART_STAT_RDRF_SHIFT)
#define LPUART_BRD_STAT_RDRF(base) (BME_UBFX32(&LPUART_STAT_REG(base), LPUART_STAT_RDRF_SHIFT, LPUART_STAT_RDRF_WIDTH))
/*@}*/

/*!
 * @name Register LPUART_STAT, field TC[22] (RO)
 *
 * TC is cleared when there is a transmission in progress or when a preamble or
 * break character is loaded. TC is set when the transmit buffer is empty and no
 * data, preamble, or break character is being transmitted. When TC is set, the
 * transmit data output signal becomes idle (logic 1). TC is cleared by writing to
 * LPUART_DATA to transmit new data, queuing a preamble by clearing and then
 * setting LPUART_CTRL[TE], queuing a break character by writing 1 to
 * LPUART_CTRL[SBK].
 *
 * Values:
 * - 0 - Transmitter active (sending data, a preamble, or a break).
 * - 1 - Transmitter idle (transmission activity complete).
 */
/*@{*/
/*! @brief Read current value of the LPUART_STAT_TC field. */
#define LPUART_RD_STAT_TC(base) ((LPUART_STAT_REG(base) & LPUART_STAT_TC_MASK) >> LPUART_STAT_TC_SHIFT)
#define LPUART_BRD_STAT_TC(base) (BME_UBFX32(&LPUART_STAT_REG(base), LPUART_STAT_TC_SHIFT, LPUART_STAT_TC_WIDTH))
/*@}*/

/*!
 * @name Register LPUART_STAT, field TDRE[23] (RO)
 *
 * TDRE will set when the transmit data register (LPUART_DATA) is empty. To
 * clear TDRE, write to the LPUART data register (LPUART_DATA). TDRE is not affected
 * by a character that is in the process of being transmitted, it is updated at
 * the start of each transmitted character.
 *
 * Values:
 * - 0 - Transmit data buffer full.
 * - 1 - Transmit data buffer empty.
 */
/*@{*/
/*! @brief Read current value of the LPUART_STAT_TDRE field. */
#define LPUART_RD_STAT_TDRE(base) ((LPUART_STAT_REG(base) & LPUART_STAT_TDRE_MASK) >> LPUART_STAT_TDRE_SHIFT)
#define LPUART_BRD_STAT_TDRE(base) (BME_UBFX32(&LPUART_STAT_REG(base), LPUART_STAT_TDRE_SHIFT, LPUART_STAT_TDRE_WIDTH))
/*@}*/

/*!
 * @name Register LPUART_STAT, field RAF[24] (RO)
 *
 * RAF is set when the receiver detects the beginning of a valid start bit, and
 * RAF is cleared automatically when the receiver detects an idle line.
 *
 * Values:
 * - 0 - LPUART receiver idle waiting for a start bit.
 * - 1 - LPUART receiver active (LPUART_RX input not idle).
 */
/*@{*/
/*! @brief Read current value of the LPUART_STAT_RAF field. */
#define LPUART_RD_STAT_RAF(base) ((LPUART_STAT_REG(base) & LPUART_STAT_RAF_MASK) >> LPUART_STAT_RAF_SHIFT)
#define LPUART_BRD_STAT_RAF(base) (BME_UBFX32(&LPUART_STAT_REG(base), LPUART_STAT_RAF_SHIFT, LPUART_STAT_RAF_WIDTH))
/*@}*/

/*!
 * @name Register LPUART_STAT, field LBKDE[25] (RW)
 *
 * LBKDE selects a longer break character detection length. While LBKDE is set,
 * receive data is not stored in the receive data buffer.
 *
 * Values:
 * - 0 - Break character is detected at length 10 bit times (if M = 0, SBNS = 0)
 *     or 11 (if M = 1, SBNS = 0 or M = 0, SBNS = 1) or 12 (if M = 1, SBNS = 1
 *     or M10 = 1, SNBS = 0) or 13 (if M10 = 1, SNBS = 1).
 * - 1 - Break character is detected at length of 11 bit times (if M = 0, SBNS =
 *     0) or 12 (if M = 1, SBNS = 0 or M = 0, SBNS = 1) or 14 (if M = 1, SBNS =
 *     1 or M10 = 1, SNBS = 0) or 15 (if M10 = 1, SNBS = 1).
 */
/*@{*/
/*! @brief Read current value of the LPUART_STAT_LBKDE field. */
#define LPUART_RD_STAT_LBKDE(base) ((LPUART_STAT_REG(base) & LPUART_STAT_LBKDE_MASK) >> LPUART_STAT_LBKDE_SHIFT)
#define LPUART_BRD_STAT_LBKDE(base) (BME_UBFX32(&LPUART_STAT_REG(base), LPUART_STAT_LBKDE_SHIFT, LPUART_STAT_LBKDE_WIDTH))

/*! @brief Set the LBKDE field to a new value. */
#define LPUART_WR_STAT_LBKDE(base, value) (LPUART_RMW_STAT(base, (LPUART_STAT_LBKDE_MASK | LPUART_STAT_MA2F_MASK | LPUART_STAT_MA1F_MASK | LPUART_STAT_PF_MASK | LPUART_STAT_FE_MASK | LPUART_STAT_NF_MASK | LPUART_STAT_OR_MASK | LPUART_STAT_IDLE_MASK | LPUART_STAT_RXEDGIF_MASK | LPUART_STAT_LBKDIF_MASK), LPUART_STAT_LBKDE(value)))
#define LPUART_BWR_STAT_LBKDE(base, value) (BME_BFI32(&LPUART_STAT_REG(base), ((uint32_t)(value) << LPUART_STAT_LBKDE_SHIFT), LPUART_STAT_LBKDE_SHIFT, LPUART_STAT_LBKDE_WIDTH))
/*@}*/

/*!
 * @name Register LPUART_STAT, field BRK13[26] (RW)
 *
 * BRK13 selects a longer transmitted break character length. Detection of a
 * framing error is not affected by the state of this bit. This bit should only be
 * changed when the transmitter is disabled.
 *
 * Values:
 * - 0 - Break character is transmitted with length of 10 bit times (if M = 0,
 *     SBNS = 0) or 11 (if M = 1, SBNS = 0 or M = 0, SBNS = 1) or 12 (if M = 1,
 *     SBNS = 1 or M10 = 1, SNBS = 0) or 13 (if M10 = 1, SNBS = 1).
 * - 1 - Break character is transmitted with length of 13 bit times (if M = 0,
 *     SBNS = 0) or 14 (if M = 1, SBNS = 0 or M = 0, SBNS = 1) or 15 (if M = 1,
 *     SBNS = 1 or M10 = 1, SNBS = 0) or 16 (if M10 = 1, SNBS = 1).
 */
/*@{*/
/*! @brief Read current value of the LPUART_STAT_BRK13 field. */
#define LPUART_RD_STAT_BRK13(base) ((LPUART_STAT_REG(base) & LPUART_STAT_BRK13_MASK) >> LPUART_STAT_BRK13_SHIFT)
#define LPUART_BRD_STAT_BRK13(base) (BME_UBFX32(&LPUART_STAT_REG(base), LPUART_STAT_BRK13_SHIFT, LPUART_STAT_BRK13_WIDTH))

/*! @brief Set the BRK13 field to a new value. */
#define LPUART_WR_STAT_BRK13(base, value) (LPUART_RMW_STAT(base, (LPUART_STAT_BRK13_MASK | LPUART_STAT_MA2F_MASK | LPUART_STAT_MA1F_MASK | LPUART_STAT_PF_MASK | LPUART_STAT_FE_MASK | LPUART_STAT_NF_MASK | LPUART_STAT_OR_MASK | LPUART_STAT_IDLE_MASK | LPUART_STAT_RXEDGIF_MASK | LPUART_STAT_LBKDIF_MASK), LPUART_STAT_BRK13(value)))
#define LPUART_BWR_STAT_BRK13(base, value) (BME_BFI32(&LPUART_STAT_REG(base), ((uint32_t)(value) << LPUART_STAT_BRK13_SHIFT), LPUART_STAT_BRK13_SHIFT, LPUART_STAT_BRK13_WIDTH))
/*@}*/

/*!
 * @name Register LPUART_STAT, field RWUID[27] (RW)
 *
 * For RWU on idle character, RWUID controls whether the idle character that
 * wakes up the receiver sets the IDLE bit. For address match wakeup, RWUID controls
 * if the IDLE bit is set when the address does not match. This bit should only
 * be changed when the receiver is disabled.
 *
 * Values:
 * - 0 - During receive standby state (RWU = 1), the IDLE bit does not get set
 *     upon detection of an idle character. During address match wakeup, the IDLE
 *     bit does not get set when an address does not match.
 * - 1 - During receive standby state (RWU = 1), the IDLE bit gets set upon
 *     detection of an idle character. During address match wakeup, the IDLE bit does
 *     get set when an address does not match.
 */
/*@{*/
/*! @brief Read current value of the LPUART_STAT_RWUID field. */
#define LPUART_RD_STAT_RWUID(base) ((LPUART_STAT_REG(base) & LPUART_STAT_RWUID_MASK) >> LPUART_STAT_RWUID_SHIFT)
#define LPUART_BRD_STAT_RWUID(base) (BME_UBFX32(&LPUART_STAT_REG(base), LPUART_STAT_RWUID_SHIFT, LPUART_STAT_RWUID_WIDTH))

/*! @brief Set the RWUID field to a new value. */
#define LPUART_WR_STAT_RWUID(base, value) (LPUART_RMW_STAT(base, (LPUART_STAT_RWUID_MASK | LPUART_STAT_MA2F_MASK | LPUART_STAT_MA1F_MASK | LPUART_STAT_PF_MASK | LPUART_STAT_FE_MASK | LPUART_STAT_NF_MASK | LPUART_STAT_OR_MASK | LPUART_STAT_IDLE_MASK | LPUART_STAT_RXEDGIF_MASK | LPUART_STAT_LBKDIF_MASK), LPUART_STAT_RWUID(value)))
#define LPUART_BWR_STAT_RWUID(base, value) (BME_BFI32(&LPUART_STAT_REG(base), ((uint32_t)(value) << LPUART_STAT_RWUID_SHIFT), LPUART_STAT_RWUID_SHIFT, LPUART_STAT_RWUID_WIDTH))
/*@}*/

/*!
 * @name Register LPUART_STAT, field RXINV[28] (RW)
 *
 * Setting this bit reverses the polarity of the received data input. Setting
 * RXINV inverts the LPUART_RX input for all cases: data bits, start and stop bits,
 * break, and idle.
 *
 * Values:
 * - 0 - Receive data not inverted.
 * - 1 - Receive data inverted.
 */
/*@{*/
/*! @brief Read current value of the LPUART_STAT_RXINV field. */
#define LPUART_RD_STAT_RXINV(base) ((LPUART_STAT_REG(base) & LPUART_STAT_RXINV_MASK) >> LPUART_STAT_RXINV_SHIFT)
#define LPUART_BRD_STAT_RXINV(base) (BME_UBFX32(&LPUART_STAT_REG(base), LPUART_STAT_RXINV_SHIFT, LPUART_STAT_RXINV_WIDTH))

/*! @brief Set the RXINV field to a new value. */
#define LPUART_WR_STAT_RXINV(base, value) (LPUART_RMW_STAT(base, (LPUART_STAT_RXINV_MASK | LPUART_STAT_MA2F_MASK | LPUART_STAT_MA1F_MASK | LPUART_STAT_PF_MASK | LPUART_STAT_FE_MASK | LPUART_STAT_NF_MASK | LPUART_STAT_OR_MASK | LPUART_STAT_IDLE_MASK | LPUART_STAT_RXEDGIF_MASK | LPUART_STAT_LBKDIF_MASK), LPUART_STAT_RXINV(value)))
#define LPUART_BWR_STAT_RXINV(base, value) (BME_BFI32(&LPUART_STAT_REG(base), ((uint32_t)(value) << LPUART_STAT_RXINV_SHIFT), LPUART_STAT_RXINV_SHIFT, LPUART_STAT_RXINV_WIDTH))
/*@}*/

/*!
 * @name Register LPUART_STAT, field MSBF[29] (RW)
 *
 * Setting this bit reverses the order of the bits that are transmitted and
 * received on the wire. This bit does not affect the polarity of the bits, the
 * location of the parity bit or the location of the start or stop bits. This bit
 * should only be changed when the transmitter and receiver are both disabled.
 *
 * Values:
 * - 0 - LSB (bit0) is the first bit that is transmitted following the start
 *     bit. Further, the first bit received after the start bit is identified as
 *     bit0.
 * - 1 - MSB (bit9, bit8, bit7 or bit6) is the first bit that is transmitted
 *     following the start bit depending on the setting of CTRL[M], CTRL[PE] and
 *     BAUD[M10]. Further, the first bit received after the start bit is identified
 *     as bit9, bit8, bit7 or bit6 depending on the setting of CTRL[M] and
 *     CTRL[PE].
 */
/*@{*/
/*! @brief Read current value of the LPUART_STAT_MSBF field. */
#define LPUART_RD_STAT_MSBF(base) ((LPUART_STAT_REG(base) & LPUART_STAT_MSBF_MASK) >> LPUART_STAT_MSBF_SHIFT)
#define LPUART_BRD_STAT_MSBF(base) (BME_UBFX32(&LPUART_STAT_REG(base), LPUART_STAT_MSBF_SHIFT, LPUART_STAT_MSBF_WIDTH))

/*! @brief Set the MSBF field to a new value. */
#define LPUART_WR_STAT_MSBF(base, value) (LPUART_RMW_STAT(base, (LPUART_STAT_MSBF_MASK | LPUART_STAT_MA2F_MASK | LPUART_STAT_MA1F_MASK | LPUART_STAT_PF_MASK | LPUART_STAT_FE_MASK | LPUART_STAT_NF_MASK | LPUART_STAT_OR_MASK | LPUART_STAT_IDLE_MASK | LPUART_STAT_RXEDGIF_MASK | LPUART_STAT_LBKDIF_MASK), LPUART_STAT_MSBF(value)))
#define LPUART_BWR_STAT_MSBF(base, value) (BME_BFI32(&LPUART_STAT_REG(base), ((uint32_t)(value) << LPUART_STAT_MSBF_SHIFT), LPUART_STAT_MSBF_SHIFT, LPUART_STAT_MSBF_WIDTH))
/*@}*/

/*!
 * @name Register LPUART_STAT, field RXEDGIF[30] (W1C)
 *
 * RXEDGIF is set when an active edge, falling if RXINV = 0, rising if RXINV=1,
 * on the LPUART_RX pin occurs. RXEDGIF is cleared by writing a 1 to it.
 *
 * Values:
 * - 0 - No active edge on the receive pin has occurred.
 * - 1 - An active edge on the receive pin has occurred.
 */
/*@{*/
/*! @brief Read current value of the LPUART_STAT_RXEDGIF field. */
#define LPUART_RD_STAT_RXEDGIF(base) ((LPUART_STAT_REG(base) & LPUART_STAT_RXEDGIF_MASK) >> LPUART_STAT_RXEDGIF_SHIFT)
#define LPUART_BRD_STAT_RXEDGIF(base) (BME_UBFX32(&LPUART_STAT_REG(base), LPUART_STAT_RXEDGIF_SHIFT, LPUART_STAT_RXEDGIF_WIDTH))

/*! @brief Set the RXEDGIF field to a new value. */
#define LPUART_WR_STAT_RXEDGIF(base, value) (LPUART_RMW_STAT(base, (LPUART_STAT_RXEDGIF_MASK | LPUART_STAT_MA2F_MASK | LPUART_STAT_MA1F_MASK | LPUART_STAT_PF_MASK | LPUART_STAT_FE_MASK | LPUART_STAT_NF_MASK | LPUART_STAT_OR_MASK | LPUART_STAT_IDLE_MASK | LPUART_STAT_LBKDIF_MASK), LPUART_STAT_RXEDGIF(value)))
#define LPUART_BWR_STAT_RXEDGIF(base, value) (BME_BFI32(&LPUART_STAT_REG(base), ((uint32_t)(value) << LPUART_STAT_RXEDGIF_SHIFT), LPUART_STAT_RXEDGIF_SHIFT, LPUART_STAT_RXEDGIF_WIDTH))
/*@}*/

/*!
 * @name Register LPUART_STAT, field LBKDIF[31] (W1C)
 *
 * LBKDIF is set when the LIN break detect circuitry is enabled and a LIN break
 * character is detected. LBKDIF is cleared by writing a 1 to it.
 *
 * Values:
 * - 0 - No LIN break character has been detected.
 * - 1 - LIN break character has been detected.
 */
/*@{*/
/*! @brief Read current value of the LPUART_STAT_LBKDIF field. */
#define LPUART_RD_STAT_LBKDIF(base) ((LPUART_STAT_REG(base) & LPUART_STAT_LBKDIF_MASK) >> LPUART_STAT_LBKDIF_SHIFT)
#define LPUART_BRD_STAT_LBKDIF(base) (BME_UBFX32(&LPUART_STAT_REG(base), LPUART_STAT_LBKDIF_SHIFT, LPUART_STAT_LBKDIF_WIDTH))

/*! @brief Set the LBKDIF field to a new value. */
#define LPUART_WR_STAT_LBKDIF(base, value) (LPUART_RMW_STAT(base, (LPUART_STAT_LBKDIF_MASK | LPUART_STAT_MA2F_MASK | LPUART_STAT_MA1F_MASK | LPUART_STAT_PF_MASK | LPUART_STAT_FE_MASK | LPUART_STAT_NF_MASK | LPUART_STAT_OR_MASK | LPUART_STAT_IDLE_MASK | LPUART_STAT_RXEDGIF_MASK), LPUART_STAT_LBKDIF(value)))
#define LPUART_BWR_STAT_LBKDIF(base, value) (BME_BFI32(&LPUART_STAT_REG(base), ((uint32_t)(value) << LPUART_STAT_LBKDIF_SHIFT), LPUART_STAT_LBKDIF_SHIFT, LPUART_STAT_LBKDIF_WIDTH))
/*@}*/

/*******************************************************************************
 * LPUART_CTRL - LPUART Control Register
 ******************************************************************************/

/*!
 * @brief LPUART_CTRL - LPUART Control Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * This read/write register controls various optional features of the LPUART
 * system. This register should only be altered when the transmitter and receiver
 * are both disabled.
 */
/*!
 * @name Constants and macros for entire LPUART_CTRL register
 */
/*@{*/
#define LPUART_RD_CTRL(base)     (LPUART_CTRL_REG(base))
#define LPUART_WR_CTRL(base, value) (LPUART_CTRL_REG(base) = (value))
#define LPUART_RMW_CTRL(base, mask, value) (LPUART_WR_CTRL(base, (LPUART_RD_CTRL(base) & ~(mask)) | (value)))
#define LPUART_SET_CTRL(base, value) (BME_OR32(&LPUART_CTRL_REG(base), (uint32_t)(value)))
#define LPUART_CLR_CTRL(base, value) (BME_AND32(&LPUART_CTRL_REG(base), (uint32_t)(~(value))))
#define LPUART_TOG_CTRL(base, value) (BME_XOR32(&LPUART_CTRL_REG(base), (uint32_t)(value)))
/*@}*/

/*
 * Constants & macros for individual LPUART_CTRL bitfields
 */

/*!
 * @name Register LPUART_CTRL, field PT[0] (RW)
 *
 * Provided parity is enabled (PE = 1), this bit selects even or odd parity. Odd
 * parity means the total number of 1s in the data character, including the
 * parity bit, is odd. Even parity means the total number of 1s in the data
 * character, including the parity bit, is even.
 *
 * Values:
 * - 0 - Even parity.
 * - 1 - Odd parity.
 */
/*@{*/
/*! @brief Read current value of the LPUART_CTRL_PT field. */
#define LPUART_RD_CTRL_PT(base) ((LPUART_CTRL_REG(base) & LPUART_CTRL_PT_MASK) >> LPUART_CTRL_PT_SHIFT)
#define LPUART_BRD_CTRL_PT(base) (BME_UBFX32(&LPUART_CTRL_REG(base), LPUART_CTRL_PT_SHIFT, LPUART_CTRL_PT_WIDTH))

/*! @brief Set the PT field to a new value. */
#define LPUART_WR_CTRL_PT(base, value) (LPUART_RMW_CTRL(base, LPUART_CTRL_PT_MASK, LPUART_CTRL_PT(value)))
#define LPUART_BWR_CTRL_PT(base, value) (BME_BFI32(&LPUART_CTRL_REG(base), ((uint32_t)(value) << LPUART_CTRL_PT_SHIFT), LPUART_CTRL_PT_SHIFT, LPUART_CTRL_PT_WIDTH))
/*@}*/

/*!
 * @name Register LPUART_CTRL, field PE[1] (RW)
 *
 * Enables hardware parity generation and checking. When parity is enabled, the
 * bit immediately before the stop bit is treated as the parity bit.
 *
 * Values:
 * - 0 - No hardware parity generation or checking.
 * - 1 - Parity enabled.
 */
/*@{*/
/*! @brief Read current value of the LPUART_CTRL_PE field. */
#define LPUART_RD_CTRL_PE(base) ((LPUART_CTRL_REG(base) & LPUART_CTRL_PE_MASK) >> LPUART_CTRL_PE_SHIFT)
#define LPUART_BRD_CTRL_PE(base) (BME_UBFX32(&LPUART_CTRL_REG(base), LPUART_CTRL_PE_SHIFT, LPUART_CTRL_PE_WIDTH))

/*! @brief Set the PE field to a new value. */
#define LPUART_WR_CTRL_PE(base, value) (LPUART_RMW_CTRL(base, LPUART_CTRL_PE_MASK, LPUART_CTRL_PE(value)))
#define LPUART_BWR_CTRL_PE(base, value) (BME_BFI32(&LPUART_CTRL_REG(base), ((uint32_t)(value) << LPUART_CTRL_PE_SHIFT), LPUART_CTRL_PE_SHIFT, LPUART_CTRL_PE_WIDTH))
/*@}*/

/*!
 * @name Register LPUART_CTRL, field ILT[2] (RW)
 *
 * Determines when the receiver starts counting logic 1s as idle character bits.
 * The count begins either after a valid start bit or after the stop bit. If the
 * count begins after the start bit, then a string of logic 1s preceding the
 * stop bit can cause false recognition of an idle character. Beginning the count
 * after the stop bit avoids false idle character recognition, but requires
 * properly synchronized transmissions. In case the LPUART is programmed with ILT = 1, a
 * logic 0 is automatically shifted after a received stop bit, therefore
 * resetting the idle count.
 *
 * Values:
 * - 0 - Idle character bit count starts after start bit.
 * - 1 - Idle character bit count starts after stop bit.
 */
/*@{*/
/*! @brief Read current value of the LPUART_CTRL_ILT field. */
#define LPUART_RD_CTRL_ILT(base) ((LPUART_CTRL_REG(base) & LPUART_CTRL_ILT_MASK) >> LPUART_CTRL_ILT_SHIFT)
#define LPUART_BRD_CTRL_ILT(base) (BME_UBFX32(&LPUART_CTRL_REG(base), LPUART_CTRL_ILT_SHIFT, LPUART_CTRL_ILT_WIDTH))

/*! @brief Set the ILT field to a new value. */
#define LPUART_WR_CTRL_ILT(base, value) (LPUART_RMW_CTRL(base, LPUART_CTRL_ILT_MASK, LPUART_CTRL_ILT(value)))
#define LPUART_BWR_CTRL_ILT(base, value) (BME_BFI32(&LPUART_CTRL_REG(base), ((uint32_t)(value) << LPUART_CTRL_ILT_SHIFT), LPUART_CTRL_ILT_SHIFT, LPUART_CTRL_ILT_WIDTH))
/*@}*/

/*!
 * @name Register LPUART_CTRL, field WAKE[3] (RW)
 *
 * Determines which condition wakes the LPUART when RWU=1: Address mark in the
 * most significant bit position of a received data character, or An idle
 * condition on the receive pin input signal.
 *
 * Values:
 * - 0 - Configures RWU for idle-line wakeup.
 * - 1 - Configures RWU with address-mark wakeup.
 */
/*@{*/
/*! @brief Read current value of the LPUART_CTRL_WAKE field. */
#define LPUART_RD_CTRL_WAKE(base) ((LPUART_CTRL_REG(base) & LPUART_CTRL_WAKE_MASK) >> LPUART_CTRL_WAKE_SHIFT)
#define LPUART_BRD_CTRL_WAKE(base) (BME_UBFX32(&LPUART_CTRL_REG(base), LPUART_CTRL_WAKE_SHIFT, LPUART_CTRL_WAKE_WIDTH))

/*! @brief Set the WAKE field to a new value. */
#define LPUART_WR_CTRL_WAKE(base, value) (LPUART_RMW_CTRL(base, LPUART_CTRL_WAKE_MASK, LPUART_CTRL_WAKE(value)))
#define LPUART_BWR_CTRL_WAKE(base, value) (BME_BFI32(&LPUART_CTRL_REG(base), ((uint32_t)(value) << LPUART_CTRL_WAKE_SHIFT), LPUART_CTRL_WAKE_SHIFT, LPUART_CTRL_WAKE_WIDTH))
/*@}*/

/*!
 * @name Register LPUART_CTRL, field M[4] (RW)
 *
 * Values:
 * - 0 - Receiver and transmitter use 8-bit data characters.
 * - 1 - Receiver and transmitter use 9-bit data characters.
 */
/*@{*/
/*! @brief Read current value of the LPUART_CTRL_M field. */
#define LPUART_RD_CTRL_M(base) ((LPUART_CTRL_REG(base) & LPUART_CTRL_M_MASK) >> LPUART_CTRL_M_SHIFT)
#define LPUART_BRD_CTRL_M(base) (BME_UBFX32(&LPUART_CTRL_REG(base), LPUART_CTRL_M_SHIFT, LPUART_CTRL_M_WIDTH))

/*! @brief Set the M field to a new value. */
#define LPUART_WR_CTRL_M(base, value) (LPUART_RMW_CTRL(base, LPUART_CTRL_M_MASK, LPUART_CTRL_M(value)))
#define LPUART_BWR_CTRL_M(base, value) (BME_BFI32(&LPUART_CTRL_REG(base), ((uint32_t)(value) << LPUART_CTRL_M_SHIFT), LPUART_CTRL_M_SHIFT, LPUART_CTRL_M_WIDTH))
/*@}*/

/*!
 * @name Register LPUART_CTRL, field RSRC[5] (RW)
 *
 * This field has no meaning or effect unless the LOOPS field is set. When LOOPS
 * is set, the RSRC field determines the source for the receiver shift register
 * input.
 *
 * Values:
 * - 0 - Provided LOOPS is set, RSRC is cleared, selects internal loop back mode
 *     and the LPUART does not use the LPUART_RX pin.
 * - 1 - Single-wire LPUART mode where the LPUART_TX pin is connected to the
 *     transmitter output and receiver input.
 */
/*@{*/
/*! @brief Read current value of the LPUART_CTRL_RSRC field. */
#define LPUART_RD_CTRL_RSRC(base) ((LPUART_CTRL_REG(base) & LPUART_CTRL_RSRC_MASK) >> LPUART_CTRL_RSRC_SHIFT)
#define LPUART_BRD_CTRL_RSRC(base) (BME_UBFX32(&LPUART_CTRL_REG(base), LPUART_CTRL_RSRC_SHIFT, LPUART_CTRL_RSRC_WIDTH))

/*! @brief Set the RSRC field to a new value. */
#define LPUART_WR_CTRL_RSRC(base, value) (LPUART_RMW_CTRL(base, LPUART_CTRL_RSRC_MASK, LPUART_CTRL_RSRC(value)))
#define LPUART_BWR_CTRL_RSRC(base, value) (BME_BFI32(&LPUART_CTRL_REG(base), ((uint32_t)(value) << LPUART_CTRL_RSRC_SHIFT), LPUART_CTRL_RSRC_SHIFT, LPUART_CTRL_RSRC_WIDTH))
/*@}*/

/*!
 * @name Register LPUART_CTRL, field DOZEEN[6] (RW)
 *
 * Values:
 * - 0 - LPUART is enabled in Doze mode.
 * - 1 - LPUART is disabled in Doze mode.
 */
/*@{*/
/*! @brief Read current value of the LPUART_CTRL_DOZEEN field. */
#define LPUART_RD_CTRL_DOZEEN(base) ((LPUART_CTRL_REG(base) & LPUART_CTRL_DOZEEN_MASK) >> LPUART_CTRL_DOZEEN_SHIFT)
#define LPUART_BRD_CTRL_DOZEEN(base) (BME_UBFX32(&LPUART_CTRL_REG(base), LPUART_CTRL_DOZEEN_SHIFT, LPUART_CTRL_DOZEEN_WIDTH))

/*! @brief Set the DOZEEN field to a new value. */
#define LPUART_WR_CTRL_DOZEEN(base, value) (LPUART_RMW_CTRL(base, LPUART_CTRL_DOZEEN_MASK, LPUART_CTRL_DOZEEN(value)))
#define LPUART_BWR_CTRL_DOZEEN(base, value) (BME_BFI32(&LPUART_CTRL_REG(base), ((uint32_t)(value) << LPUART_CTRL_DOZEEN_SHIFT), LPUART_CTRL_DOZEEN_SHIFT, LPUART_CTRL_DOZEEN_WIDTH))
/*@}*/

/*!
 * @name Register LPUART_CTRL, field LOOPS[7] (RW)
 *
 * When LOOPS is set, the LPUART_RX pin is disconnected from the LPUART and the
 * transmitter output is internally connected to the receiver input. The
 * transmitter and the receiver must be enabled to use the loop function.
 *
 * Values:
 * - 0 - Normal operation - LPUART_RX and LPUART_TX use separate pins.
 * - 1 - Loop mode or single-wire mode where transmitter outputs are internally
 *     connected to receiver input (see RSRC bit).
 */
/*@{*/
/*! @brief Read current value of the LPUART_CTRL_LOOPS field. */
#define LPUART_RD_CTRL_LOOPS(base) ((LPUART_CTRL_REG(base) & LPUART_CTRL_LOOPS_MASK) >> LPUART_CTRL_LOOPS_SHIFT)
#define LPUART_BRD_CTRL_LOOPS(base) (BME_UBFX32(&LPUART_CTRL_REG(base), LPUART_CTRL_LOOPS_SHIFT, LPUART_CTRL_LOOPS_WIDTH))

/*! @brief Set the LOOPS field to a new value. */
#define LPUART_WR_CTRL_LOOPS(base, value) (LPUART_RMW_CTRL(base, LPUART_CTRL_LOOPS_MASK, LPUART_CTRL_LOOPS(value)))
#define LPUART_BWR_CTRL_LOOPS(base, value) (BME_BFI32(&LPUART_CTRL_REG(base), ((uint32_t)(value) << LPUART_CTRL_LOOPS_SHIFT), LPUART_CTRL_LOOPS_SHIFT, LPUART_CTRL_LOOPS_WIDTH))
/*@}*/

/*!
 * @name Register LPUART_CTRL, field IDLECFG[10:8] (RW)
 *
 * Configures the number of idle characters that must be received before the
 * IDLE flag is set.
 *
 * Values:
 * - 000 - 1 idle character
 * - 001 - 2 idle characters
 * - 010 - 4 idle characters
 * - 011 - 8 idle characters
 * - 100 - 16 idle characters
 * - 101 - 32 idle characters
 * - 110 - 64 idle characters
 * - 111 - 128 idle characters
 */
/*@{*/
/*! @brief Read current value of the LPUART_CTRL_IDLECFG field. */
#define LPUART_RD_CTRL_IDLECFG(base) ((LPUART_CTRL_REG(base) & LPUART_CTRL_IDLECFG_MASK) >> LPUART_CTRL_IDLECFG_SHIFT)
#define LPUART_BRD_CTRL_IDLECFG(base) (BME_UBFX32(&LPUART_CTRL_REG(base), LPUART_CTRL_IDLECFG_SHIFT, LPUART_CTRL_IDLECFG_WIDTH))

/*! @brief Set the IDLECFG field to a new value. */
#define LPUART_WR_CTRL_IDLECFG(base, value) (LPUART_RMW_CTRL(base, LPUART_CTRL_IDLECFG_MASK, LPUART_CTRL_IDLECFG(value)))
#define LPUART_BWR_CTRL_IDLECFG(base, value) (BME_BFI32(&LPUART_CTRL_REG(base), ((uint32_t)(value) << LPUART_CTRL_IDLECFG_SHIFT), LPUART_CTRL_IDLECFG_SHIFT, LPUART_CTRL_IDLECFG_WIDTH))
/*@}*/

/*!
 * @name Register LPUART_CTRL, field MA2IE[14] (RW)
 *
 * Values:
 * - 0 - MA2F interrupt disabled
 * - 1 - MA2F interrupt enabled
 */
/*@{*/
/*! @brief Read current value of the LPUART_CTRL_MA2IE field. */
#define LPUART_RD_CTRL_MA2IE(base) ((LPUART_CTRL_REG(base) & LPUART_CTRL_MA2IE_MASK) >> LPUART_CTRL_MA2IE_SHIFT)
#define LPUART_BRD_CTRL_MA2IE(base) (BME_UBFX32(&LPUART_CTRL_REG(base), LPUART_CTRL_MA2IE_SHIFT, LPUART_CTRL_MA2IE_WIDTH))

/*! @brief Set the MA2IE field to a new value. */
#define LPUART_WR_CTRL_MA2IE(base, value) (LPUART_RMW_CTRL(base, LPUART_CTRL_MA2IE_MASK, LPUART_CTRL_MA2IE(value)))
#define LPUART_BWR_CTRL_MA2IE(base, value) (BME_BFI32(&LPUART_CTRL_REG(base), ((uint32_t)(value) << LPUART_CTRL_MA2IE_SHIFT), LPUART_CTRL_MA2IE_SHIFT, LPUART_CTRL_MA2IE_WIDTH))
/*@}*/

/*!
 * @name Register LPUART_CTRL, field MA1IE[15] (RW)
 *
 * Values:
 * - 0 - MA1F interrupt disabled
 * - 1 - MA1F interrupt enabled
 */
/*@{*/
/*! @brief Read current value of the LPUART_CTRL_MA1IE field. */
#define LPUART_RD_CTRL_MA1IE(base) ((LPUART_CTRL_REG(base) & LPUART_CTRL_MA1IE_MASK) >> LPUART_CTRL_MA1IE_SHIFT)
#define LPUART_BRD_CTRL_MA1IE(base) (BME_UBFX32(&LPUART_CTRL_REG(base), LPUART_CTRL_MA1IE_SHIFT, LPUART_CTRL_MA1IE_WIDTH))

/*! @brief Set the MA1IE field to a new value. */
#define LPUART_WR_CTRL_MA1IE(base, value) (LPUART_RMW_CTRL(base, LPUART_CTRL_MA1IE_MASK, LPUART_CTRL_MA1IE(value)))
#define LPUART_BWR_CTRL_MA1IE(base, value) (BME_BFI32(&LPUART_CTRL_REG(base), ((uint32_t)(value) << LPUART_CTRL_MA1IE_SHIFT), LPUART_CTRL_MA1IE_SHIFT, LPUART_CTRL_MA1IE_WIDTH))
/*@}*/

/*!
 * @name Register LPUART_CTRL, field SBK[16] (RW)
 *
 * Writing a 1 and then a 0 to SBK queues a break character in the transmit data
 * stream. Additional break characters of 10 to 13, or 13 to 16 if
 * LPUART_STATBRK13] is set, bit times of logic 0 are queued as long as SBK is set. Depending
 * on the timing of the set and clear of SBK relative to the information
 * currently being transmitted, a second break character may be queued before software
 * clears SBK.
 *
 * Values:
 * - 0 - Normal transmitter operation.
 * - 1 - Queue break character(s) to be sent.
 */
/*@{*/
/*! @brief Read current value of the LPUART_CTRL_SBK field. */
#define LPUART_RD_CTRL_SBK(base) ((LPUART_CTRL_REG(base) & LPUART_CTRL_SBK_MASK) >> LPUART_CTRL_SBK_SHIFT)
#define LPUART_BRD_CTRL_SBK(base) (BME_UBFX32(&LPUART_CTRL_REG(base), LPUART_CTRL_SBK_SHIFT, LPUART_CTRL_SBK_WIDTH))

/*! @brief Set the SBK field to a new value. */
#define LPUART_WR_CTRL_SBK(base, value) (LPUART_RMW_CTRL(base, LPUART_CTRL_SBK_MASK, LPUART_CTRL_SBK(value)))
#define LPUART_BWR_CTRL_SBK(base, value) (BME_BFI32(&LPUART_CTRL_REG(base), ((uint32_t)(value) << LPUART_CTRL_SBK_SHIFT), LPUART_CTRL_SBK_SHIFT, LPUART_CTRL_SBK_WIDTH))
/*@}*/

/*!
 * @name Register LPUART_CTRL, field RWU[17] (RW)
 *
 * This field can be set to place the LPUART receiver in a standby state. RWU
 * automatically clears when an RWU event occurs, that is, an IDLE event when
 * CTRL[WAKE] is clear or an address match when CTRL[WAKE] is set with STAT[RWUID] is
 * clear. RWU must be set only with CTRL[WAKE] = 0 (wakeup on idle) if the
 * channel is currently not idle. This can be determined by STAT[RAF]. If the flag is
 * set to wake up an IDLE event and the channel is already idle, it is possible
 * that the LPUART will discard data. This is because the data must be received or
 * a LIN break detected after an IDLE is detected before IDLE is allowed to
 * reasserted.
 *
 * Values:
 * - 0 - Normal receiver operation.
 * - 1 - LPUART receiver in standby waiting for wakeup condition.
 */
/*@{*/
/*! @brief Read current value of the LPUART_CTRL_RWU field. */
#define LPUART_RD_CTRL_RWU(base) ((LPUART_CTRL_REG(base) & LPUART_CTRL_RWU_MASK) >> LPUART_CTRL_RWU_SHIFT)
#define LPUART_BRD_CTRL_RWU(base) (BME_UBFX32(&LPUART_CTRL_REG(base), LPUART_CTRL_RWU_SHIFT, LPUART_CTRL_RWU_WIDTH))

/*! @brief Set the RWU field to a new value. */
#define LPUART_WR_CTRL_RWU(base, value) (LPUART_RMW_CTRL(base, LPUART_CTRL_RWU_MASK, LPUART_CTRL_RWU(value)))
#define LPUART_BWR_CTRL_RWU(base, value) (BME_BFI32(&LPUART_CTRL_REG(base), ((uint32_t)(value) << LPUART_CTRL_RWU_SHIFT), LPUART_CTRL_RWU_SHIFT, LPUART_CTRL_RWU_WIDTH))
/*@}*/

/*!
 * @name Register LPUART_CTRL, field RE[18] (RW)
 *
 * Enables the LPUART receiver. When RE is written to 0, this register bit will
 * read as 1 until the receiver finishes receiving the current character (if any).
 *
 * Values:
 * - 0 - Receiver disabled.
 * - 1 - Receiver enabled.
 */
/*@{*/
/*! @brief Read current value of the LPUART_CTRL_RE field. */
#define LPUART_RD_CTRL_RE(base) ((LPUART_CTRL_REG(base) & LPUART_CTRL_RE_MASK) >> LPUART_CTRL_RE_SHIFT)
#define LPUART_BRD_CTRL_RE(base) (BME_UBFX32(&LPUART_CTRL_REG(base), LPUART_CTRL_RE_SHIFT, LPUART_CTRL_RE_WIDTH))

/*! @brief Set the RE field to a new value. */
#define LPUART_WR_CTRL_RE(base, value) (LPUART_RMW_CTRL(base, LPUART_CTRL_RE_MASK, LPUART_CTRL_RE(value)))
#define LPUART_BWR_CTRL_RE(base, value) (BME_BFI32(&LPUART_CTRL_REG(base), ((uint32_t)(value) << LPUART_CTRL_RE_SHIFT), LPUART_CTRL_RE_SHIFT, LPUART_CTRL_RE_WIDTH))
/*@}*/

/*!
 * @name Register LPUART_CTRL, field TE[19] (RW)
 *
 * Enables the LPUART transmitter. TE can also be used to queue an idle preamble
 * by clearing and then setting TE. When TE is cleared, this register bit will
 * read as 1 until the transmitter has completed the current character and the
 * LPUART_TX pin is tristated.
 *
 * Values:
 * - 0 - Transmitter disabled.
 * - 1 - Transmitter enabled.
 */
/*@{*/
/*! @brief Read current value of the LPUART_CTRL_TE field. */
#define LPUART_RD_CTRL_TE(base) ((LPUART_CTRL_REG(base) & LPUART_CTRL_TE_MASK) >> LPUART_CTRL_TE_SHIFT)
#define LPUART_BRD_CTRL_TE(base) (BME_UBFX32(&LPUART_CTRL_REG(base), LPUART_CTRL_TE_SHIFT, LPUART_CTRL_TE_WIDTH))

/*! @brief Set the TE field to a new value. */
#define LPUART_WR_CTRL_TE(base, value) (LPUART_RMW_CTRL(base, LPUART_CTRL_TE_MASK, LPUART_CTRL_TE(value)))
#define LPUART_BWR_CTRL_TE(base, value) (BME_BFI32(&LPUART_CTRL_REG(base), ((uint32_t)(value) << LPUART_CTRL_TE_SHIFT), LPUART_CTRL_TE_SHIFT, LPUART_CTRL_TE_WIDTH))
/*@}*/

/*!
 * @name Register LPUART_CTRL, field ILIE[20] (RW)
 *
 * ILIE enables the idle line flag, STAT[IDLE], to generate interrupt requests.
 *
 * Values:
 * - 0 - Hardware interrupts from IDLE disabled; use polling.
 * - 1 - Hardware interrupt requested when IDLE flag is 1.
 */
/*@{*/
/*! @brief Read current value of the LPUART_CTRL_ILIE field. */
#define LPUART_RD_CTRL_ILIE(base) ((LPUART_CTRL_REG(base) & LPUART_CTRL_ILIE_MASK) >> LPUART_CTRL_ILIE_SHIFT)
#define LPUART_BRD_CTRL_ILIE(base) (BME_UBFX32(&LPUART_CTRL_REG(base), LPUART_CTRL_ILIE_SHIFT, LPUART_CTRL_ILIE_WIDTH))

/*! @brief Set the ILIE field to a new value. */
#define LPUART_WR_CTRL_ILIE(base, value) (LPUART_RMW_CTRL(base, LPUART_CTRL_ILIE_MASK, LPUART_CTRL_ILIE(value)))
#define LPUART_BWR_CTRL_ILIE(base, value) (BME_BFI32(&LPUART_CTRL_REG(base), ((uint32_t)(value) << LPUART_CTRL_ILIE_SHIFT), LPUART_CTRL_ILIE_SHIFT, LPUART_CTRL_ILIE_WIDTH))
/*@}*/

/*!
 * @name Register LPUART_CTRL, field RIE[21] (RW)
 *
 * Enables STAT[RDRF] to generate interrupt requests.
 *
 * Values:
 * - 0 - Hardware interrupts from RDRF disabled; use polling.
 * - 1 - Hardware interrupt requested when RDRF flag is 1.
 */
/*@{*/
/*! @brief Read current value of the LPUART_CTRL_RIE field. */
#define LPUART_RD_CTRL_RIE(base) ((LPUART_CTRL_REG(base) & LPUART_CTRL_RIE_MASK) >> LPUART_CTRL_RIE_SHIFT)
#define LPUART_BRD_CTRL_RIE(base) (BME_UBFX32(&LPUART_CTRL_REG(base), LPUART_CTRL_RIE_SHIFT, LPUART_CTRL_RIE_WIDTH))

/*! @brief Set the RIE field to a new value. */
#define LPUART_WR_CTRL_RIE(base, value) (LPUART_RMW_CTRL(base, LPUART_CTRL_RIE_MASK, LPUART_CTRL_RIE(value)))
#define LPUART_BWR_CTRL_RIE(base, value) (BME_BFI32(&LPUART_CTRL_REG(base), ((uint32_t)(value) << LPUART_CTRL_RIE_SHIFT), LPUART_CTRL_RIE_SHIFT, LPUART_CTRL_RIE_WIDTH))
/*@}*/

/*!
 * @name Register LPUART_CTRL, field TCIE[22] (RW)
 *
 * TCIE enables the transmission complete flag, TC, to generate interrupt
 * requests.
 *
 * Values:
 * - 0 - Hardware interrupts from TC disabled; use polling.
 * - 1 - Hardware interrupt requested when TC flag is 1.
 */
/*@{*/
/*! @brief Read current value of the LPUART_CTRL_TCIE field. */
#define LPUART_RD_CTRL_TCIE(base) ((LPUART_CTRL_REG(base) & LPUART_CTRL_TCIE_MASK) >> LPUART_CTRL_TCIE_SHIFT)
#define LPUART_BRD_CTRL_TCIE(base) (BME_UBFX32(&LPUART_CTRL_REG(base), LPUART_CTRL_TCIE_SHIFT, LPUART_CTRL_TCIE_WIDTH))

/*! @brief Set the TCIE field to a new value. */
#define LPUART_WR_CTRL_TCIE(base, value) (LPUART_RMW_CTRL(base, LPUART_CTRL_TCIE_MASK, LPUART_CTRL_TCIE(value)))
#define LPUART_BWR_CTRL_TCIE(base, value) (BME_BFI32(&LPUART_CTRL_REG(base), ((uint32_t)(value) << LPUART_CTRL_TCIE_SHIFT), LPUART_CTRL_TCIE_SHIFT, LPUART_CTRL_TCIE_WIDTH))
/*@}*/

/*!
 * @name Register LPUART_CTRL, field TIE[23] (RW)
 *
 * Enables STAT[TDRE] to generate interrupt requests.
 *
 * Values:
 * - 0 - Hardware interrupts from TDRE disabled; use polling.
 * - 1 - Hardware interrupt requested when TDRE flag is 1.
 */
/*@{*/
/*! @brief Read current value of the LPUART_CTRL_TIE field. */
#define LPUART_RD_CTRL_TIE(base) ((LPUART_CTRL_REG(base) & LPUART_CTRL_TIE_MASK) >> LPUART_CTRL_TIE_SHIFT)
#define LPUART_BRD_CTRL_TIE(base) (BME_UBFX32(&LPUART_CTRL_REG(base), LPUART_CTRL_TIE_SHIFT, LPUART_CTRL_TIE_WIDTH))

/*! @brief Set the TIE field to a new value. */
#define LPUART_WR_CTRL_TIE(base, value) (LPUART_RMW_CTRL(base, LPUART_CTRL_TIE_MASK, LPUART_CTRL_TIE(value)))
#define LPUART_BWR_CTRL_TIE(base, value) (BME_BFI32(&LPUART_CTRL_REG(base), ((uint32_t)(value) << LPUART_CTRL_TIE_SHIFT), LPUART_CTRL_TIE_SHIFT, LPUART_CTRL_TIE_WIDTH))
/*@}*/

/*!
 * @name Register LPUART_CTRL, field PEIE[24] (RW)
 *
 * This bit enables the parity error flag (PF) to generate hardware interrupt
 * requests.
 *
 * Values:
 * - 0 - PF interrupts disabled; use polling).
 * - 1 - Hardware interrupt requested when PF is set.
 */
/*@{*/
/*! @brief Read current value of the LPUART_CTRL_PEIE field. */
#define LPUART_RD_CTRL_PEIE(base) ((LPUART_CTRL_REG(base) & LPUART_CTRL_PEIE_MASK) >> LPUART_CTRL_PEIE_SHIFT)
#define LPUART_BRD_CTRL_PEIE(base) (BME_UBFX32(&LPUART_CTRL_REG(base), LPUART_CTRL_PEIE_SHIFT, LPUART_CTRL_PEIE_WIDTH))

/*! @brief Set the PEIE field to a new value. */
#define LPUART_WR_CTRL_PEIE(base, value) (LPUART_RMW_CTRL(base, LPUART_CTRL_PEIE_MASK, LPUART_CTRL_PEIE(value)))
#define LPUART_BWR_CTRL_PEIE(base, value) (BME_BFI32(&LPUART_CTRL_REG(base), ((uint32_t)(value) << LPUART_CTRL_PEIE_SHIFT), LPUART_CTRL_PEIE_SHIFT, LPUART_CTRL_PEIE_WIDTH))
/*@}*/

/*!
 * @name Register LPUART_CTRL, field FEIE[25] (RW)
 *
 * This bit enables the framing error flag (FE) to generate hardware interrupt
 * requests.
 *
 * Values:
 * - 0 - FE interrupts disabled; use polling.
 * - 1 - Hardware interrupt requested when FE is set.
 */
/*@{*/
/*! @brief Read current value of the LPUART_CTRL_FEIE field. */
#define LPUART_RD_CTRL_FEIE(base) ((LPUART_CTRL_REG(base) & LPUART_CTRL_FEIE_MASK) >> LPUART_CTRL_FEIE_SHIFT)
#define LPUART_BRD_CTRL_FEIE(base) (BME_UBFX32(&LPUART_CTRL_REG(base), LPUART_CTRL_FEIE_SHIFT, LPUART_CTRL_FEIE_WIDTH))

/*! @brief Set the FEIE field to a new value. */
#define LPUART_WR_CTRL_FEIE(base, value) (LPUART_RMW_CTRL(base, LPUART_CTRL_FEIE_MASK, LPUART_CTRL_FEIE(value)))
#define LPUART_BWR_CTRL_FEIE(base, value) (BME_BFI32(&LPUART_CTRL_REG(base), ((uint32_t)(value) << LPUART_CTRL_FEIE_SHIFT), LPUART_CTRL_FEIE_SHIFT, LPUART_CTRL_FEIE_WIDTH))
/*@}*/

/*!
 * @name Register LPUART_CTRL, field NEIE[26] (RW)
 *
 * This bit enables the noise flag (NF) to generate hardware interrupt requests.
 *
 * Values:
 * - 0 - NF interrupts disabled; use polling.
 * - 1 - Hardware interrupt requested when NF is set.
 */
/*@{*/
/*! @brief Read current value of the LPUART_CTRL_NEIE field. */
#define LPUART_RD_CTRL_NEIE(base) ((LPUART_CTRL_REG(base) & LPUART_CTRL_NEIE_MASK) >> LPUART_CTRL_NEIE_SHIFT)
#define LPUART_BRD_CTRL_NEIE(base) (BME_UBFX32(&LPUART_CTRL_REG(base), LPUART_CTRL_NEIE_SHIFT, LPUART_CTRL_NEIE_WIDTH))

/*! @brief Set the NEIE field to a new value. */
#define LPUART_WR_CTRL_NEIE(base, value) (LPUART_RMW_CTRL(base, LPUART_CTRL_NEIE_MASK, LPUART_CTRL_NEIE(value)))
#define LPUART_BWR_CTRL_NEIE(base, value) (BME_BFI32(&LPUART_CTRL_REG(base), ((uint32_t)(value) << LPUART_CTRL_NEIE_SHIFT), LPUART_CTRL_NEIE_SHIFT, LPUART_CTRL_NEIE_WIDTH))
/*@}*/

/*!
 * @name Register LPUART_CTRL, field ORIE[27] (RW)
 *
 * This bit enables the overrun flag (OR) to generate hardware interrupt
 * requests.
 *
 * Values:
 * - 0 - OR interrupts disabled; use polling.
 * - 1 - Hardware interrupt requested when OR is set.
 */
/*@{*/
/*! @brief Read current value of the LPUART_CTRL_ORIE field. */
#define LPUART_RD_CTRL_ORIE(base) ((LPUART_CTRL_REG(base) & LPUART_CTRL_ORIE_MASK) >> LPUART_CTRL_ORIE_SHIFT)
#define LPUART_BRD_CTRL_ORIE(base) (BME_UBFX32(&LPUART_CTRL_REG(base), LPUART_CTRL_ORIE_SHIFT, LPUART_CTRL_ORIE_WIDTH))

/*! @brief Set the ORIE field to a new value. */
#define LPUART_WR_CTRL_ORIE(base, value) (LPUART_RMW_CTRL(base, LPUART_CTRL_ORIE_MASK, LPUART_CTRL_ORIE(value)))
#define LPUART_BWR_CTRL_ORIE(base, value) (BME_BFI32(&LPUART_CTRL_REG(base), ((uint32_t)(value) << LPUART_CTRL_ORIE_SHIFT), LPUART_CTRL_ORIE_SHIFT, LPUART_CTRL_ORIE_WIDTH))
/*@}*/

/*!
 * @name Register LPUART_CTRL, field TXINV[28] (RW)
 *
 * Setting this bit reverses the polarity of the transmitted data output.
 * Setting TXINV inverts the LPUART_TX output for all cases: data bits, start and stop
 * bits, break, and idle.
 *
 * Values:
 * - 0 - Transmit data not inverted.
 * - 1 - Transmit data inverted.
 */
/*@{*/
/*! @brief Read current value of the LPUART_CTRL_TXINV field. */
#define LPUART_RD_CTRL_TXINV(base) ((LPUART_CTRL_REG(base) & LPUART_CTRL_TXINV_MASK) >> LPUART_CTRL_TXINV_SHIFT)
#define LPUART_BRD_CTRL_TXINV(base) (BME_UBFX32(&LPUART_CTRL_REG(base), LPUART_CTRL_TXINV_SHIFT, LPUART_CTRL_TXINV_WIDTH))

/*! @brief Set the TXINV field to a new value. */
#define LPUART_WR_CTRL_TXINV(base, value) (LPUART_RMW_CTRL(base, LPUART_CTRL_TXINV_MASK, LPUART_CTRL_TXINV(value)))
#define LPUART_BWR_CTRL_TXINV(base, value) (BME_BFI32(&LPUART_CTRL_REG(base), ((uint32_t)(value) << LPUART_CTRL_TXINV_SHIFT), LPUART_CTRL_TXINV_SHIFT, LPUART_CTRL_TXINV_WIDTH))
/*@}*/

/*!
 * @name Register LPUART_CTRL, field TXDIR[29] (RW)
 *
 * When the LPUART is configured for single-wire half-duplex operation (LOOPS =
 * RSRC = 1), this bit determines the direction of data at the LPUART_TX pin.
 * When clearing TXDIR, the transmitter will finish receiving the current character
 * (if any) before the receiver starts receiving data from the LPUART_TX pin.
 *
 * Values:
 * - 0 - LPUART_TX pin is an input in single-wire mode.
 * - 1 - LPUART_TX pin is an output in single-wire mode.
 */
/*@{*/
/*! @brief Read current value of the LPUART_CTRL_TXDIR field. */
#define LPUART_RD_CTRL_TXDIR(base) ((LPUART_CTRL_REG(base) & LPUART_CTRL_TXDIR_MASK) >> LPUART_CTRL_TXDIR_SHIFT)
#define LPUART_BRD_CTRL_TXDIR(base) (BME_UBFX32(&LPUART_CTRL_REG(base), LPUART_CTRL_TXDIR_SHIFT, LPUART_CTRL_TXDIR_WIDTH))

/*! @brief Set the TXDIR field to a new value. */
#define LPUART_WR_CTRL_TXDIR(base, value) (LPUART_RMW_CTRL(base, LPUART_CTRL_TXDIR_MASK, LPUART_CTRL_TXDIR(value)))
#define LPUART_BWR_CTRL_TXDIR(base, value) (BME_BFI32(&LPUART_CTRL_REG(base), ((uint32_t)(value) << LPUART_CTRL_TXDIR_SHIFT), LPUART_CTRL_TXDIR_SHIFT, LPUART_CTRL_TXDIR_WIDTH))
/*@}*/

/*!
 * @name Register LPUART_CTRL, field R9T8[30] (RW)
 *
 * R9 is the tenth data bit received when the LPUART is configured for 10-bit
 * data formats. When reading 10-bit data, read R9 before reading LPUART_DATA T8 is
 * the ninth data bit received when the LPUART is configured for 9-bit or 10-bit
 * data formats. When writing 9-bit or 10-bit data, write T8 before writing
 * LPUART_DATA. If T8 does not need to change from its previous value, such as when
 * it is used to generate address mark or parity, they it need not be written each
 * time LPUART_DATA is written.
 */
/*@{*/
/*! @brief Read current value of the LPUART_CTRL_R9T8 field. */
#define LPUART_RD_CTRL_R9T8(base) ((LPUART_CTRL_REG(base) & LPUART_CTRL_R9T8_MASK) >> LPUART_CTRL_R9T8_SHIFT)
#define LPUART_BRD_CTRL_R9T8(base) (BME_UBFX32(&LPUART_CTRL_REG(base), LPUART_CTRL_R9T8_SHIFT, LPUART_CTRL_R9T8_WIDTH))

/*! @brief Set the R9T8 field to a new value. */
#define LPUART_WR_CTRL_R9T8(base, value) (LPUART_RMW_CTRL(base, LPUART_CTRL_R9T8_MASK, LPUART_CTRL_R9T8(value)))
#define LPUART_BWR_CTRL_R9T8(base, value) (BME_BFI32(&LPUART_CTRL_REG(base), ((uint32_t)(value) << LPUART_CTRL_R9T8_SHIFT), LPUART_CTRL_R9T8_SHIFT, LPUART_CTRL_R9T8_WIDTH))
/*@}*/

/*!
 * @name Register LPUART_CTRL, field R8T9[31] (RW)
 *
 * R8 is the ninth data bit received when the LPUART is configured for 9-bit or
 * 10-bit data formats. When reading 9-bit or 10-bit data, read R8 before reading
 * LPUART_DATA. T9 is the tenth data bit received when the LPUART is configured
 * for 10-bit data formats. When writing 10-bit data, write T9 before writing
 * LPUART_DATA. If T9 does not need to change from its previous value, such as when
 * it is used to generate address mark or parity, they it need not be written
 * each time LPUART_DATA is written.
 */
/*@{*/
/*! @brief Read current value of the LPUART_CTRL_R8T9 field. */
#define LPUART_RD_CTRL_R8T9(base) ((LPUART_CTRL_REG(base) & LPUART_CTRL_R8T9_MASK) >> LPUART_CTRL_R8T9_SHIFT)
#define LPUART_BRD_CTRL_R8T9(base) (BME_UBFX32(&LPUART_CTRL_REG(base), LPUART_CTRL_R8T9_SHIFT, LPUART_CTRL_R8T9_WIDTH))

/*! @brief Set the R8T9 field to a new value. */
#define LPUART_WR_CTRL_R8T9(base, value) (LPUART_RMW_CTRL(base, LPUART_CTRL_R8T9_MASK, LPUART_CTRL_R8T9(value)))
#define LPUART_BWR_CTRL_R8T9(base, value) (BME_BFI32(&LPUART_CTRL_REG(base), ((uint32_t)(value) << LPUART_CTRL_R8T9_SHIFT), LPUART_CTRL_R8T9_SHIFT, LPUART_CTRL_R8T9_WIDTH))
/*@}*/

/*******************************************************************************
 * LPUART_DATA - LPUART Data Register
 ******************************************************************************/

/*!
 * @brief LPUART_DATA - LPUART Data Register (RW)
 *
 * Reset value: 0x00001000U
 *
 * This register is actually two separate registers. Reads return the contents
 * of the read-only receive data buffer and writes go to the write-only transmit
 * data buffer. Reads and writes of this register are also involved in the
 * automatic flag clearing mechanisms for some of the LPUART status flags.
 */
/*!
 * @name Constants and macros for entire LPUART_DATA register
 */
/*@{*/
#define LPUART_RD_DATA(base)     (LPUART_DATA_REG(base))
#define LPUART_WR_DATA(base, value) (LPUART_DATA_REG(base) = (value))
#define LPUART_RMW_DATA(base, mask, value) (LPUART_WR_DATA(base, (LPUART_RD_DATA(base) & ~(mask)) | (value)))
#define LPUART_SET_DATA(base, value) (BME_OR32(&LPUART_DATA_REG(base), (uint32_t)(value)))
#define LPUART_CLR_DATA(base, value) (BME_AND32(&LPUART_DATA_REG(base), (uint32_t)(~(value))))
#define LPUART_TOG_DATA(base, value) (BME_XOR32(&LPUART_DATA_REG(base), (uint32_t)(value)))
/*@}*/

/*
 * Constants & macros for individual LPUART_DATA bitfields
 */

/*!
 * @name Register LPUART_DATA, field R0T0[0] (RW)
 *
 * Read receive data buffer 0 or write transmit data buffer 0.
 */
/*@{*/
/*! @brief Read current value of the LPUART_DATA_R0T0 field. */
#define LPUART_RD_DATA_R0T0(base) ((LPUART_DATA_REG(base) & LPUART_DATA_R0T0_MASK) >> LPUART_DATA_R0T0_SHIFT)
#define LPUART_BRD_DATA_R0T0(base) (BME_UBFX32(&LPUART_DATA_REG(base), LPUART_DATA_R0T0_SHIFT, LPUART_DATA_R0T0_WIDTH))

/*! @brief Set the R0T0 field to a new value. */
#define LPUART_WR_DATA_R0T0(base, value) (LPUART_RMW_DATA(base, LPUART_DATA_R0T0_MASK, LPUART_DATA_R0T0(value)))
#define LPUART_BWR_DATA_R0T0(base, value) (BME_BFI32(&LPUART_DATA_REG(base), ((uint32_t)(value) << LPUART_DATA_R0T0_SHIFT), LPUART_DATA_R0T0_SHIFT, LPUART_DATA_R0T0_WIDTH))
/*@}*/

/*!
 * @name Register LPUART_DATA, field R1T1[1] (RW)
 *
 * Read receive data buffer 1 or write transmit data buffer 1.
 */
/*@{*/
/*! @brief Read current value of the LPUART_DATA_R1T1 field. */
#define LPUART_RD_DATA_R1T1(base) ((LPUART_DATA_REG(base) & LPUART_DATA_R1T1_MASK) >> LPUART_DATA_R1T1_SHIFT)
#define LPUART_BRD_DATA_R1T1(base) (BME_UBFX32(&LPUART_DATA_REG(base), LPUART_DATA_R1T1_SHIFT, LPUART_DATA_R1T1_WIDTH))

/*! @brief Set the R1T1 field to a new value. */
#define LPUART_WR_DATA_R1T1(base, value) (LPUART_RMW_DATA(base, LPUART_DATA_R1T1_MASK, LPUART_DATA_R1T1(value)))
#define LPUART_BWR_DATA_R1T1(base, value) (BME_BFI32(&LPUART_DATA_REG(base), ((uint32_t)(value) << LPUART_DATA_R1T1_SHIFT), LPUART_DATA_R1T1_SHIFT, LPUART_DATA_R1T1_WIDTH))
/*@}*/

/*!
 * @name Register LPUART_DATA, field R2T2[2] (RW)
 *
 * Read receive data buffer 2 or write transmit data buffer 2.
 */
/*@{*/
/*! @brief Read current value of the LPUART_DATA_R2T2 field. */
#define LPUART_RD_DATA_R2T2(base) ((LPUART_DATA_REG(base) & LPUART_DATA_R2T2_MASK) >> LPUART_DATA_R2T2_SHIFT)
#define LPUART_BRD_DATA_R2T2(base) (BME_UBFX32(&LPUART_DATA_REG(base), LPUART_DATA_R2T2_SHIFT, LPUART_DATA_R2T2_WIDTH))

/*! @brief Set the R2T2 field to a new value. */
#define LPUART_WR_DATA_R2T2(base, value) (LPUART_RMW_DATA(base, LPUART_DATA_R2T2_MASK, LPUART_DATA_R2T2(value)))
#define LPUART_BWR_DATA_R2T2(base, value) (BME_BFI32(&LPUART_DATA_REG(base), ((uint32_t)(value) << LPUART_DATA_R2T2_SHIFT), LPUART_DATA_R2T2_SHIFT, LPUART_DATA_R2T2_WIDTH))
/*@}*/

/*!
 * @name Register LPUART_DATA, field R3T3[3] (RW)
 *
 * Read receive data buffer 3 or write transmit data buffer 3.
 */
/*@{*/
/*! @brief Read current value of the LPUART_DATA_R3T3 field. */
#define LPUART_RD_DATA_R3T3(base) ((LPUART_DATA_REG(base) & LPUART_DATA_R3T3_MASK) >> LPUART_DATA_R3T3_SHIFT)
#define LPUART_BRD_DATA_R3T3(base) (BME_UBFX32(&LPUART_DATA_REG(base), LPUART_DATA_R3T3_SHIFT, LPUART_DATA_R3T3_WIDTH))

/*! @brief Set the R3T3 field to a new value. */
#define LPUART_WR_DATA_R3T3(base, value) (LPUART_RMW_DATA(base, LPUART_DATA_R3T3_MASK, LPUART_DATA_R3T3(value)))
#define LPUART_BWR_DATA_R3T3(base, value) (BME_BFI32(&LPUART_DATA_REG(base), ((uint32_t)(value) << LPUART_DATA_R3T3_SHIFT), LPUART_DATA_R3T3_SHIFT, LPUART_DATA_R3T3_WIDTH))
/*@}*/

/*!
 * @name Register LPUART_DATA, field R4T4[4] (RW)
 *
 * Read receive data buffer 4 or write transmit data buffer 4.
 */
/*@{*/
/*! @brief Read current value of the LPUART_DATA_R4T4 field. */
#define LPUART_RD_DATA_R4T4(base) ((LPUART_DATA_REG(base) & LPUART_DATA_R4T4_MASK) >> LPUART_DATA_R4T4_SHIFT)
#define LPUART_BRD_DATA_R4T4(base) (BME_UBFX32(&LPUART_DATA_REG(base), LPUART_DATA_R4T4_SHIFT, LPUART_DATA_R4T4_WIDTH))

/*! @brief Set the R4T4 field to a new value. */
#define LPUART_WR_DATA_R4T4(base, value) (LPUART_RMW_DATA(base, LPUART_DATA_R4T4_MASK, LPUART_DATA_R4T4(value)))
#define LPUART_BWR_DATA_R4T4(base, value) (BME_BFI32(&LPUART_DATA_REG(base), ((uint32_t)(value) << LPUART_DATA_R4T4_SHIFT), LPUART_DATA_R4T4_SHIFT, LPUART_DATA_R4T4_WIDTH))
/*@}*/

/*!
 * @name Register LPUART_DATA, field R5T5[5] (RW)
 *
 * Read receive data buffer 5 or write transmit data buffer 5.
 */
/*@{*/
/*! @brief Read current value of the LPUART_DATA_R5T5 field. */
#define LPUART_RD_DATA_R5T5(base) ((LPUART_DATA_REG(base) & LPUART_DATA_R5T5_MASK) >> LPUART_DATA_R5T5_SHIFT)
#define LPUART_BRD_DATA_R5T5(base) (BME_UBFX32(&LPUART_DATA_REG(base), LPUART_DATA_R5T5_SHIFT, LPUART_DATA_R5T5_WIDTH))

/*! @brief Set the R5T5 field to a new value. */
#define LPUART_WR_DATA_R5T5(base, value) (LPUART_RMW_DATA(base, LPUART_DATA_R5T5_MASK, LPUART_DATA_R5T5(value)))
#define LPUART_BWR_DATA_R5T5(base, value) (BME_BFI32(&LPUART_DATA_REG(base), ((uint32_t)(value) << LPUART_DATA_R5T5_SHIFT), LPUART_DATA_R5T5_SHIFT, LPUART_DATA_R5T5_WIDTH))
/*@}*/

/*!
 * @name Register LPUART_DATA, field R6T6[6] (RW)
 *
 * Read receive data buffer 6 or write transmit data buffer 6.
 */
/*@{*/
/*! @brief Read current value of the LPUART_DATA_R6T6 field. */
#define LPUART_RD_DATA_R6T6(base) ((LPUART_DATA_REG(base) & LPUART_DATA_R6T6_MASK) >> LPUART_DATA_R6T6_SHIFT)
#define LPUART_BRD_DATA_R6T6(base) (BME_UBFX32(&LPUART_DATA_REG(base), LPUART_DATA_R6T6_SHIFT, LPUART_DATA_R6T6_WIDTH))

/*! @brief Set the R6T6 field to a new value. */
#define LPUART_WR_DATA_R6T6(base, value) (LPUART_RMW_DATA(base, LPUART_DATA_R6T6_MASK, LPUART_DATA_R6T6(value)))
#define LPUART_BWR_DATA_R6T6(base, value) (BME_BFI32(&LPUART_DATA_REG(base), ((uint32_t)(value) << LPUART_DATA_R6T6_SHIFT), LPUART_DATA_R6T6_SHIFT, LPUART_DATA_R6T6_WIDTH))
/*@}*/

/*!
 * @name Register LPUART_DATA, field R7T7[7] (RW)
 *
 * Read receive data buffer 7 or write transmit data buffer 7.
 */
/*@{*/
/*! @brief Read current value of the LPUART_DATA_R7T7 field. */
#define LPUART_RD_DATA_R7T7(base) ((LPUART_DATA_REG(base) & LPUART_DATA_R7T7_MASK) >> LPUART_DATA_R7T7_SHIFT)
#define LPUART_BRD_DATA_R7T7(base) (BME_UBFX32(&LPUART_DATA_REG(base), LPUART_DATA_R7T7_SHIFT, LPUART_DATA_R7T7_WIDTH))

/*! @brief Set the R7T7 field to a new value. */
#define LPUART_WR_DATA_R7T7(base, value) (LPUART_RMW_DATA(base, LPUART_DATA_R7T7_MASK, LPUART_DATA_R7T7(value)))
#define LPUART_BWR_DATA_R7T7(base, value) (BME_BFI32(&LPUART_DATA_REG(base), ((uint32_t)(value) << LPUART_DATA_R7T7_SHIFT), LPUART_DATA_R7T7_SHIFT, LPUART_DATA_R7T7_WIDTH))
/*@}*/

/*!
 * @name Register LPUART_DATA, field R8T8[8] (RW)
 *
 * Read receive data buffer 8 or write transmit data buffer 8.
 */
/*@{*/
/*! @brief Read current value of the LPUART_DATA_R8T8 field. */
#define LPUART_RD_DATA_R8T8(base) ((LPUART_DATA_REG(base) & LPUART_DATA_R8T8_MASK) >> LPUART_DATA_R8T8_SHIFT)
#define LPUART_BRD_DATA_R8T8(base) (BME_UBFX32(&LPUART_DATA_REG(base), LPUART_DATA_R8T8_SHIFT, LPUART_DATA_R8T8_WIDTH))

/*! @brief Set the R8T8 field to a new value. */
#define LPUART_WR_DATA_R8T8(base, value) (LPUART_RMW_DATA(base, LPUART_DATA_R8T8_MASK, LPUART_DATA_R8T8(value)))
#define LPUART_BWR_DATA_R8T8(base, value) (BME_BFI32(&LPUART_DATA_REG(base), ((uint32_t)(value) << LPUART_DATA_R8T8_SHIFT), LPUART_DATA_R8T8_SHIFT, LPUART_DATA_R8T8_WIDTH))
/*@}*/

/*!
 * @name Register LPUART_DATA, field R9T9[9] (RW)
 *
 * Read receive data buffer 9 or write transmit data buffer 9.
 */
/*@{*/
/*! @brief Read current value of the LPUART_DATA_R9T9 field. */
#define LPUART_RD_DATA_R9T9(base) ((LPUART_DATA_REG(base) & LPUART_DATA_R9T9_MASK) >> LPUART_DATA_R9T9_SHIFT)
#define LPUART_BRD_DATA_R9T9(base) (BME_UBFX32(&LPUART_DATA_REG(base), LPUART_DATA_R9T9_SHIFT, LPUART_DATA_R9T9_WIDTH))

/*! @brief Set the R9T9 field to a new value. */
#define LPUART_WR_DATA_R9T9(base, value) (LPUART_RMW_DATA(base, LPUART_DATA_R9T9_MASK, LPUART_DATA_R9T9(value)))
#define LPUART_BWR_DATA_R9T9(base, value) (BME_BFI32(&LPUART_DATA_REG(base), ((uint32_t)(value) << LPUART_DATA_R9T9_SHIFT), LPUART_DATA_R9T9_SHIFT, LPUART_DATA_R9T9_WIDTH))
/*@}*/

/*!
 * @name Register LPUART_DATA, field IDLINE[11] (RO)
 *
 * Indicates the receiver line was idle before receiving the character in
 * DATA[9:0]. Unlike the IDLE flag, this bit can set for the first character received
 * when the receiver is first enabled.
 *
 * Values:
 * - 0 - Receiver was not idle before receiving this character.
 * - 1 - Receiver was idle before receiving this character.
 */
/*@{*/
/*! @brief Read current value of the LPUART_DATA_IDLINE field. */
#define LPUART_RD_DATA_IDLINE(base) ((LPUART_DATA_REG(base) & LPUART_DATA_IDLINE_MASK) >> LPUART_DATA_IDLINE_SHIFT)
#define LPUART_BRD_DATA_IDLINE(base) (BME_UBFX32(&LPUART_DATA_REG(base), LPUART_DATA_IDLINE_SHIFT, LPUART_DATA_IDLINE_WIDTH))
/*@}*/

/*!
 * @name Register LPUART_DATA, field RXEMPT[12] (RO)
 *
 * Asserts when there is no data in the receive buffer. This field does not take
 * into account data that is in the receive shift register.
 *
 * Values:
 * - 0 - Receive buffer contains valid data.
 * - 1 - Receive buffer is empty, data returned on read is not valid.
 */
/*@{*/
/*! @brief Read current value of the LPUART_DATA_RXEMPT field. */
#define LPUART_RD_DATA_RXEMPT(base) ((LPUART_DATA_REG(base) & LPUART_DATA_RXEMPT_MASK) >> LPUART_DATA_RXEMPT_SHIFT)
#define LPUART_BRD_DATA_RXEMPT(base) (BME_UBFX32(&LPUART_DATA_REG(base), LPUART_DATA_RXEMPT_SHIFT, LPUART_DATA_RXEMPT_WIDTH))
/*@}*/

/*!
 * @name Register LPUART_DATA, field FRETSC[13] (RW)
 *
 * For reads, indicates the current received dataword contained in DATA[R9:R0]
 * was received with a frame error. For writes, indicates a break or idle
 * character is to be transmitted instead of the contents in DATA[T9:T0]. T9 is used to
 * indicate a break character when 0 and a idle character when 1, he contents of
 * DATA[T8:T0] should be zero.
 *
 * Values:
 * - 0 - The dataword was received without a frame error on read, transmit a
 *     normal character on write.
 * - 1 - The dataword was received with a frame error, transmit an idle or break
 *     character on transmit.
 */
/*@{*/
/*! @brief Read current value of the LPUART_DATA_FRETSC field. */
#define LPUART_RD_DATA_FRETSC(base) ((LPUART_DATA_REG(base) & LPUART_DATA_FRETSC_MASK) >> LPUART_DATA_FRETSC_SHIFT)
#define LPUART_BRD_DATA_FRETSC(base) (BME_UBFX32(&LPUART_DATA_REG(base), LPUART_DATA_FRETSC_SHIFT, LPUART_DATA_FRETSC_WIDTH))

/*! @brief Set the FRETSC field to a new value. */
#define LPUART_WR_DATA_FRETSC(base, value) (LPUART_RMW_DATA(base, LPUART_DATA_FRETSC_MASK, LPUART_DATA_FRETSC(value)))
#define LPUART_BWR_DATA_FRETSC(base, value) (BME_BFI32(&LPUART_DATA_REG(base), ((uint32_t)(value) << LPUART_DATA_FRETSC_SHIFT), LPUART_DATA_FRETSC_SHIFT, LPUART_DATA_FRETSC_WIDTH))
/*@}*/

/*!
 * @name Register LPUART_DATA, field PARITYE[14] (RO)
 *
 * The current received dataword contained in DATA[R9:R0] was received with a
 * parity error.
 *
 * Values:
 * - 0 - The dataword was received without a parity error.
 * - 1 - The dataword was received with a parity error.
 */
/*@{*/
/*! @brief Read current value of the LPUART_DATA_PARITYE field. */
#define LPUART_RD_DATA_PARITYE(base) ((LPUART_DATA_REG(base) & LPUART_DATA_PARITYE_MASK) >> LPUART_DATA_PARITYE_SHIFT)
#define LPUART_BRD_DATA_PARITYE(base) (BME_UBFX32(&LPUART_DATA_REG(base), LPUART_DATA_PARITYE_SHIFT, LPUART_DATA_PARITYE_WIDTH))
/*@}*/

/*!
 * @name Register LPUART_DATA, field NOISY[15] (RO)
 *
 * The current received dataword contained in DATA[R9:R0] was received with
 * noise.
 *
 * Values:
 * - 0 - The dataword was received without noise.
 * - 1 - The data was received with noise.
 */
/*@{*/
/*! @brief Read current value of the LPUART_DATA_NOISY field. */
#define LPUART_RD_DATA_NOISY(base) ((LPUART_DATA_REG(base) & LPUART_DATA_NOISY_MASK) >> LPUART_DATA_NOISY_SHIFT)
#define LPUART_BRD_DATA_NOISY(base) (BME_UBFX32(&LPUART_DATA_REG(base), LPUART_DATA_NOISY_SHIFT, LPUART_DATA_NOISY_WIDTH))
/*@}*/

/*******************************************************************************
 * LPUART_MATCH - LPUART Match Address Register
 ******************************************************************************/

/*!
 * @brief LPUART_MATCH - LPUART Match Address Register (RW)
 *
 * Reset value: 0x00000000U
 */
/*!
 * @name Constants and macros for entire LPUART_MATCH register
 */
/*@{*/
#define LPUART_RD_MATCH(base)    (LPUART_MATCH_REG(base))
#define LPUART_WR_MATCH(base, value) (LPUART_MATCH_REG(base) = (value))
#define LPUART_RMW_MATCH(base, mask, value) (LPUART_WR_MATCH(base, (LPUART_RD_MATCH(base) & ~(mask)) | (value)))
#define LPUART_SET_MATCH(base, value) (BME_OR32(&LPUART_MATCH_REG(base), (uint32_t)(value)))
#define LPUART_CLR_MATCH(base, value) (BME_AND32(&LPUART_MATCH_REG(base), (uint32_t)(~(value))))
#define LPUART_TOG_MATCH(base, value) (BME_XOR32(&LPUART_MATCH_REG(base), (uint32_t)(value)))
/*@}*/

/*
 * Constants & macros for individual LPUART_MATCH bitfields
 */

/*!
 * @name Register LPUART_MATCH, field MA1[9:0] (RW)
 *
 * The MA1 and MA2 registers are compared to input data addresses when the most
 * significant bit is set and the associated BAUD[MAEN] bit is set. If a match
 * occurs, the following data is transferred to the data register. If a match
 * fails, the following data is discarded. Software should only write a MA register
 * when the associated BAUD[MAEN] bit is clear.
 */
/*@{*/
/*! @brief Read current value of the LPUART_MATCH_MA1 field. */
#define LPUART_RD_MATCH_MA1(base) ((LPUART_MATCH_REG(base) & LPUART_MATCH_MA1_MASK) >> LPUART_MATCH_MA1_SHIFT)
#define LPUART_BRD_MATCH_MA1(base) (BME_UBFX32(&LPUART_MATCH_REG(base), LPUART_MATCH_MA1_SHIFT, LPUART_MATCH_MA1_WIDTH))

/*! @brief Set the MA1 field to a new value. */
#define LPUART_WR_MATCH_MA1(base, value) (LPUART_RMW_MATCH(base, LPUART_MATCH_MA1_MASK, LPUART_MATCH_MA1(value)))
#define LPUART_BWR_MATCH_MA1(base, value) (BME_BFI32(&LPUART_MATCH_REG(base), ((uint32_t)(value) << LPUART_MATCH_MA1_SHIFT), LPUART_MATCH_MA1_SHIFT, LPUART_MATCH_MA1_WIDTH))
/*@}*/

/*!
 * @name Register LPUART_MATCH, field MA2[25:16] (RW)
 *
 * The MA1 and MA2 registers are compared to input data addresses when the most
 * significant bit is set and the associated BAUD[MAEN] bit is set. If a match
 * occurs, the following data is transferred to the data register. If a match
 * fails, the following data is discarded. Software should only write a MA register
 * when the associated BAUD[MAEN] bit is clear.
 */
/*@{*/
/*! @brief Read current value of the LPUART_MATCH_MA2 field. */
#define LPUART_RD_MATCH_MA2(base) ((LPUART_MATCH_REG(base) & LPUART_MATCH_MA2_MASK) >> LPUART_MATCH_MA2_SHIFT)
#define LPUART_BRD_MATCH_MA2(base) (BME_UBFX32(&LPUART_MATCH_REG(base), LPUART_MATCH_MA2_SHIFT, LPUART_MATCH_MA2_WIDTH))

/*! @brief Set the MA2 field to a new value. */
#define LPUART_WR_MATCH_MA2(base, value) (LPUART_RMW_MATCH(base, LPUART_MATCH_MA2_MASK, LPUART_MATCH_MA2(value)))
#define LPUART_BWR_MATCH_MA2(base, value) (BME_BFI32(&LPUART_MATCH_REG(base), ((uint32_t)(value) << LPUART_MATCH_MA2_SHIFT), LPUART_MATCH_MA2_SHIFT, LPUART_MATCH_MA2_WIDTH))
/*@}*/

/*
 * MKL27Z644 MCG
 *
 * Multipurpose Clock Generator Lite
 *
 * Registers defined in this header file:
 * - MCG_C1 - MCG Control Register 1
 * - MCG_C2 - MCG Control Register 2
 * - MCG_S - MCG Status Register
 * - MCG_SC - MCG Status and Control Register
 * - MCG_MC - MCG Miscellaneous Control Register
 */

#define MCG_INSTANCE_COUNT (1U) /*!< Number of instances of the MCG module. */
#define MCG_IDX (0U) /*!< Instance number for MCG. */

/*******************************************************************************
 * MCG_C1 - MCG Control Register 1
 ******************************************************************************/

/*!
 * @brief MCG_C1 - MCG Control Register 1 (RW)
 *
 * Reset value: 0x40U
 */
/*!
 * @name Constants and macros for entire MCG_C1 register
 */
/*@{*/
#define MCG_RD_C1(base)          (MCG_C1_REG(base))
#define MCG_WR_C1(base, value)   (MCG_C1_REG(base) = (value))
#define MCG_RMW_C1(base, mask, value) (MCG_WR_C1(base, (MCG_RD_C1(base) & ~(mask)) | (value)))
#define MCG_SET_C1(base, value)  (BME_OR8(&MCG_C1_REG(base), (uint8_t)(value)))
#define MCG_CLR_C1(base, value)  (BME_AND8(&MCG_C1_REG(base), (uint8_t)(~(value))))
#define MCG_TOG_C1(base, value)  (BME_XOR8(&MCG_C1_REG(base), (uint8_t)(value)))
/*@}*/

/*
 * Constants & macros for individual MCG_C1 bitfields
 */

/*!
 * @name Register MCG_C1, field IREFSTEN[0] (RW)
 *
 * Controls whether the IRC source remains enabled when the MCG_Lite enters Stop
 * mode.
 *
 * Values:
 * - 0 - LIRC is disabled in Stop mode.
 * - 1 - LIRC is enabled in Stop mode, if IRCLKEN is set.
 */
/*@{*/
/*! @brief Read current value of the MCG_C1_IREFSTEN field. */
#define MCG_RD_C1_IREFSTEN(base) ((MCG_C1_REG(base) & MCG_C1_IREFSTEN_MASK) >> MCG_C1_IREFSTEN_SHIFT)
#define MCG_BRD_C1_IREFSTEN(base) (BME_UBFX8(&MCG_C1_REG(base), MCG_C1_IREFSTEN_SHIFT, MCG_C1_IREFSTEN_WIDTH))

/*! @brief Set the IREFSTEN field to a new value. */
#define MCG_WR_C1_IREFSTEN(base, value) (MCG_RMW_C1(base, MCG_C1_IREFSTEN_MASK, MCG_C1_IREFSTEN(value)))
#define MCG_BWR_C1_IREFSTEN(base, value) (BME_BFI8(&MCG_C1_REG(base), ((uint8_t)(value) << MCG_C1_IREFSTEN_SHIFT), MCG_C1_IREFSTEN_SHIFT, MCG_C1_IREFSTEN_WIDTH))
/*@}*/

/*!
 * @name Register MCG_C1, field IRCLKEN[1] (RW)
 *
 * Enables the IRC source.
 *
 * Values:
 * - 0 - LIRC is disabled.
 * - 1 - LIRC is enabled.
 */
/*@{*/
/*! @brief Read current value of the MCG_C1_IRCLKEN field. */
#define MCG_RD_C1_IRCLKEN(base) ((MCG_C1_REG(base) & MCG_C1_IRCLKEN_MASK) >> MCG_C1_IRCLKEN_SHIFT)
#define MCG_BRD_C1_IRCLKEN(base) (BME_UBFX8(&MCG_C1_REG(base), MCG_C1_IRCLKEN_SHIFT, MCG_C1_IRCLKEN_WIDTH))

/*! @brief Set the IRCLKEN field to a new value. */
#define MCG_WR_C1_IRCLKEN(base, value) (MCG_RMW_C1(base, MCG_C1_IRCLKEN_MASK, MCG_C1_IRCLKEN(value)))
#define MCG_BWR_C1_IRCLKEN(base, value) (BME_BFI8(&MCG_C1_REG(base), ((uint8_t)(value) << MCG_C1_IRCLKEN_SHIFT), MCG_C1_IRCLKEN_SHIFT, MCG_C1_IRCLKEN_WIDTH))
/*@}*/

/*!
 * @name Register MCG_C1, field CLKS[7:6] (RW)
 *
 * Selects the clock source for MCGOUTCLK.
 *
 * Values:
 * - 00 - Selects HIRC clock as the main clock source. This is HIRC mode.
 * - 01 - Selects LIRC clock as the main clock source. This is LIRC2M or LIRC8M
 *     mode.
 * - 10 - Selects external clock as the main clock source. This is EXT mode.
 * - 11 - Reserved. Writing 11 takes no effect.
 */
/*@{*/
/*! @brief Read current value of the MCG_C1_CLKS field. */
#define MCG_RD_C1_CLKS(base) ((MCG_C1_REG(base) & MCG_C1_CLKS_MASK) >> MCG_C1_CLKS_SHIFT)
#define MCG_BRD_C1_CLKS(base) (BME_UBFX8(&MCG_C1_REG(base), MCG_C1_CLKS_SHIFT, MCG_C1_CLKS_WIDTH))

/*! @brief Set the CLKS field to a new value. */
#define MCG_WR_C1_CLKS(base, value) (MCG_RMW_C1(base, MCG_C1_CLKS_MASK, MCG_C1_CLKS(value)))
#define MCG_BWR_C1_CLKS(base, value) (BME_BFI8(&MCG_C1_REG(base), ((uint8_t)(value) << MCG_C1_CLKS_SHIFT), MCG_C1_CLKS_SHIFT, MCG_C1_CLKS_WIDTH))
/*@}*/

/*******************************************************************************
 * MCG_C2 - MCG Control Register 2
 ******************************************************************************/

/*!
 * @brief MCG_C2 - MCG Control Register 2 (RW)
 *
 * Reset value: 0x01U
 */
/*!
 * @name Constants and macros for entire MCG_C2 register
 */
/*@{*/
#define MCG_RD_C2(base)          (MCG_C2_REG(base))
#define MCG_WR_C2(base, value)   (MCG_C2_REG(base) = (value))
#define MCG_RMW_C2(base, mask, value) (MCG_WR_C2(base, (MCG_RD_C2(base) & ~(mask)) | (value)))
#define MCG_SET_C2(base, value)  (BME_OR8(&MCG_C2_REG(base), (uint8_t)(value)))
#define MCG_CLR_C2(base, value)  (BME_AND8(&MCG_C2_REG(base), (uint8_t)(~(value))))
#define MCG_TOG_C2(base, value)  (BME_XOR8(&MCG_C2_REG(base), (uint8_t)(value)))
/*@}*/

/*
 * Constants & macros for individual MCG_C2 bitfields
 */

/*!
 * @name Register MCG_C2, field IRCS[0] (RW)
 *
 * Controls the LIRC to work at 2 MHz or 8 MHz mode.
 *
 * Values:
 * - 0 - LIRC is in 2 MHz mode.
 * - 1 - LIRC is in 8 MHz mode.
 */
/*@{*/
/*! @brief Read current value of the MCG_C2_IRCS field. */
#define MCG_RD_C2_IRCS(base) ((MCG_C2_REG(base) & MCG_C2_IRCS_MASK) >> MCG_C2_IRCS_SHIFT)
#define MCG_BRD_C2_IRCS(base) (BME_UBFX8(&MCG_C2_REG(base), MCG_C2_IRCS_SHIFT, MCG_C2_IRCS_WIDTH))

/*! @brief Set the IRCS field to a new value. */
#define MCG_WR_C2_IRCS(base, value) (MCG_RMW_C2(base, MCG_C2_IRCS_MASK, MCG_C2_IRCS(value)))
#define MCG_BWR_C2_IRCS(base, value) (BME_BFI8(&MCG_C2_REG(base), ((uint8_t)(value) << MCG_C2_IRCS_SHIFT), MCG_C2_IRCS_SHIFT, MCG_C2_IRCS_WIDTH))
/*@}*/

/*!
 * @name Register MCG_C2, field EREFS0[2] (RW)
 *
 * Selects the source for the external reference clock. See the Oscillator (OSC)
 * chapter for more details.
 *
 * Values:
 * - 0 - External clock requested.
 * - 1 - Oscillator requested.
 */
/*@{*/
/*! @brief Read current value of the MCG_C2_EREFS0 field. */
#define MCG_RD_C2_EREFS0(base) ((MCG_C2_REG(base) & MCG_C2_EREFS0_MASK) >> MCG_C2_EREFS0_SHIFT)
#define MCG_BRD_C2_EREFS0(base) (BME_UBFX8(&MCG_C2_REG(base), MCG_C2_EREFS0_SHIFT, MCG_C2_EREFS0_WIDTH))

/*! @brief Set the EREFS0 field to a new value. */
#define MCG_WR_C2_EREFS0(base, value) (MCG_RMW_C2(base, MCG_C2_EREFS0_MASK, MCG_C2_EREFS0(value)))
#define MCG_BWR_C2_EREFS0(base, value) (BME_BFI8(&MCG_C2_REG(base), ((uint8_t)(value) << MCG_C2_EREFS0_SHIFT), MCG_C2_EREFS0_SHIFT, MCG_C2_EREFS0_WIDTH))
/*@}*/

/*!
 * @name Register MCG_C2, field HGO0[3] (RW)
 *
 * Selects the crystal oscillator mode of operation. See the Oscillator (OSC)
 * chapter for more details.
 *
 * Values:
 * - 0 - Configure crystal oscillator for low-power operation.
 * - 1 - Configure crystal oscillator for high-gain operation.
 */
/*@{*/
/*! @brief Read current value of the MCG_C2_HGO0 field. */
#define MCG_RD_C2_HGO0(base) ((MCG_C2_REG(base) & MCG_C2_HGO0_MASK) >> MCG_C2_HGO0_SHIFT)
#define MCG_BRD_C2_HGO0(base) (BME_UBFX8(&MCG_C2_REG(base), MCG_C2_HGO0_SHIFT, MCG_C2_HGO0_WIDTH))

/*! @brief Set the HGO0 field to a new value. */
#define MCG_WR_C2_HGO0(base, value) (MCG_RMW_C2(base, MCG_C2_HGO0_MASK, MCG_C2_HGO0(value)))
#define MCG_BWR_C2_HGO0(base, value) (BME_BFI8(&MCG_C2_REG(base), ((uint8_t)(value) << MCG_C2_HGO0_SHIFT), MCG_C2_HGO0_SHIFT, MCG_C2_HGO0_WIDTH))
/*@}*/

/*!
 * @name Register MCG_C2, field RANGE0[5:4] (RW)
 *
 * Selects the frequency for the crystal oscillator or the external clock
 * source. See the Oscillator (OSC) chapter for more details and refer to the chip
 * datasheet for the frequency ranges used.
 *
 * Values:
 * - 00 - Low frequency range selected for the crystal oscillator or the
 *     external clock source.
 * - 01 - High frequency range selected for the crystal oscillator or the
 *     external clock source.
 * - 10 - Very high frequency range selected for the crystal oscillator or the
 *     external clock source.
 * - 11 - Very high frequency range selected for the crystal oscillator or the
 *     external clock source. Same effect as 10.
 */
/*@{*/
/*! @brief Read current value of the MCG_C2_RANGE0 field. */
#define MCG_RD_C2_RANGE0(base) ((MCG_C2_REG(base) & MCG_C2_RANGE0_MASK) >> MCG_C2_RANGE0_SHIFT)
#define MCG_BRD_C2_RANGE0(base) (BME_UBFX8(&MCG_C2_REG(base), MCG_C2_RANGE0_SHIFT, MCG_C2_RANGE0_WIDTH))

/*! @brief Set the RANGE0 field to a new value. */
#define MCG_WR_C2_RANGE0(base, value) (MCG_RMW_C2(base, MCG_C2_RANGE0_MASK, MCG_C2_RANGE0(value)))
#define MCG_BWR_C2_RANGE0(base, value) (BME_BFI8(&MCG_C2_REG(base), ((uint8_t)(value) << MCG_C2_RANGE0_SHIFT), MCG_C2_RANGE0_SHIFT, MCG_C2_RANGE0_WIDTH))
/*@}*/

/*******************************************************************************
 * MCG_S - MCG Status Register
 ******************************************************************************/

/*!
 * @brief MCG_S - MCG Status Register (RO)
 *
 * Reset value: 0x04U
 */
/*!
 * @name Constants and macros for entire MCG_S register
 */
/*@{*/
#define MCG_RD_S(base)           (MCG_S_REG(base))
/*@}*/

/*
 * Constants & macros for individual MCG_S bitfields
 */

/*!
 * @name Register MCG_S, field OSCINIT0[1] (RO)
 *
 * This flag, which resets to 0, is set to 1 after the initialization cycles of
 * the crystal oscillator clock are completed. After being set, the bit is
 * cleared to 0 if the OSC is subsequently disabled. See the Oscillator (OSC) chapter
 * for more information.
 *
 * Values:
 * - 0 - OSC is not ready.
 * - 1 - OSC clock is ready.
 */
/*@{*/
/*! @brief Read current value of the MCG_S_OSCINIT0 field. */
#define MCG_RD_S_OSCINIT0(base) ((MCG_S_REG(base) & MCG_S_OSCINIT0_MASK) >> MCG_S_OSCINIT0_SHIFT)
#define MCG_BRD_S_OSCINIT0(base) (BME_UBFX8(&MCG_S_REG(base), MCG_S_OSCINIT0_SHIFT, MCG_S_OSCINIT0_WIDTH))
/*@}*/

/*!
 * @name Register MCG_S, field CLKST[3:2] (RO)
 *
 * Indicates the current clock mode. This field does not update immediately
 * after a write to MCG_C1[CLKS] due to internal synchronization between clock
 * domains.
 *
 * Values:
 * - 00 - HIRC clock is selected as the main clock source, and MCG_Lite works at
 *     HIRC mode.
 * - 01 - LIRC clock is selected as the main clock source, and MCG_Lite works at
 *     LIRC2M or LIRC8M mode.
 * - 10 - External clock is selected as the main clock source, and MCG_Lite
 *     works at EXT mode.
 * - 11 - Reserved.
 */
/*@{*/
/*! @brief Read current value of the MCG_S_CLKST field. */
#define MCG_RD_S_CLKST(base) ((MCG_S_REG(base) & MCG_S_CLKST_MASK) >> MCG_S_CLKST_SHIFT)
#define MCG_BRD_S_CLKST(base) (BME_UBFX8(&MCG_S_REG(base), MCG_S_CLKST_SHIFT, MCG_S_CLKST_WIDTH))
/*@}*/

/*******************************************************************************
 * MCG_SC - MCG Status and Control Register
 ******************************************************************************/

/*!
 * @brief MCG_SC - MCG Status and Control Register (RW)
 *
 * Reset value: 0x00U
 */
/*!
 * @name Constants and macros for entire MCG_SC register
 */
/*@{*/
#define MCG_RD_SC(base)          (MCG_SC_REG(base))
#define MCG_WR_SC(base, value)   (MCG_SC_REG(base) = (value))
#define MCG_RMW_SC(base, mask, value) (MCG_WR_SC(base, (MCG_RD_SC(base) & ~(mask)) | (value)))
#define MCG_SET_SC(base, value)  (BME_OR8(&MCG_SC_REG(base), (uint8_t)(value)))
#define MCG_CLR_SC(base, value)  (BME_AND8(&MCG_SC_REG(base), (uint8_t)(~(value))))
#define MCG_TOG_SC(base, value)  (BME_XOR8(&MCG_SC_REG(base), (uint8_t)(value)))
/*@}*/

/*
 * Constants & macros for individual MCG_SC bitfields
 */

/*!
 * @name Register MCG_SC, field FCRDIV[3:1] (RW)
 *
 * Selects the factor value to divide the LIRC source.
 *
 * Values:
 * - 000 - Division factor is 1.
 * - 001 - Division factor is 2.
 * - 010 - Division factor is 4.
 * - 011 - Division factor is 8.
 * - 100 - Division factor is 16.
 * - 101 - Division factor is 32.
 * - 110 - Division factor is 64.
 * - 111 - Division factor is 128.
 */
/*@{*/
/*! @brief Read current value of the MCG_SC_FCRDIV field. */
#define MCG_RD_SC_FCRDIV(base) ((MCG_SC_REG(base) & MCG_SC_FCRDIV_MASK) >> MCG_SC_FCRDIV_SHIFT)
#define MCG_BRD_SC_FCRDIV(base) (BME_UBFX8(&MCG_SC_REG(base), MCG_SC_FCRDIV_SHIFT, MCG_SC_FCRDIV_WIDTH))

/*! @brief Set the FCRDIV field to a new value. */
#define MCG_WR_SC_FCRDIV(base, value) (MCG_RMW_SC(base, MCG_SC_FCRDIV_MASK, MCG_SC_FCRDIV(value)))
#define MCG_BWR_SC_FCRDIV(base, value) (BME_BFI8(&MCG_SC_REG(base), ((uint8_t)(value) << MCG_SC_FCRDIV_SHIFT), MCG_SC_FCRDIV_SHIFT, MCG_SC_FCRDIV_WIDTH))
/*@}*/

/*******************************************************************************
 * MCG_MC - MCG Miscellaneous Control Register
 ******************************************************************************/

/*!
 * @brief MCG_MC - MCG Miscellaneous Control Register (RW)
 *
 * Reset value: 0x00U
 */
/*!
 * @name Constants and macros for entire MCG_MC register
 */
/*@{*/
#define MCG_RD_MC(base)          (MCG_MC_REG(base))
#define MCG_WR_MC(base, value)   (MCG_MC_REG(base) = (value))
#define MCG_RMW_MC(base, mask, value) (MCG_WR_MC(base, (MCG_RD_MC(base) & ~(mask)) | (value)))
#define MCG_SET_MC(base, value)  (BME_OR8(&MCG_MC_REG(base), (uint8_t)(value)))
#define MCG_CLR_MC(base, value)  (BME_AND8(&MCG_MC_REG(base), (uint8_t)(~(value))))
#define MCG_TOG_MC(base, value)  (BME_XOR8(&MCG_MC_REG(base), (uint8_t)(value)))
/*@}*/

/*
 * Constants & macros for individual MCG_MC bitfields
 */

/*!
 * @name Register MCG_MC, field LIRC_DIV2[2:0] (RW)
 *
 * Selects the factor value to further divide the LIRC source.
 *
 * Values:
 * - 000 - Division factor is 1.
 * - 001 - Division factor is 2.
 * - 010 - Division factor is 4.
 * - 011 - Division factor is 8.
 * - 100 - Division factor is 16.
 * - 101 - Division factor is 32.
 * - 110 - Division factor is 64.
 * - 111 - Division factor is 128.
 */
/*@{*/
/*! @brief Read current value of the MCG_MC_LIRC_DIV2 field. */
#define MCG_RD_MC_LIRC_DIV2(base) ((MCG_MC_REG(base) & MCG_MC_LIRC_DIV2_MASK) >> MCG_MC_LIRC_DIV2_SHIFT)
#define MCG_BRD_MC_LIRC_DIV2(base) (BME_UBFX8(&MCG_MC_REG(base), MCG_MC_LIRC_DIV2_SHIFT, MCG_MC_LIRC_DIV2_WIDTH))

/*! @brief Set the LIRC_DIV2 field to a new value. */
#define MCG_WR_MC_LIRC_DIV2(base, value) (MCG_RMW_MC(base, MCG_MC_LIRC_DIV2_MASK, MCG_MC_LIRC_DIV2(value)))
#define MCG_BWR_MC_LIRC_DIV2(base, value) (BME_BFI8(&MCG_MC_REG(base), ((uint8_t)(value) << MCG_MC_LIRC_DIV2_SHIFT), MCG_MC_LIRC_DIV2_SHIFT, MCG_MC_LIRC_DIV2_WIDTH))
/*@}*/

/*!
 * @name Register MCG_MC, field HIRCLPEN[6] (RW)
 *
 * Values:
 * - 0 - HIRC is disabled in Low-power mode, such as Stop/VLPR/VLPW/VLPS mode.
 * - 1 - HIRC is enabled in Low-power mode, such as Stop/VLPR/VLPW/VLPS mode.
 */
/*@{*/
/*! @brief Read current value of the MCG_MC_HIRCLPEN field. */
#define MCG_RD_MC_HIRCLPEN(base) ((MCG_MC_REG(base) & MCG_MC_HIRCLPEN_MASK) >> MCG_MC_HIRCLPEN_SHIFT)
#define MCG_BRD_MC_HIRCLPEN(base) (BME_UBFX8(&MCG_MC_REG(base), MCG_MC_HIRCLPEN_SHIFT, MCG_MC_HIRCLPEN_WIDTH))

/*! @brief Set the HIRCLPEN field to a new value. */
#define MCG_WR_MC_HIRCLPEN(base, value) (MCG_RMW_MC(base, MCG_MC_HIRCLPEN_MASK, MCG_MC_HIRCLPEN(value)))
#define MCG_BWR_MC_HIRCLPEN(base, value) (BME_BFI8(&MCG_MC_REG(base), ((uint8_t)(value) << MCG_MC_HIRCLPEN_SHIFT), MCG_MC_HIRCLPEN_SHIFT, MCG_MC_HIRCLPEN_WIDTH))
/*@}*/

/*!
 * @name Register MCG_MC, field HIRCEN[7] (RW)
 *
 * Enables the HIRC, even when MCG_Lite is not working at HIRC mode.
 *
 * Values:
 * - 0 - HIRC source is not enabled.
 * - 1 - HIRC source is enabled.
 */
/*@{*/
/*! @brief Read current value of the MCG_MC_HIRCEN field. */
#define MCG_RD_MC_HIRCEN(base) ((MCG_MC_REG(base) & MCG_MC_HIRCEN_MASK) >> MCG_MC_HIRCEN_SHIFT)
#define MCG_BRD_MC_HIRCEN(base) (BME_UBFX8(&MCG_MC_REG(base), MCG_MC_HIRCEN_SHIFT, MCG_MC_HIRCEN_WIDTH))

/*! @brief Set the HIRCEN field to a new value. */
#define MCG_WR_MC_HIRCEN(base, value) (MCG_RMW_MC(base, MCG_MC_HIRCEN_MASK, MCG_MC_HIRCEN(value)))
#define MCG_BWR_MC_HIRCEN(base, value) (BME_BFI8(&MCG_MC_REG(base), ((uint8_t)(value) << MCG_MC_HIRCEN_SHIFT), MCG_MC_HIRCEN_SHIFT, MCG_MC_HIRCEN_WIDTH))
/*@}*/

/*
 * MKL27Z644 MCM
 *
 * Core Platform Miscellaneous Control Module
 *
 * Registers defined in this header file:
 * - MCM_PLASC - Crossbar Switch (AXBS) Slave Configuration
 * - MCM_PLAMC - Crossbar Switch (AXBS) Master Configuration
 * - MCM_PLACR - Platform Control Register
 * - MCM_CPO - Compute Operation Control Register
 */

#define MCM_INSTANCE_COUNT (1U) /*!< Number of instances of the MCM module. */
#define MCM_IDX (0U) /*!< Instance number for MCM. */

/*******************************************************************************
 * MCM_PLASC - Crossbar Switch (AXBS) Slave Configuration
 ******************************************************************************/

/*!
 * @brief MCM_PLASC - Crossbar Switch (AXBS) Slave Configuration (RO)
 *
 * Reset value: 0x0007U
 *
 * PLASC is a 16-bit read-only register identifying the presence/absence of bus
 * slave connections to the device's crossbar switch.
 */
/*!
 * @name Constants and macros for entire MCM_PLASC register
 */
/*@{*/
#define MCM_RD_PLASC(base)       (MCM_PLASC_REG(base))
/*@}*/

/*
 * Constants & macros for individual MCM_PLASC bitfields
 */

/*!
 * @name Register MCM_PLASC, field ASC[7:0] (RO)
 *
 * Values:
 * - 0 - A bus slave connection to AXBS input port n is absent.
 * - 1 - A bus slave connection to AXBS input port n is present.
 */
/*@{*/
/*! @brief Read current value of the MCM_PLASC_ASC field. */
#define MCM_RD_PLASC_ASC(base) ((MCM_PLASC_REG(base) & MCM_PLASC_ASC_MASK) >> MCM_PLASC_ASC_SHIFT)
#define MCM_BRD_PLASC_ASC(base) (MCM_RD_PLASC_ASC(base))
/*@}*/

/*******************************************************************************
 * MCM_PLAMC - Crossbar Switch (AXBS) Master Configuration
 ******************************************************************************/

/*!
 * @brief MCM_PLAMC - Crossbar Switch (AXBS) Master Configuration (RO)
 *
 * Reset value: 0x000DU
 *
 * PLAMC is a 16-bit read-only register identifying the presence/absence of bus
 * master connections to the device's crossbar switch.
 */
/*!
 * @name Constants and macros for entire MCM_PLAMC register
 */
/*@{*/
#define MCM_RD_PLAMC(base)       (MCM_PLAMC_REG(base))
/*@}*/

/*
 * Constants & macros for individual MCM_PLAMC bitfields
 */

/*!
 * @name Register MCM_PLAMC, field AMC[7:0] (RO)
 *
 * Values:
 * - 0 - A bus master connection to AXBS input port n is absent
 * - 1 - A bus master connection to AXBS input port n is present
 */
/*@{*/
/*! @brief Read current value of the MCM_PLAMC_AMC field. */
#define MCM_RD_PLAMC_AMC(base) ((MCM_PLAMC_REG(base) & MCM_PLAMC_AMC_MASK) >> MCM_PLAMC_AMC_SHIFT)
#define MCM_BRD_PLAMC_AMC(base) (MCM_RD_PLAMC_AMC(base))
/*@}*/

/*******************************************************************************
 * MCM_PLACR - Platform Control Register
 ******************************************************************************/

/*!
 * @brief MCM_PLACR - Platform Control Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * The PLACR register selects the arbitration policy for the crossbar masters
 * and configures the flash memory controller. The speculation buffer and cache in
 * the flash memory controller is configurable via PLACR[15:10 ]. The speculation
 * buffer is enabled only for instructions after reset. It is possible to have
 * these states for the speculation buffer: DFCS EFDS Description 0 0 Speculation
 * buffer is on for instruction and off for data. 0 1 Speculation buffer is on
 * for instruction and on for data. 1 X Speculation buffer is off. The cache in
 * flash controller is enabled and caching both instruction and data type fetches
 * after reset. It is possible to have these states for the cache: DFCC DFCIC DFCDA
 * Description 0 0 0 Cache is on for both instruction and data. 0 0 1 Cache is
 * on for instruction and off for data. 0 1 0 Cache is off for instruction and on
 * for data. 0 1 1 Cache is off for both instruction and data. 1 X X Cache is off.
 */
/*!
 * @name Constants and macros for entire MCM_PLACR register
 */
/*@{*/
#define MCM_RD_PLACR(base)       (MCM_PLACR_REG(base))
#define MCM_WR_PLACR(base, value) (MCM_PLACR_REG(base) = (value))
#define MCM_RMW_PLACR(base, mask, value) (MCM_WR_PLACR(base, (MCM_RD_PLACR(base) & ~(mask)) | (value)))
#define MCM_SET_PLACR(base, value) (MCM_WR_PLACR(base, MCM_RD_PLACR(base) |  (value)))
#define MCM_CLR_PLACR(base, value) (MCM_WR_PLACR(base, MCM_RD_PLACR(base) & ~(value)))
#define MCM_TOG_PLACR(base, value) (MCM_WR_PLACR(base, MCM_RD_PLACR(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual MCM_PLACR bitfields
 */

/*!
 * @name Register MCM_PLACR, field ARB[9] (RW)
 *
 * Values:
 * - 0 - Fixed-priority arbitration for the crossbar masters
 * - 1 - Round-robin arbitration for the crossbar masters
 */
/*@{*/
/*! @brief Read current value of the MCM_PLACR_ARB field. */
#define MCM_RD_PLACR_ARB(base) ((MCM_PLACR_REG(base) & MCM_PLACR_ARB_MASK) >> MCM_PLACR_ARB_SHIFT)
#define MCM_BRD_PLACR_ARB(base) (MCM_RD_PLACR_ARB(base))

/*! @brief Set the ARB field to a new value. */
#define MCM_WR_PLACR_ARB(base, value) (MCM_RMW_PLACR(base, MCM_PLACR_ARB_MASK, MCM_PLACR_ARB(value)))
#define MCM_BWR_PLACR_ARB(base, value) (MCM_WR_PLACR_ARB(base, value))
/*@}*/

/*!
 * @name Register MCM_PLACR, field CFCC[10] (WORZ)
 *
 * Writing a 1 to this field clears the cache. Writing a 0 to this field is
 * ignored. This field always reads as 0.
 */
/*@{*/
/*! @brief Set the CFCC field to a new value. */
#define MCM_WR_PLACR_CFCC(base, value) (MCM_RMW_PLACR(base, MCM_PLACR_CFCC_MASK, MCM_PLACR_CFCC(value)))
#define MCM_BWR_PLACR_CFCC(base, value) (MCM_WR_PLACR_CFCC(base, value))
/*@}*/

/*!
 * @name Register MCM_PLACR, field DFCDA[11] (RW)
 *
 * Disables flash controller data caching.
 *
 * Values:
 * - 0 - Enable flash controller data caching
 * - 1 - Disable flash controller data caching.
 */
/*@{*/
/*! @brief Read current value of the MCM_PLACR_DFCDA field. */
#define MCM_RD_PLACR_DFCDA(base) ((MCM_PLACR_REG(base) & MCM_PLACR_DFCDA_MASK) >> MCM_PLACR_DFCDA_SHIFT)
#define MCM_BRD_PLACR_DFCDA(base) (MCM_RD_PLACR_DFCDA(base))

/*! @brief Set the DFCDA field to a new value. */
#define MCM_WR_PLACR_DFCDA(base, value) (MCM_RMW_PLACR(base, MCM_PLACR_DFCDA_MASK, MCM_PLACR_DFCDA(value)))
#define MCM_BWR_PLACR_DFCDA(base, value) (MCM_WR_PLACR_DFCDA(base, value))
/*@}*/

/*!
 * @name Register MCM_PLACR, field DFCIC[12] (RW)
 *
 * Disables flash controller instruction caching.
 *
 * Values:
 * - 0 - Enable flash controller instruction caching.
 * - 1 - Disable flash controller instruction caching.
 */
/*@{*/
/*! @brief Read current value of the MCM_PLACR_DFCIC field. */
#define MCM_RD_PLACR_DFCIC(base) ((MCM_PLACR_REG(base) & MCM_PLACR_DFCIC_MASK) >> MCM_PLACR_DFCIC_SHIFT)
#define MCM_BRD_PLACR_DFCIC(base) (MCM_RD_PLACR_DFCIC(base))

/*! @brief Set the DFCIC field to a new value. */
#define MCM_WR_PLACR_DFCIC(base, value) (MCM_RMW_PLACR(base, MCM_PLACR_DFCIC_MASK, MCM_PLACR_DFCIC(value)))
#define MCM_BWR_PLACR_DFCIC(base, value) (MCM_WR_PLACR_DFCIC(base, value))
/*@}*/

/*!
 * @name Register MCM_PLACR, field DFCC[13] (RW)
 *
 * Disables flash controller cache.
 *
 * Values:
 * - 0 - Enable flash controller cache.
 * - 1 - Disable flash controller cache.
 */
/*@{*/
/*! @brief Read current value of the MCM_PLACR_DFCC field. */
#define MCM_RD_PLACR_DFCC(base) ((MCM_PLACR_REG(base) & MCM_PLACR_DFCC_MASK) >> MCM_PLACR_DFCC_SHIFT)
#define MCM_BRD_PLACR_DFCC(base) (MCM_RD_PLACR_DFCC(base))

/*! @brief Set the DFCC field to a new value. */
#define MCM_WR_PLACR_DFCC(base, value) (MCM_RMW_PLACR(base, MCM_PLACR_DFCC_MASK, MCM_PLACR_DFCC(value)))
#define MCM_BWR_PLACR_DFCC(base, value) (MCM_WR_PLACR_DFCC(base, value))
/*@}*/

/*!
 * @name Register MCM_PLACR, field EFDS[14] (RW)
 *
 * Enables flash data speculation.
 *
 * Values:
 * - 0 - Disable flash data speculation.
 * - 1 - Enable flash data speculation.
 */
/*@{*/
/*! @brief Read current value of the MCM_PLACR_EFDS field. */
#define MCM_RD_PLACR_EFDS(base) ((MCM_PLACR_REG(base) & MCM_PLACR_EFDS_MASK) >> MCM_PLACR_EFDS_SHIFT)
#define MCM_BRD_PLACR_EFDS(base) (MCM_RD_PLACR_EFDS(base))

/*! @brief Set the EFDS field to a new value. */
#define MCM_WR_PLACR_EFDS(base, value) (MCM_RMW_PLACR(base, MCM_PLACR_EFDS_MASK, MCM_PLACR_EFDS(value)))
#define MCM_BWR_PLACR_EFDS(base, value) (MCM_WR_PLACR_EFDS(base, value))
/*@}*/

/*!
 * @name Register MCM_PLACR, field DFCS[15] (RW)
 *
 * Disables flash controller speculation.
 *
 * Values:
 * - 0 - Enable flash controller speculation.
 * - 1 - Disable flash controller speculation.
 */
/*@{*/
/*! @brief Read current value of the MCM_PLACR_DFCS field. */
#define MCM_RD_PLACR_DFCS(base) ((MCM_PLACR_REG(base) & MCM_PLACR_DFCS_MASK) >> MCM_PLACR_DFCS_SHIFT)
#define MCM_BRD_PLACR_DFCS(base) (MCM_RD_PLACR_DFCS(base))

/*! @brief Set the DFCS field to a new value. */
#define MCM_WR_PLACR_DFCS(base, value) (MCM_RMW_PLACR(base, MCM_PLACR_DFCS_MASK, MCM_PLACR_DFCS(value)))
#define MCM_BWR_PLACR_DFCS(base, value) (MCM_WR_PLACR_DFCS(base, value))
/*@}*/

/*!
 * @name Register MCM_PLACR, field ESFC[16] (RW)
 *
 * Enables stalling flash controller when flash is busy. When software needs to
 * access the flash memory while a flash memory resource is being manipulated by
 * a flash command, software can enable a stall mechanism to avoid a read
 * collision. The stall mechanism allows software to execute code from the same block on
 * which flash operations are being performed. However, software must ensure the
 * sector the flash operations are being performed on is not the same sector
 * from which the code is executing. ESFC enables the stall mechanism. This bit must
 * be set only just before the flash operation is executed and must be cleared
 * when the operation completes.
 *
 * Values:
 * - 0 - Disable stalling flash controller when flash is busy.
 * - 1 - Enable stalling flash controller when flash is busy.
 */
/*@{*/
/*! @brief Read current value of the MCM_PLACR_ESFC field. */
#define MCM_RD_PLACR_ESFC(base) ((MCM_PLACR_REG(base) & MCM_PLACR_ESFC_MASK) >> MCM_PLACR_ESFC_SHIFT)
#define MCM_BRD_PLACR_ESFC(base) (MCM_RD_PLACR_ESFC(base))

/*! @brief Set the ESFC field to a new value. */
#define MCM_WR_PLACR_ESFC(base, value) (MCM_RMW_PLACR(base, MCM_PLACR_ESFC_MASK, MCM_PLACR_ESFC(value)))
#define MCM_BWR_PLACR_ESFC(base, value) (MCM_WR_PLACR_ESFC(base, value))
/*@}*/

/*******************************************************************************
 * MCM_CPO - Compute Operation Control Register
 ******************************************************************************/

/*!
 * @brief MCM_CPO - Compute Operation Control Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * This register controls the Compute Operation.
 */
/*!
 * @name Constants and macros for entire MCM_CPO register
 */
/*@{*/
#define MCM_RD_CPO(base)         (MCM_CPO_REG(base))
#define MCM_WR_CPO(base, value)  (MCM_CPO_REG(base) = (value))
#define MCM_RMW_CPO(base, mask, value) (MCM_WR_CPO(base, (MCM_RD_CPO(base) & ~(mask)) | (value)))
#define MCM_SET_CPO(base, value) (MCM_WR_CPO(base, MCM_RD_CPO(base) |  (value)))
#define MCM_CLR_CPO(base, value) (MCM_WR_CPO(base, MCM_RD_CPO(base) & ~(value)))
#define MCM_TOG_CPO(base, value) (MCM_WR_CPO(base, MCM_RD_CPO(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual MCM_CPO bitfields
 */

/*!
 * @name Register MCM_CPO, field CPOREQ[0] (RW)
 *
 * This bit is auto-cleared by vector fetching if CPOWOI = 1.
 *
 * Values:
 * - 0 - Request is cleared.
 * - 1 - Request Compute Operation.
 */
/*@{*/
/*! @brief Read current value of the MCM_CPO_CPOREQ field. */
#define MCM_RD_CPO_CPOREQ(base) ((MCM_CPO_REG(base) & MCM_CPO_CPOREQ_MASK) >> MCM_CPO_CPOREQ_SHIFT)
#define MCM_BRD_CPO_CPOREQ(base) (MCM_RD_CPO_CPOREQ(base))

/*! @brief Set the CPOREQ field to a new value. */
#define MCM_WR_CPO_CPOREQ(base, value) (MCM_RMW_CPO(base, MCM_CPO_CPOREQ_MASK, MCM_CPO_CPOREQ(value)))
#define MCM_BWR_CPO_CPOREQ(base, value) (MCM_WR_CPO_CPOREQ(base, value))
/*@}*/

/*!
 * @name Register MCM_CPO, field CPOACK[1] (RO)
 *
 * Values:
 * - 0 - Compute operation entry has not completed or compute operation exit has
 *     completed.
 * - 1 - Compute operation entry has completed or compute operation exit has not
 *     completed.
 */
/*@{*/
/*! @brief Read current value of the MCM_CPO_CPOACK field. */
#define MCM_RD_CPO_CPOACK(base) ((MCM_CPO_REG(base) & MCM_CPO_CPOACK_MASK) >> MCM_CPO_CPOACK_SHIFT)
#define MCM_BRD_CPO_CPOACK(base) (MCM_RD_CPO_CPOACK(base))
/*@}*/

/*!
 * @name Register MCM_CPO, field CPOWOI[2] (RW)
 *
 * Values:
 * - 0 - No effect.
 * - 1 - When set, the CPOREQ is cleared on any interrupt or exception vector
 *     fetch.
 */
/*@{*/
/*! @brief Read current value of the MCM_CPO_CPOWOI field. */
#define MCM_RD_CPO_CPOWOI(base) ((MCM_CPO_REG(base) & MCM_CPO_CPOWOI_MASK) >> MCM_CPO_CPOWOI_SHIFT)
#define MCM_BRD_CPO_CPOWOI(base) (MCM_RD_CPO_CPOWOI(base))

/*! @brief Set the CPOWOI field to a new value. */
#define MCM_WR_CPO_CPOWOI(base, value) (MCM_RMW_CPO(base, MCM_CPO_CPOWOI_MASK, MCM_CPO_CPOWOI(value)))
#define MCM_BWR_CPO_CPOWOI(base, value) (MCM_WR_CPO_CPOWOI(base, value))
/*@}*/

/*
 * MKL27Z644 MTB
 *
 * Micro Trace Buffer
 *
 * Registers defined in this header file:
 * - MTB_POSITION - MTB Position Register
 * - MTB_MASTER - MTB Master Register
 * - MTB_FLOW - MTB Flow Register
 * - MTB_BASE - MTB Base Register
 * - MTB_MODECTRL - Integration Mode Control Register
 * - MTB_TAGSET - Claim TAG Set Register
 * - MTB_TAGCLEAR - Claim TAG Clear Register
 * - MTB_LOCKACCESS - Lock Access Register
 * - MTB_LOCKSTAT - Lock Status Register
 * - MTB_AUTHSTAT - Authentication Status Register
 * - MTB_DEVICEARCH - Device Architecture Register
 * - MTB_DEVICECFG - Device Configuration Register
 * - MTB_DEVICETYPID - Device Type Identifier Register
 * - MTB_PERIPHID - Peripheral ID Register
 * - MTB_COMPID - Component ID Register
 */

#define MTB_INSTANCE_COUNT (1U) /*!< Number of instances of the MTB module. */
#define MTB_IDX (0U) /*!< Instance number for MTB. */

/*******************************************************************************
 * MTB_POSITION - MTB Position Register
 ******************************************************************************/

/*!
 * @brief MTB_POSITION - MTB Position Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * The MTB_POSITION register contains the Trace Write Address Pointer and Wrap
 * fields. This register can be modified by the explicit programming model writes.
 * It is also automatically updated by the MTB hardware when trace packets are
 * being recorded. The base address of the system RAM in the memory map dictates
 * special consideration for the placement of the MTB. Consider the following
 * guidelines: For the standard configuration where the size of the MTB is <= 25% of
 * the total RAM capacity, it is recommended the MTB be based at the address
 * defined by the MTB_BASE register. The read-only MTB_BASE register is defined by
 * the expression (0x2000_0000 - (RAM_Size/4)). For this configuration, the
 * MTB_POSITION register is initialized to MTB_BASE & 0x0000_7FF8. If the size of the
 * MTB is more than 25% but less than or equal to 50% of the total RAM capacity, it
 * is recommended the MTB be based at address 0x2000_0000. In this
 * configuration, the MTB_POSITION register is initialized to (0x2000_0000 & 0x0000_7FF8) =
 * 0x0000_00000. Following these two suggested placements provides a full-featured
 * circular memory buffer containing program trace packets. In the unlikely event
 * an even larger trace buffer is required, a write-once capacity of 75% of the
 * total RAM capacity can be based at address 0x2000_0000. The MTB_POSITION
 * register is initialized to (0x2000_0000 & 0x0000_7FF8) = 0x0000_0000. However, this
 * configuration cannot support operation as a circular queue and instead
 * requires the use of the MTB_FLOW[WATERMARK] capability to automatically disable
 * tracing or halting the processor as the number of packet writes approach the
 * buffer capacity. See the MTB_FLOW register description for more details.
 */
/*!
 * @name Constants and macros for entire MTB_POSITION register
 */
/*@{*/
#define MTB_RD_POSITION(base)    (MTB_POSITION_REG(base))
#define MTB_WR_POSITION(base, value) (MTB_POSITION_REG(base) = (value))
#define MTB_RMW_POSITION(base, mask, value) (MTB_WR_POSITION(base, (MTB_RD_POSITION(base) & ~(mask)) | (value)))
#define MTB_SET_POSITION(base, value) (MTB_WR_POSITION(base, MTB_RD_POSITION(base) |  (value)))
#define MTB_CLR_POSITION(base, value) (MTB_WR_POSITION(base, MTB_RD_POSITION(base) & ~(value)))
#define MTB_TOG_POSITION(base, value) (MTB_WR_POSITION(base, MTB_RD_POSITION(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual MTB_POSITION bitfields
 */

/*!
 * @name Register MTB_POSITION, field WRAP[2] (RW)
 *
 * This field is set to 1 automatically when the POINTER value wraps as
 * determined by the MTB_MASTER[MASK] field in the MASTER Trace Control Register. A debug
 * agent might use the WRAP field to determine whether the trace information
 * above and below the pointer address is valid.
 */
/*@{*/
/*! @brief Read current value of the MTB_POSITION_WRAP field. */
#define MTB_RD_POSITION_WRAP(base) ((MTB_POSITION_REG(base) & MTB_POSITION_WRAP_MASK) >> MTB_POSITION_WRAP_SHIFT)
#define MTB_BRD_POSITION_WRAP(base) (MTB_RD_POSITION_WRAP(base))

/*! @brief Set the WRAP field to a new value. */
#define MTB_WR_POSITION_WRAP(base, value) (MTB_RMW_POSITION(base, MTB_POSITION_WRAP_MASK, MTB_POSITION_WRAP(value)))
#define MTB_BWR_POSITION_WRAP(base, value) (MTB_WR_POSITION_WRAP(base, value))
/*@}*/

/*!
 * @name Register MTB_POSITION, field POINTER[31:3] (RW)
 *
 * Because a packet consists of two words, the POINTER field is the address of
 * the first word of a packet. This field contains bits[31:3] of the RAM address
 * where the next trace packet is written. Therefore, it points to an unused
 * location and is automatically incremented. A debug agent can calculate the system
 * memory map address for the current location in the MTB using the following
 * "generic" equation: Given mtb_size = 1 << (MTB_MASTER[MASK] + 4), systemAddress =
 * MTB_BASE + (((MTB_POSITION & 0xFFFF_FFF8) + (mtb_size - (MTB_BASE &
 * (mtb_size-1)))) & 0x0000_7FF8); For this device, a simpler expression also applies. See
 * the following pseudo-code: if ((MTB_POSITION >> 13) == 0x3) systemAddress =
 * (0x1FFF << 16) + (0x1 << 15) + (MTB_POSITION & 0x7FF8); else systemAddress =
 * (0x2000 << 16) + (0x0 << 15) + (MTB_POSITION & 0x7FF8); The size of the RAM is
 * parameterized and the most significant bits of the POINTER field are RAZ/WI. For
 * these devices, POSITION[31:15] == POSITION[POINTER[28:12]] are RAZ/WI.
 * Therefore, the active bits in this field are POSITION[14:3] ==
 * POSITION[POINTER[11:0]].
 */
/*@{*/
/*! @brief Read current value of the MTB_POSITION_POINTER field. */
#define MTB_RD_POSITION_POINTER(base) ((MTB_POSITION_REG(base) & MTB_POSITION_POINTER_MASK) >> MTB_POSITION_POINTER_SHIFT)
#define MTB_BRD_POSITION_POINTER(base) (MTB_RD_POSITION_POINTER(base))

/*! @brief Set the POINTER field to a new value. */
#define MTB_WR_POSITION_POINTER(base, value) (MTB_RMW_POSITION(base, MTB_POSITION_POINTER_MASK, MTB_POSITION_POINTER(value)))
#define MTB_BWR_POSITION_POINTER(base, value) (MTB_WR_POSITION_POINTER(base, value))
/*@}*/

/*******************************************************************************
 * MTB_MASTER - MTB Master Register
 ******************************************************************************/

/*!
 * @brief MTB_MASTER - MTB Master Register (RW)
 *
 * Reset value: 0x00000080U
 *
 * The MTB_MASTER register contains the main program trace enable plus other
 * trace controls. This register can be modified by the explicit programming model
 * writes. MTB_MASTER[EN] and MTB_MASTER[HALTREQ] fields are also automatically
 * updated by the MTB hardware. Before MTB_MASTER[EN] or MTB_MASTER[TSTARTEN] are
 * set to 1, the software must initialize the MTB_POSITION and MTB_FLOW registers.
 * If MTB_FLOW[WATERMARK] is used to stop tracing or to halt the processor,
 * MTB_MASTER[MASK] must still be set to a value that prevents MTB_POSITION[POINTER]
 * from wrapping before it reaches the MTB_FLOW[WATERMARK] value. The format of
 * this mask field is different than MTBDWT_MASKn[MASK].
 */
/*!
 * @name Constants and macros for entire MTB_MASTER register
 */
/*@{*/
#define MTB_RD_MASTER(base)      (MTB_MASTER_REG(base))
#define MTB_WR_MASTER(base, value) (MTB_MASTER_REG(base) = (value))
#define MTB_RMW_MASTER(base, mask, value) (MTB_WR_MASTER(base, (MTB_RD_MASTER(base) & ~(mask)) | (value)))
#define MTB_SET_MASTER(base, value) (MTB_WR_MASTER(base, MTB_RD_MASTER(base) |  (value)))
#define MTB_CLR_MASTER(base, value) (MTB_WR_MASTER(base, MTB_RD_MASTER(base) & ~(value)))
#define MTB_TOG_MASTER(base, value) (MTB_WR_MASTER(base, MTB_RD_MASTER(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual MTB_MASTER bitfields
 */

/*!
 * @name Register MTB_MASTER, field MASK[4:0] (RW)
 *
 * This value determines the maximum size of the trace buffer in RAM. It
 * specifies the most-significant bit of the MTB_POSITION[POINTER] field that can be
 * updated by automatic increment. If the trace tries to advance past this power of
 * 2, the MTB_POSITION[WRAP] bit is set to 1, the MTB_POSITION[MASK+3:3] ==
 * MTB_POSITION[POINTER[MASK:0]] bits are set to 0, and the MTB_POSITION[14:MASK+3] ==
 * MTB_POSITION[POINTER[11:MASK+1]] bits remain unchanged. This field causes the
 * trace packet information to be stored in a circular buffer of size 2^[MASK+4]
 * bytes, that can be positioned in memory at multiples of this size. As
 * detailed in the MTB_POSITION description, typical "upper limits" for the MTB size are
 * RAM_Size/4 or RAM_Size/2. Values greater than the maximum have the same
 * effect as the maximum.
 */
/*@{*/
/*! @brief Read current value of the MTB_MASTER_MASK field. */
#define MTB_RD_MASTER_MASK(base) ((MTB_MASTER_REG(base) & MTB_MASTER_MASK_MASK) >> MTB_MASTER_MASK_SHIFT)
#define MTB_BRD_MASTER_MASK(base) (MTB_RD_MASTER_MASK(base))

/*! @brief Set the MASK field to a new value. */
#define MTB_WR_MASTER_MASK(base, value) (MTB_RMW_MASTER(base, MTB_MASTER_MASK_MASK, MTB_MASTER_MASK(value)))
#define MTB_BWR_MASTER_MASK(base, value) (MTB_WR_MASTER_MASK(base, value))
/*@}*/

/*!
 * @name Register MTB_MASTER, field TSTARTEN[5] (RW)
 *
 * If this field is 1 and the TSTART signal is HIGH, then EN is set to 1.
 * Tracing continues until a stop condition occurs.
 */
/*@{*/
/*! @brief Read current value of the MTB_MASTER_TSTARTEN field. */
#define MTB_RD_MASTER_TSTARTEN(base) ((MTB_MASTER_REG(base) & MTB_MASTER_TSTARTEN_MASK) >> MTB_MASTER_TSTARTEN_SHIFT)
#define MTB_BRD_MASTER_TSTARTEN(base) (MTB_RD_MASTER_TSTARTEN(base))

/*! @brief Set the TSTARTEN field to a new value. */
#define MTB_WR_MASTER_TSTARTEN(base, value) (MTB_RMW_MASTER(base, MTB_MASTER_TSTARTEN_MASK, MTB_MASTER_TSTARTEN(value)))
#define MTB_BWR_MASTER_TSTARTEN(base, value) (MTB_WR_MASTER_TSTARTEN(base, value))
/*@}*/

/*!
 * @name Register MTB_MASTER, field TSTOPEN[6] (RW)
 *
 * If this field is 1 and the TSTOP signal is HIGH, then EN is set to 0. If a
 * trace packet is being written to memory, the write is completed before tracing
 * is stopped.
 */
/*@{*/
/*! @brief Read current value of the MTB_MASTER_TSTOPEN field. */
#define MTB_RD_MASTER_TSTOPEN(base) ((MTB_MASTER_REG(base) & MTB_MASTER_TSTOPEN_MASK) >> MTB_MASTER_TSTOPEN_SHIFT)
#define MTB_BRD_MASTER_TSTOPEN(base) (MTB_RD_MASTER_TSTOPEN(base))

/*! @brief Set the TSTOPEN field to a new value. */
#define MTB_WR_MASTER_TSTOPEN(base, value) (MTB_RMW_MASTER(base, MTB_MASTER_TSTOPEN_MASK, MTB_MASTER_TSTOPEN(value)))
#define MTB_BWR_MASTER_TSTOPEN(base, value) (MTB_WR_MASTER_TSTOPEN(base, value))
/*@}*/

/*!
 * @name Register MTB_MASTER, field SFRWPRIV[7] (RW)
 *
 * If this field is 0, then user or privileged AHB read and write accesses to
 * the MTB_RAM Special Function Registers (programming model) are permitted. If
 * this field is 1, then only privileged write accesses are permitted; user write
 * accesses are ignored. The HPROT[1] signal determines if an access is user or
 * privileged. Note MTB_RAM SFR read access are not controlled by this bit and are
 * always permitted.
 */
/*@{*/
/*! @brief Read current value of the MTB_MASTER_SFRWPRIV field. */
#define MTB_RD_MASTER_SFRWPRIV(base) ((MTB_MASTER_REG(base) & MTB_MASTER_SFRWPRIV_MASK) >> MTB_MASTER_SFRWPRIV_SHIFT)
#define MTB_BRD_MASTER_SFRWPRIV(base) (MTB_RD_MASTER_SFRWPRIV(base))

/*! @brief Set the SFRWPRIV field to a new value. */
#define MTB_WR_MASTER_SFRWPRIV(base, value) (MTB_RMW_MASTER(base, MTB_MASTER_SFRWPRIV_MASK, MTB_MASTER_SFRWPRIV(value)))
#define MTB_BWR_MASTER_SFRWPRIV(base, value) (MTB_WR_MASTER_SFRWPRIV(base, value))
/*@}*/

/*!
 * @name Register MTB_MASTER, field RAMPRIV[8] (RW)
 *
 * If this field is 0, then user or privileged AHB read and write accesses to
 * the RAM are permitted. If this field is 1, then only privileged AHB read and
 * write accesses to the RAM are permitted and user accesses are RAZ/WI. The
 * HPROT[1] signal determines if an access is a user or privileged mode reference.
 */
/*@{*/
/*! @brief Read current value of the MTB_MASTER_RAMPRIV field. */
#define MTB_RD_MASTER_RAMPRIV(base) ((MTB_MASTER_REG(base) & MTB_MASTER_RAMPRIV_MASK) >> MTB_MASTER_RAMPRIV_SHIFT)
#define MTB_BRD_MASTER_RAMPRIV(base) (MTB_RD_MASTER_RAMPRIV(base))

/*! @brief Set the RAMPRIV field to a new value. */
#define MTB_WR_MASTER_RAMPRIV(base, value) (MTB_RMW_MASTER(base, MTB_MASTER_RAMPRIV_MASK, MTB_MASTER_RAMPRIV(value)))
#define MTB_BWR_MASTER_RAMPRIV(base, value) (MTB_WR_MASTER_RAMPRIV(base, value))
/*@}*/

/*!
 * @name Register MTB_MASTER, field HALTREQ[9] (RW)
 *
 * This field is connected to the halt request signal of the trace logic,
 * EDBGRQ. When HALTREQ is set to 1, the EDBFGRQ is asserted if DBGEN (invasive debug
 * enable, one of the debug authentication interface signals) is also HIGH.
 * HALTREQ can be automatically set to 1 using MTB_FLOW[WATERMARK].
 */
/*@{*/
/*! @brief Read current value of the MTB_MASTER_HALTREQ field. */
#define MTB_RD_MASTER_HALTREQ(base) ((MTB_MASTER_REG(base) & MTB_MASTER_HALTREQ_MASK) >> MTB_MASTER_HALTREQ_SHIFT)
#define MTB_BRD_MASTER_HALTREQ(base) (MTB_RD_MASTER_HALTREQ(base))

/*! @brief Set the HALTREQ field to a new value. */
#define MTB_WR_MASTER_HALTREQ(base, value) (MTB_RMW_MASTER(base, MTB_MASTER_HALTREQ_MASK, MTB_MASTER_HALTREQ(value)))
#define MTB_BWR_MASTER_HALTREQ(base, value) (MTB_WR_MASTER_HALTREQ(base, value))
/*@}*/

/*!
 * @name Register MTB_MASTER, field EN[31] (RW)
 *
 * When this field is 1, trace data is written into the RAM memory location
 * addressed by MTB_POSITION[POINTER]. The MTB_POSITION[POINTER] value auto
 * increments after the trace data packet is written. EN can be automatically set to 0
 * using the MTB_FLOW[WATERMARK] field and the MTB_FLOW[AUTOSTOP] bit. EN is
 * automatically set to 1 if TSTARTEN is 1 and the TSTART signal is HIGH. EN is
 * automatically set to 0 if TSTOPEN is 1 and the TSTOP signal is HIGH. If EN is set to 0
 * because MTB_FLOW[WATERMARK] is set, then it is not automatically set to 1 if
 * TSTARTEN is 1 and the TSTART input is HIGH. In this case, tracing can only be
 * restarted if MTB_FLOW[WATERMARK] or MTB_POSITION[POINTER] value is changed by
 * software.
 */
/*@{*/
/*! @brief Read current value of the MTB_MASTER_EN field. */
#define MTB_RD_MASTER_EN(base) ((MTB_MASTER_REG(base) & MTB_MASTER_EN_MASK) >> MTB_MASTER_EN_SHIFT)
#define MTB_BRD_MASTER_EN(base) (MTB_RD_MASTER_EN(base))

/*! @brief Set the EN field to a new value. */
#define MTB_WR_MASTER_EN(base, value) (MTB_RMW_MASTER(base, MTB_MASTER_EN_MASK, MTB_MASTER_EN(value)))
#define MTB_BWR_MASTER_EN(base, value) (MTB_WR_MASTER_EN(base, value))
/*@}*/

/*******************************************************************************
 * MTB_FLOW - MTB Flow Register
 ******************************************************************************/

/*!
 * @brief MTB_FLOW - MTB Flow Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * The MTB_FLOW register contains the watermark address and the
 * autostop/autohalt control bits. If tracing is stopped using the watermark autostop feature, it
 * cannot be restarted until software clears the watermark autostop. This can be
 * achieved in one of the following ways: Changing the MTB_POSITION[POINTER]
 * field value to point to the beginning of the trace buffer, or Setting
 * MTB_FLOW[AUTOSTOP] = 0. A debug agent can use MTB_FLOW[AUTOSTOP] to fill the trace buffer
 * once only without halting the processor. A debug agent can use
 * MTB_FLOW[AUTOHALT] to fill the trace buffer once before causing the Cortex-M0+ processor to
 * enter the Debug state. To enter Debug state, the Cortex-M0+ processor might
 * have to perform additional branch type operations. Therefore, the
 * MTB_FLOW[WATERMARK] field must be set below the final entry in the trace buffer region.
 */
/*!
 * @name Constants and macros for entire MTB_FLOW register
 */
/*@{*/
#define MTB_RD_FLOW(base)        (MTB_FLOW_REG(base))
#define MTB_WR_FLOW(base, value) (MTB_FLOW_REG(base) = (value))
#define MTB_RMW_FLOW(base, mask, value) (MTB_WR_FLOW(base, (MTB_RD_FLOW(base) & ~(mask)) | (value)))
#define MTB_SET_FLOW(base, value) (MTB_WR_FLOW(base, MTB_RD_FLOW(base) |  (value)))
#define MTB_CLR_FLOW(base, value) (MTB_WR_FLOW(base, MTB_RD_FLOW(base) & ~(value)))
#define MTB_TOG_FLOW(base, value) (MTB_WR_FLOW(base, MTB_RD_FLOW(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual MTB_FLOW bitfields
 */

/*!
 * @name Register MTB_FLOW, field AUTOSTOP[0] (RW)
 *
 * If this field is 1 and WATERMARK is equal to MTB_POSITION[POINTER], then
 * MTB_MASTER[EN] is automatically set to 0. This stops tracing.
 */
/*@{*/
/*! @brief Read current value of the MTB_FLOW_AUTOSTOP field. */
#define MTB_RD_FLOW_AUTOSTOP(base) ((MTB_FLOW_REG(base) & MTB_FLOW_AUTOSTOP_MASK) >> MTB_FLOW_AUTOSTOP_SHIFT)
#define MTB_BRD_FLOW_AUTOSTOP(base) (MTB_RD_FLOW_AUTOSTOP(base))

/*! @brief Set the AUTOSTOP field to a new value. */
#define MTB_WR_FLOW_AUTOSTOP(base, value) (MTB_RMW_FLOW(base, MTB_FLOW_AUTOSTOP_MASK, MTB_FLOW_AUTOSTOP(value)))
#define MTB_BWR_FLOW_AUTOSTOP(base, value) (MTB_WR_FLOW_AUTOSTOP(base, value))
/*@}*/

/*!
 * @name Register MTB_FLOW, field AUTOHALT[1] (RW)
 *
 * If this field is 1 and WATERMARK is equal to MTB_POSITION[POINTER], then
 * MTB_MASTER[HALTREQ] is automatically set to 1. If the DBGEN signal is HIGH, the
 * MTB asserts this halt request to the Cortex-M0+ processor by asserting the
 * EDBGRQ signal.
 */
/*@{*/
/*! @brief Read current value of the MTB_FLOW_AUTOHALT field. */
#define MTB_RD_FLOW_AUTOHALT(base) ((MTB_FLOW_REG(base) & MTB_FLOW_AUTOHALT_MASK) >> MTB_FLOW_AUTOHALT_SHIFT)
#define MTB_BRD_FLOW_AUTOHALT(base) (MTB_RD_FLOW_AUTOHALT(base))

/*! @brief Set the AUTOHALT field to a new value. */
#define MTB_WR_FLOW_AUTOHALT(base, value) (MTB_RMW_FLOW(base, MTB_FLOW_AUTOHALT_MASK, MTB_FLOW_AUTOHALT(value)))
#define MTB_BWR_FLOW_AUTOHALT(base, value) (MTB_WR_FLOW_AUTOHALT(base, value))
/*@}*/

/*!
 * @name Register MTB_FLOW, field WATERMARK[31:3] (RW)
 *
 * This field contains an address in the same format as the
 * MTB_POSITION[POINTER] field. When MTB_POSITION[POINTER] matches the WATERMARK field value, actions
 * defined by the AUTOHALT and AUTOSTOP bits are performed.
 */
/*@{*/
/*! @brief Read current value of the MTB_FLOW_WATERMARK field. */
#define MTB_RD_FLOW_WATERMARK(base) ((MTB_FLOW_REG(base) & MTB_FLOW_WATERMARK_MASK) >> MTB_FLOW_WATERMARK_SHIFT)
#define MTB_BRD_FLOW_WATERMARK(base) (MTB_RD_FLOW_WATERMARK(base))

/*! @brief Set the WATERMARK field to a new value. */
#define MTB_WR_FLOW_WATERMARK(base, value) (MTB_RMW_FLOW(base, MTB_FLOW_WATERMARK_MASK, MTB_FLOW_WATERMARK(value)))
#define MTB_BWR_FLOW_WATERMARK(base, value) (MTB_WR_FLOW_WATERMARK(base, value))
/*@}*/

/*******************************************************************************
 * MTB_BASE - MTB Base Register
 ******************************************************************************/

/*!
 * @brief MTB_BASE - MTB Base Register (RO)
 *
 * Reset value: 0x00000000U
 *
 * The read-only MTB_BASE Register indicates where the RAM is located in the
 * system memory map. This register is provided to enable auto discovery of the MTB
 * RAM location, by a debug agent and is defined by a hardware design parameter.
 * For this device, the base address is defined by the expression:
 * MTB_BASE[BASEADDR] = 0x2000_0000 - (RAM_Size/4)
 */
/*!
 * @name Constants and macros for entire MTB_BASE register
 */
/*@{*/
#define MTB_RD_BASE(base)        (MTB_BASE_REG(base))
/*@}*/

/*******************************************************************************
 * MTB_MODECTRL - Integration Mode Control Register
 ******************************************************************************/

/*!
 * @brief MTB_MODECTRL - Integration Mode Control Register (RO)
 *
 * Reset value: 0x00000000U
 *
 * This register enables the device to switch from a functional mode, or default
 * behavior, into integration mode. It is hardwired to specific values used
 * during the auto-discovery process by an external debug agent.
 */
/*!
 * @name Constants and macros for entire MTB_MODECTRL register
 */
/*@{*/
#define MTB_RD_MODECTRL(base)    (MTB_MODECTRL_REG(base))
/*@}*/

/*******************************************************************************
 * MTB_TAGSET - Claim TAG Set Register
 ******************************************************************************/

/*!
 * @brief MTB_TAGSET - Claim TAG Set Register (RO)
 *
 * Reset value: 0x00000000U
 *
 * The Claim Tag Set Register returns the number of bits that can be set on a
 * read, and enables individual bits to be set on a write. It is hardwired to
 * specific values used during the auto-discovery process by an external debug agent.
 */
/*!
 * @name Constants and macros for entire MTB_TAGSET register
 */
/*@{*/
#define MTB_RD_TAGSET(base)      (MTB_TAGSET_REG(base))
/*@}*/

/*******************************************************************************
 * MTB_TAGCLEAR - Claim TAG Clear Register
 ******************************************************************************/

/*!
 * @brief MTB_TAGCLEAR - Claim TAG Clear Register (RO)
 *
 * Reset value: 0x00000000U
 *
 * The read/write Claim Tag Clear Register is used to read the claim status on
 * debug resources. A read indicates the claim tag status. Writing 1 to a specific
 * bit clears the corresponding claim tag to 0. It is hardwired to specific
 * values used during the auto-discovery process by an external debug agent.
 */
/*!
 * @name Constants and macros for entire MTB_TAGCLEAR register
 */
/*@{*/
#define MTB_RD_TAGCLEAR(base)    (MTB_TAGCLEAR_REG(base))
/*@}*/

/*******************************************************************************
 * MTB_LOCKACCESS - Lock Access Register
 ******************************************************************************/

/*!
 * @brief MTB_LOCKACCESS - Lock Access Register (RO)
 *
 * Reset value: 0x00000000U
 *
 * The Lock Access Register enables a write access to component registers. It is
 * hardwired to specific values used during the auto-discovery process by an
 * external debug agent.
 */
/*!
 * @name Constants and macros for entire MTB_LOCKACCESS register
 */
/*@{*/
#define MTB_RD_LOCKACCESS(base)  (MTB_LOCKACCESS_REG(base))
/*@}*/

/*******************************************************************************
 * MTB_LOCKSTAT - Lock Status Register
 ******************************************************************************/

/*!
 * @brief MTB_LOCKSTAT - Lock Status Register (RO)
 *
 * Reset value: 0x00000000U
 *
 * The Lock Status Register indicates the status of the lock control mechanism.
 * This register is used in conjunction with the Lock Access Register. It is
 * hardwired to specific values used during the auto-discovery process by an external
 * debug agent.
 */
/*!
 * @name Constants and macros for entire MTB_LOCKSTAT register
 */
/*@{*/
#define MTB_RD_LOCKSTAT(base)    (MTB_LOCKSTAT_REG(base))
/*@}*/

/*******************************************************************************
 * MTB_AUTHSTAT - Authentication Status Register
 ******************************************************************************/

/*!
 * @brief MTB_AUTHSTAT - Authentication Status Register (RO)
 *
 * Reset value: 0x00000000U
 *
 * The Authentication Status Register reports the required security level and
 * current status of the security enable bit pairs. Where functionality changes on
 * a given security level, this change must be reported in this register. It is
 * connected to specific signals used during the auto-discovery process by an
 * external debug agent. MTB_AUTHSTAT[3:2] indicates if nonsecure, noninvasive debug
 * is enabled or disabled, while MTB_AUTHSTAT[1:0] indicates the enabled/disabled
 * state of nonsecure, invasive debug. For both 2-bit fields, 0b10 indicates the
 * functionality is disabled and 0b11 indicates it is enabled.
 */
/*!
 * @name Constants and macros for entire MTB_AUTHSTAT register
 */
/*@{*/
#define MTB_RD_AUTHSTAT(base)    (MTB_AUTHSTAT_REG(base))
/*@}*/

/*
 * Constants & macros for individual MTB_AUTHSTAT bitfields
 */

/*!
 * @name Register MTB_AUTHSTAT, field BIT0[0] (RO)
 *
 * Connected to DBGEN.
 */
/*@{*/
/*! @brief Read current value of the MTB_AUTHSTAT_BIT0 field. */
#define MTB_RD_AUTHSTAT_BIT0(base) ((MTB_AUTHSTAT_REG(base) & MTB_AUTHSTAT_BIT0_MASK) >> MTB_AUTHSTAT_BIT0_SHIFT)
#define MTB_BRD_AUTHSTAT_BIT0(base) (MTB_RD_AUTHSTAT_BIT0(base))
/*@}*/

/*!
 * @name Register MTB_AUTHSTAT, field BIT1[1] (ROO)
 *
 * Hardwired to 1.
 */
/*@{*/
/*! @brief Read current value of the MTB_AUTHSTAT_BIT1 field. */
#define MTB_RD_AUTHSTAT_BIT1(base) ((MTB_AUTHSTAT_REG(base) & MTB_AUTHSTAT_BIT1_MASK) >> MTB_AUTHSTAT_BIT1_SHIFT)
#define MTB_BRD_AUTHSTAT_BIT1(base) (MTB_RD_AUTHSTAT_BIT1(base))
/*@}*/

/*!
 * @name Register MTB_AUTHSTAT, field BIT2[2] (RO)
 *
 * Connected to NIDEN or DBGEN signal.
 */
/*@{*/
/*! @brief Read current value of the MTB_AUTHSTAT_BIT2 field. */
#define MTB_RD_AUTHSTAT_BIT2(base) ((MTB_AUTHSTAT_REG(base) & MTB_AUTHSTAT_BIT2_MASK) >> MTB_AUTHSTAT_BIT2_SHIFT)
#define MTB_BRD_AUTHSTAT_BIT2(base) (MTB_RD_AUTHSTAT_BIT2(base))
/*@}*/

/*!
 * @name Register MTB_AUTHSTAT, field BIT3[3] (ROO)
 *
 * Hardwired to 1.
 */
/*@{*/
/*! @brief Read current value of the MTB_AUTHSTAT_BIT3 field. */
#define MTB_RD_AUTHSTAT_BIT3(base) ((MTB_AUTHSTAT_REG(base) & MTB_AUTHSTAT_BIT3_MASK) >> MTB_AUTHSTAT_BIT3_SHIFT)
#define MTB_BRD_AUTHSTAT_BIT3(base) (MTB_RD_AUTHSTAT_BIT3(base))
/*@}*/

/*******************************************************************************
 * MTB_DEVICEARCH - Device Architecture Register
 ******************************************************************************/

/*!
 * @brief MTB_DEVICEARCH - Device Architecture Register (RO)
 *
 * Reset value: 0x47700A31U
 *
 * This register indicates the device architecture. It is hardwired to specific
 * values used during the auto-discovery process by an external debug agent.
 */
/*!
 * @name Constants and macros for entire MTB_DEVICEARCH register
 */
/*@{*/
#define MTB_RD_DEVICEARCH(base)  (MTB_DEVICEARCH_REG(base))
/*@}*/

/*******************************************************************************
 * MTB_DEVICECFG - Device Configuration Register
 ******************************************************************************/

/*!
 * @brief MTB_DEVICECFG - Device Configuration Register (RO)
 *
 * Reset value: 0x00000000U
 *
 * This register indicates the device configuration. It is hardwired to specific
 * values used during the auto-discovery process by an external debug agent.
 */
/*!
 * @name Constants and macros for entire MTB_DEVICECFG register
 */
/*@{*/
#define MTB_RD_DEVICECFG(base)   (MTB_DEVICECFG_REG(base))
/*@}*/

/*******************************************************************************
 * MTB_DEVICETYPID - Device Type Identifier Register
 ******************************************************************************/

/*!
 * @brief MTB_DEVICETYPID - Device Type Identifier Register (RO)
 *
 * Reset value: 0x00000031U
 *
 * This register indicates the device type ID. It is hardwired to specific
 * values used during the auto-discovery process by an external debug agent.
 */
/*!
 * @name Constants and macros for entire MTB_DEVICETYPID register
 */
/*@{*/
#define MTB_RD_DEVICETYPID(base) (MTB_DEVICETYPID_REG(base))
/*@}*/

/*******************************************************************************
 * MTB_PERIPHID - Peripheral ID Register
 ******************************************************************************/

/*!
 * @brief MTB_PERIPHID - Peripheral ID Register (RO)
 *
 * Reset value: 0x00000000U
 *
 * These registers indicate the peripheral IDs. They are hardwired to specific
 * values used during the auto-discovery process by an external debug agent.
 */
/*!
 * @name Constants and macros for entire MTB_PERIPHID register
 */
/*@{*/
#define MTB_RD_PERIPHID(base, index) (MTB_PERIPHID_REG(base, index))
/*@}*/

/*******************************************************************************
 * MTB_COMPID - Component ID Register
 ******************************************************************************/

/*!
 * @brief MTB_COMPID - Component ID Register (RO)
 *
 * Reset value: 0x00000000U
 *
 * These registers indicate the component IDs. They are hardwired to specific
 * values used during the auto-discovery process by an external debug agent.
 */
/*!
 * @name Constants and macros for entire MTB_COMPID register
 */
/*@{*/
#define MTB_RD_COMPID(base, index) (MTB_COMPID_REG(base, index))
/*@}*/

/*
 * MKL27Z644 MTBDWT
 *
 * MTB data watchpoint and trace
 *
 * Registers defined in this header file:
 * - MTBDWT_CTRL - MTB DWT Control Register
 * - MTBDWT_COMP - MTB_DWT Comparator Register
 * - MTBDWT_MASK - MTB_DWT Comparator Mask Register
 * - MTBDWT_FCT - MTB_DWT Comparator Function Register 0
 * - MTBDWT_TBCTRL - MTB_DWT Trace Buffer Control Register
 * - MTBDWT_DEVICECFG - Device Configuration Register
 * - MTBDWT_DEVICETYPID - Device Type Identifier Register
 * - MTBDWT_PERIPHID - Peripheral ID Register
 * - MTBDWT_COMPID - Component ID Register
 */

#define MTBDWT_INSTANCE_COUNT (1U) /*!< Number of instances of the MTBDWT module. */
#define MTBDWT_IDX (0U) /*!< Instance number for MTBDWT. */

/*******************************************************************************
 * MTBDWT_CTRL - MTB DWT Control Register
 ******************************************************************************/

/*!
 * @brief MTBDWT_CTRL - MTB DWT Control Register (RO)
 *
 * Reset value: 0x2F000000U
 *
 * The MTBDWT_CTRL register provides read-only information on the watchpoint
 * configuration for the MTB_DWT.
 */
/*!
 * @name Constants and macros for entire MTBDWT_CTRL register
 */
/*@{*/
#define MTBDWT_RD_CTRL(base)     (MTBDWT_CTRL_REG(base))
/*@}*/

/*
 * Constants & macros for individual MTBDWT_CTRL bitfields
 */

/*!
 * @name Register MTBDWT_CTRL, field DWTCFGCTRL[27:0] (RO)
 *
 * This field is hardwired to 0xF00_0000, disabling all the remaining DWT
 * functionality. The specific fields and their state are: MTBDWT_CTRL[27] = NOTRCPKT =
 * 1, trace sample and exception trace is not supported MTBDWT_CTRL[26] =
 * NOEXTTRIG = 1, external match signals are not supported MTBDWT_CTRL[25] = NOCYCCNT =
 * 1, cycle counter is not supported MTBDWT_CTRL[24] = NOPRFCNT = 1, profiling
 * counters are not supported MTBDWT_CTRL[22] = CYCEBTENA = 0, no POSTCNT
 * underflow packets generated MTBDWT_CTRL[21] = FOLDEVTENA = 0, no folded instruction
 * counter overflow events MTBDWT_CTRL[20] = LSUEVTENA = 0, no LSU counter overflow
 * events MTBDWT_CTRL[19] = SLEEPEVTENA = 0, no sleep counter overflow events
 * MTBDWT_CTRL[18] = EXCEVTENA = 0, no exception overhead counter events
 * MTBDWT_CTRL[17] = CPIEVTENA = 0, no CPI counter overflow events MTBDWT_CTRL[16] =
 * EXCTRCENA = 0, generation of exception trace disabled MTBDWT_CTRL[12] = PCSAMPLENA =
 * 0, no periodic PC sample packets generated MTBDWT_CTRL[11:10] = SYNCTAP = 0,
 * no synchronization packets MTBDWT_CTRL[9] = CYCTAP = 0, cycle counter is not
 * supported MTBDWT_CTRL[8:5] = POSTINIT = 0, cycle counter is not supported
 * MTBDWT_CTRL[4:1] = POSTPRESET = 0, cycle counter is not supported MTBDWT_CTRL[0] =
 * CYCCNTENA = 0, cycle counter is not supported
 */
/*@{*/
/*! @brief Read current value of the MTBDWT_CTRL_DWTCFGCTRL field. */
#define MTBDWT_RD_CTRL_DWTCFGCTRL(base) ((MTBDWT_CTRL_REG(base) & MTBDWT_CTRL_DWTCFGCTRL_MASK) >> MTBDWT_CTRL_DWTCFGCTRL_SHIFT)
#define MTBDWT_BRD_CTRL_DWTCFGCTRL(base) (MTBDWT_RD_CTRL_DWTCFGCTRL(base))
/*@}*/

/*!
 * @name Register MTBDWT_CTRL, field NUMCMP[31:28] (RO)
 *
 * The MTB_DWT implements two comparators.
 */
/*@{*/
/*! @brief Read current value of the MTBDWT_CTRL_NUMCMP field. */
#define MTBDWT_RD_CTRL_NUMCMP(base) ((MTBDWT_CTRL_REG(base) & MTBDWT_CTRL_NUMCMP_MASK) >> MTBDWT_CTRL_NUMCMP_SHIFT)
#define MTBDWT_BRD_CTRL_NUMCMP(base) (MTBDWT_RD_CTRL_NUMCMP(base))
/*@}*/

/*******************************************************************************
 * MTBDWT_COMP - MTB_DWT Comparator Register
 ******************************************************************************/

/*!
 * @brief MTBDWT_COMP - MTB_DWT Comparator Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * The MTBDWT_COMPn registers provide the reference value for comparator n.
 */
/*!
 * @name Constants and macros for entire MTBDWT_COMP register
 */
/*@{*/
#define MTBDWT_RD_COMP(base, index) (MTBDWT_COMP_REG(base, index))
#define MTBDWT_WR_COMP(base, index, value) (MTBDWT_COMP_REG(base, index) = (value))
#define MTBDWT_RMW_COMP(base, index, mask, value) (MTBDWT_WR_COMP(base, index, (MTBDWT_RD_COMP(base, index) & ~(mask)) | (value)))
#define MTBDWT_SET_COMP(base, index, value) (MTBDWT_WR_COMP(base, index, MTBDWT_RD_COMP(base, index) |  (value)))
#define MTBDWT_CLR_COMP(base, index, value) (MTBDWT_WR_COMP(base, index, MTBDWT_RD_COMP(base, index) & ~(value)))
#define MTBDWT_TOG_COMP(base, index, value) (MTBDWT_WR_COMP(base, index, MTBDWT_RD_COMP(base, index) ^  (value)))
/*@}*/

/*******************************************************************************
 * MTBDWT_MASK - MTB_DWT Comparator Mask Register
 ******************************************************************************/

/*!
 * @brief MTBDWT_MASK - MTB_DWT Comparator Mask Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * The MTBDWT_MASKn registers define the size of the ignore mask applied to the
 * reference address for address range matching by comparator n. Note the format
 * of this mask field is different than the MTB_MASTER[MASK].
 */
/*!
 * @name Constants and macros for entire MTBDWT_MASK register
 */
/*@{*/
#define MTBDWT_RD_MASK(base, index) (MTBDWT_MASK_REG(base, index))
#define MTBDWT_WR_MASK(base, index, value) (MTBDWT_MASK_REG(base, index) = (value))
#define MTBDWT_RMW_MASK(base, index, mask, value) (MTBDWT_WR_MASK(base, index, (MTBDWT_RD_MASK(base, index) & ~(mask)) | (value)))
#define MTBDWT_SET_MASK(base, index, value) (MTBDWT_WR_MASK(base, index, MTBDWT_RD_MASK(base, index) |  (value)))
#define MTBDWT_CLR_MASK(base, index, value) (MTBDWT_WR_MASK(base, index, MTBDWT_RD_MASK(base, index) & ~(value)))
#define MTBDWT_TOG_MASK(base, index, value) (MTBDWT_WR_MASK(base, index, MTBDWT_RD_MASK(base, index) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual MTBDWT_MASK bitfields
 */

/*!
 * @name Register MTBDWT_MASK, field MASK[4:0] (RW)
 *
 * The value of the ignore mask, 0-31 bits, is applied to address range
 * matching. MASK = 0 is used to include all bits of the address in the comparison,
 * except if MASK = 0 and the comparator is configured to watch instruction fetch
 * addresses, address bit [0] is ignored by the hardware since all fetches must be at
 * least halfword aligned. For MASK != 0 and regardless of watch type, address
 * bits [x-1:0] are ignored in the address comparison. Using a mask means the
 * comparator matches on a range of addresses, defined by the unmasked most
 * significant bits of the address, bits [31:x]. The maximum MASK value is 24, producing a
 * 16 Mbyte mask. An attempted write of a MASK value > 24 is limited by the
 * MTBDWT hardware to 24. If MTBDWT_COMP0 is used as a data value comparator, then
 * MTBDWT_MASK0 should be programmed to zero.
 */
/*@{*/
/*! @brief Read current value of the MTBDWT_MASK_MASK field. */
#define MTBDWT_RD_MASK_MASK(base, index) ((MTBDWT_MASK_REG(base, index) & MTBDWT_MASK_MASK_MASK) >> MTBDWT_MASK_MASK_SHIFT)
#define MTBDWT_BRD_MASK_MASK(base, index) (MTBDWT_RD_MASK_MASK(base, index))

/*! @brief Set the MASK field to a new value. */
#define MTBDWT_WR_MASK_MASK(base, index, value) (MTBDWT_RMW_MASK(base, index, MTBDWT_MASK_MASK_MASK, MTBDWT_MASK_MASK(value)))
#define MTBDWT_BWR_MASK_MASK(base, index, value) (MTBDWT_WR_MASK_MASK(base, index, value))
/*@}*/

/*******************************************************************************
 * MTBDWT_FCT - MTB_DWT Comparator Function Register 0
 ******************************************************************************/

/*!
 * @brief MTBDWT_FCT - MTB_DWT Comparator Function Register 0 (RW)
 *
 * Reset value: 0x00000000U
 *
 * The MTBDWT_FCTn registers control the operation of comparator n.
 */
/*!
 * @name Constants and macros for entire MTBDWT_FCT register
 */
/*@{*/
#define MTBDWT_RD_FCT(base, index) (MTBDWT_FCT_REG(base, index))
#define MTBDWT_WR_FCT(base, index, value) (MTBDWT_FCT_REG(base, index) = (value))
#define MTBDWT_RMW_FCT(base, index, mask, value) (MTBDWT_WR_FCT(base, index, (MTBDWT_RD_FCT(base, index) & ~(mask)) | (value)))
#define MTBDWT_SET_FCT(base, index, value) (MTBDWT_WR_FCT(base, index, MTBDWT_RD_FCT(base, index) |  (value)))
#define MTBDWT_CLR_FCT(base, index, value) (MTBDWT_WR_FCT(base, index, MTBDWT_RD_FCT(base, index) & ~(value)))
#define MTBDWT_TOG_FCT(base, index, value) (MTBDWT_WR_FCT(base, index, MTBDWT_RD_FCT(base, index) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual MTBDWT_FCT bitfields
 */

/*!
 * @name Register MTBDWT_FCT, field FUNCTION[3:0] (RW)
 *
 * Selects the action taken on a comparator match. If MTBDWT_COMP0 is used for a
 * data value and MTBDWT_COMP1 for an address value, then MTBDWT_FCT1[FUNCTION]
 * must be set to zero. For this configuration, MTBDWT_MASK1 can be set to a
 * non-zero value, so the combined comparators match on a range of addresses.
 *
 * Values:
 * - 0000 - Disabled.
 * - 0100 - Instruction fetch.
 * - 0101 - Data operand read.
 * - 0110 - Data operand write.
 * - 0111 - Data operand (read + write).
 */
/*@{*/
/*! @brief Read current value of the MTBDWT_FCT_FUNCTION field. */
#define MTBDWT_RD_FCT_FUNCTION(base, index) ((MTBDWT_FCT_REG(base, index) & MTBDWT_FCT_FUNCTION_MASK) >> MTBDWT_FCT_FUNCTION_SHIFT)
#define MTBDWT_BRD_FCT_FUNCTION(base, index) (MTBDWT_RD_FCT_FUNCTION(base, index))

/*! @brief Set the FUNCTION field to a new value. */
#define MTBDWT_WR_FCT_FUNCTION(base, index, value) (MTBDWT_RMW_FCT(base, index, MTBDWT_FCT_FUNCTION_MASK, MTBDWT_FCT_FUNCTION(value)))
#define MTBDWT_BWR_FCT_FUNCTION(base, index, value) (MTBDWT_WR_FCT_FUNCTION(base, index, value))
/*@}*/

/*!
 * @name Register MTBDWT_FCT, field DATAVMATCH[8] (RW)
 *
 * When this field is 1, it enables data value comparison. For this
 * implementation, MTBDWT_COMP0 supports address or data value comparisons; MTBDWT_COMP1 only
 * supports address comparisons.
 *
 * Values:
 * - 0 - Perform address comparison.
 * - 1 - Perform data value comparison.
 */
/*@{*/
/*! @brief Read current value of the MTBDWT_FCT_DATAVMATCH field. */
#define MTBDWT_RD_FCT_DATAVMATCH(base, index) ((MTBDWT_FCT_REG(base, index) & MTBDWT_FCT_DATAVMATCH_MASK) >> MTBDWT_FCT_DATAVMATCH_SHIFT)
#define MTBDWT_BRD_FCT_DATAVMATCH(base, index) (MTBDWT_RD_FCT_DATAVMATCH(base, index))

/*! @brief Set the DATAVMATCH field to a new value. */
#define MTBDWT_WR_FCT_DATAVMATCH(base, index, value) (MTBDWT_RMW_FCT(base, index, MTBDWT_FCT_DATAVMATCH_MASK, MTBDWT_FCT_DATAVMATCH(value)))
#define MTBDWT_BWR_FCT_DATAVMATCH(base, index, value) (MTBDWT_WR_FCT_DATAVMATCH(base, index, value))
/*@}*/

/*!
 * @name Register MTBDWT_FCT, field DATAVSIZE[11:10] (RW)
 *
 * For data value matching, this field defines the size of the required data
 * comparison.
 *
 * Values:
 * - 00 - Byte.
 * - 01 - Halfword.
 * - 10 - Word.
 * - 11 - Reserved. Any attempts to use this value results in UNPREDICTABLE
 *     behavior.
 */
/*@{*/
/*! @brief Read current value of the MTBDWT_FCT_DATAVSIZE field. */
#define MTBDWT_RD_FCT_DATAVSIZE(base, index) ((MTBDWT_FCT_REG(base, index) & MTBDWT_FCT_DATAVSIZE_MASK) >> MTBDWT_FCT_DATAVSIZE_SHIFT)
#define MTBDWT_BRD_FCT_DATAVSIZE(base, index) (MTBDWT_RD_FCT_DATAVSIZE(base, index))

/*! @brief Set the DATAVSIZE field to a new value. */
#define MTBDWT_WR_FCT_DATAVSIZE(base, index, value) (MTBDWT_RMW_FCT(base, index, MTBDWT_FCT_DATAVSIZE_MASK, MTBDWT_FCT_DATAVSIZE(value)))
#define MTBDWT_BWR_FCT_DATAVSIZE(base, index, value) (MTBDWT_WR_FCT_DATAVSIZE(base, index, value))
/*@}*/

/*!
 * @name Register MTBDWT_FCT, field DATAVADDR0[15:12] (RW)
 *
 * Since the MTB_DWT implements two comparators, the DATAVADDR0 field is
 * restricted to values {0,1}. When the DATAVMATCH bit is asserted, this field defines
 * the comparator number to use for linked address comparison. If MTBDWT_COMP0 is
 * used as a data watchpoint and MTBDWT_COMP1 as an address watchpoint,
 * DATAVADDR0 must be set.
 */
/*@{*/
/*! @brief Read current value of the MTBDWT_FCT_DATAVADDR0 field. */
#define MTBDWT_RD_FCT_DATAVADDR0(base, index) ((MTBDWT_FCT_REG(base, index) & MTBDWT_FCT_DATAVADDR0_MASK) >> MTBDWT_FCT_DATAVADDR0_SHIFT)
#define MTBDWT_BRD_FCT_DATAVADDR0(base, index) (MTBDWT_RD_FCT_DATAVADDR0(base, index))

/*! @brief Set the DATAVADDR0 field to a new value. */
#define MTBDWT_WR_FCT_DATAVADDR0(base, index, value) (MTBDWT_RMW_FCT(base, index, MTBDWT_FCT_DATAVADDR0_MASK, MTBDWT_FCT_DATAVADDR0(value)))
#define MTBDWT_BWR_FCT_DATAVADDR0(base, index, value) (MTBDWT_WR_FCT_DATAVADDR0(base, index, value))
/*@}*/

/*!
 * @name Register MTBDWT_FCT, field MATCHED[24] (RO)
 *
 * If this read-only flag is asserted, it indicates the operation defined by the
 * FUNCTION field occurred since the last read of the register. Reading the
 * register clears this bit.
 *
 * Values:
 * - 0 - No match.
 * - 1 - Match occurred.
 */
/*@{*/
/*! @brief Read current value of the MTBDWT_FCT_MATCHED field. */
#define MTBDWT_RD_FCT_MATCHED(base, index) ((MTBDWT_FCT_REG(base, index) & MTBDWT_FCT_MATCHED_MASK) >> MTBDWT_FCT_MATCHED_SHIFT)
#define MTBDWT_BRD_FCT_MATCHED(base, index) (MTBDWT_RD_FCT_MATCHED(base, index))
/*@}*/

/*******************************************************************************
 * MTBDWT_TBCTRL - MTB_DWT Trace Buffer Control Register
 ******************************************************************************/

/*!
 * @brief MTBDWT_TBCTRL - MTB_DWT Trace Buffer Control Register (RW)
 *
 * Reset value: 0x20000000U
 *
 * The MTBDWT_TBCTRL register defines how the watchpoint comparisons control the
 * actual trace buffer operation. Recall the MTB supports starting and stopping
 * the program trace based on the watchpoint comparisons signaled via TSTART and
 * TSTOP. The watchpoint comparison signals are enabled in the MTB's control
 * logic by setting the appropriate enable bits, MTB_MASTER[TSTARTEN, TSTOPEN]. In
 * the event of simultaneous assertion of both TSTART and TSTOP, TSTART takes
 * priority.
 */
/*!
 * @name Constants and macros for entire MTBDWT_TBCTRL register
 */
/*@{*/
#define MTBDWT_RD_TBCTRL(base)   (MTBDWT_TBCTRL_REG(base))
#define MTBDWT_WR_TBCTRL(base, value) (MTBDWT_TBCTRL_REG(base) = (value))
#define MTBDWT_RMW_TBCTRL(base, mask, value) (MTBDWT_WR_TBCTRL(base, (MTBDWT_RD_TBCTRL(base) & ~(mask)) | (value)))
#define MTBDWT_SET_TBCTRL(base, value) (MTBDWT_WR_TBCTRL(base, MTBDWT_RD_TBCTRL(base) |  (value)))
#define MTBDWT_CLR_TBCTRL(base, value) (MTBDWT_WR_TBCTRL(base, MTBDWT_RD_TBCTRL(base) & ~(value)))
#define MTBDWT_TOG_TBCTRL(base, value) (MTBDWT_WR_TBCTRL(base, MTBDWT_RD_TBCTRL(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual MTBDWT_TBCTRL bitfields
 */

/*!
 * @name Register MTBDWT_TBCTRL, field ACOMP0[0] (RW)
 *
 * When the MTBDWT_FCT0[MATCHED] is set, it indicates MTBDWT_COMP0 address
 * compare has triggered and the trace buffer's recording state is changed. The
 * assertion of MTBDWT_FCT0[MATCHED] is caused by the following conditions: Address
 * match in MTBDWT_COMP0 when MTBDWT_FCT0[DATAVMATCH] = 0 Data match in MTBDWT_COMP0
 * when MTBDWT_FCT0[DATAVMATCH, DATAVADDR0] = {1,0} Data match in MTBDWT_COMP0
 * and address match in MTBDWT_COMP1 when MTBDWT_FCT0[DATAVMATCH, DATAVADDR0] =
 * {1,1}
 *
 * Values:
 * - 0 - Trigger TSTOP based on the assertion of MTBDWT_FCT0[MATCHED].
 * - 1 - Trigger TSTART based on the assertion of MTBDWT_FCT0[MATCHED].
 */
/*@{*/
/*! @brief Read current value of the MTBDWT_TBCTRL_ACOMP0 field. */
#define MTBDWT_RD_TBCTRL_ACOMP0(base) ((MTBDWT_TBCTRL_REG(base) & MTBDWT_TBCTRL_ACOMP0_MASK) >> MTBDWT_TBCTRL_ACOMP0_SHIFT)
#define MTBDWT_BRD_TBCTRL_ACOMP0(base) (MTBDWT_RD_TBCTRL_ACOMP0(base))

/*! @brief Set the ACOMP0 field to a new value. */
#define MTBDWT_WR_TBCTRL_ACOMP0(base, value) (MTBDWT_RMW_TBCTRL(base, MTBDWT_TBCTRL_ACOMP0_MASK, MTBDWT_TBCTRL_ACOMP0(value)))
#define MTBDWT_BWR_TBCTRL_ACOMP0(base, value) (MTBDWT_WR_TBCTRL_ACOMP0(base, value))
/*@}*/

/*!
 * @name Register MTBDWT_TBCTRL, field ACOMP1[1] (RW)
 *
 * When the MTBDWT_FCT1[MATCHED] is set, it indicates MTBDWT_COMP1 address
 * compare has triggered and the trace buffer's recording state is changed.
 *
 * Values:
 * - 0 - Trigger TSTOP based on the assertion of MTBDWT_FCT1[MATCHED].
 * - 1 - Trigger TSTART based on the assertion of MTBDWT_FCT1[MATCHED].
 */
/*@{*/
/*! @brief Read current value of the MTBDWT_TBCTRL_ACOMP1 field. */
#define MTBDWT_RD_TBCTRL_ACOMP1(base) ((MTBDWT_TBCTRL_REG(base) & MTBDWT_TBCTRL_ACOMP1_MASK) >> MTBDWT_TBCTRL_ACOMP1_SHIFT)
#define MTBDWT_BRD_TBCTRL_ACOMP1(base) (MTBDWT_RD_TBCTRL_ACOMP1(base))

/*! @brief Set the ACOMP1 field to a new value. */
#define MTBDWT_WR_TBCTRL_ACOMP1(base, value) (MTBDWT_RMW_TBCTRL(base, MTBDWT_TBCTRL_ACOMP1_MASK, MTBDWT_TBCTRL_ACOMP1(value)))
#define MTBDWT_BWR_TBCTRL_ACOMP1(base, value) (MTBDWT_WR_TBCTRL_ACOMP1(base, value))
/*@}*/

/*!
 * @name Register MTBDWT_TBCTRL, field NUMCOMP[31:28] (RO)
 *
 * This read-only field specifies the number of comparators in the MTB_DWT. This
 * implementation includes two registers.
 */
/*@{*/
/*! @brief Read current value of the MTBDWT_TBCTRL_NUMCOMP field. */
#define MTBDWT_RD_TBCTRL_NUMCOMP(base) ((MTBDWT_TBCTRL_REG(base) & MTBDWT_TBCTRL_NUMCOMP_MASK) >> MTBDWT_TBCTRL_NUMCOMP_SHIFT)
#define MTBDWT_BRD_TBCTRL_NUMCOMP(base) (MTBDWT_RD_TBCTRL_NUMCOMP(base))
/*@}*/

/*******************************************************************************
 * MTBDWT_DEVICECFG - Device Configuration Register
 ******************************************************************************/

/*!
 * @brief MTBDWT_DEVICECFG - Device Configuration Register (RO)
 *
 * Reset value: 0x00000000U
 *
 * This register indicates the device configuration. It is hardwired to specific
 * values used during the auto-discovery process by an external debug agent.
 */
/*!
 * @name Constants and macros for entire MTBDWT_DEVICECFG register
 */
/*@{*/
#define MTBDWT_RD_DEVICECFG(base) (MTBDWT_DEVICECFG_REG(base))
/*@}*/

/*******************************************************************************
 * MTBDWT_DEVICETYPID - Device Type Identifier Register
 ******************************************************************************/

/*!
 * @brief MTBDWT_DEVICETYPID - Device Type Identifier Register (RO)
 *
 * Reset value: 0x00000004U
 *
 * This register indicates the device type ID. It is hardwired to specific
 * values used during the auto-discovery process by an external debug agent.
 */
/*!
 * @name Constants and macros for entire MTBDWT_DEVICETYPID register
 */
/*@{*/
#define MTBDWT_RD_DEVICETYPID(base) (MTBDWT_DEVICETYPID_REG(base))
/*@}*/

/*******************************************************************************
 * MTBDWT_PERIPHID - Peripheral ID Register
 ******************************************************************************/

/*!
 * @brief MTBDWT_PERIPHID - Peripheral ID Register (RO)
 *
 * Reset value: 0x00000000U
 *
 * These registers indicate the peripheral IDs. They are hardwired to specific
 * values used during the auto-discovery process by an external debug agent.
 */
/*!
 * @name Constants and macros for entire MTBDWT_PERIPHID register
 */
/*@{*/
#define MTBDWT_RD_PERIPHID(base, index) (MTBDWT_PERIPHID_REG(base, index))
/*@}*/

/*******************************************************************************
 * MTBDWT_COMPID - Component ID Register
 ******************************************************************************/

/*!
 * @brief MTBDWT_COMPID - Component ID Register (RO)
 *
 * Reset value: 0x00000000U
 *
 * These registers indicate the component IDs. They are hardwired to specific
 * values used during the auto-discovery process by an external debug agent.
 */
/*!
 * @name Constants and macros for entire MTBDWT_COMPID register
 */
/*@{*/
#define MTBDWT_RD_COMPID(base, index) (MTBDWT_COMPID_REG(base, index))
/*@}*/

/*
 * MKL27Z644 NV
 *
 * Flash configuration field
 *
 * Registers defined in this header file:
 * - NV_BACKKEY3 - Backdoor Comparison Key 3.
 * - NV_BACKKEY2 - Backdoor Comparison Key 2.
 * - NV_BACKKEY1 - Backdoor Comparison Key 1.
 * - NV_BACKKEY0 - Backdoor Comparison Key 0.
 * - NV_BACKKEY7 - Backdoor Comparison Key 7.
 * - NV_BACKKEY6 - Backdoor Comparison Key 6.
 * - NV_BACKKEY5 - Backdoor Comparison Key 5.
 * - NV_BACKKEY4 - Backdoor Comparison Key 4.
 * - NV_FPROT3 - Non-volatile P-Flash Protection 1 - Low Register
 * - NV_FPROT2 - Non-volatile P-Flash Protection 1 - High Register
 * - NV_FPROT1 - Non-volatile P-Flash Protection 0 - Low Register
 * - NV_FPROT0 - Non-volatile P-Flash Protection 0 - High Register
 * - NV_FSEC - Non-volatile Flash Security Register
 * - NV_FOPT - Non-volatile Flash Option Register
 */

#define NV_INSTANCE_COUNT (1U) /*!< Number of instances of the NV module. */
#define FTFA_FlashConfig_IDX (0U) /*!< Instance number for FTFA_FlashConfig. */

/*******************************************************************************
 * NV_BACKKEY3 - Backdoor Comparison Key 3.
 ******************************************************************************/

/*!
 * @brief NV_BACKKEY3 - Backdoor Comparison Key 3. (RO)
 *
 * Reset value: 0xFFU
 */
/*!
 * @name Constants and macros for entire NV_BACKKEY3 register
 */
/*@{*/
#define NV_RD_BACKKEY3(base)     (NV_BACKKEY3_REG(base))
/*@}*/

/*******************************************************************************
 * NV_BACKKEY2 - Backdoor Comparison Key 2.
 ******************************************************************************/

/*!
 * @brief NV_BACKKEY2 - Backdoor Comparison Key 2. (RO)
 *
 * Reset value: 0xFFU
 */
/*!
 * @name Constants and macros for entire NV_BACKKEY2 register
 */
/*@{*/
#define NV_RD_BACKKEY2(base)     (NV_BACKKEY2_REG(base))
/*@}*/

/*******************************************************************************
 * NV_BACKKEY1 - Backdoor Comparison Key 1.
 ******************************************************************************/

/*!
 * @brief NV_BACKKEY1 - Backdoor Comparison Key 1. (RO)
 *
 * Reset value: 0xFFU
 */
/*!
 * @name Constants and macros for entire NV_BACKKEY1 register
 */
/*@{*/
#define NV_RD_BACKKEY1(base)     (NV_BACKKEY1_REG(base))
/*@}*/

/*******************************************************************************
 * NV_BACKKEY0 - Backdoor Comparison Key 0.
 ******************************************************************************/

/*!
 * @brief NV_BACKKEY0 - Backdoor Comparison Key 0. (RO)
 *
 * Reset value: 0xFFU
 */
/*!
 * @name Constants and macros for entire NV_BACKKEY0 register
 */
/*@{*/
#define NV_RD_BACKKEY0(base)     (NV_BACKKEY0_REG(base))
/*@}*/

/*******************************************************************************
 * NV_BACKKEY7 - Backdoor Comparison Key 7.
 ******************************************************************************/

/*!
 * @brief NV_BACKKEY7 - Backdoor Comparison Key 7. (RO)
 *
 * Reset value: 0xFFU
 */
/*!
 * @name Constants and macros for entire NV_BACKKEY7 register
 */
/*@{*/
#define NV_RD_BACKKEY7(base)     (NV_BACKKEY7_REG(base))
/*@}*/

/*******************************************************************************
 * NV_BACKKEY6 - Backdoor Comparison Key 6.
 ******************************************************************************/

/*!
 * @brief NV_BACKKEY6 - Backdoor Comparison Key 6. (RO)
 *
 * Reset value: 0xFFU
 */
/*!
 * @name Constants and macros for entire NV_BACKKEY6 register
 */
/*@{*/
#define NV_RD_BACKKEY6(base)     (NV_BACKKEY6_REG(base))
/*@}*/

/*******************************************************************************
 * NV_BACKKEY5 - Backdoor Comparison Key 5.
 ******************************************************************************/

/*!
 * @brief NV_BACKKEY5 - Backdoor Comparison Key 5. (RO)
 *
 * Reset value: 0xFFU
 */
/*!
 * @name Constants and macros for entire NV_BACKKEY5 register
 */
/*@{*/
#define NV_RD_BACKKEY5(base)     (NV_BACKKEY5_REG(base))
/*@}*/

/*******************************************************************************
 * NV_BACKKEY4 - Backdoor Comparison Key 4.
 ******************************************************************************/

/*!
 * @brief NV_BACKKEY4 - Backdoor Comparison Key 4. (RO)
 *
 * Reset value: 0xFFU
 */
/*!
 * @name Constants and macros for entire NV_BACKKEY4 register
 */
/*@{*/
#define NV_RD_BACKKEY4(base)     (NV_BACKKEY4_REG(base))
/*@}*/

/*******************************************************************************
 * NV_FPROT3 - Non-volatile P-Flash Protection 1 - Low Register
 ******************************************************************************/

/*!
 * @brief NV_FPROT3 - Non-volatile P-Flash Protection 1 - Low Register (RO)
 *
 * Reset value: 0xFFU
 */
/*!
 * @name Constants and macros for entire NV_FPROT3 register
 */
/*@{*/
#define NV_RD_FPROT3(base)       (NV_FPROT3_REG(base))
/*@}*/

/*******************************************************************************
 * NV_FPROT2 - Non-volatile P-Flash Protection 1 - High Register
 ******************************************************************************/

/*!
 * @brief NV_FPROT2 - Non-volatile P-Flash Protection 1 - High Register (RO)
 *
 * Reset value: 0xFFU
 */
/*!
 * @name Constants and macros for entire NV_FPROT2 register
 */
/*@{*/
#define NV_RD_FPROT2(base)       (NV_FPROT2_REG(base))
/*@}*/

/*******************************************************************************
 * NV_FPROT1 - Non-volatile P-Flash Protection 0 - Low Register
 ******************************************************************************/

/*!
 * @brief NV_FPROT1 - Non-volatile P-Flash Protection 0 - Low Register (RO)
 *
 * Reset value: 0xFFU
 */
/*!
 * @name Constants and macros for entire NV_FPROT1 register
 */
/*@{*/
#define NV_RD_FPROT1(base)       (NV_FPROT1_REG(base))
/*@}*/

/*******************************************************************************
 * NV_FPROT0 - Non-volatile P-Flash Protection 0 - High Register
 ******************************************************************************/

/*!
 * @brief NV_FPROT0 - Non-volatile P-Flash Protection 0 - High Register (RO)
 *
 * Reset value: 0xFFU
 */
/*!
 * @name Constants and macros for entire NV_FPROT0 register
 */
/*@{*/
#define NV_RD_FPROT0(base)       (NV_FPROT0_REG(base))
/*@}*/

/*******************************************************************************
 * NV_FSEC - Non-volatile Flash Security Register
 ******************************************************************************/

/*!
 * @brief NV_FSEC - Non-volatile Flash Security Register (RO)
 *
 * Reset value: 0xFFU
 *
 * Allows the user to customize the operation of the MCU at boot time
 */
/*!
 * @name Constants and macros for entire NV_FSEC register
 */
/*@{*/
#define NV_RD_FSEC(base)         (NV_FSEC_REG(base))
/*@}*/

/*
 * Constants & macros for individual NV_FSEC bitfields
 */

/*!
 * @name Register NV_FSEC, field SEC[1:0] (RO)
 *
 * Values:
 * - 10 - MCU security status is unsecure
 * - 11 - MCU security status is secure
 */
/*@{*/
/*! @brief Read current value of the NV_FSEC_SEC field. */
#define NV_RD_FSEC_SEC(base) ((NV_FSEC_REG(base) & NV_FSEC_SEC_MASK) >> NV_FSEC_SEC_SHIFT)
#define NV_BRD_FSEC_SEC(base) (NV_RD_FSEC_SEC(base))
/*@}*/

/*!
 * @name Register NV_FSEC, field FSLACC[3:2] (RO)
 *
 * Values:
 * - 10 - Freescale factory access denied
 * - 11 - Freescale factory access granted
 */
/*@{*/
/*! @brief Read current value of the NV_FSEC_FSLACC field. */
#define NV_RD_FSEC_FSLACC(base) ((NV_FSEC_REG(base) & NV_FSEC_FSLACC_MASK) >> NV_FSEC_FSLACC_SHIFT)
#define NV_BRD_FSEC_FSLACC(base) (NV_RD_FSEC_FSLACC(base))
/*@}*/

/*!
 * @name Register NV_FSEC, field MEEN[5:4] (RO)
 *
 * Values:
 * - 10 - Mass erase is disabled
 * - 11 - Mass erase is enabled
 */
/*@{*/
/*! @brief Read current value of the NV_FSEC_MEEN field. */
#define NV_RD_FSEC_MEEN(base) ((NV_FSEC_REG(base) & NV_FSEC_MEEN_MASK) >> NV_FSEC_MEEN_SHIFT)
#define NV_BRD_FSEC_MEEN(base) (NV_RD_FSEC_MEEN(base))
/*@}*/

/*!
 * @name Register NV_FSEC, field KEYEN[7:6] (RO)
 *
 * Values:
 * - 10 - Backdoor key access enabled
 * - 11 - Backdoor key access disabled
 */
/*@{*/
/*! @brief Read current value of the NV_FSEC_KEYEN field. */
#define NV_RD_FSEC_KEYEN(base) ((NV_FSEC_REG(base) & NV_FSEC_KEYEN_MASK) >> NV_FSEC_KEYEN_SHIFT)
#define NV_BRD_FSEC_KEYEN(base) (NV_RD_FSEC_KEYEN(base))
/*@}*/

/*******************************************************************************
 * NV_FOPT - Non-volatile Flash Option Register
 ******************************************************************************/

/*!
 * @brief NV_FOPT - Non-volatile Flash Option Register (RO)
 *
 * Reset value: 0x3DU
 */
/*!
 * @name Constants and macros for entire NV_FOPT register
 */
/*@{*/
#define NV_RD_FOPT(base)         (NV_FOPT_REG(base))
/*@}*/

/*
 * Constants & macros for individual NV_FOPT bitfields
 */

/*!
 * @name Register NV_FOPT, field LPBOOT0[0] (RO)
 *
 * Values:
 * - 00 - Core and system clock divider (OUTDIV1) is 0x7 (divide by 8) when
 *     LPBOOT1=0 or 0x1 (divide by 2) when LPBOOT1=1.
 * - 01 - Core and system clock divider (OUTDIV1) is 0x3 (divide by 4) when
 *     LPBOOT1=0 or 0x0 (divide by 1) when LPBOOT1=1.
 */
/*@{*/
/*! @brief Read current value of the NV_FOPT_LPBOOT0 field. */
#define NV_RD_FOPT_LPBOOT0(base) ((NV_FOPT_REG(base) & NV_FOPT_LPBOOT0_MASK) >> NV_FOPT_LPBOOT0_SHIFT)
#define NV_BRD_FOPT_LPBOOT0(base) (NV_RD_FOPT_LPBOOT0(base))
/*@}*/

/*!
 * @name Register NV_FOPT, field BOOTPIN_OPT[1] (RO)
 *
 * Values:
 * - 00 - Force Boot from ROM if BOOTCFG0 asserted, where BOOTCFG0 is the boot
 *     config function which is muxed with NMI pin
 * - 01 - Boot source configured by FOPT (BOOTSRC_SEL) bits
 */
/*@{*/
/*! @brief Read current value of the NV_FOPT_BOOTPIN_OPT field. */
#define NV_RD_FOPT_BOOTPIN_OPT(base) ((NV_FOPT_REG(base) & NV_FOPT_BOOTPIN_OPT_MASK) >> NV_FOPT_BOOTPIN_OPT_SHIFT)
#define NV_BRD_FOPT_BOOTPIN_OPT(base) (NV_RD_FOPT_BOOTPIN_OPT(base))
/*@}*/

/*!
 * @name Register NV_FOPT, field NMI_DIS[2] (RO)
 *
 * Values:
 * - 00 - NMI interrupts are always blocked
 * - 01 - NMI_b pin/interrupts reset default to enabled
 */
/*@{*/
/*! @brief Read current value of the NV_FOPT_NMI_DIS field. */
#define NV_RD_FOPT_NMI_DIS(base) ((NV_FOPT_REG(base) & NV_FOPT_NMI_DIS_MASK) >> NV_FOPT_NMI_DIS_SHIFT)
#define NV_BRD_FOPT_NMI_DIS(base) (NV_RD_FOPT_NMI_DIS(base))
/*@}*/

/*!
 * @name Register NV_FOPT, field RESET_PIN_CFG[3] (RO)
 *
 * Values:
 * - 00 - RESET pin is disabled following a POR and cannot be enabled as reset
 *     function
 * - 01 - RESET_b pin is dedicated
 */
/*@{*/
/*! @brief Read current value of the NV_FOPT_RESET_PIN_CFG field. */
#define NV_RD_FOPT_RESET_PIN_CFG(base) ((NV_FOPT_REG(base) & NV_FOPT_RESET_PIN_CFG_MASK) >> NV_FOPT_RESET_PIN_CFG_SHIFT)
#define NV_BRD_FOPT_RESET_PIN_CFG(base) (NV_RD_FOPT_RESET_PIN_CFG(base))
/*@}*/

/*!
 * @name Register NV_FOPT, field LPBOOT1[4] (RO)
 *
 * Values:
 * - 00 - Core and system clock divider (OUTDIV1) is 0x7 (divide by 8) when
 *     LPBOOT0=0 or 0x3 (divide by 4) when LPBOOT0=1.
 * - 01 - Core and system clock divider (OUTDIV1) is 0x1 (divide by 2) when
 *     LPBOOT0=0 or 0x0 (divide by 1) when LPBOOT0=1.
 */
/*@{*/
/*! @brief Read current value of the NV_FOPT_LPBOOT1 field. */
#define NV_RD_FOPT_LPBOOT1(base) ((NV_FOPT_REG(base) & NV_FOPT_LPBOOT1_MASK) >> NV_FOPT_LPBOOT1_SHIFT)
#define NV_BRD_FOPT_LPBOOT1(base) (NV_RD_FOPT_LPBOOT1(base))
/*@}*/

/*!
 * @name Register NV_FOPT, field FAST_INIT[5] (RO)
 *
 * Values:
 * - 00 - Slower initialization
 * - 01 - Fast Initialization
 */
/*@{*/
/*! @brief Read current value of the NV_FOPT_FAST_INIT field. */
#define NV_RD_FOPT_FAST_INIT(base) ((NV_FOPT_REG(base) & NV_FOPT_FAST_INIT_MASK) >> NV_FOPT_FAST_INIT_SHIFT)
#define NV_BRD_FOPT_FAST_INIT(base) (NV_RD_FOPT_FAST_INIT(base))
/*@}*/

/*!
 * @name Register NV_FOPT, field BOOTSRC_SEL[7:6] (RO)
 *
 * Values:
 * - 00 - Boot from Flash
 * - 10 - Boot from ROM
 * - 11 - Boot from ROM
 */
/*@{*/
/*! @brief Read current value of the NV_FOPT_BOOTSRC_SEL field. */
#define NV_RD_FOPT_BOOTSRC_SEL(base) ((NV_FOPT_REG(base) & NV_FOPT_BOOTSRC_SEL_MASK) >> NV_FOPT_BOOTSRC_SEL_SHIFT)
#define NV_BRD_FOPT_BOOTSRC_SEL(base) (NV_RD_FOPT_BOOTSRC_SEL(base))
/*@}*/

/*
 * MKL27Z644 OSC
 *
 * Oscillator
 *
 * Registers defined in this header file:
 * - OSC_CR - OSC Control Register
 */

#define OSC_INSTANCE_COUNT (1U) /*!< Number of instances of the OSC module. */
#define OSC0_IDX (0U) /*!< Instance number for OSC0. */

/*******************************************************************************
 * OSC_CR - OSC Control Register
 ******************************************************************************/

/*!
 * @brief OSC_CR - OSC Control Register (RW)
 *
 * Reset value: 0x00U
 *
 * After OSC is enabled and starts generating the clocks, the configurations
 * such as low power and frequency range, must not be changed.
 */
/*!
 * @name Constants and macros for entire OSC_CR register
 */
/*@{*/
#define OSC_RD_CR(base)          (OSC_CR_REG(base))
#define OSC_WR_CR(base, value)   (OSC_CR_REG(base) = (value))
#define OSC_RMW_CR(base, mask, value) (OSC_WR_CR(base, (OSC_RD_CR(base) & ~(mask)) | (value)))
#define OSC_SET_CR(base, value)  (BME_OR8(&OSC_CR_REG(base), (uint8_t)(value)))
#define OSC_CLR_CR(base, value)  (BME_AND8(&OSC_CR_REG(base), (uint8_t)(~(value))))
#define OSC_TOG_CR(base, value)  (BME_XOR8(&OSC_CR_REG(base), (uint8_t)(value)))
/*@}*/

/*
 * Constants & macros for individual OSC_CR bitfields
 */

/*!
 * @name Register OSC_CR, field SC16P[0] (RW)
 *
 * Configures the oscillator load.
 *
 * Values:
 * - 0 - Disable the selection.
 * - 1 - Add 16 pF capacitor to the oscillator load.
 */
/*@{*/
/*! @brief Read current value of the OSC_CR_SC16P field. */
#define OSC_RD_CR_SC16P(base) ((OSC_CR_REG(base) & OSC_CR_SC16P_MASK) >> OSC_CR_SC16P_SHIFT)
#define OSC_BRD_CR_SC16P(base) (BME_UBFX8(&OSC_CR_REG(base), OSC_CR_SC16P_SHIFT, OSC_CR_SC16P_WIDTH))

/*! @brief Set the SC16P field to a new value. */
#define OSC_WR_CR_SC16P(base, value) (OSC_RMW_CR(base, OSC_CR_SC16P_MASK, OSC_CR_SC16P(value)))
#define OSC_BWR_CR_SC16P(base, value) (BME_BFI8(&OSC_CR_REG(base), ((uint8_t)(value) << OSC_CR_SC16P_SHIFT), OSC_CR_SC16P_SHIFT, OSC_CR_SC16P_WIDTH))
/*@}*/

/*!
 * @name Register OSC_CR, field SC8P[1] (RW)
 *
 * Configures the oscillator load.
 *
 * Values:
 * - 0 - Disable the selection.
 * - 1 - Add 8 pF capacitor to the oscillator load.
 */
/*@{*/
/*! @brief Read current value of the OSC_CR_SC8P field. */
#define OSC_RD_CR_SC8P(base) ((OSC_CR_REG(base) & OSC_CR_SC8P_MASK) >> OSC_CR_SC8P_SHIFT)
#define OSC_BRD_CR_SC8P(base) (BME_UBFX8(&OSC_CR_REG(base), OSC_CR_SC8P_SHIFT, OSC_CR_SC8P_WIDTH))

/*! @brief Set the SC8P field to a new value. */
#define OSC_WR_CR_SC8P(base, value) (OSC_RMW_CR(base, OSC_CR_SC8P_MASK, OSC_CR_SC8P(value)))
#define OSC_BWR_CR_SC8P(base, value) (BME_BFI8(&OSC_CR_REG(base), ((uint8_t)(value) << OSC_CR_SC8P_SHIFT), OSC_CR_SC8P_SHIFT, OSC_CR_SC8P_WIDTH))
/*@}*/

/*!
 * @name Register OSC_CR, field SC4P[2] (RW)
 *
 * Configures the oscillator load.
 *
 * Values:
 * - 0 - Disable the selection.
 * - 1 - Add 4 pF capacitor to the oscillator load.
 */
/*@{*/
/*! @brief Read current value of the OSC_CR_SC4P field. */
#define OSC_RD_CR_SC4P(base) ((OSC_CR_REG(base) & OSC_CR_SC4P_MASK) >> OSC_CR_SC4P_SHIFT)
#define OSC_BRD_CR_SC4P(base) (BME_UBFX8(&OSC_CR_REG(base), OSC_CR_SC4P_SHIFT, OSC_CR_SC4P_WIDTH))

/*! @brief Set the SC4P field to a new value. */
#define OSC_WR_CR_SC4P(base, value) (OSC_RMW_CR(base, OSC_CR_SC4P_MASK, OSC_CR_SC4P(value)))
#define OSC_BWR_CR_SC4P(base, value) (BME_BFI8(&OSC_CR_REG(base), ((uint8_t)(value) << OSC_CR_SC4P_SHIFT), OSC_CR_SC4P_SHIFT, OSC_CR_SC4P_WIDTH))
/*@}*/

/*!
 * @name Register OSC_CR, field SC2P[3] (RW)
 *
 * Configures the oscillator load.
 *
 * Values:
 * - 0 - Disable the selection.
 * - 1 - Add 2 pF capacitor to the oscillator load.
 */
/*@{*/
/*! @brief Read current value of the OSC_CR_SC2P field. */
#define OSC_RD_CR_SC2P(base) ((OSC_CR_REG(base) & OSC_CR_SC2P_MASK) >> OSC_CR_SC2P_SHIFT)
#define OSC_BRD_CR_SC2P(base) (BME_UBFX8(&OSC_CR_REG(base), OSC_CR_SC2P_SHIFT, OSC_CR_SC2P_WIDTH))

/*! @brief Set the SC2P field to a new value. */
#define OSC_WR_CR_SC2P(base, value) (OSC_RMW_CR(base, OSC_CR_SC2P_MASK, OSC_CR_SC2P(value)))
#define OSC_BWR_CR_SC2P(base, value) (BME_BFI8(&OSC_CR_REG(base), ((uint8_t)(value) << OSC_CR_SC2P_SHIFT), OSC_CR_SC2P_SHIFT, OSC_CR_SC2P_WIDTH))
/*@}*/

/*!
 * @name Register OSC_CR, field EREFSTEN[5] (RW)
 *
 * Controls whether or not the external reference clock (OSCERCLK) remains
 * enabled when MCU enters Stop mode.
 *
 * Values:
 * - 0 - External reference clock is disabled in Stop mode.
 * - 1 - External reference clock stays enabled in Stop mode if ERCLKEN is set
 *     before entering Stop mode.
 */
/*@{*/
/*! @brief Read current value of the OSC_CR_EREFSTEN field. */
#define OSC_RD_CR_EREFSTEN(base) ((OSC_CR_REG(base) & OSC_CR_EREFSTEN_MASK) >> OSC_CR_EREFSTEN_SHIFT)
#define OSC_BRD_CR_EREFSTEN(base) (BME_UBFX8(&OSC_CR_REG(base), OSC_CR_EREFSTEN_SHIFT, OSC_CR_EREFSTEN_WIDTH))

/*! @brief Set the EREFSTEN field to a new value. */
#define OSC_WR_CR_EREFSTEN(base, value) (OSC_RMW_CR(base, OSC_CR_EREFSTEN_MASK, OSC_CR_EREFSTEN(value)))
#define OSC_BWR_CR_EREFSTEN(base, value) (BME_BFI8(&OSC_CR_REG(base), ((uint8_t)(value) << OSC_CR_EREFSTEN_SHIFT), OSC_CR_EREFSTEN_SHIFT, OSC_CR_EREFSTEN_WIDTH))
/*@}*/

/*!
 * @name Register OSC_CR, field ERCLKEN[7] (RW)
 *
 * Enables external reference clock (OSCERCLK).
 *
 * Values:
 * - 0 - External reference clock is inactive.
 * - 1 - External reference clock is enabled.
 */
/*@{*/
/*! @brief Read current value of the OSC_CR_ERCLKEN field. */
#define OSC_RD_CR_ERCLKEN(base) ((OSC_CR_REG(base) & OSC_CR_ERCLKEN_MASK) >> OSC_CR_ERCLKEN_SHIFT)
#define OSC_BRD_CR_ERCLKEN(base) (BME_UBFX8(&OSC_CR_REG(base), OSC_CR_ERCLKEN_SHIFT, OSC_CR_ERCLKEN_WIDTH))

/*! @brief Set the ERCLKEN field to a new value. */
#define OSC_WR_CR_ERCLKEN(base, value) (OSC_RMW_CR(base, OSC_CR_ERCLKEN_MASK, OSC_CR_ERCLKEN(value)))
#define OSC_BWR_CR_ERCLKEN(base, value) (BME_BFI8(&OSC_CR_REG(base), ((uint8_t)(value) << OSC_CR_ERCLKEN_SHIFT), OSC_CR_ERCLKEN_SHIFT, OSC_CR_ERCLKEN_WIDTH))
/*@}*/

/*
 * MKL27Z644 PIT
 *
 * Periodic Interrupt Timer
 *
 * Registers defined in this header file:
 * - PIT_MCR - PIT Module Control Register
 * - PIT_LTMR64H - PIT Upper Lifetime Timer Register
 * - PIT_LTMR64L - PIT Lower Lifetime Timer Register
 * - PIT_LDVAL - Timer Load Value Register
 * - PIT_CVAL - Current Timer Value Register
 * - PIT_TCTRL - Timer Control Register
 * - PIT_TFLG - Timer Flag Register
 */

#define PIT_INSTANCE_COUNT (1U) /*!< Number of instances of the PIT module. */
#define PIT_IDX (0U) /*!< Instance number for PIT. */

/*******************************************************************************
 * PIT_MCR - PIT Module Control Register
 ******************************************************************************/

/*!
 * @brief PIT_MCR - PIT Module Control Register (RW)
 *
 * Reset value: 0x00000002U
 *
 * This register enables or disables the PIT timer clocks and controls the
 * timers when the PIT enters the Debug mode. Access: User read/write
 */
/*!
 * @name Constants and macros for entire PIT_MCR register
 */
/*@{*/
#define PIT_RD_MCR(base)         (PIT_MCR_REG(base))
#define PIT_WR_MCR(base, value)  (PIT_MCR_REG(base) = (value))
#define PIT_RMW_MCR(base, mask, value) (PIT_WR_MCR(base, (PIT_RD_MCR(base) & ~(mask)) | (value)))
#define PIT_SET_MCR(base, value) (BME_OR32(&PIT_MCR_REG(base), (uint32_t)(value)))
#define PIT_CLR_MCR(base, value) (BME_AND32(&PIT_MCR_REG(base), (uint32_t)(~(value))))
#define PIT_TOG_MCR(base, value) (BME_XOR32(&PIT_MCR_REG(base), (uint32_t)(value)))
/*@}*/

/*
 * Constants & macros for individual PIT_MCR bitfields
 */

/*!
 * @name Register PIT_MCR, field FRZ[0] (RW)
 *
 * Allows the timers to be stopped when the device enters the Debug mode.
 *
 * Values:
 * - 0 - Timers continue to run in Debug mode.
 * - 1 - Timers are stopped in Debug mode.
 */
/*@{*/
/*! @brief Read current value of the PIT_MCR_FRZ field. */
#define PIT_RD_MCR_FRZ(base) ((PIT_MCR_REG(base) & PIT_MCR_FRZ_MASK) >> PIT_MCR_FRZ_SHIFT)
#define PIT_BRD_MCR_FRZ(base) (BME_UBFX32(&PIT_MCR_REG(base), PIT_MCR_FRZ_SHIFT, PIT_MCR_FRZ_WIDTH))

/*! @brief Set the FRZ field to a new value. */
#define PIT_WR_MCR_FRZ(base, value) (PIT_RMW_MCR(base, PIT_MCR_FRZ_MASK, PIT_MCR_FRZ(value)))
#define PIT_BWR_MCR_FRZ(base, value) (BME_BFI32(&PIT_MCR_REG(base), ((uint32_t)(value) << PIT_MCR_FRZ_SHIFT), PIT_MCR_FRZ_SHIFT, PIT_MCR_FRZ_WIDTH))
/*@}*/

/*!
 * @name Register PIT_MCR, field MDIS[1] (RW)
 *
 * Disables the standard timers. This field must be enabled before any other
 * setup is done.
 *
 * Values:
 * - 0 - Clock for standard PIT timers is enabled.
 * - 1 - Clock for standard PIT timers is disabled.
 */
/*@{*/
/*! @brief Read current value of the PIT_MCR_MDIS field. */
#define PIT_RD_MCR_MDIS(base) ((PIT_MCR_REG(base) & PIT_MCR_MDIS_MASK) >> PIT_MCR_MDIS_SHIFT)
#define PIT_BRD_MCR_MDIS(base) (BME_UBFX32(&PIT_MCR_REG(base), PIT_MCR_MDIS_SHIFT, PIT_MCR_MDIS_WIDTH))

/*! @brief Set the MDIS field to a new value. */
#define PIT_WR_MCR_MDIS(base, value) (PIT_RMW_MCR(base, PIT_MCR_MDIS_MASK, PIT_MCR_MDIS(value)))
#define PIT_BWR_MCR_MDIS(base, value) (BME_BFI32(&PIT_MCR_REG(base), ((uint32_t)(value) << PIT_MCR_MDIS_SHIFT), PIT_MCR_MDIS_SHIFT, PIT_MCR_MDIS_WIDTH))
/*@}*/

/*******************************************************************************
 * PIT_LTMR64H - PIT Upper Lifetime Timer Register
 ******************************************************************************/

/*!
 * @brief PIT_LTMR64H - PIT Upper Lifetime Timer Register (RO)
 *
 * Reset value: 0x00000000U
 *
 * This register is intended for applications that chain timer 0 and timer 1 to
 * build a 64-bit lifetimer. Access: User read only
 */
/*!
 * @name Constants and macros for entire PIT_LTMR64H register
 */
/*@{*/
#define PIT_RD_LTMR64H(base)     (PIT_LTMR64H_REG(base))
/*@}*/

/*******************************************************************************
 * PIT_LTMR64L - PIT Lower Lifetime Timer Register
 ******************************************************************************/

/*!
 * @brief PIT_LTMR64L - PIT Lower Lifetime Timer Register (RO)
 *
 * Reset value: 0x00000000U
 *
 * This register is intended for applications that chain timer 0 and timer 1 to
 * build a 64-bit lifetimer. To use LTMR64H and LTMR64L, timer 0 and timer 1 need
 * to be chained. To obtain the correct value, first read LTMR64H and then
 * LTMR64L. LTMR64H will have the value of CVAL1 at the time of the first access,
 * LTMR64L will have the value of CVAL0 at the time of the first access, therefore
 * the application does not need to worry about carry-over effects of the running
 * counter. Access: User read only
 */
/*!
 * @name Constants and macros for entire PIT_LTMR64L register
 */
/*@{*/
#define PIT_RD_LTMR64L(base)     (PIT_LTMR64L_REG(base))
/*@}*/

/*******************************************************************************
 * PIT_LDVAL - Timer Load Value Register
 ******************************************************************************/

/*!
 * @brief PIT_LDVAL - Timer Load Value Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * These registers select the timeout period for the timer interrupts. Access:
 * User read/write
 */
/*!
 * @name Constants and macros for entire PIT_LDVAL register
 */
/*@{*/
#define PIT_RD_LDVAL(base, index) (PIT_LDVAL_REG(base, index))
#define PIT_WR_LDVAL(base, index, value) (PIT_LDVAL_REG(base, index) = (value))
#define PIT_RMW_LDVAL(base, index, mask, value) (PIT_WR_LDVAL(base, index, (PIT_RD_LDVAL(base, index) & ~(mask)) | (value)))
#define PIT_SET_LDVAL(base, index, value) (BME_OR32(&PIT_LDVAL_REG(base, index), (uint32_t)(value)))
#define PIT_CLR_LDVAL(base, index, value) (BME_AND32(&PIT_LDVAL_REG(base, index), (uint32_t)(~(value))))
#define PIT_TOG_LDVAL(base, index, value) (BME_XOR32(&PIT_LDVAL_REG(base, index), (uint32_t)(value)))
/*@}*/

/*******************************************************************************
 * PIT_CVAL - Current Timer Value Register
 ******************************************************************************/

/*!
 * @brief PIT_CVAL - Current Timer Value Register (RO)
 *
 * Reset value: 0x00000000U
 *
 * These registers indicate the current timer position. Access: User read only
 */
/*!
 * @name Constants and macros for entire PIT_CVAL register
 */
/*@{*/
#define PIT_RD_CVAL(base, index) (PIT_CVAL_REG(base, index))
/*@}*/

/*******************************************************************************
 * PIT_TCTRL - Timer Control Register
 ******************************************************************************/

/*!
 * @brief PIT_TCTRL - Timer Control Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * These registers contain the control bits for each timer. Access: User
 * read/write
 */
/*!
 * @name Constants and macros for entire PIT_TCTRL register
 */
/*@{*/
#define PIT_RD_TCTRL(base, index) (PIT_TCTRL_REG(base, index))
#define PIT_WR_TCTRL(base, index, value) (PIT_TCTRL_REG(base, index) = (value))
#define PIT_RMW_TCTRL(base, index, mask, value) (PIT_WR_TCTRL(base, index, (PIT_RD_TCTRL(base, index) & ~(mask)) | (value)))
#define PIT_SET_TCTRL(base, index, value) (BME_OR32(&PIT_TCTRL_REG(base, index), (uint32_t)(value)))
#define PIT_CLR_TCTRL(base, index, value) (BME_AND32(&PIT_TCTRL_REG(base, index), (uint32_t)(~(value))))
#define PIT_TOG_TCTRL(base, index, value) (BME_XOR32(&PIT_TCTRL_REG(base, index), (uint32_t)(value)))
/*@}*/

/*
 * Constants & macros for individual PIT_TCTRL bitfields
 */

/*!
 * @name Register PIT_TCTRL, field TEN[0] (RW)
 *
 * Enables or disables the timer.
 *
 * Values:
 * - 0 - Timer n is disabled.
 * - 1 - Timer n is enabled.
 */
/*@{*/
/*! @brief Read current value of the PIT_TCTRL_TEN field. */
#define PIT_RD_TCTRL_TEN(base, index) ((PIT_TCTRL_REG(base, index) & PIT_TCTRL_TEN_MASK) >> PIT_TCTRL_TEN_SHIFT)
#define PIT_BRD_TCTRL_TEN(base, index) (BME_UBFX32(&PIT_TCTRL_REG(base, index), PIT_TCTRL_TEN_SHIFT, PIT_TCTRL_TEN_WIDTH))

/*! @brief Set the TEN field to a new value. */
#define PIT_WR_TCTRL_TEN(base, index, value) (PIT_RMW_TCTRL(base, index, PIT_TCTRL_TEN_MASK, PIT_TCTRL_TEN(value)))
#define PIT_BWR_TCTRL_TEN(base, index, value) (BME_BFI32(&PIT_TCTRL_REG(base, index), ((uint32_t)(value) << PIT_TCTRL_TEN_SHIFT), PIT_TCTRL_TEN_SHIFT, PIT_TCTRL_TEN_WIDTH))
/*@}*/

/*!
 * @name Register PIT_TCTRL, field TIE[1] (RW)
 *
 * When an interrupt is pending, or, TFLGn[TIF] is set, enabling the interrupt
 * will immediately cause an interrupt event. To avoid this, the associated
 * TFLGn[TIF] must be cleared first.
 *
 * Values:
 * - 0 - Interrupt requests from Timer n are disabled.
 * - 1 - Interrupt will be requested whenever TIF is set.
 */
/*@{*/
/*! @brief Read current value of the PIT_TCTRL_TIE field. */
#define PIT_RD_TCTRL_TIE(base, index) ((PIT_TCTRL_REG(base, index) & PIT_TCTRL_TIE_MASK) >> PIT_TCTRL_TIE_SHIFT)
#define PIT_BRD_TCTRL_TIE(base, index) (BME_UBFX32(&PIT_TCTRL_REG(base, index), PIT_TCTRL_TIE_SHIFT, PIT_TCTRL_TIE_WIDTH))

/*! @brief Set the TIE field to a new value. */
#define PIT_WR_TCTRL_TIE(base, index, value) (PIT_RMW_TCTRL(base, index, PIT_TCTRL_TIE_MASK, PIT_TCTRL_TIE(value)))
#define PIT_BWR_TCTRL_TIE(base, index, value) (BME_BFI32(&PIT_TCTRL_REG(base, index), ((uint32_t)(value) << PIT_TCTRL_TIE_SHIFT), PIT_TCTRL_TIE_SHIFT, PIT_TCTRL_TIE_WIDTH))
/*@}*/

/*!
 * @name Register PIT_TCTRL, field CHN[2] (RW)
 *
 * When activated, Timer n-1 needs to expire before timer n can decrement by 1.
 * Timer 0 cannot be chained.
 *
 * Values:
 * - 0 - Timer is not chained.
 * - 1 - Timer is chained to previous timer. For example, for Channel 2, if this
 *     field is set, Timer 2 is chained to Timer 1.
 */
/*@{*/
/*! @brief Read current value of the PIT_TCTRL_CHN field. */
#define PIT_RD_TCTRL_CHN(base, index) ((PIT_TCTRL_REG(base, index) & PIT_TCTRL_CHN_MASK) >> PIT_TCTRL_CHN_SHIFT)
#define PIT_BRD_TCTRL_CHN(base, index) (BME_UBFX32(&PIT_TCTRL_REG(base, index), PIT_TCTRL_CHN_SHIFT, PIT_TCTRL_CHN_WIDTH))

/*! @brief Set the CHN field to a new value. */
#define PIT_WR_TCTRL_CHN(base, index, value) (PIT_RMW_TCTRL(base, index, PIT_TCTRL_CHN_MASK, PIT_TCTRL_CHN(value)))
#define PIT_BWR_TCTRL_CHN(base, index, value) (BME_BFI32(&PIT_TCTRL_REG(base, index), ((uint32_t)(value) << PIT_TCTRL_CHN_SHIFT), PIT_TCTRL_CHN_SHIFT, PIT_TCTRL_CHN_WIDTH))
/*@}*/

/*******************************************************************************
 * PIT_TFLG - Timer Flag Register
 ******************************************************************************/

/*!
 * @brief PIT_TFLG - Timer Flag Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * These registers hold the PIT interrupt flags. Access: User read/write
 */
/*!
 * @name Constants and macros for entire PIT_TFLG register
 */
/*@{*/
#define PIT_RD_TFLG(base, index) (PIT_TFLG_REG(base, index))
#define PIT_WR_TFLG(base, index, value) (PIT_TFLG_REG(base, index) = (value))
#define PIT_RMW_TFLG(base, index, mask, value) (PIT_WR_TFLG(base, index, (PIT_RD_TFLG(base, index) & ~(mask)) | (value)))
#define PIT_SET_TFLG(base, index, value) (BME_OR32(&PIT_TFLG_REG(base, index), (uint32_t)(value)))
#define PIT_CLR_TFLG(base, index, value) (BME_AND32(&PIT_TFLG_REG(base, index), (uint32_t)(~(value))))
#define PIT_TOG_TFLG(base, index, value) (BME_XOR32(&PIT_TFLG_REG(base, index), (uint32_t)(value)))
/*@}*/

/*
 * Constants & macros for individual PIT_TFLG bitfields
 */

/*!
 * @name Register PIT_TFLG, field TIF[0] (W1C)
 *
 * Sets to 1 at the end of the timer period. Writing 1 to this flag clears it.
 * Writing 0 has no effect. If enabled, or, when TCTRLn[TIE] = 1, TIF causes an
 * interrupt request.
 *
 * Values:
 * - 0 - Timeout has not yet occurred.
 * - 1 - Timeout has occurred.
 */
/*@{*/
/*! @brief Read current value of the PIT_TFLG_TIF field. */
#define PIT_RD_TFLG_TIF(base, index) ((PIT_TFLG_REG(base, index) & PIT_TFLG_TIF_MASK) >> PIT_TFLG_TIF_SHIFT)
#define PIT_BRD_TFLG_TIF(base, index) (BME_UBFX32(&PIT_TFLG_REG(base, index), PIT_TFLG_TIF_SHIFT, PIT_TFLG_TIF_WIDTH))

/*! @brief Set the TIF field to a new value. */
#define PIT_WR_TFLG_TIF(base, index, value) (PIT_RMW_TFLG(base, index, PIT_TFLG_TIF_MASK, PIT_TFLG_TIF(value)))
#define PIT_BWR_TFLG_TIF(base, index, value) (BME_BFI32(&PIT_TFLG_REG(base, index), ((uint32_t)(value) << PIT_TFLG_TIF_SHIFT), PIT_TFLG_TIF_SHIFT, PIT_TFLG_TIF_WIDTH))
/*@}*/

/*
 * MKL27Z644 PMC
 *
 * Power Management Controller
 *
 * Registers defined in this header file:
 * - PMC_LVDSC1 - Low Voltage Detect Status And Control 1 register
 * - PMC_LVDSC2 - Low Voltage Detect Status And Control 2 register
 * - PMC_REGSC - Regulator Status And Control register
 */

#define PMC_INSTANCE_COUNT (1U) /*!< Number of instances of the PMC module. */
#define PMC_IDX (0U) /*!< Instance number for PMC. */

/*******************************************************************************
 * PMC_LVDSC1 - Low Voltage Detect Status And Control 1 register
 ******************************************************************************/

/*!
 * @brief PMC_LVDSC1 - Low Voltage Detect Status And Control 1 register (RW)
 *
 * Reset value: 0x10U
 *
 * This register contains status and control bits to support the low voltage
 * detect function. This register should be written during the reset initialization
 * program to set the desired controls even if the desired settings are the same
 * as the reset settings. While the device is in the very low power or low
 * leakage modes, the LVD system is disabled regardless of LVDSC1 settings. To protect
 * systems that must have LVD always on, configure the Power Mode Protection
 * (PMPROT) register of the SMC module (SMC_PMPROT) to disallow any very low power or
 * low leakage modes from being enabled. See the device's data sheet for the
 * exact LVD trip voltages. The LVDV bits are reset solely on a POR Only event. The
 * register's other bits are reset on Chip Reset Not VLLS. For more information
 * about these reset types, refer to the Reset section details.
 */
/*!
 * @name Constants and macros for entire PMC_LVDSC1 register
 */
/*@{*/
#define PMC_RD_LVDSC1(base)      (PMC_LVDSC1_REG(base))
#define PMC_WR_LVDSC1(base, value) (PMC_LVDSC1_REG(base) = (value))
#define PMC_RMW_LVDSC1(base, mask, value) (PMC_WR_LVDSC1(base, (PMC_RD_LVDSC1(base) & ~(mask)) | (value)))
#define PMC_SET_LVDSC1(base, value) (BME_OR8(&PMC_LVDSC1_REG(base), (uint8_t)(value)))
#define PMC_CLR_LVDSC1(base, value) (BME_AND8(&PMC_LVDSC1_REG(base), (uint8_t)(~(value))))
#define PMC_TOG_LVDSC1(base, value) (BME_XOR8(&PMC_LVDSC1_REG(base), (uint8_t)(value)))
/*@}*/

/*
 * Constants & macros for individual PMC_LVDSC1 bitfields
 */

/*!
 * @name Register PMC_LVDSC1, field LVDV[1:0] (RW)
 *
 * Selects the LVD trip point voltage (V LVD ).
 *
 * Values:
 * - 00 - Low trip point selected (V LVD = V LVDL )
 * - 01 - High trip point selected (V LVD = V LVDH )
 * - 10 - Reserved
 * - 11 - Reserved
 */
/*@{*/
/*! @brief Read current value of the PMC_LVDSC1_LVDV field. */
#define PMC_RD_LVDSC1_LVDV(base) ((PMC_LVDSC1_REG(base) & PMC_LVDSC1_LVDV_MASK) >> PMC_LVDSC1_LVDV_SHIFT)
#define PMC_BRD_LVDSC1_LVDV(base) (BME_UBFX8(&PMC_LVDSC1_REG(base), PMC_LVDSC1_LVDV_SHIFT, PMC_LVDSC1_LVDV_WIDTH))

/*! @brief Set the LVDV field to a new value. */
#define PMC_WR_LVDSC1_LVDV(base, value) (PMC_RMW_LVDSC1(base, PMC_LVDSC1_LVDV_MASK, PMC_LVDSC1_LVDV(value)))
#define PMC_BWR_LVDSC1_LVDV(base, value) (BME_BFI8(&PMC_LVDSC1_REG(base), ((uint8_t)(value) << PMC_LVDSC1_LVDV_SHIFT), PMC_LVDSC1_LVDV_SHIFT, PMC_LVDSC1_LVDV_WIDTH))
/*@}*/

/*!
 * @name Register PMC_LVDSC1, field LVDRE[4] (RW)
 *
 * This write-once bit enables LVDF events to generate a hardware reset.
 * Additional writes are ignored.
 *
 * Values:
 * - 0 - LVDF does not generate hardware resets
 * - 1 - Force an MCU reset when LVDF = 1
 */
/*@{*/
/*! @brief Read current value of the PMC_LVDSC1_LVDRE field. */
#define PMC_RD_LVDSC1_LVDRE(base) ((PMC_LVDSC1_REG(base) & PMC_LVDSC1_LVDRE_MASK) >> PMC_LVDSC1_LVDRE_SHIFT)
#define PMC_BRD_LVDSC1_LVDRE(base) (BME_UBFX8(&PMC_LVDSC1_REG(base), PMC_LVDSC1_LVDRE_SHIFT, PMC_LVDSC1_LVDRE_WIDTH))

/*! @brief Set the LVDRE field to a new value. */
#define PMC_WR_LVDSC1_LVDRE(base, value) (PMC_RMW_LVDSC1(base, PMC_LVDSC1_LVDRE_MASK, PMC_LVDSC1_LVDRE(value)))
#define PMC_BWR_LVDSC1_LVDRE(base, value) (BME_BFI8(&PMC_LVDSC1_REG(base), ((uint8_t)(value) << PMC_LVDSC1_LVDRE_SHIFT), PMC_LVDSC1_LVDRE_SHIFT, PMC_LVDSC1_LVDRE_WIDTH))
/*@}*/

/*!
 * @name Register PMC_LVDSC1, field LVDIE[5] (RW)
 *
 * Enables hardware interrupt requests for LVDF.
 *
 * Values:
 * - 0 - Hardware interrupt disabled (use polling)
 * - 1 - Request a hardware interrupt when LVDF = 1
 */
/*@{*/
/*! @brief Read current value of the PMC_LVDSC1_LVDIE field. */
#define PMC_RD_LVDSC1_LVDIE(base) ((PMC_LVDSC1_REG(base) & PMC_LVDSC1_LVDIE_MASK) >> PMC_LVDSC1_LVDIE_SHIFT)
#define PMC_BRD_LVDSC1_LVDIE(base) (BME_UBFX8(&PMC_LVDSC1_REG(base), PMC_LVDSC1_LVDIE_SHIFT, PMC_LVDSC1_LVDIE_WIDTH))

/*! @brief Set the LVDIE field to a new value. */
#define PMC_WR_LVDSC1_LVDIE(base, value) (PMC_RMW_LVDSC1(base, PMC_LVDSC1_LVDIE_MASK, PMC_LVDSC1_LVDIE(value)))
#define PMC_BWR_LVDSC1_LVDIE(base, value) (BME_BFI8(&PMC_LVDSC1_REG(base), ((uint8_t)(value) << PMC_LVDSC1_LVDIE_SHIFT), PMC_LVDSC1_LVDIE_SHIFT, PMC_LVDSC1_LVDIE_WIDTH))
/*@}*/

/*!
 * @name Register PMC_LVDSC1, field LVDACK[6] (WORZ)
 *
 * This write-only field is used to acknowledge low voltage detection errors.
 * Write 1 to clear LVDF. Reads always return 0.
 */
/*@{*/
/*! @brief Set the LVDACK field to a new value. */
#define PMC_WR_LVDSC1_LVDACK(base, value) (PMC_RMW_LVDSC1(base, PMC_LVDSC1_LVDACK_MASK, PMC_LVDSC1_LVDACK(value)))
#define PMC_BWR_LVDSC1_LVDACK(base, value) (BME_BFI8(&PMC_LVDSC1_REG(base), ((uint8_t)(value) << PMC_LVDSC1_LVDACK_SHIFT), PMC_LVDSC1_LVDACK_SHIFT, PMC_LVDSC1_LVDACK_WIDTH))
/*@}*/

/*!
 * @name Register PMC_LVDSC1, field LVDF[7] (RO)
 *
 * This read-only status field indicates a low-voltage detect event.
 *
 * Values:
 * - 0 - Low-voltage event not detected
 * - 1 - Low-voltage event detected
 */
/*@{*/
/*! @brief Read current value of the PMC_LVDSC1_LVDF field. */
#define PMC_RD_LVDSC1_LVDF(base) ((PMC_LVDSC1_REG(base) & PMC_LVDSC1_LVDF_MASK) >> PMC_LVDSC1_LVDF_SHIFT)
#define PMC_BRD_LVDSC1_LVDF(base) (BME_UBFX8(&PMC_LVDSC1_REG(base), PMC_LVDSC1_LVDF_SHIFT, PMC_LVDSC1_LVDF_WIDTH))
/*@}*/

/*******************************************************************************
 * PMC_LVDSC2 - Low Voltage Detect Status And Control 2 register
 ******************************************************************************/

/*!
 * @brief PMC_LVDSC2 - Low Voltage Detect Status And Control 2 register (RW)
 *
 * Reset value: 0x00U
 *
 * This register contains status and control bits to support the low voltage
 * warning function. While the device is in the very low power or low leakage modes,
 * the LVD system is disabled regardless of LVDSC2 settings. See the device's
 * data sheet for the exact LVD trip voltages. The LVW trip voltages depend on LVWV
 * and LVDV. LVWV is reset solely on a POR Only event. The other fields of the
 * register are reset on Chip Reset Not VLLS. For more information about these
 * reset types, refer to the Reset section details.
 */
/*!
 * @name Constants and macros for entire PMC_LVDSC2 register
 */
/*@{*/
#define PMC_RD_LVDSC2(base)      (PMC_LVDSC2_REG(base))
#define PMC_WR_LVDSC2(base, value) (PMC_LVDSC2_REG(base) = (value))
#define PMC_RMW_LVDSC2(base, mask, value) (PMC_WR_LVDSC2(base, (PMC_RD_LVDSC2(base) & ~(mask)) | (value)))
#define PMC_SET_LVDSC2(base, value) (BME_OR8(&PMC_LVDSC2_REG(base), (uint8_t)(value)))
#define PMC_CLR_LVDSC2(base, value) (BME_AND8(&PMC_LVDSC2_REG(base), (uint8_t)(~(value))))
#define PMC_TOG_LVDSC2(base, value) (BME_XOR8(&PMC_LVDSC2_REG(base), (uint8_t)(value)))
/*@}*/

/*
 * Constants & macros for individual PMC_LVDSC2 bitfields
 */

/*!
 * @name Register PMC_LVDSC2, field LVWV[1:0] (RW)
 *
 * Selects the LVW trip point voltage (VLVW). The actual voltage for the warning
 * depends on LVDSC1[LVDV].
 *
 * Values:
 * - 00 - Low trip point selected (VLVW = VLVW1)
 * - 01 - Mid 1 trip point selected (VLVW = VLVW2)
 * - 10 - Mid 2 trip point selected (VLVW = VLVW3)
 * - 11 - High trip point selected (VLVW = VLVW4)
 */
/*@{*/
/*! @brief Read current value of the PMC_LVDSC2_LVWV field. */
#define PMC_RD_LVDSC2_LVWV(base) ((PMC_LVDSC2_REG(base) & PMC_LVDSC2_LVWV_MASK) >> PMC_LVDSC2_LVWV_SHIFT)
#define PMC_BRD_LVDSC2_LVWV(base) (BME_UBFX8(&PMC_LVDSC2_REG(base), PMC_LVDSC2_LVWV_SHIFT, PMC_LVDSC2_LVWV_WIDTH))

/*! @brief Set the LVWV field to a new value. */
#define PMC_WR_LVDSC2_LVWV(base, value) (PMC_RMW_LVDSC2(base, PMC_LVDSC2_LVWV_MASK, PMC_LVDSC2_LVWV(value)))
#define PMC_BWR_LVDSC2_LVWV(base, value) (BME_BFI8(&PMC_LVDSC2_REG(base), ((uint8_t)(value) << PMC_LVDSC2_LVWV_SHIFT), PMC_LVDSC2_LVWV_SHIFT, PMC_LVDSC2_LVWV_WIDTH))
/*@}*/

/*!
 * @name Register PMC_LVDSC2, field LVWIE[5] (RW)
 *
 * Enables hardware interrupt requests for LVWF.
 *
 * Values:
 * - 0 - Hardware interrupt disabled (use polling)
 * - 1 - Request a hardware interrupt when LVWF = 1
 */
/*@{*/
/*! @brief Read current value of the PMC_LVDSC2_LVWIE field. */
#define PMC_RD_LVDSC2_LVWIE(base) ((PMC_LVDSC2_REG(base) & PMC_LVDSC2_LVWIE_MASK) >> PMC_LVDSC2_LVWIE_SHIFT)
#define PMC_BRD_LVDSC2_LVWIE(base) (BME_UBFX8(&PMC_LVDSC2_REG(base), PMC_LVDSC2_LVWIE_SHIFT, PMC_LVDSC2_LVWIE_WIDTH))

/*! @brief Set the LVWIE field to a new value. */
#define PMC_WR_LVDSC2_LVWIE(base, value) (PMC_RMW_LVDSC2(base, PMC_LVDSC2_LVWIE_MASK, PMC_LVDSC2_LVWIE(value)))
#define PMC_BWR_LVDSC2_LVWIE(base, value) (BME_BFI8(&PMC_LVDSC2_REG(base), ((uint8_t)(value) << PMC_LVDSC2_LVWIE_SHIFT), PMC_LVDSC2_LVWIE_SHIFT, PMC_LVDSC2_LVWIE_WIDTH))
/*@}*/

/*!
 * @name Register PMC_LVDSC2, field LVWACK[6] (WORZ)
 *
 * This write-only field is used to acknowledge low voltage warning errors.
 * Write 1 to clear LVWF. Reads always return 0.
 */
/*@{*/
/*! @brief Set the LVWACK field to a new value. */
#define PMC_WR_LVDSC2_LVWACK(base, value) (PMC_RMW_LVDSC2(base, PMC_LVDSC2_LVWACK_MASK, PMC_LVDSC2_LVWACK(value)))
#define PMC_BWR_LVDSC2_LVWACK(base, value) (BME_BFI8(&PMC_LVDSC2_REG(base), ((uint8_t)(value) << PMC_LVDSC2_LVWACK_SHIFT), PMC_LVDSC2_LVWACK_SHIFT, PMC_LVDSC2_LVWACK_WIDTH))
/*@}*/

/*!
 * @name Register PMC_LVDSC2, field LVWF[7] (RO)
 *
 * This read-only status field indicates a low-voltage warning event. LVWF is
 * set when VSupply transitions below the trip point, or after reset and VSupply is
 * already below VLVW. LVWF may be 1 after power-on reset, therefore, to use LVW
 * interrupt function, before enabling LVWIE, LVWF must be cleared by writing
 * LVWACK first.
 *
 * Values:
 * - 0 - Low-voltage warning event not detected
 * - 1 - Low-voltage warning event detected
 */
/*@{*/
/*! @brief Read current value of the PMC_LVDSC2_LVWF field. */
#define PMC_RD_LVDSC2_LVWF(base) ((PMC_LVDSC2_REG(base) & PMC_LVDSC2_LVWF_MASK) >> PMC_LVDSC2_LVWF_SHIFT)
#define PMC_BRD_LVDSC2_LVWF(base) (BME_UBFX8(&PMC_LVDSC2_REG(base), PMC_LVDSC2_LVWF_SHIFT, PMC_LVDSC2_LVWF_WIDTH))
/*@}*/

/*******************************************************************************
 * PMC_REGSC - Regulator Status And Control register
 ******************************************************************************/

/*!
 * @brief PMC_REGSC - Regulator Status And Control register (RW)
 *
 * Reset value: 0x04U
 *
 * The PMC contains an internal voltage regulator. The voltage regulator design
 * uses a bandgap reference that is also available through a buffer as input to
 * certain internal peripherals, such as the CMP and ADC. The internal regulator
 * provides a status bit (REGONS) indicating the regulator is in run regulation.
 * This register is reset on Chip Reset Not VLLS and by reset types that trigger
 * Chip Reset not VLLS. See the Reset section details for more information.
 */
/*!
 * @name Constants and macros for entire PMC_REGSC register
 */
/*@{*/
#define PMC_RD_REGSC(base)       (PMC_REGSC_REG(base))
#define PMC_WR_REGSC(base, value) (PMC_REGSC_REG(base) = (value))
#define PMC_RMW_REGSC(base, mask, value) (PMC_WR_REGSC(base, (PMC_RD_REGSC(base) & ~(mask)) | (value)))
#define PMC_SET_REGSC(base, value) (BME_OR8(&PMC_REGSC_REG(base), (uint8_t)(value)))
#define PMC_CLR_REGSC(base, value) (BME_AND8(&PMC_REGSC_REG(base), (uint8_t)(~(value))))
#define PMC_TOG_REGSC(base, value) (BME_XOR8(&PMC_REGSC_REG(base), (uint8_t)(value)))
/*@}*/

/*
 * Constants & macros for individual PMC_REGSC bitfields
 */

/*!
 * @name Register PMC_REGSC, field BGBE[0] (RW)
 *
 * Enables the bandgap buffer.
 *
 * Values:
 * - 0 - Bandgap buffer not enabled
 * - 1 - Bandgap buffer enabled
 */
/*@{*/
/*! @brief Read current value of the PMC_REGSC_BGBE field. */
#define PMC_RD_REGSC_BGBE(base) ((PMC_REGSC_REG(base) & PMC_REGSC_BGBE_MASK) >> PMC_REGSC_BGBE_SHIFT)
#define PMC_BRD_REGSC_BGBE(base) (BME_UBFX8(&PMC_REGSC_REG(base), PMC_REGSC_BGBE_SHIFT, PMC_REGSC_BGBE_WIDTH))

/*! @brief Set the BGBE field to a new value. */
#define PMC_WR_REGSC_BGBE(base, value) (PMC_RMW_REGSC(base, (PMC_REGSC_BGBE_MASK | PMC_REGSC_ACKISO_MASK), PMC_REGSC_BGBE(value)))
#define PMC_BWR_REGSC_BGBE(base, value) (BME_BFI8(&PMC_REGSC_REG(base), ((uint8_t)(value) << PMC_REGSC_BGBE_SHIFT), PMC_REGSC_BGBE_SHIFT, PMC_REGSC_BGBE_WIDTH))
/*@}*/

/*!
 * @name Register PMC_REGSC, field REGONS[2] (RO)
 *
 * This read-only field provides the current status of the internal voltage
 * regulator.
 *
 * Values:
 * - 0 - Regulator is in stop regulation or in transition to/from it
 * - 1 - Regulator is in run regulation
 */
/*@{*/
/*! @brief Read current value of the PMC_REGSC_REGONS field. */
#define PMC_RD_REGSC_REGONS(base) ((PMC_REGSC_REG(base) & PMC_REGSC_REGONS_MASK) >> PMC_REGSC_REGONS_SHIFT)
#define PMC_BRD_REGSC_REGONS(base) (BME_UBFX8(&PMC_REGSC_REG(base), PMC_REGSC_REGONS_SHIFT, PMC_REGSC_REGONS_WIDTH))
/*@}*/

/*!
 * @name Register PMC_REGSC, field ACKISO[3] (W1C)
 *
 * Reading this field indicates whether certain peripherals and the I/O pads are
 * in a latched state as a result of having been in a VLLS mode. Writing 1 to
 * this field when it is set releases the I/O pads and certain peripherals to their
 * normal run mode state. After recovering from a VLLS mode, user should restore
 * chip configuration before clearing ACKISO. In particular, pin configuration
 * for enabled LLWU wakeup pins should be restored to avoid any LLWU flag from
 * being falsely set when ACKISO is cleared.
 *
 * Values:
 * - 0 - Peripherals and I/O pads are in normal run state.
 * - 1 - Certain peripherals and I/O pads are in an isolated and latched state.
 */
/*@{*/
/*! @brief Read current value of the PMC_REGSC_ACKISO field. */
#define PMC_RD_REGSC_ACKISO(base) ((PMC_REGSC_REG(base) & PMC_REGSC_ACKISO_MASK) >> PMC_REGSC_ACKISO_SHIFT)
#define PMC_BRD_REGSC_ACKISO(base) (BME_UBFX8(&PMC_REGSC_REG(base), PMC_REGSC_ACKISO_SHIFT, PMC_REGSC_ACKISO_WIDTH))

/*! @brief Set the ACKISO field to a new value. */
#define PMC_WR_REGSC_ACKISO(base, value) (PMC_RMW_REGSC(base, PMC_REGSC_ACKISO_MASK, PMC_REGSC_ACKISO(value)))
#define PMC_BWR_REGSC_ACKISO(base, value) (BME_BFI8(&PMC_REGSC_REG(base), ((uint8_t)(value) << PMC_REGSC_ACKISO_SHIFT), PMC_REGSC_ACKISO_SHIFT, PMC_REGSC_ACKISO_WIDTH))
/*@}*/

/*!
 * @name Register PMC_REGSC, field BGEN[4] (RW)
 *
 * BGEN controls whether the bandgap is enabled in lower power modes of
 * operation (VLPx, LLS, and VLLSx). When on-chip peripherals require the bandgap voltage
 * reference in low power modes of operation, set BGEN to continue to enable the
 * bandgap operation. When the bandgap voltage reference is not needed in low
 * power modes, clear BGEN to avoid excess power consumption.
 *
 * Values:
 * - 0 - Bandgap voltage reference is disabled in VLPx , LLS , and VLLSx modes.
 * - 1 - Bandgap voltage reference is enabled in VLPx , LLS , and VLLSx modes.
 */
/*@{*/
/*! @brief Read current value of the PMC_REGSC_BGEN field. */
#define PMC_RD_REGSC_BGEN(base) ((PMC_REGSC_REG(base) & PMC_REGSC_BGEN_MASK) >> PMC_REGSC_BGEN_SHIFT)
#define PMC_BRD_REGSC_BGEN(base) (BME_UBFX8(&PMC_REGSC_REG(base), PMC_REGSC_BGEN_SHIFT, PMC_REGSC_BGEN_WIDTH))

/*! @brief Set the BGEN field to a new value. */
#define PMC_WR_REGSC_BGEN(base, value) (PMC_RMW_REGSC(base, (PMC_REGSC_BGEN_MASK | PMC_REGSC_ACKISO_MASK), PMC_REGSC_BGEN(value)))
#define PMC_BWR_REGSC_BGEN(base, value) (BME_BFI8(&PMC_REGSC_REG(base), ((uint8_t)(value) << PMC_REGSC_BGEN_SHIFT), PMC_REGSC_BGEN_SHIFT, PMC_REGSC_BGEN_WIDTH))
/*@}*/

/*!
 * @name Register PMC_REGSC, field VLPO[6] (RW)
 *
 * When used in conjunction with BGEN, this bit allows additional clock sources
 * and higher frequency operation (at the cost of higher power) to be selected
 * during VLPx modes.
 *
 * Values:
 * - 0 - Operating frequencies and MCG clocking modes are restricted during VLPx
 *     modes as listed in the Power Management chapter.
 * - 1 - If BGEN is also set, operating frequencies and MCG clocking modes are
 *     unrestricted during VLPx modes. Note that flash access frequency is still
 *     restricted however.
 */
/*@{*/
/*! @brief Read current value of the PMC_REGSC_VLPO field. */
#define PMC_RD_REGSC_VLPO(base) ((PMC_REGSC_REG(base) & PMC_REGSC_VLPO_MASK) >> PMC_REGSC_VLPO_SHIFT)
#define PMC_BRD_REGSC_VLPO(base) (BME_UBFX8(&PMC_REGSC_REG(base), PMC_REGSC_VLPO_SHIFT, PMC_REGSC_VLPO_WIDTH))

/*! @brief Set the VLPO field to a new value. */
#define PMC_WR_REGSC_VLPO(base, value) (PMC_RMW_REGSC(base, (PMC_REGSC_VLPO_MASK | PMC_REGSC_ACKISO_MASK), PMC_REGSC_VLPO(value)))
#define PMC_BWR_REGSC_VLPO(base, value) (BME_BFI8(&PMC_REGSC_REG(base), ((uint8_t)(value) << PMC_REGSC_VLPO_SHIFT), PMC_REGSC_VLPO_SHIFT, PMC_REGSC_VLPO_WIDTH))
/*@}*/

/*
 * MKL27Z644 PORT
 *
 * Pin Control and Interrupts
 *
 * Registers defined in this header file:
 * - PORT_PCR - Pin Control Register n
 * - PORT_GPCLR - Global Pin Control Low Register
 * - PORT_GPCHR - Global Pin Control High Register
 * - PORT_ISFR - Interrupt Status Flag Register
 */

#define PORT_INSTANCE_COUNT (5U) /*!< Number of instances of the PORT module. */
#define PORTA_IDX (0U) /*!< Instance number for PORTA. */
#define PORTB_IDX (1U) /*!< Instance number for PORTB. */
#define PORTC_IDX (2U) /*!< Instance number for PORTC. */
#define PORTD_IDX (3U) /*!< Instance number for PORTD. */
#define PORTE_IDX (4U) /*!< Instance number for PORTE. */

/*******************************************************************************
 * PORT_PCR - Pin Control Register n
 ******************************************************************************/

/*!
 * @brief PORT_PCR - Pin Control Register n (RW)
 *
 * Reset value: 0x00000706U
 *
 * See the Signal Multiplexing and Pin Assignment chapter for the reset value of
 * this device. See the GPIO Configuration section for details on the available
 * functions for each pin. Do not modify pin configuration registers associated
 * with pins not available in your selected package. All unbonded pins not
 * available in your package will default to DISABLE state for lowest power consumption.
 */
/*!
 * @name Constants and macros for entire PORT_PCR register
 */
/*@{*/
#define PORT_RD_PCR(base, index) (PORT_PCR_REG(base, index))
#define PORT_WR_PCR(base, index, value) (PORT_PCR_REG(base, index) = (value))
#define PORT_RMW_PCR(base, index, mask, value) (PORT_WR_PCR(base, index, (PORT_RD_PCR(base, index) & ~(mask)) | (value)))
#define PORT_SET_PCR(base, index, value) (BME_OR32(&PORT_PCR_REG(base, index), (uint32_t)(value)))
#define PORT_CLR_PCR(base, index, value) (BME_AND32(&PORT_PCR_REG(base, index), (uint32_t)(~(value))))
#define PORT_TOG_PCR(base, index, value) (BME_XOR32(&PORT_PCR_REG(base, index), (uint32_t)(value)))
/*@}*/

/*
 * Constants & macros for individual PORT_PCR bitfields
 */

/*!
 * @name Register PORT_PCR, field PS[0] (RW)
 *
 * This bit is read only for pins that do not support a configurable pull
 * resistor direction. Pull configuration is valid in all digital pin muxing modes.
 *
 * Values:
 * - 0 - Internal pulldown resistor is enabled on the corresponding pin, if the
 *     corresponding PE field is set.
 * - 1 - Internal pullup resistor is enabled on the corresponding pin, if the
 *     corresponding PE field is set.
 */
/*@{*/
/*! @brief Read current value of the PORT_PCR_PS field. */
#define PORT_RD_PCR_PS(base, index) ((PORT_PCR_REG(base, index) & PORT_PCR_PS_MASK) >> PORT_PCR_PS_SHIFT)
#define PORT_BRD_PCR_PS(base, index) (BME_UBFX32(&PORT_PCR_REG(base, index), PORT_PCR_PS_SHIFT, PORT_PCR_PS_WIDTH))

/*! @brief Set the PS field to a new value. */
#define PORT_WR_PCR_PS(base, index, value) (PORT_RMW_PCR(base, index, (PORT_PCR_PS_MASK | PORT_PCR_ISF_MASK), PORT_PCR_PS(value)))
#define PORT_BWR_PCR_PS(base, index, value) (BME_BFI32(&PORT_PCR_REG(base, index), ((uint32_t)(value) << PORT_PCR_PS_SHIFT), PORT_PCR_PS_SHIFT, PORT_PCR_PS_WIDTH))
/*@}*/

/*!
 * @name Register PORT_PCR, field PE[1] (RW)
 *
 * This field is read-only for pins that do not support a configurable pull
 * resistor. Refer to the Chapter of Signal Multiplexing and Signal Descriptions for
 * the pins that support a configurable pull resistor. Pull configuration is
 * valid in all digital pin muxing modes.
 *
 * Values:
 * - 0 - Internal pullup or pulldown resistor is not enabled on the
 *     corresponding pin.
 * - 1 - Internal pullup or pulldown resistor is enabled on the corresponding
 *     pin, if the pin is configured as a digital input.
 */
/*@{*/
/*! @brief Read current value of the PORT_PCR_PE field. */
#define PORT_RD_PCR_PE(base, index) ((PORT_PCR_REG(base, index) & PORT_PCR_PE_MASK) >> PORT_PCR_PE_SHIFT)
#define PORT_BRD_PCR_PE(base, index) (BME_UBFX32(&PORT_PCR_REG(base, index), PORT_PCR_PE_SHIFT, PORT_PCR_PE_WIDTH))

/*! @brief Set the PE field to a new value. */
#define PORT_WR_PCR_PE(base, index, value) (PORT_RMW_PCR(base, index, (PORT_PCR_PE_MASK | PORT_PCR_ISF_MASK), PORT_PCR_PE(value)))
#define PORT_BWR_PCR_PE(base, index, value) (BME_BFI32(&PORT_PCR_REG(base, index), ((uint32_t)(value) << PORT_PCR_PE_SHIFT), PORT_PCR_PE_SHIFT, PORT_PCR_PE_WIDTH))
/*@}*/

/*!
 * @name Register PORT_PCR, field SRE[2] (RW)
 *
 * This field is read-only for pins that do not support a configurable slew
 * rate. Slew rate configuration is valid in all digital pin muxing modes.
 *
 * Values:
 * - 0 - Fast slew rate is configured on the corresponding pin, if the pin is
 *     configured as a digital output.
 * - 1 - Slow slew rate is configured on the corresponding pin, if the pin is
 *     configured as a digital output.
 */
/*@{*/
/*! @brief Read current value of the PORT_PCR_SRE field. */
#define PORT_RD_PCR_SRE(base, index) ((PORT_PCR_REG(base, index) & PORT_PCR_SRE_MASK) >> PORT_PCR_SRE_SHIFT)
#define PORT_BRD_PCR_SRE(base, index) (BME_UBFX32(&PORT_PCR_REG(base, index), PORT_PCR_SRE_SHIFT, PORT_PCR_SRE_WIDTH))

/*! @brief Set the SRE field to a new value. */
#define PORT_WR_PCR_SRE(base, index, value) (PORT_RMW_PCR(base, index, (PORT_PCR_SRE_MASK | PORT_PCR_ISF_MASK), PORT_PCR_SRE(value)))
#define PORT_BWR_PCR_SRE(base, index, value) (BME_BFI32(&PORT_PCR_REG(base, index), ((uint32_t)(value) << PORT_PCR_SRE_SHIFT), PORT_PCR_SRE_SHIFT, PORT_PCR_SRE_WIDTH))
/*@}*/

/*!
 * @name Register PORT_PCR, field PFE[4] (RW)
 *
 * This field is read-only for pins that do not support a configurable passive
 * input filter. Passive filter configuration is valid in all digital pin muxing
 * modes.
 *
 * Values:
 * - 0 - Passive input filter is disabled on the corresponding pin.
 * - 1 - Passive input filter is enabled on the corresponding pin, if the pin is
 *     configured as a digital input. Refer to the device data sheet for filter
 *     characteristics.
 */
/*@{*/
/*! @brief Read current value of the PORT_PCR_PFE field. */
#define PORT_RD_PCR_PFE(base, index) ((PORT_PCR_REG(base, index) & PORT_PCR_PFE_MASK) >> PORT_PCR_PFE_SHIFT)
#define PORT_BRD_PCR_PFE(base, index) (BME_UBFX32(&PORT_PCR_REG(base, index), PORT_PCR_PFE_SHIFT, PORT_PCR_PFE_WIDTH))

/*! @brief Set the PFE field to a new value. */
#define PORT_WR_PCR_PFE(base, index, value) (PORT_RMW_PCR(base, index, (PORT_PCR_PFE_MASK | PORT_PCR_ISF_MASK), PORT_PCR_PFE(value)))
#define PORT_BWR_PCR_PFE(base, index, value) (BME_BFI32(&PORT_PCR_REG(base, index), ((uint32_t)(value) << PORT_PCR_PFE_SHIFT), PORT_PCR_PFE_SHIFT, PORT_PCR_PFE_WIDTH))
/*@}*/

/*!
 * @name Register PORT_PCR, field DSE[6] (RW)
 *
 * This field is read-only for pins that do not support a configurable drive
 * strength. Drive strength configuration is valid in all digital pin muxing modes.
 *
 * Values:
 * - 0 - Low drive strength is configured on the corresponding pin, if pin is
 *     configured as a digital output.
 * - 1 - High drive strength is configured on the corresponding pin, if pin is
 *     configured as a digital output.
 */
/*@{*/
/*! @brief Read current value of the PORT_PCR_DSE field. */
#define PORT_RD_PCR_DSE(base, index) ((PORT_PCR_REG(base, index) & PORT_PCR_DSE_MASK) >> PORT_PCR_DSE_SHIFT)
#define PORT_BRD_PCR_DSE(base, index) (BME_UBFX32(&PORT_PCR_REG(base, index), PORT_PCR_DSE_SHIFT, PORT_PCR_DSE_WIDTH))

/*! @brief Set the DSE field to a new value. */
#define PORT_WR_PCR_DSE(base, index, value) (PORT_RMW_PCR(base, index, (PORT_PCR_DSE_MASK | PORT_PCR_ISF_MASK), PORT_PCR_DSE(value)))
#define PORT_BWR_PCR_DSE(base, index, value) (BME_BFI32(&PORT_PCR_REG(base, index), ((uint32_t)(value) << PORT_PCR_DSE_SHIFT), PORT_PCR_DSE_SHIFT, PORT_PCR_DSE_WIDTH))
/*@}*/

/*!
 * @name Register PORT_PCR, field MUX[10:8] (RW)
 *
 * Not all pins support all pin muxing slots. Unimplemented pin muxing slots are
 * reserved and may result in configuring the pin for a different pin muxing
 * slot. The corresponding pin is configured in the following pin muxing slot as
 * follows:
 *
 * Values:
 * - 000 - Pin disabled (analog).
 * - 001 - Alternative 1 (GPIO).
 * - 010 - Alternative 2 (chip-specific).
 * - 011 - Alternative 3 (chip-specific).
 * - 100 - Alternative 4 (chip-specific).
 * - 101 - Alternative 5 (chip-specific).
 * - 110 - Alternative 6 (chip-specific).
 * - 111 - Alternative 7 (chip-specific).
 */
/*@{*/
/*! @brief Read current value of the PORT_PCR_MUX field. */
#define PORT_RD_PCR_MUX(base, index) ((PORT_PCR_REG(base, index) & PORT_PCR_MUX_MASK) >> PORT_PCR_MUX_SHIFT)
#define PORT_BRD_PCR_MUX(base, index) (BME_UBFX32(&PORT_PCR_REG(base, index), PORT_PCR_MUX_SHIFT, PORT_PCR_MUX_WIDTH))

/*! @brief Set the MUX field to a new value. */
#define PORT_WR_PCR_MUX(base, index, value) (PORT_RMW_PCR(base, index, (PORT_PCR_MUX_MASK | PORT_PCR_ISF_MASK), PORT_PCR_MUX(value)))
#define PORT_BWR_PCR_MUX(base, index, value) (BME_BFI32(&PORT_PCR_REG(base, index), ((uint32_t)(value) << PORT_PCR_MUX_SHIFT), PORT_PCR_MUX_SHIFT, PORT_PCR_MUX_WIDTH))
/*@}*/

/*!
 * @name Register PORT_PCR, field IRQC[19:16] (RW)
 *
 * This field is read-only for pins that do not support interrupt generation.
 * The pin interrupt configuration is valid in all digital pin muxing modes. The
 * corresponding pin is configured to generate interrupt/DMA request as follows:
 *
 * Values:
 * - 0000 - Flag is disabled.
 * - 0001 - Flag and DMA request on rising edge.
 * - 0010 - Flag and DMA request on falling edge.
 * - 0011 - Flag and DMA request on either edge.
 * - 0100 - Reserved.
 * - 0101 - Reserved.
 * - 0110 - Reserved.
 * - 0111 - Reserved.
 * - 1000 - Flag and Interrupt when logic 0.
 * - 1001 - Flag and Interrupt on rising-edge.
 * - 1010 - Flag and Interrupt on falling-edge.
 * - 1011 - Flag and Interrupt on either edge.
 * - 1100 - Flag and Interrupt when logic 1.
 * - 1101 - Reserved.
 * - 1110 - Reserved.
 * - 1111 - Reserved.
 */
/*@{*/
/*! @brief Read current value of the PORT_PCR_IRQC field. */
#define PORT_RD_PCR_IRQC(base, index) ((PORT_PCR_REG(base, index) & PORT_PCR_IRQC_MASK) >> PORT_PCR_IRQC_SHIFT)
#define PORT_BRD_PCR_IRQC(base, index) (BME_UBFX32(&PORT_PCR_REG(base, index), PORT_PCR_IRQC_SHIFT, PORT_PCR_IRQC_WIDTH))

/*! @brief Set the IRQC field to a new value. */
#define PORT_WR_PCR_IRQC(base, index, value) (PORT_RMW_PCR(base, index, (PORT_PCR_IRQC_MASK | PORT_PCR_ISF_MASK), PORT_PCR_IRQC(value)))
#define PORT_BWR_PCR_IRQC(base, index, value) (BME_BFI32(&PORT_PCR_REG(base, index), ((uint32_t)(value) << PORT_PCR_IRQC_SHIFT), PORT_PCR_IRQC_SHIFT, PORT_PCR_IRQC_WIDTH))
/*@}*/

/*!
 * @name Register PORT_PCR, field ISF[24] (W1C)
 *
 * This field is read-only for pins that do not support interrupt generation.
 * The pin interrupt configuration is valid in all digital pin muxing modes.
 *
 * Values:
 * - 0 - Configured interrupt is not detected.
 * - 1 - Configured interrupt is detected. If the pin is configured to generate
 *     a DMA request, then the corresponding flag will be cleared automatically
 *     at the completion of the requested DMA transfer. Otherwise, the flag
 *     remains set until a logic 1 is written to the flag. If the pin is configured for
 *     a level sensitive interrupt and the pin remains asserted, then the flag
 *     is set again immediately after it is cleared.
 */
/*@{*/
/*! @brief Read current value of the PORT_PCR_ISF field. */
#define PORT_RD_PCR_ISF(base, index) ((PORT_PCR_REG(base, index) & PORT_PCR_ISF_MASK) >> PORT_PCR_ISF_SHIFT)
#define PORT_BRD_PCR_ISF(base, index) (BME_UBFX32(&PORT_PCR_REG(base, index), PORT_PCR_ISF_SHIFT, PORT_PCR_ISF_WIDTH))

/*! @brief Set the ISF field to a new value. */
#define PORT_WR_PCR_ISF(base, index, value) (PORT_RMW_PCR(base, index, PORT_PCR_ISF_MASK, PORT_PCR_ISF(value)))
#define PORT_BWR_PCR_ISF(base, index, value) (BME_BFI32(&PORT_PCR_REG(base, index), ((uint32_t)(value) << PORT_PCR_ISF_SHIFT), PORT_PCR_ISF_SHIFT, PORT_PCR_ISF_WIDTH))
/*@}*/

/*******************************************************************************
 * PORT_GPCLR - Global Pin Control Low Register
 ******************************************************************************/

/*!
 * @brief PORT_GPCLR - Global Pin Control Low Register (WORZ)
 *
 * Reset value: 0x00000000U
 *
 * Only 32-bit writes are supported to this register.
 */
/*!
 * @name Constants and macros for entire PORT_GPCLR register
 */
/*@{*/
#define PORT_RD_GPCLR(base)      (PORT_GPCLR_REG(base))
#define PORT_WR_GPCLR(base, value) (PORT_GPCLR_REG(base) = (value))
#define PORT_RMW_GPCLR(base, mask, value) (PORT_WR_GPCLR(base, (PORT_RD_GPCLR(base) & ~(mask)) | (value)))
/*@}*/

/*
 * Constants & macros for individual PORT_GPCLR bitfields
 */

/*!
 * @name Register PORT_GPCLR, field GPWD[15:0] (WORZ)
 *
 * Write value that is written to all Pin Control Registers bits [15:0] that are
 * selected by GPWE.
 */
/*@{*/
/*! @brief Set the GPWD field to a new value. */
#define PORT_WR_GPCLR_GPWD(base, value) (PORT_RMW_GPCLR(base, PORT_GPCLR_GPWD_MASK, PORT_GPCLR_GPWD(value)))
#define PORT_BWR_GPCLR_GPWD(base, value) (BME_BFI32(&PORT_GPCLR_REG(base), ((uint32_t)(value) << PORT_GPCLR_GPWD_SHIFT), PORT_GPCLR_GPWD_SHIFT, PORT_GPCLR_GPWD_WIDTH))
/*@}*/

/*!
 * @name Register PORT_GPCLR, field GPWE[31:16] (WORZ)
 *
 * Selects which Pin Control Registers (15 through 0) bits [15:0] update with
 * the value in GPWD.
 *
 * Values:
 * - 0 - Corresponding Pin Control Register is not updated with the value in
 *     GPWD.
 * - 1 - Corresponding Pin Control Register is updated with the value in GPWD.
 */
/*@{*/
/*! @brief Set the GPWE field to a new value. */
#define PORT_WR_GPCLR_GPWE(base, value) (PORT_RMW_GPCLR(base, PORT_GPCLR_GPWE_MASK, PORT_GPCLR_GPWE(value)))
#define PORT_BWR_GPCLR_GPWE(base, value) (BME_BFI32(&PORT_GPCLR_REG(base), ((uint32_t)(value) << PORT_GPCLR_GPWE_SHIFT), PORT_GPCLR_GPWE_SHIFT, PORT_GPCLR_GPWE_WIDTH))
/*@}*/

/*******************************************************************************
 * PORT_GPCHR - Global Pin Control High Register
 ******************************************************************************/

/*!
 * @brief PORT_GPCHR - Global Pin Control High Register (WORZ)
 *
 * Reset value: 0x00000000U
 *
 * Only 32-bit writes are supported to this register.
 */
/*!
 * @name Constants and macros for entire PORT_GPCHR register
 */
/*@{*/
#define PORT_RD_GPCHR(base)      (PORT_GPCHR_REG(base))
#define PORT_WR_GPCHR(base, value) (PORT_GPCHR_REG(base) = (value))
#define PORT_RMW_GPCHR(base, mask, value) (PORT_WR_GPCHR(base, (PORT_RD_GPCHR(base) & ~(mask)) | (value)))
/*@}*/

/*
 * Constants & macros for individual PORT_GPCHR bitfields
 */

/*!
 * @name Register PORT_GPCHR, field GPWD[15:0] (WORZ)
 *
 * Write value that is written to all Pin Control Registers bits [15:0] that are
 * selected by GPWE.
 */
/*@{*/
/*! @brief Set the GPWD field to a new value. */
#define PORT_WR_GPCHR_GPWD(base, value) (PORT_RMW_GPCHR(base, PORT_GPCHR_GPWD_MASK, PORT_GPCHR_GPWD(value)))
#define PORT_BWR_GPCHR_GPWD(base, value) (BME_BFI32(&PORT_GPCHR_REG(base), ((uint32_t)(value) << PORT_GPCHR_GPWD_SHIFT), PORT_GPCHR_GPWD_SHIFT, PORT_GPCHR_GPWD_WIDTH))
/*@}*/

/*!
 * @name Register PORT_GPCHR, field GPWE[31:16] (WORZ)
 *
 * Selects which Pin Control Registers (31 through 16) bits [15:0] update with
 * the value in GPWD.
 *
 * Values:
 * - 0 - Corresponding Pin Control Register is not updated with the value in
 *     GPWD.
 * - 1 - Corresponding Pin Control Register is updated with the value in GPWD.
 */
/*@{*/
/*! @brief Set the GPWE field to a new value. */
#define PORT_WR_GPCHR_GPWE(base, value) (PORT_RMW_GPCHR(base, PORT_GPCHR_GPWE_MASK, PORT_GPCHR_GPWE(value)))
#define PORT_BWR_GPCHR_GPWE(base, value) (BME_BFI32(&PORT_GPCHR_REG(base), ((uint32_t)(value) << PORT_GPCHR_GPWE_SHIFT), PORT_GPCHR_GPWE_SHIFT, PORT_GPCHR_GPWE_WIDTH))
/*@}*/

/*******************************************************************************
 * PORT_ISFR - Interrupt Status Flag Register
 ******************************************************************************/

/*!
 * @brief PORT_ISFR - Interrupt Status Flag Register (W1C)
 *
 * Reset value: 0x00000000U
 *
 * The corresponding bit is read only for pins that do not support interrupt
 * generation. The pin interrupt configuration is valid in all digital pin muxing
 * modes. The Interrupt Status Flag for each pin is also visible in the
 * corresponding Pin Control Register, and each flag can be cleared in either location.
 */
/*!
 * @name Constants and macros for entire PORT_ISFR register
 */
/*@{*/
#define PORT_RD_ISFR(base)       (PORT_ISFR_REG(base))
#define PORT_WR_ISFR(base, value) (PORT_ISFR_REG(base) = (value))
#define PORT_RMW_ISFR(base, mask, value) (PORT_WR_ISFR(base, (PORT_RD_ISFR(base) & ~(mask)) | (value)))
#define PORT_SET_ISFR(base, value) (BME_OR32(&PORT_ISFR_REG(base), (uint32_t)(value)))
#define PORT_CLR_ISFR(base, value) (BME_AND32(&PORT_ISFR_REG(base), (uint32_t)(~(value))))
#define PORT_TOG_ISFR(base, value) (BME_XOR32(&PORT_ISFR_REG(base), (uint32_t)(value)))
/*@}*/

/*
 * MKL27Z644 RCM
 *
 * Reset Control Module
 *
 * Registers defined in this header file:
 * - RCM_SRS0 - System Reset Status Register 0
 * - RCM_SRS1 - System Reset Status Register 1
 * - RCM_RPFC - Reset Pin Filter Control register
 * - RCM_RPFW - Reset Pin Filter Width register
 * - RCM_FM - Force Mode Register
 * - RCM_MR - Mode Register
 * - RCM_SSRS0 - Sticky System Reset Status Register 0
 * - RCM_SSRS1 - Sticky System Reset Status Register 1
 */

#define RCM_INSTANCE_COUNT (1U) /*!< Number of instances of the RCM module. */
#define RCM_IDX (0U) /*!< Instance number for RCM. */

/*******************************************************************************
 * RCM_SRS0 - System Reset Status Register 0
 ******************************************************************************/

/*!
 * @brief RCM_SRS0 - System Reset Status Register 0 (RO)
 *
 * Reset value: 0x82U
 *
 * This register includes read-only status flags to indicate the source of the
 * most recent reset. The reset state of these bits depends on what caused the MCU
 * to reset. The reset value of this register depends on the reset source: POR
 * (including LVD) - 0x82 LVD (without POR) - 0x02 VLLS mode wakeup due to RESET
 * pin assertion - 0x41 VLLS mode wakeup due to other wakeup sources - 0x01 Other
 * reset - a bit is set if its corresponding reset source caused the reset
 */
/*!
 * @name Constants and macros for entire RCM_SRS0 register
 */
/*@{*/
#define RCM_RD_SRS0(base)        (RCM_SRS0_REG(base))
/*@}*/

/*
 * Constants & macros for individual RCM_SRS0 bitfields
 */

/*!
 * @name Register RCM_SRS0, field WAKEUP[0] (RO)
 *
 * Indicates a reset has been caused by an enabled LLWU module wakeup source
 * while the chip was in a low leakage mode. In LLS mode, the RESET pin is the only
 * wakeup source that can cause this reset. Any enabled wakeup source in a VLLSx
 * mode causes a reset. This bit is cleared by any reset except WAKEUP.
 *
 * Values:
 * - 0 - Reset not caused by LLWU module wakeup source
 * - 1 - Reset caused by LLWU module wakeup source
 */
/*@{*/
/*! @brief Read current value of the RCM_SRS0_WAKEUP field. */
#define RCM_RD_SRS0_WAKEUP(base) ((RCM_SRS0_REG(base) & RCM_SRS0_WAKEUP_MASK) >> RCM_SRS0_WAKEUP_SHIFT)
#define RCM_BRD_SRS0_WAKEUP(base) (BME_UBFX8(&RCM_SRS0_REG(base), RCM_SRS0_WAKEUP_SHIFT, RCM_SRS0_WAKEUP_WIDTH))
/*@}*/

/*!
 * @name Register RCM_SRS0, field LVD[1] (RO)
 *
 * If PMC_LVDSC1[LVDRE] is set and the supply drops below the LVD trip voltage,
 * an LVD reset occurs. This field is also set by POR.
 *
 * Values:
 * - 0 - Reset not caused by LVD trip or POR
 * - 1 - Reset caused by LVD trip or POR
 */
/*@{*/
/*! @brief Read current value of the RCM_SRS0_LVD field. */
#define RCM_RD_SRS0_LVD(base) ((RCM_SRS0_REG(base) & RCM_SRS0_LVD_MASK) >> RCM_SRS0_LVD_SHIFT)
#define RCM_BRD_SRS0_LVD(base) (BME_UBFX8(&RCM_SRS0_REG(base), RCM_SRS0_LVD_SHIFT, RCM_SRS0_LVD_WIDTH))
/*@}*/

/*!
 * @name Register RCM_SRS0, field WDOG[5] (RO)
 *
 * Indicates a reset has been caused by the watchdog timer Computer Operating
 * Properly (COP) timing out. This reset source can be blocked by disabling the COP
 * watchdog: write 00 to the SIM's COPC[COPT] field.
 *
 * Values:
 * - 0 - Reset not caused by watchdog timeout
 * - 1 - Reset caused by watchdog timeout
 */
/*@{*/
/*! @brief Read current value of the RCM_SRS0_WDOG field. */
#define RCM_RD_SRS0_WDOG(base) ((RCM_SRS0_REG(base) & RCM_SRS0_WDOG_MASK) >> RCM_SRS0_WDOG_SHIFT)
#define RCM_BRD_SRS0_WDOG(base) (BME_UBFX8(&RCM_SRS0_REG(base), RCM_SRS0_WDOG_SHIFT, RCM_SRS0_WDOG_WIDTH))
/*@}*/

/*!
 * @name Register RCM_SRS0, field PIN[6] (RO)
 *
 * Indicates a reset has been caused by an active-low level on the external
 * RESET pin.
 *
 * Values:
 * - 0 - Reset not caused by external reset pin
 * - 1 - Reset caused by external reset pin
 */
/*@{*/
/*! @brief Read current value of the RCM_SRS0_PIN field. */
#define RCM_RD_SRS0_PIN(base) ((RCM_SRS0_REG(base) & RCM_SRS0_PIN_MASK) >> RCM_SRS0_PIN_SHIFT)
#define RCM_BRD_SRS0_PIN(base) (BME_UBFX8(&RCM_SRS0_REG(base), RCM_SRS0_PIN_SHIFT, RCM_SRS0_PIN_WIDTH))
/*@}*/

/*!
 * @name Register RCM_SRS0, field POR[7] (RO)
 *
 * Indicates a reset has been caused by the power-on detection logic. Because
 * the internal supply voltage was ramping up at the time, the low-voltage reset
 * (LVD) status bit is also set to indicate that the reset occurred while the
 * internal supply was below the LVD threshold.
 *
 * Values:
 * - 0 - Reset not caused by POR
 * - 1 - Reset caused by POR
 */
/*@{*/
/*! @brief Read current value of the RCM_SRS0_POR field. */
#define RCM_RD_SRS0_POR(base) ((RCM_SRS0_REG(base) & RCM_SRS0_POR_MASK) >> RCM_SRS0_POR_SHIFT)
#define RCM_BRD_SRS0_POR(base) (BME_UBFX8(&RCM_SRS0_REG(base), RCM_SRS0_POR_SHIFT, RCM_SRS0_POR_WIDTH))
/*@}*/

/*******************************************************************************
 * RCM_SRS1 - System Reset Status Register 1
 ******************************************************************************/

/*!
 * @brief RCM_SRS1 - System Reset Status Register 1 (RO)
 *
 * Reset value: 0x00U
 *
 * This register includes read-only status flags to indicate the source of the
 * most recent reset. The reset state of these bits depends on what caused the MCU
 * to reset. The reset value of this register depends on the reset source: POR
 * (including LVD) - 0x00 LVD (without POR) - 0x00 VLLS mode wakeup - 0x00 Other
 * reset - a bit is set if its corresponding reset source caused the reset
 */
/*!
 * @name Constants and macros for entire RCM_SRS1 register
 */
/*@{*/
#define RCM_RD_SRS1(base)        (RCM_SRS1_REG(base))
/*@}*/

/*
 * Constants & macros for individual RCM_SRS1 bitfields
 */

/*!
 * @name Register RCM_SRS1, field LOCKUP[1] (RO)
 *
 * Indicates a reset has been caused by the ARM core indication of a LOCKUP
 * event.
 *
 * Values:
 * - 0 - Reset not caused by core LOCKUP event
 * - 1 - Reset caused by core LOCKUP event
 */
/*@{*/
/*! @brief Read current value of the RCM_SRS1_LOCKUP field. */
#define RCM_RD_SRS1_LOCKUP(base) ((RCM_SRS1_REG(base) & RCM_SRS1_LOCKUP_MASK) >> RCM_SRS1_LOCKUP_SHIFT)
#define RCM_BRD_SRS1_LOCKUP(base) (BME_UBFX8(&RCM_SRS1_REG(base), RCM_SRS1_LOCKUP_SHIFT, RCM_SRS1_LOCKUP_WIDTH))
/*@}*/

/*!
 * @name Register RCM_SRS1, field SW[2] (RO)
 *
 * Indicates a reset has been caused by software setting of SYSRESETREQ bit in
 * Application Interrupt and Reset Control Register in the ARM core.
 *
 * Values:
 * - 0 - Reset not caused by software setting of SYSRESETREQ bit
 * - 1 - Reset caused by software setting of SYSRESETREQ bit
 */
/*@{*/
/*! @brief Read current value of the RCM_SRS1_SW field. */
#define RCM_RD_SRS1_SW(base) ((RCM_SRS1_REG(base) & RCM_SRS1_SW_MASK) >> RCM_SRS1_SW_SHIFT)
#define RCM_BRD_SRS1_SW(base) (BME_UBFX8(&RCM_SRS1_REG(base), RCM_SRS1_SW_SHIFT, RCM_SRS1_SW_WIDTH))
/*@}*/

/*!
 * @name Register RCM_SRS1, field MDM_AP[3] (RO)
 *
 * Indicates a reset has been caused by the host debugger system setting of the
 * System Reset Request bit in the MDM-AP Control Register.
 *
 * Values:
 * - 0 - Reset not caused by host debugger system setting of the System Reset
 *     Request bit
 * - 1 - Reset caused by host debugger system setting of the System Reset
 *     Request bit
 */
/*@{*/
/*! @brief Read current value of the RCM_SRS1_MDM_AP field. */
#define RCM_RD_SRS1_MDM_AP(base) ((RCM_SRS1_REG(base) & RCM_SRS1_MDM_AP_MASK) >> RCM_SRS1_MDM_AP_SHIFT)
#define RCM_BRD_SRS1_MDM_AP(base) (BME_UBFX8(&RCM_SRS1_REG(base), RCM_SRS1_MDM_AP_SHIFT, RCM_SRS1_MDM_AP_WIDTH))
/*@}*/

/*!
 * @name Register RCM_SRS1, field SACKERR[5] (RO)
 *
 * Indicates that after an attempt to enter Stop mode, a reset has been caused
 * by a failure of one or more peripherals to acknowledge within approximately one
 * second to enter stop mode.
 *
 * Values:
 * - 0 - Reset not caused by peripheral failure to acknowledge attempt to enter
 *     stop mode
 * - 1 - Reset caused by peripheral failure to acknowledge attempt to enter stop
 *     mode
 */
/*@{*/
/*! @brief Read current value of the RCM_SRS1_SACKERR field. */
#define RCM_RD_SRS1_SACKERR(base) ((RCM_SRS1_REG(base) & RCM_SRS1_SACKERR_MASK) >> RCM_SRS1_SACKERR_SHIFT)
#define RCM_BRD_SRS1_SACKERR(base) (BME_UBFX8(&RCM_SRS1_REG(base), RCM_SRS1_SACKERR_SHIFT, RCM_SRS1_SACKERR_WIDTH))
/*@}*/

/*******************************************************************************
 * RCM_RPFC - Reset Pin Filter Control register
 ******************************************************************************/

/*!
 * @brief RCM_RPFC - Reset Pin Filter Control register (RW)
 *
 * Reset value: 0x00U
 *
 * The reset values of bits 2-0 are for Chip POR only. They are unaffected by
 * other reset types. The bus clock filter is reset when disabled or when entering
 * stop mode. The LPO filter is reset when disabled .
 */
/*!
 * @name Constants and macros for entire RCM_RPFC register
 */
/*@{*/
#define RCM_RD_RPFC(base)        (RCM_RPFC_REG(base))
#define RCM_WR_RPFC(base, value) (RCM_RPFC_REG(base) = (value))
#define RCM_RMW_RPFC(base, mask, value) (RCM_WR_RPFC(base, (RCM_RD_RPFC(base) & ~(mask)) | (value)))
#define RCM_SET_RPFC(base, value) (BME_OR8(&RCM_RPFC_REG(base), (uint8_t)(value)))
#define RCM_CLR_RPFC(base, value) (BME_AND8(&RCM_RPFC_REG(base), (uint8_t)(~(value))))
#define RCM_TOG_RPFC(base, value) (BME_XOR8(&RCM_RPFC_REG(base), (uint8_t)(value)))
/*@}*/

/*
 * Constants & macros for individual RCM_RPFC bitfields
 */

/*!
 * @name Register RCM_RPFC, field RSTFLTSRW[1:0] (RW)
 *
 * Selects how the reset pin filter is enabled in run and wait modes.
 *
 * Values:
 * - 00 - All filtering disabled
 * - 01 - Bus clock filter enabled for normal operation
 * - 10 - LPO clock filter enabled for normal operation
 * - 11 - Reserved
 */
/*@{*/
/*! @brief Read current value of the RCM_RPFC_RSTFLTSRW field. */
#define RCM_RD_RPFC_RSTFLTSRW(base) ((RCM_RPFC_REG(base) & RCM_RPFC_RSTFLTSRW_MASK) >> RCM_RPFC_RSTFLTSRW_SHIFT)
#define RCM_BRD_RPFC_RSTFLTSRW(base) (BME_UBFX8(&RCM_RPFC_REG(base), RCM_RPFC_RSTFLTSRW_SHIFT, RCM_RPFC_RSTFLTSRW_WIDTH))

/*! @brief Set the RSTFLTSRW field to a new value. */
#define RCM_WR_RPFC_RSTFLTSRW(base, value) (RCM_RMW_RPFC(base, RCM_RPFC_RSTFLTSRW_MASK, RCM_RPFC_RSTFLTSRW(value)))
#define RCM_BWR_RPFC_RSTFLTSRW(base, value) (BME_BFI8(&RCM_RPFC_REG(base), ((uint8_t)(value) << RCM_RPFC_RSTFLTSRW_SHIFT), RCM_RPFC_RSTFLTSRW_SHIFT, RCM_RPFC_RSTFLTSRW_WIDTH))
/*@}*/

/*!
 * @name Register RCM_RPFC, field RSTFLTSS[2] (RW)
 *
 * Selects how the reset pin filter is enabled in Stop and VLPS modes , and also
 * during LLS and VLLS modes. On exit from VLLS mode, this bit should be
 * reconfigured before clearing PMC_REGSC[ACKISO].
 *
 * Values:
 * - 0 - All filtering disabled
 * - 1 - LPO clock filter enabled
 */
/*@{*/
/*! @brief Read current value of the RCM_RPFC_RSTFLTSS field. */
#define RCM_RD_RPFC_RSTFLTSS(base) ((RCM_RPFC_REG(base) & RCM_RPFC_RSTFLTSS_MASK) >> RCM_RPFC_RSTFLTSS_SHIFT)
#define RCM_BRD_RPFC_RSTFLTSS(base) (BME_UBFX8(&RCM_RPFC_REG(base), RCM_RPFC_RSTFLTSS_SHIFT, RCM_RPFC_RSTFLTSS_WIDTH))

/*! @brief Set the RSTFLTSS field to a new value. */
#define RCM_WR_RPFC_RSTFLTSS(base, value) (RCM_RMW_RPFC(base, RCM_RPFC_RSTFLTSS_MASK, RCM_RPFC_RSTFLTSS(value)))
#define RCM_BWR_RPFC_RSTFLTSS(base, value) (BME_BFI8(&RCM_RPFC_REG(base), ((uint8_t)(value) << RCM_RPFC_RSTFLTSS_SHIFT), RCM_RPFC_RSTFLTSS_SHIFT, RCM_RPFC_RSTFLTSS_WIDTH))
/*@}*/

/*******************************************************************************
 * RCM_RPFW - Reset Pin Filter Width register
 ******************************************************************************/

/*!
 * @brief RCM_RPFW - Reset Pin Filter Width register (RW)
 *
 * Reset value: 0x00U
 *
 * The reset values of the bits in the RSTFLTSEL field are for Chip POR only.
 * They are unaffected by other reset types.
 */
/*!
 * @name Constants and macros for entire RCM_RPFW register
 */
/*@{*/
#define RCM_RD_RPFW(base)        (RCM_RPFW_REG(base))
#define RCM_WR_RPFW(base, value) (RCM_RPFW_REG(base) = (value))
#define RCM_RMW_RPFW(base, mask, value) (RCM_WR_RPFW(base, (RCM_RD_RPFW(base) & ~(mask)) | (value)))
#define RCM_SET_RPFW(base, value) (BME_OR8(&RCM_RPFW_REG(base), (uint8_t)(value)))
#define RCM_CLR_RPFW(base, value) (BME_AND8(&RCM_RPFW_REG(base), (uint8_t)(~(value))))
#define RCM_TOG_RPFW(base, value) (BME_XOR8(&RCM_RPFW_REG(base), (uint8_t)(value)))
/*@}*/

/*
 * Constants & macros for individual RCM_RPFW bitfields
 */

/*!
 * @name Register RCM_RPFW, field RSTFLTSEL[4:0] (RW)
 *
 * Selects the reset pin bus clock filter width.
 *
 * Values:
 * - 00000 - Bus clock filter count is 1
 * - 00001 - Bus clock filter count is 2
 * - 00010 - Bus clock filter count is 3
 * - 00011 - Bus clock filter count is 4
 * - 00100 - Bus clock filter count is 5
 * - 00101 - Bus clock filter count is 6
 * - 00110 - Bus clock filter count is 7
 * - 00111 - Bus clock filter count is 8
 * - 01000 - Bus clock filter count is 9
 * - 01001 - Bus clock filter count is 10
 * - 01010 - Bus clock filter count is 11
 * - 01011 - Bus clock filter count is 12
 * - 01100 - Bus clock filter count is 13
 * - 01101 - Bus clock filter count is 14
 * - 01110 - Bus clock filter count is 15
 * - 01111 - Bus clock filter count is 16
 * - 10000 - Bus clock filter count is 17
 * - 10001 - Bus clock filter count is 18
 * - 10010 - Bus clock filter count is 19
 * - 10011 - Bus clock filter count is 20
 * - 10100 - Bus clock filter count is 21
 * - 10101 - Bus clock filter count is 22
 * - 10110 - Bus clock filter count is 23
 * - 10111 - Bus clock filter count is 24
 * - 11000 - Bus clock filter count is 25
 * - 11001 - Bus clock filter count is 26
 * - 11010 - Bus clock filter count is 27
 * - 11011 - Bus clock filter count is 28
 * - 11100 - Bus clock filter count is 29
 * - 11101 - Bus clock filter count is 30
 * - 11110 - Bus clock filter count is 31
 * - 11111 - Bus clock filter count is 32
 */
/*@{*/
/*! @brief Read current value of the RCM_RPFW_RSTFLTSEL field. */
#define RCM_RD_RPFW_RSTFLTSEL(base) ((RCM_RPFW_REG(base) & RCM_RPFW_RSTFLTSEL_MASK) >> RCM_RPFW_RSTFLTSEL_SHIFT)
#define RCM_BRD_RPFW_RSTFLTSEL(base) (BME_UBFX8(&RCM_RPFW_REG(base), RCM_RPFW_RSTFLTSEL_SHIFT, RCM_RPFW_RSTFLTSEL_WIDTH))

/*! @brief Set the RSTFLTSEL field to a new value. */
#define RCM_WR_RPFW_RSTFLTSEL(base, value) (RCM_RMW_RPFW(base, RCM_RPFW_RSTFLTSEL_MASK, RCM_RPFW_RSTFLTSEL(value)))
#define RCM_BWR_RPFW_RSTFLTSEL(base, value) (BME_BFI8(&RCM_RPFW_REG(base), ((uint8_t)(value) << RCM_RPFW_RSTFLTSEL_SHIFT), RCM_RPFW_RSTFLTSEL_SHIFT, RCM_RPFW_RSTFLTSEL_WIDTH))
/*@}*/

/*******************************************************************************
 * RCM_FM - Force Mode Register
 ******************************************************************************/

/*!
 * @brief RCM_FM - Force Mode Register (RW)
 *
 * Reset value: 0x00U
 *
 * The reset values of the bits in the FORCEROM field are for Chip POR only.
 * They are unaffected by other reset types.
 */
/*!
 * @name Constants and macros for entire RCM_FM register
 */
/*@{*/
#define RCM_RD_FM(base)          (RCM_FM_REG(base))
#define RCM_WR_FM(base, value)   (RCM_FM_REG(base) = (value))
#define RCM_RMW_FM(base, mask, value) (RCM_WR_FM(base, (RCM_RD_FM(base) & ~(mask)) | (value)))
#define RCM_SET_FM(base, value)  (BME_OR8(&RCM_FM_REG(base), (uint8_t)(value)))
#define RCM_CLR_FM(base, value)  (BME_AND8(&RCM_FM_REG(base), (uint8_t)(~(value))))
#define RCM_TOG_FM(base, value)  (BME_XOR8(&RCM_FM_REG(base), (uint8_t)(value)))
/*@}*/

/*
 * Constants & macros for individual RCM_FM bitfields
 */

/*!
 * @name Register RCM_FM, field FORCEROM[2:1] (RW)
 *
 * When either bit is set, will force boot from ROM during all subsequent system
 * resets.
 *
 * Values:
 * - 00 - No effect
 * - 01 - Force boot from ROM with RCM_MR[1] set.
 * - 10 - Force boot from ROM with RCM_MR[2] set.
 * - 11 - Force boot from ROM with RCM_MR[2:1] set.
 */
/*@{*/
/*! @brief Read current value of the RCM_FM_FORCEROM field. */
#define RCM_RD_FM_FORCEROM(base) ((RCM_FM_REG(base) & RCM_FM_FORCEROM_MASK) >> RCM_FM_FORCEROM_SHIFT)
#define RCM_BRD_FM_FORCEROM(base) (BME_UBFX8(&RCM_FM_REG(base), RCM_FM_FORCEROM_SHIFT, RCM_FM_FORCEROM_WIDTH))

/*! @brief Set the FORCEROM field to a new value. */
#define RCM_WR_FM_FORCEROM(base, value) (RCM_RMW_FM(base, RCM_FM_FORCEROM_MASK, RCM_FM_FORCEROM(value)))
#define RCM_BWR_FM_FORCEROM(base, value) (BME_BFI8(&RCM_FM_REG(base), ((uint8_t)(value) << RCM_FM_FORCEROM_SHIFT), RCM_FM_FORCEROM_SHIFT, RCM_FM_FORCEROM_WIDTH))
/*@}*/

/*******************************************************************************
 * RCM_MR - Mode Register
 ******************************************************************************/

/*!
 * @brief RCM_MR - Mode Register (RW)
 *
 * Reset value: 0x00U
 *
 * This register includes status flags to indicate the state of the mode pins
 * during the last Chip Reset.
 */
/*!
 * @name Constants and macros for entire RCM_MR register
 */
/*@{*/
#define RCM_RD_MR(base)          (RCM_MR_REG(base))
#define RCM_WR_MR(base, value)   (RCM_MR_REG(base) = (value))
#define RCM_RMW_MR(base, mask, value) (RCM_WR_MR(base, (RCM_RD_MR(base) & ~(mask)) | (value)))
#define RCM_SET_MR(base, value)  (BME_OR8(&RCM_MR_REG(base), (uint8_t)(value)))
#define RCM_CLR_MR(base, value)  (BME_AND8(&RCM_MR_REG(base), (uint8_t)(~(value))))
#define RCM_TOG_MR(base, value)  (BME_XOR8(&RCM_MR_REG(base), (uint8_t)(value)))
/*@}*/

/*
 * Constants & macros for individual RCM_MR bitfields
 */

/*!
 * @name Register RCM_MR, field BOOTROM[2:1] (W1C)
 *
 * Indicates the boot source, the boot source remains set until the next System
 * Reset or software can write logic one to clear the corresponding mode bit.
 * While either bit is set, the NMI input is disabled and the vector table is
 * relocated to the ROM base address at 0x1C00_0000. These bits should be cleared by
 * writing logic one before executing any code from either Flash or SRAM.
 *
 * Values:
 * - 00 - Boot from Flash
 * - 01 - Boot from ROM due to BOOTCFG0 pin assertion
 * - 10 - Boot form ROM due to FOPT[7] configuration
 * - 11 - Boot from ROM due to both BOOTCFG0 pin assertion and FOPT[7]
 *     configuration
 */
/*@{*/
/*! @brief Read current value of the RCM_MR_BOOTROM field. */
#define RCM_RD_MR_BOOTROM(base) ((RCM_MR_REG(base) & RCM_MR_BOOTROM_MASK) >> RCM_MR_BOOTROM_SHIFT)
#define RCM_BRD_MR_BOOTROM(base) (BME_UBFX8(&RCM_MR_REG(base), RCM_MR_BOOTROM_SHIFT, RCM_MR_BOOTROM_WIDTH))

/*! @brief Set the BOOTROM field to a new value. */
#define RCM_WR_MR_BOOTROM(base, value) (RCM_RMW_MR(base, RCM_MR_BOOTROM_MASK, RCM_MR_BOOTROM(value)))
#define RCM_BWR_MR_BOOTROM(base, value) (BME_BFI8(&RCM_MR_REG(base), ((uint8_t)(value) << RCM_MR_BOOTROM_SHIFT), RCM_MR_BOOTROM_SHIFT, RCM_MR_BOOTROM_WIDTH))
/*@}*/

/*******************************************************************************
 * RCM_SSRS0 - Sticky System Reset Status Register 0
 ******************************************************************************/

/*!
 * @brief RCM_SSRS0 - Sticky System Reset Status Register 0 (RW)
 *
 * Reset value: 0x82U
 *
 * This register includes status flags to indicate all reset sources since the
 * last POR, LVD or VLLS Wakeup that have not been cleared by software. Software
 * can clear the status flags by writing a logic one to a flag.
 */
/*!
 * @name Constants and macros for entire RCM_SSRS0 register
 */
/*@{*/
#define RCM_RD_SSRS0(base)       (RCM_SSRS0_REG(base))
#define RCM_WR_SSRS0(base, value) (RCM_SSRS0_REG(base) = (value))
#define RCM_RMW_SSRS0(base, mask, value) (RCM_WR_SSRS0(base, (RCM_RD_SSRS0(base) & ~(mask)) | (value)))
#define RCM_SET_SSRS0(base, value) (BME_OR8(&RCM_SSRS0_REG(base), (uint8_t)(value)))
#define RCM_CLR_SSRS0(base, value) (BME_AND8(&RCM_SSRS0_REG(base), (uint8_t)(~(value))))
#define RCM_TOG_SSRS0(base, value) (BME_XOR8(&RCM_SSRS0_REG(base), (uint8_t)(value)))
/*@}*/

/*
 * Constants & macros for individual RCM_SSRS0 bitfields
 */

/*!
 * @name Register RCM_SSRS0, field SWAKEUP[0] (W1C)
 *
 * Indicates a reset has been caused by an enabled LLWU modulewakeup source
 * while the chip was in a low leakage mode. In LLS mode, the RESET pin is the only
 * wakeup source that can cause this reset. Any enabled wakeup source in a VLLSx
 * mode causes a reset.
 *
 * Values:
 * - 0 - Reset not caused by LLWU module wakeup source
 * - 1 - Reset caused by LLWU module wakeup source
 */
/*@{*/
/*! @brief Read current value of the RCM_SSRS0_SWAKEUP field. */
#define RCM_RD_SSRS0_SWAKEUP(base) ((RCM_SSRS0_REG(base) & RCM_SSRS0_SWAKEUP_MASK) >> RCM_SSRS0_SWAKEUP_SHIFT)
#define RCM_BRD_SSRS0_SWAKEUP(base) (BME_UBFX8(&RCM_SSRS0_REG(base), RCM_SSRS0_SWAKEUP_SHIFT, RCM_SSRS0_SWAKEUP_WIDTH))

/*! @brief Set the SWAKEUP field to a new value. */
#define RCM_WR_SSRS0_SWAKEUP(base, value) (RCM_RMW_SSRS0(base, (RCM_SSRS0_SWAKEUP_MASK | RCM_SSRS0_SLVD_MASK | RCM_SSRS0_SWDOG_MASK | RCM_SSRS0_SPIN_MASK | RCM_SSRS0_SPOR_MASK), RCM_SSRS0_SWAKEUP(value)))
#define RCM_BWR_SSRS0_SWAKEUP(base, value) (BME_BFI8(&RCM_SSRS0_REG(base), ((uint8_t)(value) << RCM_SSRS0_SWAKEUP_SHIFT), RCM_SSRS0_SWAKEUP_SHIFT, RCM_SSRS0_SWAKEUP_WIDTH))
/*@}*/

/*!
 * @name Register RCM_SSRS0, field SLVD[1] (W1C)
 *
 * If PMC_LVDSC1[LVDRE] is set and the supply drops below the LVD trip voltage,
 * an LVD reset occurs. This field is also set by POR.
 *
 * Values:
 * - 0 - Reset not caused by LVD trip or POR
 * - 1 - Reset caused by LVD trip or POR
 */
/*@{*/
/*! @brief Read current value of the RCM_SSRS0_SLVD field. */
#define RCM_RD_SSRS0_SLVD(base) ((RCM_SSRS0_REG(base) & RCM_SSRS0_SLVD_MASK) >> RCM_SSRS0_SLVD_SHIFT)
#define RCM_BRD_SSRS0_SLVD(base) (BME_UBFX8(&RCM_SSRS0_REG(base), RCM_SSRS0_SLVD_SHIFT, RCM_SSRS0_SLVD_WIDTH))

/*! @brief Set the SLVD field to a new value. */
#define RCM_WR_SSRS0_SLVD(base, value) (RCM_RMW_SSRS0(base, (RCM_SSRS0_SLVD_MASK | RCM_SSRS0_SWAKEUP_MASK | RCM_SSRS0_SWDOG_MASK | RCM_SSRS0_SPIN_MASK | RCM_SSRS0_SPOR_MASK), RCM_SSRS0_SLVD(value)))
#define RCM_BWR_SSRS0_SLVD(base, value) (BME_BFI8(&RCM_SSRS0_REG(base), ((uint8_t)(value) << RCM_SSRS0_SLVD_SHIFT), RCM_SSRS0_SLVD_SHIFT, RCM_SSRS0_SLVD_WIDTH))
/*@}*/

/*!
 * @name Register RCM_SSRS0, field SWDOG[5] (W1C)
 *
 * Indicates a reset has been caused by the watchdog timer Computer Operating
 * Properly (COP) timing out. This reset source can be blocked by disabling the COP
 * watchdog: write 00 to the SIM's COPC[COPT] field.
 *
 * Values:
 * - 0 - Reset not caused by watchdog timeout
 * - 1 - Reset caused by watchdog timeout
 */
/*@{*/
/*! @brief Read current value of the RCM_SSRS0_SWDOG field. */
#define RCM_RD_SSRS0_SWDOG(base) ((RCM_SSRS0_REG(base) & RCM_SSRS0_SWDOG_MASK) >> RCM_SSRS0_SWDOG_SHIFT)
#define RCM_BRD_SSRS0_SWDOG(base) (BME_UBFX8(&RCM_SSRS0_REG(base), RCM_SSRS0_SWDOG_SHIFT, RCM_SSRS0_SWDOG_WIDTH))

/*! @brief Set the SWDOG field to a new value. */
#define RCM_WR_SSRS0_SWDOG(base, value) (RCM_RMW_SSRS0(base, (RCM_SSRS0_SWDOG_MASK | RCM_SSRS0_SWAKEUP_MASK | RCM_SSRS0_SLVD_MASK | RCM_SSRS0_SPIN_MASK | RCM_SSRS0_SPOR_MASK), RCM_SSRS0_SWDOG(value)))
#define RCM_BWR_SSRS0_SWDOG(base, value) (BME_BFI8(&RCM_SSRS0_REG(base), ((uint8_t)(value) << RCM_SSRS0_SWDOG_SHIFT), RCM_SSRS0_SWDOG_SHIFT, RCM_SSRS0_SWDOG_WIDTH))
/*@}*/

/*!
 * @name Register RCM_SSRS0, field SPIN[6] (W1C)
 *
 * Indicates a reset has been caused by an active-low level on the external
 * RESET pin.
 *
 * Values:
 * - 0 - Reset not caused by external reset pin
 * - 1 - Reset caused by external reset pin
 */
/*@{*/
/*! @brief Read current value of the RCM_SSRS0_SPIN field. */
#define RCM_RD_SSRS0_SPIN(base) ((RCM_SSRS0_REG(base) & RCM_SSRS0_SPIN_MASK) >> RCM_SSRS0_SPIN_SHIFT)
#define RCM_BRD_SSRS0_SPIN(base) (BME_UBFX8(&RCM_SSRS0_REG(base), RCM_SSRS0_SPIN_SHIFT, RCM_SSRS0_SPIN_WIDTH))

/*! @brief Set the SPIN field to a new value. */
#define RCM_WR_SSRS0_SPIN(base, value) (RCM_RMW_SSRS0(base, (RCM_SSRS0_SPIN_MASK | RCM_SSRS0_SWAKEUP_MASK | RCM_SSRS0_SLVD_MASK | RCM_SSRS0_SWDOG_MASK | RCM_SSRS0_SPOR_MASK), RCM_SSRS0_SPIN(value)))
#define RCM_BWR_SSRS0_SPIN(base, value) (BME_BFI8(&RCM_SSRS0_REG(base), ((uint8_t)(value) << RCM_SSRS0_SPIN_SHIFT), RCM_SSRS0_SPIN_SHIFT, RCM_SSRS0_SPIN_WIDTH))
/*@}*/

/*!
 * @name Register RCM_SSRS0, field SPOR[7] (W1C)
 *
 * Indicates a reset has been caused by the power-on detection logic. Because
 * the internal supply voltage was ramping up at the time, the low-voltage reset
 * (LVD) status bit is also set to indicate that the reset occurred while the
 * internal supply was below the LVD threshold.
 *
 * Values:
 * - 0 - Reset not caused by POR
 * - 1 - Reset caused by POR
 */
/*@{*/
/*! @brief Read current value of the RCM_SSRS0_SPOR field. */
#define RCM_RD_SSRS0_SPOR(base) ((RCM_SSRS0_REG(base) & RCM_SSRS0_SPOR_MASK) >> RCM_SSRS0_SPOR_SHIFT)
#define RCM_BRD_SSRS0_SPOR(base) (BME_UBFX8(&RCM_SSRS0_REG(base), RCM_SSRS0_SPOR_SHIFT, RCM_SSRS0_SPOR_WIDTH))

/*! @brief Set the SPOR field to a new value. */
#define RCM_WR_SSRS0_SPOR(base, value) (RCM_RMW_SSRS0(base, (RCM_SSRS0_SPOR_MASK | RCM_SSRS0_SWAKEUP_MASK | RCM_SSRS0_SLVD_MASK | RCM_SSRS0_SWDOG_MASK | RCM_SSRS0_SPIN_MASK), RCM_SSRS0_SPOR(value)))
#define RCM_BWR_SSRS0_SPOR(base, value) (BME_BFI8(&RCM_SSRS0_REG(base), ((uint8_t)(value) << RCM_SSRS0_SPOR_SHIFT), RCM_SSRS0_SPOR_SHIFT, RCM_SSRS0_SPOR_WIDTH))
/*@}*/

/*******************************************************************************
 * RCM_SSRS1 - Sticky System Reset Status Register 1
 ******************************************************************************/

/*!
 * @brief RCM_SSRS1 - Sticky System Reset Status Register 1 (RW)
 *
 * Reset value: 0x00U
 *
 * This register includes status flags to indicate all reset sources since the
 * last POR, LVD or VLLS Wakeup that have not been cleared by software. Software
 * can clear the status flags by writing a logic one to a flag.
 */
/*!
 * @name Constants and macros for entire RCM_SSRS1 register
 */
/*@{*/
#define RCM_RD_SSRS1(base)       (RCM_SSRS1_REG(base))
#define RCM_WR_SSRS1(base, value) (RCM_SSRS1_REG(base) = (value))
#define RCM_RMW_SSRS1(base, mask, value) (RCM_WR_SSRS1(base, (RCM_RD_SSRS1(base) & ~(mask)) | (value)))
#define RCM_SET_SSRS1(base, value) (BME_OR8(&RCM_SSRS1_REG(base), (uint8_t)(value)))
#define RCM_CLR_SSRS1(base, value) (BME_AND8(&RCM_SSRS1_REG(base), (uint8_t)(~(value))))
#define RCM_TOG_SSRS1(base, value) (BME_XOR8(&RCM_SSRS1_REG(base), (uint8_t)(value)))
/*@}*/

/*
 * Constants & macros for individual RCM_SSRS1 bitfields
 */

/*!
 * @name Register RCM_SSRS1, field SLOCKUP[1] (W1C)
 *
 * Indicates a reset has been caused by the ARM core indication of a LOCKUP
 * event.
 *
 * Values:
 * - 0 - Reset not caused by core LOCKUP event
 * - 1 - Reset caused by core LOCKUP event
 */
/*@{*/
/*! @brief Read current value of the RCM_SSRS1_SLOCKUP field. */
#define RCM_RD_SSRS1_SLOCKUP(base) ((RCM_SSRS1_REG(base) & RCM_SSRS1_SLOCKUP_MASK) >> RCM_SSRS1_SLOCKUP_SHIFT)
#define RCM_BRD_SSRS1_SLOCKUP(base) (BME_UBFX8(&RCM_SSRS1_REG(base), RCM_SSRS1_SLOCKUP_SHIFT, RCM_SSRS1_SLOCKUP_WIDTH))

/*! @brief Set the SLOCKUP field to a new value. */
#define RCM_WR_SSRS1_SLOCKUP(base, value) (RCM_RMW_SSRS1(base, (RCM_SSRS1_SLOCKUP_MASK | RCM_SSRS1_SSW_MASK | RCM_SSRS1_SMDM_AP_MASK | RCM_SSRS1_SSACKERR_MASK), RCM_SSRS1_SLOCKUP(value)))
#define RCM_BWR_SSRS1_SLOCKUP(base, value) (BME_BFI8(&RCM_SSRS1_REG(base), ((uint8_t)(value) << RCM_SSRS1_SLOCKUP_SHIFT), RCM_SSRS1_SLOCKUP_SHIFT, RCM_SSRS1_SLOCKUP_WIDTH))
/*@}*/

/*!
 * @name Register RCM_SSRS1, field SSW[2] (W1C)
 *
 * Indicates a reset has been caused by software setting of SYSRESETREQ bit in
 * Application Interrupt and Reset Control Register in the ARM core.
 *
 * Values:
 * - 0 - Reset not caused by software setting of SYSRESETREQ bit
 * - 1 - Reset caused by software setting of SYSRESETREQ bit
 */
/*@{*/
/*! @brief Read current value of the RCM_SSRS1_SSW field. */
#define RCM_RD_SSRS1_SSW(base) ((RCM_SSRS1_REG(base) & RCM_SSRS1_SSW_MASK) >> RCM_SSRS1_SSW_SHIFT)
#define RCM_BRD_SSRS1_SSW(base) (BME_UBFX8(&RCM_SSRS1_REG(base), RCM_SSRS1_SSW_SHIFT, RCM_SSRS1_SSW_WIDTH))

/*! @brief Set the SSW field to a new value. */
#define RCM_WR_SSRS1_SSW(base, value) (RCM_RMW_SSRS1(base, (RCM_SSRS1_SSW_MASK | RCM_SSRS1_SLOCKUP_MASK | RCM_SSRS1_SMDM_AP_MASK | RCM_SSRS1_SSACKERR_MASK), RCM_SSRS1_SSW(value)))
#define RCM_BWR_SSRS1_SSW(base, value) (BME_BFI8(&RCM_SSRS1_REG(base), ((uint8_t)(value) << RCM_SSRS1_SSW_SHIFT), RCM_SSRS1_SSW_SHIFT, RCM_SSRS1_SSW_WIDTH))
/*@}*/

/*!
 * @name Register RCM_SSRS1, field SMDM_AP[3] (W1C)
 *
 * Indicates a reset has been caused by the host debugger system setting of the
 * System Reset Request bit in the MDM-AP Control Register.
 *
 * Values:
 * - 0 - Reset not caused by host debugger system setting of the System Reset
 *     Request bit
 * - 1 - Reset caused by host debugger system setting of the System Reset
 *     Request bit
 */
/*@{*/
/*! @brief Read current value of the RCM_SSRS1_SMDM_AP field. */
#define RCM_RD_SSRS1_SMDM_AP(base) ((RCM_SSRS1_REG(base) & RCM_SSRS1_SMDM_AP_MASK) >> RCM_SSRS1_SMDM_AP_SHIFT)
#define RCM_BRD_SSRS1_SMDM_AP(base) (BME_UBFX8(&RCM_SSRS1_REG(base), RCM_SSRS1_SMDM_AP_SHIFT, RCM_SSRS1_SMDM_AP_WIDTH))

/*! @brief Set the SMDM_AP field to a new value. */
#define RCM_WR_SSRS1_SMDM_AP(base, value) (RCM_RMW_SSRS1(base, (RCM_SSRS1_SMDM_AP_MASK | RCM_SSRS1_SLOCKUP_MASK | RCM_SSRS1_SSW_MASK | RCM_SSRS1_SSACKERR_MASK), RCM_SSRS1_SMDM_AP(value)))
#define RCM_BWR_SSRS1_SMDM_AP(base, value) (BME_BFI8(&RCM_SSRS1_REG(base), ((uint8_t)(value) << RCM_SSRS1_SMDM_AP_SHIFT), RCM_SSRS1_SMDM_AP_SHIFT, RCM_SSRS1_SMDM_AP_WIDTH))
/*@}*/

/*!
 * @name Register RCM_SSRS1, field SSACKERR[5] (W1C)
 *
 * Indicates that after an attempt to enter Stop mode, a reset has been caused
 * by a failure of one or more peripherals to acknowledge within approximately one
 * second to enter stop mode.
 *
 * Values:
 * - 0 - Reset not caused by peripheral failure to acknowledge attempt to enter
 *     stop mode
 * - 1 - Reset caused by peripheral failure to acknowledge attempt to enter stop
 *     mode
 */
/*@{*/
/*! @brief Read current value of the RCM_SSRS1_SSACKERR field. */
#define RCM_RD_SSRS1_SSACKERR(base) ((RCM_SSRS1_REG(base) & RCM_SSRS1_SSACKERR_MASK) >> RCM_SSRS1_SSACKERR_SHIFT)
#define RCM_BRD_SSRS1_SSACKERR(base) (BME_UBFX8(&RCM_SSRS1_REG(base), RCM_SSRS1_SSACKERR_SHIFT, RCM_SSRS1_SSACKERR_WIDTH))

/*! @brief Set the SSACKERR field to a new value. */
#define RCM_WR_SSRS1_SSACKERR(base, value) (RCM_RMW_SSRS1(base, (RCM_SSRS1_SSACKERR_MASK | RCM_SSRS1_SLOCKUP_MASK | RCM_SSRS1_SSW_MASK | RCM_SSRS1_SMDM_AP_MASK), RCM_SSRS1_SSACKERR(value)))
#define RCM_BWR_SSRS1_SSACKERR(base, value) (BME_BFI8(&RCM_SSRS1_REG(base), ((uint8_t)(value) << RCM_SSRS1_SSACKERR_SHIFT), RCM_SSRS1_SSACKERR_SHIFT, RCM_SSRS1_SSACKERR_WIDTH))
/*@}*/

/*
 * MKL27Z644 RFSYS
 *
 * System register file
 *
 * Registers defined in this header file:
 * - RFSYS_REG - Register file register
 */

#define RFSYS_INSTANCE_COUNT (1U) /*!< Number of instances of the RFSYS module. */
#define RFSYS_IDX (0U) /*!< Instance number for RFSYS. */

/*******************************************************************************
 * RFSYS_REG - Register file register
 ******************************************************************************/

/*!
 * @brief RFSYS_REG - Register file register (RW)
 *
 * Reset value: 0x00000000U
 *
 * Each register can be accessed as 8-, 16-, or 32-bits.
 */
/*!
 * @name Constants and macros for entire RFSYS_REG register
 */
/*@{*/
#define RFSYS_RD_REG(base, index) (RFSYS_REG_REG(base, index))
#define RFSYS_WR_REG(base, index, value) (RFSYS_REG_REG(base, index) = (value))
#define RFSYS_RMW_REG(base, index, mask, value) (RFSYS_WR_REG(base, index, (RFSYS_RD_REG(base, index) & ~(mask)) | (value)))
#define RFSYS_SET_REG(base, index, value) (BME_OR32(&RFSYS_REG_REG(base, index), (uint32_t)(value)))
#define RFSYS_CLR_REG(base, index, value) (BME_AND32(&RFSYS_REG_REG(base, index), (uint32_t)(~(value))))
#define RFSYS_TOG_REG(base, index, value) (BME_XOR32(&RFSYS_REG_REG(base, index), (uint32_t)(value)))
/*@}*/

/*
 * Constants & macros for individual RFSYS_REG bitfields
 */

/*!
 * @name Register RFSYS_REG, field LL[7:0] (RW)
 *
 * Low lower byte
 */
/*@{*/
/*! @brief Read current value of the RFSYS_REG_LL field. */
#define RFSYS_RD_REG_LL(base, index) ((RFSYS_REG_REG(base, index) & RFSYS_REG_LL_MASK) >> RFSYS_REG_LL_SHIFT)
#define RFSYS_BRD_REG_LL(base, index) (BME_UBFX32(&RFSYS_REG_REG(base, index), RFSYS_REG_LL_SHIFT, RFSYS_REG_LL_WIDTH))

/*! @brief Set the LL field to a new value. */
#define RFSYS_WR_REG_LL(base, index, value) (RFSYS_RMW_REG(base, index, RFSYS_REG_LL_MASK, RFSYS_REG_LL(value)))
#define RFSYS_BWR_REG_LL(base, index, value) (BME_BFI32(&RFSYS_REG_REG(base, index), ((uint32_t)(value) << RFSYS_REG_LL_SHIFT), RFSYS_REG_LL_SHIFT, RFSYS_REG_LL_WIDTH))
/*@}*/

/*!
 * @name Register RFSYS_REG, field LH[15:8] (RW)
 *
 * Low higher byte
 */
/*@{*/
/*! @brief Read current value of the RFSYS_REG_LH field. */
#define RFSYS_RD_REG_LH(base, index) ((RFSYS_REG_REG(base, index) & RFSYS_REG_LH_MASK) >> RFSYS_REG_LH_SHIFT)
#define RFSYS_BRD_REG_LH(base, index) (BME_UBFX32(&RFSYS_REG_REG(base, index), RFSYS_REG_LH_SHIFT, RFSYS_REG_LH_WIDTH))

/*! @brief Set the LH field to a new value. */
#define RFSYS_WR_REG_LH(base, index, value) (RFSYS_RMW_REG(base, index, RFSYS_REG_LH_MASK, RFSYS_REG_LH(value)))
#define RFSYS_BWR_REG_LH(base, index, value) (BME_BFI32(&RFSYS_REG_REG(base, index), ((uint32_t)(value) << RFSYS_REG_LH_SHIFT), RFSYS_REG_LH_SHIFT, RFSYS_REG_LH_WIDTH))
/*@}*/

/*!
 * @name Register RFSYS_REG, field HL[23:16] (RW)
 *
 * High lower byte
 */
/*@{*/
/*! @brief Read current value of the RFSYS_REG_HL field. */
#define RFSYS_RD_REG_HL(base, index) ((RFSYS_REG_REG(base, index) & RFSYS_REG_HL_MASK) >> RFSYS_REG_HL_SHIFT)
#define RFSYS_BRD_REG_HL(base, index) (BME_UBFX32(&RFSYS_REG_REG(base, index), RFSYS_REG_HL_SHIFT, RFSYS_REG_HL_WIDTH))

/*! @brief Set the HL field to a new value. */
#define RFSYS_WR_REG_HL(base, index, value) (RFSYS_RMW_REG(base, index, RFSYS_REG_HL_MASK, RFSYS_REG_HL(value)))
#define RFSYS_BWR_REG_HL(base, index, value) (BME_BFI32(&RFSYS_REG_REG(base, index), ((uint32_t)(value) << RFSYS_REG_HL_SHIFT), RFSYS_REG_HL_SHIFT, RFSYS_REG_HL_WIDTH))
/*@}*/

/*!
 * @name Register RFSYS_REG, field HH[31:24] (RW)
 *
 * High higher byte
 */
/*@{*/
/*! @brief Read current value of the RFSYS_REG_HH field. */
#define RFSYS_RD_REG_HH(base, index) ((RFSYS_REG_REG(base, index) & RFSYS_REG_HH_MASK) >> RFSYS_REG_HH_SHIFT)
#define RFSYS_BRD_REG_HH(base, index) (BME_UBFX32(&RFSYS_REG_REG(base, index), RFSYS_REG_HH_SHIFT, RFSYS_REG_HH_WIDTH))

/*! @brief Set the HH field to a new value. */
#define RFSYS_WR_REG_HH(base, index, value) (RFSYS_RMW_REG(base, index, RFSYS_REG_HH_MASK, RFSYS_REG_HH(value)))
#define RFSYS_BWR_REG_HH(base, index, value) (BME_BFI32(&RFSYS_REG_REG(base, index), ((uint32_t)(value) << RFSYS_REG_HH_SHIFT), RFSYS_REG_HH_SHIFT, RFSYS_REG_HH_WIDTH))
/*@}*/

/*
 * MKL27Z644 ROM
 *
 * System ROM
 *
 * Registers defined in this header file:
 * - ROM_ENTRY - Entry
 * - ROM_TABLEMARK - End of Table Marker Register
 * - ROM_SYSACCESS - System Access Register
 * - ROM_PERIPHID4 - Peripheral ID Register
 * - ROM_PERIPHID5 - Peripheral ID Register
 * - ROM_PERIPHID6 - Peripheral ID Register
 * - ROM_PERIPHID7 - Peripheral ID Register
 * - ROM_PERIPHID0 - Peripheral ID Register
 * - ROM_PERIPHID1 - Peripheral ID Register
 * - ROM_PERIPHID2 - Peripheral ID Register
 * - ROM_PERIPHID3 - Peripheral ID Register
 * - ROM_COMPID - Component ID Register
 */

#define ROM_INSTANCE_COUNT (1U) /*!< Number of instances of the ROM module. */
#define ROM_IDX (0U) /*!< Instance number for ROM. */

/*******************************************************************************
 * ROM_ENTRY - Entry
 ******************************************************************************/

/*!
 * @brief ROM_ENTRY - Entry (RO)
 *
 * Reset value: 0x00000000U
 *
 * The System ROM Table begins with "n" relative 32-bit addresses, one for each
 * debug component present in the device and terminating with an all-zero value
 * signaling the end of the table at the "n+1"-th value. It is hardwired to
 * specific values used during the auto-discovery process by an external debug agent.
 */
/*!
 * @name Constants and macros for entire ROM_ENTRY register
 */
/*@{*/
#define ROM_RD_ENTRY(base, index) (ROM_ENTRY_REG(base, index))
/*@}*/

/*******************************************************************************
 * ROM_TABLEMARK - End of Table Marker Register
 ******************************************************************************/

/*!
 * @brief ROM_TABLEMARK - End of Table Marker Register (RO)
 *
 * Reset value: 0x00000000U
 *
 * This register indicates end of table marker. It is hardwired to specific
 * values used during the auto-discovery process by an external debug agent.
 */
/*!
 * @name Constants and macros for entire ROM_TABLEMARK register
 */
/*@{*/
#define ROM_RD_TABLEMARK(base)   (ROM_TABLEMARK_REG(base))
/*@}*/

/*******************************************************************************
 * ROM_SYSACCESS - System Access Register
 ******************************************************************************/

/*!
 * @brief ROM_SYSACCESS - System Access Register (RO)
 *
 * Reset value: 0x00000001U
 *
 * This register indicates system access. It is hardwired to specific values
 * used during the auto-discovery process by an external debug agent.
 */
/*!
 * @name Constants and macros for entire ROM_SYSACCESS register
 */
/*@{*/
#define ROM_RD_SYSACCESS(base)   (ROM_SYSACCESS_REG(base))
/*@}*/

/*******************************************************************************
 * ROM_PERIPHID4 - Peripheral ID Register
 ******************************************************************************/

/*!
 * @brief ROM_PERIPHID4 - Peripheral ID Register (RO)
 *
 * Reset value: 0x00000000U
 *
 * These registers indicate the peripheral IDs. They are hardwired to specific
 * values used during the auto-discovery process by an external debug agent.
 */
/*!
 * @name Constants and macros for entire ROM_PERIPHID4 register
 */
/*@{*/
#define ROM_RD_PERIPHID4(base)   (ROM_PERIPHID4_REG(base))
/*@}*/

/*******************************************************************************
 * ROM_PERIPHID5 - Peripheral ID Register
 ******************************************************************************/

/*!
 * @brief ROM_PERIPHID5 - Peripheral ID Register (RO)
 *
 * Reset value: 0x00000000U
 *
 * These registers indicate the peripheral IDs. They are hardwired to specific
 * values used during the auto-discovery process by an external debug agent.
 */
/*!
 * @name Constants and macros for entire ROM_PERIPHID5 register
 */
/*@{*/
#define ROM_RD_PERIPHID5(base)   (ROM_PERIPHID5_REG(base))
/*@}*/

/*******************************************************************************
 * ROM_PERIPHID6 - Peripheral ID Register
 ******************************************************************************/

/*!
 * @brief ROM_PERIPHID6 - Peripheral ID Register (RO)
 *
 * Reset value: 0x00000000U
 *
 * These registers indicate the peripheral IDs. They are hardwired to specific
 * values used during the auto-discovery process by an external debug agent.
 */
/*!
 * @name Constants and macros for entire ROM_PERIPHID6 register
 */
/*@{*/
#define ROM_RD_PERIPHID6(base)   (ROM_PERIPHID6_REG(base))
/*@}*/

/*******************************************************************************
 * ROM_PERIPHID7 - Peripheral ID Register
 ******************************************************************************/

/*!
 * @brief ROM_PERIPHID7 - Peripheral ID Register (RO)
 *
 * Reset value: 0x00000000U
 *
 * These registers indicate the peripheral IDs. They are hardwired to specific
 * values used during the auto-discovery process by an external debug agent.
 */
/*!
 * @name Constants and macros for entire ROM_PERIPHID7 register
 */
/*@{*/
#define ROM_RD_PERIPHID7(base)   (ROM_PERIPHID7_REG(base))
/*@}*/

/*******************************************************************************
 * ROM_PERIPHID0 - Peripheral ID Register
 ******************************************************************************/

/*!
 * @brief ROM_PERIPHID0 - Peripheral ID Register (RO)
 *
 * Reset value: 0x00000000U
 *
 * These registers indicate the peripheral IDs. They are hardwired to specific
 * values used during the auto-discovery process by an external debug agent.
 */
/*!
 * @name Constants and macros for entire ROM_PERIPHID0 register
 */
/*@{*/
#define ROM_RD_PERIPHID0(base)   (ROM_PERIPHID0_REG(base))
/*@}*/

/*******************************************************************************
 * ROM_PERIPHID1 - Peripheral ID Register
 ******************************************************************************/

/*!
 * @brief ROM_PERIPHID1 - Peripheral ID Register (RO)
 *
 * Reset value: 0x00000000U
 *
 * These registers indicate the peripheral IDs. They are hardwired to specific
 * values used during the auto-discovery process by an external debug agent.
 */
/*!
 * @name Constants and macros for entire ROM_PERIPHID1 register
 */
/*@{*/
#define ROM_RD_PERIPHID1(base)   (ROM_PERIPHID1_REG(base))
/*@}*/

/*******************************************************************************
 * ROM_PERIPHID2 - Peripheral ID Register
 ******************************************************************************/

/*!
 * @brief ROM_PERIPHID2 - Peripheral ID Register (RO)
 *
 * Reset value: 0x00000000U
 *
 * These registers indicate the peripheral IDs. They are hardwired to specific
 * values used during the auto-discovery process by an external debug agent.
 */
/*!
 * @name Constants and macros for entire ROM_PERIPHID2 register
 */
/*@{*/
#define ROM_RD_PERIPHID2(base)   (ROM_PERIPHID2_REG(base))
/*@}*/

/*******************************************************************************
 * ROM_PERIPHID3 - Peripheral ID Register
 ******************************************************************************/

/*!
 * @brief ROM_PERIPHID3 - Peripheral ID Register (RO)
 *
 * Reset value: 0x00000000U
 *
 * These registers indicate the peripheral IDs. They are hardwired to specific
 * values used during the auto-discovery process by an external debug agent.
 */
/*!
 * @name Constants and macros for entire ROM_PERIPHID3 register
 */
/*@{*/
#define ROM_RD_PERIPHID3(base)   (ROM_PERIPHID3_REG(base))
/*@}*/

/*******************************************************************************
 * ROM_COMPID - Component ID Register
 ******************************************************************************/

/*!
 * @brief ROM_COMPID - Component ID Register (RO)
 *
 * Reset value: 0x00000000U
 *
 * These registers indicate the component IDs. They are hardwired to specific
 * values used during the auto-discovery process by an external debug agent.
 */
/*!
 * @name Constants and macros for entire ROM_COMPID register
 */
/*@{*/
#define ROM_RD_COMPID(base, index) (ROM_COMPID_REG(base, index))
/*@}*/

/*
 * MKL27Z644 RTC
 *
 * Secure Real Time Clock
 *
 * Registers defined in this header file:
 * - RTC_TSR - RTC Time Seconds Register
 * - RTC_TPR - RTC Time Prescaler Register
 * - RTC_TAR - RTC Time Alarm Register
 * - RTC_TCR - RTC Time Compensation Register
 * - RTC_CR - RTC Control Register
 * - RTC_SR - RTC Status Register
 * - RTC_LR - RTC Lock Register
 * - RTC_IER - RTC Interrupt Enable Register
 */

#define RTC_INSTANCE_COUNT (1U) /*!< Number of instances of the RTC module. */
#define RTC_IDX (0U) /*!< Instance number for RTC. */

/*******************************************************************************
 * RTC_TSR - RTC Time Seconds Register
 ******************************************************************************/

/*!
 * @brief RTC_TSR - RTC Time Seconds Register (RW)
 *
 * Reset value: 0x00000000U
 */
/*!
 * @name Constants and macros for entire RTC_TSR register
 */
/*@{*/
#define RTC_RD_TSR(base)         (RTC_TSR_REG(base))
#define RTC_WR_TSR(base, value)  (RTC_TSR_REG(base) = (value))
#define RTC_RMW_TSR(base, mask, value) (RTC_WR_TSR(base, (RTC_RD_TSR(base) & ~(mask)) | (value)))
#define RTC_SET_TSR(base, value) (BME_OR32(&RTC_TSR_REG(base), (uint32_t)(value)))
#define RTC_CLR_TSR(base, value) (BME_AND32(&RTC_TSR_REG(base), (uint32_t)(~(value))))
#define RTC_TOG_TSR(base, value) (BME_XOR32(&RTC_TSR_REG(base), (uint32_t)(value)))
/*@}*/

/*******************************************************************************
 * RTC_TPR - RTC Time Prescaler Register
 ******************************************************************************/

/*!
 * @brief RTC_TPR - RTC Time Prescaler Register (RW)
 *
 * Reset value: 0x00000000U
 */
/*!
 * @name Constants and macros for entire RTC_TPR register
 */
/*@{*/
#define RTC_RD_TPR(base)         (RTC_TPR_REG(base))
#define RTC_WR_TPR(base, value)  (RTC_TPR_REG(base) = (value))
#define RTC_RMW_TPR(base, mask, value) (RTC_WR_TPR(base, (RTC_RD_TPR(base) & ~(mask)) | (value)))
#define RTC_SET_TPR(base, value) (BME_OR32(&RTC_TPR_REG(base), (uint32_t)(value)))
#define RTC_CLR_TPR(base, value) (BME_AND32(&RTC_TPR_REG(base), (uint32_t)(~(value))))
#define RTC_TOG_TPR(base, value) (BME_XOR32(&RTC_TPR_REG(base), (uint32_t)(value)))
/*@}*/

/*
 * Constants & macros for individual RTC_TPR bitfields
 */

/*!
 * @name Register RTC_TPR, field TPR[15:0] (RW)
 *
 * When the time counter is enabled, the TPR is read only and increments every
 * 32.768 kHz clock cycle. The time counter will read as zero when SR[TOF] or
 * SR[TIF] are set. When the time counter is disabled, the TPR can be read or
 * written. The TSR[TSR] increments when bit 14 of the TPR transitions from a logic one
 * to a logic zero.
 */
/*@{*/
/*! @brief Read current value of the RTC_TPR_TPR field. */
#define RTC_RD_TPR_TPR(base) ((RTC_TPR_REG(base) & RTC_TPR_TPR_MASK) >> RTC_TPR_TPR_SHIFT)
#define RTC_BRD_TPR_TPR(base) (BME_UBFX32(&RTC_TPR_REG(base), RTC_TPR_TPR_SHIFT, RTC_TPR_TPR_WIDTH))

/*! @brief Set the TPR field to a new value. */
#define RTC_WR_TPR_TPR(base, value) (RTC_RMW_TPR(base, RTC_TPR_TPR_MASK, RTC_TPR_TPR(value)))
#define RTC_BWR_TPR_TPR(base, value) (BME_BFI32(&RTC_TPR_REG(base), ((uint32_t)(value) << RTC_TPR_TPR_SHIFT), RTC_TPR_TPR_SHIFT, RTC_TPR_TPR_WIDTH))
/*@}*/

/*******************************************************************************
 * RTC_TAR - RTC Time Alarm Register
 ******************************************************************************/

/*!
 * @brief RTC_TAR - RTC Time Alarm Register (RW)
 *
 * Reset value: 0x00000000U
 */
/*!
 * @name Constants and macros for entire RTC_TAR register
 */
/*@{*/
#define RTC_RD_TAR(base)         (RTC_TAR_REG(base))
#define RTC_WR_TAR(base, value)  (RTC_TAR_REG(base) = (value))
#define RTC_RMW_TAR(base, mask, value) (RTC_WR_TAR(base, (RTC_RD_TAR(base) & ~(mask)) | (value)))
#define RTC_SET_TAR(base, value) (BME_OR32(&RTC_TAR_REG(base), (uint32_t)(value)))
#define RTC_CLR_TAR(base, value) (BME_AND32(&RTC_TAR_REG(base), (uint32_t)(~(value))))
#define RTC_TOG_TAR(base, value) (BME_XOR32(&RTC_TAR_REG(base), (uint32_t)(value)))
/*@}*/

/*******************************************************************************
 * RTC_TCR - RTC Time Compensation Register
 ******************************************************************************/

/*!
 * @brief RTC_TCR - RTC Time Compensation Register (RW)
 *
 * Reset value: 0x00000000U
 */
/*!
 * @name Constants and macros for entire RTC_TCR register
 */
/*@{*/
#define RTC_RD_TCR(base)         (RTC_TCR_REG(base))
#define RTC_WR_TCR(base, value)  (RTC_TCR_REG(base) = (value))
#define RTC_RMW_TCR(base, mask, value) (RTC_WR_TCR(base, (RTC_RD_TCR(base) & ~(mask)) | (value)))
#define RTC_SET_TCR(base, value) (BME_OR32(&RTC_TCR_REG(base), (uint32_t)(value)))
#define RTC_CLR_TCR(base, value) (BME_AND32(&RTC_TCR_REG(base), (uint32_t)(~(value))))
#define RTC_TOG_TCR(base, value) (BME_XOR32(&RTC_TCR_REG(base), (uint32_t)(value)))
/*@}*/

/*
 * Constants & macros for individual RTC_TCR bitfields
 */

/*!
 * @name Register RTC_TCR, field TCR[7:0] (RW)
 *
 * Configures the number of 32.768 kHz clock cycles in each second. This
 * register is double buffered and writes do not take affect until the end of the
 * current compensation interval.
 *
 * Values:
 * - 10000000 - Time Prescaler Register overflows every 32896 clock cycles.
 * - 11111111 - Time Prescaler Register overflows every 32769 clock cycles.
 * - 0 - Time Prescaler Register overflows every 32768 clock cycles.
 * - 1 - Time Prescaler Register overflows every 32767 clock cycles.
 * - 1111111 - Time Prescaler Register overflows every 32641 clock cycles.
 */
/*@{*/
/*! @brief Read current value of the RTC_TCR_TCR field. */
#define RTC_RD_TCR_TCR(base) ((RTC_TCR_REG(base) & RTC_TCR_TCR_MASK) >> RTC_TCR_TCR_SHIFT)
#define RTC_BRD_TCR_TCR(base) (BME_UBFX32(&RTC_TCR_REG(base), RTC_TCR_TCR_SHIFT, RTC_TCR_TCR_WIDTH))

/*! @brief Set the TCR field to a new value. */
#define RTC_WR_TCR_TCR(base, value) (RTC_RMW_TCR(base, RTC_TCR_TCR_MASK, RTC_TCR_TCR(value)))
#define RTC_BWR_TCR_TCR(base, value) (BME_BFI32(&RTC_TCR_REG(base), ((uint32_t)(value) << RTC_TCR_TCR_SHIFT), RTC_TCR_TCR_SHIFT, RTC_TCR_TCR_WIDTH))
/*@}*/

/*!
 * @name Register RTC_TCR, field CIR[15:8] (RW)
 *
 * Configures the compensation interval in seconds from 1 to 256 to control how
 * frequently the TCR should adjust the number of 32.768 kHz cycles in each
 * second. The value written should be one less than the number of seconds. For
 * example, write zero to configure for a compensation interval of one second. This
 * register is double buffered and writes do not take affect until the end of the
 * current compensation interval.
 */
/*@{*/
/*! @brief Read current value of the RTC_TCR_CIR field. */
#define RTC_RD_TCR_CIR(base) ((RTC_TCR_REG(base) & RTC_TCR_CIR_MASK) >> RTC_TCR_CIR_SHIFT)
#define RTC_BRD_TCR_CIR(base) (BME_UBFX32(&RTC_TCR_REG(base), RTC_TCR_CIR_SHIFT, RTC_TCR_CIR_WIDTH))

/*! @brief Set the CIR field to a new value. */
#define RTC_WR_TCR_CIR(base, value) (RTC_RMW_TCR(base, RTC_TCR_CIR_MASK, RTC_TCR_CIR(value)))
#define RTC_BWR_TCR_CIR(base, value) (BME_BFI32(&RTC_TCR_REG(base), ((uint32_t)(value) << RTC_TCR_CIR_SHIFT), RTC_TCR_CIR_SHIFT, RTC_TCR_CIR_WIDTH))
/*@}*/

/*!
 * @name Register RTC_TCR, field TCV[23:16] (RO)
 *
 * Current value used by the compensation logic for the present second interval.
 * Updated once a second if the CIC equals 0 with the contents of the TCR field.
 * If the CIC does not equal zero then it is loaded with zero (compensation is
 * not enabled for that second increment).
 */
/*@{*/
/*! @brief Read current value of the RTC_TCR_TCV field. */
#define RTC_RD_TCR_TCV(base) ((RTC_TCR_REG(base) & RTC_TCR_TCV_MASK) >> RTC_TCR_TCV_SHIFT)
#define RTC_BRD_TCR_TCV(base) (BME_UBFX32(&RTC_TCR_REG(base), RTC_TCR_TCV_SHIFT, RTC_TCR_TCV_WIDTH))
/*@}*/

/*!
 * @name Register RTC_TCR, field CIC[31:24] (RO)
 *
 * Current value of the compensation interval counter. If the compensation
 * interval counter equals zero then it is loaded with the contents of the CIR. If the
 * CIC does not equal zero then it is decremented once a second.
 */
/*@{*/
/*! @brief Read current value of the RTC_TCR_CIC field. */
#define RTC_RD_TCR_CIC(base) ((RTC_TCR_REG(base) & RTC_TCR_CIC_MASK) >> RTC_TCR_CIC_SHIFT)
#define RTC_BRD_TCR_CIC(base) (BME_UBFX32(&RTC_TCR_REG(base), RTC_TCR_CIC_SHIFT, RTC_TCR_CIC_WIDTH))
/*@}*/

/*******************************************************************************
 * RTC_CR - RTC Control Register
 ******************************************************************************/

/*!
 * @brief RTC_CR - RTC Control Register (RW)
 *
 * Reset value: 0x00000000U
 */
/*!
 * @name Constants and macros for entire RTC_CR register
 */
/*@{*/
#define RTC_RD_CR(base)          (RTC_CR_REG(base))
#define RTC_WR_CR(base, value)   (RTC_CR_REG(base) = (value))
#define RTC_RMW_CR(base, mask, value) (RTC_WR_CR(base, (RTC_RD_CR(base) & ~(mask)) | (value)))
#define RTC_SET_CR(base, value)  (BME_OR32(&RTC_CR_REG(base), (uint32_t)(value)))
#define RTC_CLR_CR(base, value)  (BME_AND32(&RTC_CR_REG(base), (uint32_t)(~(value))))
#define RTC_TOG_CR(base, value)  (BME_XOR32(&RTC_CR_REG(base), (uint32_t)(value)))
/*@}*/

/*
 * Constants & macros for individual RTC_CR bitfields
 */

/*!
 * @name Register RTC_CR, field SWR[0] (RW)
 *
 * Values:
 * - 0 - No effect.
 * - 1 - Resets all RTC registers except for the SWR bit . The SWR bit is
 *     cleared by POR and by software explicitly clearing it.
 */
/*@{*/
/*! @brief Read current value of the RTC_CR_SWR field. */
#define RTC_RD_CR_SWR(base)  ((RTC_CR_REG(base) & RTC_CR_SWR_MASK) >> RTC_CR_SWR_SHIFT)
#define RTC_BRD_CR_SWR(base) (BME_UBFX32(&RTC_CR_REG(base), RTC_CR_SWR_SHIFT, RTC_CR_SWR_WIDTH))

/*! @brief Set the SWR field to a new value. */
#define RTC_WR_CR_SWR(base, value) (RTC_RMW_CR(base, RTC_CR_SWR_MASK, RTC_CR_SWR(value)))
#define RTC_BWR_CR_SWR(base, value) (BME_BFI32(&RTC_CR_REG(base), ((uint32_t)(value) << RTC_CR_SWR_SHIFT), RTC_CR_SWR_SHIFT, RTC_CR_SWR_WIDTH))
/*@}*/

/*!
 * @name Register RTC_CR, field WPE[1] (RW)
 *
 * The wakeup pin is optional and not available on all devices.
 *
 * Values:
 * - 0 - Wakeup pin is disabled.
 * - 1 - Wakeup pin is enabled and wakeup pin asserts if the RTC interrupt
 *     asserts or the wakeup pin is turned on.
 */
/*@{*/
/*! @brief Read current value of the RTC_CR_WPE field. */
#define RTC_RD_CR_WPE(base)  ((RTC_CR_REG(base) & RTC_CR_WPE_MASK) >> RTC_CR_WPE_SHIFT)
#define RTC_BRD_CR_WPE(base) (BME_UBFX32(&RTC_CR_REG(base), RTC_CR_WPE_SHIFT, RTC_CR_WPE_WIDTH))

/*! @brief Set the WPE field to a new value. */
#define RTC_WR_CR_WPE(base, value) (RTC_RMW_CR(base, RTC_CR_WPE_MASK, RTC_CR_WPE(value)))
#define RTC_BWR_CR_WPE(base, value) (BME_BFI32(&RTC_CR_REG(base), ((uint32_t)(value) << RTC_CR_WPE_SHIFT), RTC_CR_WPE_SHIFT, RTC_CR_WPE_WIDTH))
/*@}*/

/*!
 * @name Register RTC_CR, field SUP[2] (RW)
 *
 * Values:
 * - 0 - Non-supervisor mode write accesses are not supported and generate a bus
 *     error.
 * - 1 - Non-supervisor mode write accesses are supported.
 */
/*@{*/
/*! @brief Read current value of the RTC_CR_SUP field. */
#define RTC_RD_CR_SUP(base)  ((RTC_CR_REG(base) & RTC_CR_SUP_MASK) >> RTC_CR_SUP_SHIFT)
#define RTC_BRD_CR_SUP(base) (BME_UBFX32(&RTC_CR_REG(base), RTC_CR_SUP_SHIFT, RTC_CR_SUP_WIDTH))

/*! @brief Set the SUP field to a new value. */
#define RTC_WR_CR_SUP(base, value) (RTC_RMW_CR(base, RTC_CR_SUP_MASK, RTC_CR_SUP(value)))
#define RTC_BWR_CR_SUP(base, value) (BME_BFI32(&RTC_CR_REG(base), ((uint32_t)(value) << RTC_CR_SUP_SHIFT), RTC_CR_SUP_SHIFT, RTC_CR_SUP_WIDTH))
/*@}*/

/*!
 * @name Register RTC_CR, field UM[3] (RW)
 *
 * Allows SR[TCE] to be written even when the Status Register is locked. When
 * set, the SR[TCE] can always be written if the SR[TIF] or SR[TOF] are set or if
 * the SR[TCE] is clear.
 *
 * Values:
 * - 0 - Registers cannot be written when locked.
 * - 1 - Registers can be written when locked under limited conditions.
 */
/*@{*/
/*! @brief Read current value of the RTC_CR_UM field. */
#define RTC_RD_CR_UM(base)   ((RTC_CR_REG(base) & RTC_CR_UM_MASK) >> RTC_CR_UM_SHIFT)
#define RTC_BRD_CR_UM(base)  (BME_UBFX32(&RTC_CR_REG(base), RTC_CR_UM_SHIFT, RTC_CR_UM_WIDTH))

/*! @brief Set the UM field to a new value. */
#define RTC_WR_CR_UM(base, value) (RTC_RMW_CR(base, RTC_CR_UM_MASK, RTC_CR_UM(value)))
#define RTC_BWR_CR_UM(base, value) (BME_BFI32(&RTC_CR_REG(base), ((uint32_t)(value) << RTC_CR_UM_SHIFT), RTC_CR_UM_SHIFT, RTC_CR_UM_WIDTH))
/*@}*/

/*!
 * @name Register RTC_CR, field WPS[4] (RW)
 *
 * The wakeup pin is optional and not available on all devices.
 *
 * Values:
 * - 0 - Wakeup pin asserts (active low, open drain) if the RTC interrupt
 *     asserts or the wakeup pin is turned on.
 * - 1 - Wakeup pin instead outputs the RTC 32kHz clock, provided the wakeup pin
 *     is turned on and the 32kHz clock is output to other peripherals.
 */
/*@{*/
/*! @brief Read current value of the RTC_CR_WPS field. */
#define RTC_RD_CR_WPS(base)  ((RTC_CR_REG(base) & RTC_CR_WPS_MASK) >> RTC_CR_WPS_SHIFT)
#define RTC_BRD_CR_WPS(base) (BME_UBFX32(&RTC_CR_REG(base), RTC_CR_WPS_SHIFT, RTC_CR_WPS_WIDTH))

/*! @brief Set the WPS field to a new value. */
#define RTC_WR_CR_WPS(base, value) (RTC_RMW_CR(base, RTC_CR_WPS_MASK, RTC_CR_WPS(value)))
#define RTC_BWR_CR_WPS(base, value) (BME_BFI32(&RTC_CR_REG(base), ((uint32_t)(value) << RTC_CR_WPS_SHIFT), RTC_CR_WPS_SHIFT, RTC_CR_WPS_WIDTH))
/*@}*/

/*!
 * @name Register RTC_CR, field OSCE[8] (RW)
 *
 * Values:
 * - 0 - 32.768 kHz oscillator is disabled.
 * - 1 - 32.768 kHz oscillator is enabled. After setting this bit, wait the
 *     oscillator startup time before enabling the time counter to allow the 32.768
 *     kHz clock time to stabilize.
 */
/*@{*/
/*! @brief Read current value of the RTC_CR_OSCE field. */
#define RTC_RD_CR_OSCE(base) ((RTC_CR_REG(base) & RTC_CR_OSCE_MASK) >> RTC_CR_OSCE_SHIFT)
#define RTC_BRD_CR_OSCE(base) (BME_UBFX32(&RTC_CR_REG(base), RTC_CR_OSCE_SHIFT, RTC_CR_OSCE_WIDTH))

/*! @brief Set the OSCE field to a new value. */
#define RTC_WR_CR_OSCE(base, value) (RTC_RMW_CR(base, RTC_CR_OSCE_MASK, RTC_CR_OSCE(value)))
#define RTC_BWR_CR_OSCE(base, value) (BME_BFI32(&RTC_CR_REG(base), ((uint32_t)(value) << RTC_CR_OSCE_SHIFT), RTC_CR_OSCE_SHIFT, RTC_CR_OSCE_WIDTH))
/*@}*/

/*!
 * @name Register RTC_CR, field CLKO[9] (RW)
 *
 * Values:
 * - 0 - The 32 kHz clock is output to other peripherals.
 * - 1 - The 32 kHz clock is not output to other peripherals.
 */
/*@{*/
/*! @brief Read current value of the RTC_CR_CLKO field. */
#define RTC_RD_CR_CLKO(base) ((RTC_CR_REG(base) & RTC_CR_CLKO_MASK) >> RTC_CR_CLKO_SHIFT)
#define RTC_BRD_CR_CLKO(base) (BME_UBFX32(&RTC_CR_REG(base), RTC_CR_CLKO_SHIFT, RTC_CR_CLKO_WIDTH))

/*! @brief Set the CLKO field to a new value. */
#define RTC_WR_CR_CLKO(base, value) (RTC_RMW_CR(base, RTC_CR_CLKO_MASK, RTC_CR_CLKO(value)))
#define RTC_BWR_CR_CLKO(base, value) (BME_BFI32(&RTC_CR_REG(base), ((uint32_t)(value) << RTC_CR_CLKO_SHIFT), RTC_CR_CLKO_SHIFT, RTC_CR_CLKO_WIDTH))
/*@}*/

/*!
 * @name Register RTC_CR, field SC16P[10] (RW)
 *
 * Values:
 * - 0 - Disable the load.
 * - 1 - Enable the additional load.
 */
/*@{*/
/*! @brief Read current value of the RTC_CR_SC16P field. */
#define RTC_RD_CR_SC16P(base) ((RTC_CR_REG(base) & RTC_CR_SC16P_MASK) >> RTC_CR_SC16P_SHIFT)
#define RTC_BRD_CR_SC16P(base) (BME_UBFX32(&RTC_CR_REG(base), RTC_CR_SC16P_SHIFT, RTC_CR_SC16P_WIDTH))

/*! @brief Set the SC16P field to a new value. */
#define RTC_WR_CR_SC16P(base, value) (RTC_RMW_CR(base, RTC_CR_SC16P_MASK, RTC_CR_SC16P(value)))
#define RTC_BWR_CR_SC16P(base, value) (BME_BFI32(&RTC_CR_REG(base), ((uint32_t)(value) << RTC_CR_SC16P_SHIFT), RTC_CR_SC16P_SHIFT, RTC_CR_SC16P_WIDTH))
/*@}*/

/*!
 * @name Register RTC_CR, field SC8P[11] (RW)
 *
 * Values:
 * - 0 - Disable the load.
 * - 1 - Enable the additional load.
 */
/*@{*/
/*! @brief Read current value of the RTC_CR_SC8P field. */
#define RTC_RD_CR_SC8P(base) ((RTC_CR_REG(base) & RTC_CR_SC8P_MASK) >> RTC_CR_SC8P_SHIFT)
#define RTC_BRD_CR_SC8P(base) (BME_UBFX32(&RTC_CR_REG(base), RTC_CR_SC8P_SHIFT, RTC_CR_SC8P_WIDTH))

/*! @brief Set the SC8P field to a new value. */
#define RTC_WR_CR_SC8P(base, value) (RTC_RMW_CR(base, RTC_CR_SC8P_MASK, RTC_CR_SC8P(value)))
#define RTC_BWR_CR_SC8P(base, value) (BME_BFI32(&RTC_CR_REG(base), ((uint32_t)(value) << RTC_CR_SC8P_SHIFT), RTC_CR_SC8P_SHIFT, RTC_CR_SC8P_WIDTH))
/*@}*/

/*!
 * @name Register RTC_CR, field SC4P[12] (RW)
 *
 * Values:
 * - 0 - Disable the load.
 * - 1 - Enable the additional load.
 */
/*@{*/
/*! @brief Read current value of the RTC_CR_SC4P field. */
#define RTC_RD_CR_SC4P(base) ((RTC_CR_REG(base) & RTC_CR_SC4P_MASK) >> RTC_CR_SC4P_SHIFT)
#define RTC_BRD_CR_SC4P(base) (BME_UBFX32(&RTC_CR_REG(base), RTC_CR_SC4P_SHIFT, RTC_CR_SC4P_WIDTH))

/*! @brief Set the SC4P field to a new value. */
#define RTC_WR_CR_SC4P(base, value) (RTC_RMW_CR(base, RTC_CR_SC4P_MASK, RTC_CR_SC4P(value)))
#define RTC_BWR_CR_SC4P(base, value) (BME_BFI32(&RTC_CR_REG(base), ((uint32_t)(value) << RTC_CR_SC4P_SHIFT), RTC_CR_SC4P_SHIFT, RTC_CR_SC4P_WIDTH))
/*@}*/

/*!
 * @name Register RTC_CR, field SC2P[13] (RW)
 *
 * Values:
 * - 0 - Disable the load.
 * - 1 - Enable the additional load.
 */
/*@{*/
/*! @brief Read current value of the RTC_CR_SC2P field. */
#define RTC_RD_CR_SC2P(base) ((RTC_CR_REG(base) & RTC_CR_SC2P_MASK) >> RTC_CR_SC2P_SHIFT)
#define RTC_BRD_CR_SC2P(base) (BME_UBFX32(&RTC_CR_REG(base), RTC_CR_SC2P_SHIFT, RTC_CR_SC2P_WIDTH))

/*! @brief Set the SC2P field to a new value. */
#define RTC_WR_CR_SC2P(base, value) (RTC_RMW_CR(base, RTC_CR_SC2P_MASK, RTC_CR_SC2P(value)))
#define RTC_BWR_CR_SC2P(base, value) (BME_BFI32(&RTC_CR_REG(base), ((uint32_t)(value) << RTC_CR_SC2P_SHIFT), RTC_CR_SC2P_SHIFT, RTC_CR_SC2P_WIDTH))
/*@}*/

/*******************************************************************************
 * RTC_SR - RTC Status Register
 ******************************************************************************/

/*!
 * @brief RTC_SR - RTC Status Register (RW)
 *
 * Reset value: 0x00000001U
 */
/*!
 * @name Constants and macros for entire RTC_SR register
 */
/*@{*/
#define RTC_RD_SR(base)          (RTC_SR_REG(base))
#define RTC_WR_SR(base, value)   (RTC_SR_REG(base) = (value))
#define RTC_RMW_SR(base, mask, value) (RTC_WR_SR(base, (RTC_RD_SR(base) & ~(mask)) | (value)))
#define RTC_SET_SR(base, value)  (BME_OR32(&RTC_SR_REG(base), (uint32_t)(value)))
#define RTC_CLR_SR(base, value)  (BME_AND32(&RTC_SR_REG(base), (uint32_t)(~(value))))
#define RTC_TOG_SR(base, value)  (BME_XOR32(&RTC_SR_REG(base), (uint32_t)(value)))
/*@}*/

/*
 * Constants & macros for individual RTC_SR bitfields
 */

/*!
 * @name Register RTC_SR, field TIF[0] (RO)
 *
 * The time invalid flag is set on POR or software reset. The TSR and TPR do not
 * increment and read as zero when this bit is set. This bit is cleared by
 * writing the TSR register when the time counter is disabled.
 *
 * Values:
 * - 0 - Time is valid.
 * - 1 - Time is invalid and time counter is read as zero.
 */
/*@{*/
/*! @brief Read current value of the RTC_SR_TIF field. */
#define RTC_RD_SR_TIF(base)  ((RTC_SR_REG(base) & RTC_SR_TIF_MASK) >> RTC_SR_TIF_SHIFT)
#define RTC_BRD_SR_TIF(base) (BME_UBFX32(&RTC_SR_REG(base), RTC_SR_TIF_SHIFT, RTC_SR_TIF_WIDTH))
/*@}*/

/*!
 * @name Register RTC_SR, field TOF[1] (RO)
 *
 * Time overflow flag is set when the time counter is enabled and overflows. The
 * TSR and TPR do not increment and read as zero when this bit is set. This bit
 * is cleared by writing the TSR register when the time counter is disabled.
 *
 * Values:
 * - 0 - Time overflow has not occurred.
 * - 1 - Time overflow has occurred and time counter is read as zero.
 */
/*@{*/
/*! @brief Read current value of the RTC_SR_TOF field. */
#define RTC_RD_SR_TOF(base)  ((RTC_SR_REG(base) & RTC_SR_TOF_MASK) >> RTC_SR_TOF_SHIFT)
#define RTC_BRD_SR_TOF(base) (BME_UBFX32(&RTC_SR_REG(base), RTC_SR_TOF_SHIFT, RTC_SR_TOF_WIDTH))
/*@}*/

/*!
 * @name Register RTC_SR, field TAF[2] (RO)
 *
 * Time alarm flag is set when the TAR[TAR] equals the TSR[TSR] and the TSR[TSR]
 * increments. This bit is cleared by writing the TAR register.
 *
 * Values:
 * - 0 - Time alarm has not occurred.
 * - 1 - Time alarm has occurred.
 */
/*@{*/
/*! @brief Read current value of the RTC_SR_TAF field. */
#define RTC_RD_SR_TAF(base)  ((RTC_SR_REG(base) & RTC_SR_TAF_MASK) >> RTC_SR_TAF_SHIFT)
#define RTC_BRD_SR_TAF(base) (BME_UBFX32(&RTC_SR_REG(base), RTC_SR_TAF_SHIFT, RTC_SR_TAF_WIDTH))
/*@}*/

/*!
 * @name Register RTC_SR, field TCE[4] (RW)
 *
 * When time counter is disabled the TSR register and TPR register are
 * writeable, but do not increment. When time counter is enabled the TSR register and TPR
 * register are not writeable, but increment.
 *
 * Values:
 * - 0 - Time counter is disabled.
 * - 1 - Time counter is enabled.
 */
/*@{*/
/*! @brief Read current value of the RTC_SR_TCE field. */
#define RTC_RD_SR_TCE(base)  ((RTC_SR_REG(base) & RTC_SR_TCE_MASK) >> RTC_SR_TCE_SHIFT)
#define RTC_BRD_SR_TCE(base) (BME_UBFX32(&RTC_SR_REG(base), RTC_SR_TCE_SHIFT, RTC_SR_TCE_WIDTH))

/*! @brief Set the TCE field to a new value. */
#define RTC_WR_SR_TCE(base, value) (RTC_RMW_SR(base, RTC_SR_TCE_MASK, RTC_SR_TCE(value)))
#define RTC_BWR_SR_TCE(base, value) (BME_BFI32(&RTC_SR_REG(base), ((uint32_t)(value) << RTC_SR_TCE_SHIFT), RTC_SR_TCE_SHIFT, RTC_SR_TCE_WIDTH))
/*@}*/

/*******************************************************************************
 * RTC_LR - RTC Lock Register
 ******************************************************************************/

/*!
 * @brief RTC_LR - RTC Lock Register (RW)
 *
 * Reset value: 0x000000FFU
 */
/*!
 * @name Constants and macros for entire RTC_LR register
 */
/*@{*/
#define RTC_RD_LR(base)          (RTC_LR_REG(base))
#define RTC_WR_LR(base, value)   (RTC_LR_REG(base) = (value))
#define RTC_RMW_LR(base, mask, value) (RTC_WR_LR(base, (RTC_RD_LR(base) & ~(mask)) | (value)))
#define RTC_SET_LR(base, value)  (BME_OR32(&RTC_LR_REG(base), (uint32_t)(value)))
#define RTC_CLR_LR(base, value)  (BME_AND32(&RTC_LR_REG(base), (uint32_t)(~(value))))
#define RTC_TOG_LR(base, value)  (BME_XOR32(&RTC_LR_REG(base), (uint32_t)(value)))
/*@}*/

/*
 * Constants & macros for individual RTC_LR bitfields
 */

/*!
 * @name Register RTC_LR, field TCL[3] (RW)
 *
 * After being cleared, this bit can be set only by POR or software reset.
 *
 * Values:
 * - 0 - Time Compensation Register is locked and writes are ignored.
 * - 1 - Time Compensation Register is not locked and writes complete as normal.
 */
/*@{*/
/*! @brief Read current value of the RTC_LR_TCL field. */
#define RTC_RD_LR_TCL(base)  ((RTC_LR_REG(base) & RTC_LR_TCL_MASK) >> RTC_LR_TCL_SHIFT)
#define RTC_BRD_LR_TCL(base) (BME_UBFX32(&RTC_LR_REG(base), RTC_LR_TCL_SHIFT, RTC_LR_TCL_WIDTH))

/*! @brief Set the TCL field to a new value. */
#define RTC_WR_LR_TCL(base, value) (RTC_RMW_LR(base, RTC_LR_TCL_MASK, RTC_LR_TCL(value)))
#define RTC_BWR_LR_TCL(base, value) (BME_BFI32(&RTC_LR_REG(base), ((uint32_t)(value) << RTC_LR_TCL_SHIFT), RTC_LR_TCL_SHIFT, RTC_LR_TCL_WIDTH))
/*@}*/

/*!
 * @name Register RTC_LR, field CRL[4] (RW)
 *
 * After being cleared, this bit can only be set by POR.
 *
 * Values:
 * - 0 - Control Register is locked and writes are ignored.
 * - 1 - Control Register is not locked and writes complete as normal.
 */
/*@{*/
/*! @brief Read current value of the RTC_LR_CRL field. */
#define RTC_RD_LR_CRL(base)  ((RTC_LR_REG(base) & RTC_LR_CRL_MASK) >> RTC_LR_CRL_SHIFT)
#define RTC_BRD_LR_CRL(base) (BME_UBFX32(&RTC_LR_REG(base), RTC_LR_CRL_SHIFT, RTC_LR_CRL_WIDTH))

/*! @brief Set the CRL field to a new value. */
#define RTC_WR_LR_CRL(base, value) (RTC_RMW_LR(base, RTC_LR_CRL_MASK, RTC_LR_CRL(value)))
#define RTC_BWR_LR_CRL(base, value) (BME_BFI32(&RTC_LR_REG(base), ((uint32_t)(value) << RTC_LR_CRL_SHIFT), RTC_LR_CRL_SHIFT, RTC_LR_CRL_WIDTH))
/*@}*/

/*!
 * @name Register RTC_LR, field SRL[5] (RW)
 *
 * After being cleared, this bit can be set only by POR or software reset.
 *
 * Values:
 * - 0 - Status Register is locked and writes are ignored.
 * - 1 - Status Register is not locked and writes complete as normal.
 */
/*@{*/
/*! @brief Read current value of the RTC_LR_SRL field. */
#define RTC_RD_LR_SRL(base)  ((RTC_LR_REG(base) & RTC_LR_SRL_MASK) >> RTC_LR_SRL_SHIFT)
#define RTC_BRD_LR_SRL(base) (BME_UBFX32(&RTC_LR_REG(base), RTC_LR_SRL_SHIFT, RTC_LR_SRL_WIDTH))

/*! @brief Set the SRL field to a new value. */
#define RTC_WR_LR_SRL(base, value) (RTC_RMW_LR(base, RTC_LR_SRL_MASK, RTC_LR_SRL(value)))
#define RTC_BWR_LR_SRL(base, value) (BME_BFI32(&RTC_LR_REG(base), ((uint32_t)(value) << RTC_LR_SRL_SHIFT), RTC_LR_SRL_SHIFT, RTC_LR_SRL_WIDTH))
/*@}*/

/*!
 * @name Register RTC_LR, field LRL[6] (RW)
 *
 * After being cleared, this bit can be set only by POR or software reset.
 *
 * Values:
 * - 0 - Lock Register is locked and writes are ignored.
 * - 1 - Lock Register is not locked and writes complete as normal.
 */
/*@{*/
/*! @brief Read current value of the RTC_LR_LRL field. */
#define RTC_RD_LR_LRL(base)  ((RTC_LR_REG(base) & RTC_LR_LRL_MASK) >> RTC_LR_LRL_SHIFT)
#define RTC_BRD_LR_LRL(base) (BME_UBFX32(&RTC_LR_REG(base), RTC_LR_LRL_SHIFT, RTC_LR_LRL_WIDTH))

/*! @brief Set the LRL field to a new value. */
#define RTC_WR_LR_LRL(base, value) (RTC_RMW_LR(base, RTC_LR_LRL_MASK, RTC_LR_LRL(value)))
#define RTC_BWR_LR_LRL(base, value) (BME_BFI32(&RTC_LR_REG(base), ((uint32_t)(value) << RTC_LR_LRL_SHIFT), RTC_LR_LRL_SHIFT, RTC_LR_LRL_WIDTH))
/*@}*/

/*******************************************************************************
 * RTC_IER - RTC Interrupt Enable Register
 ******************************************************************************/

/*!
 * @brief RTC_IER - RTC Interrupt Enable Register (RW)
 *
 * Reset value: 0x00000007U
 */
/*!
 * @name Constants and macros for entire RTC_IER register
 */
/*@{*/
#define RTC_RD_IER(base)         (RTC_IER_REG(base))
#define RTC_WR_IER(base, value)  (RTC_IER_REG(base) = (value))
#define RTC_RMW_IER(base, mask, value) (RTC_WR_IER(base, (RTC_RD_IER(base) & ~(mask)) | (value)))
#define RTC_SET_IER(base, value) (BME_OR32(&RTC_IER_REG(base), (uint32_t)(value)))
#define RTC_CLR_IER(base, value) (BME_AND32(&RTC_IER_REG(base), (uint32_t)(~(value))))
#define RTC_TOG_IER(base, value) (BME_XOR32(&RTC_IER_REG(base), (uint32_t)(value)))
/*@}*/

/*
 * Constants & macros for individual RTC_IER bitfields
 */

/*!
 * @name Register RTC_IER, field TIIE[0] (RW)
 *
 * Values:
 * - 0 - Time invalid flag does not generate an interrupt.
 * - 1 - Time invalid flag does generate an interrupt.
 */
/*@{*/
/*! @brief Read current value of the RTC_IER_TIIE field. */
#define RTC_RD_IER_TIIE(base) ((RTC_IER_REG(base) & RTC_IER_TIIE_MASK) >> RTC_IER_TIIE_SHIFT)
#define RTC_BRD_IER_TIIE(base) (BME_UBFX32(&RTC_IER_REG(base), RTC_IER_TIIE_SHIFT, RTC_IER_TIIE_WIDTH))

/*! @brief Set the TIIE field to a new value. */
#define RTC_WR_IER_TIIE(base, value) (RTC_RMW_IER(base, RTC_IER_TIIE_MASK, RTC_IER_TIIE(value)))
#define RTC_BWR_IER_TIIE(base, value) (BME_BFI32(&RTC_IER_REG(base), ((uint32_t)(value) << RTC_IER_TIIE_SHIFT), RTC_IER_TIIE_SHIFT, RTC_IER_TIIE_WIDTH))
/*@}*/

/*!
 * @name Register RTC_IER, field TOIE[1] (RW)
 *
 * Values:
 * - 0 - Time overflow flag does not generate an interrupt.
 * - 1 - Time overflow flag does generate an interrupt.
 */
/*@{*/
/*! @brief Read current value of the RTC_IER_TOIE field. */
#define RTC_RD_IER_TOIE(base) ((RTC_IER_REG(base) & RTC_IER_TOIE_MASK) >> RTC_IER_TOIE_SHIFT)
#define RTC_BRD_IER_TOIE(base) (BME_UBFX32(&RTC_IER_REG(base), RTC_IER_TOIE_SHIFT, RTC_IER_TOIE_WIDTH))

/*! @brief Set the TOIE field to a new value. */
#define RTC_WR_IER_TOIE(base, value) (RTC_RMW_IER(base, RTC_IER_TOIE_MASK, RTC_IER_TOIE(value)))
#define RTC_BWR_IER_TOIE(base, value) (BME_BFI32(&RTC_IER_REG(base), ((uint32_t)(value) << RTC_IER_TOIE_SHIFT), RTC_IER_TOIE_SHIFT, RTC_IER_TOIE_WIDTH))
/*@}*/

/*!
 * @name Register RTC_IER, field TAIE[2] (RW)
 *
 * Values:
 * - 0 - Time alarm flag does not generate an interrupt.
 * - 1 - Time alarm flag does generate an interrupt.
 */
/*@{*/
/*! @brief Read current value of the RTC_IER_TAIE field. */
#define RTC_RD_IER_TAIE(base) ((RTC_IER_REG(base) & RTC_IER_TAIE_MASK) >> RTC_IER_TAIE_SHIFT)
#define RTC_BRD_IER_TAIE(base) (BME_UBFX32(&RTC_IER_REG(base), RTC_IER_TAIE_SHIFT, RTC_IER_TAIE_WIDTH))

/*! @brief Set the TAIE field to a new value. */
#define RTC_WR_IER_TAIE(base, value) (RTC_RMW_IER(base, RTC_IER_TAIE_MASK, RTC_IER_TAIE(value)))
#define RTC_BWR_IER_TAIE(base, value) (BME_BFI32(&RTC_IER_REG(base), ((uint32_t)(value) << RTC_IER_TAIE_SHIFT), RTC_IER_TAIE_SHIFT, RTC_IER_TAIE_WIDTH))
/*@}*/

/*!
 * @name Register RTC_IER, field TSIE[4] (RW)
 *
 * The seconds interrupt is an edge-sensitive interrupt with a dedicated
 * interrupt vector. It is generated once a second and requires no software overhead
 * (there is no corresponding status flag to clear).
 *
 * Values:
 * - 0 - Seconds interrupt is disabled.
 * - 1 - Seconds interrupt is enabled.
 */
/*@{*/
/*! @brief Read current value of the RTC_IER_TSIE field. */
#define RTC_RD_IER_TSIE(base) ((RTC_IER_REG(base) & RTC_IER_TSIE_MASK) >> RTC_IER_TSIE_SHIFT)
#define RTC_BRD_IER_TSIE(base) (BME_UBFX32(&RTC_IER_REG(base), RTC_IER_TSIE_SHIFT, RTC_IER_TSIE_WIDTH))

/*! @brief Set the TSIE field to a new value. */
#define RTC_WR_IER_TSIE(base, value) (RTC_RMW_IER(base, RTC_IER_TSIE_MASK, RTC_IER_TSIE(value)))
#define RTC_BWR_IER_TSIE(base, value) (BME_BFI32(&RTC_IER_REG(base), ((uint32_t)(value) << RTC_IER_TSIE_SHIFT), RTC_IER_TSIE_SHIFT, RTC_IER_TSIE_WIDTH))
/*@}*/

/*!
 * @name Register RTC_IER, field WPON[7] (RW)
 *
 * The wakeup pin is optional and not available on all devices. Whenever the
 * wakeup pin is enabled and this bit is set, the wakeup pin will assert.
 *
 * Values:
 * - 0 - No effect.
 * - 1 - If the wakeup pin is enabled, then the wakeup pin will assert.
 */
/*@{*/
/*! @brief Read current value of the RTC_IER_WPON field. */
#define RTC_RD_IER_WPON(base) ((RTC_IER_REG(base) & RTC_IER_WPON_MASK) >> RTC_IER_WPON_SHIFT)
#define RTC_BRD_IER_WPON(base) (BME_UBFX32(&RTC_IER_REG(base), RTC_IER_WPON_SHIFT, RTC_IER_WPON_WIDTH))

/*! @brief Set the WPON field to a new value. */
#define RTC_WR_IER_WPON(base, value) (RTC_RMW_IER(base, RTC_IER_WPON_MASK, RTC_IER_WPON(value)))
#define RTC_BWR_IER_WPON(base, value) (BME_BFI32(&RTC_IER_REG(base), ((uint32_t)(value) << RTC_IER_WPON_SHIFT), RTC_IER_WPON_SHIFT, RTC_IER_WPON_WIDTH))
/*@}*/

/*
 * MKL27Z644 SIM
 *
 * System Integration Module
 *
 * Registers defined in this header file:
 * - SIM_SOPT1 - System Options Register 1
 * - SIM_SOPT2 - System Options Register 2
 * - SIM_SOPT4 - System Options Register 4
 * - SIM_SOPT5 - System Options Register 5
 * - SIM_SOPT7 - System Options Register 7
 * - SIM_SDID - System Device Identification Register
 * - SIM_SCGC4 - System Clock Gating Control Register 4
 * - SIM_SCGC5 - System Clock Gating Control Register 5
 * - SIM_SCGC6 - System Clock Gating Control Register 6
 * - SIM_SCGC7 - System Clock Gating Control Register 7
 * - SIM_CLKDIV1 - System Clock Divider Register 1
 * - SIM_FCFG1 - Flash Configuration Register 1
 * - SIM_FCFG2 - Flash Configuration Register 2
 * - SIM_UIDMH - Unique Identification Register Mid-High
 * - SIM_UIDML - Unique Identification Register Mid Low
 * - SIM_UIDL - Unique Identification Register Low
 * - SIM_COPC - COP Control Register
 * - SIM_SRVCOP - Service COP
 */

#define SIM_INSTANCE_COUNT (1U) /*!< Number of instances of the SIM module. */
#define SIM_IDX (0U) /*!< Instance number for SIM. */

/*******************************************************************************
 * SIM_SOPT1 - System Options Register 1
 ******************************************************************************/

/*!
 * @brief SIM_SOPT1 - System Options Register 1 (RW)
 *
 * Reset value: 0x00000000U
 *
 * The SOPT1 register is only reset on POR or LVD.
 */
/*!
 * @name Constants and macros for entire SIM_SOPT1 register
 */
/*@{*/
#define SIM_RD_SOPT1(base)       (SIM_SOPT1_REG(base))
#define SIM_WR_SOPT1(base, value) (SIM_SOPT1_REG(base) = (value))
#define SIM_RMW_SOPT1(base, mask, value) (SIM_WR_SOPT1(base, (SIM_RD_SOPT1(base) & ~(mask)) | (value)))
#define SIM_SET_SOPT1(base, value) (BME_OR32(&SIM_SOPT1_REG(base), (uint32_t)(value)))
#define SIM_CLR_SOPT1(base, value) (BME_AND32(&SIM_SOPT1_REG(base), (uint32_t)(~(value))))
#define SIM_TOG_SOPT1(base, value) (BME_XOR32(&SIM_SOPT1_REG(base), (uint32_t)(value)))
/*@}*/

/*
 * Constants & macros for individual SIM_SOPT1 bitfields
 */

/*!
 * @name Register SIM_SOPT1, field OSC32KOUT[17:16] (RW)
 *
 * Outputs the ERCLK32K on the selected pin in all modes of operation (including
 * LLS/VLLS and System Reset), overriding the existing pin mux configuration for
 * that pin. This field is reset only on POR/LVD.
 *
 * Values:
 * - 00 - ERCLK32K is not output.
 * - 01 - ERCLK32K is output on PTE0.
 * - 10 - Reserved.
 * - 11 - Reserved.
 */
/*@{*/
/*! @brief Read current value of the SIM_SOPT1_OSC32KOUT field. */
#define SIM_RD_SOPT1_OSC32KOUT(base) ((SIM_SOPT1_REG(base) & SIM_SOPT1_OSC32KOUT_MASK) >> SIM_SOPT1_OSC32KOUT_SHIFT)
#define SIM_BRD_SOPT1_OSC32KOUT(base) (BME_UBFX32(&SIM_SOPT1_REG(base), SIM_SOPT1_OSC32KOUT_SHIFT, SIM_SOPT1_OSC32KOUT_WIDTH))

/*! @brief Set the OSC32KOUT field to a new value. */
#define SIM_WR_SOPT1_OSC32KOUT(base, value) (SIM_RMW_SOPT1(base, SIM_SOPT1_OSC32KOUT_MASK, SIM_SOPT1_OSC32KOUT(value)))
#define SIM_BWR_SOPT1_OSC32KOUT(base, value) (BME_BFI32(&SIM_SOPT1_REG(base), ((uint32_t)(value) << SIM_SOPT1_OSC32KOUT_SHIFT), SIM_SOPT1_OSC32KOUT_SHIFT, SIM_SOPT1_OSC32KOUT_WIDTH))
/*@}*/

/*!
 * @name Register SIM_SOPT1, field OSC32KSEL[19:18] (RW)
 *
 * Selects the 32 kHz clock source (ERCLK32K) for RTC and LPTMR. This field is
 * reset only on POR/LVD.
 *
 * Values:
 * - 00 - System oscillator (OSC32KCLK)
 * - 01 - Reserved
 * - 10 - RTC_CLKIN
 * - 11 - LPO 1kHz
 */
/*@{*/
/*! @brief Read current value of the SIM_SOPT1_OSC32KSEL field. */
#define SIM_RD_SOPT1_OSC32KSEL(base) ((SIM_SOPT1_REG(base) & SIM_SOPT1_OSC32KSEL_MASK) >> SIM_SOPT1_OSC32KSEL_SHIFT)
#define SIM_BRD_SOPT1_OSC32KSEL(base) (BME_UBFX32(&SIM_SOPT1_REG(base), SIM_SOPT1_OSC32KSEL_SHIFT, SIM_SOPT1_OSC32KSEL_WIDTH))

/*! @brief Set the OSC32KSEL field to a new value. */
#define SIM_WR_SOPT1_OSC32KSEL(base, value) (SIM_RMW_SOPT1(base, SIM_SOPT1_OSC32KSEL_MASK, SIM_SOPT1_OSC32KSEL(value)))
#define SIM_BWR_SOPT1_OSC32KSEL(base, value) (BME_BFI32(&SIM_SOPT1_REG(base), ((uint32_t)(value) << SIM_SOPT1_OSC32KSEL_SHIFT), SIM_SOPT1_OSC32KSEL_SHIFT, SIM_SOPT1_OSC32KSEL_WIDTH))
/*@}*/

/*******************************************************************************
 * SIM_SOPT2 - System Options Register 2
 ******************************************************************************/

/*!
 * @brief SIM_SOPT2 - System Options Register 2 (RW)
 *
 * Reset value: 0x00000000U
 *
 * SOPT2 contains the controls for selecting many of the module clock source
 * options on this device. See the Clock Distribution chapter for more information
 * including clocking diagrams and definitions of device clocks.
 */
/*!
 * @name Constants and macros for entire SIM_SOPT2 register
 */
/*@{*/
#define SIM_RD_SOPT2(base)       (SIM_SOPT2_REG(base))
#define SIM_WR_SOPT2(base, value) (SIM_SOPT2_REG(base) = (value))
#define SIM_RMW_SOPT2(base, mask, value) (SIM_WR_SOPT2(base, (SIM_RD_SOPT2(base) & ~(mask)) | (value)))
#define SIM_SET_SOPT2(base, value) (BME_OR32(&SIM_SOPT2_REG(base), (uint32_t)(value)))
#define SIM_CLR_SOPT2(base, value) (BME_AND32(&SIM_SOPT2_REG(base), (uint32_t)(~(value))))
#define SIM_TOG_SOPT2(base, value) (BME_XOR32(&SIM_SOPT2_REG(base), (uint32_t)(value)))
/*@}*/

/*
 * Constants & macros for individual SIM_SOPT2 bitfields
 */

/*!
 * @name Register SIM_SOPT2, field RTCCLKOUTSEL[4] (RW)
 *
 * Selects either the RTC 1 Hz clock or the OSC clock to be output on the
 * RTC_CLKOUT pin.
 *
 * Values:
 * - 0 - RTC 1 Hz clock is output on the RTC_CLKOUT pin.
 * - 1 - OSCERCLK clock is output on the RTC_CLKOUT pin.
 */
/*@{*/
/*! @brief Read current value of the SIM_SOPT2_RTCCLKOUTSEL field. */
#define SIM_RD_SOPT2_RTCCLKOUTSEL(base) ((SIM_SOPT2_REG(base) & SIM_SOPT2_RTCCLKOUTSEL_MASK) >> SIM_SOPT2_RTCCLKOUTSEL_SHIFT)
#define SIM_BRD_SOPT2_RTCCLKOUTSEL(base) (BME_UBFX32(&SIM_SOPT2_REG(base), SIM_SOPT2_RTCCLKOUTSEL_SHIFT, SIM_SOPT2_RTCCLKOUTSEL_WIDTH))

/*! @brief Set the RTCCLKOUTSEL field to a new value. */
#define SIM_WR_SOPT2_RTCCLKOUTSEL(base, value) (SIM_RMW_SOPT2(base, SIM_SOPT2_RTCCLKOUTSEL_MASK, SIM_SOPT2_RTCCLKOUTSEL(value)))
#define SIM_BWR_SOPT2_RTCCLKOUTSEL(base, value) (BME_BFI32(&SIM_SOPT2_REG(base), ((uint32_t)(value) << SIM_SOPT2_RTCCLKOUTSEL_SHIFT), SIM_SOPT2_RTCCLKOUTSEL_SHIFT, SIM_SOPT2_RTCCLKOUTSEL_WIDTH))
/*@}*/

/*!
 * @name Register SIM_SOPT2, field CLKOUTSEL[7:5] (RW)
 *
 * Selects the clock to output on the CLKOUT pin.
 *
 * Values:
 * - 000 - Reserved
 * - 001 - Reserved
 * - 010 - Bus clock
 * - 011 - LPO clock (1 kHz)
 * - 100 - LIRC_CLK
 * - 101 - Reserved
 * - 110 - OSCERCLK
 * - 111 - IRC48M clock (IRC48M clock can be output to PAD only when chip VDD is
 *     2.7-3.6 V)
 */
/*@{*/
/*! @brief Read current value of the SIM_SOPT2_CLKOUTSEL field. */
#define SIM_RD_SOPT2_CLKOUTSEL(base) ((SIM_SOPT2_REG(base) & SIM_SOPT2_CLKOUTSEL_MASK) >> SIM_SOPT2_CLKOUTSEL_SHIFT)
#define SIM_BRD_SOPT2_CLKOUTSEL(base) (BME_UBFX32(&SIM_SOPT2_REG(base), SIM_SOPT2_CLKOUTSEL_SHIFT, SIM_SOPT2_CLKOUTSEL_WIDTH))

/*! @brief Set the CLKOUTSEL field to a new value. */
#define SIM_WR_SOPT2_CLKOUTSEL(base, value) (SIM_RMW_SOPT2(base, SIM_SOPT2_CLKOUTSEL_MASK, SIM_SOPT2_CLKOUTSEL(value)))
#define SIM_BWR_SOPT2_CLKOUTSEL(base, value) (BME_BFI32(&SIM_SOPT2_REG(base), ((uint32_t)(value) << SIM_SOPT2_CLKOUTSEL_SHIFT), SIM_SOPT2_CLKOUTSEL_SHIFT, SIM_SOPT2_CLKOUTSEL_WIDTH))
/*@}*/

/*!
 * @name Register SIM_SOPT2, field USBSRC[18] (RW)
 *
 * Selects the clock source for the USB 48 MHz clock.
 *
 * Values:
 * - 0 - External bypass clock (USB_CLKIN).
 * - 1 - IRC48M clock
 */
/*@{*/
/*! @brief Read current value of the SIM_SOPT2_USBSRC field. */
#define SIM_RD_SOPT2_USBSRC(base) ((SIM_SOPT2_REG(base) & SIM_SOPT2_USBSRC_MASK) >> SIM_SOPT2_USBSRC_SHIFT)
#define SIM_BRD_SOPT2_USBSRC(base) (BME_UBFX32(&SIM_SOPT2_REG(base), SIM_SOPT2_USBSRC_SHIFT, SIM_SOPT2_USBSRC_WIDTH))

/*! @brief Set the USBSRC field to a new value. */
#define SIM_WR_SOPT2_USBSRC(base, value) (SIM_RMW_SOPT2(base, SIM_SOPT2_USBSRC_MASK, SIM_SOPT2_USBSRC(value)))
#define SIM_BWR_SOPT2_USBSRC(base, value) (BME_BFI32(&SIM_SOPT2_REG(base), ((uint32_t)(value) << SIM_SOPT2_USBSRC_SHIFT), SIM_SOPT2_USBSRC_SHIFT, SIM_SOPT2_USBSRC_WIDTH))
/*@}*/

/*!
 * @name Register SIM_SOPT2, field FLEXIOSRC[23:22] (RW)
 *
 * Selects the clock source for the FlexIO transmit and receive clock.
 *
 * Values:
 * - 00 - Clock disabled
 * - 01 - IRC48M clock
 * - 10 - OSCERCLK clock
 * - 11 - MCGIRCLK clock
 */
/*@{*/
/*! @brief Read current value of the SIM_SOPT2_FLEXIOSRC field. */
#define SIM_RD_SOPT2_FLEXIOSRC(base) ((SIM_SOPT2_REG(base) & SIM_SOPT2_FLEXIOSRC_MASK) >> SIM_SOPT2_FLEXIOSRC_SHIFT)
#define SIM_BRD_SOPT2_FLEXIOSRC(base) (BME_UBFX32(&SIM_SOPT2_REG(base), SIM_SOPT2_FLEXIOSRC_SHIFT, SIM_SOPT2_FLEXIOSRC_WIDTH))

/*! @brief Set the FLEXIOSRC field to a new value. */
#define SIM_WR_SOPT2_FLEXIOSRC(base, value) (SIM_RMW_SOPT2(base, SIM_SOPT2_FLEXIOSRC_MASK, SIM_SOPT2_FLEXIOSRC(value)))
#define SIM_BWR_SOPT2_FLEXIOSRC(base, value) (BME_BFI32(&SIM_SOPT2_REG(base), ((uint32_t)(value) << SIM_SOPT2_FLEXIOSRC_SHIFT), SIM_SOPT2_FLEXIOSRC_SHIFT, SIM_SOPT2_FLEXIOSRC_WIDTH))
/*@}*/

/*!
 * @name Register SIM_SOPT2, field TPMSRC[25:24] (RW)
 *
 * Selects the clock source for the TPM counter clock
 *
 * Values:
 * - 00 - Clock disabled
 * - 01 - IRC48M clock
 * - 10 - OSCERCLK clock
 * - 11 - MCGIRCLK clock
 */
/*@{*/
/*! @brief Read current value of the SIM_SOPT2_TPMSRC field. */
#define SIM_RD_SOPT2_TPMSRC(base) ((SIM_SOPT2_REG(base) & SIM_SOPT2_TPMSRC_MASK) >> SIM_SOPT2_TPMSRC_SHIFT)
#define SIM_BRD_SOPT2_TPMSRC(base) (BME_UBFX32(&SIM_SOPT2_REG(base), SIM_SOPT2_TPMSRC_SHIFT, SIM_SOPT2_TPMSRC_WIDTH))

/*! @brief Set the TPMSRC field to a new value. */
#define SIM_WR_SOPT2_TPMSRC(base, value) (SIM_RMW_SOPT2(base, SIM_SOPT2_TPMSRC_MASK, SIM_SOPT2_TPMSRC(value)))
#define SIM_BWR_SOPT2_TPMSRC(base, value) (BME_BFI32(&SIM_SOPT2_REG(base), ((uint32_t)(value) << SIM_SOPT2_TPMSRC_SHIFT), SIM_SOPT2_TPMSRC_SHIFT, SIM_SOPT2_TPMSRC_WIDTH))
/*@}*/

/*!
 * @name Register SIM_SOPT2, field LPUART0SRC[27:26] (RW)
 *
 * Selects the clock source for the LPUART0 transmit and receive clock.
 *
 * Values:
 * - 00 - Clock disabled
 * - 01 - IRC48M clock
 * - 10 - OSCERCLK clock
 * - 11 - MCGIRCLK clock
 */
/*@{*/
/*! @brief Read current value of the SIM_SOPT2_LPUART0SRC field. */
#define SIM_RD_SOPT2_LPUART0SRC(base) ((SIM_SOPT2_REG(base) & SIM_SOPT2_LPUART0SRC_MASK) >> SIM_SOPT2_LPUART0SRC_SHIFT)
#define SIM_BRD_SOPT2_LPUART0SRC(base) (BME_UBFX32(&SIM_SOPT2_REG(base), SIM_SOPT2_LPUART0SRC_SHIFT, SIM_SOPT2_LPUART0SRC_WIDTH))

/*! @brief Set the LPUART0SRC field to a new value. */
#define SIM_WR_SOPT2_LPUART0SRC(base, value) (SIM_RMW_SOPT2(base, SIM_SOPT2_LPUART0SRC_MASK, SIM_SOPT2_LPUART0SRC(value)))
#define SIM_BWR_SOPT2_LPUART0SRC(base, value) (BME_BFI32(&SIM_SOPT2_REG(base), ((uint32_t)(value) << SIM_SOPT2_LPUART0SRC_SHIFT), SIM_SOPT2_LPUART0SRC_SHIFT, SIM_SOPT2_LPUART0SRC_WIDTH))
/*@}*/

/*!
 * @name Register SIM_SOPT2, field LPUART1SRC[29:28] (RW)
 *
 * Selects the clock source for the LPUART1 transmit and receive clock.
 *
 * Values:
 * - 00 - Clock disabled
 * - 01 - IRC48M clock
 * - 10 - OSCERCLK clock
 * - 11 - MCGIRCLK clock
 */
/*@{*/
/*! @brief Read current value of the SIM_SOPT2_LPUART1SRC field. */
#define SIM_RD_SOPT2_LPUART1SRC(base) ((SIM_SOPT2_REG(base) & SIM_SOPT2_LPUART1SRC_MASK) >> SIM_SOPT2_LPUART1SRC_SHIFT)
#define SIM_BRD_SOPT2_LPUART1SRC(base) (BME_UBFX32(&SIM_SOPT2_REG(base), SIM_SOPT2_LPUART1SRC_SHIFT, SIM_SOPT2_LPUART1SRC_WIDTH))

/*! @brief Set the LPUART1SRC field to a new value. */
#define SIM_WR_SOPT2_LPUART1SRC(base, value) (SIM_RMW_SOPT2(base, SIM_SOPT2_LPUART1SRC_MASK, SIM_SOPT2_LPUART1SRC(value)))
#define SIM_BWR_SOPT2_LPUART1SRC(base, value) (BME_BFI32(&SIM_SOPT2_REG(base), ((uint32_t)(value) << SIM_SOPT2_LPUART1SRC_SHIFT), SIM_SOPT2_LPUART1SRC_SHIFT, SIM_SOPT2_LPUART1SRC_WIDTH))
/*@}*/

/*******************************************************************************
 * SIM_SOPT4 - System Options Register 4
 ******************************************************************************/

/*!
 * @brief SIM_SOPT4 - System Options Register 4 (RW)
 *
 * Reset value: 0x00000000U
 */
/*!
 * @name Constants and macros for entire SIM_SOPT4 register
 */
/*@{*/
#define SIM_RD_SOPT4(base)       (SIM_SOPT4_REG(base))
#define SIM_WR_SOPT4(base, value) (SIM_SOPT4_REG(base) = (value))
#define SIM_RMW_SOPT4(base, mask, value) (SIM_WR_SOPT4(base, (SIM_RD_SOPT4(base) & ~(mask)) | (value)))
#define SIM_SET_SOPT4(base, value) (BME_OR32(&SIM_SOPT4_REG(base), (uint32_t)(value)))
#define SIM_CLR_SOPT4(base, value) (BME_AND32(&SIM_SOPT4_REG(base), (uint32_t)(~(value))))
#define SIM_TOG_SOPT4(base, value) (BME_XOR32(&SIM_SOPT4_REG(base), (uint32_t)(value)))
/*@}*/

/*
 * Constants & macros for individual SIM_SOPT4 bitfields
 */

/*!
 * @name Register SIM_SOPT4, field TPM1CH0SRC[19:18] (RW)
 *
 * Selects the source for TPM1 channel 0 input capture. When TPM1 is not in
 * input capture mode, clear this field.
 *
 * Values:
 * - 00 - TPM1_CH0 signal
 * - 01 - CMP0 output
 * - 10 - Reserved
 * - 11 - USB start of frame pulse
 */
/*@{*/
/*! @brief Read current value of the SIM_SOPT4_TPM1CH0SRC field. */
#define SIM_RD_SOPT4_TPM1CH0SRC(base) ((SIM_SOPT4_REG(base) & SIM_SOPT4_TPM1CH0SRC_MASK) >> SIM_SOPT4_TPM1CH0SRC_SHIFT)
#define SIM_BRD_SOPT4_TPM1CH0SRC(base) (BME_UBFX32(&SIM_SOPT4_REG(base), SIM_SOPT4_TPM1CH0SRC_SHIFT, SIM_SOPT4_TPM1CH0SRC_WIDTH))

/*! @brief Set the TPM1CH0SRC field to a new value. */
#define SIM_WR_SOPT4_TPM1CH0SRC(base, value) (SIM_RMW_SOPT4(base, SIM_SOPT4_TPM1CH0SRC_MASK, SIM_SOPT4_TPM1CH0SRC(value)))
#define SIM_BWR_SOPT4_TPM1CH0SRC(base, value) (BME_BFI32(&SIM_SOPT4_REG(base), ((uint32_t)(value) << SIM_SOPT4_TPM1CH0SRC_SHIFT), SIM_SOPT4_TPM1CH0SRC_SHIFT, SIM_SOPT4_TPM1CH0SRC_WIDTH))
/*@}*/

/*!
 * @name Register SIM_SOPT4, field TPM2CH0SRC[20] (RW)
 *
 * Selects the source for TPM2 channel 0 input capture. When TPM2 is not in
 * input capture mode, clear this field.
 *
 * Values:
 * - 0 - TPM2_CH0 signal
 * - 1 - CMP0 output
 */
/*@{*/
/*! @brief Read current value of the SIM_SOPT4_TPM2CH0SRC field. */
#define SIM_RD_SOPT4_TPM2CH0SRC(base) ((SIM_SOPT4_REG(base) & SIM_SOPT4_TPM2CH0SRC_MASK) >> SIM_SOPT4_TPM2CH0SRC_SHIFT)
#define SIM_BRD_SOPT4_TPM2CH0SRC(base) (BME_UBFX32(&SIM_SOPT4_REG(base), SIM_SOPT4_TPM2CH0SRC_SHIFT, SIM_SOPT4_TPM2CH0SRC_WIDTH))

/*! @brief Set the TPM2CH0SRC field to a new value. */
#define SIM_WR_SOPT4_TPM2CH0SRC(base, value) (SIM_RMW_SOPT4(base, SIM_SOPT4_TPM2CH0SRC_MASK, SIM_SOPT4_TPM2CH0SRC(value)))
#define SIM_BWR_SOPT4_TPM2CH0SRC(base, value) (BME_BFI32(&SIM_SOPT4_REG(base), ((uint32_t)(value) << SIM_SOPT4_TPM2CH0SRC_SHIFT), SIM_SOPT4_TPM2CH0SRC_SHIFT, SIM_SOPT4_TPM2CH0SRC_WIDTH))
/*@}*/

/*!
 * @name Register SIM_SOPT4, field TPM0CLKSEL[24] (RW)
 *
 * Selects the external pin used to drive the clock to the TPM0 module. The
 * selected pin must also be configured for the TPM external clock function through
 * the appropriate pin control register in the port control module.
 *
 * Values:
 * - 0 - TPM0 external clock driven by TPM_CLKIN0 pin.
 * - 1 - TPM0 external clock driven by TPM_CLKIN1 pin.
 */
/*@{*/
/*! @brief Read current value of the SIM_SOPT4_TPM0CLKSEL field. */
#define SIM_RD_SOPT4_TPM0CLKSEL(base) ((SIM_SOPT4_REG(base) & SIM_SOPT4_TPM0CLKSEL_MASK) >> SIM_SOPT4_TPM0CLKSEL_SHIFT)
#define SIM_BRD_SOPT4_TPM0CLKSEL(base) (BME_UBFX32(&SIM_SOPT4_REG(base), SIM_SOPT4_TPM0CLKSEL_SHIFT, SIM_SOPT4_TPM0CLKSEL_WIDTH))

/*! @brief Set the TPM0CLKSEL field to a new value. */
#define SIM_WR_SOPT4_TPM0CLKSEL(base, value) (SIM_RMW_SOPT4(base, SIM_SOPT4_TPM0CLKSEL_MASK, SIM_SOPT4_TPM0CLKSEL(value)))
#define SIM_BWR_SOPT4_TPM0CLKSEL(base, value) (BME_BFI32(&SIM_SOPT4_REG(base), ((uint32_t)(value) << SIM_SOPT4_TPM0CLKSEL_SHIFT), SIM_SOPT4_TPM0CLKSEL_SHIFT, SIM_SOPT4_TPM0CLKSEL_WIDTH))
/*@}*/

/*!
 * @name Register SIM_SOPT4, field TPM1CLKSEL[25] (RW)
 *
 * Selects the external pin used to drive the clock to the TPM1 module. The
 * selected pin must also be configured for the TPM external clock function through
 * the appropriate pin control register in the port control module.
 *
 * Values:
 * - 0 - TPM1 external clock driven by TPM_CLKIN0 pin.
 * - 1 - TPM1 external clock driven by TPM_CLKIN1 pin.
 */
/*@{*/
/*! @brief Read current value of the SIM_SOPT4_TPM1CLKSEL field. */
#define SIM_RD_SOPT4_TPM1CLKSEL(base) ((SIM_SOPT4_REG(base) & SIM_SOPT4_TPM1CLKSEL_MASK) >> SIM_SOPT4_TPM1CLKSEL_SHIFT)
#define SIM_BRD_SOPT4_TPM1CLKSEL(base) (BME_UBFX32(&SIM_SOPT4_REG(base), SIM_SOPT4_TPM1CLKSEL_SHIFT, SIM_SOPT4_TPM1CLKSEL_WIDTH))

/*! @brief Set the TPM1CLKSEL field to a new value. */
#define SIM_WR_SOPT4_TPM1CLKSEL(base, value) (SIM_RMW_SOPT4(base, SIM_SOPT4_TPM1CLKSEL_MASK, SIM_SOPT4_TPM1CLKSEL(value)))
#define SIM_BWR_SOPT4_TPM1CLKSEL(base, value) (BME_BFI32(&SIM_SOPT4_REG(base), ((uint32_t)(value) << SIM_SOPT4_TPM1CLKSEL_SHIFT), SIM_SOPT4_TPM1CLKSEL_SHIFT, SIM_SOPT4_TPM1CLKSEL_WIDTH))
/*@}*/

/*!
 * @name Register SIM_SOPT4, field TPM2CLKSEL[26] (RW)
 *
 * Selects the external pin used to drive the clock to the TPM2 module. The
 * selected pin must also be configured for the TPM external clock function through
 * the appropriate Pin Control Register in the Port Control module.
 *
 * Values:
 * - 0 - TPM2 external clock driven by TPM_CLKIN0 pin.
 * - 1 - TPM2 external clock driven by TPM_CLKIN1 pin.
 */
/*@{*/
/*! @brief Read current value of the SIM_SOPT4_TPM2CLKSEL field. */
#define SIM_RD_SOPT4_TPM2CLKSEL(base) ((SIM_SOPT4_REG(base) & SIM_SOPT4_TPM2CLKSEL_MASK) >> SIM_SOPT4_TPM2CLKSEL_SHIFT)
#define SIM_BRD_SOPT4_TPM2CLKSEL(base) (BME_UBFX32(&SIM_SOPT4_REG(base), SIM_SOPT4_TPM2CLKSEL_SHIFT, SIM_SOPT4_TPM2CLKSEL_WIDTH))

/*! @brief Set the TPM2CLKSEL field to a new value. */
#define SIM_WR_SOPT4_TPM2CLKSEL(base, value) (SIM_RMW_SOPT4(base, SIM_SOPT4_TPM2CLKSEL_MASK, SIM_SOPT4_TPM2CLKSEL(value)))
#define SIM_BWR_SOPT4_TPM2CLKSEL(base, value) (BME_BFI32(&SIM_SOPT4_REG(base), ((uint32_t)(value) << SIM_SOPT4_TPM2CLKSEL_SHIFT), SIM_SOPT4_TPM2CLKSEL_SHIFT, SIM_SOPT4_TPM2CLKSEL_WIDTH))
/*@}*/

/*******************************************************************************
 * SIM_SOPT5 - System Options Register 5
 ******************************************************************************/

/*!
 * @brief SIM_SOPT5 - System Options Register 5 (RW)
 *
 * Reset value: 0x00000000U
 */
/*!
 * @name Constants and macros for entire SIM_SOPT5 register
 */
/*@{*/
#define SIM_RD_SOPT5(base)       (SIM_SOPT5_REG(base))
#define SIM_WR_SOPT5(base, value) (SIM_SOPT5_REG(base) = (value))
#define SIM_RMW_SOPT5(base, mask, value) (SIM_WR_SOPT5(base, (SIM_RD_SOPT5(base) & ~(mask)) | (value)))
#define SIM_SET_SOPT5(base, value) (BME_OR32(&SIM_SOPT5_REG(base), (uint32_t)(value)))
#define SIM_CLR_SOPT5(base, value) (BME_AND32(&SIM_SOPT5_REG(base), (uint32_t)(~(value))))
#define SIM_TOG_SOPT5(base, value) (BME_XOR32(&SIM_SOPT5_REG(base), (uint32_t)(value)))
/*@}*/

/*
 * Constants & macros for individual SIM_SOPT5 bitfields
 */

/*!
 * @name Register SIM_SOPT5, field LPUART0TXSRC[1:0] (RW)
 *
 * Selects the source for the LPUART0 transmit data.
 *
 * Values:
 * - 00 - LPUART0_TX pin
 * - 01 - LPUART0_TX pin modulated with TPM1 channel 0 output
 * - 10 - LPUART0_TX pin modulated with TPM2 channel 0 output
 * - 11 - Reserved
 */
/*@{*/
/*! @brief Read current value of the SIM_SOPT5_LPUART0TXSRC field. */
#define SIM_RD_SOPT5_LPUART0TXSRC(base) ((SIM_SOPT5_REG(base) & SIM_SOPT5_LPUART0TXSRC_MASK) >> SIM_SOPT5_LPUART0TXSRC_SHIFT)
#define SIM_BRD_SOPT5_LPUART0TXSRC(base) (BME_UBFX32(&SIM_SOPT5_REG(base), SIM_SOPT5_LPUART0TXSRC_SHIFT, SIM_SOPT5_LPUART0TXSRC_WIDTH))

/*! @brief Set the LPUART0TXSRC field to a new value. */
#define SIM_WR_SOPT5_LPUART0TXSRC(base, value) (SIM_RMW_SOPT5(base, SIM_SOPT5_LPUART0TXSRC_MASK, SIM_SOPT5_LPUART0TXSRC(value)))
#define SIM_BWR_SOPT5_LPUART0TXSRC(base, value) (BME_BFI32(&SIM_SOPT5_REG(base), ((uint32_t)(value) << SIM_SOPT5_LPUART0TXSRC_SHIFT), SIM_SOPT5_LPUART0TXSRC_SHIFT, SIM_SOPT5_LPUART0TXSRC_WIDTH))
/*@}*/

/*!
 * @name Register SIM_SOPT5, field LPUART0RXSRC[2] (RW)
 *
 * Selects the source for the LPUART0 receive data.
 *
 * Values:
 * - 0 - LPUART_RX pin
 * - 1 - CMP0 output
 */
/*@{*/
/*! @brief Read current value of the SIM_SOPT5_LPUART0RXSRC field. */
#define SIM_RD_SOPT5_LPUART0RXSRC(base) ((SIM_SOPT5_REG(base) & SIM_SOPT5_LPUART0RXSRC_MASK) >> SIM_SOPT5_LPUART0RXSRC_SHIFT)
#define SIM_BRD_SOPT5_LPUART0RXSRC(base) (BME_UBFX32(&SIM_SOPT5_REG(base), SIM_SOPT5_LPUART0RXSRC_SHIFT, SIM_SOPT5_LPUART0RXSRC_WIDTH))

/*! @brief Set the LPUART0RXSRC field to a new value. */
#define SIM_WR_SOPT5_LPUART0RXSRC(base, value) (SIM_RMW_SOPT5(base, SIM_SOPT5_LPUART0RXSRC_MASK, SIM_SOPT5_LPUART0RXSRC(value)))
#define SIM_BWR_SOPT5_LPUART0RXSRC(base, value) (BME_BFI32(&SIM_SOPT5_REG(base), ((uint32_t)(value) << SIM_SOPT5_LPUART0RXSRC_SHIFT), SIM_SOPT5_LPUART0RXSRC_SHIFT, SIM_SOPT5_LPUART0RXSRC_WIDTH))
/*@}*/

/*!
 * @name Register SIM_SOPT5, field LPUART1TXSRC[5:4] (RW)
 *
 * Selects the source for the LPUART1 transmit data.
 *
 * Values:
 * - 00 - LPUART1_TX pin
 * - 01 - LPUART1_TX pin modulated with TPM1 channel 0 output
 * - 10 - LPUART1_TX pin modulated with TPM2 channel 0 output
 * - 11 - Reserved
 */
/*@{*/
/*! @brief Read current value of the SIM_SOPT5_LPUART1TXSRC field. */
#define SIM_RD_SOPT5_LPUART1TXSRC(base) ((SIM_SOPT5_REG(base) & SIM_SOPT5_LPUART1TXSRC_MASK) >> SIM_SOPT5_LPUART1TXSRC_SHIFT)
#define SIM_BRD_SOPT5_LPUART1TXSRC(base) (BME_UBFX32(&SIM_SOPT5_REG(base), SIM_SOPT5_LPUART1TXSRC_SHIFT, SIM_SOPT5_LPUART1TXSRC_WIDTH))

/*! @brief Set the LPUART1TXSRC field to a new value. */
#define SIM_WR_SOPT5_LPUART1TXSRC(base, value) (SIM_RMW_SOPT5(base, SIM_SOPT5_LPUART1TXSRC_MASK, SIM_SOPT5_LPUART1TXSRC(value)))
#define SIM_BWR_SOPT5_LPUART1TXSRC(base, value) (BME_BFI32(&SIM_SOPT5_REG(base), ((uint32_t)(value) << SIM_SOPT5_LPUART1TXSRC_SHIFT), SIM_SOPT5_LPUART1TXSRC_SHIFT, SIM_SOPT5_LPUART1TXSRC_WIDTH))
/*@}*/

/*!
 * @name Register SIM_SOPT5, field LPUART1RXSRC[6] (RW)
 *
 * Selects the source for the LPUART1 receive data.
 *
 * Values:
 * - 0 - LPUART1_RX pin
 * - 1 - CMP0 output
 */
/*@{*/
/*! @brief Read current value of the SIM_SOPT5_LPUART1RXSRC field. */
#define SIM_RD_SOPT5_LPUART1RXSRC(base) ((SIM_SOPT5_REG(base) & SIM_SOPT5_LPUART1RXSRC_MASK) >> SIM_SOPT5_LPUART1RXSRC_SHIFT)
#define SIM_BRD_SOPT5_LPUART1RXSRC(base) (BME_UBFX32(&SIM_SOPT5_REG(base), SIM_SOPT5_LPUART1RXSRC_SHIFT, SIM_SOPT5_LPUART1RXSRC_WIDTH))

/*! @brief Set the LPUART1RXSRC field to a new value. */
#define SIM_WR_SOPT5_LPUART1RXSRC(base, value) (SIM_RMW_SOPT5(base, SIM_SOPT5_LPUART1RXSRC_MASK, SIM_SOPT5_LPUART1RXSRC(value)))
#define SIM_BWR_SOPT5_LPUART1RXSRC(base, value) (BME_BFI32(&SIM_SOPT5_REG(base), ((uint32_t)(value) << SIM_SOPT5_LPUART1RXSRC_SHIFT), SIM_SOPT5_LPUART1RXSRC_SHIFT, SIM_SOPT5_LPUART1RXSRC_WIDTH))
/*@}*/

/*!
 * @name Register SIM_SOPT5, field LPUART0ODE[16] (RW)
 *
 * Values:
 * - 0 - Open drain is disabled on LPUART0.
 * - 1 - Open drain is enabled on LPUART0.
 */
/*@{*/
/*! @brief Read current value of the SIM_SOPT5_LPUART0ODE field. */
#define SIM_RD_SOPT5_LPUART0ODE(base) ((SIM_SOPT5_REG(base) & SIM_SOPT5_LPUART0ODE_MASK) >> SIM_SOPT5_LPUART0ODE_SHIFT)
#define SIM_BRD_SOPT5_LPUART0ODE(base) (BME_UBFX32(&SIM_SOPT5_REG(base), SIM_SOPT5_LPUART0ODE_SHIFT, SIM_SOPT5_LPUART0ODE_WIDTH))

/*! @brief Set the LPUART0ODE field to a new value. */
#define SIM_WR_SOPT5_LPUART0ODE(base, value) (SIM_RMW_SOPT5(base, SIM_SOPT5_LPUART0ODE_MASK, SIM_SOPT5_LPUART0ODE(value)))
#define SIM_BWR_SOPT5_LPUART0ODE(base, value) (BME_BFI32(&SIM_SOPT5_REG(base), ((uint32_t)(value) << SIM_SOPT5_LPUART0ODE_SHIFT), SIM_SOPT5_LPUART0ODE_SHIFT, SIM_SOPT5_LPUART0ODE_WIDTH))
/*@}*/

/*!
 * @name Register SIM_SOPT5, field LPUART1ODE[17] (RW)
 *
 * Values:
 * - 0 - Open drain is disabled on LPUART1.
 * - 1 - Open drain is enabled on LPUART1
 */
/*@{*/
/*! @brief Read current value of the SIM_SOPT5_LPUART1ODE field. */
#define SIM_RD_SOPT5_LPUART1ODE(base) ((SIM_SOPT5_REG(base) & SIM_SOPT5_LPUART1ODE_MASK) >> SIM_SOPT5_LPUART1ODE_SHIFT)
#define SIM_BRD_SOPT5_LPUART1ODE(base) (BME_UBFX32(&SIM_SOPT5_REG(base), SIM_SOPT5_LPUART1ODE_SHIFT, SIM_SOPT5_LPUART1ODE_WIDTH))

/*! @brief Set the LPUART1ODE field to a new value. */
#define SIM_WR_SOPT5_LPUART1ODE(base, value) (SIM_RMW_SOPT5(base, SIM_SOPT5_LPUART1ODE_MASK, SIM_SOPT5_LPUART1ODE(value)))
#define SIM_BWR_SOPT5_LPUART1ODE(base, value) (BME_BFI32(&SIM_SOPT5_REG(base), ((uint32_t)(value) << SIM_SOPT5_LPUART1ODE_SHIFT), SIM_SOPT5_LPUART1ODE_SHIFT, SIM_SOPT5_LPUART1ODE_WIDTH))
/*@}*/

/*!
 * @name Register SIM_SOPT5, field UART2ODE[18] (RW)
 *
 * Values:
 * - 0 - Open drain is disabled on UART2
 * - 1 - Open drain is enabled on UART2
 */
/*@{*/
/*! @brief Read current value of the SIM_SOPT5_UART2ODE field. */
#define SIM_RD_SOPT5_UART2ODE(base) ((SIM_SOPT5_REG(base) & SIM_SOPT5_UART2ODE_MASK) >> SIM_SOPT5_UART2ODE_SHIFT)
#define SIM_BRD_SOPT5_UART2ODE(base) (BME_UBFX32(&SIM_SOPT5_REG(base), SIM_SOPT5_UART2ODE_SHIFT, SIM_SOPT5_UART2ODE_WIDTH))

/*! @brief Set the UART2ODE field to a new value. */
#define SIM_WR_SOPT5_UART2ODE(base, value) (SIM_RMW_SOPT5(base, SIM_SOPT5_UART2ODE_MASK, SIM_SOPT5_UART2ODE(value)))
#define SIM_BWR_SOPT5_UART2ODE(base, value) (BME_BFI32(&SIM_SOPT5_REG(base), ((uint32_t)(value) << SIM_SOPT5_UART2ODE_SHIFT), SIM_SOPT5_UART2ODE_SHIFT, SIM_SOPT5_UART2ODE_WIDTH))
/*@}*/

/*******************************************************************************
 * SIM_SOPT7 - System Options Register 7
 ******************************************************************************/

/*!
 * @brief SIM_SOPT7 - System Options Register 7 (RW)
 *
 * Reset value: 0x00000000U
 */
/*!
 * @name Constants and macros for entire SIM_SOPT7 register
 */
/*@{*/
#define SIM_RD_SOPT7(base)       (SIM_SOPT7_REG(base))
#define SIM_WR_SOPT7(base, value) (SIM_SOPT7_REG(base) = (value))
#define SIM_RMW_SOPT7(base, mask, value) (SIM_WR_SOPT7(base, (SIM_RD_SOPT7(base) & ~(mask)) | (value)))
#define SIM_SET_SOPT7(base, value) (BME_OR32(&SIM_SOPT7_REG(base), (uint32_t)(value)))
#define SIM_CLR_SOPT7(base, value) (BME_AND32(&SIM_SOPT7_REG(base), (uint32_t)(~(value))))
#define SIM_TOG_SOPT7(base, value) (BME_XOR32(&SIM_SOPT7_REG(base), (uint32_t)(value)))
/*@}*/

/*
 * Constants & macros for individual SIM_SOPT7 bitfields
 */

/*!
 * @name Register SIM_SOPT7, field ADC0TRGSEL[3:0] (RW)
 *
 * Selects 1 of 16 peripherals to initiate an ADC conversion via the ADHWDT
 * input, when ADC0ALTTRGEN =1, else is ignored by ADC0.
 *
 * Values:
 * - 0000 - External trigger pin input (EXTRG_IN)
 * - 0001 - CMP0 output
 * - 0010 - Reserved
 * - 0011 - Reserved
 * - 0100 - PIT trigger 0
 * - 0101 - PIT trigger 1
 * - 0110 - Reserved
 * - 0111 - Reserved
 * - 1000 - TPM0 overflow
 * - 1001 - TPM1 overflow
 * - 1010 - TPM2 overflow
 * - 1011 - Reserved
 * - 1100 - RTC alarm
 * - 1101 - RTC seconds
 * - 1110 - LPTMR0 trigger
 * - 1111 - Reserved
 */
/*@{*/
/*! @brief Read current value of the SIM_SOPT7_ADC0TRGSEL field. */
#define SIM_RD_SOPT7_ADC0TRGSEL(base) ((SIM_SOPT7_REG(base) & SIM_SOPT7_ADC0TRGSEL_MASK) >> SIM_SOPT7_ADC0TRGSEL_SHIFT)
#define SIM_BRD_SOPT7_ADC0TRGSEL(base) (BME_UBFX32(&SIM_SOPT7_REG(base), SIM_SOPT7_ADC0TRGSEL_SHIFT, SIM_SOPT7_ADC0TRGSEL_WIDTH))

/*! @brief Set the ADC0TRGSEL field to a new value. */
#define SIM_WR_SOPT7_ADC0TRGSEL(base, value) (SIM_RMW_SOPT7(base, SIM_SOPT7_ADC0TRGSEL_MASK, SIM_SOPT7_ADC0TRGSEL(value)))
#define SIM_BWR_SOPT7_ADC0TRGSEL(base, value) (BME_BFI32(&SIM_SOPT7_REG(base), ((uint32_t)(value) << SIM_SOPT7_ADC0TRGSEL_SHIFT), SIM_SOPT7_ADC0TRGSEL_SHIFT, SIM_SOPT7_ADC0TRGSEL_WIDTH))
/*@}*/

/*!
 * @name Register SIM_SOPT7, field ADC0PRETRGSEL[4] (RW)
 *
 * Selects the ADC0 pre-trigger source when alternative triggers are enabled
 * through ADC0ALTTRGEN.The ADC0PRETRGSEL function is ignored if ADC0ALTTRGEN = 0.
 *
 * Values:
 * - 0 - Pre-trigger ADHDWTSA is selected, thus ADC0 will use ADC0_SC1A
 *     configuration for the next ADC conversion and store the result in ADC0_RA register.
 * - 1 - Pre-trigger ADHDWTSB is selected, thus ADC0 will use ADC0_SC1B
 *     configuration for the next ADC conversion and store the result in ADC0_RB register.
 */
/*@{*/
/*! @brief Read current value of the SIM_SOPT7_ADC0PRETRGSEL field. */
#define SIM_RD_SOPT7_ADC0PRETRGSEL(base) ((SIM_SOPT7_REG(base) & SIM_SOPT7_ADC0PRETRGSEL_MASK) >> SIM_SOPT7_ADC0PRETRGSEL_SHIFT)
#define SIM_BRD_SOPT7_ADC0PRETRGSEL(base) (BME_UBFX32(&SIM_SOPT7_REG(base), SIM_SOPT7_ADC0PRETRGSEL_SHIFT, SIM_SOPT7_ADC0PRETRGSEL_WIDTH))

/*! @brief Set the ADC0PRETRGSEL field to a new value. */
#define SIM_WR_SOPT7_ADC0PRETRGSEL(base, value) (SIM_RMW_SOPT7(base, SIM_SOPT7_ADC0PRETRGSEL_MASK, SIM_SOPT7_ADC0PRETRGSEL(value)))
#define SIM_BWR_SOPT7_ADC0PRETRGSEL(base, value) (BME_BFI32(&SIM_SOPT7_REG(base), ((uint32_t)(value) << SIM_SOPT7_ADC0PRETRGSEL_SHIFT), SIM_SOPT7_ADC0PRETRGSEL_SHIFT, SIM_SOPT7_ADC0PRETRGSEL_WIDTH))
/*@}*/

/*!
 * @name Register SIM_SOPT7, field ADC0ALTTRGEN[7] (RW)
 *
 * Enables alternative conversion triggers for ADC0.
 *
 * Values:
 * - 0 - ADC ADHWT trigger comes from TPM1 channel 0 and channel1. Prior to the
 *     assertion of TPM1 channel 0, a pre-trigger pulse will be sent to ADHWTSA
 *     to initiate an ADC acquisition using ADCx_SC1A configuration and store ADC
 *     conversion in ADCx_RA Register. Prior to the assertion of TPM1 channel 1 a
 *     pre-trigger pulse will be sent to ADHWTSB to initiate an ADC acquisition
 *     using ADCx_SC1Bconfiguration and store ADC conversion in ADCx_RB Register.
 * - 1 - ADC ADHWT trigger comes from a peripheral event selected by ADC0TRGSEL
 *     bits.ADC0PRETRGSEL bit will select the optional ADHWTSA or ADHWTSB select
 *     lines for choosing the ADCx_SC1x config and ADCx_Rx result regsiter to
 *     store the ADC conversion.
 */
/*@{*/
/*! @brief Read current value of the SIM_SOPT7_ADC0ALTTRGEN field. */
#define SIM_RD_SOPT7_ADC0ALTTRGEN(base) ((SIM_SOPT7_REG(base) & SIM_SOPT7_ADC0ALTTRGEN_MASK) >> SIM_SOPT7_ADC0ALTTRGEN_SHIFT)
#define SIM_BRD_SOPT7_ADC0ALTTRGEN(base) (BME_UBFX32(&SIM_SOPT7_REG(base), SIM_SOPT7_ADC0ALTTRGEN_SHIFT, SIM_SOPT7_ADC0ALTTRGEN_WIDTH))

/*! @brief Set the ADC0ALTTRGEN field to a new value. */
#define SIM_WR_SOPT7_ADC0ALTTRGEN(base, value) (SIM_RMW_SOPT7(base, SIM_SOPT7_ADC0ALTTRGEN_MASK, SIM_SOPT7_ADC0ALTTRGEN(value)))
#define SIM_BWR_SOPT7_ADC0ALTTRGEN(base, value) (BME_BFI32(&SIM_SOPT7_REG(base), ((uint32_t)(value) << SIM_SOPT7_ADC0ALTTRGEN_SHIFT), SIM_SOPT7_ADC0ALTTRGEN_SHIFT, SIM_SOPT7_ADC0ALTTRGEN_WIDTH))
/*@}*/

/*******************************************************************************
 * SIM_SDID - System Device Identification Register
 ******************************************************************************/

/*!
 * @brief SIM_SDID - System Device Identification Register (RO)
 *
 * Reset value: 0x00100C80U
 */
/*!
 * @name Constants and macros for entire SIM_SDID register
 */
/*@{*/
#define SIM_RD_SDID(base)        (SIM_SDID_REG(base))
/*@}*/

/*
 * Constants & macros for individual SIM_SDID bitfields
 */

/*!
 * @name Register SIM_SDID, field PINID[3:0] (RO)
 *
 * Specifies the pincount of the device.
 *
 * Values:
 * - 0010 - 32-pin
 * - 0100 - 48-pin
 * - 0101 - 64-pin
 * - 1011 - Custom pinout (WLCSP)
 */
/*@{*/
/*! @brief Read current value of the SIM_SDID_PINID field. */
#define SIM_RD_SDID_PINID(base) ((SIM_SDID_REG(base) & SIM_SDID_PINID_MASK) >> SIM_SDID_PINID_SHIFT)
#define SIM_BRD_SDID_PINID(base) (BME_UBFX32(&SIM_SDID_REG(base), SIM_SDID_PINID_SHIFT, SIM_SDID_PINID_WIDTH))
/*@}*/

/*!
 * @name Register SIM_SDID, field REVID[15:12] (RO)
 *
 * Specifies the silicon implementation number for the device.
 */
/*@{*/
/*! @brief Read current value of the SIM_SDID_REVID field. */
#define SIM_RD_SDID_REVID(base) ((SIM_SDID_REG(base) & SIM_SDID_REVID_MASK) >> SIM_SDID_REVID_SHIFT)
#define SIM_BRD_SDID_REVID(base) (BME_UBFX32(&SIM_SDID_REG(base), SIM_SDID_REVID_SHIFT, SIM_SDID_REVID_WIDTH))
/*@}*/

/*!
 * @name Register SIM_SDID, field SRAMSIZE[19:16] (RO)
 *
 * Specifies the size of the System SRAM
 *
 * Values:
 * - 0100 - 8 KB
 * - 0101 - 16 KB
 */
/*@{*/
/*! @brief Read current value of the SIM_SDID_SRAMSIZE field. */
#define SIM_RD_SDID_SRAMSIZE(base) ((SIM_SDID_REG(base) & SIM_SDID_SRAMSIZE_MASK) >> SIM_SDID_SRAMSIZE_SHIFT)
#define SIM_BRD_SDID_SRAMSIZE(base) (BME_UBFX32(&SIM_SDID_REG(base), SIM_SDID_SRAMSIZE_SHIFT, SIM_SDID_SRAMSIZE_WIDTH))
/*@}*/

/*!
 * @name Register SIM_SDID, field SERIESID[23:20] (RO)
 *
 * Specifies the Kinetis family of the device.
 *
 * Values:
 * - 0001 - KL family
 */
/*@{*/
/*! @brief Read current value of the SIM_SDID_SERIESID field. */
#define SIM_RD_SDID_SERIESID(base) ((SIM_SDID_REG(base) & SIM_SDID_SERIESID_MASK) >> SIM_SDID_SERIESID_SHIFT)
#define SIM_BRD_SDID_SERIESID(base) (BME_UBFX32(&SIM_SDID_REG(base), SIM_SDID_SERIESID_SHIFT, SIM_SDID_SERIESID_WIDTH))
/*@}*/

/*!
 * @name Register SIM_SDID, field SUBFAMID[27:24] (RO)
 *
 * Specifies the Kinetis sub-family of the device.
 *
 * Values:
 * - 0111 - KLx7 Subfamily
 */
/*@{*/
/*! @brief Read current value of the SIM_SDID_SUBFAMID field. */
#define SIM_RD_SDID_SUBFAMID(base) ((SIM_SDID_REG(base) & SIM_SDID_SUBFAMID_MASK) >> SIM_SDID_SUBFAMID_SHIFT)
#define SIM_BRD_SDID_SUBFAMID(base) (BME_UBFX32(&SIM_SDID_REG(base), SIM_SDID_SUBFAMID_SHIFT, SIM_SDID_SUBFAMID_WIDTH))
/*@}*/

/*!
 * @name Register SIM_SDID, field FAMID[31:28] (RO)
 *
 * Family ID
 *
 * Values:
 * - 0001 - KL17
 * - 0010 - KL27
 */
/*@{*/
/*! @brief Read current value of the SIM_SDID_FAMID field. */
#define SIM_RD_SDID_FAMID(base) ((SIM_SDID_REG(base) & SIM_SDID_FAMID_MASK) >> SIM_SDID_FAMID_SHIFT)
#define SIM_BRD_SDID_FAMID(base) (BME_UBFX32(&SIM_SDID_REG(base), SIM_SDID_FAMID_SHIFT, SIM_SDID_FAMID_WIDTH))
/*@}*/

/*******************************************************************************
 * SIM_SCGC4 - System Clock Gating Control Register 4
 ******************************************************************************/

/*!
 * @brief SIM_SCGC4 - System Clock Gating Control Register 4 (RW)
 *
 * Reset value: 0xF0000030U
 */
/*!
 * @name Constants and macros for entire SIM_SCGC4 register
 */
/*@{*/
#define SIM_RD_SCGC4(base)       (SIM_SCGC4_REG(base))
#define SIM_WR_SCGC4(base, value) (SIM_SCGC4_REG(base) = (value))
#define SIM_RMW_SCGC4(base, mask, value) (SIM_WR_SCGC4(base, (SIM_RD_SCGC4(base) & ~(mask)) | (value)))
#define SIM_SET_SCGC4(base, value) (BME_OR32(&SIM_SCGC4_REG(base), (uint32_t)(value)))
#define SIM_CLR_SCGC4(base, value) (BME_AND32(&SIM_SCGC4_REG(base), (uint32_t)(~(value))))
#define SIM_TOG_SCGC4(base, value) (BME_XOR32(&SIM_SCGC4_REG(base), (uint32_t)(value)))
/*@}*/

/* Unified clock gate bit access macros */
#define SIM_SCGC_BIT_REG(base, index)        (*((volatile uint32_t *)&SIM_SCGC4_REG(base) + (((uint32_t)(index) >> 5) - 3U)))
#define SIM_SCGC_BIT_SHIFT(index)            ((uint32_t)(index) & ((1U << 5) - 1U))
#define SIM_RD_SCGC_BIT(base, index)         (SIM_SCGC_BIT_REG((base), (index)) & (1U << SIM_SCGC_BIT_SHIFT(index)))
#define SIM_BRD_SCGC_BIT(base, index)        (BME_UBFX32(&SIM_SCGC_BIT_REG((base), (index)), SIM_SCGC_BIT_SHIFT(index), 1))
#define SIM_WR_SCGC_BIT(base, index, value)  (SIM_SCGC_BIT_REG((base), (index)) = (SIM_SCGC_BIT_REG((base), (index)) & ~(1U << SIM_SCGC_BIT_SHIFT(index))) | ((uint32_t)(value) << SIM_SCGC_BIT_SHIFT(index)))
#define SIM_BWR_SCGC_BIT(base, index, value) (BME_BFI32(&SIM_SCGC_BIT_REG((base), (index)), ((uint32_t)(value) << SIM_SCGC_BIT_SHIFT(index)), SIM_SCGC_BIT_SHIFT(index), 1))

/*
 * Constants & macros for individual SIM_SCGC4 bitfields
 */

/*!
 * @name Register SIM_SCGC4, field I2C0[6] (RW)
 *
 * Controls the clock gate to the I2C0 module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
/*@{*/
/*! @brief Read current value of the SIM_SCGC4_I2C0 field. */
#define SIM_RD_SCGC4_I2C0(base) ((SIM_SCGC4_REG(base) & SIM_SCGC4_I2C0_MASK) >> SIM_SCGC4_I2C0_SHIFT)
#define SIM_BRD_SCGC4_I2C0(base) (BME_UBFX32(&SIM_SCGC4_REG(base), SIM_SCGC4_I2C0_SHIFT, SIM_SCGC4_I2C0_WIDTH))

/*! @brief Set the I2C0 field to a new value. */
#define SIM_WR_SCGC4_I2C0(base, value) (SIM_RMW_SCGC4(base, SIM_SCGC4_I2C0_MASK, SIM_SCGC4_I2C0(value)))
#define SIM_BWR_SCGC4_I2C0(base, value) (BME_BFI32(&SIM_SCGC4_REG(base), ((uint32_t)(value) << SIM_SCGC4_I2C0_SHIFT), SIM_SCGC4_I2C0_SHIFT, SIM_SCGC4_I2C0_WIDTH))
/*@}*/

/*!
 * @name Register SIM_SCGC4, field I2C1[7] (RW)
 *
 * Controls the clock gate to the I2C1 module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
/*@{*/
/*! @brief Read current value of the SIM_SCGC4_I2C1 field. */
#define SIM_RD_SCGC4_I2C1(base) ((SIM_SCGC4_REG(base) & SIM_SCGC4_I2C1_MASK) >> SIM_SCGC4_I2C1_SHIFT)
#define SIM_BRD_SCGC4_I2C1(base) (BME_UBFX32(&SIM_SCGC4_REG(base), SIM_SCGC4_I2C1_SHIFT, SIM_SCGC4_I2C1_WIDTH))

/*! @brief Set the I2C1 field to a new value. */
#define SIM_WR_SCGC4_I2C1(base, value) (SIM_RMW_SCGC4(base, SIM_SCGC4_I2C1_MASK, SIM_SCGC4_I2C1(value)))
#define SIM_BWR_SCGC4_I2C1(base, value) (BME_BFI32(&SIM_SCGC4_REG(base), ((uint32_t)(value) << SIM_SCGC4_I2C1_SHIFT), SIM_SCGC4_I2C1_SHIFT, SIM_SCGC4_I2C1_WIDTH))
/*@}*/

/*!
 * @name Register SIM_SCGC4, field UART2[12] (RW)
 *
 * Controls the clock gate to the UART2 module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
/*@{*/
/*! @brief Read current value of the SIM_SCGC4_UART2 field. */
#define SIM_RD_SCGC4_UART2(base) ((SIM_SCGC4_REG(base) & SIM_SCGC4_UART2_MASK) >> SIM_SCGC4_UART2_SHIFT)
#define SIM_BRD_SCGC4_UART2(base) (BME_UBFX32(&SIM_SCGC4_REG(base), SIM_SCGC4_UART2_SHIFT, SIM_SCGC4_UART2_WIDTH))

/*! @brief Set the UART2 field to a new value. */
#define SIM_WR_SCGC4_UART2(base, value) (SIM_RMW_SCGC4(base, SIM_SCGC4_UART2_MASK, SIM_SCGC4_UART2(value)))
#define SIM_BWR_SCGC4_UART2(base, value) (BME_BFI32(&SIM_SCGC4_REG(base), ((uint32_t)(value) << SIM_SCGC4_UART2_SHIFT), SIM_SCGC4_UART2_SHIFT, SIM_SCGC4_UART2_WIDTH))
/*@}*/

/*!
 * @name Register SIM_SCGC4, field USBFS[18] (RW)
 *
 * This bit controls the clock gate to the USB module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
/*@{*/
/*! @brief Read current value of the SIM_SCGC4_USBFS field. */
#define SIM_RD_SCGC4_USBFS(base) ((SIM_SCGC4_REG(base) & SIM_SCGC4_USBFS_MASK) >> SIM_SCGC4_USBFS_SHIFT)
#define SIM_BRD_SCGC4_USBFS(base) (BME_UBFX32(&SIM_SCGC4_REG(base), SIM_SCGC4_USBFS_SHIFT, SIM_SCGC4_USBFS_WIDTH))

/*! @brief Set the USBFS field to a new value. */
#define SIM_WR_SCGC4_USBFS(base, value) (SIM_RMW_SCGC4(base, SIM_SCGC4_USBFS_MASK, SIM_SCGC4_USBFS(value)))
#define SIM_BWR_SCGC4_USBFS(base, value) (BME_BFI32(&SIM_SCGC4_REG(base), ((uint32_t)(value) << SIM_SCGC4_USBFS_SHIFT), SIM_SCGC4_USBFS_SHIFT, SIM_SCGC4_USBFS_WIDTH))
/*@}*/

/*!
 * @name Register SIM_SCGC4, field CMP0[19] (RW)
 *
 * Controls the clock gate to the comparator module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
/*@{*/
/*! @brief Read current value of the SIM_SCGC4_CMP0 field. */
#define SIM_RD_SCGC4_CMP0(base) ((SIM_SCGC4_REG(base) & SIM_SCGC4_CMP0_MASK) >> SIM_SCGC4_CMP0_SHIFT)
#define SIM_BRD_SCGC4_CMP0(base) (BME_UBFX32(&SIM_SCGC4_REG(base), SIM_SCGC4_CMP0_SHIFT, SIM_SCGC4_CMP0_WIDTH))

/*! @brief Set the CMP0 field to a new value. */
#define SIM_WR_SCGC4_CMP0(base, value) (SIM_RMW_SCGC4(base, SIM_SCGC4_CMP0_MASK, SIM_SCGC4_CMP0(value)))
#define SIM_BWR_SCGC4_CMP0(base, value) (BME_BFI32(&SIM_SCGC4_REG(base), ((uint32_t)(value) << SIM_SCGC4_CMP0_SHIFT), SIM_SCGC4_CMP0_SHIFT, SIM_SCGC4_CMP0_WIDTH))
/*@}*/

/*!
 * @name Register SIM_SCGC4, field VREF[20] (RW)
 *
 * Controls the clock gate to the VREF module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
/*@{*/
/*! @brief Read current value of the SIM_SCGC4_VREF field. */
#define SIM_RD_SCGC4_VREF(base) ((SIM_SCGC4_REG(base) & SIM_SCGC4_VREF_MASK) >> SIM_SCGC4_VREF_SHIFT)
#define SIM_BRD_SCGC4_VREF(base) (BME_UBFX32(&SIM_SCGC4_REG(base), SIM_SCGC4_VREF_SHIFT, SIM_SCGC4_VREF_WIDTH))

/*! @brief Set the VREF field to a new value. */
#define SIM_WR_SCGC4_VREF(base, value) (SIM_RMW_SCGC4(base, SIM_SCGC4_VREF_MASK, SIM_SCGC4_VREF(value)))
#define SIM_BWR_SCGC4_VREF(base, value) (BME_BFI32(&SIM_SCGC4_REG(base), ((uint32_t)(value) << SIM_SCGC4_VREF_SHIFT), SIM_SCGC4_VREF_SHIFT, SIM_SCGC4_VREF_WIDTH))
/*@}*/

/*!
 * @name Register SIM_SCGC4, field SPI0[22] (RW)
 *
 * Controls the clock gate to the SPI0 module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
/*@{*/
/*! @brief Read current value of the SIM_SCGC4_SPI0 field. */
#define SIM_RD_SCGC4_SPI0(base) ((SIM_SCGC4_REG(base) & SIM_SCGC4_SPI0_MASK) >> SIM_SCGC4_SPI0_SHIFT)
#define SIM_BRD_SCGC4_SPI0(base) (BME_UBFX32(&SIM_SCGC4_REG(base), SIM_SCGC4_SPI0_SHIFT, SIM_SCGC4_SPI0_WIDTH))

/*! @brief Set the SPI0 field to a new value. */
#define SIM_WR_SCGC4_SPI0(base, value) (SIM_RMW_SCGC4(base, SIM_SCGC4_SPI0_MASK, SIM_SCGC4_SPI0(value)))
#define SIM_BWR_SCGC4_SPI0(base, value) (BME_BFI32(&SIM_SCGC4_REG(base), ((uint32_t)(value) << SIM_SCGC4_SPI0_SHIFT), SIM_SCGC4_SPI0_SHIFT, SIM_SCGC4_SPI0_WIDTH))
/*@}*/

/*!
 * @name Register SIM_SCGC4, field SPI1[23] (RW)
 *
 * Controls the clock gate to the SPI1 module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
/*@{*/
/*! @brief Read current value of the SIM_SCGC4_SPI1 field. */
#define SIM_RD_SCGC4_SPI1(base) ((SIM_SCGC4_REG(base) & SIM_SCGC4_SPI1_MASK) >> SIM_SCGC4_SPI1_SHIFT)
#define SIM_BRD_SCGC4_SPI1(base) (BME_UBFX32(&SIM_SCGC4_REG(base), SIM_SCGC4_SPI1_SHIFT, SIM_SCGC4_SPI1_WIDTH))

/*! @brief Set the SPI1 field to a new value. */
#define SIM_WR_SCGC4_SPI1(base, value) (SIM_RMW_SCGC4(base, SIM_SCGC4_SPI1_MASK, SIM_SCGC4_SPI1(value)))
#define SIM_BWR_SCGC4_SPI1(base, value) (BME_BFI32(&SIM_SCGC4_REG(base), ((uint32_t)(value) << SIM_SCGC4_SPI1_SHIFT), SIM_SCGC4_SPI1_SHIFT, SIM_SCGC4_SPI1_WIDTH))
/*@}*/

/*******************************************************************************
 * SIM_SCGC5 - System Clock Gating Control Register 5
 ******************************************************************************/

/*!
 * @brief SIM_SCGC5 - System Clock Gating Control Register 5 (RW)
 *
 * Reset value: 0x00000182U
 */
/*!
 * @name Constants and macros for entire SIM_SCGC5 register
 */
/*@{*/
#define SIM_RD_SCGC5(base)       (SIM_SCGC5_REG(base))
#define SIM_WR_SCGC5(base, value) (SIM_SCGC5_REG(base) = (value))
#define SIM_RMW_SCGC5(base, mask, value) (SIM_WR_SCGC5(base, (SIM_RD_SCGC5(base) & ~(mask)) | (value)))
#define SIM_SET_SCGC5(base, value) (BME_OR32(&SIM_SCGC5_REG(base), (uint32_t)(value)))
#define SIM_CLR_SCGC5(base, value) (BME_AND32(&SIM_SCGC5_REG(base), (uint32_t)(~(value))))
#define SIM_TOG_SCGC5(base, value) (BME_XOR32(&SIM_SCGC5_REG(base), (uint32_t)(value)))
/*@}*/

/*
 * Constants & macros for individual SIM_SCGC5 bitfields
 */

/*!
 * @name Register SIM_SCGC5, field LPTMR[0] (RW)
 *
 * Controls software access to the Low Power Timer module.
 *
 * Values:
 * - 0 - Access disabled
 * - 1 - Access enabled
 */
/*@{*/
/*! @brief Read current value of the SIM_SCGC5_LPTMR field. */
#define SIM_RD_SCGC5_LPTMR(base) ((SIM_SCGC5_REG(base) & SIM_SCGC5_LPTMR_MASK) >> SIM_SCGC5_LPTMR_SHIFT)
#define SIM_BRD_SCGC5_LPTMR(base) (BME_UBFX32(&SIM_SCGC5_REG(base), SIM_SCGC5_LPTMR_SHIFT, SIM_SCGC5_LPTMR_WIDTH))

/*! @brief Set the LPTMR field to a new value. */
#define SIM_WR_SCGC5_LPTMR(base, value) (SIM_RMW_SCGC5(base, SIM_SCGC5_LPTMR_MASK, SIM_SCGC5_LPTMR(value)))
#define SIM_BWR_SCGC5_LPTMR(base, value) (BME_BFI32(&SIM_SCGC5_REG(base), ((uint32_t)(value) << SIM_SCGC5_LPTMR_SHIFT), SIM_SCGC5_LPTMR_SHIFT, SIM_SCGC5_LPTMR_WIDTH))
/*@}*/

/*!
 * @name Register SIM_SCGC5, field PORTA[9] (RW)
 *
 * Controls the clock gate to the Port A module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
/*@{*/
/*! @brief Read current value of the SIM_SCGC5_PORTA field. */
#define SIM_RD_SCGC5_PORTA(base) ((SIM_SCGC5_REG(base) & SIM_SCGC5_PORTA_MASK) >> SIM_SCGC5_PORTA_SHIFT)
#define SIM_BRD_SCGC5_PORTA(base) (BME_UBFX32(&SIM_SCGC5_REG(base), SIM_SCGC5_PORTA_SHIFT, SIM_SCGC5_PORTA_WIDTH))

/*! @brief Set the PORTA field to a new value. */
#define SIM_WR_SCGC5_PORTA(base, value) (SIM_RMW_SCGC5(base, SIM_SCGC5_PORTA_MASK, SIM_SCGC5_PORTA(value)))
#define SIM_BWR_SCGC5_PORTA(base, value) (BME_BFI32(&SIM_SCGC5_REG(base), ((uint32_t)(value) << SIM_SCGC5_PORTA_SHIFT), SIM_SCGC5_PORTA_SHIFT, SIM_SCGC5_PORTA_WIDTH))
/*@}*/

/*!
 * @name Register SIM_SCGC5, field PORTB[10] (RW)
 *
 * Controls the clock gate to the Port B module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
/*@{*/
/*! @brief Read current value of the SIM_SCGC5_PORTB field. */
#define SIM_RD_SCGC5_PORTB(base) ((SIM_SCGC5_REG(base) & SIM_SCGC5_PORTB_MASK) >> SIM_SCGC5_PORTB_SHIFT)
#define SIM_BRD_SCGC5_PORTB(base) (BME_UBFX32(&SIM_SCGC5_REG(base), SIM_SCGC5_PORTB_SHIFT, SIM_SCGC5_PORTB_WIDTH))

/*! @brief Set the PORTB field to a new value. */
#define SIM_WR_SCGC5_PORTB(base, value) (SIM_RMW_SCGC5(base, SIM_SCGC5_PORTB_MASK, SIM_SCGC5_PORTB(value)))
#define SIM_BWR_SCGC5_PORTB(base, value) (BME_BFI32(&SIM_SCGC5_REG(base), ((uint32_t)(value) << SIM_SCGC5_PORTB_SHIFT), SIM_SCGC5_PORTB_SHIFT, SIM_SCGC5_PORTB_WIDTH))
/*@}*/

/*!
 * @name Register SIM_SCGC5, field PORTC[11] (RW)
 *
 * Controls the clock gate to the Port C module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
/*@{*/
/*! @brief Read current value of the SIM_SCGC5_PORTC field. */
#define SIM_RD_SCGC5_PORTC(base) ((SIM_SCGC5_REG(base) & SIM_SCGC5_PORTC_MASK) >> SIM_SCGC5_PORTC_SHIFT)
#define SIM_BRD_SCGC5_PORTC(base) (BME_UBFX32(&SIM_SCGC5_REG(base), SIM_SCGC5_PORTC_SHIFT, SIM_SCGC5_PORTC_WIDTH))

/*! @brief Set the PORTC field to a new value. */
#define SIM_WR_SCGC5_PORTC(base, value) (SIM_RMW_SCGC5(base, SIM_SCGC5_PORTC_MASK, SIM_SCGC5_PORTC(value)))
#define SIM_BWR_SCGC5_PORTC(base, value) (BME_BFI32(&SIM_SCGC5_REG(base), ((uint32_t)(value) << SIM_SCGC5_PORTC_SHIFT), SIM_SCGC5_PORTC_SHIFT, SIM_SCGC5_PORTC_WIDTH))
/*@}*/

/*!
 * @name Register SIM_SCGC5, field PORTD[12] (RW)
 *
 * Controls the clock gate to the Port D module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
/*@{*/
/*! @brief Read current value of the SIM_SCGC5_PORTD field. */
#define SIM_RD_SCGC5_PORTD(base) ((SIM_SCGC5_REG(base) & SIM_SCGC5_PORTD_MASK) >> SIM_SCGC5_PORTD_SHIFT)
#define SIM_BRD_SCGC5_PORTD(base) (BME_UBFX32(&SIM_SCGC5_REG(base), SIM_SCGC5_PORTD_SHIFT, SIM_SCGC5_PORTD_WIDTH))

/*! @brief Set the PORTD field to a new value. */
#define SIM_WR_SCGC5_PORTD(base, value) (SIM_RMW_SCGC5(base, SIM_SCGC5_PORTD_MASK, SIM_SCGC5_PORTD(value)))
#define SIM_BWR_SCGC5_PORTD(base, value) (BME_BFI32(&SIM_SCGC5_REG(base), ((uint32_t)(value) << SIM_SCGC5_PORTD_SHIFT), SIM_SCGC5_PORTD_SHIFT, SIM_SCGC5_PORTD_WIDTH))
/*@}*/

/*!
 * @name Register SIM_SCGC5, field PORTE[13] (RW)
 *
 * Controls the clock gate to the Port E module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
/*@{*/
/*! @brief Read current value of the SIM_SCGC5_PORTE field. */
#define SIM_RD_SCGC5_PORTE(base) ((SIM_SCGC5_REG(base) & SIM_SCGC5_PORTE_MASK) >> SIM_SCGC5_PORTE_SHIFT)
#define SIM_BRD_SCGC5_PORTE(base) (BME_UBFX32(&SIM_SCGC5_REG(base), SIM_SCGC5_PORTE_SHIFT, SIM_SCGC5_PORTE_WIDTH))

/*! @brief Set the PORTE field to a new value. */
#define SIM_WR_SCGC5_PORTE(base, value) (SIM_RMW_SCGC5(base, SIM_SCGC5_PORTE_MASK, SIM_SCGC5_PORTE(value)))
#define SIM_BWR_SCGC5_PORTE(base, value) (BME_BFI32(&SIM_SCGC5_REG(base), ((uint32_t)(value) << SIM_SCGC5_PORTE_SHIFT), SIM_SCGC5_PORTE_SHIFT, SIM_SCGC5_PORTE_WIDTH))
/*@}*/

/*!
 * @name Register SIM_SCGC5, field LPUART0[20] (RW)
 *
 * This bit controls the clock gate to the LPUART0 module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
/*@{*/
/*! @brief Read current value of the SIM_SCGC5_LPUART0 field. */
#define SIM_RD_SCGC5_LPUART0(base) ((SIM_SCGC5_REG(base) & SIM_SCGC5_LPUART0_MASK) >> SIM_SCGC5_LPUART0_SHIFT)
#define SIM_BRD_SCGC5_LPUART0(base) (BME_UBFX32(&SIM_SCGC5_REG(base), SIM_SCGC5_LPUART0_SHIFT, SIM_SCGC5_LPUART0_WIDTH))

/*! @brief Set the LPUART0 field to a new value. */
#define SIM_WR_SCGC5_LPUART0(base, value) (SIM_RMW_SCGC5(base, SIM_SCGC5_LPUART0_MASK, SIM_SCGC5_LPUART0(value)))
#define SIM_BWR_SCGC5_LPUART0(base, value) (BME_BFI32(&SIM_SCGC5_REG(base), ((uint32_t)(value) << SIM_SCGC5_LPUART0_SHIFT), SIM_SCGC5_LPUART0_SHIFT, SIM_SCGC5_LPUART0_WIDTH))
/*@}*/

/*!
 * @name Register SIM_SCGC5, field LPUART1[21] (RW)
 *
 * This bit controls the clock gate to the LPUART1 module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
/*@{*/
/*! @brief Read current value of the SIM_SCGC5_LPUART1 field. */
#define SIM_RD_SCGC5_LPUART1(base) ((SIM_SCGC5_REG(base) & SIM_SCGC5_LPUART1_MASK) >> SIM_SCGC5_LPUART1_SHIFT)
#define SIM_BRD_SCGC5_LPUART1(base) (BME_UBFX32(&SIM_SCGC5_REG(base), SIM_SCGC5_LPUART1_SHIFT, SIM_SCGC5_LPUART1_WIDTH))

/*! @brief Set the LPUART1 field to a new value. */
#define SIM_WR_SCGC5_LPUART1(base, value) (SIM_RMW_SCGC5(base, SIM_SCGC5_LPUART1_MASK, SIM_SCGC5_LPUART1(value)))
#define SIM_BWR_SCGC5_LPUART1(base, value) (BME_BFI32(&SIM_SCGC5_REG(base), ((uint32_t)(value) << SIM_SCGC5_LPUART1_SHIFT), SIM_SCGC5_LPUART1_SHIFT, SIM_SCGC5_LPUART1_WIDTH))
/*@}*/

/*!
 * @name Register SIM_SCGC5, field FLEXIO[31] (RW)
 *
 * This bit controls the clock gate to the FlexIO Module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
/*@{*/
/*! @brief Read current value of the SIM_SCGC5_FLEXIO field. */
#define SIM_RD_SCGC5_FLEXIO(base) ((SIM_SCGC5_REG(base) & SIM_SCGC5_FLEXIO_MASK) >> SIM_SCGC5_FLEXIO_SHIFT)
#define SIM_BRD_SCGC5_FLEXIO(base) (BME_UBFX32(&SIM_SCGC5_REG(base), SIM_SCGC5_FLEXIO_SHIFT, SIM_SCGC5_FLEXIO_WIDTH))

/*! @brief Set the FLEXIO field to a new value. */
#define SIM_WR_SCGC5_FLEXIO(base, value) (SIM_RMW_SCGC5(base, SIM_SCGC5_FLEXIO_MASK, SIM_SCGC5_FLEXIO(value)))
#define SIM_BWR_SCGC5_FLEXIO(base, value) (BME_BFI32(&SIM_SCGC5_REG(base), ((uint32_t)(value) << SIM_SCGC5_FLEXIO_SHIFT), SIM_SCGC5_FLEXIO_SHIFT, SIM_SCGC5_FLEXIO_WIDTH))
/*@}*/

/*******************************************************************************
 * SIM_SCGC6 - System Clock Gating Control Register 6
 ******************************************************************************/

/*!
 * @brief SIM_SCGC6 - System Clock Gating Control Register 6 (RW)
 *
 * Reset value: 0x00000001U
 */
/*!
 * @name Constants and macros for entire SIM_SCGC6 register
 */
/*@{*/
#define SIM_RD_SCGC6(base)       (SIM_SCGC6_REG(base))
#define SIM_WR_SCGC6(base, value) (SIM_SCGC6_REG(base) = (value))
#define SIM_RMW_SCGC6(base, mask, value) (SIM_WR_SCGC6(base, (SIM_RD_SCGC6(base) & ~(mask)) | (value)))
#define SIM_SET_SCGC6(base, value) (BME_OR32(&SIM_SCGC6_REG(base), (uint32_t)(value)))
#define SIM_CLR_SCGC6(base, value) (BME_AND32(&SIM_SCGC6_REG(base), (uint32_t)(~(value))))
#define SIM_TOG_SCGC6(base, value) (BME_XOR32(&SIM_SCGC6_REG(base), (uint32_t)(value)))
/*@}*/

/*
 * Constants & macros for individual SIM_SCGC6 bitfields
 */

/*!
 * @name Register SIM_SCGC6, field FTF[0] (RW)
 *
 * Controls the clock gate to the flash memory. Flash reads are still supported
 * while the flash memory is clock gated, but entry into low power modes is
 * blocked.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
/*@{*/
/*! @brief Read current value of the SIM_SCGC6_FTF field. */
#define SIM_RD_SCGC6_FTF(base) ((SIM_SCGC6_REG(base) & SIM_SCGC6_FTF_MASK) >> SIM_SCGC6_FTF_SHIFT)
#define SIM_BRD_SCGC6_FTF(base) (BME_UBFX32(&SIM_SCGC6_REG(base), SIM_SCGC6_FTF_SHIFT, SIM_SCGC6_FTF_WIDTH))

/*! @brief Set the FTF field to a new value. */
#define SIM_WR_SCGC6_FTF(base, value) (SIM_RMW_SCGC6(base, SIM_SCGC6_FTF_MASK, SIM_SCGC6_FTF(value)))
#define SIM_BWR_SCGC6_FTF(base, value) (BME_BFI32(&SIM_SCGC6_REG(base), ((uint32_t)(value) << SIM_SCGC6_FTF_SHIFT), SIM_SCGC6_FTF_SHIFT, SIM_SCGC6_FTF_WIDTH))
/*@}*/

/*!
 * @name Register SIM_SCGC6, field DMAMUX[1] (RW)
 *
 * Controls the clock gate to the DMA Mux module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
/*@{*/
/*! @brief Read current value of the SIM_SCGC6_DMAMUX field. */
#define SIM_RD_SCGC6_DMAMUX(base) ((SIM_SCGC6_REG(base) & SIM_SCGC6_DMAMUX_MASK) >> SIM_SCGC6_DMAMUX_SHIFT)
#define SIM_BRD_SCGC6_DMAMUX(base) (BME_UBFX32(&SIM_SCGC6_REG(base), SIM_SCGC6_DMAMUX_SHIFT, SIM_SCGC6_DMAMUX_WIDTH))

/*! @brief Set the DMAMUX field to a new value. */
#define SIM_WR_SCGC6_DMAMUX(base, value) (SIM_RMW_SCGC6(base, SIM_SCGC6_DMAMUX_MASK, SIM_SCGC6_DMAMUX(value)))
#define SIM_BWR_SCGC6_DMAMUX(base, value) (BME_BFI32(&SIM_SCGC6_REG(base), ((uint32_t)(value) << SIM_SCGC6_DMAMUX_SHIFT), SIM_SCGC6_DMAMUX_SHIFT, SIM_SCGC6_DMAMUX_WIDTH))
/*@}*/

/*!
 * @name Register SIM_SCGC6, field CRC[18] (RW)
 *
 * This bit controls the clock gate to the CRC module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
/*@{*/
/*! @brief Read current value of the SIM_SCGC6_CRC field. */
#define SIM_RD_SCGC6_CRC(base) ((SIM_SCGC6_REG(base) & SIM_SCGC6_CRC_MASK) >> SIM_SCGC6_CRC_SHIFT)
#define SIM_BRD_SCGC6_CRC(base) (BME_UBFX32(&SIM_SCGC6_REG(base), SIM_SCGC6_CRC_SHIFT, SIM_SCGC6_CRC_WIDTH))

/*! @brief Set the CRC field to a new value. */
#define SIM_WR_SCGC6_CRC(base, value) (SIM_RMW_SCGC6(base, SIM_SCGC6_CRC_MASK, SIM_SCGC6_CRC(value)))
#define SIM_BWR_SCGC6_CRC(base, value) (BME_BFI32(&SIM_SCGC6_REG(base), ((uint32_t)(value) << SIM_SCGC6_CRC_SHIFT), SIM_SCGC6_CRC_SHIFT, SIM_SCGC6_CRC_WIDTH))
/*@}*/

/*!
 * @name Register SIM_SCGC6, field PIT[23] (RW)
 *
 * This bit controls the clock gate to the PIT module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
/*@{*/
/*! @brief Read current value of the SIM_SCGC6_PIT field. */
#define SIM_RD_SCGC6_PIT(base) ((SIM_SCGC6_REG(base) & SIM_SCGC6_PIT_MASK) >> SIM_SCGC6_PIT_SHIFT)
#define SIM_BRD_SCGC6_PIT(base) (BME_UBFX32(&SIM_SCGC6_REG(base), SIM_SCGC6_PIT_SHIFT, SIM_SCGC6_PIT_WIDTH))

/*! @brief Set the PIT field to a new value. */
#define SIM_WR_SCGC6_PIT(base, value) (SIM_RMW_SCGC6(base, SIM_SCGC6_PIT_MASK, SIM_SCGC6_PIT(value)))
#define SIM_BWR_SCGC6_PIT(base, value) (BME_BFI32(&SIM_SCGC6_REG(base), ((uint32_t)(value) << SIM_SCGC6_PIT_SHIFT), SIM_SCGC6_PIT_SHIFT, SIM_SCGC6_PIT_WIDTH))
/*@}*/

/*!
 * @name Register SIM_SCGC6, field TPM0[24] (RW)
 *
 * Controls the clock gate to the TPM0 module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
/*@{*/
/*! @brief Read current value of the SIM_SCGC6_TPM0 field. */
#define SIM_RD_SCGC6_TPM0(base) ((SIM_SCGC6_REG(base) & SIM_SCGC6_TPM0_MASK) >> SIM_SCGC6_TPM0_SHIFT)
#define SIM_BRD_SCGC6_TPM0(base) (BME_UBFX32(&SIM_SCGC6_REG(base), SIM_SCGC6_TPM0_SHIFT, SIM_SCGC6_TPM0_WIDTH))

/*! @brief Set the TPM0 field to a new value. */
#define SIM_WR_SCGC6_TPM0(base, value) (SIM_RMW_SCGC6(base, SIM_SCGC6_TPM0_MASK, SIM_SCGC6_TPM0(value)))
#define SIM_BWR_SCGC6_TPM0(base, value) (BME_BFI32(&SIM_SCGC6_REG(base), ((uint32_t)(value) << SIM_SCGC6_TPM0_SHIFT), SIM_SCGC6_TPM0_SHIFT, SIM_SCGC6_TPM0_WIDTH))
/*@}*/

/*!
 * @name Register SIM_SCGC6, field TPM1[25] (RW)
 *
 * Controls the clock gate to the TPM1 module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
/*@{*/
/*! @brief Read current value of the SIM_SCGC6_TPM1 field. */
#define SIM_RD_SCGC6_TPM1(base) ((SIM_SCGC6_REG(base) & SIM_SCGC6_TPM1_MASK) >> SIM_SCGC6_TPM1_SHIFT)
#define SIM_BRD_SCGC6_TPM1(base) (BME_UBFX32(&SIM_SCGC6_REG(base), SIM_SCGC6_TPM1_SHIFT, SIM_SCGC6_TPM1_WIDTH))

/*! @brief Set the TPM1 field to a new value. */
#define SIM_WR_SCGC6_TPM1(base, value) (SIM_RMW_SCGC6(base, SIM_SCGC6_TPM1_MASK, SIM_SCGC6_TPM1(value)))
#define SIM_BWR_SCGC6_TPM1(base, value) (BME_BFI32(&SIM_SCGC6_REG(base), ((uint32_t)(value) << SIM_SCGC6_TPM1_SHIFT), SIM_SCGC6_TPM1_SHIFT, SIM_SCGC6_TPM1_WIDTH))
/*@}*/

/*!
 * @name Register SIM_SCGC6, field TPM2[26] (RW)
 *
 * Controls the clock gate to the TPM2 module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
/*@{*/
/*! @brief Read current value of the SIM_SCGC6_TPM2 field. */
#define SIM_RD_SCGC6_TPM2(base) ((SIM_SCGC6_REG(base) & SIM_SCGC6_TPM2_MASK) >> SIM_SCGC6_TPM2_SHIFT)
#define SIM_BRD_SCGC6_TPM2(base) (BME_UBFX32(&SIM_SCGC6_REG(base), SIM_SCGC6_TPM2_SHIFT, SIM_SCGC6_TPM2_WIDTH))

/*! @brief Set the TPM2 field to a new value. */
#define SIM_WR_SCGC6_TPM2(base, value) (SIM_RMW_SCGC6(base, SIM_SCGC6_TPM2_MASK, SIM_SCGC6_TPM2(value)))
#define SIM_BWR_SCGC6_TPM2(base, value) (BME_BFI32(&SIM_SCGC6_REG(base), ((uint32_t)(value) << SIM_SCGC6_TPM2_SHIFT), SIM_SCGC6_TPM2_SHIFT, SIM_SCGC6_TPM2_WIDTH))
/*@}*/

/*!
 * @name Register SIM_SCGC6, field ADC0[27] (RW)
 *
 * Controls the clock gate to the ADC0 module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
/*@{*/
/*! @brief Read current value of the SIM_SCGC6_ADC0 field. */
#define SIM_RD_SCGC6_ADC0(base) ((SIM_SCGC6_REG(base) & SIM_SCGC6_ADC0_MASK) >> SIM_SCGC6_ADC0_SHIFT)
#define SIM_BRD_SCGC6_ADC0(base) (BME_UBFX32(&SIM_SCGC6_REG(base), SIM_SCGC6_ADC0_SHIFT, SIM_SCGC6_ADC0_WIDTH))

/*! @brief Set the ADC0 field to a new value. */
#define SIM_WR_SCGC6_ADC0(base, value) (SIM_RMW_SCGC6(base, SIM_SCGC6_ADC0_MASK, SIM_SCGC6_ADC0(value)))
#define SIM_BWR_SCGC6_ADC0(base, value) (BME_BFI32(&SIM_SCGC6_REG(base), ((uint32_t)(value) << SIM_SCGC6_ADC0_SHIFT), SIM_SCGC6_ADC0_SHIFT, SIM_SCGC6_ADC0_WIDTH))
/*@}*/

/*!
 * @name Register SIM_SCGC6, field RTC[29] (RW)
 *
 * Controls software access and interrupts to the RTC module.
 *
 * Values:
 * - 0 - Access and interrupts disabled
 * - 1 - Access and interrupts enabled
 */
/*@{*/
/*! @brief Read current value of the SIM_SCGC6_RTC field. */
#define SIM_RD_SCGC6_RTC(base) ((SIM_SCGC6_REG(base) & SIM_SCGC6_RTC_MASK) >> SIM_SCGC6_RTC_SHIFT)
#define SIM_BRD_SCGC6_RTC(base) (BME_UBFX32(&SIM_SCGC6_REG(base), SIM_SCGC6_RTC_SHIFT, SIM_SCGC6_RTC_WIDTH))

/*! @brief Set the RTC field to a new value. */
#define SIM_WR_SCGC6_RTC(base, value) (SIM_RMW_SCGC6(base, SIM_SCGC6_RTC_MASK, SIM_SCGC6_RTC(value)))
#define SIM_BWR_SCGC6_RTC(base, value) (BME_BFI32(&SIM_SCGC6_REG(base), ((uint32_t)(value) << SIM_SCGC6_RTC_SHIFT), SIM_SCGC6_RTC_SHIFT, SIM_SCGC6_RTC_WIDTH))
/*@}*/

/*******************************************************************************
 * SIM_SCGC7 - System Clock Gating Control Register 7
 ******************************************************************************/

/*!
 * @brief SIM_SCGC7 - System Clock Gating Control Register 7 (RW)
 *
 * Reset value: 0x00000100U
 */
/*!
 * @name Constants and macros for entire SIM_SCGC7 register
 */
/*@{*/
#define SIM_RD_SCGC7(base)       (SIM_SCGC7_REG(base))
#define SIM_WR_SCGC7(base, value) (SIM_SCGC7_REG(base) = (value))
#define SIM_RMW_SCGC7(base, mask, value) (SIM_WR_SCGC7(base, (SIM_RD_SCGC7(base) & ~(mask)) | (value)))
#define SIM_SET_SCGC7(base, value) (BME_OR32(&SIM_SCGC7_REG(base), (uint32_t)(value)))
#define SIM_CLR_SCGC7(base, value) (BME_AND32(&SIM_SCGC7_REG(base), (uint32_t)(~(value))))
#define SIM_TOG_SCGC7(base, value) (BME_XOR32(&SIM_SCGC7_REG(base), (uint32_t)(value)))
/*@}*/

/*
 * Constants & macros for individual SIM_SCGC7 bitfields
 */

/*!
 * @name Register SIM_SCGC7, field DMA[8] (RW)
 *
 * Controls the clock gate to the DMA module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
/*@{*/
/*! @brief Read current value of the SIM_SCGC7_DMA field. */
#define SIM_RD_SCGC7_DMA(base) ((SIM_SCGC7_REG(base) & SIM_SCGC7_DMA_MASK) >> SIM_SCGC7_DMA_SHIFT)
#define SIM_BRD_SCGC7_DMA(base) (BME_UBFX32(&SIM_SCGC7_REG(base), SIM_SCGC7_DMA_SHIFT, SIM_SCGC7_DMA_WIDTH))

/*! @brief Set the DMA field to a new value. */
#define SIM_WR_SCGC7_DMA(base, value) (SIM_RMW_SCGC7(base, SIM_SCGC7_DMA_MASK, SIM_SCGC7_DMA(value)))
#define SIM_BWR_SCGC7_DMA(base, value) (BME_BFI32(&SIM_SCGC7_REG(base), ((uint32_t)(value) << SIM_SCGC7_DMA_SHIFT), SIM_SCGC7_DMA_SHIFT, SIM_SCGC7_DMA_WIDTH))
/*@}*/

/*******************************************************************************
 * SIM_CLKDIV1 - System Clock Divider Register 1
 ******************************************************************************/

/*!
 * @brief SIM_CLKDIV1 - System Clock Divider Register 1 (RW)
 *
 * Reset value: 0x00010000U
 *
 * The CLKDIV1 register cannot be written to when the device is in VLPR mode.
 * Reset value loaded during System Reset from FTFA_FOPT[LPBOOT] (See ).
 */
/*!
 * @name Constants and macros for entire SIM_CLKDIV1 register
 */
/*@{*/
#define SIM_RD_CLKDIV1(base)     (SIM_CLKDIV1_REG(base))
#define SIM_WR_CLKDIV1(base, value) (SIM_CLKDIV1_REG(base) = (value))
#define SIM_RMW_CLKDIV1(base, mask, value) (SIM_WR_CLKDIV1(base, (SIM_RD_CLKDIV1(base) & ~(mask)) | (value)))
#define SIM_SET_CLKDIV1(base, value) (BME_OR32(&SIM_CLKDIV1_REG(base), (uint32_t)(value)))
#define SIM_CLR_CLKDIV1(base, value) (BME_AND32(&SIM_CLKDIV1_REG(base), (uint32_t)(~(value))))
#define SIM_TOG_CLKDIV1(base, value) (BME_XOR32(&SIM_CLKDIV1_REG(base), (uint32_t)(value)))
/*@}*/

/*
 * Constants & macros for individual SIM_CLKDIV1 bitfields
 */

/*!
 * @name Register SIM_CLKDIV1, field OUTDIV4[18:16] (RW)
 *
 * Sets the divide value for the bus and flash clock and is in addition to the
 * System clock divide ratio. At the end of reset, it is loaded with 0001 (divide
 * by 2).
 *
 * Values:
 * - 000 - Divide-by-1.
 * - 001 - Divide-by-2.
 * - 010 - Divide-by-3.
 * - 011 - Divide-by-4.
 * - 100 - Divide-by-5.
 * - 101 - Divide-by-6.
 * - 110 - Divide-by-7.
 * - 111 - Divide-by-8.
 */
/*@{*/
/*! @brief Read current value of the SIM_CLKDIV1_OUTDIV4 field. */
#define SIM_RD_CLKDIV1_OUTDIV4(base) ((SIM_CLKDIV1_REG(base) & SIM_CLKDIV1_OUTDIV4_MASK) >> SIM_CLKDIV1_OUTDIV4_SHIFT)
#define SIM_BRD_CLKDIV1_OUTDIV4(base) (BME_UBFX32(&SIM_CLKDIV1_REG(base), SIM_CLKDIV1_OUTDIV4_SHIFT, SIM_CLKDIV1_OUTDIV4_WIDTH))

/*! @brief Set the OUTDIV4 field to a new value. */
#define SIM_WR_CLKDIV1_OUTDIV4(base, value) (SIM_RMW_CLKDIV1(base, SIM_CLKDIV1_OUTDIV4_MASK, SIM_CLKDIV1_OUTDIV4(value)))
#define SIM_BWR_CLKDIV1_OUTDIV4(base, value) (BME_BFI32(&SIM_CLKDIV1_REG(base), ((uint32_t)(value) << SIM_CLKDIV1_OUTDIV4_SHIFT), SIM_CLKDIV1_OUTDIV4_SHIFT, SIM_CLKDIV1_OUTDIV4_WIDTH))
/*@}*/

/*!
 * @name Register SIM_CLKDIV1, field OUTDIV1[31:28] (RW)
 *
 * Sets the divide value for the core/system clock, as well as the bus/flash
 * clocks. At the end of reset, it is loaded with 0000 (divide by one), 0001 (divide
 * by two), 0011 (divide by four), or 0111 (divide by eight) depending on the
 * setting of the FTFA_FOPT[LPBOOT] (See ).
 *
 * Values:
 * - 0000 - Divide-by-1.
 * - 0001 - Divide-by-2.
 * - 0010 - Divide-by-3.
 * - 0011 - Divide-by-4.
 * - 0100 - Divide-by-5.
 * - 0101 - Divide-by-6.
 * - 0110 - Divide-by-7.
 * - 0111 - Divide-by-8.
 * - 1000 - Divide-by-9.
 * - 1001 - Divide-by-10.
 * - 1010 - Divide-by-11.
 * - 1011 - Divide-by-12.
 * - 1100 - Divide-by-13.
 * - 1101 - Divide-by-14.
 * - 1110 - Divide-by-15.
 * - 1111 - Divide-by-16.
 */
/*@{*/
/*! @brief Read current value of the SIM_CLKDIV1_OUTDIV1 field. */
#define SIM_RD_CLKDIV1_OUTDIV1(base) ((SIM_CLKDIV1_REG(base) & SIM_CLKDIV1_OUTDIV1_MASK) >> SIM_CLKDIV1_OUTDIV1_SHIFT)
#define SIM_BRD_CLKDIV1_OUTDIV1(base) (BME_UBFX32(&SIM_CLKDIV1_REG(base), SIM_CLKDIV1_OUTDIV1_SHIFT, SIM_CLKDIV1_OUTDIV1_WIDTH))

/*! @brief Set the OUTDIV1 field to a new value. */
#define SIM_WR_CLKDIV1_OUTDIV1(base, value) (SIM_RMW_CLKDIV1(base, SIM_CLKDIV1_OUTDIV1_MASK, SIM_CLKDIV1_OUTDIV1(value)))
#define SIM_BWR_CLKDIV1_OUTDIV1(base, value) (BME_BFI32(&SIM_CLKDIV1_REG(base), ((uint32_t)(value) << SIM_CLKDIV1_OUTDIV1_SHIFT), SIM_CLKDIV1_OUTDIV1_SHIFT, SIM_CLKDIV1_OUTDIV1_WIDTH))
/*@}*/

/*******************************************************************************
 * SIM_FCFG1 - Flash Configuration Register 1
 ******************************************************************************/

/*!
 * @brief SIM_FCFG1 - Flash Configuration Register 1 (RW)
 *
 * Reset value: 0x0F000000U
 */
/*!
 * @name Constants and macros for entire SIM_FCFG1 register
 */
/*@{*/
#define SIM_RD_FCFG1(base)       (SIM_FCFG1_REG(base))
#define SIM_WR_FCFG1(base, value) (SIM_FCFG1_REG(base) = (value))
#define SIM_RMW_FCFG1(base, mask, value) (SIM_WR_FCFG1(base, (SIM_RD_FCFG1(base) & ~(mask)) | (value)))
#define SIM_SET_FCFG1(base, value) (BME_OR32(&SIM_FCFG1_REG(base), (uint32_t)(value)))
#define SIM_CLR_FCFG1(base, value) (BME_AND32(&SIM_FCFG1_REG(base), (uint32_t)(~(value))))
#define SIM_TOG_FCFG1(base, value) (BME_XOR32(&SIM_FCFG1_REG(base), (uint32_t)(value)))
/*@}*/

/*
 * Constants & macros for individual SIM_FCFG1 bitfields
 */

/*!
 * @name Register SIM_FCFG1, field FLASHDIS[0] (RW)
 *
 * Flash accesses are disabled (and generate a bus error) and the flash memory
 * is placed in a low-power state. This field should not be changed during VLP
 * modes. Relocate the interrupt vectors out of Flash memory before disabling the
 * Flash.
 *
 * Values:
 * - 0 - Flash is enabled.
 * - 1 - Flash is disabled.
 */
/*@{*/
/*! @brief Read current value of the SIM_FCFG1_FLASHDIS field. */
#define SIM_RD_FCFG1_FLASHDIS(base) ((SIM_FCFG1_REG(base) & SIM_FCFG1_FLASHDIS_MASK) >> SIM_FCFG1_FLASHDIS_SHIFT)
#define SIM_BRD_FCFG1_FLASHDIS(base) (BME_UBFX32(&SIM_FCFG1_REG(base), SIM_FCFG1_FLASHDIS_SHIFT, SIM_FCFG1_FLASHDIS_WIDTH))

/*! @brief Set the FLASHDIS field to a new value. */
#define SIM_WR_FCFG1_FLASHDIS(base, value) (SIM_RMW_FCFG1(base, SIM_FCFG1_FLASHDIS_MASK, SIM_FCFG1_FLASHDIS(value)))
#define SIM_BWR_FCFG1_FLASHDIS(base, value) (BME_BFI32(&SIM_FCFG1_REG(base), ((uint32_t)(value) << SIM_FCFG1_FLASHDIS_SHIFT), SIM_FCFG1_FLASHDIS_SHIFT, SIM_FCFG1_FLASHDIS_WIDTH))
/*@}*/

/*!
 * @name Register SIM_FCFG1, field FLASHDOZE[1] (RW)
 *
 * When set, flash memory is disabled for the duration of Doze mode. This field
 * must be clear during VLP modes. The flash will be automatically enabled again
 * at the end of Doze mode so interrupt vectors do not need to be relocated out
 * of flash memory. The wake-up time from Doze mode is extended when this field is
 * set. An attempt by the DMA or other bus master to access the flash memory
 * when the flash is disabled will result in a bus error.
 *
 * Values:
 * - 0 - Flash remains enabled during Doze mode.
 * - 1 - Flash is disabled for the duration of Doze mode.
 */
/*@{*/
/*! @brief Read current value of the SIM_FCFG1_FLASHDOZE field. */
#define SIM_RD_FCFG1_FLASHDOZE(base) ((SIM_FCFG1_REG(base) & SIM_FCFG1_FLASHDOZE_MASK) >> SIM_FCFG1_FLASHDOZE_SHIFT)
#define SIM_BRD_FCFG1_FLASHDOZE(base) (BME_UBFX32(&SIM_FCFG1_REG(base), SIM_FCFG1_FLASHDOZE_SHIFT, SIM_FCFG1_FLASHDOZE_WIDTH))

/*! @brief Set the FLASHDOZE field to a new value. */
#define SIM_WR_FCFG1_FLASHDOZE(base, value) (SIM_RMW_FCFG1(base, SIM_FCFG1_FLASHDOZE_MASK, SIM_FCFG1_FLASHDOZE(value)))
#define SIM_BWR_FCFG1_FLASHDOZE(base, value) (BME_BFI32(&SIM_FCFG1_REG(base), ((uint32_t)(value) << SIM_FCFG1_FLASHDOZE_SHIFT), SIM_FCFG1_FLASHDOZE_SHIFT, SIM_FCFG1_FLASHDOZE_WIDTH))
/*@}*/

/*!
 * @name Register SIM_FCFG1, field PFSIZE[27:24] (RO)
 *
 * Specifies the amount of program flash memory available on the device .
 * Undefined values are reserved.
 *
 * Values:
 * - 0000 - 8 KB of program flash memory, 1 KB protection region
 * - 0001 - 16 KB of program flash memory, 1 KB protection region
 * - 0011 - 32 KB of program flash memory, 1 KB protection region
 * - 0101 - 64 KB of program flash memory, 2 KB protection region
 * - 0111 - 128 KB of program flash memory, 4 KB protection region
 * - 1001 - 256 KB of program flash memory, 8 KB protection region
 * - 1111 - 64 KB of program flash memory, 2 KB protection region
 */
/*@{*/
/*! @brief Read current value of the SIM_FCFG1_PFSIZE field. */
#define SIM_RD_FCFG1_PFSIZE(base) ((SIM_FCFG1_REG(base) & SIM_FCFG1_PFSIZE_MASK) >> SIM_FCFG1_PFSIZE_SHIFT)
#define SIM_BRD_FCFG1_PFSIZE(base) (BME_UBFX32(&SIM_FCFG1_REG(base), SIM_FCFG1_PFSIZE_SHIFT, SIM_FCFG1_PFSIZE_WIDTH))
/*@}*/

/*******************************************************************************
 * SIM_FCFG2 - Flash Configuration Register 2
 ******************************************************************************/

/*!
 * @brief SIM_FCFG2 - Flash Configuration Register 2 (RO)
 *
 * Reset value: 0x7F800000U
 *
 * This is read only register, any write to this register will cause transfer
 * error.
 */
/*!
 * @name Constants and macros for entire SIM_FCFG2 register
 */
/*@{*/
#define SIM_RD_FCFG2(base)       (SIM_FCFG2_REG(base))
/*@}*/

/*
 * Constants & macros for individual SIM_FCFG2 bitfields
 */

/*!
 * @name Register SIM_FCFG2, field MAXADDR0[30:24] (RO)
 *
 * This field concatenated with 13 trailing zeros indicates the first invalid
 * address of program flash. For example, if MAXADDR0 = 0x10, the first invalid
 * address of program flash is 0x0002_0000. This would be the MAXADDR0 value for a
 * device with 128 KB program flash.
 */
/*@{*/
/*! @brief Read current value of the SIM_FCFG2_MAXADDR0 field. */
#define SIM_RD_FCFG2_MAXADDR0(base) ((SIM_FCFG2_REG(base) & SIM_FCFG2_MAXADDR0_MASK) >> SIM_FCFG2_MAXADDR0_SHIFT)
#define SIM_BRD_FCFG2_MAXADDR0(base) (BME_UBFX32(&SIM_FCFG2_REG(base), SIM_FCFG2_MAXADDR0_SHIFT, SIM_FCFG2_MAXADDR0_WIDTH))
/*@}*/

/*******************************************************************************
 * SIM_UIDMH - Unique Identification Register Mid-High
 ******************************************************************************/

/*!
 * @brief SIM_UIDMH - Unique Identification Register Mid-High (RO)
 *
 * Reset value: 0x00000000U
 */
/*!
 * @name Constants and macros for entire SIM_UIDMH register
 */
/*@{*/
#define SIM_RD_UIDMH(base)       (SIM_UIDMH_REG(base))
/*@}*/

/*
 * Constants & macros for individual SIM_UIDMH bitfields
 */

/*!
 * @name Register SIM_UIDMH, field UID[15:0] (RO)
 *
 * Unique identification for the device.
 */
/*@{*/
/*! @brief Read current value of the SIM_UIDMH_UID field. */
#define SIM_RD_UIDMH_UID(base) ((SIM_UIDMH_REG(base) & SIM_UIDMH_UID_MASK) >> SIM_UIDMH_UID_SHIFT)
#define SIM_BRD_UIDMH_UID(base) (BME_UBFX32(&SIM_UIDMH_REG(base), SIM_UIDMH_UID_SHIFT, SIM_UIDMH_UID_WIDTH))
/*@}*/

/*******************************************************************************
 * SIM_UIDML - Unique Identification Register Mid Low
 ******************************************************************************/

/*!
 * @brief SIM_UIDML - Unique Identification Register Mid Low (RO)
 *
 * Reset value: 0x00000000U
 */
/*!
 * @name Constants and macros for entire SIM_UIDML register
 */
/*@{*/
#define SIM_RD_UIDML(base)       (SIM_UIDML_REG(base))
/*@}*/

/*******************************************************************************
 * SIM_UIDL - Unique Identification Register Low
 ******************************************************************************/

/*!
 * @brief SIM_UIDL - Unique Identification Register Low (RO)
 *
 * Reset value: 0x00000000U
 */
/*!
 * @name Constants and macros for entire SIM_UIDL register
 */
/*@{*/
#define SIM_RD_UIDL(base)        (SIM_UIDL_REG(base))
/*@}*/

/*******************************************************************************
 * SIM_COPC - COP Control Register
 ******************************************************************************/

/*!
 * @brief SIM_COPC - COP Control Register (RW)
 *
 * Reset value: 0x0000000CU
 *
 * All of the bits in this register can be written only once after a reset,
 * writing this register will also reset the COP counter.
 */
/*!
 * @name Constants and macros for entire SIM_COPC register
 */
/*@{*/
#define SIM_RD_COPC(base)        (SIM_COPC_REG(base))
#define SIM_WR_COPC(base, value) (SIM_COPC_REG(base) = (value))
#define SIM_RMW_COPC(base, mask, value) (SIM_WR_COPC(base, (SIM_RD_COPC(base) & ~(mask)) | (value)))
#define SIM_SET_COPC(base, value) (BME_OR32(&SIM_COPC_REG(base), (uint32_t)(value)))
#define SIM_CLR_COPC(base, value) (BME_AND32(&SIM_COPC_REG(base), (uint32_t)(~(value))))
#define SIM_TOG_COPC(base, value) (BME_XOR32(&SIM_COPC_REG(base), (uint32_t)(value)))
/*@}*/

/*
 * Constants & macros for individual SIM_COPC bitfields
 */

/*!
 * @name Register SIM_COPC, field COPW[0] (RW)
 *
 * Windowed mode is supported for all COP clock sources, but only when the COP
 * is configured for a long timeout. The COP window is opened three quarters
 * through the timeout period and will generate a system reset if the COP is serviced
 * outside of that time.
 *
 * Values:
 * - 0 - Normal mode
 * - 1 - Windowed mode
 */
/*@{*/
/*! @brief Read current value of the SIM_COPC_COPW field. */
#define SIM_RD_COPC_COPW(base) ((SIM_COPC_REG(base) & SIM_COPC_COPW_MASK) >> SIM_COPC_COPW_SHIFT)
#define SIM_BRD_COPC_COPW(base) (BME_UBFX32(&SIM_COPC_REG(base), SIM_COPC_COPW_SHIFT, SIM_COPC_COPW_WIDTH))

/*! @brief Set the COPW field to a new value. */
#define SIM_WR_COPC_COPW(base, value) (SIM_RMW_COPC(base, SIM_COPC_COPW_MASK, SIM_COPC_COPW(value)))
#define SIM_BWR_COPC_COPW(base, value) (BME_BFI32(&SIM_COPC_REG(base), ((uint32_t)(value) << SIM_COPC_COPW_SHIFT), SIM_COPC_COPW_SHIFT, SIM_COPC_COPW_WIDTH))
/*@}*/

/*!
 * @name Register SIM_COPC, field COPCLKS[1] (RW)
 *
 * This write-once field selects between a short timeout or a long timeout, the
 * COP clock source is configured by COPCLKSEL.
 *
 * Values:
 * - 0 - COP configured for short timeout
 * - 1 - COP configured for long timeout
 */
/*@{*/
/*! @brief Read current value of the SIM_COPC_COPCLKS field. */
#define SIM_RD_COPC_COPCLKS(base) ((SIM_COPC_REG(base) & SIM_COPC_COPCLKS_MASK) >> SIM_COPC_COPCLKS_SHIFT)
#define SIM_BRD_COPC_COPCLKS(base) (BME_UBFX32(&SIM_COPC_REG(base), SIM_COPC_COPCLKS_SHIFT, SIM_COPC_COPCLKS_WIDTH))

/*! @brief Set the COPCLKS field to a new value. */
#define SIM_WR_COPC_COPCLKS(base, value) (SIM_RMW_COPC(base, SIM_COPC_COPCLKS_MASK, SIM_COPC_COPCLKS(value)))
#define SIM_BWR_COPC_COPCLKS(base, value) (BME_BFI32(&SIM_COPC_REG(base), ((uint32_t)(value) << SIM_COPC_COPCLKS_SHIFT), SIM_COPC_COPCLKS_SHIFT, SIM_COPC_COPCLKS_WIDTH))
/*@}*/

/*!
 * @name Register SIM_COPC, field COPT[3:2] (RW)
 *
 * This write-once field selects the timeout period of the COP. COPT along with
 * the COPCLKS field define the COP timeout period.
 *
 * Values:
 * - 00 - COP disabled
 * - 01 - COP timeout after 25 cycles for short timeout or 213 cycles for long
 *     timeout
 * - 10 - COP timeout after 28 cycles for short timeout or 216 cycles for long
 *     timeout
 * - 11 - COP timeout after 210 cycles for short timeout or 218 cycles for long
 *     timeout
 */
/*@{*/
/*! @brief Read current value of the SIM_COPC_COPT field. */
#define SIM_RD_COPC_COPT(base) ((SIM_COPC_REG(base) & SIM_COPC_COPT_MASK) >> SIM_COPC_COPT_SHIFT)
#define SIM_BRD_COPC_COPT(base) (BME_UBFX32(&SIM_COPC_REG(base), SIM_COPC_COPT_SHIFT, SIM_COPC_COPT_WIDTH))

/*! @brief Set the COPT field to a new value. */
#define SIM_WR_COPC_COPT(base, value) (SIM_RMW_COPC(base, SIM_COPC_COPT_MASK, SIM_COPC_COPT(value)))
#define SIM_BWR_COPC_COPT(base, value) (BME_BFI32(&SIM_COPC_REG(base), ((uint32_t)(value) << SIM_COPC_COPT_SHIFT), SIM_COPC_COPT_SHIFT, SIM_COPC_COPT_WIDTH))
/*@}*/

/*!
 * @name Register SIM_COPC, field COPSTPEN[4] (RW)
 *
 * Values:
 * - 0 - COP is disabled and the counter is reset in Stop modes
 * - 1 - COP is enabled in Stop modes
 */
/*@{*/
/*! @brief Read current value of the SIM_COPC_COPSTPEN field. */
#define SIM_RD_COPC_COPSTPEN(base) ((SIM_COPC_REG(base) & SIM_COPC_COPSTPEN_MASK) >> SIM_COPC_COPSTPEN_SHIFT)
#define SIM_BRD_COPC_COPSTPEN(base) (BME_UBFX32(&SIM_COPC_REG(base), SIM_COPC_COPSTPEN_SHIFT, SIM_COPC_COPSTPEN_WIDTH))

/*! @brief Set the COPSTPEN field to a new value. */
#define SIM_WR_COPC_COPSTPEN(base, value) (SIM_RMW_COPC(base, SIM_COPC_COPSTPEN_MASK, SIM_COPC_COPSTPEN(value)))
#define SIM_BWR_COPC_COPSTPEN(base, value) (BME_BFI32(&SIM_COPC_REG(base), ((uint32_t)(value) << SIM_COPC_COPSTPEN_SHIFT), SIM_COPC_COPSTPEN_SHIFT, SIM_COPC_COPSTPEN_WIDTH))
/*@}*/

/*!
 * @name Register SIM_COPC, field COPDBGEN[5] (RW)
 *
 * Values:
 * - 0 - COP is disabled and the counter is reset in Debug mode
 * - 1 - COP is enabled in Debug mode
 */
/*@{*/
/*! @brief Read current value of the SIM_COPC_COPDBGEN field. */
#define SIM_RD_COPC_COPDBGEN(base) ((SIM_COPC_REG(base) & SIM_COPC_COPDBGEN_MASK) >> SIM_COPC_COPDBGEN_SHIFT)
#define SIM_BRD_COPC_COPDBGEN(base) (BME_UBFX32(&SIM_COPC_REG(base), SIM_COPC_COPDBGEN_SHIFT, SIM_COPC_COPDBGEN_WIDTH))

/*! @brief Set the COPDBGEN field to a new value. */
#define SIM_WR_COPC_COPDBGEN(base, value) (SIM_RMW_COPC(base, SIM_COPC_COPDBGEN_MASK, SIM_COPC_COPDBGEN(value)))
#define SIM_BWR_COPC_COPDBGEN(base, value) (BME_BFI32(&SIM_COPC_REG(base), ((uint32_t)(value) << SIM_COPC_COPDBGEN_SHIFT), SIM_COPC_COPDBGEN_SHIFT, SIM_COPC_COPDBGEN_WIDTH))
/*@}*/

/*!
 * @name Register SIM_COPC, field COPCLKSEL[7:6] (RW)
 *
 * This write-once field selects the clock source of the COP watchdog.
 *
 * Values:
 * - 00 - LPO clock (1 kHz)
 * - 01 - MCGIRCLK
 * - 10 - OSCERCLK
 * - 11 - Bus clock
 */
/*@{*/
/*! @brief Read current value of the SIM_COPC_COPCLKSEL field. */
#define SIM_RD_COPC_COPCLKSEL(base) ((SIM_COPC_REG(base) & SIM_COPC_COPCLKSEL_MASK) >> SIM_COPC_COPCLKSEL_SHIFT)
#define SIM_BRD_COPC_COPCLKSEL(base) (BME_UBFX32(&SIM_COPC_REG(base), SIM_COPC_COPCLKSEL_SHIFT, SIM_COPC_COPCLKSEL_WIDTH))

/*! @brief Set the COPCLKSEL field to a new value. */
#define SIM_WR_COPC_COPCLKSEL(base, value) (SIM_RMW_COPC(base, SIM_COPC_COPCLKSEL_MASK, SIM_COPC_COPCLKSEL(value)))
#define SIM_BWR_COPC_COPCLKSEL(base, value) (BME_BFI32(&SIM_COPC_REG(base), ((uint32_t)(value) << SIM_COPC_COPCLKSEL_SHIFT), SIM_COPC_COPCLKSEL_SHIFT, SIM_COPC_COPCLKSEL_WIDTH))
/*@}*/

/*******************************************************************************
 * SIM_SRVCOP - Service COP
 ******************************************************************************/

/*!
 * @brief SIM_SRVCOP - Service COP (WO)
 *
 * Reset value: 0x00000000U
 *
 * This is write only register, any read to this register will cause transfer
 * error.
 */
/*!
 * @name Constants and macros for entire SIM_SRVCOP register
 */
/*@{*/
#define SIM_WR_SRVCOP(base, value) (SIM_SRVCOP_REG(base) = (value))
/*@}*/

/*
 * Constants & macros for individual SIM_SRVCOP bitfields
 */

/*!
 * @name Register SIM_SRVCOP, field SRVCOP[7:0] (WO)
 *
 * Write 0x55 and then 0xAA (in that order) to reset the COP timeout counter,
 * writing any other value will generate a system reset.
 */
/*@{*/
/*! @brief Set the SRVCOP field to a new value. */
#define SIM_WR_SRVCOP_SRVCOP(base, value) (SIM_WR_SRVCOP(base, SIM_SRVCOP_SRVCOP(value)))
#define SIM_BWR_SRVCOP_SRVCOP(base, value) (SIM_WR_SRVCOP_SRVCOP(base, value))
/*@}*/

/*
 * MKL27Z644 SMC
 *
 * System Mode Controller
 *
 * Registers defined in this header file:
 * - SMC_PMPROT - Power Mode Protection register
 * - SMC_PMCTRL - Power Mode Control register
 * - SMC_STOPCTRL - Stop Control Register
 * - SMC_PMSTAT - Power Mode Status register
 */

#define SMC_INSTANCE_COUNT (1U) /*!< Number of instances of the SMC module. */
#define SMC_IDX (0U) /*!< Instance number for SMC. */

/*******************************************************************************
 * SMC_PMPROT - Power Mode Protection register
 ******************************************************************************/

/*!
 * @brief SMC_PMPROT - Power Mode Protection register (RW)
 *
 * Reset value: 0x00U
 *
 * This register provides protection for entry into any low-power run or stop
 * mode. The enabling of the low-power run or stop mode occurs by configuring the
 * Power Mode Control register (PMCTRL). The PMPROT register can be written only
 * once after any system reset. If the MCU is configured for a disallowed or
 * reserved power mode, the MCU remains in its current power mode. For example, if the
 * MCU is in normal RUN mode and AVLP is 0, an attempt to enter VLPR mode using
 * PMCTRL[RUNM] is blocked and PMCTRL[RUNM] remains 00b, indicating the MCU is
 * still in Normal Run mode. This register is reset on Chip Reset not VLLS and by
 * reset types that trigger Chip Reset not VLLS. It is unaffected by reset types
 * that do not trigger Chip Reset not VLLS. See the Reset section details for more
 * information.
 */
/*!
 * @name Constants and macros for entire SMC_PMPROT register
 */
/*@{*/
#define SMC_RD_PMPROT(base)      (SMC_PMPROT_REG(base))
#define SMC_WR_PMPROT(base, value) (SMC_PMPROT_REG(base) = (value))
#define SMC_RMW_PMPROT(base, mask, value) (SMC_WR_PMPROT(base, (SMC_RD_PMPROT(base) & ~(mask)) | (value)))
#define SMC_SET_PMPROT(base, value) (BME_OR8(&SMC_PMPROT_REG(base), (uint8_t)(value)))
#define SMC_CLR_PMPROT(base, value) (BME_AND8(&SMC_PMPROT_REG(base), (uint8_t)(~(value))))
#define SMC_TOG_PMPROT(base, value) (BME_XOR8(&SMC_PMPROT_REG(base), (uint8_t)(value)))
/*@}*/

/*
 * Constants & macros for individual SMC_PMPROT bitfields
 */

/*!
 * @name Register SMC_PMPROT, field AVLLS[1] (RW)
 *
 * Provided the appropriate control bits are set up in PMCTRL, this write once
 * bit allows the MCU to enter any very-low-leakage stop mode (VLLSx).
 *
 * Values:
 * - 0 - Any VLLSx mode is not allowed
 * - 1 - Any VLLSx mode is allowed
 */
/*@{*/
/*! @brief Read current value of the SMC_PMPROT_AVLLS field. */
#define SMC_RD_PMPROT_AVLLS(base) ((SMC_PMPROT_REG(base) & SMC_PMPROT_AVLLS_MASK) >> SMC_PMPROT_AVLLS_SHIFT)
#define SMC_BRD_PMPROT_AVLLS(base) (BME_UBFX8(&SMC_PMPROT_REG(base), SMC_PMPROT_AVLLS_SHIFT, SMC_PMPROT_AVLLS_WIDTH))

/*! @brief Set the AVLLS field to a new value. */
#define SMC_WR_PMPROT_AVLLS(base, value) (SMC_RMW_PMPROT(base, SMC_PMPROT_AVLLS_MASK, SMC_PMPROT_AVLLS(value)))
#define SMC_BWR_PMPROT_AVLLS(base, value) (BME_BFI8(&SMC_PMPROT_REG(base), ((uint8_t)(value) << SMC_PMPROT_AVLLS_SHIFT), SMC_PMPROT_AVLLS_SHIFT, SMC_PMPROT_AVLLS_WIDTH))
/*@}*/

/*!
 * @name Register SMC_PMPROT, field ALLS[3] (RW)
 *
 * Provided the appropriate control bits are set up in PMCTRL, this write-once
 * field allows the MCU to enter any low-leakage stop mode (LLS).
 *
 * Values:
 * - 0 - LLS is not allowed
 * - 1 - LLS is allowed
 */
/*@{*/
/*! @brief Read current value of the SMC_PMPROT_ALLS field. */
#define SMC_RD_PMPROT_ALLS(base) ((SMC_PMPROT_REG(base) & SMC_PMPROT_ALLS_MASK) >> SMC_PMPROT_ALLS_SHIFT)
#define SMC_BRD_PMPROT_ALLS(base) (BME_UBFX8(&SMC_PMPROT_REG(base), SMC_PMPROT_ALLS_SHIFT, SMC_PMPROT_ALLS_WIDTH))

/*! @brief Set the ALLS field to a new value. */
#define SMC_WR_PMPROT_ALLS(base, value) (SMC_RMW_PMPROT(base, SMC_PMPROT_ALLS_MASK, SMC_PMPROT_ALLS(value)))
#define SMC_BWR_PMPROT_ALLS(base, value) (BME_BFI8(&SMC_PMPROT_REG(base), ((uint8_t)(value) << SMC_PMPROT_ALLS_SHIFT), SMC_PMPROT_ALLS_SHIFT, SMC_PMPROT_ALLS_WIDTH))
/*@}*/

/*!
 * @name Register SMC_PMPROT, field AVLP[5] (RW)
 *
 * Provided the appropriate control bits are set up in PMCTRL, this write-once
 * field allows the MCU to enter any very-low-power mode (VLPR, VLPW, and VLPS).
 *
 * Values:
 * - 0 - VLPR, VLPW, and VLPS are not allowed.
 * - 1 - VLPR, VLPW, and VLPS are allowed.
 */
/*@{*/
/*! @brief Read current value of the SMC_PMPROT_AVLP field. */
#define SMC_RD_PMPROT_AVLP(base) ((SMC_PMPROT_REG(base) & SMC_PMPROT_AVLP_MASK) >> SMC_PMPROT_AVLP_SHIFT)
#define SMC_BRD_PMPROT_AVLP(base) (BME_UBFX8(&SMC_PMPROT_REG(base), SMC_PMPROT_AVLP_SHIFT, SMC_PMPROT_AVLP_WIDTH))

/*! @brief Set the AVLP field to a new value. */
#define SMC_WR_PMPROT_AVLP(base, value) (SMC_RMW_PMPROT(base, SMC_PMPROT_AVLP_MASK, SMC_PMPROT_AVLP(value)))
#define SMC_BWR_PMPROT_AVLP(base, value) (BME_BFI8(&SMC_PMPROT_REG(base), ((uint8_t)(value) << SMC_PMPROT_AVLP_SHIFT), SMC_PMPROT_AVLP_SHIFT, SMC_PMPROT_AVLP_WIDTH))
/*@}*/

/*******************************************************************************
 * SMC_PMCTRL - Power Mode Control register
 ******************************************************************************/

/*!
 * @brief SMC_PMCTRL - Power Mode Control register (RW)
 *
 * Reset value: 0x00U
 *
 * The PMCTRL register controls entry into low-power Run and Stop modes,
 * provided that the selected power mode is allowed via an appropriate setting of the
 * protection (PMPROT) register. This register is reset on Chip POR not VLLS and by
 * reset types that trigger Chip POR not VLLS. It is unaffected by reset types
 * that do not trigger Chip POR not VLLS. See the Reset section details for more
 * information.
 */
/*!
 * @name Constants and macros for entire SMC_PMCTRL register
 */
/*@{*/
#define SMC_RD_PMCTRL(base)      (SMC_PMCTRL_REG(base))
#define SMC_WR_PMCTRL(base, value) (SMC_PMCTRL_REG(base) = (value))
#define SMC_RMW_PMCTRL(base, mask, value) (SMC_WR_PMCTRL(base, (SMC_RD_PMCTRL(base) & ~(mask)) | (value)))
#define SMC_SET_PMCTRL(base, value) (BME_OR8(&SMC_PMCTRL_REG(base), (uint8_t)(value)))
#define SMC_CLR_PMCTRL(base, value) (BME_AND8(&SMC_PMCTRL_REG(base), (uint8_t)(~(value))))
#define SMC_TOG_PMCTRL(base, value) (BME_XOR8(&SMC_PMCTRL_REG(base), (uint8_t)(value)))
/*@}*/

/*
 * Constants & macros for individual SMC_PMCTRL bitfields
 */

/*!
 * @name Register SMC_PMCTRL, field STOPM[2:0] (RW)
 *
 * When written, controls entry into the selected stop mode when Sleep-Now or
 * Sleep-On-Exit mode is entered with SLEEPDEEP=1 . Writes to this field are
 * blocked if the protection level has not been enabled using the PMPROT register.
 * After any system reset, this field is cleared by hardware on any successful write
 * to the PMPROT register. When set to VLLSx, the VLLSM field in the STOPCTRL
 * register is used to further select the particular VLLS submode which will be
 * entered. When set to STOP, the PSTOPO bits in the STOPCTRL register can be used to
 * select a Partial Stop mode if desired.
 *
 * Values:
 * - 000 - Normal Stop (STOP)
 * - 001 - Reserved
 * - 010 - Very-Low-Power Stop (VLPS)
 * - 011 - Low-Leakage Stop (LLS)
 * - 100 - Very-Low-Leakage Stop (VLLSx)
 * - 101 - Reserved
 * - 110 - Reseved
 * - 111 - Reserved
 */
/*@{*/
/*! @brief Read current value of the SMC_PMCTRL_STOPM field. */
#define SMC_RD_PMCTRL_STOPM(base) ((SMC_PMCTRL_REG(base) & SMC_PMCTRL_STOPM_MASK) >> SMC_PMCTRL_STOPM_SHIFT)
#define SMC_BRD_PMCTRL_STOPM(base) (BME_UBFX8(&SMC_PMCTRL_REG(base), SMC_PMCTRL_STOPM_SHIFT, SMC_PMCTRL_STOPM_WIDTH))

/*! @brief Set the STOPM field to a new value. */
#define SMC_WR_PMCTRL_STOPM(base, value) (SMC_RMW_PMCTRL(base, SMC_PMCTRL_STOPM_MASK, SMC_PMCTRL_STOPM(value)))
#define SMC_BWR_PMCTRL_STOPM(base, value) (BME_BFI8(&SMC_PMCTRL_REG(base), ((uint8_t)(value) << SMC_PMCTRL_STOPM_SHIFT), SMC_PMCTRL_STOPM_SHIFT, SMC_PMCTRL_STOPM_WIDTH))
/*@}*/

/*!
 * @name Register SMC_PMCTRL, field STOPA[3] (RO)
 *
 * When set, this read-only status bit indicates an interrupt occured during the
 * previous stop mode entry sequence, preventing the system from entering that
 * mode. This field is cleared by reset or by hardware at the beginning of any
 * stop mode entry sequence and is set if the sequence was aborted.
 *
 * Values:
 * - 0 - The previous stop mode entry was successsful.
 * - 1 - The previous stop mode entry was aborted.
 */
/*@{*/
/*! @brief Read current value of the SMC_PMCTRL_STOPA field. */
#define SMC_RD_PMCTRL_STOPA(base) ((SMC_PMCTRL_REG(base) & SMC_PMCTRL_STOPA_MASK) >> SMC_PMCTRL_STOPA_SHIFT)
#define SMC_BRD_PMCTRL_STOPA(base) (BME_UBFX8(&SMC_PMCTRL_REG(base), SMC_PMCTRL_STOPA_SHIFT, SMC_PMCTRL_STOPA_WIDTH))
/*@}*/

/*!
 * @name Register SMC_PMCTRL, field RUNM[6:5] (RW)
 *
 * When written, causes entry into the selected run mode. Writes to this field
 * are blocked if the protection level has not been enabled using the PMPROT
 * register. RUNM may be set to VLPR only when PMSTAT=RUN. After being written to
 * VLPR, RUNM should not be written back to RUN until PMSTAT=VLPR.
 *
 * Values:
 * - 00 - Normal Run mode (RUN)
 * - 01 - Reserved
 * - 10 - Very-Low-Power Run mode (VLPR)
 * - 11 - Reserved
 */
/*@{*/
/*! @brief Read current value of the SMC_PMCTRL_RUNM field. */
#define SMC_RD_PMCTRL_RUNM(base) ((SMC_PMCTRL_REG(base) & SMC_PMCTRL_RUNM_MASK) >> SMC_PMCTRL_RUNM_SHIFT)
#define SMC_BRD_PMCTRL_RUNM(base) (BME_UBFX8(&SMC_PMCTRL_REG(base), SMC_PMCTRL_RUNM_SHIFT, SMC_PMCTRL_RUNM_WIDTH))

/*! @brief Set the RUNM field to a new value. */
#define SMC_WR_PMCTRL_RUNM(base, value) (SMC_RMW_PMCTRL(base, SMC_PMCTRL_RUNM_MASK, SMC_PMCTRL_RUNM(value)))
#define SMC_BWR_PMCTRL_RUNM(base, value) (BME_BFI8(&SMC_PMCTRL_REG(base), ((uint8_t)(value) << SMC_PMCTRL_RUNM_SHIFT), SMC_PMCTRL_RUNM_SHIFT, SMC_PMCTRL_RUNM_WIDTH))
/*@}*/

/*******************************************************************************
 * SMC_STOPCTRL - Stop Control Register
 ******************************************************************************/

/*!
 * @brief SMC_STOPCTRL - Stop Control Register (RW)
 *
 * Reset value: 0x03U
 *
 * The STOPCTRL register provides various control bits allowing the user to fine
 * tune power consumption during the stop mode selected by the STOPM field. This
 * register is reset on Chip POR not VLLS and by reset types that trigger Chip
 * POR not VLLS. It is unaffected by reset types that do not trigger Chip POR not
 * VLLS. See the Reset section details for more information.
 */
/*!
 * @name Constants and macros for entire SMC_STOPCTRL register
 */
/*@{*/
#define SMC_RD_STOPCTRL(base)    (SMC_STOPCTRL_REG(base))
#define SMC_WR_STOPCTRL(base, value) (SMC_STOPCTRL_REG(base) = (value))
#define SMC_RMW_STOPCTRL(base, mask, value) (SMC_WR_STOPCTRL(base, (SMC_RD_STOPCTRL(base) & ~(mask)) | (value)))
#define SMC_SET_STOPCTRL(base, value) (BME_OR8(&SMC_STOPCTRL_REG(base), (uint8_t)(value)))
#define SMC_CLR_STOPCTRL(base, value) (BME_AND8(&SMC_STOPCTRL_REG(base), (uint8_t)(~(value))))
#define SMC_TOG_STOPCTRL(base, value) (BME_XOR8(&SMC_STOPCTRL_REG(base), (uint8_t)(value)))
/*@}*/

/*
 * Constants & macros for individual SMC_STOPCTRL bitfields
 */

/*!
 * @name Register SMC_STOPCTRL, field VLLSM[2:0] (RW)
 *
 * This field controls which VLLS sub-mode to enter if STOPM = VLLSx.
 *
 * Values:
 * - 000 - VLLS0
 * - 001 - VLLS1
 * - 010 - Reserved
 * - 011 - VLLS3
 * - 100 - Reserved
 * - 101 - Reserved
 * - 110 - Reserved
 * - 111 - Reserved
 */
/*@{*/
/*! @brief Read current value of the SMC_STOPCTRL_VLLSM field. */
#define SMC_RD_STOPCTRL_VLLSM(base) ((SMC_STOPCTRL_REG(base) & SMC_STOPCTRL_VLLSM_MASK) >> SMC_STOPCTRL_VLLSM_SHIFT)
#define SMC_BRD_STOPCTRL_VLLSM(base) (BME_UBFX8(&SMC_STOPCTRL_REG(base), SMC_STOPCTRL_VLLSM_SHIFT, SMC_STOPCTRL_VLLSM_WIDTH))

/*! @brief Set the VLLSM field to a new value. */
#define SMC_WR_STOPCTRL_VLLSM(base, value) (SMC_RMW_STOPCTRL(base, SMC_STOPCTRL_VLLSM_MASK, SMC_STOPCTRL_VLLSM(value)))
#define SMC_BWR_STOPCTRL_VLLSM(base, value) (BME_BFI8(&SMC_STOPCTRL_REG(base), ((uint8_t)(value) << SMC_STOPCTRL_VLLSM_SHIFT), SMC_STOPCTRL_VLLSM_SHIFT, SMC_STOPCTRL_VLLSM_WIDTH))
/*@}*/

/*!
 * @name Register SMC_STOPCTRL, field LPOPO[3] (RW)
 *
 * Controls whether the 1 kHz LPO clock is enabled in LLS/VLLSx modes. During
 * VLLS0 mode, the LPO clock is disabled by hardware and this bit has no effect.
 *
 * Values:
 * - 0 - LPO clock is enabled in LLS/VLLSx
 * - 1 - LPO clock is disabled in LLS/VLLSx
 */
/*@{*/
/*! @brief Read current value of the SMC_STOPCTRL_LPOPO field. */
#define SMC_RD_STOPCTRL_LPOPO(base) ((SMC_STOPCTRL_REG(base) & SMC_STOPCTRL_LPOPO_MASK) >> SMC_STOPCTRL_LPOPO_SHIFT)
#define SMC_BRD_STOPCTRL_LPOPO(base) (BME_UBFX8(&SMC_STOPCTRL_REG(base), SMC_STOPCTRL_LPOPO_SHIFT, SMC_STOPCTRL_LPOPO_WIDTH))

/*! @brief Set the LPOPO field to a new value. */
#define SMC_WR_STOPCTRL_LPOPO(base, value) (SMC_RMW_STOPCTRL(base, SMC_STOPCTRL_LPOPO_MASK, SMC_STOPCTRL_LPOPO(value)))
#define SMC_BWR_STOPCTRL_LPOPO(base, value) (BME_BFI8(&SMC_STOPCTRL_REG(base), ((uint8_t)(value) << SMC_STOPCTRL_LPOPO_SHIFT), SMC_STOPCTRL_LPOPO_SHIFT, SMC_STOPCTRL_LPOPO_WIDTH))
/*@}*/

/*!
 * @name Register SMC_STOPCTRL, field PORPO[5] (RW)
 *
 * This bit controls whether the POR detect circuit is enabled in VLLS0 mode.
 *
 * Values:
 * - 0 - POR detect circuit is enabled in VLLS0
 * - 1 - POR detect circuit is disabled in VLLS0
 */
/*@{*/
/*! @brief Read current value of the SMC_STOPCTRL_PORPO field. */
#define SMC_RD_STOPCTRL_PORPO(base) ((SMC_STOPCTRL_REG(base) & SMC_STOPCTRL_PORPO_MASK) >> SMC_STOPCTRL_PORPO_SHIFT)
#define SMC_BRD_STOPCTRL_PORPO(base) (BME_UBFX8(&SMC_STOPCTRL_REG(base), SMC_STOPCTRL_PORPO_SHIFT, SMC_STOPCTRL_PORPO_WIDTH))

/*! @brief Set the PORPO field to a new value. */
#define SMC_WR_STOPCTRL_PORPO(base, value) (SMC_RMW_STOPCTRL(base, SMC_STOPCTRL_PORPO_MASK, SMC_STOPCTRL_PORPO(value)))
#define SMC_BWR_STOPCTRL_PORPO(base, value) (BME_BFI8(&SMC_STOPCTRL_REG(base), ((uint8_t)(value) << SMC_STOPCTRL_PORPO_SHIFT), SMC_STOPCTRL_PORPO_SHIFT, SMC_STOPCTRL_PORPO_WIDTH))
/*@}*/

/*!
 * @name Register SMC_STOPCTRL, field PSTOPO[7:6] (RW)
 *
 * These bits control whether a Partial Stop mode is entered when STOPM=STOP.
 * When entering a Partial Stop mode from RUN mode, the PMC, MCG and flash remain
 * fully powered, allowing the device to wakeup almost instantaneously at the
 * expense of higher power consumption. In PSTOP2, only system clocks are gated
 * allowing peripherals running on bus clock to remain fully functional. In PSTOP1,
 * both system and bus clocks are gated.
 *
 * Values:
 * - 00 - STOP - Normal Stop mode
 * - 01 - PSTOP1 - Partial Stop with both system and bus clocks disabled
 * - 10 - PSTOP2 - Partial Stop with system clock disabled and bus clock enabled
 * - 11 - Reserved
 */
/*@{*/
/*! @brief Read current value of the SMC_STOPCTRL_PSTOPO field. */
#define SMC_RD_STOPCTRL_PSTOPO(base) ((SMC_STOPCTRL_REG(base) & SMC_STOPCTRL_PSTOPO_MASK) >> SMC_STOPCTRL_PSTOPO_SHIFT)
#define SMC_BRD_STOPCTRL_PSTOPO(base) (BME_UBFX8(&SMC_STOPCTRL_REG(base), SMC_STOPCTRL_PSTOPO_SHIFT, SMC_STOPCTRL_PSTOPO_WIDTH))

/*! @brief Set the PSTOPO field to a new value. */
#define SMC_WR_STOPCTRL_PSTOPO(base, value) (SMC_RMW_STOPCTRL(base, SMC_STOPCTRL_PSTOPO_MASK, SMC_STOPCTRL_PSTOPO(value)))
#define SMC_BWR_STOPCTRL_PSTOPO(base, value) (BME_BFI8(&SMC_STOPCTRL_REG(base), ((uint8_t)(value) << SMC_STOPCTRL_PSTOPO_SHIFT), SMC_STOPCTRL_PSTOPO_SHIFT, SMC_STOPCTRL_PSTOPO_WIDTH))
/*@}*/

/*******************************************************************************
 * SMC_PMSTAT - Power Mode Status register
 ******************************************************************************/

/*!
 * @brief SMC_PMSTAT - Power Mode Status register (RO)
 *
 * Reset value: 0x01U
 *
 * PMSTAT is a read-only, one-hot register which indicates the current power
 * mode of the system. This register is reset on Chip POR not VLLS and by reset
 * types that trigger Chip POR not VLLS. It is unaffected by reset types that do not
 * trigger Chip POR not VLLS. See the Reset section details for more information.
 */
/*!
 * @name Constants and macros for entire SMC_PMSTAT register
 */
/*@{*/
#define SMC_RD_PMSTAT(base)      (SMC_PMSTAT_REG(base))
/*@}*/

/*
 * MKL27Z644 SPI
 *
 * Serial Peripheral Interface
 *
 * Registers defined in this header file:
 * - SPI_S - SPI Status Register
 * - SPI_BR - SPI Baud Rate Register
 * - SPI_C2 - SPI Control Register 2
 * - SPI_C1 - SPI Control Register 1
 * - SPI_ML - SPI Match Register low
 * - SPI_MH - SPI match register high
 * - SPI_DL - SPI Data Register low
 * - SPI_DH - SPI data register high
 * - SPI_CI - SPI clear interrupt register
 * - SPI_C3 - SPI control register 3
 */

#define SPI_INSTANCE_COUNT (2U) /*!< Number of instances of the SPI module. */
#define SPI0_IDX (0U) /*!< Instance number for SPI0. */
#define SPI1_IDX (1U) /*!< Instance number for SPI1. */

/*******************************************************************************
 * SPI_S - SPI Status Register
 ******************************************************************************/

/*!
 * @brief SPI_S - SPI Status Register (RW)
 *
 * Reset value: 0x20U
 *
 * This register contains read-only status bits. Writes have no meaning or
 * effect. When the FIFO is not supported or not enabled (FIFOMODE is not present or
 * is 0): Bits 3 through 0 are not implemented and always read 0. When the FIFO is
 * supported and enabled (FIFOMODE is 1): This register has four flags that
 * provide mechanisms to support an 8-byte FIFO mode: RNFULLF, TNEARF, TXFULLF, and
 * RFIFOEF. When the SPI is in 8-byte FIFO mode, the function of SPRF and SPTEF
 * differs slightly from their function in the normal buffered modes, mainly
 * regarding how these flags are cleared by the amount available in the transmit and
 * receive FIFOs. The RNFULLF and TNEAREF help improve the efficiency of FIFO
 * operation when transfering large amounts of data. These flags provide a "watermark"
 * feature of the FIFOs to allow continuous transmissions of data when running
 * at high speed. The RNFULLF can generate an interrupt if the RNFULLIEN bit in
 * the C3 register is set, which allows the CPU to start emptying the receive FIFO
 * without delaying the reception of subsequent bytes. The user can also
 * determine if all data in the receive FIFO has been read by monitoring the RFIFOEF. The
 * TNEAREF can generate an interrupt if the TNEARIEN bit in the C3 register is
 * set, which allows the CPU to start filling the transmit FIFO before it is empty
 * and thus to prevent breaks in SPI transmission. At an initial POR, the values
 * of TNEAREF and RFIFOEF are 0. However, the status (S) register and both TX
 * and RX FIFOs are reset due to a change of SPIMODE, FIFOMODE or SPE. If this type
 * of reset occurs and FIFOMODE is 0, TNEAREF and RFIFOEF continue to reset to
 * 0. If this type of reset occurs and FIFOMODE is 1, TNEAREF and RFIFOEF reset to
 * 1.
 */
/*!
 * @name Constants and macros for entire SPI_S register
 */
/*@{*/
#define SPI_RD_S(base)           (SPI_S_REG(base))
#define SPI_WR_S(base, value)    (SPI_S_REG(base) = (value))
#define SPI_RMW_S(base, mask, value) (SPI_WR_S(base, (SPI_RD_S(base) & ~(mask)) | (value)))
#define SPI_SET_S(base, value)   (BME_OR8(&SPI_S_REG(base), (uint8_t)(value)))
#define SPI_CLR_S(base, value)   (BME_AND8(&SPI_S_REG(base), (uint8_t)(~(value))))
#define SPI_TOG_S(base, value)   (BME_XOR8(&SPI_S_REG(base), (uint8_t)(value)))
/*@}*/

/*
 * Constants & macros for individual SPI_S bitfields
 */

/*!
 * @name Register SPI_S, field RFIFOEF[0] (RO)
 *
 * This bit indicates the status of the read FIFO when FIFOMODE is enabled. If
 * FIFOMODE is not enabled, ignore this bit. When FIFOMODE and DMA are both
 * enabled, the inverted RXIFOEF is used to trigger a DMA transfer. So when the receive
 * FIFO is not empty, the DMA request is active, and remains active until the
 * FIFO is empty. At an initial POR, the values of TNEAREF and RFIFOEF are 0.
 * However, the status (S) register and both TX and RX FIFOs are reset due to a change
 * of SPIMODE, FIFOMODE or SPE. If this type of reset occurs and FIFOMODE is 0,
 * TNEAREF and RFIFOEF continue to reset to 0. If this type of reset occurs and
 * FIFOMODE is 1, TNEAREF and RFIFOEF reset to 1.
 *
 * Values:
 * - 0 - Read FIFO has data. Reads of the DH:DL registers in 16-bit mode or the
 *     DL register in 8-bit mode will empty the read FIFO.
 * - 1 - Read FIFO is empty.
 */
/*@{*/
/*! @brief Read current value of the SPI_S_RFIFOEF field. */
#define SPI_RD_S_RFIFOEF(base) ((SPI_S_REG(base) & SPI_S_RFIFOEF_MASK) >> SPI_S_RFIFOEF_SHIFT)
#define SPI_BRD_S_RFIFOEF(base) (BME_UBFX8(&SPI_S_REG(base), SPI_S_RFIFOEF_SHIFT, SPI_S_RFIFOEF_WIDTH))
/*@}*/

/*!
 * @name Register SPI_S, field TXFULLF[1] (RO)
 *
 * This bit indicates the status of the transmit FIFO when FIFOMODE is enabled.
 * This flag is set when there are 8 bytes in the transmit FIFO. If FIFOMODE is
 * not enabled, ignore this bit. When FIFOMODE and DMA are both enabled, the
 * inverted TXFULLF is used to trigger a DMA transfer. So when the transmit FIFO is
 * not full, the DMA request is active, and remains active until the FIFO is full.
 *
 * Values:
 * - 0 - Transmit FIFO has less than 8 bytes
 * - 1 - Transmit FIFO has 8 bytes of data
 */
/*@{*/
/*! @brief Read current value of the SPI_S_TXFULLF field. */
#define SPI_RD_S_TXFULLF(base) ((SPI_S_REG(base) & SPI_S_TXFULLF_MASK) >> SPI_S_TXFULLF_SHIFT)
#define SPI_BRD_S_TXFULLF(base) (BME_UBFX8(&SPI_S_REG(base), SPI_S_TXFULLF_SHIFT, SPI_S_TXFULLF_WIDTH))
/*@}*/

/*!
 * @name Register SPI_S, field TNEAREF[2] (RO)
 *
 * This flag is set when only one 16-bit word or two 8-bit bytes of data remain
 * in the transmit FIFO, provided C3[TNEAREF_MARK] is 0, or when only two 16-bit
 * words or four 8-bit bytes of data remain in the transmit FIFO, provided
 * C3[TNEAREF_MARK] is 1. If FIFOMODE is not enabled, ignore this bit. At an initial
 * POR, the values of TNEAREF and RFIFOEF are 0. However, the status (S) register
 * and both TX and RX FIFOs are reset due to a change of SPIMODE, FIFOMODE or SPE.
 * If this type of reset occurs and FIFOMODE is 0, TNEAREF and RFIFOEF continue
 * to reset to 0. If this type of reset occurs and FIFOMODE is 1, TNEAREF and
 * RFIFOEF reset to 1.
 *
 * Values:
 * - 0 - Transmit FIFO has more than 16 bits (when C3[TNEAREF_MARK] is 0) or
 *     more than 32 bits (when C3[TNEAREF_MARK] is 1) remaining to transmit
 * - 1 - Transmit FIFO has an amount of data equal to or less than 16 bits (when
 *     C3[TNEAREF_MARK] is 0) or 32 bits (when C3[TNEAREF_MARK] is 1) remaining
 *     to transmit
 */
/*@{*/
/*! @brief Read current value of the SPI_S_TNEAREF field. */
#define SPI_RD_S_TNEAREF(base) ((SPI_S_REG(base) & SPI_S_TNEAREF_MASK) >> SPI_S_TNEAREF_SHIFT)
#define SPI_BRD_S_TNEAREF(base) (BME_UBFX8(&SPI_S_REG(base), SPI_S_TNEAREF_SHIFT, SPI_S_TNEAREF_WIDTH))
/*@}*/

/*!
 * @name Register SPI_S, field RNFULLF[3] (RO)
 *
 * This flag is set when more than three 16-bit words or six 8-bit bytes of data
 * remain in the receive FIFO, provided C3[RNFULLF_MARK] is 0, or when more than
 * two 16-bit words or four 8-bit bytes of data remain in the receive FIFO,
 * provided C3[RNFULLF_MARK] is 1. It has no function if FIFOMODE is not present or
 * is 0.
 *
 * Values:
 * - 0 - Receive FIFO has received less than 48 bits (when C3[RNFULLF_MARK] is
 *     0) or less than 32 bits (when C3[RNFULLF_MARK] is 1)
 * - 1 - Receive FIFO has received data of an amount equal to or greater than 48
 *     bits (when C3[RNFULLF_MARK] is 0) or 32 bits (when C3[RNFULLF_MARK] is 1)
 */
/*@{*/
/*! @brief Read current value of the SPI_S_RNFULLF field. */
#define SPI_RD_S_RNFULLF(base) ((SPI_S_REG(base) & SPI_S_RNFULLF_MASK) >> SPI_S_RNFULLF_SHIFT)
#define SPI_BRD_S_RNFULLF(base) (BME_UBFX8(&SPI_S_REG(base), SPI_S_RNFULLF_SHIFT, SPI_S_RNFULLF_WIDTH))
/*@}*/

/*!
 * @name Register SPI_S, field MODF[4] (RO)
 *
 * MODF is set if the SPI is configured as a master and the slave select input
 * goes low, indicating some other SPI device is also configured as a master. The
 * SS pin acts as a mode fault error input only when C1[MSTR] is 1, C2[MODFEN] is
 * 1, and C1[SSOE] is 0; otherwise, MODF will never be set. MODF is cleared by
 * reading MODF while it is 1 and then writing to the SPI Control Register 1 (C1).
 *
 * Values:
 * - 0 - No mode fault error
 * - 1 - Mode fault error detected
 */
/*@{*/
/*! @brief Read current value of the SPI_S_MODF field. */
#define SPI_RD_S_MODF(base)  ((SPI_S_REG(base) & SPI_S_MODF_MASK) >> SPI_S_MODF_SHIFT)
#define SPI_BRD_S_MODF(base) (BME_UBFX8(&SPI_S_REG(base), SPI_S_MODF_SHIFT, SPI_S_MODF_WIDTH))
/*@}*/

/*!
 * @name Register SPI_S, field SPTEF[5] (RO)
 *
 * When the FIFO is not supported or not enabled (FIFOMODE is not present or is
 * 0): This bit is set when the transmit data buffer is empty. When the transmit
 * DMA request is disabled (TXDMAE is 0), SPTEF is cleared by reading the S
 * register with SPTEF set and then writing a data value to the transmit buffer at
 * DH:DL. The S register must be read with SPTEF set to 1 before writing data to the
 * DH:DL register; otherwise, the DH:DL write is ignored. When the transmit DMA
 * request is enabled (TXDMAE is 1), SPTEF is automatically cleared when the DMA
 * transfer for the transmit DMA request is completed (TX DMA Done is asserted).
 * SPTEF is automatically set when all data from the transmit buffer transfers
 * into the transmit shift register. For an idle SPI, data written to DH:DL is
 * transferred to the shifter almost immediately so that SPTEF is set within two bus
 * cycles, allowing a second set of data to be queued into the transmit buffer.
 * After completion of the transfer of the data in the shift register, the queued
 * data from the transmit buffer automatically moves to the shifter, and SPTEF is
 * set to indicate that room exists for new data in the transmit buffer. If no
 * new data is waiting in the transmit buffer, SPTEF simply remains set and no
 * data moves from the buffer to the shifter. When the FIFO is not supported or not
 * enabled (FIFOMODE is not present or is 0): If a transfer does not stop, the
 * last data that was transmitted is sent out again. When the FIFO is supported and
 * enabled (FIFOMODE is 1): This bit provides the status of the FIFO rather than
 * an 8-bit or a 16-bit buffer. This bit is set when the transmit FIFO is empty.
 * When the transmit DMA request is disabled (TXDMAE is 0), SPTEF is cleared by
 * writing a data value to the transmit FIFO at DH:DL. When the transmit DMA
 * request is enabled (TXDMAE is 1), SPTEF is automatically cleared when the DMA
 * transfer for the transmit DMA request is completed (TX DMA Done is asserted).
 * SPTEF is automatically set when all data from the transmit FIFO transfers into the
 * transmit shift register. For an idle SPI, data written to the DH:DL register
 * is transferred to the shifter almost immediately, so that SPTEF is set within
 * two bus cycles. A second write of data to the DH:DL register clears this SPTEF
 * flag. After completion of the transfer of the data in the shift register, the
 * queued data from the transmit FIFO automatically moves to the shifter, and
 * SPTEF will be set only when all data written to the transmit FIFO has been
 * transfered to the shifter. If no new data is waiting in the transmit FIFO, SPTEF
 * simply remains set and no data moves from the buffer to the shifter.
 *
 * Values:
 * - 0 - SPI transmit buffer not empty (when FIFOMODE is not present or is 0) or
 *     SPI FIFO not empty (when FIFOMODE is 1)
 * - 1 - SPI transmit buffer empty (when FIFOMODE is not present or is 0) or SPI
 *     FIFO empty (when FIFOMODE is 1)
 */
/*@{*/
/*! @brief Read current value of the SPI_S_SPTEF field. */
#define SPI_RD_S_SPTEF(base) ((SPI_S_REG(base) & SPI_S_SPTEF_MASK) >> SPI_S_SPTEF_SHIFT)
#define SPI_BRD_S_SPTEF(base) (BME_UBFX8(&SPI_S_REG(base), SPI_S_SPTEF_SHIFT, SPI_S_SPTEF_WIDTH))
/*@}*/

/*!
 * @name Register SPI_S, field SPMF[6] (W1C)
 *
 * SPMF is set after SPRF is 1 when the value in the receive data buffer matches
 * the value in the MH:ML registers. To clear the flag, read SPMF when it is set
 * and then write a 1 to it.
 *
 * Values:
 * - 0 - Value in the receive data buffer does not match the value in the MH:ML
 *     registers
 * - 1 - Value in the receive data buffer matches the value in the MH:ML
 *     registers
 */
/*@{*/
/*! @brief Read current value of the SPI_S_SPMF field. */
#define SPI_RD_S_SPMF(base)  ((SPI_S_REG(base) & SPI_S_SPMF_MASK) >> SPI_S_SPMF_SHIFT)
#define SPI_BRD_S_SPMF(base) (BME_UBFX8(&SPI_S_REG(base), SPI_S_SPMF_SHIFT, SPI_S_SPMF_WIDTH))

/*! @brief Set the SPMF field to a new value. */
#define SPI_WR_S_SPMF(base, value) (SPI_RMW_S(base, SPI_S_SPMF_MASK, SPI_S_SPMF(value)))
#define SPI_BWR_S_SPMF(base, value) (BME_BFI8(&SPI_S_REG(base), ((uint8_t)(value) << SPI_S_SPMF_SHIFT), SPI_S_SPMF_SHIFT, SPI_S_SPMF_WIDTH))
/*@}*/

/*!
 * @name Register SPI_S, field SPRF[7] (RO)
 *
 * When the FIFO is not supported or not enabled (FIFOMODE is not present or is
 * 0): SPRF is set at the completion of an SPI transfer to indicate that received
 * data may be read from the SPI data (DH:DL) register. When the receive DMA
 * request is disabled (RXDMAE is 0), SPRF is cleared by reading SPRF while it is
 * set and then reading the SPI data register. When the receive DMA request is
 * enabled (RXDMAE is 1), SPRF is automatically cleared when the DMA transfer for the
 * receive DMA request is completed (RX DMA Done is asserted). When FIFOMODE is
 * 1: This bit indicates the status of the read FIFO when FIFOMODE is enabled.
 * The SPRF is set when the read FIFO has received 64 bits (4 words or 8 bytes) of
 * data from the shifter and there have been no CPU reads of the SPI data (DH:DL)
 * register. When the receive DMA request is disabled (RXDMAE is 0), SPRF is
 * cleared by reading the SPI data register, resulting in the FIFO no longer being
 * full, assuming another SPI message is not received. When the receive DMA
 * request is enabled (RXDMAE is 1), SPRF is automatically cleared when the first DMA
 * transfer for the receive DMA request is completed (RX DMA Done is asserted).
 *
 * Values:
 * - 0 - No data available in the receive data buffer (when FIFOMODE is not
 *     present or is 0) or Read FIFO is not full (when FIFOMODE is 1)
 * - 1 - Data available in the receive data buffer (when FIFOMODE is not present
 *     or is 0) or Read FIFO is full (when FIFOMODE is 1)
 */
/*@{*/
/*! @brief Read current value of the SPI_S_SPRF field. */
#define SPI_RD_S_SPRF(base)  ((SPI_S_REG(base) & SPI_S_SPRF_MASK) >> SPI_S_SPRF_SHIFT)
#define SPI_BRD_S_SPRF(base) (BME_UBFX8(&SPI_S_REG(base), SPI_S_SPRF_SHIFT, SPI_S_SPRF_WIDTH))
/*@}*/

/*******************************************************************************
 * SPI_BR - SPI Baud Rate Register
 ******************************************************************************/

/*!
 * @brief SPI_BR - SPI Baud Rate Register (RW)
 *
 * Reset value: 0x00U
 *
 * Use this register to set the prescaler and bit rate divisor for an SPI
 * master. This register may be read or written at any time.
 */
/*!
 * @name Constants and macros for entire SPI_BR register
 */
/*@{*/
#define SPI_RD_BR(base)          (SPI_BR_REG(base))
#define SPI_WR_BR(base, value)   (SPI_BR_REG(base) = (value))
#define SPI_RMW_BR(base, mask, value) (SPI_WR_BR(base, (SPI_RD_BR(base) & ~(mask)) | (value)))
#define SPI_SET_BR(base, value)  (BME_OR8(&SPI_BR_REG(base), (uint8_t)(value)))
#define SPI_CLR_BR(base, value)  (BME_AND8(&SPI_BR_REG(base), (uint8_t)(~(value))))
#define SPI_TOG_BR(base, value)  (BME_XOR8(&SPI_BR_REG(base), (uint8_t)(value)))
/*@}*/

/*
 * Constants & macros for individual SPI_BR bitfields
 */

/*!
 * @name Register SPI_BR, field SPR[3:0] (RW)
 *
 * This 4-bit field selects one of nine divisors for the SPI baud rate divider.
 * The input to this divider comes from the SPI baud rate prescaler. Refer to the
 * description of "SPI Baud Rate Generation" for details.
 *
 * Values:
 * - 0000 - Baud rate divisor is 2.
 * - 0001 - Baud rate divisor is 4.
 * - 0010 - Baud rate divisor is 8.
 * - 0011 - Baud rate divisor is 16.
 * - 0100 - Baud rate divisor is 32.
 * - 0101 - Baud rate divisor is 64.
 * - 0110 - Baud rate divisor is 128.
 * - 0111 - Baud rate divisor is 256.
 * - 1000 - Baud rate divisor is 512.
 */
/*@{*/
/*! @brief Read current value of the SPI_BR_SPR field. */
#define SPI_RD_BR_SPR(base)  ((SPI_BR_REG(base) & SPI_BR_SPR_MASK) >> SPI_BR_SPR_SHIFT)
#define SPI_BRD_BR_SPR(base) (BME_UBFX8(&SPI_BR_REG(base), SPI_BR_SPR_SHIFT, SPI_BR_SPR_WIDTH))

/*! @brief Set the SPR field to a new value. */
#define SPI_WR_BR_SPR(base, value) (SPI_RMW_BR(base, SPI_BR_SPR_MASK, SPI_BR_SPR(value)))
#define SPI_BWR_BR_SPR(base, value) (BME_BFI8(&SPI_BR_REG(base), ((uint8_t)(value) << SPI_BR_SPR_SHIFT), SPI_BR_SPR_SHIFT, SPI_BR_SPR_WIDTH))
/*@}*/

/*!
 * @name Register SPI_BR, field SPPR[6:4] (RW)
 *
 * This 3-bit field selects one of eight divisors for the SPI baud rate
 * prescaler. The input to this prescaler is the SPI module clock. The output of this
 * prescaler drives the input of the SPI baud rate divider. Refer to the description
 * of "SPI Baud Rate Generation" for details.
 *
 * Values:
 * - 000 - Baud rate prescaler divisor is 1.
 * - 001 - Baud rate prescaler divisor is 2.
 * - 010 - Baud rate prescaler divisor is 3.
 * - 011 - Baud rate prescaler divisor is 4.
 * - 100 - Baud rate prescaler divisor is 5.
 * - 101 - Baud rate prescaler divisor is 6.
 * - 110 - Baud rate prescaler divisor is 7.
 * - 111 - Baud rate prescaler divisor is 8.
 */
/*@{*/
/*! @brief Read current value of the SPI_BR_SPPR field. */
#define SPI_RD_BR_SPPR(base) ((SPI_BR_REG(base) & SPI_BR_SPPR_MASK) >> SPI_BR_SPPR_SHIFT)
#define SPI_BRD_BR_SPPR(base) (BME_UBFX8(&SPI_BR_REG(base), SPI_BR_SPPR_SHIFT, SPI_BR_SPPR_WIDTH))

/*! @brief Set the SPPR field to a new value. */
#define SPI_WR_BR_SPPR(base, value) (SPI_RMW_BR(base, SPI_BR_SPPR_MASK, SPI_BR_SPPR(value)))
#define SPI_BWR_BR_SPPR(base, value) (BME_BFI8(&SPI_BR_REG(base), ((uint8_t)(value) << SPI_BR_SPPR_SHIFT), SPI_BR_SPPR_SHIFT, SPI_BR_SPPR_WIDTH))
/*@}*/

/*******************************************************************************
 * SPI_C2 - SPI Control Register 2
 ******************************************************************************/

/*!
 * @brief SPI_C2 - SPI Control Register 2 (RW)
 *
 * Reset value: 0x00U
 *
 * This read/write register is used to control optional features of the SPI
 * system.
 */
/*!
 * @name Constants and macros for entire SPI_C2 register
 */
/*@{*/
#define SPI_RD_C2(base)          (SPI_C2_REG(base))
#define SPI_WR_C2(base, value)   (SPI_C2_REG(base) = (value))
#define SPI_RMW_C2(base, mask, value) (SPI_WR_C2(base, (SPI_RD_C2(base) & ~(mask)) | (value)))
#define SPI_SET_C2(base, value)  (BME_OR8(&SPI_C2_REG(base), (uint8_t)(value)))
#define SPI_CLR_C2(base, value)  (BME_AND8(&SPI_C2_REG(base), (uint8_t)(~(value))))
#define SPI_TOG_C2(base, value)  (BME_XOR8(&SPI_C2_REG(base), (uint8_t)(value)))
/*@}*/

/*
 * Constants & macros for individual SPI_C2 bitfields
 */

/*!
 * @name Register SPI_C2, field SPC0[0] (RW)
 *
 * Enables bidirectional pin configurations.
 *
 * Values:
 * - 0 - SPI uses separate pins for data input and data output (pin mode is
 *     normal). In master mode of operation: MISO is master in and MOSI is master
 *     out. In slave mode of operation: MISO is slave out and MOSI is slave in.
 * - 1 - SPI configured for single-wire bidirectional operation (pin mode is
 *     bidirectional). In master mode of operation: MISO is not used by SPI; MOSI is
 *     master in when BIDIROE is 0 or master I/O when BIDIROE is 1. In slave
 *     mode of operation: MISO is slave in when BIDIROE is 0 or slave I/O when
 *     BIDIROE is 1; MOSI is not used by SPI.
 */
/*@{*/
/*! @brief Read current value of the SPI_C2_SPC0 field. */
#define SPI_RD_C2_SPC0(base) ((SPI_C2_REG(base) & SPI_C2_SPC0_MASK) >> SPI_C2_SPC0_SHIFT)
#define SPI_BRD_C2_SPC0(base) (BME_UBFX8(&SPI_C2_REG(base), SPI_C2_SPC0_SHIFT, SPI_C2_SPC0_WIDTH))

/*! @brief Set the SPC0 field to a new value. */
#define SPI_WR_C2_SPC0(base, value) (SPI_RMW_C2(base, SPI_C2_SPC0_MASK, SPI_C2_SPC0(value)))
#define SPI_BWR_C2_SPC0(base, value) (BME_BFI8(&SPI_C2_REG(base), ((uint8_t)(value) << SPI_C2_SPC0_SHIFT), SPI_C2_SPC0_SHIFT, SPI_C2_SPC0_WIDTH))
/*@}*/

/*!
 * @name Register SPI_C2, field SPISWAI[1] (RW)
 *
 * This bit is used for power conservation while the device is in Wait mode.
 *
 * Values:
 * - 0 - SPI clocks continue to operate in Wait mode.
 * - 1 - SPI clocks stop when the MCU enters Wait mode.
 */
/*@{*/
/*! @brief Read current value of the SPI_C2_SPISWAI field. */
#define SPI_RD_C2_SPISWAI(base) ((SPI_C2_REG(base) & SPI_C2_SPISWAI_MASK) >> SPI_C2_SPISWAI_SHIFT)
#define SPI_BRD_C2_SPISWAI(base) (BME_UBFX8(&SPI_C2_REG(base), SPI_C2_SPISWAI_SHIFT, SPI_C2_SPISWAI_WIDTH))

/*! @brief Set the SPISWAI field to a new value. */
#define SPI_WR_C2_SPISWAI(base, value) (SPI_RMW_C2(base, SPI_C2_SPISWAI_MASK, SPI_C2_SPISWAI(value)))
#define SPI_BWR_C2_SPISWAI(base, value) (BME_BFI8(&SPI_C2_REG(base), ((uint8_t)(value) << SPI_C2_SPISWAI_SHIFT), SPI_C2_SPISWAI_SHIFT, SPI_C2_SPISWAI_WIDTH))
/*@}*/

/*!
 * @name Register SPI_C2, field RXDMAE[2] (RW)
 *
 * This is the enable bit for a receive DMA request. When this bit is set to 1,
 * a receive DMA request is asserted when both SPRF and SPE are set, and the
 * interrupt from SPRF is disabled.
 *
 * Values:
 * - 0 - DMA request for receive is disabled and interrupt from SPRF is allowed
 * - 1 - DMA request for receive is enabled and interrupt from SPRF is disabled
 */
/*@{*/
/*! @brief Read current value of the SPI_C2_RXDMAE field. */
#define SPI_RD_C2_RXDMAE(base) ((SPI_C2_REG(base) & SPI_C2_RXDMAE_MASK) >> SPI_C2_RXDMAE_SHIFT)
#define SPI_BRD_C2_RXDMAE(base) (BME_UBFX8(&SPI_C2_REG(base), SPI_C2_RXDMAE_SHIFT, SPI_C2_RXDMAE_WIDTH))

/*! @brief Set the RXDMAE field to a new value. */
#define SPI_WR_C2_RXDMAE(base, value) (SPI_RMW_C2(base, SPI_C2_RXDMAE_MASK, SPI_C2_RXDMAE(value)))
#define SPI_BWR_C2_RXDMAE(base, value) (BME_BFI8(&SPI_C2_REG(base), ((uint8_t)(value) << SPI_C2_RXDMAE_SHIFT), SPI_C2_RXDMAE_SHIFT, SPI_C2_RXDMAE_WIDTH))
/*@}*/

/*!
 * @name Register SPI_C2, field BIDIROE[3] (RW)
 *
 * When bidirectional mode is enabled because SPI pin control 0 (SPC0) is set to
 * 1, BIDIROE determines whether the SPI data output driver is enabled to the
 * single bidirectional SPI I/O pin. Depending on whether the SPI is configured as
 * a master or a slave, it uses the MOSI (MOMI) or MISO (SISO) pin, respectively,
 * as the single SPI data I/O pin. When SPC0 is 0, BIDIROE has no meaning or
 * effect.
 *
 * Values:
 * - 0 - Output driver disabled so SPI data I/O pin acts as an input
 * - 1 - SPI I/O pin enabled as an output
 */
/*@{*/
/*! @brief Read current value of the SPI_C2_BIDIROE field. */
#define SPI_RD_C2_BIDIROE(base) ((SPI_C2_REG(base) & SPI_C2_BIDIROE_MASK) >> SPI_C2_BIDIROE_SHIFT)
#define SPI_BRD_C2_BIDIROE(base) (BME_UBFX8(&SPI_C2_REG(base), SPI_C2_BIDIROE_SHIFT, SPI_C2_BIDIROE_WIDTH))

/*! @brief Set the BIDIROE field to a new value. */
#define SPI_WR_C2_BIDIROE(base, value) (SPI_RMW_C2(base, SPI_C2_BIDIROE_MASK, SPI_C2_BIDIROE(value)))
#define SPI_BWR_C2_BIDIROE(base, value) (BME_BFI8(&SPI_C2_REG(base), ((uint8_t)(value) << SPI_C2_BIDIROE_SHIFT), SPI_C2_BIDIROE_SHIFT, SPI_C2_BIDIROE_WIDTH))
/*@}*/

/*!
 * @name Register SPI_C2, field MODFEN[4] (RW)
 *
 * When the SPI is configured for slave mode, this bit has no meaning or effect.
 * (The SS pin is the slave select input.) In master mode, this bit determines
 * how the SS pin is used. For details, refer to the description of the SSOE bit
 * in the C1 register.
 *
 * Values:
 * - 0 - Mode fault function disabled, master SS pin reverts to general-purpose
 *     I/O not controlled by SPI
 * - 1 - Mode fault function enabled, master SS pin acts as the mode fault input
 *     or the slave select output
 */
/*@{*/
/*! @brief Read current value of the SPI_C2_MODFEN field. */
#define SPI_RD_C2_MODFEN(base) ((SPI_C2_REG(base) & SPI_C2_MODFEN_MASK) >> SPI_C2_MODFEN_SHIFT)
#define SPI_BRD_C2_MODFEN(base) (BME_UBFX8(&SPI_C2_REG(base), SPI_C2_MODFEN_SHIFT, SPI_C2_MODFEN_WIDTH))

/*! @brief Set the MODFEN field to a new value. */
#define SPI_WR_C2_MODFEN(base, value) (SPI_RMW_C2(base, SPI_C2_MODFEN_MASK, SPI_C2_MODFEN(value)))
#define SPI_BWR_C2_MODFEN(base, value) (BME_BFI8(&SPI_C2_REG(base), ((uint8_t)(value) << SPI_C2_MODFEN_SHIFT), SPI_C2_MODFEN_SHIFT, SPI_C2_MODFEN_WIDTH))
/*@}*/

/*!
 * @name Register SPI_C2, field TXDMAE[5] (RW)
 *
 * This bit enables a transmit DMA request. When this bit is set to 1, a
 * transmit DMA request is asserted when both SPTEF and SPE are set, and the interrupt
 * from SPTEF is disabled.
 *
 * Values:
 * - 0 - DMA request for transmit is disabled and interrupt from SPTEF is allowed
 * - 1 - DMA request for transmit is enabled and interrupt from SPTEF is disabled
 */
/*@{*/
/*! @brief Read current value of the SPI_C2_TXDMAE field. */
#define SPI_RD_C2_TXDMAE(base) ((SPI_C2_REG(base) & SPI_C2_TXDMAE_MASK) >> SPI_C2_TXDMAE_SHIFT)
#define SPI_BRD_C2_TXDMAE(base) (BME_UBFX8(&SPI_C2_REG(base), SPI_C2_TXDMAE_SHIFT, SPI_C2_TXDMAE_WIDTH))

/*! @brief Set the TXDMAE field to a new value. */
#define SPI_WR_C2_TXDMAE(base, value) (SPI_RMW_C2(base, SPI_C2_TXDMAE_MASK, SPI_C2_TXDMAE(value)))
#define SPI_BWR_C2_TXDMAE(base, value) (BME_BFI8(&SPI_C2_REG(base), ((uint8_t)(value) << SPI_C2_TXDMAE_SHIFT), SPI_C2_TXDMAE_SHIFT, SPI_C2_TXDMAE_WIDTH))
/*@}*/

/*!
 * @name Register SPI_C2, field SPIMODE[6] (RW)
 *
 * This bit allows the user to select either an 8-bit or 16-bit SPI data
 * transmission length. In master mode, a change of this bit aborts a transmission in
 * progress, forces the SPI system into an idle state, and resets all status bits
 * in the S register. Refer to the description of "Data Transmission Length" for
 * details.
 *
 * Values:
 * - 0 - 8-bit SPI shift register, match register, and buffers
 * - 1 - 16-bit SPI shift register, match register, and buffers
 */
/*@{*/
/*! @brief Read current value of the SPI_C2_SPIMODE field. */
#define SPI_RD_C2_SPIMODE(base) ((SPI_C2_REG(base) & SPI_C2_SPIMODE_MASK) >> SPI_C2_SPIMODE_SHIFT)
#define SPI_BRD_C2_SPIMODE(base) (BME_UBFX8(&SPI_C2_REG(base), SPI_C2_SPIMODE_SHIFT, SPI_C2_SPIMODE_WIDTH))

/*! @brief Set the SPIMODE field to a new value. */
#define SPI_WR_C2_SPIMODE(base, value) (SPI_RMW_C2(base, SPI_C2_SPIMODE_MASK, SPI_C2_SPIMODE(value)))
#define SPI_BWR_C2_SPIMODE(base, value) (BME_BFI8(&SPI_C2_REG(base), ((uint8_t)(value) << SPI_C2_SPIMODE_SHIFT), SPI_C2_SPIMODE_SHIFT, SPI_C2_SPIMODE_WIDTH))
/*@}*/

/*!
 * @name Register SPI_C2, field SPMIE[7] (RW)
 *
 * This is the interrupt enable bit for the SPI receive data buffer hardware
 * match (SPMF) function.
 *
 * Values:
 * - 0 - Interrupts from SPMF inhibited (use polling)
 * - 1 - When SPMF is 1, requests a hardware interrupt
 */
/*@{*/
/*! @brief Read current value of the SPI_C2_SPMIE field. */
#define SPI_RD_C2_SPMIE(base) ((SPI_C2_REG(base) & SPI_C2_SPMIE_MASK) >> SPI_C2_SPMIE_SHIFT)
#define SPI_BRD_C2_SPMIE(base) (BME_UBFX8(&SPI_C2_REG(base), SPI_C2_SPMIE_SHIFT, SPI_C2_SPMIE_WIDTH))

/*! @brief Set the SPMIE field to a new value. */
#define SPI_WR_C2_SPMIE(base, value) (SPI_RMW_C2(base, SPI_C2_SPMIE_MASK, SPI_C2_SPMIE(value)))
#define SPI_BWR_C2_SPMIE(base, value) (BME_BFI8(&SPI_C2_REG(base), ((uint8_t)(value) << SPI_C2_SPMIE_SHIFT), SPI_C2_SPMIE_SHIFT, SPI_C2_SPMIE_WIDTH))
/*@}*/

/*******************************************************************************
 * SPI_C1 - SPI Control Register 1
 ******************************************************************************/

/*!
 * @brief SPI_C1 - SPI Control Register 1 (RW)
 *
 * Reset value: 0x04U
 *
 * This read/write register includes the SPI enable control, interrupt enables,
 * and configuration options.
 */
/*!
 * @name Constants and macros for entire SPI_C1 register
 */
/*@{*/
#define SPI_RD_C1(base)          (SPI_C1_REG(base))
#define SPI_WR_C1(base, value)   (SPI_C1_REG(base) = (value))
#define SPI_RMW_C1(base, mask, value) (SPI_WR_C1(base, (SPI_RD_C1(base) & ~(mask)) | (value)))
#define SPI_SET_C1(base, value)  (BME_OR8(&SPI_C1_REG(base), (uint8_t)(value)))
#define SPI_CLR_C1(base, value)  (BME_AND8(&SPI_C1_REG(base), (uint8_t)(~(value))))
#define SPI_TOG_C1(base, value)  (BME_XOR8(&SPI_C1_REG(base), (uint8_t)(value)))
/*@}*/

/*
 * Constants & macros for individual SPI_C1 bitfields
 */

/*!
 * @name Register SPI_C1, field LSBFE[0] (RW)
 *
 * This bit does not affect the position of the MSB and LSB in the data
 * register. Reads and writes of the data register always have the MSB in bit 7 (or bit
 * 15 in 16-bit mode).
 *
 * Values:
 * - 0 - SPI serial data transfers start with the most significant bit.
 * - 1 - SPI serial data transfers start with the least significant bit.
 */
/*@{*/
/*! @brief Read current value of the SPI_C1_LSBFE field. */
#define SPI_RD_C1_LSBFE(base) ((SPI_C1_REG(base) & SPI_C1_LSBFE_MASK) >> SPI_C1_LSBFE_SHIFT)
#define SPI_BRD_C1_LSBFE(base) (BME_UBFX8(&SPI_C1_REG(base), SPI_C1_LSBFE_SHIFT, SPI_C1_LSBFE_WIDTH))

/*! @brief Set the LSBFE field to a new value. */
#define SPI_WR_C1_LSBFE(base, value) (SPI_RMW_C1(base, SPI_C1_LSBFE_MASK, SPI_C1_LSBFE(value)))
#define SPI_BWR_C1_LSBFE(base, value) (BME_BFI8(&SPI_C1_REG(base), ((uint8_t)(value) << SPI_C1_LSBFE_SHIFT), SPI_C1_LSBFE_SHIFT, SPI_C1_LSBFE_WIDTH))
/*@}*/

/*!
 * @name Register SPI_C1, field SSOE[1] (RW)
 *
 * This bit is used in combination with the Mode Fault Enable (MODFEN) field in
 * the C2 register and the Master/Slave (MSTR) control bit to determine the
 * function of the SS pin.
 *
 * Values:
 * - 0 - When C2[MODFEN] is 0: In master mode, SS pin function is
 *     general-purpose I/O (not SPI). In slave mode, SS pin function is slave select input.
 *     When C2[MODFEN] is 1: In master mode, SS pin function is SS input for mode
 *     fault. In slave mode, SS pin function is slave select input.
 * - 1 - When C2[MODFEN] is 0: In master mode, SS pin function is
 *     general-purpose I/O (not SPI). In slave mode, SS pin function is slave select input.
 *     When C2[MODFEN] is 1: In master mode, SS pin function is automatic SS output.
 *     In slave mode: SS pin function is slave select input.
 */
/*@{*/
/*! @brief Read current value of the SPI_C1_SSOE field. */
#define SPI_RD_C1_SSOE(base) ((SPI_C1_REG(base) & SPI_C1_SSOE_MASK) >> SPI_C1_SSOE_SHIFT)
#define SPI_BRD_C1_SSOE(base) (BME_UBFX8(&SPI_C1_REG(base), SPI_C1_SSOE_SHIFT, SPI_C1_SSOE_WIDTH))

/*! @brief Set the SSOE field to a new value. */
#define SPI_WR_C1_SSOE(base, value) (SPI_RMW_C1(base, SPI_C1_SSOE_MASK, SPI_C1_SSOE(value)))
#define SPI_BWR_C1_SSOE(base, value) (BME_BFI8(&SPI_C1_REG(base), ((uint8_t)(value) << SPI_C1_SSOE_SHIFT), SPI_C1_SSOE_SHIFT, SPI_C1_SSOE_WIDTH))
/*@}*/

/*!
 * @name Register SPI_C1, field CPHA[2] (RW)
 *
 * Selects one of two clock formats for different kinds of synchronous serial
 * peripheral devices. Refer to the description of "SPI Clock Formats" for details.
 *
 * Values:
 * - 0 - First edge on SPSCK occurs at the middle of the first cycle of a data
 *     transfer.
 * - 1 - First edge on SPSCK occurs at the start of the first cycle of a data
 *     transfer.
 */
/*@{*/
/*! @brief Read current value of the SPI_C1_CPHA field. */
#define SPI_RD_C1_CPHA(base) ((SPI_C1_REG(base) & SPI_C1_CPHA_MASK) >> SPI_C1_CPHA_SHIFT)
#define SPI_BRD_C1_CPHA(base) (BME_UBFX8(&SPI_C1_REG(base), SPI_C1_CPHA_SHIFT, SPI_C1_CPHA_WIDTH))

/*! @brief Set the CPHA field to a new value. */
#define SPI_WR_C1_CPHA(base, value) (SPI_RMW_C1(base, SPI_C1_CPHA_MASK, SPI_C1_CPHA(value)))
#define SPI_BWR_C1_CPHA(base, value) (BME_BFI8(&SPI_C1_REG(base), ((uint8_t)(value) << SPI_C1_CPHA_SHIFT), SPI_C1_CPHA_SHIFT, SPI_C1_CPHA_WIDTH))
/*@}*/

/*!
 * @name Register SPI_C1, field CPOL[3] (RW)
 *
 * Selects an inverted or non-inverted SPI clock. To transmit data between SPI
 * modules, the SPI modules must have identical CPOL values. This bit effectively
 * places an inverter in series with the clock signal either from a master SPI
 * device or to a slave SPI device. Refer to the description of "SPI Clock Formats"
 * for details.
 *
 * Values:
 * - 0 - Active-high SPI clock (idles low)
 * - 1 - Active-low SPI clock (idles high)
 */
/*@{*/
/*! @brief Read current value of the SPI_C1_CPOL field. */
#define SPI_RD_C1_CPOL(base) ((SPI_C1_REG(base) & SPI_C1_CPOL_MASK) >> SPI_C1_CPOL_SHIFT)
#define SPI_BRD_C1_CPOL(base) (BME_UBFX8(&SPI_C1_REG(base), SPI_C1_CPOL_SHIFT, SPI_C1_CPOL_WIDTH))

/*! @brief Set the CPOL field to a new value. */
#define SPI_WR_C1_CPOL(base, value) (SPI_RMW_C1(base, SPI_C1_CPOL_MASK, SPI_C1_CPOL(value)))
#define SPI_BWR_C1_CPOL(base, value) (BME_BFI8(&SPI_C1_REG(base), ((uint8_t)(value) << SPI_C1_CPOL_SHIFT), SPI_C1_CPOL_SHIFT, SPI_C1_CPOL_WIDTH))
/*@}*/

/*!
 * @name Register SPI_C1, field MSTR[4] (RW)
 *
 * Selects master or slave mode operation.
 *
 * Values:
 * - 0 - SPI module configured as a slave SPI device
 * - 1 - SPI module configured as a master SPI device
 */
/*@{*/
/*! @brief Read current value of the SPI_C1_MSTR field. */
#define SPI_RD_C1_MSTR(base) ((SPI_C1_REG(base) & SPI_C1_MSTR_MASK) >> SPI_C1_MSTR_SHIFT)
#define SPI_BRD_C1_MSTR(base) (BME_UBFX8(&SPI_C1_REG(base), SPI_C1_MSTR_SHIFT, SPI_C1_MSTR_WIDTH))

/*! @brief Set the MSTR field to a new value. */
#define SPI_WR_C1_MSTR(base, value) (SPI_RMW_C1(base, SPI_C1_MSTR_MASK, SPI_C1_MSTR(value)))
#define SPI_BWR_C1_MSTR(base, value) (BME_BFI8(&SPI_C1_REG(base), ((uint8_t)(value) << SPI_C1_MSTR_SHIFT), SPI_C1_MSTR_SHIFT, SPI_C1_MSTR_WIDTH))
/*@}*/

/*!
 * @name Register SPI_C1, field SPTIE[5] (RW)
 *
 * When the FIFO is not supported or not enabled (FIFOMODE is not present or is
 * 0): This is the interrupt enable bit for SPI transmit buffer empty (SPTEF). An
 * interrupt occurs when the SPI transmit buffer is empty (SPTEF is set). When
 * the FIFO is supported and enabled (FIFOMODE is 1): This is the interrupt enable
 * bit for SPI transmit FIFO empty (SPTEF). An interrupt occurs when the SPI
 * transmit FIFO is empty (SPTEF is set).
 *
 * Values:
 * - 0 - Interrupts from SPTEF inhibited (use polling)
 * - 1 - When SPTEF is 1, hardware interrupt requested
 */
/*@{*/
/*! @brief Read current value of the SPI_C1_SPTIE field. */
#define SPI_RD_C1_SPTIE(base) ((SPI_C1_REG(base) & SPI_C1_SPTIE_MASK) >> SPI_C1_SPTIE_SHIFT)
#define SPI_BRD_C1_SPTIE(base) (BME_UBFX8(&SPI_C1_REG(base), SPI_C1_SPTIE_SHIFT, SPI_C1_SPTIE_WIDTH))

/*! @brief Set the SPTIE field to a new value. */
#define SPI_WR_C1_SPTIE(base, value) (SPI_RMW_C1(base, SPI_C1_SPTIE_MASK, SPI_C1_SPTIE(value)))
#define SPI_BWR_C1_SPTIE(base, value) (BME_BFI8(&SPI_C1_REG(base), ((uint8_t)(value) << SPI_C1_SPTIE_SHIFT), SPI_C1_SPTIE_SHIFT, SPI_C1_SPTIE_WIDTH))
/*@}*/

/*!
 * @name Register SPI_C1, field SPE[6] (RW)
 *
 * Enables the SPI system and dedicates the SPI port pins to SPI system
 * functions. If SPE is cleared, the SPI is disabled and forced into an idle state, and
 * all status bits in the S register are reset.
 *
 * Values:
 * - 0 - SPI system inactive
 * - 1 - SPI system enabled
 */
/*@{*/
/*! @brief Read current value of the SPI_C1_SPE field. */
#define SPI_RD_C1_SPE(base)  ((SPI_C1_REG(base) & SPI_C1_SPE_MASK) >> SPI_C1_SPE_SHIFT)
#define SPI_BRD_C1_SPE(base) (BME_UBFX8(&SPI_C1_REG(base), SPI_C1_SPE_SHIFT, SPI_C1_SPE_WIDTH))

/*! @brief Set the SPE field to a new value. */
#define SPI_WR_C1_SPE(base, value) (SPI_RMW_C1(base, SPI_C1_SPE_MASK, SPI_C1_SPE(value)))
#define SPI_BWR_C1_SPE(base, value) (BME_BFI8(&SPI_C1_REG(base), ((uint8_t)(value) << SPI_C1_SPE_SHIFT), SPI_C1_SPE_SHIFT, SPI_C1_SPE_WIDTH))
/*@}*/

/*!
 * @name Register SPI_C1, field SPIE[7] (RW)
 *
 * When the FIFO is not supported or not enabled (FIFOMODE is not present or is
 * 0): Enables the interrupt for SPI receive buffer full (SPRF) and mode fault
 * (MODF) events. When the FIFO is supported and enabled (FIFOMODE is 1): This bit
 * enables the SPI to interrupt the CPU when the receive FIFO is full. An
 * interrupt occurs when the SPRF bit is set or the MODF bit is set.
 *
 * Values:
 * - 0 - Interrupts from SPRF and MODF are inhibited-use polling (when FIFOMODE
 *     is not present or is 0) or Read FIFO Full Interrupts are disabled (when
 *     FIFOMODE is 1)
 * - 1 - Request a hardware interrupt when SPRF or MODF is 1 (when FIFOMODE is
 *     not present or is 0) or Read FIFO Full Interrupts are enabled (when
 *     FIFOMODE is 1)
 */
/*@{*/
/*! @brief Read current value of the SPI_C1_SPIE field. */
#define SPI_RD_C1_SPIE(base) ((SPI_C1_REG(base) & SPI_C1_SPIE_MASK) >> SPI_C1_SPIE_SHIFT)
#define SPI_BRD_C1_SPIE(base) (BME_UBFX8(&SPI_C1_REG(base), SPI_C1_SPIE_SHIFT, SPI_C1_SPIE_WIDTH))

/*! @brief Set the SPIE field to a new value. */
#define SPI_WR_C1_SPIE(base, value) (SPI_RMW_C1(base, SPI_C1_SPIE_MASK, SPI_C1_SPIE(value)))
#define SPI_BWR_C1_SPIE(base, value) (BME_BFI8(&SPI_C1_REG(base), ((uint8_t)(value) << SPI_C1_SPIE_SHIFT), SPI_C1_SPIE_SHIFT, SPI_C1_SPIE_WIDTH))
/*@}*/

/*******************************************************************************
 * SPI_ML - SPI Match Register low
 ******************************************************************************/

/*!
 * @brief SPI_ML - SPI Match Register low (RW)
 *
 * Reset value: 0x00U
 *
 * This register, together with the MH register, contains the hardware compare
 * value. When the value received in the SPI receive data buffer equals this
 * hardware compare value, the SPI Match Flag in the S register (S[SPMF]) sets. In
 * 8-bit mode, only the ML register is available. Reads of the MH register return
 * all zeros. Writes to the MH register are ignored. In 16-bit mode, reading either
 * byte (the MH or ML register) latches the contents of both bytes into a buffer
 * where they remain latched until the other byte is read. Writing to either
 * byte (the MH or ML register) latches the value into a buffer. When both bytes
 * have been written, they are transferred as a coherent value into the SPI match
 * registers.
 */
/*!
 * @name Constants and macros for entire SPI_ML register
 */
/*@{*/
#define SPI_RD_ML(base)          (SPI_ML_REG(base))
#define SPI_WR_ML(base, value)   (SPI_ML_REG(base) = (value))
#define SPI_RMW_ML(base, mask, value) (SPI_WR_ML(base, (SPI_RD_ML(base) & ~(mask)) | (value)))
#define SPI_SET_ML(base, value)  (BME_OR8(&SPI_ML_REG(base), (uint8_t)(value)))
#define SPI_CLR_ML(base, value)  (BME_AND8(&SPI_ML_REG(base), (uint8_t)(~(value))))
#define SPI_TOG_ML(base, value)  (BME_XOR8(&SPI_ML_REG(base), (uint8_t)(value)))
/*@}*/

/*******************************************************************************
 * SPI_MH - SPI match register high
 ******************************************************************************/

/*!
 * @brief SPI_MH - SPI match register high (RW)
 *
 * Reset value: 0x00U
 *
 * Refer to the description of the ML register.
 */
/*!
 * @name Constants and macros for entire SPI_MH register
 */
/*@{*/
#define SPI_RD_MH(base)          (SPI_MH_REG(base))
#define SPI_WR_MH(base, value)   (SPI_MH_REG(base) = (value))
#define SPI_RMW_MH(base, mask, value) (SPI_WR_MH(base, (SPI_RD_MH(base) & ~(mask)) | (value)))
#define SPI_SET_MH(base, value)  (BME_OR8(&SPI_MH_REG(base), (uint8_t)(value)))
#define SPI_CLR_MH(base, value)  (BME_AND8(&SPI_MH_REG(base), (uint8_t)(~(value))))
#define SPI_TOG_MH(base, value)  (BME_XOR8(&SPI_MH_REG(base), (uint8_t)(value)))
/*@}*/

/*******************************************************************************
 * SPI_DL - SPI Data Register low
 ******************************************************************************/

/*!
 * @brief SPI_DL - SPI Data Register low (RW)
 *
 * Reset value: 0x00U
 *
 * This register, together with the DH register, is both the input and output
 * register for SPI data. A write to the registers writes to the transmit data
 * buffer, allowing data to be queued and transmitted. When the SPI is configured as
 * a master, data queued in the transmit data buffer is transmitted immediately
 * after the previous transmission has completed. The SPTEF bit in the S register
 * indicates when the transmit data buffer is ready to accept new data. When the
 * transmit DMA request is disabled (TXDMAE is 0): The S register must be read
 * when S[SPTEF] is set before writing to the SPI data registers; otherwise, the
 * write is ignored. When the transmit DMA request is enabled (TXDMAE is 1) when
 * S[SPTEF] is set, the SPI data registers can be written automatically by DMA
 * without reading the S register first. Data may be read from the SPI data registers
 * any time after S[SPRF] is set and before another transfer is finished.
 * Failure to read the data out of the receive data buffer before a new transfer ends
 * causes a receive overrun condition, and the data from the new transfer is lost.
 * The new data is lost because the receive buffer still held the previous
 * character and was not ready to accept the new data. There is no indication for a
 * receive overrun condition, so the application system designer must ensure that
 * previous data has been read from the receive buffer before a new transfer is
 * initiated. In 8-bit mode, only the DL register is available. Reads of the DH
 * register return all zeros. Writes to the DH register are ignored. In 16-bit mode,
 * reading either byte (the DH or DL register) latches the contents of both
 * bytes into a buffer where they remain latched until the other byte is read.
 * Writing to either byte (the DH or DL register) latches the value into a buffer. When
 * both bytes have been written, they are transferred as a coherent 16-bit value
 * into the transmit data buffer.
 */
/*!
 * @name Constants and macros for entire SPI_DL register
 */
/*@{*/
#define SPI_RD_DL(base)          (SPI_DL_REG(base))
#define SPI_WR_DL(base, value)   (SPI_DL_REG(base) = (value))
#define SPI_RMW_DL(base, mask, value) (SPI_WR_DL(base, (SPI_RD_DL(base) & ~(mask)) | (value)))
#define SPI_SET_DL(base, value)  (BME_OR8(&SPI_DL_REG(base), (uint8_t)(value)))
#define SPI_CLR_DL(base, value)  (BME_AND8(&SPI_DL_REG(base), (uint8_t)(~(value))))
#define SPI_TOG_DL(base, value)  (BME_XOR8(&SPI_DL_REG(base), (uint8_t)(value)))
/*@}*/

/*******************************************************************************
 * SPI_DH - SPI data register high
 ******************************************************************************/

/*!
 * @brief SPI_DH - SPI data register high (RW)
 *
 * Reset value: 0x00U
 *
 * Refer to the description of the DL register.
 */
/*!
 * @name Constants and macros for entire SPI_DH register
 */
/*@{*/
#define SPI_RD_DH(base)          (SPI_DH_REG(base))
#define SPI_WR_DH(base, value)   (SPI_DH_REG(base) = (value))
#define SPI_RMW_DH(base, mask, value) (SPI_WR_DH(base, (SPI_RD_DH(base) & ~(mask)) | (value)))
#define SPI_SET_DH(base, value)  (BME_OR8(&SPI_DH_REG(base), (uint8_t)(value)))
#define SPI_CLR_DH(base, value)  (BME_AND8(&SPI_DH_REG(base), (uint8_t)(~(value))))
#define SPI_TOG_DH(base, value)  (BME_XOR8(&SPI_DH_REG(base), (uint8_t)(value)))
/*@}*/

/*******************************************************************************
 * SPI_CI - SPI clear interrupt register
 ******************************************************************************/

/*!
 * @brief SPI_CI - SPI clear interrupt register (RW)
 *
 * Reset value: 0x00U
 *
 * This register applies only for an instance of the SPI module that supports
 * the FIFO feature. The register has four bits dedicated to clearing the
 * interrupts. Writing 1 to these bits clears the corresponding interrupts if the INTCLR
 * bit in the C3 register is 1. Reading these bits always returns 0. This register
 * also has two read-only bits to indicate the transmit FIFO and receive FIFO
 * overrun conditions. When the receive FIFO is full and data is received, RXFOF is
 * set. Similarily, when the transmit FIFO is full and a write to the data
 * register occurs, TXFOF is set. These flags are cleared when the CI register is read
 * while the flags are set. The register has two more read-only bits to indicate
 * the error flags. These flags are set when, due to some spurious reason,
 * entries in the FIFO total more than 64 bits of data. At this point, all the flags
 * in the status register are reset, and entries in the FIFO are flushed with the
 * corresponding error flags set. These flags are cleared when the CI register is
 * read while the flags are set.
 */
/*!
 * @name Constants and macros for entire SPI_CI register
 */
/*@{*/
#define SPI_RD_CI(base)          (SPI_CI_REG(base))
#define SPI_WR_CI(base, value)   (SPI_CI_REG(base) = (value))
#define SPI_RMW_CI(base, mask, value) (SPI_WR_CI(base, (SPI_RD_CI(base) & ~(mask)) | (value)))
#define SPI_SET_CI(base, value)  (BME_OR8(&SPI_CI_REG(base), (uint8_t)(value)))
#define SPI_CLR_CI(base, value)  (BME_AND8(&SPI_CI_REG(base), (uint8_t)(~(value))))
#define SPI_TOG_CI(base, value)  (BME_XOR8(&SPI_CI_REG(base), (uint8_t)(value)))
/*@}*/

/*
 * Constants & macros for individual SPI_CI bitfields
 */

/*!
 * @name Register SPI_CI, field SPRFCI[0] (WORZ)
 *
 * Writing 1 to this bit clears the SPRF interrupt provided that C3[3] is set.
 */
/*@{*/
/*! @brief Set the SPRFCI field to a new value. */
#define SPI_WR_CI_SPRFCI(base, value) (SPI_RMW_CI(base, SPI_CI_SPRFCI_MASK, SPI_CI_SPRFCI(value)))
#define SPI_BWR_CI_SPRFCI(base, value) (BME_BFI8(&SPI_CI_REG(base), ((uint8_t)(value) << SPI_CI_SPRFCI_SHIFT), SPI_CI_SPRFCI_SHIFT, SPI_CI_SPRFCI_WIDTH))
/*@}*/

/*!
 * @name Register SPI_CI, field SPTEFCI[1] (WORZ)
 *
 * Writing 1 to this bit clears the SPTEF interrupt provided that C3[3] is set.
 */
/*@{*/
/*! @brief Set the SPTEFCI field to a new value. */
#define SPI_WR_CI_SPTEFCI(base, value) (SPI_RMW_CI(base, SPI_CI_SPTEFCI_MASK, SPI_CI_SPTEFCI(value)))
#define SPI_BWR_CI_SPTEFCI(base, value) (BME_BFI8(&SPI_CI_REG(base), ((uint8_t)(value) << SPI_CI_SPTEFCI_SHIFT), SPI_CI_SPTEFCI_SHIFT, SPI_CI_SPTEFCI_WIDTH))
/*@}*/

/*!
 * @name Register SPI_CI, field RNFULLFCI[2] (WORZ)
 *
 * Writing 1 to this bit clears the RNFULLF interrupt provided that C3[3] is set.
 */
/*@{*/
/*! @brief Set the RNFULLFCI field to a new value. */
#define SPI_WR_CI_RNFULLFCI(base, value) (SPI_RMW_CI(base, SPI_CI_RNFULLFCI_MASK, SPI_CI_RNFULLFCI(value)))
#define SPI_BWR_CI_RNFULLFCI(base, value) (BME_BFI8(&SPI_CI_REG(base), ((uint8_t)(value) << SPI_CI_RNFULLFCI_SHIFT), SPI_CI_RNFULLFCI_SHIFT, SPI_CI_RNFULLFCI_WIDTH))
/*@}*/

/*!
 * @name Register SPI_CI, field TNEAREFCI[3] (WORZ)
 *
 * Writing 1 to this bit clears the TNEAREF interrupt provided that C3[3] is set.
 */
/*@{*/
/*! @brief Set the TNEAREFCI field to a new value. */
#define SPI_WR_CI_TNEAREFCI(base, value) (SPI_RMW_CI(base, SPI_CI_TNEAREFCI_MASK, SPI_CI_TNEAREFCI(value)))
#define SPI_BWR_CI_TNEAREFCI(base, value) (BME_BFI8(&SPI_CI_REG(base), ((uint8_t)(value) << SPI_CI_TNEAREFCI_SHIFT), SPI_CI_TNEAREFCI_SHIFT, SPI_CI_TNEAREFCI_WIDTH))
/*@}*/

/*!
 * @name Register SPI_CI, field RXFOF[4] (RO)
 *
 * This flag indicates that a receive FIFO overflow condition has occurred.
 *
 * Values:
 * - 0 - Receive FIFO overflow condition has not occurred
 * - 1 - Receive FIFO overflow condition occurred
 */
/*@{*/
/*! @brief Read current value of the SPI_CI_RXFOF field. */
#define SPI_RD_CI_RXFOF(base) ((SPI_CI_REG(base) & SPI_CI_RXFOF_MASK) >> SPI_CI_RXFOF_SHIFT)
#define SPI_BRD_CI_RXFOF(base) (BME_UBFX8(&SPI_CI_REG(base), SPI_CI_RXFOF_SHIFT, SPI_CI_RXFOF_WIDTH))
/*@}*/

/*!
 * @name Register SPI_CI, field TXFOF[5] (RO)
 *
 * This flag indicates that a transmit FIFO overflow condition has occurred.
 *
 * Values:
 * - 0 - Transmit FIFO overflow condition has not occurred
 * - 1 - Transmit FIFO overflow condition occurred
 */
/*@{*/
/*! @brief Read current value of the SPI_CI_TXFOF field. */
#define SPI_RD_CI_TXFOF(base) ((SPI_CI_REG(base) & SPI_CI_TXFOF_MASK) >> SPI_CI_TXFOF_SHIFT)
#define SPI_BRD_CI_TXFOF(base) (BME_UBFX8(&SPI_CI_REG(base), SPI_CI_TXFOF_SHIFT, SPI_CI_TXFOF_WIDTH))
/*@}*/

/*!
 * @name Register SPI_CI, field RXFERR[6] (RO)
 *
 * This flag indicates that a receive FIFO error occurred because entries in the
 * FIFO total more than 64 bits of data.
 *
 * Values:
 * - 0 - No receive FIFO error occurred
 * - 1 - A receive FIFO error occurred
 */
/*@{*/
/*! @brief Read current value of the SPI_CI_RXFERR field. */
#define SPI_RD_CI_RXFERR(base) ((SPI_CI_REG(base) & SPI_CI_RXFERR_MASK) >> SPI_CI_RXFERR_SHIFT)
#define SPI_BRD_CI_RXFERR(base) (BME_UBFX8(&SPI_CI_REG(base), SPI_CI_RXFERR_SHIFT, SPI_CI_RXFERR_WIDTH))
/*@}*/

/*!
 * @name Register SPI_CI, field TXFERR[7] (RO)
 *
 * This flag indicates that a transmit FIFO error occurred because entries in
 * the FIFO total more than 64 bits of data.
 *
 * Values:
 * - 0 - No transmit FIFO error occurred
 * - 1 - A transmit FIFO error occurred
 */
/*@{*/
/*! @brief Read current value of the SPI_CI_TXFERR field. */
#define SPI_RD_CI_TXFERR(base) ((SPI_CI_REG(base) & SPI_CI_TXFERR_MASK) >> SPI_CI_TXFERR_SHIFT)
#define SPI_BRD_CI_TXFERR(base) (BME_UBFX8(&SPI_CI_REG(base), SPI_CI_TXFERR_SHIFT, SPI_CI_TXFERR_WIDTH))
/*@}*/

/*******************************************************************************
 * SPI_C3 - SPI control register 3
 ******************************************************************************/

/*!
 * @brief SPI_C3 - SPI control register 3 (RW)
 *
 * Reset value: 0x00U
 *
 * This register introduces a 64-bit FIFO function on both transmit and receive
 * buffers. It applies only for an instance of the SPI module that supports the
 * FIFO feature. FIFO mode is enabled by setting the FIFOMODE bit to 1. A write to
 * this register occurs only when it sets the FIFOMODE bit to 1. Using this FIFO
 * feature allows the SPI to provide high speed transfers of large amounts of
 * data without consuming large amounts of the CPU bandwidth. Enabling this FIFO
 * function affects the behavior of some of the read/write buffer flags in the S
 * register as follows: When the receive FIFO has data in it, S[RFIFOEF] is 0. As a
 * result: If C2[RXDMAE] is 1, RFIFOEF_b generates a receive DMA request. The
 * DMA request remains active until RFIFOEF is set to 1, indicating the receive
 * buffer is empty. If C2[RXDMAE] is 0 and C1[SPIE] is 1, SPRF interrupts the CPU.
 * When the transmit FIFO is not full, S[TXFULLF] is 0. As a result: If C2[TXDMAE]
 * is 1, TXFULLF_b generates a transmit DMA request. The DMA request remains
 * active until TXFULLF is set to 1, indicating the transmit FIFO is full. If
 * C2[TXDMAE] is 0 and C1[SPTIE] is 1, SPTEF interrupts the CPU. Two interrupt enable
 * bits, TNEARIEN and RNFULLIEN, provide CPU interrupts based on the "watermark"
 * feature of the TNEARF and RNFULLF flags of the S register.
 */
/*!
 * @name Constants and macros for entire SPI_C3 register
 */
/*@{*/
#define SPI_RD_C3(base)          (SPI_C3_REG(base))
#define SPI_WR_C3(base, value)   (SPI_C3_REG(base) = (value))
#define SPI_RMW_C3(base, mask, value) (SPI_WR_C3(base, (SPI_RD_C3(base) & ~(mask)) | (value)))
#define SPI_SET_C3(base, value)  (BME_OR8(&SPI_C3_REG(base), (uint8_t)(value)))
#define SPI_CLR_C3(base, value)  (BME_AND8(&SPI_C3_REG(base), (uint8_t)(~(value))))
#define SPI_TOG_C3(base, value)  (BME_XOR8(&SPI_C3_REG(base), (uint8_t)(value)))
/*@}*/

/*
 * Constants & macros for individual SPI_C3 bitfields
 */

/*!
 * @name Register SPI_C3, field FIFOMODE[0] (RW)
 *
 * This bit enables the SPI to use a 64-bit FIFO (8 bytes or four 16-bit words)
 * for both transmit and receive buffers.
 *
 * Values:
 * - 0 - FIFO mode disabled
 * - 1 - FIFO mode enabled
 */
/*@{*/
/*! @brief Read current value of the SPI_C3_FIFOMODE field. */
#define SPI_RD_C3_FIFOMODE(base) ((SPI_C3_REG(base) & SPI_C3_FIFOMODE_MASK) >> SPI_C3_FIFOMODE_SHIFT)
#define SPI_BRD_C3_FIFOMODE(base) (BME_UBFX8(&SPI_C3_REG(base), SPI_C3_FIFOMODE_SHIFT, SPI_C3_FIFOMODE_WIDTH))

/*! @brief Set the FIFOMODE field to a new value. */
#define SPI_WR_C3_FIFOMODE(base, value) (SPI_RMW_C3(base, SPI_C3_FIFOMODE_MASK, SPI_C3_FIFOMODE(value)))
#define SPI_BWR_C3_FIFOMODE(base, value) (BME_BFI8(&SPI_C3_REG(base), ((uint8_t)(value) << SPI_C3_FIFOMODE_SHIFT), SPI_C3_FIFOMODE_SHIFT, SPI_C3_FIFOMODE_WIDTH))
/*@}*/

/*!
 * @name Register SPI_C3, field RNFULLIEN[1] (RW)
 *
 * Writing 1 to this bit enables the SPI to interrupt the CPU when the RNFULLF
 * flag is set. This bit is ignored and has no function if the FIFOMODE bit is 0.
 *
 * Values:
 * - 0 - No interrupt upon RNFULLF being set
 * - 1 - Enable interrupts upon RNFULLF being set
 */
/*@{*/
/*! @brief Read current value of the SPI_C3_RNFULLIEN field. */
#define SPI_RD_C3_RNFULLIEN(base) ((SPI_C3_REG(base) & SPI_C3_RNFULLIEN_MASK) >> SPI_C3_RNFULLIEN_SHIFT)
#define SPI_BRD_C3_RNFULLIEN(base) (BME_UBFX8(&SPI_C3_REG(base), SPI_C3_RNFULLIEN_SHIFT, SPI_C3_RNFULLIEN_WIDTH))

/*! @brief Set the RNFULLIEN field to a new value. */
#define SPI_WR_C3_RNFULLIEN(base, value) (SPI_RMW_C3(base, SPI_C3_RNFULLIEN_MASK, SPI_C3_RNFULLIEN(value)))
#define SPI_BWR_C3_RNFULLIEN(base, value) (BME_BFI8(&SPI_C3_REG(base), ((uint8_t)(value) << SPI_C3_RNFULLIEN_SHIFT), SPI_C3_RNFULLIEN_SHIFT, SPI_C3_RNFULLIEN_WIDTH))
/*@}*/

/*!
 * @name Register SPI_C3, field TNEARIEN[2] (RW)
 *
 * Writing 1 to this bit enables the SPI to interrupt the CPU when the TNEAREF
 * flag is set. This bit is ignored and has no function if the FIFOMODE bit is 0.
 *
 * Values:
 * - 0 - No interrupt upon TNEAREF being set
 * - 1 - Enable interrupts upon TNEAREF being set
 */
/*@{*/
/*! @brief Read current value of the SPI_C3_TNEARIEN field. */
#define SPI_RD_C3_TNEARIEN(base) ((SPI_C3_REG(base) & SPI_C3_TNEARIEN_MASK) >> SPI_C3_TNEARIEN_SHIFT)
#define SPI_BRD_C3_TNEARIEN(base) (BME_UBFX8(&SPI_C3_REG(base), SPI_C3_TNEARIEN_SHIFT, SPI_C3_TNEARIEN_WIDTH))

/*! @brief Set the TNEARIEN field to a new value. */
#define SPI_WR_C3_TNEARIEN(base, value) (SPI_RMW_C3(base, SPI_C3_TNEARIEN_MASK, SPI_C3_TNEARIEN(value)))
#define SPI_BWR_C3_TNEARIEN(base, value) (BME_BFI8(&SPI_C3_REG(base), ((uint8_t)(value) << SPI_C3_TNEARIEN_SHIFT), SPI_C3_TNEARIEN_SHIFT, SPI_C3_TNEARIEN_WIDTH))
/*@}*/

/*!
 * @name Register SPI_C3, field INTCLR[3] (RW)
 *
 * This bit selects the mechanism by which the SPRF, SPTEF, TNEAREF, and RNFULLF
 * interrupts are cleared.
 *
 * Values:
 * - 0 - These interrupts are cleared when the corresponding flags are cleared
 *     depending on the state of the FIFOs
 * - 1 - These interrupts are cleared by writing the corresponding bits in the
 *     CI register
 */
/*@{*/
/*! @brief Read current value of the SPI_C3_INTCLR field. */
#define SPI_RD_C3_INTCLR(base) ((SPI_C3_REG(base) & SPI_C3_INTCLR_MASK) >> SPI_C3_INTCLR_SHIFT)
#define SPI_BRD_C3_INTCLR(base) (BME_UBFX8(&SPI_C3_REG(base), SPI_C3_INTCLR_SHIFT, SPI_C3_INTCLR_WIDTH))

/*! @brief Set the INTCLR field to a new value. */
#define SPI_WR_C3_INTCLR(base, value) (SPI_RMW_C3(base, SPI_C3_INTCLR_MASK, SPI_C3_INTCLR(value)))
#define SPI_BWR_C3_INTCLR(base, value) (BME_BFI8(&SPI_C3_REG(base), ((uint8_t)(value) << SPI_C3_INTCLR_SHIFT), SPI_C3_INTCLR_SHIFT, SPI_C3_INTCLR_WIDTH))
/*@}*/

/*!
 * @name Register SPI_C3, field RNFULLF_MARK[4] (RW)
 *
 * This bit selects the mark after which the RNFULLF flag is asserted.
 *
 * Values:
 * - 0 - RNFULLF is set when the receive FIFO has 48 bits or more
 * - 1 - RNFULLF is set when the receive FIFO has 32 bits or more
 */
/*@{*/
/*! @brief Read current value of the SPI_C3_RNFULLF_MARK field. */
#define SPI_RD_C3_RNFULLF_MARK(base) ((SPI_C3_REG(base) & SPI_C3_RNFULLF_MARK_MASK) >> SPI_C3_RNFULLF_MARK_SHIFT)
#define SPI_BRD_C3_RNFULLF_MARK(base) (BME_UBFX8(&SPI_C3_REG(base), SPI_C3_RNFULLF_MARK_SHIFT, SPI_C3_RNFULLF_MARK_WIDTH))

/*! @brief Set the RNFULLF_MARK field to a new value. */
#define SPI_WR_C3_RNFULLF_MARK(base, value) (SPI_RMW_C3(base, SPI_C3_RNFULLF_MARK_MASK, SPI_C3_RNFULLF_MARK(value)))
#define SPI_BWR_C3_RNFULLF_MARK(base, value) (BME_BFI8(&SPI_C3_REG(base), ((uint8_t)(value) << SPI_C3_RNFULLF_MARK_SHIFT), SPI_C3_RNFULLF_MARK_SHIFT, SPI_C3_RNFULLF_MARK_WIDTH))
/*@}*/

/*!
 * @name Register SPI_C3, field TNEAREF_MARK[5] (RW)
 *
 * This bit selects the mark after which the TNEAREF flag is asserted.
 *
 * Values:
 * - 0 - TNEAREF is set when the transmit FIFO has 16 bits or less
 * - 1 - TNEAREF is set when the transmit FIFO has 32 bits or less
 */
/*@{*/
/*! @brief Read current value of the SPI_C3_TNEAREF_MARK field. */
#define SPI_RD_C3_TNEAREF_MARK(base) ((SPI_C3_REG(base) & SPI_C3_TNEAREF_MARK_MASK) >> SPI_C3_TNEAREF_MARK_SHIFT)
#define SPI_BRD_C3_TNEAREF_MARK(base) (BME_UBFX8(&SPI_C3_REG(base), SPI_C3_TNEAREF_MARK_SHIFT, SPI_C3_TNEAREF_MARK_WIDTH))

/*! @brief Set the TNEAREF_MARK field to a new value. */
#define SPI_WR_C3_TNEAREF_MARK(base, value) (SPI_RMW_C3(base, SPI_C3_TNEAREF_MARK_MASK, SPI_C3_TNEAREF_MARK(value)))
#define SPI_BWR_C3_TNEAREF_MARK(base, value) (BME_BFI8(&SPI_C3_REG(base), ((uint8_t)(value) << SPI_C3_TNEAREF_MARK_SHIFT), SPI_C3_TNEAREF_MARK_SHIFT, SPI_C3_TNEAREF_MARK_WIDTH))
/*@}*/

/*
 * MKL27Z644 TPM
 *
 * Timer/PWM Module
 *
 * Registers defined in this header file:
 * - TPM_SC - Status and Control
 * - TPM_CNT - Counter
 * - TPM_MOD - Modulo
 * - TPM_CnSC - Channel (n) Status and Control
 * - TPM_CnV - Channel (n) Value
 * - TPM_STATUS - Capture and Compare Status
 * - TPM_POL - Channel Polarity
 * - TPM_CONF - Configuration
 */

#define TPM_INSTANCE_COUNT (3U) /*!< Number of instances of the TPM module. */
#define TPM0_IDX (0U) /*!< Instance number for TPM0. */
#define TPM1_IDX (1U) /*!< Instance number for TPM1. */
#define TPM2_IDX (2U) /*!< Instance number for TPM2. */

/*******************************************************************************
 * TPM_SC - Status and Control
 ******************************************************************************/

/*!
 * @brief TPM_SC - Status and Control (RW)
 *
 * Reset value: 0x00000000U
 *
 * SC contains the overflow status flag and control bits used to configure the
 * interrupt enable, module configuration and prescaler factor. These controls
 * relate to all channels within this module.
 */
/*!
 * @name Constants and macros for entire TPM_SC register
 */
/*@{*/
#define TPM_RD_SC(base)          (TPM_SC_REG(base))
#define TPM_WR_SC(base, value)   (TPM_SC_REG(base) = (value))
#define TPM_RMW_SC(base, mask, value) (TPM_WR_SC(base, (TPM_RD_SC(base) & ~(mask)) | (value)))
#define TPM_SET_SC(base, value)  (BME_OR32(&TPM_SC_REG(base), (uint32_t)(value)))
#define TPM_CLR_SC(base, value)  (BME_AND32(&TPM_SC_REG(base), (uint32_t)(~(value))))
#define TPM_TOG_SC(base, value)  (BME_XOR32(&TPM_SC_REG(base), (uint32_t)(value)))
/*@}*/

/*
 * Constants & macros for individual TPM_SC bitfields
 */

/*!
 * @name Register TPM_SC, field PS[2:0] (RW)
 *
 * Selects one of 8 division factors for the clock mode selected by CMOD. This
 * field is write protected. It can be written only when the counter is disabled.
 *
 * Values:
 * - 000 - Divide by 1
 * - 001 - Divide by 2
 * - 010 - Divide by 4
 * - 011 - Divide by 8
 * - 100 - Divide by 16
 * - 101 - Divide by 32
 * - 110 - Divide by 64
 * - 111 - Divide by 128
 */
/*@{*/
/*! @brief Read current value of the TPM_SC_PS field. */
#define TPM_RD_SC_PS(base)   ((TPM_SC_REG(base) & TPM_SC_PS_MASK) >> TPM_SC_PS_SHIFT)
#define TPM_BRD_SC_PS(base)  (BME_UBFX32(&TPM_SC_REG(base), TPM_SC_PS_SHIFT, TPM_SC_PS_WIDTH))

/*! @brief Set the PS field to a new value. */
#define TPM_WR_SC_PS(base, value) (TPM_RMW_SC(base, (TPM_SC_PS_MASK | TPM_SC_TOF_MASK), TPM_SC_PS(value)))
#define TPM_BWR_SC_PS(base, value) (BME_BFI32(&TPM_SC_REG(base), ((uint32_t)(value) << TPM_SC_PS_SHIFT), TPM_SC_PS_SHIFT, TPM_SC_PS_WIDTH))
/*@}*/

/*!
 * @name Register TPM_SC, field CMOD[4:3] (RW)
 *
 * Selects the TPM counter clock modes. When disabling the counter, this field
 * remain set until acknolwedged in the TPM clock domain.
 *
 * Values:
 * - 00 - TPM counter is disabled
 * - 01 - TPM counter increments on every TPM counter clock
 * - 10 - TPM counter increments on rising edge of TPM_EXTCLK synchronized to
 *     the TPM counter clock
 * - 11 - Reserved.
 */
/*@{*/
/*! @brief Read current value of the TPM_SC_CMOD field. */
#define TPM_RD_SC_CMOD(base) ((TPM_SC_REG(base) & TPM_SC_CMOD_MASK) >> TPM_SC_CMOD_SHIFT)
#define TPM_BRD_SC_CMOD(base) (BME_UBFX32(&TPM_SC_REG(base), TPM_SC_CMOD_SHIFT, TPM_SC_CMOD_WIDTH))

/*! @brief Set the CMOD field to a new value. */
#define TPM_WR_SC_CMOD(base, value) (TPM_RMW_SC(base, (TPM_SC_CMOD_MASK | TPM_SC_TOF_MASK), TPM_SC_CMOD(value)))
#define TPM_BWR_SC_CMOD(base, value) (BME_BFI32(&TPM_SC_REG(base), ((uint32_t)(value) << TPM_SC_CMOD_SHIFT), TPM_SC_CMOD_SHIFT, TPM_SC_CMOD_WIDTH))
/*@}*/

/*!
 * @name Register TPM_SC, field CPWMS[5] (RW)
 *
 * Selects CPWM mode. This mode configures the TPM to operate in up-down
 * counting mode. This field is write protected. It can be written only when the counter
 * is disabled.
 *
 * Values:
 * - 0 - TPM counter operates in up counting mode.
 * - 1 - TPM counter operates in up-down counting mode.
 */
/*@{*/
/*! @brief Read current value of the TPM_SC_CPWMS field. */
#define TPM_RD_SC_CPWMS(base) ((TPM_SC_REG(base) & TPM_SC_CPWMS_MASK) >> TPM_SC_CPWMS_SHIFT)
#define TPM_BRD_SC_CPWMS(base) (BME_UBFX32(&TPM_SC_REG(base), TPM_SC_CPWMS_SHIFT, TPM_SC_CPWMS_WIDTH))

/*! @brief Set the CPWMS field to a new value. */
#define TPM_WR_SC_CPWMS(base, value) (TPM_RMW_SC(base, (TPM_SC_CPWMS_MASK | TPM_SC_TOF_MASK), TPM_SC_CPWMS(value)))
#define TPM_BWR_SC_CPWMS(base, value) (BME_BFI32(&TPM_SC_REG(base), ((uint32_t)(value) << TPM_SC_CPWMS_SHIFT), TPM_SC_CPWMS_SHIFT, TPM_SC_CPWMS_WIDTH))
/*@}*/

/*!
 * @name Register TPM_SC, field TOIE[6] (RW)
 *
 * Enables TPM overflow interrupts.
 *
 * Values:
 * - 0 - Disable TOF interrupts. Use software polling or DMA request.
 * - 1 - Enable TOF interrupts. An interrupt is generated when TOF equals one.
 */
/*@{*/
/*! @brief Read current value of the TPM_SC_TOIE field. */
#define TPM_RD_SC_TOIE(base) ((TPM_SC_REG(base) & TPM_SC_TOIE_MASK) >> TPM_SC_TOIE_SHIFT)
#define TPM_BRD_SC_TOIE(base) (BME_UBFX32(&TPM_SC_REG(base), TPM_SC_TOIE_SHIFT, TPM_SC_TOIE_WIDTH))

/*! @brief Set the TOIE field to a new value. */
#define TPM_WR_SC_TOIE(base, value) (TPM_RMW_SC(base, (TPM_SC_TOIE_MASK | TPM_SC_TOF_MASK), TPM_SC_TOIE(value)))
#define TPM_BWR_SC_TOIE(base, value) (BME_BFI32(&TPM_SC_REG(base), ((uint32_t)(value) << TPM_SC_TOIE_SHIFT), TPM_SC_TOIE_SHIFT, TPM_SC_TOIE_WIDTH))
/*@}*/

/*!
 * @name Register TPM_SC, field TOF[7] (W1C)
 *
 * Set by hardware when the TPM counter equals the value in the MOD register and
 * increments. Writing a 1 to TOF clears it. Writing a 0 to TOF has no effect.
 * If another TPM overflow occurs between the flag setting and the flag clearing,
 * the write operation has no effect; therefore, TOF remains set indicating
 * another overflow has occurred. In this case a TOF interrupt request is not lost due
 * to a delay in clearing the previous TOF.
 *
 * Values:
 * - 0 - TPM counter has not overflowed.
 * - 1 - TPM counter has overflowed.
 */
/*@{*/
/*! @brief Read current value of the TPM_SC_TOF field. */
#define TPM_RD_SC_TOF(base)  ((TPM_SC_REG(base) & TPM_SC_TOF_MASK) >> TPM_SC_TOF_SHIFT)
#define TPM_BRD_SC_TOF(base) (BME_UBFX32(&TPM_SC_REG(base), TPM_SC_TOF_SHIFT, TPM_SC_TOF_WIDTH))

/*! @brief Set the TOF field to a new value. */
#define TPM_WR_SC_TOF(base, value) (TPM_RMW_SC(base, TPM_SC_TOF_MASK, TPM_SC_TOF(value)))
#define TPM_BWR_SC_TOF(base, value) (BME_BFI32(&TPM_SC_REG(base), ((uint32_t)(value) << TPM_SC_TOF_SHIFT), TPM_SC_TOF_SHIFT, TPM_SC_TOF_WIDTH))
/*@}*/

/*!
 * @name Register TPM_SC, field DMA[8] (RW)
 *
 * Enables DMA transfers for the overflow flag.
 *
 * Values:
 * - 0 - Disables DMA transfers.
 * - 1 - Enables DMA transfers.
 */
/*@{*/
/*! @brief Read current value of the TPM_SC_DMA field. */
#define TPM_RD_SC_DMA(base)  ((TPM_SC_REG(base) & TPM_SC_DMA_MASK) >> TPM_SC_DMA_SHIFT)
#define TPM_BRD_SC_DMA(base) (BME_UBFX32(&TPM_SC_REG(base), TPM_SC_DMA_SHIFT, TPM_SC_DMA_WIDTH))

/*! @brief Set the DMA field to a new value. */
#define TPM_WR_SC_DMA(base, value) (TPM_RMW_SC(base, (TPM_SC_DMA_MASK | TPM_SC_TOF_MASK), TPM_SC_DMA(value)))
#define TPM_BWR_SC_DMA(base, value) (BME_BFI32(&TPM_SC_REG(base), ((uint32_t)(value) << TPM_SC_DMA_SHIFT), TPM_SC_DMA_SHIFT, TPM_SC_DMA_WIDTH))
/*@}*/

/*******************************************************************************
 * TPM_CNT - Counter
 ******************************************************************************/

/*!
 * @brief TPM_CNT - Counter (RW)
 *
 * Reset value: 0x00000000U
 *
 * The CNT register contains the TPM counter value. Reset clears the CNT
 * register. Writing any value to COUNT also clears the counter. When debug is active,
 * the TPM counter does not increment unless configured otherwise. Reading the CNT
 * register adds two wait states to the register access due to synchronization
 * delays.
 */
/*!
 * @name Constants and macros for entire TPM_CNT register
 */
/*@{*/
#define TPM_RD_CNT(base)         (TPM_CNT_REG(base))
#define TPM_WR_CNT(base, value)  (TPM_CNT_REG(base) = (value))
#define TPM_RMW_CNT(base, mask, value) (TPM_WR_CNT(base, (TPM_RD_CNT(base) & ~(mask)) | (value)))
#define TPM_SET_CNT(base, value) (BME_OR32(&TPM_CNT_REG(base), (uint32_t)(value)))
#define TPM_CLR_CNT(base, value) (BME_AND32(&TPM_CNT_REG(base), (uint32_t)(~(value))))
#define TPM_TOG_CNT(base, value) (BME_XOR32(&TPM_CNT_REG(base), (uint32_t)(value)))
/*@}*/

/*
 * Constants & macros for individual TPM_CNT bitfields
 */

/*!
 * @name Register TPM_CNT, field COUNT[15:0] (RW)
 */
/*@{*/
/*! @brief Read current value of the TPM_CNT_COUNT field. */
#define TPM_RD_CNT_COUNT(base) ((TPM_CNT_REG(base) & TPM_CNT_COUNT_MASK) >> TPM_CNT_COUNT_SHIFT)
#define TPM_BRD_CNT_COUNT(base) (BME_UBFX32(&TPM_CNT_REG(base), TPM_CNT_COUNT_SHIFT, TPM_CNT_COUNT_WIDTH))

/*! @brief Set the COUNT field to a new value. */
#define TPM_WR_CNT_COUNT(base, value) (TPM_RMW_CNT(base, TPM_CNT_COUNT_MASK, TPM_CNT_COUNT(value)))
#define TPM_BWR_CNT_COUNT(base, value) (BME_BFI32(&TPM_CNT_REG(base), ((uint32_t)(value) << TPM_CNT_COUNT_SHIFT), TPM_CNT_COUNT_SHIFT, TPM_CNT_COUNT_WIDTH))
/*@}*/

/*******************************************************************************
 * TPM_MOD - Modulo
 ******************************************************************************/

/*!
 * @brief TPM_MOD - Modulo (RW)
 *
 * Reset value: 0x0000FFFFU
 *
 * The Modulo register contains the modulo value for the TPM counter. When the
 * TPM counter reaches the modulo value and increments, the overflow flag (TOF) is
 * set and the next value of TPM counter depends on the selected counting method
 * (see CounterThe TPM has a 16-bit counter that is used by the channels either
 * for input or output modes. ). Writing to the MOD register latches the value
 * into a buffer. The MOD register is updated with the value of its write buffer
 * according to MOD Register Update . Additional writes to the MOD write buffer are
 * ignored until the register has been updated. It is recommended to initialize
 * the TPM counter (write to CNT) before writing to the MOD register to avoid
 * confusion about when the first counter overflow will occur.
 */
/*!
 * @name Constants and macros for entire TPM_MOD register
 */
/*@{*/
#define TPM_RD_MOD(base)         (TPM_MOD_REG(base))
#define TPM_WR_MOD(base, value)  (TPM_MOD_REG(base) = (value))
#define TPM_RMW_MOD(base, mask, value) (TPM_WR_MOD(base, (TPM_RD_MOD(base) & ~(mask)) | (value)))
#define TPM_SET_MOD(base, value) (BME_OR32(&TPM_MOD_REG(base), (uint32_t)(value)))
#define TPM_CLR_MOD(base, value) (BME_AND32(&TPM_MOD_REG(base), (uint32_t)(~(value))))
#define TPM_TOG_MOD(base, value) (BME_XOR32(&TPM_MOD_REG(base), (uint32_t)(value)))
/*@}*/

/*
 * Constants & macros for individual TPM_MOD bitfields
 */

/*!
 * @name Register TPM_MOD, field MOD[15:0] (RW)
 *
 * When writing this field, all bytes must be written at the same time.
 */
/*@{*/
/*! @brief Read current value of the TPM_MOD_MOD field. */
#define TPM_RD_MOD_MOD(base) ((TPM_MOD_REG(base) & TPM_MOD_MOD_MASK) >> TPM_MOD_MOD_SHIFT)
#define TPM_BRD_MOD_MOD(base) (BME_UBFX32(&TPM_MOD_REG(base), TPM_MOD_MOD_SHIFT, TPM_MOD_MOD_WIDTH))

/*! @brief Set the MOD field to a new value. */
#define TPM_WR_MOD_MOD(base, value) (TPM_RMW_MOD(base, TPM_MOD_MOD_MASK, TPM_MOD_MOD(value)))
#define TPM_BWR_MOD_MOD(base, value) (BME_BFI32(&TPM_MOD_REG(base), ((uint32_t)(value) << TPM_MOD_MOD_SHIFT), TPM_MOD_MOD_SHIFT, TPM_MOD_MOD_WIDTH))
/*@}*/

/*******************************************************************************
 * TPM_CnSC - Channel (n) Status and Control
 ******************************************************************************/

/*!
 * @brief TPM_CnSC - Channel (n) Status and Control (RW)
 *
 * Reset value: 0x00000000U
 *
 * CnSC contains the channel-interrupt-status flag and control bits used to
 * configure the interrupt enable, channel configuration, and pin function. When
 * switching from one channel mode to a different channel mode, the channel must
 * first be disabled and this must be acknowledged in the TPM counter clock domain.
 * Mode, Edge, and Level Selection CPWMS MSnB:MSnA ELSnB:ELSnA Mode Configuration
 * X 00 00 None Channel disabled X 01 00 Software compare Pin not used for TPM 0
 * 00 01 Input capture Capture on Rising Edge Only 10 Capture on Falling Edge
 * Only 11 Capture on Rising or Falling Edge 01 01 Output compare Toggle Output on
 * match 10 Clear Output on match 11 Set Output on match 10 10 Edge-aligned PWM
 * High-true pulses (clear Output on match, set Output on reload) X1 Low-true
 * pulses (set Output on match, clear Output on reload) 11 10 Output compare Pulse
 * Output low on match 01 Pulse Output high on match 1 10 10 Center-aligned PWM
 * High-true pulses (clear Output on match-up, set Output on match-down) 01 Low-true
 * pulses (set Output on match-up, clear Output on match-down)
 */
/*!
 * @name Constants and macros for entire TPM_CnSC register
 */
/*@{*/
#define TPM_RD_CnSC(base, index) (TPM_CnSC_REG(base, index))
#define TPM_WR_CnSC(base, index, value) (TPM_CnSC_REG(base, index) = (value))
#define TPM_RMW_CnSC(base, index, mask, value) (TPM_WR_CnSC(base, index, (TPM_RD_CnSC(base, index) & ~(mask)) | (value)))
#define TPM_SET_CnSC(base, index, value) (BME_OR32(&TPM_CnSC_REG(base, index), (uint32_t)(value)))
#define TPM_CLR_CnSC(base, index, value) (BME_AND32(&TPM_CnSC_REG(base, index), (uint32_t)(~(value))))
#define TPM_TOG_CnSC(base, index, value) (BME_XOR32(&TPM_CnSC_REG(base, index), (uint32_t)(value)))
/*@}*/

/*
 * Constants & macros for individual TPM_CnSC bitfields
 */

/*!
 * @name Register TPM_CnSC, field DMA[0] (RW)
 *
 * Enables DMA transfers for the channel.
 *
 * Values:
 * - 0 - Disable DMA transfers.
 * - 1 - Enable DMA transfers.
 */
/*@{*/
/*! @brief Read current value of the TPM_CnSC_DMA field. */
#define TPM_RD_CnSC_DMA(base, index) ((TPM_CnSC_REG(base, index) & TPM_CnSC_DMA_MASK) >> TPM_CnSC_DMA_SHIFT)
#define TPM_BRD_CnSC_DMA(base, index) (BME_UBFX32(&TPM_CnSC_REG(base, index), TPM_CnSC_DMA_SHIFT, TPM_CnSC_DMA_WIDTH))

/*! @brief Set the DMA field to a new value. */
#define TPM_WR_CnSC_DMA(base, index, value) (TPM_RMW_CnSC(base, index, (TPM_CnSC_DMA_MASK | TPM_CnSC_CHF_MASK), TPM_CnSC_DMA(value)))
#define TPM_BWR_CnSC_DMA(base, index, value) (BME_BFI32(&TPM_CnSC_REG(base, index), ((uint32_t)(value) << TPM_CnSC_DMA_SHIFT), TPM_CnSC_DMA_SHIFT, TPM_CnSC_DMA_WIDTH))
/*@}*/

/*!
 * @name Register TPM_CnSC, field ELSA[2] (RW)
 *
 * The functionality of ELSB and ELSA depends on the channel mode. When a
 * channel is disabled, this field will not change state until acknowledged in the TPM
 * counter clock domain.
 */
/*@{*/
/*! @brief Read current value of the TPM_CnSC_ELSA field. */
#define TPM_RD_CnSC_ELSA(base, index) ((TPM_CnSC_REG(base, index) & TPM_CnSC_ELSA_MASK) >> TPM_CnSC_ELSA_SHIFT)
#define TPM_BRD_CnSC_ELSA(base, index) (BME_UBFX32(&TPM_CnSC_REG(base, index), TPM_CnSC_ELSA_SHIFT, TPM_CnSC_ELSA_WIDTH))

/*! @brief Set the ELSA field to a new value. */
#define TPM_WR_CnSC_ELSA(base, index, value) (TPM_RMW_CnSC(base, index, (TPM_CnSC_ELSA_MASK | TPM_CnSC_CHF_MASK), TPM_CnSC_ELSA(value)))
#define TPM_BWR_CnSC_ELSA(base, index, value) (BME_BFI32(&TPM_CnSC_REG(base, index), ((uint32_t)(value) << TPM_CnSC_ELSA_SHIFT), TPM_CnSC_ELSA_SHIFT, TPM_CnSC_ELSA_WIDTH))
/*@}*/

/*!
 * @name Register TPM_CnSC, field ELSB[3] (RW)
 *
 * The functionality of ELSB and ELSA depends on the channel mode. When a
 * channel is disabled, this field will not change state until acknowledged in the TPM
 * counter clock domain.
 */
/*@{*/
/*! @brief Read current value of the TPM_CnSC_ELSB field. */
#define TPM_RD_CnSC_ELSB(base, index) ((TPM_CnSC_REG(base, index) & TPM_CnSC_ELSB_MASK) >> TPM_CnSC_ELSB_SHIFT)
#define TPM_BRD_CnSC_ELSB(base, index) (BME_UBFX32(&TPM_CnSC_REG(base, index), TPM_CnSC_ELSB_SHIFT, TPM_CnSC_ELSB_WIDTH))

/*! @brief Set the ELSB field to a new value. */
#define TPM_WR_CnSC_ELSB(base, index, value) (TPM_RMW_CnSC(base, index, (TPM_CnSC_ELSB_MASK | TPM_CnSC_CHF_MASK), TPM_CnSC_ELSB(value)))
#define TPM_BWR_CnSC_ELSB(base, index, value) (BME_BFI32(&TPM_CnSC_REG(base, index), ((uint32_t)(value) << TPM_CnSC_ELSB_SHIFT), TPM_CnSC_ELSB_SHIFT, TPM_CnSC_ELSB_WIDTH))
/*@}*/

/*!
 * @name Register TPM_CnSC, field MSA[4] (RW)
 *
 * Used for further selections in the channel logic. Its functionality is
 * dependent on the channel mode. When a channel is disabled, this field will not
 * change state until acknowledged in the TPM counter clock domain.
 */
/*@{*/
/*! @brief Read current value of the TPM_CnSC_MSA field. */
#define TPM_RD_CnSC_MSA(base, index) ((TPM_CnSC_REG(base, index) & TPM_CnSC_MSA_MASK) >> TPM_CnSC_MSA_SHIFT)
#define TPM_BRD_CnSC_MSA(base, index) (BME_UBFX32(&TPM_CnSC_REG(base, index), TPM_CnSC_MSA_SHIFT, TPM_CnSC_MSA_WIDTH))

/*! @brief Set the MSA field to a new value. */
#define TPM_WR_CnSC_MSA(base, index, value) (TPM_RMW_CnSC(base, index, (TPM_CnSC_MSA_MASK | TPM_CnSC_CHF_MASK), TPM_CnSC_MSA(value)))
#define TPM_BWR_CnSC_MSA(base, index, value) (BME_BFI32(&TPM_CnSC_REG(base, index), ((uint32_t)(value) << TPM_CnSC_MSA_SHIFT), TPM_CnSC_MSA_SHIFT, TPM_CnSC_MSA_WIDTH))
/*@}*/

/*!
 * @name Register TPM_CnSC, field MSB[5] (RW)
 *
 * Used for further selections in the channel logic. Its functionality is
 * dependent on the channel mode. When a channel is disabled, this field will not
 * change state until acknowledged in the TPM counter clock domain.
 */
/*@{*/
/*! @brief Read current value of the TPM_CnSC_MSB field. */
#define TPM_RD_CnSC_MSB(base, index) ((TPM_CnSC_REG(base, index) & TPM_CnSC_MSB_MASK) >> TPM_CnSC_MSB_SHIFT)
#define TPM_BRD_CnSC_MSB(base, index) (BME_UBFX32(&TPM_CnSC_REG(base, index), TPM_CnSC_MSB_SHIFT, TPM_CnSC_MSB_WIDTH))

/*! @brief Set the MSB field to a new value. */
#define TPM_WR_CnSC_MSB(base, index, value) (TPM_RMW_CnSC(base, index, (TPM_CnSC_MSB_MASK | TPM_CnSC_CHF_MASK), TPM_CnSC_MSB(value)))
#define TPM_BWR_CnSC_MSB(base, index, value) (BME_BFI32(&TPM_CnSC_REG(base, index), ((uint32_t)(value) << TPM_CnSC_MSB_SHIFT), TPM_CnSC_MSB_SHIFT, TPM_CnSC_MSB_WIDTH))
/*@}*/

/*!
 * @name Register TPM_CnSC, field CHIE[6] (RW)
 *
 * Enables channel interrupts.
 *
 * Values:
 * - 0 - Disable channel interrupts.
 * - 1 - Enable channel interrupts.
 */
/*@{*/
/*! @brief Read current value of the TPM_CnSC_CHIE field. */
#define TPM_RD_CnSC_CHIE(base, index) ((TPM_CnSC_REG(base, index) & TPM_CnSC_CHIE_MASK) >> TPM_CnSC_CHIE_SHIFT)
#define TPM_BRD_CnSC_CHIE(base, index) (BME_UBFX32(&TPM_CnSC_REG(base, index), TPM_CnSC_CHIE_SHIFT, TPM_CnSC_CHIE_WIDTH))

/*! @brief Set the CHIE field to a new value. */
#define TPM_WR_CnSC_CHIE(base, index, value) (TPM_RMW_CnSC(base, index, (TPM_CnSC_CHIE_MASK | TPM_CnSC_CHF_MASK), TPM_CnSC_CHIE(value)))
#define TPM_BWR_CnSC_CHIE(base, index, value) (BME_BFI32(&TPM_CnSC_REG(base, index), ((uint32_t)(value) << TPM_CnSC_CHIE_SHIFT), TPM_CnSC_CHIE_SHIFT, TPM_CnSC_CHIE_WIDTH))
/*@}*/

/*!
 * @name Register TPM_CnSC, field CHF[7] (W1C)
 *
 * Set by hardware when an event occurs on the channel. CHF is cleared by
 * writing a 1 to the CHF bit. Writing a 0 to CHF has no effect. If another event
 * occurs between the CHF sets and the write operation, the write operation has no
 * effect; therefore, CHF remains set indicating another event has occurred. In this
 * case a CHF interrupt request is not lost due to the delay in clearing the
 * previous CHF.
 *
 * Values:
 * - 0 - No channel event has occurred.
 * - 1 - A channel event has occurred.
 */
/*@{*/
/*! @brief Read current value of the TPM_CnSC_CHF field. */
#define TPM_RD_CnSC_CHF(base, index) ((TPM_CnSC_REG(base, index) & TPM_CnSC_CHF_MASK) >> TPM_CnSC_CHF_SHIFT)
#define TPM_BRD_CnSC_CHF(base, index) (BME_UBFX32(&TPM_CnSC_REG(base, index), TPM_CnSC_CHF_SHIFT, TPM_CnSC_CHF_WIDTH))

/*! @brief Set the CHF field to a new value. */
#define TPM_WR_CnSC_CHF(base, index, value) (TPM_RMW_CnSC(base, index, TPM_CnSC_CHF_MASK, TPM_CnSC_CHF(value)))
#define TPM_BWR_CnSC_CHF(base, index, value) (BME_BFI32(&TPM_CnSC_REG(base, index), ((uint32_t)(value) << TPM_CnSC_CHF_SHIFT), TPM_CnSC_CHF_SHIFT, TPM_CnSC_CHF_WIDTH))
/*@}*/

/*******************************************************************************
 * TPM_CnV - Channel (n) Value
 ******************************************************************************/

/*!
 * @brief TPM_CnV - Channel (n) Value (RW)
 *
 * Reset value: 0x00000000U
 *
 * These registers contain the captured TPM counter value for the input modes or
 * the match value for the output modes. In input capture mode, any write to a
 * CnV register is ignored. In compare modes, writing to a CnV register latches
 * the value into a buffer. A CnV register is updated with the value of its write
 * buffer according to CnV Register Update . Additional writes to the CnV write
 * buffer are ignored until the register has been updated.
 */
/*!
 * @name Constants and macros for entire TPM_CnV register
 */
/*@{*/
#define TPM_RD_CnV(base, index)  (TPM_CnV_REG(base, index))
#define TPM_WR_CnV(base, index, value) (TPM_CnV_REG(base, index) = (value))
#define TPM_RMW_CnV(base, index, mask, value) (TPM_WR_CnV(base, index, (TPM_RD_CnV(base, index) & ~(mask)) | (value)))
#define TPM_SET_CnV(base, index, value) (BME_OR32(&TPM_CnV_REG(base, index), (uint32_t)(value)))
#define TPM_CLR_CnV(base, index, value) (BME_AND32(&TPM_CnV_REG(base, index), (uint32_t)(~(value))))
#define TPM_TOG_CnV(base, index, value) (BME_XOR32(&TPM_CnV_REG(base, index), (uint32_t)(value)))
/*@}*/

/*
 * Constants & macros for individual TPM_CnV bitfields
 */

/*!
 * @name Register TPM_CnV, field VAL[15:0] (RW)
 *
 * Captured TPM counter value of the input modes or the match value for the
 * output modes. When writing this field, all bytes must be written at the same time.
 */
/*@{*/
/*! @brief Read current value of the TPM_CnV_VAL field. */
#define TPM_RD_CnV_VAL(base, index) ((TPM_CnV_REG(base, index) & TPM_CnV_VAL_MASK) >> TPM_CnV_VAL_SHIFT)
#define TPM_BRD_CnV_VAL(base, index) (BME_UBFX32(&TPM_CnV_REG(base, index), TPM_CnV_VAL_SHIFT, TPM_CnV_VAL_WIDTH))

/*! @brief Set the VAL field to a new value. */
#define TPM_WR_CnV_VAL(base, index, value) (TPM_RMW_CnV(base, index, TPM_CnV_VAL_MASK, TPM_CnV_VAL(value)))
#define TPM_BWR_CnV_VAL(base, index, value) (BME_BFI32(&TPM_CnV_REG(base, index), ((uint32_t)(value) << TPM_CnV_VAL_SHIFT), TPM_CnV_VAL_SHIFT, TPM_CnV_VAL_WIDTH))
/*@}*/

/*******************************************************************************
 * TPM_STATUS - Capture and Compare Status
 ******************************************************************************/

/*!
 * @brief TPM_STATUS - Capture and Compare Status (RW)
 *
 * Reset value: 0x00000000U
 *
 * The STATUS register contains a copy of the status flag, CnSC[CHnF] for each
 * TPM channel, as well as SC[TOF], for software convenience. Each CHnF bit in
 * STATUS is a mirror of CHnF bit in CnSC. All CHnF bits can be checked using only
 * one read of STATUS. All CHnF bits can be cleared by writing all ones to STATUS.
 * Hardware sets the individual channel flags when an event occurs on the
 * channel. Writing a 1 to CHF clears it. Writing a 0 to CHF has no effect. If another
 * event occurs between the flag setting and the write operation, the write
 * operation has no effect; therefore, CHF remains set indicating another event has
 * occurred. In this case a CHF interrupt request is not lost due to the clearing
 * sequence for a previous CHF.
 */
/*!
 * @name Constants and macros for entire TPM_STATUS register
 */
/*@{*/
#define TPM_RD_STATUS(base)      (TPM_STATUS_REG(base))
#define TPM_WR_STATUS(base, value) (TPM_STATUS_REG(base) = (value))
#define TPM_RMW_STATUS(base, mask, value) (TPM_WR_STATUS(base, (TPM_RD_STATUS(base) & ~(mask)) | (value)))
#define TPM_SET_STATUS(base, value) (BME_OR32(&TPM_STATUS_REG(base), (uint32_t)(value)))
#define TPM_CLR_STATUS(base, value) (BME_AND32(&TPM_STATUS_REG(base), (uint32_t)(~(value))))
#define TPM_TOG_STATUS(base, value) (BME_XOR32(&TPM_STATUS_REG(base), (uint32_t)(value)))
/*@}*/

/*
 * Constants & macros for individual TPM_STATUS bitfields
 */

/*!
 * @name Register TPM_STATUS, field CH0F[0] (W1C)
 *
 * See the register description.
 *
 * Values:
 * - 0 - No channel event has occurred.
 * - 1 - A channel event has occurred.
 */
/*@{*/
/*! @brief Read current value of the TPM_STATUS_CH0F field. */
#define TPM_RD_STATUS_CH0F(base) ((TPM_STATUS_REG(base) & TPM_STATUS_CH0F_MASK) >> TPM_STATUS_CH0F_SHIFT)
#define TPM_BRD_STATUS_CH0F(base) (BME_UBFX32(&TPM_STATUS_REG(base), TPM_STATUS_CH0F_SHIFT, TPM_STATUS_CH0F_WIDTH))

/*! @brief Set the CH0F field to a new value. */
#define TPM_WR_STATUS_CH0F(base, value) (TPM_RMW_STATUS(base, (TPM_STATUS_CH0F_MASK | TPM_STATUS_CH1F_MASK | TPM_STATUS_CH2F_MASK | TPM_STATUS_CH3F_MASK | TPM_STATUS_CH4F_MASK | TPM_STATUS_CH5F_MASK | TPM_STATUS_TOF_MASK), TPM_STATUS_CH0F(value)))
#define TPM_BWR_STATUS_CH0F(base, value) (BME_BFI32(&TPM_STATUS_REG(base), ((uint32_t)(value) << TPM_STATUS_CH0F_SHIFT), TPM_STATUS_CH0F_SHIFT, TPM_STATUS_CH0F_WIDTH))
/*@}*/

/*!
 * @name Register TPM_STATUS, field CH1F[1] (W1C)
 *
 * See the register description.
 *
 * Values:
 * - 0 - No channel event has occurred.
 * - 1 - A channel event has occurred.
 */
/*@{*/
/*! @brief Read current value of the TPM_STATUS_CH1F field. */
#define TPM_RD_STATUS_CH1F(base) ((TPM_STATUS_REG(base) & TPM_STATUS_CH1F_MASK) >> TPM_STATUS_CH1F_SHIFT)
#define TPM_BRD_STATUS_CH1F(base) (BME_UBFX32(&TPM_STATUS_REG(base), TPM_STATUS_CH1F_SHIFT, TPM_STATUS_CH1F_WIDTH))

/*! @brief Set the CH1F field to a new value. */
#define TPM_WR_STATUS_CH1F(base, value) (TPM_RMW_STATUS(base, (TPM_STATUS_CH1F_MASK | TPM_STATUS_CH0F_MASK | TPM_STATUS_CH2F_MASK | TPM_STATUS_CH3F_MASK | TPM_STATUS_CH4F_MASK | TPM_STATUS_CH5F_MASK | TPM_STATUS_TOF_MASK), TPM_STATUS_CH1F(value)))
#define TPM_BWR_STATUS_CH1F(base, value) (BME_BFI32(&TPM_STATUS_REG(base), ((uint32_t)(value) << TPM_STATUS_CH1F_SHIFT), TPM_STATUS_CH1F_SHIFT, TPM_STATUS_CH1F_WIDTH))
/*@}*/

/*!
 * @name Register TPM_STATUS, field CH2F[2] (W1C)
 *
 * See the register description.
 *
 * Values:
 * - 0 - No channel event has occurred.
 * - 1 - A channel event has occurred.
 */
/*@{*/
/*! @brief Read current value of the TPM_STATUS_CH2F field. */
#define TPM_RD_STATUS_CH2F(base) ((TPM_STATUS_REG(base) & TPM_STATUS_CH2F_MASK) >> TPM_STATUS_CH2F_SHIFT)
#define TPM_BRD_STATUS_CH2F(base) (BME_UBFX32(&TPM_STATUS_REG(base), TPM_STATUS_CH2F_SHIFT, TPM_STATUS_CH2F_WIDTH))

/*! @brief Set the CH2F field to a new value. */
#define TPM_WR_STATUS_CH2F(base, value) (TPM_RMW_STATUS(base, (TPM_STATUS_CH2F_MASK | TPM_STATUS_CH0F_MASK | TPM_STATUS_CH1F_MASK | TPM_STATUS_CH3F_MASK | TPM_STATUS_CH4F_MASK | TPM_STATUS_CH5F_MASK | TPM_STATUS_TOF_MASK), TPM_STATUS_CH2F(value)))
#define TPM_BWR_STATUS_CH2F(base, value) (BME_BFI32(&TPM_STATUS_REG(base), ((uint32_t)(value) << TPM_STATUS_CH2F_SHIFT), TPM_STATUS_CH2F_SHIFT, TPM_STATUS_CH2F_WIDTH))
/*@}*/

/*!
 * @name Register TPM_STATUS, field CH3F[3] (W1C)
 *
 * See the register description.
 *
 * Values:
 * - 0 - No channel event has occurred.
 * - 1 - A channel event has occurred.
 */
/*@{*/
/*! @brief Read current value of the TPM_STATUS_CH3F field. */
#define TPM_RD_STATUS_CH3F(base) ((TPM_STATUS_REG(base) & TPM_STATUS_CH3F_MASK) >> TPM_STATUS_CH3F_SHIFT)
#define TPM_BRD_STATUS_CH3F(base) (BME_UBFX32(&TPM_STATUS_REG(base), TPM_STATUS_CH3F_SHIFT, TPM_STATUS_CH3F_WIDTH))

/*! @brief Set the CH3F field to a new value. */
#define TPM_WR_STATUS_CH3F(base, value) (TPM_RMW_STATUS(base, (TPM_STATUS_CH3F_MASK | TPM_STATUS_CH0F_MASK | TPM_STATUS_CH1F_MASK | TPM_STATUS_CH2F_MASK | TPM_STATUS_CH4F_MASK | TPM_STATUS_CH5F_MASK | TPM_STATUS_TOF_MASK), TPM_STATUS_CH3F(value)))
#define TPM_BWR_STATUS_CH3F(base, value) (BME_BFI32(&TPM_STATUS_REG(base), ((uint32_t)(value) << TPM_STATUS_CH3F_SHIFT), TPM_STATUS_CH3F_SHIFT, TPM_STATUS_CH3F_WIDTH))
/*@}*/

/*!
 * @name Register TPM_STATUS, field CH4F[4] (W1C)
 *
 * See the register description.
 *
 * Values:
 * - 0 - No channel event has occurred.
 * - 1 - A channel event has occurred.
 */
/*@{*/
/*! @brief Read current value of the TPM_STATUS_CH4F field. */
#define TPM_RD_STATUS_CH4F(base) ((TPM_STATUS_REG(base) & TPM_STATUS_CH4F_MASK) >> TPM_STATUS_CH4F_SHIFT)
#define TPM_BRD_STATUS_CH4F(base) (BME_UBFX32(&TPM_STATUS_REG(base), TPM_STATUS_CH4F_SHIFT, TPM_STATUS_CH4F_WIDTH))

/*! @brief Set the CH4F field to a new value. */
#define TPM_WR_STATUS_CH4F(base, value) (TPM_RMW_STATUS(base, (TPM_STATUS_CH4F_MASK | TPM_STATUS_CH0F_MASK | TPM_STATUS_CH1F_MASK | TPM_STATUS_CH2F_MASK | TPM_STATUS_CH3F_MASK | TPM_STATUS_CH5F_MASK | TPM_STATUS_TOF_MASK), TPM_STATUS_CH4F(value)))
#define TPM_BWR_STATUS_CH4F(base, value) (BME_BFI32(&TPM_STATUS_REG(base), ((uint32_t)(value) << TPM_STATUS_CH4F_SHIFT), TPM_STATUS_CH4F_SHIFT, TPM_STATUS_CH4F_WIDTH))
/*@}*/

/*!
 * @name Register TPM_STATUS, field CH5F[5] (W1C)
 *
 * See the register description.
 *
 * Values:
 * - 0 - No channel event has occurred.
 * - 1 - A channel event has occurred.
 */
/*@{*/
/*! @brief Read current value of the TPM_STATUS_CH5F field. */
#define TPM_RD_STATUS_CH5F(base) ((TPM_STATUS_REG(base) & TPM_STATUS_CH5F_MASK) >> TPM_STATUS_CH5F_SHIFT)
#define TPM_BRD_STATUS_CH5F(base) (BME_UBFX32(&TPM_STATUS_REG(base), TPM_STATUS_CH5F_SHIFT, TPM_STATUS_CH5F_WIDTH))

/*! @brief Set the CH5F field to a new value. */
#define TPM_WR_STATUS_CH5F(base, value) (TPM_RMW_STATUS(base, (TPM_STATUS_CH5F_MASK | TPM_STATUS_CH0F_MASK | TPM_STATUS_CH1F_MASK | TPM_STATUS_CH2F_MASK | TPM_STATUS_CH3F_MASK | TPM_STATUS_CH4F_MASK | TPM_STATUS_TOF_MASK), TPM_STATUS_CH5F(value)))
#define TPM_BWR_STATUS_CH5F(base, value) (BME_BFI32(&TPM_STATUS_REG(base), ((uint32_t)(value) << TPM_STATUS_CH5F_SHIFT), TPM_STATUS_CH5F_SHIFT, TPM_STATUS_CH5F_WIDTH))
/*@}*/

/*!
 * @name Register TPM_STATUS, field TOF[8] (W1C)
 *
 * See register description
 *
 * Values:
 * - 0 - TPM counter has not overflowed.
 * - 1 - TPM counter has overflowed.
 */
/*@{*/
/*! @brief Read current value of the TPM_STATUS_TOF field. */
#define TPM_RD_STATUS_TOF(base) ((TPM_STATUS_REG(base) & TPM_STATUS_TOF_MASK) >> TPM_STATUS_TOF_SHIFT)
#define TPM_BRD_STATUS_TOF(base) (BME_UBFX32(&TPM_STATUS_REG(base), TPM_STATUS_TOF_SHIFT, TPM_STATUS_TOF_WIDTH))

/*! @brief Set the TOF field to a new value. */
#define TPM_WR_STATUS_TOF(base, value) (TPM_RMW_STATUS(base, (TPM_STATUS_TOF_MASK | TPM_STATUS_CH0F_MASK | TPM_STATUS_CH1F_MASK | TPM_STATUS_CH2F_MASK | TPM_STATUS_CH3F_MASK | TPM_STATUS_CH4F_MASK | TPM_STATUS_CH5F_MASK), TPM_STATUS_TOF(value)))
#define TPM_BWR_STATUS_TOF(base, value) (BME_BFI32(&TPM_STATUS_REG(base), ((uint32_t)(value) << TPM_STATUS_TOF_SHIFT), TPM_STATUS_TOF_SHIFT, TPM_STATUS_TOF_WIDTH))
/*@}*/

/*******************************************************************************
 * TPM_POL - Channel Polarity
 ******************************************************************************/

/*!
 * @brief TPM_POL - Channel Polarity (RW)
 *
 * Reset value: 0x00000000U
 *
 * This register defines the input and output polarity of each of the channels.
 */
/*!
 * @name Constants and macros for entire TPM_POL register
 */
/*@{*/
#define TPM_RD_POL(base)         (TPM_POL_REG(base))
#define TPM_WR_POL(base, value)  (TPM_POL_REG(base) = (value))
#define TPM_RMW_POL(base, mask, value) (TPM_WR_POL(base, (TPM_RD_POL(base) & ~(mask)) | (value)))
#define TPM_SET_POL(base, value) (BME_OR32(&TPM_POL_REG(base), (uint32_t)(value)))
#define TPM_CLR_POL(base, value) (BME_AND32(&TPM_POL_REG(base), (uint32_t)(~(value))))
#define TPM_TOG_POL(base, value) (BME_XOR32(&TPM_POL_REG(base), (uint32_t)(value)))
/*@}*/

/*
 * Constants & macros for individual TPM_POL bitfields
 */

/*!
 * @name Register TPM_POL, field POL0[0] (RW)
 *
 * Values:
 * - 0 - The channel polarity is active high.
 * - 1 - The channel polarity is active low.
 */
/*@{*/
/*! @brief Read current value of the TPM_POL_POL0 field. */
#define TPM_RD_POL_POL0(base) ((TPM_POL_REG(base) & TPM_POL_POL0_MASK) >> TPM_POL_POL0_SHIFT)
#define TPM_BRD_POL_POL0(base) (BME_UBFX32(&TPM_POL_REG(base), TPM_POL_POL0_SHIFT, TPM_POL_POL0_WIDTH))

/*! @brief Set the POL0 field to a new value. */
#define TPM_WR_POL_POL0(base, value) (TPM_RMW_POL(base, TPM_POL_POL0_MASK, TPM_POL_POL0(value)))
#define TPM_BWR_POL_POL0(base, value) (BME_BFI32(&TPM_POL_REG(base), ((uint32_t)(value) << TPM_POL_POL0_SHIFT), TPM_POL_POL0_SHIFT, TPM_POL_POL0_WIDTH))
/*@}*/

/*!
 * @name Register TPM_POL, field POL1[1] (RW)
 *
 * Values:
 * - 0 - The channel polarity is active high.
 * - 1 - The channel polarity is active low.
 */
/*@{*/
/*! @brief Read current value of the TPM_POL_POL1 field. */
#define TPM_RD_POL_POL1(base) ((TPM_POL_REG(base) & TPM_POL_POL1_MASK) >> TPM_POL_POL1_SHIFT)
#define TPM_BRD_POL_POL1(base) (BME_UBFX32(&TPM_POL_REG(base), TPM_POL_POL1_SHIFT, TPM_POL_POL1_WIDTH))

/*! @brief Set the POL1 field to a new value. */
#define TPM_WR_POL_POL1(base, value) (TPM_RMW_POL(base, TPM_POL_POL1_MASK, TPM_POL_POL1(value)))
#define TPM_BWR_POL_POL1(base, value) (BME_BFI32(&TPM_POL_REG(base), ((uint32_t)(value) << TPM_POL_POL1_SHIFT), TPM_POL_POL1_SHIFT, TPM_POL_POL1_WIDTH))
/*@}*/

/*!
 * @name Register TPM_POL, field POL2[2] (RW)
 *
 * Values:
 * - 0 - The channel polarity is active high.
 * - 1 - The channel polarity is active low.
 */
/*@{*/
/*! @brief Read current value of the TPM_POL_POL2 field. */
#define TPM_RD_POL_POL2(base) ((TPM_POL_REG(base) & TPM_POL_POL2_MASK) >> TPM_POL_POL2_SHIFT)
#define TPM_BRD_POL_POL2(base) (BME_UBFX32(&TPM_POL_REG(base), TPM_POL_POL2_SHIFT, TPM_POL_POL2_WIDTH))

/*! @brief Set the POL2 field to a new value. */
#define TPM_WR_POL_POL2(base, value) (TPM_RMW_POL(base, TPM_POL_POL2_MASK, TPM_POL_POL2(value)))
#define TPM_BWR_POL_POL2(base, value) (BME_BFI32(&TPM_POL_REG(base), ((uint32_t)(value) << TPM_POL_POL2_SHIFT), TPM_POL_POL2_SHIFT, TPM_POL_POL2_WIDTH))
/*@}*/

/*!
 * @name Register TPM_POL, field POL3[3] (RW)
 *
 * Values:
 * - 0 - The channel polarity is active high.
 * - 1 - The channel polarity is active low.
 */
/*@{*/
/*! @brief Read current value of the TPM_POL_POL3 field. */
#define TPM_RD_POL_POL3(base) ((TPM_POL_REG(base) & TPM_POL_POL3_MASK) >> TPM_POL_POL3_SHIFT)
#define TPM_BRD_POL_POL3(base) (BME_UBFX32(&TPM_POL_REG(base), TPM_POL_POL3_SHIFT, TPM_POL_POL3_WIDTH))

/*! @brief Set the POL3 field to a new value. */
#define TPM_WR_POL_POL3(base, value) (TPM_RMW_POL(base, TPM_POL_POL3_MASK, TPM_POL_POL3(value)))
#define TPM_BWR_POL_POL3(base, value) (BME_BFI32(&TPM_POL_REG(base), ((uint32_t)(value) << TPM_POL_POL3_SHIFT), TPM_POL_POL3_SHIFT, TPM_POL_POL3_WIDTH))
/*@}*/

/*!
 * @name Register TPM_POL, field POL4[4] (RW)
 *
 * Values:
 * - 0 - The channel polarity is active high
 * - 1 - The channel polarity is active low.
 */
/*@{*/
/*! @brief Read current value of the TPM_POL_POL4 field. */
#define TPM_RD_POL_POL4(base) ((TPM_POL_REG(base) & TPM_POL_POL4_MASK) >> TPM_POL_POL4_SHIFT)
#define TPM_BRD_POL_POL4(base) (BME_UBFX32(&TPM_POL_REG(base), TPM_POL_POL4_SHIFT, TPM_POL_POL4_WIDTH))

/*! @brief Set the POL4 field to a new value. */
#define TPM_WR_POL_POL4(base, value) (TPM_RMW_POL(base, TPM_POL_POL4_MASK, TPM_POL_POL4(value)))
#define TPM_BWR_POL_POL4(base, value) (BME_BFI32(&TPM_POL_REG(base), ((uint32_t)(value) << TPM_POL_POL4_SHIFT), TPM_POL_POL4_SHIFT, TPM_POL_POL4_WIDTH))
/*@}*/

/*!
 * @name Register TPM_POL, field POL5[5] (RW)
 *
 * Values:
 * - 0 - The channel polarity is active high.
 * - 1 - The channel polarity is active low.
 */
/*@{*/
/*! @brief Read current value of the TPM_POL_POL5 field. */
#define TPM_RD_POL_POL5(base) ((TPM_POL_REG(base) & TPM_POL_POL5_MASK) >> TPM_POL_POL5_SHIFT)
#define TPM_BRD_POL_POL5(base) (BME_UBFX32(&TPM_POL_REG(base), TPM_POL_POL5_SHIFT, TPM_POL_POL5_WIDTH))

/*! @brief Set the POL5 field to a new value. */
#define TPM_WR_POL_POL5(base, value) (TPM_RMW_POL(base, TPM_POL_POL5_MASK, TPM_POL_POL5(value)))
#define TPM_BWR_POL_POL5(base, value) (BME_BFI32(&TPM_POL_REG(base), ((uint32_t)(value) << TPM_POL_POL5_SHIFT), TPM_POL_POL5_SHIFT, TPM_POL_POL5_WIDTH))
/*@}*/

/*******************************************************************************
 * TPM_CONF - Configuration
 ******************************************************************************/

/*!
 * @brief TPM_CONF - Configuration (RW)
 *
 * Reset value: 0x00000000U
 *
 * This register selects the behavior in debug and wait modes and the use of an
 * external global time base.
 */
/*!
 * @name Constants and macros for entire TPM_CONF register
 */
/*@{*/
#define TPM_RD_CONF(base)        (TPM_CONF_REG(base))
#define TPM_WR_CONF(base, value) (TPM_CONF_REG(base) = (value))
#define TPM_RMW_CONF(base, mask, value) (TPM_WR_CONF(base, (TPM_RD_CONF(base) & ~(mask)) | (value)))
#define TPM_SET_CONF(base, value) (BME_OR32(&TPM_CONF_REG(base), (uint32_t)(value)))
#define TPM_CLR_CONF(base, value) (BME_AND32(&TPM_CONF_REG(base), (uint32_t)(~(value))))
#define TPM_TOG_CONF(base, value) (BME_XOR32(&TPM_CONF_REG(base), (uint32_t)(value)))
/*@}*/

/*
 * Constants & macros for individual TPM_CONF bitfields
 */

/*!
 * @name Register TPM_CONF, field DOZEEN[5] (RW)
 *
 * Configures the TPM behavior in wait mode.
 *
 * Values:
 * - 0 - Internal TPM counter continues in Doze mode.
 * - 1 - Internal TPM counter is paused and does not increment during Doze mode.
 *     Trigger inputs and input capture events are also ignored.
 */
/*@{*/
/*! @brief Read current value of the TPM_CONF_DOZEEN field. */
#define TPM_RD_CONF_DOZEEN(base) ((TPM_CONF_REG(base) & TPM_CONF_DOZEEN_MASK) >> TPM_CONF_DOZEEN_SHIFT)
#define TPM_BRD_CONF_DOZEEN(base) (BME_UBFX32(&TPM_CONF_REG(base), TPM_CONF_DOZEEN_SHIFT, TPM_CONF_DOZEEN_WIDTH))

/*! @brief Set the DOZEEN field to a new value. */
#define TPM_WR_CONF_DOZEEN(base, value) (TPM_RMW_CONF(base, TPM_CONF_DOZEEN_MASK, TPM_CONF_DOZEEN(value)))
#define TPM_BWR_CONF_DOZEEN(base, value) (BME_BFI32(&TPM_CONF_REG(base), ((uint32_t)(value) << TPM_CONF_DOZEEN_SHIFT), TPM_CONF_DOZEEN_SHIFT, TPM_CONF_DOZEEN_WIDTH))
/*@}*/

/*!
 * @name Register TPM_CONF, field DBGMODE[7:6] (RW)
 *
 * Configures the TPM behavior in debug mode. All other configurations are
 * reserved.
 *
 * Values:
 * - 00 - TPM counter is paused and does not increment during debug mode.
 *     Trigger inputs and input capture events are also ignored.
 * - 11 - TPM counter continues in debug mode.
 */
/*@{*/
/*! @brief Read current value of the TPM_CONF_DBGMODE field. */
#define TPM_RD_CONF_DBGMODE(base) ((TPM_CONF_REG(base) & TPM_CONF_DBGMODE_MASK) >> TPM_CONF_DBGMODE_SHIFT)
#define TPM_BRD_CONF_DBGMODE(base) (BME_UBFX32(&TPM_CONF_REG(base), TPM_CONF_DBGMODE_SHIFT, TPM_CONF_DBGMODE_WIDTH))

/*! @brief Set the DBGMODE field to a new value. */
#define TPM_WR_CONF_DBGMODE(base, value) (TPM_RMW_CONF(base, TPM_CONF_DBGMODE_MASK, TPM_CONF_DBGMODE(value)))
#define TPM_BWR_CONF_DBGMODE(base, value) (BME_BFI32(&TPM_CONF_REG(base), ((uint32_t)(value) << TPM_CONF_DBGMODE_SHIFT), TPM_CONF_DBGMODE_SHIFT, TPM_CONF_DBGMODE_WIDTH))
/*@}*/

/*!
 * @name Register TPM_CONF, field GTBSYNC[8] (RW)
 *
 * When enabled, the TPM counter is synchronized to the global time base. It
 * uses the global timebase enable, trigger and overflow to ensure the TPM counter
 * starts incrementing at the same time as the global timebase, stops incrementing
 * at the same time as the global timebase and is reset at the same time as the
 * global timebase. This field should only be changed when the TPM counter is
 * disabled.
 *
 * Values:
 * - 0 - Global timebase synchronization disabled.
 * - 1 - Global timebase synchronization enabled.
 */
/*@{*/
/*! @brief Read current value of the TPM_CONF_GTBSYNC field. */
#define TPM_RD_CONF_GTBSYNC(base) ((TPM_CONF_REG(base) & TPM_CONF_GTBSYNC_MASK) >> TPM_CONF_GTBSYNC_SHIFT)
#define TPM_BRD_CONF_GTBSYNC(base) (BME_UBFX32(&TPM_CONF_REG(base), TPM_CONF_GTBSYNC_SHIFT, TPM_CONF_GTBSYNC_WIDTH))

/*! @brief Set the GTBSYNC field to a new value. */
#define TPM_WR_CONF_GTBSYNC(base, value) (TPM_RMW_CONF(base, TPM_CONF_GTBSYNC_MASK, TPM_CONF_GTBSYNC(value)))
#define TPM_BWR_CONF_GTBSYNC(base, value) (BME_BFI32(&TPM_CONF_REG(base), ((uint32_t)(value) << TPM_CONF_GTBSYNC_SHIFT), TPM_CONF_GTBSYNC_SHIFT, TPM_CONF_GTBSYNC_WIDTH))
/*@}*/

/*!
 * @name Register TPM_CONF, field GTBEEN[9] (RW)
 *
 * Configures the TPM to use an externally generated global time base counter.
 * When an externally generated timebase is used, the internal TPM counter is not
 * used by the channels but can be used to generate a periodic interruptor DMA
 * request using the Modulo register and timer overflow flag.
 *
 * Values:
 * - 0 - All channels use the internally generated TPM counter as their timebase
 * - 1 - All channels use an externally generated global timebase as their
 *     timebase
 */
/*@{*/
/*! @brief Read current value of the TPM_CONF_GTBEEN field. */
#define TPM_RD_CONF_GTBEEN(base) ((TPM_CONF_REG(base) & TPM_CONF_GTBEEN_MASK) >> TPM_CONF_GTBEEN_SHIFT)
#define TPM_BRD_CONF_GTBEEN(base) (BME_UBFX32(&TPM_CONF_REG(base), TPM_CONF_GTBEEN_SHIFT, TPM_CONF_GTBEEN_WIDTH))

/*! @brief Set the GTBEEN field to a new value. */
#define TPM_WR_CONF_GTBEEN(base, value) (TPM_RMW_CONF(base, TPM_CONF_GTBEEN_MASK, TPM_CONF_GTBEEN(value)))
#define TPM_BWR_CONF_GTBEEN(base, value) (BME_BFI32(&TPM_CONF_REG(base), ((uint32_t)(value) << TPM_CONF_GTBEEN_SHIFT), TPM_CONF_GTBEEN_SHIFT, TPM_CONF_GTBEEN_WIDTH))
/*@}*/

/*!
 * @name Register TPM_CONF, field CSOT[16] (RW)
 *
 * When set, the TPM counter will not start incrementing after it is enabled
 * until a rising edge on the selected trigger input is detected. If the TPM counter
 * is stopped due to an overflow, a rising edge on the selected trigger input
 * will also cause the TPM counter to start incrementing again. The trigger input
 * is ignored if the TPM counter is paused during debug mode or doze mode. This
 * field should only be changed when the TPM counter is disabled.
 *
 * Values:
 * - 0 - TPM counter starts to increment immediately, once it is enabled.
 * - 1 - TPM counter only starts to increment when it a rising edge on the
 *     selected input trigger is detected, after it has been enabled or after it has
 *     stopped due to overflow.
 */
/*@{*/
/*! @brief Read current value of the TPM_CONF_CSOT field. */
#define TPM_RD_CONF_CSOT(base) ((TPM_CONF_REG(base) & TPM_CONF_CSOT_MASK) >> TPM_CONF_CSOT_SHIFT)
#define TPM_BRD_CONF_CSOT(base) (BME_UBFX32(&TPM_CONF_REG(base), TPM_CONF_CSOT_SHIFT, TPM_CONF_CSOT_WIDTH))

/*! @brief Set the CSOT field to a new value. */
#define TPM_WR_CONF_CSOT(base, value) (TPM_RMW_CONF(base, TPM_CONF_CSOT_MASK, TPM_CONF_CSOT(value)))
#define TPM_BWR_CONF_CSOT(base, value) (BME_BFI32(&TPM_CONF_REG(base), ((uint32_t)(value) << TPM_CONF_CSOT_SHIFT), TPM_CONF_CSOT_SHIFT, TPM_CONF_CSOT_WIDTH))
/*@}*/

/*!
 * @name Register TPM_CONF, field CSOO[17] (RW)
 *
 * When set, the TPM counter will stop incrementing once the counter equals the
 * MOD value and incremented (this also sets the TOF). Reloading the counter with
 * 0 due to writing to the counter register or due to a trigger input does not
 * cause the counter to stop incrementing. Once the counter has stopped
 * incrementing, the counter will not start incrementing unless it is disabled and then
 * enabled again, or a rising edge on the selected trigger input is detected when
 * CSOT set. This field should only be changed when the TPM counter is disabled.
 *
 * Values:
 * - 0 - TPM counter continues incrementing or decrementing after overflow
 * - 1 - TPM counter stops incrementing or decrementing after overflow.
 */
/*@{*/
/*! @brief Read current value of the TPM_CONF_CSOO field. */
#define TPM_RD_CONF_CSOO(base) ((TPM_CONF_REG(base) & TPM_CONF_CSOO_MASK) >> TPM_CONF_CSOO_SHIFT)
#define TPM_BRD_CONF_CSOO(base) (BME_UBFX32(&TPM_CONF_REG(base), TPM_CONF_CSOO_SHIFT, TPM_CONF_CSOO_WIDTH))

/*! @brief Set the CSOO field to a new value. */
#define TPM_WR_CONF_CSOO(base, value) (TPM_RMW_CONF(base, TPM_CONF_CSOO_MASK, TPM_CONF_CSOO(value)))
#define TPM_BWR_CONF_CSOO(base, value) (BME_BFI32(&TPM_CONF_REG(base), ((uint32_t)(value) << TPM_CONF_CSOO_SHIFT), TPM_CONF_CSOO_SHIFT, TPM_CONF_CSOO_WIDTH))
/*@}*/

/*!
 * @name Register TPM_CONF, field CROT[18] (RW)
 *
 * When set, the TPM counter will reload with 0 (and initialize PWM outputs to
 * their default value) when a rising edge is detected on the selected trigger
 * input. The trigger input is ignored if the TPM counter is paused during debug
 * mode or doze mode. This field should only be changed when the TPM counter is
 * disabled.
 *
 * Values:
 * - 0 - Counter is not reloaded due to a rising edge on the selected input
 *     trigger
 * - 1 - Counter is reloaded when a rising edge is detected on the selected
 *     input trigger
 */
/*@{*/
/*! @brief Read current value of the TPM_CONF_CROT field. */
#define TPM_RD_CONF_CROT(base) ((TPM_CONF_REG(base) & TPM_CONF_CROT_MASK) >> TPM_CONF_CROT_SHIFT)
#define TPM_BRD_CONF_CROT(base) (BME_UBFX32(&TPM_CONF_REG(base), TPM_CONF_CROT_SHIFT, TPM_CONF_CROT_WIDTH))

/*! @brief Set the CROT field to a new value. */
#define TPM_WR_CONF_CROT(base, value) (TPM_RMW_CONF(base, TPM_CONF_CROT_MASK, TPM_CONF_CROT(value)))
#define TPM_BWR_CONF_CROT(base, value) (BME_BFI32(&TPM_CONF_REG(base), ((uint32_t)(value) << TPM_CONF_CROT_SHIFT), TPM_CONF_CROT_SHIFT, TPM_CONF_CROT_WIDTH))
/*@}*/

/*!
 * @name Register TPM_CONF, field CPOT[19] (RW)
 *
 * When enabled, the counter will pause incrementing while the trigger remains
 * asserted (level sensitive). This field should only be changed when the TPM
 * counter is disabled.
 */
/*@{*/
/*! @brief Read current value of the TPM_CONF_CPOT field. */
#define TPM_RD_CONF_CPOT(base) ((TPM_CONF_REG(base) & TPM_CONF_CPOT_MASK) >> TPM_CONF_CPOT_SHIFT)
#define TPM_BRD_CONF_CPOT(base) (BME_UBFX32(&TPM_CONF_REG(base), TPM_CONF_CPOT_SHIFT, TPM_CONF_CPOT_WIDTH))

/*! @brief Set the CPOT field to a new value. */
#define TPM_WR_CONF_CPOT(base, value) (TPM_RMW_CONF(base, TPM_CONF_CPOT_MASK, TPM_CONF_CPOT(value)))
#define TPM_BWR_CONF_CPOT(base, value) (BME_BFI32(&TPM_CONF_REG(base), ((uint32_t)(value) << TPM_CONF_CPOT_SHIFT), TPM_CONF_CPOT_SHIFT, TPM_CONF_CPOT_WIDTH))
/*@}*/

/*!
 * @name Register TPM_CONF, field TRGPOL[22] (RW)
 *
 * Selects the polarity of the external trigger source. This field should only
 * be changed when the TPM counter is disabled.
 *
 * Values:
 * - 0 - Trigger is active high.
 * - 1 - Trigger is active low.
 */
/*@{*/
/*! @brief Read current value of the TPM_CONF_TRGPOL field. */
#define TPM_RD_CONF_TRGPOL(base) ((TPM_CONF_REG(base) & TPM_CONF_TRGPOL_MASK) >> TPM_CONF_TRGPOL_SHIFT)
#define TPM_BRD_CONF_TRGPOL(base) (BME_UBFX32(&TPM_CONF_REG(base), TPM_CONF_TRGPOL_SHIFT, TPM_CONF_TRGPOL_WIDTH))

/*! @brief Set the TRGPOL field to a new value. */
#define TPM_WR_CONF_TRGPOL(base, value) (TPM_RMW_CONF(base, TPM_CONF_TRGPOL_MASK, TPM_CONF_TRGPOL(value)))
#define TPM_BWR_CONF_TRGPOL(base, value) (BME_BFI32(&TPM_CONF_REG(base), ((uint32_t)(value) << TPM_CONF_TRGPOL_SHIFT), TPM_CONF_TRGPOL_SHIFT, TPM_CONF_TRGPOL_WIDTH))
/*@}*/

/*!
 * @name Register TPM_CONF, field TRGSRC[23] (RW)
 *
 * Selects between internal (channel pin input capture) or external trigger
 * sources. When selecting an internal trigger, the channel selected should be
 * configured for input capture. Only a rising edge input capture can be used to
 * initially start the counter using the CSOT configuration; either rising edge or
 * falling edge input capture can be used to reload the counter using the CROT
 * configuration; and the state of the channel input pin is used to pause the counter
 * using the CPOT configuration. The channel polarity register can be used to
 * invert the polarity of the channel input pins. This field should only be changed
 * when the TPM counter is disabled.
 *
 * Values:
 * - 0 - Trigger source selected by TRGSEL is external.
 * - 1 - Trigger source selected by TRGSEL is internal (channel pin input
 *     capture).
 */
/*@{*/
/*! @brief Read current value of the TPM_CONF_TRGSRC field. */
#define TPM_RD_CONF_TRGSRC(base) ((TPM_CONF_REG(base) & TPM_CONF_TRGSRC_MASK) >> TPM_CONF_TRGSRC_SHIFT)
#define TPM_BRD_CONF_TRGSRC(base) (BME_UBFX32(&TPM_CONF_REG(base), TPM_CONF_TRGSRC_SHIFT, TPM_CONF_TRGSRC_WIDTH))

/*! @brief Set the TRGSRC field to a new value. */
#define TPM_WR_CONF_TRGSRC(base, value) (TPM_RMW_CONF(base, TPM_CONF_TRGSRC_MASK, TPM_CONF_TRGSRC(value)))
#define TPM_BWR_CONF_TRGSRC(base, value) (BME_BFI32(&TPM_CONF_REG(base), ((uint32_t)(value) << TPM_CONF_TRGSRC_SHIFT), TPM_CONF_TRGSRC_SHIFT, TPM_CONF_TRGSRC_WIDTH))
/*@}*/

/*!
 * @name Register TPM_CONF, field TRGSEL[27:24] (RW)
 *
 * Selects the input trigger to use for starting, reloading and/or pausing the
 * counter. The source of the trigger (external or internal to the TPM) is
 * configured by the TRGSRC field. This field should only be changed when the TPM
 * counter is disabled. Refer to the chip configuration section for available external
 * trigger options. The available internal trigger sources are listed below.
 *
 * Values:
 * - 0001 - Channel 0 pin input capture
 * - 0010 - Channel 1 pin input capture
 * - 0011 - Channel 0 or Channel 1 pin input capture
 * - 0100 - Channel 2 pin input capture
 * - 0101 - Channel 0 or Channel 2 pin input capture
 * - 0110 - Channel 1 or Channel 2 pin input capture
 * - 0111 - Channel 0 or Channel 1 or Channel 2 pin input capture
 * - 1000 - Channel 3 pin input capture
 * - 1001 - Channel 0 or Channel 3 pin input capture
 * - 1010 - Channel 1 or Channel 3 pin input capture
 * - 1011 - Channel 0 or Channel 1 or Channel 3 pin input capture
 * - 1100 - Channel 2 or Channel 3 pin input capture
 * - 1101 - Channel 0 or Channel 2 or Channel 3 pin input capture
 * - 1110 - Channel 1 or Channel 2 or Channel 3 pin input capture
 * - 1111 - Channel 0 or Channel 1 or Channel 2 or Channel 3 pin input capture
 */
/*@{*/
/*! @brief Read current value of the TPM_CONF_TRGSEL field. */
#define TPM_RD_CONF_TRGSEL(base) ((TPM_CONF_REG(base) & TPM_CONF_TRGSEL_MASK) >> TPM_CONF_TRGSEL_SHIFT)
#define TPM_BRD_CONF_TRGSEL(base) (BME_UBFX32(&TPM_CONF_REG(base), TPM_CONF_TRGSEL_SHIFT, TPM_CONF_TRGSEL_WIDTH))

/*! @brief Set the TRGSEL field to a new value. */
#define TPM_WR_CONF_TRGSEL(base, value) (TPM_RMW_CONF(base, TPM_CONF_TRGSEL_MASK, TPM_CONF_TRGSEL(value)))
#define TPM_BWR_CONF_TRGSEL(base, value) (BME_BFI32(&TPM_CONF_REG(base), ((uint32_t)(value) << TPM_CONF_TRGSEL_SHIFT), TPM_CONF_TRGSEL_SHIFT, TPM_CONF_TRGSEL_WIDTH))
/*@}*/

/*
 * MKL27Z644 UART
 *
 * Serial Communication Interface
 *
 * Registers defined in this header file:
 * - UART_BDH - UART Baud Rate Registers: High
 * - UART_BDL - UART Baud Rate Registers: Low
 * - UART_C1 - UART Control Register 1
 * - UART_C2 - UART Control Register 2
 * - UART_S1 - UART Status Register 1
 * - UART_S2 - UART Status Register 2
 * - UART_C3 - UART Control Register 3
 * - UART_D - UART Data Register
 * - UART_MA1 - UART Match Address Registers 1
 * - UART_MA2 - UART Match Address Registers 2
 * - UART_C4 - UART Control Register 4
 * - UART_C5 - UART Control Register 5
 * - UART_C7816 - UART 7816 Control Register
 * - UART_IE7816 - UART 7816 Interrupt Enable Register
 * - UART_IS7816 - UART 7816 Interrupt Status Register
 * - UART_WP7816 - UART 7816 Wait Parameter Register
 * - UART_WN7816 - UART 7816 Wait N Register
 * - UART_WF7816 - UART 7816 Wait FD Register
 * - UART_ET7816 - UART 7816 Error Threshold Register
 * - UART_TL7816 - UART 7816 Transmit Length Register
 * - UART_AP7816A_T0 - UART 7816 ATR Duration Timer Register A
 * - UART_AP7816B_T0 - UART 7816 ATR Duration Timer Register B
 * - UART_WP7816A_T0 - UART 7816 Wait Parameter Register A
 * - UART_WP7816B_T0 - UART 7816 Wait Parameter Register B
 * - UART_WP7816A_T1 - UART 7816 Wait Parameter Register A
 * - UART_WP7816B_T1 - UART 7816 Wait Parameter Register B
 * - UART_WGP7816_T1 - UART 7816 Wait and Guard Parameter Register
 * - UART_WP7816C_T1 - UART 7816 Wait Parameter Register C
 */

#define UART_INSTANCE_COUNT (3U) /*!< Number of instances of the UART module. */
#define UART2_IDX (2U) /*!< Instance number for UART2. */

/*******************************************************************************
 * UART_BDH - UART Baud Rate Registers: High
 ******************************************************************************/

/*!
 * @brief UART_BDH - UART Baud Rate Registers: High (RW)
 *
 * Reset value: 0x00U
 *
 * This register, along with the BDL register, controls the prescale divisor for
 * UART baud rate generation. To update the 13-bit baud rate setting
 * (SBR[12:0]), first write to BDH to buffer the high half of the new value and then write
 * to BDL. The working value in BDH does not change until BDL is written. BDL is
 * reset to a nonzero value, but after reset, the baud rate generator remains
 * disabled until the first time the receiver or transmitter is enabled, that is,
 * when C2[RE] or C2[TE] is set.
 */
/*!
 * @name Constants and macros for entire UART_BDH register
 */
/*@{*/
#define UART_RD_BDH(base)        (UART_BDH_REG(base))
#define UART_WR_BDH(base, value) (UART_BDH_REG(base) = (value))
#define UART_RMW_BDH(base, mask, value) (UART_WR_BDH(base, (UART_RD_BDH(base) & ~(mask)) | (value)))
#define UART_SET_BDH(base, value) (BME_OR8(&UART_BDH_REG(base), (uint8_t)(value)))
#define UART_CLR_BDH(base, value) (BME_AND8(&UART_BDH_REG(base), (uint8_t)(~(value))))
#define UART_TOG_BDH(base, value) (BME_XOR8(&UART_BDH_REG(base), (uint8_t)(value)))
/*@}*/

/*
 * Constants & macros for individual UART_BDH bitfields
 */

/*!
 * @name Register UART_BDH, field SBR[4:0] (RW)
 *
 * The baud rate for the UART is determined by the 13 SBR fields. See Baud rate
 * generation for details. The baud rate generator is disabled until C2[TE] or
 * C2[RE] is set for the first time after reset.The baud rate generator is disabled
 * when SBR = 0. Writing to BDH has no effect without writing to BDL, because
 * writing to BDH puts the data in a temporary location until BDL is written.
 */
/*@{*/
/*! @brief Read current value of the UART_BDH_SBR field. */
#define UART_RD_BDH_SBR(base) ((UART_BDH_REG(base) & UART_BDH_SBR_MASK) >> UART_BDH_SBR_SHIFT)
#define UART_BRD_BDH_SBR(base) (BME_UBFX8(&UART_BDH_REG(base), UART_BDH_SBR_SHIFT, UART_BDH_SBR_WIDTH))

/*! @brief Set the SBR field to a new value. */
#define UART_WR_BDH_SBR(base, value) (UART_RMW_BDH(base, UART_BDH_SBR_MASK, UART_BDH_SBR(value)))
#define UART_BWR_BDH_SBR(base, value) (BME_BFI8(&UART_BDH_REG(base), ((uint8_t)(value) << UART_BDH_SBR_SHIFT), UART_BDH_SBR_SHIFT, UART_BDH_SBR_WIDTH))
/*@}*/

/*!
 * @name Register UART_BDH, field RXEDGIE[6] (RW)
 *
 * Enables the receive input active edge, RXEDGIF, to generate interrupt
 * requests.
 *
 * Values:
 * - 0 - Hardware interrupts from RXEDGIF disabled using polling.
 * - 1 - RXEDGIF interrupt request enabled.
 */
/*@{*/
/*! @brief Read current value of the UART_BDH_RXEDGIE field. */
#define UART_RD_BDH_RXEDGIE(base) ((UART_BDH_REG(base) & UART_BDH_RXEDGIE_MASK) >> UART_BDH_RXEDGIE_SHIFT)
#define UART_BRD_BDH_RXEDGIE(base) (BME_UBFX8(&UART_BDH_REG(base), UART_BDH_RXEDGIE_SHIFT, UART_BDH_RXEDGIE_WIDTH))

/*! @brief Set the RXEDGIE field to a new value. */
#define UART_WR_BDH_RXEDGIE(base, value) (UART_RMW_BDH(base, UART_BDH_RXEDGIE_MASK, UART_BDH_RXEDGIE(value)))
#define UART_BWR_BDH_RXEDGIE(base, value) (BME_BFI8(&UART_BDH_REG(base), ((uint8_t)(value) << UART_BDH_RXEDGIE_SHIFT), UART_BDH_RXEDGIE_SHIFT, UART_BDH_RXEDGIE_WIDTH))
/*@}*/

/*******************************************************************************
 * UART_BDL - UART Baud Rate Registers: Low
 ******************************************************************************/

/*!
 * @brief UART_BDL - UART Baud Rate Registers: Low (RW)
 *
 * Reset value: 0x04U
 *
 * This register, along with the BDH register, controls the prescale divisor for
 * UART baud rate generation. To update the 13-bit baud rate setting, SBR[12:0],
 * first write to BDH to buffer the high half of the new value and then write to
 * BDL. The working value in BDH does not change until BDL is written. BDL is
 * reset to a nonzero value, but after reset, the baud rate generator remains
 * disabled until the first time the receiver or transmitter is enabled, that is, when
 * C2[RE] or C2[TE] is set.
 */
/*!
 * @name Constants and macros for entire UART_BDL register
 */
/*@{*/
#define UART_RD_BDL(base)        (UART_BDL_REG(base))
#define UART_WR_BDL(base, value) (UART_BDL_REG(base) = (value))
#define UART_RMW_BDL(base, mask, value) (UART_WR_BDL(base, (UART_RD_BDL(base) & ~(mask)) | (value)))
#define UART_SET_BDL(base, value) (BME_OR8(&UART_BDL_REG(base), (uint8_t)(value)))
#define UART_CLR_BDL(base, value) (BME_AND8(&UART_BDL_REG(base), (uint8_t)(~(value))))
#define UART_TOG_BDL(base, value) (BME_XOR8(&UART_BDL_REG(base), (uint8_t)(value)))
/*@}*/

/*******************************************************************************
 * UART_C1 - UART Control Register 1
 ******************************************************************************/

/*!
 * @brief UART_C1 - UART Control Register 1 (RW)
 *
 * Reset value: 0x00U
 *
 * This read/write register controls various optional features of the UART
 * system.
 */
/*!
 * @name Constants and macros for entire UART_C1 register
 */
/*@{*/
#define UART_RD_C1(base)         (UART_C1_REG(base))
#define UART_WR_C1(base, value)  (UART_C1_REG(base) = (value))
#define UART_RMW_C1(base, mask, value) (UART_WR_C1(base, (UART_RD_C1(base) & ~(mask)) | (value)))
#define UART_SET_C1(base, value) (BME_OR8(&UART_C1_REG(base), (uint8_t)(value)))
#define UART_CLR_C1(base, value) (BME_AND8(&UART_C1_REG(base), (uint8_t)(~(value))))
#define UART_TOG_C1(base, value) (BME_XOR8(&UART_C1_REG(base), (uint8_t)(value)))
/*@}*/

/*
 * Constants & macros for individual UART_C1 bitfields
 */

/*!
 * @name Register UART_C1, field PT[0] (RW)
 *
 * Determines whether the UART generates and checks for even parity or odd
 * parity. With even parity, an even number of 1s clears the parity bit and an odd
 * number of 1s sets the parity bit. With odd parity, an odd number of 1s clears the
 * parity bit and an even number of 1s sets the parity bit. This field must be
 * cleared when C7816[ISO_7816E] is set/enabled.
 *
 * Values:
 * - 0 - Even parity.
 * - 1 - Odd parity.
 */
/*@{*/
/*! @brief Read current value of the UART_C1_PT field. */
#define UART_RD_C1_PT(base)  ((UART_C1_REG(base) & UART_C1_PT_MASK) >> UART_C1_PT_SHIFT)
#define UART_BRD_C1_PT(base) (BME_UBFX8(&UART_C1_REG(base), UART_C1_PT_SHIFT, UART_C1_PT_WIDTH))

/*! @brief Set the PT field to a new value. */
#define UART_WR_C1_PT(base, value) (UART_RMW_C1(base, UART_C1_PT_MASK, UART_C1_PT(value)))
#define UART_BWR_C1_PT(base, value) (BME_BFI8(&UART_C1_REG(base), ((uint8_t)(value) << UART_C1_PT_SHIFT), UART_C1_PT_SHIFT, UART_C1_PT_WIDTH))
/*@}*/

/*!
 * @name Register UART_C1, field PE[1] (RW)
 *
 * Enables the parity function. When parity is enabled, parity function inserts
 * a parity bit in the bit position immediately preceding the stop bit. This
 * field must be set when C7816[ISO_7816E] is set/enabled.
 *
 * Values:
 * - 0 - Parity function disabled.
 * - 1 - Parity function enabled.
 */
/*@{*/
/*! @brief Read current value of the UART_C1_PE field. */
#define UART_RD_C1_PE(base)  ((UART_C1_REG(base) & UART_C1_PE_MASK) >> UART_C1_PE_SHIFT)
#define UART_BRD_C1_PE(base) (BME_UBFX8(&UART_C1_REG(base), UART_C1_PE_SHIFT, UART_C1_PE_WIDTH))

/*! @brief Set the PE field to a new value. */
#define UART_WR_C1_PE(base, value) (UART_RMW_C1(base, UART_C1_PE_MASK, UART_C1_PE(value)))
#define UART_BWR_C1_PE(base, value) (BME_BFI8(&UART_C1_REG(base), ((uint8_t)(value) << UART_C1_PE_SHIFT), UART_C1_PE_SHIFT, UART_C1_PE_WIDTH))
/*@}*/

/*!
 * @name Register UART_C1, field ILT[2] (RW)
 *
 * Determines when the receiver starts counting logic 1s as idle character bits.
 * The count begins either after a valid start bit or after the stop bit. If the
 * count begins after the start bit, then a string of logic 1s preceding the
 * stop bit can cause false recognition of an idle character. Beginning the count
 * after the stop bit avoids false idle character recognition, but requires
 * properly synchronized transmissions. In case the UART is programmed with ILT = 1, a
 * logic of 1'b0 is automatically shifted after a received stop bit, therefore
 * resetting the idle count. In case the UART is programmed for IDLE line wakeup
 * (RWU = 1 and WAKE = 0), ILT has no effect on when the receiver starts counting
 * logic 1s as idle character bits. In idle line wakeup, an idle character is
 * recognized at anytime the receiver sees 10, 11, or 12 1s depending on the M, PE,
 * and C4[M10] fields.
 *
 * Values:
 * - 0 - Idle character bit count starts after start bit.
 * - 1 - Idle character bit count starts after stop bit.
 */
/*@{*/
/*! @brief Read current value of the UART_C1_ILT field. */
#define UART_RD_C1_ILT(base) ((UART_C1_REG(base) & UART_C1_ILT_MASK) >> UART_C1_ILT_SHIFT)
#define UART_BRD_C1_ILT(base) (BME_UBFX8(&UART_C1_REG(base), UART_C1_ILT_SHIFT, UART_C1_ILT_WIDTH))

/*! @brief Set the ILT field to a new value. */
#define UART_WR_C1_ILT(base, value) (UART_RMW_C1(base, UART_C1_ILT_MASK, UART_C1_ILT(value)))
#define UART_BWR_C1_ILT(base, value) (BME_BFI8(&UART_C1_REG(base), ((uint8_t)(value) << UART_C1_ILT_SHIFT), UART_C1_ILT_SHIFT, UART_C1_ILT_WIDTH))
/*@}*/

/*!
 * @name Register UART_C1, field WAKE[3] (RW)
 *
 * Determines which condition wakes the UART: Address mark in the most
 * significant bit position of a received data character, or An idle condition on the
 * receive pin input signal.
 *
 * Values:
 * - 0 - Idle line wakeup.
 * - 1 - Address mark wakeup.
 */
/*@{*/
/*! @brief Read current value of the UART_C1_WAKE field. */
#define UART_RD_C1_WAKE(base) ((UART_C1_REG(base) & UART_C1_WAKE_MASK) >> UART_C1_WAKE_SHIFT)
#define UART_BRD_C1_WAKE(base) (BME_UBFX8(&UART_C1_REG(base), UART_C1_WAKE_SHIFT, UART_C1_WAKE_WIDTH))

/*! @brief Set the WAKE field to a new value. */
#define UART_WR_C1_WAKE(base, value) (UART_RMW_C1(base, UART_C1_WAKE_MASK, UART_C1_WAKE(value)))
#define UART_BWR_C1_WAKE(base, value) (BME_BFI8(&UART_C1_REG(base), ((uint8_t)(value) << UART_C1_WAKE_SHIFT), UART_C1_WAKE_SHIFT, UART_C1_WAKE_WIDTH))
/*@}*/

/*!
 * @name Register UART_C1, field M[4] (RW)
 *
 * This field must be set when C7816[ISO_7816E] is set/enabled.
 *
 * Values:
 * - 0 - Normal-start + 8 data bits (MSB/LSB first as determined by MSBF) + stop.
 * - 1 - Use-start + 9 data bits (MSB/LSB first as determined by MSBF) + stop.
 */
/*@{*/
/*! @brief Read current value of the UART_C1_M field. */
#define UART_RD_C1_M(base)   ((UART_C1_REG(base) & UART_C1_M_MASK) >> UART_C1_M_SHIFT)
#define UART_BRD_C1_M(base)  (BME_UBFX8(&UART_C1_REG(base), UART_C1_M_SHIFT, UART_C1_M_WIDTH))

/*! @brief Set the M field to a new value. */
#define UART_WR_C1_M(base, value) (UART_RMW_C1(base, UART_C1_M_MASK, UART_C1_M(value)))
#define UART_BWR_C1_M(base, value) (BME_BFI8(&UART_C1_REG(base), ((uint8_t)(value) << UART_C1_M_SHIFT), UART_C1_M_SHIFT, UART_C1_M_WIDTH))
/*@}*/

/*!
 * @name Register UART_C1, field RSRC[5] (RW)
 *
 * This field has no meaning or effect unless the LOOPS field is set. When LOOPS
 * is set, the RSRC field determines the source for the receiver shift register
 * input.
 *
 * Values:
 * - 0 - Selects internal loop back mode. The receiver input is internally
 *     connected to transmitter output.
 * - 1 - Single wire UART mode where the receiver input is connected to the
 *     transmit pin input signal.
 */
/*@{*/
/*! @brief Read current value of the UART_C1_RSRC field. */
#define UART_RD_C1_RSRC(base) ((UART_C1_REG(base) & UART_C1_RSRC_MASK) >> UART_C1_RSRC_SHIFT)
#define UART_BRD_C1_RSRC(base) (BME_UBFX8(&UART_C1_REG(base), UART_C1_RSRC_SHIFT, UART_C1_RSRC_WIDTH))

/*! @brief Set the RSRC field to a new value. */
#define UART_WR_C1_RSRC(base, value) (UART_RMW_C1(base, UART_C1_RSRC_MASK, UART_C1_RSRC(value)))
#define UART_BWR_C1_RSRC(base, value) (BME_BFI8(&UART_C1_REG(base), ((uint8_t)(value) << UART_C1_RSRC_SHIFT), UART_C1_RSRC_SHIFT, UART_C1_RSRC_WIDTH))
/*@}*/

/*!
 * @name Register UART_C1, field LOOPS[7] (RW)
 *
 * When LOOPS is set, the RxD pin is disconnected from the UART and the
 * transmitter output is internally connected to the receiver input. The transmitter and
 * the receiver must be enabled to use the loop function.
 *
 * Values:
 * - 0 - Normal operation.
 * - 1 - Loop mode where transmitter output is internally connected to receiver
 *     input. The receiver input is determined by RSRC.
 */
/*@{*/
/*! @brief Read current value of the UART_C1_LOOPS field. */
#define UART_RD_C1_LOOPS(base) ((UART_C1_REG(base) & UART_C1_LOOPS_MASK) >> UART_C1_LOOPS_SHIFT)
#define UART_BRD_C1_LOOPS(base) (BME_UBFX8(&UART_C1_REG(base), UART_C1_LOOPS_SHIFT, UART_C1_LOOPS_WIDTH))

/*! @brief Set the LOOPS field to a new value. */
#define UART_WR_C1_LOOPS(base, value) (UART_RMW_C1(base, UART_C1_LOOPS_MASK, UART_C1_LOOPS(value)))
#define UART_BWR_C1_LOOPS(base, value) (BME_BFI8(&UART_C1_REG(base), ((uint8_t)(value) << UART_C1_LOOPS_SHIFT), UART_C1_LOOPS_SHIFT, UART_C1_LOOPS_WIDTH))
/*@}*/

/*******************************************************************************
 * UART_C2 - UART Control Register 2
 ******************************************************************************/

/*!
 * @brief UART_C2 - UART Control Register 2 (RW)
 *
 * Reset value: 0x00U
 *
 * This register can be read or written at any time.
 */
/*!
 * @name Constants and macros for entire UART_C2 register
 */
/*@{*/
#define UART_RD_C2(base)         (UART_C2_REG(base))
#define UART_WR_C2(base, value)  (UART_C2_REG(base) = (value))
#define UART_RMW_C2(base, mask, value) (UART_WR_C2(base, (UART_RD_C2(base) & ~(mask)) | (value)))
#define UART_SET_C2(base, value) (BME_OR8(&UART_C2_REG(base), (uint8_t)(value)))
#define UART_CLR_C2(base, value) (BME_AND8(&UART_C2_REG(base), (uint8_t)(~(value))))
#define UART_TOG_C2(base, value) (BME_XOR8(&UART_C2_REG(base), (uint8_t)(value)))
/*@}*/

/*
 * Constants & macros for individual UART_C2 bitfields
 */

/*!
 * @name Register UART_C2, field SBK[0] (RW)
 *
 * Toggling SBK sends one break character from the following: See Transmitting
 * break characters for the number of logic 0s for the different configurations.
 * Toggling implies clearing the SBK field before the break character has finished
 * transmitting. As long as SBK is set, the transmitter continues to send
 * complete break characters (10, 11, or 12 bits, or 13 or 14 bits). Ensure that C2[TE]
 * is asserted atleast 1 clock before assertion of this bit. 10, 11, or 12 logic
 * 0s if S2[BRK13] is cleared 13 or 14 logic 0s if S2[BRK13] is set. This field
 * must be cleared when C7816[ISO_7816E] is set.
 *
 * Values:
 * - 0 - Normal transmitter operation.
 * - 1 - Queue break characters to be sent.
 */
/*@{*/
/*! @brief Read current value of the UART_C2_SBK field. */
#define UART_RD_C2_SBK(base) ((UART_C2_REG(base) & UART_C2_SBK_MASK) >> UART_C2_SBK_SHIFT)
#define UART_BRD_C2_SBK(base) (BME_UBFX8(&UART_C2_REG(base), UART_C2_SBK_SHIFT, UART_C2_SBK_WIDTH))

/*! @brief Set the SBK field to a new value. */
#define UART_WR_C2_SBK(base, value) (UART_RMW_C2(base, UART_C2_SBK_MASK, UART_C2_SBK(value)))
#define UART_BWR_C2_SBK(base, value) (BME_BFI8(&UART_C2_REG(base), ((uint8_t)(value) << UART_C2_SBK_SHIFT), UART_C2_SBK_SHIFT, UART_C2_SBK_WIDTH))
/*@}*/

/*!
 * @name Register UART_C2, field RWU[1] (RW)
 *
 * This field can be set to place the UART receiver in a standby state. RWU
 * automatically clears when an RWU event occurs, that is, an IDLE event when
 * C1[WAKE] is clear or an address match when C1[WAKE] is set. This field must be
 * cleared when C7816[ISO_7816E] is set. RWU must be set only with C1[WAKE] = 0 (wakeup
 * on idle) if the channel is currently not idle. This can be determined by
 * S2[RAF]. If the flag is set to wake up an IDLE event and the channel is already
 * idle, it is possible that the UART will discard data. This is because the data
 * must be received after an IDLE is detected before IDLE is allowed to reasserted.
 *
 * Values:
 * - 0 - Normal operation.
 * - 1 - RWU enables the wakeup function and inhibits further receiver interrupt
 *     requests. Normally, hardware wakes the receiver by automatically clearing
 *     RWU.
 */
/*@{*/
/*! @brief Read current value of the UART_C2_RWU field. */
#define UART_RD_C2_RWU(base) ((UART_C2_REG(base) & UART_C2_RWU_MASK) >> UART_C2_RWU_SHIFT)
#define UART_BRD_C2_RWU(base) (BME_UBFX8(&UART_C2_REG(base), UART_C2_RWU_SHIFT, UART_C2_RWU_WIDTH))

/*! @brief Set the RWU field to a new value. */
#define UART_WR_C2_RWU(base, value) (UART_RMW_C2(base, UART_C2_RWU_MASK, UART_C2_RWU(value)))
#define UART_BWR_C2_RWU(base, value) (BME_BFI8(&UART_C2_REG(base), ((uint8_t)(value) << UART_C2_RWU_SHIFT), UART_C2_RWU_SHIFT, UART_C2_RWU_WIDTH))
/*@}*/

/*!
 * @name Register UART_C2, field RE[2] (RW)
 *
 * Enables the UART receiver.
 *
 * Values:
 * - 0 - Receiver off.
 * - 1 - Receiver on.
 */
/*@{*/
/*! @brief Read current value of the UART_C2_RE field. */
#define UART_RD_C2_RE(base)  ((UART_C2_REG(base) & UART_C2_RE_MASK) >> UART_C2_RE_SHIFT)
#define UART_BRD_C2_RE(base) (BME_UBFX8(&UART_C2_REG(base), UART_C2_RE_SHIFT, UART_C2_RE_WIDTH))

/*! @brief Set the RE field to a new value. */
#define UART_WR_C2_RE(base, value) (UART_RMW_C2(base, UART_C2_RE_MASK, UART_C2_RE(value)))
#define UART_BWR_C2_RE(base, value) (BME_BFI8(&UART_C2_REG(base), ((uint8_t)(value) << UART_C2_RE_SHIFT), UART_C2_RE_SHIFT, UART_C2_RE_WIDTH))
/*@}*/

/*!
 * @name Register UART_C2, field TE[3] (RW)
 *
 * Enables the UART transmitter. TE can be used to queue an idle preamble by
 * clearing and then setting TE. When C7816[ISO_7816E] is set/enabled and
 * C7816[TTYPE] = 1, this field is automatically cleared after the requested block has been
 * transmitted. This condition is detected when TL7816[TLEN] = 0 and four
 * additional characters are transmitted.
 *
 * Values:
 * - 0 - Transmitter off.
 * - 1 - Transmitter on.
 */
/*@{*/
/*! @brief Read current value of the UART_C2_TE field. */
#define UART_RD_C2_TE(base)  ((UART_C2_REG(base) & UART_C2_TE_MASK) >> UART_C2_TE_SHIFT)
#define UART_BRD_C2_TE(base) (BME_UBFX8(&UART_C2_REG(base), UART_C2_TE_SHIFT, UART_C2_TE_WIDTH))

/*! @brief Set the TE field to a new value. */
#define UART_WR_C2_TE(base, value) (UART_RMW_C2(base, UART_C2_TE_MASK, UART_C2_TE(value)))
#define UART_BWR_C2_TE(base, value) (BME_BFI8(&UART_C2_REG(base), ((uint8_t)(value) << UART_C2_TE_SHIFT), UART_C2_TE_SHIFT, UART_C2_TE_WIDTH))
/*@}*/

/*!
 * @name Register UART_C2, field ILIE[4] (RW)
 *
 * Enables the idle line flag, S1[IDLE], to generate interrupt requests
 *
 * Values:
 * - 0 - IDLE interrupt requests disabled.
 * - 1 - IDLE interrupt requests enabled.
 */
/*@{*/
/*! @brief Read current value of the UART_C2_ILIE field. */
#define UART_RD_C2_ILIE(base) ((UART_C2_REG(base) & UART_C2_ILIE_MASK) >> UART_C2_ILIE_SHIFT)
#define UART_BRD_C2_ILIE(base) (BME_UBFX8(&UART_C2_REG(base), UART_C2_ILIE_SHIFT, UART_C2_ILIE_WIDTH))

/*! @brief Set the ILIE field to a new value. */
#define UART_WR_C2_ILIE(base, value) (UART_RMW_C2(base, UART_C2_ILIE_MASK, UART_C2_ILIE(value)))
#define UART_BWR_C2_ILIE(base, value) (BME_BFI8(&UART_C2_REG(base), ((uint8_t)(value) << UART_C2_ILIE_SHIFT), UART_C2_ILIE_SHIFT, UART_C2_ILIE_WIDTH))
/*@}*/

/*!
 * @name Register UART_C2, field RIE[5] (RW)
 *
 * Enables S1[RDRF] to generate interrupt requests or DMA transfer requests,
 * based on the state of C5[RDMAS].
 *
 * Values:
 * - 0 - RDRF interrupt and DMA transfer requests disabled.
 * - 1 - RDRF interrupt or DMA transfer requests enabled.
 */
/*@{*/
/*! @brief Read current value of the UART_C2_RIE field. */
#define UART_RD_C2_RIE(base) ((UART_C2_REG(base) & UART_C2_RIE_MASK) >> UART_C2_RIE_SHIFT)
#define UART_BRD_C2_RIE(base) (BME_UBFX8(&UART_C2_REG(base), UART_C2_RIE_SHIFT, UART_C2_RIE_WIDTH))

/*! @brief Set the RIE field to a new value. */
#define UART_WR_C2_RIE(base, value) (UART_RMW_C2(base, UART_C2_RIE_MASK, UART_C2_RIE(value)))
#define UART_BWR_C2_RIE(base, value) (BME_BFI8(&UART_C2_REG(base), ((uint8_t)(value) << UART_C2_RIE_SHIFT), UART_C2_RIE_SHIFT, UART_C2_RIE_WIDTH))
/*@}*/

/*!
 * @name Register UART_C2, field TCIE[6] (RW)
 *
 * Enables the transmission complete flag, S1[TC], to generate interrupt
 * requests .
 *
 * Values:
 * - 0 - TC interrupt requests disabled.
 * - 1 - TC interrupt requests enabled.
 */
/*@{*/
/*! @brief Read current value of the UART_C2_TCIE field. */
#define UART_RD_C2_TCIE(base) ((UART_C2_REG(base) & UART_C2_TCIE_MASK) >> UART_C2_TCIE_SHIFT)
#define UART_BRD_C2_TCIE(base) (BME_UBFX8(&UART_C2_REG(base), UART_C2_TCIE_SHIFT, UART_C2_TCIE_WIDTH))

/*! @brief Set the TCIE field to a new value. */
#define UART_WR_C2_TCIE(base, value) (UART_RMW_C2(base, UART_C2_TCIE_MASK, UART_C2_TCIE(value)))
#define UART_BWR_C2_TCIE(base, value) (BME_BFI8(&UART_C2_REG(base), ((uint8_t)(value) << UART_C2_TCIE_SHIFT), UART_C2_TCIE_SHIFT, UART_C2_TCIE_WIDTH))
/*@}*/

/*!
 * @name Register UART_C2, field TIE[7] (RW)
 *
 * Enables S1[TDRE] to generate interrupt requests or DMA transfer requests,
 * based on the state of C5[TDMAS]. If C2[TIE] and C5[TDMAS] are both set, then TCIE
 * must be cleared, and D[D] must not be written unless servicing a DMA request.
 *
 * Values:
 * - 0 - TDRE interrupt and DMA transfer requests disabled.
 * - 1 - TDRE interrupt or DMA transfer requests enabled.
 */
/*@{*/
/*! @brief Read current value of the UART_C2_TIE field. */
#define UART_RD_C2_TIE(base) ((UART_C2_REG(base) & UART_C2_TIE_MASK) >> UART_C2_TIE_SHIFT)
#define UART_BRD_C2_TIE(base) (BME_UBFX8(&UART_C2_REG(base), UART_C2_TIE_SHIFT, UART_C2_TIE_WIDTH))

/*! @brief Set the TIE field to a new value. */
#define UART_WR_C2_TIE(base, value) (UART_RMW_C2(base, UART_C2_TIE_MASK, UART_C2_TIE(value)))
#define UART_BWR_C2_TIE(base, value) (BME_BFI8(&UART_C2_REG(base), ((uint8_t)(value) << UART_C2_TIE_SHIFT), UART_C2_TIE_SHIFT, UART_C2_TIE_WIDTH))
/*@}*/

/*******************************************************************************
 * UART_S1 - UART Status Register 1
 ******************************************************************************/

/*!
 * @brief UART_S1 - UART Status Register 1 (RO)
 *
 * Reset value: 0xC0U
 *
 * The S1 register provides inputs to the MCU for generation of UART interrupts
 * or DMA requests. This register can also be polled by the MCU to check the
 * status of its fields. To clear a flag, the status register should be read followed
 * by a read or write to D register, depending on the interrupt flag type. Other
 * instructions can be executed between the two steps as long the handling of
 * I/O is not compromised, but the order of operations is important for flag
 * clearing. When a flag is configured to trigger a DMA request, assertion of the
 * associated DMA done signal from the DMA controller clears the flag. If the
 * condition that results in the assertion of the flag, interrupt, or DMA request is not
 * resolved prior to clearing the flag, the flag, and interrupt/DMA request,
 * reasserts.
 */
/*!
 * @name Constants and macros for entire UART_S1 register
 */
/*@{*/
#define UART_RD_S1(base)         (UART_S1_REG(base))
/*@}*/

/*
 * Constants & macros for individual UART_S1 bitfields
 */

/*!
 * @name Register UART_S1, field PF[0] (RO)
 *
 * PF is set when PE is set and the parity of the received data does not match
 * its parity bit. The PF is not set in the case of an overrun condition. To clear
 * PF, read S1 and then read D.
 *
 * Values:
 * - 0 - No parity error detected.
 * - 1 - Parity error.
 */
/*@{*/
/*! @brief Read current value of the UART_S1_PF field. */
#define UART_RD_S1_PF(base)  ((UART_S1_REG(base) & UART_S1_PF_MASK) >> UART_S1_PF_SHIFT)
#define UART_BRD_S1_PF(base) (BME_UBFX8(&UART_S1_REG(base), UART_S1_PF_SHIFT, UART_S1_PF_WIDTH))
/*@}*/

/*!
 * @name Register UART_S1, field FE[1] (RO)
 *
 * FE is set when a logic 0 is accepted as the stop bit. FE does not set in the
 * case of an overrun. FE inhibits further data reception until it is cleared. To
 * clear FE, read S1 with FE set and then read D. The last data in the receive
 * buffer represents the data that was received with the frame error enabled.
 * Framing errors are not supported when 7816E is set/enabled. However, if this flag
 * is set, data is still not received in 7816 mode.
 *
 * Values:
 * - 0 - No framing error detected.
 * - 1 - Framing error.
 */
/*@{*/
/*! @brief Read current value of the UART_S1_FE field. */
#define UART_RD_S1_FE(base)  ((UART_S1_REG(base) & UART_S1_FE_MASK) >> UART_S1_FE_SHIFT)
#define UART_BRD_S1_FE(base) (BME_UBFX8(&UART_S1_REG(base), UART_S1_FE_SHIFT, UART_S1_FE_WIDTH))
/*@}*/

/*!
 * @name Register UART_S1, field NF[2] (RO)
 *
 * NF is set when the UART detects noise on the receiver input. NF does not
 * become set in the case of an overrun. To clear NF, read S1 and then read D.
 *
 * Values:
 * - 0 - No noise detected.
 * - 1 - Noise detected in the received character in D.
 */
/*@{*/
/*! @brief Read current value of the UART_S1_NF field. */
#define UART_RD_S1_NF(base)  ((UART_S1_REG(base) & UART_S1_NF_MASK) >> UART_S1_NF_SHIFT)
#define UART_BRD_S1_NF(base) (BME_UBFX8(&UART_S1_REG(base), UART_S1_NF_SHIFT, UART_S1_NF_WIDTH))
/*@}*/

/*!
 * @name Register UART_S1, field OR[3] (RO)
 *
 * OR is set when software fails to prevent the receive data register from
 * overflowing with data. The OR bit is set immediately after the stop bit has been
 * completely received for the dataword that overflows the buffer and all the other
 * error flags (FE, NF, and PF) are prevented from setting. The data in the
 * shift register is lost, but the data already in the UART data registers is not
 * affected. If the OR flag is set, no data is stored in the data buffer even if
 * sufficient room exists. Additionally, while the OR flag is set, the RDRF and IDLE
 * flags are blocked from asserting, that is, transition from an inactive to an
 * active state. To clear OR, read S1 when OR is set and then read D. See
 * functional description for more details regarding the operation of the OR bit. In
 * 7816 mode, it is possible to configure a NACK to be returned by programing
 * C7816[ONACK].
 *
 * Values:
 * - 0 - No overrun has occurred since the last time the flag was cleared.
 * - 1 - Overrun has occurred or the overrun flag has not been cleared since the
 *     last overrun occured.
 */
/*@{*/
/*! @brief Read current value of the UART_S1_OR field. */
#define UART_RD_S1_OR(base)  ((UART_S1_REG(base) & UART_S1_OR_MASK) >> UART_S1_OR_SHIFT)
#define UART_BRD_S1_OR(base) (BME_UBFX8(&UART_S1_REG(base), UART_S1_OR_SHIFT, UART_S1_OR_WIDTH))
/*@}*/

/*!
 * @name Register UART_S1, field IDLE[4] (RO)
 *
 * After the IDLE flag is cleared, a frame must be received (although not
 * necessarily stored in the data buffer, for example if C2[RWU] is set). To clear
 * IDLE, read UART status S1 with IDLE set and then read D. IDLE is set when either
 * of the following appear on the receiver input: 10 consecutive logic 1s if C1[M]
 * = 0 11 consecutive logic 1s if C1[M] = 1 and C4[M10] = 0 12 consecutive logic
 * 1s if C1[M] = 1, C4[M10] = 1, and C1[PE] = 1 Idle detection is not supported
 * when 7816E is set/enabled and hence this flag is ignored. When RWU is set and
 * WAKE is cleared, an idle line condition sets the IDLE flag if RWUID is set,
 * else the IDLE flag does not become set.
 *
 * Values:
 * - 0 - Receiver input is either active now or has never become active since
 *     the IDLE flag was last cleared.
 * - 1 - Receiver input has become idle or the flag has not been cleared since
 *     it last asserted.
 */
/*@{*/
/*! @brief Read current value of the UART_S1_IDLE field. */
#define UART_RD_S1_IDLE(base) ((UART_S1_REG(base) & UART_S1_IDLE_MASK) >> UART_S1_IDLE_SHIFT)
#define UART_BRD_S1_IDLE(base) (BME_UBFX8(&UART_S1_REG(base), UART_S1_IDLE_SHIFT, UART_S1_IDLE_WIDTH))
/*@}*/

/*!
 * @name Register UART_S1, field RDRF[5] (RO)
 *
 * RDRF is set when the receive buffer (D) is full. To clear RDRF, read S1 when
 * RDRF is set and then read D.
 *
 * Values:
 * - 0 - Receive data buffer is empty.
 * - 1 - Receive data buffer is full.
 */
/*@{*/
/*! @brief Read current value of the UART_S1_RDRF field. */
#define UART_RD_S1_RDRF(base) ((UART_S1_REG(base) & UART_S1_RDRF_MASK) >> UART_S1_RDRF_SHIFT)
#define UART_BRD_S1_RDRF(base) (BME_UBFX8(&UART_S1_REG(base), UART_S1_RDRF_SHIFT, UART_S1_RDRF_WIDTH))
/*@}*/

/*!
 * @name Register UART_S1, field TC[6] (RO)
 *
 * TC is set when the transmit buffer is empty and no data, preamble, or break
 * character is being transmitted. When TC is set, the transmit data output signal
 * becomes idle (logic 1). TC is cleared by reading S1 with TC set and then
 * doing one of the following: When C7816[ISO_7816E] is set/enabled, this field is
 * set after any NACK signal has been received, but prior to any corresponding
 * guard times expiring. Writing to D to transmit new data. Queuing a preamble by
 * clearing and then setting C2[TE]. Queuing a break character by writing 1 to SBK
 * in C2.
 *
 * Values:
 * - 0 - Transmitter active (sending data, a preamble, or a break).
 * - 1 - Transmitter idle (transmission activity complete).
 */
/*@{*/
/*! @brief Read current value of the UART_S1_TC field. */
#define UART_RD_S1_TC(base)  ((UART_S1_REG(base) & UART_S1_TC_MASK) >> UART_S1_TC_SHIFT)
#define UART_BRD_S1_TC(base) (BME_UBFX8(&UART_S1_REG(base), UART_S1_TC_SHIFT, UART_S1_TC_WIDTH))
/*@}*/

/*!
 * @name Register UART_S1, field TDRE[7] (RO)
 *
 * TDRE will set when the transmit data register (D) is empty. To clear TDRE,
 * read S1 when TDRE is set and then write to the UART data register (D).
 *
 * Values:
 * - 0 - Transmit data buffer is full.
 * - 1 - Transmit data buffer is empty.
 */
/*@{*/
/*! @brief Read current value of the UART_S1_TDRE field. */
#define UART_RD_S1_TDRE(base) ((UART_S1_REG(base) & UART_S1_TDRE_MASK) >> UART_S1_TDRE_SHIFT)
#define UART_BRD_S1_TDRE(base) (BME_UBFX8(&UART_S1_REG(base), UART_S1_TDRE_SHIFT, UART_S1_TDRE_WIDTH))
/*@}*/

/*******************************************************************************
 * UART_S2 - UART Status Register 2
 ******************************************************************************/

/*!
 * @brief UART_S2 - UART Status Register 2 (RW)
 *
 * Reset value: 0x00U
 *
 * The S2 register provides inputs to the MCU for generation of UART interrupts
 * or DMA requests. Also, this register can be polled by the MCU to check the
 * status of these bits. This register can be read or written at any time, with the
 * exception of the MSBF and RXINV bits, which should be changed by the user only
 * between transmit and receive packets.
 */
/*!
 * @name Constants and macros for entire UART_S2 register
 */
/*@{*/
#define UART_RD_S2(base)         (UART_S2_REG(base))
#define UART_WR_S2(base, value)  (UART_S2_REG(base) = (value))
#define UART_RMW_S2(base, mask, value) (UART_WR_S2(base, (UART_RD_S2(base) & ~(mask)) | (value)))
#define UART_SET_S2(base, value) (BME_OR8(&UART_S2_REG(base), (uint8_t)(value)))
#define UART_CLR_S2(base, value) (BME_AND8(&UART_S2_REG(base), (uint8_t)(~(value))))
#define UART_TOG_S2(base, value) (BME_XOR8(&UART_S2_REG(base), (uint8_t)(value)))
/*@}*/

/*
 * Constants & macros for individual UART_S2 bitfields
 */

/*!
 * @name Register UART_S2, field RAF[0] (RO)
 *
 * RAF is set when the UART receiver detects a logic 0 during the RT1 time
 * period of the start bit search. RAF is cleared when the receiver detects an idle
 * character when C7816[ISO7816E] is cleared/disabled. When C7816[ISO7816E] is
 * enabled, the RAF is cleared if the C7816[TTYPE] = 0 expires or the C7816[TTYPE] =
 * 1 expires.In case C7816[ISO7816E] is set and C7816[TTYPE] = 0, it is possible
 * to configure the guard time to 12. However, if a NACK is required to be
 * transmitted, the data transfer actually takes 13 ETU with the 13th ETU slot being a
 * inactive buffer. Therefore, in this situation, the RAF may deassert one ETU
 * prior to actually being inactive.
 *
 * Values:
 * - 0 - UART receiver idle/inactive waiting for a start bit.
 * - 1 - UART receiver active, RxD input not idle.
 */
/*@{*/
/*! @brief Read current value of the UART_S2_RAF field. */
#define UART_RD_S2_RAF(base) ((UART_S2_REG(base) & UART_S2_RAF_MASK) >> UART_S2_RAF_SHIFT)
#define UART_BRD_S2_RAF(base) (BME_UBFX8(&UART_S2_REG(base), UART_S2_RAF_SHIFT, UART_S2_RAF_WIDTH))
/*@}*/

/*!
 * @name Register UART_S2, field BRK13[2] (RW)
 *
 * Determines whether the transmit break character is 10, 11, or 12 bits long,
 * or 13 or 14 bits long. See for the length of the break character for the
 * different configurations. The detection of a framing error is not affected by this
 * field. Transmitting break characters
 *
 * Values:
 * - 0 - Break character is 10, 11, or 12 bits long.
 * - 1 - Break character is 13 or 14 bits long.
 */
/*@{*/
/*! @brief Read current value of the UART_S2_BRK13 field. */
#define UART_RD_S2_BRK13(base) ((UART_S2_REG(base) & UART_S2_BRK13_MASK) >> UART_S2_BRK13_SHIFT)
#define UART_BRD_S2_BRK13(base) (BME_UBFX8(&UART_S2_REG(base), UART_S2_BRK13_SHIFT, UART_S2_BRK13_WIDTH))

/*! @brief Set the BRK13 field to a new value. */
#define UART_WR_S2_BRK13(base, value) (UART_RMW_S2(base, (UART_S2_BRK13_MASK | UART_S2_RXEDGIF_MASK), UART_S2_BRK13(value)))
#define UART_BWR_S2_BRK13(base, value) (BME_BFI8(&UART_S2_REG(base), ((uint8_t)(value) << UART_S2_BRK13_SHIFT), UART_S2_BRK13_SHIFT, UART_S2_BRK13_WIDTH))
/*@}*/

/*!
 * @name Register UART_S2, field RWUID[3] (RW)
 *
 * When RWU is set and WAKE is cleared, this field controls whether the idle
 * character that wakes the receiver sets S1[IDLE]. This field must be cleared when
 * C7816[ISO7816E] is set/enabled.
 *
 * Values:
 * - 0 - S1[IDLE] is not set upon detection of an idle character.
 * - 1 - S1[IDLE] is set upon detection of an idle character.
 */
/*@{*/
/*! @brief Read current value of the UART_S2_RWUID field. */
#define UART_RD_S2_RWUID(base) ((UART_S2_REG(base) & UART_S2_RWUID_MASK) >> UART_S2_RWUID_SHIFT)
#define UART_BRD_S2_RWUID(base) (BME_UBFX8(&UART_S2_REG(base), UART_S2_RWUID_SHIFT, UART_S2_RWUID_WIDTH))

/*! @brief Set the RWUID field to a new value. */
#define UART_WR_S2_RWUID(base, value) (UART_RMW_S2(base, (UART_S2_RWUID_MASK | UART_S2_RXEDGIF_MASK), UART_S2_RWUID(value)))
#define UART_BWR_S2_RWUID(base, value) (BME_BFI8(&UART_S2_REG(base), ((uint8_t)(value) << UART_S2_RWUID_SHIFT), UART_S2_RWUID_SHIFT, UART_S2_RWUID_WIDTH))
/*@}*/

/*!
 * @name Register UART_S2, field RXINV[4] (RW)
 *
 * Setting this field reverses the polarity of the received data input. In NRZ
 * format, a one is represented by a mark and a zero is represented by a space for
 * normal polarity, and the opposite for inverted polarity. This field is
 * automatically set when C7816[INIT] and C7816[ISO7816E] are enabled and an initial
 * character is detected in T = 0 protocol mode. Setting RXINV inverts the RxD
 * input for data bits, start and stop bits, break, and idle. When C7816[ISO7816E] is
 * set/enabled, only the data bits and the parity bit are inverted.
 *
 * Values:
 * - 0 - Receive data is not inverted.
 * - 1 - Receive data is inverted.
 */
/*@{*/
/*! @brief Read current value of the UART_S2_RXINV field. */
#define UART_RD_S2_RXINV(base) ((UART_S2_REG(base) & UART_S2_RXINV_MASK) >> UART_S2_RXINV_SHIFT)
#define UART_BRD_S2_RXINV(base) (BME_UBFX8(&UART_S2_REG(base), UART_S2_RXINV_SHIFT, UART_S2_RXINV_WIDTH))

/*! @brief Set the RXINV field to a new value. */
#define UART_WR_S2_RXINV(base, value) (UART_RMW_S2(base, (UART_S2_RXINV_MASK | UART_S2_RXEDGIF_MASK), UART_S2_RXINV(value)))
#define UART_BWR_S2_RXINV(base, value) (BME_BFI8(&UART_S2_REG(base), ((uint8_t)(value) << UART_S2_RXINV_SHIFT), UART_S2_RXINV_SHIFT, UART_S2_RXINV_WIDTH))
/*@}*/

/*!
 * @name Register UART_S2, field MSBF[5] (RW)
 *
 * Setting this field reverses the order of the bits that are transmitted and
 * received on the wire. This field does not affect the polarity of the bits, the
 * location of the parity bit, or the location of the start or stop bits. This
 * field is automatically set when C7816[INIT] and C7816[ISO7816E] are enabled and
 * an initial character is detected in T = 0 protocol mode.
 *
 * Values:
 * - 0 - LSB (bit0) is the first bit that is transmitted following the start
 *     bit. Further, the first bit received after the start bit is identified as
 *     bit0.
 * - 1 - MSB (bit8, bit7 or bit6) is the first bit that is transmitted following
 *     the start bit, depending on the setting of C1[M] and C1[PE]. Further, the
 *     first bit received after the start bit is identified as bit8, bit7, or
 *     bit6, depending on the setting of C1[M] and C1[PE].
 */
/*@{*/
/*! @brief Read current value of the UART_S2_MSBF field. */
#define UART_RD_S2_MSBF(base) ((UART_S2_REG(base) & UART_S2_MSBF_MASK) >> UART_S2_MSBF_SHIFT)
#define UART_BRD_S2_MSBF(base) (BME_UBFX8(&UART_S2_REG(base), UART_S2_MSBF_SHIFT, UART_S2_MSBF_WIDTH))

/*! @brief Set the MSBF field to a new value. */
#define UART_WR_S2_MSBF(base, value) (UART_RMW_S2(base, (UART_S2_MSBF_MASK | UART_S2_RXEDGIF_MASK), UART_S2_MSBF(value)))
#define UART_BWR_S2_MSBF(base, value) (BME_BFI8(&UART_S2_REG(base), ((uint8_t)(value) << UART_S2_MSBF_SHIFT), UART_S2_MSBF_SHIFT, UART_S2_MSBF_WIDTH))
/*@}*/

/*!
 * @name Register UART_S2, field RXEDGIF[6] (W1C)
 *
 * RXEDGIF is set when an active edge occurs on the RxD pin. The active edge is
 * falling if RXINV = 0, and rising if RXINV=1. RXEDGIF is cleared by writing a 1
 * to it. See for additional details. RXEDGIF description The active edge is
 * detected only in two wire mode and on receiving data coming from the RxD pin.
 *
 * Values:
 * - 0 - No active edge on the receive pin has occurred.
 * - 1 - An active edge on the receive pin has occurred.
 */
/*@{*/
/*! @brief Read current value of the UART_S2_RXEDGIF field. */
#define UART_RD_S2_RXEDGIF(base) ((UART_S2_REG(base) & UART_S2_RXEDGIF_MASK) >> UART_S2_RXEDGIF_SHIFT)
#define UART_BRD_S2_RXEDGIF(base) (BME_UBFX8(&UART_S2_REG(base), UART_S2_RXEDGIF_SHIFT, UART_S2_RXEDGIF_WIDTH))

/*! @brief Set the RXEDGIF field to a new value. */
#define UART_WR_S2_RXEDGIF(base, value) (UART_RMW_S2(base, UART_S2_RXEDGIF_MASK, UART_S2_RXEDGIF(value)))
#define UART_BWR_S2_RXEDGIF(base, value) (BME_BFI8(&UART_S2_REG(base), ((uint8_t)(value) << UART_S2_RXEDGIF_SHIFT), UART_S2_RXEDGIF_SHIFT, UART_S2_RXEDGIF_WIDTH))
/*@}*/

/*******************************************************************************
 * UART_C3 - UART Control Register 3
 ******************************************************************************/

/*!
 * @brief UART_C3 - UART Control Register 3 (RW)
 *
 * Reset value: 0x00U
 *
 * Writing R8 does not have any effect. TXDIR and TXINV can be changed only
 * between transmit and receive packets.
 */
/*!
 * @name Constants and macros for entire UART_C3 register
 */
/*@{*/
#define UART_RD_C3(base)         (UART_C3_REG(base))
#define UART_WR_C3(base, value)  (UART_C3_REG(base) = (value))
#define UART_RMW_C3(base, mask, value) (UART_WR_C3(base, (UART_RD_C3(base) & ~(mask)) | (value)))
#define UART_SET_C3(base, value) (BME_OR8(&UART_C3_REG(base), (uint8_t)(value)))
#define UART_CLR_C3(base, value) (BME_AND8(&UART_C3_REG(base), (uint8_t)(~(value))))
#define UART_TOG_C3(base, value) (BME_XOR8(&UART_C3_REG(base), (uint8_t)(value)))
/*@}*/

/*
 * Constants & macros for individual UART_C3 bitfields
 */

/*!
 * @name Register UART_C3, field PEIE[0] (RW)
 *
 * Enables the parity error flag, S1[PF], to generate interrupt requests.
 *
 * Values:
 * - 0 - PF interrupt requests are disabled.
 * - 1 - PF interrupt requests are enabled.
 */
/*@{*/
/*! @brief Read current value of the UART_C3_PEIE field. */
#define UART_RD_C3_PEIE(base) ((UART_C3_REG(base) & UART_C3_PEIE_MASK) >> UART_C3_PEIE_SHIFT)
#define UART_BRD_C3_PEIE(base) (BME_UBFX8(&UART_C3_REG(base), UART_C3_PEIE_SHIFT, UART_C3_PEIE_WIDTH))

/*! @brief Set the PEIE field to a new value. */
#define UART_WR_C3_PEIE(base, value) (UART_RMW_C3(base, UART_C3_PEIE_MASK, UART_C3_PEIE(value)))
#define UART_BWR_C3_PEIE(base, value) (BME_BFI8(&UART_C3_REG(base), ((uint8_t)(value) << UART_C3_PEIE_SHIFT), UART_C3_PEIE_SHIFT, UART_C3_PEIE_WIDTH))
/*@}*/

/*!
 * @name Register UART_C3, field FEIE[1] (RW)
 *
 * Enables the framing error flag, S1[FE], to generate interrupt requests.
 *
 * Values:
 * - 0 - FE interrupt requests are disabled.
 * - 1 - FE interrupt requests are enabled.
 */
/*@{*/
/*! @brief Read current value of the UART_C3_FEIE field. */
#define UART_RD_C3_FEIE(base) ((UART_C3_REG(base) & UART_C3_FEIE_MASK) >> UART_C3_FEIE_SHIFT)
#define UART_BRD_C3_FEIE(base) (BME_UBFX8(&UART_C3_REG(base), UART_C3_FEIE_SHIFT, UART_C3_FEIE_WIDTH))

/*! @brief Set the FEIE field to a new value. */
#define UART_WR_C3_FEIE(base, value) (UART_RMW_C3(base, UART_C3_FEIE_MASK, UART_C3_FEIE(value)))
#define UART_BWR_C3_FEIE(base, value) (BME_BFI8(&UART_C3_REG(base), ((uint8_t)(value) << UART_C3_FEIE_SHIFT), UART_C3_FEIE_SHIFT, UART_C3_FEIE_WIDTH))
/*@}*/

/*!
 * @name Register UART_C3, field NEIE[2] (RW)
 *
 * Enables the noise flag, S1[NF], to generate interrupt requests.
 *
 * Values:
 * - 0 - NF interrupt requests are disabled.
 * - 1 - NF interrupt requests are enabled.
 */
/*@{*/
/*! @brief Read current value of the UART_C3_NEIE field. */
#define UART_RD_C3_NEIE(base) ((UART_C3_REG(base) & UART_C3_NEIE_MASK) >> UART_C3_NEIE_SHIFT)
#define UART_BRD_C3_NEIE(base) (BME_UBFX8(&UART_C3_REG(base), UART_C3_NEIE_SHIFT, UART_C3_NEIE_WIDTH))

/*! @brief Set the NEIE field to a new value. */
#define UART_WR_C3_NEIE(base, value) (UART_RMW_C3(base, UART_C3_NEIE_MASK, UART_C3_NEIE(value)))
#define UART_BWR_C3_NEIE(base, value) (BME_BFI8(&UART_C3_REG(base), ((uint8_t)(value) << UART_C3_NEIE_SHIFT), UART_C3_NEIE_SHIFT, UART_C3_NEIE_WIDTH))
/*@}*/

/*!
 * @name Register UART_C3, field ORIE[3] (RW)
 *
 * Enables the overrun error flag, S1[OR], to generate interrupt requests.
 *
 * Values:
 * - 0 - OR interrupts are disabled.
 * - 1 - OR interrupt requests are enabled.
 */
/*@{*/
/*! @brief Read current value of the UART_C3_ORIE field. */
#define UART_RD_C3_ORIE(base) ((UART_C3_REG(base) & UART_C3_ORIE_MASK) >> UART_C3_ORIE_SHIFT)
#define UART_BRD_C3_ORIE(base) (BME_UBFX8(&UART_C3_REG(base), UART_C3_ORIE_SHIFT, UART_C3_ORIE_WIDTH))

/*! @brief Set the ORIE field to a new value. */
#define UART_WR_C3_ORIE(base, value) (UART_RMW_C3(base, UART_C3_ORIE_MASK, UART_C3_ORIE(value)))
#define UART_BWR_C3_ORIE(base, value) (BME_BFI8(&UART_C3_REG(base), ((uint8_t)(value) << UART_C3_ORIE_SHIFT), UART_C3_ORIE_SHIFT, UART_C3_ORIE_WIDTH))
/*@}*/

/*!
 * @name Register UART_C3, field TXINV[4] (RW)
 *
 * Setting this field reverses the polarity of the transmitted data output. In
 * NRZ format, a one is represented by a mark and a zero is represented by a space
 * for normal polarity, and the opposite for inverted polarity. This field is
 * automatically set when C7816[INIT] and C7816[ISO7816E] are enabled and an
 * initial character is detected in T = 0 protocol mode. Setting TXINV inverts all
 * transmitted values, including idle, break, start, and stop bits. In loop mode, if
 * TXINV is set, the receiver gets the transmit inversion bit when RXINV is
 * disabled. When C7816[ISO7816E] is set/enabled then only the transmitted data bits
 * and parity bit are inverted.
 *
 * Values:
 * - 0 - Transmit data is not inverted.
 * - 1 - Transmit data is inverted.
 */
/*@{*/
/*! @brief Read current value of the UART_C3_TXINV field. */
#define UART_RD_C3_TXINV(base) ((UART_C3_REG(base) & UART_C3_TXINV_MASK) >> UART_C3_TXINV_SHIFT)
#define UART_BRD_C3_TXINV(base) (BME_UBFX8(&UART_C3_REG(base), UART_C3_TXINV_SHIFT, UART_C3_TXINV_WIDTH))

/*! @brief Set the TXINV field to a new value. */
#define UART_WR_C3_TXINV(base, value) (UART_RMW_C3(base, UART_C3_TXINV_MASK, UART_C3_TXINV(value)))
#define UART_BWR_C3_TXINV(base, value) (BME_BFI8(&UART_C3_REG(base), ((uint8_t)(value) << UART_C3_TXINV_SHIFT), UART_C3_TXINV_SHIFT, UART_C3_TXINV_WIDTH))
/*@}*/

/*!
 * @name Register UART_C3, field TXDIR[5] (RW)
 *
 * Determines whether the TXD pin is used as an input or output in the
 * single-wire mode of operation. This field is relevant only to the single wire mode.
 * When C7816[ISO7816E] is set/enabled and C7816[TTYPE] = 1, this field is
 * automatically cleared after the requested block is transmitted. This condition is
 * detected when TL7816[TLEN] = 0 and 4 additional characters are transmitted.
 * Additionally, if C7816[ISO7816E] is set/enabled and C7816[TTYPE] = 0 and a NACK is
 * being transmitted, the hardware automatically overrides this field as needed. In
 * this situation, TXDIR does not reflect the temporary state associated with
 * the NACK.
 *
 * Values:
 * - 0 - TXD pin is an input in single wire mode.
 * - 1 - TXD pin is an output in single wire mode.
 */
/*@{*/
/*! @brief Read current value of the UART_C3_TXDIR field. */
#define UART_RD_C3_TXDIR(base) ((UART_C3_REG(base) & UART_C3_TXDIR_MASK) >> UART_C3_TXDIR_SHIFT)
#define UART_BRD_C3_TXDIR(base) (BME_UBFX8(&UART_C3_REG(base), UART_C3_TXDIR_SHIFT, UART_C3_TXDIR_WIDTH))

/*! @brief Set the TXDIR field to a new value. */
#define UART_WR_C3_TXDIR(base, value) (UART_RMW_C3(base, UART_C3_TXDIR_MASK, UART_C3_TXDIR(value)))
#define UART_BWR_C3_TXDIR(base, value) (BME_BFI8(&UART_C3_REG(base), ((uint8_t)(value) << UART_C3_TXDIR_SHIFT), UART_C3_TXDIR_SHIFT, UART_C3_TXDIR_WIDTH))
/*@}*/

/*!
 * @name Register UART_C3, field T8[6] (RW)
 *
 * T8 is the ninth data bit transmitted when the UART is configured for 9-bit
 * data format, that is, if C1[M] = 1 or C4[M10] = 1. If the value of T8 is the
 * same as in the previous transmission, T8 does not have to be rewritten. The same
 * value is transmitted until T8 is rewritten. To correctly transmit the 9th bit,
 * write UARTx_C3[T8] to the desired value, then write the UARTx_D register with
 * the remaining data.
 */
/*@{*/
/*! @brief Read current value of the UART_C3_T8 field. */
#define UART_RD_C3_T8(base)  ((UART_C3_REG(base) & UART_C3_T8_MASK) >> UART_C3_T8_SHIFT)
#define UART_BRD_C3_T8(base) (BME_UBFX8(&UART_C3_REG(base), UART_C3_T8_SHIFT, UART_C3_T8_WIDTH))

/*! @brief Set the T8 field to a new value. */
#define UART_WR_C3_T8(base, value) (UART_RMW_C3(base, UART_C3_T8_MASK, UART_C3_T8(value)))
#define UART_BWR_C3_T8(base, value) (BME_BFI8(&UART_C3_REG(base), ((uint8_t)(value) << UART_C3_T8_SHIFT), UART_C3_T8_SHIFT, UART_C3_T8_WIDTH))
/*@}*/

/*!
 * @name Register UART_C3, field R8[7] (RO)
 *
 * R8 is the ninth data bit received when the UART is configured for 9-bit data
 * format, that is, if C1[M] = 1 or C4[M10] = 1. The R8 value corresponds to the
 * current data value in the UARTx_D register. To read the 9th bit, read the
 * value of UARTx_C3[R8], then read the UARTx_D register.
 */
/*@{*/
/*! @brief Read current value of the UART_C3_R8 field. */
#define UART_RD_C3_R8(base)  ((UART_C3_REG(base) & UART_C3_R8_MASK) >> UART_C3_R8_SHIFT)
#define UART_BRD_C3_R8(base) (BME_UBFX8(&UART_C3_REG(base), UART_C3_R8_SHIFT, UART_C3_R8_WIDTH))
/*@}*/

/*******************************************************************************
 * UART_D - UART Data Register
 ******************************************************************************/

/*!
 * @brief UART_D - UART Data Register (RW)
 *
 * Reset value: 0x00U
 *
 * This register is actually two separate registers. Reads return the contents
 * of the read-only receive data register and writes go to the write-only transmit
 * data register. In 8-bit or 9-bit data format, only UART data register (D)
 * needs to be accessed to clear the S1[RDRF] bit . The C3 register needs to be
 * read, prior to the D register, only if the ninth bit of data needs to be captured.
 * In the normal 8-bit mode (M bit cleared) if the parity is enabled, you get
 * seven data bits and one parity bit. That one parity bit is loaded into the D
 * register. So, for the data bits, mask off the parity bit from the value you read
 * out of this register. When transmitting in 9-bit data format and using 8-bit
 * write instructions, write first to transmit bit 8 in UART control register 3
 * (C3[T8]), then D. A write to C3[T8] stores the data in a temporary register. If
 * D register is written first, and then the new data on data bus is stored in D,
 * the temporary value written by the last write to C3[T8] gets stored in the
 * C3[T8] register.
 */
/*!
 * @name Constants and macros for entire UART_D register
 */
/*@{*/
#define UART_RD_D(base)          (UART_D_REG(base))
#define UART_WR_D(base, value)   (UART_D_REG(base) = (value))
#define UART_RMW_D(base, mask, value) (UART_WR_D(base, (UART_RD_D(base) & ~(mask)) | (value)))
#define UART_SET_D(base, value)  (BME_OR8(&UART_D_REG(base), (uint8_t)(value)))
#define UART_CLR_D(base, value)  (BME_AND8(&UART_D_REG(base), (uint8_t)(~(value))))
#define UART_TOG_D(base, value)  (BME_XOR8(&UART_D_REG(base), (uint8_t)(value)))
/*@}*/

/*******************************************************************************
 * UART_MA1 - UART Match Address Registers 1
 ******************************************************************************/

/*!
 * @brief UART_MA1 - UART Match Address Registers 1 (RW)
 *
 * Reset value: 0x00U
 *
 * The MA1 and MA2 registers are compared to input data addresses when the most
 * significant bit is set and the associated C4[MAEN] field is set. If a match
 * occurs, the following data is transferred to the data register. If a match
 * fails, the following data is discarded. These registers can be read and written at
 * anytime.
 */
/*!
 * @name Constants and macros for entire UART_MA1 register
 */
/*@{*/
#define UART_RD_MA1(base)        (UART_MA1_REG(base))
#define UART_WR_MA1(base, value) (UART_MA1_REG(base) = (value))
#define UART_RMW_MA1(base, mask, value) (UART_WR_MA1(base, (UART_RD_MA1(base) & ~(mask)) | (value)))
#define UART_SET_MA1(base, value) (BME_OR8(&UART_MA1_REG(base), (uint8_t)(value)))
#define UART_CLR_MA1(base, value) (BME_AND8(&UART_MA1_REG(base), (uint8_t)(~(value))))
#define UART_TOG_MA1(base, value) (BME_XOR8(&UART_MA1_REG(base), (uint8_t)(value)))
/*@}*/

/*******************************************************************************
 * UART_MA2 - UART Match Address Registers 2
 ******************************************************************************/

/*!
 * @brief UART_MA2 - UART Match Address Registers 2 (RW)
 *
 * Reset value: 0x00U
 *
 * These registers can be read and written at anytime. The MA1 and MA2 registers
 * are compared to input data addresses when the most significant bit is set and
 * the associated C4[MAEN] field is set. If a match occurs, the following data
 * is transferred to the data register. If a match fails, the following data is
 * discarded.
 */
/*!
 * @name Constants and macros for entire UART_MA2 register
 */
/*@{*/
#define UART_RD_MA2(base)        (UART_MA2_REG(base))
#define UART_WR_MA2(base, value) (UART_MA2_REG(base) = (value))
#define UART_RMW_MA2(base, mask, value) (UART_WR_MA2(base, (UART_RD_MA2(base) & ~(mask)) | (value)))
#define UART_SET_MA2(base, value) (BME_OR8(&UART_MA2_REG(base), (uint8_t)(value)))
#define UART_CLR_MA2(base, value) (BME_AND8(&UART_MA2_REG(base), (uint8_t)(~(value))))
#define UART_TOG_MA2(base, value) (BME_XOR8(&UART_MA2_REG(base), (uint8_t)(value)))
/*@}*/

/*******************************************************************************
 * UART_C4 - UART Control Register 4
 ******************************************************************************/

/*!
 * @brief UART_C4 - UART Control Register 4 (RW)
 *
 * Reset value: 0x00U
 */
/*!
 * @name Constants and macros for entire UART_C4 register
 */
/*@{*/
#define UART_RD_C4(base)         (UART_C4_REG(base))
#define UART_WR_C4(base, value)  (UART_C4_REG(base) = (value))
#define UART_RMW_C4(base, mask, value) (UART_WR_C4(base, (UART_RD_C4(base) & ~(mask)) | (value)))
#define UART_SET_C4(base, value) (BME_OR8(&UART_C4_REG(base), (uint8_t)(value)))
#define UART_CLR_C4(base, value) (BME_AND8(&UART_C4_REG(base), (uint8_t)(~(value))))
#define UART_TOG_C4(base, value) (BME_XOR8(&UART_C4_REG(base), (uint8_t)(value)))
/*@}*/

/*
 * Constants & macros for individual UART_C4 bitfields
 */

/*!
 * @name Register UART_C4, field BRFA[4:0] (RW)
 *
 * This bit field is used to add more timing resolution to the average baud
 * frequency, in increments of 1/32. See Baud rate generation for more information.
 */
/*@{*/
/*! @brief Read current value of the UART_C4_BRFA field. */
#define UART_RD_C4_BRFA(base) ((UART_C4_REG(base) & UART_C4_BRFA_MASK) >> UART_C4_BRFA_SHIFT)
#define UART_BRD_C4_BRFA(base) (BME_UBFX8(&UART_C4_REG(base), UART_C4_BRFA_SHIFT, UART_C4_BRFA_WIDTH))

/*! @brief Set the BRFA field to a new value. */
#define UART_WR_C4_BRFA(base, value) (UART_RMW_C4(base, UART_C4_BRFA_MASK, UART_C4_BRFA(value)))
#define UART_BWR_C4_BRFA(base, value) (BME_BFI8(&UART_C4_REG(base), ((uint8_t)(value) << UART_C4_BRFA_SHIFT), UART_C4_BRFA_SHIFT, UART_C4_BRFA_WIDTH))
/*@}*/

/*!
 * @name Register UART_C4, field M10[5] (RW)
 *
 * Causes a tenth, non-memory mapped bit to be part of the serial transmission.
 * This tenth bit is generated and interpreted as a parity bit. If M10 is set,
 * then both C1[M] and C1[PE] must also be set. This field must be cleared when
 * C7816[ISO7816E] is set/enabled. See Data format (non ISO-7816) for more
 * information.
 *
 * Values:
 * - 0 - The parity bit is the ninth bit in the serial transmission.
 * - 1 - The parity bit is the tenth bit in the serial transmission.
 */
/*@{*/
/*! @brief Read current value of the UART_C4_M10 field. */
#define UART_RD_C4_M10(base) ((UART_C4_REG(base) & UART_C4_M10_MASK) >> UART_C4_M10_SHIFT)
#define UART_BRD_C4_M10(base) (BME_UBFX8(&UART_C4_REG(base), UART_C4_M10_SHIFT, UART_C4_M10_WIDTH))

/*! @brief Set the M10 field to a new value. */
#define UART_WR_C4_M10(base, value) (UART_RMW_C4(base, UART_C4_M10_MASK, UART_C4_M10(value)))
#define UART_BWR_C4_M10(base, value) (BME_BFI8(&UART_C4_REG(base), ((uint8_t)(value) << UART_C4_M10_SHIFT), UART_C4_M10_SHIFT, UART_C4_M10_WIDTH))
/*@}*/

/*!
 * @name Register UART_C4, field MAEN2[6] (RW)
 *
 * See Match address operation for more information.
 *
 * Values:
 * - 0 - All data received is transferred to the data buffer if MAEN1 is cleared.
 * - 1 - All data received with the most significant bit cleared, is discarded.
 *     All data received with the most significant bit set, is compared with
 *     contents of MA2 register. If no match occurs, the data is discarded. If a
 *     match occurs, data is transferred to the data buffer. This field must be
 *     cleared when C7816[ISO7816E] is set/enabled.
 */
/*@{*/
/*! @brief Read current value of the UART_C4_MAEN2 field. */
#define UART_RD_C4_MAEN2(base) ((UART_C4_REG(base) & UART_C4_MAEN2_MASK) >> UART_C4_MAEN2_SHIFT)
#define UART_BRD_C4_MAEN2(base) (BME_UBFX8(&UART_C4_REG(base), UART_C4_MAEN2_SHIFT, UART_C4_MAEN2_WIDTH))

/*! @brief Set the MAEN2 field to a new value. */
#define UART_WR_C4_MAEN2(base, value) (UART_RMW_C4(base, UART_C4_MAEN2_MASK, UART_C4_MAEN2(value)))
#define UART_BWR_C4_MAEN2(base, value) (BME_BFI8(&UART_C4_REG(base), ((uint8_t)(value) << UART_C4_MAEN2_SHIFT), UART_C4_MAEN2_SHIFT, UART_C4_MAEN2_WIDTH))
/*@}*/

/*!
 * @name Register UART_C4, field MAEN1[7] (RW)
 *
 * See Match address operation for more information.
 *
 * Values:
 * - 0 - All data received is transferred to the data buffer if MAEN2 is cleared.
 * - 1 - All data received with the most significant bit cleared, is discarded.
 *     All data received with the most significant bit set, is compared with
 *     contents of MA1 register. If no match occurs, the data is discarded. If match
 *     occurs, data is transferred to the data buffer. This field must be cleared
 *     when C7816[ISO7816E] is set/enabled.
 */
/*@{*/
/*! @brief Read current value of the UART_C4_MAEN1 field. */
#define UART_RD_C4_MAEN1(base) ((UART_C4_REG(base) & UART_C4_MAEN1_MASK) >> UART_C4_MAEN1_SHIFT)
#define UART_BRD_C4_MAEN1(base) (BME_UBFX8(&UART_C4_REG(base), UART_C4_MAEN1_SHIFT, UART_C4_MAEN1_WIDTH))

/*! @brief Set the MAEN1 field to a new value. */
#define UART_WR_C4_MAEN1(base, value) (UART_RMW_C4(base, UART_C4_MAEN1_MASK, UART_C4_MAEN1(value)))
#define UART_BWR_C4_MAEN1(base, value) (BME_BFI8(&UART_C4_REG(base), ((uint8_t)(value) << UART_C4_MAEN1_SHIFT), UART_C4_MAEN1_SHIFT, UART_C4_MAEN1_WIDTH))
/*@}*/

/*******************************************************************************
 * UART_C5 - UART Control Register 5
 ******************************************************************************/

/*!
 * @brief UART_C5 - UART Control Register 5 (RW)
 *
 * Reset value: 0x00U
 */
/*!
 * @name Constants and macros for entire UART_C5 register
 */
/*@{*/
#define UART_RD_C5(base)         (UART_C5_REG(base))
#define UART_WR_C5(base, value)  (UART_C5_REG(base) = (value))
#define UART_RMW_C5(base, mask, value) (UART_WR_C5(base, (UART_RD_C5(base) & ~(mask)) | (value)))
#define UART_SET_C5(base, value) (BME_OR8(&UART_C5_REG(base), (uint8_t)(value)))
#define UART_CLR_C5(base, value) (BME_AND8(&UART_C5_REG(base), (uint8_t)(~(value))))
#define UART_TOG_C5(base, value) (BME_XOR8(&UART_C5_REG(base), (uint8_t)(value)))
/*@}*/

/*
 * Constants & macros for individual UART_C5 bitfields
 */

/*!
 * @name Register UART_C5, field RDMAS[5] (RW)
 *
 * Configures the receiver data register full flag, S1[RDRF], to generate
 * interrupt or DMA requests if C2[RIE] is set. If C2[RIE] is cleared, and S1[RDRF] is
 * set, the RDRF DMA and RDFR interrupt request signals are not asserted,
 * regardless of the state of RDMAS.
 *
 * Values:
 * - 0 - If C2[RIE] and S1[RDRF] are set, the RDFR interrupt request signal is
 *     asserted to request an interrupt service.
 * - 1 - If C2[RIE] and S1[RDRF] are set, the RDRF DMA request signal is
 *     asserted to request a DMA transfer.
 */
/*@{*/
/*! @brief Read current value of the UART_C5_RDMAS field. */
#define UART_RD_C5_RDMAS(base) ((UART_C5_REG(base) & UART_C5_RDMAS_MASK) >> UART_C5_RDMAS_SHIFT)
#define UART_BRD_C5_RDMAS(base) (BME_UBFX8(&UART_C5_REG(base), UART_C5_RDMAS_SHIFT, UART_C5_RDMAS_WIDTH))

/*! @brief Set the RDMAS field to a new value. */
#define UART_WR_C5_RDMAS(base, value) (UART_RMW_C5(base, UART_C5_RDMAS_MASK, UART_C5_RDMAS(value)))
#define UART_BWR_C5_RDMAS(base, value) (BME_BFI8(&UART_C5_REG(base), ((uint8_t)(value) << UART_C5_RDMAS_SHIFT), UART_C5_RDMAS_SHIFT, UART_C5_RDMAS_WIDTH))
/*@}*/

/*!
 * @name Register UART_C5, field TDMAS[7] (RW)
 *
 * Configures the transmit data register empty flag, S1[TDRE], to generate
 * interrupt or DMA requests if C2[TIE] is set. If C2[TIE] is cleared, TDRE DMA and
 * TDRE interrupt request signals are not asserted when the TDRE flag is set,
 * regardless of the state of TDMAS. If C2[TIE] and TDMAS are both set, then C2[TCIE]
 * must be cleared, and D must not be written unless a DMA request is being
 * serviced.
 *
 * Values:
 * - 0 - If C2[TIE] is set and the S1[TDRE] flag is set, the TDRE interrupt
 *     request signal is asserted to request interrupt service.
 * - 1 - If C2[TIE] is set and the S1[TDRE] flag is set, the TDRE DMA request
 *     signal is asserted to request a DMA transfer.
 */
/*@{*/
/*! @brief Read current value of the UART_C5_TDMAS field. */
#define UART_RD_C5_TDMAS(base) ((UART_C5_REG(base) & UART_C5_TDMAS_MASK) >> UART_C5_TDMAS_SHIFT)
#define UART_BRD_C5_TDMAS(base) (BME_UBFX8(&UART_C5_REG(base), UART_C5_TDMAS_SHIFT, UART_C5_TDMAS_WIDTH))

/*! @brief Set the TDMAS field to a new value. */
#define UART_WR_C5_TDMAS(base, value) (UART_RMW_C5(base, UART_C5_TDMAS_MASK, UART_C5_TDMAS(value)))
#define UART_BWR_C5_TDMAS(base, value) (BME_BFI8(&UART_C5_REG(base), ((uint8_t)(value) << UART_C5_TDMAS_SHIFT), UART_C5_TDMAS_SHIFT, UART_C5_TDMAS_WIDTH))
/*@}*/

/*******************************************************************************
 * UART_C7816 - UART 7816 Control Register
 ******************************************************************************/

/*!
 * @brief UART_C7816 - UART 7816 Control Register (RW)
 *
 * Reset value: 0x00U
 *
 * The C7816 register is the primary control register for ISO-7816 specific
 * functionality. This register is specific to 7816 functionality and the values in
 * this register have no effect on UART operation and should be ignored if
 * ISO_7816E is not set/enabled. This register may be read at any time but values must
 * be changed only when ISO_7816E is not set.
 */
/*!
 * @name Constants and macros for entire UART_C7816 register
 */
/*@{*/
#define UART_RD_C7816(base)      (UART_C7816_REG(base))
#define UART_WR_C7816(base, value) (UART_C7816_REG(base) = (value))
#define UART_RMW_C7816(base, mask, value) (UART_WR_C7816(base, (UART_RD_C7816(base) & ~(mask)) | (value)))
#define UART_SET_C7816(base, value) (BME_OR8(&UART_C7816_REG(base), (uint8_t)(value)))
#define UART_CLR_C7816(base, value) (BME_AND8(&UART_C7816_REG(base), (uint8_t)(~(value))))
#define UART_TOG_C7816(base, value) (BME_XOR8(&UART_C7816_REG(base), (uint8_t)(value)))
/*@}*/

/*
 * Constants & macros for individual UART_C7816 bitfields
 */

/*!
 * @name Register UART_C7816, field ISO_7816E[0] (RW)
 *
 * Indicates that the UART is operating according to the ISO-7816 protocol. This
 * field must be modified only when no transmit or receive is occurring. If this
 * field is changed during a data transfer, the data being transmitted or
 * received may be transferred incorrectly.
 *
 * Values:
 * - 0 - ISO-7816 functionality is turned off/not enabled.
 * - 1 - ISO-7816 functionality is turned on/enabled.
 */
/*@{*/
/*! @brief Read current value of the UART_C7816_ISO_7816E field. */
#define UART_RD_C7816_ISO_7816E(base) ((UART_C7816_REG(base) & UART_C7816_ISO_7816E_MASK) >> UART_C7816_ISO_7816E_SHIFT)
#define UART_BRD_C7816_ISO_7816E(base) (BME_UBFX8(&UART_C7816_REG(base), UART_C7816_ISO_7816E_SHIFT, UART_C7816_ISO_7816E_WIDTH))

/*! @brief Set the ISO_7816E field to a new value. */
#define UART_WR_C7816_ISO_7816E(base, value) (UART_RMW_C7816(base, UART_C7816_ISO_7816E_MASK, UART_C7816_ISO_7816E(value)))
#define UART_BWR_C7816_ISO_7816E(base, value) (BME_BFI8(&UART_C7816_REG(base), ((uint8_t)(value) << UART_C7816_ISO_7816E_SHIFT), UART_C7816_ISO_7816E_SHIFT, UART_C7816_ISO_7816E_WIDTH))
/*@}*/

/*!
 * @name Register UART_C7816, field TTYPE[1] (RW)
 *
 * Indicates the transfer protocol being used. See ISO-7816 / smartcard support
 * for more details.
 *
 * Values:
 * - 0 - T = 0 per the ISO-7816 specification.
 * - 1 - T = 1 per the ISO-7816 specification.
 */
/*@{*/
/*! @brief Read current value of the UART_C7816_TTYPE field. */
#define UART_RD_C7816_TTYPE(base) ((UART_C7816_REG(base) & UART_C7816_TTYPE_MASK) >> UART_C7816_TTYPE_SHIFT)
#define UART_BRD_C7816_TTYPE(base) (BME_UBFX8(&UART_C7816_REG(base), UART_C7816_TTYPE_SHIFT, UART_C7816_TTYPE_WIDTH))

/*! @brief Set the TTYPE field to a new value. */
#define UART_WR_C7816_TTYPE(base, value) (UART_RMW_C7816(base, UART_C7816_TTYPE_MASK, UART_C7816_TTYPE(value)))
#define UART_BWR_C7816_TTYPE(base, value) (BME_BFI8(&UART_C7816_REG(base), ((uint8_t)(value) << UART_C7816_TTYPE_SHIFT), UART_C7816_TTYPE_SHIFT, UART_C7816_TTYPE_WIDTH))
/*@}*/

/*!
 * @name Register UART_C7816, field INIT[2] (RW)
 *
 * When this field is set, all received characters are searched for a valid
 * initial character. If an invalid initial character is identified, and ANACK is
 * set, a NACK is sent. All received data is discarded and error flags blocked
 * (S1[NF], S1[OR], S1[FE], S1[PF], IS7816[WT], IS7816[CWT], IS7816[BWT], IS7816[ADT],
 * IS7816[GTV]) until a valid initial character is detected. Upon detecting a
 * valid initial character, the configuration values S2[MSBF], C3[TXINV], and
 * S2[RXINV] are automatically updated to reflect the initial character that was
 * received. The actual INIT data value is not stored in the receive buffer.
 * Additionally, upon detection of a valid initial character, IS7816[INITD] is set and an
 * interrupt issued as programmed by IE7816[INITDE]. When a valid initial
 * character is detected, INIT is automatically cleared. This Initial Character Detect
 * feature is supported only in T = 0 protocol mode.
 *
 * Values:
 * - 0 - Normal operating mode. Receiver does not seek to identify initial
 *     character.
 * - 1 - Receiver searches for initial character.
 */
/*@{*/
/*! @brief Read current value of the UART_C7816_INIT field. */
#define UART_RD_C7816_INIT(base) ((UART_C7816_REG(base) & UART_C7816_INIT_MASK) >> UART_C7816_INIT_SHIFT)
#define UART_BRD_C7816_INIT(base) (BME_UBFX8(&UART_C7816_REG(base), UART_C7816_INIT_SHIFT, UART_C7816_INIT_WIDTH))

/*! @brief Set the INIT field to a new value. */
#define UART_WR_C7816_INIT(base, value) (UART_RMW_C7816(base, UART_C7816_INIT_MASK, UART_C7816_INIT(value)))
#define UART_BWR_C7816_INIT(base, value) (BME_BFI8(&UART_C7816_REG(base), ((uint8_t)(value) << UART_C7816_INIT_SHIFT), UART_C7816_INIT_SHIFT, UART_C7816_INIT_WIDTH))
/*@}*/

/*!
 * @name Register UART_C7816, field ANACK[3] (RW)
 *
 * When this field is set, the receiver automatically generates a NACK response
 * if a parity error occurs or if INIT is set and an invalid initial character is
 * detected. A NACK is generated only if TTYPE = 0. If ANACK is set, the UART
 * attempts to retransmit the data indefinitely. To stop retransmission attempts,
 * clear C2[TE] or ISO_7816E and do not set until S1[TC] sets C2[TE] again.
 *
 * Values:
 * - 0 - No NACK is automatically generated.
 * - 1 - A NACK is automatically generated if a parity error is detected or if
 *     an invalid initial character is detected.
 */
/*@{*/
/*! @brief Read current value of the UART_C7816_ANACK field. */
#define UART_RD_C7816_ANACK(base) ((UART_C7816_REG(base) & UART_C7816_ANACK_MASK) >> UART_C7816_ANACK_SHIFT)
#define UART_BRD_C7816_ANACK(base) (BME_UBFX8(&UART_C7816_REG(base), UART_C7816_ANACK_SHIFT, UART_C7816_ANACK_WIDTH))

/*! @brief Set the ANACK field to a new value. */
#define UART_WR_C7816_ANACK(base, value) (UART_RMW_C7816(base, UART_C7816_ANACK_MASK, UART_C7816_ANACK(value)))
#define UART_BWR_C7816_ANACK(base, value) (BME_BFI8(&UART_C7816_REG(base), ((uint8_t)(value) << UART_C7816_ANACK_SHIFT), UART_C7816_ANACK_SHIFT, UART_C7816_ANACK_WIDTH))
/*@}*/

/*!
 * @name Register UART_C7816, field ONACK[4] (RW)
 *
 * When this field is set, the receiver automatically generates a NACK response
 * if a receive buffer overrun occurs, as indicated by S1[OR]. In many systems,
 * this results in the transmitter resending the packet that overflowed until the
 * retransmit threshold for that transmitter is reached. A NACK is generated only
 * if TTYPE=0. This field operates independently of ANACK. See . Overrun NACK
 * considerations
 *
 * Values:
 * - 0 - The received data does not generate a NACK when the receipt of the data
 *     results in an overflow event.
 * - 1 - If the receiver buffer overflows, a NACK is automatically sent on a
 *     received character.
 */
/*@{*/
/*! @brief Read current value of the UART_C7816_ONACK field. */
#define UART_RD_C7816_ONACK(base) ((UART_C7816_REG(base) & UART_C7816_ONACK_MASK) >> UART_C7816_ONACK_SHIFT)
#define UART_BRD_C7816_ONACK(base) (BME_UBFX8(&UART_C7816_REG(base), UART_C7816_ONACK_SHIFT, UART_C7816_ONACK_WIDTH))

/*! @brief Set the ONACK field to a new value. */
#define UART_WR_C7816_ONACK(base, value) (UART_RMW_C7816(base, UART_C7816_ONACK_MASK, UART_C7816_ONACK(value)))
#define UART_BWR_C7816_ONACK(base, value) (BME_BFI8(&UART_C7816_REG(base), ((uint8_t)(value) << UART_C7816_ONACK_SHIFT), UART_C7816_ONACK_SHIFT, UART_C7816_ONACK_WIDTH))
/*@}*/

/*******************************************************************************
 * UART_IE7816 - UART 7816 Interrupt Enable Register
 ******************************************************************************/

/*!
 * @brief UART_IE7816 - UART 7816 Interrupt Enable Register (RW)
 *
 * Reset value: 0x00U
 *
 * The IE7816 register controls which flags result in an interrupt being issued.
 * This register is specific to 7816 functionality, the corresponding flags that
 * drive the interrupts are not asserted when 7816E is not set/enabled. However,
 * these flags may remain set if they are asserted while 7816E was set and not
 * subsequently cleared. This register may be read or written to at any time.
 */
/*!
 * @name Constants and macros for entire UART_IE7816 register
 */
/*@{*/
#define UART_RD_IE7816(base)     (UART_IE7816_REG(base))
#define UART_WR_IE7816(base, value) (UART_IE7816_REG(base) = (value))
#define UART_RMW_IE7816(base, mask, value) (UART_WR_IE7816(base, (UART_RD_IE7816(base) & ~(mask)) | (value)))
#define UART_SET_IE7816(base, value) (BME_OR8(&UART_IE7816_REG(base), (uint8_t)(value)))
#define UART_CLR_IE7816(base, value) (BME_AND8(&UART_IE7816_REG(base), (uint8_t)(~(value))))
#define UART_TOG_IE7816(base, value) (BME_XOR8(&UART_IE7816_REG(base), (uint8_t)(value)))
/*@}*/

/*
 * Constants & macros for individual UART_IE7816 bitfields
 */

/*!
 * @name Register UART_IE7816, field RXTE[0] (RW)
 *
 * Values:
 * - 0 - The assertion of IS7816[RXT] does not result in the generation of an
 *     interrupt.
 * - 1 - The assertion of IS7816[RXT] results in the generation of an interrupt.
 */
/*@{*/
/*! @brief Read current value of the UART_IE7816_RXTE field. */
#define UART_RD_IE7816_RXTE(base) ((UART_IE7816_REG(base) & UART_IE7816_RXTE_MASK) >> UART_IE7816_RXTE_SHIFT)
#define UART_BRD_IE7816_RXTE(base) (BME_UBFX8(&UART_IE7816_REG(base), UART_IE7816_RXTE_SHIFT, UART_IE7816_RXTE_WIDTH))

/*! @brief Set the RXTE field to a new value. */
#define UART_WR_IE7816_RXTE(base, value) (UART_RMW_IE7816(base, UART_IE7816_RXTE_MASK, UART_IE7816_RXTE(value)))
#define UART_BWR_IE7816_RXTE(base, value) (BME_BFI8(&UART_IE7816_REG(base), ((uint8_t)(value) << UART_IE7816_RXTE_SHIFT), UART_IE7816_RXTE_SHIFT, UART_IE7816_RXTE_WIDTH))
/*@}*/

/*!
 * @name Register UART_IE7816, field TXTE[1] (RW)
 *
 * Values:
 * - 0 - The assertion of IS7816[TXT] does not result in the generation of an
 *     interrupt.
 * - 1 - The assertion of IS7816[TXT] results in the generation of an interrupt.
 */
/*@{*/
/*! @brief Read current value of the UART_IE7816_TXTE field. */
#define UART_RD_IE7816_TXTE(base) ((UART_IE7816_REG(base) & UART_IE7816_TXTE_MASK) >> UART_IE7816_TXTE_SHIFT)
#define UART_BRD_IE7816_TXTE(base) (BME_UBFX8(&UART_IE7816_REG(base), UART_IE7816_TXTE_SHIFT, UART_IE7816_TXTE_WIDTH))

/*! @brief Set the TXTE field to a new value. */
#define UART_WR_IE7816_TXTE(base, value) (UART_RMW_IE7816(base, UART_IE7816_TXTE_MASK, UART_IE7816_TXTE(value)))
#define UART_BWR_IE7816_TXTE(base, value) (BME_BFI8(&UART_IE7816_REG(base), ((uint8_t)(value) << UART_IE7816_TXTE_SHIFT), UART_IE7816_TXTE_SHIFT, UART_IE7816_TXTE_WIDTH))
/*@}*/

/*!
 * @name Register UART_IE7816, field GTVE[2] (RW)
 *
 * Values:
 * - 0 - The assertion of IS7816[GTV] does not result in the generation of an
 *     interrupt.
 * - 1 - The assertion of IS7816[GTV] results in the generation of an interrupt.
 */
/*@{*/
/*! @brief Read current value of the UART_IE7816_GTVE field. */
#define UART_RD_IE7816_GTVE(base) ((UART_IE7816_REG(base) & UART_IE7816_GTVE_MASK) >> UART_IE7816_GTVE_SHIFT)
#define UART_BRD_IE7816_GTVE(base) (BME_UBFX8(&UART_IE7816_REG(base), UART_IE7816_GTVE_SHIFT, UART_IE7816_GTVE_WIDTH))

/*! @brief Set the GTVE field to a new value. */
#define UART_WR_IE7816_GTVE(base, value) (UART_RMW_IE7816(base, UART_IE7816_GTVE_MASK, UART_IE7816_GTVE(value)))
#define UART_BWR_IE7816_GTVE(base, value) (BME_BFI8(&UART_IE7816_REG(base), ((uint8_t)(value) << UART_IE7816_GTVE_SHIFT), UART_IE7816_GTVE_SHIFT, UART_IE7816_GTVE_WIDTH))
/*@}*/

/*!
 * @name Register UART_IE7816, field ADTE[3] (RW)
 *
 * Values:
 * - 0 - The assertion of IS7816[ADT] does not result in the generation of an
 *     interrupt.
 * - 1 - The assertion of IS7816[ADT] results in the generation of an interrupt.
 */
/*@{*/
/*! @brief Read current value of the UART_IE7816_ADTE field. */
#define UART_RD_IE7816_ADTE(base) ((UART_IE7816_REG(base) & UART_IE7816_ADTE_MASK) >> UART_IE7816_ADTE_SHIFT)
#define UART_BRD_IE7816_ADTE(base) (BME_UBFX8(&UART_IE7816_REG(base), UART_IE7816_ADTE_SHIFT, UART_IE7816_ADTE_WIDTH))

/*! @brief Set the ADTE field to a new value. */
#define UART_WR_IE7816_ADTE(base, value) (UART_RMW_IE7816(base, UART_IE7816_ADTE_MASK, UART_IE7816_ADTE(value)))
#define UART_BWR_IE7816_ADTE(base, value) (BME_BFI8(&UART_IE7816_REG(base), ((uint8_t)(value) << UART_IE7816_ADTE_SHIFT), UART_IE7816_ADTE_SHIFT, UART_IE7816_ADTE_WIDTH))
/*@}*/

/*!
 * @name Register UART_IE7816, field INITDE[4] (RW)
 *
 * Values:
 * - 0 - The assertion of IS7816[INITD] does not result in the generation of an
 *     interrupt.
 * - 1 - The assertion of IS7816[INITD] results in the generation of an
 *     interrupt.
 */
/*@{*/
/*! @brief Read current value of the UART_IE7816_INITDE field. */
#define UART_RD_IE7816_INITDE(base) ((UART_IE7816_REG(base) & UART_IE7816_INITDE_MASK) >> UART_IE7816_INITDE_SHIFT)
#define UART_BRD_IE7816_INITDE(base) (BME_UBFX8(&UART_IE7816_REG(base), UART_IE7816_INITDE_SHIFT, UART_IE7816_INITDE_WIDTH))

/*! @brief Set the INITDE field t