 /* main.c              (c) 2015 Freescale Semiconductor, Inc.
 * Descriptions: ADC functions for conversion example
 * 28 Sept 2015 Pedro Aguayo: Initial version
 * 16 Dec 2015 S Mihalik, O Romero: Modified code
 */

#include "derivative.h"
#include "ADC.h"
#include "clocks.h"
#define PTE7  7          						/* Port PTE7 output to blue LED */
#define PTH0 24          						/* Port PTH0 output to red LED */
#define PTH1 25          						/* Port PTH1 output to green LED */

uint32_t adcResultInMv = 0;

int main(void){
  int counter = 0;
  int j;

  init_clks_FEE_40MHz();        					/* KEA128 8MHz xtal: core 40 MHz, bus 20MHz */
  GPIOB_PDDR |= 1<<PTE7 | 1<< PTH0 | 1<<PTH1;   	/* Output ports to LEDs */
  GPIOB_PIDR &= 1<<PTE7 | 1<< PTH0 | 1<<PTH1;   	/* Disable inputs (default) */

  init_ADC();  		 /* Init. ADC: Single conversion, SW trigger; enable adc chans 10 & 22 */

  for(;;) {

	convertAdcChan(10);                 /* Convert Channel AD10 to pot on EVB */
	while(adc_complete()==0){}          /* Wait for conversion complete flag */

	adcResultInMv = read_adc_chx();     /* Get channel's conversion results in mv */

    if (adcResultInMv > 3750) {         /* If result > 3.75V */
      GPIOB_PSOR |= 1<<PTE7 | 1<<PTH1;  /* turn off blue, green LEDs */
      GPIOB_PCOR |= 1<<PTH0;            /* turn on red LED */
    }
    else if (adcResultInMv > 2500) {    /* If result > 2.5V */
      GPIOB_PSOR |= 1<<PTE7 | 1<<PTH0;  /* turn off blue, red 2 LEDs */
      GPIOB_PCOR |= 1<<PTH1;     	    /* turn on green LED */
    }
    else if (adcResultInMv > 1250) {    /* If result > 1.25V */
      GPIOB_PSOR |= 1<<PTH0 | 1<<PTH1;  /* turn off red, green LEDs */
      GPIOB_PCOR |= 1<<PTE7;     	    /* turn on blue LED */
    }
    else {
      GPIOB_PSOR |= 1<<PTE7 | 1<< PTH0 | 1<<PTH1; /* Turn off all LEDs */
    }

    convertAdcChan(11);                 /* Convert Channel AD11 (pin PTC3) */
    while(adc_complete()==0){}          /* Wait for conversion complete flag */
    adcResultInMv = read_adc_chx();     /* Get channel's conversion results in mv */

    counter++;
  }
}
