/******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2013 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
***************************************************************************
*
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
* THE POSSIBILITY OF SUCH DAMAGE.
*
***************************************************************************//*!
*
* @file systick.c
*
* @author Freescale
*
* @version 0.0.1
*
* @date Jun. 25, 2013
*
* @brief provide systick utility routines.
*
*******************************************************************************/

#include "common.h"
#include "systick.h"

uint32_t cnt_start_value;
uint32_t cnt_end_value;
uint32_t overhead;

#if 0
  __IO uint32_t CTRL;                    /*!< Offset: 0x000 (R/W)  SysTick Control and Status Register */
  __IO uint32_t LOAD;                    /*!< Offset: 0x004 (R/W)  SysTick Reload Value Register       */
  __IO uint32_t VAL;                     /*!< Offset: 0x008 (R/W)  SysTick Current Value Register      */
  __I  uint32_t CALIB;                   /*!< Offset: 0x00C (R/ )  SysTick Calibration Register        */
#endif
void systick_init(void)
{
	SysTick->VAL = 0x0;	/* clear current timer value */
    SysTick->LOAD = 0x00FFFFFF;
    SysTick->CTRL = SysTick_CTRL_CLKSOURCE_Msk | SysTick_CTRL_ENABLE_Msk;   
}

void systick_disable(void)
{
    SysTick->CTRL &= ~SysTick_CTRL_ENABLE_Msk;
}

void cal_systick_read_overhead(void)
{
  	uint32_t cnt_start_value;
    uint32_t cnt_end_value;
	
	cnt_start_value = SysTick->VAL;
  
    cnt_end_value = SysTick->VAL;
	
	overhead = cnt_start_value - cnt_end_value;
	
#ifdef DEBUG_PRINT
	printf("systick start value: 0x%x\n\r", (unsigned int)cnt_start_value);
	printf("systick end value: 0x%x\n\r", (unsigned int) cnt_end_value);
	printf("systick current value read overhead: 0x%x\n\r", (unsigned int)overhead);
#endif
    
}

#define US_TO_COUNT(us, Hz)    (uint32_t)((uint32_t)us * (Hz / 1000000U))
#define COUNT_TO_US(count, Hz) (uint32_t)((uint32_t)(count * 1000000U) / Hz)
#define MS_TO_COUNT(ms, Hz)    (uint32_t)((uint32_t)ms * (Hz / 1000U))
#define COUNT_TO_MS(count, Hz) (uint32_t)((uint32_t)(count * 1000U) / Hz)

#pragma weak DelayMs
void DelayMs(uint32_t ms)
{
    volatile uint32_t temp;
    volatile  uint32_t i;
    SysTick->LOAD = US_TO_COUNT(ms, BUS_CLK_HZ*2);
    SysTick->CTRL |= SysTick_CTRL_ENABLE_Msk | SysTick_CTRL_CLKSOURCE_Msk;
    for(i = 0; i < ms; i++)
	{
		SysTick->VAL = 0;
		do
		{
			temp = SysTick->CTRL;
		}
        while((temp & SysTick_CTRL_ENABLE_Msk) && !(temp & SysTick_CTRL_COUNTFLAG_Msk));
	}
}

#pragma weak DelayUs
void DelayUs(uint32_t us)
{
    uint32_t temp;
    SysTick->LOAD = US_TO_COUNT(us, BUS_CLK_HZ*2);
    SysTick->VAL = 0;
    SysTick->CTRL |= SysTick_CTRL_ENABLE_Msk | SysTick_CTRL_CLKSOURCE_Msk;
    do
    {
        temp = SysTick->CTRL;
    }
    while((temp & SysTick_CTRL_ENABLE_Msk) && !(temp & SysTick_CTRL_COUNTFLAG_Msk));
}
