/******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2013 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
***************************************************************************
*
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
* THE POSSIBILITY OF SUCH DAMAGE.
*
*******************************************************************************/


#include "common.h"
#include "flash.h"
#include "uart.h"
#include "kbi.h"
#include "sysinit.h"
#include "systick.h"
#include "mscan.h"
#include "mscan_api.h"

#include "xmodem.h"

#define __KOBE_VERSION__	"1.0.0"
#define APP_IMAGE_START     0x5000

#define NODE_ID1			0x801
#define NODE_ID2			0x802
#define NODE_ID3			0x803

/* define MACRO for filter,here define a dual filter to receive 
   extend and standard frame from ID(NODE_ID2&NODE_ID3) */
#define CAN_IDAR0			NODE_ID2<<1
#define CAN_IDAR1			NODE_ID3<<1
#define CAN_IDMR0			0x1|(uint32_t)0x18<<16 /* received all standard and extend frame from ID(NODE_ID2) */
#define CAN_IDMR1			0x1|(uint32_t)0x18<<16 


ItemInfoType     sCANTxItemInfo;
MSCAN_FrameType  sRxFrameInfo;

void download_app(void);
void bootup_application(uint32_t appEntry, uint32_t appStack);
bool is_enter_menu_triggered(void);

int main (void)
{	
    uint8_t i;
    uint32_t appEntry, appStack;

    /* UART & system */
    sysinit();
    UART_SetCallback(xmodem_uart_handler);
    UART_EnableInterrupt(UART1, UART_RxBuffFullInt);
    NVIC_EnableIRQ(UART1_IRQn);
	printf("Kobe version: %s\r\n",__KOBE_VERSION__);
    
    /* flash */
    FLASH_Init(BUS_CLK_HZ);

    /* CAN init */
    MSCAN_ConfigType sMSCANConfig = {0};
    MSCAN_GlobeVaribleInit(MSCAN);
    SIM->PINSEL1 |= SIM_PINSEL1_MSCANPS_MASK;
    
    sMSCANConfig.sBaudRateSetting.SJW = BAUD_RATE_SJW;
    sMSCANConfig.sBaudRateSetting.BRP = BAUD_RATE_BRP;
    sMSCANConfig.sBaudRateSetting.SAMP = BAUD_RATE_SAMP;
	sMSCANConfig.sBaudRateSetting.TSEG1= BAUD_RATE_TSEG1;
	sMSCANConfig.sBaudRateSetting.TSEG2= BAUD_RATE_TSEG2;
	sMSCANConfig.u32IDAR0 = (CAN_IDAR0);
	sMSCANConfig.u32IDAR1 = (CAN_IDAR1);
	sMSCANConfig.u32IDMR0 = (CAN_IDMR0);
	sMSCANConfig.u32IDMR1 = (CAN_IDMR1);
	sMSCANConfig.u8IDARMode = ID_ACCEPT_MODE_TWO32;
	sMSCANConfig.sSetting.bCanEn = 1;
    sMSCANConfig.sSetting.bCLKSRC = 1;
  //  sMSCANConfig.sSetting.bLoopModeEn = 1;
	sMSCANConfig.sSetting.bRxFullIEn=1;
	sMSCANConfig.sSetting.bTimerEn=1;
	sMSCANConfig.sSetting.bOverRunIEn=1;
	sMSCANConfig.sSetting.bStatusChangeIEn=1;
	//sMSCANConfig.sSetting.bTxEmptyIEn=1;
	CAN_Init(MSCAN,&sMSCANConfig);

	//Initialize the Tx information
	sCANTxItemInfo.bIsExtOrStand = 1;
	sCANTxItemInfo.bIsRemoteFrame = 0;
	sCANTxItemInfo.ID_Type.ID = NODE_ID1;
	sCANTxItemInfo.u32DataLength = 8;
	sCANTxItemInfo.u8BPR = 0x80;
     
    xmodem_init();

	if(is_enter_menu_triggered())
	{
        printf("enter bootlaoder mode...\r\n");
        download_app();
	}
    
	appStack = *(uint32_t*)APP_IMAGE_START;
	appEntry = *(uint32_t*)(APP_IMAGE_START + 4);
    printf("appStack:0x%X\r\n", appStack);
    printf("appEntry:0x%X\r\n", appEntry);
    bootup_application(appEntry,appStack);
}


void download_app(void)
{
	while(1)
	{
		if(xmodem_is_active())
        {
			xmodem_download();
            break;
        }
	}
}

bool is_enter_menu_triggered(void)
{
    GPIOB->PDDR &= ~(1<<28);
    GPIOB->PIDR &= ~(1<<28);
    DelayMs(1);
    if(GPIOB->PDIR & (1<<28))
    {
        return false;
    }
    else
    {
        return true;
    }
}


	
void bootup_application(uint32_t appEntry, uint32_t appStack)
{
	static void (*jump_to_application)(void);
	static uint32_t stack_pointer;
	
	//shutdown_drivers();
	
    jump_to_application = (void (*)(void))appEntry;
    stack_pointer = appStack;
	SCB->VTOR = 0x5000;
	__set_MSP(stack_pointer);
	__set_PSP(stack_pointer);
	jump_to_application();
}

