#/****************************************************************************/
#/*                                                                          */
#/* FILE NAME     :  copy_handler_core0.s                                    */
#/* DESCRIPTION   :  this code copies the IVOR vector table and the IVOR4    */
#/*                  interrupt handler to IMEM                               */
#/* DATE          :  July 31, 2013                                           */
#/*                                                                          */
#/****************************************************************************/

    .global      copy_handler_to_imem_c0
    .section    .vletext, "vax"
    .vle

copy_handler_to_imem_c0:
#/* load base address of IMEM (from linker file) */
    e_lis   r4, __IMEM_START_CPU0@h
    e_or2i  r4, __IMEM_START_CPU0@l
#/* load starting address of IVOR vectors */
    e_lis   r7, IVORnTable_core0@h
    e_or2i  r7, IVORnTable_core0@l
#/* calculate size of table and move to ctr for loop count */
    e_lis   r5, end_of_IVOR_table_core0@h
    e_or2i  r5, end_of_IVOR_table_core0@l
    subf    r5, r7, r5
    mtctr   r5
#/* loop and byte copy IVOR vector code to IMEM */
IVOR_loop:
    e_lbz   r6, 0(r7)
    e_stb   r6, 0(r4)

    se_addi r4, 1
    se_addi r7, 1
    e_bdnz  IVOR_loop

#/* load IMEM offset adress of IVOR4 handler (from linker file) */
    e_lis   r4, __IVOR4_HANDLER_C0_START@h
    e_or2i  r4, __IVOR4_HANDLER_C0_START@l
#/* load IVOR4 handler start address */    
    e_lis   r7, IVOR4_Handler_core0@h
    e_or2i  r7, IVOR4_Handler_core0@l

#/* calculate size of handler and move to ctr for loop count */
    e_lis   r5, end_of_handler_c0@h
    e_or2i  r5, end_of_handler_c0@l
    subf    r5, r7, r5
    mtctr   r5

#/* loop and byte copy Handler code to IMEM */
HANDLER_loop:
    e_lbz   r6, 0(r7)
    e_stb   r6, 0(r4)

    se_addi r4, 1
    se_addi r7, 1

    e_bdnz  HANDLER_loop

#/* return */    
    se_blr
