/*****************************************************************************/
/*                                                                           */
/*  FILE NAME     :  mcu_init.c                                              */
/*  DESCRIPTION   :  Example source for configure clocks and run modes       */
/*  NOTES         :  This code is executed by the boot core (core 1), and    */
/*                   sets up global configuration for clocks and run modes.  */
/*                   It also configures core 0 and lock step core addresses  */
/*                   and enables them for execution at the run mode change.  */
/*                                                                           */
/*****************************************************************************/

#include "../headers/project.h"
extern IVOR4_Handler_core1();

extern const uint32_t IntcIsrVectorTable[];


/*****************************************************************************/
/* Clock_and_Mode_Init                                                       */ 
/* Configures clocks and sets up run modes - This code is run by core 1 as   */
/* the boot core.                                                            */
/*****************************************************************************/

void copy_handler_to_imem(void){

    unsigned int x;
    unsigned int *read_ptr;
    unsigned int *write_ptr;

    write_ptr = (int)0x51000000;
    
    read_ptr = (int)&IVOR4_Handler_core1;

    for (x = 0; x < 0x44; x++){
        *write_ptr = *read_ptr;
        write_ptr++;
        read_ptr++;
    }
    
    

}
