/*----------------------------------------------------------*/
/* Linker file core MPC5746R, single .elf.                  */  
/* Links to execute from flash memory                       */
/*                                                          */
/*----------------------------------------------------------*/

DEFAULTS {

// Define Boot Header area Size
   BOOTFLASH_SIZE = 0x20
// Define Boot Header area Base Address
   BOOTFLASH_BASE_ADDR = 0x01000000

// Define Core 1 Flash Allocation
   C1_FLASH_SIZE = 256K - BOOTFLASH_SIZE   
// Define Core 1 Flash Base Address 
   C1_FLASH_BASE_ADDR =  BOOTFLASH_BASE_ADDR + BOOTFLASH_SIZE

// Define Core 0 Flash Allocation
   C0_FLASH_SIZE = 256K
// Define Core 0 Flash Base Address 
   C0_FLASH_BASE_ADDR =  0x01040000

// Define Standby SRAM
   STANDBY_RAM_SIZE = 32K
// Define Standby SRAM Base Address   
   STANDBY_RAM_BASE_ADDRESS = 0x40000000
 
// Define Core 0 SRAM Allocation  
   C0_SRAM_SIZE =  112K    
// Define Processor 2 SRAM Base Address
   C0_SRAM_BASE_ADDR = 0x40008000

// Define Core 1 SRAM Allocation  
   C1_SRAM_SIZE =  112K    
// Define Processor 1 SRAM Base Address
   C1_SRAM_BASE_ADDR = 0x40024000   


// Define Core 1 IMEM  
   C1_IMEM_SIZE =  16K    
// Define Processor 1 IMEM Base Address
   C1_IMEM_BASE_ADDR = 0x51000000

// Define Core 0 IMEM  
   C0_IMEM_SIZE =  16K    
// Define Processor 1 IMEM Base Address
   C0_IMEM_BASE_ADDR = 0x50000000   

// Define Core 1 DMEM  
   C1_DMEM_SIZE =  32K    
// Define Processor 1 DMEM Base Address
   C1_DMEM_BASE_ADDR = 0x51800000   

// Define Core 0 DMEM  
   C0_DMEM_SIZE =  32K    
// Define Processor 1 DMEM Base Address
   C0_DMEM_BASE_ADDR = 0x50800000   

// Stack located at end of DMEM     
// Define Stack Size
   STACK_SIZE = 4K       
       
}

/*---------- DO NOT MODIFY ANYTHING BELOW THIS POINT -------*/
MEMORY {
//    default_utest_flash: org = DCF_DEFAULT_BASE_ADDR, len = DCF_DEFAULT_SIZE
    bootflash    : org = BOOTFLASH_BASE_ADDR, len = BOOTFLASH_SIZE
    c1_int_flash : org = C1_FLASH_BASE_ADDR,  len = C1_FLASH_SIZE
    c1_int_sram  : org = C1_SRAM_BASE_ADDR,   len = C1_SRAM_SIZE
    c1_int_imem  : org = C1_IMEM_BASE_ADDR,   len = C1_IMEM_SIZE
    c1_int_dmem  : org = C1_DMEM_BASE_ADDR,   len = C1_DMEM_SIZE-STACK_SIZE
    c1_stack_ram : org = (C1_DMEM_BASE_ADDR+C1_DMEM_SIZE-STACK_SIZE)  len = STACK_SIZE

    c0_int_flash : org = C0_FLASH_BASE_ADDR,  len = C0_FLASH_SIZE
    c0_int_sram  : org = C0_SRAM_BASE_ADDR,   len = C0_SRAM_SIZE
    c0_int_imem  : org = C0_IMEM_BASE_ADDR,   len = C0_IMEM_SIZE
    c0_int_dmem  : org = C0_DMEM_BASE_ADDR,   len = C0_DMEM_SIZE-STACK_SIZE
    c0_stack_ram : org = (C0_DMEM_BASE_ADDR+C1_DMEM_SIZE-STACK_SIZE)  len = STACK_SIZE
}

SECTIONS
{
    .boot_header      : {} >  bootflash
    .init_core1       : {} >  c1_int_flash
    .text             : {} > .              /* BookE Code   */
    .vletext          : {} > .              /* VLE Code */
                                            
    .fixaddr          : {} > .              /* Required for         */
    .fixtype          : {} > .              /* compatibility with   */
    .secinfo          : {} > .              /* GHS provided startup */
    .syscall          : {} > .              /* code                 */
        
    .rodata  : {*(.rdata) *(.rodata)} > .   /* Read Only Data */
     
    .ROM.data   ROM(.data)       : {} > .   /* Store Initialised RAM Variables */
    .ROM.sdata  ROM(.sdata)      : {} > .   /* temporarily in Flash            */
    .xptn_vectors_core1 ALIGN(0x100)   : {} > .   /* core 1 Exception Vector Table (IVPR) - align 256 byte boundary */
    .isrvectbl    ALIGN(0x1000)  : {} > .   /* ISR Vector Table - must be 4K aligned */
    
    .data             : {} > c1_int_sram     /* Initialised Data                */
    .bss              : {} > .              /* Uninitialised Data              */
    .sdabase ALIGN (2): {} > .              /* Base location for SDA Area      */
    .sdata            : {} > .              /* Small Initialised Data (Area1)  */
    .sbss             : {} > .              /* Small Uninitialised Data (Area1)*/
    .sdata2           : {} > .              /* Small Initialised Constant Data */
    .sbss2            : {} > .              /* Small Uninitialised Data (Area2)*/
    .init_core0       : {} > c0_int_flash
    .xptn_vectors_core0 ALIGN(0x100)   : {} > .   /* core 0 Exception Vector Table (IVPR) - align 256 byte boundary */
    
    .heap   ALIGN(16) PAD(1K)         : {} > c1_int_sram   /* Heap Area  */
    .stack  ALIGN(4)  PAD(STACK_SIZE) : {} > c1_stack_ram  /* Stack Area */


/*-------- LABELS USED IN CODE -------------------------------*/
    __IVPR_CORE0 = ADDR(.xptn_vectors_core0);
    __IVPR_CORE1 = ADDR(.xptn_vectors_core1);

/* Label for IMEM and DMEM Init */
    __IMEM_START_CPU1 = C1_IMEM_BASE_ADDR;
    __IMEM_END_CPU1   = C1_IMEM_BASE_ADDR + C1_IMEM_SIZE;

    __IMEM_START_CPU0 = C0_IMEM_BASE_ADDR;
    __IMEM_END_CPU0   = C0_IMEM_BASE_ADDR + C0_IMEM_SIZE;

    __DMEM_START_CPU1 = C1_DMEM_BASE_ADDR;
    __DMEM_END_CPU1   = C1_DMEM_BASE_ADDR + C1_DMEM_SIZE-STACK_SIZE;

    __DMEM_START_CPU0 = C0_DMEM_BASE_ADDR;
    __DMEM_END_CPU0   = C0_DMEM_BASE_ADDR + C0_DMEM_SIZE-STACK_SIZE;

/* Labels for Copying Initialised Data from Flash to RAM */
    __DATA_SRAM_ADDR_CPU1  = ADDR(.data);
    __SDATA_SRAM_ADDR_CPU1 = ADDR(.sdata);
#    __DATA_SRAM_ADDR_CPU0  = ADDR(.data);
#    __SDATA_SRAM_ADDR_CPU0 = ADDR(.sdata);

    __DATA_SIZE_CPU1   = SIZEOF(.data);
    __SDATA_SIZE_CPU1  = SIZEOF(.sdata);
#    __DATA_SIZE_CPU0   = SIZEOF(.data);
#    __SDATA_SIZE_CPU0  = SIZEOF(.sdata);

    __DATA_ROM_ADDR_CPU1  = ADDR(.ROM.data);
    __SDATA_ROM_ADDR_CPU1 = ADDR(.ROM.sdata);
#    __DATA_ROM_ADDR_CPU0  = ADDR(.ROM.data);
#    __SDATA_ROM_ADDR_CPU0 = ADDR(.ROM.sdata);

/* Labels for stack */
    __STACK_SIZE = STACK_SIZE;
    __STACK_START_CPU1 = C1_DMEM_BASE_ADDR+C1_DMEM_SIZE-STACK_SIZE;
    __STACK_END_CPU1   = C1_DMEM_BASE_ADDR+C1_DMEM_SIZE;
    __STACK_START_CPU0 = C0_DMEM_BASE_ADDR+C0_DMEM_SIZE-STACK_SIZE;
    __STACK_END_CPU0   = C0_DMEM_BASE_ADDR+C0_DMEM_SIZE;


/* These special symbols mark the bounds of RAM and ROM memory. */
/* They are used by the MULTI debugger.                         */
    __ghs_ramstart  = MEMADDR(c0_int_sram);
    __ghs_ramend    = MEMENDADDR(c1_int_sram);
    __ghs_romstart  = MEMADDR(c1_int_flash);
    __ghs_romend    = MEMENDADDR(c1_int_flash);

    __ghs_rambootcodestart = 0;           /* zero for ROM image */
    __ghs_rambootcodeend = 0;             /* zero for ROM image */
    __ghs_rombootcodestart = MEMADDR(c1_int_flash);
    __ghs_rombootcodeend = MEMENDADDR(c1_int_flash);

}


