
/*****************************************************************************
 * (c) Copyright 2010, Freescale Semiconductor Inc.
 * ALL RIGHTS RESERVED.
 ***************************************************************************//*!
 * @file      LCDHDW.h
 * @author    B34185
 * @version   1.0.1.0
 * @date      Dec-6-2010
 * @brief     LCD driver configuration file for LCD type IS18080P..
 ******************************************************************************/
#ifndef __LCDHWD_H
    #define __LCDHWD_H

    #define DIM(x)                (sizeof(x)/sizeof(x[0]))

    #define _LCD_CHARNUM          (9)                   // number of LCD segment
    #define _LCDTYPE              (1)                   // 1 byte to complete one character
    #define  CharacterPlace(LCDn) *((unsigned char *)&LCD_WF3TO0 + LCDn)

    #define SymbolON(LCDn, mask)                                              \
    {                                                                         \
      *((unsigned char *)&LCD_WF3TO0 + LCDn) |= (1<<(mask)); ;                \
    }
    
    #define SymbolOFF(LCDn, mask)                                             \
    {                                                                         \
      *((unsigned char *)&LCD_WF3TO0 + LCDn) &= ~(1<<(mask));                 \
    }

    #define SymbolTGL(LCDn, mask)                                             \
    {                                                                         \
      *((unsigned char *)&LCD_WF3TO0 + LCDn) ^= (1<<(mask));                  \
    }
    
    #define SegmentsON(LCDn, mask)                                            \
    {                                                                         \
      *((unsigned char *)&LCD_WF3TO0 + LCDn) |= (mask);                       \
    }

    #define SegmentsOFF(LCDn, mask)                                           \
    {                                                                         \
      *((unsigned char *)&LCD_WF3TO0 + LCDn) &= ~(mask);                      \
    }
    
    /* Indicate how character is connected to LCDn          */
    #define   Char0     CharacterPlace(42)
    #define   Char1     CharacterPlace(41)
    #define   Char2     CharacterPlace(40)
    #define   Char3     CharacterPlace(27)
    #define   Char4     CharacterPlace(26)
    #define   Char5     CharacterPlace(25)
    #define   Char6     CharacterPlace(24)
    #define   Char7     CharacterPlace(23)
    #define   Char8     CharacterPlace(22)

    /* Special symbols ON */
/***************************************************************************//*!
 * @brief   Macro displays _LCD_CHAR_V_S3_ON segments.
 * @note    Implemented as inlined macro.
 ******************************************************************************/
    #define _LCD_CHAR_V_S3_ON    SymbolON(44,0)

/***************************************************************************//*!
 * @brief   Macro displays _LCD_CHAR_I_S8_ON segments.
 * @note    Implemented as inlined macro.
 ******************************************************************************/
    #define _LCD_CHAR_I_S8_ON    SymbolON(44,2)

/***************************************************************************//*!
 * @brief   Macro displays _LCD_CHAR_V_S6_ON segments.
 * @note    Implemented as inlined macro.
 ******************************************************************************/
    #define _LCD_CHAR_V_S6_ON    SymbolON(44,5)
    
    /***************************************************************************//*!
 * @brief   Macro displays _LCD_CHAR_V_S9_ON segments.
 * @note    Implemented as inlined macro.
 ******************************************************************************/
    #define _LCD_CHAR_V_S9_ON    SymbolON(44,4)

/***************************************************************************//*!
 * @brief   Macro displays _LCD_CHAR_V_S7_ON segments.
 * @note    Implemented as inlined macro.
 ******************************************************************************/
    #define _LCD_CHAR_V_S7_ON    SymbolON(45,1)

/***************************************************************************//*!
 * @brief   Macro displays _LCD_CHAR_V_S12_ON segments.
 * @note    Implemented as inlined macro.
 ******************************************************************************/
    #define _LCD_CHAR_V_S12_ON   SymbolON(45,2)

/***************************************************************************//*!
 * @brief   Macro displays _LCD_CHAR_V_S13_ON segments.
 * @note    Implemented as inlined macro.
 ******************************************************************************/
    #define _LCD_CHAR_V_S13_ON   SymbolON(45,3)

/***************************************************************************//*!
 * @brief   Macro displays _LCD_CHAR_V_S11_ON segments.
 * @note    Implemented as inlined macro.
 ******************************************************************************/
    #define _LCD_CHAR_V_S11_ON   SymbolON(45,4)

/***************************************************************************//*!
 * @brief   Macro displays _LCD_CHAR_I_S12_ON segments.
 * @note    Implemented as inlined macro.
 ******************************************************************************/
    #define _LCD_CHAR_I_S12_ON   SymbolON(45,2)

/***************************************************************************//*!
 * @brief   Macro displays _LCD_DOT_P3_ON segments.
 * @note    Implemented as inlined macro.
 ******************************************************************************/
    #define _LCD_DOT_P3_ON       SymbolON(21,1)
    
/***************************************************************************//*!
 * @brief   Macro displays _LCD_DOT_P2_ON segments.
 * @note    Implemented as inlined macro.
 ******************************************************************************/
    #define _LCD_DOT_P2_ON       SymbolON(21,6)

/***************************************************************************//*!
 * @brief   Macro displays _LCD_DOT_P1_ON segments.
 * @note    Implemented as inlined macro.
 ******************************************************************************/
    #define _LCD_DOT_P1_ON       SymbolON(21,7)
   
//------------------------------------------------------------------------------
/***************************************************************************//*!
 * @brief   Macro displays _LCD_CHAR_T_ON segments.
 * @note    Implemented as inlined macro.
 ******************************************************************************/
    #define _LCD_CHAR_T_ON       SymbolON(38,0)

/***************************************************************************//*!
 * @brief   Macro displays _LCD_COLS_ON segments.
 * @note    Implemented as inlined macro.
 ******************************************************************************/
    #define _LCD_COLS_ON         SymbolON(23,0)

/***************************************************************************//*!
 * @brief   Macro displays _LCD_COMMA_ON segments.
 * @note    Implemented as inlined macro.
 ******************************************************************************/
    #define _LCD_COMMA_ON         SymbolON(23,2)

/***************************************************************************//*!
 * @brief   Macro displays _LCD_SYM_T1_ON segments.
 * @note    Implemented as inlined macro.
 ******************************************************************************/
    #define _LCD_SYM_T1_ON        SymbolON(43,0)

/***************************************************************************//*!
 * @brief   Macro displays _LCD_SYM_T2_ON segments.
 * @note    Implemented as inlined macro.
 ******************************************************************************/
    #define _LCD_SYM_T2_ON        SymbolON(26,0)

/***************************************************************************//*!
 * @brief   Macro displays _LCD_SYM_T3_ON segments.
 * @note    Implemented as inlined macro.
 ******************************************************************************/
    #define _LCD_SYM_T3_ON        SymbolON(27,0)

/***************************************************************************//*!
 * @brief   Macro displays _LCD_SYM_T4_ON segments.
 * @note    Implemented as inlined macro.
 ******************************************************************************/
    #define _LCD_SYM_T4_ON        SymbolON(25,0)

/***************************************************************************//*!
 * @brief   Macro displays _LCD_SYM_kW_ON segments.
 * @note    Implemented as inlined macro.
 ******************************************************************************/
    #define _LCD_SYM_kW_ON        SymbolON(22,0)

/***************************************************************************//*!
 * @brief   Macro displays _LCD_SYM_h_ON segments.
 * @note    Implemented as inlined macro.
 ******************************************************************************/
    #define _LCD_SYM_h_ON         SymbolON(20,3)

/***************************************************************************//*!
 * @brief   Macro displays _LCD_SYM_BATT_ON segments.
 * @note    Implemented as inlined macro.
 ******************************************************************************/
    #define _LCD_SYM_BATT_ON      SymbolON(49,0)

/***************************************************************************//*!
 * @brief   Macro displays _LCD_SYM_WRN_ON segments.
 * @note    Implemented as inlined macro.
 ******************************************************************************/
    #define _LCD_SYM_WRN_ON       SymbolON(47,0)

/***************************************************************************//*!
 * @brief   Macro displays _LCD_SYM_LOCK_ON segments.
 * @note    Implemented as inlined macro.
 ******************************************************************************/
    #define _LCD_SYM_LOCK_ON      SymbolON(45,0)

/***************************************************************************//*!
 * @brief   Macro displays _LCD_SYM_OBIS_DOTS_ON segments.
 * @note    Implemented as inlined macro.
 ******************************************************************************/
    #define _LCD_SYM_OBIS_DOTS_ON SymbolON(22,3)

/***************************************************************************//*!
 * @brief   Macro displays _LCD_SYM_OBIS_ONE_ON segments.
 * @note    Implemented as inlined macro.
 ******************************************************************************/
#define _LCD_SYM_OBIS_ONE_ON      SymbolON(21,1)

/***************************************************************************//*!
 * @brief   Macro displays _LCD_SYM_OBIS_D1B_C_ON segments.
 * @note    Implemented as inlined macro.
 ******************************************************************************/
#define _LCD_SYM_OBIS_D1B_C_ON    SymbolON(23,1)

/***************************************************************************//*!
 * @brief   Macro displays _LCD_SYM_OBIS_D1A_E_ON segments.
 * @note    Implemented as inlined macro.
 ******************************************************************************/
#define _LCD_SYM_OBIS_D1A_E_ON    SymbolON(23,3)

/***************************************************************************//*!
 * @brief   Macro displays _LCD_SYM_OBIS_D2B_ON segments.
 * @note    Implemented as inlined macro.
 ******************************************************************************/
#define _LCD_SYM_OBIS_D2B_ON      SymbolON(22,1)

/***************************************************************************//*!
 * @brief   Macro displays _LCD_SYM_OBIS_D2E_ON segments.
 * @note    Implemented as inlined macro.
 ******************************************************************************/
#define _LCD_SYM_OBIS_D2E_ON      SymbolON(22,2)

/***************************************************************************//*!
 * @brief   Macro displays _LCD_SYM_OBIS_D3B_ON segments.
 * @note    Implemented as inlined macro.
 ******************************************************************************/
#define _LCD_SYM_OBIS_D3B_ON    SymbolON(22,3)

/***************************************************************************//*!
 * @brief   Macro displays _LCD_SYM_OBIS_D3A_ON segments.
 * @note    Implemented as inlined macro.
 ******************************************************************************/
#define _LCD_SYM_OBIS_D3A_ON         SymbolON(21,0)

/***************************************************************************//*!
 * @brief   Macro displays _LCD_SYM_OBIS_D3C_ON segments.
 * @note    Implemented as inlined macro.
 ******************************************************************************/
#define _LCD_SYM_OBIS_D3C_ON         SymbolON(21,2)

/***************************************************************************//*!
 * @brief   Macro displays _LCD_SYM_OBIS_D3D_ON segments.
 * @note    Implemented as inlined macro.
 ******************************************************************************/
#define _LCD_SYM_OBIS_D3D_ON         SymbolON(21,3)

/***************************************************************************//*!
 * @brief   Macro displays _LCD_SYM_OBIS_D3E_ON segments.
 * @note    Implemented as inlined macro.
 ******************************************************************************/
#define _LCD_SYM_OBIS_D3E_ON         SymbolON(20,0)

/***************************************************************************//*!
 * @brief   Macro displays _LCD_SYM_OBIS_D3F_ON segments.
 * @note    Implemented as inlined macro.
 ******************************************************************************/
#define _LCD_SYM_OBIS_D3F_ON         SymbolON(20,1)

/***************************************************************************//*!
 * @brief   Macro displays _LCD_SYM_OBIS_D3G_ON segments.
 * @note    Implemented as inlined macro.
 ******************************************************************************/
#define _LCD_SYM_OBIS_D3G_ON         SymbolON(20,2)


    /* Special symbols OFF */
/***************************************************************************//*!
 * @brief   Macro displays _LCD_CHAR_V_S3_OFF segments.
 * @note    Implemented as inlined macro.
 ******************************************************************************/
    #define _LCD_CHAR_V_S3_OFF       SymbolOFF(44,0)

/***************************************************************************//*!
 * @brief   Macro displays _LCD_CHAR_V_S6_OFF segments.
 * @note    Implemented as inlined macro.
 ******************************************************************************/
    #define _LCD_CHAR_V_S6_OFF       SymbolOFF(44,5)

/***************************************************************************//*!
 * @brief   Macro displays _LCD_CHAR_V_S7_OFF segments.
 * @note    Implemented as inlined macro.
 ******************************************************************************/
    #define _LCD_CHAR_V_S7_OFF       SymbolOFF(45,1)

/***************************************************************************//*!
 * @brief   Macro displays _LCD_CHAR_V_S9_OFF segments.
 * @note    Implemented as inlined macro.
 ******************************************************************************/
    #define _LCD_CHAR_V_S9_OFF       SymbolOFF(44,4)

/***************************************************************************//*!
 * @brief   Macro displays _LCD_CHAR_V_S11_OFF segments.
 * @note    Implemented as inlined macro.
 ******************************************************************************/
    #define _LCD_CHAR_V_S11_OFF      SymbolOFF(45,4)

/***************************************************************************//*!
 * @brief   Macro displays _LCD_CHAR_V_S12_OFF segments.
 * @note    Implemented as inlined macro.
 ******************************************************************************/
    #define _LCD_CHAR_V_S12_OFF      SymbolOFF(45,2)

/***************************************************************************//*!
 * @brief   Macro displays _LCD_CHAR_V_S1_OFF segments.
 * @note    Implemented as inlined macro.
 ******************************************************************************/
    #define _LCD_CHAR_V_S13_OFF      SymbolOFF(45,3)

/***************************************************************************//*!
 * @brief   Macro displays _LCD_CHAR_I_S8_OFF segments.
 * @note    Implemented as inlined macro.
 ******************************************************************************/
    #define _LCD_CHAR_I_S8_OFF       SymbolOFF(44,2)

/***************************************************************************//*!
 * @brief   Macro displays _LCD_CHAR_I_S12_OFF segments.
 * @note    Implemented as inlined macro.
 ******************************************************************************/
    #define _LCD_CHAR_I_S12_OFF      SymbolOFF(45,2)

/***************************************************************************//*!
 * @brief   Macro displays _LCD_DOT_P3_OFF segments.
 * @note    Implemented as inlined macro.
 ******************************************************************************/
    #define _LCD_DOT_P3_OFF          SymbolOFF(21,1)
      
/***************************************************************************//*!
 * @brief   Macro displays _LCD_DOT_P2_OFF segments.
 * @note    Implemented as inlined macro.
 ******************************************************************************/
    #define _LCD_DOT_P2_OFF          SymbolOFF(21,6)

/***************************************************************************//*!
 * @brief   Macro displays _LCD_DOT_P1_OFF segments.
 * @note    Implemented as inlined macro.
 ******************************************************************************/
    #define _LCD_DOT_P1_OFF          SymbolOFF(21,7)
   
//------------------------------------------------------------------------------
/***************************************************************************//*!
 * @brief   Macro displays _LCD_CHAR_T_OFF segments.
 * @note    Implemented as inlined macro.
 ******************************************************************************/
    #define _LCD_CHAR_T_OFF        SymbolOFF(38,0)

/***************************************************************************//*!
 * @brief   Macro displays _LCD_COLS_OFF segments.
 * @note    Implemented as inlined macro.
 ******************************************************************************/
    #define _LCD_COLS_OFF         SymbolOFF(23,0)

/***************************************************************************//*!
 * @brief   Macro displays _LCD_COMMA_OFF segments.
 * @note    Implemented as inlined macro.
 ******************************************************************************/
    #define _LCD_COMMA_OFF         SymbolOFF(23,2)

/***************************************************************************//*!
 * @brief   Macro displays _LCD_SYM_T1_OFF segments.
 * @note    Implemented as inlined macro.
 ******************************************************************************/
    #define _LCD_SYM_T1_OFF        SymbolOFF(43,0)

/***************************************************************************//*!
 * @brief   Macro displays _LCD_SYM_T2_OFF segments.
 * @note    Implemented as inlined macro.
 ******************************************************************************/
    #define _LCD_SYM_T2_OFF        SymbolOFF(26,0)

/***************************************************************************//*!
 * @brief   Macro displays _LCD_SYM_T3_OFF segments.
 * @note    Implemented as inlined macro.
 ******************************************************************************/
    #define _LCD_SYM_T3_OFF        SymbolOFF(27,0)

/***************************************************************************//*!
 * @brief   Macro displays _LCD_SYM_T4_OFF segments.
 * @note    Implemented as inlined macro.
 ******************************************************************************/
    #define _LCD_SYM_T4_OFF        SymbolOFF(25,0)

/***************************************************************************//*!
 * @brief   Macro displays _LCD_SYM_kW_OFF segments.
 * @note    Implemented as inlined macro.
 ******************************************************************************/
    #define _LCD_SYM_kW_OFF        SymbolOFF(22,0)

/***************************************************************************//*!
 * @brief   Macro displays _LCD_SYM_h_OFF segments.
 * @note    Implemented as inlined macro.
 ******************************************************************************/
    #define _LCD_SYM_h_OFF         SymbolOFF(20,3)

/***************************************************************************//*!
 * @brief   Macro displays _LCD_SYM_BATT_OFF segments.
 * @note    Implemented as inlined macro.
 ******************************************************************************/
    #define _LCD_SYM_BATT_OFF      SymbolOFF(49,0)

/***************************************************************************//*!
 * @brief   Macro displays _LCD_SYM_WRN_OFF segments.
 * @note    Implemented as inlined macro.
 ******************************************************************************/
    #define _LCD_SYM_WRN_OFF       SymbolOFF(47,0)

/***************************************************************************//*!
 * @brief   Macro displays _LCD_SYM_LOCK_OFF segments.
 * @note    Implemented as inlined macro.
 ******************************************************************************/
    #define _LCD_SYM_LOCK_OFF      SymbolOFF(45,0)

/***************************************************************************//*!
 * @brief   Macro displays _LCD_SYM_OBIS_DOTS_OFF segments.
 * @note    Implemented as inlined macro.
 ******************************************************************************/
    #define _LCD_SYM_OBIS_DOTS_OFF  SymbolOFF(22,3)

/***************************************************************************//*!
 * @brief   Macro displays _LCD_SYM_OBIS_ONE_OFF segments.
 * @note    Implemented as inlined macro.
 ******************************************************************************/
#define _LCD_SYM_OBIS_ONE_OFF       SymbolOFF(21,1)

/***************************************************************************//*!
 * @brief   Macro displays _LCD_SYM_OBIS_D1B_C_OFF segments.
 * @note    Implemented as inlined macro.
 ******************************************************************************/
#define _LCD_SYM_OBIS_D1B_C_OFF     SymbolOFF(23,1)

/***************************************************************************//*!
 * @brief   Macro displays _LCD_SYM_OBIS_D1A_E_OFF segments.
 * @note    Implemented as inlined macro.
 ******************************************************************************/
#define _LCD_SYM_OBIS_D1A_E_OFF     SymbolOFF(23,3)

/***************************************************************************//*!
 * @brief   Macro displays _LCD_SYM_OBIS_D2B_OFF segments.
 * @note    Implemented as inlined macro.
 ******************************************************************************/
#define _LCD_SYM_OBIS_D2B_OFF       SymbolOFF(22,1)

/***************************************************************************//*!
 * @brief   Macro displays _LCD_SYM_OBIS_D2E_OFF segments.
 * @note    Implemented as inlined macro.
 ******************************************************************************/
#define _LCD_SYM_OBIS_D2E_OFF       SymbolOFF(22,2)

/***************************************************************************//*!
 * @brief   Macro displays _LCD_SYM_OBIS_D3B_OFF segments.
 * @note    Implemented as inlined macro.
 ******************************************************************************/
#define _LCD_SYM_OBIS_D3B_OFF       SymbolOFF(22,3)

/***************************************************************************//*!
 * @brief   Macro displays _LCD_SYM_OBIS_D3A_OFF segments.
 * @note    Implemented as inlined macro.
 ******************************************************************************/
#define _LCD_SYM_OBIS_D3A_OFF         SymbolOFF(21,0)

/***************************************************************************//*!
 * @brief   Macro displays _LCD_SYM_OBIS_D3C_OFF segments.
 * @note    Implemented as inlined macro.
 ******************************************************************************/
#define _LCD_SYM_OBIS_D3C_OFF         SymbolOFF(21,2)

/***************************************************************************//*!
 * @brief   Macro displays _LCD_SYM_OBIS_D3D_OFF segments.
 * @note    Implemented as inlined macro.
 ******************************************************************************/
#define _LCD_SYM_OBIS_D3D_OFF         SymbolOFF(21,3)

/***************************************************************************//*!
 * @brief   Macro displays _LCD_SYM_OBIS_D3E_OFF segments.
 * @note    Implemented as inlined macro.
 ******************************************************************************/
#define _LCD_SYM_OBIS_D3E_OFF         SymbolOFF(20,0)

/***************************************************************************//*!
 * @brief   Macro displays _LCD_SYM_OBIS_D3F_OFF segments.
 * @note    Implemented as inlined macro.
 ******************************************************************************/
#define _LCD_SYM_OBIS_D3F_OFF         SymbolOFF(20,1)

/***************************************************************************//*!
 * @brief   Macro displays _LCD_SYM_OBIS_D3G_OFF segments.
 * @note    Implemented as inlined macro.
 ******************************************************************************/
#define _LCD_SYM_OBIS_D3G_OFF         SymbolOFF(20,2)

    /* Segments ON  */
    #define Segment60_ON    SegmentsON(60,0xff)
    #define Segment59_ON    SegmentsON(59,0xff)
    #define Segment49_ON    SegmentsON(49,0xff)
    #define Segment48_ON    SegmentsON(48,0xff)
    #define Segment47_ON    SegmentsON(47,0xff)
    #define Segment46_ON    SegmentsON(46,0xff)
    #define Segment45_ON    SegmentsON(45,0xff)
    #define Segment44_ON    SegmentsON(44,0xff)
    #define Segment43_ON    SegmentsON(43,0xff)
    #define Segment42_ON    SegmentsON(42,0xff)
    #define Segment41_ON    SegmentsON(41,0xff)
    #define Segment40_ON    SegmentsON(40,0xff)
    #define Segment27_ON    SegmentsON(27,0xff)
    #define Segment26_ON    SegmentsON(26,0xff)
    #define Segment25_ON    SegmentsON(25,0xff)
    #define Segment24_ON    SegmentsON(24,0xff)
    #define Segment23_ON    SegmentsON(23,0xff)
    #define Segment22_ON    SegmentsON(22,0xff)
    #define Segment21_ON    SegmentsON(21,0xff)
    #define Segment20_ON    SegmentsON(20,0xff)


     /* Segments OFF  */
    #define Segment60_OFF    SegmentsOFF(60,0xff)
    #define Segment59_OFF    SegmentsOFF(59,0xff)
    #define Segment49_OFF    SegmentsOFF(49,0xff)
    #define Segment48_OFF    SegmentsOFF(48,0xff)
    #define Segment47_OFF    SegmentsOFF(47,0xff)
    #define Segment46_OFF    SegmentsOFF(46,0xff)
    #define Segment45_OFF    SegmentsOFF(45,0xff)
    #define Segment44_OFF    SegmentsOFF(44,0xff)
    #define Segment43_OFF    SegmentsOFF(43,0xff)
    #define Segment42_OFF    SegmentsOFF(42,0xff)
    #define Segment41_OFF    SegmentsOFF(41,0xff)
    #define Segment40_OFF    SegmentsOFF(40,0xff)
    #define Segment27_OFF    SegmentsOFF(27,0xff)
    #define Segment26_OFF    SegmentsOFF(26,0xff)
    #define Segment25_OFF    SegmentsOFF(25,0xff)
    #define Segment24_OFF    SegmentsOFF(24,0xff)
    #define Segment23_OFF    SegmentsOFF(23,0xff)
    #define Segment22_OFF    SegmentsOFF(22,0xff)
    #define Segment21_OFF    SegmentsOFF(21,0xff)
    #define Segment20_OFF    SegmentsOFF(20,0xff)

    /*Map segment to COM mask - LINE0*/
    #define  L0SEGA   0x02
    #define  L0SEGB   0x08
    #define  L0SEGC   0x40
    #define  L0SEGD   0x80
    #define  L0SEGE   0x20
    #define  L0SEGF   0x04
    #define  L0SEGG   0x10
    
#endif /* __LCDHWD_H */ 