/*****************************************************************************
 * (c) Copyright 2016, Freescale Semiconductor
 * ALL RIGHTS RESERVED.
 ***************************************************************************//*!
 * @file      appconfig.h
 * @author    
 * @version   0.0.1.0
 * @date      Jun-20-2013
 * @brief     Application configuration and interrupt vector definitions.
 ******************************************************************************/
#ifndef __APPCONFIG_H
#define __APPCONFIG_H

/*******************************************************************************
*//*! @addtogroup twr_sai_audio_playback_test_config_def
* @{
*******************************************************************************/

/***************************************************************************//*!
 * @brief   Define processor device.
 * @details Supported devices - MCU_MKL43Z256  (MCU_MKL46Z256 temporarily used)
 ******************************************************************************/
#define MCU_MKL43Z256

/**************************************************************************/ /*!
 * @brief Configures pin to Alternative 6 (GPIO) mode with high drive strength.
 *****************************************************************************/
#define PORT_MODULE_ALT6_MODE_I2S   /* ALT6 push-pull mode high strength  */   \
(tPORT){                                                                       \
/* PCR      */ CLR(PORT_PCR_ISF_MASK)|SET(PORT_PCR_IRQC(0))|                   \
               SET(PORT_PCR_MUX(6))|SET(PORT_PCR_DSE_MASK)|                    \
               CLR(PORT_PCR_PFE_MASK)|CLR(PORT_PCR_SRE_MASK)|                  \
               CLR(PORT_PCR_PE_MASK)|CLR(PORT_PCR_PS_MASK),                    \
}

/***************************************************************************//*!
 * @brief   SAI/I2S module Master TX/RX DMA mode
 * @details MCLK frequency is set to 24.0MHz depending on the SIM_CLKDIV1_OUTDIV
 *          Samplerate selected by SAI0_SetSampleRate() function
 *           
 * @showinitializer
 * @note    
 ******************************************************************************/
#define SAI_MODULE_MASTER_TX_RX_DMA_CONFIG                                     \
(tI2S){                                                                        \
/* TCSR */ SET(I2S_TCSR_FWDE_MASK)| SET(I2S_TCSR_FR_MASK),                     \
/* TCR1 */ 0,                                                                  \
/* TCR2 */ SET(I2S_TCR2_BCD_MASK)|                                             \
/*  ..  */ CLR(I2S_TCR2_BCP_MASK),                                             \
/* TCR3 */ 0,                                                                  \
/* TCR4 */ SET(I2S_TCR4_FRSZ_MASK)|SET(I2S_TCR4_SYWD(I2S_BIT_DEPTH-1))|SET(I2S_TCR4_FCONT_MASK)|\
/*  ..  */ SET(I2S_TCR4_FSE_MASK)|SET(I2S_TCR4_FSD_MASK)|SET(I2S_TCR4_MF_MASK),\
/* TCR5 */ SET(I2S_TCR5_WNW(I2S_BIT_DEPTH-1))|                                 \
/*  ..  */ SET(I2S_TCR5_W0W(I2S_BIT_DEPTH-1))|SET(I2S_TCR5_FBT(0x0f)),         \
/* TDR0 */ 0,                                                                  \
/* TFR0 */ 0,                                                                  \
/* TMR  */ SET(I2S_TMR_TWM(0x0)),                                              \
/* RCSR */ SET(I2S_RCSR_FWDE_MASK)|SET(I2S_TCSR_FR_MASK),                      \
/* RCR1 */ 0,                                                                  \
/* RCR2 */ SET(I2S_RCR2_BCD_MASK)|                                             \
/*  ..  */ CLR(I2S_RCR2_BCP_MASK),                                             \
/* RCR3 */ 0,                                                                  \
/* RCR4 */ SET(I2S_RCR4_FRSZ_MASK)|SET(I2S_RCR4_SYWD(I2S_BIT_DEPTH-1))|SET(I2S_TCR4_FCONT_MASK)|\
/*  ..  */ SET(I2S_RCR4_FSE_MASK)|SET(I2S_RCR4_FSD_MASK)|SET(I2S_RCR4_MF_MASK),\
/* RCR5 */ SET(I2S_RCR5_WNW(I2S_BIT_DEPTH-1))|                                 \
/*  ..  */ SET(I2S_RCR5_W0W(I2S_BIT_DEPTH-1))|SET(I2S_RCR5_FBT(0x0f)),         \
/* RDR0 */ 0,                                                                  \
/* RFR0 */ 0,                                                                  \
/* RMR  */ SET(I2S_RMR_RWM(0x0)),                                              \
/* MCR  */ 0,                                                                  \
/* MDR  */ 0,                                                                  \
}         
/*! @} End of sai_config  */

/******************************************************************************
 * @brief   Define interrupt vectors.
 * @example 
 *          extern void uart_isr (void);       ///< uart isr prototype
 *          #undef  VECTOR_030
 *          #define VECTOR_030 uart_isr        ///< uart_isr interrupt vector re-definition
 ******************************************************************************/
extern void sai0_isr (void);       ///< sai0 isr prototype
extern void dma0_isr (void);       ///< dma0 isr prototype
extern void dma1_isr (void);       ///< dma1 isr prototype
extern void porta_isr (void);   ///< porta isr prototype (defined in gpio.c)

#undef  VECTOR_039
#define VECTOR_039 sai0_isr      ///< sai0_isr interrupt vector re-definition

#undef  VECTOR_016
#define VECTOR_016 dma0_isr      ///< sai0_isr interrupt vector re-definition

#undef  VECTOR_017
#define VECTOR_017 dma1_isr      ///< sai0_isr interrupt vector re-definition

#undef  VECTOR_046
#define VECTOR_046 porta_isr    ///< porta_isr interrupt vector re-definition

#undef  CONFIG_4
#define CONFIG_4		(pointer*)0xffff3ffe

/*! @} End of twr_sai_audio_playback_test_config_def                                           */

#endif /* __APPCONFIG_ */
