/*
 * Copyright (c) 2015-2016, Freescale Semiconductor, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * o Redistributions of source code must retain the above copyright notice, this list
 *   of conditions and the following disclaimer.
 *
 * o Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * o Neither the name of Freescale Semiconductor, Inc. nor the names of its
 *   contributors may be used to endorse or promote products derived from this
 *   software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/*******************************************************************************
 * Includes
 ******************************************************************************/
#include "lcd_hx8357_drv.h"
#include "pic_hex_data.h"
#include "logo_echo.h"

/*******************************************************************************
 * Definitions
 ******************************************************************************/
#define ZERO_X_INIT     40
#define ZERO_Y_INIT     60
#define DIF_X_ABS       1
#define DIF_Y_ABS       1
#define DELAY_TIME      40000U

/*******************************************************************************
 * Variables
 ******************************************************************************/
static PicMovVar_t PicMovVar={
    .Zero_X = ZERO_X_INIT,
    .Zero_Y = ZERO_Y_INIT,
    .Dif_X = DIF_X_ABS,
    .Dif_Y = DIF_Y_ABS,
    .Max_Zero_X = LCD_H_POINTS - PIC1_H_POINTS - 1U,
    .Max_Zero_Y = LCD_V_POINTS - PIC1_V_POINTS - 1U,
    .Pic_X_Size = PIC1_H_POINTS,
    .Pic_Y_Size = PIC1_V_POINTS,
    .Background = White,
};

/*******************************************************************************
 * Functions
 ******************************************************************************/

static void Sort(uint16_t *a, uint16_t *b)
{
    uint16_t c;

    if(*a > *b)
    {
      c = *a;
      *a = *b;
      *b = c;
    }
}

void LogoEcho_Prepare(void)
{
    LCD_HX8357_FillColorWhole(PicMovVar.Background);
}

void LogoEcho_Update(void)
{
    AreaPoints_t PicArea, Bar1Area, Bar2Area;

    PicMovVar.Zero_X_Old = PicMovVar.Zero_X;
    PicMovVar.Zero_Y_Old = PicMovVar.Zero_Y;

    PicMovVar.Zero_X += PicMovVar.Dif_X;
    PicMovVar.Zero_Y += PicMovVar.Dif_Y;

    if(PicMovVar.Zero_X > PicMovVar.Max_Zero_X)
    {
        PicMovVar.Zero_X = PicMovVar.Max_Zero_X*2 - PicMovVar.Zero_X;
        PicMovVar.Dif_X = -PicMovVar.Dif_X;
    }
    else if(PicMovVar.Zero_X < 0)
    {
        PicMovVar.Zero_X = -PicMovVar.Zero_X;
        PicMovVar.Dif_X = -PicMovVar.Dif_X;
    }
    else
    {
    }

    if(PicMovVar.Zero_Y > PicMovVar.Max_Zero_Y)
    {
        PicMovVar.Zero_Y = PicMovVar.Max_Zero_Y*2 - PicMovVar.Zero_Y;
        PicMovVar.Dif_Y = -PicMovVar.Dif_Y;
    }
    else if(PicMovVar.Zero_Y < 0)
    {
        PicMovVar.Zero_Y = -PicMovVar.Zero_Y;
        PicMovVar.Dif_Y = -PicMovVar.Dif_Y;
    }
    else
    {
    }

    PicMovVar.Dif_X_Act = PicMovVar.Zero_X - PicMovVar.Zero_X_Old;
    PicMovVar.Dif_Y_Act = PicMovVar.Zero_Y - PicMovVar.Zero_Y_Old;

    PicArea.x1 = PicMovVar.Zero_X;
    PicArea.x2 = PicMovVar.Zero_X + PicMovVar.Pic_X_Size - 1U;
    PicArea.y1 = PicMovVar.Zero_Y;
    PicArea.y2 = PicMovVar.Zero_Y + PicMovVar.Pic_Y_Size - 1U;

#if 1
    /* Use DMA method to update image */
    LCD_HX8357_FillPicDMA(&PicArea, HexPicLogo);
#else
    /* Use polling method to update image */
    LCD_HX8357_FillPicPolling(&PicArea, HexPicLogo);
#endif

    for(volatile uint32_t t=DELAY_TIME; t!=0U; t--)
    {
    }

    /* Calculate the horizontal bar's coordinate value. */
    if((PicMovVar.Dif_X_Act>=0) && (PicMovVar.Dif_Y_Act>=0))
    {
        Bar1Area.x1 = PicMovVar.Zero_X_Old;
        Bar1Area.x2 = PicMovVar.Zero_X_Old + PicMovVar.Pic_X_Size - 1;
        Bar1Area.y1 = PicMovVar.Zero_Y_Old;
        Bar1Area.y2 = PicMovVar.Zero_Y - 1;
    }
    else if((PicMovVar.Dif_X_Act>=0) && (PicMovVar.Dif_Y_Act<=0))
    {
        Bar1Area.x1 = PicMovVar.Zero_X_Old;
        Bar1Area.x2 = PicMovVar.Zero_X_Old + PicMovVar.Pic_X_Size - 1;
        Bar1Area.y1 = PicMovVar.Zero_Y + PicMovVar.Pic_Y_Size;
        Bar1Area.y2 = PicMovVar.Zero_Y_Old + PicMovVar.Pic_Y_Size - 1;
    }
    else if((PicMovVar.Dif_X_Act<=0) && (PicMovVar.Dif_Y_Act>=0))
    {
        Bar1Area.x1 = PicMovVar.Zero_X_Old;
        Bar1Area.x2 = PicMovVar.Zero_X_Old + PicMovVar.Pic_X_Size - 1;
        Bar1Area.y1 = PicMovVar.Zero_Y_Old;
        Bar1Area.y2 = PicMovVar.Zero_Y - 1;
    }
    else if((PicMovVar.Dif_X_Act<=0) && (PicMovVar.Dif_Y_Act<=0))
    {
        Bar1Area.x1 = PicMovVar.Zero_X_Old;
        Bar1Area.x2 = PicMovVar.Zero_X_Old + PicMovVar.Pic_X_Size - 1;
        Bar1Area.y1 = PicMovVar.Zero_Y + PicMovVar.Pic_Y_Size;
        Bar1Area.y2 = PicMovVar.Zero_Y_Old + PicMovVar.Pic_Y_Size - 1;
    }
    else
    {
    }

    /* Calculate the vertical bar's coordinate value. */
    if((PicMovVar.Dif_X_Act>=0) && (PicMovVar.Dif_Y_Act>=0))
    {
        Bar2Area.x1 = PicMovVar.Zero_X_Old;
        Bar2Area.x2 = PicMovVar.Zero_X - 1;
        Bar2Area.y1 = PicMovVar.Zero_Y_Old;
        Bar2Area.y2 = PicMovVar.Zero_Y_Old + PicMovVar.Pic_Y_Size - 1;
    }
    else if((PicMovVar.Dif_X_Act>=0) && (PicMovVar.Dif_Y_Act<=0))
    {
        Bar2Area.x1 = PicMovVar.Zero_X_Old;
        Bar2Area.x2 = PicMovVar.Zero_X - 1;
        Bar2Area.y1 = PicMovVar.Zero_Y_Old;
        Bar2Area.y2 = PicMovVar.Zero_Y_Old + PicMovVar.Pic_Y_Size - 1;
    }
    else if((PicMovVar.Dif_X_Act<=0) && (PicMovVar.Dif_Y_Act>=0))
    {
        Bar2Area.x1 = PicMovVar.Zero_X + PicMovVar.Pic_X_Size;
        Bar2Area.x2 = PicMovVar.Zero_X_Old + PicMovVar.Pic_X_Size - 1;
        Bar2Area.y1 = PicMovVar.Zero_Y_Old;
        Bar2Area.y2 = PicMovVar.Zero_Y_Old + PicMovVar.Pic_Y_Size - 1;
    }
    else if((PicMovVar.Dif_X_Act<=0) && (PicMovVar.Dif_Y_Act<=0))
    {
        Bar2Area.x1 = PicMovVar.Zero_X + PicMovVar.Pic_X_Size;
        Bar2Area.x2 = PicMovVar.Zero_X_Old + PicMovVar.Pic_X_Size - 1;
        Bar2Area.y1 = PicMovVar.Zero_Y_Old;
        Bar2Area.y2 = PicMovVar.Zero_Y_Old + PicMovVar.Pic_Y_Size - 1;
    }
    else
    {
    }

    /* Sort the coordinate value. */
    Sort(&Bar1Area.x1, &Bar1Area.x2);
    Sort(&Bar1Area.y1, &Bar1Area.y2);
    Sort(&Bar2Area.x1, &Bar2Area.x2);
    Sort(&Bar2Area.y1, &Bar2Area.y2);

    /* Erase the old bars. */
    LCD_HX8357_FillColorPolling(&Bar1Area, PicMovVar.Background);
    LCD_HX8357_FillColorPolling(&Bar2Area, PicMovVar.Background);
}

/* EOF */
