/*
 * Copyright (c) 2015-2016, Freescale Semiconductor, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * o Redistributions of source code must retain the above copyright notice, this list
 *   of conditions and the following disclaimer.
 *
 * o Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * o Neither the name of Freescale Semiconductor, Inc. nor the names of its
 *   contributors may be used to endorse or promote products derived from this
 *   software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/*******************************************************************************
 * Includes
 ******************************************************************************/
#include <stdint.h>
#include <stdbool.h>

#include "lcd_hx8357_drv.h"
#include "pic_hex_data.h"
#include "zoo_rotate.h"

/*******************************************************************************
 * Definitions
 ******************************************************************************/
#define GT4(number) (number>=4? number-4 : number)

/*******************************************************************************
 * Variables
 ******************************************************************************/
const AreaPoints_t PicZooArea[4] = {
    {  0U, 0U, LCD_H_POINTS/2U-1U, LCD_V_POINTS/2U-1U  },
    {  LCD_H_POINTS/2U, 0U, LCD_H_POINTS-1U, LCD_V_POINTS/2U-1U },
    {  LCD_H_POINTS/2U, LCD_V_POINTS/2U, LCD_H_POINTS-1U, LCD_V_POINTS-1U },
    {  0U, LCD_V_POINTS/2U, LCD_H_POINTS/2U-1U, LCD_V_POINTS-1U  }
};

static uint32_t step = 0;
static const uint16_t * ppa[4] = {HexPicZoo1, HexPicZoo2, HexPicZoo3, HexPicZoo4};
const uint16_t * ppb[4];

/*******************************************************************************
 * Functions
 ******************************************************************************/
/*!
 * @brief Display zootopia pictures.
 */
void DispZoo(void)
{
    for(uint32_t i=0; i<4U; i++)
    {
        ppb[i] = ppa[GT4(step + 3 - i)];
#if 1
        /* Use multi-beat and DMA method to update image */
        LCD_HX8357_FillPicDMA(&PicZooArea[i], ppb[i]);
#else
        /* Use single-beat and polling method to update image */
        LCD_HX8357_FillPicPolling(&PicZooArea[i], ppb[i]);
#endif
    }

    if(step < 3U)
    {
        step++;
    }
    else
    {
        step = 0U;
    }
}

/* EOF */
