/*
 * Copyright (c) 2015-2016, Freescale Semiconductor, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * o Redistributions of source code must retain the above copyright notice, this list
 *   of conditions and the following disclaimer.
 *
 * o Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * o Neither the name of Freescale Semiconductor, Inc. nor the names of its
 *   contributors may be used to endorse or promote products derived from this
 *   software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/*******************************************************************************
 * Includes
 ******************************************************************************/
#include "lcd_hx8357_drv.h"
#include "flexio_8080_drv.h"
#include "pic_hex_data.h"

/*******************************************************************************
 * Variables
 ******************************************************************************/
uint16_t *pColor = EmptyFrame;

const AreaPoints_t LCDArea = {0U, 0U, LCD_H_POINTS-1U, LCD_V_POINTS-1U};
extern bool DMAFillColorMode;
/*******************************************************************************
 * Functions
 ******************************************************************************/
/*!
 * Delay for some time.
 */
static void Delay(uint32_t t)
{
    for(; t!=0U; t--)
    {
        for(volatile uint32_t j=0U; j<20U; j++)
        {
        }
    }
}

/*!
 * Initialize the LCD module.
 */
void LCD_HX8357_Init(void)
{
    uint8_t Command;
    uint16_t CommandValue[20];

    Command = 0xB0;
    CommandValue[0U] = 0x00;
    CommandValue[1U] = 0x00;
    FLEXIO_8080_SglBeatWR_nPrm(Command, CommandValue, 2U);

    Command = 0xB3;
    CommandValue[0U] = 0x02;
    CommandValue[1U] = 0x00;
    CommandValue[2U] = 0x00;
    CommandValue[3U] = 0x00;
    FLEXIO_8080_SglBeatWR_nPrm(Command, CommandValue, 4U);

    Command = 0xB4;
    CommandValue[0U] = 0x00;
    FLEXIO_8080_SglBeatWR_nPrm(Command, CommandValue, 1U);

    Command = 0xC0;
    CommandValue[0U] = 0x13;
    CommandValue[1U] = 0x3B;
    CommandValue[2U] = 0x00;
    CommandValue[3U] = 0x03;
    CommandValue[4U] = 0x00;
    CommandValue[5U] = 0x01;
    CommandValue[6U] = 0x00;
    CommandValue[7U] = 0x43;
    FLEXIO_8080_SglBeatWR_nPrm(Command, CommandValue, 8U);

    Command = 0xC1;
    CommandValue[0U] = 0x08;
    CommandValue[1U] = 0x12;
    CommandValue[2U] = 0x08;
    CommandValue[3U] = 0x08;
    FLEXIO_8080_SglBeatWR_nPrm(Command, CommandValue, 4U);

    Command = 0xC4;
    CommandValue[0U] = 0x11;
    CommandValue[1U] = 0x07;
    CommandValue[2U] = 0x03;
    CommandValue[3U] = 0x03;
    FLEXIO_8080_SglBeatWR_nPrm(Command, CommandValue, 4U);

    Command = 0xC8;
    CommandValue[0U] = 0x04;
    CommandValue[1U] = 0x09;
    CommandValue[2U] = 0x16;
    CommandValue[3U] = 0x5A;
    CommandValue[4U] = 0x02;
    CommandValue[5U] = 0x0A;
    CommandValue[6U] = 0x16;
    CommandValue[7U] = 0x05;
    CommandValue[8U] = 0x00;
    CommandValue[9U] = 0x32;
    CommandValue[10U] = 0x05;
    CommandValue[11U] = 0x16;
    CommandValue[12U] = 0x0A;
    CommandValue[13U] = 0x53;
    CommandValue[14U] = 0x08;
    CommandValue[15U] = 0x16;
    CommandValue[16U] = 0x09;
    CommandValue[17U] = 0x04;
    CommandValue[18U] = 0x32;
    CommandValue[19U] = 0x00;
    FLEXIO_8080_SglBeatWR_nPrm(Command, CommandValue, 20U);

    Command = 0x35;
    CommandValue[0U] = 0x00;
    FLEXIO_8080_SglBeatWR_nPrm(Command, CommandValue, 1U);

    Command = 0x3A;
    CommandValue[0U] = 0x55;
    FLEXIO_8080_SglBeatWR_nPrm(Command, CommandValue, 1U);

    Command = 0x44;
    CommandValue[0U] = 0x00;
    CommandValue[1U] = 0x01;
    FLEXIO_8080_SglBeatWR_nPrm(Command, CommandValue, 2U);

    Command = 0x2C;
    FLEXIO_8080_SglBeatWR_nPrm(Command, NULL, 0U);
    Command = 0x11;
    FLEXIO_8080_SglBeatWR_nPrm(Command, NULL, 0U);

    Delay(150U);

    Command = 0xD0;
    CommandValue[0U] = 0x07;
    CommandValue[1U] = 0x07;
    CommandValue[2U] = 0x1E;
    CommandValue[3U] = 0x07;
    FLEXIO_8080_SglBeatWR_nPrm(Command, CommandValue, 4U);

    Command = 0xD1;
    CommandValue[0U] = 0x03;
    CommandValue[1U] = 0x52;
    CommandValue[2U] = 0x10;
    FLEXIO_8080_SglBeatWR_nPrm(Command, CommandValue, 3U);

    Command = 0xD2;
    CommandValue[0U] = 0x03;
    CommandValue[1U] = 0x24;
    FLEXIO_8080_SglBeatWR_nPrm(Command, CommandValue, 2U);

    Command = 0xB0;
    CommandValue[0U] =0x00;
    FLEXIO_8080_SglBeatWR_nPrm(Command, CommandValue, 1U);

    Command = 0x29;
    FLEXIO_8080_SglBeatWR_nPrm(Command, NULL, 0U);
    Delay(10U);

    Command = 0x3A;
    CommandValue[0U] =0x55;
    FLEXIO_8080_SglBeatWR_nPrm(Command, CommandValue, 1U);
    Delay(100U);

    Command = 0x36;
    CommandValue[0U] =0x28;
    FLEXIO_8080_SglBeatWR_nPrm(Command, CommandValue, 1U);
    Delay(100U);
}

/*!
 * Set the filling area.
 */
void LCD_HX8357_SetWindow(const AreaPoints_t * area)
{
    uint8_t Command;
    uint16_t CommandValue[4];

    Command = 0x2A;
    CommandValue[0U] = area->x1 >> 8U;
    CommandValue[1U] = area->x1 & 0xFF;
    CommandValue[2U] = area->x2 >> 8U;
    CommandValue[3U] = area->x2 & 0xFF;
    FLEXIO_8080_SglBeatWR_nPrm(Command, CommandValue, 4U);

    Command = 0x2B;
    CommandValue[0U] = area->y1 >> 8U;
    CommandValue[1U] = area->y1 & 0xFF;
    CommandValue[2U] = area->y2 >> 8U;
    CommandValue[3U] = area->y2 & 0xFF;
    FLEXIO_8080_SglBeatWR_nPrm(Command, CommandValue, 4U);
}

void LCD_HX8357_FillColorPolling(const AreaPoints_t * area, const uint16_t color)
{
    uint32_t points = (area->x2-area->x1+1) * (area->y2-area->y1+1);
    LCD_HX8357_SetWindow(area);
    FLEXIO_8080_SglBeatWR_nSamePrm(0x2C, color, points);
}

void LCD_HX8357_FillColorDMA(const AreaPoints_t * area, const uint16_t color)
{
    uint32_t transfers = (area->x2-area->x1+1) * (area->y2-area->y1+1);
    LCD_HX8357_SetWindow(area);

    pColor[0] = color;
    pColor[1] = color;

    DMAFillColorMode = true;

    FLEXIO_8080_MulBeatWR_nPrm(0x2C, pColor, transfers);
    while(WR_DMATransferDone == false)
    {
        /* You can add some necessary statements here.*/
    }
    DMAFillColorMode = false;
}

void LCD_HX8357_FillPicPolling(const AreaPoints_t * area, const uint16_t * pic)
{
    uint32_t transfers = (area->x2-area->x1 + 1) * (area->y2-area->y1 + 1);
    LCD_HX8357_SetWindow(area);
    FLEXIO_8080_SglBeatWR_nPrm(0x2C, pic, transfers);
}

void LCD_HX8357_FillPicDMA(const AreaPoints_t * area, const uint16_t * pic)
{
    uint32_t transfers = (area->x2-area->x1 + 1) * (area->y2-area->y1 + 1);
    LCD_HX8357_SetWindow(area);

    FLEXIO_8080_MulBeatWR_nPrm(0x2C, pic, transfers);
    while(WR_DMATransferDone == false)
    {
        /* You can add some necessary statements here.*/
    }
}

void LCD_HX8357_FillColorWhole(const uint16_t color)
{
#if 1
    /* Use multi-beat and DMA to fill color. */
    LCD_HX8357_FillColorDMA(&LCDArea, color);
#else
    /* Use single-beat and polling to fill color */
    LCD_HX8357_FillColorPolling(&LCDArea, color);
#endif
}

void LCD_HX8357_FillPicWhole(const uint16_t *pic)
{
#if 1
    /* Use multi-beat and DMA to update image. */
    LCD_HX8357_FillPicDMA(&LCDArea, pic);
#else
    /* Use single-beat and polling to update image */
    LCD_HX8357_FillPicPolling(&LCDArea, pic);
#endif
}

/* EOF */
