/*
 * Copyright (c) 2015, Freescale Semiconductor, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * o Redistributions of source code must retain the above copyright notice, this list
 *   of conditions and the following disclaimer.
 *
 * o Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * o Neither the name of Freescale Semiconductor, Inc. nor the names of its
 *   contributors may be used to endorse or promote products derived from this
 *   software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "fsl_common.h"
#include "fsl_port.h"
#include "pin_mux.h"

/*******************************************************************************
 * Code
 ******************************************************************************/

/* Function Name : BOARD_InitPins */
void BOARD_InitPins(void)
{
    /* Initialize LPUART0 pins below */
    /* Ungate the port clock */
    CLOCK_EnableClock(kCLOCK_PortA);

    /* Affects PORTA_PCR1 register */
    PORT_SetPinMux(PORTA, 1u, kPORT_MuxAlt2);
    /* Affects PORTA_PCR2 register */
    PORT_SetPinMux(PORTA, 2u, kPORT_MuxAlt2);
}


/* Configure port mux of FlexIO data pins */
void FLEXIO_8080_Config_Data_Pin(void)
{
    FLEXIO_DATA0_PORT->PCR[FLEXIO_DATA0_PIN] = PORT_PCR_MUX(FLEXIO_DATA0_MUX) | PORT_PCR_PE_MASK | PORT_PCR_PS(0);       /* FXIO0_D0 */
    FLEXIO_DATA1_PORT->PCR[FLEXIO_DATA1_PIN] = PORT_PCR_MUX(FLEXIO_DATA1_MUX) | PORT_PCR_PE_MASK | PORT_PCR_PS(0);       /* FXIO0_D1 */
    FLEXIO_DATA2_PORT->PCR[FLEXIO_DATA2_PIN] = PORT_PCR_MUX(FLEXIO_DATA2_MUX) | PORT_PCR_PE_MASK | PORT_PCR_PS(0);       /* FXIO0_D2 */
    FLEXIO_DATA3_PORT->PCR[FLEXIO_DATA3_PIN] = PORT_PCR_MUX(FLEXIO_DATA3_MUX) | PORT_PCR_PE_MASK | PORT_PCR_PS(0);       /* FXIO0_D3 */
    FLEXIO_DATA4_PORT->PCR[FLEXIO_DATA4_PIN] = PORT_PCR_MUX(FLEXIO_DATA4_MUX) | PORT_PCR_PE_MASK | PORT_PCR_PS(0);       /* FXIO0_D4 */
    FLEXIO_DATA5_PORT->PCR[FLEXIO_DATA5_PIN] = PORT_PCR_MUX(FLEXIO_DATA5_MUX) | PORT_PCR_PE_MASK | PORT_PCR_PS(0);       /* FXIO0_D5 */
    FLEXIO_DATA6_PORT->PCR[FLEXIO_DATA6_PIN] = PORT_PCR_MUX(FLEXIO_DATA6_MUX) | PORT_PCR_PE_MASK | PORT_PCR_PS(0);       /* FXIO0_D6 */
    FLEXIO_DATA7_PORT->PCR[FLEXIO_DATA7_PIN] = PORT_PCR_MUX(FLEXIO_DATA7_MUX) | PORT_PCR_PE_MASK | PORT_PCR_PS(0);       /* FXIO0_D7 */
}

/* Configure FLEXIO_WR pin as FlexIO function */
void FLEXIO_8080_Config_WR_FlexIO(void)
{
    FLEXIO_WR_PORT->PCR[FLEXIO_WR_PIN] = PORT_PCR_MUX(FLEXIO_WR_PIN_MUX) | PORT_PCR_PE_MASK | PORT_PCR_PS_MASK;
}

/* Configure FLEXIO_WR pin as GPIO function and outputting high level */
void FLEXIO_8080_Config_WR_GPIO(void)
{
    FLEXIO_WR_GPIO->PSOR |= 1U << FLEXIO_WR_PIN;
    FLEXIO_WR_GPIO->PDDR |= 1U << FLEXIO_WR_PIN;
    FLEXIO_WR_PORT->PCR[FLEXIO_WR_PIN] = PORT_PCR_MUX(1U) | PORT_PCR_PE_MASK | PORT_PCR_PS_MASK;
}

/* Configure FLEXIO_RD pin as FlexIO function */
void FLEXIO_8080_Config_RD_FlexIO(void)
{
    FLEXIO_RD_PORT->PCR[FLEXIO_RD_PIN] = PORT_PCR_MUX(FLEXIO_RD_PIN_MUX) | PORT_PCR_PE_MASK | PORT_PCR_PS_MASK;
}

/* Configure FLEXIO_RD pin as GPIO function and outputting high level */
void FLEXIO_8080_Config_RD_GPIO(void)
{
    FLEXIO_RD_GPIO->PSOR |= 1U << FLEXIO_RD_PIN;
    FLEXIO_RD_GPIO->PDDR |= 1U << FLEXIO_RD_PIN;
    FLEXIO_RD_PORT->PCR[FLEXIO_RD_PIN] = PORT_PCR_MUX(1U) | PORT_PCR_PE_MASK | PORT_PCR_PS_MASK;
}

/* Configure FLEXIO_CS pin as GPIO function and outputting high level */
void FLEXIO_8080_Config_CS_GPIO(void)
{
    FLEXIO_CS_GPIO->PSOR |= 1U << FLEXIO_CS_PIN;
    FLEXIO_CS_GPIO->PDDR |= 1U << FLEXIO_CS_PIN;
    FLEXIO_CS_PORT->PCR[FLEXIO_CS_PIN] = PORT_PCR_MUX(1U) | PORT_PCR_PE_MASK | PORT_PCR_PS_MASK;
}

/* Set FLEXIO_CS pin's level */
void FLEXIO_8080_Set_CS_Pin(bool level)
{
    if(level)
    {
        FLEXIO_CS_GPIO->PSOR |= 1U << FLEXIO_CS_PIN;
    }
    else
    {
        FLEXIO_CS_GPIO->PCOR |= 1U << FLEXIO_CS_PIN;
    }
}

/* Configure RS pin as GPIO function and outputting high level */
void FLEXIO_8080_Config_RS_GPIO(void)
{
    FLEXIO_RS_GPIO->PSOR |= 1U << FLEXIO_RS_PIN;
    FLEXIO_RS_GPIO->PDDR |= 1U << FLEXIO_RS_PIN;
    FLEXIO_RS_PORT->PCR[FLEXIO_RS_PIN] = PORT_PCR_MUX(1U) | PORT_PCR_PE_MASK | PORT_PCR_PS_MASK;
}

/* Set RS pin's level */
void FLEXIO_8080_Set_RS_Pin(bool level)
{
    if(level)
    {
        FLEXIO_RS_GPIO->PSOR |= 1U << FLEXIO_RS_PIN;
    }
    else
    {
        FLEXIO_RS_GPIO->PCOR |= 1U << FLEXIO_RS_PIN;
    }
}