/*
 * Copyright (c) 2015, Freescale Semiconductor, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * o Redistributions of source code must retain the above copyright notice, this list
 *   of conditions and the following disclaimer.
 *
 * o Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * o Neither the name of Freescale Semiconductor, Inc. nor the names of its
 *   contributors may be used to endorse or promote products derived from this
 *   software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _PIN_MUX_H_
#define _PIN_MUX_H_

#include "board.h"
#include "fsl_common.h"


#define FLEXIO_DATA0_FXIOD_INDEX    0U
#define FLEXIO_DATA0_PORT           PORTD
#define FLEXIO_DATA0_PIN            0U
#define FLEXIO_DATA0_MUX            6U

#define FLEXIO_DATA1_PORT           PORTD
#define FLEXIO_DATA1_PIN            1U
#define FLEXIO_DATA1_MUX            6U

#define FLEXIO_DATA2_PORT           PORTD
#define FLEXIO_DATA2_PIN            2U
#define FLEXIO_DATA2_MUX            6U

#define FLEXIO_DATA3_PORT           PORTD
#define FLEXIO_DATA3_PIN            3U
#define FLEXIO_DATA3_MUX            6U

#define FLEXIO_DATA4_PORT           PORTD
#define FLEXIO_DATA4_PIN            4U
#define FLEXIO_DATA4_MUX            6U

#define FLEXIO_DATA5_PORT           PORTD
#define FLEXIO_DATA5_PIN            5U
#define FLEXIO_DATA5_MUX            6U

#define FLEXIO_DATA6_PORT           PORTD
#define FLEXIO_DATA6_PIN            6U
#define FLEXIO_DATA6_MUX            6U

#define FLEXIO_DATA7_PORT           PORTD
#define FLEXIO_DATA7_PIN            7U
#define FLEXIO_DATA7_MUX            6U

#define FLEXIO_WR_PIN_FXIOD_INDEX   16U                     /* WR pin */
#define FLEXIO_WR_PORT              PORTB
#define FLEXIO_WR_PIN               16U
#define FLEXIO_WR_GPIO              GPIOB
#define FLEXIO_WR_PIN_MUX           6U

#define FLEXIO_RD_PIN_FXIOD_INDEX   17U                     /* RD pin */
#define FLEXIO_RD_PORT              PORTB
#define FLEXIO_RD_PIN               17U
#define FLEXIO_RD_GPIO              GPIOB
#define FLEXIO_RD_PIN_MUX           6U

#define FLEXIO_CS_PORT              PORTB
#define FLEXIO_CS_PIN               18U                     /* CS pin */
#define FLEXIO_CS_GPIO              GPIOB

#define FLEXIO_RS_PORT              PORTB
#define FLEXIO_RS_PIN               19U                     /* RS pin */
#define FLEXIO_RS_GPIO              GPIOB


#if defined(__cplusplus)
extern "C" {
#endif /* __cplusplus*/
       /*!
        * @brief configure all pins for this demo/example
        *
        */
void BOARD_InitPins(void);


/* Configure port mux of FlexIO data pins */
void FLEXIO_8080_Config_Data_Pin(void);

/* Configure WR pin as FlexIO function */
void FLEXIO_8080_Config_WR_FlexIO(void);

/* Configure WR pin as GPIO function and outputting high level */
void FLEXIO_8080_Config_WR_GPIO(void);

/* Configure RD pin as FlexIO function */
void FLEXIO_8080_Config_RD_FlexIO(void);

/* Configure RD pin as GPIO function and outputting high level */
void FLEXIO_8080_Config_RD_GPIO(void);

/* Configure CS pin as GPIO function and outputting high level */
void FLEXIO_8080_Config_CS_GPIO(void);

/* Set CS pin's level */
void FLEXIO_8080_Set_CS_Pin(bool level);

/* Configure RS pin as GPIO function and outputting high level */
void FLEXIO_8080_Config_RS_GPIO(void);

/* Set RS pin's level */
void FLEXIO_8080_Set_RS_Pin(bool level);

#if defined(__cplusplus)
}
#endif /* __cplusplus*/

#endif /* _PIN_MUX_H_ */
