
MEMORY {
// Memory map for the MPC5748G

// Flash blocks. UTEST starts at 0x00400000.
// First boot header at 0x00f8c000
    flash_rsvd1  : ORIGIN = 0x00400000, LENGTH = 0x00b8c000
    flash_memory : ORIGIN = 0x00f8c000,	LENGTH = 0x005f4000
    flash_rsvd2  : ORIGIN = .,          LENGTH = 0 

// 768K of system SRAM starting at 0x40000000
    dram_rsvd1   : ORIGIN = 0x40000000, LENGTH = 0x100 // reserved for interrupt vectors
    dram_reset   : ORIGIN = .,	        LENGTH = 0
    dram_memory  : ORIGIN = .,          LENGTH = 768K-0x100
    dram_rsvd2   : ORIGIN = .,          LENGTH = 0
}
DEFAULTS {
    stack_reserve = 32k
    stack_reserve1 = 32k
    stack_reserve2 = 32k
    heap_reserve = 32k
}
//
// Program layout for running out of RAM.
//
//

SECTIONS
{
    .PPC.EMB.sdata0 	            	    	    ABS : > dram_memory
    .PPC.EMB.sbss0                            CLEAR ABS : > .

    .boot_header					: > .
    .text  			            		: > dram_memory
    .vletext 				    		: > .
    .syscall 				    		: > .
    .secinfo 				    		: > .
    .rodata 				    		: > .
    .toc 				    		: > .
    .sdata2 				    		: > .
    .opd 				    		: > .
    .fixaddr			 	   		: > .
    .fixtype						: > .

    .sdabase 		        	      ALIGN(16) : > dram_memory	
    .sdata 						: > .
    .sbss 						: > .
    .data 						: > .
    .bss 		  				: > .
    .ghcovfz 					  CLEAR	: > .
    .ghcovcz 					  CLEAR	: > .
    .ghcovdz 					  CLEAR	: > .

    .heap                  ALIGN(16) PAD(heap_reserve)  : > dram_memory
    .stack_core1          ALIGN(16) PAD(stack_reserve1) : > .
    .stack_core2          ALIGN(16) PAD(stack_reserve2) : > .
    .stack                 ALIGN(16) PAD(stack_reserve) : > .

//
// These special symbols mark the bounds of RAM and ROM memory.
// They are used by the MULTI debugger.
//
    __ghs_ramstart  = MEMADDR(dram_rsvd1);
    __ghs_ramend    = MEMENDADDR(dram_memory);
    __ghs_romstart  = MEMADDR(flash_rsvd1);
    __ghs_romend    = MEMENDADDR(flash_rsvd2);
    
}
