/*******************************************************************************
* NXP Semiconductors
* (c) Copyright 2016 NXP Semiconductors
* ALL RIGHTS RESERVED.
********************************************************************************
Services performed by NXP in this matter are performed AS IS and without any 
warranty. CUSTOMER retains the final decision relative to the total design
and functionality of the end product. NXP neither guarantees nor will be held
liable by CUSTOMER for the success of this project.
NXP DISCLAIMS ALL WARRANTIES, EXPRESSED, IMPLIED OR STATUTORY INCLUDING,
BUT NOT LIMITED TO, IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR
A PARTICULAR PURPOSE ON ANY HARDWARE, SOFTWARE ORE ADVISE SUPPLIED 
TO THE PROJECT BY NXP, AND OR NAY PRODUCT RESULTING FROM NXP SERVICES. 
IN NO EVENT SHALL NXP BE LIABLE FOR INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING
OUT OF THIS AGREEMENT. 
CUSTOMER agrees to hold NXP harmless against any and all claims demands 
or actions by anyone on account of any damage, or injury, whether commercial,
contractual, or tortuous, rising directly or indirectly as a result 
of the advise or assistance supplied CUSTOMER in connection with product, 
services or goods supplied under this Agreement.
********************************************************************************
* File              Errors.c
* Owner             Lukas Zadrapa
* Version           1.0
* Date              Jun-20-2016
* Classification    General Business Information
* Brief             Error functions
********************************************************************************
* Detailed Description:
********************************************************************************
Revision History:
Ver  Date         Author            Description of Changes
1.0  Jun-20-2016  Lukas Zadrapa     Initial version
*******************************************************************************/

/*******************************************************************************
* Includes                                                                     
*******************************************************************************/
#include <string.h>
#include "Errors.h"
#include "MPC5748G_310.h"

/*******************************************************************************
* External objects
*******************************************************************************/

/*******************************************************************************
* Constants and macros
*******************************************************************************/
char * const ErrorString[] = {
                                      NULL,
                                      "S-Record Out Of Range",
                                      "S-Record Size Must Be Even",
                                      "Flash Programming Error",
                                      "Flash Erase Error",
                                      "Bad Hex Data",
                                      "S-Record Too Long",
                                      "CheckSumErr",
                                      "Flash Init Error"
                                    };

const char BadError[] = "Invalid Error Number";

/*******************************************************************************
* Global variables
*******************************************************************************/

/*******************************************************************************
* Local types
*******************************************************************************/

/*******************************************************************************
* Local function prototypes
*******************************************************************************/

/*******************************************************************************
* Local variables
*******************************************************************************/

/*******************************************************************************
* Local functions
*******************************************************************************/

/*******************************************************************************
* Global functions
*******************************************************************************/

/*******************************************************************************
Function Name : GetErrorString
Engineer      : Lukas Zadrapa
Date          : Jun-20-2016
Parameters    : NONE
Modifies      : NONE
Returns       : Returns pointer to error string
Notes         : NONE 
Issues        : NONE
*******************************************************************************/
char * GetErrorString(uint8_t ErrorNumber)
{
  int16_t MaxError;
  
  
  MaxError = sizeof(ErrorString) / sizeof(int8_t *);
  
  if (ErrorNumber > MaxError)
    return((char *)BadError);
  else
    return(ErrorString[ErrorNumber]);
  
}
