
MEMORY {
// Memory map for the MPC5748G

// Flash blocks. UTEST starts at 0x00400000.
// First boot header at 0x00f8c000
    flash_rsvd1  : ORIGIN = 0x00400000, LENGTH = 0x00b8c000
//    flash_memory : ORIGIN = 0x00f8c000,	LENGTH = 0x005f4000
    flash_memory : ORIGIN = 0x00f94000,	LENGTH = 0x005ec000
    flash_rsvd2  : ORIGIN = .,          LENGTH = 0 

// 768K of system SRAM starting at 0x40000000
    dram_rsvd1   : ORIGIN = 0x40000000, LENGTH = 0x100 // reserved for interrupt vectors
    dram_reset   : ORIGIN = .,	        LENGTH = 0
    dram_memory  : ORIGIN = .,          LENGTH = 768K-0x100
    dram_rsvd2   : ORIGIN = .,          LENGTH = 0
}
DEFAULTS {
    stack_reserve = 32k
    stack_reserve1 = 32k
    stack_reserve2 = 32k
    heap_reserve = 32k
}
//
// Program layout for starting in ROM, copying data to RAM,
// and continuing to execute out of ROM.
//

SECTIONS
{
//
// RAM SECTIONS
//
    .PPC.EMB.sdata0 	          		    ABS : > dram_memory
    .PPC.EMB.sbss0                            CLEAR ABS : > .
   
    .sdabase 		       		       ALIGN(16): > dram_memory	
    .sdata 						: > .
    .sbss 						: > .
    .data 						: > .
    .bss 						: > .
    .ghcovfz 					  CLEAR : > .
    .ghcovcz 					  CLEAR	: > .
    .ghcovdz 					  CLEAR	: > .

    .heap                  ALIGN(16) PAD(heap_reserve)  : > dram_memory
    .stack_core1          ALIGN(16) PAD(stack_reserve1) : > .
    .stack_core2          ALIGN(16) PAD(stack_reserve2) : > .
    .stack                 ALIGN(16) PAD(stack_reserve) : > .
//
// ROM SECTIONS
//
    .boot_header					: > flash_memory
    .text						: > flash_memory
    .vletext						: > .
    .syscall						: > .

    .rodata		 				: > .
    .toc 				     SHFLAGS(2)	: > .
    .sdata2 						: > .
    .opd 				     SHFLAGS(2)	: > .

    .secinfo 						: > .
    .fixaddr 						: > .
    .fixtype 						: > .

    .CROM.PPC.EMB.sdata0 	  CROM(.PPC.EMB.sdata0) : > .
    .CROM.sdata  	            	   CROM(.sdata) : > .
    .CROM.data 	            		    CROM(.data) : > .

//
// These special symbols mark the bounds of RAM and ROM memory.
// They are used by the MULTI debugger.
//
    __ghs_ramstart  = MEMADDR(dram_rsvd1);
    __ghs_ramend    = MEMENDADDR(dram_memory);
    __ghs_romstart  = MEMADDR(flash_rsvd1);
    __ghs_romend    = MEMENDADDR(flash_rsvd2);

//
// These special symbols mark the bounds of RAM and ROM images of boot code.
// They are used by the GHS startup code (_start and __ghs_ind_crt0).
//
    __ghs_rambootcodestart  = 0;
    __ghs_rambootcodeend    = 0;
    __ghs_rombootcodestart  = ADDR(.text);
    __ghs_rombootcodeend    = ENDADDR(.fixtype);
}

