/*******************************************************************************
* NXP Semiconductors
* (c) Copyright 2016 NXP Semiconductors
* ALL RIGHTS RESERVED.
********************************************************************************
Services performed by NXP in this matter are performed AS IS and without any 
warranty. CUSTOMER retains the final decision relative to the total design
and functionality of the end product. NXP neither guarantees nor will be held
liable by CUSTOMER for the success of this project.
NXP DISCLAIMS ALL WARRANTIES, EXPRESSED, IMPLIED OR STATUTORY INCLUDING,
BUT NOT LIMITED TO, IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR
A PARTICULAR PURPOSE ON ANY HARDWARE, SOFTWARE ORE ADVISE SUPPLIED 
TO THE PROJECT BY NXP, AND OR NAY PRODUCT RESULTING FROM NXP SERVICES. 
IN NO EVENT SHALL NXP BE LIABLE FOR INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING
OUT OF THIS AGREEMENT. 
CUSTOMER agrees to hold NXP harmless against any and all claims demands 
or actions by anyone on account of any damage, or injury, whether commercial,
contractual, or tortuous, rising directly or indirectly as a result 
of the advise or assistance supplied CUSTOMER in connection with product, 
services or goods supplied under this Agreement.
********************************************************************************
* File:             main.c
* Owner:            Lukas Zadrapa
* Version:          1.0
* Date:             Jun-20-2016
* Classification:   General Business Information
* Brief:            User Application for MPC5748G
********************************************************************************
* Detailed Description:
*
* This project just toggles LED DS2 on EVB board to show that this User
* Application has been started by bootloader. 
*
* ------------------------------------------------------------------------------
* Test HW:         MPC574XG-324DS Rev.A + MPC574XG-MB Rev.C
* MCU:             PPC5748GMMN6A 1N81M
* Fsys:            160 MHz PLL
* Debugger:        Lauterbach Trace32
* Target:          internal_FLASH
********************************************************************************
Revision History:
Ver  Date         Author            Description of Changes
1.0  Jun-20-2016  Lukas Zadrapa     Initial version
*******************************************************************************/

/*******************************************************************************
* Includes                                                                     
*******************************************************************************/
#include "MPC5748G_310.h"
#include "typedefs.h"

/*******************************************************************************
* Constants and macros
*******************************************************************************/
#define	DRUN_MODE	0x3

#define	LED_DS2		98	/* pin PG[2] */

/*******************************************************************************
* External objects
*******************************************************************************/

/*******************************************************************************
* Global variables
*******************************************************************************/

/*******************************************************************************
* Local functions
*******************************************************************************/

/*******************************************************************************
Function Name : Sys_Init
Engineer      : Lukas Zadrapa
Date          : Jun-20-2016
Parameters    : NONE
Modifies      : NONE
Returns       : NONE
Notes         : Clock settings - configure 160MHz system clock using
                40MHz crystal
Issues        : NONE
*******************************************************************************/
void Sys_Init(void)
{    
    /* enable all modes, enable all peripherals */
    MC_ME.ME.R        = 0x000005FF;
    MC_ME.RUN_PC[0].R = 0x000000FE;
    /* Connect XOSC to PLL */
    MC_CGM.AC5_SC.B.SELCTL = 1;              
    /* Configure PLL0 Dividers - 160MHz from 40Mhx XOSC */
    PLLDIG.PLLDV.B.PREDIV  = 2;
    PLLDIG.PLLDV.B.MFD     = 32;
    PLLDIG.PLLDV.B.RFDPHI  = 1;
    PLLDIG.PLLCAL3.R       = 0x09C3C000;
    PLLDIG.PLLFD.B.SMDEN   = 1;       /* Sigma delta modulation disabled */
    /* switch to PLL */
    MC_ME.DRUN_MC.R  = 0x00130172;    /* FLASH in normal mode, PLLON, FXOSC ON, Use PLL_PHI_0 */
    
    MC_ME.MCTL.R     = 0x30005AF0;    /* DRUN target mode + KEY */
    MC_ME.MCTL.R     = 0x3000A50F;    /* DRUN target mode + KEY Inverted */
    
    while(MC_ME.GS.B.S_MTRANS == 1); /* Wait for mode transition complete */

    /* Enable CLKOUT signal */
    /* System clock (160MHz divided by 20 = 8MHz) will be visible on pin PG[7] */
    /* Pin PG[7] is configured in SIUL2_Init() function */
    MC_CGM.AC6_DC0.B.DE = 1;		/* Enable output clock devided */
    MC_CGM.AC6_DC0.B.DIV = 0x13;	/* Divide output clock by 20 */
    MC_CGM.AC6_SC.B.SELCTL = 0x2; 	/* PLL_CLKOUT1 */    
}//Sys_Init

/*******************************************************************************
Function Name : SIUL2_Init
Engineer      : Lukas Zadrapa
Date          : Jun-20-2016
Parameters    : NONE
Modifies      : NONE
Returns       : NONE
Notes         : Configure PG[2] as output to drive LED DS2
Issues        : NONE
*******************************************************************************/
void SIUL2_Init (void)
{
    /* Initialize LED */
    SIUL2.GPDO[LED_DS2].R = 1;	/* LEDs are active low, set to initial inactive state */
    
    SIUL2.MSCR[LED_DS2].R = 0x02000000;	/* Configure GPIOs as output */
}//SIUL2_Init

/*******************************************************************************
* Global functions
*******************************************************************************/

/*******************************************************************************
Function Name : main
Engineer      : Lukas Zadrapa
Date          : Jun-20-2016
Parameters    : NONE
Modifies      : NONE
Returns       : NONE
Notes         : Watchdog SWT_0 is disabled in startup file crt0.ppc.
Issues        : NONE
*******************************************************************************/
void main (void)
{
    unsigned int i;
    
    Sys_Init();
    SIUL2_Init();
   
    while(1)
    {
	SIUL2.GPDO[LED_DS2].R ^= 1;	/* Toggle LED1 */
	for(i=0; i<1000000; i++)
	    asm("nop");
    };    
}//main
