/******************************************************************************
*
* (c) Copyright 2009, Freescale & STMicroelectronics
*
***************************************************************************//*!
*
* @file     GFLIB_ControllerPIrAW.h
*
* @author   Roman Filka
*
* @version  1.0.6.0
*
* @date     Jan-11-2010
*
* @brief    Header file for #GFLIB_ControllerPIrAW function.
*
*******************************************************************************
*
* Function implemented as ANSIC ISO/IEC 9899:1990, C90.
*
******************************************************************************/
#ifndef _GFLIB_CONTROLLER_PIRAW_H
#define _GFLIB_CONTROLLER_PIRAW_H

#ifdef __cplusplus
extern "C" {
#endif

#ifndef  _MATLAB_BAM_CREATE
#include "SWLIBS_Typedefs.h"
#include "SWLIBS_Defines.h"
#include "SWLIBS_Inlines.h"
#endif

/******************************************************************************
| Defines and macros            (scope: module-local)
-----------------------------------------------------------------------------*/
/*! Function alias for #GFLIB_ControllerPIrAWANSIC function.*/
#define GFLIB_ControllerPIrAW(s32InErr,pParam)\
                            GFLIB_ControllerPIrAWANSIC(s32InErr, pParam)

/*! Macro containing default values of recurrent form PI controller with anti\--windup.*/
#define GFLIB_CONTROLLER_PIAW_R_DEFAULT   {0,0,0,0,INT32_MIN,INT32_MAX,0}

/******************************************************************************
| Typedefs and structures       (scope: module-local)
-----------------------------------------------------------------------------*/
/*------------------------------------------------------------------------*//*!
@struct GFLIB_CONTROLLER_PIAW_R_T "\GFLIB_ControllerPIrAW.h"

@brief  Structure containing parameters and states of recurrent form PI controller
        with anti\--windup
*//*-------------------------------------------------------------------------*/
typedef struct
{
    tFrac32 s32CC1sc;   /*!< CC1 coefficient, fractional format normalized to fit into \f$\left[-2^{31},2^{31}-1\right)\f$ */
    tFrac32 s32CC2sc;   /*!< CC2 coefficient, fractional format normalized to fit into \f$\left[-2^{31},2^{31}-1\right)\f$ */
    tFrac32 s32Acc;     /*!< Internal controller accumulator */
    tFrac32 s32InErrK1; /*!< Controller input from previous calculation step */
    tFrac32 s32UpperLimit; /*!< Upper Limit of the controller, fractional format normalized to fit into \f$\left[-2^{31},2^{31}-1\right)\f$ */
    tFrac32 s32LowerLimit; /*!< Lower Limit of the controller, fractional format normalized to fit into \f$\left[-2^{31},2^{31}-1\right)\f$ */
    tU16    u16NShift;   /*!< Scaling factor for controller coefficients, integer format \f$\left[0,31\right]\f$ */
}GFLIB_CONTROLLER_PIAW_R_T;

/******************************************************************************
| Exported Variables
-----------------------------------------------------------------------------*/

/******************************************************************************
| Exported function prototypes
-----------------------------------------------------------------------------*/
/*!
* @ingroup GFLIB_GROUP
*/

extern tFrac32 GFLIB_ControllerPIrAWANSIC(tFrac32 s32InErr,
                                          GFLIB_CONTROLLER_PIAW_R_T *pParam);

/******************************************************************************
| Inline functions
-----------------------------------------------------------------------------*/

#ifdef __cplusplus
}
#endif

#endif /* _GFLIB_CONTROLLER_PIRAW_H */

