/******************************************************************************
*
* (c) Copyright 2009, Freescale & STMicroelectronics
*
***************************************************************************//*!
*
* @file     GFLIB_Cos.h
*
* @author   B04459
*
* @version  1.0.5.0
*
* @date     Jan-11-2010
*
* @brief    Header file for #GFLIB_Cos function.
*
*******************************************************************************
*
* Function implemented as ANSIC ISO/IEC 9899:1990, C90.
*
******************************************************************************/
#ifndef _GFLIB_COS_H
#define _GFLIB_COS_H

#ifndef  _MATLAB_BAM_CREATE
#include "SWLIBS_Typedefs.h"
#include "SWLIBS_Defines.h"
#include "SWLIBS_Inlines.h"
#endif
/******************************************************************************
* Defines and macros            (scope: module-local)
******************************************************************************/
/*! Function alias for #GFLIB_CosANSIC function.*/
#define GFLIB_Cos(s32In) GFLIB_CosANSIC(s32In, &gflibCosCoef)

/******************************************************************************
* Typedefs and structures       (scope: module-local)
******************************************************************************/
/*------------------------------------------------------------------------*//*!
@struct GFLIB_COSTLR_T "\GFLIB_Cos.h"

@brief      Structure containing one array of five 32-bit elements for storing
            coefficients of Taylor polynomial.

@details    By calling function alias #GFLIB_Cos, default values of coefficients
            are used. Polynomial coefficients can be modified by the user
            and in such a case full function call shall be used, i.e. #GFLIB_CosANSIC.
*//*-------------------------------------------------------------------------*/
typedef struct
{
    tFrac32  s32A[5];  /*!< Array of five 32-bit elements for storing coefficients
                            of Taylor polynomial. */
}GFLIB_COSTLR_T;

/******************************************************************************
* Exported Variables
******************************************************************************/
extern const GFLIB_COSTLR_T gflibCosCoef;

/******************************************************************************
* Exported function prototypes
******************************************************************************/
/*!
* @ingroup GFLIB_GROUP
*/
extern tFrac32 GFLIB_CosANSIC(tFrac32 s32In, const GFLIB_COSTLR_T * const pParam);

/******************************************************************************
* Inline functions
******************************************************************************/

#endif /* _GFLIB_COS_H */

