/******************************************************************************
*
* (c) Copyright 2009, Freescale & STMicroelectronics
*
***************************************************************************//*!
*
* @file     GFLIB_Hyst.h
*
* @author   Roman Filka
*
* @version  1.0.4.0
*
* @date     Jan-11-2010
*
* @brief    Header file for #GFLIB_Hyst function.
*
*******************************************************************************
*
* Function implemented as ANSIC ISO/IEC 9899:1990, C90.
*
******************************************************************************/
#ifndef _GFLIB_HYST_H
#define _GFLIB_HYST_H

#ifndef  _MATLAB_BAM_CREATE
#include "SWLIBS_Typedefs.h"
#include "SWLIBS_Defines.h"
#include "SWLIBS_Inlines.h"
#endif

/******************************************************************************
* Defines and macros            (scope: module-local)
******************************************************************************/
/*! Function alias for #GFLIB_HystANSIC function.*/
#define GFLIB_Hyst(s32In, pParam) GFLIB_HystANSIC(s32In, pParam)

/*! Macro containing default values of hysteresis function structure.*/
#define GFLIB_HYST_DEFAULT   {0,0,0,0,0}

/******************************************************************************
* Typedefs and structures       (scope: module-local)
******************************************************************************/
/*------------------------------------------------------------------------*//*!
@struct GFLIB_HYST_T "\GFLIB_Hyst.h"

@brief      Structure containing parameters and states for hysteresis function
            implemented in #GFLIB_Hyst.

@details
*//*-------------------------------------------------------------------------*/
typedef struct
{
    tFrac32  s32HystOn;     /*!< Value determining the upper threshold; fractional format normalized to fit into \f$\left[-2^{31},2^{31}-1\right)\f$ . */
    tFrac32  s32HystOff;    /*!< Value determining the lower threshold; fractional format normalized to fit into \f$\left[-2^{31},2^{31}-1\right)\f$ . */
    tFrac32  s32OutValOn;   /*!< Value of output when input is higher than upper threshold; fractional format normalized to fit into \f$\left[-2^{31},2^{31}-1\right)\f$ . */
    tFrac32  s32OutValOff;  /*!< Value of output when input is lower than lower threshold; fractional format normalized to fit into \f$\left[-2^{31},2^{31}-1\right)\f$ . */
    tFrac32  s32OutState;   /*!< Actual state of the output; fractional format normalized to fit into \f$\left[-2^{31},2^{31}-1\right)\f$ . */
}GFLIB_HYST_T;

/******************************************************************************
* Exported Variables
******************************************************************************/

/******************************************************************************
* Exported function prototypes
******************************************************************************/
/*!
* @ingroup GFLIB_GROUP
*/
extern tFrac32 GFLIB_HystANSIC(tFrac32 s32In, GFLIB_HYST_T *pParam);

/******************************************************************************
* Inline functions
******************************************************************************/

#endif /* _GFLIB_HYST_H */
