/******************************************************************************
*
* (c) Copyright 2009, Freescale & STMicroelectronics
*
***************************************************************************//*!
*
* @file     GFLIB_Tan.h
*
* @author   B04459
*
* @version  1.0.5.0
*
* @date     Jan-11-2010
*
* @brief    Header file for #GFLIB_Tan function.
*
*******************************************************************************
*
* Function implemented as ANSIC ISO/IEC 9899:1990, C90.
*
******************************************************************************/
#ifndef GFLIB_TAN_H_
#define GFLIB_TAN_H_

#ifndef  _MATLAB_BAM_CREATE
#include "SWLIBS_Typedefs.h"
#include "SWLIBS_Defines.h"
#include "SWLIBS_Inlines.h"
#endif

/******************************************************************************
* Defines and macros            (scope: module-local)
******************************************************************************/
/*! Function alias for #GFLIB_TanANSIC function.*/
#define GFLIB_Tan(s32In) GFLIB_TanANSIC(s32In, &gflibTanCoef)

/******************************************************************************
* Typedefs and structures       (scope: module-local)
******************************************************************************/
/*------------------------------------------------------------------------*//*!
@struct GFLIB_TAN_TAYLOR_COEF_T "\GFLIB_Tan.h"

@brief      Structure containing four polynomial coefficients for one sub-interval.

@details    Output of \f$\tan\left(\pi\cdot \mbox{s32In}\right)\f$ for
            interval \f$\left[0,\frac{\pi}{4}\right)\f$ of input angles is divided
            into eight sub-sectors. Polynomial approximation is done using 4th
            order polynomial, for each sub-sector respectively. Four coefficients
            for a single sub-interval are stored in this (#GFLIB_TAN_TAYLOR_COEF_T)
            structure.
*//*-------------------------------------------------------------------------*/
typedef struct
{
	tFrac32  s32A[4];          /*!< Array of four 32-bit elements for storing polynomial
                                    coefficients for one sub-interval. */
}GFLIB_TAN_TAYLOR_COEF_T;

/*------------------------------------------------------------------------*//*!
@struct GFLIB_TANTLR_T "\GFLIB_Tan.h"

@brief      Structure containing eight sub-structures with polynomial coefficients
            to cover all sub-intervals.

@details    Output of \f$\tan\left(\pi\cdot \mbox{s32In}\right)\f$ for
            interval \f$\left[0,\frac{\pi}{4}\right)\f$ of input angles is divided
            into eight sub-sectors. Polynomial approximation is done using 4th
            order polynomial, for each sub-sector respectively. Eight arrays,
            each including four polynomial coefficients for each sub-interval,
            are stored in this (#GFLIB_TANTLR_T) structure.

            \par
            By calling function alias #GFLIB_Tan, default values of coefficients
            are used. Polynomial coefficients can be modified by the user
            and in such a case full function call shall be used,i.e. #GFLIB_TanANSIC.
*//*-------------------------------------------------------------------------*/
typedef struct
{
    GFLIB_TAN_TAYLOR_COEF_T  GFLIB_TAN_SECTOR[8]; /*!< Array of eight elements for
                                                       storing eight sub-arrays
                                                       (each sub-array contains four
                                                       32-bit coefficients)
                                                       for all sub-intervals.*/
}GFLIB_TANTLR_T;

/******************************************************************************
* Exported Variables
******************************************************************************/
extern const GFLIB_TANTLR_T gflibTanCoef;

/******************************************************************************
* Exported function prototypes
******************************************************************************/
/*!
* @ingroup GFLIB_GROUP
*/
extern tFrac32 GFLIB_TanANSIC(tFrac32 s32In, const GFLIB_TANTLR_T * const pParam);

/******************************************************************************
* Inline functions
******************************************************************************/

#endif /*GFLIB_TAN_H_*/
