/******************************************************************************
*
* (c) Copyright 2009, Freescale & STMicroelectronics
*
***************************************************************************//*!
*
* @file      GFLIB_UpperLimit.c
*
* @author    Virginia Clemente
* 
* @version    1.0.13.0
* 
* @date      Apr-26-2010
* 
* @brief     Source file for the Upper-Limit function.
*
********************************************************************************
*
* Function implemented as ANSIC ISO/IEC 9899:1990, C90.
*
*******************************************************************************/
/*!
@if GFLIB_GROUP
	@addtogroup GFLIB_GROUP
@else
	@defgroup GFLIB_GROUP	GFLIB	
@endif
*/ 

#include "SWLIBS_Typedefs.h"
#include "GFLIB_UpperLimit.h"

#ifdef __cplusplus
extern "C" {
#endif

/*******************************************************************************
| external declarations
|-----------------------------------------------------------------------------*/

/*******************************************************************************
| defines and macros (scope: module-local)
|-----------------------------------------------------------------------------*/

/*******************************************************************************
| typedefs and structures (scope: module-local)
|-----------------------------------------------------------------------------*/

/*******************************************************************************
| global variable definitions (scope: module-exported)
|-----------------------------------------------------------------------------*/

/*******************************************************************************
| global variable definitions (scope: module-local)
|-----------------------------------------------------------------------------*/

/*******************************************************************************
| function prototypes (scope: module-local)
|-----------------------------------------------------------------------------*/

/*******************************************************************************
| function implementations (scope: module-local)
|-----------------------------------------------------------------------------*/

/*******************************************************************************
| function implementations (scope: module-exported)
|-----------------------------------------------------------------------------*/

/***************************************************************************//*!
@brief       The function limits the input value by the defined upper limit.

@param[in]   s32In   Input value.
@param[in]   pParam  Pointer to the limits structure.
  
@return      The input value or the upper limit if the input value is
             larger than the upper limit.
        
@details     The function tests whether the input value is below the upper
             limit. If so the input value will be returned.  Otherwise, if the
             input value is above the upper limit, the upper limit will be
             returned.

             The upper limits can be found in the limits structure, supplied to
             the function as a pointer \c pParam.

@par Reentrancy:
            The function is reentrant.

@par Code Example:
\code
#include "gflib.h"

tFrac32 x;
tFrac32 y;
GFLIB_UPPERLIMIT_T UpperLimitParam;

void main(void)
{
    // 0.5 = 0x40000000
    UpperLimitParam.s32UpperLimit = FRAC32(0.5);

    // x = 0.75 = 0x60000000
    x  = FRAC32(0.75);
    // y should be 0x40000000
    y = GFLIB_UpperLimit(x, &UpperLimitParam);

    // x = -0.75 = 0xa0000000
    x  = FRAC32(-0.75);
    // y should be 0xa0000000
    y = GFLIB_UpperLimit(x, &UpperLimitParam);

    // x = 0.25 = 0x20000000
    x  = FRAC32(0.25);
    // y should be 0x20000000
    y = GFLIB_UpperLimit(x, &UpperLimitParam);

    return;
}
\endcode

@par Performance:
            \anchor tab1_GFLIB_UpperLimit
            <table border="1" CELLPADDING="5" align = "center">
            <caption>#GFLIB_UpperLimit function performance</caption>
            <tr>
              <th>Code size [bytes] GHS/CW</th> <td>14/10</td>
            </tr>
            <tr>
              <th>Data size [bytes] GHS/CW</th> <td>0/0</td>
            </tr>
            <tr>
              <th>Execution clock cycles max [clk] GHS/CW</th> <td>15/16</td>
            </tr>
            <tr>
              <th>Execution clock cycles min [clk] GHS/CW</th> <td>14/12</td>
            </tr>
            </table>

*******************************************************************************/

tFrac32 GFLIB_UpperLimitANSIC (tFrac32 s32In,
                               const GFLIB_UPPERLIMIT_T *const pParam)
{
    s32In = (s32In > pParam->s32UpperLimit) ? pParam->s32UpperLimit : s32In; 

    return s32In;
}
#ifdef __cplusplus
}
#endif

/* End of file */
