/*******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2004-2012 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
****************************************************************************//*!
*
* @file    etpu_gct.h_
*
* @author  Milan Brejl [r54529]
*
* @version 1.2
*
* @date    03-Jun-2016
*
* @brief   This file contains a template of prototypes and definese for
*          the same name .c file.
*
*******************************************************************************/
#include "typedefs.h"

/*******************************************************************************
* General Macros
*******************************************************************************/
#define ETPU_ENGINE_A_CHANNEL(x)  (x)
#define ETPU_ENGINE_B_CHANNEL(x)  ((x)+64)

#define FS_ETPU_ENTRY_TABLE_ADDR  (((FS_ETPU_ENTRY_TABLE)>>11) & 0x1F)

/******************************************************************************
* Application Constants and Macros
******************************************************************************/
#define SYS_FREQ_HZ                                                       160E6
#define TCR1_FREQ_HZ                                            (SYS_FREQ_HZ/2)
#define MSEC2TCR1(x)                                 (TCR1_FREQ_HZ/1E3*(x)/1E0)
#define USEC2TCR1(x)                                 (TCR1_FREQ_HZ/1E3*(x)/1E3)
#define NSEC2TCR1(x)                                 (TCR1_FREQ_HZ/1E3*(x)/1E6)
#define UFRACT24(x)                                              ((x)*0xFFFFFF)
#define SFRACT24(x)                                              ((x)*0x7FFFFF)

/*******************************************************************************
* Define Functions to Channels
*******************************************************************************/
#define ETPU_PWMM_MASTER_CH		        ETPU_ENGINE_A_CHANNEL(10)
#define ETPU_PWMM_PHASEA_BASE_CH        ETPU_ENGINE_A_CHANNEL(11)
#define ETPU_PWMM_PHASEA_COMPL_CH       ETPU_ENGINE_A_CHANNEL(12)
#define ETPU_PWMM_PHASEB_BASE_CH        ETPU_ENGINE_A_CHANNEL(17)
#define ETPU_PWMM_PHASEB_COMPL_CH       ETPU_ENGINE_A_CHANNEL(18)
#define ETPU_PWMM_PHASEC_BASE_CH        ETPU_ENGINE_A_CHANNEL(15)
#define ETPU_PWMM_PHASEC_COMPL_CH       ETPU_ENGINE_A_CHANNEL(16)


/*******************************************************************************
* Define Interrupt Enable, DMA Enable and Output Disable
*******************************************************************************/
#define ETPU_CIE_A    (1<<ETPU_PWMM_MASTER_CH)  /* enable interrupt on channel ETPU_<FUNC1>_CHAN */
#define ETPU_DTRE_A   0x00000000  /* enable DMA request on channel ETPU_<FUNC2>_CHAN */
#define ETPU_ODIS_A   0x00000000
#define ETPU_OPOL_A   0x00000000
#define ETPU_CIE_B    0x00000000
#define ETPU_DTRE_B   0x00000000
#define ETPU_ODIS_B   0x00000000
#define ETPU_OPOL_B   0x00000000

/******************************************************************************
* Global Variables Access
******************************************************************************/
/* Global <FUNC1> structures defined in etpu_gct.c */
extern struct pwmm_instance_t pwmm_instance;
extern struct pwmm_config_t  pwmm_config;
extern struct pwmm_inputs_t pwmm_inputs;
extern struct pwmm_states_t pwmm_states;



/*******************************************************************************
* Function Prototypes
*******************************************************************************/
int32_t my_system_etpu_init (void);
void    my_system_etpu_start(void);

/*******************************************************************************
 *
 * Copyright:
 *  Freescale Semiconductor, INC. All Rights Reserved.
 *  You are hereby granted a copyright license to use, modify, and
 *  distribute the SOFTWARE so long as this entire notice is
 *  retained without alteration in any modified and/or redistributed
 *  versions, and that such modified versions are clearly identified
 *  as such. No licenses are granted by implication, estoppel or
 *  otherwise under any patents or trademarks of Freescale
 *  Semiconductor, Inc. This software is provided on an "AS IS"
 *  basis and without warranty.
 *
 *  To the maximum extent permitted by applicable law, Freescale
 *  Semiconductor DISCLAIMS ALL WARRANTIES WHETHER EXPRESS OR IMPLIED,
 *  INCLUDING IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A
 *  PARTICULAR PURPOSE AND ANY WARRANTY AGAINST INFRINGEMENT WITH
 *  REGARD TO THE SOFTWARE (INCLUDING ANY MODIFIED VERSIONS THEREOF)
 *  AND ANY ACCOMPANYING WRITTEN MATERIALS.
 *
 *  To the maximum extent permitted by applicable law, IN NO EVENT
 *  SHALL Freescale Semiconductor BE LIABLE FOR ANY DAMAGES WHATSOEVER
 *  (INCLUDING WITHOUT LIMITATION, DAMAGES FOR LOSS OF BUSINESS PROFITS,
 *  BUSINESS INTERRUPTION, LOSS OF BUSINESS INFORMATION, OR OTHER
 *  PECUNIARY LOSS) ARISING OF THE USE OR INABILITY TO USE THE SOFTWARE.
 *
 *  Freescale Semiconductor assumes no responsibility for the
 *  maintenance and support of this software
 ******************************************************************************/
/*******************************************************************************
 *
 * REVISION HISTORY:
 *
 * FILE OWNER: Milan Brejl [r54529]
 *
 * Revision 1.2  2012/04/10  r54529
 * Adjusted to new API style comming with AN4908.
 *  
 * Revision 1.1  2012/04/10  r54529
 * Usage of fs_etpu2_init with autogenerated macro FS_ETPU_ENGINE_MEM_SIZE.
 *  
 * Revision 1.0  2012/02/22  r54529
 * Initial version based on eTPU Graphical Configuration Tool (GCT) output.
 *
 ******************************************************************************/
