/*
 * LIN.h
 *
 *  Created on: May 10, 2016
 *      Author: B55840
 */

#include "derivative.h"
#include "SCI0.h"

#ifndef LIN_H_
#define LIN_H_

/**********************************************************************************************
* Public functions
**********************************************************************************************/

/***********************************************************************************************
*
* @brief    LIN_init  - Initialize the LIN phy communication
* @param    none
* @return   none
*
************************************************************************************************/
void LIN_init();

/***********************************************************************************************
*
* @brief    LIN_send_data - Send a LIN frame
* @param    ID of the frame, number of bytes to be transmitted, data to be transmited
* @return   none
*
************************************************************************************************/
void LIN_send_data(unsigned char ID, unsigned char data_lenght, unsigned char data[]);


/***********************************************************************************************
*
* @brief    LIN_read_char - Read a response from an slave
* @param    ID of the header
* @return   Slave response to that ID
*
************************************************************************************************/
unsigned char LIN_read_char(unsigned char ID);


/***********************************************************************************************
*
* @brief    delay_us - Generate a delay of the desire microseconds
* @param    amount of micro seconds
* @return   none
*
************************************************************************************************/
/* time fuction */
void delay_us(unsigned int micro_seconds);

#endif /* LIN_H_ */
