/*
 * SCI.c
 *
 *  Created on: Jan 14, 2016
 *      Author: B55840
 */

#include "SCI0.h"


/********************************* SCI 0 ******************************************************/

/***********************************************************************************************
*
* @brief    Comms_Init - Initialize the serial communications driver
* @param    none
* @return   none
*
************************************************************************************************/
void SCI0_init(unsigned long bus_clk,unsigned int baudrate){
	SCI0BD = bus_clk/baudrate;
	SCI0CR2_TE = 1;				/* Enable Transmitter */
	SCI0SR2_BRK13 = 1;			/* Break character is 13 bit long */
}

/***********************************************************************************************
*
* @brief    SCI_send_break - Send break character
* @param    none
* @return   none
*
************************************************************************************************/
void SCI0_send_break(void){
	SCI0CR2_SBK = 1; /* send break */
	SCI0CR2_SBK = 0; /* stop trasmiting break */
	while(SCI0SR1_TC == 0){}
}

/***********************************************************************************************
*
* @brief    SCI_send_char - send character through SCI0
* @param    character to send
* @return   none
*
************************************************************************************************/
void SCI0_send_char(unsigned char character){
	SCI0DRL = character;
	while(SCI0SR1_TC==0){};
}

/***********************************************************************************************
*
* @brief    SCI_send_array - send array through SCI0
* @param    array to send
* @return   none
*
************************************************************************************************/
void SCI0_send_array(unsigned char array[]){
	int ptr = 0;
	while(array[ptr]!='\0'){
		SCI0_send_char(array[ptr]);
		ptr++;
	}
}

/***********************************************************************************************
*
* @brief    SCI_read_char - receive character from SCI0
* @param    none
* @return   read character
*
************************************************************************************************/
unsigned char SCI0_read_char(void){
	if(SCI0SR1_RDRF){
		return SCI0DRL;
	}
	return 0;
}




/********************************* SCI 1 ******************************************************/
/***********************************************************************************************
*
* @brief    Comms_Init - Initialize the serial communications driver
* @param    none
* @return   none
*
************************************************************************************************/
void SCI1_init(unsigned long bus_clk,unsigned int baudrate){
	SCI1BD = bus_clk/baudrate;
	SCI1CR2_TE = 1;				/* Enable Transmitter */
	SCI1CR2_RE = 1;				/* Enable Transmitter */
}

/***********************************************************************************************
*
* @brief    SCI_send_char - send character through SCI1
* @param    character to send
* @return   none
*
************************************************************************************************/
void SCI1_send_char(unsigned char character){
	SCI1DRL = character;
	while(SCI1SR1_TC==0){};
}

/***********************************************************************************************
*
* @brief    SCI_send_array - send array through SCI1
* @param    array to send
* @return   none
*
************************************************************************************************/
void SCI1_send_array(unsigned char array[]){
	int ptr = 0;
	//send string
	while(array[ptr]!='\0'){
		SCI1_send_char(array[ptr]);
		ptr++;
	}
}

/***********************************************************************************************
*
* @brief    SCI_read_char - receive character from SCI1
* @param    none
* @return   read character
*
************************************************************************************************/
unsigned char SCI1_read_char(void){
	if(SCI1SR1_RDRF){
		return SCI1DRL;
	}
	return 0;
}

/***********************************************************************************************
*
* @brief    SCI_read_char - Poll character from SCI0
* @param    none
* @return   read character
*
************************************************************************************************/
unsigned char SCI1_read_char_polling(void){
	unsigned char data_received;
	while(SCI1SR1_RDRF==0){}
	(void)SCI1SR1;						/* Clear Rx Flag */				
	data_received = SCI1DRL;
	return data_received;
	
}
