/*
 * SCI.h
 *
 *  Created on: Jan 14, 2016
 *      Author: B55840
 */


#ifndef SCI_H_
#define SCI_H_

/**********************************************************************************************
* Includes
**********************************************************************************************/
#include "derivative.h"

/**********************************************************************************************
* Macros
**********************************************************************************************/
/* Macro to modity LIN baud rate */
#define BAUD_RATE 19200

#define SCI0 0
#define SCI1 1


/**********************************************************************************************
* Public Functions
**********************************************************************************************/
/**********************************************************************************************
* SCI0
**********************************************************************************************/

/***********************************************************************************************
*
* @brief    Comms_Init - Initialize the serial communications driver
* @param    none
* @return   none
*
************************************************************************************************/
void SCI0_init(unsigned long bus_clk,unsigned int baudrate);

/***********************************************************************************************
*
* @brief    SCI_send_break - Send break character
* @param    none
* @return   none
*
************************************************************************************************/
void SCI0_send_break(void);

/***********************************************************************************************
*
* @brief    SCI_send_char - send character through SCI0
* @param    character to send
* @return   none
*
************************************************************************************************/
void SCI0_send_char(unsigned char character);

/***********************************************************************************************
*
* @brief    SCI_send_array - send array through SCI0
* @param    array to send
* @return   none
*
************************************************************************************************/
void SCI0_send_array(unsigned char array[]);

/***********************************************************************************************
*
* @brief    SCI_read_char - receive character from SCI0
* @param    none
* @return   read character
*
************************************************************************************************/
unsigned char SCI0_read_char(void);


/**********************************************************************************************
* SCI1
**********************************************************************************************/
/***********************************************************************************************
*
* @brief    Comms_Init - Initialize the serial communications driver
* @param    none
* @return   none
*
************************************************************************************************/
void SCI1_init(unsigned long bus_clk,unsigned int baudrate);

/***********************************************************************************************
*
* @brief    SCI_send_char - send character through SCI1
* @param    character to send
* @return   none
*
************************************************************************************************/
void SCI1_send_char(unsigned char character);

/***********************************************************************************************
*
* @brief    SCI_send_array - send array through SCI1
* @param    array to send
* @return   none
*
************************************************************************************************/
void SCI1_send_array(unsigned char array[]);

/***********************************************************************************************
*
* @brief    SCI_read_char - receive character from SCI1
* @param    none
* @return   read character
*
************************************************************************************************/
unsigned char SCI1_read_char(void);

/***********************************************************************************************
*
* @brief    SCI_read_char - Poll character from SCI0
* @param    none
* @return   read character
*
************************************************************************************************/
unsigned char SCI1_read_char_polling(void);

#endif /* SCI_H_ */
