/*
 * Copyright (c) 2015, Freescale Semiconductor, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * o Redistributions of source code must retain the above copyright notice, this list
 *   of conditions and the following disclaimer.
 *
 * o Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * o Neither the name of Freescale Semiconductor, Inc. nor the names of its
 *   contributors may be used to endorse or promote products derived from this
 *   software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */


#include <hidef.h> /* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */
#include "Clock.h"
#include "SCI0.h"
#include "LIN.h"


unsigned char bootloader_data[37];
unsigned char data[8];
unsigned char data_received=0;
unsigned char phrase_lenght;

void main(void) {
	unsigned char dataCounter,phraseCounter;
	CPMUVREGCTL_VREG5VEN = 1;	 /* 5v regulator */
	Clock_init(CLK_32_MHZ);
	SCI1_init(32000000,19200); /* SCI1 is linked to PC communication */
	MODRR0_SCI1RR = 1; /* TX ROUTED TO PT5 (white)/ RX ROUTED TO PT4(green) */
	LIN_init();
	SCI0_init(32000000,BAUD_RATE); /* SCI0 is linked to the LIN phy */
	EnableInterrupts;
	/* include your code here */

	for(;;) {
		__RESET_WATCHDOG();	/* feeds the dog */
		data_received = SCI1_read_char();
		if(data_received != 0x00){
			bootloader_data[0] = data_received; /* length of the phrase to be send by the PC */

			for(dataCounter=1;dataCounter<=bootloader_data[0];dataCounter++){
				bootloader_data[dataCounter] = SCI1_read_char_polling();
			}
			phrase_lenght = bootloader_data[0]+1; /* counting the phrase length as data received too */
			phraseCounter = 0;
			while(phrase_lenght>0){
				if(phrase_lenght >= 8){
					for(dataCounter=0;dataCounter<8;dataCounter++){
						data[dataCounter] = bootloader_data[phraseCounter+dataCounter]; 
					}
					LIN_send_data(0x31,8,data);
					delay_us(10000);
					phrase_lenght -= 8;
					phraseCounter+=8;	/* data is send by groups of 8 bytes */
				}
				else{ /* if less than 8 bytes are left to send */
					for(dataCounter=0;dataCounter<phrase_lenght;dataCounter++){
						data[dataCounter] = bootloader_data[phraseCounter+dataCounter]; 
					}
					LIN_send_data(0x31,phrase_lenght,data);
					phrase_lenght = 0;
				}
			}
			/* ack routine */
			data_received = LIN_read_char(0x32);	/* wait for slave to send ack */
			if(data_received==0x41){ 	/*ack received from slave */
				SCI1_send_char(0x41); /* send ok to computer*/
			}
		}
	} /* loop forever */
	/* please make sure that you never leave main */

}
