/*
 * CPMU.c
 *
 *  Created on: Mar 11, 2013
 *      Author: B34981
 */

/**********************************************************************************************
* Includes
**********************************************************************************************/
#include "CPMU.h"

/**********************************************************************************************
* External objects
**********************************************************************************************/


/**********************************************************************************************
* Global variables
**********************************************************************************************/


/**********************************************************************************************
* Constants and macros
**********************************************************************************************/


/**********************************************************************************************
* Local types
**********************************************************************************************/


/**********************************************************************************************
* Local function prototypes
*********************************************************************************************/


/**********************************************************************************************
* Local variables
**********************************************************************************************/


/**********************************************************************************************
* Local functions
**********************************************************************************************/


/**********************************************************************************************
* Global functions
**********************************************************************************************/

/***********************************************************************************************
*
* @brief    PLL_Init - Configures BusClock to 32 MHz
* @param    none
* @return   none
*
************************************************************************************************/  
void PLL_Init(void)
{		
//	CPMUCLKS_PLLSEL = 0x1;				// FBUS = FPLL/2.   FBUS = 32MHz, 			
//	
//#if OSCILLATOR_FREQUENCY == 4
//	CPMUREFDIV_REFDIV = 0x0;		    // FREF = FOSC/(REFDIV+1) = 4/(0+1) = 4MHZ
//#elif OSCILLATOR_FREQUENCY == 8
//	CPMUREFDIV_REFDIV = 0x1;		    // FREF = FOSC/(REFDIV+1) = 8/(1+1) = 4MHZ
//#elif OSCILLATOR_FREQUENCY == 12
//	CPMUREFDIV_REFDIV = 0x2;		    // FREF = FOSC/(REFDIV+1) = 12/(2+1) = 4MHZ
//#elif OSCILLATOR_FREQUENCY == 16
//	CPMUREFDIV_REFDIV = 0x3;		    // FREF = FOSC/(REFDIV+1) = 16/(3+1) = 4MHZ
//#else
//	#error Non-Supported Oscillator Frequency Selected
//#endif
//	
//	CPMUREFDIV_REFFRQ = 0x1;			// Reference clock between 2MHZ and 6MHZ.	
//	CPMUSYNR_SYNDIV = 7;				// FVCO = 2xFREFx(SYNDIV+1)   =   FVCO = 2x4x(7+1) = 64MHZ	
//	CPMUSYNR_VCOFRQ = 0x1;             	// FVCO is between 48MHZ and 80MHZ	
//	CPMUPOSTDIV_POSTDIV = 0x0;			// FPLL = FVCO/(POSTDIV+1).  FPLL = 64MHZ/(0+1)    FPLL = 64MHz	
//	CPMUOSC_OSCE = 0x1;					// External oscillator enable. FREF = FOSC/(REFDIV+1)	
//	
//	while(!CPMUIFLG_LOCK){}				// Wait for LOCK.      	
//		
//	CPMUIFLG = 0xFF;					// Clear CPMU flags    
	
	/* Wait for stable supply after power up */
	//while (GDUF_GLVLSF)
		//GDUF_GLVLSF = 1;

	CPMUOSC_OSCE = 0;				/* Disable external oscillator */
	
	//CPMUREFDIV_REFDIV = 3;
	CPMUREFDIV_REFFRQ = 0;
	CPMUSYNR_SYNDIV = 31;
	CPMUSYNR_VCOFRQ = 1;
	CPMUPOSTDIV_POSTDIV = 0;
	
	
	//CPMUREFDIV_REFDIV = 3;
	
	while(CPMUIFLG_LOCK==0){}
	
	
	
	
	
	CPMURFLG  = 0x60; 				/* Clear PORF and LVRF */
	
}

/***********************************************************************************************
*
* @brief    RTI_Init - Configure RTI to execute each 100 ms
* @param    none
* @return   none
*
************************************************************************************************/  
void RTI_Init(void){
	CPMUCLKS_RTIOSCSEL = 0x0;          // RTI clock source is IRCCLK (1 MHz).
	CPMURTI_RTDEC = 0x1;               // Decimal based divider value
	CPMURTI_RTR = 0x60;                // RTI Interrupt each 100x10^3 counts
}


/***********************************************************************************************
*
* @brief    RTI_Disable - Stop the RTI timer
* @param    none
* @return   none
*
************************************************************************************************/  
void RTI_Disable(void)
{
	CPMURTI = 0x00;                // RTI Disable
}



/***********************************************************************************************
*
* @brief    RTI_CheckTimer - Check the timer interrupt flag measuring 100 ms
* @param    none
* @return   none
*
************************************************************************************************/ 
UINT8 RTI_CheckTimer(void)
{
	if(CPMUIFLG_RTIF)					// If the 100 ms interrupt is set
	{
		CPMUIFLG_RTIF = 1;				// Clear flag 
		return 1;
	}	
	else
	{
		return 0;
	}
}
