/*
 * Clock.c
 *
 *  Created on: Jan 14, 2016
 *      Author: B55840
 */

#include "Clock.h"



/**	Initializes the Bus Clock to the desire frequency using internal ocillator
 * 
 * 	This function initializes the bus clock to the desired frequency using the internal clock as reference 
 * 	the function output bus frequencies is limited to the ones specified in the header file. Any other value
 *  will have an output frequency of 24 MHz
 * 	
 *	@param bus_clk			Desired bus clock
 *	 
 * */

void Clock_init(unsigned char bus_clk){

	CPMUOSC_OSCE = 0;				/* Disable external oscillator */

	if(bus_clk==CLK_8_MHZ){
		//CPMUREFDIV_REFDIV = 3;
		CPMUREFDIV_REFFRQ = 0;
		CPMUSYNR_SYNDIV = 15;
		CPMUSYNR_VCOFRQ = 1;
		CPMUPOSTDIV_POSTDIV = 1;
	}
	else if(bus_clk == CLK_12_5_MHZ){
		CPMUREFDIV_REFDIV = 3;
		CPMUREFDIV_REFFRQ = 0;
		CPMUSYNR_SYNDIV = 24;
		CPMUSYNR_VCOFRQ = 1;
		CPMUPOSTDIV_POSTDIV = 1;
	}
	else if(bus_clk == CLK_24_MHZ){
		//CPMUREFDIV_REFDIV = 3;
		CPMUREFDIV_REFFRQ = 0;
		CPMUSYNR_SYNDIV = 47;
		CPMUSYNR_VCOFRQ = 1;
		CPMUPOSTDIV_POSTDIV = 1;
	}
	else{
		//CPMUREFDIV_REFDIV = 3;
		CPMUREFDIV_REFFRQ = 0;
		CPMUSYNR_SYNDIV = 31;
		CPMUSYNR_VCOFRQ = 1;
		CPMUPOSTDIV_POSTDIV = 0;
	}
	
	while(CPMUIFLG_LOCK==0){}
	
	CPMURFLG  = 0x60; 				/* Clear PORF and LVRF */
}



